# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFrameworkResult',
    'AwaitableGetFrameworkResult',
    'get_framework',
    'get_framework_output',
]

@pulumi.output_type
class GetFrameworkResult:
    def __init__(__self__, creation_time=None, deployment_status=None, framework_arn=None, framework_controls=None, framework_description=None, framework_status=None, framework_tags=None):
        if creation_time and not isinstance(creation_time, float):
            raise TypeError("Expected argument 'creation_time' to be a float")
        pulumi.set(__self__, "creation_time", creation_time)
        if deployment_status and not isinstance(deployment_status, str):
            raise TypeError("Expected argument 'deployment_status' to be a str")
        pulumi.set(__self__, "deployment_status", deployment_status)
        if framework_arn and not isinstance(framework_arn, str):
            raise TypeError("Expected argument 'framework_arn' to be a str")
        pulumi.set(__self__, "framework_arn", framework_arn)
        if framework_controls and not isinstance(framework_controls, list):
            raise TypeError("Expected argument 'framework_controls' to be a list")
        pulumi.set(__self__, "framework_controls", framework_controls)
        if framework_description and not isinstance(framework_description, str):
            raise TypeError("Expected argument 'framework_description' to be a str")
        pulumi.set(__self__, "framework_description", framework_description)
        if framework_status and not isinstance(framework_status, str):
            raise TypeError("Expected argument 'framework_status' to be a str")
        pulumi.set(__self__, "framework_status", framework_status)
        if framework_tags and not isinstance(framework_tags, list):
            raise TypeError("Expected argument 'framework_tags' to be a list")
        pulumi.set(__self__, "framework_tags", framework_tags)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[float]:
        """
        The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deploymentStatus")
    def deployment_status(self) -> Optional[str]:
        """
        The deployment status of a framework. The statuses are: `CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED`
        """
        return pulumi.get(self, "deployment_status")

    @property
    @pulumi.getter(name="frameworkArn")
    def framework_arn(self) -> Optional[str]:
        """
        An Amazon Resource Name (ARN) that uniquely identifies Framework as a resource
        """
        return pulumi.get(self, "framework_arn")

    @property
    @pulumi.getter(name="frameworkControls")
    def framework_controls(self) -> Optional[Sequence['outputs.FrameworkControl']]:
        """
        Contains detailed information about all of the controls of a framework. Each framework must contain at least one control.
        """
        return pulumi.get(self, "framework_controls")

    @property
    @pulumi.getter(name="frameworkDescription")
    def framework_description(self) -> Optional[str]:
        """
        An optional description of the framework with a maximum 1,024 characters.
        """
        return pulumi.get(self, "framework_description")

    @property
    @pulumi.getter(name="frameworkStatus")
    def framework_status(self) -> Optional[str]:
        """
        A framework consists of one or more controls. Each control governs a resource, such as backup plans, backup selections, backup vaults, or recovery points. You can also turn AWS Config recording on or off for each resource. The statuses are:

        `ACTIVE` when recording is turned on for all resources governed by the framework.

        `PARTIALLY_ACTIVE` when recording is turned off for at least one resource governed by the framework.

        `INACTIVE` when recording is turned off for all resources governed by the framework.

        `UNAVAILABLE` when AWS Backup is unable to validate recording status at this time.
        """
        return pulumi.get(self, "framework_status")

    @property
    @pulumi.getter(name="frameworkTags")
    def framework_tags(self) -> Optional[Sequence['outputs.FrameworkTag']]:
        """
        Metadata that you can assign to help organize the frameworks that you create. Each tag is a key-value pair.
        """
        return pulumi.get(self, "framework_tags")


class AwaitableGetFrameworkResult(GetFrameworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFrameworkResult(
            creation_time=self.creation_time,
            deployment_status=self.deployment_status,
            framework_arn=self.framework_arn,
            framework_controls=self.framework_controls,
            framework_description=self.framework_description,
            framework_status=self.framework_status,
            framework_tags=self.framework_tags)


def get_framework(framework_arn: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFrameworkResult:
    """
    Contains detailed information about a framework. Frameworks contain controls, which evaluate and report on your backup events and resources. Frameworks generate daily compliance results.


    :param str framework_arn: An Amazon Resource Name (ARN) that uniquely identifies Framework as a resource
    """
    __args__ = dict()
    __args__['frameworkArn'] = framework_arn
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:backup:getFramework', __args__, opts=opts, typ=GetFrameworkResult).value

    return AwaitableGetFrameworkResult(
        creation_time=__ret__.creation_time,
        deployment_status=__ret__.deployment_status,
        framework_arn=__ret__.framework_arn,
        framework_controls=__ret__.framework_controls,
        framework_description=__ret__.framework_description,
        framework_status=__ret__.framework_status,
        framework_tags=__ret__.framework_tags)


@_utilities.lift_output_func(get_framework)
def get_framework_output(framework_arn: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFrameworkResult]:
    """
    Contains detailed information about a framework. Frameworks contain controls, which evaluate and report on your backup events and resources. Frameworks generate daily compliance results.


    :param str framework_arn: An Amazon Resource Name (ARN) that uniquely identifies Framework as a resource
    """
    ...
