# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetStageResult',
    'AwaitableGetStageResult',
    'get_stage',
    'get_stage_output',
]

@pulumi.output_type
class GetStageResult:
    def __init__(__self__, access_log_setting=None, cache_cluster_enabled=None, cache_cluster_size=None, canary_setting=None, client_certificate_id=None, deployment_id=None, description=None, documentation_version=None, method_settings=None, tags=None, tracing_enabled=None, variables=None):
        if access_log_setting and not isinstance(access_log_setting, dict):
            raise TypeError("Expected argument 'access_log_setting' to be a dict")
        pulumi.set(__self__, "access_log_setting", access_log_setting)
        if cache_cluster_enabled and not isinstance(cache_cluster_enabled, bool):
            raise TypeError("Expected argument 'cache_cluster_enabled' to be a bool")
        pulumi.set(__self__, "cache_cluster_enabled", cache_cluster_enabled)
        if cache_cluster_size and not isinstance(cache_cluster_size, str):
            raise TypeError("Expected argument 'cache_cluster_size' to be a str")
        pulumi.set(__self__, "cache_cluster_size", cache_cluster_size)
        if canary_setting and not isinstance(canary_setting, dict):
            raise TypeError("Expected argument 'canary_setting' to be a dict")
        pulumi.set(__self__, "canary_setting", canary_setting)
        if client_certificate_id and not isinstance(client_certificate_id, str):
            raise TypeError("Expected argument 'client_certificate_id' to be a str")
        pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if documentation_version and not isinstance(documentation_version, str):
            raise TypeError("Expected argument 'documentation_version' to be a str")
        pulumi.set(__self__, "documentation_version", documentation_version)
        if method_settings and not isinstance(method_settings, list):
            raise TypeError("Expected argument 'method_settings' to be a list")
        pulumi.set(__self__, "method_settings", method_settings)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tracing_enabled and not isinstance(tracing_enabled, bool):
            raise TypeError("Expected argument 'tracing_enabled' to be a bool")
        pulumi.set(__self__, "tracing_enabled", tracing_enabled)
        if variables and not isinstance(variables, dict):
            raise TypeError("Expected argument 'variables' to be a dict")
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="accessLogSetting")
    def access_log_setting(self) -> Optional['outputs.StageAccessLogSetting']:
        """
        Specifies settings for logging access in this stage.
        """
        return pulumi.get(self, "access_log_setting")

    @property
    @pulumi.getter(name="cacheClusterEnabled")
    def cache_cluster_enabled(self) -> Optional[bool]:
        """
        Indicates whether cache clustering is enabled for the stage.
        """
        return pulumi.get(self, "cache_cluster_enabled")

    @property
    @pulumi.getter(name="cacheClusterSize")
    def cache_cluster_size(self) -> Optional[str]:
        """
        The stage's cache cluster size.
        """
        return pulumi.get(self, "cache_cluster_size")

    @property
    @pulumi.getter(name="canarySetting")
    def canary_setting(self) -> Optional['outputs.StageCanarySetting']:
        """
        Specifies settings for the canary deployment in this stage.
        """
        return pulumi.get(self, "canary_setting")

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[str]:
        """
        The ID of the client certificate that API Gateway uses to call your integration endpoints in the stage. 
        """
        return pulumi.get(self, "client_certificate_id")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[str]:
        """
        The ID of the deployment that the stage is associated with. This parameter is required to create a stage. 
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the stage.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="documentationVersion")
    def documentation_version(self) -> Optional[str]:
        """
        The version ID of the API documentation snapshot.
        """
        return pulumi.get(self, "documentation_version")

    @property
    @pulumi.getter(name="methodSettings")
    def method_settings(self) -> Optional[Sequence['outputs.StageMethodSetting']]:
        """
        Settings for all methods in the stage.
        """
        return pulumi.get(self, "method_settings")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.StageTag']]:
        """
        An array of arbitrary tags (key-value pairs) to associate with the stage.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tracingEnabled")
    def tracing_enabled(self) -> Optional[bool]:
        """
        Specifies whether active X-Ray tracing is enabled for this stage.
        """
        return pulumi.get(self, "tracing_enabled")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Any]:
        """
        A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value.
        """
        return pulumi.get(self, "variables")


class AwaitableGetStageResult(GetStageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStageResult(
            access_log_setting=self.access_log_setting,
            cache_cluster_enabled=self.cache_cluster_enabled,
            cache_cluster_size=self.cache_cluster_size,
            canary_setting=self.canary_setting,
            client_certificate_id=self.client_certificate_id,
            deployment_id=self.deployment_id,
            description=self.description,
            documentation_version=self.documentation_version,
            method_settings=self.method_settings,
            tags=self.tags,
            tracing_enabled=self.tracing_enabled,
            variables=self.variables)


def get_stage(rest_api_id: Optional[str] = None,
              stage_name: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStageResult:
    """
    Resource Type definition for AWS::ApiGateway::Stage


    :param str rest_api_id: The ID of the RestApi resource that you're deploying with this stage.
    :param str stage_name: The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
    """
    __args__ = dict()
    __args__['restApiId'] = rest_api_id
    __args__['stageName'] = stage_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:apigateway:getStage', __args__, opts=opts, typ=GetStageResult).value

    return AwaitableGetStageResult(
        access_log_setting=__ret__.access_log_setting,
        cache_cluster_enabled=__ret__.cache_cluster_enabled,
        cache_cluster_size=__ret__.cache_cluster_size,
        canary_setting=__ret__.canary_setting,
        client_certificate_id=__ret__.client_certificate_id,
        deployment_id=__ret__.deployment_id,
        description=__ret__.description,
        documentation_version=__ret__.documentation_version,
        method_settings=__ret__.method_settings,
        tags=__ret__.tags,
        tracing_enabled=__ret__.tracing_enabled,
        variables=__ret__.variables)


@_utilities.lift_output_func(get_stage)
def get_stage_output(rest_api_id: Optional[pulumi.Input[str]] = None,
                     stage_name: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStageResult]:
    """
    Resource Type definition for AWS::ApiGateway::Stage


    :param str rest_api_id: The ID of the RestApi resource that you're deploying with this stage.
    :param str stage_name: The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
    """
    ...
