# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['GroupVersionInitArgs', 'GroupVersion']

@pulumi.input_type
class GroupVersionInitArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[str],
                 connector_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 core_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 device_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 function_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 logger_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 resource_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 subscription_definition_version_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GroupVersion resource.
        """
        pulumi.set(__self__, "group_id", group_id)
        if connector_definition_version_arn is not None:
            pulumi.set(__self__, "connector_definition_version_arn", connector_definition_version_arn)
        if core_definition_version_arn is not None:
            pulumi.set(__self__, "core_definition_version_arn", core_definition_version_arn)
        if device_definition_version_arn is not None:
            pulumi.set(__self__, "device_definition_version_arn", device_definition_version_arn)
        if function_definition_version_arn is not None:
            pulumi.set(__self__, "function_definition_version_arn", function_definition_version_arn)
        if logger_definition_version_arn is not None:
            pulumi.set(__self__, "logger_definition_version_arn", logger_definition_version_arn)
        if resource_definition_version_arn is not None:
            pulumi.set(__self__, "resource_definition_version_arn", resource_definition_version_arn)
        if subscription_definition_version_arn is not None:
            pulumi.set(__self__, "subscription_definition_version_arn", subscription_definition_version_arn)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="connectorDefinitionVersionArn")
    def connector_definition_version_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "connector_definition_version_arn")

    @connector_definition_version_arn.setter
    def connector_definition_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_definition_version_arn", value)

    @property
    @pulumi.getter(name="coreDefinitionVersionArn")
    def core_definition_version_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "core_definition_version_arn")

    @core_definition_version_arn.setter
    def core_definition_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "core_definition_version_arn", value)

    @property
    @pulumi.getter(name="deviceDefinitionVersionArn")
    def device_definition_version_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "device_definition_version_arn")

    @device_definition_version_arn.setter
    def device_definition_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_definition_version_arn", value)

    @property
    @pulumi.getter(name="functionDefinitionVersionArn")
    def function_definition_version_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "function_definition_version_arn")

    @function_definition_version_arn.setter
    def function_definition_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_definition_version_arn", value)

    @property
    @pulumi.getter(name="loggerDefinitionVersionArn")
    def logger_definition_version_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "logger_definition_version_arn")

    @logger_definition_version_arn.setter
    def logger_definition_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logger_definition_version_arn", value)

    @property
    @pulumi.getter(name="resourceDefinitionVersionArn")
    def resource_definition_version_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_definition_version_arn")

    @resource_definition_version_arn.setter
    def resource_definition_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_definition_version_arn", value)

    @property
    @pulumi.getter(name="subscriptionDefinitionVersionArn")
    def subscription_definition_version_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subscription_definition_version_arn")

    @subscription_definition_version_arn.setter
    def subscription_definition_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_definition_version_arn", value)


warnings.warn("""GroupVersion is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class GroupVersion(pulumi.CustomResource):
    warnings.warn("""GroupVersion is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 core_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 device_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 function_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 logger_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 resource_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 subscription_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Greengrass::GroupVersion

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupVersionInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Greengrass::GroupVersion

        :param str resource_name: The name of the resource.
        :param GroupVersionInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupVersionInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 core_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 device_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 function_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 logger_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 resource_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 subscription_definition_version_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""GroupVersion is deprecated: GroupVersion is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupVersionInitArgs.__new__(GroupVersionInitArgs)

            __props__.__dict__["connector_definition_version_arn"] = connector_definition_version_arn
            __props__.__dict__["core_definition_version_arn"] = core_definition_version_arn
            __props__.__dict__["device_definition_version_arn"] = device_definition_version_arn
            __props__.__dict__["function_definition_version_arn"] = function_definition_version_arn
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["logger_definition_version_arn"] = logger_definition_version_arn
            __props__.__dict__["resource_definition_version_arn"] = resource_definition_version_arn
            __props__.__dict__["subscription_definition_version_arn"] = subscription_definition_version_arn
        super(GroupVersion, __self__).__init__(
            'aws-native:greengrass:GroupVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'GroupVersion':
        """
        Get an existing GroupVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = GroupVersionInitArgs.__new__(GroupVersionInitArgs)

        __props__.__dict__["connector_definition_version_arn"] = None
        __props__.__dict__["core_definition_version_arn"] = None
        __props__.__dict__["device_definition_version_arn"] = None
        __props__.__dict__["function_definition_version_arn"] = None
        __props__.__dict__["group_id"] = None
        __props__.__dict__["logger_definition_version_arn"] = None
        __props__.__dict__["resource_definition_version_arn"] = None
        __props__.__dict__["subscription_definition_version_arn"] = None
        return GroupVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectorDefinitionVersionArn")
    def connector_definition_version_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "connector_definition_version_arn")

    @property
    @pulumi.getter(name="coreDefinitionVersionArn")
    def core_definition_version_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "core_definition_version_arn")

    @property
    @pulumi.getter(name="deviceDefinitionVersionArn")
    def device_definition_version_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "device_definition_version_arn")

    @property
    @pulumi.getter(name="functionDefinitionVersionArn")
    def function_definition_version_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "function_definition_version_arn")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="loggerDefinitionVersionArn")
    def logger_definition_version_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "logger_definition_version_arn")

    @property
    @pulumi.getter(name="resourceDefinitionVersionArn")
    def resource_definition_version_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "resource_definition_version_arn")

    @property
    @pulumi.getter(name="subscriptionDefinitionVersionArn")
    def subscription_definition_version_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "subscription_definition_version_arn")

