// Generated by delombok at Mon Jul 29 09:41:39 CEST 2019
/*
 * Copyright 2019 Amazon.com, Inc. or its affiliates.
 * Licensed under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package software.amazon.kinesis.multilang.config;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import software.amazon.kinesis.checkpoint.CheckpointConfig;
import software.amazon.kinesis.common.ConfigsBuilder;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.KinesisClientUtil;
import software.amazon.kinesis.coordinator.CoordinatorConfig;
import software.amazon.kinesis.coordinator.Scheduler;
import software.amazon.kinesis.leases.LeaseManagementConfig;
import software.amazon.kinesis.leases.ShardPrioritization;
import software.amazon.kinesis.lifecycle.LifecycleConfig;
import software.amazon.kinesis.metrics.MetricsConfig;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.multilang.config.credentials.V2CredentialWrapper;
import software.amazon.kinesis.processor.ProcessorConfig;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;
import software.amazon.kinesis.retrieval.RetrievalConfig;
import software.amazon.kinesis.retrieval.polling.PollingConfig;

public class MultiLangDaemonConfiguration {
    @java.lang.SuppressWarnings("all")
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(MultiLangDaemonConfiguration.class);
    private static final String CREDENTIALS_DEFAULT_SEARCH_PATH = "software.amazon.awssdk.auth.credentials";
    private String applicationName;
    private String streamName;
    @ConfigurationSettable(configurationClass = ConfigsBuilder.class)
    private String tableName;
    private String workerIdentifier = UUID.randomUUID().toString();

    public void setWorkerId(String workerId) {
        this.workerIdentifier = workerId;
    }

    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private long failoverTimeMillis;
    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private long shardSyncIntervalMillis;
    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private boolean cleanupLeasesUponShardCompletion;
    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private boolean ignoreUnexpectedChildShards;
    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private int maxLeasesForWorker;
    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private int maxLeasesToStealAtOneTime;
    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private int initialLeaseTableReadCapacity;
    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private int initialLeaseTableWriteCapacity;
    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class, methodName = "initialPositionInStream")
    @ConfigurationSettable(configurationClass = RetrievalConfig.class)
    private InitialPositionInStreamExtended initialPositionInStreamExtended;

    public InitialPositionInStream getInitialPositionInStream() {
        if (initialPositionInStreamExtended != null) {
            return initialPositionInStreamExtended.getInitialPositionInStream();
        }
        return null;
    }

    public void setInitialPositionInStream(InitialPositionInStream initialPositionInStream) {
        this.initialPositionInStreamExtended = InitialPositionInStreamExtended.newInitialPosition(initialPositionInStream);
    }

    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private int maxLeaseRenewalThreads;
    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private long listShardsBackoffTimeInMillis;
    @ConfigurationSettable(configurationClass = LeaseManagementConfig.class)
    private int maxListShardsRetryAttempts;
    // Enables applications flush/checkpoint (if they have some data "in progress", but don't get new data for while)
    @ConfigurationSettable(configurationClass = ProcessorConfig.class)
    private boolean callProcessRecordsEvenForEmptyRecordList;
    @ConfigurationSettable(configurationClass = CoordinatorConfig.class)
    private long parentShardPollIntervalMillis;
    @ConfigurationSettable(configurationClass = CoordinatorConfig.class)
    private ShardPrioritization shardPrioritization;
    @ConfigurationSettable(configurationClass = CoordinatorConfig.class)
    private boolean skipShardSyncAtWorkerInitializationIfLeasesExist;
    @ConfigurationSettable(configurationClass = LifecycleConfig.class)
    private long taskBackoffTimeMillis;
    @ConfigurationSettable(configurationClass = MetricsConfig.class)
    private long metricsBufferTimeMillis;
    @ConfigurationSettable(configurationClass = MetricsConfig.class)
    private int metricsMaxQueueSize;
    @ConfigurationSettable(configurationClass = MetricsConfig.class)
    private MetricsLevel metricsLevel;
    @ConfigurationSettable(configurationClass = LifecycleConfig.class, convertToOptional = true)
    private Long logWarningForTaskAfterMillis;
    @ConfigurationSettable(configurationClass = MetricsConfig.class)
    private Set<String> metricsEnabledDimensions;

    public String[] getMetricsEnabledDimensions() {
        return metricsEnabledDimensions.toArray(new String[0]);
    }

    public void setMetricsEnabledDimensions(String[] dimensions) {
        metricsEnabledDimensions = new HashSet<>(Arrays.asList(dimensions));
    }

    private RetrievalMode retrievalMode = RetrievalMode.DEFAULT;
    private final FanoutConfigBean fanoutConfig = new FanoutConfigBean();
    private final PollingConfigBean pollingConfig = new PollingConfigBean();
    private boolean validateSequenceNumberBeforeCheckpointing;
    private long shutdownGraceMillis;
    private Integer timeoutInSeconds;
    private final BuilderDynaBean kinesisCredentialsProvider;

    public void setAWSCredentialsProvider(String providerString) {
        kinesisCredentialsProvider.set("", providerString);
    }

    private final BuilderDynaBean dynamoDBCredentialsProvider;

    public void setAWSCredentialsProviderDynamoDB(String providerString) {
        dynamoDBCredentialsProvider.set("", providerString);
    }

    private final BuilderDynaBean cloudWatchCredentialsProvider;

    public void setAWSCredentialsProviderCloudWatch(String providerString) {
        cloudWatchCredentialsProvider.set("", providerString);
    }

    private final BuilderDynaBean kinesisClient;
    private final BuilderDynaBean dynamoDbClient;
    private final BuilderDynaBean cloudWatchClient;
    private final BeanUtilsBean utilsBean;
    private final ConvertUtilsBean convertUtilsBean;

    public MultiLangDaemonConfiguration(BeanUtilsBean utilsBean, ConvertUtilsBean convertUtilsBean) {
        this.utilsBean = utilsBean;
        this.convertUtilsBean = convertUtilsBean;
        convertUtilsBean.register(new Converter() {
            @Override
            public <T> T convert(Class<T> type, Object value) {
                return type.cast(MetricsLevel.valueOf(value.toString().toUpperCase()));
            }
        }, MetricsLevel.class);
        convertUtilsBean.register(new Converter() {
            @Override
            public <T> T convert(Class<T> type, Object value) {
                return type.cast(InitialPositionInStream.valueOf(value.toString().toUpperCase()));
            }
        }, InitialPositionInStream.class);
        convertUtilsBean.register(new Converter() {
            @Override
            public <T> T convert(Class<T> type, Object value) {
                return type.cast(URI.create(value.toString()));
            }
        }, URI.class);
        convertUtilsBean.register(new Converter() {
            @Override
            public <T> T convert(Class<T> type, Object value) {
                return type.cast(RetrievalMode.from(value.toString()));
            }
        }, RetrievalMode.class);
        convertUtilsBean.register(new Converter() {
            @Override
            public <T> T convert(final Class<T> type, final Object value) {
                return type.cast(Region.of(value.toString()));
            }
        }, Region.class);
        ArrayConverter arrayConverter = new ArrayConverter(String[].class, new StringConverter());
        arrayConverter.setDelimiter(',');
        convertUtilsBean.register(arrayConverter, String[].class);
        AWSCredentialsProviderPropertyValueDecoder oldCredentialsDecoder = new AWSCredentialsProviderPropertyValueDecoder();
        Function<String, ?> converter = s -> new V2CredentialWrapper(oldCredentialsDecoder.decodeValue(s));
        this.kinesisCredentialsProvider = new BuilderDynaBean(AwsCredentialsProvider.class, convertUtilsBean, converter, CREDENTIALS_DEFAULT_SEARCH_PATH);
        this.dynamoDBCredentialsProvider = new BuilderDynaBean(AwsCredentialsProvider.class, convertUtilsBean, converter, CREDENTIALS_DEFAULT_SEARCH_PATH);
        this.cloudWatchCredentialsProvider = new BuilderDynaBean(AwsCredentialsProvider.class, convertUtilsBean, converter, CREDENTIALS_DEFAULT_SEARCH_PATH);
        this.kinesisClient = new BuilderDynaBean(KinesisAsyncClient.class, convertUtilsBean);
        this.dynamoDbClient = new BuilderDynaBean(DynamoDbAsyncClient.class, convertUtilsBean);
        this.cloudWatchClient = new BuilderDynaBean(CloudWatchAsyncClient.class, convertUtilsBean);
    }

    private void setRegionForClient(String name, BuilderDynaBean client, Region region) {
        try {
            utilsBean.setProperty(client, "region", region);
        } catch (IllegalAccessException | InvocationTargetException e) {
            // log.error("Failed to set region on {}", name, e);
            throw new IllegalStateException(e);
        }
    }

    public void setRegionName(Region region) {
        setRegionForClient("kinesisClient", kinesisClient, region);
        setRegionForClient("dynamoDbClient", dynamoDbClient, region);
        setRegionForClient("cloudWatchClient", cloudWatchClient, region);
    }

    private void setEndpointForClient(String name, BuilderDynaBean client, String endpoint) {
        try {
            utilsBean.setProperty(client, "endpointOverride", endpoint);
        } catch (IllegalAccessException | InvocationTargetException e) {
            // log.error("Failed to set endpoint on {}", name, e);
            throw new IllegalStateException(e);
        }
    }

    public void setKinesisEndpoint(String endpoint) {
        setEndpointForClient("kinesisClient", kinesisClient, endpoint);
    }

    public void setDynamoDBEndpoint(String endpoint) {
        setEndpointForClient("dynamoDbClient", dynamoDbClient, endpoint);
    }

    private AwsCredentialsProvider resolveCredentials(BuilderDynaBean credsBuilder) {
        if (!credsBuilder.isDirty()) {
            return null;
        }
        return credsBuilder.build(AwsCredentialsProvider.class);
    }

    private void updateCredentials(BuilderDynaBean toUpdate, AwsCredentialsProvider primary, AwsCredentialsProvider secondary) {
        if (toUpdate.hasValue("credentialsProvider")) {
            return;
        }
        try {
            if (primary != null) {
                utilsBean.setProperty(toUpdate, "credentialsProvider", primary);
            } else if (secondary != null) {
                utilsBean.setProperty(toUpdate, "credentialsProvider", secondary);
            }
        } catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Unable to update credentials", e);
        }
    }

    private void addConfigObjects(Map<Class<?>, Object> configObjects, Object... toAdd) {
        for (Object obj : toAdd) {
            configObjects.put(obj.getClass(), obj);
        }
    }

    private void resolveFields(Map<Class<?>, Object> configObjects, Set<Class<?>> restrictTo, Set<Class<?>> skipIf) {
        ConfigurationSettableUtils.resolveFields(this, configObjects, restrictTo, skipIf);
    }

    private void handleRetrievalConfig(RetrievalConfig retrievalConfig, ConfigsBuilder configsBuilder) {
        retrievalConfig.retrievalSpecificConfig(retrievalMode.builder(this).build(configsBuilder.kinesisClient(), this));
    }

    private Object adjustKinesisHttpConfiguration(Object builderObj) {
        System.out.println("!! adjustKinesisHttpConfiguration " + builderObj);
        if (builderObj instanceof KinesisAsyncClientBuilder) {
            KinesisAsyncClientBuilder builder = (KinesisAsyncClientBuilder) builderObj;
            return builder.applyMutation(KinesisClientUtil::adjustKinesisClientBuilder);
        }
        return builderObj;
    }


    static class ResolvedConfiguration {
        final CoordinatorConfig coordinatorConfig;
        final CheckpointConfig checkpointConfig;
        final LeaseManagementConfig leaseManagementConfig;
        final LifecycleConfig lifecycleConfig;
        final MetricsConfig metricsConfig;
        final ProcessorConfig processorConfig;
        final RetrievalConfig retrievalConfig;

        //        public ResolvedConfiguration(CoordinatorConfig coordinatorConfig,
//                CheckpointConfig checkpointConfig,
//                LeaseManagementConfig leaseManagementConfig,
//                LifecycleConfig lifecycleConfig,
//                MetricsConfig metricsConfig,
//                ProcessorConfig processorConfig,
//                RetrievalConfig retrievalConfig) {
//            this.coordinatorConfig = coordinatorConfig;
//            this.checkpointConfig = checkpointConfig;
//            this.leaseManagementConfig = leaseManagementConfig;
//            this.lifecycleConfig = lifecycleConfig;
//            this.metricsConfig = metricsConfig;
//            this.processorConfig = processorConfig;
//            this.retrievalConfig = retrievalConfig;
//        }
        public Scheduler build() {
            return new Scheduler(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig);
        }

        @java.lang.SuppressWarnings("all")
        public ResolvedConfiguration(final CoordinatorConfig coordinatorConfig, final CheckpointConfig checkpointConfig, final LeaseManagementConfig leaseManagementConfig, final LifecycleConfig lifecycleConfig, final MetricsConfig metricsConfig, final ProcessorConfig processorConfig, final RetrievalConfig retrievalConfig) {
            this.coordinatorConfig = coordinatorConfig;
            this.checkpointConfig = checkpointConfig;
            this.leaseManagementConfig = leaseManagementConfig;
            this.lifecycleConfig = lifecycleConfig;
            this.metricsConfig = metricsConfig;
            this.processorConfig = processorConfig;
            this.retrievalConfig = retrievalConfig;
        }

        @java.lang.SuppressWarnings("all")
        public CoordinatorConfig getCoordinatorConfig() {
            return this.coordinatorConfig;
        }

        @java.lang.SuppressWarnings("all")
        public CheckpointConfig getCheckpointConfig() {
            return this.checkpointConfig;
        }

        @java.lang.SuppressWarnings("all")
        public LeaseManagementConfig getLeaseManagementConfig() {
            return this.leaseManagementConfig;
        }

        @java.lang.SuppressWarnings("all")
        public LifecycleConfig getLifecycleConfig() {
            return this.lifecycleConfig;
        }

        @java.lang.SuppressWarnings("all")
        public MetricsConfig getMetricsConfig() {
            return this.metricsConfig;
        }

        @java.lang.SuppressWarnings("all")
        public ProcessorConfig getProcessorConfig() {
            return this.processorConfig;
        }

        @java.lang.SuppressWarnings("all")
        public RetrievalConfig getRetrievalConfig() {
            return this.retrievalConfig;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof MultiLangDaemonConfiguration.ResolvedConfiguration)) return false;
            final MultiLangDaemonConfiguration.ResolvedConfiguration other = (MultiLangDaemonConfiguration.ResolvedConfiguration) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$coordinatorConfig = this.getCoordinatorConfig();
            final java.lang.Object other$coordinatorConfig = other.getCoordinatorConfig();
            if (this$coordinatorConfig == null ? other$coordinatorConfig != null : !this$coordinatorConfig.equals(other$coordinatorConfig)) return false;
            final java.lang.Object this$checkpointConfig = this.getCheckpointConfig();
            final java.lang.Object other$checkpointConfig = other.getCheckpointConfig();
            if (this$checkpointConfig == null ? other$checkpointConfig != null : !this$checkpointConfig.equals(other$checkpointConfig)) return false;
            final java.lang.Object this$leaseManagementConfig = this.getLeaseManagementConfig();
            final java.lang.Object other$leaseManagementConfig = other.getLeaseManagementConfig();
            if (this$leaseManagementConfig == null ? other$leaseManagementConfig != null : !this$leaseManagementConfig.equals(other$leaseManagementConfig)) return false;
            final java.lang.Object this$lifecycleConfig = this.getLifecycleConfig();
            final java.lang.Object other$lifecycleConfig = other.getLifecycleConfig();
            if (this$lifecycleConfig == null ? other$lifecycleConfig != null : !this$lifecycleConfig.equals(other$lifecycleConfig)) return false;
            final java.lang.Object this$metricsConfig = this.getMetricsConfig();
            final java.lang.Object other$metricsConfig = other.getMetricsConfig();
            if (this$metricsConfig == null ? other$metricsConfig != null : !this$metricsConfig.equals(other$metricsConfig)) return false;
            final java.lang.Object this$processorConfig = this.getProcessorConfig();
            final java.lang.Object other$processorConfig = other.getProcessorConfig();
            if (this$processorConfig == null ? other$processorConfig != null : !this$processorConfig.equals(other$processorConfig)) return false;
            final java.lang.Object this$retrievalConfig = this.getRetrievalConfig();
            final java.lang.Object other$retrievalConfig = other.getRetrievalConfig();
            if (this$retrievalConfig == null ? other$retrievalConfig != null : !this$retrievalConfig.equals(other$retrievalConfig)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof MultiLangDaemonConfiguration.ResolvedConfiguration;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $coordinatorConfig = this.getCoordinatorConfig();
            result = result * PRIME + ($coordinatorConfig == null ? 43 : $coordinatorConfig.hashCode());
            final java.lang.Object $checkpointConfig = this.getCheckpointConfig();
            result = result * PRIME + ($checkpointConfig == null ? 43 : $checkpointConfig.hashCode());
            final java.lang.Object $leaseManagementConfig = this.getLeaseManagementConfig();
            result = result * PRIME + ($leaseManagementConfig == null ? 43 : $leaseManagementConfig.hashCode());
            final java.lang.Object $lifecycleConfig = this.getLifecycleConfig();
            result = result * PRIME + ($lifecycleConfig == null ? 43 : $lifecycleConfig.hashCode());
            final java.lang.Object $metricsConfig = this.getMetricsConfig();
            result = result * PRIME + ($metricsConfig == null ? 43 : $metricsConfig.hashCode());
            final java.lang.Object $processorConfig = this.getProcessorConfig();
            result = result * PRIME + ($processorConfig == null ? 43 : $processorConfig.hashCode());
            final java.lang.Object $retrievalConfig = this.getRetrievalConfig();
            result = result * PRIME + ($retrievalConfig == null ? 43 : $retrievalConfig.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "MultiLangDaemonConfiguration.ResolvedConfiguration(coordinatorConfig=" + this.getCoordinatorConfig() + ", checkpointConfig=" + this.getCheckpointConfig() + ", leaseManagementConfig=" + this.getLeaseManagementConfig() + ", lifecycleConfig=" + this.getLifecycleConfig() + ", metricsConfig=" + this.getMetricsConfig() + ", processorConfig=" + this.getProcessorConfig() + ", retrievalConfig=" + this.getRetrievalConfig() + ")";
        }
    }

    ResolvedConfiguration resolvedConfiguration(ShardRecordProcessorFactory shardRecordProcessorFactory) {
        AwsCredentialsProvider kinesisCreds = resolveCredentials(kinesisCredentialsProvider);
        AwsCredentialsProvider dynamoDbCreds = resolveCredentials(dynamoDBCredentialsProvider);
        AwsCredentialsProvider cloudwatchCreds = resolveCredentials(cloudWatchCredentialsProvider);
        updateCredentials(kinesisClient, kinesisCreds, kinesisCreds);
        updateCredentials(dynamoDbClient, dynamoDbCreds, kinesisCreds);
        updateCredentials(cloudWatchClient, cloudwatchCreds, kinesisCreds);
        System.out.println("!!!123 " + kinesisClient);
        KinesisAsyncClient kinesisAsyncClient = kinesisClient.build(KinesisAsyncClient.class, this::adjustKinesisHttpConfiguration);
        System.out.println("!!!456 " + kinesisAsyncClient);
        DynamoDbAsyncClient dynamoDbAsyncClient = dynamoDbClient.build(DynamoDbAsyncClient.class);
        CloudWatchAsyncClient cloudWatchAsyncClient = cloudWatchClient.build(CloudWatchAsyncClient.class);
        ConfigsBuilder configsBuilder = new ConfigsBuilder(streamName, applicationName, kinesisAsyncClient, dynamoDbAsyncClient, cloudWatchAsyncClient, workerIdentifier, shardRecordProcessorFactory);
        Map<Class<?>, Object> configObjects = new HashMap<>();
        addConfigObjects(configObjects, configsBuilder);
        resolveFields(configObjects, Collections.singleton(ConfigsBuilder.class), Collections.singleton(PollingConfig.class));
        CoordinatorConfig coordinatorConfig = configsBuilder.coordinatorConfig();
        CheckpointConfig checkpointConfig = configsBuilder.checkpointConfig();
        LeaseManagementConfig leaseManagementConfig = configsBuilder.leaseManagementConfig();
        LifecycleConfig lifecycleConfig = configsBuilder.lifecycleConfig();
        MetricsConfig metricsConfig = configsBuilder.metricsConfig();
        ProcessorConfig processorConfig = configsBuilder.processorConfig();
        RetrievalConfig retrievalConfig = configsBuilder.retrievalConfig();
        addConfigObjects(configObjects, coordinatorConfig, checkpointConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig);
        handleRetrievalConfig(retrievalConfig, configsBuilder);
        resolveFields(configObjects, null, new HashSet<>(Arrays.asList(ConfigsBuilder.class, PollingConfig.class)));
        return new ResolvedConfiguration(coordinatorConfig, checkpointConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig);
    }

    public Scheduler build(ShardRecordProcessorFactory shardRecordProcessorFactory) {
        return resolvedConfiguration(shardRecordProcessorFactory).build();
    }

    @java.lang.SuppressWarnings("all")
    public String getApplicationName() {
        return this.applicationName;
    }

    @java.lang.SuppressWarnings("all")
    public String getStreamName() {
        return this.streamName;
    }

    @java.lang.SuppressWarnings("all")
    public String getTableName() {
        return this.tableName;
    }

    @java.lang.SuppressWarnings("all")
    public String getWorkerIdentifier() {
        return this.workerIdentifier;
    }

    @java.lang.SuppressWarnings("all")
    public long getFailoverTimeMillis() {
        return this.failoverTimeMillis;
    }

    @java.lang.SuppressWarnings("all")
    public long getShardSyncIntervalMillis() {
        return this.shardSyncIntervalMillis;
    }

    @java.lang.SuppressWarnings("all")
    public boolean isCleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    @java.lang.SuppressWarnings("all")
    public boolean isIgnoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    @java.lang.SuppressWarnings("all")
    public int getMaxLeasesForWorker() {
        return this.maxLeasesForWorker;
    }

    @java.lang.SuppressWarnings("all")
    public int getMaxLeasesToStealAtOneTime() {
        return this.maxLeasesToStealAtOneTime;
    }

    @java.lang.SuppressWarnings("all")
    public int getInitialLeaseTableReadCapacity() {
        return this.initialLeaseTableReadCapacity;
    }

    @java.lang.SuppressWarnings("all")
    public int getInitialLeaseTableWriteCapacity() {
        return this.initialLeaseTableWriteCapacity;
    }

    @java.lang.SuppressWarnings("all")
    public InitialPositionInStreamExtended getInitialPositionInStreamExtended() {
        return this.initialPositionInStreamExtended;
    }

    @java.lang.SuppressWarnings("all")
    public int getMaxLeaseRenewalThreads() {
        return this.maxLeaseRenewalThreads;
    }

    @java.lang.SuppressWarnings("all")
    public long getListShardsBackoffTimeInMillis() {
        return this.listShardsBackoffTimeInMillis;
    }

    @java.lang.SuppressWarnings("all")
    public int getMaxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    @java.lang.SuppressWarnings("all")
    public boolean isCallProcessRecordsEvenForEmptyRecordList() {
        return this.callProcessRecordsEvenForEmptyRecordList;
    }

    @java.lang.SuppressWarnings("all")
    public long getParentShardPollIntervalMillis() {
        return this.parentShardPollIntervalMillis;
    }

    @java.lang.SuppressWarnings("all")
    public ShardPrioritization getShardPrioritization() {
        return this.shardPrioritization;
    }

    @java.lang.SuppressWarnings("all")
    public boolean isSkipShardSyncAtWorkerInitializationIfLeasesExist() {
        return this.skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    @java.lang.SuppressWarnings("all")
    public long getTaskBackoffTimeMillis() {
        return this.taskBackoffTimeMillis;
    }

    @java.lang.SuppressWarnings("all")
    public long getMetricsBufferTimeMillis() {
        return this.metricsBufferTimeMillis;
    }

    @java.lang.SuppressWarnings("all")
    public int getMetricsMaxQueueSize() {
        return this.metricsMaxQueueSize;
    }

    @java.lang.SuppressWarnings("all")
    public MetricsLevel getMetricsLevel() {
        return this.metricsLevel;
    }

    @java.lang.SuppressWarnings("all")
    public Long getLogWarningForTaskAfterMillis() {
        return this.logWarningForTaskAfterMillis;
    }

    @java.lang.SuppressWarnings("all")
    public RetrievalMode getRetrievalMode() {
        return this.retrievalMode;
    }

    @java.lang.SuppressWarnings("all")
    public FanoutConfigBean getFanoutConfig() {
        return this.fanoutConfig;
    }

    @java.lang.SuppressWarnings("all")
    public PollingConfigBean getPollingConfig() {
        return this.pollingConfig;
    }

    @java.lang.SuppressWarnings("all")
    public boolean isValidateSequenceNumberBeforeCheckpointing() {
        return this.validateSequenceNumberBeforeCheckpointing;
    }

    @java.lang.SuppressWarnings("all")
    public long getShutdownGraceMillis() {
        return this.shutdownGraceMillis;
    }

    @java.lang.SuppressWarnings("all")
    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    @java.lang.SuppressWarnings("all")
    public BuilderDynaBean getKinesisCredentialsProvider() {
        return this.kinesisCredentialsProvider;
    }

    @java.lang.SuppressWarnings("all")
    public BuilderDynaBean getDynamoDBCredentialsProvider() {
        return this.dynamoDBCredentialsProvider;
    }

    @java.lang.SuppressWarnings("all")
    public BuilderDynaBean getCloudWatchCredentialsProvider() {
        return this.cloudWatchCredentialsProvider;
    }

    @java.lang.SuppressWarnings("all")
    public BuilderDynaBean getKinesisClient() {
        return this.kinesisClient;
    }

    @java.lang.SuppressWarnings("all")
    public BuilderDynaBean getDynamoDbClient() {
        return this.dynamoDbClient;
    }

    @java.lang.SuppressWarnings("all")
    public BuilderDynaBean getCloudWatchClient() {
        return this.cloudWatchClient;
    }

    @java.lang.SuppressWarnings("all")
    public BeanUtilsBean getUtilsBean() {
        return this.utilsBean;
    }

    @java.lang.SuppressWarnings("all")
    public ConvertUtilsBean getConvertUtilsBean() {
        return this.convertUtilsBean;
    }

    @java.lang.SuppressWarnings("all")
    public void setApplicationName(final String applicationName) {
        this.applicationName = applicationName;
    }

    @java.lang.SuppressWarnings("all")
    public void setStreamName(final String streamName) {
        this.streamName = streamName;
    }

    @java.lang.SuppressWarnings("all")
    public void setTableName(final String tableName) {
        this.tableName = tableName;
    }

    @java.lang.SuppressWarnings("all")
    public void setWorkerIdentifier(final String workerIdentifier) {
        this.workerIdentifier = workerIdentifier;
    }

    @java.lang.SuppressWarnings("all")
    public void setFailoverTimeMillis(final long failoverTimeMillis) {
        this.failoverTimeMillis = failoverTimeMillis;
    }

    @java.lang.SuppressWarnings("all")
    public void setShardSyncIntervalMillis(final long shardSyncIntervalMillis) {
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
    }

    @java.lang.SuppressWarnings("all")
    public void setCleanupLeasesUponShardCompletion(final boolean cleanupLeasesUponShardCompletion) {
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
    }

    @java.lang.SuppressWarnings("all")
    public void setIgnoreUnexpectedChildShards(final boolean ignoreUnexpectedChildShards) {
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
    }

    @java.lang.SuppressWarnings("all")
    public void setMaxLeasesForWorker(final int maxLeasesForWorker) {
        this.maxLeasesForWorker = maxLeasesForWorker;
    }

    @java.lang.SuppressWarnings("all")
    public void setMaxLeasesToStealAtOneTime(final int maxLeasesToStealAtOneTime) {
        this.maxLeasesToStealAtOneTime = maxLeasesToStealAtOneTime;
    }

    @java.lang.SuppressWarnings("all")
    public void setInitialLeaseTableReadCapacity(final int initialLeaseTableReadCapacity) {
        this.initialLeaseTableReadCapacity = initialLeaseTableReadCapacity;
    }

    @java.lang.SuppressWarnings("all")
    public void setInitialLeaseTableWriteCapacity(final int initialLeaseTableWriteCapacity) {
        this.initialLeaseTableWriteCapacity = initialLeaseTableWriteCapacity;
    }

    @java.lang.SuppressWarnings("all")
    public void setInitialPositionInStreamExtended(final InitialPositionInStreamExtended initialPositionInStreamExtended) {
        this.initialPositionInStreamExtended = initialPositionInStreamExtended;
    }

    @java.lang.SuppressWarnings("all")
    public void setMaxLeaseRenewalThreads(final int maxLeaseRenewalThreads) {
        this.maxLeaseRenewalThreads = maxLeaseRenewalThreads;
    }

    @java.lang.SuppressWarnings("all")
    public void setListShardsBackoffTimeInMillis(final long listShardsBackoffTimeInMillis) {
        this.listShardsBackoffTimeInMillis = listShardsBackoffTimeInMillis;
    }

    @java.lang.SuppressWarnings("all")
    public void setMaxListShardsRetryAttempts(final int maxListShardsRetryAttempts) {
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
    }

    @java.lang.SuppressWarnings("all")
    public void setCallProcessRecordsEvenForEmptyRecordList(final boolean callProcessRecordsEvenForEmptyRecordList) {
        this.callProcessRecordsEvenForEmptyRecordList = callProcessRecordsEvenForEmptyRecordList;
    }

    @java.lang.SuppressWarnings("all")
    public void setParentShardPollIntervalMillis(final long parentShardPollIntervalMillis) {
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
    }

    @java.lang.SuppressWarnings("all")
    public void setShardPrioritization(final ShardPrioritization shardPrioritization) {
        this.shardPrioritization = shardPrioritization;
    }

    @java.lang.SuppressWarnings("all")
    public void setSkipShardSyncAtWorkerInitializationIfLeasesExist(final boolean skipShardSyncAtWorkerInitializationIfLeasesExist) {
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    @java.lang.SuppressWarnings("all")
    public void setTaskBackoffTimeMillis(final long taskBackoffTimeMillis) {
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
    }

    @java.lang.SuppressWarnings("all")
    public void setMetricsBufferTimeMillis(final long metricsBufferTimeMillis) {
        this.metricsBufferTimeMillis = metricsBufferTimeMillis;
    }

    @java.lang.SuppressWarnings("all")
    public void setMetricsMaxQueueSize(final int metricsMaxQueueSize) {
        this.metricsMaxQueueSize = metricsMaxQueueSize;
    }

    @java.lang.SuppressWarnings("all")
    public void setMetricsLevel(final MetricsLevel metricsLevel) {
        this.metricsLevel = metricsLevel;
    }

    @java.lang.SuppressWarnings("all")
    public void setLogWarningForTaskAfterMillis(final Long logWarningForTaskAfterMillis) {
        this.logWarningForTaskAfterMillis = logWarningForTaskAfterMillis;
    }

    @java.lang.SuppressWarnings("all")
    public void setRetrievalMode(final RetrievalMode retrievalMode) {
        this.retrievalMode = retrievalMode;
    }

    @java.lang.SuppressWarnings("all")
    public void setValidateSequenceNumberBeforeCheckpointing(final boolean validateSequenceNumberBeforeCheckpointing) {
        this.validateSequenceNumberBeforeCheckpointing = validateSequenceNumberBeforeCheckpointing;
    }

    @java.lang.SuppressWarnings("all")
    public void setShutdownGraceMillis(final long shutdownGraceMillis) {
        this.shutdownGraceMillis = shutdownGraceMillis;
    }

    @java.lang.SuppressWarnings("all")
    public void setTimeoutInSeconds(final Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }
}
