(function () {
  'use strict';

  const __DEMO__ = false;

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);
      if (object === null) break;
    }

    return object;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);

        if (!base) return;
        var desc = Object.getOwnPropertyDescriptor(base, property);

        if (desc.get) {
          return desc.get.call(receiver);
        }

        return desc.value;
      };
    }

    return _get(target, property, receiver || target);
  }

  function _toArray(arr) {
    return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest();
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _toPrimitive(input, hint) {
    if (typeof input !== "object" || input === null) return input;
    var prim = input[Symbol.toPrimitive];

    if (prim !== undefined) {
      var res = prim.call(input, hint || "default");
      if (typeof res !== "object") return res;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }

    return (hint === "string" ? String : Number)(input);
  }

  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, "string");

    return typeof key === "symbol" ? key : String(key);
  }

  function _decorate(decorators, factory, superClass, mixins) {
    var api = _getDecoratorsApi();

    if (mixins) {
      for (var i = 0; i < mixins.length; i++) {
        api = mixins[i](api);
      }
    }

    var r = factory(function initialize(O) {
      api.initializeInstanceElements(O, decorated.elements);
    }, superClass);
    var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators);
    api.initializeClassElements(r.F, decorated.elements);
    return api.runClassFinishers(r.F, decorated.finishers);
  }

  function _getDecoratorsApi() {
    _getDecoratorsApi = function () {
      return api;
    };

    var api = {
      elementsDefinitionOrder: [["method"], ["field"]],
      initializeInstanceElements: function (O, elements) {
        ["method", "field"].forEach(function (kind) {
          elements.forEach(function (element) {
            if (element.kind === kind && element.placement === "own") {
              this.defineClassElement(O, element);
            }
          }, this);
        }, this);
      },
      initializeClassElements: function (F, elements) {
        var proto = F.prototype;
        ["method", "field"].forEach(function (kind) {
          elements.forEach(function (element) {
            var placement = element.placement;

            if (element.kind === kind && (placement === "static" || placement === "prototype")) {
              var receiver = placement === "static" ? F : proto;
              this.defineClassElement(receiver, element);
            }
          }, this);
        }, this);
      },
      defineClassElement: function (receiver, element) {
        var descriptor = element.descriptor;

        if (element.kind === "field") {
          var initializer = element.initializer;
          descriptor = {
            enumerable: descriptor.enumerable,
            writable: descriptor.writable,
            configurable: descriptor.configurable,
            value: initializer === void 0 ? void 0 : initializer.call(receiver)
          };
        }

        Object.defineProperty(receiver, element.key, descriptor);
      },
      decorateClass: function (elements, decorators) {
        var newElements = [];
        var finishers = [];
        var placements = {
          static: [],
          prototype: [],
          own: []
        };
        elements.forEach(function (element) {
          this.addElementPlacement(element, placements);
        }, this);
        elements.forEach(function (element) {
          if (!_hasDecorators(element)) return newElements.push(element);
          var elementFinishersExtras = this.decorateElement(element, placements);
          newElements.push(elementFinishersExtras.element);
          newElements.push.apply(newElements, elementFinishersExtras.extras);
          finishers.push.apply(finishers, elementFinishersExtras.finishers);
        }, this);

        if (!decorators) {
          return {
            elements: newElements,
            finishers: finishers
          };
        }

        var result = this.decorateConstructor(newElements, decorators);
        finishers.push.apply(finishers, result.finishers);
        result.finishers = finishers;
        return result;
      },
      addElementPlacement: function (element, placements, silent) {
        var keys = placements[element.placement];

        if (!silent && keys.indexOf(element.key) !== -1) {
          throw new TypeError("Duplicated element (" + element.key + ")");
        }

        keys.push(element.key);
      },
      decorateElement: function (element, placements) {
        var extras = [];
        var finishers = [];

        for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) {
          var keys = placements[element.placement];
          keys.splice(keys.indexOf(element.key), 1);
          var elementObject = this.fromElementDescriptor(element);
          var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject);
          element = elementFinisherExtras.element;
          this.addElementPlacement(element, placements);

          if (elementFinisherExtras.finisher) {
            finishers.push(elementFinisherExtras.finisher);
          }

          var newExtras = elementFinisherExtras.extras;

          if (newExtras) {
            for (var j = 0; j < newExtras.length; j++) {
              this.addElementPlacement(newExtras[j], placements);
            }

            extras.push.apply(extras, newExtras);
          }
        }

        return {
          element: element,
          finishers: finishers,
          extras: extras
        };
      },
      decorateConstructor: function (elements, decorators) {
        var finishers = [];

        for (var i = decorators.length - 1; i >= 0; i--) {
          var obj = this.fromClassDescriptor(elements);
          var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj);

          if (elementsAndFinisher.finisher !== undefined) {
            finishers.push(elementsAndFinisher.finisher);
          }

          if (elementsAndFinisher.elements !== undefined) {
            elements = elementsAndFinisher.elements;

            for (var j = 0; j < elements.length - 1; j++) {
              for (var k = j + 1; k < elements.length; k++) {
                if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) {
                  throw new TypeError("Duplicated element (" + elements[j].key + ")");
                }
              }
            }
          }
        }

        return {
          elements: elements,
          finishers: finishers
        };
      },
      fromElementDescriptor: function (element) {
        var obj = {
          kind: element.kind,
          key: element.key,
          placement: element.placement,
          descriptor: element.descriptor
        };
        var desc = {
          value: "Descriptor",
          configurable: true
        };
        Object.defineProperty(obj, Symbol.toStringTag, desc);
        if (element.kind === "field") obj.initializer = element.initializer;
        return obj;
      },
      toElementDescriptors: function (elementObjects) {
        if (elementObjects === undefined) return;
        return _toArray(elementObjects).map(function (elementObject) {
          var element = this.toElementDescriptor(elementObject);
          this.disallowProperty(elementObject, "finisher", "An element descriptor");
          this.disallowProperty(elementObject, "extras", "An element descriptor");
          return element;
        }, this);
      },
      toElementDescriptor: function (elementObject) {
        var kind = String(elementObject.kind);

        if (kind !== "method" && kind !== "field") {
          throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"');
        }

        var key = _toPropertyKey(elementObject.key);

        var placement = String(elementObject.placement);

        if (placement !== "static" && placement !== "prototype" && placement !== "own") {
          throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"');
        }

        var descriptor = elementObject.descriptor;
        this.disallowProperty(elementObject, "elements", "An element descriptor");
        var element = {
          kind: kind,
          key: key,
          placement: placement,
          descriptor: Object.assign({}, descriptor)
        };

        if (kind !== "field") {
          this.disallowProperty(elementObject, "initializer", "A method descriptor");
        } else {
          this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor");
          this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor");
          this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor");
          element.initializer = elementObject.initializer;
        }

        return element;
      },
      toElementFinisherExtras: function (elementObject) {
        var element = this.toElementDescriptor(elementObject);

        var finisher = _optionalCallableProperty(elementObject, "finisher");

        var extras = this.toElementDescriptors(elementObject.extras);
        return {
          element: element,
          finisher: finisher,
          extras: extras
        };
      },
      fromClassDescriptor: function (elements) {
        var obj = {
          kind: "class",
          elements: elements.map(this.fromElementDescriptor, this)
        };
        var desc = {
          value: "Descriptor",
          configurable: true
        };
        Object.defineProperty(obj, Symbol.toStringTag, desc);
        return obj;
      },
      toClassDescriptor: function (obj) {
        var kind = String(obj.kind);

        if (kind !== "class") {
          throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"');
        }

        this.disallowProperty(obj, "key", "A class descriptor");
        this.disallowProperty(obj, "placement", "A class descriptor");
        this.disallowProperty(obj, "descriptor", "A class descriptor");
        this.disallowProperty(obj, "initializer", "A class descriptor");
        this.disallowProperty(obj, "extras", "A class descriptor");

        var finisher = _optionalCallableProperty(obj, "finisher");

        var elements = this.toElementDescriptors(obj.elements);
        return {
          elements: elements,
          finisher: finisher
        };
      },
      runClassFinishers: function (constructor, finishers) {
        for (var i = 0; i < finishers.length; i++) {
          var newConstructor = (0, finishers[i])(constructor);

          if (newConstructor !== undefined) {
            if (typeof newConstructor !== "function") {
              throw new TypeError("Finishers must return a constructor.");
            }

            constructor = newConstructor;
          }
        }

        return constructor;
      },
      disallowProperty: function (obj, name, objectType) {
        if (obj[name] !== undefined) {
          throw new TypeError(objectType + " can't have a ." + name + " property.");
        }
      }
    };
    return api;
  }

  function _createElementDescriptor(def) {
    var key = _toPropertyKey(def.key);

    var descriptor;

    if (def.kind === "method") {
      descriptor = {
        value: def.value,
        writable: true,
        configurable: true,
        enumerable: false
      };
    } else if (def.kind === "get") {
      descriptor = {
        get: def.value,
        configurable: true,
        enumerable: false
      };
    } else if (def.kind === "set") {
      descriptor = {
        set: def.value,
        configurable: true,
        enumerable: false
      };
    } else if (def.kind === "field") {
      descriptor = {
        configurable: true,
        writable: true,
        enumerable: true
      };
    }

    var element = {
      kind: def.kind === "field" ? "field" : "method",
      key: key,
      placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype",
      descriptor: descriptor
    };
    if (def.decorators) element.decorators = def.decorators;
    if (def.kind === "field") element.initializer = def.value;
    return element;
  }

  function _coalesceGetterSetter(element, other) {
    if (element.descriptor.get !== undefined) {
      other.descriptor.get = element.descriptor.get;
    } else {
      other.descriptor.set = element.descriptor.set;
    }
  }

  function _coalesceClassElements(elements) {
    var newElements = [];

    var isSameElement = function (other) {
      return other.kind === "method" && other.key === element.key && other.placement === element.placement;
    };

    for (var i = 0; i < elements.length; i++) {
      var element = elements[i];
      var other;

      if (element.kind === "method" && (other = newElements.find(isSameElement))) {
        if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) {
          if (_hasDecorators(element) || _hasDecorators(other)) {
            throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated.");
          }

          other.descriptor = element.descriptor;
        } else {
          if (_hasDecorators(element)) {
            if (_hasDecorators(other)) {
              throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ").");
            }

            other.decorators = element.decorators;
          }

          _coalesceGetterSetter(element, other);
        }
      } else {
        newElements.push(element);
      }
    }

    return newElements;
  }

  function _hasDecorators(element) {
    return element.decorators && element.decorators.length;
  }

  function _isDataDescriptor(desc) {
    return desc !== undefined && !(desc.value === undefined && desc.writable === undefined);
  }

  function _optionalCallableProperty(obj, name) {
    var value = obj[name];

    if (value !== undefined && typeof value !== "function") {
      throw new TypeError("Expected '" + name + "' to be a function");
    }

    return value;
  }

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */

  /**
   * True if the custom elements polyfill is in use.
   */
  const isCEPolyfill = typeof window !== 'undefined' && window.customElements != null && window.customElements.polyfillWrapFlushCallback !== undefined;
  /**
   * Reparents nodes, starting from `start` (inclusive) to `end` (exclusive),
   * into another container (could be the same container), before `before`. If
   * `before` is null, it appends the nodes to the container.
   */

  const reparentNodes = (container, start, end = null, before = null) => {
    while (start !== end) {
      const n = start.nextSibling;
      container.insertBefore(start, before);
      start = n;
    }
  };
  /**
   * Removes nodes, starting from `start` (inclusive) to `end` (exclusive), from
   * `container`.
   */

  const removeNodes = (container, start, end = null) => {
    while (start !== end) {
      const n = start.nextSibling;
      container.removeChild(start);
      start = n;
    }
  };

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */

  /**
   * An expression marker with embedded unique key to avoid collision with
   * possible text in templates.
   */
  const marker = `{{lit-${String(Math.random()).slice(2)}}}`;
  /**
   * An expression marker used text-positions, multi-binding attributes, and
   * attributes with markup-like text values.
   */

  const nodeMarker = `<!--${marker}-->`;
  const markerRegex = new RegExp(`${marker}|${nodeMarker}`);
  /**
   * Suffix appended to all bound attribute names.
   */

  const boundAttributeSuffix = '$lit$';
  /**
   * An updatable Template that tracks the location of dynamic parts.
   */

  class Template {
    constructor(result, element) {
      this.parts = [];
      this.element = element;
      const nodesToRemove = [];
      const stack = []; // Edge needs all 4 parameters present; IE11 needs 3rd parameter to be null

      const walker = document.createTreeWalker(element.content, 133
      /* NodeFilter.SHOW_{ELEMENT|COMMENT|TEXT} */
      , null, false); // Keeps track of the last index associated with a part. We try to delete
      // unnecessary nodes, but we never want to associate two different parts
      // to the same index. They must have a constant node between.

      let lastPartIndex = 0;
      let index = -1;
      let partIndex = 0;
      const {
        strings,
        values: {
          length
        }
      } = result;

      while (partIndex < length) {
        const node = walker.nextNode();

        if (node === null) {
          // We've exhausted the content inside a nested template element.
          // Because we still have parts (the outer for-loop), we know:
          // - There is a template in the stack
          // - The walker will find a nextNode outside the template
          walker.currentNode = stack.pop();
          continue;
        }

        index++;

        if (node.nodeType === 1
        /* Node.ELEMENT_NODE */
        ) {
            if (node.hasAttributes()) {
              const attributes = node.attributes;
              const {
                length
              } = attributes; // Per
              // https://developer.mozilla.org/en-US/docs/Web/API/NamedNodeMap,
              // attributes are not guaranteed to be returned in document order.
              // In particular, Edge/IE can return them out of order, so we cannot
              // assume a correspondence between part index and attribute index.

              let count = 0;

              for (let i = 0; i < length; i++) {
                if (endsWith(attributes[i].name, boundAttributeSuffix)) {
                  count++;
                }
              }

              while (count-- > 0) {
                // Get the template literal section leading up to the first
                // expression in this attribute
                const stringForPart = strings[partIndex]; // Find the attribute name

                const name = lastAttributeNameRegex.exec(stringForPart)[2]; // Find the corresponding attribute
                // All bound attributes have had a suffix added in
                // TemplateResult#getHTML to opt out of special attribute
                // handling. To look up the attribute value we also need to add
                // the suffix.

                const attributeLookupName = name.toLowerCase() + boundAttributeSuffix;
                const attributeValue = node.getAttribute(attributeLookupName);
                node.removeAttribute(attributeLookupName);
                const statics = attributeValue.split(markerRegex);
                this.parts.push({
                  type: 'attribute',
                  index,
                  name,
                  strings: statics
                });
                partIndex += statics.length - 1;
              }
            }

            if (node.tagName === 'TEMPLATE') {
              stack.push(node);
              walker.currentNode = node.content;
            }
          } else if (node.nodeType === 3
        /* Node.TEXT_NODE */
        ) {
            const data = node.data;

            if (data.indexOf(marker) >= 0) {
              const parent = node.parentNode;
              const strings = data.split(markerRegex);
              const lastIndex = strings.length - 1; // Generate a new text node for each literal section
              // These nodes are also used as the markers for node parts

              for (let i = 0; i < lastIndex; i++) {
                let insert;
                let s = strings[i];

                if (s === '') {
                  insert = createMarker();
                } else {
                  const match = lastAttributeNameRegex.exec(s);

                  if (match !== null && endsWith(match[2], boundAttributeSuffix)) {
                    s = s.slice(0, match.index) + match[1] + match[2].slice(0, -boundAttributeSuffix.length) + match[3];
                  }

                  insert = document.createTextNode(s);
                }

                parent.insertBefore(insert, node);
                this.parts.push({
                  type: 'node',
                  index: ++index
                });
              } // If there's no text, we must insert a comment to mark our place.
              // Else, we can trust it will stick around after cloning.


              if (strings[lastIndex] === '') {
                parent.insertBefore(createMarker(), node);
                nodesToRemove.push(node);
              } else {
                node.data = strings[lastIndex];
              } // We have a part for each match found


              partIndex += lastIndex;
            }
          } else if (node.nodeType === 8
        /* Node.COMMENT_NODE */
        ) {
            if (node.data === marker) {
              const parent = node.parentNode; // Add a new marker node to be the startNode of the Part if any of
              // the following are true:
              //  * We don't have a previousSibling
              //  * The previousSibling is already the start of a previous part

              if (node.previousSibling === null || index === lastPartIndex) {
                index++;
                parent.insertBefore(createMarker(), node);
              }

              lastPartIndex = index;
              this.parts.push({
                type: 'node',
                index
              }); // If we don't have a nextSibling, keep this node so we have an end.
              // Else, we can remove it to save future costs.

              if (node.nextSibling === null) {
                node.data = '';
              } else {
                nodesToRemove.push(node);
                index--;
              }

              partIndex++;
            } else {
              let i = -1;

              while ((i = node.data.indexOf(marker, i + 1)) !== -1) {
                // Comment node has a binding marker inside, make an inactive part
                // The binding won't work, but subsequent bindings will
                // TODO (justinfagnani): consider whether it's even worth it to
                // make bindings in comments work
                this.parts.push({
                  type: 'node',
                  index: -1
                });
                partIndex++;
              }
            }
          }
      } // Remove text binding nodes after the walk to not disturb the TreeWalker


      for (const n of nodesToRemove) {
        n.parentNode.removeChild(n);
      }
    }

  }

  const endsWith = (str, suffix) => {
    const index = str.length - suffix.length;
    return index >= 0 && str.slice(index) === suffix;
  };

  const isTemplatePartActive = part => part.index !== -1; // Allows `document.createComment('')` to be renamed for a
  // small manual size-savings.

  const createMarker = () => document.createComment('');
  /**
   * This regex extracts the attribute name preceding an attribute-position
   * expression. It does this by matching the syntax allowed for attributes
   * against the string literal directly preceding the expression, assuming that
   * the expression is in an attribute-value position.
   *
   * See attributes in the HTML spec:
   * https://www.w3.org/TR/html5/syntax.html#elements-attributes
   *
   * " \x09\x0a\x0c\x0d" are HTML space characters:
   * https://www.w3.org/TR/html5/infrastructure.html#space-characters
   *
   * "\0-\x1F\x7F-\x9F" are Unicode control characters, which includes every
   * space character except " ".
   *
   * So an attribute is:
   *  * The name: any character except a control character, space character, ('),
   *    ("), ">", "=", or "/"
   *  * Followed by zero or more space characters
   *  * Followed by "="
   *  * Followed by zero or more space characters
   *  * Followed by:
   *    * Any character except space, ('), ("), "<", ">", "=", (`), or
   *    * (") then any non-("), or
   *    * (') then any non-(')
   */

  const lastAttributeNameRegex = // eslint-disable-next-line no-control-regex
  /([ \x09\x0a\x0c\x0d])([^\0-\x1F\x7F-\x9F "'>=/]+)([ \x09\x0a\x0c\x0d]*=[ \x09\x0a\x0c\x0d]*(?:[^ \x09\x0a\x0c\x0d"'`<>=]*|"[^"]*|'[^']*))$/;

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  const walkerNodeFilter = 133
  /* NodeFilter.SHOW_{ELEMENT|COMMENT|TEXT} */
  ;
  /**
   * Removes the list of nodes from a Template safely. In addition to removing
   * nodes from the Template, the Template part indices are updated to match
   * the mutated Template DOM.
   *
   * As the template is walked the removal state is tracked and
   * part indices are adjusted as needed.
   *
   * div
   *   div#1 (remove) <-- start removing (removing node is div#1)
   *     div
   *       div#2 (remove)  <-- continue removing (removing node is still div#1)
   *         div
   * div <-- stop removing since previous sibling is the removing node (div#1,
   * removed 4 nodes)
   */

  function removeNodesFromTemplate(template, nodesToRemove) {
    const {
      element: {
        content
      },
      parts
    } = template;
    const walker = document.createTreeWalker(content, walkerNodeFilter, null, false);
    let partIndex = nextActiveIndexInTemplateParts(parts);
    let part = parts[partIndex];
    let nodeIndex = -1;
    let removeCount = 0;
    const nodesToRemoveInTemplate = [];
    let currentRemovingNode = null;

    while (walker.nextNode()) {
      nodeIndex++;
      const node = walker.currentNode; // End removal if stepped past the removing node

      if (node.previousSibling === currentRemovingNode) {
        currentRemovingNode = null;
      } // A node to remove was found in the template


      if (nodesToRemove.has(node)) {
        nodesToRemoveInTemplate.push(node); // Track node we're removing

        if (currentRemovingNode === null) {
          currentRemovingNode = node;
        }
      } // When removing, increment count by which to adjust subsequent part indices


      if (currentRemovingNode !== null) {
        removeCount++;
      }

      while (part !== undefined && part.index === nodeIndex) {
        // If part is in a removed node deactivate it by setting index to -1 or
        // adjust the index as needed.
        part.index = currentRemovingNode !== null ? -1 : part.index - removeCount; // go to the next active part.

        partIndex = nextActiveIndexInTemplateParts(parts, partIndex);
        part = parts[partIndex];
      }
    }

    nodesToRemoveInTemplate.forEach(n => n.parentNode.removeChild(n));
  }

  const countNodes = node => {
    let count = node.nodeType === 11
    /* Node.DOCUMENT_FRAGMENT_NODE */
    ? 0 : 1;
    const walker = document.createTreeWalker(node, walkerNodeFilter, null, false);

    while (walker.nextNode()) {
      count++;
    }

    return count;
  };

  const nextActiveIndexInTemplateParts = (parts, startIndex = -1) => {
    for (let i = startIndex + 1; i < parts.length; i++) {
      const part = parts[i];

      if (isTemplatePartActive(part)) {
        return i;
      }
    }

    return -1;
  };
  /**
   * Inserts the given node into the Template, optionally before the given
   * refNode. In addition to inserting the node into the Template, the Template
   * part indices are updated to match the mutated Template DOM.
   */


  function insertNodeIntoTemplate(template, node, refNode = null) {
    const {
      element: {
        content
      },
      parts
    } = template; // If there's no refNode, then put node at end of template.
    // No part indices need to be shifted in this case.

    if (refNode === null || refNode === undefined) {
      content.appendChild(node);
      return;
    }

    const walker = document.createTreeWalker(content, walkerNodeFilter, null, false);
    let partIndex = nextActiveIndexInTemplateParts(parts);
    let insertCount = 0;
    let walkerIndex = -1;

    while (walker.nextNode()) {
      walkerIndex++;
      const walkerNode = walker.currentNode;

      if (walkerNode === refNode) {
        insertCount = countNodes(node);
        refNode.parentNode.insertBefore(node, refNode);
      }

      while (partIndex !== -1 && parts[partIndex].index === walkerIndex) {
        // If we've inserted the node, simply adjust all subsequent parts
        if (insertCount > 0) {
          while (partIndex !== -1) {
            parts[partIndex].index += insertCount;
            partIndex = nextActiveIndexInTemplateParts(parts, partIndex);
          }

          return;
        }

        partIndex = nextActiveIndexInTemplateParts(parts, partIndex);
      }
    }
  }

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  const directives = new WeakMap();
  /**
   * Brands a function as a directive factory function so that lit-html will call
   * the function during template rendering, rather than passing as a value.
   *
   * A _directive_ is a function that takes a Part as an argument. It has the
   * signature: `(part: Part) => void`.
   *
   * A directive _factory_ is a function that takes arguments for data and
   * configuration and returns a directive. Users of directive usually refer to
   * the directive factory as the directive. For example, "The repeat directive".
   *
   * Usually a template author will invoke a directive factory in their template
   * with relevant arguments, which will then return a directive function.
   *
   * Here's an example of using the `repeat()` directive factory that takes an
   * array and a function to render an item:
   *
   * ```js
   * html`<ul><${repeat(items, (item) => html`<li>${item}</li>`)}</ul>`
   * ```
   *
   * When `repeat` is invoked, it returns a directive function that closes over
   * `items` and the template function. When the outer template is rendered, the
   * return directive function is called with the Part for the expression.
   * `repeat` then performs it's custom logic to render multiple items.
   *
   * @param f The directive factory function. Must be a function that returns a
   * function of the signature `(part: Part) => void`. The returned function will
   * be called with the part object.
   *
   * @example
   *
   * import {directive, html} from 'lit-html';
   *
   * const immutable = directive((v) => (part) => {
   *   if (part.value !== v) {
   *     part.setValue(v)
   *   }
   * });
   */

  const directive = f => (...args) => {
    const d = f(...args);
    directives.set(d, true);
    return d;
  };
  const isDirective = o => {
    return typeof o === 'function' && directives.has(o);
  };

  /**
   * @license
   * Copyright (c) 2018 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */

  /**
   * A sentinel value that signals that a value was handled by a directive and
   * should not be written to the DOM.
   */
  const noChange = {};
  /**
   * A sentinel value that signals a NodePart to fully clear its content.
   */

  const nothing = {};

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  /**
   * An instance of a `Template` that can be attached to the DOM and updated
   * with new values.
   */

  class TemplateInstance {
    constructor(template, processor, options) {
      this.__parts = [];
      this.template = template;
      this.processor = processor;
      this.options = options;
    }

    update(values) {
      let i = 0;

      for (const part of this.__parts) {
        if (part !== undefined) {
          part.setValue(values[i]);
        }

        i++;
      }

      for (const part of this.__parts) {
        if (part !== undefined) {
          part.commit();
        }
      }
    }

    _clone() {
      // There are a number of steps in the lifecycle of a template instance's
      // DOM fragment:
      //  1. Clone - create the instance fragment
      //  2. Adopt - adopt into the main document
      //  3. Process - find part markers and create parts
      //  4. Upgrade - upgrade custom elements
      //  5. Update - set node, attribute, property, etc., values
      //  6. Connect - connect to the document. Optional and outside of this
      //     method.
      //
      // We have a few constraints on the ordering of these steps:
      //  * We need to upgrade before updating, so that property values will pass
      //    through any property setters.
      //  * We would like to process before upgrading so that we're sure that the
      //    cloned fragment is inert and not disturbed by self-modifying DOM.
      //  * We want custom elements to upgrade even in disconnected fragments.
      //
      // Given these constraints, with full custom elements support we would
      // prefer the order: Clone, Process, Adopt, Upgrade, Update, Connect
      //
      // But Safari does not implement CustomElementRegistry#upgrade, so we
      // can not implement that order and still have upgrade-before-update and
      // upgrade disconnected fragments. So we instead sacrifice the
      // process-before-upgrade constraint, since in Custom Elements v1 elements
      // must not modify their light DOM in the constructor. We still have issues
      // when co-existing with CEv0 elements like Polymer 1, and with polyfills
      // that don't strictly adhere to the no-modification rule because shadow
      // DOM, which may be created in the constructor, is emulated by being placed
      // in the light DOM.
      //
      // The resulting order is on native is: Clone, Adopt, Upgrade, Process,
      // Update, Connect. document.importNode() performs Clone, Adopt, and Upgrade
      // in one step.
      //
      // The Custom Elements v1 polyfill supports upgrade(), so the order when
      // polyfilled is the more ideal: Clone, Process, Adopt, Upgrade, Update,
      // Connect.
      const fragment = isCEPolyfill ? this.template.element.content.cloneNode(true) : document.importNode(this.template.element.content, true);
      const stack = [];
      const parts = this.template.parts; // Edge needs all 4 parameters present; IE11 needs 3rd parameter to be null

      const walker = document.createTreeWalker(fragment, 133
      /* NodeFilter.SHOW_{ELEMENT|COMMENT|TEXT} */
      , null, false);
      let partIndex = 0;
      let nodeIndex = 0;
      let part;
      let node = walker.nextNode(); // Loop through all the nodes and parts of a template

      while (partIndex < parts.length) {
        part = parts[partIndex];

        if (!isTemplatePartActive(part)) {
          this.__parts.push(undefined);

          partIndex++;
          continue;
        } // Progress the tree walker until we find our next part's node.
        // Note that multiple parts may share the same node (attribute parts
        // on a single element), so this loop may not run at all.


        while (nodeIndex < part.index) {
          nodeIndex++;

          if (node.nodeName === 'TEMPLATE') {
            stack.push(node);
            walker.currentNode = node.content;
          }

          if ((node = walker.nextNode()) === null) {
            // We've exhausted the content inside a nested template element.
            // Because we still have parts (the outer for-loop), we know:
            // - There is a template in the stack
            // - The walker will find a nextNode outside the template
            walker.currentNode = stack.pop();
            node = walker.nextNode();
          }
        } // We've arrived at our part's node.


        if (part.type === 'node') {
          const part = this.processor.handleTextExpression(this.options);
          part.insertAfterNode(node.previousSibling);

          this.__parts.push(part);
        } else {
          this.__parts.push(...this.processor.handleAttributeExpressions(node, part.name, part.strings, this.options));
        }

        partIndex++;
      }

      if (isCEPolyfill) {
        document.adoptNode(fragment);
        customElements.upgrade(fragment);
      }

      return fragment;
    }

  }

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  const commentMarker = ` ${marker} `;
  /**
   * The return type of `html`, which holds a Template and the values from
   * interpolated expressions.
   */

  class TemplateResult {
    constructor(strings, values, type, processor) {
      this.strings = strings;
      this.values = values;
      this.type = type;
      this.processor = processor;
    }
    /**
     * Returns a string of HTML used to create a `<template>` element.
     */


    getHTML() {
      const l = this.strings.length - 1;
      let html = '';
      let isCommentBinding = false;

      for (let i = 0; i < l; i++) {
        const s = this.strings[i]; // For each binding we want to determine the kind of marker to insert
        // into the template source before it's parsed by the browser's HTML
        // parser. The marker type is based on whether the expression is in an
        // attribute, text, or comment position.
        //   * For node-position bindings we insert a comment with the marker
        //     sentinel as its text content, like <!--{{lit-guid}}-->.
        //   * For attribute bindings we insert just the marker sentinel for the
        //     first binding, so that we support unquoted attribute bindings.
        //     Subsequent bindings can use a comment marker because multi-binding
        //     attributes must be quoted.
        //   * For comment bindings we insert just the marker sentinel so we don't
        //     close the comment.
        //
        // The following code scans the template source, but is *not* an HTML
        // parser. We don't need to track the tree structure of the HTML, only
        // whether a binding is inside a comment, and if not, if it appears to be
        // the first binding in an attribute.

        const commentOpen = s.lastIndexOf('<!--'); // We're in comment position if we have a comment open with no following
        // comment close. Because <-- can appear in an attribute value there can
        // be false positives.

        isCommentBinding = (commentOpen > -1 || isCommentBinding) && s.indexOf('-->', commentOpen + 1) === -1; // Check to see if we have an attribute-like sequence preceding the
        // expression. This can match "name=value" like structures in text,
        // comments, and attribute values, so there can be false-positives.

        const attributeMatch = lastAttributeNameRegex.exec(s);

        if (attributeMatch === null) {
          // We're only in this branch if we don't have a attribute-like
          // preceding sequence. For comments, this guards against unusual
          // attribute values like <div foo="<!--${'bar'}">. Cases like
          // <!-- foo=${'bar'}--> are handled correctly in the attribute branch
          // below.
          html += s + (isCommentBinding ? commentMarker : nodeMarker);
        } else {
          // For attributes we use just a marker sentinel, and also append a
          // $lit$ suffix to the name to opt-out of attribute-specific parsing
          // that IE and Edge do for style and certain SVG attributes.
          html += s.substr(0, attributeMatch.index) + attributeMatch[1] + attributeMatch[2] + boundAttributeSuffix + attributeMatch[3] + marker;
        }
      }

      html += this.strings[l];
      return html;
    }

    getTemplateElement() {
      const template = document.createElement('template');
      template.innerHTML = this.getHTML();
      return template;
    }

  }
  /**
   * A TemplateResult for SVG fragments.
   *
   * This class wraps HTML in an `<svg>` tag in order to parse its contents in the
   * SVG namespace, then modifies the template to remove the `<svg>` tag so that
   * clones only container the original fragment.
   */

  class SVGTemplateResult extends TemplateResult {
    getHTML() {
      return `<svg>${super.getHTML()}</svg>`;
    }

    getTemplateElement() {
      const template = super.getTemplateElement();
      const content = template.content;
      const svgElement = content.firstChild;
      content.removeChild(svgElement);
      reparentNodes(content, svgElement.firstChild);
      return template;
    }

  }

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  const isPrimitive = value => {
    return value === null || !(typeof value === 'object' || typeof value === 'function');
  };
  const isIterable = value => {
    return Array.isArray(value) || // eslint-disable-next-line @typescript-eslint/no-explicit-any
    !!(value && value[Symbol.iterator]);
  };
  /**
   * Writes attribute values to the DOM for a group of AttributeParts bound to a
   * single attribute. The value is only set once even if there are multiple parts
   * for an attribute.
   */

  class AttributeCommitter {
    constructor(element, name, strings) {
      this.dirty = true;
      this.element = element;
      this.name = name;
      this.strings = strings;
      this.parts = [];

      for (let i = 0; i < strings.length - 1; i++) {
        this.parts[i] = this._createPart();
      }
    }
    /**
     * Creates a single part. Override this to create a differnt type of part.
     */


    _createPart() {
      return new AttributePart(this);
    }

    _getValue() {
      const strings = this.strings;
      const l = strings.length - 1;
      let text = '';

      for (let i = 0; i < l; i++) {
        text += strings[i];
        const part = this.parts[i];

        if (part !== undefined) {
          const v = part.value;

          if (isPrimitive(v) || !isIterable(v)) {
            text += typeof v === 'string' ? v : String(v);
          } else {
            for (const t of v) {
              text += typeof t === 'string' ? t : String(t);
            }
          }
        }
      }

      text += strings[l];
      return text;
    }

    commit() {
      if (this.dirty) {
        this.dirty = false;
        this.element.setAttribute(this.name, this._getValue());
      }
    }

  }
  /**
   * A Part that controls all or part of an attribute value.
   */

  class AttributePart {
    constructor(committer) {
      this.value = undefined;
      this.committer = committer;
    }

    setValue(value) {
      if (value !== noChange && (!isPrimitive(value) || value !== this.value)) {
        this.value = value; // If the value is a not a directive, dirty the committer so that it'll
        // call setAttribute. If the value is a directive, it'll dirty the
        // committer if it calls setValue().

        if (!isDirective(value)) {
          this.committer.dirty = true;
        }
      }
    }

    commit() {
      while (isDirective(this.value)) {
        const directive = this.value;
        this.value = noChange;
        directive(this);
      }

      if (this.value === noChange) {
        return;
      }

      this.committer.commit();
    }

  }
  /**
   * A Part that controls a location within a Node tree. Like a Range, NodePart
   * has start and end locations and can set and update the Nodes between those
   * locations.
   *
   * NodeParts support several value types: primitives, Nodes, TemplateResults,
   * as well as arrays and iterables of those types.
   */

  class NodePart {
    constructor(options) {
      this.value = undefined;
      this.__pendingValue = undefined;
      this.options = options;
    }
    /**
     * Appends this part into a container.
     *
     * This part must be empty, as its contents are not automatically moved.
     */


    appendInto(container) {
      this.startNode = container.appendChild(createMarker());
      this.endNode = container.appendChild(createMarker());
    }
    /**
     * Inserts this part after the `ref` node (between `ref` and `ref`'s next
     * sibling). Both `ref` and its next sibling must be static, unchanging nodes
     * such as those that appear in a literal section of a template.
     *
     * This part must be empty, as its contents are not automatically moved.
     */


    insertAfterNode(ref) {
      this.startNode = ref;
      this.endNode = ref.nextSibling;
    }
    /**
     * Appends this part into a parent part.
     *
     * This part must be empty, as its contents are not automatically moved.
     */


    appendIntoPart(part) {
      part.__insert(this.startNode = createMarker());

      part.__insert(this.endNode = createMarker());
    }
    /**
     * Inserts this part after the `ref` part.
     *
     * This part must be empty, as its contents are not automatically moved.
     */


    insertAfterPart(ref) {
      ref.__insert(this.startNode = createMarker());

      this.endNode = ref.endNode;
      ref.endNode = this.startNode;
    }

    setValue(value) {
      this.__pendingValue = value;
    }

    commit() {
      if (this.startNode.parentNode === null) {
        return;
      }

      while (isDirective(this.__pendingValue)) {
        const directive = this.__pendingValue;
        this.__pendingValue = noChange;
        directive(this);
      }

      const value = this.__pendingValue;

      if (value === noChange) {
        return;
      }

      if (isPrimitive(value)) {
        if (value !== this.value) {
          this.__commitText(value);
        }
      } else if (value instanceof TemplateResult) {
        this.__commitTemplateResult(value);
      } else if (value instanceof Node) {
        this.__commitNode(value);
      } else if (isIterable(value)) {
        this.__commitIterable(value);
      } else if (value === nothing) {
        this.value = nothing;
        this.clear();
      } else {
        // Fallback, will render the string representation
        this.__commitText(value);
      }
    }

    __insert(node) {
      this.endNode.parentNode.insertBefore(node, this.endNode);
    }

    __commitNode(value) {
      if (this.value === value) {
        return;
      }

      this.clear();

      this.__insert(value);

      this.value = value;
    }

    __commitText(value) {
      const node = this.startNode.nextSibling;
      value = value == null ? '' : value; // If `value` isn't already a string, we explicitly convert it here in case
      // it can't be implicitly converted - i.e. it's a symbol.

      const valueAsString = typeof value === 'string' ? value : String(value);

      if (node === this.endNode.previousSibling && node.nodeType === 3
      /* Node.TEXT_NODE */
      ) {
          // If we only have a single text node between the markers, we can just
          // set its value, rather than replacing it.
          // TODO(justinfagnani): Can we just check if this.value is primitive?
          node.data = valueAsString;
        } else {
        this.__commitNode(document.createTextNode(valueAsString));
      }

      this.value = value;
    }

    __commitTemplateResult(value) {
      const template = this.options.templateFactory(value);

      if (this.value instanceof TemplateInstance && this.value.template === template) {
        this.value.update(value.values);
      } else {
        // Make sure we propagate the template processor from the TemplateResult
        // so that we use its syntax extension, etc. The template factory comes
        // from the render function options so that it can control template
        // caching and preprocessing.
        const instance = new TemplateInstance(template, value.processor, this.options);

        const fragment = instance._clone();

        instance.update(value.values);

        this.__commitNode(fragment);

        this.value = instance;
      }
    }

    __commitIterable(value) {
      // For an Iterable, we create a new InstancePart per item, then set its
      // value to the item. This is a little bit of overhead for every item in
      // an Iterable, but it lets us recurse easily and efficiently update Arrays
      // of TemplateResults that will be commonly returned from expressions like:
      // array.map((i) => html`${i}`), by reusing existing TemplateInstances.
      // If _value is an array, then the previous render was of an
      // iterable and _value will contain the NodeParts from the previous
      // render. If _value is not an array, clear this part and make a new
      // array for NodeParts.
      if (!Array.isArray(this.value)) {
        this.value = [];
        this.clear();
      } // Lets us keep track of how many items we stamped so we can clear leftover
      // items from a previous render


      const itemParts = this.value;
      let partIndex = 0;
      let itemPart;

      for (const item of value) {
        // Try to reuse an existing part
        itemPart = itemParts[partIndex]; // If no existing part, create a new one

        if (itemPart === undefined) {
          itemPart = new NodePart(this.options);
          itemParts.push(itemPart);

          if (partIndex === 0) {
            itemPart.appendIntoPart(this);
          } else {
            itemPart.insertAfterPart(itemParts[partIndex - 1]);
          }
        }

        itemPart.setValue(item);
        itemPart.commit();
        partIndex++;
      }

      if (partIndex < itemParts.length) {
        // Truncate the parts array so _value reflects the current state
        itemParts.length = partIndex;
        this.clear(itemPart && itemPart.endNode);
      }
    }

    clear(startNode = this.startNode) {
      removeNodes(this.startNode.parentNode, startNode.nextSibling, this.endNode);
    }

  }
  /**
   * Implements a boolean attribute, roughly as defined in the HTML
   * specification.
   *
   * If the value is truthy, then the attribute is present with a value of
   * ''. If the value is falsey, the attribute is removed.
   */

  class BooleanAttributePart {
    constructor(element, name, strings) {
      this.value = undefined;
      this.__pendingValue = undefined;

      if (strings.length !== 2 || strings[0] !== '' || strings[1] !== '') {
        throw new Error('Boolean attributes can only contain a single expression');
      }

      this.element = element;
      this.name = name;
      this.strings = strings;
    }

    setValue(value) {
      this.__pendingValue = value;
    }

    commit() {
      while (isDirective(this.__pendingValue)) {
        const directive = this.__pendingValue;
        this.__pendingValue = noChange;
        directive(this);
      }

      if (this.__pendingValue === noChange) {
        return;
      }

      const value = !!this.__pendingValue;

      if (this.value !== value) {
        if (value) {
          this.element.setAttribute(this.name, '');
        } else {
          this.element.removeAttribute(this.name);
        }

        this.value = value;
      }

      this.__pendingValue = noChange;
    }

  }
  /**
   * Sets attribute values for PropertyParts, so that the value is only set once
   * even if there are multiple parts for a property.
   *
   * If an expression controls the whole property value, then the value is simply
   * assigned to the property under control. If there are string literals or
   * multiple expressions, then the strings are expressions are interpolated into
   * a string first.
   */

  class PropertyCommitter extends AttributeCommitter {
    constructor(element, name, strings) {
      super(element, name, strings);
      this.single = strings.length === 2 && strings[0] === '' && strings[1] === '';
    }

    _createPart() {
      return new PropertyPart(this);
    }

    _getValue() {
      if (this.single) {
        return this.parts[0].value;
      }

      return super._getValue();
    }

    commit() {
      if (this.dirty) {
        this.dirty = false; // eslint-disable-next-line @typescript-eslint/no-explicit-any

        this.element[this.name] = this._getValue();
      }
    }

  }
  class PropertyPart extends AttributePart {} // Detect event listener options support. If the `capture` property is read
  // from the options object, then options are supported. If not, then the third
  // argument to add/removeEventListener is interpreted as the boolean capture
  // value so we should only pass the `capture` property.

  let eventOptionsSupported = false; // Wrap into an IIFE because MS Edge <= v41 does not support having try/catch
  // blocks right into the body of a module

  (() => {
    try {
      const options = {
        get capture() {
          eventOptionsSupported = true;
          return false;
        }

      }; // eslint-disable-next-line @typescript-eslint/no-explicit-any

      window.addEventListener('test', options, options); // eslint-disable-next-line @typescript-eslint/no-explicit-any

      window.removeEventListener('test', options, options);
    } catch (_e) {// event options not supported
    }
  })();

  class EventPart {
    constructor(element, eventName, eventContext) {
      this.value = undefined;
      this.__pendingValue = undefined;
      this.element = element;
      this.eventName = eventName;
      this.eventContext = eventContext;

      this.__boundHandleEvent = e => this.handleEvent(e);
    }

    setValue(value) {
      this.__pendingValue = value;
    }

    commit() {
      while (isDirective(this.__pendingValue)) {
        const directive = this.__pendingValue;
        this.__pendingValue = noChange;
        directive(this);
      }

      if (this.__pendingValue === noChange) {
        return;
      }

      const newListener = this.__pendingValue;
      const oldListener = this.value;
      const shouldRemoveListener = newListener == null || oldListener != null && (newListener.capture !== oldListener.capture || newListener.once !== oldListener.once || newListener.passive !== oldListener.passive);
      const shouldAddListener = newListener != null && (oldListener == null || shouldRemoveListener);

      if (shouldRemoveListener) {
        this.element.removeEventListener(this.eventName, this.__boundHandleEvent, this.__options);
      }

      if (shouldAddListener) {
        this.__options = getOptions(newListener);
        this.element.addEventListener(this.eventName, this.__boundHandleEvent, this.__options);
      }

      this.value = newListener;
      this.__pendingValue = noChange;
    }

    handleEvent(event) {
      if (typeof this.value === 'function') {
        this.value.call(this.eventContext || this.element, event);
      } else {
        this.value.handleEvent(event);
      }
    }

  } // We copy options because of the inconsistent behavior of browsers when reading
  // the third argument of add/removeEventListener. IE11 doesn't support options
  // at all. Chrome 41 only reads `capture` if the argument is an object.

  const getOptions = o => o && (eventOptionsSupported ? {
    capture: o.capture,
    passive: o.passive,
    once: o.once
  } : o.capture);

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  /**
   * The default TemplateFactory which caches Templates keyed on
   * result.type and result.strings.
   */

  function templateFactory(result) {
    let templateCache = templateCaches.get(result.type);

    if (templateCache === undefined) {
      templateCache = {
        stringsArray: new WeakMap(),
        keyString: new Map()
      };
      templateCaches.set(result.type, templateCache);
    }

    let template = templateCache.stringsArray.get(result.strings);

    if (template !== undefined) {
      return template;
    } // If the TemplateStringsArray is new, generate a key from the strings
    // This key is shared between all templates with identical content


    const key = result.strings.join(marker); // Check if we already have a Template for this key

    template = templateCache.keyString.get(key);

    if (template === undefined) {
      // If we have not seen this key before, create a new Template
      template = new Template(result, result.getTemplateElement()); // Cache the Template for this key

      templateCache.keyString.set(key, template);
    } // Cache all future queries for this TemplateStringsArray


    templateCache.stringsArray.set(result.strings, template);
    return template;
  }
  const templateCaches = new Map();

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  const parts = new WeakMap();
  /**
   * Renders a template result or other value to a container.
   *
   * To update a container with new values, reevaluate the template literal and
   * call `render` with the new result.
   *
   * @param result Any value renderable by NodePart - typically a TemplateResult
   *     created by evaluating a template tag like `html` or `svg`.
   * @param container A DOM parent to render to. The entire contents are either
   *     replaced, or efficiently updated if the same result type was previous
   *     rendered there.
   * @param options RenderOptions for the entire render tree rendered to this
   *     container. Render options must *not* change between renders to the same
   *     container, as those changes will not effect previously rendered DOM.
   */

  const render = (result, container, options) => {
    let part = parts.get(container);

    if (part === undefined) {
      removeNodes(container, container.firstChild);
      parts.set(container, part = new NodePart(Object.assign({
        templateFactory
      }, options)));
      part.appendInto(container);
    }

    part.setValue(result);
    part.commit();
  };

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  /**
   * Creates Parts when a template is instantiated.
   */

  class DefaultTemplateProcessor {
    /**
     * Create parts for an attribute-position binding, given the event, attribute
     * name, and string literals.
     *
     * @param element The element containing the binding
     * @param name  The attribute name
     * @param strings The string literals. There are always at least two strings,
     *   event for fully-controlled bindings with a single expression.
     */
    handleAttributeExpressions(element, name, strings, options) {
      const prefix = name[0];

      if (prefix === '.') {
        const committer = new PropertyCommitter(element, name.slice(1), strings);
        return committer.parts;
      }

      if (prefix === '@') {
        return [new EventPart(element, name.slice(1), options.eventContext)];
      }

      if (prefix === '?') {
        return [new BooleanAttributePart(element, name.slice(1), strings)];
      }

      const committer = new AttributeCommitter(element, name, strings);
      return committer.parts;
    }
    /**
     * Create parts for a text-position binding.
     * @param templateFactory
     */


    handleTextExpression(options) {
      return new NodePart(options);
    }

  }
  const defaultTemplateProcessor = new DefaultTemplateProcessor();

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  // This line will be used in regexes to search for lit-html usage.
  // TODO(justinfagnani): inject version number at build time

  if (typeof window !== 'undefined') {
    (window['litHtmlVersions'] || (window['litHtmlVersions'] = [])).push('1.2.1');
  }
  /**
   * Interprets a template literal as an HTML template that can efficiently
   * render to and update a container.
   */


  const html = (strings, ...values) => new TemplateResult(strings, values, 'html', defaultTemplateProcessor);
  /**
   * Interprets a template literal as an SVG template that can efficiently
   * render to and update a container.
   */

  const svg = (strings, ...values) => new SVGTemplateResult(strings, values, 'svg', defaultTemplateProcessor);

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */

  const getTemplateCacheKey = (type, scopeName) => `${type}--${scopeName}`;

  let compatibleShadyCSSVersion = true;

  if (typeof window.ShadyCSS === 'undefined') {
    compatibleShadyCSSVersion = false;
  } else if (typeof window.ShadyCSS.prepareTemplateDom === 'undefined') {
    console.warn(`Incompatible ShadyCSS version detected. ` + `Please update to at least @webcomponents/webcomponentsjs@2.0.2 and ` + `@webcomponents/shadycss@1.3.1.`);
    compatibleShadyCSSVersion = false;
  }
  /**
   * Template factory which scopes template DOM using ShadyCSS.
   * @param scopeName {string}
   */


  const shadyTemplateFactory = scopeName => result => {
    const cacheKey = getTemplateCacheKey(result.type, scopeName);
    let templateCache = templateCaches.get(cacheKey);

    if (templateCache === undefined) {
      templateCache = {
        stringsArray: new WeakMap(),
        keyString: new Map()
      };
      templateCaches.set(cacheKey, templateCache);
    }

    let template = templateCache.stringsArray.get(result.strings);

    if (template !== undefined) {
      return template;
    }

    const key = result.strings.join(marker);
    template = templateCache.keyString.get(key);

    if (template === undefined) {
      const element = result.getTemplateElement();

      if (compatibleShadyCSSVersion) {
        window.ShadyCSS.prepareTemplateDom(element, scopeName);
      }

      template = new Template(result, element);
      templateCache.keyString.set(key, template);
    }

    templateCache.stringsArray.set(result.strings, template);
    return template;
  };

  const TEMPLATE_TYPES = ['html', 'svg'];
  /**
   * Removes all style elements from Templates for the given scopeName.
   */

  const removeStylesFromLitTemplates = scopeName => {
    TEMPLATE_TYPES.forEach(type => {
      const templates = templateCaches.get(getTemplateCacheKey(type, scopeName));

      if (templates !== undefined) {
        templates.keyString.forEach(template => {
          const {
            element: {
              content
            }
          } = template; // IE 11 doesn't support the iterable param Set constructor

          const styles = new Set();
          Array.from(content.querySelectorAll('style')).forEach(s => {
            styles.add(s);
          });
          removeNodesFromTemplate(template, styles);
        });
      }
    });
  };

  const shadyRenderSet = new Set();
  /**
   * For the given scope name, ensures that ShadyCSS style scoping is performed.
   * This is done just once per scope name so the fragment and template cannot
   * be modified.
   * (1) extracts styles from the rendered fragment and hands them to ShadyCSS
   * to be scoped and appended to the document
   * (2) removes style elements from all lit-html Templates for this scope name.
   *
   * Note, <style> elements can only be placed into templates for the
   * initial rendering of the scope. If <style> elements are included in templates
   * dynamically rendered to the scope (after the first scope render), they will
   * not be scoped and the <style> will be left in the template and rendered
   * output.
   */

  const prepareTemplateStyles = (scopeName, renderedDOM, template) => {
    shadyRenderSet.add(scopeName); // If `renderedDOM` is stamped from a Template, then we need to edit that
    // Template's underlying template element. Otherwise, we create one here
    // to give to ShadyCSS, which still requires one while scoping.

    const templateElement = !!template ? template.element : document.createElement('template'); // Move styles out of rendered DOM and store.

    const styles = renderedDOM.querySelectorAll('style');
    const {
      length
    } = styles; // If there are no styles, skip unnecessary work

    if (length === 0) {
      // Ensure prepareTemplateStyles is called to support adding
      // styles via `prepareAdoptedCssText` since that requires that
      // `prepareTemplateStyles` is called.
      //
      // ShadyCSS will only update styles containing @apply in the template
      // given to `prepareTemplateStyles`. If no lit Template was given,
      // ShadyCSS will not be able to update uses of @apply in any relevant
      // template. However, this is not a problem because we only create the
      // template for the purpose of supporting `prepareAdoptedCssText`,
      // which doesn't support @apply at all.
      window.ShadyCSS.prepareTemplateStyles(templateElement, scopeName);
      return;
    }

    const condensedStyle = document.createElement('style'); // Collect styles into a single style. This helps us make sure ShadyCSS
    // manipulations will not prevent us from being able to fix up template
    // part indices.
    // NOTE: collecting styles is inefficient for browsers but ShadyCSS
    // currently does this anyway. When it does not, this should be changed.

    for (let i = 0; i < length; i++) {
      const style = styles[i];
      style.parentNode.removeChild(style);
      condensedStyle.textContent += style.textContent;
    } // Remove styles from nested templates in this scope.


    removeStylesFromLitTemplates(scopeName); // And then put the condensed style into the "root" template passed in as
    // `template`.

    const content = templateElement.content;

    if (!!template) {
      insertNodeIntoTemplate(template, condensedStyle, content.firstChild);
    } else {
      content.insertBefore(condensedStyle, content.firstChild);
    } // Note, it's important that ShadyCSS gets the template that `lit-html`
    // will actually render so that it can update the style inside when
    // needed (e.g. @apply native Shadow DOM case).


    window.ShadyCSS.prepareTemplateStyles(templateElement, scopeName);
    const style = content.querySelector('style');

    if (window.ShadyCSS.nativeShadow && style !== null) {
      // When in native Shadow DOM, ensure the style created by ShadyCSS is
      // included in initially rendered output (`renderedDOM`).
      renderedDOM.insertBefore(style.cloneNode(true), renderedDOM.firstChild);
    } else if (!!template) {
      // When no style is left in the template, parts will be broken as a
      // result. To fix this, we put back the style node ShadyCSS removed
      // and then tell lit to remove that node from the template.
      // There can be no style in the template in 2 cases (1) when Shady DOM
      // is in use, ShadyCSS removes all styles, (2) when native Shadow DOM
      // is in use ShadyCSS removes the style if it contains no content.
      // NOTE, ShadyCSS creates its own style so we can safely add/remove
      // `condensedStyle` here.
      content.insertBefore(condensedStyle, content.firstChild);
      const removes = new Set();
      removes.add(condensedStyle);
      removeNodesFromTemplate(template, removes);
    }
  };
  /**
   * Extension to the standard `render` method which supports rendering
   * to ShadowRoots when the ShadyDOM (https://github.com/webcomponents/shadydom)
   * and ShadyCSS (https://github.com/webcomponents/shadycss) polyfills are used
   * or when the webcomponentsjs
   * (https://github.com/webcomponents/webcomponentsjs) polyfill is used.
   *
   * Adds a `scopeName` option which is used to scope element DOM and stylesheets
   * when native ShadowDOM is unavailable. The `scopeName` will be added to
   * the class attribute of all rendered DOM. In addition, any style elements will
   * be automatically re-written with this `scopeName` selector and moved out
   * of the rendered DOM and into the document `<head>`.
   *
   * It is common to use this render method in conjunction with a custom element
   * which renders a shadowRoot. When this is done, typically the element's
   * `localName` should be used as the `scopeName`.
   *
   * In addition to DOM scoping, ShadyCSS also supports a basic shim for css
   * custom properties (needed only on older browsers like IE11) and a shim for
   * a deprecated feature called `@apply` that supports applying a set of css
   * custom properties to a given location.
   *
   * Usage considerations:
   *
   * * Part values in `<style>` elements are only applied the first time a given
   * `scopeName` renders. Subsequent changes to parts in style elements will have
   * no effect. Because of this, parts in style elements should only be used for
   * values that will never change, for example parts that set scope-wide theme
   * values or parts which render shared style elements.
   *
   * * Note, due to a limitation of the ShadyDOM polyfill, rendering in a
   * custom element's `constructor` is not supported. Instead rendering should
   * either done asynchronously, for example at microtask timing (for example
   * `Promise.resolve()`), or be deferred until the first time the element's
   * `connectedCallback` runs.
   *
   * Usage considerations when using shimmed custom properties or `@apply`:
   *
   * * Whenever any dynamic changes are made which affect
   * css custom properties, `ShadyCSS.styleElement(element)` must be called
   * to update the element. There are two cases when this is needed:
   * (1) the element is connected to a new parent, (2) a class is added to the
   * element that causes it to match different custom properties.
   * To address the first case when rendering a custom element, `styleElement`
   * should be called in the element's `connectedCallback`.
   *
   * * Shimmed custom properties may only be defined either for an entire
   * shadowRoot (for example, in a `:host` rule) or via a rule that directly
   * matches an element with a shadowRoot. In other words, instead of flowing from
   * parent to child as do native css custom properties, shimmed custom properties
   * flow only from shadowRoots to nested shadowRoots.
   *
   * * When using `@apply` mixing css shorthand property names with
   * non-shorthand names (for example `border` and `border-width`) is not
   * supported.
   */


  const render$1 = (result, container, options) => {
    if (!options || typeof options !== 'object' || !options.scopeName) {
      throw new Error('The `scopeName` option is required.');
    }

    const scopeName = options.scopeName;
    const hasRendered = parts.has(container);
    const needsScoping = compatibleShadyCSSVersion && container.nodeType === 11
    /* Node.DOCUMENT_FRAGMENT_NODE */
    && !!container.host; // Handle first render to a scope specially...

    const firstScopeRender = needsScoping && !shadyRenderSet.has(scopeName); // On first scope render, render into a fragment; this cannot be a single
    // fragment that is reused since nested renders can occur synchronously.

    const renderContainer = firstScopeRender ? document.createDocumentFragment() : container;
    render(result, renderContainer, Object.assign({
      templateFactory: shadyTemplateFactory(scopeName)
    }, options)); // When performing first scope render,
    // (1) We've rendered into a fragment so that there's a chance to
    // `prepareTemplateStyles` before sub-elements hit the DOM
    // (which might cause them to render based on a common pattern of
    // rendering in a custom element's `connectedCallback`);
    // (2) Scope the template with ShadyCSS one time only for this scope.
    // (3) Render the fragment into the container and make sure the
    // container knows its `part` is the one we just rendered. This ensures
    // DOM will be re-used on subsequent renders.

    if (firstScopeRender) {
      const part = parts.get(renderContainer);
      parts.delete(renderContainer); // ShadyCSS might have style sheets (e.g. from `prepareAdoptedCssText`)
      // that should apply to `renderContainer` even if the rendered value is
      // not a TemplateInstance. However, it will only insert scoped styles
      // into the document if `prepareTemplateStyles` has already been called
      // for the given scope name.

      const template = part.value instanceof TemplateInstance ? part.value.template : undefined;
      prepareTemplateStyles(scopeName, renderContainer, template);
      removeNodes(container, container.firstChild);
      container.appendChild(renderContainer);
      parts.set(container, part);
    } // After elements have hit the DOM, update styling if this is the
    // initial render to this container.
    // This is needed whenever dynamic changes are made so it would be
    // safest to do every render; however, this would regress performance
    // so we leave it up to the user to call `ShadyCSS.styleElement`
    // for dynamic changes.


    if (!hasRendered && needsScoping) {
      window.ShadyCSS.styleElement(container.host);
    }
  };

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  var _a;
  /**
   * When using Closure Compiler, JSCompiler_renameProperty(property, object) is
   * replaced at compile time by the munged name for object[property]. We cannot
   * alias this function, so we have to use a small shim that has the same
   * behavior when not compiling.
   */


  window.JSCompiler_renameProperty = (prop, _obj) => prop;

  const defaultConverter = {
    toAttribute(value, type) {
      switch (type) {
        case Boolean:
          return value ? '' : null;

        case Object:
        case Array:
          // if the value is `null` or `undefined` pass this through
          // to allow removing/no change behavior.
          return value == null ? value : JSON.stringify(value);
      }

      return value;
    },

    fromAttribute(value, type) {
      switch (type) {
        case Boolean:
          return value !== null;

        case Number:
          return value === null ? null : Number(value);

        case Object:
        case Array:
          return JSON.parse(value);
      }

      return value;
    }

  };
  /**
   * Change function that returns true if `value` is different from `oldValue`.
   * This method is used as the default for a property's `hasChanged` function.
   */

  const notEqual = (value, old) => {
    // This ensures (old==NaN, value==NaN) always returns false
    return old !== value && (old === old || value === value);
  };
  const defaultPropertyDeclaration = {
    attribute: true,
    type: String,
    converter: defaultConverter,
    reflect: false,
    hasChanged: notEqual
  };
  const STATE_HAS_UPDATED = 1;
  const STATE_UPDATE_REQUESTED = 1 << 2;
  const STATE_IS_REFLECTING_TO_ATTRIBUTE = 1 << 3;
  const STATE_IS_REFLECTING_TO_PROPERTY = 1 << 4;
  /**
   * The Closure JS Compiler doesn't currently have good support for static
   * property semantics where "this" is dynamic (e.g.
   * https://github.com/google/closure-compiler/issues/3177 and others) so we use
   * this hack to bypass any rewriting by the compiler.
   */

  const finalized = 'finalized';
  /**
   * Base element class which manages element properties and attributes. When
   * properties change, the `update` method is asynchronously called. This method
   * should be supplied by subclassers to render updates as desired.
   */

  class UpdatingElement extends HTMLElement {
    constructor() {
      super();
      this._updateState = 0;
      this._instanceProperties = undefined; // Initialize to an unresolved Promise so we can make sure the element has
      // connected before first update.

      this._updatePromise = new Promise(res => this._enableUpdatingResolver = res);
      /**
       * Map with keys for any properties that have changed since the last
       * update cycle with previous values.
       */

      this._changedProperties = new Map();
      /**
       * Map with keys of properties that should be reflected when updated.
       */

      this._reflectingProperties = undefined;
      this.initialize();
    }
    /**
     * Returns a list of attributes corresponding to the registered properties.
     * @nocollapse
     */


    static get observedAttributes() {
      // note: piggy backing on this to ensure we're finalized.
      this.finalize();
      const attributes = []; // Use forEach so this works even if for/of loops are compiled to for loops
      // expecting arrays

      this._classProperties.forEach((v, p) => {
        const attr = this._attributeNameForProperty(p, v);

        if (attr !== undefined) {
          this._attributeToPropertyMap.set(attr, p);

          attributes.push(attr);
        }
      });

      return attributes;
    }
    /**
     * Ensures the private `_classProperties` property metadata is created.
     * In addition to `finalize` this is also called in `createProperty` to
     * ensure the `@property` decorator can add property metadata.
     */

    /** @nocollapse */


    static _ensureClassProperties() {
      // ensure private storage for property declarations.
      if (!this.hasOwnProperty(JSCompiler_renameProperty('_classProperties', this))) {
        this._classProperties = new Map(); // NOTE: Workaround IE11 not supporting Map constructor argument.

        const superProperties = Object.getPrototypeOf(this)._classProperties;

        if (superProperties !== undefined) {
          superProperties.forEach((v, k) => this._classProperties.set(k, v));
        }
      }
    }
    /**
     * Creates a property accessor on the element prototype if one does not exist
     * and stores a PropertyDeclaration for the property with the given options.
     * The property setter calls the property's `hasChanged` property option
     * or uses a strict identity check to determine whether or not to request
     * an update.
     *
     * This method may be overridden to customize properties; however,
     * when doing so, it's important to call `super.createProperty` to ensure
     * the property is setup correctly. This method calls
     * `getPropertyDescriptor` internally to get a descriptor to install.
     * To customize what properties do when they are get or set, override
     * `getPropertyDescriptor`. To customize the options for a property,
     * implement `createProperty` like this:
     *
     * static createProperty(name, options) {
     *   options = Object.assign(options, {myOption: true});
     *   super.createProperty(name, options);
     * }
     *
     * @nocollapse
     */


    static createProperty(name, options = defaultPropertyDeclaration) {
      // Note, since this can be called by the `@property` decorator which
      // is called before `finalize`, we ensure storage exists for property
      // metadata.
      this._ensureClassProperties();

      this._classProperties.set(name, options); // Do not generate an accessor if the prototype already has one, since
      // it would be lost otherwise and that would never be the user's intention;
      // Instead, we expect users to call `requestUpdate` themselves from
      // user-defined accessors. Note that if the super has an accessor we will
      // still overwrite it


      if (options.noAccessor || this.prototype.hasOwnProperty(name)) {
        return;
      }

      const key = typeof name === 'symbol' ? Symbol() : `__${name}`;
      const descriptor = this.getPropertyDescriptor(name, key, options);

      if (descriptor !== undefined) {
        Object.defineProperty(this.prototype, name, descriptor);
      }
    }
    /**
     * Returns a property descriptor to be defined on the given named property.
     * If no descriptor is returned, the property will not become an accessor.
     * For example,
     *
     *   class MyElement extends LitElement {
     *     static getPropertyDescriptor(name, key, options) {
     *       const defaultDescriptor =
     *           super.getPropertyDescriptor(name, key, options);
     *       const setter = defaultDescriptor.set;
     *       return {
     *         get: defaultDescriptor.get,
     *         set(value) {
     *           setter.call(this, value);
     *           // custom action.
     *         },
     *         configurable: true,
     *         enumerable: true
     *       }
     *     }
     *   }
     *
     * @nocollapse
     */


    static getPropertyDescriptor(name, key, _options) {
      return {
        // tslint:disable-next-line:no-any no symbol in index
        get() {
          return this[key];
        },

        set(value) {
          const oldValue = this[name];
          this[key] = value;

          this._requestUpdate(name, oldValue);
        },

        configurable: true,
        enumerable: true
      };
    }
    /**
     * Returns the property options associated with the given property.
     * These options are defined with a PropertyDeclaration via the `properties`
     * object or the `@property` decorator and are registered in
     * `createProperty(...)`.
     *
     * Note, this method should be considered "final" and not overridden. To
     * customize the options for a given property, override `createProperty`.
     *
     * @nocollapse
     * @final
     */


    static getPropertyOptions(name) {
      return this._classProperties && this._classProperties.get(name) || defaultPropertyDeclaration;
    }
    /**
     * Creates property accessors for registered properties and ensures
     * any superclasses are also finalized.
     * @nocollapse
     */


    static finalize() {
      // finalize any superclasses
      const superCtor = Object.getPrototypeOf(this);

      if (!superCtor.hasOwnProperty(finalized)) {
        superCtor.finalize();
      }

      this[finalized] = true;

      this._ensureClassProperties(); // initialize Map populated in observedAttributes


      this._attributeToPropertyMap = new Map(); // make any properties
      // Note, only process "own" properties since this element will inherit
      // any properties defined on the superClass, and finalization ensures
      // the entire prototype chain is finalized.

      if (this.hasOwnProperty(JSCompiler_renameProperty('properties', this))) {
        const props = this.properties; // support symbols in properties (IE11 does not support this)

        const propKeys = [...Object.getOwnPropertyNames(props), ...(typeof Object.getOwnPropertySymbols === 'function' ? Object.getOwnPropertySymbols(props) : [])]; // This for/of is ok because propKeys is an array

        for (const p of propKeys) {
          // note, use of `any` is due to TypeSript lack of support for symbol in
          // index types
          // tslint:disable-next-line:no-any no symbol in index
          this.createProperty(p, props[p]);
        }
      }
    }
    /**
     * Returns the property name for the given attribute `name`.
     * @nocollapse
     */


    static _attributeNameForProperty(name, options) {
      const attribute = options.attribute;
      return attribute === false ? undefined : typeof attribute === 'string' ? attribute : typeof name === 'string' ? name.toLowerCase() : undefined;
    }
    /**
     * Returns true if a property should request an update.
     * Called when a property value is set and uses the `hasChanged`
     * option for the property if present or a strict identity check.
     * @nocollapse
     */


    static _valueHasChanged(value, old, hasChanged = notEqual) {
      return hasChanged(value, old);
    }
    /**
     * Returns the property value for the given attribute value.
     * Called via the `attributeChangedCallback` and uses the property's
     * `converter` or `converter.fromAttribute` property option.
     * @nocollapse
     */


    static _propertyValueFromAttribute(value, options) {
      const type = options.type;
      const converter = options.converter || defaultConverter;
      const fromAttribute = typeof converter === 'function' ? converter : converter.fromAttribute;
      return fromAttribute ? fromAttribute(value, type) : value;
    }
    /**
     * Returns the attribute value for the given property value. If this
     * returns undefined, the property will *not* be reflected to an attribute.
     * If this returns null, the attribute will be removed, otherwise the
     * attribute will be set to the value.
     * This uses the property's `reflect` and `type.toAttribute` property options.
     * @nocollapse
     */


    static _propertyValueToAttribute(value, options) {
      if (options.reflect === undefined) {
        return;
      }

      const type = options.type;
      const converter = options.converter;
      const toAttribute = converter && converter.toAttribute || defaultConverter.toAttribute;
      return toAttribute(value, type);
    }
    /**
     * Performs element initialization. By default captures any pre-set values for
     * registered properties.
     */


    initialize() {
      this._saveInstanceProperties(); // ensures first update will be caught by an early access of
      // `updateComplete`


      this._requestUpdate();
    }
    /**
     * Fixes any properties set on the instance before upgrade time.
     * Otherwise these would shadow the accessor and break these properties.
     * The properties are stored in a Map which is played back after the
     * constructor runs. Note, on very old versions of Safari (<=9) or Chrome
     * (<=41), properties created for native platform properties like (`id` or
     * `name`) may not have default values set in the element constructor. On
     * these browsers native properties appear on instances and therefore their
     * default value will overwrite any element default (e.g. if the element sets
     * this.id = 'id' in the constructor, the 'id' will become '' since this is
     * the native platform default).
     */


    _saveInstanceProperties() {
      // Use forEach so this works even if for/of loops are compiled to for loops
      // expecting arrays
      this.constructor._classProperties.forEach((_v, p) => {
        if (this.hasOwnProperty(p)) {
          const value = this[p];
          delete this[p];

          if (!this._instanceProperties) {
            this._instanceProperties = new Map();
          }

          this._instanceProperties.set(p, value);
        }
      });
    }
    /**
     * Applies previously saved instance properties.
     */


    _applyInstanceProperties() {
      // Use forEach so this works even if for/of loops are compiled to for loops
      // expecting arrays
      // tslint:disable-next-line:no-any
      this._instanceProperties.forEach((v, p) => this[p] = v);

      this._instanceProperties = undefined;
    }

    connectedCallback() {
      // Ensure first connection completes an update. Updates cannot complete
      // before connection.
      this.enableUpdating();
    }

    enableUpdating() {
      if (this._enableUpdatingResolver !== undefined) {
        this._enableUpdatingResolver();

        this._enableUpdatingResolver = undefined;
      }
    }
    /**
     * Allows for `super.disconnectedCallback()` in extensions while
     * reserving the possibility of making non-breaking feature additions
     * when disconnecting at some point in the future.
     */


    disconnectedCallback() {}
    /**
     * Synchronizes property values when attributes change.
     */


    attributeChangedCallback(name, old, value) {
      if (old !== value) {
        this._attributeToProperty(name, value);
      }
    }

    _propertyToAttribute(name, value, options = defaultPropertyDeclaration) {
      const ctor = this.constructor;

      const attr = ctor._attributeNameForProperty(name, options);

      if (attr !== undefined) {
        const attrValue = ctor._propertyValueToAttribute(value, options); // an undefined value does not change the attribute.


        if (attrValue === undefined) {
          return;
        } // Track if the property is being reflected to avoid
        // setting the property again via `attributeChangedCallback`. Note:
        // 1. this takes advantage of the fact that the callback is synchronous.
        // 2. will behave incorrectly if multiple attributes are in the reaction
        // stack at time of calling. However, since we process attributes
        // in `update` this should not be possible (or an extreme corner case
        // that we'd like to discover).
        // mark state reflecting


        this._updateState = this._updateState | STATE_IS_REFLECTING_TO_ATTRIBUTE;

        if (attrValue == null) {
          this.removeAttribute(attr);
        } else {
          this.setAttribute(attr, attrValue);
        } // mark state not reflecting


        this._updateState = this._updateState & ~STATE_IS_REFLECTING_TO_ATTRIBUTE;
      }
    }

    _attributeToProperty(name, value) {
      // Use tracking info to avoid deserializing attribute value if it was
      // just set from a property setter.
      if (this._updateState & STATE_IS_REFLECTING_TO_ATTRIBUTE) {
        return;
      }

      const ctor = this.constructor; // Note, hint this as an `AttributeMap` so closure clearly understands
      // the type; it has issues with tracking types through statics
      // tslint:disable-next-line:no-unnecessary-type-assertion

      const propName = ctor._attributeToPropertyMap.get(name);

      if (propName !== undefined) {
        const options = ctor.getPropertyOptions(propName); // mark state reflecting

        this._updateState = this._updateState | STATE_IS_REFLECTING_TO_PROPERTY;
        this[propName] = // tslint:disable-next-line:no-any
        ctor._propertyValueFromAttribute(value, options); // mark state not reflecting

        this._updateState = this._updateState & ~STATE_IS_REFLECTING_TO_PROPERTY;
      }
    }
    /**
     * This private version of `requestUpdate` does not access or return the
     * `updateComplete` promise. This promise can be overridden and is therefore
     * not free to access.
     */


    _requestUpdate(name, oldValue) {
      let shouldRequestUpdate = true; // If we have a property key, perform property update steps.

      if (name !== undefined) {
        const ctor = this.constructor;
        const options = ctor.getPropertyOptions(name);

        if (ctor._valueHasChanged(this[name], oldValue, options.hasChanged)) {
          if (!this._changedProperties.has(name)) {
            this._changedProperties.set(name, oldValue);
          } // Add to reflecting properties set.
          // Note, it's important that every change has a chance to add the
          // property to `_reflectingProperties`. This ensures setting
          // attribute + property reflects correctly.


          if (options.reflect === true && !(this._updateState & STATE_IS_REFLECTING_TO_PROPERTY)) {
            if (this._reflectingProperties === undefined) {
              this._reflectingProperties = new Map();
            }

            this._reflectingProperties.set(name, options);
          }
        } else {
          // Abort the request if the property should not be considered changed.
          shouldRequestUpdate = false;
        }
      }

      if (!this._hasRequestedUpdate && shouldRequestUpdate) {
        this._updatePromise = this._enqueueUpdate();
      }
    }
    /**
     * Requests an update which is processed asynchronously. This should
     * be called when an element should update based on some state not triggered
     * by setting a property. In this case, pass no arguments. It should also be
     * called when manually implementing a property setter. In this case, pass the
     * property `name` and `oldValue` to ensure that any configured property
     * options are honored. Returns the `updateComplete` Promise which is resolved
     * when the update completes.
     *
     * @param name {PropertyKey} (optional) name of requesting property
     * @param oldValue {any} (optional) old value of requesting property
     * @returns {Promise} A Promise that is resolved when the update completes.
     */


    requestUpdate(name, oldValue) {
      this._requestUpdate(name, oldValue);

      return this.updateComplete;
    }
    /**
     * Sets up the element to asynchronously update.
     */


    async _enqueueUpdate() {
      this._updateState = this._updateState | STATE_UPDATE_REQUESTED;

      try {
        // Ensure any previous update has resolved before updating.
        // This `await` also ensures that property changes are batched.
        await this._updatePromise;
      } catch (e) {// Ignore any previous errors. We only care that the previous cycle is
        // done. Any error should have been handled in the previous update.
      }

      const result = this.performUpdate(); // If `performUpdate` returns a Promise, we await it. This is done to
      // enable coordinating updates with a scheduler. Note, the result is
      // checked to avoid delaying an additional microtask unless we need to.

      if (result != null) {
        await result;
      }

      return !this._hasRequestedUpdate;
    }

    get _hasRequestedUpdate() {
      return this._updateState & STATE_UPDATE_REQUESTED;
    }

    get hasUpdated() {
      return this._updateState & STATE_HAS_UPDATED;
    }
    /**
     * Performs an element update. Note, if an exception is thrown during the
     * update, `firstUpdated` and `updated` will not be called.
     *
     * You can override this method to change the timing of updates. If this
     * method is overridden, `super.performUpdate()` must be called.
     *
     * For instance, to schedule updates to occur just before the next frame:
     *
     * ```
     * protected async performUpdate(): Promise<unknown> {
     *   await new Promise((resolve) => requestAnimationFrame(() => resolve()));
     *   super.performUpdate();
     * }
     * ```
     */


    performUpdate() {
      // Mixin instance properties once, if they exist.
      if (this._instanceProperties) {
        this._applyInstanceProperties();
      }

      let shouldUpdate = false;
      const changedProperties = this._changedProperties;

      try {
        shouldUpdate = this.shouldUpdate(changedProperties);

        if (shouldUpdate) {
          this.update(changedProperties);
        } else {
          this._markUpdated();
        }
      } catch (e) {
        // Prevent `firstUpdated` and `updated` from running when there's an
        // update exception.
        shouldUpdate = false; // Ensure element can accept additional updates after an exception.

        this._markUpdated();

        throw e;
      }

      if (shouldUpdate) {
        if (!(this._updateState & STATE_HAS_UPDATED)) {
          this._updateState = this._updateState | STATE_HAS_UPDATED;
          this.firstUpdated(changedProperties);
        }

        this.updated(changedProperties);
      }
    }

    _markUpdated() {
      this._changedProperties = new Map();
      this._updateState = this._updateState & ~STATE_UPDATE_REQUESTED;
    }
    /**
     * Returns a Promise that resolves when the element has completed updating.
     * The Promise value is a boolean that is `true` if the element completed the
     * update without triggering another update. The Promise result is `false` if
     * a property was set inside `updated()`. If the Promise is rejected, an
     * exception was thrown during the update.
     *
     * To await additional asynchronous work, override the `_getUpdateComplete`
     * method. For example, it is sometimes useful to await a rendered element
     * before fulfilling this Promise. To do this, first await
     * `super._getUpdateComplete()`, then any subsequent state.
     *
     * @returns {Promise} The Promise returns a boolean that indicates if the
     * update resolved without triggering another update.
     */


    get updateComplete() {
      return this._getUpdateComplete();
    }
    /**
     * Override point for the `updateComplete` promise.
     *
     * It is not safe to override the `updateComplete` getter directly due to a
     * limitation in TypeScript which means it is not possible to call a
     * superclass getter (e.g. `super.updateComplete.then(...)`) when the target
     * language is ES5 (https://github.com/microsoft/TypeScript/issues/338).
     * This method should be overridden instead. For example:
     *
     *   class MyElement extends LitElement {
     *     async _getUpdateComplete() {
     *       await super._getUpdateComplete();
     *       await this._myChild.updateComplete;
     *     }
     *   }
     */


    _getUpdateComplete() {
      return this._updatePromise;
    }
    /**
     * Controls whether or not `update` should be called when the element requests
     * an update. By default, this method always returns `true`, but this can be
     * customized to control when to update.
     *
     * @param _changedProperties Map of changed properties with old values
     */


    shouldUpdate(_changedProperties) {
      return true;
    }
    /**
     * Updates the element. This method reflects property values to attributes.
     * It can be overridden to render and keep updated element DOM.
     * Setting properties inside this method will *not* trigger
     * another update.
     *
     * @param _changedProperties Map of changed properties with old values
     */


    update(_changedProperties) {
      if (this._reflectingProperties !== undefined && this._reflectingProperties.size > 0) {
        // Use forEach so this works even if for/of loops are compiled to for
        // loops expecting arrays
        this._reflectingProperties.forEach((v, k) => this._propertyToAttribute(k, this[k], v));

        this._reflectingProperties = undefined;
      }

      this._markUpdated();
    }
    /**
     * Invoked whenever the element is updated. Implement to perform
     * post-updating tasks via DOM APIs, for example, focusing an element.
     *
     * Setting properties inside this method will trigger the element to update
     * again after this update cycle completes.
     *
     * @param _changedProperties Map of changed properties with old values
     */


    updated(_changedProperties) {}
    /**
     * Invoked when the element is first updated. Implement to perform one time
     * work on the element after update.
     *
     * Setting properties inside this method will trigger the element to update
     * again after this update cycle completes.
     *
     * @param _changedProperties Map of changed properties with old values
     */


    firstUpdated(_changedProperties) {}

  }
  _a = finalized;
  /**
   * Marks class as having finished creating properties.
   */

  UpdatingElement[_a] = true;

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  const legacyCustomElement = (tagName, clazz) => {
    window.customElements.define(tagName, clazz); // Cast as any because TS doesn't recognize the return type as being a
    // subtype of the decorated class when clazz is typed as
    // `Constructor<HTMLElement>` for some reason.
    // `Constructor<HTMLElement>` is helpful to make sure the decorator is
    // applied to elements however.
    // tslint:disable-next-line:no-any

    return clazz;
  };

  const standardCustomElement = (tagName, descriptor) => {
    const {
      kind,
      elements
    } = descriptor;
    return {
      kind,
      elements,

      // This callback is called once the class is otherwise fully defined
      finisher(clazz) {
        window.customElements.define(tagName, clazz);
      }

    };
  };
  /**
   * Class decorator factory that defines the decorated class as a custom element.
   *
   * ```
   * @customElement('my-element')
   * class MyElement {
   *   render() {
   *     return html``;
   *   }
   * }
   * ```
   *
   * @param tagName The name of the custom element to define.
   */


  const customElement = tagName => classOrDescriptor => typeof classOrDescriptor === 'function' ? legacyCustomElement(tagName, classOrDescriptor) : standardCustomElement(tagName, classOrDescriptor);

  const standardProperty = (options, element) => {
    // When decorating an accessor, pass it through and add property metadata.
    // Note, the `hasOwnProperty` check in `createProperty` ensures we don't
    // stomp over the user's accessor.
    if (element.kind === 'method' && element.descriptor && !('value' in element.descriptor)) {
      return Object.assign(Object.assign({}, element), {
        finisher(clazz) {
          clazz.createProperty(element.key, options);
        }

      });
    } else {
      // createProperty() takes care of defining the property, but we still
      // must return some kind of descriptor, so return a descriptor for an
      // unused prototype field. The finisher calls createProperty().
      return {
        kind: 'field',
        key: Symbol(),
        placement: 'own',
        descriptor: {},

        // When @babel/plugin-proposal-decorators implements initializers,
        // do this instead of the initializer below. See:
        // https://github.com/babel/babel/issues/9260 extras: [
        //   {
        //     kind: 'initializer',
        //     placement: 'own',
        //     initializer: descriptor.initializer,
        //   }
        // ],
        initializer() {
          if (typeof element.initializer === 'function') {
            this[element.key] = element.initializer.call(this);
          }
        },

        finisher(clazz) {
          clazz.createProperty(element.key, options);
        }

      };
    }
  };

  const legacyProperty = (options, proto, name) => {
    proto.constructor.createProperty(name, options);
  };
  /**
   * A property decorator which creates a LitElement property which reflects a
   * corresponding attribute value. A `PropertyDeclaration` may optionally be
   * supplied to configure property features.
   *
   * This decorator should only be used for public fields. Private or protected
   * fields should use the internalProperty decorator.
   *
   * @example
   *
   *     class MyElement {
   *       @property({ type: Boolean })
   *       clicked = false;
   *     }
   *
   * @ExportDecoratedItems
   */


  function property(options) {
    // tslint:disable-next-line:no-any decorator
    return (protoOrDescriptor, name) => name !== undefined ? legacyProperty(options, protoOrDescriptor, name) : standardProperty(options, protoOrDescriptor);
  }
  /**
   * Declares a private or protected property that still triggers updates to the
   * element when it changes.
   *
   * Properties declared this way must not be used from HTML or HTML templating
   * systems, they're solely for properties internal to the element. These
   * properties may be renamed by optimization tools like closure compiler.
   */

  function internalProperty(options) {
    return property({
      attribute: false,
      hasChanged: options === null || options === void 0 ? void 0 : options.hasChanged
    });
  }
  /**
   * A property decorator that converts a class property into a getter that
   * executes a querySelector on the element's renderRoot.
   *
   * @param selector A DOMString containing one or more selectors to match.
   *
   * See: https://developer.mozilla.org/en-US/docs/Web/API/Document/querySelector
   *
   * @example
   *
   *     class MyElement {
   *       @query('#first')
   *       first;
   *
   *       render() {
   *         return html`
   *           <div id="first"></div>
   *           <div id="second"></div>
   *         `;
   *       }
   *     }
   *
   */

  function query(selector) {
    return (protoOrDescriptor, // tslint:disable-next-line:no-any decorator
    name) => {
      const descriptor = {
        get() {
          return this.renderRoot.querySelector(selector);
        },

        enumerable: true,
        configurable: true
      };
      return name !== undefined ? legacyQuery(descriptor, protoOrDescriptor, name) : standardQuery(descriptor, protoOrDescriptor);
    };
  } // Note, in the future, we may extend this decorator to support the use case
  // where the queried element may need to do work to become ready to interact
  // with (e.g. load some implementation code). If so, we might elect to
  // add a second argument defining a function that can be run to make the
  // queried element loaded/updated/ready.

  /**
   * A property decorator that converts a class property into a getter that
   * returns a promise that resolves to the result of a querySelector on the
   * element's renderRoot done after the element's `updateComplete` promise
   * resolves. When the queried property may change with element state, this
   * decorator can be used instead of requiring users to await the
   * `updateComplete` before accessing the property.
   *
   * @param selector A DOMString containing one or more selectors to match.
   *
   * See: https://developer.mozilla.org/en-US/docs/Web/API/Document/querySelector
   *
   * @example
   *
   *     class MyElement {
   *       @queryAsync('#first')
   *       first;
   *
   *       render() {
   *         return html`
   *           <div id="first"></div>
   *           <div id="second"></div>
   *         `;
   *       }
   *     }
   *
   *     // external usage
   *     async doSomethingWithFirst() {
   *      (await aMyElement.first).doSomething();
   *     }
   */

  function queryAsync(selector) {
    return (protoOrDescriptor, // tslint:disable-next-line:no-any decorator
    name) => {
      const descriptor = {
        async get() {
          await this.updateComplete;
          return this.renderRoot.querySelector(selector);
        },

        enumerable: true,
        configurable: true
      };
      return name !== undefined ? legacyQuery(descriptor, protoOrDescriptor, name) : standardQuery(descriptor, protoOrDescriptor);
    };
  }

  const legacyQuery = (descriptor, proto, name) => {
    Object.defineProperty(proto, name, descriptor);
  };

  const standardQuery = (descriptor, element) => ({
    kind: 'method',
    placement: 'prototype',
    key: element.key,
    descriptor
  });

  const standardEventOptions = (options, element) => {
    return Object.assign(Object.assign({}, element), {
      finisher(clazz) {
        Object.assign(clazz.prototype[element.key], options);
      }

    });
  };

  const legacyEventOptions = // tslint:disable-next-line:no-any legacy decorator
  (options, proto, name) => {
    Object.assign(proto[name], options);
  };
  /**
   * Adds event listener options to a method used as an event listener in a
   * lit-html template.
   *
   * @param options An object that specifies event listener options as accepted by
   * `EventTarget#addEventListener` and `EventTarget#removeEventListener`.
   *
   * Current browsers support the `capture`, `passive`, and `once` options. See:
   * https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#Parameters
   *
   * @example
   *
   *     class MyElement {
   *       clicked = false;
   *
   *       render() {
   *         return html`
   *           <div @click=${this._onClick}`>
   *             <button></button>
   *           </div>
   *         `;
   *       }
   *
   *       @eventOptions({capture: true})
   *       _onClick(e) {
   *         this.clicked = true;
   *       }
   *     }
   */


  function eventOptions(options) {
    // Return value typed as any to prevent TypeScript from complaining that
    // standard decorator function signature does not match TypeScript decorator
    // signature
    // TODO(kschaaf): unclear why it was only failing on this decorator and not
    // the others
    return (protoOrDescriptor, name) => name !== undefined ? legacyEventOptions(options, protoOrDescriptor, name) : standardEventOptions(options, protoOrDescriptor);
  }

  /**
  @license
  Copyright (c) 2019 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at
  http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
  http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
  found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
  part of the polymer project is also subject to an additional IP rights grant
  found at http://polymer.github.io/PATENTS.txt
  */
  const supportsAdoptingStyleSheets = 'adoptedStyleSheets' in Document.prototype && 'replace' in CSSStyleSheet.prototype;
  const constructionToken = Symbol();
  class CSSResult {
    constructor(cssText, safeToken) {
      if (safeToken !== constructionToken) {
        throw new Error('CSSResult is not constructable. Use `unsafeCSS` or `css` instead.');
      }

      this.cssText = cssText;
    } // Note, this is a getter so that it's lazy. In practice, this means
    // stylesheets are not created until the first element instance is made.


    get styleSheet() {
      if (this._styleSheet === undefined) {
        // Note, if `adoptedStyleSheets` is supported then we assume CSSStyleSheet
        // is constructable.
        if (supportsAdoptingStyleSheets) {
          this._styleSheet = new CSSStyleSheet();

          this._styleSheet.replaceSync(this.cssText);
        } else {
          this._styleSheet = null;
        }
      }

      return this._styleSheet;
    }

    toString() {
      return this.cssText;
    }

  }
  /**
   * Wrap a value for interpolation in a css tagged template literal.
   *
   * This is unsafe because untrusted CSS text can be used to phone home
   * or exfiltrate data to an attacker controlled site. Take care to only use
   * this with trusted input.
   */

  const unsafeCSS = value => {
    return new CSSResult(String(value), constructionToken);
  };

  const textFromCSSResult = value => {
    if (value instanceof CSSResult) {
      return value.cssText;
    } else if (typeof value === 'number') {
      return value;
    } else {
      throw new Error(`Value passed to 'css' function must be a 'css' function result: ${value}. Use 'unsafeCSS' to pass non-literal values, but
            take care to ensure page security.`);
    }
  };
  /**
   * Template tag which which can be used with LitElement's `style` property to
   * set element styles. For security reasons, only literal string values may be
   * used. To incorporate non-literal values `unsafeCSS` may be used inside a
   * template string part.
   */


  const css = (strings, ...values) => {
    const cssText = values.reduce((acc, v, idx) => acc + textFromCSSResult(v) + strings[idx + 1], strings[0]);
    return new CSSResult(cssText, constructionToken);
  };

  /**
   * @license
   * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt
   * The complete set of authors may be found at
   * http://polymer.github.io/AUTHORS.txt
   * The complete set of contributors may be found at
   * http://polymer.github.io/CONTRIBUTORS.txt
   * Code distributed by Google as part of the polymer project is also
   * subject to an additional IP rights grant found at
   * http://polymer.github.io/PATENTS.txt
   */
  // This line will be used in regexes to search for LitElement usage.
  // TODO(justinfagnani): inject version number at build time

  (window['litElementVersions'] || (window['litElementVersions'] = [])).push('2.3.1');
  /**
   * Sentinal value used to avoid calling lit-html's render function when
   * subclasses do not implement `render`
   */

  const renderNotImplemented = {};
  class LitElement extends UpdatingElement {
    /**
     * Return the array of styles to apply to the element.
     * Override this method to integrate into a style management system.
     *
     * @nocollapse
     */
    static getStyles() {
      return this.styles;
    }
    /** @nocollapse */


    static _getUniqueStyles() {
      // Only gather styles once per class
      if (this.hasOwnProperty(JSCompiler_renameProperty('_styles', this))) {
        return;
      } // Take care not to call `this.getStyles()` multiple times since this
      // generates new CSSResults each time.
      // TODO(sorvell): Since we do not cache CSSResults by input, any
      // shared styles will generate new stylesheet objects, which is wasteful.
      // This should be addressed when a browser ships constructable
      // stylesheets.


      const userStyles = this.getStyles();

      if (userStyles === undefined) {
        this._styles = [];
      } else if (Array.isArray(userStyles)) {
        // De-duplicate styles preserving the _last_ instance in the set.
        // This is a performance optimization to avoid duplicated styles that can
        // occur especially when composing via subclassing.
        // The last item is kept to try to preserve the cascade order with the
        // assumption that it's most important that last added styles override
        // previous styles.
        const addStyles = (styles, set) => styles.reduceRight((set, s) => // Note: On IE set.add() does not return the set
        Array.isArray(s) ? addStyles(s, set) : (set.add(s), set), set); // Array.from does not work on Set in IE, otherwise return
        // Array.from(addStyles(userStyles, new Set<CSSResult>())).reverse()


        const set = addStyles(userStyles, new Set());
        const styles = [];
        set.forEach(v => styles.unshift(v));
        this._styles = styles;
      } else {
        this._styles = [userStyles];
      }
    }
    /**
     * Performs element initialization. By default this calls `createRenderRoot`
     * to create the element `renderRoot` node and captures any pre-set values for
     * registered properties.
     */


    initialize() {
      super.initialize();

      this.constructor._getUniqueStyles();

      this.renderRoot = this.createRenderRoot(); // Note, if renderRoot is not a shadowRoot, styles would/could apply to the
      // element's getRootNode(). While this could be done, we're choosing not to
      // support this now since it would require different logic around de-duping.

      if (window.ShadowRoot && this.renderRoot instanceof window.ShadowRoot) {
        this.adoptStyles();
      }
    }
    /**
     * Returns the node into which the element should render and by default
     * creates and returns an open shadowRoot. Implement to customize where the
     * element's DOM is rendered. For example, to render into the element's
     * childNodes, return `this`.
     * @returns {Element|DocumentFragment} Returns a node into which to render.
     */


    createRenderRoot() {
      return this.attachShadow({
        mode: 'open'
      });
    }
    /**
     * Applies styling to the element shadowRoot using the `static get styles`
     * property. Styling will apply using `shadowRoot.adoptedStyleSheets` where
     * available and will fallback otherwise. When Shadow DOM is polyfilled,
     * ShadyCSS scopes styles and adds them to the document. When Shadow DOM
     * is available but `adoptedStyleSheets` is not, styles are appended to the
     * end of the `shadowRoot` to [mimic spec
     * behavior](https://wicg.github.io/construct-stylesheets/#using-constructed-stylesheets).
     */


    adoptStyles() {
      const styles = this.constructor._styles;

      if (styles.length === 0) {
        return;
      } // There are three separate cases here based on Shadow DOM support.
      // (1) shadowRoot polyfilled: use ShadyCSS
      // (2) shadowRoot.adoptedStyleSheets available: use it.
      // (3) shadowRoot.adoptedStyleSheets polyfilled: append styles after
      // rendering


      if (window.ShadyCSS !== undefined && !window.ShadyCSS.nativeShadow) {
        window.ShadyCSS.ScopingShim.prepareAdoptedCssText(styles.map(s => s.cssText), this.localName);
      } else if (supportsAdoptingStyleSheets) {
        this.renderRoot.adoptedStyleSheets = styles.map(s => s.styleSheet);
      } else {
        // This must be done after rendering so the actual style insertion is done
        // in `update`.
        this._needsShimAdoptedStyleSheets = true;
      }
    }

    connectedCallback() {
      super.connectedCallback(); // Note, first update/render handles styleElement so we only call this if
      // connected after first update.

      if (this.hasUpdated && window.ShadyCSS !== undefined) {
        window.ShadyCSS.styleElement(this);
      }
    }
    /**
     * Updates the element. This method reflects property values to attributes
     * and calls `render` to render DOM via lit-html. Setting properties inside
     * this method will *not* trigger another update.
     * @param _changedProperties Map of changed properties with old values
     */


    update(changedProperties) {
      // Setting properties in `render` should not trigger an update. Since
      // updates are allowed after super.update, it's important to call `render`
      // before that.
      const templateResult = this.render();
      super.update(changedProperties); // If render is not implemented by the component, don't call lit-html render

      if (templateResult !== renderNotImplemented) {
        this.constructor.render(templateResult, this.renderRoot, {
          scopeName: this.localName,
          eventContext: this
        });
      } // When native Shadow DOM is used but adoptedStyles are not supported,
      // insert styling after rendering to ensure adoptedStyles have highest
      // priority.


      if (this._needsShimAdoptedStyleSheets) {
        this._needsShimAdoptedStyleSheets = false;

        this.constructor._styles.forEach(s => {
          const style = document.createElement('style');
          style.textContent = s.cssText;
          this.renderRoot.appendChild(style);
        });
      }
    }
    /**
     * Invoked on each update to perform rendering tasks. This method may return
     * any value renderable by lit-html's NodePart - typically a TemplateResult.
     * Setting properties inside this method will *not* trigger the element to
     * update.
     */


    render() {
      return renderNotImplemented;
    }

  }
  /**
   * Ensure this class is marked as `finalized` as an optimization ensuring
   * it will not needlessly try to `finalize`.
   *
   * Note this property name is a string to prevent breaking Closure JS Compiler
   * optimizations. See updating-element.ts for more information.
   */

  LitElement['finalized'] = true;
  /**
   * Render method used to render the value to the element's DOM.
   * @param result The value to render.
   * @param container Node into which to render.
   * @param options Element name.
   * @nocollapse
   */

  LitElement.render = render$1;

  // Polymer legacy event helpers used courtesy of the Polymer project.
  //
  // Copyright (c) 2017 The Polymer Authors. All rights reserved.
  //
  // Redistribution and use in source and binary forms, with or without
  // modification, are permitted provided that the following conditions are
  // met:
  //
  //    * Redistributions of source code must retain the above copyright
  // notice, this list of conditions and the following disclaimer.
  //    * Redistributions in binary form must reproduce the above
  // copyright notice, this list of conditions and the following disclaimer
  // in the documentation and/or other materials provided with the
  // distribution.
  //    * Neither the name of Google Inc. nor the names of its
  // contributors may be used to endorse or promote products derived from
  // this software without specific prior written permission.
  //
  // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  // "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  // LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  // A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  // OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  // SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  // LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  // DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  // THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  // (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  /**
   * Dispatches a custom event with an optional detail value.
   *
   * @param {string} type Name of event type.
   * @param {*=} detail Detail value containing event-specific
   *   payload.
   * @param {{ bubbles: (boolean|undefined),
   *           cancelable: (boolean|undefined),
   *           composed: (boolean|undefined) }=}
   *  options Object specifying options.  These may include:
   *  `bubbles` (boolean, defaults to `true`),
   *  `cancelable` (boolean, defaults to false), and
   *  `node` on which to fire the event (HTMLElement, defaults to `this`).
   * @return {Event} The new event that was fired.
   */
  const fireEvent = (node, type, detail, options) => {
    options = options || {}; // @ts-ignore

    detail = detail === null || detail === undefined ? {} : detail;
    const event = new Event(type, {
      bubbles: options.bubbles === undefined ? true : options.bubbles,
      cancelable: Boolean(options.cancelable),
      composed: options.composed === undefined ? true : options.composed
    });
    event.detail = detail;
    node.dispatchEvent(event);
    return event;
  };

  const navigate = (_node, path, replace = false) => {
    if (__DEMO__) {
      if (replace) {
        history.replaceState(null, "", `${location.pathname}#${path}`);
      } else {
        window.location.hash = path;
      }
    } else if (replace) {
      history.replaceState(null, "", path);
    } else {
      history.pushState(null, "", path);
    }

    fireEvent(window, "location-changed", {
      replace
    });
  };

  const darkStyles = {
    "primary-background-color": "#111111",
    "card-background-color": "#1c1c1c",
    "secondary-background-color": "#1e1e1e",
    "primary-text-color": "#e1e1e1",
    "secondary-text-color": "#9b9b9b",
    "app-header-text-color": "#e1e1e1",
    "app-header-background-color": "#1c1c1c",
    "switch-unchecked-button-color": "#999999",
    "switch-unchecked-track-color": "#9b9b9b",
    "divider-color": "rgba(225, 225, 225, .12)"
  };
  const derivedStyles = {
    "error-state-color": "var(--error-color)",
    "state-icon-unavailable-color": "var(--disabled-text-color)",
    "sidebar-text-color": "var(--primary-text-color)",
    "sidebar-background-color": "var(--card-background-color)",
    "sidebar-selected-text-color": "var(--primary-color)",
    "sidebar-selected-icon-color": "var(--primary-color)",
    "sidebar-icon-color": "rgba(var(--rgb-primary-text-color), 0.6)",
    "switch-checked-color": "var(--primary-color)",
    "switch-checked-button-color": "var(--switch-checked-color, var(--primary-background-color))",
    "switch-checked-track-color": "var(--switch-checked-color, #000000)",
    "switch-unchecked-button-color": "var(--switch-unchecked-color, var(--primary-background-color))",
    "switch-unchecked-track-color": "var(--switch-unchecked-color, #000000)",
    "slider-color": "var(--primary-color)",
    "slider-secondary-color": "var(--light-primary-color)",
    "slider-bar-color": "var(--disabled-text-color)",
    "label-badge-grey": "var(--paper-grey-500)",
    "label-badge-background-color": "var(--card-background-color)",
    "label-badge-text-color": "rgba(var(--rgb-primary-text-color), 0.8)",
    "paper-listbox-background-color": "var(--card-background-color)",
    "paper-item-icon-color": "var(--state-icon-color)",
    "paper-item-icon-active-color": "var(--state-icon-active-color)",
    "table-row-background-color": "var(--primary-background-color)",
    "table-row-alternative-background-color": "var(--secondary-background-color)",
    "paper-slider-knob-color": "var(--slider-color)",
    "paper-slider-knob-start-color": "var(--slider-color)",
    "paper-slider-pin-color": "var(--slider-color)",
    "paper-slider-active-color": "var(--slider-color)",
    "paper-slider-secondary-color": "var(--slider-secondary-color)",
    "paper-slider-container-color": "var(--slider-bar-color)",
    "data-table-background-color": "var(--card-background-color)",
    "markdown-code-background-color": "var(--primary-background-color)",
    "mdc-theme-primary": "var(--primary-color)",
    "mdc-theme-secondary": "var(--accent-color)",
    "mdc-theme-background": "var(--primary-background-color)",
    "mdc-theme-surface": "var(--card-background-color)",
    "mdc-theme-on-primary": "var(--text-primary-color)",
    "mdc-theme-on-secondary": "var(--text-primary-color)",
    "mdc-theme-on-surface": "var(--primary-text-color)",
    "mdc-theme-text-primary-on-background": "var(--primary-text-color)",
    "app-header-text-color": "var(--text-primary-color)",
    "app-header-background-color": "var(--primary-color)",
    "material-body-text-color": "var(--primary-text-color)",
    "material-background-color": "var(--card-background-color)",
    "material-secondary-background-color": "var(--secondary-background-color)",
    "mdc-checkbox-unchecked-color": "rgba(var(--rgb-primary-text-color), 0.54)",
    "mdc-checkbox-disabled-color": "var(--disabled-text-color)",
    "mdc-radio-unchecked-color": "rgba(var(--rgb-primary-text-color), 0.54)",
    "mdc-radio-disabled-color": "var(--disabled-text-color)",
    "mdc-tab-text-label-color-default": "var(--primary-text-color)"
  };
  const haStyle = css`
  :host {
    font-family: var(--paper-font-body1_-_font-family);
    -webkit-font-smoothing: var(--paper-font-body1_-_-webkit-font-smoothing);
    font-size: var(--paper-font-body1_-_font-size);
    font-weight: var(--paper-font-body1_-_font-weight);
    line-height: var(--paper-font-body1_-_line-height);
  }

  app-header-layout,
  ha-app-layout {
    background-color: var(--primary-background-color);
  }

  app-header,
  app-toolbar {
    background-color: var(--app-header-background-color);
    font-weight: 400;
    color: var(--app-header-text-color, white);
  }

  app-toolbar ha-menu-button + [main-title],
  app-toolbar ha-icon-button-arrow-prev + [main-title],
  app-toolbar ha-icon-button + [main-title] {
    margin-left: 24px;
  }

  h1 {
    font-family: var(--paper-font-headline_-_font-family);
    -webkit-font-smoothing: var(--paper-font-headline_-_-webkit-font-smoothing);
    white-space: var(--paper-font-headline_-_white-space);
    overflow: var(--paper-font-headline_-_overflow);
    text-overflow: var(--paper-font-headline_-_text-overflow);
    font-size: var(--paper-font-headline_-_font-size);
    font-weight: var(--paper-font-headline_-_font-weight);
    line-height: var(--paper-font-headline_-_line-height);
  }

  h2 {
    font-family: var(--paper-font-title_-_font-family);
    -webkit-font-smoothing: var(--paper-font-title_-_-webkit-font-smoothing);
    white-space: var(--paper-font-title_-_white-space);
    overflow: var(--paper-font-title_-_overflow);
    text-overflow: var(--paper-font-title_-_text-overflow);
    font-size: var(--paper-font-title_-_font-size);
    font-weight: var(--paper-font-title_-_font-weight);
    line-height: var(--paper-font-title_-_line-height);
  }

  h3 {
    font-family: var(--paper-font-subhead_-_font-family);
    -webkit-font-smoothing: var(--paper-font-subhead_-_-webkit-font-smoothing);
    white-space: var(--paper-font-subhead_-_white-space);
    overflow: var(--paper-font-subhead_-_overflow);
    text-overflow: var(--paper-font-subhead_-_text-overflow);
    font-size: var(--paper-font-subhead_-_font-size);
    font-weight: var(--paper-font-subhead_-_font-weight);
    line-height: var(--paper-font-subhead_-_line-height);
  }

  a {
    color: var(--primary-color);
  }

  .secondary {
    color: var(--secondary-text-color);
  }

  .error {
    color: var(--error-color);
  }

  .warning {
    color: var(--error-color);
  }

  mwc-button.warning {
    --mdc-theme-primary: var(--error-color);
  }

  button.link {
    background: none;
    color: inherit;
    border: none;
    padding: 0;
    font: inherit;
    text-align: left;
    text-decoration: underline;
    cursor: pointer;
  }

  .card-actions a {
    text-decoration: none;
  }

  .card-actions .warning {
    --mdc-theme-primary: var(--error-color);
  }

  .layout.horizontal,
  .layout.vertical {
    display: flex;
  }
  .layout.inline {
    display: inline-flex;
  }
  .layout.horizontal {
    flex-direction: row;
  }
  .layout.vertical {
    flex-direction: column;
  }
  .layout.wrap {
    flex-wrap: wrap;
  }
  .layout.no-wrap {
    flex-wrap: nowrap;
  }
  .layout.center,
  .layout.center-center {
    align-items: center;
  }
  .layout.bottom {
    align-items: flex-end;
  }
  .layout.center-justified,
  .layout.center-center {
    justify-content: center;
  }
  .flex {
    flex: 1;
    flex-basis: 0.000000001px;
  }
  .flex-auto {
    flex: 1 1 auto;
  }
  .flex-none {
    flex: none;
  }
  .layout.justified {
    justify-content: space-between;
  }
`;
  const haStyleDialog = css`
  /* prevent clipping of positioned elements */
  paper-dialog-scrollable {
    --paper-dialog-scrollable: {
      -webkit-overflow-scrolling: auto;
    }
  }

  /* force smooth scrolling for iOS 10 */
  paper-dialog-scrollable.can-scroll {
    --paper-dialog-scrollable: {
      -webkit-overflow-scrolling: touch;
    }
  }

  .paper-dialog-buttons {
    align-items: flex-end;
    padding: 8px;
    padding-bottom: max(env(safe-area-inset-bottom), 8px);
  }

  @media all and (min-width: 450px) and (min-height: 500px) {
    ha-paper-dialog {
      min-width: 400px;
    }
  }

  @media all and (max-width: 450px), all and (max-height: 500px) {
    paper-dialog,
    ha-paper-dialog {
      margin: 0;
      width: calc(
        100% - env(safe-area-inset-right) - env(safe-area-inset-left)
      ) !important;
      min-width: calc(
        100% - env(safe-area-inset-right) - env(safe-area-inset-left)
      ) !important;
      max-width: calc(
        100% - env(safe-area-inset-right) - env(safe-area-inset-left)
      ) !important;
      max-height: calc(100% - 64px);

      position: fixed !important;
      bottom: 0px;
      left: env(safe-area-inset-left);
      right: env(safe-area-inset-right);
      overflow: scroll;
      border-bottom-left-radius: 0px;
      border-bottom-right-radius: 0px;
    }
  }

  /* mwc-dialog (ha-dialog) styles */
  ha-dialog {
    --mdc-dialog-min-width: 400px;
    --mdc-dialog-max-width: 600px;
    --mdc-dialog-heading-ink-color: var(--primary-text-color);
    --mdc-dialog-content-ink-color: var(--primary-text-color);
    --justify-action-buttons: space-between;
  }

  ha-dialog .form {
    padding-bottom: 24px;
    color: var(--primary-text-color);
  }

  /* make dialog fullscreen on small screens */
  @media all and (max-width: 450px), all and (max-height: 500px) {
    ha-dialog {
      --mdc-dialog-min-width: calc(
        100vw - env(safe-area-inset-right) - env(safe-area-inset-left)
      );
      --mdc-dialog-max-width: calc(
        100vw - env(safe-area-inset-right) - env(safe-area-inset-left)
      );
      --mdc-dialog-min-height: 100%;
      --mdc-dialog-max-height: 100%;
      --mdc-shape-medium: 0px;
      --vertial-align-dialog: flex-end;
    }
  }
  mwc-button.warning {
    --mdc-theme-primary: var(--error-color);
  }
  .error {
    color: var(--error-color);
  }
`;

  const expand_hex = hex => {
    let result = "";

    for (const val of hex) {
      result += val + val;
    }

    return result;
  };

  const rgb_hex = component => {
    const hex = Math.round(Math.min(Math.max(component, 0), 255)).toString(16);
    return hex.length === 1 ? `0${hex}` : hex;
  }; // Conversion between HEX and RGB


  const hex2rgb = hex => {
    hex = hex.replace("#", "");

    if (hex.length === 3 || hex.length === 4) {
      hex = expand_hex(hex);
    }

    return [parseInt(hex.substring(0, 2), 16), parseInt(hex.substring(2, 4), 16), parseInt(hex.substring(4, 6), 16)];
  };
  const rgb2hex = rgb => {
    return `#${rgb_hex(rgb[0])}${rgb_hex(rgb[1])}${rgb_hex(rgb[2])}`;
  }; // Conversion between LAB, XYZ and RGB from https://github.com/gka/chroma.js
  // Copyright (c) 2011-2019, Gregor Aisch
  // Constants for XYZ and LAB conversion

  const Xn = 0.95047;
  const Yn = 1;
  const Zn = 1.08883;
  const t0 = 0.137931034; // 4 / 29

  const t1 = 0.206896552; // 6 / 29

  const t2 = 0.12841855; // 3 * t1 * t1

  const t3 = 0.008856452; // t1 * t1 * t1

  const rgb_xyz = r => {
    r /= 255;

    if (r <= 0.04045) {
      return r / 12.92;
    }

    return ((r + 0.055) / 1.055) ** 2.4;
  };

  const xyz_lab = t => {
    if (t > t3) {
      return t ** (1 / 3);
    }

    return t / t2 + t0;
  };

  const xyz_rgb = r => {
    return 255 * (r <= 0.00304 ? 12.92 * r : 1.055 * r ** (1 / 2.4) - 0.055);
  };

  const lab_xyz = t => {
    return t > t1 ? t * t * t : t2 * (t - t0);
  }; // Conversions between RGB and LAB


  const rgb2xyz = rgb => {
    let [r, g, b] = rgb;
    r = rgb_xyz(r);
    g = rgb_xyz(g);
    b = rgb_xyz(b);
    const x = xyz_lab((0.4124564 * r + 0.3575761 * g + 0.1804375 * b) / Xn);
    const y = xyz_lab((0.2126729 * r + 0.7151522 * g + 0.072175 * b) / Yn);
    const z = xyz_lab((0.0193339 * r + 0.119192 * g + 0.9503041 * b) / Zn);
    return [x, y, z];
  };

  const rgb2lab = rgb => {
    const [x, y, z] = rgb2xyz(rgb);
    const l = 116 * y - 16;
    return [l < 0 ? 0 : l, 500 * (x - y), 200 * (y - z)];
  };
  const lab2rgb = lab => {
    const [l, a, b] = lab;
    let y = (l + 16) / 116;
    let x = isNaN(a) ? y : y + a / 500;
    let z = isNaN(b) ? y : y - b / 200;
    y = Yn * lab_xyz(y);
    x = Xn * lab_xyz(x);
    z = Zn * lab_xyz(z);
    const r = xyz_rgb(3.2404542 * x - 1.5371385 * y - 0.4985314 * z); // D65 -> sRGB

    const g = xyz_rgb(-0.969266 * x + 1.8760108 * y + 0.041556 * z);
    const b_ = xyz_rgb(0.0556434 * x - 0.2040259 * y + 1.0572252 * z);
    return [r, g, b_];
  };
  const lab2hex = lab => {
    const rgb = lab2rgb(lab);
    return rgb2hex(rgb);
  };

  const luminosity = rgb => {
    // http://www.w3.org/TR/WCAG20/#relativeluminancedef
    const lum = [0, 0, 0];

    for (let i = 0; i < rgb.length; i++) {
      const chan = rgb[i] / 255;
      lum[i] = chan <= 0.03928 ? chan / 12.92 : ((chan + 0.055) / 1.055) ** 2.4;
    }

    return 0.2126 * lum[0] + 0.7152 * lum[1] + 0.0722 * lum[2];
  };

  const rgbContrast = (color1, color2) => {
    const lum1 = luminosity(color1);
    const lum2 = luminosity(color2);

    if (lum1 > lum2) {
      return (lum1 + 0.05) / (lum2 + 0.05);
    }

    return (lum2 + 0.05) / (lum1 + 0.05);
  };

  // From https://github.com/gka/chroma.js
  // Copyright (c) 2011-2019, Gregor Aisch
  const labDarken = (lab, amount = 1) => {
    return [lab[0] - 18 * amount, lab[1], lab[2]];
  };
  const labBrighten = (lab, amount = 1) => {
    return labDarken(lab, -amount);
  };

  let PROCESSED_THEMES = {};
  /**
   * Apply a theme to an element by setting the CSS variables on it.
   *
   * element: Element to apply theme on.
   * themes: HASS Theme information
   * selectedTheme: selected theme.
   */

  const applyThemesOnElement = (element, themes, selectedTheme, themeOptions) => {
    let cacheKey = selectedTheme;
    let themeRules = {};

    if (selectedTheme === "default" && themeOptions) {
      if (themeOptions.dark) {
        cacheKey = `${cacheKey}__dark`;
        themeRules = darkStyles;
      }

      if (themeOptions.primaryColor) {
        cacheKey = `${cacheKey}__primary_${themeOptions.primaryColor}`;
        const rgbPrimaryColor = hex2rgb(themeOptions.primaryColor);
        const labPrimaryColor = rgb2lab(rgbPrimaryColor);
        themeRules["primary-color"] = themeOptions.primaryColor;
        const rgbLigthPrimaryColor = lab2rgb(labBrighten(labPrimaryColor));
        themeRules["light-primary-color"] = rgb2hex(rgbLigthPrimaryColor);
        themeRules["dark-primary-color"] = lab2hex(labDarken(labPrimaryColor));
        themeRules["text-primary-color"] = rgbContrast(rgbPrimaryColor, [33, 33, 33]) < 6 ? "#fff" : "#212121";
        themeRules["text-light-primary-color"] = rgbContrast(rgbLigthPrimaryColor, [33, 33, 33]) < 6 ? "#fff" : "#212121";
        themeRules["state-icon-color"] = themeRules["dark-primary-color"];
      }

      if (themeOptions.accentColor) {
        cacheKey = `${cacheKey}__accent_${themeOptions.accentColor}`;
        themeRules["accent-color"] = themeOptions.accentColor;
        const rgbAccentColor = hex2rgb(themeOptions.accentColor);
        themeRules["text-accent-color"] = rgbContrast(rgbAccentColor, [33, 33, 33]) < 6 ? "#fff" : "#212121";
      }
    }

    if (selectedTheme && themes.themes[selectedTheme]) {
      themeRules = themes.themes[selectedTheme];
    }

    if (!element._themes && !Object.keys(themeRules).length) {
      // No styles to reset, and no styles to set
      return;
    }

    const newTheme = themeRules && cacheKey ? PROCESSED_THEMES[cacheKey] || processTheme(cacheKey, themeRules) : undefined; // Add previous set keys to reset them, and new theme

    const styles = { ...element._themes,
      ...(newTheme === null || newTheme === void 0 ? void 0 : newTheme.styles)
    };
    element._themes = newTheme === null || newTheme === void 0 ? void 0 : newTheme.keys; // Set and/or reset styles

    if (element.updateStyles) {
      element.updateStyles(styles);
    } else if (window.ShadyCSS) {
      // Implement updateStyles() method of Polymer elements
      window.ShadyCSS.styleSubtree(
      /** @type {!HTMLElement} */
      element, styles);
    }
  };

  const processTheme = (cacheKey, theme) => {
    if (!theme || !Object.keys(theme).length) {
      return undefined;
    }

    const combinedTheme = { ...derivedStyles,
      ...theme
    };
    const styles = {};
    const keys = {};

    for (const key of Object.keys(combinedTheme)) {
      const prefixedKey = `--${key}`;
      const value = combinedTheme[key];
      styles[prefixedKey] = value;
      keys[prefixedKey] = ""; // Try to create a rgb value for this key if it is not a var

      if (!value.startsWith("#")) {
        // Can't convert non hex value
        continue;
      }

      const rgbKey = `rgb-${key}`;

      if (combinedTheme[rgbKey] !== undefined) {
        // Theme has it's own rgb value
        continue;
      }

      try {
        const rgbValue = hex2rgb(value).join(",");
        const prefixedRgbKey = `--${rgbKey}`;
        styles[prefixedRgbKey] = rgbValue;
        keys[prefixedRgbKey] = "";
      } catch (e) {
        continue;
      }
    }

    PROCESSED_THEMES[cacheKey] = {
      styles,
      keys
    };
    return {
      styles,
      keys
    };
  };

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  const nativeShadow = !(window['ShadyDOM'] && window['ShadyDOM']['inUse']);
  let nativeCssVariables_;
  /**
   * @param {(ShadyCSSOptions | ShadyCSSInterface)=} settings
   */

  function calcCssVariables(settings) {
    if (settings && settings['shimcssproperties']) {
      nativeCssVariables_ = false;
    } else {
      // chrome 49 has semi-working css vars, check if box-shadow works
      // safari 9.1 has a recalc bug: https://bugs.webkit.org/show_bug.cgi?id=155782
      // However, shim css custom properties are only supported with ShadyDOM enabled,
      // so fall back on native if we do not detect ShadyDOM
      // Edge 15: custom properties used in ::before and ::after will also be used in the parent element
      // https://developer.microsoft.com/en-us/microsoft-edge/platform/issues/12414257/
      nativeCssVariables_ = nativeShadow || Boolean(!navigator.userAgent.match(/AppleWebKit\/601|Edge\/15/) && window.CSS && CSS.supports && CSS.supports('box-shadow', '0 0 0 var(--foo)'));
    }
  }
  /** @type {string | undefined} */


  let cssBuild;

  if (window.ShadyCSS && window.ShadyCSS.cssBuild !== undefined) {
    cssBuild = window.ShadyCSS.cssBuild;
  }
  /** @type {boolean} */


  const disableRuntime = Boolean(window.ShadyCSS && window.ShadyCSS.disableRuntime);

  if (window.ShadyCSS && window.ShadyCSS.nativeCss !== undefined) {
    nativeCssVariables_ = window.ShadyCSS.nativeCss;
  } else if (window.ShadyCSS) {
    calcCssVariables(window.ShadyCSS); // reset window variable to let ShadyCSS API take its place

    window.ShadyCSS = undefined;
  } else {
    calcCssVariables(window['WebComponents'] && window['WebComponents']['flags']);
  } // Hack for type error under new type inference which doesn't like that
  // nativeCssVariables is updated in a function and assigns the type
  // `function(): ?` instead of `boolean`.


  const nativeCssVariables =
  /** @type {boolean} */
  nativeCssVariables_;

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /** @unrestricted */

  class StyleNode {
    constructor() {
      /** @type {number} */
      this['start'] = 0;
      /** @type {number} */

      this['end'] = 0;
      /** @type {StyleNode} */

      this['previous'] = null;
      /** @type {StyleNode} */

      this['parent'] = null;
      /** @type {Array<StyleNode>} */

      this['rules'] = null;
      /** @type {string} */

      this['parsedCssText'] = '';
      /** @type {string} */

      this['cssText'] = '';
      /** @type {boolean} */

      this['atRule'] = false;
      /** @type {number} */

      this['type'] = 0;
      /** @type {string} */

      this['keyframesName'] = '';
      /** @type {string} */

      this['selector'] = '';
      /** @type {string} */

      this['parsedSelector'] = '';
    }

  }

  /**
   * @param {string} text
   * @return {StyleNode}
   */

  function parse(text) {
    text = clean(text);
    return parseCss(lex(text), text);
  } // remove stuff we don't care about that may hinder parsing

  /**
   * @param {string} cssText
   * @return {string}
   */

  function clean(cssText) {
    return cssText.replace(RX.comments, '').replace(RX.port, '');
  } // super simple {...} lexer that returns a node tree

  /**
   * @param {string} text
   * @return {!StyleNode}
   */


  function lex(text) {
    let root = new StyleNode();
    root['start'] = 0;
    root['end'] = text.length;
    let n = root;

    for (let i = 0, l = text.length; i < l; i++) {
      if (text[i] === OPEN_BRACE) {
        if (!n['rules']) {
          n['rules'] = [];
        }

        let p = n;
        let previous = p['rules'][p['rules'].length - 1] || null;
        n = new StyleNode();
        n['start'] = i + 1;
        n['parent'] = p;
        n['previous'] = previous;
        p['rules'].push(n);
      } else if (text[i] === CLOSE_BRACE) {
        n['end'] = i + 1;
        n = n['parent'] || root;
      }
    }

    return root;
  } // add selectors/cssText to node tree

  /**
   * @param {StyleNode} node
   * @param {string} text
   * @return {!StyleNode}
   */


  function parseCss(node, text) {
    let t = text.substring(node['start'], node['end'] - 1);
    node['parsedCssText'] = node['cssText'] = t.trim();

    if (node['parent']) {
      let ss = node['previous'] ? node['previous']['end'] : node['parent']['start'];
      t = text.substring(ss, node['start'] - 1);
      t = _expandUnicodeEscapes(t);
      t = t.replace(RX.multipleSpaces, ' '); // TODO(sorvell): ad hoc; make selector include only after last ;
      // helps with mixin syntax

      t = t.substring(t.lastIndexOf(';') + 1);
      let s = node['parsedSelector'] = node['selector'] = t.trim();
      node['atRule'] = s.indexOf(AT_START) === 0; // note, support a subset of rule types...

      if (node['atRule']) {
        if (s.indexOf(MEDIA_START) === 0) {
          node['type'] = types.MEDIA_RULE;
        } else if (s.match(RX.keyframesRule)) {
          node['type'] = types.KEYFRAMES_RULE;
          node['keyframesName'] = node['selector'].split(RX.multipleSpaces).pop();
        }
      } else {
        if (s.indexOf(VAR_START) === 0) {
          node['type'] = types.MIXIN_RULE;
        } else {
          node['type'] = types.STYLE_RULE;
        }
      }
    }

    let r$ = node['rules'];

    if (r$) {
      for (let i = 0, l = r$.length, r; i < l && (r = r$[i]); i++) {
        parseCss(r, text);
      }
    }

    return node;
  }
  /**
   * conversion of sort unicode escapes with spaces like `\33 ` (and longer) into
   * expanded form that doesn't require trailing space `\000033`
   * @param {string} s
   * @return {string}
   */


  function _expandUnicodeEscapes(s) {
    return s.replace(/\\([0-9a-f]{1,6})\s/gi, function () {
      let code = arguments[1],
          repeat = 6 - code.length;

      while (repeat--) {
        code = '0' + code;
      }

      return '\\' + code;
    });
  }
  /**
   * stringify parsed css.
   * @param {StyleNode} node
   * @param {boolean=} preserveProperties
   * @param {string=} text
   * @return {string}
   */


  function stringify(node, preserveProperties, text = '') {
    // calc rule cssText
    let cssText = '';

    if (node['cssText'] || node['rules']) {
      let r$ = node['rules'];

      if (r$ && !_hasMixinRules(r$)) {
        for (let i = 0, l = r$.length, r; i < l && (r = r$[i]); i++) {
          cssText = stringify(r, preserveProperties, cssText);
        }
      } else {
        cssText = preserveProperties ? node['cssText'] : removeCustomProps(node['cssText']);
        cssText = cssText.trim();

        if (cssText) {
          cssText = '  ' + cssText + '\n';
        }
      }
    } // emit rule if there is cssText


    if (cssText) {
      if (node['selector']) {
        text += node['selector'] + ' ' + OPEN_BRACE + '\n';
      }

      text += cssText;

      if (node['selector']) {
        text += CLOSE_BRACE + '\n\n';
      }
    }

    return text;
  }
  /**
   * @param {Array<StyleNode>} rules
   * @return {boolean}
   */

  function _hasMixinRules(rules) {
    let r = rules[0];
    return Boolean(r) && Boolean(r['selector']) && r['selector'].indexOf(VAR_START) === 0;
  }
  /**
   * @param {string} cssText
   * @return {string}
   */


  function removeCustomProps(cssText) {
    cssText = removeCustomPropAssignment(cssText);
    return removeCustomPropApply(cssText);
  }
  /**
   * @param {string} cssText
   * @return {string}
   */


  function removeCustomPropAssignment(cssText) {
    return cssText.replace(RX.customProp, '').replace(RX.mixinProp, '');
  }
  /**
   * @param {string} cssText
   * @return {string}
   */

  function removeCustomPropApply(cssText) {
    return cssText.replace(RX.mixinApply, '').replace(RX.varApply, '');
  }
  /** @enum {number} */


  const types = {
    STYLE_RULE: 1,
    KEYFRAMES_RULE: 7,
    MEDIA_RULE: 4,
    MIXIN_RULE: 1000
  };
  const OPEN_BRACE = '{';
  const CLOSE_BRACE = '}'; // helper regexp's

  const RX = {
    comments: /\/\*[^*]*\*+([^/*][^*]*\*+)*\//gim,
    port: /@import[^;]*;/gim,
    customProp: /(?:^[^;\-\s}]+)?--[^;{}]*?:[^{};]*?(?:[;\n]|$)/gim,
    mixinProp: /(?:^[^;\-\s}]+)?--[^;{}]*?:[^{};]*?{[^}]*?}(?:[;\n]|$)?/gim,
    mixinApply: /@apply\s*\(?[^);]*\)?\s*(?:[;\n]|$)?/gim,
    varApply: /[^;:]*?:[^;]*?var\([^;]*\)(?:[;\n]|$)?/gim,
    keyframesRule: /^@[^\s]*keyframes/,
    multipleSpaces: /\s+/g
  };
  const VAR_START = '--';
  const MEDIA_START = '@media';
  const AT_START = '@';

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  const VAR_ASSIGN = /(?:^|[;\s{]\s*)(--[\w-]*?)\s*:\s*(?:((?:'(?:\\'|.)*?'|"(?:\\"|.)*?"|\([^)]*?\)|[^};{])+)|\{([^}]*)\}(?:(?=[;\s}])|$))/gi;
  const MIXIN_MATCH = /(?:^|\W+)@apply\s*\(?([^);\n]*)\)?/gi;
  const MEDIA_MATCH = /@media\s(.*)/;

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /** @type {!Set<string>} */

  const styleTextSet = new Set();
  const scopingAttribute = 'shady-unscoped';
  /**
   * Add a specifically-marked style to the document directly, and only one copy of that style.
   *
   * @param {!HTMLStyleElement} style
   * @return {undefined}
   */

  function processUnscopedStyle(style) {
    const text = style.textContent;

    if (!styleTextSet.has(text)) {
      styleTextSet.add(text);
      const newStyle = document.createElement('style');
      newStyle.setAttribute('shady-unscoped', '');
      newStyle.textContent = text;
      document.head.appendChild(newStyle);
    }
  }
  /**
   * Check if a style is supposed to be unscoped
   * @param {!HTMLStyleElement} style
   * @return {boolean} true if the style has the unscoping attribute
   */

  function isUnscopedStyle(style) {
    return style.hasAttribute(scopingAttribute);
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * @param {string|StyleNode} rules
   * @param {function(StyleNode)=} callback
   * @return {string}
   */

  function toCssText(rules, callback) {
    if (!rules) {
      return '';
    }

    if (typeof rules === 'string') {
      rules = parse(rules);
    }

    if (callback) {
      forEachRule(rules, callback);
    }

    return stringify(rules, nativeCssVariables);
  }
  /**
   * @param {HTMLStyleElement} style
   * @return {StyleNode}
   */

  function rulesForStyle(style) {
    if (!style['__cssRules'] && style.textContent) {
      style['__cssRules'] = parse(style.textContent);
    }

    return style['__cssRules'] || null;
  } // Tests if a rule is a keyframes selector, which looks almost exactly
  /**
   * @param {StyleNode} node
   * @param {Function=} styleRuleCallback
   * @param {Function=} keyframesRuleCallback
   * @param {boolean=} onlyActiveRules
   */

  function forEachRule(node, styleRuleCallback, keyframesRuleCallback, onlyActiveRules) {
    if (!node) {
      return;
    }

    let skipRules = false;
    let type = node['type'];

    if (onlyActiveRules) {
      if (type === types.MEDIA_RULE) {
        let matchMedia = node['selector'].match(MEDIA_MATCH);

        if (matchMedia) {
          // if rule is a non matching @media rule, skip subrules
          if (!window.matchMedia(matchMedia[1]).matches) {
            skipRules = true;
          }
        }
      }
    }

    if (type === types.STYLE_RULE) {
      styleRuleCallback(node);
    } else if (keyframesRuleCallback && type === types.KEYFRAMES_RULE) {
      keyframesRuleCallback(node);
    } else if (type === types.MIXIN_RULE) {
      skipRules = true;
    }

    let r$ = node['rules'];

    if (r$ && !skipRules) {
      for (let i = 0, l = r$.length, r; i < l && (r = r$[i]); i++) {
        forEachRule(r, styleRuleCallback, keyframesRuleCallback, onlyActiveRules);
      }
    }
  } // add a string of cssText to the document.
  /**
   * Walk from text[start] matching parens and
   * returns position of the outer end paren
   * @param {string} text
   * @param {number} start
   * @return {number}
   */

  function findMatchingParen(text, start) {
    let level = 0;

    for (let i = start, l = text.length; i < l; i++) {
      if (text[i] === '(') {
        level++;
      } else if (text[i] === ')') {
        if (--level === 0) {
          return i;
        }
      }
    }

    return -1;
  }
  /**
   * @param {string} str
   * @param {function(string, string, string, string)} callback
   */

  function processVariableAndFallback(str, callback) {
    // find 'var('
    let start = str.indexOf('var(');

    if (start === -1) {
      // no var?, everything is prefix
      return callback(str, '', '', '');
    } //${prefix}var(${inner})${suffix}


    let end = findMatchingParen(str, start + 3);
    let inner = str.substring(start + 4, end);
    let prefix = str.substring(0, start); // suffix may have other variables

    let suffix = processVariableAndFallback(str.substring(end + 1), callback);
    let comma = inner.indexOf(','); // value and fallback args should be trimmed to match in property lookup

    if (comma === -1) {
      // variable, no fallback
      return callback(prefix, inner.trim(), '', suffix);
    } // var(${value},${fallback})


    let value = inner.substring(0, comma).trim();
    let fallback = inner.substring(comma + 1).trim();
    return callback(prefix, value, fallback, suffix);
  }
  /**
   * @type {function(*):*}
   */

  const wrap = window['ShadyDOM'] && window['ShadyDOM']['wrap'] || (node => node);
  /**
   * @param {Element | {is: string, extends: string}} element
   * @return {{is: string, typeExtension: string}}
   */

  function getIsExtends(element) {
    let localName = element['localName'];
    let is = '',
        typeExtension = '';
    /*
    NOTE: technically, this can be wrong for certain svg elements
    with `-` in the name like `<font-face>`
    */

    if (localName) {
      if (localName.indexOf('-') > -1) {
        is = localName;
      } else {
        typeExtension = localName;
        is = element.getAttribute && element.getAttribute('is') || '';
      }
    } else {
      is =
      /** @type {?} */
      element.is;
      typeExtension =
      /** @type {?} */
      element.extends;
    }

    return {
      is,
      typeExtension
    };
  }
  /**
   * @param {Element|DocumentFragment} element
   * @return {string}
   */

  function gatherStyleText(element) {
    /** @type {!Array<string>} */
    const styleTextParts = [];
    const styles =
    /** @type {!NodeList<!HTMLStyleElement>} */
    element.querySelectorAll('style');

    for (let i = 0; i < styles.length; i++) {
      const style = styles[i];

      if (isUnscopedStyle(style)) {
        if (!nativeShadow) {
          processUnscopedStyle(style);
          style.parentNode.removeChild(style);
        }
      } else {
        styleTextParts.push(style.textContent);
        style.parentNode.removeChild(style);
      }
    }

    return styleTextParts.join('').trim();
  }
  const CSS_BUILD_ATTR = 'css-build';
  /**
   * Return the polymer-css-build "build type" applied to this element
   *
   * @param {!HTMLElement} element
   * @return {string} Can be "", "shady", or "shadow"
   */

  function getCssBuild(element) {
    if (cssBuild !== undefined) {
      return (
        /** @type {string} */
        cssBuild
      );
    }

    if (element.__cssBuild === undefined) {
      // try attribute first, as it is the common case
      const attrValue = element.getAttribute(CSS_BUILD_ATTR);

      if (attrValue) {
        element.__cssBuild = attrValue;
      } else {
        const buildComment = getBuildComment(element);

        if (buildComment !== '') {
          // remove build comment so it is not needlessly copied into every element instance
          removeBuildComment(element);
        }

        element.__cssBuild = buildComment;
      }
    }

    return element.__cssBuild || '';
  }
  /**
   * Check if the given element, either a <template> or <style>, has been processed
   * by polymer-css-build.
   *
   * If so, then we can make a number of optimizations:
   * - polymer-css-build will decompose mixins into individual CSS Custom Properties,
   * so the ApplyShim can be skipped entirely.
   * - Under native ShadowDOM, the style text can just be copied into each instance
   * without modification
   * - If the build is "shady" and ShadyDOM is in use, the styling does not need
   * scoping beyond the shimming of CSS Custom Properties
   *
   * @param {!HTMLElement} element
   * @return {boolean}
   */

  function elementHasBuiltCss(element) {
    return getCssBuild(element) !== '';
  }
  /**
   * For templates made with tagged template literals, polymer-css-build will
   * insert a comment of the form `<!--css-build:shadow-->`
   *
   * @param {!HTMLElement} element
   * @return {string}
   */

  function getBuildComment(element) {
    const buildComment = element.localName === 'template' ?
    /** @type {!HTMLTemplateElement} */
    element.content.firstChild : element.firstChild;

    if (buildComment instanceof Comment) {
      const commentParts = buildComment.textContent.trim().split(':');

      if (commentParts[0] === CSS_BUILD_ATTR) {
        return commentParts[1];
      }
    }

    return '';
  }
  /**
   * @param {!HTMLElement} element
   */

  function removeBuildComment(element) {
    const buildComment = element.localName === 'template' ?
    /** @type {!HTMLTemplateElement} */
    element.content.firstChild : element.firstChild;
    buildComment.parentNode.removeChild(buildComment);
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * @param {Element} element
   * @param {Object=} properties
   */

  function updateNativeProperties(element, properties) {
    // remove previous properties
    for (let p in properties) {
      // NOTE: for bc with shim, don't apply null values.
      if (p === null) {
        element.style.removeProperty(p);
      } else {
        element.style.setProperty(p, properties[p]);
      }
    }
  }
  /**
   * @param {Element} element
   * @param {string} property
   * @return {string}
   */

  function getComputedStyleValue(element, property) {
    /**
     * @const {string}
     */
    const value = window.getComputedStyle(element).getPropertyValue(property);

    if (!value) {
      return '';
    } else {
      return value.trim();
    }
  }
  /**
   * return true if `cssText` contains a mixin definition or consumption
   * @param {string} cssText
   * @return {boolean}
   */

  function detectMixin(cssText) {
    const has = MIXIN_MATCH.test(cssText) || VAR_ASSIGN.test(cssText); // reset state of the regexes

    MIXIN_MATCH.lastIndex = 0;
    VAR_ASSIGN.lastIndex = 0;
    return has;
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  const APPLY_NAME_CLEAN = /;\s*/m;
  const INITIAL_INHERIT = /^\s*(initial)|(inherit)\s*$/;
  const IMPORTANT = /\s*!important/; // separator used between mixin-name and mixin-property-name when producing properties
  // NOTE: plain '-' may cause collisions in user styles

  const MIXIN_VAR_SEP = '_-_';
  // map of mixin to property names
  // --foo: {border: 2px} -> {properties: {(--foo, ['border'])}, dependants: {'element-name': proto}}

  class MixinMap {
    constructor() {
      /** @type {!Object<string, !MixinMapEntry>} */
      this._map = {};
    }
    /**
     * @param {string} name
     * @param {!PropertyEntry} props
     */


    set(name, props) {
      name = name.trim();
      this._map[name] = {
        properties: props,
        dependants: {}
      };
    }
    /**
     * @param {string} name
     * @return {MixinMapEntry}
     */


    get(name) {
      name = name.trim();
      return this._map[name] || null;
    }

  }
  /**
   * Callback for when an element is marked invalid
   * @type {?function(string)}
   */


  let invalidCallback = null;
  /** @unrestricted */

  class ApplyShim {
    constructor() {
      /** @type {?string} */
      this._currentElement = null;
      /** @type {HTMLMetaElement} */

      this._measureElement = null;
      this._map = new MixinMap();
    }
    /**
     * return true if `cssText` contains a mixin definition or consumption
     * @param {string} cssText
     * @return {boolean}
     */


    detectMixin(cssText) {
      return detectMixin(cssText);
    }
    /**
     * Gather styles into one style for easier processing
     * @param {!HTMLTemplateElement} template
     * @return {HTMLStyleElement}
     */


    gatherStyles(template) {
      const styleText = gatherStyleText(template.content);

      if (styleText) {
        const style =
        /** @type {!HTMLStyleElement} */
        document.createElement('style');
        style.textContent = styleText;
        template.content.insertBefore(style, template.content.firstChild);
        return style;
      }

      return null;
    }
    /**
     * @param {!HTMLTemplateElement} template
     * @param {string} elementName
     * @return {StyleNode}
     */


    transformTemplate(template, elementName) {
      if (template._gatheredStyle === undefined) {
        template._gatheredStyle = this.gatherStyles(template);
      }
      /** @type {HTMLStyleElement} */


      const style = template._gatheredStyle;
      return style ? this.transformStyle(style, elementName) : null;
    }
    /**
     * @param {!HTMLStyleElement} style
     * @param {string} elementName
     * @return {StyleNode}
     */


    transformStyle(style, elementName = '') {
      let ast = rulesForStyle(style);
      this.transformRules(ast, elementName);
      style.textContent = toCssText(ast);
      return ast;
    }
    /**
     * @param {!HTMLStyleElement} style
     * @return {StyleNode}
     */


    transformCustomStyle(style) {
      let ast = rulesForStyle(style);
      forEachRule(ast, rule => {
        if (rule['selector'] === ':root') {
          rule['selector'] = 'html';
        }

        this.transformRule(rule);
      });
      style.textContent = toCssText(ast);
      return ast;
    }
    /**
     * @param {StyleNode} rules
     * @param {string} elementName
     */


    transformRules(rules, elementName) {
      this._currentElement = elementName;
      forEachRule(rules, r => {
        this.transformRule(r);
      });
      this._currentElement = null;
    }
    /**
     * @param {!StyleNode} rule
     */


    transformRule(rule) {
      rule['cssText'] = this.transformCssText(rule['parsedCssText'], rule); // :root was only used for variable assignment in property shim,
      // but generates invalid selectors with real properties.
      // replace with `:host > *`, which serves the same effect

      if (rule['selector'] === ':root') {
        rule['selector'] = ':host > *';
      }
    }
    /**
     * @param {string} cssText
     * @param {!StyleNode} rule
     * @return {string}
     */


    transformCssText(cssText, rule) {
      // produce variables
      cssText = cssText.replace(VAR_ASSIGN, (matchText, propertyName, valueProperty, valueMixin) => this._produceCssProperties(matchText, propertyName, valueProperty, valueMixin, rule)); // consume mixins

      return this._consumeCssProperties(cssText, rule);
    }
    /**
     * @param {string} property
     * @return {string}
     */


    _getInitialValueForProperty(property) {
      if (!this._measureElement) {
        this._measureElement =
        /** @type {HTMLMetaElement} */
        document.createElement('meta');

        this._measureElement.setAttribute('apply-shim-measure', '');

        this._measureElement.style.all = 'initial';
        document.head.appendChild(this._measureElement);
      }

      return window.getComputedStyle(this._measureElement).getPropertyValue(property);
    }
    /**
     * Walk over all rules before this rule to find fallbacks for mixins
     *
     * @param {!StyleNode} startRule
     * @return {!Object}
     */


    _fallbacksFromPreviousRules(startRule) {
      // find the "top" rule
      let topRule = startRule;

      while (topRule['parent']) {
        topRule = topRule['parent'];
      }

      const fallbacks = {};
      let seenStartRule = false;
      forEachRule(topRule, r => {
        // stop when we hit the input rule
        seenStartRule = seenStartRule || r === startRule;

        if (seenStartRule) {
          return;
        } // NOTE: Only matching selectors are "safe" for this fallback processing
        // It would be prohibitive to run `matchesSelector()` on each selector,
        // so we cheat and only check if the same selector string is used, which
        // guarantees things like specificity matching


        if (r['selector'] === startRule['selector']) {
          Object.assign(fallbacks, this._cssTextToMap(r['parsedCssText']));
        }
      });
      return fallbacks;
    }
    /**
     * replace mixin consumption with variable consumption
     * @param {string} text
     * @param {!StyleNode=} rule
     * @return {string}
     */


    _consumeCssProperties(text, rule) {
      /** @type {Array} */
      let m = null; // loop over text until all mixins with defintions have been applied

      while (m = MIXIN_MATCH.exec(text)) {
        let matchText = m[0];
        let mixinName = m[1];
        let idx = m.index; // collect properties before apply to be "defaults" if mixin might override them
        // match includes a "prefix", so find the start and end positions of @apply

        let applyPos = idx + matchText.indexOf('@apply');
        let afterApplyPos = idx + matchText.length; // find props defined before this @apply

        let textBeforeApply = text.slice(0, applyPos);
        let textAfterApply = text.slice(afterApplyPos);
        let defaults = rule ? this._fallbacksFromPreviousRules(rule) : {};
        Object.assign(defaults, this._cssTextToMap(textBeforeApply));

        let replacement = this._atApplyToCssProperties(mixinName, defaults); // use regex match position to replace mixin, keep linear processing time


        text = `${textBeforeApply}${replacement}${textAfterApply}`; // move regex search to _after_ replacement

        MIXIN_MATCH.lastIndex = idx + replacement.length;
      }

      return text;
    }
    /**
     * produce variable consumption at the site of mixin consumption
     * `@apply` --foo; -> for all props (${propname}: var(--foo_-_${propname}, ${fallback[propname]}}))
     * Example:
     *  border: var(--foo_-_border); padding: var(--foo_-_padding, 2px)
     *
     * @param {string} mixinName
     * @param {Object} fallbacks
     * @return {string}
     */


    _atApplyToCssProperties(mixinName, fallbacks) {
      mixinName = mixinName.replace(APPLY_NAME_CLEAN, '');
      let vars = [];

      let mixinEntry = this._map.get(mixinName); // if we depend on a mixin before it is created
      // make a sentinel entry in the map to add this element as a dependency for when it is defined.


      if (!mixinEntry) {
        this._map.set(mixinName, {});

        mixinEntry = this._map.get(mixinName);
      }

      if (mixinEntry) {
        if (this._currentElement) {
          mixinEntry.dependants[this._currentElement] = true;
        }

        let p, parts, f;
        const properties = mixinEntry.properties;

        for (p in properties) {
          f = fallbacks && fallbacks[p];
          parts = [p, ': var(', mixinName, MIXIN_VAR_SEP, p];

          if (f) {
            parts.push(',', f.replace(IMPORTANT, ''));
          }

          parts.push(')');

          if (IMPORTANT.test(properties[p])) {
            parts.push(' !important');
          }

          vars.push(parts.join(''));
        }
      }

      return vars.join('; ');
    }
    /**
     * @param {string} property
     * @param {string} value
     * @return {string}
     */


    _replaceInitialOrInherit(property, value) {
      let match = INITIAL_INHERIT.exec(value);

      if (match) {
        if (match[1]) {
          // initial
          // replace `initial` with the concrete initial value for this property
          value = this._getInitialValueForProperty(property);
        } else {
          // inherit
          // with this purposfully illegal value, the variable will be invalid at
          // compute time (https://www.w3.org/TR/css-variables/#invalid-at-computed-value-time)
          // and for inheriting values, will behave similarly
          // we cannot support the same behavior for non inheriting values like 'border'
          value = 'apply-shim-inherit';
        }
      }

      return value;
    }
    /**
     * "parse" a mixin definition into a map of properties and values
     * cssTextToMap('border: 2px solid black') -> ('border', '2px solid black')
     * @param {string} text
     * @param {boolean=} replaceInitialOrInherit
     * @return {!Object<string, string>}
     */


    _cssTextToMap(text, replaceInitialOrInherit = false) {
      let props = text.split(';');
      let property, value;
      let out = {};

      for (let i = 0, p, sp; i < props.length; i++) {
        p = props[i];

        if (p) {
          sp = p.split(':'); // ignore lines that aren't definitions like @media

          if (sp.length > 1) {
            property = sp[0].trim(); // some properties may have ':' in the value, like data urls

            value = sp.slice(1).join(':');

            if (replaceInitialOrInherit) {
              value = this._replaceInitialOrInherit(property, value);
            }

            out[property] = value;
          }
        }
      }

      return out;
    }
    /**
     * @param {MixinMapEntry} mixinEntry
     */


    _invalidateMixinEntry(mixinEntry) {
      if (!invalidCallback) {
        return;
      }

      for (let elementName in mixinEntry.dependants) {
        if (elementName !== this._currentElement) {
          invalidCallback(elementName);
        }
      }
    }
    /**
     * @param {string} matchText
     * @param {string} propertyName
     * @param {?string} valueProperty
     * @param {?string} valueMixin
     * @param {!StyleNode} rule
     * @return {string}
     */


    _produceCssProperties(matchText, propertyName, valueProperty, valueMixin, rule) {
      // handle case where property value is a mixin
      if (valueProperty) {
        // form: --mixin2: var(--mixin1), where --mixin1 is in the map
        processVariableAndFallback(valueProperty, (prefix, value) => {
          if (value && this._map.get(value)) {
            valueMixin = `@apply ${value};`;
          }
        });
      }

      if (!valueMixin) {
        return matchText;
      }

      let mixinAsProperties = this._consumeCssProperties('' + valueMixin, rule);

      let prefix = matchText.slice(0, matchText.indexOf('--')); // `initial` and `inherit` as properties in a map should be replaced because
      // these keywords are eagerly evaluated when the mixin becomes CSS Custom Properties,
      // and would set the variable value, rather than carry the keyword to the `var()` usage.

      let mixinValues = this._cssTextToMap(mixinAsProperties, true);

      let combinedProps = mixinValues;

      let mixinEntry = this._map.get(propertyName);

      let oldProps = mixinEntry && mixinEntry.properties;

      if (oldProps) {
        // NOTE: since we use mixin, the map of properties is updated here
        // and this is what we want.
        combinedProps = Object.assign(Object.create(oldProps), mixinValues);
      } else {
        this._map.set(propertyName, combinedProps);
      }

      let out = [];
      let p, v; // set variables defined by current mixin

      let needToInvalidate = false;

      for (p in combinedProps) {
        v = mixinValues[p]; // if property not defined by current mixin, set initial

        if (v === undefined) {
          v = 'initial';
        }

        if (oldProps && !(p in oldProps)) {
          needToInvalidate = true;
        }

        out.push(`${propertyName}${MIXIN_VAR_SEP}${p}: ${v}`);
      }

      if (needToInvalidate) {
        this._invalidateMixinEntry(mixinEntry);
      }

      if (mixinEntry) {
        mixinEntry.properties = combinedProps;
      } // because the mixinMap is global, the mixin might conflict with
      // a different scope's simple variable definition:
      // Example:
      // some style somewhere:
      // --mixin1:{ ... }
      // --mixin2: var(--mixin1);
      // some other element:
      // --mixin1: 10px solid red;
      // --foo: var(--mixin1);
      // In this case, we leave the original variable definition in place.


      if (valueProperty) {
        prefix = `${matchText};${prefix}`;
      }

      return `${prefix}${out.join('; ')};`;
    }

  }
  /* exports */

  /* eslint-disable no-self-assign */


  ApplyShim.prototype['detectMixin'] = ApplyShim.prototype.detectMixin;
  ApplyShim.prototype['transformStyle'] = ApplyShim.prototype.transformStyle;
  ApplyShim.prototype['transformCustomStyle'] = ApplyShim.prototype.transformCustomStyle;
  ApplyShim.prototype['transformRules'] = ApplyShim.prototype.transformRules;
  ApplyShim.prototype['transformRule'] = ApplyShim.prototype.transformRule;
  ApplyShim.prototype['transformTemplate'] = ApplyShim.prototype.transformTemplate;
  ApplyShim.prototype['_separator'] = MIXIN_VAR_SEP;
  /* eslint-enable no-self-assign */

  Object.defineProperty(ApplyShim.prototype, 'invalidCallback', {
    /** @return {?function(string)} */
    get() {
      return invalidCallback;
    },

    /** @param {?function(string)} cb */
    set(cb) {
      invalidCallback = cb;
    }

  });

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * @const {!Object<string, !HTMLTemplateElement>}
   */

  const templateMap = {};

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  /*
   * Utilities for handling invalidating apply-shim mixins for a given template.
   *
   * The invalidation strategy involves keeping track of the "current" version of a template's mixins, and updating that count when a mixin is invalidated.
   * The template
   */

  /** @const {string} */

  const CURRENT_VERSION = '_applyShimCurrentVersion';
  /** @const {string} */

  const NEXT_VERSION = '_applyShimNextVersion';
  /** @const {string} */

  const VALIDATING_VERSION = '_applyShimValidatingVersion';
  /**
   * @const {Promise<void>}
   */

  const promise = Promise.resolve();
  /**
   * @param {string} elementName
   */

  function invalidate(elementName) {
    let template = templateMap[elementName];

    if (template) {
      invalidateTemplate(template);
    }
  }
  /**
   * This function can be called multiple times to mark a template invalid
   * and signal that the style inside must be regenerated.
   *
   * Use `startValidatingTemplate` to begin an asynchronous validation cycle.
   * During that cycle, call `templateIsValidating` to see if the template must
   * be revalidated
   * @param {HTMLTemplateElement} template
   */

  function invalidateTemplate(template) {
    // default the current version to 0
    template[CURRENT_VERSION] = template[CURRENT_VERSION] || 0; // ensure the "validating for" flag exists

    template[VALIDATING_VERSION] = template[VALIDATING_VERSION] || 0; // increment the next version

    template[NEXT_VERSION] = (template[NEXT_VERSION] || 0) + 1;
  }
  /**
   * @param {HTMLTemplateElement} template
   * @return {boolean}
   */

  function templateIsValid(template) {
    return template[CURRENT_VERSION] === template[NEXT_VERSION];
  }
  /**
   * Returns true if the template is currently invalid and `startValidating` has been called since the last invalidation.
   * If false, the template must be validated.
   * @param {HTMLTemplateElement} template
   * @return {boolean}
   */

  function templateIsValidating(template) {
    return !templateIsValid(template) && template[VALIDATING_VERSION] === template[NEXT_VERSION];
  }
  /**
   * Begin an asynchronous invalidation cycle.
   * This should be called after every validation of a template
   *
   * After one microtask, the template will be marked as valid until the next call to `invalidateTemplate`
   * @param {HTMLTemplateElement} template
   */

  function startValidatingTemplate(template) {
    // remember that the current "next version" is the reason for this validation cycle
    template[VALIDATING_VERSION] = template[NEXT_VERSION]; // however, there only needs to be one async task to clear the counters

    if (!template._validating) {
      template._validating = true;
      promise.then(function () {
        // sync the current version to let future invalidations cause a refresh cycle
        template[CURRENT_VERSION] = template[NEXT_VERSION];
        template._validating = false;
      });
    }
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /** @type {Promise<void>} */

  let readyPromise = null;
  /** @type {?function(?function())} */

  let whenReady = window['HTMLImports'] && window['HTMLImports']['whenReady'] || null;
  /** @type {function()} */

  let resolveFn;
  /**
   * @param {?function()} callback
   */

  function documentWait(callback) {
    requestAnimationFrame(function () {
      if (whenReady) {
        whenReady(callback);
      } else {
        if (!readyPromise) {
          readyPromise = new Promise(resolve => {
            resolveFn = resolve;
          });

          if (document.readyState === 'complete') {
            resolveFn();
          } else {
            document.addEventListener('readystatechange', () => {
              if (document.readyState === 'complete') {
                resolveFn();
              }
            });
          }
        }

        readyPromise.then(function () {
          callback && callback();
        });
      }
    });
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  const SEEN_MARKER = '__seenByShadyCSS';
  const CACHED_STYLE = '__shadyCSSCachedStyle';
  /** @type {?function(!HTMLStyleElement)} */

  let transformFn = null;
  /** @type {?function()} */

  let validateFn = null;
  /**
  This interface is provided to add document-level <style> elements to ShadyCSS for processing.
  These styles must be processed by ShadyCSS to simulate ShadowRoot upper-bound encapsulation from outside styles
  In addition, these styles may also need to be processed for @apply rules and CSS Custom Properties

  To add document-level styles to ShadyCSS, one can call `ShadyCSS.addDocumentStyle(styleElement)` or `ShadyCSS.addDocumentStyle({getStyle: () => styleElement})`

  In addition, if the process used to discover document-level styles can be synchronously flushed, one should set `ShadyCSS.documentStyleFlush`.
  This function will be called when calculating styles.

  An example usage of the document-level styling api can be found in `examples/document-style-lib.js`

  @unrestricted
  */

  class CustomStyleInterface {
    constructor() {
      /** @type {!Array<!CustomStyleProvider>} */
      this['customStyles'] = [];
      this['enqueued'] = false; // NOTE(dfreedm): use quotes here to prevent closure inlining to `function(){}`;

      documentWait(() => {
        if (window['ShadyCSS']['flushCustomStyles']) {
          window['ShadyCSS']['flushCustomStyles']();
        }
      });
    }
    /**
     * Queue a validation for new custom styles to batch style recalculations
     */


    enqueueDocumentValidation() {
      if (this['enqueued'] || !validateFn) {
        return;
      }

      this['enqueued'] = true;
      documentWait(validateFn);
    }
    /**
     * @param {!HTMLStyleElement} style
     */


    addCustomStyle(style) {
      if (!style[SEEN_MARKER]) {
        style[SEEN_MARKER] = true;
        this['customStyles'].push(style);
        this.enqueueDocumentValidation();
      }
    }
    /**
     * @param {!CustomStyleProvider} customStyle
     * @return {HTMLStyleElement}
     */


    getStyleForCustomStyle(customStyle) {
      if (customStyle[CACHED_STYLE]) {
        return customStyle[CACHED_STYLE];
      }

      let style;

      if (customStyle['getStyle']) {
        style = customStyle['getStyle']();
      } else {
        style = customStyle;
      }

      return style;
    }
    /**
     * @return {!Array<!CustomStyleProvider>}
     */


    processStyles() {
      const cs = this['customStyles'];

      for (let i = 0; i < cs.length; i++) {
        const customStyle = cs[i];

        if (customStyle[CACHED_STYLE]) {
          continue;
        }

        const style = this.getStyleForCustomStyle(customStyle);

        if (style) {
          // HTMLImports polyfill may have cloned the style into the main document,
          // which is referenced with __appliedElement.
          const styleToTransform =
          /** @type {!HTMLStyleElement} */
          style['__appliedElement'] || style;

          if (transformFn) {
            transformFn(styleToTransform);
          }

          customStyle[CACHED_STYLE] = styleToTransform;
        }
      }

      return cs;
    }

  }
  /* eslint-disable no-self-assign */

  CustomStyleInterface.prototype['addCustomStyle'] = CustomStyleInterface.prototype.addCustomStyle;
  CustomStyleInterface.prototype['getStyleForCustomStyle'] = CustomStyleInterface.prototype.getStyleForCustomStyle;
  CustomStyleInterface.prototype['processStyles'] = CustomStyleInterface.prototype.processStyles;
  /* eslint-enable no-self-assign */

  Object.defineProperties(CustomStyleInterface.prototype, {
    'transformCallback': {
      /** @return {?function(!HTMLStyleElement)} */
      get() {
        return transformFn;
      },

      /** @param {?function(!HTMLStyleElement)} fn */
      set(fn) {
        transformFn = fn;
      }

    },
    'validateCallback': {
      /** @return {?function()} */
      get() {
        return validateFn;
      },

      /**
       * @param {?function()} fn
       * @this {CustomStyleInterface}
       */
      set(fn) {
        let needsEnqueue = false;

        if (!validateFn) {
          needsEnqueue = true;
        }

        validateFn = fn;

        if (needsEnqueue) {
          this.enqueueDocumentValidation();
        }
      }

    }
  });

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /** @const {ApplyShim} */

  const applyShim = new ApplyShim();

  class ApplyShimInterface {
    constructor() {
      /** @type {?CustomStyleInterfaceInterface} */
      this.customStyleInterface = null;
      applyShim['invalidCallback'] = invalidate;
    }

    ensure() {
      if (this.customStyleInterface) {
        return;
      }

      if (window.ShadyCSS.CustomStyleInterface) {
        this.customStyleInterface =
        /** @type {!CustomStyleInterfaceInterface} */
        window.ShadyCSS.CustomStyleInterface;

        this.customStyleInterface['transformCallback'] = style => {
          applyShim.transformCustomStyle(style);
        };

        this.customStyleInterface['validateCallback'] = () => {
          requestAnimationFrame(() => {
            if (this.customStyleInterface['enqueued']) {
              this.flushCustomStyles();
            }
          });
        };
      }
    }
    /**
     * @param {!HTMLTemplateElement} template
     * @param {string} elementName
     */


    prepareTemplate(template, elementName) {
      this.ensure();

      if (elementHasBuiltCss(template)) {
        return;
      }

      templateMap[elementName] = template;
      let ast = applyShim.transformTemplate(template, elementName); // save original style ast to use for revalidating instances

      template['_styleAst'] = ast;
    }

    flushCustomStyles() {
      this.ensure();

      if (!this.customStyleInterface) {
        return;
      }

      let styles = this.customStyleInterface['processStyles']();

      if (!this.customStyleInterface['enqueued']) {
        return;
      }

      for (let i = 0; i < styles.length; i++) {
        let cs = styles[i];
        let style = this.customStyleInterface['getStyleForCustomStyle'](cs);

        if (style) {
          applyShim.transformCustomStyle(style);
        }
      }

      this.customStyleInterface['enqueued'] = false;
    }
    /**
     * @param {HTMLElement} element
     * @param {Object=} properties
     */


    styleSubtree(element, properties) {
      this.ensure();

      if (properties) {
        updateNativeProperties(element, properties);
      }

      if (element.shadowRoot) {
        this.styleElement(element);
        let shadowChildren =
        /** @type {!ParentNode} */
        element.shadowRoot.children || element.shadowRoot.childNodes;

        for (let i = 0; i < shadowChildren.length; i++) {
          this.styleSubtree(
          /** @type {HTMLElement} */
          shadowChildren[i]);
        }
      } else {
        let children = element.children || element.childNodes;

        for (let i = 0; i < children.length; i++) {
          this.styleSubtree(
          /** @type {HTMLElement} */
          children[i]);
        }
      }
    }
    /**
     * @param {HTMLElement} element
     */


    styleElement(element) {
      this.ensure();
      let {
        is
      } = getIsExtends(element);
      let template = templateMap[is];

      if (template && elementHasBuiltCss(template)) {
        return;
      }

      if (template && !templateIsValid(template)) {
        // only revalidate template once
        if (!templateIsValidating(template)) {
          this.prepareTemplate(template, is);
          startValidatingTemplate(template);
        } // update this element instance


        let root = element.shadowRoot;

        if (root) {
          let style =
          /** @type {HTMLStyleElement} */
          root.querySelector('style');

          if (style) {
            // reuse the template's style ast, it has all the original css text
            style['__cssRules'] = template['_styleAst'];
            style.textContent = toCssText(template['_styleAst']);
          }
        }
      }
    }
    /**
     * @param {Object=} properties
     */


    styleDocument(properties) {
      this.ensure();
      this.styleSubtree(document.body, properties);
    }

  }

  if (!window.ShadyCSS || !window.ShadyCSS.ScopingShim) {
    const applyShimInterface = new ApplyShimInterface();
    let CustomStyleInterface = window.ShadyCSS && window.ShadyCSS.CustomStyleInterface;
    /** @suppress {duplicate} */

    window.ShadyCSS = {
      /**
       * @param {!HTMLTemplateElement} template
       * @param {string} elementName
       * @param {string=} elementExtends
       */
      prepareTemplate(template, elementName, elementExtends) {
        // eslint-disable-line no-unused-vars
        applyShimInterface.flushCustomStyles();
        applyShimInterface.prepareTemplate(template, elementName);
      },

      /**
       * @param {!HTMLTemplateElement} template
       * @param {string} elementName
       * @param {string=} elementExtends
       */
      prepareTemplateStyles(template, elementName, elementExtends) {
        window.ShadyCSS.prepareTemplate(template, elementName, elementExtends);
      },

      /**
       * @param {!HTMLTemplateElement} template
       * @param {string} elementName
       */
      prepareTemplateDom(template, elementName) {},

      // eslint-disable-line no-unused-vars

      /**
       * @param {!HTMLElement} element
       * @param {Object=} properties
       */
      styleSubtree(element, properties) {
        applyShimInterface.flushCustomStyles();
        applyShimInterface.styleSubtree(element, properties);
      },

      /**
       * @param {!HTMLElement} element
       */
      styleElement(element) {
        applyShimInterface.flushCustomStyles();
        applyShimInterface.styleElement(element);
      },

      /**
       * @param {Object=} properties
       */
      styleDocument(properties) {
        applyShimInterface.flushCustomStyles();
        applyShimInterface.styleDocument(properties);
      },

      /**
       * @param {Element} element
       * @param {string} property
       * @return {string}
       */
      getComputedStyleValue(element, property) {
        return getComputedStyleValue(element, property);
      },

      flushCustomStyles() {
        applyShimInterface.flushCustomStyles();
      },

      nativeCss: nativeCssVariables,
      nativeShadow: nativeShadow,
      cssBuild: cssBuild,
      disableRuntime: disableRuntime
    };

    if (CustomStyleInterface) {
      window.ShadyCSS.CustomStyleInterface = CustomStyleInterface;
    }
  }

  window.ShadyCSS.ApplyShim = applyShim;

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  /* eslint-disable no-unused-vars */

  /**
   * When using Closure Compiler, JSCompiler_renameProperty(property, object) is replaced by the munged name for object[property]
   * We cannot alias this function, so we have to use a small shim that has the same behavior when not compiling.
   *
   * @param {?} prop Property name
   * @param {*} obj Reference object
   * @return {string} Potentially renamed property name
   */
  window.JSCompiler_renameProperty = function (prop, obj) {
    return prop;
  };

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  let CSS_URL_RX = /(url\()([^)]*)(\))/g;
  let ABS_URL = /(^\/[^\/])|(^#)|(^[\w-\d]*:)/;
  let workingURL;
  let resolveDoc;
  /**
   * Resolves the given URL against the provided `baseUri'.
   *
   * Note that this function performs no resolution for URLs that start
   * with `/` (absolute URLs) or `#` (hash identifiers).  For general purpose
   * URL resolution, use `window.URL`.
   *
   * @param {string} url Input URL to resolve
   * @param {?string=} baseURI Base URI to resolve the URL against
   * @return {string} resolved URL
   */

  function resolveUrl(url, baseURI) {
    if (url && ABS_URL.test(url)) {
      return url;
    }

    if (url === '//') {
      return url;
    } // Lazy feature detection.


    if (workingURL === undefined) {
      workingURL = false;

      try {
        const u = new URL('b', 'http://a');
        u.pathname = 'c%20d';
        workingURL = u.href === 'http://a/c%20d';
      } catch (e) {// silently fail
      }
    }

    if (!baseURI) {
      baseURI = document.baseURI || window.location.href;
    }

    if (workingURL) {
      try {
        return new URL(url, baseURI).href;
      } catch (e) {
        // Bad url or baseURI structure. Do not attempt to resolve.
        return url;
      }
    } // Fallback to creating an anchor into a disconnected document.


    if (!resolveDoc) {
      resolveDoc = document.implementation.createHTMLDocument('temp');
      resolveDoc.base = resolveDoc.createElement('base');
      resolveDoc.head.appendChild(resolveDoc.base);
      resolveDoc.anchor = resolveDoc.createElement('a');
      resolveDoc.body.appendChild(resolveDoc.anchor);
    }

    resolveDoc.base.href = baseURI;
    resolveDoc.anchor.href = url;
    return resolveDoc.anchor.href || url;
  }
  /**
   * Resolves any relative URL's in the given CSS text against the provided
   * `ownerDocument`'s `baseURI`.
   *
   * @param {string} cssText CSS text to process
   * @param {string} baseURI Base URI to resolve the URL against
   * @return {string} Processed CSS text with resolved URL's
   */

  function resolveCss(cssText, baseURI) {
    return cssText.replace(CSS_URL_RX, function (m, pre, url, post) {
      return pre + '\'' + resolveUrl(url.replace(/["']/g, ''), baseURI) + '\'' + post;
    });
  }
  /**
   * Returns a path from a given `url`. The path includes the trailing
   * `/` from the url.
   *
   * @param {string} url Input URL to transform
   * @return {string} resolved path
   */

  function pathFromUrl(url) {
    return url.substring(0, url.lastIndexOf('/') + 1);
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  const useShadow = !window.ShadyDOM || !window.ShadyDOM.inUse;
  const useNativeCSSProperties = Boolean(!window.ShadyCSS || window.ShadyCSS.nativeCss);
  const supportsAdoptingStyleSheets$1 = useShadow && 'adoptedStyleSheets' in Document.prototype && 'replaceSync' in CSSStyleSheet.prototype && // Since spec may change, feature detect exact API we need
  (() => {
    try {
      const sheet = new CSSStyleSheet();
      sheet.replaceSync('');
      const host = document.createElement('div');
      host.attachShadow({
        mode: 'open'
      });
      host.shadowRoot.adoptedStyleSheets = [sheet];
      return host.shadowRoot.adoptedStyleSheets[0] === sheet;
    } catch (e) {
      return false;
    }
  })();
  /**
   * Globally settable property that is automatically assigned to
   * `ElementMixin` instances, useful for binding in templates to
   * make URL's relative to an application's root.  Defaults to the main
   * document URL, but can be overridden by users.  It may be useful to set
   * `rootPath` to provide a stable application mount path when
   * using client side routing.
   */

  let rootPath = window.Polymer && window.Polymer.rootPath || pathFromUrl(document.baseURI || window.location.href);
  /**
   * A global callback used to sanitize any value before inserting it into the DOM.
   * The callback signature is:
   *
   *  function sanitizeDOMValue(value, name, type, node) { ... }
   *
   * Where:
   *
   * `value` is the value to sanitize.
   * `name` is the name of an attribute or property (for example, href).
   * `type` indicates where the value is being inserted: one of property, attribute, or text.
   * `node` is the node where the value is being inserted.
   *
   * @type {(function(*,string,string,?Node):*)|undefined}
   */

  let sanitizeDOMValue = window.Polymer && window.Polymer.sanitizeDOMValue || undefined;
  /**
   * Globally settable property to make Polymer Gestures use passive TouchEvent listeners when recognizing gestures.
   * When set to `true`, gestures made from touch will not be able to prevent scrolling, allowing for smoother
   * scrolling performance.
   * Defaults to `false` for backwards compatibility.
   */

  let passiveTouchGestures = window.Polymer && window.Polymer.setPassiveTouchGestures || false;
  /**
   * Setting to ensure Polymer template evaluation only occurs based on tempates
   * defined in trusted script.  When true, `<dom-module>` re-registration is
   * disallowed, `<dom-bind>` is disabled, and `<dom-if>`/`<dom-repeat>`
   * templates will only evaluate in the context of a trusted element template.
   */

  let strictTemplatePolicy = window.Polymer && window.Polymer.strictTemplatePolicy || false;
  /**
   * Setting to enable dom-module lookup from Polymer.Element.  By default,
   * templates must be defined in script using the `static get template()`
   * getter and the `html` tag function.  To enable legacy loading of templates
   * via dom-module, set this flag to true.
   */

  let allowTemplateFromDomModule = window.Polymer && window.Polymer.allowTemplateFromDomModule || false;
  /**
   * Setting to skip processing style includes and re-writing urls in css styles.
   * Normally "included" styles are pulled into the element and all urls in styles
   * are re-written to be relative to the containing script url.
   * If no includes or relative urls are used in styles, these steps can be
   * skipped as an optimization.
   */

  let legacyOptimizations = window.Polymer && window.Polymer.legacyOptimizations || false;
  /**
   * Setting to add warnings useful when migrating from Polymer 1.x to 2.x.
   */

  let legacyWarnings = window.Polymer && window.Polymer.legacyWarnings || false;
  /**
   * Setting to perform initial rendering synchronously when running under ShadyDOM.
   * This matches the behavior of Polymer 1.
   */

  let syncInitialRender = window.Polymer && window.Polymer.syncInitialRender || false;
  /**
   * Setting to retain the legacy Polymer 1 behavior for multi-property
   * observers around undefined values. Observers and computed property methods
   * are not called until no argument is undefined.
   */

  let legacyUndefined = window.Polymer && window.Polymer.legacyUndefined || false;
  /**
   * Setting to ensure computed properties are computed in order to ensure
   * re-computation never occurs in a given turn.
   */

  let orderedComputed = window.Polymer && window.Polymer.orderedComputed || false;
  /**
   * Setting to remove nested templates inside `dom-if` and `dom-repeat` as
   * part of element template parsing.  This is a performance optimization that
   * eliminates most of the tax of needing two elements due to the loss of
   * type-extended templates as a result of the V1 specification changes.
   */

  let removeNestedTemplates = window.Polymer && window.Polymer.removeNestedTemplates || false;
  /**
   * Setting to place `dom-if` elements in a performance-optimized mode that takes
   * advantage of lighter-weight host runtime template stamping to eliminate the
   * need for an intermediate Templatizer `TemplateInstance` to mange the nodes
   * stamped by `dom-if`.  Under this setting, any Templatizer-provided API's
   * such as `modelForElement` will not be available for nodes stamped by
   * `dom-if`.
   */

  let fastDomIf = window.Polymer && window.Polymer.fastDomIf || false;
  /**
   * Setting to disable `dom-change` and `rendered-item-count` events from
   * `dom-if` and `dom-repeat`. Users can opt back into `dom-change` events by
   * setting the `notify-dom-change` attribute (`notifyDomChange: true` property)
   * to `dom-if`/`don-repeat` instances.
   */

  let suppressTemplateNotifications = window.Polymer && window.Polymer.suppressTemplateNotifications || false;
  /**
   * Setting to disable use of dynamic attributes. This is an optimization
   * to avoid setting `observedAttributes`. Instead attributes are read
   * once at create time and set/removeAttribute are patched.
   */

  let legacyNoObservedAttributes = window.Polymer && window.Polymer.legacyNoObservedAttributes || false;
  /**
   * Setting to enable use of `adoptedStyleSheets` for sharing style sheets
   * between component instances' shadow roots, if the app uses built Shady CSS
   * styles.
   */

  let useAdoptedStyleSheetsWithBuiltCSS = window.Polymer && window.Polymer.useAdoptedStyleSheetsWithBuiltCSS || false;

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  let dedupeId = 0;
  /* eslint-disable valid-jsdoc */

  /**
   * Wraps an ES6 class expression mixin such that the mixin is only applied
   * if it has not already been applied its base argument. Also memoizes mixin
   * applications.
   *
   * @template T
   * @param {T} mixin ES6 class expression mixin to wrap
   * @return {T}
   * @suppress {invalidCasts}
   */

  const dedupingMixin = function (mixin) {
    let mixinApplications =
    /** @type {!MixinFunction} */
    mixin.__mixinApplications;

    if (!mixinApplications) {
      mixinApplications = new WeakMap();
      /** @type {!MixinFunction} */

      mixin.__mixinApplications = mixinApplications;
    } // maintain a unique id for each mixin


    let mixinDedupeId = dedupeId++;

    function dedupingMixin(base) {
      let baseSet =
      /** @type {!MixinFunction} */
      base.__mixinSet;

      if (baseSet && baseSet[mixinDedupeId]) {
        return base;
      }

      let map = mixinApplications;
      let extended = map.get(base);

      if (!extended) {
        extended =
        /** @type {!Function} */
        mixin(base);
        map.set(base, extended); // copy inherited mixin set from the extended class, or the base class
        // NOTE: we avoid use of Set here because some browser (IE11)
        // cannot extend a base Set via the constructor.

        let mixinSet = Object.create(
        /** @type {!MixinFunction} */
        extended.__mixinSet || baseSet || null);
        mixinSet[mixinDedupeId] = true;
        /** @type {!MixinFunction} */

        extended.__mixinSet = mixinSet;
      }

      return extended;
    }

    return dedupingMixin;
  };
  /* eslint-enable valid-jsdoc */

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  let modules = {};
  let lcModules = {};
  /**
   * Sets a dom-module into the global registry by id.
   *
   * @param {string} id dom-module id
   * @param {DomModule} module dom-module instance
   * @return {void}
   */

  function setModule(id, module) {
    // store id separate from lowercased id so that
    // in all cases mixedCase id will stored distinctly
    // and lowercase version is a fallback
    modules[id] = lcModules[id.toLowerCase()] = module;
  }
  /**
   * Retrieves a dom-module from the global registry by id.
   *
   * @param {string} id dom-module id
   * @return {DomModule!} dom-module instance
   */


  function findModule(id) {
    return modules[id] || lcModules[id.toLowerCase()];
  }

  function styleOutsideTemplateCheck(inst) {
    if (inst.querySelector('style')) {
      console.warn('dom-module %s has style outside template', inst.id);
    }
  }
  /**
   * The `dom-module` element registers the dom it contains to the name given
   * by the module's id attribute. It provides a unified database of dom
   * accessible via its static `import` API.
   *
   * A key use case of `dom-module` is for providing custom element `<template>`s
   * via HTML imports that are parsed by the native HTML parser, that can be
   * relocated during a bundling pass and still looked up by `id`.
   *
   * Example:
   *
   *     <dom-module id="foo">
   *       <img src="stuff.png">
   *     </dom-module>
   *
   * Then in code in some other location that cannot access the dom-module above
   *
   *     let img = customElements.get('dom-module').import('foo', 'img');
   *
   * @customElement
   * @extends HTMLElement
   * @summary Custom element that provides a registry of relocatable DOM content
   *   by `id` that is agnostic to bundling.
   * @unrestricted
   */


  class DomModule extends HTMLElement {
    /** @override */
    static get observedAttributes() {
      return ['id'];
    }
    /**
     * Retrieves the element specified by the css `selector` in the module
     * registered by `id`. For example, this.import('foo', 'img');
     * @param {string} id The id of the dom-module in which to search.
     * @param {string=} selector The css selector by which to find the element.
     * @return {Element} Returns the element which matches `selector` in the
     * module registered at the specified `id`.
     *
     * @export
     * @nocollapse Referred to indirectly in style-gather.js
     */


    static import(id, selector) {
      if (id) {
        let m = findModule(id);

        if (m && selector) {
          return m.querySelector(selector);
        }

        return m;
      }

      return null;
    }
    /* eslint-disable no-unused-vars */

    /**
     * @param {string} name Name of attribute.
     * @param {?string} old Old value of attribute.
     * @param {?string} value Current value of attribute.
     * @param {?string} namespace Attribute namespace.
     * @return {void}
     * @override
     */


    attributeChangedCallback(name, old, value, namespace) {
      if (old !== value) {
        this.register();
      }
    }
    /* eslint-enable no-unused-args */

    /**
     * The absolute URL of the original location of this `dom-module`.
     *
     * This value will differ from this element's `ownerDocument` in the
     * following ways:
     * - Takes into account any `assetpath` attribute added during bundling
     *   to indicate the original location relative to the bundled location
     * - Uses the HTMLImports polyfill's `importForElement` API to ensure
     *   the path is relative to the import document's location since
     *   `ownerDocument` is not currently polyfilled
     */


    get assetpath() {
      // Don't override existing assetpath.
      if (!this.__assetpath) {
        // note: assetpath set via an attribute must be relative to this
        // element's location; accomodate polyfilled HTMLImports
        const owner = window.HTMLImports && HTMLImports.importForElement ? HTMLImports.importForElement(this) || document : this.ownerDocument;
        const url = resolveUrl(this.getAttribute('assetpath') || '', owner.baseURI);
        this.__assetpath = pathFromUrl(url);
      }

      return this.__assetpath;
    }
    /**
     * Registers the dom-module at a given id. This method should only be called
     * when a dom-module is imperatively created. For
     * example, `document.createElement('dom-module').register('foo')`.
     * @param {string=} id The id at which to register the dom-module.
     * @return {void}
     */


    register(id) {
      id = id || this.id;

      if (id) {
        // Under strictTemplatePolicy, reject and null out any re-registered
        // dom-module since it is ambiguous whether first-in or last-in is trusted
        if (strictTemplatePolicy && findModule(id) !== undefined) {
          setModule(id, null);
          throw new Error(`strictTemplatePolicy: dom-module ${id} re-registered`);
        }

        this.id = id;
        setModule(id, this);
        styleOutsideTemplateCheck(this);
      }
    }

  }
  DomModule.prototype['modules'] = modules;
  customElements.define('dom-module', DomModule);

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  const MODULE_STYLE_LINK_SELECTOR = 'link[rel=import][type~=css]';
  const INCLUDE_ATTR = 'include';
  const SHADY_UNSCOPED_ATTR = 'shady-unscoped';
  /**
   * @param {string} moduleId .
   * @return {?DomModule} .
   */

  function importModule(moduleId) {
    return (
      /** @type {?DomModule} */
      DomModule.import(moduleId)
    );
  }

  function styleForImport(importDoc) {
    // NOTE: polyfill affordance.
    // under the HTMLImports polyfill, there will be no 'body',
    // but the import pseudo-doc can be used directly.
    let container = importDoc.body ? importDoc.body : importDoc;
    const importCss = resolveCss(container.textContent, importDoc.baseURI);
    const style = document.createElement('style');
    style.textContent = importCss;
    return style;
  }

  /**
   * Returns a list of <style> elements in a space-separated list of `dom-module`s.
   *
   * @function
   * @param {string} moduleIds List of dom-module id's within which to
   * search for css.
   * @return {!Array<!HTMLStyleElement>} Array of contained <style> elements
   */

  function stylesFromModules(moduleIds) {
    const modules = moduleIds.trim().split(/\s+/);
    const styles = [];

    for (let i = 0; i < modules.length; i++) {
      styles.push(...stylesFromModule(modules[i]));
    }

    return styles;
  }
  /**
   * Returns a list of <style> elements in a given `dom-module`.
   * Styles in a `dom-module` can come either from `<style>`s within the
   * first `<template>`, or else from one or more
   * `<link rel="import" type="css">` links outside the template.
   *
   * @param {string} moduleId dom-module id to gather styles from
   * @return {!Array<!HTMLStyleElement>} Array of contained styles.
   */

  function stylesFromModule(moduleId) {
    const m = importModule(moduleId);

    if (!m) {
      console.warn('Could not find style data in module named', moduleId);
      return [];
    }

    if (m._styles === undefined) {
      const styles = []; // module imports: <link rel="import" type="css">

      styles.push(..._stylesFromModuleImports(m)); // include css from the first template in the module

      const template =
      /** @type {?HTMLTemplateElement} */
      m.querySelector('template');

      if (template) {
        styles.push(...stylesFromTemplate(template,
        /** @type {templateWithAssetPath} */
        m.assetpath));
      }

      m._styles = styles;
    }

    return m._styles;
  }
  /**
   * Returns the `<style>` elements within a given template.
   *
   * @param {!HTMLTemplateElement} template Template to gather styles from
   * @param {string=} baseURI baseURI for style content
   * @return {!Array<!HTMLStyleElement>} Array of styles
   */

  function stylesFromTemplate(template, baseURI) {
    if (!template._styles) {
      const styles = []; // if element is a template, get content from its .content

      const e$ = template.content.querySelectorAll('style');

      for (let i = 0; i < e$.length; i++) {
        let e = e$[i]; // support style sharing by allowing styles to "include"
        // other dom-modules that contain styling

        let include = e.getAttribute(INCLUDE_ATTR);

        if (include) {
          styles.push(...stylesFromModules(include).filter(function (item, index, self) {
            return self.indexOf(item) === index;
          }));
        }

        if (baseURI) {
          e.textContent = resolveCss(e.textContent,
          /** @type {string} */
          baseURI);
        }

        styles.push(e);
      }

      template._styles = styles;
    }

    return template._styles;
  }
  /**
   * Returns a list of <style> elements  from stylesheets loaded via `<link rel="import" type="css">` links within the specified `dom-module`.
   *
   * @param {string} moduleId Id of `dom-module` to gather CSS from
   * @return {!Array<!HTMLStyleElement>} Array of contained styles.
   */

  function stylesFromModuleImports(moduleId) {
    let m = importModule(moduleId);
    return m ? _stylesFromModuleImports(m) : [];
  }
  /**
   * @param {!HTMLElement} module dom-module element that could contain `<link rel="import" type="css">` styles
   * @return {!Array<!HTMLStyleElement>} Array of contained styles
   */

  function _stylesFromModuleImports(module) {
    const styles = [];
    const p$ = module.querySelectorAll(MODULE_STYLE_LINK_SELECTOR);

    for (let i = 0; i < p$.length; i++) {
      let p = p$[i];

      if (p.import) {
        const importDoc = p.import;
        const unscoped = p.hasAttribute(SHADY_UNSCOPED_ATTR);

        if (unscoped && !importDoc._unscopedStyle) {
          const style = styleForImport(importDoc);
          style.setAttribute(SHADY_UNSCOPED_ATTR, '');
          importDoc._unscopedStyle = style;
        } else if (!importDoc._style) {
          importDoc._style = styleForImport(importDoc);
        }

        styles.push(unscoped ? importDoc._unscopedStyle : importDoc._style);
      }
    }

    return styles;
  }
  /**
   *
   * Returns CSS text of styles in a space-separated list of `dom-module`s.
   * Note: This method is deprecated, use `stylesFromModules` instead.
   *
   * @deprecated
   * @param {string} moduleIds List of dom-module id's within which to
   * search for css.
   * @return {string} Concatenated CSS content from specified `dom-module`s
   */


  function cssFromModules(moduleIds) {
    let modules = moduleIds.trim().split(/\s+/);
    let cssText = '';

    for (let i = 0; i < modules.length; i++) {
      cssText += cssFromModule(modules[i]);
    }

    return cssText;
  }
  /**
   * Returns CSS text of styles in a given `dom-module`.  CSS in a `dom-module`
   * can come either from `<style>`s within the first `<template>`, or else
   * from one or more `<link rel="import" type="css">` links outside the
   * template.
   *
   * Any `<styles>` processed are removed from their original location.
   * Note: This method is deprecated, use `styleFromModule` instead.
   *
   * @deprecated
   * @param {string} moduleId dom-module id to gather styles from
   * @return {string} Concatenated CSS content from specified `dom-module`
   */

  function cssFromModule(moduleId) {
    let m = importModule(moduleId);

    if (m && m._cssText === undefined) {
      // module imports: <link rel="import" type="css">
      let cssText = _cssFromModuleImports(m); // include css from the first template in the module


      let t =
      /** @type {?HTMLTemplateElement} */
      m.querySelector('template');

      if (t) {
        cssText += cssFromTemplate(t,
        /** @type {templateWithAssetPath} */
        m.assetpath);
      }

      m._cssText = cssText || null;
    }

    if (!m) {
      console.warn('Could not find style data in module named', moduleId);
    }

    return m && m._cssText || '';
  }
  /**
   * Returns CSS text of `<styles>` within a given template.
   *
   * Any `<styles>` processed are removed from their original location.
   * Note: This method is deprecated, use `styleFromTemplate` instead.
   *
   * @deprecated
   * @param {!HTMLTemplateElement} template Template to gather styles from
   * @param {string} baseURI Base URI to resolve the URL against
   * @return {string} Concatenated CSS content from specified template
   */

  function cssFromTemplate(template, baseURI) {
    let cssText = '';
    const e$ = stylesFromTemplate(template, baseURI); // if element is a template, get content from its .content

    for (let i = 0; i < e$.length; i++) {
      let e = e$[i];

      if (e.parentNode) {
        e.parentNode.removeChild(e);
      }

      cssText += e.textContent;
    }

    return cssText;
  }
  /**
   * @deprecated
   * @param {!HTMLElement} module dom-module element that could contain `<link rel="import" type="css">` styles
   * @return {string} Concatenated CSS content from links in the dom-module
   */

  function _cssFromModuleImports(module) {
    let cssText = '';

    let styles = _stylesFromModuleImports(module);

    for (let i = 0; i < styles.length; i++) {
      cssText += styles[i].textContent;
    }

    return cssText;
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  /* eslint-disable valid-jsdoc */

  /**
   * Node wrapper to ensure ShadowDOM safe operation regardless of polyfill
   * presence or mode. Note that with the introduction of `ShadyDOM.noPatch`,
   * a node wrapper must be used to access ShadowDOM API.
   * This is similar to using `Polymer.dom` but relies exclusively
   * on the presence of the ShadyDOM polyfill rather than requiring the loading
   * of legacy (Polymer.dom) API.
   * @type {function(Node):Node}
   */
  const wrap$1 = window['ShadyDOM'] && window['ShadyDOM']['noPatch'] && window['ShadyDOM']['wrap'] ? window['ShadyDOM']['wrap'] : window['ShadyDOM'] ? n => ShadyDOM['patch'](n) : n => n;

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * Module with utilities for manipulating structured data path strings.
   *
   * @summary Module with utilities for manipulating structured data path strings.
   */

  /**
   * Returns true if the given string is a structured data path (has dots).
   *
   * Example:
   *
   * ```
   * isPath('foo.bar.baz') // true
   * isPath('foo')         // false
   * ```
   *
   * @param {string} path Path string
   * @return {boolean} True if the string contained one or more dots
   */

  function isPath(path) {
    return path.indexOf('.') >= 0;
  }
  /**
   * Returns the root property name for the given path.
   *
   * Example:
   *
   * ```
   * root('foo.bar.baz') // 'foo'
   * root('foo')         // 'foo'
   * ```
   *
   * @param {string} path Path string
   * @return {string} Root property name
   */

  function root(path) {
    let dotIndex = path.indexOf('.');

    if (dotIndex === -1) {
      return path;
    }

    return path.slice(0, dotIndex);
  }
  /**
   * Given `base` is `foo.bar`, `foo` is an ancestor, `foo.bar` is not
   * Returns true if the given path is an ancestor of the base path.
   *
   * Example:
   *
   * ```
   * isAncestor('foo.bar', 'foo')         // true
   * isAncestor('foo.bar', 'foo.bar')     // false
   * isAncestor('foo.bar', 'foo.bar.baz') // false
   * ```
   *
   * @param {string} base Path string to test against.
   * @param {string} path Path string to test.
   * @return {boolean} True if `path` is an ancestor of `base`.
   */

  function isAncestor(base, path) {
    //     base.startsWith(path + '.');
    return base.indexOf(path + '.') === 0;
  }
  /**
   * Given `base` is `foo.bar`, `foo.bar.baz` is an descendant
   *
   * Example:
   *
   * ```
   * isDescendant('foo.bar', 'foo.bar.baz') // true
   * isDescendant('foo.bar', 'foo.bar')     // false
   * isDescendant('foo.bar', 'foo')         // false
   * ```
   *
   * @param {string} base Path string to test against.
   * @param {string} path Path string to test.
   * @return {boolean} True if `path` is a descendant of `base`.
   */

  function isDescendant(base, path) {
    //     path.startsWith(base + '.');
    return path.indexOf(base + '.') === 0;
  }
  /**
   * Replaces a previous base path with a new base path, preserving the
   * remainder of the path.
   *
   * User must ensure `path` has a prefix of `base`.
   *
   * Example:
   *
   * ```
   * translate('foo.bar', 'zot', 'foo.bar.baz') // 'zot.baz'
   * ```
   *
   * @param {string} base Current base string to remove
   * @param {string} newBase New base string to replace with
   * @param {string} path Path to translate
   * @return {string} Translated string
   */

  function translate(base, newBase, path) {
    return newBase + path.slice(base.length);
  }
  /**
   * @param {string} base Path string to test against
   * @param {string} path Path string to test
   * @return {boolean} True if `path` is equal to `base`
   */

  function matches(base, path) {
    return base === path || isAncestor(base, path) || isDescendant(base, path);
  }
  /**
   * Converts array-based paths to flattened path.  String-based paths
   * are returned as-is.
   *
   * Example:
   *
   * ```
   * normalize(['foo.bar', 0, 'baz'])  // 'foo.bar.0.baz'
   * normalize('foo.bar.0.baz')        // 'foo.bar.0.baz'
   * ```
   *
   * @param {string | !Array<string|number>} path Input path
   * @return {string} Flattened path
   */

  function normalize(path) {
    if (Array.isArray(path)) {
      let parts = [];

      for (let i = 0; i < path.length; i++) {
        let args = path[i].toString().split('.');

        for (let j = 0; j < args.length; j++) {
          parts.push(args[j]);
        }
      }

      return parts.join('.');
    } else {
      return path;
    }
  }
  /**
   * Splits a path into an array of property names. Accepts either arrays
   * of path parts or strings.
   *
   * Example:
   *
   * ```
   * split(['foo.bar', 0, 'baz'])  // ['foo', 'bar', '0', 'baz']
   * split('foo.bar.0.baz')        // ['foo', 'bar', '0', 'baz']
   * ```
   *
   * @param {string | !Array<string|number>} path Input path
   * @return {!Array<string>} Array of path parts
   * @suppress {checkTypes}
   */

  function split(path) {
    if (Array.isArray(path)) {
      return normalize(path).split('.');
    }

    return path.toString().split('.');
  }
  /**
   * Reads a value from a path.  If any sub-property in the path is `undefined`,
   * this method returns `undefined` (will never throw.
   *
   * @param {Object} root Object from which to dereference path from
   * @param {string | !Array<string|number>} path Path to read
   * @param {Object=} info If an object is provided to `info`, the normalized
   *  (flattened) path will be set to `info.path`.
   * @return {*} Value at path, or `undefined` if the path could not be
   *  fully dereferenced.
   */

  function get(root, path, info) {
    let prop = root;
    let parts = split(path); // Loop over path parts[0..n-1] and dereference

    for (let i = 0; i < parts.length; i++) {
      if (!prop) {
        return;
      }

      let part = parts[i];
      prop = prop[part];
    }

    if (info) {
      info.path = parts.join('.');
    }

    return prop;
  }
  /**
   * Sets a value to a path.  If any sub-property in the path is `undefined`,
   * this method will no-op.
   *
   * @param {Object} root Object from which to dereference path from
   * @param {string | !Array<string|number>} path Path to set
   * @param {*} value Value to set to path
   * @return {string | undefined} The normalized version of the input path
   */

  function set(root, path, value) {
    let prop = root;
    let parts = split(path);
    let last = parts[parts.length - 1];

    if (parts.length > 1) {
      // Loop over path parts[0..n-2] and dereference
      for (let i = 0; i < parts.length - 1; i++) {
        let part = parts[i];
        prop = prop[part];

        if (!prop) {
          return;
        }
      } // Set value to object at end of path


      prop[last] = value;
    } else {
      // Simple property set
      prop[path] = value;
    }

    return parts.join('.');
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  const caseMap = {};
  const DASH_TO_CAMEL = /-[a-z]/g;
  const CAMEL_TO_DASH = /([A-Z])/g;
  /**
   * @fileoverview Module with utilities for converting between "dash-case" and
   * "camelCase" identifiers.
   */

  /**
   * Converts "dash-case" identifier (e.g. `foo-bar-baz`) to "camelCase"
   * (e.g. `fooBarBaz`).
   *
   * @param {string} dash Dash-case identifier
   * @return {string} Camel-case representation of the identifier
   */

  function dashToCamelCase(dash) {
    return caseMap[dash] || (caseMap[dash] = dash.indexOf('-') < 0 ? dash : dash.replace(DASH_TO_CAMEL, m => m[1].toUpperCase()));
  }
  /**
   * Converts "camelCase" identifier (e.g. `fooBarBaz`) to "dash-case"
   * (e.g. `foo-bar-baz`).
   *
   * @param {string} camel Camel-case identifier
   * @return {string} Dash-case representation of the identifier
   */

  function camelToDashCase(camel) {
    return caseMap[camel] || (caseMap[camel] = camel.replace(CAMEL_TO_DASH, '-$1').toLowerCase());
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  let microtaskCurrHandle = 0;
  let microtaskLastHandle = 0;
  let microtaskCallbacks = [];
  let microtaskNodeContent = 0;
  let microtaskScheduled = false;
  let microtaskNode = document.createTextNode('');
  new window.MutationObserver(microtaskFlush).observe(microtaskNode, {
    characterData: true
  });

  function microtaskFlush() {
    microtaskScheduled = false;
    const len = microtaskCallbacks.length;

    for (let i = 0; i < len; i++) {
      let cb = microtaskCallbacks[i];

      if (cb) {
        try {
          cb();
        } catch (e) {
          setTimeout(() => {
            throw e;
          });
        }
      }
    }

    microtaskCallbacks.splice(0, len);
    microtaskLastHandle += len;
  }
  /**
   * Async interface wrapper around `setTimeout`.
   *
   * @namespace
   * @summary Async interface wrapper around `setTimeout`.
   */


  const timeOut = {
    /**
     * Returns a sub-module with the async interface providing the provided
     * delay.
     *
     * @memberof timeOut
     * @param {number=} delay Time to wait before calling callbacks in ms
     * @return {!AsyncInterface} An async timeout interface
     */
    after(delay) {
      return {
        run(fn) {
          return window.setTimeout(fn, delay);
        },

        cancel(handle) {
          window.clearTimeout(handle);
        }

      };
    },

    /**
     * Enqueues a function called in the next task.
     *
     * @memberof timeOut
     * @param {!Function} fn Callback to run
     * @param {number=} delay Delay in milliseconds
     * @return {number} Handle used for canceling task
     */
    run(fn, delay) {
      return window.setTimeout(fn, delay);
    },

    /**
     * Cancels a previously enqueued `timeOut` callback.
     *
     * @memberof timeOut
     * @param {number} handle Handle returned from `run` of callback to cancel
     * @return {void}
     */
    cancel(handle) {
      window.clearTimeout(handle);
    }

  };
  /**
   * Async interface wrapper around `requestAnimationFrame`.
   *
   * @namespace
   * @summary Async interface wrapper around `requestAnimationFrame`.
   */

  const animationFrame = {
    /**
     * Enqueues a function called at `requestAnimationFrame` timing.
     *
     * @memberof animationFrame
     * @param {function(number):void} fn Callback to run
     * @return {number} Handle used for canceling task
     */
    run(fn) {
      return window.requestAnimationFrame(fn);
    },

    /**
     * Cancels a previously enqueued `animationFrame` callback.
     *
     * @memberof animationFrame
     * @param {number} handle Handle returned from `run` of callback to cancel
     * @return {void}
     */
    cancel(handle) {
      window.cancelAnimationFrame(handle);
    }

  };
  /**
   * Async interface for enqueuing callbacks that run at microtask timing.
   *
   * Note that microtask timing is achieved via a single `MutationObserver`,
   * and thus callbacks enqueued with this API will all run in a single
   * batch, and not interleaved with other microtasks such as promises.
   * Promises are avoided as an implementation choice for the time being
   * due to Safari bugs that cause Promises to lack microtask guarantees.
   *
   * @namespace
   * @summary Async interface for enqueuing callbacks that run at microtask
   *   timing.
   */

  const microTask = {
    /**
     * Enqueues a function called at microtask timing.
     *
     * @memberof microTask
     * @param {!Function=} callback Callback to run
     * @return {number} Handle used for canceling task
     */
    run(callback) {
      if (!microtaskScheduled) {
        microtaskScheduled = true;
        microtaskNode.textContent = microtaskNodeContent++;
      }

      microtaskCallbacks.push(callback);
      return microtaskCurrHandle++;
    },

    /**
     * Cancels a previously enqueued `microTask` callback.
     *
     * @memberof microTask
     * @param {number} handle Handle returned from `run` of callback to cancel
     * @return {void}
     */
    cancel(handle) {
      const idx = handle - microtaskLastHandle;

      if (idx >= 0) {
        if (!microtaskCallbacks[idx]) {
          throw new Error('invalid async handle: ' + handle);
        }

        microtaskCallbacks[idx] = null;
      }
    }

  };

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /** @const {!AsyncInterface} */

  const microtask = microTask;
  /**
   * Element class mixin that provides basic meta-programming for creating one
   * or more property accessors (getter/setter pair) that enqueue an async
   * (batched) `_propertiesChanged` callback.
   *
   * For basic usage of this mixin, call `MyClass.createProperties(props)`
   * once at class definition time to create property accessors for properties
   * named in props, implement `_propertiesChanged` to react as desired to
   * property changes, and implement `static get observedAttributes()` and
   * include lowercase versions of any property names that should be set from
   * attributes. Last, call `this._enableProperties()` in the element's
   * `connectedCallback` to enable the accessors.
   *
   * @mixinFunction
   * @polymer
   * @summary Element class mixin for reacting to property changes from
   *   generated property accessors.
   * @template T
   * @param {function(new:T)} superClass Class to apply mixin to.
   * @return {function(new:T)} superClass with mixin applied.
   */

  const PropertiesChanged = dedupingMixin(
  /**
   * @template T
   * @param {function(new:T)} superClass Class to apply mixin to.
   * @return {function(new:T)} superClass with mixin applied.
   */
  superClass => {
    /**
     * @polymer
     * @mixinClass
     * @implements {Polymer_PropertiesChanged}
     * @unrestricted
     */
    class PropertiesChanged extends superClass {
      /**
       * Creates property accessors for the given property names.
       * @param {!Object} props Object whose keys are names of accessors.
       * @return {void}
       * @protected
       * @nocollapse
       */
      static createProperties(props) {
        const proto = this.prototype;

        for (let prop in props) {
          // don't stomp an existing accessor
          if (!(prop in proto)) {
            proto._createPropertyAccessor(prop);
          }
        }
      }
      /**
       * Returns an attribute name that corresponds to the given property.
       * The attribute name is the lowercased property name. Override to
       * customize this mapping.
       * @param {string} property Property to convert
       * @return {string} Attribute name corresponding to the given property.
       *
       * @protected
       * @nocollapse
       */


      static attributeNameForProperty(property) {
        return property.toLowerCase();
      }
      /**
       * Override point to provide a type to which to deserialize a value to
       * a given property.
       * @param {string} name Name of property
       *
       * @protected
       * @nocollapse
       */


      static typeForProperty(name) {} //eslint-disable-line no-unused-vars

      /**
       * Creates a setter/getter pair for the named property with its own
       * local storage.  The getter returns the value in the local storage,
       * and the setter calls `_setProperty`, which updates the local storage
       * for the property and enqueues a `_propertiesChanged` callback.
       *
       * This method may be called on a prototype or an instance.  Calling
       * this method may overwrite a property value that already exists on
       * the prototype/instance by creating the accessor.
       *
       * @param {string} property Name of the property
       * @param {boolean=} readOnly When true, no setter is created; the
       *   protected `_setProperty` function must be used to set the property
       * @return {void}
       * @protected
       * @override
       */


      _createPropertyAccessor(property, readOnly) {
        this._addPropertyToAttributeMap(property);

        if (!this.hasOwnProperty(JSCompiler_renameProperty('__dataHasAccessor', this))) {
          this.__dataHasAccessor = Object.assign({}, this.__dataHasAccessor);
        }

        if (!this.__dataHasAccessor[property]) {
          this.__dataHasAccessor[property] = true;

          this._definePropertyAccessor(property, readOnly);
        }
      }
      /**
       * Adds the given `property` to a map matching attribute names
       * to property names, using `attributeNameForProperty`. This map is
       * used when deserializing attribute values to properties.
       *
       * @param {string} property Name of the property
       * @override
       */


      _addPropertyToAttributeMap(property) {
        if (!this.hasOwnProperty(JSCompiler_renameProperty('__dataAttributes', this))) {
          this.__dataAttributes = Object.assign({}, this.__dataAttributes);
        } // This check is technically not correct; it's an optimization that
        // assumes that if a _property_ name is already in the map (note this is
        // an attr->property map), the property mapped directly to the attribute
        // and it has already been mapped.  This would fail if
        // `attributeNameForProperty` were overridden such that this was not the
        // case.


        let attr = this.__dataAttributes[property];

        if (!attr) {
          attr = this.constructor.attributeNameForProperty(property);
          this.__dataAttributes[attr] = property;
        }

        return attr;
      }
      /**
       * Defines a property accessor for the given property.
       * @param {string} property Name of the property
       * @param {boolean=} readOnly When true, no setter is created
       * @return {void}
       * @override
       */


      _definePropertyAccessor(property, readOnly) {
        Object.defineProperty(this, property, {
          /* eslint-disable valid-jsdoc */

          /** @this {PropertiesChanged} */
          get() {
            // Inline for perf instead of using `_getProperty`
            return this.__data[property];
          },

          /** @this {PropertiesChanged} */
          set: readOnly ? function () {} : function (value) {
            // Inline for perf instead of using `_setProperty`
            if (this._setPendingProperty(property, value, true)) {
              this._invalidateProperties();
            }
          }
          /* eslint-enable */

        });
      }

      constructor() {
        super();
        /** @type {boolean} */

        this.__dataEnabled = false;
        this.__dataReady = false;
        this.__dataInvalid = false;
        this.__data = {};
        this.__dataPending = null;
        this.__dataOld = null;
        this.__dataInstanceProps = null;
        /** @type {number} */
        // NOTE: used to track re-entrant calls to `_flushProperties`

        this.__dataCounter = 0;
        this.__serializing = false;

        this._initializeProperties();
      }
      /**
       * Lifecycle callback called when properties are enabled via
       * `_enableProperties`.
       *
       * Users may override this function to implement behavior that is
       * dependent on the element having its property data initialized, e.g.
       * from defaults (initialized from `constructor`, `_initializeProperties`),
       * `attributeChangedCallback`, or values propagated from host e.g. via
       * bindings.  `super.ready()` must be called to ensure the data system
       * becomes enabled.
       *
       * @return {void}
       * @public
       * @override
       */


      ready() {
        this.__dataReady = true;

        this._flushProperties();
      }
      /**
       * Initializes the local storage for property accessors.
       *
       * Provided as an override point for performing any setup work prior
       * to initializing the property accessor system.
       *
       * @return {void}
       * @protected
       * @override
       */


      _initializeProperties() {
        // Capture instance properties; these will be set into accessors
        // during first flush. Don't set them here, since we want
        // these to overwrite defaults/constructor assignments
        for (let p in this.__dataHasAccessor) {
          if (this.hasOwnProperty(p)) {
            this.__dataInstanceProps = this.__dataInstanceProps || {};
            this.__dataInstanceProps[p] = this[p];
            delete this[p];
          }
        }
      }
      /**
       * Called at ready time with bag of instance properties that overwrote
       * accessors when the element upgraded.
       *
       * The default implementation sets these properties back into the
       * setter at ready time.  This method is provided as an override
       * point for customizing or providing more efficient initialization.
       *
       * @param {Object} props Bag of property values that were overwritten
       *   when creating property accessors.
       * @return {void}
       * @protected
       * @override
       */


      _initializeInstanceProperties(props) {
        Object.assign(this, props);
      }
      /**
       * Updates the local storage for a property (via `_setPendingProperty`)
       * and enqueues a `_proeprtiesChanged` callback.
       *
       * @param {string} property Name of the property
       * @param {*} value Value to set
       * @return {void}
       * @protected
       * @override
       */


      _setProperty(property, value) {
        if (this._setPendingProperty(property, value)) {
          this._invalidateProperties();
        }
      }
      /**
       * Returns the value for the given property.
       * @param {string} property Name of property
       * @return {*} Value for the given property
       * @protected
       * @override
       */


      _getProperty(property) {
        return this.__data[property];
      }
      /* eslint-disable no-unused-vars */

      /**
       * Updates the local storage for a property, records the previous value,
       * and adds it to the set of "pending changes" that will be passed to the
       * `_propertiesChanged` callback.  This method does not enqueue the
       * `_propertiesChanged` callback.
       *
       * @param {string} property Name of the property
       * @param {*} value Value to set
       * @param {boolean=} ext Not used here; affordance for closure
       * @return {boolean} Returns true if the property changed
       * @protected
       * @override
       */


      _setPendingProperty(property, value, ext) {
        let old = this.__data[property];

        let changed = this._shouldPropertyChange(property, value, old);

        if (changed) {
          if (!this.__dataPending) {
            this.__dataPending = {};
            this.__dataOld = {};
          } // Ensure old is captured from the last turn


          if (this.__dataOld && !(property in this.__dataOld)) {
            this.__dataOld[property] = old;
          }

          this.__data[property] = value;
          this.__dataPending[property] = value;
        }

        return changed;
      }
      /* eslint-enable */

      /**
       * @param {string} property Name of the property
       * @return {boolean} Returns true if the property is pending.
       */


      _isPropertyPending(property) {
        return !!(this.__dataPending && this.__dataPending.hasOwnProperty(property));
      }
      /**
       * Marks the properties as invalid, and enqueues an async
       * `_propertiesChanged` callback.
       *
       * @return {void}
       * @protected
       * @override
       */


      _invalidateProperties() {
        if (!this.__dataInvalid && this.__dataReady) {
          this.__dataInvalid = true;
          microtask.run(() => {
            if (this.__dataInvalid) {
              this.__dataInvalid = false;

              this._flushProperties();
            }
          });
        }
      }
      /**
       * Call to enable property accessor processing. Before this method is
       * called accessor values will be set but side effects are
       * queued. When called, any pending side effects occur immediately.
       * For elements, generally `connectedCallback` is a normal spot to do so.
       * It is safe to call this method multiple times as it only turns on
       * property accessors once.
       *
       * @return {void}
       * @protected
       * @override
       */


      _enableProperties() {
        if (!this.__dataEnabled) {
          this.__dataEnabled = true;

          if (this.__dataInstanceProps) {
            this._initializeInstanceProperties(this.__dataInstanceProps);

            this.__dataInstanceProps = null;
          }

          this.ready();
        }
      }
      /**
       * Calls the `_propertiesChanged` callback with the current set of
       * pending changes (and old values recorded when pending changes were
       * set), and resets the pending set of changes. Generally, this method
       * should not be called in user code.
       *
       * @return {void}
       * @protected
       * @override
       */


      _flushProperties() {
        this.__dataCounter++;
        const props = this.__data;
        const changedProps = this.__dataPending;
        const old = this.__dataOld;

        if (this._shouldPropertiesChange(props, changedProps, old)) {
          this.__dataPending = null;
          this.__dataOld = null;

          this._propertiesChanged(props, changedProps, old);
        }

        this.__dataCounter--;
      }
      /**
       * Called in `_flushProperties` to determine if `_propertiesChanged`
       * should be called. The default implementation returns true if
       * properties are pending. Override to customize when
       * `_propertiesChanged` is called.
       * @param {!Object} currentProps Bag of all current accessor values
       * @param {?Object} changedProps Bag of properties changed since the last
       *   call to `_propertiesChanged`
       * @param {?Object} oldProps Bag of previous values for each property
       *   in `changedProps`
       * @return {boolean} true if changedProps is truthy
       * @override
       */


      _shouldPropertiesChange(currentProps, changedProps, oldProps) {
        // eslint-disable-line no-unused-vars
        return Boolean(changedProps);
      }
      /**
       * Callback called when any properties with accessors created via
       * `_createPropertyAccessor` have been set.
       *
       * @param {!Object} currentProps Bag of all current accessor values
       * @param {?Object} changedProps Bag of properties changed since the last
       *   call to `_propertiesChanged`
       * @param {?Object} oldProps Bag of previous values for each property
       *   in `changedProps`
       * @return {void}
       * @protected
       * @override
       */


      _propertiesChanged(currentProps, changedProps, oldProps) {// eslint-disable-line no-unused-vars
      }
      /**
       * Method called to determine whether a property value should be
       * considered as a change and cause the `_propertiesChanged` callback
       * to be enqueued.
       *
       * The default implementation returns `true` if a strict equality
       * check fails. The method always returns false for `NaN`.
       *
       * Override this method to e.g. provide stricter checking for
       * Objects/Arrays when using immutable patterns.
       *
       * @param {string} property Property name
       * @param {*} value New property value
       * @param {*} old Previous property value
       * @return {boolean} Whether the property should be considered a change
       *   and enqueue a `_proeprtiesChanged` callback
       * @protected
       * @override
       */


      _shouldPropertyChange(property, value, old) {
        return (// Strict equality check
          old !== value && ( // This ensures (old==NaN, value==NaN) always returns false
          old === old || value === value)
        );
      }
      /**
       * Implements native Custom Elements `attributeChangedCallback` to
       * set an attribute value to a property via `_attributeToProperty`.
       *
       * @param {string} name Name of attribute that changed
       * @param {?string} old Old attribute value
       * @param {?string} value New attribute value
       * @param {?string} namespace Attribute namespace.
       * @return {void}
       * @suppress {missingProperties} Super may or may not implement the callback
       * @override
       */


      attributeChangedCallback(name, old, value, namespace) {
        if (old !== value) {
          this._attributeToProperty(name, value);
        }

        if (super.attributeChangedCallback) {
          super.attributeChangedCallback(name, old, value, namespace);
        }
      }
      /**
       * Deserializes an attribute to its associated property.
       *
       * This method calls the `_deserializeValue` method to convert the string to
       * a typed value.
       *
       * @param {string} attribute Name of attribute to deserialize.
       * @param {?string} value of the attribute.
       * @param {*=} type type to deserialize to, defaults to the value
       * returned from `typeForProperty`
       * @return {void}
       * @override
       */


      _attributeToProperty(attribute, value, type) {
        if (!this.__serializing) {
          const map = this.__dataAttributes;
          const property = map && map[attribute] || attribute;
          this[property] = this._deserializeValue(value, type || this.constructor.typeForProperty(property));
        }
      }
      /**
       * Serializes a property to its associated attribute.
       *
       * @suppress {invalidCasts} Closure can't figure out `this` is an element.
       *
       * @param {string} property Property name to reflect.
       * @param {string=} attribute Attribute name to reflect to.
       * @param {*=} value Property value to refect.
       * @return {void}
       * @override
       */


      _propertyToAttribute(property, attribute, value) {
        this.__serializing = true;
        value = arguments.length < 3 ? this[property] : value;

        this._valueToNodeAttribute(
        /** @type {!HTMLElement} */
        this, value, attribute || this.constructor.attributeNameForProperty(property));

        this.__serializing = false;
      }
      /**
       * Sets a typed value to an HTML attribute on a node.
       *
       * This method calls the `_serializeValue` method to convert the typed
       * value to a string.  If the `_serializeValue` method returns `undefined`,
       * the attribute will be removed (this is the default for boolean
       * type `false`).
       *
       * @param {Element} node Element to set attribute to.
       * @param {*} value Value to serialize.
       * @param {string} attribute Attribute name to serialize to.
       * @return {void}
       * @override
       */


      _valueToNodeAttribute(node, value, attribute) {
        const str = this._serializeValue(value);

        if (attribute === 'class' || attribute === 'name' || attribute === 'slot') {
          node =
          /** @type {?Element} */
          wrap$1(node);
        }

        if (str === undefined) {
          node.removeAttribute(attribute);
        } else {
          node.setAttribute(attribute, str);
        }
      }
      /**
       * Converts a typed JavaScript value to a string.
       *
       * This method is called when setting JS property values to
       * HTML attributes.  Users may override this method to provide
       * serialization for custom types.
       *
       * @param {*} value Property value to serialize.
       * @return {string | undefined} String serialized from the provided
       * property  value.
       * @override
       */


      _serializeValue(value) {
        switch (typeof value) {
          case 'boolean':
            return value ? '' : undefined;

          default:
            return value != null ? value.toString() : undefined;
        }
      }
      /**
       * Converts a string to a typed JavaScript value.
       *
       * This method is called when reading HTML attribute values to
       * JS properties.  Users may override this method to provide
       * deserialization for custom `type`s. Types for `Boolean`, `String`,
       * and `Number` convert attributes to the expected types.
       *
       * @param {?string} value Value to deserialize.
       * @param {*=} type Type to deserialize the string to.
       * @return {*} Typed value deserialized from the provided string.
       * @override
       */


      _deserializeValue(value, type) {
        switch (type) {
          case Boolean:
            return value !== null;

          case Number:
            return Number(value);

          default:
            return value;
        }
      }

    }

    return PropertiesChanged;
  });

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  // that won't have their values "saved" by `saveAccessorValue`, since
  // reading from an HTMLElement accessor from the context of a prototype throws

  const nativeProperties = {};
  let proto = HTMLElement.prototype;

  while (proto) {
    let props = Object.getOwnPropertyNames(proto);

    for (let i = 0; i < props.length; i++) {
      nativeProperties[props[i]] = true;
    }

    proto = Object.getPrototypeOf(proto);
  }
  /**
   * Used to save the value of a property that will be overridden with
   * an accessor. If the `model` is a prototype, the values will be saved
   * in `__dataProto`, and it's up to the user (or downstream mixin) to
   * decide how/when to set these values back into the accessors.
   * If `model` is already an instance (it has a `__data` property), then
   * the value will be set as a pending property, meaning the user should
   * call `_invalidateProperties` or `_flushProperties` to take effect
   *
   * @param {Object} model Prototype or instance
   * @param {string} property Name of property
   * @return {void}
   * @private
   */


  function saveAccessorValue(model, property) {
    // Don't read/store value for any native properties since they could throw
    if (!nativeProperties[property]) {
      let value = model[property];

      if (value !== undefined) {
        if (model.__data) {
          // Adding accessor to instance; update the property
          // It is the user's responsibility to call _flushProperties
          model._setPendingProperty(property, value);
        } else {
          // Adding accessor to proto; save proto's value for instance-time use
          if (!model.__dataProto) {
            model.__dataProto = {};
          } else if (!model.hasOwnProperty(JSCompiler_renameProperty('__dataProto', model))) {
            model.__dataProto = Object.create(model.__dataProto);
          }

          model.__dataProto[property] = value;
        }
      }
    }
  }
  /**
   * Element class mixin that provides basic meta-programming for creating one
   * or more property accessors (getter/setter pair) that enqueue an async
   * (batched) `_propertiesChanged` callback.
   *
   * For basic usage of this mixin:
   *
   * -   Declare attributes to observe via the standard `static get
   *     observedAttributes()`. Use `dash-case` attribute names to represent
   *     `camelCase` property names.
   * -   Implement the `_propertiesChanged` callback on the class.
   * -   Call `MyClass.createPropertiesForAttributes()` **once** on the class to
   *     generate property accessors for each observed attribute. This must be
   *     called before the first instance is created, for example, by calling it
   *     before calling `customElements.define`. It can also be called lazily from
   *     the element's `constructor`, as long as it's guarded so that the call is
   *     only made once, when the first instance is created.
   * -   Call `this._enableProperties()` in the element's `connectedCallback` to
   *     enable the accessors.
   *
   * Any `observedAttributes` will automatically be
   * deserialized via `attributeChangedCallback` and set to the associated
   * property using `dash-case`-to-`camelCase` convention.
   *
   * @mixinFunction
   * @polymer
   * @appliesMixin PropertiesChanged
   * @summary Element class mixin for reacting to property changes from
   *   generated property accessors.
   * @template T
   * @param {function(new:T)} superClass Class to apply mixin to.
   * @return {function(new:T)} superClass with mixin applied.
   */


  const PropertyAccessors = dedupingMixin(superClass => {
    /**
     * @constructor
     * @implements {Polymer_PropertiesChanged}
     * @unrestricted
     * @private
     */
    const base = PropertiesChanged(superClass);
    /**
     * @polymer
     * @mixinClass
     * @implements {Polymer_PropertyAccessors}
     * @extends {base}
     * @unrestricted
     */

    class PropertyAccessors extends base {
      /**
       * Generates property accessors for all attributes in the standard
       * static `observedAttributes` array.
       *
       * Attribute names are mapped to property names using the `dash-case` to
       * `camelCase` convention
       *
       * @return {void}
       * @nocollapse
       */
      static createPropertiesForAttributes() {
        let a$ =
        /** @type {?} */
        this.observedAttributes;

        for (let i = 0; i < a$.length; i++) {
          this.prototype._createPropertyAccessor(dashToCamelCase(a$[i]));
        }
      }
      /**
       * Returns an attribute name that corresponds to the given property.
       * By default, converts camel to dash case, e.g. `fooBar` to `foo-bar`.
       * @param {string} property Property to convert
       * @return {string} Attribute name corresponding to the given property.
       *
       * @protected
       * @nocollapse
       */


      static attributeNameForProperty(property) {
        return camelToDashCase(property);
      }
      /**
       * Overrides PropertiesChanged implementation to initialize values for
       * accessors created for values that already existed on the element
       * prototype.
       *
       * @return {void}
       * @protected
       * @override
       */


      _initializeProperties() {
        if (this.__dataProto) {
          this._initializeProtoProperties(this.__dataProto);

          this.__dataProto = null;
        }

        super._initializeProperties();
      }
      /**
       * Called at instance time with bag of properties that were overwritten
       * by accessors on the prototype when accessors were created.
       *
       * The default implementation sets these properties back into the
       * setter at instance time.  This method is provided as an override
       * point for customizing or providing more efficient initialization.
       *
       * @param {Object} props Bag of property values that were overwritten
       *   when creating property accessors.
       * @return {void}
       * @protected
       * @override
       */


      _initializeProtoProperties(props) {
        for (let p in props) {
          this._setProperty(p, props[p]);
        }
      }
      /**
       * Ensures the element has the given attribute. If it does not,
       * assigns the given value to the attribute.
       *
       * @suppress {invalidCasts} Closure can't figure out `this` is infact an
       *     element
       *
       * @param {string} attribute Name of attribute to ensure is set.
       * @param {string} value of the attribute.
       * @return {void}
       * @override
       */


      _ensureAttribute(attribute, value) {
        const el =
        /** @type {!HTMLElement} */
        this;

        if (!el.hasAttribute(attribute)) {
          this._valueToNodeAttribute(el, value, attribute);
        }
      }
      /**
       * Overrides PropertiesChanged implemention to serialize objects as JSON.
       *
       * @param {*} value Property value to serialize.
       * @return {string | undefined} String serialized from the provided property
       *     value.
       * @override
       */


      _serializeValue(value) {
        /* eslint-disable no-fallthrough */
        switch (typeof value) {
          case 'object':
            if (value instanceof Date) {
              return value.toString();
            } else if (value) {
              try {
                return JSON.stringify(value);
              } catch (x) {
                return '';
              }
            }

          default:
            return super._serializeValue(value);
        }
      }
      /**
       * Converts a string to a typed JavaScript value.
       *
       * This method is called by Polymer when reading HTML attribute values to
       * JS properties.  Users may override this method on Polymer element
       * prototypes to provide deserialization for custom `type`s.  Note,
       * the `type` argument is the value of the `type` field provided in the
       * `properties` configuration object for a given property, and is
       * by convention the constructor for the type to deserialize.
       *
       *
       * @param {?string} value Attribute value to deserialize.
       * @param {*=} type Type to deserialize the string to.
       * @return {*} Typed value deserialized from the provided string.
       * @override
       */


      _deserializeValue(value, type) {
        /**
         * @type {*}
         */
        let outValue;

        switch (type) {
          case Object:
            try {
              outValue = JSON.parse(
              /** @type {string} */
              value);
            } catch (x) {
              // allow non-JSON literals like Strings and Numbers
              outValue = value;
            }

            break;

          case Array:
            try {
              outValue = JSON.parse(
              /** @type {string} */
              value);
            } catch (x) {
              outValue = null;
              console.warn(`Polymer::Attributes: couldn't decode Array as JSON: ${value}`);
            }

            break;

          case Date:
            outValue = isNaN(value) ? String(value) : Number(value);
            outValue = new Date(outValue);
            break;

          default:
            outValue = super._deserializeValue(value, type);
            break;
        }

        return outValue;
      }
      /* eslint-enable no-fallthrough */

      /**
       * Overrides PropertiesChanged implementation to save existing prototype
       * property value so that it can be reset.
       * @param {string} property Name of the property
       * @param {boolean=} readOnly When true, no setter is created
       *
       * When calling on a prototype, any overwritten values are saved in
       * `__dataProto`, and it is up to the subclasser to decide how/when
       * to set those properties back into the accessor.  When calling on an
       * instance, the overwritten value is set via `_setPendingProperty`,
       * and the user should call `_invalidateProperties` or `_flushProperties`
       * for the values to take effect.
       * @protected
       * @return {void}
       * @override
       */


      _definePropertyAccessor(property, readOnly) {
        saveAccessorValue(this, property);

        super._definePropertyAccessor(property, readOnly);
      }
      /**
       * Returns true if this library created an accessor for the given property.
       *
       * @param {string} property Property name
       * @return {boolean} True if an accessor was created
       * @override
       */


      _hasAccessor(property) {
        return this.__dataHasAccessor && this.__dataHasAccessor[property];
      }
      /**
       * Returns true if the specified property has a pending change.
       *
       * @param {string} prop Property name
       * @return {boolean} True if property has a pending change
       * @protected
       * @override
       */


      _isPropertyPending(prop) {
        return Boolean(this.__dataPending && prop in this.__dataPending);
      }

    }

    return PropertyAccessors;
  });

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  // This is a clear layering violation and gives favored-nation status to
  // dom-if and dom-repeat templates.  This is a conceit we're choosing to keep
  // a.) to ease 1.x backwards-compatibility due to loss of `is`, and
  // b.) to maintain if/repeat capability in parser-constrained elements
  //     (e.g. table, select) in lieu of native CE type extensions without
  //     massive new invention in this space (e.g. directive system)

  const templateExtensions = {
    'dom-if': true,
    'dom-repeat': true
  };
  let placeholderBugDetect = false;
  let placeholderBug = false;

  function hasPlaceholderBug() {
    if (!placeholderBugDetect) {
      placeholderBugDetect = true;
      const t = document.createElement('textarea');
      t.placeholder = 'a';
      placeholderBug = t.placeholder === t.textContent;
    }

    return placeholderBug;
  }
  /**
   * Some browsers have a bug with textarea, where placeholder text is copied as
   * a textnode child of the textarea.
   *
   * If the placeholder is a binding, this can break template stamping in two
   * ways.
   *
   * One issue is that when the `placeholder` attribute is removed when the
   * binding is processed, the textnode child of the textarea is deleted, and the
   * template info tries to bind into that node.
   *
   * With `legacyOptimizations` in use, when the template is stamped and the
   * `textarea.textContent` binding is processed, no corresponding node is found
   * because it was removed during parsing. An exception is generated when this
   * binding is updated.
   *
   * With `legacyOptimizations` not in use, the template is cloned before
   * processing and this changes the above behavior. The cloned template also has
   * a value property set to the placeholder and textContent. This prevents the
   * removal of the textContent when the placeholder attribute is removed.
   * Therefore the exception does not occur. However, there is an extra
   * unnecessary binding.
   *
   * @param {!Node} node Check node for placeholder bug
   * @return {void}
   */


  function fixPlaceholder(node) {
    if (hasPlaceholderBug() && node.localName === 'textarea' && node.placeholder && node.placeholder === node.textContent) {
      node.textContent = null;
    }
  }

  function wrapTemplateExtension(node) {
    let is = node.getAttribute('is');

    if (is && templateExtensions[is]) {
      let t = node;
      t.removeAttribute('is');
      node = t.ownerDocument.createElement(is);
      t.parentNode.replaceChild(node, t);
      node.appendChild(t);

      while (t.attributes.length) {
        node.setAttribute(t.attributes[0].name, t.attributes[0].value);
        t.removeAttribute(t.attributes[0].name);
      }
    }

    return node;
  }

  function findTemplateNode(root, nodeInfo) {
    // recursively ascend tree until we hit root
    let parent = nodeInfo.parentInfo && findTemplateNode(root, nodeInfo.parentInfo); // unwind the stack, returning the indexed node at each level

    if (parent) {
      // note: marginally faster than indexing via childNodes
      // (http://jsperf.com/childnodes-lookup)
      for (let n = parent.firstChild, i = 0; n; n = n.nextSibling) {
        if (nodeInfo.parentIndex === i++) {
          return n;
        }
      }
    } else {
      return root;
    }
  } // construct `$` map (from id annotations)


  function applyIdToMap(inst, map, node, nodeInfo) {
    if (nodeInfo.id) {
      map[nodeInfo.id] = node;
    }
  } // install event listeners (from event annotations)


  function applyEventListener(inst, node, nodeInfo) {
    if (nodeInfo.events && nodeInfo.events.length) {
      for (let j = 0, e$ = nodeInfo.events, e; j < e$.length && (e = e$[j]); j++) {
        inst._addMethodEventListenerToNode(node, e.name, e.value, inst);
      }
    }
  } // push configuration references at configure time


  function applyTemplateInfo(inst, node, nodeInfo, parentTemplateInfo) {
    if (nodeInfo.templateInfo) {
      // Give the node an instance of this templateInfo and set its parent
      node._templateInfo = nodeInfo.templateInfo;
      node._parentTemplateInfo = parentTemplateInfo;
    }
  }

  function createNodeEventHandler(context, eventName, methodName) {
    // Instances can optionally have a _methodHost which allows redirecting where
    // to find methods. Currently used by `templatize`.
    context = context._methodHost || context;

    let handler = function (e) {
      if (context[methodName]) {
        context[methodName](e, e.detail);
      } else {
        console.warn('listener method `' + methodName + '` not defined');
      }
    };

    return handler;
  }
  /**
   * Element mixin that provides basic template parsing and stamping, including
   * the following template-related features for stamped templates:
   *
   * - Declarative event listeners (`on-eventname="listener"`)
   * - Map of node id's to stamped node instances (`this.$.id`)
   * - Nested template content caching/removal and re-installation (performance
   *   optimization)
   *
   * @mixinFunction
   * @polymer
   * @summary Element class mixin that provides basic template parsing and stamping
   */


  const TemplateStamp = dedupingMixin(
  /**
   * @template T
   * @param {function(new:T)} superClass Class to apply mixin to.
   * @return {function(new:T)} superClass with mixin applied.
   */
  superClass => {
    /**
     * @polymer
     * @mixinClass
     * @implements {Polymer_TemplateStamp}
     */
    class TemplateStamp extends superClass {
      /**
       * Scans a template to produce template metadata.
       *
       * Template-specific metadata are stored in the object returned, and node-
       * specific metadata are stored in objects in its flattened `nodeInfoList`
       * array.  Only nodes in the template that were parsed as nodes of
       * interest contain an object in `nodeInfoList`.  Each `nodeInfo` object
       * contains an `index` (`childNodes` index in parent) and optionally
       * `parent`, which points to node info of its parent (including its index).
       *
       * The template metadata object returned from this method has the following
       * structure (many fields optional):
       *
       * ```js
       *   {
       *     // Flattened list of node metadata (for nodes that generated metadata)
       *     nodeInfoList: [
       *       {
       *         // `id` attribute for any nodes with id's for generating `$` map
       *         id: {string},
       *         // `on-event="handler"` metadata
       *         events: [
       *           {
       *             name: {string},   // event name
       *             value: {string},  // handler method name
       *           }, ...
       *         ],
       *         // Notes when the template contained a `<slot>` for shady DOM
       *         // optimization purposes
       *         hasInsertionPoint: {boolean},
       *         // For nested `<template>`` nodes, nested template metadata
       *         templateInfo: {object}, // nested template metadata
       *         // Metadata to allow efficient retrieval of instanced node
       *         // corresponding to this metadata
       *         parentInfo: {number},   // reference to parent nodeInfo>
       *         parentIndex: {number},  // index in parent's `childNodes` collection
       *         infoIndex: {number},    // index of this `nodeInfo` in `templateInfo.nodeInfoList`
       *       },
       *       ...
       *     ],
       *     // When true, the template had the `strip-whitespace` attribute
       *     // or was nested in a template with that setting
       *     stripWhitespace: {boolean},
       *     // For nested templates, nested template content is moved into
       *     // a document fragment stored here; this is an optimization to
       *     // avoid the cost of nested template cloning
       *     content: {DocumentFragment}
       *   }
       * ```
       *
       * This method kicks off a recursive treewalk as follows:
       *
       * ```
       *    _parseTemplate <---------------------+
       *      _parseTemplateContent              |
       *        _parseTemplateNode  <------------|--+
       *          _parseTemplateNestedTemplate --+  |
       *          _parseTemplateChildNodes ---------+
       *          _parseTemplateNodeAttributes
       *            _parseTemplateNodeAttribute
       *
       * ```
       *
       * These methods may be overridden to add custom metadata about templates
       * to either `templateInfo` or `nodeInfo`.
       *
       * Note that this method may be destructive to the template, in that
       * e.g. event annotations may be removed after being noted in the
       * template metadata.
       *
       * @param {!HTMLTemplateElement} template Template to parse
       * @param {TemplateInfo=} outerTemplateInfo Template metadata from the outer
       *   template, for parsing nested templates
       * @return {!TemplateInfo} Parsed template metadata
       * @nocollapse
       */
      static _parseTemplate(template, outerTemplateInfo) {
        // since a template may be re-used, memo-ize metadata
        if (!template._templateInfo) {
          // TODO(rictic): fix typing
          let
          /** ? */
          templateInfo = template._templateInfo = {};
          templateInfo.nodeInfoList = [];
          templateInfo.nestedTemplate = Boolean(outerTemplateInfo);
          templateInfo.stripWhiteSpace = outerTemplateInfo && outerTemplateInfo.stripWhiteSpace || template.hasAttribute('strip-whitespace'); // TODO(rictic): fix typing

          this._parseTemplateContent(template, templateInfo,
          /** @type {?} */
          {
            parent: null
          });
        }

        return template._templateInfo;
      }
      /**
       * See docs for _parseTemplateNode.
       *
       * @param {!HTMLTemplateElement} template .
       * @param {!TemplateInfo} templateInfo .
       * @param {!NodeInfo} nodeInfo .
       * @return {boolean} .
       * @nocollapse
       */


      static _parseTemplateContent(template, templateInfo, nodeInfo) {
        return this._parseTemplateNode(template.content, templateInfo, nodeInfo);
      }
      /**
       * Parses template node and adds template and node metadata based on
       * the current node, and its `childNodes` and `attributes`.
       *
       * This method may be overridden to add custom node or template specific
       * metadata based on this node.
       *
       * @param {Node} node Node to parse
       * @param {!TemplateInfo} templateInfo Template metadata for current template
       * @param {!NodeInfo} nodeInfo Node metadata for current template.
       * @return {boolean} `true` if the visited node added node-specific
       *   metadata to `nodeInfo`
       * @nocollapse
       */


      static _parseTemplateNode(node, templateInfo, nodeInfo) {
        let noted = false;
        let element =
        /** @type {!HTMLTemplateElement} */
        node;

        if (element.localName == 'template' && !element.hasAttribute('preserve-content')) {
          noted = this._parseTemplateNestedTemplate(element, templateInfo, nodeInfo) || noted;
        } else if (element.localName === 'slot') {
          // For ShadyDom optimization, indicating there is an insertion point
          templateInfo.hasInsertionPoint = true;
        }

        fixPlaceholder(element);

        if (element.firstChild) {
          this._parseTemplateChildNodes(element, templateInfo, nodeInfo);
        }

        if (element.hasAttributes && element.hasAttributes()) {
          noted = this._parseTemplateNodeAttributes(element, templateInfo, nodeInfo) || noted;
        } // Checking `nodeInfo.noted` allows a child node of this node (who gets
        // access to `parentInfo`) to cause the parent to be noted, which
        // otherwise has no return path via `_parseTemplateChildNodes` (used by
        // some optimizations)


        return noted || nodeInfo.noted;
      }
      /**
       * Parses template child nodes for the given root node.
       *
       * This method also wraps whitelisted legacy template extensions
       * (`is="dom-if"` and `is="dom-repeat"`) with their equivalent element
       * wrappers, collapses text nodes, and strips whitespace from the template
       * if the `templateInfo.stripWhitespace` setting was provided.
       *
       * @param {Node} root Root node whose `childNodes` will be parsed
       * @param {!TemplateInfo} templateInfo Template metadata for current template
       * @param {!NodeInfo} nodeInfo Node metadata for current template.
       * @return {void}
       */


      static _parseTemplateChildNodes(root, templateInfo, nodeInfo) {
        if (root.localName === 'script' || root.localName === 'style') {
          return;
        }

        for (let node = root.firstChild, parentIndex = 0, next; node; node = next) {
          // Wrap templates
          if (node.localName == 'template') {
            node = wrapTemplateExtension(node);
          } // collapse adjacent textNodes: fixes an IE issue that can cause
          // text nodes to be inexplicably split =(
          // note that root.normalize() should work but does not so we do this
          // manually.


          next = node.nextSibling;

          if (node.nodeType === Node.TEXT_NODE) {
            let
            /** Node */
            n = next;

            while (n && n.nodeType === Node.TEXT_NODE) {
              node.textContent += n.textContent;
              next = n.nextSibling;
              root.removeChild(n);
              n = next;
            } // optionally strip whitespace


            if (templateInfo.stripWhiteSpace && !node.textContent.trim()) {
              root.removeChild(node);
              continue;
            }
          }

          let childInfo =
          /** @type {!NodeInfo} */
          {
            parentIndex,
            parentInfo: nodeInfo
          };

          if (this._parseTemplateNode(node, templateInfo, childInfo)) {
            childInfo.infoIndex = templateInfo.nodeInfoList.push(childInfo) - 1;
          } // Increment if not removed


          if (node.parentNode) {
            parentIndex++;
          }
        }
      }
      /**
       * Parses template content for the given nested `<template>`.
       *
       * Nested template info is stored as `templateInfo` in the current node's
       * `nodeInfo`. `template.content` is removed and stored in `templateInfo`.
       * It will then be the responsibility of the host to set it back to the
       * template and for users stamping nested templates to use the
       * `_contentForTemplate` method to retrieve the content for this template
       * (an optimization to avoid the cost of cloning nested template content).
       *
       * @param {HTMLTemplateElement} node Node to parse (a <template>)
       * @param {TemplateInfo} outerTemplateInfo Template metadata for current template
       *   that includes the template `node`
       * @param {!NodeInfo} nodeInfo Node metadata for current template.
       * @return {boolean} `true` if the visited node added node-specific
       *   metadata to `nodeInfo`
       * @nocollapse
       */


      static _parseTemplateNestedTemplate(node, outerTemplateInfo, nodeInfo) {
        // TODO(rictic): the type of node should be non-null
        let element =
        /** @type {!HTMLTemplateElement} */
        node;

        let templateInfo = this._parseTemplate(element, outerTemplateInfo);

        let content = templateInfo.content = element.content.ownerDocument.createDocumentFragment();
        content.appendChild(element.content);
        nodeInfo.templateInfo = templateInfo;
        return true;
      }
      /**
       * Parses template node attributes and adds node metadata to `nodeInfo`
       * for nodes of interest.
       *
       * @param {Element} node Node to parse
       * @param {!TemplateInfo} templateInfo Template metadata for current
       *     template
       * @param {!NodeInfo} nodeInfo Node metadata for current template.
       * @return {boolean} `true` if the visited node added node-specific
       *   metadata to `nodeInfo`
       * @nocollapse
       */


      static _parseTemplateNodeAttributes(node, templateInfo, nodeInfo) {
        // Make copy of original attribute list, since the order may change
        // as attributes are added and removed
        let noted = false;
        let attrs = Array.from(node.attributes);

        for (let i = attrs.length - 1, a; a = attrs[i]; i--) {
          noted = this._parseTemplateNodeAttribute(node, templateInfo, nodeInfo, a.name, a.value) || noted;
        }

        return noted;
      }
      /**
       * Parses a single template node attribute and adds node metadata to
       * `nodeInfo` for attributes of interest.
       *
       * This implementation adds metadata for `on-event="handler"` attributes
       * and `id` attributes.
       *
       * @param {Element} node Node to parse
       * @param {!TemplateInfo} templateInfo Template metadata for current template
       * @param {!NodeInfo} nodeInfo Node metadata for current template.
       * @param {string} name Attribute name
       * @param {string} value Attribute value
       * @return {boolean} `true` if the visited node added node-specific
       *   metadata to `nodeInfo`
       * @nocollapse
       */


      static _parseTemplateNodeAttribute(node, templateInfo, nodeInfo, name, value) {
        // events (on-*)
        if (name.slice(0, 3) === 'on-') {
          node.removeAttribute(name);
          nodeInfo.events = nodeInfo.events || [];
          nodeInfo.events.push({
            name: name.slice(3),
            value
          });
          return true;
        } // static id
        else if (name === 'id') {
            nodeInfo.id = value;
            return true;
          }

        return false;
      }
      /**
       * Returns the `content` document fragment for a given template.
       *
       * For nested templates, Polymer performs an optimization to cache nested
       * template content to avoid the cost of cloning deeply nested templates.
       * This method retrieves the cached content for a given template.
       *
       * @param {HTMLTemplateElement} template Template to retrieve `content` for
       * @return {DocumentFragment} Content fragment
       * @nocollapse
       */


      static _contentForTemplate(template) {
        let templateInfo =
        /** @type {HTMLTemplateElementWithInfo} */
        template._templateInfo;
        return templateInfo && templateInfo.content || template.content;
      }
      /**
       * Clones the provided template content and returns a document fragment
       * containing the cloned dom.
       *
       * The template is parsed (once and memoized) using this library's
       * template parsing features, and provides the following value-added
       * features:
       * * Adds declarative event listeners for `on-event="handler"` attributes
       * * Generates an "id map" for all nodes with id's under `$` on returned
       *   document fragment
       * * Passes template info including `content` back to templates as
       *   `_templateInfo` (a performance optimization to avoid deep template
       *   cloning)
       *
       * Note that the memoized template parsing process is destructive to the
       * template: attributes for bindings and declarative event listeners are
       * removed after being noted in notes, and any nested `<template>.content`
       * is removed and stored in notes as well.
       *
       * @param {!HTMLTemplateElement} template Template to stamp
       * @param {TemplateInfo=} templateInfo Optional template info associated
       *   with the template to be stamped; if omitted the template will be
       *   automatically parsed.
       * @return {!StampedTemplate} Cloned template content
       * @override
       */


      _stampTemplate(template, templateInfo) {
        // Polyfill support: bootstrap the template if it has not already been
        if (template && !template.content && window.HTMLTemplateElement && HTMLTemplateElement.decorate) {
          HTMLTemplateElement.decorate(template);
        } // Accepting the `templateInfo` via an argument allows for creating
        // instances of the `templateInfo` by the caller, useful for adding
        // instance-time information to the prototypical data


        templateInfo = templateInfo || this.constructor._parseTemplate(template);
        let nodeInfo = templateInfo.nodeInfoList;
        let content = templateInfo.content || template.content;
        let dom =
        /** @type {DocumentFragment} */
        document.importNode(content, true); // NOTE: ShadyDom optimization indicating there is an insertion point

        dom.__noInsertionPoint = !templateInfo.hasInsertionPoint;
        let nodes = dom.nodeList = new Array(nodeInfo.length);
        dom.$ = {};

        for (let i = 0, l = nodeInfo.length, info; i < l && (info = nodeInfo[i]); i++) {
          let node = nodes[i] = findTemplateNode(dom, info);
          applyIdToMap(this, dom.$, node, info);
          applyTemplateInfo(this, node, info, templateInfo);
          applyEventListener(this, node, info);
        }

        dom =
        /** @type {!StampedTemplate} */
        dom; // eslint-disable-line no-self-assign

        return dom;
      }
      /**
       * Adds an event listener by method name for the event provided.
       *
       * This method generates a handler function that looks up the method
       * name at handling time.
       *
       * @param {!EventTarget} node Node to add listener on
       * @param {string} eventName Name of event
       * @param {string} methodName Name of method
       * @param {*=} context Context the method will be called on (defaults
       *   to `node`)
       * @return {Function} Generated handler function
       * @override
       */


      _addMethodEventListenerToNode(node, eventName, methodName, context) {
        context = context || node;
        let handler = createNodeEventHandler(context, eventName, methodName);

        this._addEventListenerToNode(node, eventName, handler);

        return handler;
      }
      /**
       * Override point for adding custom or simulated event handling.
       *
       * @param {!EventTarget} node Node to add event listener to
       * @param {string} eventName Name of event
       * @param {function(!Event):void} handler Listener function to add
       * @return {void}
       * @override
       */


      _addEventListenerToNode(node, eventName, handler) {
        node.addEventListener(eventName, handler);
      }
      /**
       * Override point for adding custom or simulated event handling.
       *
       * @param {!EventTarget} node Node to remove event listener from
       * @param {string} eventName Name of event
       * @param {function(!Event):void} handler Listener function to remove
       * @return {void}
       * @override
       */


      _removeEventListenerFromNode(node, eventName, handler) {
        node.removeEventListener(eventName, handler);
      }

    }

    return TemplateStamp;
  });

  /**
   * @fileoverview
   * @suppress {checkPrototypalTypes}
   * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
   * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
   * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
   * Google as part of the polymer project is also subject to an additional IP
   * rights grant found at http://polymer.github.io/PATENTS.txt
   */
  // from multiple properties in the same turn

  let dedupeId$1 = 0;
  const NOOP = [];
  /**
   * Property effect types; effects are stored on the prototype using these keys
   * @enum {string}
   */

  const TYPES = {
    COMPUTE: '__computeEffects',
    REFLECT: '__reflectEffects',
    NOTIFY: '__notifyEffects',
    PROPAGATE: '__propagateEffects',
    OBSERVE: '__observeEffects',
    READ_ONLY: '__readOnly'
  };
  const COMPUTE_INFO = '__computeInfo';
  /** @const {!RegExp} */

  const capitalAttributeRegex = /[A-Z]/;

  /**
   * Ensures that the model has an own-property map of effects for the given type.
   * The model may be a prototype or an instance.
   *
   * Property effects are stored as arrays of effects by property in a map,
   * by named type on the model. e.g.
   *
   *   __computeEffects: {
   *     foo: [ ... ],
   *     bar: [ ... ]
   *   }
   *
   * If the model does not yet have an effect map for the type, one is created
   * and returned.  If it does, but it is not an own property (i.e. the
   * prototype had effects), the the map is deeply cloned and the copy is
   * set on the model and returned, ready for new effects to be added.
   *
   * @param {Object} model Prototype or instance
   * @param {string} type Property effect type
   * @param {boolean=} cloneArrays Clone any arrays assigned to the map when
   *   extending a superclass map onto this subclass
   * @return {Object} The own-property map of effects for the given type
   * @private
   */

  function ensureOwnEffectMap(model, type, cloneArrays) {
    let effects = model[type];

    if (!effects) {
      effects = model[type] = {};
    } else if (!model.hasOwnProperty(type)) {
      effects = model[type] = Object.create(model[type]);

      if (cloneArrays) {
        for (let p in effects) {
          let protoFx = effects[p]; // Perf optimization over Array.slice

          let instFx = effects[p] = Array(protoFx.length);

          for (let i = 0; i < protoFx.length; i++) {
            instFx[i] = protoFx[i];
          }
        }
      }
    }

    return effects;
  } // -- effects ----------------------------------------------

  /**
   * Runs all effects of a given type for the given set of property changes
   * on an instance.
   *
   * @param {!Polymer_PropertyEffects} inst The instance with effects to run
   * @param {?Object} effects Object map of property-to-Array of effects
   * @param {?Object} props Bag of current property changes
   * @param {?Object=} oldProps Bag of previous values for changed properties
   * @param {boolean=} hasPaths True with `props` contains one or more paths
   * @param {*=} extraArgs Additional metadata to pass to effect function
   * @return {boolean} True if an effect ran for this property
   * @private
   */


  function runEffects(inst, effects, props, oldProps, hasPaths, extraArgs) {
    if (effects) {
      let ran = false;
      const id = dedupeId$1++;

      for (let prop in props) {
        // Inline `runEffectsForProperty` for perf.
        let rootProperty = hasPaths ? root(prop) : prop;
        let fxs = effects[rootProperty];

        if (fxs) {
          for (let i = 0, l = fxs.length, fx; i < l && (fx = fxs[i]); i++) {
            if ((!fx.info || fx.info.lastRun !== id) && (!hasPaths || pathMatchesTrigger(prop, fx.trigger))) {
              if (fx.info) {
                fx.info.lastRun = id;
              }

              fx.fn(inst, prop, props, oldProps, fx.info, hasPaths, extraArgs);
              ran = true;
            }
          }
        }
      }

      return ran;
    }

    return false;
  }
  /**
   * Runs a list of effects for a given property.
   *
   * @param {!Polymer_PropertyEffects} inst The instance with effects to run
   * @param {!Object} effects Object map of property-to-Array of effects
   * @param {number} dedupeId Counter used for de-duping effects
   * @param {string} prop Name of changed property
   * @param {*} props Changed properties
   * @param {*} oldProps Old properties
   * @param {boolean=} hasPaths True with `props` contains one or more paths
   * @param {*=} extraArgs Additional metadata to pass to effect function
   * @return {boolean} True if an effect ran for this property
   * @private
   */


  function runEffectsForProperty(inst, effects, dedupeId, prop, props, oldProps, hasPaths, extraArgs) {
    let ran = false;
    let rootProperty = hasPaths ? root(prop) : prop;
    let fxs = effects[rootProperty];

    if (fxs) {
      for (let i = 0, l = fxs.length, fx; i < l && (fx = fxs[i]); i++) {
        if ((!fx.info || fx.info.lastRun !== dedupeId) && (!hasPaths || pathMatchesTrigger(prop, fx.trigger))) {
          if (fx.info) {
            fx.info.lastRun = dedupeId;
          }

          fx.fn(inst, prop, props, oldProps, fx.info, hasPaths, extraArgs);
          ran = true;
        }
      }
    }

    return ran;
  }
  /**
   * Determines whether a property/path that has changed matches the trigger
   * criteria for an effect.  A trigger is a descriptor with the following
   * structure, which matches the descriptors returned from `parseArg`.
   * e.g. for `foo.bar.*`:
   * ```
   * trigger: {
   *   name: 'a.b',
   *   structured: true,
   *   wildcard: true
   * }
   * ```
   * If no trigger is given, the path is deemed to match.
   *
   * @param {string} path Path or property that changed
   * @param {?DataTrigger} trigger Descriptor
   * @return {boolean} Whether the path matched the trigger
   */


  function pathMatchesTrigger(path, trigger) {
    if (trigger) {
      let triggerPath =
      /** @type {string} */
      trigger.name;
      return triggerPath == path || !!(trigger.structured && isAncestor(triggerPath, path)) || !!(trigger.wildcard && isDescendant(triggerPath, path));
    } else {
      return true;
    }
  }
  /**
   * Implements the "observer" effect.
   *
   * Calls the method with `info.methodName` on the instance, passing the
   * new and old values.
   *
   * @param {!Polymer_PropertyEffects} inst The instance the effect will be run on
   * @param {string} property Name of property
   * @param {Object} props Bag of current property changes
   * @param {Object} oldProps Bag of previous values for changed properties
   * @param {?} info Effect metadata
   * @return {void}
   * @private
   */


  function runObserverEffect(inst, property, props, oldProps, info) {
    let fn = typeof info.method === "string" ? inst[info.method] : info.method;
    let changedProp = info.property;

    if (fn) {
      fn.call(inst, inst.__data[changedProp], oldProps[changedProp]);
    } else if (!info.dynamicFn) {
      console.warn('observer method `' + info.method + '` not defined');
    }
  }
  /**
   * Runs "notify" effects for a set of changed properties.
   *
   * This method differs from the generic `runEffects` method in that it
   * will dispatch path notification events in the case that the property
   * changed was a path and the root property for that path didn't have a
   * "notify" effect.  This is to maintain 1.0 behavior that did not require
   * `notify: true` to ensure object sub-property notifications were
   * sent.
   *
   * @param {!Polymer_PropertyEffects} inst The instance with effects to run
   * @param {Object} notifyProps Bag of properties to notify
   * @param {Object} props Bag of current property changes
   * @param {Object} oldProps Bag of previous values for changed properties
   * @param {boolean} hasPaths True with `props` contains one or more paths
   * @return {void}
   * @private
   */


  function runNotifyEffects(inst, notifyProps, props, oldProps, hasPaths) {
    // Notify
    let fxs = inst[TYPES.NOTIFY];
    let notified;
    let id = dedupeId$1++; // Try normal notify effects; if none, fall back to try path notification

    for (let prop in notifyProps) {
      if (notifyProps[prop]) {
        if (fxs && runEffectsForProperty(inst, fxs, id, prop, props, oldProps, hasPaths)) {
          notified = true;
        } else if (hasPaths && notifyPath(inst, prop, props)) {
          notified = true;
        }
      }
    } // Flush host if we actually notified and host was batching
    // And the host has already initialized clients; this prevents
    // an issue with a host observing data changes before clients are ready.


    let host;

    if (notified && (host = inst.__dataHost) && host._invalidateProperties) {
      host._invalidateProperties();
    }
  }
  /**
   * Dispatches {property}-changed events with path information in the detail
   * object to indicate a sub-path of the property was changed.
   *
   * @param {!Polymer_PropertyEffects} inst The element from which to fire the
   *     event
   * @param {string} path The path that was changed
   * @param {Object} props Bag of current property changes
   * @return {boolean} Returns true if the path was notified
   * @private
   */


  function notifyPath(inst, path, props) {
    let rootProperty = root(path);

    if (rootProperty !== path) {
      let eventName = camelToDashCase(rootProperty) + '-changed';
      dispatchNotifyEvent(inst, eventName, props[path], path);
      return true;
    }

    return false;
  }
  /**
   * Dispatches {property}-changed events to indicate a property (or path)
   * changed.
   *
   * @param {!Polymer_PropertyEffects} inst The element from which to fire the
   *     event
   * @param {string} eventName The name of the event to send
   *     ('{property}-changed')
   * @param {*} value The value of the changed property
   * @param {string | null | undefined} path If a sub-path of this property
   *     changed, the path that changed (optional).
   * @return {void}
   * @private
   * @suppress {invalidCasts}
   */


  function dispatchNotifyEvent(inst, eventName, value, path) {
    let detail = {
      value: value,
      queueProperty: true
    };

    if (path) {
      detail.path = path;
    } // As a performance optimization, we could elide the wrap here since notifying
    // events are non-bubbling and shouldn't need retargeting. However, a very
    // small number of internal tests failed in obscure ways, which may indicate
    // user code relied on timing differences resulting from ShadyDOM flushing
    // as a result of the wrapped `dispatchEvent`.


    wrap$1(
    /** @type {!HTMLElement} */
    inst).dispatchEvent(new CustomEvent(eventName, {
      detail
    }));
  }
  /**
   * Implements the "notify" effect.
   *
   * Dispatches a non-bubbling event named `info.eventName` on the instance
   * with a detail object containing the new `value`.
   *
   * @param {!Polymer_PropertyEffects} inst The instance the effect will be run on
   * @param {string} property Name of property
   * @param {Object} props Bag of current property changes
   * @param {Object} oldProps Bag of previous values for changed properties
   * @param {?} info Effect metadata
   * @param {boolean} hasPaths True with `props` contains one or more paths
   * @return {void}
   * @private
   */


  function runNotifyEffect(inst, property, props, oldProps, info, hasPaths) {
    let rootProperty = hasPaths ? root(property) : property;
    let path = rootProperty != property ? property : null;
    let value = path ? get(inst, path) : inst.__data[property];

    if (path && value === undefined) {
      value = props[property]; // specifically for .splices
    }

    dispatchNotifyEvent(inst, info.eventName, value, path);
  }
  /**
   * Handler function for 2-way notification events. Receives context
   * information captured in the `addNotifyListener` closure from the
   * `__notifyListeners` metadata.
   *
   * Sets the value of the notified property to the host property or path.  If
   * the event contained path information, translate that path to the host
   * scope's name for that path first.
   *
   * @param {CustomEvent} event Notification event (e.g. '<property>-changed')
   * @param {!Polymer_PropertyEffects} inst Host element instance handling the
   *     notification event
   * @param {string} fromProp Child element property that was bound
   * @param {string} toPath Host property/path that was bound
   * @param {boolean} negate Whether the binding was negated
   * @return {void}
   * @private
   */


  function handleNotification(event, inst, fromProp, toPath, negate) {
    let value;
    let detail =
    /** @type {Object} */
    event.detail;
    let fromPath = detail && detail.path;

    if (fromPath) {
      toPath = translate(fromProp, toPath, fromPath);
      value = detail && detail.value;
    } else {
      value = event.currentTarget[fromProp];
    }

    value = negate ? !value : value;

    if (!inst[TYPES.READ_ONLY] || !inst[TYPES.READ_ONLY][toPath]) {
      if (inst._setPendingPropertyOrPath(toPath, value, true, Boolean(fromPath)) && (!detail || !detail.queueProperty)) {
        inst._invalidateProperties();
      }
    }
  }
  /**
   * Implements the "reflect" effect.
   *
   * Sets the attribute named `info.attrName` to the given property value.
   *
   * @param {!Polymer_PropertyEffects} inst The instance the effect will be run on
   * @param {string} property Name of property
   * @param {Object} props Bag of current property changes
   * @param {Object} oldProps Bag of previous values for changed properties
   * @param {?} info Effect metadata
   * @return {void}
   * @private
   */


  function runReflectEffect(inst, property, props, oldProps, info) {
    let value = inst.__data[property];

    if (sanitizeDOMValue) {
      value = sanitizeDOMValue(value, info.attrName, 'attribute',
      /** @type {Node} */
      inst);
    }

    inst._propertyToAttribute(property, info.attrName, value);
  }
  /**
   * Runs "computed" effects for a set of changed properties.
   *
   * This method differs from the generic `runEffects` method in that it
   * continues to run computed effects based on the output of each pass until
   * there are no more newly computed properties.  This ensures that all
   * properties that will be computed by the initial set of changes are
   * computed before other effects (binding propagation, observers, and notify)
   * run.
   *
   * @param {!Polymer_PropertyEffects} inst The instance the effect will be run on
   * @param {?Object} changedProps Bag of changed properties
   * @param {?Object} oldProps Bag of previous values for changed properties
   * @param {boolean} hasPaths True with `props` contains one or more paths
   * @return {void}
   * @private
   */


  function runComputedEffects(inst, changedProps, oldProps, hasPaths) {
    let computeEffects = inst[TYPES.COMPUTE];

    if (computeEffects) {
      if (orderedComputed) {
        // Runs computed effects in efficient order by keeping a topologically-
        // sorted queue of compute effects to run, and inserting subsequently
        // invalidated effects as they are run
        dedupeId$1++;
        const order = getComputedOrder(inst);
        const queue = [];

        for (let p in changedProps) {
          enqueueEffectsFor(p, computeEffects, queue, order, hasPaths);
        }

        let info;

        while (info = queue.shift()) {
          if (runComputedEffect(inst, '', changedProps, oldProps, info)) {
            enqueueEffectsFor(info.methodInfo, computeEffects, queue, order, hasPaths);
          }
        }

        Object.assign(
        /** @type {!Object} */
        oldProps, inst.__dataOld);
        Object.assign(
        /** @type {!Object} */
        changedProps, inst.__dataPending);
        inst.__dataPending = null;
      } else {
        // Original Polymer 2.x computed effects order, which continues running
        // effects until no further computed properties have been invalidated
        let inputProps = changedProps;

        while (runEffects(inst, computeEffects, inputProps, oldProps, hasPaths)) {
          Object.assign(
          /** @type {!Object} */
          oldProps, inst.__dataOld);
          Object.assign(
          /** @type {!Object} */
          changedProps, inst.__dataPending);
          inputProps = inst.__dataPending;
          inst.__dataPending = null;
        }
      }
    }
  }
  /**
   * Inserts a computed effect into a queue, given the specified order. Performs
   * the insert using a binary search.
   *
   * Used by `orderedComputed: true` computed property algorithm.
   *
   * @param {Object} info Property effects metadata
   * @param {Array<Object>} queue Ordered queue of effects
   * @param {Map<string,number>} order Map of computed property name->topological
   *   sort order
   */


  const insertEffect = (info, queue, order) => {
    let start = 0;
    let end = queue.length - 1;
    let idx = -1;

    while (start <= end) {
      const mid = start + end >> 1; // Note `methodInfo` is where the computed property name is stored in
      // the effect metadata

      const cmp = order.get(queue[mid].methodInfo) - order.get(info.methodInfo);

      if (cmp < 0) {
        start = mid + 1;
      } else if (cmp > 0) {
        end = mid - 1;
      } else {
        idx = mid;
        break;
      }
    }

    if (idx < 0) {
      idx = end + 1;
    }

    queue.splice(idx, 0, info);
  };
  /**
   * Inserts all downstream computed effects invalidated by the specified property
   * into the topologically-sorted queue of effects to be run.
   *
   * Used by `orderedComputed: true` computed property algorithm.
   *
   * @param {string} prop Property name
   * @param {Object} computeEffects Computed effects for this element
   * @param {Array<Object>} queue Topologically-sorted queue of computed effects
   *   to be run
   * @param {Map<string,number>} order Map of computed property name->topological
   *   sort order
   * @param {boolean} hasPaths True with `changedProps` contains one or more paths
   */


  const enqueueEffectsFor = (prop, computeEffects, queue, order, hasPaths) => {
    const rootProperty = hasPaths ? root(prop) : prop;
    const fxs = computeEffects[rootProperty];

    if (fxs) {
      for (let i = 0; i < fxs.length; i++) {
        const fx = fxs[i];

        if (fx.info.lastRun !== dedupeId$1 && (!hasPaths || pathMatchesTrigger(prop, fx.trigger))) {
          fx.info.lastRun = dedupeId$1;
          insertEffect(fx.info, queue, order);
        }
      }
    }
  };
  /**
   * Generates and retrieves a memoized map of computed property name to its
   * topologically-sorted order.
   *
   * The map is generated by first assigning a "dependency count" to each property
   * (defined as number properties it depends on, including its method for
   * "dynamic functions"). Any properties that have no dependencies are added to
   * the `ready` queue, which are properties whose order can be added to the final
   * order map. Properties are popped off the `ready` queue one by one and a.) added as
   * the next property in the order map, and b.) each property that it is a
   * dependency for has its dep count decremented (and if that property's dep
   * count goes to zero, it is added to the `ready` queue), until all properties
   * have been visited and ordered.
   *
   * Used by `orderedComputed: true` computed property algorithm.
   *
   * @param {!Polymer_PropertyEffects} inst The instance to retrieve the computed
   *   effect order for.
   * @return {Map<string,number>} Map of computed property name->topological sort
   *   order
   */


  function getComputedOrder(inst) {
    let ordered = inst.constructor.__orderedComputedDeps;

    if (!ordered) {
      ordered = new Map();
      const effects = inst[TYPES.COMPUTE];
      let {
        counts,
        ready,
        total
      } = dependencyCounts(inst);
      let curr;

      while (curr = ready.shift()) {
        ordered.set(curr, ordered.size);
        const computedByCurr = effects[curr];

        if (computedByCurr) {
          computedByCurr.forEach(fx => {
            // Note `methodInfo` is where the computed property name is stored
            const computedProp = fx.info.methodInfo;
            --total;

            if (--counts[computedProp] === 0) {
              ready.push(computedProp);
            }
          });
        }
      }

      if (total !== 0) {
        const el =
        /** @type {HTMLElement} */
        inst;
        console.warn(`Computed graph for ${el.localName} incomplete; circular?`);
      }

      inst.constructor.__orderedComputedDeps = ordered;
    }

    return ordered;
  }
  /**
   * Generates a map of property-to-dependency count (`counts`, where "dependency
   * count" is the number of dependencies a given property has assuming it is a
   * computed property, otherwise 0).  It also returns a pre-populated list of
   * `ready` properties that have no dependencies and a `total` count, which is
   * used for error-checking the graph.
   *
   * Used by `orderedComputed: true` computed property algorithm.
   *
   * @param {!Polymer_PropertyEffects} inst The instance to generate dependency
   *   counts for.
   * @return {!Object} Object containing `counts` map (property-to-dependency
   *   count) and pre-populated `ready` array of properties that had zero
   *   dependencies.
   */


  function dependencyCounts(inst) {
    const infoForComputed = inst[COMPUTE_INFO];
    const counts = {};
    const computedDeps = inst[TYPES.COMPUTE];
    const ready = [];
    let total = 0; // Count dependencies for each computed property

    for (let p in infoForComputed) {
      const info = infoForComputed[p]; // Be sure to add the method name itself in case of "dynamic functions"

      total += counts[p] = info.args.filter(a => !a.literal).length + (info.dynamicFn ? 1 : 0);
    } // Build list of ready properties (that aren't themselves computed)


    for (let p in computedDeps) {
      if (!infoForComputed[p]) {
        ready.push(p);
      }
    }

    return {
      counts,
      ready,
      total
    };
  }
  /**
   * Implements the "computed property" effect by running the method with the
   * values of the arguments specified in the `info` object and setting the
   * return value to the computed property specified.
   *
   * @param {!Polymer_PropertyEffects} inst The instance the effect will be run on
   * @param {string} property Name of property
   * @param {?Object} changedProps Bag of current property changes
   * @param {?Object} oldProps Bag of previous values for changed properties
   * @param {?} info Effect metadata
   * @return {boolean} True when the property being computed changed
   * @private
   */


  function runComputedEffect(inst, property, changedProps, oldProps, info) {
    // Dirty check dependencies and run if any invalid
    let result = runMethodEffect(inst, property, changedProps, oldProps, info); // Abort if method returns a no-op result

    if (result === NOOP) {
      return false;
    }

    let computedProp = info.methodInfo;

    if (inst.__dataHasAccessor && inst.__dataHasAccessor[computedProp]) {
      return inst._setPendingProperty(computedProp, result, true);
    } else {
      inst[computedProp] = result;
      return false;
    }
  }
  /**
   * Computes path changes based on path links set up using the `linkPaths`
   * API.
   *
   * @param {!Polymer_PropertyEffects} inst The instance whose props are changing
   * @param {string} path Path that has changed
   * @param {*} value Value of changed path
   * @return {void}
   * @private
   */


  function computeLinkedPaths(inst, path, value) {
    let links = inst.__dataLinkedPaths;

    if (links) {
      let link;

      for (let a in links) {
        let b = links[a];

        if (isDescendant(a, path)) {
          link = translate(a, b, path);

          inst._setPendingPropertyOrPath(link, value, true, true);
        } else if (isDescendant(b, path)) {
          link = translate(b, a, path);

          inst._setPendingPropertyOrPath(link, value, true, true);
        }
      }
    }
  } // -- bindings ----------------------------------------------

  /**
   * Adds binding metadata to the current `nodeInfo`, and binding effects
   * for all part dependencies to `templateInfo`.
   *
   * @param {Function} constructor Class that `_parseTemplate` is currently
   *   running on
   * @param {TemplateInfo} templateInfo Template metadata for current template
   * @param {NodeInfo} nodeInfo Node metadata for current template node
   * @param {string} kind Binding kind, either 'property', 'attribute', or 'text'
   * @param {string} target Target property name
   * @param {!Array<!BindingPart>} parts Array of binding part metadata
   * @param {string=} literal Literal text surrounding binding parts (specified
   *   only for 'property' bindings, since these must be initialized as part
   *   of boot-up)
   * @return {void}
   * @private
   */


  function addBinding(constructor, templateInfo, nodeInfo, kind, target, parts, literal) {
    // Create binding metadata and add to nodeInfo
    nodeInfo.bindings = nodeInfo.bindings || [];
    let
    /** Binding */
    binding = {
      kind,
      target,
      parts,
      literal,
      isCompound: parts.length !== 1
    };
    nodeInfo.bindings.push(binding); // Add listener info to binding metadata

    if (shouldAddListener(binding)) {
      let {
        event,
        negate
      } = binding.parts[0];
      binding.listenerEvent = event || camelToDashCase(target) + '-changed';
      binding.listenerNegate = negate;
    } // Add "propagate" property effects to templateInfo


    let index = templateInfo.nodeInfoList.length;

    for (let i = 0; i < binding.parts.length; i++) {
      let part = binding.parts[i];
      part.compoundIndex = i;
      addEffectForBindingPart(constructor, templateInfo, binding, part, index);
    }
  }
  /**
   * Adds property effects to the given `templateInfo` for the given binding
   * part.
   *
   * @param {Function} constructor Class that `_parseTemplate` is currently
   *   running on
   * @param {TemplateInfo} templateInfo Template metadata for current template
   * @param {!Binding} binding Binding metadata
   * @param {!BindingPart} part Binding part metadata
   * @param {number} index Index into `nodeInfoList` for this node
   * @return {void}
   */


  function addEffectForBindingPart(constructor, templateInfo, binding, part, index) {
    if (!part.literal) {
      if (binding.kind === 'attribute' && binding.target[0] === '-') {
        console.warn('Cannot set attribute ' + binding.target + ' because "-" is not a valid attribute starting character');
      } else {
        let dependencies = part.dependencies;
        let info = {
          index,
          binding,
          part,
          evaluator: constructor
        };

        for (let j = 0; j < dependencies.length; j++) {
          let trigger = dependencies[j];

          if (typeof trigger == 'string') {
            trigger = parseArg(trigger);
            trigger.wildcard = true;
          }

          constructor._addTemplatePropertyEffect(templateInfo, trigger.rootProperty, {
            fn: runBindingEffect,
            info,
            trigger
          });
        }
      }
    }
  }
  /**
   * Implements the "binding" (property/path binding) effect.
   *
   * Note that binding syntax is overridable via `_parseBindings` and
   * `_evaluateBinding`.  This method will call `_evaluateBinding` for any
   * non-literal parts returned from `_parseBindings`.  However,
   * there is no support for _path_ bindings via custom binding parts,
   * as this is specific to Polymer's path binding syntax.
   *
   * @param {!Polymer_PropertyEffects} inst The instance the effect will be run on
   * @param {string} path Name of property
   * @param {Object} props Bag of current property changes
   * @param {Object} oldProps Bag of previous values for changed properties
   * @param {?} info Effect metadata
   * @param {boolean} hasPaths True with `props` contains one or more paths
   * @param {Array} nodeList List of nodes associated with `nodeInfoList` template
   *   metadata
   * @return {void}
   * @private
   */


  function runBindingEffect(inst, path, props, oldProps, info, hasPaths, nodeList) {
    let node = nodeList[info.index];
    let binding = info.binding;
    let part = info.part; // Subpath notification: transform path and set to client
    // e.g.: foo="{{obj.sub}}", path: 'obj.sub.prop', set 'foo.prop'=obj.sub.prop

    if (hasPaths && part.source && path.length > part.source.length && binding.kind == 'property' && !binding.isCompound && node.__isPropertyEffectsClient && node.__dataHasAccessor && node.__dataHasAccessor[binding.target]) {
      let value = props[path];
      path = translate(part.source, binding.target, path);

      if (node._setPendingPropertyOrPath(path, value, false, true)) {
        inst._enqueueClient(node);
      }
    } else {
      let value = info.evaluator._evaluateBinding(inst, part, path, props, oldProps, hasPaths); // Propagate value to child
      // Abort if value is a no-op result


      if (value !== NOOP) {
        applyBindingValue(inst, node, binding, part, value);
      }
    }
  }
  /**
   * Sets the value for an "binding" (binding) effect to a node,
   * either as a property or attribute.
   *
   * @param {!Polymer_PropertyEffects} inst The instance owning the binding effect
   * @param {Node} node Target node for binding
   * @param {!Binding} binding Binding metadata
   * @param {!BindingPart} part Binding part metadata
   * @param {*} value Value to set
   * @return {void}
   * @private
   */


  function applyBindingValue(inst, node, binding, part, value) {
    value = computeBindingValue(node, value, binding, part);

    if (sanitizeDOMValue) {
      value = sanitizeDOMValue(value, binding.target, binding.kind, node);
    }

    if (binding.kind == 'attribute') {
      // Attribute binding
      inst._valueToNodeAttribute(
      /** @type {Element} */
      node, value, binding.target);
    } else {
      // Property binding
      let prop = binding.target;

      if (node.__isPropertyEffectsClient && node.__dataHasAccessor && node.__dataHasAccessor[prop]) {
        if (!node[TYPES.READ_ONLY] || !node[TYPES.READ_ONLY][prop]) {
          if (node._setPendingProperty(prop, value)) {
            inst._enqueueClient(node);
          }
        }
      } else {
        // In legacy no-batching mode, bindings applied before dataReady are
        // equivalent to the "apply config" phase, which only set managed props
        inst._setUnmanagedPropertyToNode(node, prop, value);
      }
    }
  }
  /**
   * Transforms an "binding" effect value based on compound & negation
   * effect metadata, as well as handling for special-case properties
   *
   * @param {Node} node Node the value will be set to
   * @param {*} value Value to set
   * @param {!Binding} binding Binding metadata
   * @param {!BindingPart} part Binding part metadata
   * @return {*} Transformed value to set
   * @private
   */


  function computeBindingValue(node, value, binding, part) {
    if (binding.isCompound) {
      let storage = node.__dataCompoundStorage[binding.target];
      storage[part.compoundIndex] = value;
      value = storage.join('');
    }

    if (binding.kind !== 'attribute') {
      // Some browsers serialize `undefined` to `"undefined"`
      if (binding.target === 'textContent' || binding.target === 'value' && (node.localName === 'input' || node.localName === 'textarea')) {
        value = value == undefined ? '' : value;
      }
    }

    return value;
  }
  /**
   * Returns true if a binding's metadata meets all the requirements to allow
   * 2-way binding, and therefore a `<property>-changed` event listener should be
   * added:
   * - used curly braces
   * - is a property (not attribute) binding
   * - is not a textContent binding
   * - is not compound
   *
   * @param {!Binding} binding Binding metadata
   * @return {boolean} True if 2-way listener should be added
   * @private
   */


  function shouldAddListener(binding) {
    return Boolean(binding.target) && binding.kind != 'attribute' && binding.kind != 'text' && !binding.isCompound && binding.parts[0].mode === '{';
  }
  /**
   * Setup compound binding storage structures, notify listeners, and dataHost
   * references onto the bound nodeList.
   *
   * @param {!Polymer_PropertyEffects} inst Instance that bas been previously
   *     bound
   * @param {TemplateInfo} templateInfo Template metadata
   * @return {void}
   * @private
   */


  function setupBindings(inst, templateInfo) {
    // Setup compound storage, dataHost, and notify listeners
    let {
      nodeList,
      nodeInfoList
    } = templateInfo;

    if (nodeInfoList.length) {
      for (let i = 0; i < nodeInfoList.length; i++) {
        let info = nodeInfoList[i];
        let node = nodeList[i];
        let bindings = info.bindings;

        if (bindings) {
          for (let i = 0; i < bindings.length; i++) {
            let binding = bindings[i];
            setupCompoundStorage(node, binding);
            addNotifyListener(node, inst, binding);
          }
        } // This ensures all bound elements have a host set, regardless
        // of whether they upgrade synchronous to creation


        node.__dataHost = inst;
      }
    }
  }
  /**
   * Initializes `__dataCompoundStorage` local storage on a bound node with
   * initial literal data for compound bindings, and sets the joined
   * literal parts to the bound property.
   *
   * When changes to compound parts occur, they are first set into the compound
   * storage array for that property, and then the array is joined to result in
   * the final value set to the property/attribute.
   *
   * @param {Node} node Bound node to initialize
   * @param {Binding} binding Binding metadata
   * @return {void}
   * @private
   */


  function setupCompoundStorage(node, binding) {
    if (binding.isCompound) {
      // Create compound storage map
      let storage = node.__dataCompoundStorage || (node.__dataCompoundStorage = {});
      let parts = binding.parts; // Copy literals from parts into storage for this binding

      let literals = new Array(parts.length);

      for (let j = 0; j < parts.length; j++) {
        literals[j] = parts[j].literal;
      }

      let target = binding.target;
      storage[target] = literals; // Configure properties with their literal parts

      if (binding.literal && binding.kind == 'property') {
        // Note, className needs style scoping so this needs wrapping.
        // We may also want to consider doing this for `textContent` and
        // `innerHTML`.
        if (target === 'className') {
          node = wrap$1(node);
        }

        node[target] = binding.literal;
      }
    }
  }
  /**
   * Adds a 2-way binding notification event listener to the node specified
   *
   * @param {Object} node Child element to add listener to
   * @param {!Polymer_PropertyEffects} inst Host element instance to handle
   *     notification event
   * @param {Binding} binding Binding metadata
   * @return {void}
   * @private
   */


  function addNotifyListener(node, inst, binding) {
    if (binding.listenerEvent) {
      let part = binding.parts[0];
      node.addEventListener(binding.listenerEvent, function (e) {
        handleNotification(e, inst, binding.target, part.source, part.negate);
      });
    }
  } // -- for method-based effects (complexObserver & computed) --------------

  /**
   * Adds property effects for each argument in the method signature (and
   * optionally, for the method name if `dynamic` is true) that calls the
   * provided effect function.
   *
   * @param {Element | Object} model Prototype or instance
   * @param {!MethodSignature} sig Method signature metadata
   * @param {string} type Type of property effect to add
   * @param {Function} effectFn Function to run when arguments change
   * @param {*=} methodInfo Effect-specific information to be included in
   *   method effect metadata
   * @param {boolean|Object=} dynamicFn Boolean or object map indicating whether
   *   method names should be included as a dependency to the effect. Note,
   *   defaults to true if the signature is static (sig.static is true).
   * @return {!Object} Effect metadata for this method effect
   * @private
   */


  function createMethodEffect(model, sig, type, effectFn, methodInfo, dynamicFn) {
    dynamicFn = sig.static || dynamicFn && (typeof dynamicFn !== 'object' || dynamicFn[sig.methodName]);
    let info = {
      methodName: sig.methodName,
      args: sig.args,
      methodInfo,
      dynamicFn
    };

    for (let i = 0, arg; i < sig.args.length && (arg = sig.args[i]); i++) {
      if (!arg.literal) {
        model._addPropertyEffect(arg.rootProperty, type, {
          fn: effectFn,
          info: info,
          trigger: arg
        });
      }
    }

    if (dynamicFn) {
      model._addPropertyEffect(sig.methodName, type, {
        fn: effectFn,
        info: info
      });
    }

    return info;
  }
  /**
   * Calls a method with arguments marshaled from properties on the instance
   * based on the method signature contained in the effect metadata.
   *
   * Multi-property observers, computed properties, and inline computing
   * functions call this function to invoke the method, then use the return
   * value accordingly.
   *
   * @param {!Polymer_PropertyEffects} inst The instance the effect will be run on
   * @param {string} property Name of property
   * @param {Object} props Bag of current property changes
   * @param {Object} oldProps Bag of previous values for changed properties
   * @param {?} info Effect metadata
   * @return {*} Returns the return value from the method invocation
   * @private
   */


  function runMethodEffect(inst, property, props, oldProps, info) {
    // Instances can optionally have a _methodHost which allows redirecting where
    // to find methods. Currently used by `templatize`.
    let context = inst._methodHost || inst;
    let fn = context[info.methodName];

    if (fn) {
      let args = inst._marshalArgs(info.args, property, props);

      return args === NOOP ? NOOP : fn.apply(context, args);
    } else if (!info.dynamicFn) {
      console.warn('method `' + info.methodName + '` not defined');
    }
  }

  const emptyArray = []; // Regular expressions used for binding

  const IDENT = '(?:' + '[a-zA-Z_$][\\w.:$\\-*]*' + ')';
  const NUMBER = '(?:' + '[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?' + ')';
  const SQUOTE_STRING = '(?:' + '\'(?:[^\'\\\\]|\\\\.)*\'' + ')';
  const DQUOTE_STRING = '(?:' + '"(?:[^"\\\\]|\\\\.)*"' + ')';
  const STRING = '(?:' + SQUOTE_STRING + '|' + DQUOTE_STRING + ')';
  const ARGUMENT = '(?:(' + IDENT + '|' + NUMBER + '|' + STRING + ')\\s*' + ')';
  const ARGUMENTS = '(?:' + ARGUMENT + '(?:,\\s*' + ARGUMENT + ')*' + ')';
  const ARGUMENT_LIST = '(?:' + '\\(\\s*' + '(?:' + ARGUMENTS + '?' + ')' + '\\)\\s*' + ')';
  const BINDING = '(' + IDENT + '\\s*' + ARGUMENT_LIST + '?' + ')'; // Group 3

  const OPEN_BRACKET = '(\\[\\[|{{)' + '\\s*';
  const CLOSE_BRACKET = '(?:]]|}})';
  const NEGATE = '(?:(!)\\s*)?'; // Group 2

  const EXPRESSION = OPEN_BRACKET + NEGATE + BINDING + CLOSE_BRACKET;
  const bindingRegex = new RegExp(EXPRESSION, "g");
  /**
   * Create a string from binding parts of all the literal parts
   *
   * @param {!Array<BindingPart>} parts All parts to stringify
   * @return {string} String made from the literal parts
   */

  function literalFromParts(parts) {
    let s = '';

    for (let i = 0; i < parts.length; i++) {
      let literal = parts[i].literal;
      s += literal || '';
    }

    return s;
  }
  /**
   * Parses an expression string for a method signature, and returns a metadata
   * describing the method in terms of `methodName`, `static` (whether all the
   * arguments are literals), and an array of `args`
   *
   * @param {string} expression The expression to parse
   * @return {?MethodSignature} The method metadata object if a method expression was
   *   found, otherwise `undefined`
   * @private
   */


  function parseMethod(expression) {
    // tries to match valid javascript property names
    let m = expression.match(/([^\s]+?)\(([\s\S]*)\)/);

    if (m) {
      let methodName = m[1];
      let sig = {
        methodName,
        static: true,
        args: emptyArray
      };

      if (m[2].trim()) {
        // replace escaped commas with comma entity, split on un-escaped commas
        let args = m[2].replace(/\\,/g, '&comma;').split(',');
        return parseArgs(args, sig);
      } else {
        return sig;
      }
    }

    return null;
  }
  /**
   * Parses an array of arguments and sets the `args` property of the supplied
   * signature metadata object. Sets the `static` property to false if any
   * argument is a non-literal.
   *
   * @param {!Array<string>} argList Array of argument names
   * @param {!MethodSignature} sig Method signature metadata object
   * @return {!MethodSignature} The updated signature metadata object
   * @private
   */


  function parseArgs(argList, sig) {
    sig.args = argList.map(function (rawArg) {
      let arg = parseArg(rawArg);

      if (!arg.literal) {
        sig.static = false;
      }

      return arg;
    }, this);
    return sig;
  }
  /**
   * Parses an individual argument, and returns an argument metadata object
   * with the following fields:
   *
   *   {
   *     value: 'prop',        // property/path or literal value
   *     literal: false,       // whether argument is a literal
   *     structured: false,    // whether the property is a path
   *     rootProperty: 'prop', // the root property of the path
   *     wildcard: false       // whether the argument was a wildcard '.*' path
   *   }
   *
   * @param {string} rawArg The string value of the argument
   * @return {!MethodArg} Argument metadata object
   * @private
   */


  function parseArg(rawArg) {
    // clean up whitespace
    let arg = rawArg.trim() // replace comma entity with comma
    .replace(/&comma;/g, ',') // repair extra escape sequences; note only commas strictly need
    // escaping, but we allow any other char to be escaped since its
    // likely users will do this
    .replace(/\\(.)/g, '\$1'); // basic argument descriptor

    let a = {
      name: arg,
      value: '',
      literal: false
    }; // detect literal value (must be String or Number)

    let fc = arg[0];

    if (fc === '-') {
      fc = arg[1];
    }

    if (fc >= '0' && fc <= '9') {
      fc = '#';
    }

    switch (fc) {
      case "'":
      case '"':
        a.value = arg.slice(1, -1);
        a.literal = true;
        break;

      case '#':
        a.value = Number(arg);
        a.literal = true;
        break;
    } // if not literal, look for structured path


    if (!a.literal) {
      a.rootProperty = root(arg); // detect structured path (has dots)

      a.structured = isPath(arg);

      if (a.structured) {
        a.wildcard = arg.slice(-2) == '.*';

        if (a.wildcard) {
          a.name = arg.slice(0, -2);
        }
      }
    }

    return a;
  }

  function getArgValue(data, props, path) {
    let value = get(data, path); // when data is not stored e.g. `splices`, get the value from changedProps
    // TODO(kschaaf): Note, this can cause a rare issue where the wildcard
    // info.value could pull a stale value out of changedProps during a reentrant
    // change that sets the value back to undefined.
    // https://github.com/Polymer/polymer/issues/5479

    if (value === undefined) {
      value = props[path];
    }

    return value;
  } // data api

  /**
   * Sends array splice notifications (`.splices` and `.length`)
   *
   * Note: this implementation only accepts normalized paths
   *
   * @param {!Polymer_PropertyEffects} inst Instance to send notifications to
   * @param {Array} array The array the mutations occurred on
   * @param {string} path The path to the array that was mutated
   * @param {Array} splices Array of splice records
   * @return {void}
   * @private
   */


  function notifySplices(inst, array, path, splices) {
    const splicesData = {
      indexSplices: splices
    }; // Legacy behavior stored splices in `__data__` so it was *not* ephemeral.
    // To match this behavior, we store splices directly on the array.

    if (legacyUndefined && !inst._overrideLegacyUndefined) {
      array.splices = splicesData;
    }

    inst.notifyPath(path + '.splices', splicesData);
    inst.notifyPath(path + '.length', array.length); // Clear splice data only when it's stored on the array.

    if (legacyUndefined && !inst._overrideLegacyUndefined) {
      splicesData.indexSplices = [];
    }
  }
  /**
   * Creates a splice record and sends an array splice notification for
   * the described mutation
   *
   * Note: this implementation only accepts normalized paths
   *
   * @param {!Polymer_PropertyEffects} inst Instance to send notifications to
   * @param {Array} array The array the mutations occurred on
   * @param {string} path The path to the array that was mutated
   * @param {number} index Index at which the array mutation occurred
   * @param {number} addedCount Number of added items
   * @param {Array} removed Array of removed items
   * @return {void}
   * @private
   */


  function notifySplice(inst, array, path, index, addedCount, removed) {
    notifySplices(inst, array, path, [{
      index: index,
      addedCount: addedCount,
      removed: removed,
      object: array,
      type: 'splice'
    }]);
  }
  /**
   * Returns an upper-cased version of the string.
   *
   * @param {string} name String to uppercase
   * @return {string} Uppercased string
   * @private
   */


  function upper(name) {
    return name[0].toUpperCase() + name.substring(1);
  }
  /**
   * Element class mixin that provides meta-programming for Polymer's template
   * binding and data observation (collectively, "property effects") system.
   *
   * This mixin uses provides the following key static methods for adding
   * property effects to an element class:
   * - `addPropertyEffect`
   * - `createPropertyObserver`
   * - `createMethodObserver`
   * - `createNotifyingProperty`
   * - `createReadOnlyProperty`
   * - `createReflectedProperty`
   * - `createComputedProperty`
   * - `bindTemplate`
   *
   * Each method creates one or more property accessors, along with metadata
   * used by this mixin's implementation of `_propertiesChanged` to perform
   * the property effects.
   *
   * Underscored versions of the above methods also exist on the element
   * prototype for adding property effects on instances at runtime.
   *
   * Note that this mixin overrides several `PropertyAccessors` methods, in
   * many cases to maintain guarantees provided by the Polymer 1.x features;
   * notably it changes property accessors to be synchronous by default
   * whereas the default when using `PropertyAccessors` standalone is to be
   * async by default.
   *
   * @mixinFunction
   * @polymer
   * @appliesMixin TemplateStamp
   * @appliesMixin PropertyAccessors
   * @summary Element class mixin that provides meta-programming for Polymer's
   * template binding and data observation system.
   */


  const PropertyEffects = dedupingMixin(superClass => {
    /**
     * @constructor
     * @implements {Polymer_PropertyAccessors}
     * @implements {Polymer_TemplateStamp}
     * @unrestricted
     * @private
     */
    const propertyEffectsBase = TemplateStamp(PropertyAccessors(superClass));
    /**
     * @polymer
     * @mixinClass
     * @implements {Polymer_PropertyEffects}
     * @extends {propertyEffectsBase}
     * @unrestricted
     */

    class PropertyEffects extends propertyEffectsBase {
      constructor() {
        super();
        /** @type {boolean} */
        // Used to identify users of this mixin, ala instanceof

        this.__isPropertyEffectsClient = true;
        /** @type {boolean} */

        this.__dataClientsReady;
        /** @type {Array} */

        this.__dataPendingClients;
        /** @type {Object} */

        this.__dataToNotify;
        /** @type {Object} */

        this.__dataLinkedPaths;
        /** @type {boolean} */

        this.__dataHasPaths;
        /** @type {Object} */

        this.__dataCompoundStorage;
        /** @type {Polymer_PropertyEffects} */

        this.__dataHost;
        /** @type {!Object} */

        this.__dataTemp;
        /** @type {boolean} */

        this.__dataClientsInitialized;
        /** @type {!Object} */

        this.__data;
        /** @type {!Object|null} */

        this.__dataPending;
        /** @type {!Object} */

        this.__dataOld;
        /** @type {Object} */

        this.__computeEffects;
        /** @type {Object} */

        this.__computeInfo;
        /** @type {Object} */

        this.__reflectEffects;
        /** @type {Object} */

        this.__notifyEffects;
        /** @type {Object} */

        this.__propagateEffects;
        /** @type {Object} */

        this.__observeEffects;
        /** @type {Object} */

        this.__readOnly;
        /** @type {!TemplateInfo} */

        this.__templateInfo;
        /** @type {boolean} */

        this._overrideLegacyUndefined;
      }

      get PROPERTY_EFFECT_TYPES() {
        return TYPES;
      }
      /**
       * @override
       * @return {void}
       */


      _initializeProperties() {
        super._initializeProperties();

        this._registerHost();

        this.__dataClientsReady = false;
        this.__dataPendingClients = null;
        this.__dataToNotify = null;
        this.__dataLinkedPaths = null;
        this.__dataHasPaths = false; // May be set on instance prior to upgrade

        this.__dataCompoundStorage = this.__dataCompoundStorage || null;
        this.__dataHost = this.__dataHost || null;
        this.__dataTemp = {};
        this.__dataClientsInitialized = false;
      }

      _registerHost() {
        if (hostStack.length) {
          let host = hostStack[hostStack.length - 1];

          host._enqueueClient(this); // This ensures even non-bound elements have a host set, as
          // long as they upgrade synchronously


          this.__dataHost = host;
        }
      }
      /**
       * Overrides `PropertyAccessors` implementation to provide a
       * more efficient implementation of initializing properties from
       * the prototype on the instance.
       *
       * @override
       * @param {Object} props Properties to initialize on the prototype
       * @return {void}
       */


      _initializeProtoProperties(props) {
        this.__data = Object.create(props);
        this.__dataPending = Object.create(props);
        this.__dataOld = {};
      }
      /**
       * Overrides `PropertyAccessors` implementation to avoid setting
       * `_setProperty`'s `shouldNotify: true`.
       *
       * @override
       * @param {Object} props Properties to initialize on the instance
       * @return {void}
       */


      _initializeInstanceProperties(props) {
        let readOnly = this[TYPES.READ_ONLY];

        for (let prop in props) {
          if (!readOnly || !readOnly[prop]) {
            this.__dataPending = this.__dataPending || {};
            this.__dataOld = this.__dataOld || {};
            this.__data[prop] = this.__dataPending[prop] = props[prop];
          }
        }
      } // Prototype setup ----------------------------------------

      /**
       * Equivalent to static `addPropertyEffect` API but can be called on
       * an instance to add effects at runtime.  See that method for
       * full API docs.
       *
       * @override
       * @param {string} property Property that should trigger the effect
       * @param {string} type Effect type, from this.PROPERTY_EFFECT_TYPES
       * @param {Object=} effect Effect metadata object
       * @return {void}
       * @protected
       */


      _addPropertyEffect(property, type, effect) {
        this._createPropertyAccessor(property, type == TYPES.READ_ONLY); // effects are accumulated into arrays per property based on type


        let effects = ensureOwnEffectMap(this, type, true)[property];

        if (!effects) {
          effects = this[type][property] = [];
        }

        effects.push(effect);
      }
      /**
       * Removes the given property effect.
       *
       * @override
       * @param {string} property Property the effect was associated with
       * @param {string} type Effect type, from this.PROPERTY_EFFECT_TYPES
       * @param {Object=} effect Effect metadata object to remove
       * @return {void}
       */


      _removePropertyEffect(property, type, effect) {
        let effects = ensureOwnEffectMap(this, type, true)[property];
        let idx = effects.indexOf(effect);

        if (idx >= 0) {
          effects.splice(idx, 1);
        }
      }
      /**
       * Returns whether the current prototype/instance has a property effect
       * of a certain type.
       *
       * @override
       * @param {string} property Property name
       * @param {string=} type Effect type, from this.PROPERTY_EFFECT_TYPES
       * @return {boolean} True if the prototype/instance has an effect of this
       *     type
       * @protected
       */


      _hasPropertyEffect(property, type) {
        let effects = this[type];
        return Boolean(effects && effects[property]);
      }
      /**
       * Returns whether the current prototype/instance has a "read only"
       * accessor for the given property.
       *
       * @override
       * @param {string} property Property name
       * @return {boolean} True if the prototype/instance has an effect of this
       *     type
       * @protected
       */


      _hasReadOnlyEffect(property) {
        return this._hasPropertyEffect(property, TYPES.READ_ONLY);
      }
      /**
       * Returns whether the current prototype/instance has a "notify"
       * property effect for the given property.
       *
       * @override
       * @param {string} property Property name
       * @return {boolean} True if the prototype/instance has an effect of this
       *     type
       * @protected
       */


      _hasNotifyEffect(property) {
        return this._hasPropertyEffect(property, TYPES.NOTIFY);
      }
      /**
       * Returns whether the current prototype/instance has a "reflect to
       * attribute" property effect for the given property.
       *
       * @override
       * @param {string} property Property name
       * @return {boolean} True if the prototype/instance has an effect of this
       *     type
       * @protected
       */


      _hasReflectEffect(property) {
        return this._hasPropertyEffect(property, TYPES.REFLECT);
      }
      /**
       * Returns whether the current prototype/instance has a "computed"
       * property effect for the given property.
       *
       * @override
       * @param {string} property Property name
       * @return {boolean} True if the prototype/instance has an effect of this
       *     type
       * @protected
       */


      _hasComputedEffect(property) {
        return this._hasPropertyEffect(property, TYPES.COMPUTE);
      } // Runtime ----------------------------------------

      /**
       * Sets a pending property or path.  If the root property of the path in
       * question had no accessor, the path is set, otherwise it is enqueued
       * via `_setPendingProperty`.
       *
       * This function isolates relatively expensive functionality necessary
       * for the public API (`set`, `setProperties`, `notifyPath`, and property
       * change listeners via {{...}} bindings), such that it is only done
       * when paths enter the system, and not at every propagation step.  It
       * also sets a `__dataHasPaths` flag on the instance which is used to
       * fast-path slower path-matching code in the property effects host paths.
       *
       * `path` can be a path string or array of path parts as accepted by the
       * public API.
       *
       * @override
       * @param {string | !Array<number|string>} path Path to set
       * @param {*} value Value to set
       * @param {boolean=} shouldNotify Set to true if this change should
       *  cause a property notification event dispatch
       * @param {boolean=} isPathNotification If the path being set is a path
       *   notification of an already changed value, as opposed to a request
       *   to set and notify the change.  In the latter `false` case, a dirty
       *   check is performed and then the value is set to the path before
       *   enqueuing the pending property change.
       * @return {boolean} Returns true if the property/path was enqueued in
       *   the pending changes bag.
       * @protected
       */


      _setPendingPropertyOrPath(path, value, shouldNotify, isPathNotification) {
        if (isPathNotification || root(Array.isArray(path) ? path[0] : path) !== path) {
          // Dirty check changes being set to a path against the actual object,
          // since this is the entry point for paths into the system; from here
          // the only dirty checks are against the `__dataTemp` cache to prevent
          // duplicate work in the same turn only. Note, if this was a notification
          // of a change already set to a path (isPathNotification: true),
          // we always let the change through and skip the `set` since it was
          // already dirty checked at the point of entry and the underlying
          // object has already been updated
          if (!isPathNotification) {
            let old = get(this, path);
            path =
            /** @type {string} */
            set(this, path, value); // Use property-accessor's simpler dirty check

            if (!path || !super._shouldPropertyChange(path, value, old)) {
              return false;
            }
          }

          this.__dataHasPaths = true;

          if (this._setPendingProperty(
          /**@type{string}*/
          path, value, shouldNotify)) {
            computeLinkedPaths(this,
            /**@type{string}*/
            path, value);
            return true;
          }
        } else {
          if (this.__dataHasAccessor && this.__dataHasAccessor[path]) {
            return this._setPendingProperty(
            /**@type{string}*/
            path, value, shouldNotify);
          } else {
            this[path] = value;
          }
        }

        return false;
      }
      /**
       * Applies a value to a non-Polymer element/node's property.
       *
       * The implementation makes a best-effort at binding interop:
       * Some native element properties have side-effects when
       * re-setting the same value (e.g. setting `<input>.value` resets the
       * cursor position), so we do a dirty-check before setting the value.
       * However, for better interop with non-Polymer custom elements that
       * accept objects, we explicitly re-set object changes coming from the
       * Polymer world (which may include deep object changes without the
       * top reference changing), erring on the side of providing more
       * information.
       *
       * Users may override this method to provide alternate approaches.
       *
       * @override
       * @param {!Node} node The node to set a property on
       * @param {string} prop The property to set
       * @param {*} value The value to set
       * @return {void}
       * @protected
       */


      _setUnmanagedPropertyToNode(node, prop, value) {
        // It is a judgment call that resetting primitives is
        // "bad" and resettings objects is also "good"; alternatively we could
        // implement a whitelist of tag & property values that should never
        // be reset (e.g. <input>.value && <select>.value)
        if (value !== node[prop] || typeof value == 'object') {
          // Note, className needs style scoping so this needs wrapping.
          if (prop === 'className') {
            node =
            /** @type {!Node} */
            wrap$1(node);
          }

          node[prop] = value;
        }
      }
      /**
       * Overrides the `PropertiesChanged` implementation to introduce special
       * dirty check logic depending on the property & value being set:
       *
       * 1. Any value set to a path (e.g. 'obj.prop': 42 or 'obj.prop': {...})
       *    Stored in `__dataTemp`, dirty checked against `__dataTemp`
       * 2. Object set to simple property (e.g. 'prop': {...})
       *    Stored in `__dataTemp` and `__data`, dirty checked against
       *    `__dataTemp` by default implementation of `_shouldPropertyChange`
       * 3. Primitive value set to simple property (e.g. 'prop': 42)
       *    Stored in `__data`, dirty checked against `__data`
       *
       * The dirty-check is important to prevent cycles due to two-way
       * notification, but paths and objects are only dirty checked against any
       * previous value set during this turn via a "temporary cache" that is
       * cleared when the last `_propertiesChanged` exits. This is so:
       * a. any cached array paths (e.g. 'array.3.prop') may be invalidated
       *    due to array mutations like shift/unshift/splice; this is fine
       *    since path changes are dirty-checked at user entry points like `set`
       * b. dirty-checking for objects only lasts one turn to allow the user
       *    to mutate the object in-place and re-set it with the same identity
       *    and have all sub-properties re-propagated in a subsequent turn.
       *
       * The temp cache is not necessarily sufficient to prevent invalid array
       * paths, since a splice can happen during the same turn (with pathological
       * user code); we could introduce a "fixup" for temporarily cached array
       * paths if needed: https://github.com/Polymer/polymer/issues/4227
       *
       * @override
       * @param {string} property Name of the property
       * @param {*} value Value to set
       * @param {boolean=} shouldNotify True if property should fire notification
       *   event (applies only for `notify: true` properties)
       * @return {boolean} Returns true if the property changed
       */


      _setPendingProperty(property, value, shouldNotify) {
        let propIsPath = this.__dataHasPaths && isPath(property);
        let prevProps = propIsPath ? this.__dataTemp : this.__data;

        if (this._shouldPropertyChange(property, value, prevProps[property])) {
          if (!this.__dataPending) {
            this.__dataPending = {};
            this.__dataOld = {};
          } // Ensure old is captured from the last turn


          if (!(property in this.__dataOld)) {
            this.__dataOld[property] = this.__data[property];
          } // Paths are stored in temporary cache (cleared at end of turn),
          // which is used for dirty-checking, all others stored in __data


          if (propIsPath) {
            this.__dataTemp[property] = value;
          } else {
            this.__data[property] = value;
          } // All changes go into pending property bag, passed to _propertiesChanged


          this.__dataPending[property] = value; // Track properties that should notify separately

          if (propIsPath || this[TYPES.NOTIFY] && this[TYPES.NOTIFY][property]) {
            this.__dataToNotify = this.__dataToNotify || {};
            this.__dataToNotify[property] = shouldNotify;
          }

          return true;
        }

        return false;
      }
      /**
       * Overrides base implementation to ensure all accessors set `shouldNotify`
       * to true, for per-property notification tracking.
       *
       * @override
       * @param {string} property Name of the property
       * @param {*} value Value to set
       * @return {void}
       */


      _setProperty(property, value) {
        if (this._setPendingProperty(property, value, true)) {
          this._invalidateProperties();
        }
      }
      /**
       * Overrides `PropertyAccessor`'s default async queuing of
       * `_propertiesChanged`: if `__dataReady` is false (has not yet been
       * manually flushed), the function no-ops; otherwise flushes
       * `_propertiesChanged` synchronously.
       *
       * @override
       * @return {void}
       */


      _invalidateProperties() {
        if (this.__dataReady) {
          this._flushProperties();
        }
      }
      /**
       * Enqueues the given client on a list of pending clients, whose
       * pending property changes can later be flushed via a call to
       * `_flushClients`.
       *
       * @override
       * @param {Object} client PropertyEffects client to enqueue
       * @return {void}
       * @protected
       */


      _enqueueClient(client) {
        this.__dataPendingClients = this.__dataPendingClients || [];

        if (client !== this) {
          this.__dataPendingClients.push(client);
        }
      }
      /**
       * Flushes any clients previously enqueued via `_enqueueClient`, causing
       * their `_flushProperties` method to run.
       *
       * @override
       * @return {void}
       * @protected
       */


      _flushClients() {
        if (!this.__dataClientsReady) {
          this.__dataClientsReady = true;

          this._readyClients(); // Override point where accessors are turned on; importantly,
          // this is after clients have fully readied, providing a guarantee
          // that any property effects occur only after all clients are ready.


          this.__dataReady = true;
        } else {
          this.__enableOrFlushClients();
        }
      } // NOTE: We ensure clients either enable or flush as appropriate. This
      // handles two corner cases:
      // (1) clients flush properly when connected/enabled before the host
      // enables; e.g.
      //   (a) Templatize stamps with no properties and does not flush and
      //   (b) the instance is inserted into dom and
      //   (c) then the instance flushes.
      // (2) clients enable properly when not connected/enabled when the host
      // flushes; e.g.
      //   (a) a template is runtime stamped and not yet connected/enabled
      //   (b) a host sets a property, causing stamped dom to flush
      //   (c) the stamped dom enables.


      __enableOrFlushClients() {
        let clients = this.__dataPendingClients;

        if (clients) {
          this.__dataPendingClients = null;

          for (let i = 0; i < clients.length; i++) {
            let client = clients[i];

            if (!client.__dataEnabled) {
              client._enableProperties();
            } else if (client.__dataPending) {
              client._flushProperties();
            }
          }
        }
      }
      /**
       * Perform any initial setup on client dom. Called before the first
       * `_flushProperties` call on client dom and before any element
       * observers are called.
       *
       * @override
       * @return {void}
       * @protected
       */


      _readyClients() {
        this.__enableOrFlushClients();
      }
      /**
       * Sets a bag of property changes to this instance, and
       * synchronously processes all effects of the properties as a batch.
       *
       * Property names must be simple properties, not paths.  Batched
       * path propagation is not supported.
       *
       * @override
       * @param {Object} props Bag of one or more key-value pairs whose key is
       *   a property and value is the new value to set for that property.
       * @param {boolean=} setReadOnly When true, any private values set in
       *   `props` will be set. By default, `setProperties` will not set
       *   `readOnly: true` root properties.
       * @return {void}
       * @public
       */


      setProperties(props, setReadOnly) {
        for (let path in props) {
          if (setReadOnly || !this[TYPES.READ_ONLY] || !this[TYPES.READ_ONLY][path]) {
            //TODO(kschaaf): explicitly disallow paths in setProperty?
            // wildcard observers currently only pass the first changed path
            // in the `info` object, and you could do some odd things batching
            // paths, e.g. {'foo.bar': {...}, 'foo': null}
            this._setPendingPropertyOrPath(path, props[path], true);
          }
        }

        this._invalidateProperties();
      }
      /**
       * Overrides `PropertyAccessors` so that property accessor
       * side effects are not enabled until after client dom is fully ready.
       * Also calls `_flushClients` callback to ensure client dom is enabled
       * that was not enabled as a result of flushing properties.
       *
       * @override
       * @return {void}
       */


      ready() {
        // It is important that `super.ready()` is not called here as it
        // immediately turns on accessors. Instead, we wait until `readyClients`
        // to enable accessors to provide a guarantee that clients are ready
        // before processing any accessors side effects.
        this._flushProperties(); // If no data was pending, `_flushProperties` will not `flushClients`
        // so ensure this is done.


        if (!this.__dataClientsReady) {
          this._flushClients();
        } // Before ready, client notifications do not trigger _flushProperties.
        // Therefore a flush is necessary here if data has been set.


        if (this.__dataPending) {
          this._flushProperties();
        }
      }
      /**
       * Implements `PropertyAccessors`'s properties changed callback.
       *
       * Runs each class of effects for the batch of changed properties in
       * a specific order (compute, propagate, reflect, observe, notify).
       *
       * @override
       * @param {!Object} currentProps Bag of all current accessor values
       * @param {?Object} changedProps Bag of properties changed since the last
       *   call to `_propertiesChanged`
       * @param {?Object} oldProps Bag of previous values for each property
       *   in `changedProps`
       * @return {void}
       */


      _propertiesChanged(currentProps, changedProps, oldProps) {
        // ----------------------------
        // let c = Object.getOwnPropertyNames(changedProps || {});
        // window.debug && console.group(this.localName + '#' + this.id + ': ' + c);
        // if (window.debug) { debugger; }
        // ----------------------------
        let hasPaths = this.__dataHasPaths;
        this.__dataHasPaths = false;
        let notifyProps; // Compute properties

        runComputedEffects(this, changedProps, oldProps, hasPaths); // Clear notify properties prior to possible reentry (propagate, observe),
        // but after computing effects have a chance to add to them

        notifyProps = this.__dataToNotify;
        this.__dataToNotify = null; // Propagate properties to clients

        this._propagatePropertyChanges(changedProps, oldProps, hasPaths); // Flush clients


        this._flushClients(); // Reflect properties


        runEffects(this, this[TYPES.REFLECT], changedProps, oldProps, hasPaths); // Observe properties

        runEffects(this, this[TYPES.OBSERVE], changedProps, oldProps, hasPaths); // Notify properties to host

        if (notifyProps) {
          runNotifyEffects(this, notifyProps, changedProps, oldProps, hasPaths);
        } // Clear temporary cache at end of turn


        if (this.__dataCounter == 1) {
          this.__dataTemp = {};
        } // ----------------------------
        // window.debug && console.groupEnd(this.localName + '#' + this.id + ': ' + c);
        // ----------------------------

      }
      /**
       * Called to propagate any property changes to stamped template nodes
       * managed by this element.
       *
       * @override
       * @param {Object} changedProps Bag of changed properties
       * @param {Object} oldProps Bag of previous values for changed properties
       * @param {boolean} hasPaths True with `props` contains one or more paths
       * @return {void}
       * @protected
       */


      _propagatePropertyChanges(changedProps, oldProps, hasPaths) {
        if (this[TYPES.PROPAGATE]) {
          runEffects(this, this[TYPES.PROPAGATE], changedProps, oldProps, hasPaths);
        }

        if (this.__templateInfo) {
          this._runEffectsForTemplate(this.__templateInfo, changedProps, oldProps, hasPaths);
        }
      }

      _runEffectsForTemplate(templateInfo, changedProps, oldProps, hasPaths) {
        const baseRunEffects = (changedProps, hasPaths) => {
          runEffects(this, templateInfo.propertyEffects, changedProps, oldProps, hasPaths, templateInfo.nodeList);

          for (let info = templateInfo.firstChild; info; info = info.nextSibling) {
            this._runEffectsForTemplate(info, changedProps, oldProps, hasPaths);
          }
        };

        if (templateInfo.runEffects) {
          templateInfo.runEffects(baseRunEffects, changedProps, hasPaths);
        } else {
          baseRunEffects(changedProps, hasPaths);
        }
      }
      /**
       * Aliases one data path as another, such that path notifications from one
       * are routed to the other.
       *
       * @override
       * @param {string | !Array<string|number>} to Target path to link.
       * @param {string | !Array<string|number>} from Source path to link.
       * @return {void}
       * @public
       */


      linkPaths(to, from) {
        to = normalize(to);
        from = normalize(from);
        this.__dataLinkedPaths = this.__dataLinkedPaths || {};
        this.__dataLinkedPaths[to] = from;
      }
      /**
       * Removes a data path alias previously established with `_linkPaths`.
       *
       * Note, the path to unlink should be the target (`to`) used when
       * linking the paths.
       *
       * @override
       * @param {string | !Array<string|number>} path Target path to unlink.
       * @return {void}
       * @public
       */


      unlinkPaths(path) {
        path = normalize(path);

        if (this.__dataLinkedPaths) {
          delete this.__dataLinkedPaths[path];
        }
      }
      /**
       * Notify that an array has changed.
       *
       * Example:
       *
       *     this.items = [ {name: 'Jim'}, {name: 'Todd'}, {name: 'Bill'} ];
       *     ...
       *     this.items.splice(1, 1, {name: 'Sam'});
       *     this.items.push({name: 'Bob'});
       *     this.notifySplices('items', [
       *       { index: 1, removed: [{name: 'Todd'}], addedCount: 1,
       *         object: this.items, type: 'splice' },
       *       { index: 3, removed: [], addedCount: 1,
       *         object: this.items, type: 'splice'}
       *     ]);
       *
       * @param {string} path Path that should be notified.
       * @param {Array} splices Array of splice records indicating ordered
       *   changes that occurred to the array. Each record should have the
       *   following fields:
       *    * index: index at which the change occurred
       *    * removed: array of items that were removed from this index
       *    * addedCount: number of new items added at this index
       *    * object: a reference to the array in question
       *    * type: the string literal 'splice'
       *
       *   Note that splice records _must_ be normalized such that they are
       *   reported in index order (raw results from `Object.observe` are not
       *   ordered and must be normalized/merged before notifying).
       *
       * @override
       * @return {void}
       * @public
       */


      notifySplices(path, splices) {
        let info = {
          path: ''
        };
        let array =
        /** @type {Array} */
        get(this, path, info);
        notifySplices(this, array, info.path, splices);
      }
      /**
       * Convenience method for reading a value from a path.
       *
       * Note, if any part in the path is undefined, this method returns
       * `undefined` (this method does not throw when dereferencing undefined
       * paths).
       *
       * @override
       * @param {(string|!Array<(string|number)>)} path Path to the value
       *   to read.  The path may be specified as a string (e.g. `foo.bar.baz`)
       *   or an array of path parts (e.g. `['foo.bar', 'baz']`).  Note that
       *   bracketed expressions are not supported; string-based path parts
       *   *must* be separated by dots.  Note that when dereferencing array
       *   indices, the index may be used as a dotted part directly
       *   (e.g. `users.12.name` or `['users', 12, 'name']`).
       * @param {Object=} root Root object from which the path is evaluated.
       * @return {*} Value at the path, or `undefined` if any part of the path
       *   is undefined.
       * @public
       */


      get(path, root) {
        return get(root || this, path);
      }
      /**
       * Convenience method for setting a value to a path and notifying any
       * elements bound to the same path.
       *
       * Note, if any part in the path except for the last is undefined,
       * this method does nothing (this method does not throw when
       * dereferencing undefined paths).
       *
       * @override
       * @param {(string|!Array<(string|number)>)} path Path to the value
       *   to write.  The path may be specified as a string (e.g. `'foo.bar.baz'`)
       *   or an array of path parts (e.g. `['foo.bar', 'baz']`).  Note that
       *   bracketed expressions are not supported; string-based path parts
       *   *must* be separated by dots.  Note that when dereferencing array
       *   indices, the index may be used as a dotted part directly
       *   (e.g. `'users.12.name'` or `['users', 12, 'name']`).
       * @param {*} value Value to set at the specified path.
       * @param {Object=} root Root object from which the path is evaluated.
       *   When specified, no notification will occur.
       * @return {void}
       * @public
       */


      set(path, value, root) {
        if (root) {
          set(root, path, value);
        } else {
          if (!this[TYPES.READ_ONLY] || !this[TYPES.READ_ONLY][
          /** @type {string} */
          path]) {
            if (this._setPendingPropertyOrPath(path, value, true)) {
              this._invalidateProperties();
            }
          }
        }
      }
      /**
       * Adds items onto the end of the array at the path specified.
       *
       * The arguments after `path` and return value match that of
       * `Array.prototype.push`.
       *
       * This method notifies other paths to the same array that a
       * splice occurred to the array.
       *
       * @override
       * @param {string | !Array<string|number>} path Path to array.
       * @param {...*} items Items to push onto array
       * @return {number} New length of the array.
       * @public
       */


      push(path, ...items) {
        let info = {
          path: ''
        };
        let array =
        /** @type {Array}*/
        get(this, path, info);
        let len = array.length;
        let ret = array.push(...items);

        if (items.length) {
          notifySplice(this, array, info.path, len, items.length, []);
        }

        return ret;
      }
      /**
       * Removes an item from the end of array at the path specified.
       *
       * The arguments after `path` and return value match that of
       * `Array.prototype.pop`.
       *
       * This method notifies other paths to the same array that a
       * splice occurred to the array.
       *
       * @override
       * @param {string | !Array<string|number>} path Path to array.
       * @return {*} Item that was removed.
       * @public
       */


      pop(path) {
        let info = {
          path: ''
        };
        let array =
        /** @type {Array} */
        get(this, path, info);
        let hadLength = Boolean(array.length);
        let ret = array.pop();

        if (hadLength) {
          notifySplice(this, array, info.path, array.length, 0, [ret]);
        }

        return ret;
      }
      /**
       * Starting from the start index specified, removes 0 or more items
       * from the array and inserts 0 or more new items in their place.
       *
       * The arguments after `path` and return value match that of
       * `Array.prototype.splice`.
       *
       * This method notifies other paths to the same array that a
       * splice occurred to the array.
       *
       * @override
       * @param {string | !Array<string|number>} path Path to array.
       * @param {number} start Index from which to start removing/inserting.
       * @param {number=} deleteCount Number of items to remove.
       * @param {...*} items Items to insert into array.
       * @return {!Array} Array of removed items.
       * @public
       */


      splice(path, start, deleteCount, ...items) {
        let info = {
          path: ''
        };
        let array =
        /** @type {Array} */
        get(this, path, info); // Normalize fancy native splice handling of crazy start values

        if (start < 0) {
          start = array.length - Math.floor(-start);
        } else if (start) {
          start = Math.floor(start);
        } // array.splice does different things based on the number of arguments
        // you pass in. Therefore, array.splice(0) and array.splice(0, undefined)
        // do different things. In the former, the whole array is cleared. In the
        // latter, no items are removed.
        // This means that we need to detect whether 1. one of the arguments
        // is actually passed in and then 2. determine how many arguments
        // we should pass on to the native array.splice
        //


        let ret; // Omit any additional arguments if they were not passed in

        if (arguments.length === 2) {
          ret = array.splice(start); // Either start was undefined and the others were defined, but in this
          // case we can safely pass on all arguments
          //
          // Note: this includes the case where none of the arguments were passed in,
          // e.g. this.splice('array'). However, if both start and deleteCount
          // are undefined, array.splice will not modify the array (as expected)
        } else {
          ret = array.splice(start, deleteCount, ...items);
        } // At the end, check whether any items were passed in (e.g. insertions)
        // or if the return array contains items (e.g. deletions).
        // Only notify if items were added or deleted.


        if (items.length || ret.length) {
          notifySplice(this, array, info.path, start, items.length, ret);
        }

        return ret;
      }
      /**
       * Removes an item from the beginning of array at the path specified.
       *
       * The arguments after `path` and return value match that of
       * `Array.prototype.pop`.
       *
       * This method notifies other paths to the same array that a
       * splice occurred to the array.
       *
       * @override
       * @param {string | !Array<string|number>} path Path to array.
       * @return {*} Item that was removed.
       * @public
       */


      shift(path) {
        let info = {
          path: ''
        };
        let array =
        /** @type {Array} */
        get(this, path, info);
        let hadLength = Boolean(array.length);
        let ret = array.shift();

        if (hadLength) {
          notifySplice(this, array, info.path, 0, 0, [ret]);
        }

        return ret;
      }
      /**
       * Adds items onto the beginning of the array at the path specified.
       *
       * The arguments after `path` and return value match that of
       * `Array.prototype.push`.
       *
       * This method notifies other paths to the same array that a
       * splice occurred to the array.
       *
       * @override
       * @param {string | !Array<string|number>} path Path to array.
       * @param {...*} items Items to insert info array
       * @return {number} New length of the array.
       * @public
       */


      unshift(path, ...items) {
        let info = {
          path: ''
        };
        let array =
        /** @type {Array} */
        get(this, path, info);
        let ret = array.unshift(...items);

        if (items.length) {
          notifySplice(this, array, info.path, 0, items.length, []);
        }

        return ret;
      }
      /**
       * Notify that a path has changed.
       *
       * Example:
       *
       *     this.item.user.name = 'Bob';
       *     this.notifyPath('item.user.name');
       *
       * @override
       * @param {string} path Path that should be notified.
       * @param {*=} value Value at the path (optional).
       * @return {void}
       * @public
       */


      notifyPath(path, value) {
        /** @type {string} */
        let propPath;

        if (arguments.length == 1) {
          // Get value if not supplied
          let info = {
            path: ''
          };
          value = get(this, path, info);
          propPath = info.path;
        } else if (Array.isArray(path)) {
          // Normalize path if needed
          propPath = normalize(path);
        } else {
          propPath =
          /** @type{string} */
          path;
        }

        if (this._setPendingPropertyOrPath(propPath, value, true, true)) {
          this._invalidateProperties();
        }
      }
      /**
       * Equivalent to static `createReadOnlyProperty` API but can be called on
       * an instance to add effects at runtime.  See that method for
       * full API docs.
       *
       * @override
       * @param {string} property Property name
       * @param {boolean=} protectedSetter Creates a custom protected setter
       *   when `true`.
       * @return {void}
       * @protected
       */


      _createReadOnlyProperty(property, protectedSetter) {
        this._addPropertyEffect(property, TYPES.READ_ONLY);

        if (protectedSetter) {
          this['_set' + upper(property)] =
          /** @this {PropertyEffects} */
          function (value) {
            this._setProperty(property, value);
          };
        }
      }
      /**
       * Equivalent to static `createPropertyObserver` API but can be called on
       * an instance to add effects at runtime.  See that method for
       * full API docs.
       *
       * @override
       * @param {string} property Property name
       * @param {string|function(*,*)} method Function or name of observer method
       *     to call
       * @param {boolean=} dynamicFn Whether the method name should be included as
       *   a dependency to the effect.
       * @return {void}
       * @protected
       */


      _createPropertyObserver(property, method, dynamicFn) {
        let info = {
          property,
          method,
          dynamicFn: Boolean(dynamicFn)
        };

        this._addPropertyEffect(property, TYPES.OBSERVE, {
          fn: runObserverEffect,
          info,
          trigger: {
            name: property
          }
        });

        if (dynamicFn) {
          this._addPropertyEffect(
          /** @type {string} */
          method, TYPES.OBSERVE, {
            fn: runObserverEffect,
            info,
            trigger: {
              name: method
            }
          });
        }
      }
      /**
       * Equivalent to static `createMethodObserver` API but can be called on
       * an instance to add effects at runtime.  See that method for
       * full API docs.
       *
       * @override
       * @param {string} expression Method expression
       * @param {boolean|Object=} dynamicFn Boolean or object map indicating
       *   whether method names should be included as a dependency to the effect.
       * @return {void}
       * @protected
       */


      _createMethodObserver(expression, dynamicFn) {
        let sig = parseMethod(expression);

        if (!sig) {
          throw new Error("Malformed observer expression '" + expression + "'");
        }

        createMethodEffect(this, sig, TYPES.OBSERVE, runMethodEffect, null, dynamicFn);
      }
      /**
       * Equivalent to static `createNotifyingProperty` API but can be called on
       * an instance to add effects at runtime.  See that method for
       * full API docs.
       *
       * @override
       * @param {string} property Property name
       * @return {void}
       * @protected
       */


      _createNotifyingProperty(property) {
        this._addPropertyEffect(property, TYPES.NOTIFY, {
          fn: runNotifyEffect,
          info: {
            eventName: camelToDashCase(property) + '-changed',
            property: property
          }
        });
      }
      /**
       * Equivalent to static `createReflectedProperty` API but can be called on
       * an instance to add effects at runtime.  See that method for
       * full API docs.
       *
       * @override
       * @param {string} property Property name
       * @return {void}
       * @protected
       * @suppress {missingProperties} go/missingfnprops
       */


      _createReflectedProperty(property) {
        let attr = this.constructor.attributeNameForProperty(property);

        if (attr[0] === '-') {
          console.warn('Property ' + property + ' cannot be reflected to attribute ' + attr + ' because "-" is not a valid starting attribute name. Use a lowercase first letter for the property instead.');
        } else {
          this._addPropertyEffect(property, TYPES.REFLECT, {
            fn: runReflectEffect,
            info: {
              attrName: attr
            }
          });
        }
      }
      /**
       * Equivalent to static `createComputedProperty` API but can be called on
       * an instance to add effects at runtime.  See that method for
       * full API docs.
       *
       * @override
       * @param {string} property Name of computed property to set
       * @param {string} expression Method expression
       * @param {boolean|Object=} dynamicFn Boolean or object map indicating
       *   whether method names should be included as a dependency to the effect.
       * @return {void}
       * @protected
       */


      _createComputedProperty(property, expression, dynamicFn) {
        let sig = parseMethod(expression);

        if (!sig) {
          throw new Error("Malformed computed expression '" + expression + "'");
        }

        const info = createMethodEffect(this, sig, TYPES.COMPUTE, runComputedEffect, property, dynamicFn); // Effects are normally stored as map of dependency->effect, but for
        // ordered computation, we also need tree of computedProp->dependencies

        ensureOwnEffectMap(this, COMPUTE_INFO)[property] = info;
      }
      /**
       * Gather the argument values for a method specified in the provided array
       * of argument metadata.
       *
       * The `path` and `value` arguments are used to fill in wildcard descriptor
       * when the method is being called as a result of a path notification.
       *
       * @param {!Array<!MethodArg>} args Array of argument metadata
       * @param {string} path Property/path name that triggered the method effect
       * @param {Object} props Bag of current property changes
       * @return {!Array<*>} Array of argument values
       * @private
       */


      _marshalArgs(args, path, props) {
        const data = this.__data;
        const values = [];

        for (let i = 0, l = args.length; i < l; i++) {
          let {
            name,
            structured,
            wildcard,
            value,
            literal
          } = args[i];

          if (!literal) {
            if (wildcard) {
              const matches = isDescendant(name, path);
              const pathValue = getArgValue(data, props, matches ? path : name);
              value = {
                path: matches ? path : name,
                value: pathValue,
                base: matches ? get(data, name) : pathValue
              };
            } else {
              value = structured ? getArgValue(data, props, name) : data[name];
            }
          } // When the `legacyUndefined` flag is enabled, pass a no-op value
          // so that the observer, computed property, or compound binding is aborted.


          if (legacyUndefined && !this._overrideLegacyUndefined && value === undefined && args.length > 1) {
            return NOOP;
          }

          values[i] = value;
        }

        return values;
      } // -- static class methods ------------

      /**
       * Ensures an accessor exists for the specified property, and adds
       * to a list of "property effects" that will run when the accessor for
       * the specified property is set.  Effects are grouped by "type", which
       * roughly corresponds to a phase in effect processing.  The effect
       * metadata should be in the following form:
       *
       *     {
       *       fn: effectFunction, // Reference to function to call to perform effect
       *       info: { ... }       // Effect metadata passed to function
       *       trigger: {          // Optional triggering metadata; if not provided
       *         name: string      // the property is treated as a wildcard
       *         structured: boolean
       *         wildcard: boolean
       *       }
       *     }
       *
       * Effects are called from `_propertiesChanged` in the following order by
       * type:
       *
       * 1. COMPUTE
       * 2. PROPAGATE
       * 3. REFLECT
       * 4. OBSERVE
       * 5. NOTIFY
       *
       * Effect functions are called with the following signature:
       *
       *     effectFunction(inst, path, props, oldProps, info, hasPaths)
       *
       * @param {string} property Property that should trigger the effect
       * @param {string} type Effect type, from this.PROPERTY_EFFECT_TYPES
       * @param {Object=} effect Effect metadata object
       * @return {void}
       * @protected
       * @nocollapse
       */


      static addPropertyEffect(property, type, effect) {
        this.prototype._addPropertyEffect(property, type, effect);
      }
      /**
       * Creates a single-property observer for the given property.
       *
       * @param {string} property Property name
       * @param {string|function(*,*)} method Function or name of observer method to call
       * @param {boolean=} dynamicFn Whether the method name should be included as
       *   a dependency to the effect.
       * @return {void}
       * @protected
       * @nocollapse
       */


      static createPropertyObserver(property, method, dynamicFn) {
        this.prototype._createPropertyObserver(property, method, dynamicFn);
      }
      /**
       * Creates a multi-property "method observer" based on the provided
       * expression, which should be a string in the form of a normal JavaScript
       * function signature: `'methodName(arg1, [..., argn])'`.  Each argument
       * should correspond to a property or path in the context of this
       * prototype (or instance), or may be a literal string or number.
       *
       * @param {string} expression Method expression
       * @param {boolean|Object=} dynamicFn Boolean or object map indicating
       * @return {void}
       *   whether method names should be included as a dependency to the effect.
       * @protected
       * @nocollapse
       */


      static createMethodObserver(expression, dynamicFn) {
        this.prototype._createMethodObserver(expression, dynamicFn);
      }
      /**
       * Causes the setter for the given property to dispatch `<property>-changed`
       * events to notify of changes to the property.
       *
       * @param {string} property Property name
       * @return {void}
       * @protected
       * @nocollapse
       */


      static createNotifyingProperty(property) {
        this.prototype._createNotifyingProperty(property);
      }
      /**
       * Creates a read-only accessor for the given property.
       *
       * To set the property, use the protected `_setProperty` API.
       * To create a custom protected setter (e.g. `_setMyProp()` for
       * property `myProp`), pass `true` for `protectedSetter`.
       *
       * Note, if the property will have other property effects, this method
       * should be called first, before adding other effects.
       *
       * @param {string} property Property name
       * @param {boolean=} protectedSetter Creates a custom protected setter
       *   when `true`.
       * @return {void}
       * @protected
       * @nocollapse
       */


      static createReadOnlyProperty(property, protectedSetter) {
        this.prototype._createReadOnlyProperty(property, protectedSetter);
      }
      /**
       * Causes the setter for the given property to reflect the property value
       * to a (dash-cased) attribute of the same name.
       *
       * @param {string} property Property name
       * @return {void}
       * @protected
       * @nocollapse
       */


      static createReflectedProperty(property) {
        this.prototype._createReflectedProperty(property);
      }
      /**
       * Creates a computed property whose value is set to the result of the
       * method described by the given `expression` each time one or more
       * arguments to the method changes.  The expression should be a string
       * in the form of a normal JavaScript function signature:
       * `'methodName(arg1, [..., argn])'`
       *
       * @param {string} property Name of computed property to set
       * @param {string} expression Method expression
       * @param {boolean|Object=} dynamicFn Boolean or object map indicating whether
       *   method names should be included as a dependency to the effect.
       * @return {void}
       * @protected
       * @nocollapse
       */


      static createComputedProperty(property, expression, dynamicFn) {
        this.prototype._createComputedProperty(property, expression, dynamicFn);
      }
      /**
       * Parses the provided template to ensure binding effects are created
       * for them, and then ensures property accessors are created for any
       * dependent properties in the template.  Binding effects for bound
       * templates are stored in a linked list on the instance so that
       * templates can be efficiently stamped and unstamped.
       *
       * @param {!HTMLTemplateElement} template Template containing binding
       *   bindings
       * @return {!TemplateInfo} Template metadata object
       * @protected
       * @nocollapse
       */


      static bindTemplate(template) {
        return this.prototype._bindTemplate(template);
      } // -- binding ----------------------------------------------

      /*
       * Overview of binding flow:
       *
       * During finalization (`instanceBinding==false`, `wasPreBound==false`):
       *  `_bindTemplate(t, false)` called directly during finalization - parses
       *  the template (for the first time), and then assigns that _prototypical_
       *  template info to `__preboundTemplateInfo` _on the prototype_; note in
       *  this case `wasPreBound` is false; this is the first time we're binding
       *  it, thus we create accessors.
       *
       * During first stamping (`instanceBinding==true`, `wasPreBound==true`):
       *   `_stampTemplate` calls `_bindTemplate(t, true)`: the `templateInfo`
       *   returned matches the prebound one, and so this is `wasPreBound == true`
       *   state; thus we _skip_ creating accessors, but _do_ create an instance
       *   of the template info to serve as the start of our linked list (needs to
       *   be an instance, not the prototypical one, so that we can add `nodeList`
       *   to it to contain the `nodeInfo`-ordered list of instance nodes for
       *   bindings, and so we can chain runtime-stamped template infos off of
       *   it). At this point, the call to `_stampTemplate` calls
       *   `applyTemplateInfo` for each nested `<template>` found during parsing
       *   to hand prototypical `_templateInfo` to them; we also pass the _parent_
       *   `templateInfo` to the `<template>` so that we have the instance-time
       *   parent to link the `templateInfo` under in the case it was
       *   runtime-stamped.
       *
       * During subsequent runtime stamping (`instanceBinding==true`,
       *   `wasPreBound==false`): `_stampTemplate` calls `_bindTemplate(t, true)`
       *   - here `templateInfo` is guaranteed to _not_ match the prebound one,
       *   because it was either a different template altogether, or even if it
       *   was the same template, the step above created a instance of the info;
       *   in this case `wasPreBound == false`, so we _do_ create accessors, _and_
       *   link a instance into the linked list.
       */

      /**
       * Equivalent to static `bindTemplate` API but can be called on an instance
       * to add effects at runtime.  See that method for full API docs.
       *
       * This method may be called on the prototype (for prototypical template
       * binding, to avoid creating accessors every instance) once per prototype,
       * and will be called with `runtimeBinding: true` by `_stampTemplate` to
       * create and link an instance of the template metadata associated with a
       * particular stamping.
       *
       * @override
       * @param {!HTMLTemplateElement} template Template containing binding
       * bindings
       * @param {boolean=} instanceBinding When false (default), performs
       * "prototypical" binding of the template and overwrites any previously
       * bound template for the class. When true (as passed from
       * `_stampTemplate`), the template info is instanced and linked into the
       * list of bound templates.
       * @return {!TemplateInfo} Template metadata object; for `runtimeBinding`,
       * this is an instance of the prototypical template info
       * @protected
       * @suppress {missingProperties} go/missingfnprops
       */


      _bindTemplate(template, instanceBinding) {
        let templateInfo = this.constructor._parseTemplate(template);

        let wasPreBound = this.__preBoundTemplateInfo == templateInfo; // Optimization: since this is called twice for proto-bound templates,
        // don't attempt to recreate accessors if this template was pre-bound

        if (!wasPreBound) {
          for (let prop in templateInfo.propertyEffects) {
            this._createPropertyAccessor(prop);
          }
        }

        if (instanceBinding) {
          // For instance-time binding, create instance of template metadata
          // and link into tree of templates if necessary
          templateInfo =
          /** @type {!TemplateInfo} */
          Object.create(templateInfo);
          templateInfo.wasPreBound = wasPreBound;

          if (!this.__templateInfo) {
            // Set the info to the root of the tree
            this.__templateInfo = templateInfo;
          } else {
            // Append this template info onto the end of its parent template's
            // list, which will determine the tree structure via which property
            // effects are run; if this template was not nested in another
            // template, use the root template (the first stamped one) as the
            // parent. Note, `parent` is the `templateInfo` instance for this
            // template's parent (containing) template, which was set up in
            // `applyTemplateInfo`.  While a given template's `parent` is set
            // apriori, it is only added to the parent's child list at the point
            // that it is being bound, since a template may or may not ever be
            // stamped, and may be stamped more than once (in which case instances
            // of the template info will be in the tree under its parent more than
            // once).
            const parent = template._parentTemplateInfo || this.__templateInfo;
            const previous = parent.lastChild;
            templateInfo.parent = parent;
            parent.lastChild = templateInfo;
            templateInfo.previousSibling = previous;

            if (previous) {
              previous.nextSibling = templateInfo;
            } else {
              parent.firstChild = templateInfo;
            }
          }
        } else {
          this.__preBoundTemplateInfo = templateInfo;
        }

        return templateInfo;
      }
      /**
       * Adds a property effect to the given template metadata, which is run
       * at the "propagate" stage of `_propertiesChanged` when the template
       * has been bound to the element via `_bindTemplate`.
       *
       * The `effect` object should match the format in `_addPropertyEffect`.
       *
       * @param {Object} templateInfo Template metadata to add effect to
       * @param {string} prop Property that should trigger the effect
       * @param {Object=} effect Effect metadata object
       * @return {void}
       * @protected
       * @nocollapse
       */


      static _addTemplatePropertyEffect(templateInfo, prop, effect) {
        let hostProps = templateInfo.hostProps = templateInfo.hostProps || {};
        hostProps[prop] = true;
        let effects = templateInfo.propertyEffects = templateInfo.propertyEffects || {};
        let propEffects = effects[prop] = effects[prop] || [];
        propEffects.push(effect);
      }
      /**
       * Stamps the provided template and performs instance-time setup for
       * Polymer template features, including data bindings, declarative event
       * listeners, and the `this.$` map of `id`'s to nodes.  A document fragment
       * is returned containing the stamped DOM, ready for insertion into the
       * DOM.
       *
       * This method may be called more than once; however note that due to
       * `shadycss` polyfill limitations, only styles from templates prepared
       * using `ShadyCSS.prepareTemplate` will be correctly polyfilled (scoped
       * to the shadow root and support CSS custom properties), and note that
       * `ShadyCSS.prepareTemplate` may only be called once per element. As such,
       * any styles required by in runtime-stamped templates must be included
       * in the main element template.
       *
       * @param {!HTMLTemplateElement} template Template to stamp
       * @param {TemplateInfo=} templateInfo Optional bound template info associated
       *   with the template to be stamped; if omitted the template will be
       *   automatically bound.
       * @return {!StampedTemplate} Cloned template content
       * @override
       * @protected
       */


      _stampTemplate(template, templateInfo) {
        templateInfo = templateInfo ||
        /** @type {!TemplateInfo} */
        this._bindTemplate(template, true); // Ensures that created dom is `_enqueueClient`'d to this element so
        // that it can be flushed on next call to `_flushProperties`

        hostStack.push(this);

        let dom = super._stampTemplate(template, templateInfo);

        hostStack.pop(); // Add template-instance-specific data to instanced templateInfo

        templateInfo.nodeList = dom.nodeList; // Capture child nodes to allow unstamping of non-prototypical templates

        if (!templateInfo.wasPreBound) {
          let nodes = templateInfo.childNodes = [];

          for (let n = dom.firstChild; n; n = n.nextSibling) {
            nodes.push(n);
          }
        }

        dom.templateInfo = templateInfo; // Setup compound storage, 2-way listeners, and dataHost for bindings

        setupBindings(this, templateInfo); // Flush properties into template nodes; the check on `__dataClientsReady`
        // ensures we don't needlessly run effects for an element's initial
        // prototypical template stamping since they will happen as a part of the
        // first call to `_propertiesChanged`. This flag is set to true
        // after running the initial propagate effects, and immediately before
        // flushing clients. Since downstream clients could cause stamping on
        // this host (e.g. a fastDomIf `dom-if` being forced to render
        // synchronously), this flag ensures effects for runtime-stamped templates
        // are run at this point during the initial element boot-up.

        if (this.__dataClientsReady) {
          this._runEffectsForTemplate(templateInfo, this.__data, null, false);

          this._flushClients();
        }

        return dom;
      }
      /**
       * Removes and unbinds the nodes previously contained in the provided
       * DocumentFragment returned from `_stampTemplate`.
       *
       * @override
       * @param {!StampedTemplate} dom DocumentFragment previously returned
       *   from `_stampTemplate` associated with the nodes to be removed
       * @return {void}
       * @protected
       */


      _removeBoundDom(dom) {
        // Unlink template info; Note that while the child is unlinked from its
        // parent list, a template's `parent` reference is never removed, since
        // this is is determined by the tree structure and applied at
        // `applyTemplateInfo` time.
        const templateInfo = dom.templateInfo;
        const {
          previousSibling,
          nextSibling,
          parent
        } = templateInfo;

        if (previousSibling) {
          previousSibling.nextSibling = nextSibling;
        } else if (parent) {
          parent.firstChild = nextSibling;
        }

        if (nextSibling) {
          nextSibling.previousSibling = previousSibling;
        } else if (parent) {
          parent.lastChild = previousSibling;
        }

        templateInfo.nextSibling = templateInfo.previousSibling = null; // Remove stamped nodes

        let nodes = templateInfo.childNodes;

        for (let i = 0; i < nodes.length; i++) {
          let node = nodes[i];
          wrap$1(wrap$1(node).parentNode).removeChild(node);
        }
      }
      /**
       * Overrides default `TemplateStamp` implementation to add support for
       * parsing bindings from `TextNode`'s' `textContent`.  A `bindings`
       * array is added to `nodeInfo` and populated with binding metadata
       * with information capturing the binding target, and a `parts` array
       * with one or more metadata objects capturing the source(s) of the
       * binding.
       *
       * @param {Node} node Node to parse
       * @param {TemplateInfo} templateInfo Template metadata for current template
       * @param {NodeInfo} nodeInfo Node metadata for current template node
       * @return {boolean} `true` if the visited node added node-specific
       *   metadata to `nodeInfo`
       * @protected
       * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
       * @nocollapse
       */


      static _parseTemplateNode(node, templateInfo, nodeInfo) {
        // TODO(https://github.com/google/closure-compiler/issues/3240):
        //     Change back to just super.methodCall()
        let noted = propertyEffectsBase._parseTemplateNode.call(this, node, templateInfo, nodeInfo);

        if (node.nodeType === Node.TEXT_NODE) {
          let parts = this._parseBindings(node.textContent, templateInfo);

          if (parts) {
            // Initialize the textContent with any literal parts
            // NOTE: default to a space here so the textNode remains; some browsers
            // (IE) omit an empty textNode following cloneNode/importNode.
            node.textContent = literalFromParts(parts) || ' ';
            addBinding(this, templateInfo, nodeInfo, 'text', 'textContent', parts);
            noted = true;
          }
        }

        return noted;
      }
      /**
       * Overrides default `TemplateStamp` implementation to add support for
       * parsing bindings from attributes.  A `bindings`
       * array is added to `nodeInfo` and populated with binding metadata
       * with information capturing the binding target, and a `parts` array
       * with one or more metadata objects capturing the source(s) of the
       * binding.
       *
       * @param {Element} node Node to parse
       * @param {TemplateInfo} templateInfo Template metadata for current template
       * @param {NodeInfo} nodeInfo Node metadata for current template node
       * @param {string} name Attribute name
       * @param {string} value Attribute value
       * @return {boolean} `true` if the visited node added node-specific
       *   metadata to `nodeInfo`
       * @protected
       * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
       * @nocollapse
       */


      static _parseTemplateNodeAttribute(node, templateInfo, nodeInfo, name, value) {
        let parts = this._parseBindings(value, templateInfo);

        if (parts) {
          // Attribute or property
          let origName = name;
          let kind = 'property'; // The only way we see a capital letter here is if the attr has
          // a capital letter in it per spec. In this case, to make sure
          // this binding works, we go ahead and make the binding to the attribute.

          if (capitalAttributeRegex.test(name)) {
            kind = 'attribute';
          } else if (name[name.length - 1] == '$') {
            name = name.slice(0, -1);
            kind = 'attribute';
          } // Initialize attribute bindings with any literal parts


          let literal = literalFromParts(parts);

          if (literal && kind == 'attribute') {
            // Ensure a ShadyCSS template scoped style is not removed
            // when a class$ binding's initial literal value is set.
            if (name == 'class' && node.hasAttribute('class')) {
              literal += ' ' + node.getAttribute(name);
            }

            node.setAttribute(name, literal);
          } // support disable-upgrade


          if (kind == 'attribute' && origName == 'disable-upgrade$') {
            node.setAttribute(name, '');
          } // Clear attribute before removing, since IE won't allow removing
          // `value` attribute if it previously had a value (can't
          // unconditionally set '' before removing since attributes with `$`
          // can't be set using setAttribute)


          if (node.localName === 'input' && origName === 'value') {
            node.setAttribute(origName, '');
          } // Remove annotation


          node.removeAttribute(origName); // Case hackery: attributes are lower-case, but bind targets
          // (properties) are case sensitive. Gambit is to map dash-case to
          // camel-case: `foo-bar` becomes `fooBar`.
          // Attribute bindings are excepted.

          if (kind === 'property') {
            name = dashToCamelCase(name);
          }

          addBinding(this, templateInfo, nodeInfo, kind, name, parts, literal);
          return true;
        } else {
          // TODO(https://github.com/google/closure-compiler/issues/3240):
          //     Change back to just super.methodCall()
          return propertyEffectsBase._parseTemplateNodeAttribute.call(this, node, templateInfo, nodeInfo, name, value);
        }
      }
      /**
       * Overrides default `TemplateStamp` implementation to add support for
       * binding the properties that a nested template depends on to the template
       * as `_host_<property>`.
       *
       * @param {Node} node Node to parse
       * @param {TemplateInfo} templateInfo Template metadata for current template
       * @param {NodeInfo} nodeInfo Node metadata for current template node
       * @return {boolean} `true` if the visited node added node-specific
       *   metadata to `nodeInfo`
       * @protected
       * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
       * @nocollapse
       */


      static _parseTemplateNestedTemplate(node, templateInfo, nodeInfo) {
        // TODO(https://github.com/google/closure-compiler/issues/3240):
        //     Change back to just super.methodCall()
        let noted = propertyEffectsBase._parseTemplateNestedTemplate.call(this, node, templateInfo, nodeInfo);

        const parent = node.parentNode;
        const nestedTemplateInfo = nodeInfo.templateInfo;
        const isDomIf = parent.localName === 'dom-if';
        const isDomRepeat = parent.localName === 'dom-repeat'; // Remove nested template and redirect its host bindings & templateInfo
        // onto the parent (dom-if/repeat element)'s nodeInfo

        if (removeNestedTemplates && (isDomIf || isDomRepeat)) {
          parent.removeChild(node); // Use the parent's nodeInfo (for the dom-if/repeat) to record the
          // templateInfo, and use that for any host property bindings below

          nodeInfo = nodeInfo.parentInfo;
          nodeInfo.templateInfo = nestedTemplateInfo; // Ensure the parent dom-if/repeat is noted since it now may have host
          // bindings; it may not have been if it did not have its own bindings

          nodeInfo.noted = true;
          noted = false;
        } // Merge host props into outer template and add bindings


        let hostProps = nestedTemplateInfo.hostProps;

        if (fastDomIf && isDomIf) {
          // `fastDomIf` mode uses runtime-template stamping to add accessors/
          // effects to properties used in its template; as such we don't need to
          // tax the host element with `_host_` bindings for the `dom-if`.
          // However, in the event it is nested in a `dom-repeat`, it is still
          // important that its host properties are added to the
          // TemplateInstance's `hostProps` so that they are forwarded to the
          // TemplateInstance.
          if (hostProps) {
            templateInfo.hostProps = Object.assign(templateInfo.hostProps || {}, hostProps); // Ensure the dom-if is noted so that it has a __dataHost, since
            // `fastDomIf` uses the host for runtime template stamping; note this
            // was already ensured above in the `removeNestedTemplates` case

            if (!removeNestedTemplates) {
              nodeInfo.parentInfo.noted = true;
            }
          }
        } else {
          let mode = '{';

          for (let source in hostProps) {
            let parts = [{
              mode,
              source,
              dependencies: [source],
              hostProp: true
            }];
            addBinding(this, templateInfo, nodeInfo, 'property', '_host_' + source, parts);
          }
        }

        return noted;
      }
      /**
       * Called to parse text in a template (either attribute values or
       * textContent) into binding metadata.
       *
       * Any overrides of this method should return an array of binding part
       * metadata  representing one or more bindings found in the provided text
       * and any "literal" text in between.  Any non-literal parts will be passed
       * to `_evaluateBinding` when any dependencies change.  The only required
       * fields of each "part" in the returned array are as follows:
       *
       * - `dependencies` - Array containing trigger metadata for each property
       *   that should trigger the binding to update
       * - `literal` - String containing text if the part represents a literal;
       *   in this case no `dependencies` are needed
       *
       * Additional metadata for use by `_evaluateBinding` may be provided in
       * each part object as needed.
       *
       * The default implementation handles the following types of bindings
       * (one or more may be intermixed with literal strings):
       * - Property binding: `[[prop]]`
       * - Path binding: `[[object.prop]]`
       * - Negated property or path bindings: `[[!prop]]` or `[[!object.prop]]`
       * - Two-way property or path bindings (supports negation):
       *   `{{prop}}`, `{{object.prop}}`, `{{!prop}}` or `{{!object.prop}}`
       * - Inline computed method (supports negation):
       *   `[[compute(a, 'literal', b)]]`, `[[!compute(a, 'literal', b)]]`
       *
       * The default implementation uses a regular expression for best
       * performance. However, the regular expression uses a white-list of
       * allowed characters in a data-binding, which causes problems for
       * data-bindings that do use characters not in this white-list.
       *
       * Instead of updating the white-list with all allowed characters,
       * there is a StrictBindingParser (see lib/mixins/strict-binding-parser)
       * that uses a state machine instead. This state machine is able to handle
       * all characters. However, it is slightly less performant, therefore we
       * extracted it into a separate optional mixin.
       *
       * @param {string} text Text to parse from attribute or textContent
       * @param {Object} templateInfo Current template metadata
       * @return {Array<!BindingPart>} Array of binding part metadata
       * @protected
       * @nocollapse
       */


      static _parseBindings(text, templateInfo) {
        let parts = [];
        let lastIndex = 0;
        let m; // Example: "literal1{{prop}}literal2[[!compute(foo,bar)]]final"
        // Regex matches:
        //        Iteration 1:  Iteration 2:
        // m[1]: '{{'          '[['
        // m[2]: ''            '!'
        // m[3]: 'prop'        'compute(foo,bar)'

        while ((m = bindingRegex.exec(text)) !== null) {
          // Add literal part
          if (m.index > lastIndex) {
            parts.push({
              literal: text.slice(lastIndex, m.index)
            });
          } // Add binding part


          let mode = m[1][0];
          let negate = Boolean(m[2]);
          let source = m[3].trim();
          let customEvent = false,
              notifyEvent = '',
              colon = -1;

          if (mode == '{' && (colon = source.indexOf('::')) > 0) {
            notifyEvent = source.substring(colon + 2);
            source = source.substring(0, colon);
            customEvent = true;
          }

          let signature = parseMethod(source);
          let dependencies = [];

          if (signature) {
            // Inline computed function
            let {
              args,
              methodName
            } = signature;

            for (let i = 0; i < args.length; i++) {
              let arg = args[i];

              if (!arg.literal) {
                dependencies.push(arg);
              }
            }

            let dynamicFns = templateInfo.dynamicFns;

            if (dynamicFns && dynamicFns[methodName] || signature.static) {
              dependencies.push(methodName);
              signature.dynamicFn = true;
            }
          } else {
            // Property or path
            dependencies.push(source);
          }

          parts.push({
            source,
            mode,
            negate,
            customEvent,
            signature,
            dependencies,
            event: notifyEvent
          });
          lastIndex = bindingRegex.lastIndex;
        } // Add a final literal part


        if (lastIndex && lastIndex < text.length) {
          let literal = text.substring(lastIndex);

          if (literal) {
            parts.push({
              literal: literal
            });
          }
        }

        if (parts.length) {
          return parts;
        } else {
          return null;
        }
      }
      /**
       * Called to evaluate a previously parsed binding part based on a set of
       * one or more changed dependencies.
       *
       * @param {!Polymer_PropertyEffects} inst Element that should be used as
       *     scope for binding dependencies
       * @param {BindingPart} part Binding part metadata
       * @param {string} path Property/path that triggered this effect
       * @param {Object} props Bag of current property changes
       * @param {Object} oldProps Bag of previous values for changed properties
       * @param {boolean} hasPaths True with `props` contains one or more paths
       * @return {*} Value the binding part evaluated to
       * @protected
       * @nocollapse
       */


      static _evaluateBinding(inst, part, path, props, oldProps, hasPaths) {
        let value;

        if (part.signature) {
          value = runMethodEffect(inst, path, props, oldProps, part.signature);
        } else if (path != part.source) {
          value = get(inst, part.source);
        } else {
          if (hasPaths && isPath(path)) {
            value = get(inst, path);
          } else {
            value = inst.__data[path];
          }
        }

        if (part.negate) {
          value = !value;
        }

        return value;
      }

    }

    return PropertyEffects;
  });
  /**
   * Stack for enqueuing client dom created by a host element.
   *
   * By default elements are flushed via `_flushProperties` when
   * `connectedCallback` is called. Elements attach their client dom to
   * themselves at `ready` time which results from this first flush.
   * This provides an ordering guarantee that the client dom an element
   * creates is flushed before the element itself (i.e. client `ready`
   * fires before host `ready`).
   *
   * However, if `_flushProperties` is called *before* an element is connected,
   * as for example `Templatize` does, this ordering guarantee cannot be
   * satisfied because no elements are connected. (Note: Bound elements that
   * receive data do become enqueued clients and are properly ordered but
   * unbound elements are not.)
   *
   * To maintain the desired "client before host" ordering guarantee for this
   * case we rely on the "host stack. Client nodes registers themselves with
   * the creating host element when created. This ensures that all client dom
   * is readied in the proper order, maintaining the desired guarantee.
   *
   * @private
   */

  const hostStack = [];

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * Registers a class prototype for telemetry purposes.
   * @param {!PolymerElementConstructor} prototype Element prototype to register
   * @protected
   */


  function register(prototype) {
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * Creates a copy of `props` with each property normalized such that
   * upgraded it is an object with at least a type property { type: Type}.
   *
   * @param {!Object} props Properties to normalize
   * @return {!Object} Copy of input `props` with normalized properties that
   * are in the form {type: Type}
   * @private
   */

  function normalizeProperties(props) {
    const output = {};

    for (let p in props) {
      const o = props[p];
      output[p] = typeof o === 'function' ? {
        type: o
      } : o;
    }

    return output;
  }
  /**
   * Mixin that provides a minimal starting point to using the PropertiesChanged
   * mixin by providing a mechanism to declare properties in a static
   * getter (e.g. static get properties() { return { foo: String } }). Changes
   * are reported via the `_propertiesChanged` method.
   *
   * This mixin provides no specific support for rendering. Users are expected
   * to create a ShadowRoot and put content into it and update it in whatever
   * way makes sense. This can be done in reaction to properties changing by
   * implementing `_propertiesChanged`.
   *
   * @mixinFunction
   * @polymer
   * @appliesMixin PropertiesChanged
   * @summary Mixin that provides a minimal starting point for using
   * the PropertiesChanged mixin by providing a declarative `properties` object.
   * @template T
   * @param {function(new:T)} superClass Class to apply mixin to.
   * @return {function(new:T)} superClass with mixin applied.
   */


  const PropertiesMixin = dedupingMixin(superClass => {
    /**
     * @constructor
     * @implements {Polymer_PropertiesChanged}
     * @private
     */
    const base = PropertiesChanged(superClass);
    /**
     * Returns the super class constructor for the given class, if it is an
     * instance of the PropertiesMixin.
     *
     * @param {!PropertiesMixinConstructor} constructor PropertiesMixin constructor
     * @return {?PropertiesMixinConstructor} Super class constructor
     */

    function superPropertiesClass(constructor) {
      const superCtor = Object.getPrototypeOf(constructor); // Note, the `PropertiesMixin` class below only refers to the class
      // generated by this call to the mixin; the instanceof test only works
      // because the mixin is deduped and guaranteed only to apply once, hence
      // all constructors in a proto chain will see the same `PropertiesMixin`

      return superCtor.prototype instanceof PropertiesMixin ?
      /** @type {!PropertiesMixinConstructor} */
      superCtor : null;
    }
    /**
     * Returns a memoized version of the `properties` object for the
     * given class. Properties not in object format are converted to at
     * least {type}.
     *
     * @param {PropertiesMixinConstructor} constructor PropertiesMixin constructor
     * @return {Object} Memoized properties object
     */


    function ownProperties(constructor) {
      if (!constructor.hasOwnProperty(JSCompiler_renameProperty('__ownProperties', constructor))) {
        let props = null;

        if (constructor.hasOwnProperty(JSCompiler_renameProperty('properties', constructor))) {
          const properties = constructor.properties;

          if (properties) {
            props = normalizeProperties(properties);
          }
        }

        constructor.__ownProperties = props;
      }

      return constructor.__ownProperties;
    }
    /**
     * @polymer
     * @mixinClass
     * @extends {base}
     * @implements {Polymer_PropertiesMixin}
     * @unrestricted
     */


    class PropertiesMixin extends base {
      /**
       * Implements standard custom elements getter to observes the attributes
       * listed in `properties`.
       * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
       * @nocollapse
       */
      static get observedAttributes() {
        if (!this.hasOwnProperty(JSCompiler_renameProperty('__observedAttributes', this))) {
          register(this.prototype);
          const props = this._properties;
          this.__observedAttributes = props ? Object.keys(props).map(p => this.prototype._addPropertyToAttributeMap(p)) : [];
        }

        return this.__observedAttributes;
      }
      /**
       * Finalizes an element definition, including ensuring any super classes
       * are also finalized. This includes ensuring property
       * accessors exist on the element prototype. This method calls
       * `_finalizeClass` to finalize each constructor in the prototype chain.
       * @return {void}
       * @nocollapse
       */


      static finalize() {
        if (!this.hasOwnProperty(JSCompiler_renameProperty('__finalized', this))) {
          const superCtor = superPropertiesClass(
          /** @type {!PropertiesMixinConstructor} */
          this);

          if (superCtor) {
            superCtor.finalize();
          }

          this.__finalized = true;

          this._finalizeClass();
        }
      }
      /**
       * Finalize an element class. This includes ensuring property
       * accessors exist on the element prototype. This method is called by
       * `finalize` and finalizes the class constructor.
       *
       * @protected
       * @nocollapse
       */


      static _finalizeClass() {
        const props = ownProperties(
        /** @type {!PropertiesMixinConstructor} */
        this);

        if (props) {
          /** @type {?} */
          this.createProperties(props);
        }
      }
      /**
       * Returns a memoized version of all properties, including those inherited
       * from super classes. Properties not in object format are converted to
       * at least {type}.
       *
       * @return {Object} Object containing properties for this class
       * @protected
       * @nocollapse
       */


      static get _properties() {
        if (!this.hasOwnProperty(JSCompiler_renameProperty('__properties', this))) {
          const superCtor = superPropertiesClass(
          /** @type {!PropertiesMixinConstructor} */
          this);
          this.__properties = Object.assign({}, superCtor && superCtor._properties, ownProperties(
          /** @type {PropertiesMixinConstructor} */
          this));
        }

        return this.__properties;
      }
      /**
       * Overrides `PropertiesChanged` method to return type specified in the
       * static `properties` object for the given property.
       * @param {string} name Name of property
       * @return {*} Type to which to deserialize attribute
       *
       * @protected
       * @nocollapse
       */


      static typeForProperty(name) {
        const info = this._properties[name];
        return info && info.type;
      }
      /**
       * Overrides `PropertiesChanged` method and adds a call to
       * `finalize` which lazily configures the element's property accessors.
       * @override
       * @return {void}
       */


      _initializeProperties() {
        this.constructor.finalize();

        super._initializeProperties();
      }
      /**
       * Called when the element is added to a document.
       * Calls `_enableProperties` to turn on property system from
       * `PropertiesChanged`.
       * @suppress {missingProperties} Super may or may not implement the callback
       * @return {void}
       * @override
       */


      connectedCallback() {
        if (super.connectedCallback) {
          super.connectedCallback();
        }

        this._enableProperties();
      }
      /**
       * Called when the element is removed from a document
       * @suppress {missingProperties} Super may or may not implement the callback
       * @return {void}
       * @override
       */


      disconnectedCallback() {
        if (super.disconnectedCallback) {
          super.disconnectedCallback();
        }
      }

    }

    return PropertiesMixin;
  });

  /**
   * @fileoverview
   * @suppress {checkPrototypalTypes}
   * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
   * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
   * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
   * Google as part of the polymer project is also subject to an additional IP
   * rights grant found at http://polymer.github.io/PATENTS.txt
   */
  /**
   * Current Polymer version in Semver notation.
   * @type {string} Semver notation of the current version of Polymer.
   */

  const version = '3.4.1';
  const builtCSS = window.ShadyCSS && window.ShadyCSS['cssBuild'];
  /**
   * Element class mixin that provides the core API for Polymer's meta-programming
   * features including template stamping, data-binding, attribute deserialization,
   * and property change observation.
   *
   * Subclassers may provide the following static getters to return metadata
   * used to configure Polymer's features for the class:
   *
   * - `static get is()`: When the template is provided via a `dom-module`,
   *   users should return the `dom-module` id from a static `is` getter.  If
   *   no template is needed or the template is provided directly via the
   *   `template` getter, there is no need to define `is` for the element.
   *
   * - `static get template()`: Users may provide the template directly (as
   *   opposed to via `dom-module`) by implementing a static `template` getter.
   *   The getter must return an `HTMLTemplateElement`.
   *
   * - `static get properties()`: Should return an object describing
   *   property-related metadata used by Polymer features (key: property name
   *   value: object containing property metadata). Valid keys in per-property
   *   metadata include:
   *   - `type` (String|Number|Object|Array|...): Used by
   *     `attributeChangedCallback` to determine how string-based attributes
   *     are deserialized to JavaScript property values.
   *   - `notify` (boolean): Causes a change in the property to fire a
   *     non-bubbling event called `<property>-changed`. Elements that have
   *     enabled two-way binding to the property use this event to observe changes.
   *   - `readOnly` (boolean): Creates a getter for the property, but no setter.
   *     To set a read-only property, use the private setter method
   *     `_setProperty(property, value)`.
   *   - `observer` (string): Observer method name that will be called when
   *     the property changes. The arguments of the method are
   *     `(value, previousValue)`.
   *   - `computed` (string): String describing method and dependent properties
   *     for computing the value of this property (e.g. `'computeFoo(bar, zot)'`).
   *     Computed properties are read-only by default and can only be changed
   *     via the return value of the computing method.
   *
   * - `static get observers()`: Array of strings describing multi-property
   *   observer methods and their dependent properties (e.g.
   *   `'observeABC(a, b, c)'`).
   *
   * The base class provides default implementations for the following standard
   * custom element lifecycle callbacks; users may override these, but should
   * call the super method to ensure
   * - `constructor`: Run when the element is created or upgraded
   * - `connectedCallback`: Run each time the element is connected to the
   *   document
   * - `disconnectedCallback`: Run each time the element is disconnected from
   *   the document
   * - `attributeChangedCallback`: Run each time an attribute in
   *   `observedAttributes` is set or removed (note: this element's default
   *   `observedAttributes` implementation will automatically return an array
   *   of dash-cased attributes based on `properties`)
   *
   * @mixinFunction
   * @polymer
   * @appliesMixin PropertyEffects
   * @appliesMixin PropertiesMixin
   * @property rootPath {string} Set to the value of `rootPath`,
   *   which defaults to the main document path
   * @property importPath {string} Set to the value of the class's static
   *   `importPath` property, which defaults to the path of this element's
   *   `dom-module` (when `is` is used), but can be overridden for other
   *   import strategies.
   * @summary Element class mixin that provides the core API for Polymer's
   * meta-programming features.
   * @template T
   * @param {function(new:T)} superClass Class to apply mixin to.
   * @return {function(new:T)} superClass with mixin applied.
   */

  const ElementMixin = dedupingMixin(base => {
    /**
     * @constructor
     * @implements {Polymer_PropertyEffects}
     * @implements {Polymer_PropertiesMixin}
     * @extends {HTMLElement}
     * @private
     */
    const polymerElementBase = PropertiesMixin(PropertyEffects(base));
    /**
     * Returns a list of properties with default values.
     * This list is created as an optimization since it is a subset of
     * the list returned from `_properties`.
     * This list is used in `_initializeProperties` to set property defaults.
     *
     * @param {PolymerElementConstructor} constructor Element class
     * @return {PolymerElementProperties} Flattened properties for this class
     *   that have default values
     * @private
     */

    function propertyDefaults(constructor) {
      if (!constructor.hasOwnProperty(JSCompiler_renameProperty('__propertyDefaults', constructor))) {
        constructor.__propertyDefaults = null;
        let props = constructor._properties;

        for (let p in props) {
          let info = props[p];

          if ('value' in info) {
            constructor.__propertyDefaults = constructor.__propertyDefaults || {};
            constructor.__propertyDefaults[p] = info;
          }
        }
      }

      return constructor.__propertyDefaults;
    }
    /**
     * Returns a memoized version of the `observers` array.
     * @param {PolymerElementConstructor} constructor Element class
     * @return {Array} Array containing own observers for the given class
     * @protected
     */


    function ownObservers(constructor) {
      if (!constructor.hasOwnProperty(JSCompiler_renameProperty('__ownObservers', constructor))) {
        constructor.__ownObservers = constructor.hasOwnProperty(JSCompiler_renameProperty('observers', constructor)) ?
        /** @type {PolymerElementConstructor} */
        constructor.observers : null;
      }

      return constructor.__ownObservers;
    }
    /**
     * Creates effects for a property.
     *
     * Note, once a property has been set to
     * `readOnly`, `computed`, `reflectToAttribute`, or `notify`
     * these values may not be changed. For example, a subclass cannot
     * alter these settings. However, additional `observers` may be added
     * by subclasses.
     *
     * The info object should contain property metadata as follows:
     *
     * * `type`: {function} type to which an attribute matching the property
     * is deserialized. Note the property is camel-cased from a dash-cased
     * attribute. For example, 'foo-bar' attribute is deserialized to a
     * property named 'fooBar'.
     *
     * * `readOnly`: {boolean} creates a readOnly property and
     * makes a private setter for the private of the form '_setFoo' for a
     * property 'foo',
     *
     * * `computed`: {string} creates a computed property. A computed property
     * is also automatically set to `readOnly: true`. The value is calculated
     * by running a method and arguments parsed from the given string. For
     * example 'compute(foo)' will compute a given property when the
     * 'foo' property changes by executing the 'compute' method. This method
     * must return the computed value.
     *
     * * `reflectToAttribute`: {boolean} If true, the property value is reflected
     * to an attribute of the same name. Note, the attribute is dash-cased
     * so a property named 'fooBar' is reflected as 'foo-bar'.
     *
     * * `notify`: {boolean} sends a non-bubbling notification event when
     * the property changes. For example, a property named 'foo' sends an
     * event named 'foo-changed' with `event.detail` set to the value of
     * the property.
     *
     * * observer: {string} name of a method that runs when the property
     * changes. The arguments of the method are (value, previousValue).
     *
     * Note: Users may want control over modifying property
     * effects via subclassing. For example, a user might want to make a
     * reflectToAttribute property not do so in a subclass. We've chosen to
     * disable this because it leads to additional complication.
     * For example, a readOnly effect generates a special setter. If a subclass
     * disables the effect, the setter would fail unexpectedly.
     * Based on feedback, we may want to try to make effects more malleable
     * and/or provide an advanced api for manipulating them.
     *
     * @param {!PolymerElement} proto Element class prototype to add accessors
     *   and effects to
     * @param {string} name Name of the property.
     * @param {Object} info Info object from which to create property effects.
     * Supported keys:
     * @param {Object} allProps Flattened map of all properties defined in this
     *   element (including inherited properties)
     * @return {void}
     * @private
     */


    function createPropertyFromConfig(proto, name, info, allProps) {
      // computed forces readOnly...
      if (info.computed) {
        info.readOnly = true;
      } // Note, since all computed properties are readOnly, this prevents
      // adding additional computed property effects (which leads to a confusing
      // setup where multiple triggers for setting a property)
      // While we do have `hasComputedEffect` this is set on the property's
      // dependencies rather than itself.


      if (info.computed) {
        if (proto._hasReadOnlyEffect(name)) {
          console.warn(`Cannot redefine computed property '${name}'.`);
        } else {
          proto._createComputedProperty(name, info.computed, allProps);
        }
      }

      if (info.readOnly && !proto._hasReadOnlyEffect(name)) {
        proto._createReadOnlyProperty(name, !info.computed);
      } else if (info.readOnly === false && proto._hasReadOnlyEffect(name)) {
        console.warn(`Cannot make readOnly property '${name}' non-readOnly.`);
      }

      if (info.reflectToAttribute && !proto._hasReflectEffect(name)) {
        proto._createReflectedProperty(name);
      } else if (info.reflectToAttribute === false && proto._hasReflectEffect(name)) {
        console.warn(`Cannot make reflected property '${name}' non-reflected.`);
      }

      if (info.notify && !proto._hasNotifyEffect(name)) {
        proto._createNotifyingProperty(name);
      } else if (info.notify === false && proto._hasNotifyEffect(name)) {
        console.warn(`Cannot make notify property '${name}' non-notify.`);
      } // always add observer


      if (info.observer) {
        proto._createPropertyObserver(name, info.observer, allProps[info.observer]);
      } // always create the mapping from attribute back to property for deserialization.


      proto._addPropertyToAttributeMap(name);
    }
    /**
     * Process all style elements in the element template. Styles with the
     * `include` attribute are processed such that any styles in
     * the associated "style modules" are included in the element template.
     * @param {PolymerElementConstructor} klass Element class
     * @param {!HTMLTemplateElement} template Template to process
     * @param {string} is Name of element
     * @param {string} baseURI Base URI for element
     * @private
     */


    function processElementStyles(klass, template, is, baseURI) {
      if (!builtCSS) {
        const templateStyles = template.content.querySelectorAll('style');
        const stylesWithImports = stylesFromTemplate(template); // insert styles from <link rel="import" type="css"> at the top of the template

        const linkedStyles = stylesFromModuleImports(is);
        const firstTemplateChild = template.content.firstElementChild;

        for (let idx = 0; idx < linkedStyles.length; idx++) {
          let s = linkedStyles[idx];
          s.textContent = klass._processStyleText(s.textContent, baseURI);
          template.content.insertBefore(s, firstTemplateChild);
        } // keep track of the last "concrete" style in the template we have encountered


        let templateStyleIndex = 0; // ensure all gathered styles are actually in this template.

        for (let i = 0; i < stylesWithImports.length; i++) {
          let s = stylesWithImports[i];
          let templateStyle = templateStyles[templateStyleIndex]; // if the style is not in this template, it's been "included" and
          // we put a clone of it in the template before the style that included it

          if (templateStyle !== s) {
            s = s.cloneNode(true);
            templateStyle.parentNode.insertBefore(s, templateStyle);
          } else {
            templateStyleIndex++;
          }

          s.textContent = klass._processStyleText(s.textContent, baseURI);
        }
      }

      if (window.ShadyCSS) {
        window.ShadyCSS.prepareTemplate(template, is);
      } // Support for `adoptedStylesheets` relies on using native Shadow DOM
      // and built CSS. Built CSS is required because runtime transformation of
      // `@apply` is not supported. This is because ShadyCSS relies on being able
      // to update a `style` element in the element template and this is
      // removed when using `adoptedStyleSheets`.
      // Note, it would be more efficient to allow style includes to become
      // separate stylesheets; however, because of `@apply` these are
      // potentially not shareable and sharing the ones that could be shared
      // would require some coordination. To keep it simple, all the includes
      // and styles are collapsed into a single shareable stylesheet.


      if (useAdoptedStyleSheetsWithBuiltCSS && builtCSS && supportsAdoptingStyleSheets$1) {
        // Remove styles in template and make a shareable stylesheet
        const styles = template.content.querySelectorAll('style');

        if (styles) {
          let css = '';
          Array.from(styles).forEach(s => {
            css += s.textContent;
            s.parentNode.removeChild(s);
          });
          klass._styleSheet = new CSSStyleSheet();

          klass._styleSheet.replaceSync(css);
        }
      }
    }
    /**
     * Look up template from dom-module for element
     *
     * @param {string} is Element name to look up
     * @return {?HTMLTemplateElement|undefined} Template found in dom module, or
     *   undefined if not found
     * @protected
     */


    function getTemplateFromDomModule(is) {
      let template = null; // Under strictTemplatePolicy in 3.x+, dom-module lookup is only allowed
      // when opted-in via allowTemplateFromDomModule

      if (is && (!strictTemplatePolicy || allowTemplateFromDomModule)) {
        template =
        /** @type {?HTMLTemplateElement} */
        DomModule.import(is, 'template'); // Under strictTemplatePolicy, require any element with an `is`
        // specified to have a dom-module

        if (strictTemplatePolicy && !template) {
          throw new Error(`strictTemplatePolicy: expecting dom-module or null template for ${is}`);
        }
      }

      return template;
    }
    /**
     * @polymer
     * @mixinClass
     * @unrestricted
     * @implements {Polymer_ElementMixin}
     * @extends {polymerElementBase}
     */


    class PolymerElement extends polymerElementBase {
      /**
       * Current Polymer version in Semver notation.
       * @type {string} Semver notation of the current version of Polymer.
       * @nocollapse
       */
      static get polymerElementVersion() {
        return version;
      }
      /**
       * Override of PropertiesMixin _finalizeClass to create observers and
       * find the template.
       * @return {void}
       * @protected
       * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
       * @nocollapse
       */


      static _finalizeClass() {
        // TODO(https://github.com/google/closure-compiler/issues/3240):
        //     Change back to just super.methodCall()
        polymerElementBase._finalizeClass.call(this);

        const observers = ownObservers(this);

        if (observers) {
          this.createObservers(observers, this._properties);
        }

        this._prepareTemplate();
      }
      /** @nocollapse */


      static _prepareTemplate() {
        // note: create "working" template that is finalized at instance time
        let template =
        /** @type {PolymerElementConstructor} */
        this.template;

        if (template) {
          if (typeof template === 'string') {
            console.error('template getter must return HTMLTemplateElement');
            template = null;
          } else if (!legacyOptimizations) {
            template = template.cloneNode(true);
          }
        }
        /** @override */


        this.prototype._template = template;
      }
      /**
       * Override of PropertiesChanged createProperties to create accessors
       * and property effects for all of the properties.
       * @param {!Object} props .
       * @return {void}
       * @protected
       * @nocollapse
       */


      static createProperties(props) {
        for (let p in props) {
          createPropertyFromConfig(
          /** @type {?} */
          this.prototype, p, props[p], props);
        }
      }
      /**
       * Creates observers for the given `observers` array.
       * Leverages `PropertyEffects` to create observers.
       * @param {Object} observers Array of observer descriptors for
       *   this class
       * @param {Object} dynamicFns Object containing keys for any properties
       *   that are functions and should trigger the effect when the function
       *   reference is changed
       * @return {void}
       * @protected
       * @nocollapse
       */


      static createObservers(observers, dynamicFns) {
        const proto = this.prototype;

        for (let i = 0; i < observers.length; i++) {
          proto._createMethodObserver(observers[i], dynamicFns);
        }
      }
      /**
       * Returns the template that will be stamped into this element's shadow root.
       *
       * If a `static get is()` getter is defined, the default implementation will
       * return the first `<template>` in a `dom-module` whose `id` matches this
       * element's `is` (note that a `_template` property on the class prototype
       * takes precedence over the `dom-module` template, to maintain legacy
       * element semantics; a subclass will subsequently fall back to its super
       * class template if neither a `prototype._template` or a `dom-module` for
       * the class's `is` was found).
       *
       * Users may override this getter to return an arbitrary template
       * (in which case the `is` getter is unnecessary). The template returned
       * must be an `HTMLTemplateElement`.
       *
       * Note that when subclassing, if the super class overrode the default
       * implementation and the subclass would like to provide an alternate
       * template via a `dom-module`, it should override this getter and
       * return `DomModule.import(this.is, 'template')`.
       *
       * If a subclass would like to modify the super class template, it should
       * clone it rather than modify it in place.  If the getter does expensive
       * work such as cloning/modifying a template, it should memoize the
       * template for maximum performance:
       *
       *   let memoizedTemplate;
       *   class MySubClass extends MySuperClass {
       *     static get template() {
       *       if (!memoizedTemplate) {
       *         memoizedTemplate = super.template.cloneNode(true);
       *         let subContent = document.createElement('div');
       *         subContent.textContent = 'This came from MySubClass';
       *         memoizedTemplate.content.appendChild(subContent);
       *       }
       *       return memoizedTemplate;
       *     }
       *   }
       *
       * @return {!HTMLTemplateElement|string} Template to be stamped
       * @nocollapse
       */


      static get template() {
        // Explanation of template-related properties:
        // - constructor.template (this getter): the template for the class.
        //     This can come from the prototype (for legacy elements), from a
        //     dom-module, or from the super class's template (or can be overridden
        //     altogether by the user)
        // - constructor._template: memoized version of constructor.template
        // - prototype._template: working template for the element, which will be
        //     parsed and modified in place. It is a cloned version of
        //     constructor.template, saved in _finalizeClass(). Note that before
        //     this getter is called, for legacy elements this could be from a
        //     _template field on the info object passed to Polymer(), a behavior,
        //     or set in registered(); once the static getter runs, a clone of it
        //     will overwrite it on the prototype as the working template.
        if (!this.hasOwnProperty(JSCompiler_renameProperty('_template', this))) {
          const protoTemplate = this.prototype.hasOwnProperty(JSCompiler_renameProperty('_template', this.prototype)) ? this.prototype._template : undefined;
          this._template = // If user has put template on prototype (e.g. in legacy via registered
          // callback or info object), prefer that first. Note that `null` is
          // used as a sentinel to indicate "no template" and can be used to
          // override a super template, whereas `undefined` is used as a
          // sentinel to mean "fall-back to default template lookup" via
          // dom-module and/or super.template.
          protoTemplate !== undefined ? protoTemplate : // Look in dom-module associated with this element's is
          this.hasOwnProperty(JSCompiler_renameProperty('is', this)) && getTemplateFromDomModule(
          /** @type {PolymerElementConstructor}*/
          this.is) || // Next look for superclass template (call the super impl this
          // way so that `this` points to the superclass)
          Object.getPrototypeOf(
          /** @type {PolymerElementConstructor}*/
          this.prototype).constructor.template;
        }

        return this._template;
      }
      /**
       * Set the template.
       *
       * @param {!HTMLTemplateElement|string} value Template to set.
       * @nocollapse
       */


      static set template(value) {
        this._template = value;
      }
      /**
       * Path matching the url from which the element was imported.
       *
       * This path is used to resolve url's in template style cssText.
       * The `importPath` property is also set on element instances and can be
       * used to create bindings relative to the import path.
       *
       * For elements defined in ES modules, users should implement
       * `static get importMeta() { return import.meta; }`, and the default
       * implementation of `importPath` will  return `import.meta.url`'s path.
       * For elements defined in HTML imports, this getter will return the path
       * to the document containing a `dom-module` element matching this
       * element's static `is` property.
       *
       * Note, this path should contain a trailing `/`.
       *
       * @return {string} The import path for this element class
       * @suppress {missingProperties}
       * @nocollapse
       */


      static get importPath() {
        if (!this.hasOwnProperty(JSCompiler_renameProperty('_importPath', this))) {
          const meta = this.importMeta;

          if (meta) {
            this._importPath = pathFromUrl(meta.url);
          } else {
            const module = DomModule.import(
            /** @type {PolymerElementConstructor} */
            this.is);
            this._importPath = module && module.assetpath || Object.getPrototypeOf(
            /** @type {PolymerElementConstructor}*/
            this.prototype).constructor.importPath;
          }
        }

        return this._importPath;
      }

      constructor() {
        super();
        /** @type {HTMLTemplateElement} */

        this._template;
        /** @type {string} */

        this._importPath;
        /** @type {string} */

        this.rootPath;
        /** @type {string} */

        this.importPath;
        /** @type {StampedTemplate | HTMLElement | ShadowRoot} */

        this.root;
        /** @type {!Object<string, !Element>} */

        this.$;
      }
      /**
       * Overrides the default `PropertyAccessors` to ensure class
       * metaprogramming related to property accessors and effects has
       * completed (calls `finalize`).
       *
       * It also initializes any property defaults provided via `value` in
       * `properties` metadata.
       *
       * @return {void}
       * @override
       * @suppress {invalidCasts,missingProperties} go/missingfnprops
       */


      _initializeProperties() {
        this.constructor.finalize(); // note: finalize template when we have access to `localName` to
        // avoid dependence on `is` for polyfilling styling.

        this.constructor._finalizeTemplate(
        /** @type {!HTMLElement} */
        this.localName);

        super._initializeProperties(); // set path defaults


        this.rootPath = rootPath;
        this.importPath = this.constructor.importPath; // apply property defaults...

        let p$ = propertyDefaults(this.constructor);

        if (!p$) {
          return;
        }

        for (let p in p$) {
          let info = p$[p];

          if (this._canApplyPropertyDefault(p)) {
            let value = typeof info.value == 'function' ? info.value.call(this) : info.value; // Set via `_setProperty` if there is an accessor, to enable
            // initializing readOnly property defaults

            if (this._hasAccessor(p)) {
              this._setPendingProperty(p, value, true);
            } else {
              this[p] = value;
            }
          }
        }
      }
      /**
       * Determines if a property dfeault can be applied. For example, this
       * prevents a default from being applied when a property that has no
       * accessor is overridden by its host before upgrade (e.g. via a binding).
       * @override
       * @param {string} property Name of the property
       * @return {boolean} Returns true if the property default can be applied.
       */


      _canApplyPropertyDefault(property) {
        return !this.hasOwnProperty(property);
      }
      /**
       * Gather style text for a style element in the template.
       *
       * @param {string} cssText Text containing styling to process
       * @param {string} baseURI Base URI to rebase CSS paths against
       * @return {string} The processed CSS text
       * @protected
       * @nocollapse
       */


      static _processStyleText(cssText, baseURI) {
        return resolveCss(cssText, baseURI);
      }
      /**
      * Configures an element `proto` to function with a given `template`.
      * The element name `is` and extends `ext` must be specified for ShadyCSS
      * style scoping.
      *
      * @param {string} is Tag name (or type extension name) for this element
      * @return {void}
      * @protected
      * @nocollapse
      */


      static _finalizeTemplate(is) {
        /** @const {HTMLTemplateElement} */
        const template = this.prototype._template;

        if (template && !template.__polymerFinalized) {
          template.__polymerFinalized = true;
          const importPath = this.importPath;
          const baseURI = importPath ? resolveUrl(importPath) : ''; // e.g. support `include="module-name"`, and ShadyCSS

          processElementStyles(this, template, is, baseURI);

          this.prototype._bindTemplate(template);
        }
      }
      /**
       * Provides a default implementation of the standard Custom Elements
       * `connectedCallback`.
       *
       * The default implementation enables the property effects system and
       * flushes any pending properties, and updates shimmed CSS properties
       * when using the ShadyCSS scoping/custom properties polyfill.
       *
       * @override
       * @suppress {missingProperties, invalidCasts} Super may or may not
       *     implement the callback
       * @return {void}
       */


      connectedCallback() {
        if (window.ShadyCSS && this._template) {
          window.ShadyCSS.styleElement(
          /** @type {!HTMLElement} */
          this);
        }

        super.connectedCallback();
      }
      /**
       * Stamps the element template.
       *
       * @return {void}
       * @override
       */


      ready() {
        if (this._template) {
          this.root = this._stampTemplate(this._template);
          this.$ = this.root.$;
        }

        super.ready();
      }
      /**
       * Implements `PropertyEffects`'s `_readyClients` call. Attaches
       * element dom by calling `_attachDom` with the dom stamped from the
       * element's template via `_stampTemplate`. Note that this allows
       * client dom to be attached to the element prior to any observers
       * running.
       *
       * @return {void}
       * @override
       */


      _readyClients() {
        if (this._template) {
          this.root = this._attachDom(
          /** @type {StampedTemplate} */
          this.root);
        } // The super._readyClients here sets the clients initialized flag.
        // We must wait to do this until after client dom is created/attached
        // so that this flag can be checked to prevent notifications fired
        // during this process from being handled before clients are ready.


        super._readyClients();
      }
      /**
       * Attaches an element's stamped dom to itself. By default,
       * this method creates a `shadowRoot` and adds the dom to it.
       * However, this method may be overridden to allow an element
       * to put its dom in another location.
       *
       * @override
       * @throws {Error}
       * @suppress {missingReturn}
       * @param {StampedTemplate} dom to attach to the element.
       * @return {ShadowRoot} node to which the dom has been attached.
       */


      _attachDom(dom) {
        const n = wrap$1(this);

        if (n.attachShadow) {
          if (dom) {
            if (!n.shadowRoot) {
              n.attachShadow({
                mode: 'open',
                shadyUpgradeFragment: dom
              });
              n.shadowRoot.appendChild(dom); // When `adoptedStyleSheets` is supported a stylesheet is made
              // available on the element constructor.

              if (this.constructor._styleSheet) {
                n.shadowRoot.adoptedStyleSheets = [this.constructor._styleSheet];
              }
            }

            if (syncInitialRender && window.ShadyDOM) {
              window.ShadyDOM.flushInitial(n.shadowRoot);
            }

            return n.shadowRoot;
          }

          return null;
        } else {
          throw new Error('ShadowDOM not available. ' + // TODO(sorvell): move to compile-time conditional when supported
          'PolymerElement can create dom as children instead of in ' + 'ShadowDOM by setting `this.root = this;\` before \`ready\`.');
        }
      }
      /**
       * When using the ShadyCSS scoping and custom property shim, causes all
       * shimmed styles in this element (and its subtree) to be updated
       * based on current custom property values.
       *
       * The optional parameter overrides inline custom property styles with an
       * object of properties where the keys are CSS properties, and the values
       * are strings.
       *
       * Example: `this.updateStyles({'--color': 'blue'})`
       *
       * These properties are retained unless a value of `null` is set.
       *
       * Note: This function does not support updating CSS mixins.
       * You can not dynamically change the value of an `@apply`.
       *
       * @override
       * @param {Object=} properties Bag of custom property key/values to
       *   apply to this element.
       * @return {void}
       * @suppress {invalidCasts}
       */


      updateStyles(properties) {
        if (window.ShadyCSS) {
          window.ShadyCSS.styleSubtree(
          /** @type {!HTMLElement} */
          this, properties);
        }
      }
      /**
       * Rewrites a given URL relative to a base URL. The base URL defaults to
       * the original location of the document containing the `dom-module` for
       * this element. This method will return the same URL before and after
       * bundling.
       *
       * Note that this function performs no resolution for URLs that start
       * with `/` (absolute URLs) or `#` (hash identifiers).  For general purpose
       * URL resolution, use `window.URL`.
       *
       * @override
       * @param {string} url URL to resolve.
       * @param {string=} base Optional base URL to resolve against, defaults
       * to the element's `importPath`
       * @return {string} Rewritten URL relative to base
       */


      resolveUrl(url, base) {
        if (!base && this.importPath) {
          base = resolveUrl(this.importPath);
        }

        return resolveUrl(url, base);
      }
      /**
       * Overrides `PropertyEffects` to add map of dynamic functions on
       * template info, for consumption by `PropertyEffects` template binding
       * code. This map determines which method templates should have accessors
       * created for them.
       *
       * @param {!HTMLTemplateElement} template Template
       * @param {!TemplateInfo} templateInfo Template metadata for current template
       * @param {!NodeInfo} nodeInfo Node metadata for current template.
       * @return {boolean} .
       * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
       * @nocollapse
       */


      static _parseTemplateContent(template, templateInfo, nodeInfo) {
        templateInfo.dynamicFns = templateInfo.dynamicFns || this._properties; // TODO(https://github.com/google/closure-compiler/issues/3240):
        //     Change back to just super.methodCall()

        return polymerElementBase._parseTemplateContent.call(this, template, templateInfo, nodeInfo);
      }
      /**
       * Overrides `PropertyEffects` to warn on use of undeclared properties in
       * template.
       *
       * @param {Object} templateInfo Template metadata to add effect to
       * @param {string} prop Property that should trigger the effect
       * @param {Object=} effect Effect metadata object
       * @return {void}
       * @protected
       * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
       * @nocollapse
       */


      static _addTemplatePropertyEffect(templateInfo, prop, effect) {
        // Warn if properties are used in template without being declared.
        // Properties must be listed in `properties` to be included in
        // `observedAttributes` since CE V1 reads that at registration time, and
        // since we want to keep template parsing lazy, we can't automatically
        // add undeclared properties used in templates to `observedAttributes`.
        // The warning is only enabled in `legacyOptimizations` mode, since
        // we don't want to spam existing users who might have adopted the
        // shorthand when attribute deserialization is not important.
        if (legacyWarnings && !(prop in this._properties) && // Methods used in templates with no dependencies (or only literal
        // dependencies) become accessors with template effects; ignore these
        !(effect.info.part.signature && effect.info.part.signature.static) && // Warnings for bindings added to nested templates are handled by
        // templatizer so ignore both the host-to-template bindings
        // (`hostProp`) and TemplateInstance-to-child bindings
        // (`nestedTemplate`)
        !effect.info.part.hostProp && !templateInfo.nestedTemplate) {
          console.warn(`Property '${prop}' used in template but not declared in 'properties'; ` + `attribute will not be observed.`);
        } // TODO(https://github.com/google/closure-compiler/issues/3240):
        //     Change back to just super.methodCall()


        return polymerElementBase._addTemplatePropertyEffect.call(this, templateInfo, prop, effect);
      }

    }

    return PolymerElement;
  });

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * @summary Collapse multiple callbacks into one invocation after a timer.
   */

  class Debouncer {
    constructor() {
      this._asyncModule = null;
      this._callback = null;
      this._timer = null;
    }
    /**
     * Sets the scheduler; that is, a module with the Async interface,
     * a callback and optional arguments to be passed to the run function
     * from the async module.
     *
     * @param {!AsyncInterface} asyncModule Object with Async interface.
     * @param {function()} callback Callback to run.
     * @return {void}
     */


    setConfig(asyncModule, callback) {
      this._asyncModule = asyncModule;
      this._callback = callback;
      this._timer = this._asyncModule.run(() => {
        this._timer = null;
        debouncerQueue.delete(this);

        this._callback();
      });
    }
    /**
     * Cancels an active debouncer and returns a reference to itself.
     *
     * @return {void}
     */


    cancel() {
      if (this.isActive()) {
        this._cancelAsync(); // Canceling a debouncer removes its spot from the flush queue,
        // so if a debouncer is manually canceled and re-debounced, it
        // will reset its flush order (this is a very minor difference from 1.x)
        // Re-debouncing via the `debounce` API retains the 1.x FIFO flush order


        debouncerQueue.delete(this);
      }
    }
    /**
     * Cancels a debouncer's async callback.
     *
     * @return {void}
     */


    _cancelAsync() {
      if (this.isActive()) {
        this._asyncModule.cancel(
        /** @type {number} */
        this._timer);

        this._timer = null;
      }
    }
    /**
     * Flushes an active debouncer and returns a reference to itself.
     *
     * @return {void}
     */


    flush() {
      if (this.isActive()) {
        this.cancel();

        this._callback();
      }
    }
    /**
     * Returns true if the debouncer is active.
     *
     * @return {boolean} True if active.
     */


    isActive() {
      return this._timer != null;
    }
    /**
     * Creates a debouncer if no debouncer is passed as a parameter
     * or it cancels an active debouncer otherwise. The following
     * example shows how a debouncer can be called multiple times within a
     * microtask and "debounced" such that the provided callback function is
     * called once. Add this method to a custom element:
     *
     * ```js
     * import {microTask} from '@polymer/polymer/lib/utils/async.js';
     * import {Debouncer} from '@polymer/polymer/lib/utils/debounce.js';
     * // ...
     *
     * _debounceWork() {
     *   this._debounceJob = Debouncer.debounce(this._debounceJob,
     *       microTask, () => this._doWork());
     * }
     * ```
     *
     * If the `_debounceWork` method is called multiple times within the same
     * microtask, the `_doWork` function will be called only once at the next
     * microtask checkpoint.
     *
     * Note: In testing it is often convenient to avoid asynchrony. To accomplish
     * this with a debouncer, you can use `enqueueDebouncer` and
     * `flush`. For example, extend the above example by adding
     * `enqueueDebouncer(this._debounceJob)` at the end of the
     * `_debounceWork` method. Then in a test, call `flush` to ensure
     * the debouncer has completed.
     *
     * @param {Debouncer?} debouncer Debouncer object.
     * @param {!AsyncInterface} asyncModule Object with Async interface
     * @param {function()} callback Callback to run.
     * @return {!Debouncer} Returns a debouncer object.
     */


    static debounce(debouncer, asyncModule, callback) {
      if (debouncer instanceof Debouncer) {
        // Cancel the async callback, but leave in debouncerQueue if it was
        // enqueued, to maintain 1.x flush order
        debouncer._cancelAsync();
      } else {
        debouncer = new Debouncer();
      }

      debouncer.setConfig(asyncModule, callback);
      return debouncer;
    }

  }
  let debouncerQueue = new Set();
  /**
   * Adds a `Debouncer` to a list of globally flushable tasks.
   *
   * @param {!Debouncer} debouncer Debouncer to enqueue
   * @return {void}
   */

  const enqueueDebouncer = function (debouncer) {
    debouncerQueue.add(debouncer);
  };
  /**
   * Flushes any enqueued debouncers
   *
   * @return {boolean} Returns whether any debouncers were flushed
   */

  const flushDebouncers = function () {
    const didFlush = Boolean(debouncerQueue.size); // If new debouncers are added while flushing, Set.forEach will ensure
    // newly added ones are also flushed

    debouncerQueue.forEach(debouncer => {
      try {
        debouncer.flush();
      } catch (e) {
        setTimeout(() => {
          throw e;
        });
      }
    });
    return didFlush;
  };

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  let HAS_NATIVE_TA = typeof document.head.style.touchAction === 'string';
  let GESTURE_KEY = '__polymerGestures';
  let HANDLED_OBJ = '__polymerGesturesHandled';
  let TOUCH_ACTION = '__polymerGesturesTouchAction'; // radius for tap and track

  let TAP_DISTANCE = 25;
  let TRACK_DISTANCE = 5; // number of last N track positions to keep

  let TRACK_LENGTH = 2; // Disabling "mouse" handlers for 2500ms is enough

  let MOUSE_TIMEOUT = 2500;
  let MOUSE_EVENTS = ['mousedown', 'mousemove', 'mouseup', 'click']; // an array of bitmask values for mapping MouseEvent.which to MouseEvent.buttons

  let MOUSE_WHICH_TO_BUTTONS = [0, 1, 4, 2];

  let MOUSE_HAS_BUTTONS = function () {
    try {
      return new MouseEvent('test', {
        buttons: 1
      }).buttons === 1;
    } catch (e) {
      return false;
    }
  }();
  /**
   * @param {string} name Possible mouse event name
   * @return {boolean} true if mouse event, false if not
   */


  function isMouseEvent(name) {
    return MOUSE_EVENTS.indexOf(name) > -1;
  }
  /* eslint no-empty: ["error", { "allowEmptyCatch": true }] */
  // check for passive event listeners


  let supportsPassive = false;

  (function () {
    try {
      let opts = Object.defineProperty({}, 'passive', {
        get() {
          supportsPassive = true;
        }

      });
      window.addEventListener('test', null, opts);
      window.removeEventListener('test', null, opts);
    } catch (e) {}
  })();
  /**
   * Generate settings for event listeners, dependant on `passiveTouchGestures`
   *
   * @param {string} eventName Event name to determine if `{passive}` option is
   *   needed
   * @return {{passive: boolean} | undefined} Options to use for addEventListener
   *   and removeEventListener
   */


  function PASSIVE_TOUCH(eventName) {
    if (isMouseEvent(eventName) || eventName === 'touchend') {
      return;
    }

    if (HAS_NATIVE_TA && supportsPassive && passiveTouchGestures) {
      return {
        passive: true
      };
    } else {
      return;
    }
  } // Check for touch-only devices


  let IS_TOUCH_ONLY = navigator.userAgent.match(/iP(?:[oa]d|hone)|Android/); // keep track of any labels hit by the mouseCanceller

  /** @type {!Array<!HTMLLabelElement>} */

  const clickedLabels = [];
  /** @type {!Object<boolean>} */

  const labellable = {
    'button': true,
    'input': true,
    'keygen': true,
    'meter': true,
    'output': true,
    'textarea': true,
    'progress': true,
    'select': true
  }; // Defined at https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#enabling-and-disabling-form-controls:-the-disabled-attribute

  /** @type {!Object<boolean>} */

  const canBeDisabled = {
    'button': true,
    'command': true,
    'fieldset': true,
    'input': true,
    'keygen': true,
    'optgroup': true,
    'option': true,
    'select': true,
    'textarea': true
  };
  /**
   * @param {HTMLElement} el Element to check labelling status
   * @return {boolean} element can have labels
   */

  function canBeLabelled(el) {
    return labellable[el.localName] || false;
  }
  /**
   * @param {HTMLElement} el Element that may be labelled.
   * @return {!Array<!HTMLLabelElement>} Relevant label for `el`
   */


  function matchingLabels(el) {
    let labels = Array.prototype.slice.call(
    /** @type {HTMLInputElement} */
    el.labels || []); // IE doesn't have `labels` and Safari doesn't populate `labels`
    // if element is in a shadowroot.
    // In this instance, finding the non-ancestor labels is enough,
    // as the mouseCancellor code will handle ancstor labels

    if (!labels.length) {
      labels = [];
      let root = el.getRootNode(); // if there is an id on `el`, check for all labels with a matching `for` attribute

      if (el.id) {
        let matching = root.querySelectorAll(`label[for = ${el.id}]`);

        for (let i = 0; i < matching.length; i++) {
          labels.push(
          /** @type {!HTMLLabelElement} */
          matching[i]);
        }
      }
    }

    return labels;
  } // touch will make synthetic mouse events
  // `preventDefault` on touchend will cancel them,
  // but this breaks `<input>` focus and link clicks
  // disable mouse handlers for MOUSE_TIMEOUT ms after
  // a touchend to ignore synthetic mouse events


  let mouseCanceller = function (mouseEvent) {
    // Check for sourceCapabilities, used to distinguish synthetic events
    // if mouseEvent did not come from a device that fires touch events,
    // it was made by a real mouse and should be counted
    // http://wicg.github.io/InputDeviceCapabilities/#dom-inputdevicecapabilities-firestouchevents
    let sc = mouseEvent.sourceCapabilities;

    if (sc && !sc.firesTouchEvents) {
      return;
    } // skip synthetic mouse events


    mouseEvent[HANDLED_OBJ] = {
      skip: true
    }; // disable "ghost clicks"

    if (mouseEvent.type === 'click') {
      let clickFromLabel = false;
      let path = getComposedPath(mouseEvent);

      for (let i = 0; i < path.length; i++) {
        if (path[i].nodeType === Node.ELEMENT_NODE) {
          if (path[i].localName === 'label') {
            clickedLabels.push(
            /** @type {!HTMLLabelElement} */
            path[i]);
          } else if (canBeLabelled(
          /** @type {!HTMLElement} */
          path[i])) {
            let ownerLabels = matchingLabels(
            /** @type {!HTMLElement} */
            path[i]); // check if one of the clicked labels is labelling this element

            for (let j = 0; j < ownerLabels.length; j++) {
              clickFromLabel = clickFromLabel || clickedLabels.indexOf(ownerLabels[j]) > -1;
            }
          }
        }

        if (path[i] === POINTERSTATE.mouse.target) {
          return;
        }
      } // if one of the clicked labels was labelling the target element,
      // this is not a ghost click


      if (clickFromLabel) {
        return;
      }

      mouseEvent.preventDefault();
      mouseEvent.stopPropagation();
    }
  };
  /**
   * @param {boolean=} setup True to add, false to remove.
   * @return {void}
   */


  function setupTeardownMouseCanceller(setup) {
    let events = IS_TOUCH_ONLY ? ['click'] : MOUSE_EVENTS;

    for (let i = 0, en; i < events.length; i++) {
      en = events[i];

      if (setup) {
        // reset clickLabels array
        clickedLabels.length = 0;
        document.addEventListener(en, mouseCanceller, true);
      } else {
        document.removeEventListener(en, mouseCanceller, true);
      }
    }
  }

  function ignoreMouse(e) {

    if (!POINTERSTATE.mouse.mouseIgnoreJob) {
      setupTeardownMouseCanceller(true);
    }

    let unset = function () {
      setupTeardownMouseCanceller();
      POINTERSTATE.mouse.target = null;
      POINTERSTATE.mouse.mouseIgnoreJob = null;
    };

    POINTERSTATE.mouse.target = getComposedPath(e)[0];
    POINTERSTATE.mouse.mouseIgnoreJob = Debouncer.debounce(POINTERSTATE.mouse.mouseIgnoreJob, timeOut.after(MOUSE_TIMEOUT), unset);
  }
  /**
   * @param {MouseEvent} ev event to test for left mouse button down
   * @return {boolean} has left mouse button down
   */


  function hasLeftMouseButton(ev) {
    let type = ev.type; // exit early if the event is not a mouse event

    if (!isMouseEvent(type)) {
      return false;
    } // ev.button is not reliable for mousemove (0 is overloaded as both left button and no buttons)
    // instead we use ev.buttons (bitmask of buttons) or fall back to ev.which (deprecated, 0 for no buttons, 1 for left button)


    if (type === 'mousemove') {
      // allow undefined for testing events
      let buttons = ev.buttons === undefined ? 1 : ev.buttons;

      if (ev instanceof window.MouseEvent && !MOUSE_HAS_BUTTONS) {
        buttons = MOUSE_WHICH_TO_BUTTONS[ev.which] || 0;
      } // buttons is a bitmask, check that the left button bit is set (1)


      return Boolean(buttons & 1);
    } else {
      // allow undefined for testing events
      let button = ev.button === undefined ? 0 : ev.button; // ev.button is 0 in mousedown/mouseup/click for left button activation

      return button === 0;
    }
  }

  function isSyntheticClick(ev) {
    if (ev.type === 'click') {
      // ev.detail is 0 for HTMLElement.click in most browsers
      if (ev.detail === 0) {
        return true;
      } // in the worst case, check that the x/y position of the click is within
      // the bounding box of the target of the event
      // Thanks IE 10 >:(


      let t = _findOriginalTarget(ev); // make sure the target of the event is an element so we can use getBoundingClientRect,
      // if not, just assume it is a synthetic click


      if (!t.nodeType ||
      /** @type {Element} */
      t.nodeType !== Node.ELEMENT_NODE) {
        return true;
      }

      let bcr =
      /** @type {Element} */
      t.getBoundingClientRect(); // use page x/y to account for scrolling

      let x = ev.pageX,
          y = ev.pageY; // ev is a synthetic click if the position is outside the bounding box of the target

      return !(x >= bcr.left && x <= bcr.right && y >= bcr.top && y <= bcr.bottom);
    }

    return false;
  }

  let POINTERSTATE = {
    mouse: {
      target: null,
      mouseIgnoreJob: null
    },
    touch: {
      x: 0,
      y: 0,
      id: -1,
      scrollDecided: false
    }
  };

  function firstTouchAction(ev) {
    let ta = 'auto';
    let path = getComposedPath(ev);

    for (let i = 0, n; i < path.length; i++) {
      n = path[i];

      if (n[TOUCH_ACTION]) {
        ta = n[TOUCH_ACTION];
        break;
      }
    }

    return ta;
  }

  function trackDocument(stateObj, movefn, upfn) {
    stateObj.movefn = movefn;
    stateObj.upfn = upfn;
    document.addEventListener('mousemove', movefn);
    document.addEventListener('mouseup', upfn);
  }

  function untrackDocument(stateObj) {
    document.removeEventListener('mousemove', stateObj.movefn);
    document.removeEventListener('mouseup', stateObj.upfn);
    stateObj.movefn = null;
    stateObj.upfn = null;
  }

  {
    // use a document-wide touchend listener to start the ghost-click prevention mechanism
    // Use passive event listeners, if supported, to not affect scrolling performance
    document.addEventListener('touchend', ignoreMouse, supportsPassive ? {
      passive: true
    } : false);
  }
  /**
   * Returns the composedPath for the given event.
   * @param {Event} event to process
   * @return {!Array<!EventTarget>} Path of the event
   */


  const getComposedPath = window.ShadyDOM && window.ShadyDOM.noPatch ? window.ShadyDOM.composedPath : event => event.composedPath && event.composedPath() || [];
  /** @type {!Object<string, !GestureRecognizer>} */

  const gestures = {};
  /** @type {!Array<!GestureRecognizer>} */

  const recognizers = [];
  /**
   * Finds the element rendered on the screen at the provided coordinates.
   *
   * Similar to `document.elementFromPoint`, but pierces through
   * shadow roots.
   *
   * @param {number} x Horizontal pixel coordinate
   * @param {number} y Vertical pixel coordinate
   * @return {Element} Returns the deepest shadowRoot inclusive element
   * found at the screen position given.
   */

  function deepTargetFind(x, y) {
    let node = document.elementFromPoint(x, y);
    let next = node; // this code path is only taken when native ShadowDOM is used
    // if there is a shadowroot, it may have a node at x/y
    // if there is not a shadowroot, exit the loop

    while (next && next.shadowRoot && !window.ShadyDOM) {
      // if there is a node at x/y in the shadowroot, look deeper
      let oldNext = next;
      next = next.shadowRoot.elementFromPoint(x, y); // on Safari, elementFromPoint may return the shadowRoot host

      if (oldNext === next) {
        break;
      }

      if (next) {
        node = next;
      }
    }

    return node;
  }
  /**
   * a cheaper check than ev.composedPath()[0];
   *
   * @private
   * @param {Event|Touch} ev Event.
   * @return {EventTarget} Returns the event target.
   */

  function _findOriginalTarget(ev) {
    const path = getComposedPath(
    /** @type {?Event} */
    ev); // It shouldn't be, but sometimes path is empty (window on Safari).

    return path.length > 0 ? path[0] : ev.target;
  }
  /**
   * @private
   * @param {Event} ev Event.
   * @return {void}
   */


  function _handleNative(ev) {
    let handled;
    let type = ev.type;
    let node = ev.currentTarget;
    let gobj = node[GESTURE_KEY];

    if (!gobj) {
      return;
    }

    let gs = gobj[type];

    if (!gs) {
      return;
    }

    if (!ev[HANDLED_OBJ]) {
      ev[HANDLED_OBJ] = {};

      if (type.slice(0, 5) === 'touch') {
        ev =
        /** @type {TouchEvent} */
        ev; // eslint-disable-line no-self-assign

        let t = ev.changedTouches[0];

        if (type === 'touchstart') {
          // only handle the first finger
          if (ev.touches.length === 1) {
            POINTERSTATE.touch.id = t.identifier;
          }
        }

        if (POINTERSTATE.touch.id !== t.identifier) {
          return;
        }

        if (!HAS_NATIVE_TA) {
          if (type === 'touchstart' || type === 'touchmove') {
            _handleTouchAction(ev);
          }
        }
      }
    }

    handled = ev[HANDLED_OBJ]; // used to ignore synthetic mouse events

    if (handled.skip) {
      return;
    } // reset recognizer state


    for (let i = 0, r; i < recognizers.length; i++) {
      r = recognizers[i];

      if (gs[r.name] && !handled[r.name]) {
        if (r.flow && r.flow.start.indexOf(ev.type) > -1 && r.reset) {
          r.reset();
        }
      }
    } // enforce gesture recognizer order


    for (let i = 0, r; i < recognizers.length; i++) {
      r = recognizers[i];

      if (gs[r.name] && !handled[r.name]) {
        handled[r.name] = true;
        r[type](ev);
      }
    }
  }
  /**
   * @private
   * @param {TouchEvent} ev Event.
   * @return {void}
   */


  function _handleTouchAction(ev) {
    let t = ev.changedTouches[0];
    let type = ev.type;

    if (type === 'touchstart') {
      POINTERSTATE.touch.x = t.clientX;
      POINTERSTATE.touch.y = t.clientY;
      POINTERSTATE.touch.scrollDecided = false;
    } else if (type === 'touchmove') {
      if (POINTERSTATE.touch.scrollDecided) {
        return;
      }

      POINTERSTATE.touch.scrollDecided = true;
      let ta = firstTouchAction(ev);
      let shouldPrevent = false;
      let dx = Math.abs(POINTERSTATE.touch.x - t.clientX);
      let dy = Math.abs(POINTERSTATE.touch.y - t.clientY);

      if (!ev.cancelable) ; else if (ta === 'none') {
        shouldPrevent = true;
      } else if (ta === 'pan-x') {
        shouldPrevent = dy > dx;
      } else if (ta === 'pan-y') {
        shouldPrevent = dx > dy;
      }

      if (shouldPrevent) {
        ev.preventDefault();
      } else {
        prevent('track');
      }
    }
  }
  /**
   * Adds an event listener to a node for the given gesture type.
   *
   * @param {!EventTarget} node Node to add listener on
   * @param {string} evType Gesture type: `down`, `up`, `track`, or `tap`
   * @param {!function(!Event):void} handler Event listener function to call
   * @return {boolean} Returns true if a gesture event listener was added.
   */


  function addListener(node, evType, handler) {
    if (gestures[evType]) {
      _add(node, evType, handler);

      return true;
    }

    return false;
  }
  /**
   * Removes an event listener from a node for the given gesture type.
   *
   * @param {!EventTarget} node Node to remove listener from
   * @param {string} evType Gesture type: `down`, `up`, `track`, or `tap`
   * @param {!function(!Event):void} handler Event listener function previously passed to
   *  `addListener`.
   * @return {boolean} Returns true if a gesture event listener was removed.
   */

  function removeListener(node, evType, handler) {
    if (gestures[evType]) {
      _remove(node, evType, handler);

      return true;
    }

    return false;
  }
  /**
   * automate the event listeners for the native events
   *
   * @private
   * @param {!EventTarget} node Node on which to add the event.
   * @param {string} evType Event type to add.
   * @param {function(!Event)} handler Event handler function.
   * @return {void}
   */

  function _add(node, evType, handler) {
    let recognizer = gestures[evType];
    let deps = recognizer.deps;
    let name = recognizer.name;
    let gobj = node[GESTURE_KEY];

    if (!gobj) {
      node[GESTURE_KEY] = gobj = {};
    }

    for (let i = 0, dep, gd; i < deps.length; i++) {
      dep = deps[i]; // don't add mouse handlers on iOS because they cause gray selection overlays

      if (IS_TOUCH_ONLY && isMouseEvent(dep) && dep !== 'click') {
        continue;
      }

      gd = gobj[dep];

      if (!gd) {
        gobj[dep] = gd = {
          _count: 0
        };
      }

      if (gd._count === 0) {
        node.addEventListener(dep, _handleNative, PASSIVE_TOUCH(dep));
      }

      gd[name] = (gd[name] || 0) + 1;
      gd._count = (gd._count || 0) + 1;
    }

    node.addEventListener(evType, handler);

    if (recognizer.touchAction) {
      setTouchAction(node, recognizer.touchAction);
    }
  }
  /**
   * automate event listener removal for native events
   *
   * @private
   * @param {!EventTarget} node Node on which to remove the event.
   * @param {string} evType Event type to remove.
   * @param {function(!Event): void} handler Event handler function.
   * @return {void}
   */


  function _remove(node, evType, handler) {
    let recognizer = gestures[evType];
    let deps = recognizer.deps;
    let name = recognizer.name;
    let gobj = node[GESTURE_KEY];

    if (gobj) {
      for (let i = 0, dep, gd; i < deps.length; i++) {
        dep = deps[i];
        gd = gobj[dep];

        if (gd && gd[name]) {
          gd[name] = (gd[name] || 1) - 1;
          gd._count = (gd._count || 1) - 1;

          if (gd._count === 0) {
            node.removeEventListener(dep, _handleNative, PASSIVE_TOUCH(dep));
          }
        }
      }
    }

    node.removeEventListener(evType, handler);
  }
  /**
   * Registers a new gesture event recognizer for adding new custom
   * gesture event types.
   *
   * @param {!GestureRecognizer} recog Gesture recognizer descriptor
   * @return {void}
   */


  function register$1(recog) {
    recognizers.push(recog);

    for (let i = 0; i < recog.emits.length; i++) {
      gestures[recog.emits[i]] = recog;
    }
  }
  /**
   * @private
   * @param {string} evName Event name.
   * @return {Object} Returns the gesture for the given event name.
   */

  function _findRecognizerByEvent(evName) {
    for (let i = 0, r; i < recognizers.length; i++) {
      r = recognizers[i];

      for (let j = 0, n; j < r.emits.length; j++) {
        n = r.emits[j];

        if (n === evName) {
          return r;
        }
      }
    }

    return null;
  }
  /**
   * Sets scrolling direction on node.
   *
   * This value is checked on first move, thus it should be called prior to
   * adding event listeners.
   *
   * @param {!EventTarget} node Node to set touch action setting on
   * @param {string} value Touch action value
   * @return {void}
   */


  function setTouchAction(node, value) {
    if (HAS_NATIVE_TA && node instanceof HTMLElement) {
      // NOTE: add touchAction async so that events can be added in
      // custom element constructors. Otherwise we run afoul of custom
      // elements restriction against settings attributes (style) in the
      // constructor.
      microTask.run(() => {
        node.style.touchAction = value;
      });
    }

    node[TOUCH_ACTION] = value;
  }
  /**
   * Dispatches an event on the `target` element of `type` with the given
   * `detail`.
   * @private
   * @param {!EventTarget} target The element on which to fire an event.
   * @param {string} type The type of event to fire.
   * @param {!Object=} detail The detail object to populate on the event.
   * @return {void}
   */

  function _fire(target, type, detail) {
    let ev = new Event(type, {
      bubbles: true,
      cancelable: true,
      composed: true
    });
    ev.detail = detail;
    wrap$1(
    /** @type {!Node} */
    target).dispatchEvent(ev); // forward `preventDefault` in a clean way

    if (ev.defaultPrevented) {
      let preventer = detail.preventer || detail.sourceEvent;

      if (preventer && preventer.preventDefault) {
        preventer.preventDefault();
      }
    }
  }
  /**
   * Prevents the dispatch and default action of the given event name.
   *
   * @param {string} evName Event name.
   * @return {void}
   */


  function prevent(evName) {
    let recognizer = _findRecognizerByEvent(evName);

    if (recognizer.info) {
      recognizer.info.prevent = true;
    }
  }
  /* eslint-disable valid-jsdoc */

  register$1({
    name: 'downup',
    deps: ['mousedown', 'touchstart', 'touchend'],
    flow: {
      start: ['mousedown', 'touchstart'],
      end: ['mouseup', 'touchend']
    },
    emits: ['down', 'up'],
    info: {
      movefn: null,
      upfn: null
    },

    /**
     * @this {GestureRecognizer}
     * @return {void}
     */
    reset: function () {
      untrackDocument(this.info);
    },

    /**
     * @this {GestureRecognizer}
     * @param {MouseEvent} e
     * @return {void}
     */
    mousedown: function (e) {
      if (!hasLeftMouseButton(e)) {
        return;
      }

      let t = _findOriginalTarget(e);

      let self = this;

      let movefn = function movefn(e) {
        if (!hasLeftMouseButton(e)) {
          downupFire('up', t, e);
          untrackDocument(self.info);
        }
      };

      let upfn = function upfn(e) {
        if (hasLeftMouseButton(e)) {
          downupFire('up', t, e);
        }

        untrackDocument(self.info);
      };

      trackDocument(this.info, movefn, upfn);
      downupFire('down', t, e);
    },

    /**
     * @this {GestureRecognizer}
     * @param {TouchEvent} e
     * @return {void}
     */
    touchstart: function (e) {
      downupFire('down', _findOriginalTarget(e), e.changedTouches[0], e);
    },

    /**
     * @this {GestureRecognizer}
     * @param {TouchEvent} e
     * @return {void}
     */
    touchend: function (e) {
      downupFire('up', _findOriginalTarget(e), e.changedTouches[0], e);
    }
  });
  /**
   * @param {string} type
   * @param {EventTarget} target
   * @param {Event|Touch} event
   * @param {Event=} preventer
   * @return {void}
   */

  function downupFire(type, target, event, preventer) {
    if (!target) {
      return;
    }

    _fire(target, type, {
      x: event.clientX,
      y: event.clientY,
      sourceEvent: event,
      preventer: preventer,
      prevent: function (e) {
        return prevent(e);
      }
    });
  }

  register$1({
    name: 'track',
    touchAction: 'none',
    deps: ['mousedown', 'touchstart', 'touchmove', 'touchend'],
    flow: {
      start: ['mousedown', 'touchstart'],
      end: ['mouseup', 'touchend']
    },
    emits: ['track'],
    info: {
      x: 0,
      y: 0,
      state: 'start',
      started: false,
      moves: [],

      /** @this {GestureInfo} */
      addMove: function (move) {
        if (this.moves.length > TRACK_LENGTH) {
          this.moves.shift();
        }

        this.moves.push(move);
      },
      movefn: null,
      upfn: null,
      prevent: false
    },

    /**
     * @this {GestureRecognizer}
     * @return {void}
     */
    reset: function () {
      this.info.state = 'start';
      this.info.started = false;
      this.info.moves = [];
      this.info.x = 0;
      this.info.y = 0;
      this.info.prevent = false;
      untrackDocument(this.info);
    },

    /**
     * @this {GestureRecognizer}
     * @param {MouseEvent} e
     * @return {void}
     */
    mousedown: function (e) {
      if (!hasLeftMouseButton(e)) {
        return;
      }

      let t = _findOriginalTarget(e);

      let self = this;

      let movefn = function movefn(e) {
        let x = e.clientX,
            y = e.clientY;

        if (trackHasMovedEnough(self.info, x, y)) {
          // first move is 'start', subsequent moves are 'move', mouseup is 'end'
          self.info.state = self.info.started ? e.type === 'mouseup' ? 'end' : 'track' : 'start';

          if (self.info.state === 'start') {
            // if and only if tracking, always prevent tap
            prevent('tap');
          }

          self.info.addMove({
            x: x,
            y: y
          });

          if (!hasLeftMouseButton(e)) {
            // always fire "end"
            self.info.state = 'end';
            untrackDocument(self.info);
          }

          if (t) {
            trackFire(self.info, t, e);
          }

          self.info.started = true;
        }
      };

      let upfn = function upfn(e) {
        if (self.info.started) {
          movefn(e);
        } // remove the temporary listeners


        untrackDocument(self.info);
      }; // add temporary document listeners as mouse retargets


      trackDocument(this.info, movefn, upfn);
      this.info.x = e.clientX;
      this.info.y = e.clientY;
    },

    /**
     * @this {GestureRecognizer}
     * @param {TouchEvent} e
     * @return {void}
     */
    touchstart: function (e) {
      let ct = e.changedTouches[0];
      this.info.x = ct.clientX;
      this.info.y = ct.clientY;
    },

    /**
     * @this {GestureRecognizer}
     * @param {TouchEvent} e
     * @return {void}
     */
    touchmove: function (e) {
      let t = _findOriginalTarget(e);

      let ct = e.changedTouches[0];
      let x = ct.clientX,
          y = ct.clientY;

      if (trackHasMovedEnough(this.info, x, y)) {
        if (this.info.state === 'start') {
          // if and only if tracking, always prevent tap
          prevent('tap');
        }

        this.info.addMove({
          x: x,
          y: y
        });
        trackFire(this.info, t, ct);
        this.info.state = 'track';
        this.info.started = true;
      }
    },

    /**
     * @this {GestureRecognizer}
     * @param {TouchEvent} e
     * @return {void}
     */
    touchend: function (e) {
      let t = _findOriginalTarget(e);

      let ct = e.changedTouches[0]; // only trackend if track was started and not aborted

      if (this.info.started) {
        // reset started state on up
        this.info.state = 'end';
        this.info.addMove({
          x: ct.clientX,
          y: ct.clientY
        });
        trackFire(this.info, t, ct);
      }
    }
  });
  /**
   * @param {!GestureInfo} info
   * @param {number} x
   * @param {number} y
   * @return {boolean}
   */

  function trackHasMovedEnough(info, x, y) {
    if (info.prevent) {
      return false;
    }

    if (info.started) {
      return true;
    }

    let dx = Math.abs(info.x - x);
    let dy = Math.abs(info.y - y);
    return dx >= TRACK_DISTANCE || dy >= TRACK_DISTANCE;
  }
  /**
   * @param {!GestureInfo} info
   * @param {?EventTarget} target
   * @param {Touch} touch
   * @return {void}
   */


  function trackFire(info, target, touch) {
    if (!target) {
      return;
    }

    let secondlast = info.moves[info.moves.length - 2];
    let lastmove = info.moves[info.moves.length - 1];
    let dx = lastmove.x - info.x;
    let dy = lastmove.y - info.y;
    let ddx,
        ddy = 0;

    if (secondlast) {
      ddx = lastmove.x - secondlast.x;
      ddy = lastmove.y - secondlast.y;
    }

    _fire(target, 'track', {
      state: info.state,
      x: touch.clientX,
      y: touch.clientY,
      dx: dx,
      dy: dy,
      ddx: ddx,
      ddy: ddy,
      sourceEvent: touch,
      hover: function () {
        return deepTargetFind(touch.clientX, touch.clientY);
      }
    });
  }

  register$1({
    name: 'tap',
    deps: ['mousedown', 'click', 'touchstart', 'touchend'],
    flow: {
      start: ['mousedown', 'touchstart'],
      end: ['click', 'touchend']
    },
    emits: ['tap'],
    info: {
      x: NaN,
      y: NaN,
      prevent: false
    },

    /**
     * @this {GestureRecognizer}
     * @return {void}
     */
    reset: function () {
      this.info.x = NaN;
      this.info.y = NaN;
      this.info.prevent = false;
    },

    /**
     * @this {GestureRecognizer}
     * @param {MouseEvent} e
     * @return {void}
     */
    mousedown: function (e) {
      if (hasLeftMouseButton(e)) {
        this.info.x = e.clientX;
        this.info.y = e.clientY;
      }
    },

    /**
     * @this {GestureRecognizer}
     * @param {MouseEvent} e
     * @return {void}
     */
    click: function (e) {
      if (hasLeftMouseButton(e)) {
        trackForward(this.info, e);
      }
    },

    /**
     * @this {GestureRecognizer}
     * @param {TouchEvent} e
     * @return {void}
     */
    touchstart: function (e) {
      const touch = e.changedTouches[0];
      this.info.x = touch.clientX;
      this.info.y = touch.clientY;
    },

    /**
     * @this {GestureRecognizer}
     * @param {TouchEvent} e
     * @return {void}
     */
    touchend: function (e) {
      trackForward(this.info, e.changedTouches[0], e);
    }
  });
  /**
   * @param {!GestureInfo} info
   * @param {Event | Touch} e
   * @param {Event=} preventer
   * @return {void}
   */

  function trackForward(info, e, preventer) {
    let dx = Math.abs(e.clientX - info.x);
    let dy = Math.abs(e.clientY - info.y); // find original target from `preventer` for TouchEvents, or `e` for MouseEvents

    let t = _findOriginalTarget(preventer || e);

    if (!t || canBeDisabled[
    /** @type {!HTMLElement} */
    t.localName] && t.hasAttribute('disabled')) {
      return;
    } // dx,dy can be NaN if `click` has been simulated and there was no `down` for `start`


    if (isNaN(dx) || isNaN(dy) || dx <= TAP_DISTANCE && dy <= TAP_DISTANCE || isSyntheticClick(e)) {
      // prevent taps from being generated if an event has canceled them
      if (!info.prevent) {
        _fire(t, 'tap', {
          x: e.clientX,
          y: e.clientY,
          sourceEvent: e,
          preventer: preventer
        });
      }
    }
  }
  /* eslint-enable valid-jsdoc */

  /** @deprecated */


  const findOriginalTarget = _findOriginalTarget;

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * Element class mixin that provides API for adding Polymer's cross-platform
   * gesture events to nodes.
   *
   * The API is designed to be compatible with override points implemented
   * in `TemplateStamp` such that declarative event listeners in
   * templates will support gesture events when this mixin is applied along with
   * `TemplateStamp`.
   *
   * @mixinFunction
   * @polymer
   * @summary Element class mixin that provides API for adding Polymer's
   *   cross-platform gesture events to nodes
   * @template T
   * @param {function(new:T)} superClass Class to apply mixin to.
   * @return {function(new:T)} superClass with mixin applied.
   */

  const GestureEventListeners = dedupingMixin(superClass => {
    /**
     * @polymer
     * @mixinClass
     * @implements {Polymer_GestureEventListeners}
     */
    class GestureEventListeners extends superClass {
      /**
       * Add the event listener to the node if it is a gestures event.
       *
       * @param {!EventTarget} node Node to add event listener to
       * @param {string} eventName Name of event
       * @param {function(!Event):void} handler Listener function to add
       * @return {void}
       * @override
       */
      _addEventListenerToNode(node, eventName, handler) {
        if (!addListener(node, eventName, handler)) {
          super._addEventListenerToNode(node, eventName, handler);
        }
      }
      /**
       * Remove the event listener to the node if it is a gestures event.
       *
       * @param {!EventTarget} node Node to remove event listener from
       * @param {string} eventName Name of event
       * @param {function(!Event):void} handler Listener function to remove
       * @return {void}
       * @override
       */


      _removeEventListenerFromNode(node, eventName, handler) {
        if (!removeListener(node, eventName, handler)) {
          super._removeEventListenerFromNode(node, eventName, handler);
        }
      }

    }

    return GestureEventListeners;
  });

  /**
   * @fileoverview
   * @suppress {checkPrototypalTypes}
   * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
   * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
   * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
   * Google as part of the polymer project is also subject to an additional IP
   * rights grant found at http://polymer.github.io/PATENTS.txt
   */
  const HOST_DIR = /:host\(:dir\((ltr|rtl)\)\)/g;
  const HOST_DIR_REPLACMENT = ':host([dir="$1"])';
  const EL_DIR = /([\s\w-#\.\[\]\*]*):dir\((ltr|rtl)\)/g;
  const EL_DIR_REPLACMENT = ':host([dir="$2"]) $1';
  const DIR_CHECK = /:dir\((?:ltr|rtl)\)/;
  const SHIM_SHADOW = Boolean(window['ShadyDOM'] && window['ShadyDOM']['inUse']);
  /**
   * @type {!Array<!Polymer_DirMixin>}
   */

  const DIR_INSTANCES = [];
  /** @type {?MutationObserver} */

  let observer = null;
  let documentDir = '';

  function getRTL() {
    documentDir = document.documentElement.getAttribute('dir');
  }
  /**
   * @param {!Polymer_DirMixin} instance Instance to set RTL status on
   */


  function setRTL(instance) {
    if (!instance.__autoDirOptOut) {
      const el =
      /** @type {!HTMLElement} */
      instance;
      el.setAttribute('dir', documentDir);
    }
  }

  function updateDirection() {
    getRTL();
    documentDir = document.documentElement.getAttribute('dir');

    for (let i = 0; i < DIR_INSTANCES.length; i++) {
      setRTL(DIR_INSTANCES[i]);
    }
  }

  function takeRecords() {
    if (observer && observer.takeRecords().length) {
      updateDirection();
    }
  }
  /**
   * Element class mixin that allows elements to use the `:dir` CSS Selector to
   * have text direction specific styling.
   *
   * With this mixin, any stylesheet provided in the template will transform
   * `:dir` into `:host([dir])` and sync direction with the page via the
   * element's `dir` attribute.
   *
   * Elements can opt out of the global page text direction by setting the `dir`
   * attribute directly in `ready()` or in HTML.
   *
   * Caveats:
   * - Applications must set `<html dir="ltr">` or `<html dir="rtl">` to sync
   *   direction
   * - Automatic left-to-right or right-to-left styling is sync'd with the
   *   `<html>` element only.
   * - Changing `dir` at runtime is supported.
   * - Opting out of the global direction styling is permanent
   *
   * @mixinFunction
   * @polymer
   * @appliesMixin PropertyAccessors
   * @template T
   * @param {function(new:T)} superClass Class to apply mixin to.
   * @return {function(new:T)} superClass with mixin applied.
   */


  const DirMixin = dedupingMixin(base => {
    if (!SHIM_SHADOW) {
      if (!observer) {
        getRTL();
        observer = new MutationObserver(updateDirection);
        observer.observe(document.documentElement, {
          attributes: true,
          attributeFilter: ['dir']
        });
      }
    }
    /**
     * @constructor
     * @implements {Polymer_PropertyAccessors}
     * @private
     */


    const elementBase = PropertyAccessors(base);
    /**
     * @polymer
     * @mixinClass
     * @implements {Polymer_DirMixin}
     */

    class Dir extends elementBase {
      /**
       * @param {string} cssText .
       * @param {string} baseURI .
       * @return {string} .
       * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
       * @nocollapse
       */
      static _processStyleText(cssText, baseURI) {
        // TODO(https://github.com/google/closure-compiler/issues/3240):
        //     Change back to just super.methodCall()
        cssText = elementBase._processStyleText.call(this, cssText, baseURI);

        if (!SHIM_SHADOW && DIR_CHECK.test(cssText)) {
          cssText = this._replaceDirInCssText(cssText);
          this.__activateDir = true;
        }

        return cssText;
      }
      /**
       * Replace `:dir` in the given CSS text
       *
       * @param {string} text CSS text to replace DIR
       * @return {string} Modified CSS
       * @nocollapse
       */


      static _replaceDirInCssText(text) {
        let replacedText = text;
        replacedText = replacedText.replace(HOST_DIR, HOST_DIR_REPLACMENT);
        replacedText = replacedText.replace(EL_DIR, EL_DIR_REPLACMENT);
        return replacedText;
      }

      constructor() {
        super();
        /** @type {boolean} */

        this.__autoDirOptOut = false;
      }
      /**
       * @override
       * @suppress {invalidCasts} Closure doesn't understand that `this` is an
       *     HTMLElement
       * @return {void}
       */


      ready() {
        super.ready();
        this.__autoDirOptOut =
        /** @type {!HTMLElement} */
        this.hasAttribute('dir');
      }
      /**
       * @override
       * @suppress {missingProperties} If it exists on elementBase, it can be
       *   super'd
       * @return {void}
       */


      connectedCallback() {
        if (elementBase.prototype.connectedCallback) {
          super.connectedCallback();
        }

        if (this.constructor.__activateDir) {
          takeRecords();
          DIR_INSTANCES.push(this);
          setRTL(this);
        }
      }
      /**
       * @override
       * @suppress {missingProperties} If it exists on elementBase, it can be
       *   super'd
       * @return {void}
       */


      disconnectedCallback() {
        if (elementBase.prototype.disconnectedCallback) {
          super.disconnectedCallback();
        }

        if (this.constructor.__activateDir) {
          const idx = DIR_INSTANCES.indexOf(this);

          if (idx > -1) {
            DIR_INSTANCES.splice(idx, 1);
          }
        }
      }

    }

    Dir.__activateDir = false;
    return Dir;
  });

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  function resolve() {
    document.body.removeAttribute('unresolved');
  }

  if (document.readyState === 'interactive' || document.readyState === 'complete') {
    resolve();
  } else {
    window.addEventListener('DOMContentLoaded', resolve);
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  function newSplice(index, removed, addedCount) {
    return {
      index: index,
      removed: removed,
      addedCount: addedCount
    };
  }

  const EDIT_LEAVE = 0;
  const EDIT_UPDATE = 1;
  const EDIT_ADD = 2;
  const EDIT_DELETE = 3; // Note: This function is *based* on the computation of the Levenshtein
  // "edit" distance. The one change is that "updates" are treated as two
  // edits - not one. With Array splices, an update is really a delete
  // followed by an add. By retaining this, we optimize for "keeping" the
  // maximum array items in the original array. For example:
  //
  //   'xxxx123' -> '123yyyy'
  //
  // With 1-edit updates, the shortest path would be just to update all seven
  // characters. With 2-edit updates, we delete 4, leave 3, and add 4. This
  // leaves the substring '123' intact.

  function calcEditDistances(current, currentStart, currentEnd, old, oldStart, oldEnd) {
    // "Deletion" columns
    let rowCount = oldEnd - oldStart + 1;
    let columnCount = currentEnd - currentStart + 1;
    let distances = new Array(rowCount); // "Addition" rows. Initialize null column.

    for (let i = 0; i < rowCount; i++) {
      distances[i] = new Array(columnCount);
      distances[i][0] = i;
    } // Initialize null row


    for (let j = 0; j < columnCount; j++) distances[0][j] = j;

    for (let i = 1; i < rowCount; i++) {
      for (let j = 1; j < columnCount; j++) {
        if (equals(current[currentStart + j - 1], old[oldStart + i - 1])) distances[i][j] = distances[i - 1][j - 1];else {
          let north = distances[i - 1][j] + 1;
          let west = distances[i][j - 1] + 1;
          distances[i][j] = north < west ? north : west;
        }
      }
    }

    return distances;
  } // This starts at the final weight, and walks "backward" by finding
  // the minimum previous weight recursively until the origin of the weight
  // matrix.


  function spliceOperationsFromEditDistances(distances) {
    let i = distances.length - 1;
    let j = distances[0].length - 1;
    let current = distances[i][j];
    let edits = [];

    while (i > 0 || j > 0) {
      if (i == 0) {
        edits.push(EDIT_ADD);
        j--;
        continue;
      }

      if (j == 0) {
        edits.push(EDIT_DELETE);
        i--;
        continue;
      }

      let northWest = distances[i - 1][j - 1];
      let west = distances[i - 1][j];
      let north = distances[i][j - 1];
      let min;
      if (west < north) min = west < northWest ? west : northWest;else min = north < northWest ? north : northWest;

      if (min == northWest) {
        if (northWest == current) {
          edits.push(EDIT_LEAVE);
        } else {
          edits.push(EDIT_UPDATE);
          current = northWest;
        }

        i--;
        j--;
      } else if (min == west) {
        edits.push(EDIT_DELETE);
        i--;
        current = west;
      } else {
        edits.push(EDIT_ADD);
        j--;
        current = north;
      }
    }

    edits.reverse();
    return edits;
  }
  /**
   * Splice Projection functions:
   *
   * A splice map is a representation of how a previous array of items
   * was transformed into a new array of items. Conceptually it is a list of
   * tuples of
   *
   *   <index, removed, addedCount>
   *
   * which are kept in ascending index order of. The tuple represents that at
   * the |index|, |removed| sequence of items were removed, and counting forward
   * from |index|, |addedCount| items were added.
   */

  /**
   * Lacking individual splice mutation information, the minimal set of
   * splices can be synthesized given the previous state and final state of an
   * array. The basic approach is to calculate the edit distance matrix and
   * choose the shortest path through it.
   *
   * Complexity: O(l * p)
   *   l: The length of the current array
   *   p: The length of the old array
   *
   * @param {!Array} current The current "changed" array for which to
   * calculate splices.
   * @param {number} currentStart Starting index in the `current` array for
   * which splices are calculated.
   * @param {number} currentEnd Ending index in the `current` array for
   * which splices are calculated.
   * @param {!Array} old The original "unchanged" array to compare `current`
   * against to determine splices.
   * @param {number} oldStart Starting index in the `old` array for
   * which splices are calculated.
   * @param {number} oldEnd Ending index in the `old` array for
   * which splices are calculated.
   * @return {!Array} Returns an array of splice record objects. Each of these
   * contains: `index` the location where the splice occurred; `removed`
   * the array of removed items from this location; `addedCount` the number
   * of items added at this location.
   */


  function calcSplices(current, currentStart, currentEnd, old, oldStart, oldEnd) {
    let prefixCount = 0;
    let suffixCount = 0;
    let splice;
    let minLength = Math.min(currentEnd - currentStart, oldEnd - oldStart);
    if (currentStart == 0 && oldStart == 0) prefixCount = sharedPrefix(current, old, minLength);
    if (currentEnd == current.length && oldEnd == old.length) suffixCount = sharedSuffix(current, old, minLength - prefixCount);
    currentStart += prefixCount;
    oldStart += prefixCount;
    currentEnd -= suffixCount;
    oldEnd -= suffixCount;
    if (currentEnd - currentStart == 0 && oldEnd - oldStart == 0) return [];

    if (currentStart == currentEnd) {
      splice = newSplice(currentStart, [], 0);

      while (oldStart < oldEnd) splice.removed.push(old[oldStart++]);

      return [splice];
    } else if (oldStart == oldEnd) return [newSplice(currentStart, [], currentEnd - currentStart)];

    let ops = spliceOperationsFromEditDistances(calcEditDistances(current, currentStart, currentEnd, old, oldStart, oldEnd));
    splice = undefined;
    let splices = [];
    let index = currentStart;
    let oldIndex = oldStart;

    for (let i = 0; i < ops.length; i++) {
      switch (ops[i]) {
        case EDIT_LEAVE:
          if (splice) {
            splices.push(splice);
            splice = undefined;
          }

          index++;
          oldIndex++;
          break;

        case EDIT_UPDATE:
          if (!splice) splice = newSplice(index, [], 0);
          splice.addedCount++;
          index++;
          splice.removed.push(old[oldIndex]);
          oldIndex++;
          break;

        case EDIT_ADD:
          if (!splice) splice = newSplice(index, [], 0);
          splice.addedCount++;
          index++;
          break;

        case EDIT_DELETE:
          if (!splice) splice = newSplice(index, [], 0);
          splice.removed.push(old[oldIndex]);
          oldIndex++;
          break;
      }
    }

    if (splice) {
      splices.push(splice);
    }

    return splices;
  }

  function sharedPrefix(current, old, searchLength) {
    for (let i = 0; i < searchLength; i++) if (!equals(current[i], old[i])) return i;

    return searchLength;
  }

  function sharedSuffix(current, old, searchLength) {
    let index1 = current.length;
    let index2 = old.length;
    let count = 0;

    while (count < searchLength && equals(current[--index1], old[--index2])) count++;

    return count;
  }
  /**
   * Returns an array of splice records indicating the minimum edits required
   * to transform the `previous` array into the `current` array.
   *
   * Splice records are ordered by index and contain the following fields:
   * - `index`: index where edit started
   * - `removed`: array of removed items from this index
   * - `addedCount`: number of items added at this index
   *
   * This function is based on the Levenshtein "minimum edit distance"
   * algorithm. Note that updates are treated as removal followed by addition.
   *
   * The worst-case time complexity of this algorithm is `O(l * p)`
   *   l: The length of the current array
   *   p: The length of the previous array
   *
   * However, the worst-case complexity is reduced by an `O(n)` optimization
   * to detect any shared prefix & suffix between the two arrays and only
   * perform the more expensive minimum edit distance calculation over the
   * non-shared portions of the arrays.
   *
   * @function
   * @param {!Array} current The "changed" array for which splices will be
   * calculated.
   * @param {!Array} previous The "unchanged" original array to compare
   * `current` against to determine the splices.
   * @return {!Array} Returns an array of splice record objects. Each of these
   * contains: `index` the location where the splice occurred; `removed`
   * the array of removed items from this location; `addedCount` the number
   * of items added at this location.
   */


  function calculateSplices(current, previous) {
    return calcSplices(current, 0, current.length, previous, 0, previous.length);
  }

  function equals(currentValue, previousValue) {
    return currentValue === previousValue;
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * Returns true if `node` is a slot element
   * @param {!Node} node Node to test.
   * @return {boolean} Returns true if the given `node` is a slot
   * @private
   */

  function isSlot(node) {
    return node.localName === 'slot';
  }
  /**
   * Class that listens for changes (additions or removals) to
   * "flattened nodes" on a given `node`. The list of flattened nodes consists
   * of a node's children and, for any children that are `<slot>` elements,
   * the expanded flattened list of `assignedNodes`.
   * For example, if the observed node has children `<a></a><slot></slot><b></b>`
   * and the `<slot>` has one `<div>` assigned to it, then the flattened
   * nodes list is `<a></a><div></div><b></b>`. If the `<slot>` has other
   * `<slot>` elements assigned to it, these are flattened as well.
   *
   * The provided `callback` is called whenever any change to this list
   * of flattened nodes occurs, where an addition or removal of a node is
   * considered a change. The `callback` is called with one argument, an object
   * containing an array of any `addedNodes` and `removedNodes`.
   *
   * Note: the callback is called asynchronous to any changes
   * at a microtask checkpoint. This is because observation is performed using
   * `MutationObserver` and the `<slot>` element's `slotchange` event which
   * are asynchronous.
   *
   * An example:
   * ```js
   * class TestSelfObserve extends PolymerElement {
   *   static get is() { return 'test-self-observe';}
   *   connectedCallback() {
   *     super.connectedCallback();
   *     this._observer = new FlattenedNodesObserver(this, (info) => {
   *       this.info = info;
   *     });
   *   }
   *   disconnectedCallback() {
   *     super.disconnectedCallback();
   *     this._observer.disconnect();
   *   }
   * }
   * customElements.define(TestSelfObserve.is, TestSelfObserve);
   * ```
   *
   * @summary Class that listens for changes (additions or removals) to
   * "flattened nodes" on a given `node`.
   * @implements {PolymerDomApi.ObserveHandle}
   */


  let FlattenedNodesObserver = class {
    /**
     * Returns the list of flattened nodes for the given `node`.
     * This list consists of a node's children and, for any children
     * that are `<slot>` elements, the expanded flattened list of `assignedNodes`.
     * For example, if the observed node has children `<a></a><slot></slot><b></b>`
     * and the `<slot>` has one `<div>` assigned to it, then the flattened
     * nodes list is `<a></a><div></div><b></b>`. If the `<slot>` has other
     * `<slot>` elements assigned to it, these are flattened as well.
     *
     * @param {!HTMLElement|!HTMLSlotElement} node The node for which to
     *      return the list of flattened nodes.
     * @return {!Array<!Node>} The list of flattened nodes for the given `node`.
     * @nocollapse See https://github.com/google/closure-compiler/issues/2763
     */
    // eslint-disable-next-line
    static getFlattenedNodes(node) {
      const wrapped = wrap$1(node);

      if (isSlot(node)) {
        node =
        /** @type {!HTMLSlotElement} */
        node; // eslint-disable-line no-self-assign

        return wrapped.assignedNodes({
          flatten: true
        });
      } else {
        return Array.from(wrapped.childNodes).map(node => {
          if (isSlot(node)) {
            node =
            /** @type {!HTMLSlotElement} */
            node; // eslint-disable-line no-self-assign

            return wrap$1(node).assignedNodes({
              flatten: true
            });
          } else {
            return [node];
          }
        }).reduce((a, b) => a.concat(b), []);
      }
    }
    /**
     * @param {!HTMLElement} target Node on which to listen for changes.
     * @param {?function(this: Element, { target: !HTMLElement, addedNodes: !Array<!Element>, removedNodes: !Array<!Element> }):void} callback Function called when there are additions
     * or removals from the target's list of flattened nodes.
     */
    // eslint-disable-next-line


    constructor(target, callback) {
      /**
       * @type {MutationObserver}
       * @private
       */
      this._shadyChildrenObserver = null;
      /**
       * @type {MutationObserver}
       * @private
       */

      this._nativeChildrenObserver = null;
      this._connected = false;
      /**
       * @type {!HTMLElement}
       * @private
       */

      this._target = target;
      this.callback = callback;
      this._effectiveNodes = [];
      this._observer = null;
      this._scheduled = false;
      /**
       * @type {function()}
       * @private
       */

      this._boundSchedule = () => {
        this._schedule();
      };

      this.connect();

      this._schedule();
    }
    /**
     * Activates an observer. This method is automatically called when
     * a `FlattenedNodesObserver` is created. It should only be called to
     * re-activate an observer that has been deactivated via the `disconnect` method.
     *
     * @return {void}
     */


    connect() {
      if (isSlot(this._target)) {
        this._listenSlots([this._target]);
      } else if (wrap$1(this._target).children) {
        this._listenSlots(
        /** @type {!NodeList<!Node>} */
        wrap$1(this._target).children);

        if (window.ShadyDOM) {
          this._shadyChildrenObserver = window.ShadyDOM.observeChildren(this._target, mutations => {
            this._processMutations(mutations);
          });
        } else {
          this._nativeChildrenObserver = new MutationObserver(mutations => {
            this._processMutations(mutations);
          });

          this._nativeChildrenObserver.observe(this._target, {
            childList: true
          });
        }
      }

      this._connected = true;
    }
    /**
     * Deactivates the flattened nodes observer. After calling this method
     * the observer callback will not be called when changes to flattened nodes
     * occur. The `connect` method may be subsequently called to reactivate
     * the observer.
     *
     * @return {void}
     * @override
     */


    disconnect() {
      if (isSlot(this._target)) {
        this._unlistenSlots([this._target]);
      } else if (wrap$1(this._target).children) {
        this._unlistenSlots(
        /** @type {!NodeList<!Node>} */
        wrap$1(this._target).children);

        if (window.ShadyDOM && this._shadyChildrenObserver) {
          window.ShadyDOM.unobserveChildren(this._shadyChildrenObserver);
          this._shadyChildrenObserver = null;
        } else if (this._nativeChildrenObserver) {
          this._nativeChildrenObserver.disconnect();

          this._nativeChildrenObserver = null;
        }
      }

      this._connected = false;
    }
    /**
     * @return {void}
     * @private
     */


    _schedule() {
      if (!this._scheduled) {
        this._scheduled = true;
        microTask.run(() => this.flush());
      }
    }
    /**
     * @param {Array<MutationRecord>} mutations Mutations signaled by the mutation observer
     * @return {void}
     * @private
     */


    _processMutations(mutations) {
      this._processSlotMutations(mutations);

      this.flush();
    }
    /**
     * @param {Array<MutationRecord>} mutations Mutations signaled by the mutation observer
     * @return {void}
     * @private
     */


    _processSlotMutations(mutations) {
      if (mutations) {
        for (let i = 0; i < mutations.length; i++) {
          let mutation = mutations[i];

          if (mutation.addedNodes) {
            this._listenSlots(mutation.addedNodes);
          }

          if (mutation.removedNodes) {
            this._unlistenSlots(mutation.removedNodes);
          }
        }
      }
    }
    /**
     * Flushes the observer causing any pending changes to be immediately
     * delivered the observer callback. By default these changes are delivered
     * asynchronously at the next microtask checkpoint.
     *
     * @return {boolean} Returns true if any pending changes caused the observer
     * callback to run.
     */


    flush() {
      if (!this._connected) {
        return false;
      }

      if (window.ShadyDOM) {
        ShadyDOM.flush();
      }

      if (this._nativeChildrenObserver) {
        this._processSlotMutations(this._nativeChildrenObserver.takeRecords());
      } else if (this._shadyChildrenObserver) {
        this._processSlotMutations(this._shadyChildrenObserver.takeRecords());
      }

      this._scheduled = false;
      let info = {
        target: this._target,
        addedNodes: [],
        removedNodes: []
      };
      let newNodes = this.constructor.getFlattenedNodes(this._target);
      let splices = calculateSplices(newNodes, this._effectiveNodes); // process removals

      for (let i = 0, s; i < splices.length && (s = splices[i]); i++) {
        for (let j = 0, n; j < s.removed.length && (n = s.removed[j]); j++) {
          info.removedNodes.push(n);
        }
      } // process adds


      for (let i = 0, s; i < splices.length && (s = splices[i]); i++) {
        for (let j = s.index; j < s.index + s.addedCount; j++) {
          info.addedNodes.push(newNodes[j]);
        }
      } // update cache


      this._effectiveNodes = newNodes;
      let didFlush = false;

      if (info.addedNodes.length || info.removedNodes.length) {
        didFlush = true;
        this.callback.call(this._target, info);
      }

      return didFlush;
    }
    /**
     * @param {!Array<!Node>|!NodeList<!Node>} nodeList Nodes that could change
     * @return {void}
     * @private
     */


    _listenSlots(nodeList) {
      for (let i = 0; i < nodeList.length; i++) {
        let n = nodeList[i];

        if (isSlot(n)) {
          n.addEventListener('slotchange', this._boundSchedule);
        }
      }
    }
    /**
     * @param {!Array<!Node>|!NodeList<!Node>} nodeList Nodes that could change
     * @return {void}
     * @private
     */


    _unlistenSlots(nodeList) {
      for (let i = 0; i < nodeList.length; i++) {
        let n = nodeList[i];

        if (isSlot(n)) {
          n.removeEventListener('slotchange', this._boundSchedule);
        }
      }
    }

  };

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * Forces several classes of asynchronously queued tasks to flush:
   * - Debouncers added via `enqueueDebouncer`
   * - ShadyDOM distribution
   *
   * @return {void}
   */

  const flush = function () {
    let shadyDOM, debouncers;

    do {
      shadyDOM = window.ShadyDOM && ShadyDOM.flush();

      if (window.ShadyCSS && window.ShadyCSS.ScopingShim) {
        window.ShadyCSS.ScopingShim.flush();
      }

      debouncers = flushDebouncers();
    } while (shadyDOM || debouncers);
  };

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  /* eslint-enable no-unused-vars */

  const p = Element.prototype;
  /**
   * @const {function(this:Node, string): boolean}
   */

  const normalizedMatchesSelector = p.matches || p.matchesSelector || p.mozMatchesSelector || p.msMatchesSelector || p.oMatchesSelector || p.webkitMatchesSelector;
  /**
   * Cross-platform `element.matches` shim.
   *
   * @function matchesSelector
   * @param {!Node} node Node to check selector against
   * @param {string} selector Selector to match
   * @return {boolean} True if node matched selector
   */

  const matchesSelector = function (node, selector) {
    return normalizedMatchesSelector.call(node, selector);
  };
  /**
   * Node API wrapper class returned from `Polymer.dom.(target)` when
   * `target` is a `Node`.
   * @implements {PolymerDomApi}
   * @unrestricted
   */

  class DomApiNative {
    /**
     * @param {!Node} node Node for which to create a Polymer.dom helper object.
     */
    constructor(node) {
      if (window['ShadyDOM'] && window['ShadyDOM']['inUse']) {
        window['ShadyDOM']['patch'](node);
      }

      this.node = node;
    }
    /**
     * Returns an instance of `FlattenedNodesObserver` that
     * listens for node changes on this element.
     *
     * @param {function(this:HTMLElement, { target: !HTMLElement, addedNodes: !Array<!Element>, removedNodes: !Array<!Element> }):void} callback Called when direct or distributed children
     *   of this element changes
     * @return {!PolymerDomApi.ObserveHandle} Observer instance
     * @override
     */


    observeNodes(callback) {
      return new FlattenedNodesObserver(
      /** @type {!HTMLElement} */
      this.node, callback);
    }
    /**
     * Disconnects an observer previously created via `observeNodes`
     *
     * @param {!PolymerDomApi.ObserveHandle} observerHandle Observer instance
     *   to disconnect.
     * @return {void}
     * @override
     */


    unobserveNodes(observerHandle) {
      observerHandle.disconnect();
    }
    /**
     * Provided as a backwards-compatible API only.  This method does nothing.
     * @return {void}
     */


    notifyObserver() {}
    /**
     * Returns true if the provided node is contained with this element's
     * light-DOM children or shadow root, including any nested shadow roots
     * of children therein.
     *
     * @param {Node} node Node to test
     * @return {boolean} Returns true if the given `node` is contained within
     *   this element's light or shadow DOM.
     * @override
     */


    deepContains(node) {
      if (wrap$1(this.node).contains(node)) {
        return true;
      }

      let n = node;
      let doc = node.ownerDocument; // walk from node to `this` or `document`

      while (n && n !== doc && n !== this.node) {
        // use logical parentnode, or native ShadowRoot host
        n = wrap$1(n).parentNode || wrap$1(n).host;
      }

      return n === this.node;
    }
    /**
     * Returns the root node of this node.  Equivalent to `getRootNode()`.
     *
     * @return {!Node} Top most element in the dom tree in which the node
     * exists. If the node is connected to a document this is either a
     * shadowRoot or the document; otherwise, it may be the node
     * itself or a node or document fragment containing it.
     * @override
     */


    getOwnerRoot() {
      return wrap$1(this.node).getRootNode();
    }
    /**
     * For slot elements, returns the nodes assigned to the slot; otherwise
     * an empty array. It is equivalent to `<slot>.addignedNodes({flatten:true})`.
     *
     * @return {!Array<!Node>} Array of assigned nodes
     * @override
     */


    getDistributedNodes() {
      return this.node.localName === 'slot' ? wrap$1(this.node).assignedNodes({
        flatten: true
      }) : [];
    }
    /**
     * Returns an array of all slots this element was distributed to.
     *
     * @return {!Array<!HTMLSlotElement>} Description
     * @override
     */


    getDestinationInsertionPoints() {
      let ip$ = [];
      let n = wrap$1(this.node).assignedSlot;

      while (n) {
        ip$.push(n);
        n = wrap$1(n).assignedSlot;
      }

      return ip$;
    }
    /**
     * Calls `importNode` on the `ownerDocument` for this node.
     *
     * @param {!Node} node Node to import
     * @param {boolean} deep True if the node should be cloned deeply during
     *   import
     * @return {Node} Clone of given node imported to this owner document
     */


    importNode(node, deep) {
      let doc = this.node instanceof Document ? this.node : this.node.ownerDocument;
      return wrap$1(doc).importNode(node, deep);
    }
    /**
     * @return {!Array<!Node>} Returns a flattened list of all child nodes and
     * nodes assigned to child slots.
     * @override
     */


    getEffectiveChildNodes() {
      return FlattenedNodesObserver.getFlattenedNodes(
      /** @type {!HTMLElement} */
      this.node);
    }
    /**
     * Returns a filtered list of flattened child elements for this element based
     * on the given selector.
     *
     * @param {string} selector Selector to filter nodes against
     * @return {!Array<!HTMLElement>} List of flattened child elements
     * @override
     */


    queryDistributedElements(selector) {
      let c$ = this.getEffectiveChildNodes();
      let list = [];

      for (let i = 0, l = c$.length, c; i < l && (c = c$[i]); i++) {
        if (c.nodeType === Node.ELEMENT_NODE && matchesSelector(c, selector)) {
          list.push(c);
        }
      }

      return list;
    }
    /**
     * For shadow roots, returns the currently focused element within this
     * shadow root.
     *
     * return {Node|undefined} Currently focused element
     * @override
     */


    get activeElement() {
      let node = this.node;
      return node._activeElement !== undefined ? node._activeElement : node.activeElement;
    }

  }

  function forwardMethods(proto, methods) {
    for (let i = 0; i < methods.length; i++) {
      let method = methods[i];
      /* eslint-disable valid-jsdoc */

      proto[method] =
      /** @this {DomApiNative} */
      function () {
        return this.node[method].apply(this.node, arguments);
      };
      /* eslint-enable */

    }
  }

  function forwardReadOnlyProperties(proto, properties) {
    for (let i = 0; i < properties.length; i++) {
      let name = properties[i];
      Object.defineProperty(proto, name, {
        get: function () {
          const domApi =
          /** @type {DomApiNative} */
          this;
          return domApi.node[name];
        },
        configurable: true
      });
    }
  }

  function forwardProperties(proto, properties) {
    for (let i = 0; i < properties.length; i++) {
      let name = properties[i];
      Object.defineProperty(proto, name, {
        /**
         * @this {DomApiNative}
         * @return {*} .
         */
        get: function () {
          return this.node[name];
        },

        /**
         * @this {DomApiNative}
         * @param {*} value .
         */
        set: function (value) {
          this.node[name] = value;
        },
        configurable: true
      });
    }
  }
  /**
   * Event API wrapper class returned from `dom.(target)` when
   * `target` is an `Event`.
   */


  class EventApi {
    constructor(event) {
      this.event = event;
    }
    /**
     * Returns the first node on the `composedPath` of this event.
     *
     * @return {!EventTarget} The node this event was dispatched to
     */


    get rootTarget() {
      return this.path[0];
    }
    /**
     * Returns the local (re-targeted) target for this event.
     *
     * @return {!EventTarget} The local (re-targeted) target for this event.
     */


    get localTarget() {
      return this.event.target;
    }
    /**
     * Returns the `composedPath` for this event.
     * @return {!Array<!EventTarget>} The nodes this event propagated through
     */


    get path() {
      return this.event.composedPath();
    }

  }
  let DomApiImpl = DomApiNative;

  if (window['ShadyDOM'] && window['ShadyDOM']['inUse'] && window['ShadyDOM']['noPatch'] && window['ShadyDOM']['Wrapper']) {
    /**
     * @private
     * @extends {HTMLElement}
     */
    class Wrapper extends window['ShadyDOM']['Wrapper'] {} // copy bespoke API onto wrapper


    Object.getOwnPropertyNames(DomApiNative.prototype).forEach(prop => {
      if (prop != 'activeElement') {
        Wrapper.prototype[prop] = DomApiNative.prototype[prop];
      }
    }); // Note, `classList` is here only for legacy compatibility since it does not
    // trigger distribution in v1 Shadow DOM.

    forwardReadOnlyProperties(Wrapper.prototype, ['classList']);
    DomApiImpl = Wrapper;
    Object.defineProperties(EventApi.prototype, {
      // Returns the "lowest" node in the same root as the event's currentTarget.
      // When in `noPatch` mode, this must be calculated by walking the event's
      // path.
      localTarget: {
        get() {
          const current = this.event.currentTarget;
          const currentRoot = current && dom(current).getOwnerRoot();
          const p$ = this.path;

          for (let i = 0; i < p$.length; i++) {
            const e = p$[i];

            if (dom(e).getOwnerRoot() === currentRoot) {
              return e;
            }
          }
        },

        configurable: true
      },
      path: {
        get() {
          return window['ShadyDOM']['composedPath'](this.event);
        },

        configurable: true
      }
    });
  } else {
    // Methods that can provoke distribution or must return the logical, not
    // composed tree.
    forwardMethods(DomApiNative.prototype, ['cloneNode', 'appendChild', 'insertBefore', 'removeChild', 'replaceChild', 'setAttribute', 'removeAttribute', 'querySelector', 'querySelectorAll']); // Properties that should return the logical, not composed tree. Note, `classList`
    // is here only for legacy compatibility since it does not trigger distribution
    // in v1 Shadow DOM.

    forwardReadOnlyProperties(DomApiNative.prototype, ['parentNode', 'firstChild', 'lastChild', 'nextSibling', 'previousSibling', 'firstElementChild', 'lastElementChild', 'nextElementSibling', 'previousElementSibling', 'childNodes', 'children', 'classList']);
    forwardProperties(DomApiNative.prototype, ['textContent', 'innerHTML', 'className']);
  }
  /**
   * Legacy DOM and Event manipulation API wrapper factory used to abstract
   * differences between native Shadow DOM and "Shady DOM" when polyfilling on
   * older browsers.
   *
   * Note that in Polymer 2.x use of `Polymer.dom` is no longer required and
   * in the majority of cases simply facades directly to the standard native
   * API.
   *
   * @summary Legacy DOM and Event manipulation API wrapper factory used to
   * abstract differences between native Shadow DOM and "Shady DOM."
   * @param {(Node|Event|DomApiNative|EventApi)=} obj Node or event to operate on
   * @return {!DomApiNative|!EventApi} Wrapper providing either node API or event API
   */

  const dom = function (obj) {
    obj = obj || document;

    if (obj instanceof DomApiImpl) {
      return (
        /** @type {!DomApi} */
        obj
      );
    }

    if (obj instanceof EventApi) {
      return (
        /** @type {!EventApi} */
        obj
      );
    }

    let helper = obj['__domApi'];

    if (!helper) {
      if (obj instanceof Event) {
        helper = new EventApi(obj);
      } else {
        helper = new DomApiImpl(
        /** @type {Node} */
        obj);
      }

      obj['__domApi'] = helper;
    }

    return helper;
  };

  /**
  @license
  Copyright (c) 2019 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  const ShadyDOM$1 = window.ShadyDOM;
  const ShadyCSS = window.ShadyCSS;
  /**
   * Return true if node scope is correct.
   *
   * @param {!Element} node Node to check scope
   * @param {!Node} scope Scope reference
   * @return {boolean} True if node is in scope
   */

  function sameScope(node, scope) {
    return wrap$1(node).getRootNode() === scope;
  }
  /**
   * Ensure that elements in a ShadowDOM container are scoped correctly.
   * This function is only needed when ShadyDOM is used and unpatched DOM APIs are used in third party code.
   * This can happen in noPatch mode or when specialized APIs like ranges or tables are used to mutate DOM.
   *
   * @param  {!Element} container Container element to scope
   * @param  {boolean=} shouldObserve if true, start a mutation observer for added nodes to the container
   * @return {?MutationObserver} Returns a new MutationObserver on `container` if `shouldObserve` is true.
   */


  function scopeSubtree(container, shouldObserve = false) {
    // If using native ShadowDOM, abort
    if (!ShadyDOM$1 || !ShadyCSS) {
      return null;
    } // ShadyCSS handles DOM mutations when ShadyDOM does not handle scoping itself


    if (!ShadyDOM$1['handlesDynamicScoping']) {
      return null;
    }

    const ScopingShim = ShadyCSS['ScopingShim']; // if ScopingShim is not available, abort

    if (!ScopingShim) {
      return null;
    } // capture correct scope for container


    const containerScope = ScopingShim['scopeForNode'](container);
    const root = wrap$1(container).getRootNode();

    const scopify = node => {
      if (!sameScope(node, root)) {
        return;
      } // NOTE: native qSA does not honor scoped DOM, but it is faster, and the same behavior as Polymer v1


      const elements = Array.from(ShadyDOM$1['nativeMethods']['querySelectorAll'].call(node, '*'));
      elements.push(node);

      for (let i = 0; i < elements.length; i++) {
        const el = elements[i];

        if (!sameScope(el, root)) {
          continue;
        }

        const currentScope = ScopingShim['currentScopeForNode'](el);

        if (currentScope !== containerScope) {
          if (currentScope !== '') {
            ScopingShim['unscopeNode'](el, currentScope);
          }

          ScopingShim['scopeNode'](el, containerScope);
        }
      }
    }; // scope everything in container


    scopify(container);

    if (shouldObserve) {
      const mo = new MutationObserver(mxns => {
        for (let i = 0; i < mxns.length; i++) {
          const mxn = mxns[i];

          for (let j = 0; j < mxn.addedNodes.length; j++) {
            const addedNode = mxn.addedNodes[j];

            if (addedNode.nodeType === Node.ELEMENT_NODE) {
              scopify(addedNode);
            }
          }
        }
      });
      mo.observe(container, {
        childList: true,
        subtree: true
      });
      return mo;
    } else {
      return null;
    }
  }

  /**
   * @fileoverview
   * @suppress {checkPrototypalTypes}
   * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
   * This code may only be used under the BSD style license found at
   * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
   * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
   * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
   * Google as part of the polymer project is also subject to an additional IP
   * rights grant found at http://polymer.github.io/PATENTS.txt
   */
  const DISABLED_ATTR = 'disable-upgrade';
  const findObservedAttributesGetter = ctor => {
    while (ctor) {
      const desc = Object.getOwnPropertyDescriptor(ctor, 'observedAttributes');

      if (desc) {
        return desc.get;
      }

      ctor = Object.getPrototypeOf(ctor.prototype).constructor;
    }

    return () => [];
  };
  /**
   * Element class mixin that allows the element to boot up in a non-enabled
   * state when the `disable-upgrade` attribute is present. This mixin is
   * designed to be used with element classes like PolymerElement that perform
   * initial startup work when they are first connected. When the
   * `disable-upgrade` attribute is removed, if the element is connected, it
   * boots up and "enables" as it otherwise would; if it is not connected, the
   * element boots up when it is next connected.
   *
   * Using `disable-upgrade` with PolymerElement prevents any data propagation
   * to the element, any element DOM from stamping, or any work done in
   * connected/disconnctedCallback from occuring, but it does not prevent work
   * done in the element constructor.
   *
   * Note, this mixin must be applied on top of any element class that
   * itself implements a `connectedCallback` so that it can control the work
   * done in `connectedCallback`. For example,
   *
   *     MyClass = DisableUpgradeMixin(class extends BaseClass {...});
   *
   * @mixinFunction
   * @polymer
   * @appliesMixin ElementMixin
   * @template T
   * @param {function(new:T)} superClass Class to apply mixin to.
   * @return {function(new:T)} superClass with mixin applied.
   */

  const DisableUpgradeMixin = dedupingMixin(base => {
    /**
     * @constructor
     * @implements {Polymer_ElementMixin}
     * @extends {HTMLElement}
     * @private
     */
    const superClass = ElementMixin(base); // Work around for closure bug #126934458. Using `super` in a property
    // getter does not work so instead we search the Base prototype for an
    // implementation of observedAttributes so that we can override and call
    // the `super` getter. Note, this is done one time ever because we assume
    // that `Base` is always comes from `Polymer.LegacyElementMixn`.

    let observedAttributesGetter = findObservedAttributesGetter(superClass);
    /**
     * @polymer
     * @mixinClass
     * @implements {Polymer_DisableUpgradeMixin}
     */

    class DisableUpgradeClass extends superClass {
      constructor() {
        super();
        /** @type {boolean|undefined} */

        this.__isUpgradeDisabled;
      }

      static get observedAttributes() {
        return observedAttributesGetter.call(this).concat(DISABLED_ATTR);
      } // Prevent element from initializing properties when it's upgrade disabled.

      /** @override */


      _initializeProperties() {
        if (this.hasAttribute(DISABLED_ATTR)) {
          this.__isUpgradeDisabled = true;
        } else {
          super._initializeProperties();
        }
      } // Prevent element from enabling properties when it's upgrade disabled.
      // Normally overriding connectedCallback would be enough, but dom-* elements

      /** @override */


      _enableProperties() {
        if (!this.__isUpgradeDisabled) {
          super._enableProperties();
        }
      } // If the element starts upgrade-disabled and a property is set for
      // which an accessor exists, the default should not be applied.
      // This additional check is needed because defaults are applied via
      // `_initializeProperties` which is called after initial properties
      // have been set when the element starts upgrade-disabled.

      /** @override */


      _canApplyPropertyDefault(property) {
        return super._canApplyPropertyDefault(property) && !(this.__isUpgradeDisabled && this._isPropertyPending(property));
      }
      /**
       * @override
       * @param {string} name Attribute name.
       * @param {?string} old The previous value for the attribute.
       * @param {?string} value The new value for the attribute.
       * @param {?string} namespace The XML namespace for the attribute.
       * @return {void}
       */


      attributeChangedCallback(name, old, value, namespace) {
        if (name == DISABLED_ATTR) {
          // When disable-upgrade is removed, intialize properties and
          // provoke connectedCallback if the element is already connected.
          if (this.__isUpgradeDisabled && value == null) {
            super._initializeProperties();

            this.__isUpgradeDisabled = false;

            if (wrap$1(this).isConnected) {
              super.connectedCallback();
            }
          }
        } else {
          super.attributeChangedCallback(name, old, value,
          /** @type {null|string} */
          namespace);
        }
      } // Prevent element from connecting when it's upgrade disabled.
      // This prevents user code in `attached` from being called.

      /** @override */


      connectedCallback() {
        if (!this.__isUpgradeDisabled) {
          super.connectedCallback();
        }
      } // Prevent element from disconnecting when it's upgrade disabled.
      // This avoids allowing user code `detached` from being called without a
      // paired call to `attached`.

      /** @override */


      disconnectedCallback() {
        if (!this.__isUpgradeDisabled) {
          super.disconnectedCallback();
        }
      }

    }

    return DisableUpgradeClass;
  });

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  const DISABLED_ATTR$1 = 'disable-upgrade';
  let styleInterface = window.ShadyCSS;
  /**
   * Element class mixin that provides Polymer's "legacy" API intended to be
   * backward-compatible to the greatest extent possible with the API
   * found on the Polymer 1.x `Polymer.Base` prototype applied to all elements
   * defined using the `Polymer({...})` function.
   *
   * @mixinFunction
   * @polymer
   * @appliesMixin ElementMixin
   * @appliesMixin GestureEventListeners
   * @appliesMixin DirMixin
   * @property isAttached {boolean} Set to `true` in this element's
   *   `connectedCallback` and `false` in `disconnectedCallback`
   * @summary Element class mixin that provides Polymer's "legacy" API
   */

  const LegacyElementMixin = dedupingMixin(base => {
    // TODO(kschaaf): Note, the `@implements {Polymer_DirMixin}` is required here
    // (rather than on legacyElementBase) for unknown reasons.

    /**
     * @constructor
     * @implements {Polymer_ElementMixin}
     * @implements {Polymer_GestureEventListeners}
     * @implements {Polymer_DirMixin}
     * @extends {HTMLElement}
     * @private
     */
    const GesturesElement = GestureEventListeners(ElementMixin(base)); // Note, the DirMixin does nothing if css is built so avoid including it
    // in that case.

    /**
     * @constructor
     * @extends {GesturesElement}
     * @private
     */

    const legacyElementBase = builtCSS ? GesturesElement : DirMixin(GesturesElement);
    const observedAttributesGetter = findObservedAttributesGetter(legacyElementBase);
    /**
     * Map of simple names to touch action names
     * @dict
     */

    const DIRECTION_MAP = {
      'x': 'pan-x',
      'y': 'pan-y',
      'none': 'none',
      'all': 'auto'
    };
    /**
     * @polymer
     * @mixinClass
     * @extends {legacyElementBase}
     * @implements {Polymer_LegacyElementMixin}
     * @unrestricted
     */

    class LegacyElement extends legacyElementBase {
      constructor() {
        super();
        /** @type {boolean} */

        this.isAttached;
        /** @type {?WeakMap<!Element, !Object<string, !Function>>} */

        this.__boundListeners;
        /** @type {?Object<string, ?Function>} */

        this._debouncers; // NOTE: Inlined for perf from version of DisableUpgradeMixin.

        /** @type {boolean|undefined} */

        this.__isUpgradeDisabled;
        /** @type {boolean|undefined} */

        this.__needsAttributesAtConnected;
        /** @type {boolean|undefined} */

        this._legacyForceObservedAttributes;
      }
      /**
       * Forwards `importMeta` from the prototype (i.e. from the info object
       * passed to `Polymer({...})`) to the static API.
       *
       * @return {!Object} The `import.meta` object set on the prototype
       * @suppress {missingProperties} `this` is always in the instance in
       *  closure for some reason even in a static method, rather than the class
       * @nocollapse
       */


      static get importMeta() {
        return this.prototype.importMeta;
      }
      /**
       * Legacy callback called during the `constructor`, for overriding
       * by the user.
       * @override
       * @return {void}
       */


      created() {}
      /**
       * Processes an attribute reaction when the `legacyNoObservedAttributes`
       * setting is in use.
       * @param {string} name Name of attribute that changed
       * @param {?string} old Old attribute value
       * @param {?string} value New attribute value
       * @return {void}
       */


      __attributeReaction(name, old, value) {
        if (this.__dataAttributes && this.__dataAttributes[name] || name === DISABLED_ATTR$1) {
          this.attributeChangedCallback(name, old, value, null);
        }
      }
      /**
       * Sets the value of an attribute.
       * @override
       * @param {string} name The name of the attribute to change.
       * @param {string|number|boolean|!TrustedHTML|!TrustedScriptURL|!TrustedURL} value The new attribute value.
       */


      setAttribute(name, value) {
        if (legacyNoObservedAttributes && !this._legacyForceObservedAttributes) {
          const oldValue = this.getAttribute(name);
          super.setAttribute(name, value); // value coerced to String for closure's benefit

          this.__attributeReaction(name, oldValue, String(value));
        } else {
          super.setAttribute(name, value);
        }
      }
      /**
       * Removes an attribute.
       * @override
       * @param {string} name The name of the attribute to remove.
       */


      removeAttribute(name) {
        if (legacyNoObservedAttributes && !this._legacyForceObservedAttributes) {
          const oldValue = this.getAttribute(name);
          super.removeAttribute(name);

          this.__attributeReaction(name, oldValue, null);
        } else {
          super.removeAttribute(name);
        }
      } // NOTE: Inlined for perf from version of DisableUpgradeMixin.


      static get observedAttributes() {
        if (legacyNoObservedAttributes && !this.prototype._legacyForceObservedAttributes) {
          // Ensure this element is property registered with the telemetry system.
          if (!this.hasOwnProperty(JSCompiler_renameProperty('__observedAttributes', this))) {
            this.__observedAttributes = [];
            register(this.prototype);
          }

          return this.__observedAttributes;
        } else {
          return observedAttributesGetter.call(this).concat(DISABLED_ATTR$1);
        }
      } // NOTE: Inlined for perf from version of DisableUpgradeMixin.
      // Prevent element from enabling properties when it's upgrade disabled.
      // Normally overriding connectedCallback would be enough, but dom-* elements

      /** @override */


      _enableProperties() {
        if (!this.__isUpgradeDisabled) {
          super._enableProperties();
        }
      } // NOTE: Inlined for perf from version of DisableUpgradeMixin.
      // If the element starts upgrade-disabled and a property is set for
      // which an accessor exists, the default should not be applied.
      // This additional check is needed because defaults are applied via
      // `_initializeProperties` which is called after initial properties
      // have been set when the element starts upgrade-disabled.

      /** @override */


      _canApplyPropertyDefault(property) {
        return super._canApplyPropertyDefault(property) && !(this.__isUpgradeDisabled && this._isPropertyPending(property));
      }
      /**
       * Provides an implementation of `connectedCallback`
       * which adds Polymer legacy API's `attached` method.
       * @return {void}
       * @override
       */


      connectedCallback() {
        if (this.__needsAttributesAtConnected) {
          this._takeAttributes();
        } // NOTE: Inlined for perf from version of DisableUpgradeMixin.


        if (!this.__isUpgradeDisabled) {
          super.connectedCallback();
          this.isAttached = true;
          this.attached();
        }
      }
      /**
       * Legacy callback called during `connectedCallback`, for overriding
       * by the user.
       * @override
       * @return {void}
       */


      attached() {}
      /**
       * Provides an implementation of `disconnectedCallback`
       * which adds Polymer legacy API's `detached` method.
       * @return {void}
       * @override
       */


      disconnectedCallback() {
        // NOTE: Inlined for perf from version of DisableUpgradeMixin.
        if (!this.__isUpgradeDisabled) {
          super.disconnectedCallback();
          this.isAttached = false;
          this.detached();
        }
      }
      /**
       * Legacy callback called during `disconnectedCallback`, for overriding
       * by the user.
       * @override
       * @return {void}
       */


      detached() {}
      /**
       * Provides an override implementation of `attributeChangedCallback`
       * which adds the Polymer legacy API's `attributeChanged` method.
       * @param {string} name Name of attribute.
       * @param {?string} old Old value of attribute.
       * @param {?string} value Current value of attribute.
       * @param {?string} namespace Attribute namespace.
       * @return {void}
       * @override
       */


      attributeChangedCallback(name, old, value, namespace) {
        if (old !== value) {
          // NOTE: Inlined for perf from version of DisableUpgradeMixin.
          if (name == DISABLED_ATTR$1) {
            // When disable-upgrade is removed, intialize properties and
            // provoke connectedCallback if the element is already connected.
            if (this.__isUpgradeDisabled && value == null) {
              this._initializeProperties();

              this.__isUpgradeDisabled = false;

              if (wrap$1(this).isConnected) {
                this.connectedCallback();
              }
            }
          } else {
            super.attributeChangedCallback(name, old, value, namespace);
            this.attributeChanged(name, old, value);
          }
        }
      }
      /**
       * Legacy callback called during `attributeChangedChallback`, for overriding
       * by the user.
       * @param {string} name Name of attribute.
       * @param {?string} old Old value of attribute.
       * @param {?string} value Current value of attribute.
       * @return {void}
       * @override
       */


      attributeChanged(name, old, value) {} // eslint-disable-line no-unused-vars

      /**
       * Overrides the default `Polymer.PropertyEffects` implementation to
       * add support for class initialization via the `_registered` callback.
       * This is called only when the first instance of the element is created.
       *
       * @return {void}
       * @override
       * @suppress {invalidCasts}
       */


      _initializeProperties() {
        // NOTE: Inlined for perf from version of DisableUpgradeMixin.
        // Only auto-use disable-upgrade if legacyOptimizations is set.
        if (legacyOptimizations && this.hasAttribute(DISABLED_ATTR$1)) {
          this.__isUpgradeDisabled = true;
        } else {
          let proto = Object.getPrototypeOf(this);

          if (!proto.hasOwnProperty(JSCompiler_renameProperty('__hasRegisterFinished', proto))) {
            this._registered(); // backstop in case the `_registered` implementation does not set this


            proto.__hasRegisterFinished = true;
          }

          super._initializeProperties();

          this.root =
          /** @type {HTMLElement} */
          this;
          this.created(); // Pull all attribute values 1x if `legacyNoObservedAttributes` is set.

          if (legacyNoObservedAttributes && !this._legacyForceObservedAttributes) {
            if (this.hasAttributes()) {
              this._takeAttributes(); // Element created from scratch or parser generated

            } else if (!this.parentNode) {
              this.__needsAttributesAtConnected = true;
            }
          } // Ensure listeners are applied immediately so that they are
          // added before declarative event listeners. This allows an element to
          // decorate itself via an event prior to any declarative listeners
          // seeing the event. Note, this ensures compatibility with 1.x ordering.


          this._applyListeners();
        }
      }

      _takeAttributes() {
        const a = this.attributes;

        for (let i = 0, l = a.length; i < l; i++) {
          const attr = a[i];

          this.__attributeReaction(attr.name, null, attr.value);
        }
      }
      /**
       * Called automatically when an element is initializing.
       * Users may override this method to perform class registration time
       * work. The implementation should ensure the work is performed
       * only once for the class.
       * @protected
       * @return {void}
       * @override
       */


      _registered() {}
      /**
       * Overrides the default `Polymer.PropertyEffects` implementation to
       * add support for installing `hostAttributes` and `listeners`.
       *
       * @return {void}
       * @override
       */


      ready() {
        this._ensureAttributes();

        super.ready();
      }
      /**
       * Ensures an element has required attributes. Called when the element
       * is being readied via `ready`. Users should override to set the
       * element's required attributes. The implementation should be sure
       * to check and not override existing attributes added by
       * the user of the element. Typically, setting attributes should be left
       * to the element user and not done here; reasonable exceptions include
       * setting aria roles and focusability.
       * @protected
       * @return {void}
       * @override
       */


      _ensureAttributes() {}
      /**
       * Adds element event listeners. Called when the element
       * is being readied via `ready`. Users should override to
       * add any required element event listeners.
       * In performance critical elements, the work done here should be kept
       * to a minimum since it is done before the element is rendered. In
       * these elements, consider adding listeners asynchronously so as not to
       * block render.
       * @protected
       * @return {void}
       * @override
       */


      _applyListeners() {}
      /**
       * Converts a typed JavaScript value to a string.
       *
       * Note this method is provided as backward-compatible legacy API
       * only.  It is not directly called by any Polymer features. To customize
       * how properties are serialized to attributes for attribute bindings and
       * `reflectToAttribute: true` properties as well as this method, override
       * the `_serializeValue` method provided by `Polymer.PropertyAccessors`.
       *
       * @param {*} value Value to deserialize
       * @return {string | undefined} Serialized value
       * @override
       */


      serialize(value) {
        return this._serializeValue(value);
      }
      /**
       * Converts a string to a typed JavaScript value.
       *
       * Note this method is provided as backward-compatible legacy API
       * only.  It is not directly called by any Polymer features.  To customize
       * how attributes are deserialized to properties for in
       * `attributeChangedCallback`, override `_deserializeValue` method
       * provided by `Polymer.PropertyAccessors`.
       *
       * @param {string} value String to deserialize
       * @param {*} type Type to deserialize the string to
       * @return {*} Returns the deserialized value in the `type` given.
       * @override
       */


      deserialize(value, type) {
        return this._deserializeValue(value, type);
      }
      /**
       * Serializes a property to its associated attribute.
       *
       * Note this method is provided as backward-compatible legacy API
       * only.  It is not directly called by any Polymer features.
       *
       * @param {string} property Property name to reflect.
       * @param {string=} attribute Attribute name to reflect.
       * @param {*=} value Property value to reflect.
       * @return {void}
       * @override
       */


      reflectPropertyToAttribute(property, attribute, value) {
        this._propertyToAttribute(property, attribute, value);
      }
      /**
       * Sets a typed value to an HTML attribute on a node.
       *
       * Note this method is provided as backward-compatible legacy API
       * only.  It is not directly called by any Polymer features.
       *
       * @param {*} value Value to serialize.
       * @param {string} attribute Attribute name to serialize to.
       * @param {Element} node Element to set attribute to.
       * @return {void}
       * @override
       */


      serializeValueToAttribute(value, attribute, node) {
        this._valueToNodeAttribute(
        /** @type {Element} */
        node || this, value, attribute);
      }
      /**
       * Copies own properties (including accessor descriptors) from a source
       * object to a target object.
       *
       * @param {Object} prototype Target object to copy properties to.
       * @param {Object} api Source object to copy properties from.
       * @return {Object} prototype object that was passed as first argument.
       * @override
       */


      extend(prototype, api) {
        if (!(prototype && api)) {
          return prototype || api;
        }

        let n$ = Object.getOwnPropertyNames(api);

        for (let i = 0, n; i < n$.length && (n = n$[i]); i++) {
          let pd = Object.getOwnPropertyDescriptor(api, n);

          if (pd) {
            Object.defineProperty(prototype, n, pd);
          }
        }

        return prototype;
      }
      /**
       * Copies props from a source object to a target object.
       *
       * Note, this method uses a simple `for...in` strategy for enumerating
       * properties.  To ensure only `ownProperties` are copied from source
       * to target and that accessor implementations are copied, use `extend`.
       *
       * @param {!Object} target Target object to copy properties to.
       * @param {!Object} source Source object to copy properties from.
       * @return {!Object} Target object that was passed as first argument.
       * @override
       */


      mixin(target, source) {
        for (let i in source) {
          target[i] = source[i];
        }

        return target;
      }
      /**
       * Sets the prototype of an object.
       *
       * Note this method is provided as backward-compatible legacy API
       * only.  It is not directly called by any Polymer features.
       * @param {Object} object The object on which to set the prototype.
       * @param {Object} prototype The prototype that will be set on the given
       * `object`.
       * @return {Object} Returns the given `object` with its prototype set
       * to the given `prototype` object.
       * @override
       */


      chainObject(object, prototype) {
        if (object && prototype && object !== prototype) {
          object.__proto__ = prototype;
        }

        return object;
      }
      /* **** Begin Template **** */

      /**
       * Calls `importNode` on the `content` of the `template` specified and
       * returns a document fragment containing the imported content.
       *
       * @param {HTMLTemplateElement} template HTML template element to instance.
       * @return {!DocumentFragment} Document fragment containing the imported
       *   template content.
       * @override
       * @suppress {missingProperties} go/missingfnprops
       */


      instanceTemplate(template) {
        let content = this.constructor._contentForTemplate(template);

        let dom =
        /** @type {!DocumentFragment} */
        document.importNode(content, true);
        return dom;
      }
      /* **** Begin Events **** */

      /**
       * Dispatches a custom event with an optional detail value.
       *
       * @param {string} type Name of event type.
       * @param {*=} detail Detail value containing event-specific
       *   payload.
       * @param {{ bubbles: (boolean|undefined), cancelable: (boolean|undefined),
       *     composed: (boolean|undefined) }=}
       *  options Object specifying options.  These may include:
       *  `bubbles` (boolean, defaults to `true`),
       *  `cancelable` (boolean, defaults to false), and
       *  `node` on which to fire the event (HTMLElement, defaults to `this`).
       * @return {!Event} The new event that was fired.
       * @override
       */


      fire(type, detail, options) {
        options = options || {};
        detail = detail === null || detail === undefined ? {} : detail;
        let event = new Event(type, {
          bubbles: options.bubbles === undefined ? true : options.bubbles,
          cancelable: Boolean(options.cancelable),
          composed: options.composed === undefined ? true : options.composed
        });
        event.detail = detail;
        let node = options.node || this;
        wrap$1(node).dispatchEvent(event);
        return event;
      }
      /**
       * Convenience method to add an event listener on a given element,
       * late bound to a named method on this element.
       *
       * @param {?EventTarget} node Element to add event listener to.
       * @param {string} eventName Name of event to listen for.
       * @param {string} methodName Name of handler method on `this` to call.
       * @return {void}
       * @override
       */


      listen(node, eventName, methodName) {
        node =
        /** @type {!EventTarget} */
        node || this;
        let hbl = this.__boundListeners || (this.__boundListeners = new WeakMap());
        let bl = hbl.get(node);

        if (!bl) {
          bl = {};
          hbl.set(node, bl);
        }

        let key = eventName + methodName;

        if (!bl[key]) {
          bl[key] = this._addMethodEventListenerToNode(
          /** @type {!Node} */
          node, eventName, methodName, this);
        }
      }
      /**
       * Convenience method to remove an event listener from a given element,
       * late bound to a named method on this element.
       *
       * @param {?EventTarget} node Element to remove event listener from.
       * @param {string} eventName Name of event to stop listening to.
       * @param {string} methodName Name of handler method on `this` to not call
       anymore.
       * @return {void}
       * @override
       */


      unlisten(node, eventName, methodName) {
        node =
        /** @type {!EventTarget} */
        node || this;

        let bl = this.__boundListeners && this.__boundListeners.get(
        /** @type {!Element} */
        node);

        let key = eventName + methodName;
        let handler = bl && bl[key];

        if (handler) {
          this._removeEventListenerFromNode(
          /** @type {!Node} */
          node, eventName, handler);

          bl[key] =
          /** @type {?} */
          null;
        }
      }
      /**
       * Override scrolling behavior to all direction, one direction, or none.
       *
       * Valid scroll directions:
       *   - 'all': scroll in any direction
       *   - 'x': scroll only in the 'x' direction
       *   - 'y': scroll only in the 'y' direction
       *   - 'none': disable scrolling for this node
       *
       * @param {string=} direction Direction to allow scrolling
       * Defaults to `all`.
       * @param {Element=} node Element to apply scroll direction setting.
       * Defaults to `this`.
       * @return {void}
       * @override
       */


      setScrollDirection(direction, node) {
        setTouchAction(
        /** @type {!Element} */
        node || this, DIRECTION_MAP[direction] || 'auto');
      }
      /* **** End Events **** */

      /**
       * Convenience method to run `querySelector` on this local DOM scope.
       *
       * This function calls `Polymer.dom(this.root).querySelector(slctr)`.
       *
       * @param {string} slctr Selector to run on this local DOM scope
       * @return {Element} Element found by the selector, or null if not found.
       * @override
       */


      $$(slctr) {
        // Note, no need to `wrap` this because root is always patched
        return this.root.querySelector(slctr);
      }
      /**
       * Return the element whose local dom within which this element
       * is contained. This is a shorthand for
       * `this.getRootNode().host`.
       * @this {Element}
       * @return {?Node} The element whose local dom within which this element is
       * contained.
       * @override
       */


      get domHost() {
        let root = wrap$1(this).getRootNode();
        return root instanceof DocumentFragment ?
        /** @type {ShadowRoot} */
        root.host : root;
      }
      /**
       * Force this element to distribute its children to its local dom.
       * This should not be necessary as of Polymer 2.0.2 and is provided only
       * for backwards compatibility.
       * @return {void}
       * @override
       */


      distributeContent() {
        const thisEl =
        /** @type {Element} */
        this;
        const domApi =
        /** @type {PolymerDomApi} */
        dom(thisEl);

        if (window.ShadyDOM && domApi.shadowRoot) {
          ShadyDOM.flush();
        }
      }
      /**
       * Returns a list of nodes that are the effective childNodes. The effective
       * childNodes list is the same as the element's childNodes except that
       * any `<content>` elements are replaced with the list of nodes distributed
       * to the `<content>`, the result of its `getDistributedNodes` method.
       * @return {!Array<!Node>} List of effective child nodes.
       * @suppress {invalidCasts} LegacyElementMixin must be applied to an
       *     HTMLElement
       * @override
       */


      getEffectiveChildNodes() {
        const thisEl =
        /** @type {Element} */
        this;
        const domApi =
        /** @type {PolymerDomApi} */
        dom(thisEl);
        return domApi.getEffectiveChildNodes();
      }
      /**
       * Returns a list of nodes distributed within this element that match
       * `selector`. These can be dom children or elements distributed to
       * children that are insertion points.
       * @param {string} selector Selector to run.
       * @return {!Array<!Node>} List of distributed elements that match selector.
       * @suppress {invalidCasts} LegacyElementMixin must be applied to an
       * HTMLElement
       * @override
       */


      queryDistributedElements(selector) {
        const thisEl =
        /** @type {Element} */
        this;
        const domApi =
        /** @type {PolymerDomApi} */
        dom(thisEl);
        return domApi.queryDistributedElements(selector);
      }
      /**
       * Returns a list of elements that are the effective children. The effective
       * children list is the same as the element's children except that
       * any `<content>` elements are replaced with the list of elements
       * distributed to the `<content>`.
       *
       * @return {!Array<!Node>} List of effective children.
       * @override
       */


      getEffectiveChildren() {
        let list = this.getEffectiveChildNodes();
        return list.filter(function (
        /** @type {!Node} */
        n) {
          return n.nodeType === Node.ELEMENT_NODE;
        });
      }
      /**
       * Returns a string of text content that is the concatenation of the
       * text content's of the element's effective childNodes (the elements
       * returned by <a href="#getEffectiveChildNodes>getEffectiveChildNodes</a>.
       *
       * @return {string} List of effective children.
       * @override
       */


      getEffectiveTextContent() {
        let cn = this.getEffectiveChildNodes();
        let tc = [];

        for (let i = 0, c; c = cn[i]; i++) {
          if (c.nodeType !== Node.COMMENT_NODE) {
            tc.push(c.textContent);
          }
        }

        return tc.join('');
      }
      /**
       * Returns the first effective childNode within this element that
       * match `selector`. These can be dom child nodes or elements distributed
       * to children that are insertion points.
       * @param {string} selector Selector to run.
       * @return {Node} First effective child node that matches selector.
       * @override
       */


      queryEffectiveChildren(selector) {
        let e$ = this.queryDistributedElements(selector);
        return e$ && e$[0];
      }
      /**
       * Returns a list of effective childNodes within this element that
       * match `selector`. These can be dom child nodes or elements distributed
       * to children that are insertion points.
       * @param {string} selector Selector to run.
       * @return {!Array<!Node>} List of effective child nodes that match
       *     selector.
       * @override
       */


      queryAllEffectiveChildren(selector) {
        return this.queryDistributedElements(selector);
      }
      /**
       * Returns a list of nodes distributed to this element's `<slot>`.
       *
       * If this element contains more than one `<slot>` in its local DOM,
       * an optional selector may be passed to choose the desired content.
       *
       * @param {string=} slctr CSS selector to choose the desired
       *   `<slot>`.  Defaults to `content`.
       * @return {!Array<!Node>} List of distributed nodes for the `<slot>`.
       * @override
       */


      getContentChildNodes(slctr) {
        // Note, no need to `wrap` this because root is always
        let content = this.root.querySelector(slctr || 'slot');
        return content ?
        /** @type {PolymerDomApi} */
        dom(content).getDistributedNodes() : [];
      }
      /**
       * Returns a list of element children distributed to this element's
       * `<slot>`.
       *
       * If this element contains more than one `<slot>` in its
       * local DOM, an optional selector may be passed to choose the desired
       * content.  This method differs from `getContentChildNodes` in that only
       * elements are returned.
       *
       * @param {string=} slctr CSS selector to choose the desired
       *   `<content>`.  Defaults to `content`.
       * @return {!Array<!HTMLElement>} List of distributed nodes for the
       *   `<slot>`.
       * @suppress {invalidCasts}
       * @override
       */


      getContentChildren(slctr) {
        let children =
        /** @type {!Array<!HTMLElement>} */
        this.getContentChildNodes(slctr).filter(function (n) {
          return n.nodeType === Node.ELEMENT_NODE;
        });
        return children;
      }
      /**
       * Checks whether an element is in this element's light DOM tree.
       *
       * @param {?Node} node The element to be checked.
       * @return {boolean} true if node is in this element's light DOM tree.
       * @suppress {invalidCasts} LegacyElementMixin must be applied to an
       * HTMLElement
       * @override
       */


      isLightDescendant(node) {
        const thisNode =
        /** @type {Node} */
        this;
        return thisNode !== node && wrap$1(thisNode).contains(node) && wrap$1(thisNode).getRootNode() === wrap$1(node).getRootNode();
      }
      /**
       * Checks whether an element is in this element's local DOM tree.
       *
       * @param {!Element} node The element to be checked.
       * @return {boolean} true if node is in this element's local DOM tree.
       * @override
       */


      isLocalDescendant(node) {
        return this.root === wrap$1(node).getRootNode();
      }
      /**
       * No-op for backwards compatibility. This should now be handled by
       * ShadyCss library.
       * @param  {!Element} container Container element to scope
       * @param  {boolean=} shouldObserve if true, start a mutation observer for added nodes to the container
       * @return {?MutationObserver} Returns a new MutationObserver on `container` if `shouldObserve` is true.
       * @override
       */


      scopeSubtree(container, shouldObserve = false) {
        return scopeSubtree(container, shouldObserve);
      }
      /**
       * Returns the computed style value for the given property.
       * @param {string} property The css property name.
       * @return {string} Returns the computed css property value for the given
       * `property`.
       * @suppress {invalidCasts} LegacyElementMixin must be applied to an
       *     HTMLElement
       * @override
       */


      getComputedStyleValue(property) {
        return styleInterface.getComputedStyleValue(
        /** @type {!Element} */
        this, property);
      } // debounce

      /**
       * Call `debounce` to collapse multiple requests for a named task into
       * one invocation which is made after the wait time has elapsed with
       * no new request.  If no wait time is given, the callback will be called
       * at microtask timing (guaranteed before paint).
       *
       *     debouncedClickAction(e) {
       *       // will not call `processClick` more than once per 100ms
       *       this.debounce('click', function() {
       *        this.processClick();
       *       } 100);
       *     }
       *
       * @param {string} jobName String to identify the debounce job.
       * @param {function():void} callback Function that is called (with `this`
       *   context) when the wait time elapses.
       * @param {number=} wait Optional wait time in milliseconds (ms) after the
       *   last signal that must elapse before invoking `callback`
       * @return {!Object} Returns a debouncer object on which exists the
       * following methods: `isActive()` returns true if the debouncer is
       * active; `cancel()` cancels the debouncer if it is active;
       * `flush()` immediately invokes the debounced callback if the debouncer
       * is active.
       * @override
       */


      debounce(jobName, callback, wait) {
        this._debouncers = this._debouncers || {};
        return this._debouncers[jobName] = Debouncer.debounce(this._debouncers[jobName], wait > 0 ? timeOut.after(wait) : microTask, callback.bind(this));
      }
      /**
       * Returns whether a named debouncer is active.
       *
       * @param {string} jobName The name of the debouncer started with `debounce`
       * @return {boolean} Whether the debouncer is active (has not yet fired).
       * @override
       */


      isDebouncerActive(jobName) {
        this._debouncers = this._debouncers || {};
        let debouncer = this._debouncers[jobName];
        return !!(debouncer && debouncer.isActive());
      }
      /**
       * Immediately calls the debouncer `callback` and inactivates it.
       *
       * @param {string} jobName The name of the debouncer started with `debounce`
       * @return {void}
       * @override
       */


      flushDebouncer(jobName) {
        this._debouncers = this._debouncers || {};
        let debouncer = this._debouncers[jobName];

        if (debouncer) {
          debouncer.flush();
        }
      }
      /**
       * Cancels an active debouncer.  The `callback` will not be called.
       *
       * @param {string} jobName The name of the debouncer started with `debounce`
       * @return {void}
       * @override
       */


      cancelDebouncer(jobName) {
        this._debouncers = this._debouncers || {};
        let debouncer = this._debouncers[jobName];

        if (debouncer) {
          debouncer.cancel();
        }
      }
      /**
       * Runs a callback function asynchronously.
       *
       * By default (if no waitTime is specified), async callbacks are run at
       * microtask timing, which will occur before paint.
       *
       * @param {!Function} callback The callback function to run, bound to
       *     `this`.
       * @param {number=} waitTime Time to wait before calling the
       *   `callback`.  If unspecified or 0, the callback will be run at microtask
       *   timing (before paint).
       * @return {number} Handle that may be used to cancel the async job.
       * @override
       */


      async(callback, waitTime) {
        return waitTime > 0 ? timeOut.run(callback.bind(this), waitTime) : ~microTask.run(callback.bind(this));
      }
      /**
       * Cancels an async operation started with `async`.
       *
       * @param {number} handle Handle returned from original `async` call to
       *   cancel.
       * @return {void}
       * @override
       */


      cancelAsync(handle) {
        handle < 0 ? microTask.cancel(~handle) : timeOut.cancel(handle);
      } // other

      /**
       * Convenience method for creating an element and configuring it.
       *
       * @param {string} tag HTML element tag to create.
       * @param {Object=} props Object of properties to configure on the
       *    instance.
       * @return {!Element} Newly created and configured element.
       * @override
       */


      create(tag, props) {
        let elt = document.createElement(tag);

        if (props) {
          if (elt.setProperties) {
            elt.setProperties(props);
          } else {
            for (let n in props) {
              elt[n] = props[n];
            }
          }
        }

        return elt;
      }
      /**
       * Polyfill for Element.prototype.matches, which is sometimes still
       * prefixed.
       *
       * @param {string} selector Selector to test.
       * @param {!Element=} node Element to test the selector against.
       * @return {boolean} Whether the element matches the selector.
       * @override
       */


      elementMatches(selector, node) {
        return matchesSelector(node || this, selector);
      }
      /**
       * Toggles an HTML attribute on or off.
       *
       * @param {string} name HTML attribute name
       * @param {boolean=} bool Boolean to force the attribute on or off.
       *    When unspecified, the state of the attribute will be reversed.
       * @return {boolean} true if the attribute now exists
       * @override
       */


      toggleAttribute(name, bool) {
        let node =
        /** @type {Element} */
        this;

        if (arguments.length === 3) {
          node =
          /** @type {Element} */
          arguments[2];
        }

        if (arguments.length == 1) {
          bool = !node.hasAttribute(name);
        }

        if (bool) {
          wrap$1(node).setAttribute(name, '');
          return true;
        } else {
          wrap$1(node).removeAttribute(name);
          return false;
        }
      }
      /**
       * Toggles a CSS class on or off.
       *
       * @param {string} name CSS class name
       * @param {boolean=} bool Boolean to force the class on or off.
       *    When unspecified, the state of the class will be reversed.
       * @param {Element=} node Node to target.  Defaults to `this`.
       * @return {void}
       * @override
       */


      toggleClass(name, bool, node) {
        node =
        /** @type {Element} */
        node || this;

        if (arguments.length == 1) {
          bool = !node.classList.contains(name);
        }

        if (bool) {
          node.classList.add(name);
        } else {
          node.classList.remove(name);
        }
      }
      /**
       * Cross-platform helper for setting an element's CSS `transform` property.
       *
       * @param {string} transformText Transform setting.
       * @param {Element=} node Element to apply the transform to.
       * Defaults to `this`
       * @return {void}
       * @override
       */


      transform(transformText, node) {
        node =
        /** @type {Element} */
        node || this;
        node.style.webkitTransform = transformText;
        node.style.transform = transformText;
      }
      /**
       * Cross-platform helper for setting an element's CSS `translate3d`
       * property.
       *
       * @param {number|string} x X offset.
       * @param {number|string} y Y offset.
       * @param {number|string} z Z offset.
       * @param {Element=} node Element to apply the transform to.
       * Defaults to `this`.
       * @return {void}
       * @override
       */


      translate3d(x, y, z, node) {
        node =
        /** @type {Element} */
        node || this;
        this.transform('translate3d(' + x + ',' + y + ',' + z + ')', node);
      }
      /**
       * Removes an item from an array, if it exists.
       *
       * If the array is specified by path, a change notification is
       * generated, so that observers, data bindings and computed
       * properties watching that path can update.
       *
       * If the array is passed directly, **no change
       * notification is generated**.
       *
       * @param {string | !Array<number|string>} arrayOrPath Path to array from
       *     which to remove the item
       *   (or the array itself).
       * @param {*} item Item to remove.
       * @return {Array} Array containing item removed.
       * @override
       */


      arrayDelete(arrayOrPath, item) {
        let index;

        if (Array.isArray(arrayOrPath)) {
          index = arrayOrPath.indexOf(item);

          if (index >= 0) {
            return arrayOrPath.splice(index, 1);
          }
        } else {
          let arr = get(this, arrayOrPath);
          index = arr.indexOf(item);

          if (index >= 0) {
            return this.splice(arrayOrPath, index, 1);
          }
        }

        return null;
      } // logging

      /**
       * Facades `console.log`/`warn`/`error` as override point.
       *
       * @param {string} level One of 'log', 'warn', 'error'
       * @param {Array} args Array of strings or objects to log
       * @return {void}
       * @override
       */


      _logger(level, args) {
        // accept ['foo', 'bar'] and [['foo', 'bar']]
        if (Array.isArray(args) && args.length === 1 && Array.isArray(args[0])) {
          args = args[0];
        }

        switch (level) {
          case 'log':
          case 'warn':
          case 'error':
            console[level](...args);
        }
      }
      /**
       * Facades `console.log` as an override point.
       *
       * @param {...*} args Array of strings or objects to log
       * @return {void}
       * @override
       */


      _log(...args) {
        this._logger('log', args);
      }
      /**
       * Facades `console.warn` as an override point.
       *
       * @param {...*} args Array of strings or objects to log
       * @return {void}
       * @override
       */


      _warn(...args) {
        this._logger('warn', args);
      }
      /**
       * Facades `console.error` as an override point.
       *
       * @param {...*} args Array of strings or objects to log
       * @return {void}
       * @override
       */


      _error(...args) {
        this._logger('error', args);
      }
      /**
       * Formats a message using the element type an a method name.
       *
       * @param {string} methodName Method name to associate with message
       * @param {...*} args Array of strings or objects to log
       * @return {!Array} Array with formatting information for `console`
       *   logging.
       * @override
       */


      _logf(methodName, ...args) {
        return ['[%s::%s]', this.is, methodName, ...args];
      }

    }

    LegacyElement.prototype.is = '';
    return LegacyElement;
  });

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  const lifecycleProps = {
    attached: true,
    detached: true,
    ready: true,
    created: true,
    beforeRegister: true,
    registered: true,
    attributeChanged: true,
    listeners: true,
    hostAttributes: true
  };
  const excludeOnInfo = {
    attached: true,
    detached: true,
    ready: true,
    created: true,
    beforeRegister: true,
    registered: true,
    attributeChanged: true,
    behaviors: true,
    _noAccessors: true
  };
  const excludeOnBehaviors = Object.assign({
    listeners: true,
    hostAttributes: true,
    properties: true,
    observers: true
  }, excludeOnInfo);

  function copyProperties(source, target, excludeProps) {
    const noAccessors = source._noAccessors;
    const propertyNames = Object.getOwnPropertyNames(source);

    for (let i = 0; i < propertyNames.length; i++) {
      let p = propertyNames[i];

      if (p in excludeProps) {
        continue;
      }

      if (noAccessors) {
        target[p] = source[p];
      } else {
        let pd = Object.getOwnPropertyDescriptor(source, p);

        if (pd) {
          // ensure property is configurable so that a later behavior can
          // re-configure it.
          pd.configurable = true;
          Object.defineProperty(target, p, pd);
        }
      }
    }
  }
  // 1.x
  // Behaviors were mixed in *in reverse order* and de-duped on the fly.
  // The rule was that behavior properties were copied onto the element
  // prototype if and only if the property did not already exist.
  // Given: Polymer{ behaviors: [A, B, C, A, B]}, property copy order was:
  // (1), B, (2), A, (3) C. This means prototype properties win over
  // B properties win over A win over C. This mirrors what would happen
  // with inheritance if element extended B extended A extended C.
  //
  // Again given, Polymer{ behaviors: [A, B, C, A, B]}, the resulting
  // `behaviors` array was [C, A, B].
  // Behavior lifecycle methods were called in behavior array order
  // followed by the element, e.g. (1) C.created, (2) A.created,
  // (3) B.created, (4) element.created. There was no support for
  // super, and "super-behavior" methods were callable only by name).
  //
  // 2.x
  // Behaviors are made into proper mixins which live in the
  // element's prototype chain. Behaviors are placed in the element prototype
  // eldest to youngest and de-duped youngest to oldest:
  // So, first [A, B, C, A, B] becomes [C, A, B] then,
  // the element prototype becomes (oldest) (1) PolymerElement, (2) class(C),
  // (3) class(A), (4) class(B), (5) class(Polymer({...})).
  // Result:
  // This means element properties win over B properties win over A win
  // over C. (same as 1.x)
  // If lifecycle is called (super then me), order is
  // (1) C.created, (2) A.created, (3) B.created, (4) element.created
  // (again same as 1.x)

  function applyBehaviors(proto, behaviors, lifecycle) {
    for (let i = 0; i < behaviors.length; i++) {
      applyInfo(proto, behaviors[i], lifecycle, excludeOnBehaviors);
    }
  }

  function applyInfo(proto, info, lifecycle, excludeProps) {
    copyProperties(info, proto, excludeProps);

    for (let p in lifecycleProps) {
      if (info[p]) {
        lifecycle[p] = lifecycle[p] || [];
        lifecycle[p].push(info[p]);
      }
    }
  }
  /**
   * @param {Array} behaviors List of behaviors to flatten.
   * @param {Array=} list Target list to flatten behaviors into.
   * @param {Array=} exclude List of behaviors to exclude from the list.
   * @return {!Array} Returns the list of flattened behaviors.
   */


  function flattenBehaviors(behaviors, list, exclude) {
    list = list || [];

    for (let i = behaviors.length - 1; i >= 0; i--) {
      let b = behaviors[i];

      if (b) {
        if (Array.isArray(b)) {
          flattenBehaviors(b, list);
        } else {
          // dedup
          if (list.indexOf(b) < 0 && (!exclude || exclude.indexOf(b) < 0)) {
            list.unshift(b);
          }
        }
      } else {
        console.warn('behavior is null, check for missing or 404 import');
      }
    }

    return list;
  }
  /**
   * Copies property descriptors from source to target, overwriting all fields
   * of any previous descriptor for a property *except* for `value`, which is
   * merged in from the target if it does not exist on the source.
   *
   * @param {*} target Target properties object
   * @param {*} source Source properties object
   */


  function mergeProperties(target, source) {
    for (const p in source) {
      const targetInfo = target[p];
      const sourceInfo = source[p];

      if (!('value' in sourceInfo) && targetInfo && 'value' in targetInfo) {
        target[p] = Object.assign({
          value: targetInfo.value
        }, sourceInfo);
      } else {
        target[p] = sourceInfo;
      }
    }
  }

  const LegacyElement = LegacyElementMixin(HTMLElement);
  /* Note about construction and extension of legacy classes.
    [Changed in Q4 2018 to optimize performance.]

    When calling `Polymer` or `mixinBehaviors`, the generated class below is
    made. The list of behaviors was previously made into one generated class per
    behavior, but this is no longer the case as behaviors are now called
    manually. Note, there may *still* be multiple generated classes in the
    element's prototype chain if extension is used with `mixinBehaviors`.

    The generated class is directly tied to the info object and behaviors
    used to create it. That list of behaviors is filtered so it's only the
    behaviors not active on the superclass. In order to call through to the
    entire list of lifecycle methods, it's important to call `super`.

    The element's `properties` and `observers` are controlled via the finalization
    mechanism provided by `PropertiesMixin`. `Properties` and `observers` are
    collected by manually traversing the prototype chain and merging.

    To limit changes, the `_registered` method is called via `_initializeProperties`
    and not `_finalizeClass`.

  */

  /**
   * @param {!PolymerInit} info Polymer info object
   * @param {function(new:HTMLElement)} Base base class to extend with info object
   * @param {Object=} behaviors behaviors to copy into the element
   * @return {function(new:HTMLElement)} Generated class
   * @suppress {checkTypes}
   * @private
   */

  function GenerateClassFromInfo(info, Base, behaviors) {
    // manages behavior and lifecycle processing (filled in after class definition)
    let behaviorList;
    const lifecycle = {};
    /** @private */

    class PolymerGenerated extends Base {
      // explicitly not calling super._finalizeClass

      /** @nocollapse */
      static _finalizeClass() {
        // if calling via a subclass that hasn't been generated, pass through to super
        if (!this.hasOwnProperty(JSCompiler_renameProperty('generatedFrom', this))) {
          // TODO(https://github.com/google/closure-compiler/issues/3240):
          //     Change back to just super.methodCall()
          Base._finalizeClass.call(this);
        } else {
          // interleave properties and observers per behavior and `info`
          if (behaviorList) {
            for (let i = 0, b; i < behaviorList.length; i++) {
              b = behaviorList[i];

              if (b.properties) {
                this.createProperties(b.properties);
              }

              if (b.observers) {
                this.createObservers(b.observers, b.properties);
              }
            }
          }

          if (info.properties) {
            this.createProperties(info.properties);
          }

          if (info.observers) {
            this.createObservers(info.observers, info.properties);
          } // make sure to prepare the element template


          this._prepareTemplate();
        }
      }
      /** @nocollapse */


      static get properties() {
        const properties = {};

        if (behaviorList) {
          for (let i = 0; i < behaviorList.length; i++) {
            mergeProperties(properties, behaviorList[i].properties);
          }
        }

        mergeProperties(properties, info.properties);
        return properties;
      }
      /** @nocollapse */


      static get observers() {
        let observers = [];

        if (behaviorList) {
          for (let i = 0, b; i < behaviorList.length; i++) {
            b = behaviorList[i];

            if (b.observers) {
              observers = observers.concat(b.observers);
            }
          }
        }

        if (info.observers) {
          observers = observers.concat(info.observers);
        }

        return observers;
      }
      /**
       * @return {void}
       */


      created() {
        super.created();
        const list = lifecycle.created;

        if (list) {
          for (let i = 0; i < list.length; i++) {
            list[i].call(this);
          }
        }
      }
      /**
       * @return {void}
       */


      _registered() {
        /* NOTE: `beforeRegister` is called here for bc, but the behavior
          is different than in 1.x. In 1.0, the method was called *after*
          mixing prototypes together but *before* processing of meta-objects.
          However, dynamic effects can still be set here and can be done either
          in `beforeRegister` or `registered`. It is no longer possible to set
          `is` in `beforeRegister` as you could in 1.x.
        */
        // only proceed if the generated class' prototype has not been registered.
        const generatedProto = PolymerGenerated.prototype;

        if (!generatedProto.hasOwnProperty(JSCompiler_renameProperty('__hasRegisterFinished', generatedProto))) {
          generatedProto.__hasRegisterFinished = true; // ensure superclass is registered first.

          super._registered(); // copy properties onto the generated class lazily if we're optimizing,


          if (legacyOptimizations) {
            copyPropertiesToProto(generatedProto);
          } // make sure legacy lifecycle is called on the *element*'s prototype
          // and not the generated class prototype; if the element has been
          // extended, these are *not* the same.


          const proto = Object.getPrototypeOf(this);
          let list = lifecycle.beforeRegister;

          if (list) {
            for (let i = 0; i < list.length; i++) {
              list[i].call(proto);
            }
          }

          list = lifecycle.registered;

          if (list) {
            for (let i = 0; i < list.length; i++) {
              list[i].call(proto);
            }
          }
        }
      }
      /**
       * @return {void}
       */


      _applyListeners() {
        super._applyListeners();

        const list = lifecycle.listeners;

        if (list) {
          for (let i = 0; i < list.length; i++) {
            const listeners = list[i];

            if (listeners) {
              for (let l in listeners) {
                this._addMethodEventListenerToNode(this, l, listeners[l]);
              }
            }
          }
        }
      } // note: exception to "super then me" rule;
      // do work before calling super so that super attributes
      // only apply if not already set.

      /**
       * @return {void}
       */


      _ensureAttributes() {
        const list = lifecycle.hostAttributes;

        if (list) {
          for (let i = list.length - 1; i >= 0; i--) {
            const hostAttributes = list[i];

            for (let a in hostAttributes) {
              this._ensureAttribute(a, hostAttributes[a]);
            }
          }
        }

        super._ensureAttributes();
      }
      /**
       * @return {void}
       */


      ready() {
        super.ready();
        let list = lifecycle.ready;

        if (list) {
          for (let i = 0; i < list.length; i++) {
            list[i].call(this);
          }
        }
      }
      /**
       * @return {void}
       */


      attached() {
        super.attached();
        let list = lifecycle.attached;

        if (list) {
          for (let i = 0; i < list.length; i++) {
            list[i].call(this);
          }
        }
      }
      /**
       * @return {void}
       */


      detached() {
        super.detached();
        let list = lifecycle.detached;

        if (list) {
          for (let i = 0; i < list.length; i++) {
            list[i].call(this);
          }
        }
      }
      /**
       * Implements native Custom Elements `attributeChangedCallback` to
       * set an attribute value to a property via `_attributeToProperty`.
       *
       * @param {string} name Name of attribute that changed
       * @param {?string} old Old attribute value
       * @param {?string} value New attribute value
       * @return {void}
       */


      attributeChanged(name, old, value) {
        super.attributeChanged();
        let list = lifecycle.attributeChanged;

        if (list) {
          for (let i = 0; i < list.length; i++) {
            list[i].call(this, name, old, value);
          }
        }
      }

    } // apply behaviors, note actual copying is done lazily at first instance creation


    if (behaviors) {
      // NOTE: ensure the behavior is extending a class with
      // legacy element api. This is necessary since behaviors expect to be able
      // to access 1.x legacy api.
      if (!Array.isArray(behaviors)) {
        behaviors = [behaviors];
      }

      let superBehaviors = Base.prototype.behaviors; // get flattened, deduped list of behaviors *not* already on super class

      behaviorList = flattenBehaviors(behaviors, null, superBehaviors);
      PolymerGenerated.prototype.behaviors = superBehaviors ? superBehaviors.concat(behaviors) : behaviorList;
    }

    const copyPropertiesToProto = proto => {
      if (behaviorList) {
        applyBehaviors(proto, behaviorList, lifecycle);
      }

      applyInfo(proto, info, lifecycle, excludeOnInfo);
    }; // copy properties if we're not optimizing


    if (!legacyOptimizations) {
      copyPropertiesToProto(PolymerGenerated.prototype);
    }

    PolymerGenerated.generatedFrom = info;
    return PolymerGenerated;
  }
  /**
   * Generates a class that extends `LegacyElement` based on the
   * provided info object.  Metadata objects on the `info` object
   * (`properties`, `observers`, `listeners`, `behaviors`, `is`) are used
   * for Polymer's meta-programming systems, and any functions are copied
   * to the generated class.
   *
   * Valid "metadata" values are as follows:
   *
   * `is`: String providing the tag name to register the element under. In
   * addition, if a `dom-module` with the same id exists, the first template
   * in that `dom-module` will be stamped into the shadow root of this element,
   * with support for declarative event listeners (`on-...`), Polymer data
   * bindings (`[[...]]` and `{{...}}`), and id-based node finding into
   * `this.$`.
   *
   * `properties`: Object describing property-related metadata used by Polymer
   * features (key: property names, value: object containing property metadata).
   * Valid keys in per-property metadata include:
   * - `type` (String|Number|Object|Array|...): Used by
   *   `attributeChangedCallback` to determine how string-based attributes
   *   are deserialized to JavaScript property values.
   * - `notify` (boolean): Causes a change in the property to fire a
   *   non-bubbling event called `<property>-changed`. Elements that have
   *   enabled two-way binding to the property use this event to observe changes.
   * - `readOnly` (boolean): Creates a getter for the property, but no setter.
   *   To set a read-only property, use the private setter method
   *   `_setProperty(property, value)`.
   * - `observer` (string): Observer method name that will be called when
   *   the property changes. The arguments of the method are
   *   `(value, previousValue)`.
   * - `computed` (string): String describing method and dependent properties
   *   for computing the value of this property (e.g. `'computeFoo(bar, zot)'`).
   *   Computed properties are read-only by default and can only be changed
   *   via the return value of the computing method.
   *
   * `observers`: Array of strings describing multi-property observer methods
   *  and their dependent properties (e.g. `'observeABC(a, b, c)'`).
   *
   * `listeners`: Object describing event listeners to be added to each
   *  instance of this element (key: event name, value: method name).
   *
   * `behaviors`: Array of additional `info` objects containing metadata
   * and callbacks in the same format as the `info` object here which are
   * merged into this element.
   *
   * `hostAttributes`: Object listing attributes to be applied to the host
   *  once created (key: attribute name, value: attribute value).  Values
   *  are serialized based on the type of the value.  Host attributes should
   *  generally be limited to attributes such as `tabIndex` and `aria-...`.
   *  Attributes in `hostAttributes` are only applied if a user-supplied
   *  attribute is not already present (attributes in markup override
   *  `hostAttributes`).
   *
   * In addition, the following Polymer-specific callbacks may be provided:
   * - `registered`: called after first instance of this element,
   * - `created`: called during `constructor`
   * - `attached`: called during `connectedCallback`
   * - `detached`: called during `disconnectedCallback`
   * - `ready`: called before first `attached`, after all properties of
   *   this element have been propagated to its template and all observers
   *   have run
   *
   * @param {!PolymerInit} info Object containing Polymer metadata and functions
   *   to become class methods.
   * @template T
   * @param {function(T):T} mixin Optional mixin to apply to legacy base class
   *   before extending with Polymer metaprogramming.
   * @return {function(new:HTMLElement)} Generated class
   */


  const Class = function (info, mixin) {
    if (!info) {
      console.warn('Polymer.Class requires `info` argument');
    }

    let klass = mixin ? mixin(LegacyElement) : LegacyElement;
    klass = GenerateClassFromInfo(info, klass, info.behaviors); // decorate klass with registration info

    klass.is = klass.prototype.is = info.is;
    return klass;
  };

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * Legacy class factory and registration helper for defining Polymer
   * elements.
   *
   * This method is equivalent to
   *
   *     import {Class} from '@polymer/polymer/lib/legacy/class.js';
   *     customElements.define(info.is, Class(info));
   *
   * See `Class` for details on valid legacy metadata format for `info`.
   *
   * @global
   * @override
   * @function
   * @param {!PolymerInit} info Object containing Polymer metadata and functions
   *   to become class methods.
   * @return {function(new: HTMLElement)} Generated class
   * @suppress {duplicate, invalidCasts, checkTypes}
   */

  const Polymer = function (info) {
    // if input is a `class` (aka a function with a prototype), use the prototype
    // remember that the `constructor` will never be called
    let klass;

    if (typeof info === 'function') {
      klass = info;
    } else {
      klass = Polymer.Class(info);
    } // Copy opt out for `legacyNoObservedAttributes` from info object to class.


    if (info._legacyForceObservedAttributes) {
      klass.prototype._legacyForceObservedAttributes = info._legacyForceObservedAttributes;
    }

    customElements.define(klass.is,
    /** @type {!HTMLElement} */
    klass);
    return klass;
  };

  Polymer.Class = Class;

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  function mutablePropertyChange(inst, property, value, old, mutableData) {
    let isObject;

    if (mutableData) {
      isObject = typeof value === 'object' && value !== null; // Pull `old` for Objects from temp cache, but treat `null` as a primitive

      if (isObject) {
        old = inst.__dataTemp[property];
      }
    } // Strict equality check, but return false for NaN===NaN


    let shouldChange = old !== value && (old === old || value === value); // Objects are stored in temporary cache (cleared at end of
    // turn), which is used for dirty-checking

    if (isObject && shouldChange) {
      inst.__dataTemp[property] = value;
    }

    return shouldChange;
  }
  /**
   * Element class mixin to skip strict dirty-checking for objects and arrays
   * (always consider them to be "dirty"), for use on elements utilizing
   * `PropertyEffects`
   *
   * By default, `PropertyEffects` performs strict dirty checking on
   * objects, which means that any deep modifications to an object or array will
   * not be propagated unless "immutable" data patterns are used (i.e. all object
   * references from the root to the mutation were changed).
   *
   * Polymer also provides a proprietary data mutation and path notification API
   * (e.g. `notifyPath`, `set`, and array mutation API's) that allow efficient
   * mutation and notification of deep changes in an object graph to all elements
   * bound to the same object graph.
   *
   * In cases where neither immutable patterns nor the data mutation API can be
   * used, applying this mixin will cause Polymer to skip dirty checking for
   * objects and arrays (always consider them to be "dirty").  This allows a
   * user to make a deep modification to a bound object graph, and then either
   * simply re-set the object (e.g. `this.items = this.items`) or call `notifyPath`
   * (e.g. `this.notifyPath('items')`) to update the tree.  Note that all
   * elements that wish to be updated based on deep mutations must apply this
   * mixin or otherwise skip strict dirty checking for objects/arrays.
   * Specifically, any elements in the binding tree between the source of a
   * mutation and the consumption of it must apply this mixin or enable the
   * `OptionalMutableData` mixin.
   *
   * In order to make the dirty check strategy configurable, see
   * `OptionalMutableData`.
   *
   * Note, the performance characteristics of propagating large object graphs
   * will be worse as opposed to using strict dirty checking with immutable
   * patterns or Polymer's path notification API.
   *
   * @mixinFunction
   * @polymer
   * @summary Element class mixin to skip strict dirty-checking for objects
   *   and arrays
   * @template T
   * @param {function(new:T)} superClass Class to apply mixin to.
   * @return {function(new:T)} superClass with mixin applied.
   */


  const MutableData = dedupingMixin(superClass => {
    /**
     * @polymer
     * @mixinClass
     * @implements {Polymer_MutableData}
     */
    class MutableData extends superClass {
      /**
       * Overrides `PropertyEffects` to provide option for skipping
       * strict equality checking for Objects and Arrays.
       *
       * This method pulls the value to dirty check against from the `__dataTemp`
       * cache (rather than the normal `__data` cache) for Objects.  Since the temp
       * cache is cleared at the end of a turn, this implementation allows
       * side-effects of deep object changes to be processed by re-setting the
       * same object (using the temp cache as an in-turn backstop to prevent
       * cycles due to 2-way notification).
       *
       * @param {string} property Property name
       * @param {*} value New property value
       * @param {*} old Previous property value
       * @return {boolean} Whether the property should be considered a change
       * @protected
       */
      _shouldPropertyChange(property, value, old) {
        return mutablePropertyChange(this, property, value, old, true);
      }

    }

    return MutableData;
  });
  /**
   * Element class mixin to add the optional ability to skip strict
   * dirty-checking for objects and arrays (always consider them to be
   * "dirty") by setting a `mutable-data` attribute on an element instance.
   *
   * By default, `PropertyEffects` performs strict dirty checking on
   * objects, which means that any deep modifications to an object or array will
   * not be propagated unless "immutable" data patterns are used (i.e. all object
   * references from the root to the mutation were changed).
   *
   * Polymer also provides a proprietary data mutation and path notification API
   * (e.g. `notifyPath`, `set`, and array mutation API's) that allow efficient
   * mutation and notification of deep changes in an object graph to all elements
   * bound to the same object graph.
   *
   * In cases where neither immutable patterns nor the data mutation API can be
   * used, applying this mixin will allow Polymer to skip dirty checking for
   * objects and arrays (always consider them to be "dirty").  This allows a
   * user to make a deep modification to a bound object graph, and then either
   * simply re-set the object (e.g. `this.items = this.items`) or call `notifyPath`
   * (e.g. `this.notifyPath('items')`) to update the tree.  Note that all
   * elements that wish to be updated based on deep mutations must apply this
   * mixin or otherwise skip strict dirty checking for objects/arrays.
   * Specifically, any elements in the binding tree between the source of a
   * mutation and the consumption of it must enable this mixin or apply the
   * `MutableData` mixin.
   *
   * While this mixin adds the ability to forgo Object/Array dirty checking,
   * the `mutableData` flag defaults to false and must be set on the instance.
   *
   * Note, the performance characteristics of propagating large object graphs
   * will be worse by relying on `mutableData: true` as opposed to using
   * strict dirty checking with immutable patterns or Polymer's path notification
   * API.
   *
   * @mixinFunction
   * @polymer
   * @summary Element class mixin to optionally skip strict dirty-checking
   *   for objects and arrays
   */

  const OptionalMutableData = dedupingMixin(superClass => {
    /**
     * @mixinClass
     * @polymer
     * @implements {Polymer_OptionalMutableData}
     */
    class OptionalMutableData extends superClass {
      /** @nocollapse */
      static get properties() {
        return {
          /**
           * Instance-level flag for configuring the dirty-checking strategy
           * for this element.  When true, Objects and Arrays will skip dirty
           * checking, otherwise strict equality checking will be used.
           */
          mutableData: Boolean
        };
      }
      /**
       * Overrides `PropertyEffects` to provide option for skipping
       * strict equality checking for Objects and Arrays.
       *
       * When `this.mutableData` is true on this instance, this method
       * pulls the value to dirty check against from the `__dataTemp` cache
       * (rather than the normal `__data` cache) for Objects.  Since the temp
       * cache is cleared at the end of a turn, this implementation allows
       * side-effects of deep object changes to be processed by re-setting the
       * same object (using the temp cache as an in-turn backstop to prevent
       * cycles due to 2-way notification).
       *
       * @param {string} property Property name
       * @param {*} value New property value
       * @param {*} old Previous property value
       * @return {boolean} Whether the property should be considered a change
       * @protected
       */


      _shouldPropertyChange(property, value, old) {
        return mutablePropertyChange(this, property, value, old, this.mutableData);
      }

    }

    return OptionalMutableData;
  }); // Export for use by legacy behavior

  MutableData._mutablePropertyChange = mutablePropertyChange;

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  // machinery for propagating host properties to children. This is an ES5
  // class only because Babel (incorrectly) requires super() in the class
  // constructor even though no `this` is used and it returns an instance.

  let newInstance = null;
  /**
   * @constructor
   * @extends {HTMLTemplateElement}
   * @private
   */

  function HTMLTemplateElementExtension() {
    return newInstance;
  }

  HTMLTemplateElementExtension.prototype = Object.create(HTMLTemplateElement.prototype, {
    constructor: {
      value: HTMLTemplateElementExtension,
      writable: true
    }
  });
  /**
   * @constructor
   * @implements {Polymer_PropertyEffects}
   * @extends {HTMLTemplateElementExtension}
   * @private
   */

  const DataTemplate = PropertyEffects(HTMLTemplateElementExtension);
  /**
   * @constructor
   * @implements {Polymer_MutableData}
   * @extends {DataTemplate}
   * @private
   */

  const MutableDataTemplate = MutableData(DataTemplate); // Applies a DataTemplate subclass to a <template> instance

  function upgradeTemplate(template, constructor) {
    newInstance = template;
    Object.setPrototypeOf(template, constructor.prototype);
    new constructor();
    newInstance = null;
  }
  /**
   * Base class for TemplateInstance.
   * @constructor
   * @extends {HTMLElement}
   * @implements {Polymer_PropertyEffects}
   * @private
   */


  const templateInstanceBase = PropertyEffects(class {});
  function showHideChildren(hide, children) {
    for (let i = 0; i < children.length; i++) {
      let n = children[i]; // Ignore non-changes

      if (Boolean(hide) != Boolean(n.__hideTemplateChildren__)) {
        // clear and restore text
        if (n.nodeType === Node.TEXT_NODE) {
          if (hide) {
            n.__polymerTextContent__ = n.textContent;
            n.textContent = '';
          } else {
            n.textContent = n.__polymerTextContent__;
          } // remove and replace slot

        } else if (n.localName === 'slot') {
          if (hide) {
            n.__polymerReplaced__ = document.createComment('hidden-slot');
            wrap$1(wrap$1(n).parentNode).replaceChild(n.__polymerReplaced__, n);
          } else {
            const replace = n.__polymerReplaced__;

            if (replace) {
              wrap$1(wrap$1(replace).parentNode).replaceChild(n, replace);
            }
          }
        } // hide and show nodes
        else if (n.style) {
            if (hide) {
              n.__polymerDisplay__ = n.style.display;
              n.style.display = 'none';
            } else {
              n.style.display = n.__polymerDisplay__;
            }
          }
      }

      n.__hideTemplateChildren__ = hide;

      if (n._showHideChildren) {
        n._showHideChildren(hide);
      }
    }
  }
  /**
   * @polymer
   * @customElement
   * @appliesMixin PropertyEffects
   * @unrestricted
   */

  class TemplateInstanceBase extends templateInstanceBase {
    constructor(props) {
      super();

      this._configureProperties(props);
      /** @type {!StampedTemplate} */


      this.root = this._stampTemplate(this.__dataHost); // Save list of stamped children

      let children = [];
      /** @suppress {invalidCasts} */

      this.children =
      /** @type {!NodeList} */
      children; // Polymer 1.x did not use `Polymer.dom` here so not bothering.

      for (let n = this.root.firstChild; n; n = n.nextSibling) {
        children.push(n);
        n.__templatizeInstance = this;
      }

      if (this.__templatizeOwner && this.__templatizeOwner.__hideTemplateChildren__) {
        this._showHideChildren(true);
      } // Flush props only when props are passed if instance props exist
      // or when there isn't instance props.


      let options = this.__templatizeOptions;

      if (props && options.instanceProps || !options.instanceProps) {
        this._enableProperties();
      }
    }
    /**
     * Configure the given `props` by calling `_setPendingProperty`. Also
     * sets any properties stored in `__hostProps`.
     * @private
     * @param {Object} props Object of property name-value pairs to set.
     * @return {void}
     */


    _configureProperties(props) {
      let options = this.__templatizeOptions;

      if (options.forwardHostProp) {
        for (let hprop in this.__hostProps) {
          this._setPendingProperty(hprop, this.__dataHost['_host_' + hprop]);
        }
      } // Any instance props passed in the constructor will overwrite host props;
      // normally this would be a user error but we don't specifically filter them


      for (let iprop in props) {
        this._setPendingProperty(iprop, props[iprop]);
      }
    }
    /**
     * Forwards a host property to this instance.  This method should be
     * called on instances from the `options.forwardHostProp` callback
     * to propagate changes of host properties to each instance.
     *
     * Note this method enqueues the change, which are flushed as a batch.
     *
     * @param {string} prop Property or path name
     * @param {*} value Value of the property to forward
     * @return {void}
     */


    forwardHostProp(prop, value) {
      if (this._setPendingPropertyOrPath(prop, value, false, true)) {
        this.__dataHost._enqueueClient(this);
      }
    }
    /**
     * Override point for adding custom or simulated event handling.
     *
     * @override
     * @param {!Node} node Node to add event listener to
     * @param {string} eventName Name of event
     * @param {function(!Event):void} handler Listener function to add
     * @return {void}
     */


    _addEventListenerToNode(node, eventName, handler) {
      if (this._methodHost && this.__templatizeOptions.parentModel) {
        // If this instance should be considered a parent model, decorate
        // events this template instance as `model`
        this._methodHost._addEventListenerToNode(node, eventName, e => {
          e.model = this;
          handler(e);
        });
      } else {
        // Otherwise delegate to the template's host (which could be)
        // another template instance
        let templateHost = this.__dataHost.__dataHost;

        if (templateHost) {
          templateHost._addEventListenerToNode(node, eventName, handler);
        }
      }
    }
    /**
     * Shows or hides the template instance top level child elements. For
     * text nodes, `textContent` is removed while "hidden" and replaced when
     * "shown."
     * @param {boolean} hide Set to true to hide the children;
     * set to false to show them.
     * @return {void}
     * @protected
     */


    _showHideChildren(hide) {
      showHideChildren(hide, this.children);
    }
    /**
     * Overrides default property-effects implementation to intercept
     * textContent bindings while children are "hidden" and cache in
     * private storage for later retrieval.
     *
     * @override
     * @param {!Node} node The node to set a property on
     * @param {string} prop The property to set
     * @param {*} value The value to set
     * @return {void}
     * @protected
     */


    _setUnmanagedPropertyToNode(node, prop, value) {
      if (node.__hideTemplateChildren__ && node.nodeType == Node.TEXT_NODE && prop == 'textContent') {
        node.__polymerTextContent__ = value;
      } else {
        super._setUnmanagedPropertyToNode(node, prop, value);
      }
    }
    /**
     * Find the parent model of this template instance.  The parent model
     * is either another templatize instance that had option `parentModel: true`,
     * or else the host element.
     *
     * @return {!Polymer_PropertyEffects} The parent model of this instance
     */


    get parentModel() {
      let model = this.__parentModel;

      if (!model) {
        let options;
        model = this;

        do {
          // A template instance's `__dataHost` is a <template>
          // `model.__dataHost.__dataHost` is the template's host
          model = model.__dataHost.__dataHost;
        } while ((options = model.__templatizeOptions) && !options.parentModel);

        this.__parentModel = model;
      }

      return model;
    }
    /**
     * Stub of HTMLElement's `dispatchEvent`, so that effects that may
     * dispatch events safely no-op.
     *
     * @param {Event} event Event to dispatch
     * @return {boolean} Always true.
     * @override
     */


    dispatchEvent(event) {
      // eslint-disable-line no-unused-vars
      return true;
    }

  }
  /**
   * @constructor
   * @extends {TemplateInstanceBase}
   * @implements {Polymer_MutableData}
   * @private
   */

  const MutableTemplateInstanceBase = MutableData( // This cast shouldn't be neccessary, but Closure doesn't understand that
  // TemplateInstanceBase is a constructor function.

  /** @type {function(new:TemplateInstanceBase)} */
  TemplateInstanceBase);

  function findMethodHost(template) {
    // Technically this should be the owner of the outermost template.
    // In shadow dom, this is always getRootNode().host, but we can
    // approximate this via cooperation with our dataHost always setting
    // `_methodHost` as long as there were bindings (or id's) on this
    // instance causing it to get a dataHost.
    let templateHost = template.__dataHost;
    return templateHost && templateHost._methodHost || templateHost;
  }
  /* eslint-disable valid-jsdoc */

  /**
   * @suppress {missingProperties} class.prototype is not defined for some reason
   */


  function createTemplatizerClass(template, templateInfo, options) {
    /**
     * @constructor
     * @extends {TemplateInstanceBase}
     */
    let templatizerBase = options.mutableData ? MutableTemplateInstanceBase : TemplateInstanceBase; // Affordance for global mixins onto TemplatizeInstance

    if (templatize.mixin) {
      templatizerBase = templatize.mixin(templatizerBase);
    }
    /**
     * Anonymous class created by the templatize
     * @constructor
     * @private
     */


    let klass = class extends templatizerBase {};
    /** @override */

    klass.prototype.__templatizeOptions = options;

    klass.prototype._bindTemplate(template);

    addNotifyEffects(klass, template, templateInfo, options);
    return klass;
  }
  /**
   * Adds propagate effects from the template to the template instance for
   * properties that the host binds to the template using the `_host_` prefix.
   *
   * @suppress {missingProperties} class.prototype is not defined for some reason
   */


  function addPropagateEffects(target, templateInfo, options, methodHost) {
    let userForwardHostProp = options.forwardHostProp;

    if (userForwardHostProp && templateInfo.hasHostProps) {
      // Under the `removeNestedTemplates` optimization, a custom element like
      // `dom-if` or `dom-repeat` can itself be treated as the "template"; this
      // flag is used to switch between upgrading a `<template>` to be a property
      // effects client vs. adding the effects directly to the custom element
      const isTemplate = target.localName == 'template'; // Provide data API and property effects on memoized template class

      let klass = templateInfo.templatizeTemplateClass;

      if (!klass) {
        if (isTemplate) {
          /**
           * @constructor
           * @extends {DataTemplate}
           */
          let templatizedBase = options.mutableData ? MutableDataTemplate : DataTemplate; // NOTE: due to https://github.com/google/closure-compiler/issues/2928,
          // combining the next two lines into one assignment causes a spurious
          // type error.

          /** @private */

          class TemplatizedTemplate extends templatizedBase {}

          klass = templateInfo.templatizeTemplateClass = TemplatizedTemplate;
        } else {
          /**
           * @constructor
           * @extends {PolymerElement}
           */
          const templatizedBase = target.constructor; // Create a cached subclass of the base custom element class onto which
          // to put the template-specific propagate effects
          // NOTE: due to https://github.com/google/closure-compiler/issues/2928,
          // combining the next two lines into one assignment causes a spurious
          // type error.

          /** @private */

          class TemplatizedTemplateExtension extends templatizedBase {}

          klass = templateInfo.templatizeTemplateClass = TemplatizedTemplateExtension;
        } // Add template - >instances effects
        // and host <- template effects


        let hostProps = templateInfo.hostProps;

        for (let prop in hostProps) {
          klass.prototype._addPropertyEffect('_host_' + prop, klass.prototype.PROPERTY_EFFECT_TYPES.PROPAGATE, {
            fn: createForwardHostPropEffect(prop, userForwardHostProp)
          });

          klass.prototype._createNotifyingProperty('_host_' + prop);
        }

        if (legacyWarnings && methodHost) {
          warnOnUndeclaredProperties(templateInfo, options, methodHost);
        }
      } // Mix any pre-bound data into __data; no need to flush this to
      // instances since they pull from the template at instance-time


      if (target.__dataProto) {
        // Note, generally `__dataProto` could be chained, but it's guaranteed
        // to not be since this is a vanilla template we just added effects to
        Object.assign(target.__data, target.__dataProto);
      }

      if (isTemplate) {
        upgradeTemplate(target, klass); // Clear any pending data for performance

        target.__dataTemp = {};
        target.__dataPending = null;
        target.__dataOld = null;

        target._enableProperties();
      } else {
        // Swizzle the cached subclass prototype onto the custom element
        Object.setPrototypeOf(target, klass.prototype); // Check for any pre-bound instance host properties, and do the
        // instance property delete/assign dance for those (directly into data;
        // not need to go through accessor since they are pulled at instance time)

        const hostProps = templateInfo.hostProps;

        for (let prop in hostProps) {
          prop = '_host_' + prop;

          if (prop in target) {
            const val = target[prop];
            delete target[prop];
            target.__data[prop] = val;
          }
        }
      }
    }
  }
  /* eslint-enable valid-jsdoc */


  function createForwardHostPropEffect(hostProp, userForwardHostProp) {
    return function forwardHostProp(template, prop, props) {
      userForwardHostProp.call(template.__templatizeOwner, prop.substring('_host_'.length), props[prop]);
    };
  }

  function addNotifyEffects(klass, template, templateInfo, options) {
    let hostProps = templateInfo.hostProps || {};

    for (let iprop in options.instanceProps) {
      delete hostProps[iprop];
      let userNotifyInstanceProp = options.notifyInstanceProp;

      if (userNotifyInstanceProp) {
        klass.prototype._addPropertyEffect(iprop, klass.prototype.PROPERTY_EFFECT_TYPES.NOTIFY, {
          fn: createNotifyInstancePropEffect(iprop, userNotifyInstanceProp)
        });
      }
    }

    if (options.forwardHostProp && template.__dataHost) {
      for (let hprop in hostProps) {
        // As we're iterating hostProps in this function, note whether
        // there were any, for an optimization in addPropagateEffects
        if (!templateInfo.hasHostProps) {
          templateInfo.hasHostProps = true;
        }

        klass.prototype._addPropertyEffect(hprop, klass.prototype.PROPERTY_EFFECT_TYPES.NOTIFY, {
          fn: createNotifyHostPropEffect()
        });
      }
    }
  }

  function createNotifyInstancePropEffect(instProp, userNotifyInstanceProp) {
    return function notifyInstanceProp(inst, prop, props) {
      userNotifyInstanceProp.call(inst.__templatizeOwner, inst, prop, props[prop]);
    };
  }

  function createNotifyHostPropEffect() {
    return function notifyHostProp(inst, prop, props) {
      inst.__dataHost._setPendingPropertyOrPath('_host_' + prop, props[prop], true, true);
    };
  }
  /**
   * Returns an anonymous `PropertyEffects` class bound to the
   * `<template>` provided.  Instancing the class will result in the
   * template being stamped into a document fragment stored as the instance's
   * `root` property, after which it can be appended to the DOM.
   *
   * Templates may utilize all Polymer data-binding features as well as
   * declarative event listeners.  Event listeners and inline computing
   * functions in the template will be called on the host of the template.
   *
   * The constructor returned takes a single argument dictionary of initial
   * property values to propagate into template bindings.  Additionally
   * host properties can be forwarded in, and instance properties can be
   * notified out by providing optional callbacks in the `options` dictionary.
   *
   * Valid configuration in `options` are as follows:
   *
   * - `forwardHostProp(property, value)`: Called when a property referenced
   *   in the template changed on the template's host. As this library does
   *   not retain references to templates instanced by the user, it is the
   *   templatize owner's responsibility to forward host property changes into
   *   user-stamped instances.  The `instance.forwardHostProp(property, value)`
   *    method on the generated class should be called to forward host
   *   properties into the template to prevent unnecessary property-changed
   *   notifications. Any properties referenced in the template that are not
   *   defined in `instanceProps` will be notified up to the template's host
   *   automatically.
   * - `instanceProps`: Dictionary of property names that will be added
   *   to the instance by the templatize owner.  These properties shadow any
   *   host properties, and changes within the template to these properties
   *   will result in `notifyInstanceProp` being called.
   * - `mutableData`: When `true`, the generated class will skip strict
   *   dirty-checking for objects and arrays (always consider them to be
   *   "dirty").
   * - `notifyInstanceProp(instance, property, value)`: Called when
   *   an instance property changes.  Users may choose to call `notifyPath`
   *   on e.g. the owner to notify the change.
   * - `parentModel`: When `true`, events handled by declarative event listeners
   *   (`on-event="handler"`) will be decorated with a `model` property pointing
   *   to the template instance that stamped it.  It will also be returned
   *   from `instance.parentModel` in cases where template instance nesting
   *   causes an inner model to shadow an outer model.
   *
   * All callbacks are called bound to the `owner`. Any context
   * needed for the callbacks (such as references to `instances` stamped)
   * should be stored on the `owner` such that they can be retrieved via
   * `this`.
   *
   * When `options.forwardHostProp` is declared as an option, any properties
   * referenced in the template will be automatically forwarded from the host of
   * the `<template>` to instances, with the exception of any properties listed in
   * the `options.instanceProps` object.  `instanceProps` are assumed to be
   * managed by the owner of the instances, either passed into the constructor
   * or set after the fact.  Note, any properties passed into the constructor will
   * always be set to the instance (regardless of whether they would normally
   * be forwarded from the host).
   *
   * Note that `templatize()` can be run only once for a given `<template>`.
   * Further calls will result in an error. Also, there is a special
   * behavior if the template was duplicated through a mechanism such as
   * `<dom-repeat>` or `<test-fixture>`. In this case, all calls to
   * `templatize()` return the same class for all duplicates of a template.
   * The class returned from `templatize()` is generated only once using
   * the `options` from the first call. This means that any `options`
   * provided to subsequent calls will be ignored. Therefore, it is very
   * important not to close over any variables inside the callbacks. Also,
   * arrow functions must be avoided because they bind the outer `this`.
   * Inside the callbacks, any contextual information can be accessed
   * through `this`, which points to the `owner`.
   *
   * @param {!HTMLTemplateElement} template Template to templatize
   * @param {Polymer_PropertyEffects=} owner Owner of the template instances;
   *   any optional callbacks will be bound to this owner.
   * @param {Object=} options Options dictionary (see summary for details)
   * @return {function(new:TemplateInstanceBase, Object=)} Generated class bound
   *   to the template provided
   * @suppress {invalidCasts}
   */


  function templatize(template, owner, options) {
    // Under strictTemplatePolicy, the templatized element must be owned
    // by a (trusted) Polymer element, indicated by existence of _methodHost;
    // e.g. for dom-if & dom-repeat in main document, _methodHost is null
    if (strictTemplatePolicy && !findMethodHost(template)) {
      throw new Error('strictTemplatePolicy: template owner not trusted');
    }

    options =
    /** @type {!TemplatizeOptions} */
    options || {};

    if (template.__templatizeOwner) {
      throw new Error('A <template> can only be templatized once');
    }

    template.__templatizeOwner = owner;
    const ctor = owner ? owner.constructor : TemplateInstanceBase;

    let templateInfo = ctor._parseTemplate(template); // Get memoized base class for the prototypical template, which
    // includes property effects for binding template & forwarding

    /**
     * @constructor
     * @extends {TemplateInstanceBase}
     */


    let baseClass = templateInfo.templatizeInstanceClass;

    if (!baseClass) {
      baseClass = createTemplatizerClass(template, templateInfo, options);
      templateInfo.templatizeInstanceClass = baseClass;
    }

    const methodHost = findMethodHost(template); // Host property forwarding must be installed onto template instance

    addPropagateEffects(template, templateInfo, options, methodHost); // Subclass base class and add reference for this specific template

    /** @private */

    let klass = class TemplateInstance extends baseClass {};
    /** @override */

    klass.prototype._methodHost = methodHost;
    /** @override */

    klass.prototype.__dataHost =
    /** @type {!DataTemplate} */
    template;
    /** @override */

    klass.prototype.__templatizeOwner =
    /** @type {!Object} */
    owner;
    /** @override */

    klass.prototype.__hostProps = templateInfo.hostProps;
    klass =
    /** @type {function(new:TemplateInstanceBase)} */
    klass; //eslint-disable-line no-self-assign

    return klass;
  }

  function warnOnUndeclaredProperties(templateInfo, options, methodHost) {
    const declaredProps = methodHost.constructor._properties;
    const {
      propertyEffects
    } = templateInfo;
    const {
      instanceProps
    } = options;

    for (let prop in propertyEffects) {
      // Ensure properties with template effects are declared on the outermost
      // host (`methodHost`), unless they are instance props or static functions
      if (!declaredProps[prop] && !(instanceProps && instanceProps[prop])) {
        const effects = propertyEffects[prop];

        for (let i = 0; i < effects.length; i++) {
          const {
            part
          } = effects[i].info;

          if (!(part.signature && part.signature.static)) {
            console.warn(`Property '${prop}' used in template but not ` + `declared in 'properties'; attribute will not be observed.`);
            break;
          }
        }
      }
    }
  }
  /**
   * Returns the template "model" associated with a given element, which
   * serves as the binding scope for the template instance the element is
   * contained in. A template model is an instance of
   * `TemplateInstanceBase`, and should be used to manipulate data
   * associated with this template instance.
   *
   * Example:
   *
   *   let model = modelForElement(el);
   *   if (model.index < 10) {
   *     model.set('item.checked', true);
   *   }
   *
   * @param {HTMLElement} template The model will be returned for
   *   elements stamped from this template (accepts either an HTMLTemplateElement)
   *   or a `<dom-if>`/`<dom-repeat>` element when using `removeNestedTemplates`
   *   optimization.
   * @param {Node=} node Node for which to return a template model.
   * @return {TemplateInstanceBase} Template instance representing the
   *   binding scope for the element
   */


  function modelForElement(template, node) {
    let model;

    while (node) {
      // An element with a __templatizeInstance marks the top boundary
      // of a scope; walk up until we find one, and then ensure that
      // its __dataHost matches `this`, meaning this dom-repeat stamped it
      if (model = node.__dataHost ? node : node.__templatizeInstance) {
        // Found an element stamped by another template; keep walking up
        // from its __dataHost
        if (model.__dataHost != template) {
          node = model.__dataHost;
        } else {
          return model;
        }
      } else {
        // Still in a template scope, keep going up until
        // a __templatizeInstance is found
        node = wrap$1(node).parentNode;
      }
    }

    return null;
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  let elementsHidden = false;
  /**
   * @return {boolean} True if elements will be hidden globally
   */

  function hideElementsGlobally() {
    if (legacyOptimizations && !useShadow) {
      if (!elementsHidden) {
        elementsHidden = true;
        const style = document.createElement('style');
        style.textContent = 'dom-bind,dom-if,dom-repeat{display:none;}';
        document.head.appendChild(style);
      }

      return true;
    }

    return false;
  }

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * @constructor
   * @extends {HTMLElement}
   * @implements {Polymer_PropertyEffects}
   * @implements {Polymer_OptionalMutableData}
   * @implements {Polymer_GestureEventListeners}
   * @private
   */

  const domBindBase = GestureEventListeners(OptionalMutableData(PropertyEffects(HTMLElement)));
  /**
   * Custom element to allow using Polymer's template features (data binding,
   * declarative event listeners, etc.) in the main document without defining
   * a new custom element.
   *
   * `<template>` tags utilizing bindings may be wrapped with the `<dom-bind>`
   * element, which will immediately stamp the wrapped template into the main
   * document and bind elements to the `dom-bind` element itself as the
   * binding scope.
   *
   * @polymer
   * @customElement
   * @appliesMixin PropertyEffects
   * @appliesMixin OptionalMutableData
   * @appliesMixin GestureEventListeners
   * @extends {domBindBase}
   * @summary Custom element to allow using Polymer's template features (data
   *   binding, declarative event listeners, etc.) in the main document.
   */

  class DomBind extends domBindBase {
    static get observedAttributes() {
      return ['mutable-data'];
    }

    constructor() {
      super();

      if (strictTemplatePolicy) {
        throw new Error(`strictTemplatePolicy: dom-bind not allowed`);
      }

      this.root = null;
      this.$ = null;
      this.__children = null;
    }
    /* eslint-disable no-unused-vars */

    /**
     * @override
     * @param {string} name Name of attribute that changed
     * @param {?string} old Old attribute value
     * @param {?string} value New attribute value
     * @param {?string} namespace Attribute namespace.
     * @return {void}
     */


    attributeChangedCallback(name, old, value, namespace) {
      // assumes only one observed attribute
      this.mutableData = true;
    }
    /**
     * @override
     * @return {void}
     */


    connectedCallback() {
      if (!hideElementsGlobally()) {
        this.style.display = 'none';
      }

      this.render();
    }
    /**
     * @override
     * @return {void}
     */


    disconnectedCallback() {
      this.__removeChildren();
    }

    __insertChildren() {
      wrap$1(wrap$1(this).parentNode).insertBefore(this.root, this);
    }

    __removeChildren() {
      if (this.__children) {
        for (let i = 0; i < this.__children.length; i++) {
          this.root.appendChild(this.__children[i]);
        }
      }
    }
    /**
     * Forces the element to render its content. This is typically only
     * necessary to call if HTMLImports with the async attribute are used.
     * @return {void}
     */


    render() {
      let template;

      if (!this.__children) {
        template =
        /** @type {?HTMLTemplateElement} */
        template || this.querySelector('template');

        if (!template) {
          // Wait until childList changes and template should be there by then
          let observer = new MutationObserver(() => {
            template =
            /** @type {HTMLTemplateElement} */
            this.querySelector('template');

            if (template) {
              observer.disconnect();
              this.render();
            } else {
              throw new Error('dom-bind requires a <template> child');
            }
          });
          observer.observe(this, {
            childList: true
          });
          return;
        }

        this.root = this._stampTemplate(
        /** @type {!HTMLTemplateElement} */
        template);
        this.$ = this.root.$;
        this.__children = [];

        for (let n = this.root.firstChild; n; n = n.nextSibling) {
          this.__children[this.__children.length] = n;
        }

        this._enableProperties();
      }

      this.__insertChildren();

      this.dispatchEvent(new CustomEvent('dom-change', {
        bubbles: true,
        composed: true
      }));
    }

  }
  customElements.define('dom-bind', DomBind);

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * Class representing a static string value which can be used to filter
   * strings by asseting that they have been created via this class. The
   * `value` property returns the string passed to the constructor.
   */

  class LiteralString {
    constructor(string) {
      /** @type {string} */
      this.value = string.toString();
    }
    /**
     * @return {string} LiteralString string value
     * @override
     */


    toString() {
      return this.value;
    }

  }
  /**
   * @param {*} value Object to stringify into HTML
   * @return {string} HTML stringified form of `obj`
   */


  function literalValue(value) {
    if (value instanceof LiteralString) {
      return (
        /** @type {!LiteralString} */
        value.value
      );
    } else {
      throw new Error(`non-literal value passed to Polymer's htmlLiteral function: ${value}`);
    }
  }
  /**
   * @param {*} value Object to stringify into HTML
   * @return {string} HTML stringified form of `obj`
   */


  function htmlValue(value) {
    if (value instanceof HTMLTemplateElement) {
      return (
        /** @type {!HTMLTemplateElement } */
        value.innerHTML
      );
    } else if (value instanceof LiteralString) {
      return literalValue(value);
    } else {
      throw new Error(`non-template value passed to Polymer's html function: ${value}`);
    }
  }
  /**
   * A template literal tag that creates an HTML <template> element from the
   * contents of the string.
   *
   * This allows you to write a Polymer Template in JavaScript.
   *
   * Templates can be composed by interpolating `HTMLTemplateElement`s in
   * expressions in the JavaScript template literal. The nested template's
   * `innerHTML` is included in the containing template.  The only other
   * values allowed in expressions are those returned from `htmlLiteral`
   * which ensures only literal values from JS source ever reach the HTML, to
   * guard against XSS risks.
   *
   * All other values are disallowed in expressions to help prevent XSS
   * attacks; however, `htmlLiteral` can be used to compose static
   * string values into templates. This is useful to compose strings into
   * places that do not accept html, like the css text of a `style`
   * element.
   *
   * Example:
   *
   *     static get template() {
   *       return html`
   *         <style>:host{ content:"..." }</style>
   *         <div class="shadowed">${this.partialTemplate}</div>
   *         ${super.template}
   *       `;
   *     }
   *     static get partialTemplate() { return html`<span>Partial!</span>`; }
   *
   * @param {!ITemplateArray} strings Constant parts of tagged template literal
   * @param {...*} values Variable parts of tagged template literal
   * @return {!HTMLTemplateElement} Constructed HTMLTemplateElement
   */


  const html$1 = function html(strings, ...values) {
    const template =
    /** @type {!HTMLTemplateElement} */
    document.createElement('template');
    template.innerHTML = values.reduce((acc, v, idx) => acc + htmlValue(v) + strings[idx + 1], strings[0]);
    return template;
  };

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * Base class that provides the core API for Polymer's meta-programming
   * features including template stamping, data-binding, attribute deserialization,
   * and property change observation.
   *
   * @customElement
   * @polymer
   * @constructor
   * @implements {Polymer_ElementMixin}
   * @extends HTMLElement
   * @appliesMixin ElementMixin
   * @summary Custom element base class that provides the core API for Polymer's
   *   key meta-programming features including template stamping, data-binding,
   *   attribute deserialization, and property change observation
   */

  const PolymerElement = ElementMixin(HTMLElement);

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * @constructor
   * @implements {Polymer_OptionalMutableData}
   * @extends {PolymerElement}
   * @private
   */

  const domRepeatBase = OptionalMutableData(PolymerElement);
  /**
   * The `<dom-repeat>` element will automatically stamp and binds one instance
   * of template content to each object in a user-provided array.
   * `dom-repeat` accepts an `items` property, and one instance of the template
   * is stamped for each item into the DOM at the location of the `dom-repeat`
   * element.  The `item` property will be set on each instance's binding
   * scope, thus templates should bind to sub-properties of `item`.
   *
   * Example:
   *
   * ```html
   * <dom-module id="employee-list">
   *
   *   <template>
   *
   *     <div> Employee list: </div>
   *     <dom-repeat items="{{employees}}">
   *       <template>
   *         <div>First name: <span>{{item.first}}</span></div>
   *         <div>Last name: <span>{{item.last}}</span></div>
   *       </template>
   *     </dom-repeat>
   *
   *   </template>
   *
   * </dom-module>
   * ```
   *
   * With the following custom element definition:
   *
   * ```js
   * class EmployeeList extends PolymerElement {
   *   static get is() { return 'employee-list'; }
   *   static get properties() {
   *     return {
   *       employees: {
   *         value() {
   *           return [
   *             {first: 'Bob', last: 'Smith'},
   *             {first: 'Sally', last: 'Johnson'},
   *             ...
   *           ];
   *         }
   *       }
   *     };
   *   }
   * }
   * ```
   *
   * Notifications for changes to items sub-properties will be forwarded to template
   * instances, which will update via the normal structured data notification system.
   *
   * Mutations to the `items` array itself should be made using the Array
   * mutation API's on the PropertyEffects mixin (`push`, `pop`, `splice`,
   * `shift`, `unshift`), and template instances will be kept in sync with the
   * data in the array.
   *
   * Events caught by event handlers within the `dom-repeat` template will be
   * decorated with a `model` property, which represents the binding scope for
   * each template instance.  The model should be used to manipulate data on the
   * instance, for example `event.model.set('item.checked', true);`.
   *
   * Alternatively, the model for a template instance for an element stamped by
   * a `dom-repeat` can be obtained using the `modelForElement` API on the
   * `dom-repeat` that stamped it, for example
   * `this.$.domRepeat.modelForElement(event.target).set('item.checked', true);`.
   * This may be useful for manipulating instance data of event targets obtained
   * by event handlers on parents of the `dom-repeat` (event delegation).
   *
   * A view-specific filter/sort may be applied to each `dom-repeat` by supplying a
   * `filter` and/or `sort` property.  This may be a string that names a function on
   * the host, or a function may be assigned to the property directly.  The functions
   * should implemented following the standard `Array` filter/sort API.
   *
   * In order to re-run the filter or sort functions based on changes to sub-fields
   * of `items`, the `observe` property may be set as a space-separated list of
   * `item` sub-fields that should cause a re-filter/sort when modified.  If
   * the filter or sort function depends on properties not contained in `items`,
   * the user should observe changes to those properties and call `render` to update
   * the view based on the dependency change.
   *
   * For example, for an `dom-repeat` with a filter of the following:
   *
   * ```js
   * isEngineer(item) {
   *   return item.type == 'engineer' || item.manager.type == 'engineer';
   * }
   * ```
   *
   * Then the `observe` property should be configured as follows:
   *
   * ```html
   * <dom-repeat items="{{employees}}" filter="isEngineer" observe="type manager.type">
   * ```
   *
   * @customElement
   * @polymer
   * @extends {domRepeatBase}
   * @appliesMixin OptionalMutableData
   * @summary Custom element for stamping instance of a template bound to
   *   items in an array.
   */

  class DomRepeat extends domRepeatBase {
    // Not needed to find template; can be removed once the analyzer
    // can find the tag name from customElements.define call
    static get is() {
      return 'dom-repeat';
    }

    static get template() {
      return null;
    }

    static get properties() {
      /**
       * Fired whenever DOM is added or removed by this template (by
       * default, rendering occurs lazily).  To force immediate rendering, call
       * `render`.
       *
       * @event dom-change
       */
      return {
        /**
         * An array containing items determining how many instances of the template
         * to stamp and that that each template instance should bind to.
         */
        items: {
          type: Array
        },

        /**
         * The name of the variable to add to the binding scope for the array
         * element associated with a given template instance.
         */
        as: {
          type: String,
          value: 'item'
        },

        /**
         * The name of the variable to add to the binding scope with the index
         * of the instance in the sorted and filtered list of rendered items.
         * Note, for the index in the `this.items` array, use the value of the
         * `itemsIndexAs` property.
         */
        indexAs: {
          type: String,
          value: 'index'
        },

        /**
         * The name of the variable to add to the binding scope with the index
         * of the instance in the `this.items` array. Note, for the index of
         * this instance in the sorted and filtered list of rendered items,
         * use the value of the `indexAs` property.
         */
        itemsIndexAs: {
          type: String,
          value: 'itemsIndex'
        },

        /**
         * A function that should determine the sort order of the items.  This
         * property should either be provided as a string, indicating a method
         * name on the element's host, or else be an actual function.  The
         * function should match the sort function passed to `Array.sort`.
         * Using a sort function has no effect on the underlying `items` array.
         */
        sort: {
          type: Function,
          observer: '__sortChanged'
        },

        /**
         * A function that can be used to filter items out of the view.  This
         * property should either be provided as a string, indicating a method
         * name on the element's host, or else be an actual function.  The
         * function should match the sort function passed to `Array.filter`.
         * Using a filter function has no effect on the underlying `items` array.
         */
        filter: {
          type: Function,
          observer: '__filterChanged'
        },

        /**
         * When using a `filter` or `sort` function, the `observe` property
         * should be set to a space-separated list of the names of item
         * sub-fields that should trigger a re-sort or re-filter when changed.
         * These should generally be fields of `item` that the sort or filter
         * function depends on.
         */
        observe: {
          type: String,
          observer: '__observeChanged'
        },

        /**
         * When using a `filter` or `sort` function, the `delay` property
         * determines a debounce time in ms after a change to observed item
         * properties that must pass before the filter or sort is re-run.
         * This is useful in rate-limiting shuffling of the view when
         * item changes may be frequent.
         */
        delay: Number,

        /**
         * Count of currently rendered items after `filter` (if any) has been applied.
         * If "chunking mode" is enabled, `renderedItemCount` is updated each time a
         * set of template instances is rendered.
         *
         */
        renderedItemCount: {
          type: Number,
          notify: !suppressTemplateNotifications,
          readOnly: true
        },

        /**
         * When greater than zero, defines an initial count of template instances
         * to render after setting the `items` array, before the next paint, and
         * puts the `dom-repeat` into "chunking mode".  The remaining items (and
         * any future items as a result of pushing onto the array) will be created
         * and rendered incrementally at each animation frame thereof until all
         * instances have been rendered.
         */
        initialCount: {
          type: Number
        },

        /**
         * When `initialCount` is used, this property defines a frame rate (in
         * fps) to target by throttling the number of instances rendered each
         * frame to not exceed the budget for the target frame rate.  The
         * framerate is effectively the number of `requestAnimationFrame`s that
         * it tries to allow to actually fire in a given second. It does this
         * by measuring the time between `rAF`s and continuously adjusting the
         * number of items created each `rAF` to maintain the target framerate.
         * Setting this to a higher number allows lower latency and higher
         * throughput for event handlers and other tasks, but results in a
         * longer time for the remaining items to complete rendering.
         */
        targetFramerate: {
          type: Number,
          value: 20
        },
        _targetFrameTime: {
          type: Number,
          computed: '__computeFrameTime(targetFramerate)'
        },

        /**
         * When the global `suppressTemplateNotifications` setting is used, setting
         * `notifyDomChange: true` will enable firing `dom-change` events on this
         * element.
         */
        notifyDomChange: {
          type: Boolean
        },

        /**
         * When chunking is enabled via `initialCount` and the `items` array is
         * set to a new array, this flag controls whether the previously rendered
         * instances are reused or not.
         *
         * When `true`, any previously rendered template instances are updated in
         * place to their new item values synchronously in one shot, and then any
         * further items (if any) are chunked out.  When `false`, the list is
         * returned back to its `initialCount` (any instances over the initial
         * count are discarded) and the remainder of the list is chunked back in.
         * Set this to `true` to avoid re-creating the list and losing scroll
         * position, although note that when changing the list to completely
         * different data the render thread will be blocked until all existing
         * instances are updated to their new data.
         */
        reuseChunkedInstances: {
          type: Boolean
        }
      };
    }

    static get observers() {
      return ['__itemsChanged(items.*)'];
    }

    constructor() {
      super();
      this.__instances = [];
      this.__renderDebouncer = null;
      this.__itemsIdxToInstIdx = {};
      this.__chunkCount = null;
      this.__renderStartTime = null;
      this.__itemsArrayChanged = false;
      this.__shouldMeasureChunk = false;
      this.__shouldContinueChunking = false;
      this.__chunkingId = 0;
      this.__sortFn = null;
      this.__filterFn = null;
      this.__observePaths = null;
      /** @type {?function(new:TemplateInstanceBase, Object=)} */

      this.__ctor = null;
      this.__isDetached = true;
      this.template = null;
      /** @type {TemplateInfo} */

      this._templateInfo;
    }
    /**
     * @override
     * @return {void}
     */


    disconnectedCallback() {
      super.disconnectedCallback();
      this.__isDetached = true;

      for (let i = 0; i < this.__instances.length; i++) {
        this.__detachInstance(i);
      }
    }
    /**
     * @override
     * @return {void}
     */


    connectedCallback() {
      super.connectedCallback();

      if (!hideElementsGlobally()) {
        this.style.display = 'none';
      } // only perform attachment if the element was previously detached.


      if (this.__isDetached) {
        this.__isDetached = false;
        let wrappedParent = wrap$1(wrap$1(this).parentNode);

        for (let i = 0; i < this.__instances.length; i++) {
          this.__attachInstance(i, wrappedParent);
        }
      }
    }

    __ensureTemplatized() {
      // Templatizing (generating the instance constructor) needs to wait
      // until ready, since won't have its template content handed back to
      // it until then
      if (!this.__ctor) {
        // When `removeNestedTemplates` is true, the "template" is the element
        // itself, which has been given a `_templateInfo` property
        const thisAsTemplate =
        /** @type {!HTMLTemplateElement} */

        /** @type {!HTMLElement} */
        this;
        let template = this.template = thisAsTemplate._templateInfo ? thisAsTemplate :
        /** @type {!HTMLTemplateElement} */
        this.querySelector('template');

        if (!template) {
          // Wait until childList changes and template should be there by then
          let observer = new MutationObserver(() => {
            if (this.querySelector('template')) {
              observer.disconnect();

              this.__render();
            } else {
              throw new Error('dom-repeat requires a <template> child');
            }
          });
          observer.observe(this, {
            childList: true
          });
          return false;
        } // Template instance props that should be excluded from forwarding


        let instanceProps = {};
        instanceProps[this.as] = true;
        instanceProps[this.indexAs] = true;
        instanceProps[this.itemsIndexAs] = true;
        this.__ctor = templatize(template, this, {
          mutableData: this.mutableData,
          parentModel: true,
          instanceProps: instanceProps,

          /**
           * @this {DomRepeat}
           * @param {string} prop Property to set
           * @param {*} value Value to set property to
           */
          forwardHostProp: function (prop, value) {
            let i$ = this.__instances;

            for (let i = 0, inst; i < i$.length && (inst = i$[i]); i++) {
              inst.forwardHostProp(prop, value);
            }
          },

          /**
           * @this {DomRepeat}
           * @param {Object} inst Instance to notify
           * @param {string} prop Property to notify
           * @param {*} value Value to notify
           */
          notifyInstanceProp: function (inst, prop, value) {
            if (matches(this.as, prop)) {
              let idx = inst[this.itemsIndexAs];

              if (prop == this.as) {
                this.items[idx] = value;
              }

              let path = translate(this.as, `${JSCompiler_renameProperty('items', this)}.${idx}`, prop);
              this.notifyPath(path, value);
            }
          }
        });
      }

      return true;
    }

    __getMethodHost() {
      // Technically this should be the owner of the outermost template.
      // In shadow dom, this is always getRootNode().host, but we can
      // approximate this via cooperation with our dataHost always setting
      // `_methodHost` as long as there were bindings (or id's) on this
      // instance causing it to get a dataHost.
      return this.__dataHost._methodHost || this.__dataHost;
    }

    __functionFromPropertyValue(functionOrMethodName) {
      if (typeof functionOrMethodName === 'string') {
        let methodName = functionOrMethodName;

        let obj = this.__getMethodHost();

        return function () {
          return obj[methodName].apply(obj, arguments);
        };
      }

      return functionOrMethodName;
    }

    __sortChanged(sort) {
      this.__sortFn = this.__functionFromPropertyValue(sort);

      if (this.items) {
        this.__debounceRender(this.__render);
      }
    }

    __filterChanged(filter) {
      this.__filterFn = this.__functionFromPropertyValue(filter);

      if (this.items) {
        this.__debounceRender(this.__render);
      }
    }

    __computeFrameTime(rate) {
      return Math.ceil(1000 / rate);
    }

    __observeChanged() {
      this.__observePaths = this.observe && this.observe.replace('.*', '.').split(' ');
    }

    __handleObservedPaths(path) {
      // Handle cases where path changes should cause a re-sort/filter
      if (this.__sortFn || this.__filterFn) {
        if (!path) {
          // Always re-render if the item itself changed
          this.__debounceRender(this.__render, this.delay);
        } else if (this.__observePaths) {
          // Otherwise, re-render if the path changed matches an observed path
          let paths = this.__observePaths;

          for (let i = 0; i < paths.length; i++) {
            if (path.indexOf(paths[i]) === 0) {
              this.__debounceRender(this.__render, this.delay);
            }
          }
        }
      }
    }

    __itemsChanged(change) {
      if (this.items && !Array.isArray(this.items)) {
        console.warn('dom-repeat expected array for `items`, found', this.items);
      } // If path was to an item (e.g. 'items.3' or 'items.3.foo'), forward the
      // path to that instance synchronously (returns false for non-item paths)


      if (!this.__handleItemPath(change.path, change.value)) {
        // Otherwise, the array was reset ('items') or spliced ('items.splices'),
        // so queue a render.  Restart chunking when the items changed (for
        // backward compatibility), unless `reuseChunkedInstances` option is set
        if (change.path === 'items') {
          this.__itemsArrayChanged = true;
        }

        this.__debounceRender(this.__render);
      }
    }
    /**
     * @param {function(this:DomRepeat)} fn Function to debounce.
     * @param {number=} delay Delay in ms to debounce by.
     */


    __debounceRender(fn, delay = 0) {
      this.__renderDebouncer = Debouncer.debounce(this.__renderDebouncer, delay > 0 ? timeOut.after(delay) : microTask, fn.bind(this));
      enqueueDebouncer(this.__renderDebouncer);
    }
    /**
     * Forces the element to render its content. Normally rendering is
     * asynchronous to a provoking change. This is done for efficiency so
     * that multiple changes trigger only a single render. The render method
     * should be called if, for example, template rendering is required to
     * validate application state.
     * @return {void}
     */


    render() {
      // Queue this repeater, then flush all in order
      this.__debounceRender(this.__render);

      flush();
    }

    __render() {
      if (!this.__ensureTemplatized()) {
        // No template found yet
        return;
      }

      let items = this.items || []; // Sort and filter the items into a mapping array from instance->item

      const isntIdxToItemsIdx = this.__sortAndFilterItems(items); // If we're chunking, increase the limit if there are new instances to
      // create and schedule the next chunk


      const limit = this.__calculateLimit(isntIdxToItemsIdx.length); // Create, update, and/or remove instances


      this.__updateInstances(items, limit, isntIdxToItemsIdx); // If we're chunking, schedule a rAF task to measure/continue chunking.     
      // Do this before any notifying events (renderedItemCount & dom-change)
      // since those could modify items and enqueue a new full render which will
      // pre-empt this measurement.


      if (this.initialCount && (this.__shouldMeasureChunk || this.__shouldContinueChunking)) {
        cancelAnimationFrame(this.__chunkingId);
        this.__chunkingId = requestAnimationFrame(() => this.__continueChunking());
      } // Set rendered item count


      this._setRenderedItemCount(this.__instances.length); // Notify users


      if (!suppressTemplateNotifications || this.notifyDomChange) {
        this.dispatchEvent(new CustomEvent('dom-change', {
          bubbles: true,
          composed: true
        }));
      }
    }

    __sortAndFilterItems(items) {
      // Generate array maping the instance index to the items array index
      let isntIdxToItemsIdx = new Array(items.length);

      for (let i = 0; i < items.length; i++) {
        isntIdxToItemsIdx[i] = i;
      } // Apply user filter


      if (this.__filterFn) {
        isntIdxToItemsIdx = isntIdxToItemsIdx.filter((i, idx, array) => this.__filterFn(items[i], idx, array));
      } // Apply user sort


      if (this.__sortFn) {
        isntIdxToItemsIdx.sort((a, b) => this.__sortFn(items[a], items[b]));
      }

      return isntIdxToItemsIdx;
    }

    __calculateLimit(filteredItemCount) {
      let limit = filteredItemCount;
      const currentCount = this.__instances.length; // When chunking, we increase the limit from the currently rendered count
      // by the chunk count that is re-calculated after each rAF (with special
      // cases for reseting the limit to initialCount after changing items)

      if (this.initialCount) {
        let newCount;

        if (!this.__chunkCount || this.__itemsArrayChanged && !this.reuseChunkedInstances) {
          // Limit next render to the initial count
          limit = Math.min(filteredItemCount, this.initialCount); // Subtract off any existing instances to determine the number of
          // instances that will be created

          newCount = Math.max(limit - currentCount, 0); // Initialize the chunk size with how many items we're creating

          this.__chunkCount = newCount || 1;
        } else {
          // The number of new instances that will be created is based on the
          // existing instances, the new list size, and the chunk size
          newCount = Math.min(Math.max(filteredItemCount - currentCount, 0), this.__chunkCount); // Update the limit based on how many new items we're making, limited
          // buy the total size of the list

          limit = Math.min(currentCount + newCount, filteredItemCount);
        } // Record some state about chunking for use in `__continueChunking`


        this.__shouldMeasureChunk = newCount === this.__chunkCount;
        this.__shouldContinueChunking = limit < filteredItemCount;
        this.__renderStartTime = performance.now();
      }

      this.__itemsArrayChanged = false;
      return limit;
    }

    __continueChunking() {
      // Simple auto chunkSize throttling algorithm based on feedback loop:
      // measure actual time between frames and scale chunk count by ratio of
      // target/actual frame time.  Only modify chunk size if our measurement
      // reflects the cost of a creating a full chunk's worth of instances; this
      // avoids scaling up the chunk size if we e.g. quickly re-rendered instances
      // in place
      if (this.__shouldMeasureChunk) {
        const renderTime = performance.now() - this.__renderStartTime;

        const ratio = this._targetFrameTime / renderTime;
        this.__chunkCount = Math.round(this.__chunkCount * ratio) || 1;
      } // Enqueue a new render if we haven't reached the full size of the list


      if (this.__shouldContinueChunking) {
        this.__debounceRender(this.__render);
      }
    }

    __updateInstances(items, limit, isntIdxToItemsIdx) {
      // items->inst map kept for item path forwarding
      const itemsIdxToInstIdx = this.__itemsIdxToInstIdx = {};
      let instIdx; // Generate instances and assign items

      for (instIdx = 0; instIdx < limit; instIdx++) {
        let inst = this.__instances[instIdx];
        let itemIdx = isntIdxToItemsIdx[instIdx];
        let item = items[itemIdx];
        itemsIdxToInstIdx[itemIdx] = instIdx;

        if (inst) {
          inst._setPendingProperty(this.as, item);

          inst._setPendingProperty(this.indexAs, instIdx);

          inst._setPendingProperty(this.itemsIndexAs, itemIdx);

          inst._flushProperties();
        } else {
          this.__insertInstance(item, instIdx, itemIdx);
        }
      } // Remove any extra instances from previous state


      for (let i = this.__instances.length - 1; i >= instIdx; i--) {
        this.__detachAndRemoveInstance(i);
      }
    }

    __detachInstance(idx) {
      let inst = this.__instances[idx];
      const wrappedRoot = wrap$1(inst.root);

      for (let i = 0; i < inst.children.length; i++) {
        let el = inst.children[i];
        wrappedRoot.appendChild(el);
      }

      return inst;
    }

    __attachInstance(idx, parent) {
      let inst = this.__instances[idx]; // Note, this is pre-wrapped as an optimization

      parent.insertBefore(inst.root, this);
    }

    __detachAndRemoveInstance(idx) {
      this.__detachInstance(idx);

      this.__instances.splice(idx, 1);
    }

    __stampInstance(item, instIdx, itemIdx) {
      let model = {};
      model[this.as] = item;
      model[this.indexAs] = instIdx;
      model[this.itemsIndexAs] = itemIdx;
      return new this.__ctor(model);
    }

    __insertInstance(item, instIdx, itemIdx) {
      const inst = this.__stampInstance(item, instIdx, itemIdx);

      let beforeRow = this.__instances[instIdx + 1];
      let beforeNode = beforeRow ? beforeRow.children[0] : this;
      wrap$1(wrap$1(this).parentNode).insertBefore(inst.root, beforeNode);
      this.__instances[instIdx] = inst;
      return inst;
    } // Implements extension point from Templatize mixin

    /**
     * Shows or hides the template instance top level child elements. For
     * text nodes, `textContent` is removed while "hidden" and replaced when
     * "shown."
     * @param {boolean} hidden Set to true to hide the children;
     * set to false to show them.
     * @return {void}
     * @protected
     */


    _showHideChildren(hidden) {
      for (let i = 0; i < this.__instances.length; i++) {
        this.__instances[i]._showHideChildren(hidden);
      }
    } // Called as a side effect of a host items.<key>.<path> path change,
    // responsible for notifying item.<path> changes to inst for key


    __handleItemPath(path, value) {
      let itemsPath = path.slice(6); // 'items.'.length == 6

      let dot = itemsPath.indexOf('.');
      let itemsIdx = dot < 0 ? itemsPath : itemsPath.substring(0, dot); // If path was index into array...

      if (itemsIdx == parseInt(itemsIdx, 10)) {
        let itemSubPath = dot < 0 ? '' : itemsPath.substring(dot + 1); // If the path is observed, it will trigger a full refresh

        this.__handleObservedPaths(itemSubPath); // Note, even if a rull refresh is triggered, always do the path
        // notification because unless mutableData is used for dom-repeat
        // and all elements in the instance subtree, a full refresh may
        // not trigger the proper update.


        let instIdx = this.__itemsIdxToInstIdx[itemsIdx];
        let inst = this.__instances[instIdx];

        if (inst) {
          let itemPath = this.as + (itemSubPath ? '.' + itemSubPath : ''); // This is effectively `notifyPath`, but avoids some of the overhead
          // of the public API

          inst._setPendingPropertyOrPath(itemPath, value, false, true);

          inst._flushProperties();
        }

        return true;
      }
    }
    /**
     * Returns the item associated with a given element stamped by
     * this `dom-repeat`.
     *
     * Note, to modify sub-properties of the item,
     * `modelForElement(el).set('item.<sub-prop>', value)`
     * should be used.
     *
     * @param {!HTMLElement} el Element for which to return the item.
     * @return {*} Item associated with the element.
     */


    itemForElement(el) {
      let instance = this.modelForElement(el);
      return instance && instance[this.as];
    }
    /**
     * Returns the inst index for a given element stamped by this `dom-repeat`.
     * If `sort` is provided, the index will reflect the sorted order (rather
     * than the original array order).
     *
     * @param {!HTMLElement} el Element for which to return the index.
     * @return {?number} Row index associated with the element (note this may
     *   not correspond to the array index if a user `sort` is applied).
     */


    indexForElement(el) {
      let instance = this.modelForElement(el);
      return instance && instance[this.indexAs];
    }
    /**
     * Returns the template "model" associated with a given element, which
     * serves as the binding scope for the template instance the element is
     * contained in. A template model
     * should be used to manipulate data associated with this template instance.
     *
     * Example:
     *
     *   let model = modelForElement(el);
     *   if (model.index < 10) {
     *     model.set('item.checked', true);
     *   }
     *
     * @param {!HTMLElement} el Element for which to return a template model.
     * @return {TemplateInstanceBase} Model representing the binding scope for
     *   the element.
     */


    modelForElement(el) {
      return modelForElement(this.template, el);
    }

  }
  customElements.define(DomRepeat.is, DomRepeat);

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * @customElement
   * @polymer
   * @extends PolymerElement
   * @summary Base class for dom-if element; subclassed into concrete
   *   implementation.
   */

  class DomIfBase extends PolymerElement {
    // Not needed to find template; can be removed once the analyzer
    // can find the tag name from customElements.define call
    static get is() {
      return 'dom-if';
    }

    static get template() {
      return null;
    }

    static get properties() {
      return {
        /**
         * Fired whenever DOM is added or removed/hidden by this template (by
         * default, rendering occurs lazily).  To force immediate rendering, call
         * `render`.
         *
         * @event dom-change
         */

        /**
         * A boolean indicating whether this template should stamp.
         */
        if: {
          type: Boolean,
          observer: '__debounceRender'
        },

        /**
         * When true, elements will be removed from DOM and discarded when `if`
         * becomes false and re-created and added back to the DOM when `if`
         * becomes true.  By default, stamped elements will be hidden but left
         * in the DOM when `if` becomes false, which is generally results
         * in better performance.
         */
        restamp: {
          type: Boolean,
          observer: '__debounceRender'
        },

        /**
         * When the global `suppressTemplateNotifications` setting is used, setting
         * `notifyDomChange: true` will enable firing `dom-change` events on this
         * element.
         */
        notifyDomChange: {
          type: Boolean
        }
      };
    }

    constructor() {
      super();
      this.__renderDebouncer = null;
      this._lastIf = false;
      this.__hideTemplateChildren__ = false;
      /** @type {!HTMLTemplateElement|undefined} */

      this.__template;
      /** @type {!TemplateInfo|undefined} */

      this._templateInfo;
    }

    __debounceRender() {
      // Render is async for 2 reasons:
      // 1. To eliminate dom creation trashing if user code thrashes `if` in the
      //    same turn. This was more common in 1.x where a compound computed
      //    property could result in the result changing multiple times, but is
      //    mitigated to a large extent by batched property processing in 2.x.
      // 2. To avoid double object propagation when a bag including values bound
      //    to the `if` property as well as one or more hostProps could enqueue
      //    the <dom-if> to flush before the <template>'s host property
      //    forwarding. In that scenario creating an instance would result in
      //    the host props being set once, and then the enqueued changes on the
      //    template would set properties a second time, potentially causing an
      //    object to be set to an instance more than once.  Creating the
      //    instance async from flushing data ensures this doesn't happen. If
      //    we wanted a sync option in the future, simply having <dom-if> flush
      //    (or clear) its template's pending host properties before creating
      //    the instance would also avoid the problem.
      this.__renderDebouncer = Debouncer.debounce(this.__renderDebouncer, microTask, () => this.__render());
      enqueueDebouncer(this.__renderDebouncer);
    }
    /**
     * @override
     * @return {void}
     */


    disconnectedCallback() {
      super.disconnectedCallback();
      const parent = wrap$1(this).parentNode;

      if (!parent || parent.nodeType == Node.DOCUMENT_FRAGMENT_NODE && !wrap$1(parent).host) {
        this.__teardownInstance();
      }
    }
    /**
     * @override
     * @return {void}
     */


    connectedCallback() {
      super.connectedCallback();

      if (!hideElementsGlobally()) {
        this.style.display = 'none';
      }

      if (this.if) {
        this.__debounceRender();
      }
    }
    /**
     * Ensures a template has been assigned to `this.__template`.  If it has not
     * yet been, it querySelectors for it in its children and if it does not yet
     * exist (e.g. in parser-generated case), opens a mutation observer and
     * waits for it to appear (returns false if it has not yet been found,
     * otherwise true).  In the `removeNestedTemplates` case, the "template" will
     * be the `dom-if` element itself.
     *
     * @return {boolean} True when a template has been found, false otherwise
     */


    __ensureTemplate() {
      if (!this.__template) {
        // When `removeNestedTemplates` is true, the "template" is the element
        // itself, which has been given a `_templateInfo` property
        const thisAsTemplate =
        /** @type {!HTMLTemplateElement} */

        /** @type {!HTMLElement} */
        this;
        let template = thisAsTemplate._templateInfo ? thisAsTemplate :
        /** @type {!HTMLTemplateElement} */
        wrap$1(thisAsTemplate).querySelector('template');

        if (!template) {
          // Wait until childList changes and template should be there by then
          let observer = new MutationObserver(() => {
            if (wrap$1(this).querySelector('template')) {
              observer.disconnect();

              this.__render();
            } else {
              throw new Error('dom-if requires a <template> child');
            }
          });
          observer.observe(this, {
            childList: true
          });
          return false;
        }

        this.__template = template;
      }

      return true;
    }
    /**
     * Ensures a an instance of the template has been created and inserted. This
     * method may return false if the template has not yet been found or if
     * there is no `parentNode` to insert the template into (in either case,
     * connection or the template-finding mutation observer firing will queue
     * another render, causing this method to be called again at a more
     * appropriate time).
     *
     * Subclasses should implement the following methods called here:
     * - `__hasInstance`
     * - `__createAndInsertInstance`
     * - `__getInstanceNodes`
     *
     * @return {boolean} True if the instance was created, false otherwise.
     */


    __ensureInstance() {
      let parentNode = wrap$1(this).parentNode;

      if (!this.__hasInstance()) {
        // Guard against element being detached while render was queued
        if (!parentNode) {
          return false;
        } // Find the template (when false, there was no template yet)


        if (!this.__ensureTemplate()) {
          return false;
        }

        this.__createAndInsertInstance(parentNode);
      } else {
        // Move instance children if necessary
        let children = this.__getInstanceNodes();

        if (children && children.length) {
          // Detect case where dom-if was re-attached in new position
          let lastChild = wrap$1(this).previousSibling;

          if (lastChild !== children[children.length - 1]) {
            for (let i = 0, n; i < children.length && (n = children[i]); i++) {
              wrap$1(parentNode).insertBefore(n, this);
            }
          }
        }
      }

      return true;
    }
    /**
     * Forces the element to render its content. Normally rendering is
     * asynchronous to a provoking change. This is done for efficiency so
     * that multiple changes trigger only a single render. The render method
     * should be called if, for example, template rendering is required to
     * validate application state.
     *
     * @return {void}
     */


    render() {
      flush();
    }
    /**
     * Performs the key rendering steps:
     * 1. Ensure a template instance has been stamped (when true)
     * 2. Remove the template instance (when false and restamp:true)
     * 3. Sync the hidden state of the instance nodes with the if/restamp state
     * 4. Fires the `dom-change` event when necessary
     *
     * @return {void}
     */


    __render() {
      if (this.if) {
        if (!this.__ensureInstance()) {
          // No template found yet
          return;
        }
      } else if (this.restamp) {
        this.__teardownInstance();
      }

      this._showHideChildren();

      if ((!suppressTemplateNotifications || this.notifyDomChange) && this.if != this._lastIf) {
        this.dispatchEvent(new CustomEvent('dom-change', {
          bubbles: true,
          composed: true
        }));
        this._lastIf = this.if;
      }
    } // Ideally these would be annotated as abstract methods in an abstract class,
    // but closure compiler is finnicky

    /* eslint-disable valid-jsdoc */

    /**
     * Abstract API to be implemented by subclass: Returns true if a template
     * instance has been created and inserted.
     *
     * @protected
     * @return {boolean} True when an instance has been created.
     */


    __hasInstance() {}
    /**
     * Abstract API to be implemented by subclass: Returns the child nodes stamped
     * from a template instance.
     *
     * @protected
     * @return {Array<Node>} Array of child nodes stamped from the template
     * instance.
     */


    __getInstanceNodes() {}
    /**
     * Abstract API to be implemented by subclass: Creates an instance of the
     * template and inserts it into the given parent node.
     *
     * @protected
     * @param {Node} parentNode The parent node to insert the instance into
     * @return {void}
     */


    __createAndInsertInstance(parentNode) {} // eslint-disable-line no-unused-vars

    /**
     * Abstract API to be implemented by subclass: Removes nodes created by an
     * instance of a template and any associated cleanup.
     *
     * @protected
     * @return {void}
     */


    __teardownInstance() {}
    /**
     * Abstract API to be implemented by subclass: Shows or hides any template
     * instance childNodes based on the `if` state of the element and its
     * `__hideTemplateChildren__` property.
     *
     * @protected
     * @return {void}
     */


    _showHideChildren() {}
    /* eslint-enable valid-jsdoc */


  }
  /**
   * The version of DomIf used when `fastDomIf` setting is in use, which is
   * optimized for first-render (but adds a tax to all subsequent property updates
   * on the host, whether they were used in a given `dom-if` or not).
   *
   * This implementation avoids use of `Templatizer`, which introduces a new scope
   * (a non-element PropertyEffects instance), which is not strictly necessary
   * since `dom-if` never introduces new properties to its scope (unlike
   * `dom-repeat`). Taking advantage of this fact, the `dom-if` reaches up to its
   * `__dataHost` and stamps the template directly from the host using the host's
   * runtime `_stampTemplate` API, which binds the property effects of the
   * template directly to the host. This both avoids the intermediary
   * `Templatizer` instance, but also avoids the need to bind host properties to
   * the `<template>` element and forward those into the template instance.
   *
   * In this version of `dom-if`, the `this.__instance` method is the
   * `DocumentFragment` returned from `_stampTemplate`, which also serves as the
   * handle for later removing it using the `_removeBoundDom` method.
   */


  class DomIfFast extends DomIfBase {
    constructor() {
      super();
      this.__instance = null;
      this.__syncInfo = null;
    }
    /**
     * Implementation of abstract API needed by DomIfBase.
     *
     * @override
     * @return {boolean} True when an instance has been created.
     */


    __hasInstance() {
      return Boolean(this.__instance);
    }
    /**
     * Implementation of abstract API needed by DomIfBase.
     *
     * @override
     * @return {Array<Node>} Array of child nodes stamped from the template
     * instance.
     */


    __getInstanceNodes() {
      return this.__instance.templateInfo.childNodes;
    }
    /**
     * Implementation of abstract API needed by DomIfBase.
     *
     * Stamps the template by calling `_stampTemplate` on the `__dataHost` of this
     * element and then inserts the resulting nodes into the given `parentNode`.
     *
     * @override
     * @param {Node} parentNode The parent node to insert the instance into
     * @return {void}
     */


    __createAndInsertInstance(parentNode) {
      const host = this.__dataHost || this;

      if (strictTemplatePolicy) {
        if (!this.__dataHost) {
          throw new Error('strictTemplatePolicy: template owner not trusted');
        }
      } // Pre-bind and link the template into the effects system


      const templateInfo = host._bindTemplate(
      /** @type {!HTMLTemplateElement} */
      this.__template, true); // Install runEffects hook that prevents running property effects
      // (and any nested template effects) when the `if` is false


      templateInfo.runEffects = (runEffects, changedProps, hasPaths) => {
        let syncInfo = this.__syncInfo;

        if (this.if) {
          // Mix any props that changed while the `if` was false into `changedProps`
          if (syncInfo) {
            // If there were properties received while the `if` was false, it is
            // important to sync the hidden state with the element _first_, so that
            // new bindings to e.g. `textContent` do not get stomped on by
            // pre-hidden values if `_showHideChildren` were to be called later at
            // the next render. Clearing `__invalidProps` here ensures
            // `_showHideChildren`'s call to `__syncHostProperties` no-ops, so
            // that we don't call `runEffects` more often than necessary.
            this.__syncInfo = null;

            this._showHideChildren();

            changedProps = Object.assign(syncInfo.changedProps, changedProps);
          }

          runEffects(changedProps, hasPaths);
        } else {
          // Accumulate any values changed while `if` was false, along with the
          // runEffects method to sync them, so that we can replay them once `if`
          // becomes true
          if (this.__instance) {
            if (!syncInfo) {
              syncInfo = this.__syncInfo = {
                runEffects,
                changedProps: {}
              };
            }

            if (hasPaths) {
              // Store root object of any paths; this will ensure direct bindings
              // like [[obj.foo]] bindings run after a `set('obj.foo', v)`, but
              // note that path notifications like `set('obj.foo.bar', v)` will
              // not propagate. Since batched path notifications are not
              // supported, we cannot simply accumulate path notifications. This
              // is equivalent to the non-fastDomIf case, which stores root(p) in
              // __invalidProps.
              for (const p in changedProps) {
                const rootProp = root(p);
                syncInfo.changedProps[rootProp] = this.__dataHost[rootProp];
              }
            } else {
              Object.assign(syncInfo.changedProps, changedProps);
            }
          }
        }
      }; // Stamp the template, and set its DocumentFragment to the "instance"


      this.__instance = host._stampTemplate(
      /** @type {!HTMLTemplateElement} */
      this.__template, templateInfo);
      wrap$1(parentNode).insertBefore(this.__instance, this);
    }
    /**
     * Run effects for any properties that changed while the `if` was false.
     *
     * @return {void}
     */


    __syncHostProperties() {
      const syncInfo = this.__syncInfo;

      if (syncInfo) {
        this.__syncInfo = null;
        syncInfo.runEffects(syncInfo.changedProps, false);
      }
    }
    /**
     * Implementation of abstract API needed by DomIfBase.
     *
     * Remove the instance and any nodes it created.  Uses the `__dataHost`'s
     * runtime `_removeBoundDom` method.
     *
     * @override
     * @return {void}
     */


    __teardownInstance() {
      const host = this.__dataHost || this;

      if (this.__instance) {
        host._removeBoundDom(this.__instance);

        this.__instance = null;
        this.__syncInfo = null;
      }
    }
    /**
     * Implementation of abstract API needed by DomIfBase.
     *
     * Shows or hides the template instance top level child nodes. For
     * text nodes, `textContent` is removed while "hidden" and replaced when
     * "shown."
     *
     * @override
     * @return {void}
     * @protected
     * @suppress {visibility}
     */


    _showHideChildren() {
      const hidden = this.__hideTemplateChildren__ || !this.if;

      if (this.__instance && Boolean(this.__instance.__hidden) !== hidden) {
        this.__instance.__hidden = hidden;
        showHideChildren(hidden, this.__instance.templateInfo.childNodes);
      }

      if (!hidden) {
        this.__syncHostProperties();
      }
    }

  }
  /**
   * The "legacy" implementation of `dom-if`, implemented using `Templatizer`.
   *
   * In this version, `this.__instance` is the `TemplateInstance` returned
   * from the templatized constructor.
   */


  class DomIfLegacy extends DomIfBase {
    constructor() {
      super();
      this.__ctor = null;
      this.__instance = null;
      this.__invalidProps = null;
    }
    /**
     * Implementation of abstract API needed by DomIfBase.
     *
     * @override
     * @return {boolean} True when an instance has been created.
     */


    __hasInstance() {
      return Boolean(this.__instance);
    }
    /**
     * Implementation of abstract API needed by DomIfBase.
     *
     * @override
     * @return {Array<Node>} Array of child nodes stamped from the template
     * instance.
     */


    __getInstanceNodes() {
      return this.__instance.children;
    }
    /**
     * Implementation of abstract API needed by DomIfBase.
     *
     * Stamps the template by creating a new instance of the templatized
     * constructor (which is created lazily if it does not yet exist), and then
     * inserts its resulting `root` doc fragment into the given `parentNode`.
     *
     * @override
     * @param {Node} parentNode The parent node to insert the instance into
     * @return {void}
     */


    __createAndInsertInstance(parentNode) {
      // Ensure we have an instance constructor
      if (!this.__ctor) {
        this.__ctor = templatize(
        /** @type {!HTMLTemplateElement} */
        this.__template, this, {
          // dom-if templatizer instances require `mutable: true`, as
          // `__syncHostProperties` relies on that behavior to sync objects
          mutableData: true,

          /**
           * @param {string} prop Property to forward
           * @param {*} value Value of property
           * @this {DomIfLegacy}
           */
          forwardHostProp: function (prop, value) {
            if (this.__instance) {
              if (this.if) {
                this.__instance.forwardHostProp(prop, value);
              } else {
                // If we have an instance but are squelching host property
                // forwarding due to if being false, note the invalidated
                // properties so `__syncHostProperties` can sync them the next
                // time `if` becomes true
                this.__invalidProps = this.__invalidProps || Object.create(null);
                this.__invalidProps[root(prop)] = true;
              }
            }
          }
        });
      } // Create and insert the instance


      this.__instance = new this.__ctor();
      wrap$1(parentNode).insertBefore(this.__instance.root, this);
    }
    /**
     * Implementation of abstract API needed by DomIfBase.
     *
     * Removes the instance and any nodes it created.
     *
     * @override
     * @return {void}
     */


    __teardownInstance() {
      if (this.__instance) {
        let c$ = this.__instance.children;

        if (c$ && c$.length) {
          // use first child parent, for case when dom-if may have been detached
          let parent = wrap$1(c$[0]).parentNode; // Instance children may be disconnected from parents when dom-if
          // detaches if a tree was innerHTML'ed

          if (parent) {
            parent = wrap$1(parent);

            for (let i = 0, n; i < c$.length && (n = c$[i]); i++) {
              parent.removeChild(n);
            }
          }
        }

        this.__invalidProps = null;
        this.__instance = null;
      }
    }
    /**
     * Forwards any properties that changed while the `if` was false into the
     * template instance and flushes it.
     *
     * @return {void}
     */


    __syncHostProperties() {
      let props = this.__invalidProps;

      if (props) {
        this.__invalidProps = null;

        for (let prop in props) {
          this.__instance._setPendingProperty(prop, this.__dataHost[prop]);
        }

        this.__instance._flushProperties();
      }
    }
    /**
     * Implementation of abstract API needed by DomIfBase.
     *
     * Shows or hides the template instance top level child elements. For
     * text nodes, `textContent` is removed while "hidden" and replaced when
     * "shown."
     *
     * @override
     * @protected
     * @return {void}
     * @suppress {visibility}
     */


    _showHideChildren() {
      const hidden = this.__hideTemplateChildren__ || !this.if;

      if (this.__instance && Boolean(this.__instance.__hidden) !== hidden) {
        this.__instance.__hidden = hidden;

        this.__instance._showHideChildren(hidden);
      }

      if (!hidden) {
        this.__syncHostProperties();
      }
    }

  }
  /**
   * The `<dom-if>` element will stamp a light-dom `<template>` child when
   * the `if` property becomes truthy, and the template can use Polymer
   * data-binding and declarative event features when used in the context of
   * a Polymer element's template.
   *
   * When `if` becomes falsy, the stamped content is hidden but not
   * removed from dom. When `if` subsequently becomes truthy again, the content
   * is simply re-shown. This approach is used due to its favorable performance
   * characteristics: the expense of creating template content is paid only
   * once and lazily.
   *
   * Set the `restamp` property to true to force the stamped content to be
   * created / destroyed when the `if` condition changes.
   *
   * @customElement
   * @polymer
   * @extends DomIfBase
   * @constructor
   * @summary Custom element that conditionally stamps and hides or removes
   *   template content based on a boolean flag.
   */


  const DomIf = fastDomIf ? DomIfFast : DomIfLegacy;
  customElements.define(DomIf.is, DomIf);

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  /**
   * Element mixin for recording dynamic associations between item paths in a
   * master `items` array and a `selected` array such that path changes to the
   * master array (at the host) element or elsewhere via data-binding) are
   * correctly propagated to items in the selected array and vice-versa.
   *
   * The `items` property accepts an array of user data, and via the
   * `select(item)` and `deselect(item)` API, updates the `selected` property
   * which may be bound to other parts of the application, and any changes to
   * sub-fields of `selected` item(s) will be kept in sync with items in the
   * `items` array.  When `multi` is false, `selected` is a property
   * representing the last selected item.  When `multi` is true, `selected`
   * is an array of multiply selected items.
   *
   * @polymer
   * @mixinFunction
   * @appliesMixin ElementMixin
   * @summary Element mixin for recording dynamic associations between item paths in a
   * master `items` array and a `selected` array
   */

  let ArraySelectorMixin = dedupingMixin(superClass => {
    /**
     * @constructor
     * @implements {Polymer_ElementMixin}
     * @private
     */
    let elementBase = ElementMixin(superClass);
    /**
     * @polymer
     * @mixinClass
     * @implements {Polymer_ArraySelectorMixin}
     * @unrestricted
     */

    class ArraySelectorMixin extends elementBase {
      static get properties() {
        return {
          /**
           * An array containing items from which selection will be made.
           */
          items: {
            type: Array
          },

          /**
           * When `true`, multiple items may be selected at once (in this case,
           * `selected` is an array of currently selected items).  When `false`,
           * only one item may be selected at a time.
           */
          multi: {
            type: Boolean,
            value: false
          },

          /**
           * When `multi` is true, this is an array that contains any selected.
           * When `multi` is false, this is the currently selected item, or `null`
           * if no item is selected.
           * @type {?Object|?Array<!Object>}
           */
          selected: {
            type: Object,
            notify: true
          },

          /**
           * When `multi` is false, this is the currently selected item, or `null`
           * if no item is selected.
           * @type {?Object}
           */
          selectedItem: {
            type: Object,
            notify: true
          },

          /**
           * When `true`, calling `select` on an item that is already selected
           * will deselect the item.
           */
          toggle: {
            type: Boolean,
            value: false
          }
        };
      }

      static get observers() {
        return ['__updateSelection(multi, items.*)'];
      }

      constructor() {
        super();
        this.__lastItems = null;
        this.__lastMulti = null;
        this.__selectedMap = null;
      }

      __updateSelection(multi, itemsInfo) {
        let path = itemsInfo.path;

        if (path == JSCompiler_renameProperty('items', this)) {
          // Case 1 - items array changed, so diff against previous array and
          // deselect any removed items and adjust selected indices
          let newItems = itemsInfo.base || [];
          let lastItems = this.__lastItems;
          let lastMulti = this.__lastMulti;

          if (multi !== lastMulti) {
            this.clearSelection();
          }

          if (lastItems) {
            let splices = calculateSplices(newItems, lastItems);

            this.__applySplices(splices);
          }

          this.__lastItems = newItems;
          this.__lastMulti = multi;
        } else if (itemsInfo.path == `${JSCompiler_renameProperty('items', this)}.splices`) {
          // Case 2 - got specific splice information describing the array mutation:
          // deselect any removed items and adjust selected indices
          this.__applySplices(itemsInfo.value.indexSplices);
        } else {
          // Case 3 - an array element was changed, so deselect the previous
          // item for that index if it was previously selected
          let part = path.slice(`${JSCompiler_renameProperty('items', this)}.`.length);
          let idx = parseInt(part, 10);

          if (part.indexOf('.') < 0 && part == idx) {
            this.__deselectChangedIdx(idx);
          }
        }
      }

      __applySplices(splices) {
        let selected = this.__selectedMap; // Adjust selected indices and mark removals

        for (let i = 0; i < splices.length; i++) {
          let s = splices[i];
          selected.forEach((idx, item) => {
            if (idx < s.index) ; else if (idx >= s.index + s.removed.length) {
              // adjust index
              selected.set(item, idx + s.addedCount - s.removed.length);
            } else {
              // remove index
              selected.set(item, -1);
            }
          });

          for (let j = 0; j < s.addedCount; j++) {
            let idx = s.index + j;

            if (selected.has(this.items[idx])) {
              selected.set(this.items[idx], idx);
            }
          }
        } // Update linked paths


        this.__updateLinks(); // Remove selected items that were removed from the items array


        let sidx = 0;
        selected.forEach((idx, item) => {
          if (idx < 0) {
            if (this.multi) {
              this.splice(JSCompiler_renameProperty('selected', this), sidx, 1);
            } else {
              this.selected = this.selectedItem = null;
            }

            selected.delete(item);
          } else {
            sidx++;
          }
        });
      }

      __updateLinks() {
        this.__dataLinkedPaths = {};

        if (this.multi) {
          let sidx = 0;

          this.__selectedMap.forEach(idx => {
            if (idx >= 0) {
              this.linkPaths(`${JSCompiler_renameProperty('items', this)}.${idx}`, `${JSCompiler_renameProperty('selected', this)}.${sidx++}`);
            }
          });
        } else {
          this.__selectedMap.forEach(idx => {
            this.linkPaths(JSCompiler_renameProperty('selected', this), `${JSCompiler_renameProperty('items', this)}.${idx}`);
            this.linkPaths(JSCompiler_renameProperty('selectedItem', this), `${JSCompiler_renameProperty('items', this)}.${idx}`);
          });
        }
      }
      /**
       * Clears the selection state.
       * @override
       * @return {void}
       */


      clearSelection() {
        // Unbind previous selection
        this.__dataLinkedPaths = {}; // The selected map stores 3 pieces of information:
        // key: items array object
        // value: items array index
        // order: selected array index

        this.__selectedMap = new Map(); // Initialize selection

        this.selected = this.multi ? [] : null;
        this.selectedItem = null;
      }
      /**
       * Returns whether the item is currently selected.
       *
       * @override
       * @param {*} item Item from `items` array to test
       * @return {boolean} Whether the item is selected
       */


      isSelected(item) {
        return this.__selectedMap.has(item);
      }
      /**
       * Returns whether the item is currently selected.
       *
       * @override
       * @param {number} idx Index from `items` array to test
       * @return {boolean} Whether the item is selected
       */


      isIndexSelected(idx) {
        return this.isSelected(this.items[idx]);
      }

      __deselectChangedIdx(idx) {
        let sidx = this.__selectedIndexForItemIndex(idx);

        if (sidx >= 0) {
          let i = 0;

          this.__selectedMap.forEach((idx, item) => {
            if (sidx == i++) {
              this.deselect(item);
            }
          });
        }
      }

      __selectedIndexForItemIndex(idx) {
        let selected = this.__dataLinkedPaths[`${JSCompiler_renameProperty('items', this)}.${idx}`];

        if (selected) {
          return parseInt(selected.slice(`${JSCompiler_renameProperty('selected', this)}.`.length), 10);
        }
      }
      /**
       * Deselects the given item if it is already selected.
       *
       * @override
       * @param {*} item Item from `items` array to deselect
       * @return {void}
       */


      deselect(item) {
        let idx = this.__selectedMap.get(item);

        if (idx >= 0) {
          this.__selectedMap.delete(item);

          let sidx;

          if (this.multi) {
            sidx = this.__selectedIndexForItemIndex(idx);
          }

          this.__updateLinks();

          if (this.multi) {
            this.splice(JSCompiler_renameProperty('selected', this), sidx, 1);
          } else {
            this.selected = this.selectedItem = null;
          }
        }
      }
      /**
       * Deselects the given index if it is already selected.
       *
       * @override
       * @param {number} idx Index from `items` array to deselect
       * @return {void}
       */


      deselectIndex(idx) {
        this.deselect(this.items[idx]);
      }
      /**
       * Selects the given item.  When `toggle` is true, this will automatically
       * deselect the item if already selected.
       *
       * @override
       * @param {*} item Item from `items` array to select
       * @return {void}
       */


      select(item) {
        this.selectIndex(this.items.indexOf(item));
      }
      /**
       * Selects the given index.  When `toggle` is true, this will automatically
       * deselect the item if already selected.
       *
       * @override
       * @param {number} idx Index from `items` array to select
       * @return {void}
       */


      selectIndex(idx) {
        let item = this.items[idx];

        if (!this.isSelected(item)) {
          if (!this.multi) {
            this.__selectedMap.clear();
          }

          this.__selectedMap.set(item, idx);

          this.__updateLinks();

          if (this.multi) {
            this.push(JSCompiler_renameProperty('selected', this), item);
          } else {
            this.selected = this.selectedItem = item;
          }
        } else if (this.toggle) {
          this.deselectIndex(idx);
        }
      }

    }

    return ArraySelectorMixin;
  }); // export mixin
  /**
   * @constructor
   * @extends {PolymerElement}
   * @implements {Polymer_ArraySelectorMixin}
   * @private
   */

  let baseArraySelector = ArraySelectorMixin(PolymerElement);
  /**
   * Element implementing the `ArraySelector` mixin, which records
   * dynamic associations between item paths in a master `items` array and a
   * `selected` array such that path changes to the master array (at the host)
   * element or elsewhere via data-binding) are correctly propagated to items
   * in the selected array and vice-versa.
   *
   * The `items` property accepts an array of user data, and via the
   * `select(item)` and `deselect(item)` API, updates the `selected` property
   * which may be bound to other parts of the application, and any changes to
   * sub-fields of `selected` item(s) will be kept in sync with items in the
   * `items` array.  When `multi` is false, `selected` is a property
   * representing the last selected item.  When `multi` is true, `selected`
   * is an array of multiply selected items.
   *
   * Example:
   *
   * ```js
   * import {PolymerElement} from '@polymer/polymer';
   * import '@polymer/polymer/lib/elements/array-selector.js';
   *
   * class EmployeeList extends PolymerElement {
   *   static get _template() {
   *     return html`
   *         <div> Employee list: </div>
   *         <dom-repeat id="employeeList" items="{{employees}}">
   *           <template>
   *             <div>First name: <span>{{item.first}}</span></div>
   *               <div>Last name: <span>{{item.last}}</span></div>
   *               <button on-click="toggleSelection">Select</button>
   *           </template>
   *         </dom-repeat>
   *
   *         <array-selector id="selector"
   *                         items="{{employees}}"
   *                         selected="{{selected}}"
   *                         multi toggle></array-selector>
   *
   *         <div> Selected employees: </div>
   *         <dom-repeat items="{{selected}}">
   *           <template>
   *             <div>First name: <span>{{item.first}}</span></div>
   *             <div>Last name: <span>{{item.last}}</span></div>
   *           </template>
   *         </dom-repeat>`;
   *   }
   *   static get is() { return 'employee-list'; }
   *   static get properties() {
   *     return {
   *       employees: {
   *         value() {
   *           return [
   *             {first: 'Bob', last: 'Smith'},
   *             {first: 'Sally', last: 'Johnson'},
   *             ...
   *           ];
   *         }
   *       }
   *     };
   *   }
   *   toggleSelection(e) {
   *     const item = this.$.employeeList.itemForElement(e.target);
   *     this.$.selector.select(item);
   *   }
   * }
   * ```
   *
   * @polymer
   * @customElement
   * @extends {baseArraySelector}
   * @appliesMixin ArraySelectorMixin
   * @summary Custom element that links paths between an input `items` array and
   *   an output `selected` item or array based on calls to its selection API.
   */

  class ArraySelector extends baseArraySelector {
    // Not needed to find template; can be removed once the analyzer
    // can find the tag name from customElements.define call
    static get is() {
      return 'array-selector';
    }

    static get template() {
      return null;
    }

  }

  customElements.define(ArraySelector.is, ArraySelector);

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  const customStyleInterface = new CustomStyleInterface();

  if (!window.ShadyCSS) {
    window.ShadyCSS = {
      /**
       * @param {!HTMLTemplateElement} template
       * @param {string} elementName
       * @param {string=} elementExtends
       */
      prepareTemplate(template, elementName, elementExtends) {},

      // eslint-disable-line no-unused-vars

      /**
       * @param {!HTMLTemplateElement} template
       * @param {string} elementName
       */
      prepareTemplateDom(template, elementName) {},

      // eslint-disable-line no-unused-vars

      /**
       * @param {!HTMLTemplateElement} template
       * @param {string} elementName
       * @param {string=} elementExtends
       */
      prepareTemplateStyles(template, elementName, elementExtends) {},

      // eslint-disable-line no-unused-vars

      /**
       * @param {Element} element
       * @param {Object=} properties
       */
      styleSubtree(element, properties) {
        customStyleInterface.processStyles();
        updateNativeProperties(element, properties);
      },

      /**
       * @param {Element} element
       */
      styleElement(element) {
        // eslint-disable-line no-unused-vars
        customStyleInterface.processStyles();
      },

      /**
       * @param {Object=} properties
       */
      styleDocument(properties) {
        customStyleInterface.processStyles();
        updateNativeProperties(document.body, properties);
      },

      /**
       * @param {Element} element
       * @param {string} property
       * @return {string}
       */
      getComputedStyleValue(element, property) {
        return getComputedStyleValue(element, property);
      },

      flushCustomStyles() {},

      nativeCss: nativeCssVariables,
      nativeShadow: nativeShadow,
      cssBuild: cssBuild,
      disableRuntime: disableRuntime
    };
  }

  window.ShadyCSS.CustomStyleInterface = customStyleInterface;

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */
  const attr = 'include';
  const CustomStyleInterface$1 = window.ShadyCSS.CustomStyleInterface;
  /**
   * Custom element for defining styles in the main document that can take
   * advantage of [shady DOM](https://github.com/webcomponents/shadycss) shims
   * for style encapsulation, custom properties, and custom mixins.
   *
   * - Document styles defined in a `<custom-style>` are shimmed to ensure they
   *   do not leak into local DOM when running on browsers without native
   *   Shadow DOM.
   * - Custom properties can be defined in a `<custom-style>`. Use the `html` selector
   *   to define custom properties that apply to all custom elements.
   * - Custom mixins can be defined in a `<custom-style>`, if you import the optional
   *   [apply shim](https://github.com/webcomponents/shadycss#about-applyshim)
   *   (`shadycss/apply-shim.html`).
   *
   * To use:
   *
   * - Import `custom-style.html`.
   * - Place a `<custom-style>` element in the main document, wrapping an inline `<style>` tag that
   *   contains the CSS rules you want to shim.
   *
   * For example:
   *
   * ```html
   * <!-- import apply shim--only required if using mixins -->
   * <link rel="import" href="bower_components/shadycss/apply-shim.html">
   * <!-- import custom-style element -->
   * <link rel="import" href="bower_components/polymer/lib/elements/custom-style.html">
   *
   * <custom-style>
   *   <style>
   *     html {
   *       --custom-color: blue;
   *       --custom-mixin: {
   *         font-weight: bold;
   *         color: red;
   *       };
   *     }
   *   </style>
   * </custom-style>
   * ```
   *
   * @customElement
   * @extends HTMLElement
   * @summary Custom element for defining styles in the main document that can
   *   take advantage of Polymer's style scoping and custom properties shims.
   */

  class CustomStyle extends HTMLElement {
    constructor() {
      super();
      this._style = null;
      CustomStyleInterface$1.addCustomStyle(this);
    }
    /**
     * Returns the light-DOM `<style>` child this element wraps.  Upon first
     * call any style modules referenced via the `include` attribute will be
     * concatenated to this element's `<style>`.
     *
     * @export
     * @return {HTMLStyleElement} This element's light-DOM `<style>`
     */


    getStyle() {
      if (this._style) {
        return this._style;
      }

      const style =
      /** @type {HTMLStyleElement} */
      this.querySelector('style');

      if (!style) {
        return null;
      }

      this._style = style;
      const include = style.getAttribute(attr);

      if (include) {
        style.removeAttribute(attr);
        /** @suppress {deprecated} */

        style.textContent = cssFromModules(include) + style.textContent;
      }
      /*
      HTML Imports styling the main document are deprecated in Chrome
      https://crbug.com/523952
       If this element is not in the main document, then it must be in an HTML Import document.
      In that case, move the custom style to the main document.
       The ordering of `<custom-style>` should stay the same as when loaded by HTML Imports, but there may be odd
      cases of ordering w.r.t the main document styles.
      */


      if (this.ownerDocument !== window.document) {
        window.document.head.appendChild(this);
      }

      return this._style;
    }

  }
  window.customElements.define('custom-style', CustomStyle);

  /**
  @license
  Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
  The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
  The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
  Code distributed by Google as part of the polymer project is also
  subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
  */

  const Base = LegacyElementMixin(HTMLElement).prototype;

  /**
  @license
  Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at
  http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
  http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
  found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
  part of the polymer project is also subject to an additional IP rights grant
  found at http://polymer.github.io/PATENTS.txt
  */
  /**
  The `<iron-flex-layout>` component provides simple ways to use
  [CSS flexible box
  layout](https://developer.mozilla.org/en-US/docs/Web/Guide/CSS/Flexible_boxes),
  also known as flexbox. Note that this is an old element, that was written
  before all modern browsers had non-prefixed flex styles. As such, nowadays you
  don't really need to use this element anymore, and can use CSS flex styles
  directly in your code.

  This component provides two different ways to use flexbox:

  1. [Layout
  classes](https://github.com/PolymerElements/iron-flex-layout/tree/master/iron-flex-layout-classes.html).
  The layout class stylesheet provides a simple set of class-based flexbox rules,
  that let you specify layout properties directly in markup. You must include this
  file in every element that needs to use them.

      Sample use:

      ```
      <custom-element-demo>
        <template>
          <script src="../webcomponentsjs/webcomponents-lite.js"></script>
          <next-code-block></next-code-block>
        </template>
      </custom-element-demo>
      ```

      ```js
      import {html} from '@polymer/polymer/lib/utils/html-tag.js';
      import '@polymer/iron-flex-layout/iron-flex-layout-classes.js';

      const template = html`
        <style is="custom-style" include="iron-flex iron-flex-alignment"></style>
        <style>
          .test { width: 100px; }
        </style>
        <div class="layout horizontal center-center">
          <div class="test">horizontal layout center alignment</div>
        </div>
      `;
      document.body.appendChild(template.content);
      ```

  2. [Custom CSS
  mixins](https://github.com/PolymerElements/iron-flex-layout/blob/master/iron-flex-layout.html).
  The mixin stylesheet includes custom CSS mixins that can be applied inside a CSS
  rule using the `@apply` function.

  Please note that the old [/deep/ layout
  classes](https://github.com/PolymerElements/iron-flex-layout/tree/master/classes)
  are deprecated, and should not be used. To continue using layout properties
  directly in markup, please switch to using the new `dom-module`-based
  [layout
  classes](https://github.com/PolymerElements/iron-flex-layout/tree/master/iron-flex-layout-classes.html).
  Please note that the new version does not use `/deep/`, and therefore requires
  you to import the `dom-modules` in every element that needs to use them.

  @group Iron Elements
  @pseudoElement iron-flex-layout
  @demo demo/index.html
  */

  const template = html$1`
<custom-style>
  <style is="custom-style">
    [hidden] {
      display: none !important;
    }
  </style>
</custom-style>
<custom-style>
  <style is="custom-style">
    html {

      --layout: {
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
      };

      --layout-inline: {
        display: -ms-inline-flexbox;
        display: -webkit-inline-flex;
        display: inline-flex;
      };

      --layout-horizontal: {
        @apply --layout;

        -ms-flex-direction: row;
        -webkit-flex-direction: row;
        flex-direction: row;
      };

      --layout-horizontal-reverse: {
        @apply --layout;

        -ms-flex-direction: row-reverse;
        -webkit-flex-direction: row-reverse;
        flex-direction: row-reverse;
      };

      --layout-vertical: {
        @apply --layout;

        -ms-flex-direction: column;
        -webkit-flex-direction: column;
        flex-direction: column;
      };

      --layout-vertical-reverse: {
        @apply --layout;

        -ms-flex-direction: column-reverse;
        -webkit-flex-direction: column-reverse;
        flex-direction: column-reverse;
      };

      --layout-wrap: {
        -ms-flex-wrap: wrap;
        -webkit-flex-wrap: wrap;
        flex-wrap: wrap;
      };

      --layout-wrap-reverse: {
        -ms-flex-wrap: wrap-reverse;
        -webkit-flex-wrap: wrap-reverse;
        flex-wrap: wrap-reverse;
      };

      --layout-flex-auto: {
        -ms-flex: 1 1 auto;
        -webkit-flex: 1 1 auto;
        flex: 1 1 auto;
      };

      --layout-flex-none: {
        -ms-flex: none;
        -webkit-flex: none;
        flex: none;
      };

      --layout-flex: {
        -ms-flex: 1 1 0.000000001px;
        -webkit-flex: 1;
        flex: 1;
        -webkit-flex-basis: 0.000000001px;
        flex-basis: 0.000000001px;
      };

      --layout-flex-2: {
        -ms-flex: 2;
        -webkit-flex: 2;
        flex: 2;
      };

      --layout-flex-3: {
        -ms-flex: 3;
        -webkit-flex: 3;
        flex: 3;
      };

      --layout-flex-4: {
        -ms-flex: 4;
        -webkit-flex: 4;
        flex: 4;
      };

      --layout-flex-5: {
        -ms-flex: 5;
        -webkit-flex: 5;
        flex: 5;
      };

      --layout-flex-6: {
        -ms-flex: 6;
        -webkit-flex: 6;
        flex: 6;
      };

      --layout-flex-7: {
        -ms-flex: 7;
        -webkit-flex: 7;
        flex: 7;
      };

      --layout-flex-8: {
        -ms-flex: 8;
        -webkit-flex: 8;
        flex: 8;
      };

      --layout-flex-9: {
        -ms-flex: 9;
        -webkit-flex: 9;
        flex: 9;
      };

      --layout-flex-10: {
        -ms-flex: 10;
        -webkit-flex: 10;
        flex: 10;
      };

      --layout-flex-11: {
        -ms-flex: 11;
        -webkit-flex: 11;
        flex: 11;
      };

      --layout-flex-12: {
        -ms-flex: 12;
        -webkit-flex: 12;
        flex: 12;
      };

      /* alignment in cross axis */

      --layout-start: {
        -ms-flex-align: start;
        -webkit-align-items: flex-start;
        align-items: flex-start;
      };

      --layout-center: {
        -ms-flex-align: center;
        -webkit-align-items: center;
        align-items: center;
      };

      --layout-end: {
        -ms-flex-align: end;
        -webkit-align-items: flex-end;
        align-items: flex-end;
      };

      --layout-baseline: {
        -ms-flex-align: baseline;
        -webkit-align-items: baseline;
        align-items: baseline;
      };

      /* alignment in main axis */

      --layout-start-justified: {
        -ms-flex-pack: start;
        -webkit-justify-content: flex-start;
        justify-content: flex-start;
      };

      --layout-center-justified: {
        -ms-flex-pack: center;
        -webkit-justify-content: center;
        justify-content: center;
      };

      --layout-end-justified: {
        -ms-flex-pack: end;
        -webkit-justify-content: flex-end;
        justify-content: flex-end;
      };

      --layout-around-justified: {
        -ms-flex-pack: distribute;
        -webkit-justify-content: space-around;
        justify-content: space-around;
      };

      --layout-justified: {
        -ms-flex-pack: justify;
        -webkit-justify-content: space-between;
        justify-content: space-between;
      };

      --layout-center-center: {
        @apply --layout-center;
        @apply --layout-center-justified;
      };

      /* self alignment */

      --layout-self-start: {
        -ms-align-self: flex-start;
        -webkit-align-self: flex-start;
        align-self: flex-start;
      };

      --layout-self-center: {
        -ms-align-self: center;
        -webkit-align-self: center;
        align-self: center;
      };

      --layout-self-end: {
        -ms-align-self: flex-end;
        -webkit-align-self: flex-end;
        align-self: flex-end;
      };

      --layout-self-stretch: {
        -ms-align-self: stretch;
        -webkit-align-self: stretch;
        align-self: stretch;
      };

      --layout-self-baseline: {
        -ms-align-self: baseline;
        -webkit-align-self: baseline;
        align-self: baseline;
      };

      /* multi-line alignment in main axis */

      --layout-start-aligned: {
        -ms-flex-line-pack: start;  /* IE10 */
        -ms-align-content: flex-start;
        -webkit-align-content: flex-start;
        align-content: flex-start;
      };

      --layout-end-aligned: {
        -ms-flex-line-pack: end;  /* IE10 */
        -ms-align-content: flex-end;
        -webkit-align-content: flex-end;
        align-content: flex-end;
      };

      --layout-center-aligned: {
        -ms-flex-line-pack: center;  /* IE10 */
        -ms-align-content: center;
        -webkit-align-content: center;
        align-content: center;
      };

      --layout-between-aligned: {
        -ms-flex-line-pack: justify;  /* IE10 */
        -ms-align-content: space-between;
        -webkit-align-content: space-between;
        align-content: space-between;
      };

      --layout-around-aligned: {
        -ms-flex-line-pack: distribute;  /* IE10 */
        -ms-align-content: space-around;
        -webkit-align-content: space-around;
        align-content: space-around;
      };

      /*******************************
                Other Layout
      *******************************/

      --layout-block: {
        display: block;
      };

      --layout-invisible: {
        visibility: hidden !important;
      };

      --layout-relative: {
        position: relative;
      };

      --layout-fit: {
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
      };

      --layout-scroll: {
        -webkit-overflow-scrolling: touch;
        overflow: auto;
      };

      --layout-fullbleed: {
        margin: 0;
        height: 100vh;
      };

      /* fixed position */

      --layout-fixed-top: {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
      };

      --layout-fixed-right: {
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
      };

      --layout-fixed-bottom: {
        position: fixed;
        right: 0;
        bottom: 0;
        left: 0;
      };

      --layout-fixed-left: {
        position: fixed;
        top: 0;
        bottom: 0;
        left: 0;
      };

    }
  </style>
</custom-style>`;
  template.setAttribute('style', 'display: none;');
  document.head.appendChild(template.content);
  var style = document.createElement('style');
  style.textContent = '[hidden] { display: none !important; }';
  document.head.appendChild(style);

  /**
  @license
  Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at
  http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
  http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
  found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
  part of the polymer project is also subject to an additional IP rights grant
  found at http://polymer.github.io/PATENTS.txt
  */
  const template$1 = html$1`
<custom-style>
  <style is="custom-style">
    html {

      /* Material Design color palette for Google products */

      --google-red-100: #f4c7c3;
      --google-red-300: #e67c73;
      --google-red-500: #db4437;
      --google-red-700: #c53929;

      --google-blue-100: #c6dafc;
      --google-blue-300: #7baaf7;
      --google-blue-500: #4285f4;
      --google-blue-700: #3367d6;

      --google-green-100: #b7e1cd;
      --google-green-300: #57bb8a;
      --google-green-500: #0f9d58;
      --google-green-700: #0b8043;

      --google-yellow-100: #fce8b2;
      --google-yellow-300: #f7cb4d;
      --google-yellow-500: #f4b400;
      --google-yellow-700: #f09300;

      --google-grey-100: #f5f5f5;
      --google-grey-300: #e0e0e0;
      --google-grey-500: #9e9e9e;
      --google-grey-700: #616161;

      /* Material Design color palette from online spec document */

      --paper-red-50: #ffebee;
      --paper-red-100: #ffcdd2;
      --paper-red-200: #ef9a9a;
      --paper-red-300: #e57373;
      --paper-red-400: #ef5350;
      --paper-red-500: #f44336;
      --paper-red-600: #e53935;
      --paper-red-700: #d32f2f;
      --paper-red-800: #c62828;
      --paper-red-900: #b71c1c;
      --paper-red-a100: #ff8a80;
      --paper-red-a200: #ff5252;
      --paper-red-a400: #ff1744;
      --paper-red-a700: #d50000;

      --paper-pink-50: #fce4ec;
      --paper-pink-100: #f8bbd0;
      --paper-pink-200: #f48fb1;
      --paper-pink-300: #f06292;
      --paper-pink-400: #ec407a;
      --paper-pink-500: #e91e63;
      --paper-pink-600: #d81b60;
      --paper-pink-700: #c2185b;
      --paper-pink-800: #ad1457;
      --paper-pink-900: #880e4f;
      --paper-pink-a100: #ff80ab;
      --paper-pink-a200: #ff4081;
      --paper-pink-a400: #f50057;
      --paper-pink-a700: #c51162;

      --paper-purple-50: #f3e5f5;
      --paper-purple-100: #e1bee7;
      --paper-purple-200: #ce93d8;
      --paper-purple-300: #ba68c8;
      --paper-purple-400: #ab47bc;
      --paper-purple-500: #9c27b0;
      --paper-purple-600: #8e24aa;
      --paper-purple-700: #7b1fa2;
      --paper-purple-800: #6a1b9a;
      --paper-purple-900: #4a148c;
      --paper-purple-a100: #ea80fc;
      --paper-purple-a200: #e040fb;
      --paper-purple-a400: #d500f9;
      --paper-purple-a700: #aa00ff;

      --paper-deep-purple-50: #ede7f6;
      --paper-deep-purple-100: #d1c4e9;
      --paper-deep-purple-200: #b39ddb;
      --paper-deep-purple-300: #9575cd;
      --paper-deep-purple-400: #7e57c2;
      --paper-deep-purple-500: #673ab7;
      --paper-deep-purple-600: #5e35b1;
      --paper-deep-purple-700: #512da8;
      --paper-deep-purple-800: #4527a0;
      --paper-deep-purple-900: #311b92;
      --paper-deep-purple-a100: #b388ff;
      --paper-deep-purple-a200: #7c4dff;
      --paper-deep-purple-a400: #651fff;
      --paper-deep-purple-a700: #6200ea;

      --paper-indigo-50: #e8eaf6;
      --paper-indigo-100: #c5cae9;
      --paper-indigo-200: #9fa8da;
      --paper-indigo-300: #7986cb;
      --paper-indigo-400: #5c6bc0;
      --paper-indigo-500: #3f51b5;
      --paper-indigo-600: #3949ab;
      --paper-indigo-700: #303f9f;
      --paper-indigo-800: #283593;
      --paper-indigo-900: #1a237e;
      --paper-indigo-a100: #8c9eff;
      --paper-indigo-a200: #536dfe;
      --paper-indigo-a400: #3d5afe;
      --paper-indigo-a700: #304ffe;

      --paper-blue-50: #e3f2fd;
      --paper-blue-100: #bbdefb;
      --paper-blue-200: #90caf9;
      --paper-blue-300: #64b5f6;
      --paper-blue-400: #42a5f5;
      --paper-blue-500: #2196f3;
      --paper-blue-600: #1e88e5;
      --paper-blue-700: #1976d2;
      --paper-blue-800: #1565c0;
      --paper-blue-900: #0d47a1;
      --paper-blue-a100: #82b1ff;
      --paper-blue-a200: #448aff;
      --paper-blue-a400: #2979ff;
      --paper-blue-a700: #2962ff;

      --paper-light-blue-50: #e1f5fe;
      --paper-light-blue-100: #b3e5fc;
      --paper-light-blue-200: #81d4fa;
      --paper-light-blue-300: #4fc3f7;
      --paper-light-blue-400: #29b6f6;
      --paper-light-blue-500: #03a9f4;
      --paper-light-blue-600: #039be5;
      --paper-light-blue-700: #0288d1;
      --paper-light-blue-800: #0277bd;
      --paper-light-blue-900: #01579b;
      --paper-light-blue-a100: #80d8ff;
      --paper-light-blue-a200: #40c4ff;
      --paper-light-blue-a400: #00b0ff;
      --paper-light-blue-a700: #0091ea;

      --paper-cyan-50: #e0f7fa;
      --paper-cyan-100: #b2ebf2;
      --paper-cyan-200: #80deea;
      --paper-cyan-300: #4dd0e1;
      --paper-cyan-400: #26c6da;
      --paper-cyan-500: #00bcd4;
      --paper-cyan-600: #00acc1;
      --paper-cyan-700: #0097a7;
      --paper-cyan-800: #00838f;
      --paper-cyan-900: #006064;
      --paper-cyan-a100: #84ffff;
      --paper-cyan-a200: #18ffff;
      --paper-cyan-a400: #00e5ff;
      --paper-cyan-a700: #00b8d4;

      --paper-teal-50: #e0f2f1;
      --paper-teal-100: #b2dfdb;
      --paper-teal-200: #80cbc4;
      --paper-teal-300: #4db6ac;
      --paper-teal-400: #26a69a;
      --paper-teal-500: #009688;
      --paper-teal-600: #00897b;
      --paper-teal-700: #00796b;
      --paper-teal-800: #00695c;
      --paper-teal-900: #004d40;
      --paper-teal-a100: #a7ffeb;
      --paper-teal-a200: #64ffda;
      --paper-teal-a400: #1de9b6;
      --paper-teal-a700: #00bfa5;

      --paper-green-50: #e8f5e9;
      --paper-green-100: #c8e6c9;
      --paper-green-200: #a5d6a7;
      --paper-green-300: #81c784;
      --paper-green-400: #66bb6a;
      --paper-green-500: #4caf50;
      --paper-green-600: #43a047;
      --paper-green-700: #388e3c;
      --paper-green-800: #2e7d32;
      --paper-green-900: #1b5e20;
      --paper-green-a100: #b9f6ca;
      --paper-green-a200: #69f0ae;
      --paper-green-a400: #00e676;
      --paper-green-a700: #00c853;

      --paper-light-green-50: #f1f8e9;
      --paper-light-green-100: #dcedc8;
      --paper-light-green-200: #c5e1a5;
      --paper-light-green-300: #aed581;
      --paper-light-green-400: #9ccc65;
      --paper-light-green-500: #8bc34a;
      --paper-light-green-600: #7cb342;
      --paper-light-green-700: #689f38;
      --paper-light-green-800: #558b2f;
      --paper-light-green-900: #33691e;
      --paper-light-green-a100: #ccff90;
      --paper-light-green-a200: #b2ff59;
      --paper-light-green-a400: #76ff03;
      --paper-light-green-a700: #64dd17;

      --paper-lime-50: #f9fbe7;
      --paper-lime-100: #f0f4c3;
      --paper-lime-200: #e6ee9c;
      --paper-lime-300: #dce775;
      --paper-lime-400: #d4e157;
      --paper-lime-500: #cddc39;
      --paper-lime-600: #c0ca33;
      --paper-lime-700: #afb42b;
      --paper-lime-800: #9e9d24;
      --paper-lime-900: #827717;
      --paper-lime-a100: #f4ff81;
      --paper-lime-a200: #eeff41;
      --paper-lime-a400: #c6ff00;
      --paper-lime-a700: #aeea00;

      --paper-yellow-50: #fffde7;
      --paper-yellow-100: #fff9c4;
      --paper-yellow-200: #fff59d;
      --paper-yellow-300: #fff176;
      --paper-yellow-400: #ffee58;
      --paper-yellow-500: #ffeb3b;
      --paper-yellow-600: #fdd835;
      --paper-yellow-700: #fbc02d;
      --paper-yellow-800: #f9a825;
      --paper-yellow-900: #f57f17;
      --paper-yellow-a100: #ffff8d;
      --paper-yellow-a200: #ffff00;
      --paper-yellow-a400: #ffea00;
      --paper-yellow-a700: #ffd600;

      --paper-amber-50: #fff8e1;
      --paper-amber-100: #ffecb3;
      --paper-amber-200: #ffe082;
      --paper-amber-300: #ffd54f;
      --paper-amber-400: #ffca28;
      --paper-amber-500: #ffc107;
      --paper-amber-600: #ffb300;
      --paper-amber-700: #ffa000;
      --paper-amber-800: #ff8f00;
      --paper-amber-900: #ff6f00;
      --paper-amber-a100: #ffe57f;
      --paper-amber-a200: #ffd740;
      --paper-amber-a400: #ffc400;
      --paper-amber-a700: #ffab00;

      --paper-orange-50: #fff3e0;
      --paper-orange-100: #ffe0b2;
      --paper-orange-200: #ffcc80;
      --paper-orange-300: #ffb74d;
      --paper-orange-400: #ffa726;
      --paper-orange-500: #ff9800;
      --paper-orange-600: #fb8c00;
      --paper-orange-700: #f57c00;
      --paper-orange-800: #ef6c00;
      --paper-orange-900: #e65100;
      --paper-orange-a100: #ffd180;
      --paper-orange-a200: #ffab40;
      --paper-orange-a400: #ff9100;
      --paper-orange-a700: #ff6500;

      --paper-deep-orange-50: #fbe9e7;
      --paper-deep-orange-100: #ffccbc;
      --paper-deep-orange-200: #ffab91;
      --paper-deep-orange-300: #ff8a65;
      --paper-deep-orange-400: #ff7043;
      --paper-deep-orange-500: #ff5722;
      --paper-deep-orange-600: #f4511e;
      --paper-deep-orange-700: #e64a19;
      --paper-deep-orange-800: #d84315;
      --paper-deep-orange-900: #bf360c;
      --paper-deep-orange-a100: #ff9e80;
      --paper-deep-orange-a200: #ff6e40;
      --paper-deep-orange-a400: #ff3d00;
      --paper-deep-orange-a700: #dd2c00;

      --paper-brown-50: #efebe9;
      --paper-brown-100: #d7ccc8;
      --paper-brown-200: #bcaaa4;
      --paper-brown-300: #a1887f;
      --paper-brown-400: #8d6e63;
      --paper-brown-500: #795548;
      --paper-brown-600: #6d4c41;
      --paper-brown-700: #5d4037;
      --paper-brown-800: #4e342e;
      --paper-brown-900: #3e2723;

      --paper-grey-50: #fafafa;
      --paper-grey-100: #f5f5f5;
      --paper-grey-200: #eeeeee;
      --paper-grey-300: #e0e0e0;
      --paper-grey-400: #bdbdbd;
      --paper-grey-500: #9e9e9e;
      --paper-grey-600: #757575;
      --paper-grey-700: #616161;
      --paper-grey-800: #424242;
      --paper-grey-900: #212121;

      --paper-blue-grey-50: #eceff1;
      --paper-blue-grey-100: #cfd8dc;
      --paper-blue-grey-200: #b0bec5;
      --paper-blue-grey-300: #90a4ae;
      --paper-blue-grey-400: #78909c;
      --paper-blue-grey-500: #607d8b;
      --paper-blue-grey-600: #546e7a;
      --paper-blue-grey-700: #455a64;
      --paper-blue-grey-800: #37474f;
      --paper-blue-grey-900: #263238;

      /* opacity for dark text on a light background */
      --dark-divider-opacity: 0.12;
      --dark-disabled-opacity: 0.38; /* or hint text or icon */
      --dark-secondary-opacity: 0.54;
      --dark-primary-opacity: 0.87;

      /* opacity for light text on a dark background */
      --light-divider-opacity: 0.12;
      --light-disabled-opacity: 0.3; /* or hint text or icon */
      --light-secondary-opacity: 0.7;
      --light-primary-opacity: 1.0;

    }

  </style>
</custom-style>
`;
  template$1.setAttribute('style', 'display: none;');
  document.head.appendChild(template$1.content);

  /**
  @license
  Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at
  http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
  http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
  found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
  part of the polymer project is also subject to an additional IP rights grant
  found at http://polymer.github.io/PATENTS.txt
  */
  const template$2 = html$1`
<custom-style>
  <style is="custom-style">
    html {
      /*
       * You can use these generic variables in your elements for easy theming.
       * For example, if all your elements use \`--primary-text-color\` as its main
       * color, then switching from a light to a dark theme is just a matter of
       * changing the value of \`--primary-text-color\` in your application.
       */
      --primary-text-color: var(--light-theme-text-color);
      --primary-background-color: var(--light-theme-background-color);
      --secondary-text-color: var(--light-theme-secondary-color);
      --disabled-text-color: var(--light-theme-disabled-color);
      --divider-color: var(--light-theme-divider-color);
      --error-color: var(--paper-deep-orange-a700);

      /*
       * Primary and accent colors. Also see color.js for more colors.
       */
      --primary-color: var(--paper-indigo-500);
      --light-primary-color: var(--paper-indigo-100);
      --dark-primary-color: var(--paper-indigo-700);

      --accent-color: var(--paper-pink-a200);
      --light-accent-color: var(--paper-pink-a100);
      --dark-accent-color: var(--paper-pink-a400);


      /*
       * Material Design Light background theme
       */
      --light-theme-background-color: #ffffff;
      --light-theme-base-color: #000000;
      --light-theme-text-color: var(--paper-grey-900);
      --light-theme-secondary-color: #737373;  /* for secondary text and icons */
      --light-theme-disabled-color: #9b9b9b;  /* disabled/hint text */
      --light-theme-divider-color: #dbdbdb;

      /*
       * Material Design Dark background theme
       */
      --dark-theme-background-color: var(--paper-grey-900);
      --dark-theme-base-color: #ffffff;
      --dark-theme-text-color: #ffffff;
      --dark-theme-secondary-color: #bcbcbc;  /* for secondary text and icons */
      --dark-theme-disabled-color: #646464;  /* disabled/hint text */
      --dark-theme-divider-color: #3c3c3c;

      /*
       * Deprecated values because of their confusing names.
       */
      --text-primary-color: var(--dark-theme-text-color);
      --default-primary-color: var(--primary-color);
    }
  </style>
</custom-style>`;
  template$2.setAttribute('style', 'display: none;');
  document.head.appendChild(template$2.content);

  /**
  @license
  Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at
  http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
  http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
  found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
  part of the polymer project is also subject to an additional IP rights grant
  found at http://polymer.github.io/PATENTS.txt
  */
  const template$3 = html$1`
<custom-style>
  <style is="custom-style">
    html {

      --shadow-transition: {
        transition: box-shadow 0.28s cubic-bezier(0.4, 0, 0.2, 1);
      };

      --shadow-none: {
        box-shadow: none;
      };

      /* from http://codepen.io/shyndman/pen/c5394ddf2e8b2a5c9185904b57421cdb */

      --shadow-elevation-2dp: {
        box-shadow: 0 2px 2px 0 rgba(0, 0, 0, 0.14),
                    0 1px 5px 0 rgba(0, 0, 0, 0.12),
                    0 3px 1px -2px rgba(0, 0, 0, 0.2);
      };

      --shadow-elevation-3dp: {
        box-shadow: 0 3px 4px 0 rgba(0, 0, 0, 0.14),
                    0 1px 8px 0 rgba(0, 0, 0, 0.12),
                    0 3px 3px -2px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-4dp: {
        box-shadow: 0 4px 5px 0 rgba(0, 0, 0, 0.14),
                    0 1px 10px 0 rgba(0, 0, 0, 0.12),
                    0 2px 4px -1px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-6dp: {
        box-shadow: 0 6px 10px 0 rgba(0, 0, 0, 0.14),
                    0 1px 18px 0 rgba(0, 0, 0, 0.12),
                    0 3px 5px -1px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-8dp: {
        box-shadow: 0 8px 10px 1px rgba(0, 0, 0, 0.14),
                    0 3px 14px 2px rgba(0, 0, 0, 0.12),
                    0 5px 5px -3px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-12dp: {
        box-shadow: 0 12px 16px 1px rgba(0, 0, 0, 0.14),
                    0 4px 22px 3px rgba(0, 0, 0, 0.12),
                    0 6px 7px -4px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-16dp: {
        box-shadow: 0 16px 24px 2px rgba(0, 0, 0, 0.14),
                    0  6px 30px 5px rgba(0, 0, 0, 0.12),
                    0  8px 10px -5px rgba(0, 0, 0, 0.4);
      };

      --shadow-elevation-24dp: {
        box-shadow: 0 24px 38px 3px rgba(0, 0, 0, 0.14),
                    0 9px 46px 8px rgba(0, 0, 0, 0.12),
                    0 11px 15px -7px rgba(0, 0, 0, 0.4);
      };
    }
  </style>
</custom-style>`;
  template$3.setAttribute('style', 'display: none;');
  document.head.appendChild(template$3.content);

  /**
  @license
  Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at
  http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
  http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
  found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
  part of the polymer project is also subject to an additional IP rights grant
  found at http://polymer.github.io/PATENTS.txt
  */
  // Give the user the choice to opt out of font loading.

  if (!window.polymerSkipLoadingFontRoboto) {
    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.type = 'text/css';
    link.crossOrigin = 'anonymous';
    link.href = 'https://fonts.googleapis.com/css?family=Roboto+Mono:400,700|Roboto:400,300,300italic,400italic,500,500italic,700,700italic';
    document.head.appendChild(link);
  }

  /**
  @license
  Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
  This code may only be used under the BSD style license found at
  http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
  http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
  found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
  part of the polymer project is also subject to an additional IP rights grant
  found at http://polymer.github.io/PATENTS.txt
  */
  const template$4 = html$1`<custom-style>
  <style is="custom-style">
    html {

      /* Shared Styles */
      --paper-font-common-base: {
        font-family: 'Roboto', 'Noto', sans-serif;
        -webkit-font-smoothing: antialiased;
      };

      --paper-font-common-code: {
        font-family: 'Roboto Mono', 'Consolas', 'Menlo', monospace;
        -webkit-font-smoothing: antialiased;
      };

      --paper-font-common-expensive-kerning: {
        text-rendering: optimizeLegibility;
      };

      --paper-font-common-nowrap: {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
      };

      /* Material Font Styles */

      --paper-font-display4: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 112px;
        font-weight: 300;
        letter-spacing: -.044em;
        line-height: 120px;
      };

      --paper-font-display3: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 56px;
        font-weight: 400;
        letter-spacing: -.026em;
        line-height: 60px;
      };

      --paper-font-display2: {
        @apply --paper-font-common-base;

        font-size: 45px;
        font-weight: 400;
        letter-spacing: -.018em;
        line-height: 48px;
      };

      --paper-font-display1: {
        @apply --paper-font-common-base;

        font-size: 34px;
        font-weight: 400;
        letter-spacing: -.01em;
        line-height: 40px;
      };

      --paper-font-headline: {
        @apply --paper-font-common-base;

        font-size: 24px;
        font-weight: 400;
        letter-spacing: -.012em;
        line-height: 32px;
      };

      --paper-font-title: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 20px;
        font-weight: 500;
        line-height: 28px;
      };

      --paper-font-subhead: {
        @apply --paper-font-common-base;

        font-size: 16px;
        font-weight: 400;
        line-height: 24px;
      };

      --paper-font-body2: {
        @apply --paper-font-common-base;

        font-size: 14px;
        font-weight: 500;
        line-height: 24px;
      };

      --paper-font-body1: {
        @apply --paper-font-common-base;

        font-size: 14px;
        font-weight: 400;
        line-height: 20px;
      };

      --paper-font-caption: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 12px;
        font-weight: 400;
        letter-spacing: 0.011em;
        line-height: 20px;
      };

      --paper-font-menu: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 13px;
        font-weight: 500;
        line-height: 24px;
      };

      --paper-font-button: {
        @apply --paper-font-common-base;
        @apply --paper-font-common-nowrap;

        font-size: 14px;
        font-weight: 500;
        letter-spacing: 0.018em;
        line-height: 24px;
        text-transform: uppercase;
      };

      --paper-font-code2: {
        @apply --paper-font-common-code;

        font-size: 14px;
        font-weight: 700;
        line-height: 20px;
      };

      --paper-font-code1: {
        @apply --paper-font-common-code;

        font-size: 14px;
        font-weight: 500;
        line-height: 20px;
      };

    }

  </style>
</custom-style>`;
  template$4.setAttribute('style', 'display: none;');
  document.head.appendChild(template$4.content);

  const documentContainer = document.createElement("template");
  documentContainer.setAttribute("style", "display: none;");
  documentContainer.innerHTML = `<custom-style>
  <style>
    /*
      Home Assistant default styles.

      In Polymer 2.0, default styles should to be set on the html selector.
      (Setting all default styles only on body breaks shadyCSS polyfill.)
      See: https://github.com/home-assistant/home-assistant-polymer/pull/901
    */
    html {
      font-size: 14px;
      height: 100vh;

      /* text */
      --primary-text-color: #212121;
      --secondary-text-color: #727272;
      --text-primary-color: #ffffff;
      --text-light-primary-color: #212121;
      --disabled-text-color: #bdbdbd;

      /* main interface colors */
      --primary-color: #03a9f4;
      --dark-primary-color: #0288d1;
      --light-primary-color: #b3e5fC;
      --accent-color: #ff9800;
      --divider-color: rgba(0, 0, 0, .12);

      --scrollbar-thumb-color: rgb(194, 194, 194);

      --error-color: #db4437;
      --warning-color: #FF9800;
      --success-color: #0f9d58;
      --info-color: #4285f4;

      /* states and badges */
      --state-icon-color: #44739e;
      --state-icon-active-color: #FDD835;

      /* background and sidebar */
      --card-background-color: #ffffff;
      --primary-background-color: #fafafa;
      --secondary-background-color: #e5e5e5; /* behind the cards on state */

      /* for label-badge */
      --label-badge-red: #DF4C1E;
      --label-badge-blue: #039be5;
      --label-badge-green: #0DA035;
      --label-badge-yellow: #f4b400;

      /*
        Paper-styles color.html dependency is stripped on build.
        When a default paper-style color is used, it needs to be copied
        from paper-styles/color.html to here.
      */

      --paper-grey-50: #fafafa; /* default for: --mwc-switch-unchecked-button-color */
      --paper-grey-200: #eeeeee;  /* for ha-date-picker-style */
      --paper-grey-500: #9e9e9e;  /* --label-badge-grey */

      /* for paper-slider */
      --paper-green-400: #66bb6a;
      --paper-blue-400: #42a5f5;
      --paper-orange-400: #ffa726;

      /* opacity for dark text on a light background */
      --dark-divider-opacity: 0.12;
      --dark-disabled-opacity: 0.38; /* or hint text or icon */
      --dark-secondary-opacity: 0.54;
      --dark-primary-opacity: 0.87;

      /* opacity for light text on a dark background */
      --light-divider-opacity: 0.12;
      --light-disabled-opacity: 0.3; /* or hint text or icon */
      --light-secondary-opacity: 0.7;
      --light-primary-opacity: 1.0;

      /* set our slider style */
      --ha-paper-slider-pin-font-size: 15px;

      /* rgb */
      --rgb-primary-color: 3, 169, 244;
      --rgb-accent-color: 255, 152, 0;
      --rgb-primary-text-color: 33, 33, 33;
      --rgb-secondary-text-color: 114, 114, 114;
      --rgb-text-primary-color: 255, 255, 255;
      --rgb-card-background-color: 255, 255, 255;

      ${Object.entries(derivedStyles).map(([key, value]) => `--${key}: ${value};`).join("")}
    }

    /*
      prevent clipping of positioned elements in a small scrollable
      force smooth scrolling if can scroll
      use non-shady selectors so this only targets iOS 9
      conditional mixin set in ha-style-dialog does not work with shadyCSS
    */
    paper-dialog-scrollable:not(.can-scroll) > .scrollable {
      -webkit-overflow-scrolling: auto !important;
    }

    paper-dialog-scrollable.can-scroll > .scrollable {
      -webkit-overflow-scrolling: touch !important;
    }
  </style>
</custom-style>`;
  document.head.appendChild(documentContainer.content);

  const atLeastVersion = (version, major, minor) => {
    const [haMajor, haMinor] = version.split(".", 2);
    return Number(haMajor) > major || Number(haMajor) === major && Number(haMinor) >= minor;
  };

  const getConfiguration = async hass => {
    const response = await hass.connection.sendMessagePromise({
      type: "hacs/config"
    });
    return response;
  };
  const getRepositories = async hass => {
    const response = await hass.connection.sendMessagePromise({
      type: "hacs/repositories"
    });
    return response;
  };
  const getCritical = async hass => {
    const response = await hass.connection.sendMessagePromise({
      type: "hacs/get_critical"
    });
    return response;
  };
  const getStatus = async hass => {
    const response = await hass.connection.sendMessagePromise({
      type: "hacs/status"
    });
    return response;
  };
  const getRemovedRepositories = async hass => {
    const response = await hass.connection.sendMessagePromise({
      type: "hacs/removed"
    });
    return response;
  };
  const repositoryInstall = async (hass, repository) => {
    await hass.connection.sendMessagePromise({
      type: "hacs/repository",
      action: "install",
      repository: repository
    });
  };
  const repositoryUninstall = async (hass, repository) => {
    await hass.connection.sendMessagePromise({
      type: "hacs/repository",
      action: "uninstall",
      repository: repository
    });
  };
  const repositoryReleasenotes = async (hass, repository) => {
    const response = await hass.connection.sendMessagePromise({
      type: "hacs/repository",
      action: "release_notes",
      repository: repository
    });
    return response;
  };
  const repositoryToggleBeta = async (hass, repository) => {
    await hass.connection.sendMessagePromise({
      type: "hacs/repository",
      action: "toggle_beta",
      repository: repository
    });
  };
  const repositoryInstallVersion = async (hass, repository, version) => {
    await hass.connection.sendMessagePromise({
      type: "hacs/repository/data",
      action: "install",
      repository: repository,
      data: version
    });
  };
  const repositoryAdd = async (hass, repository, category) => {
    await hass.connection.sendMessagePromise({
      type: "hacs/repository/data",
      action: "add",
      repository: repository,
      data: category
    });
  };
  const repositorySetNotNew = async (hass, repository) => {
    await hass.connection.sendMessagePromise({
      type: "hacs/repository",
      action: "not_new",
      repository: repository
    });
  };
  const repositoryUpdate = async (hass, repository) => {
    await hass.connection.sendMessagePromise({
      type: "hacs/repository",
      action: "update",
      repository: repository
    });
  };
  const repositoryDelete = async (hass, repository) => {
    await hass.connection.sendMessagePromise({
      type: "hacs/repository",
      action: "delete",
      repository: repository
    });
  };
  const settingsClearAllNewRepositories = async (hass, categories) => {
    await hass.connection.sendMessagePromise({
      type: "hacs/settings",
      action: "clear_new",
      categories
    });
  };
  const getLovelaceConfiguration = async hass => {
    try {
      const response = await hass.connection.sendMessagePromise({
        type: "lovelace/resources"
      });
      return response;
    } catch (e) {
      return null;
    }
  };
  const fetchResources = hass => hass.connection.sendMessagePromise({
    type: "lovelace/resources"
  });
  const createResource = (hass, values) => hass.callWS({
    type: "lovelace/resources/create",
    ...values
  });
  const updateResource = (hass, values) => hass.callWS({
    type: "lovelace/resources/update",
    ...values
  });
  const deleteResource = (hass, id) => hass.callWS({
    type: "lovelace/resources/delete",
    resource_id: id
  });

  const hacsStyleVariables = css`
  :host {
    --hcv-color-error: var(--hacs-error-color, var(--google-red-500, #f44336));
    --hcv-color-warning: var(--hacs-warning-color, #ff8c00);
    --hcv-color-update: var(--hacs-update-color, #f4b400);
    --hcv-color-new: var(--hacs-new-color, var(--google-blue-500, #2196f3));
    --hcv-color-icon: var(--hacs--default-icon-color, var(--sidebar-icon-color));
    --hcv-color-markdown-background: var(--markdown-code-background-color, #f6f8fa);

    --hcv-text-color-primary: var(--primary-text-color);
    --hcv-text-color-on-background: var(--text-primary-color);
    --hcv-text-color-secondary: var(--secondary-text-color);
    --hcv-text-color-link: var(--link-text-color, var(--accent-color));

    --mdc-dialog-heading-ink-color: var(--hcv-text-color-primary);
    --mdc-dialog-content-ink-color: var(--hcv-text-color-primary);

    /*hacs-fab*/
    --hcv-color-fab: var(--hacs-fab-color, var(--accent-color));
    --hcv-text-color-fab: var(--hacs-fab-text-color, var(--hcv-text-color-on-background));

    /*hacs-chip*/
    --hcv-color-chip: var(--hacs-chip-color, var(--accent-color));
    --hcv-text-color-chip: var(--hacs-chip-text-color, var(--hcv-text-color-on-background));

    /*hacs-link*/
    --hcv-text-decoration-link: var(--hacs-link-text-decoration, none);
  }
`;

  const hacsLinkStyle = css`
  a {
    text-decoration: var(--hcv-text-decoration-link);
    color: var(--hcv-text-color-link);
  }
`;
  const hacsButtonStyle = css`
  mwc-button[raised] {
    border-radius: 10px;
  }
`;
  const hacsIconStyle = css`
  paper-menu-button,
  ha-icon-button,
  ha-icon {
    color: var(--hcv-color-icon);
  }
`;
  const hassTabsSubpage = css`
  hass-tabs-subpage {
    font-family: var(--paper-font-body1_-_font-family);
    -webkit-font-smoothing: var(--paper-font-body1_-_-webkit-font-smoothing);
    font-size: var(--paper-font-body1_-_font-size);
    font-weight: var(--paper-font-body1_-_font-weight);
    line-height: var(--paper-font-body1_-_line-height);
  }
`;
  const fabStyles = css`
  mwc-fab {
    position: fixed;
    bottom: 100px;
    right: 24px;
    z-index: 1;
    margin-bottom: -80px;
    transition: margin-bottom 0.3s;
  }

  mwc-fab[is-wide] {
    bottom: 100px;
    right: 24px;
  }
  mwc-fab[narrow] {
    bottom: 152px;
  }
  mwc-fab[dirty] {
    margin-bottom: 0;
  }

  mwc-fab.rtl {
    right: auto;
    right: 24px;
  }

  mwc-fab[is-wide].rtl {
    bottom: 100px;
    right: auto;
    left: 24px;
  }
`;
  const searchStyles = css`
  search-input.header {
    display: block;
    position: relative;
    left: -22px;
    top: -7px;
    color: var(--secondary-text-color);
    margin-left: 0;
  }
  .search {
    padding: 0 16px;
    background: var(--sidebar-background-color);
    border-bottom: 1px solid var(--divider-color);
  }
  .search search-input {
    position: relative;
    top: 2px;
  }

  search-input {
    --layout-fit_-_right: 100vw;
  }
`;
  const scrollBarStyle = css`
  *::-webkit-scrollbar {
    width: 0.2em;
  }

  *::-webkit-scrollbar-track {
    box-shadow: inset 0 0 6px rgba(0, 0, 0, 0.3);
  }

  *::-webkit-scrollbar-thumb {
    background-color: var(--accent-color);
  }
`;
  const hacsStyleDialog = [haStyleDialog, css``];

  const hacsCommonClasses = css`
  .warning {
    color: var(--hcv-color-warning);
  }
  .pending_update {
    color: var(--hcv-color-update);
  }
  .pending_restart,
  .error,
  .uninstall {
    color: var(--hcv-color-error);
    --mdc-theme-primary: var(--hcv-color-error);
  }
  .header {
    font-size: var(--paper-font-headline_-_font-size);
    opacity: var(--dark-primary-opacity);
    padding: 8px 0 4px 16px;
  }
`;
  const HacsStyles = [haStyle, hacsIconStyle, hacsButtonStyle, hacsCommonClasses, hacsLinkStyle];

  function areInputsEqual(newInputs, lastInputs) {
    if (newInputs.length !== lastInputs.length) {
      return false;
    }

    for (var i = 0; i < newInputs.length; i++) {
      if (newInputs[i] !== lastInputs[i]) {
        return false;
      }
    }

    return true;
  }

  function memoizeOne(resultFn, isEqual) {
    if (isEqual === void 0) {
      isEqual = areInputsEqual;
    }

    var lastThis;
    var lastArgs = [];
    var lastResult;
    var calledOnce = false;

    function memoized() {
      var newArgs = [];

      for (var _i = 0; _i < arguments.length; _i++) {
        newArgs[_i] = arguments[_i];
      }

      if (calledOnce && lastThis === this && isEqual(newArgs, lastArgs)) {
        return lastResult;
      }

      lastResult = resultFn.apply(this, newArgs);
      calledOnce = true;
      lastThis = this;
      lastArgs = newArgs;
      return lastResult;
    }

    return memoized;
  }

  // Material Design Icons v5.4.55
  var mdiAccount = "M12,4A4,4 0 0,1 16,8A4,4 0 0,1 12,12A4,4 0 0,1 8,8A4,4 0 0,1 12,4M12,14C16.42,14 20,15.79 20,18V20H4V18C4,15.79 7.58,14 12,14Z";
  var mdiAlertCircle = "M13,13H11V7H13M13,17H11V15H13M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z";
  var mdiArrowDownBold = "M9,4H15V12H19.84L12,19.84L4.16,12H9V4Z";
  var mdiArrowLeft = "M20,11V13H8L13.5,18.5L12.08,19.92L4.16,12L12.08,4.08L13.5,5.5L8,11H20Z";
  var mdiArrowRight = "M4,11V13H16L10.5,18.5L11.92,19.92L19.84,12L11.92,4.08L10.5,5.5L16,11H4Z";
  var mdiChevronLeft = "M15.41,16.58L10.83,12L15.41,7.41L14,6L8,12L14,18L15.41,16.58Z";
  var mdiChevronRight = "M8.59,16.58L13.17,12L8.59,7.41L10,6L16,12L10,18L8.59,16.58Z";
  var mdiClose = "M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z";
  var mdiCube = "M21,16.5C21,16.88 20.79,17.21 20.47,17.38L12.57,21.82C12.41,21.94 12.21,22 12,22C11.79,22 11.59,21.94 11.43,21.82L3.53,17.38C3.21,17.21 3,16.88 3,16.5V7.5C3,7.12 3.21,6.79 3.53,6.62L11.43,2.18C11.59,2.06 11.79,2 12,2C12.21,2 12.41,2.06 12.57,2.18L20.47,6.62C20.79,6.79 21,7.12 21,7.5V16.5M12,4.15L6.04,7.5L12,10.85L17.96,7.5L12,4.15Z";
  var mdiDelete = "M19,4H15.5L14.5,3H9.5L8.5,4H5V6H19M6,19A2,2 0 0,0 8,21H16A2,2 0 0,0 18,19V7H6V19Z";
  var mdiDotsVertical = "M12,16A2,2 0 0,1 14,18A2,2 0 0,1 12,20A2,2 0 0,1 10,18A2,2 0 0,1 12,16M12,10A2,2 0 0,1 14,12A2,2 0 0,1 12,14A2,2 0 0,1 10,12A2,2 0 0,1 12,10M12,4A2,2 0 0,1 14,6A2,2 0 0,1 12,8A2,2 0 0,1 10,6A2,2 0 0,1 12,4Z";
  var mdiExclamationThick = "M10 3H14V14H10V3M10 21V17H14V21H10Z";
  var mdiGithub = "M12,2A10,10 0 0,0 2,12C2,16.42 4.87,20.17 8.84,21.5C9.34,21.58 9.5,21.27 9.5,21C9.5,20.77 9.5,20.14 9.5,19.31C6.73,19.91 6.14,17.97 6.14,17.97C5.68,16.81 5.03,16.5 5.03,16.5C4.12,15.88 5.1,15.9 5.1,15.9C6.1,15.97 6.63,16.93 6.63,16.93C7.5,18.45 8.97,18 9.54,17.76C9.63,17.11 9.89,16.67 10.17,16.42C7.95,16.17 5.62,15.31 5.62,11.5C5.62,10.39 6,9.5 6.65,8.79C6.55,8.54 6.2,7.5 6.75,6.15C6.75,6.15 7.59,5.88 9.5,7.17C10.29,6.95 11.15,6.84 12,6.84C12.85,6.84 13.71,6.95 14.5,7.17C16.41,5.88 17.25,6.15 17.25,6.15C17.8,7.5 17.45,8.54 17.35,8.79C18,9.5 18.38,10.39 18.38,11.5C18.38,15.32 16.04,16.16 13.81,16.41C14.17,16.72 14.5,17.33 14.5,18.26C14.5,19.6 14.5,20.68 14.5,21C14.5,21.27 14.66,21.59 15.17,21.5C19.14,20.16 22,16.42 22,12A10,10 0 0,0 12,2Z";
  var mdiMagnify = "M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z";
  var mdiMenu = "M3,6H21V8H3V6M3,11H21V13H3V11M3,16H21V18H3V16Z";
  var mdiPalette = "M17.5,12A1.5,1.5 0 0,1 16,10.5A1.5,1.5 0 0,1 17.5,9A1.5,1.5 0 0,1 19,10.5A1.5,1.5 0 0,1 17.5,12M14.5,8A1.5,1.5 0 0,1 13,6.5A1.5,1.5 0 0,1 14.5,5A1.5,1.5 0 0,1 16,6.5A1.5,1.5 0 0,1 14.5,8M9.5,8A1.5,1.5 0 0,1 8,6.5A1.5,1.5 0 0,1 9.5,5A1.5,1.5 0 0,1 11,6.5A1.5,1.5 0 0,1 9.5,8M6.5,12A1.5,1.5 0 0,1 5,10.5A1.5,1.5 0 0,1 6.5,9A1.5,1.5 0 0,1 8,10.5A1.5,1.5 0 0,1 6.5,12M12,3A9,9 0 0,0 3,12A9,9 0 0,0 12,21A1.5,1.5 0 0,0 13.5,19.5C13.5,19.11 13.35,18.76 13.11,18.5C12.88,18.23 12.73,17.88 12.73,17.5A1.5,1.5 0 0,1 14.23,16H16A5,5 0 0,0 21,11C21,6.58 16.97,3 12,3Z";
  var mdiPlus = "M19,13H13V19H11V13H5V11H11V5H13V11H19V13Z";
  var mdiPuzzle = "M20.5,11H19V7C19,5.89 18.1,5 17,5H13V3.5A2.5,2.5 0 0,0 10.5,1A2.5,2.5 0 0,0 8,3.5V5H4A2,2 0 0,0 2,7V10.8H3.5C5,10.8 6.2,12 6.2,13.5C6.2,15 5,16.2 3.5,16.2H2V20A2,2 0 0,0 4,22H7.8V20.5C7.8,19 9,17.8 10.5,17.8C12,17.8 13.2,19 13.2,20.5V22H17A2,2 0 0,0 19,20V16H20.5A2.5,2.5 0 0,0 23,13.5A2.5,2.5 0 0,0 20.5,11Z";
  var mdiRobot = "M12,2A2,2 0 0,1 14,4C14,4.74 13.6,5.39 13,5.73V7H14A7,7 0 0,1 21,14H22A1,1 0 0,1 23,15V18A1,1 0 0,1 22,19H21V20A2,2 0 0,1 19,22H5A2,2 0 0,1 3,20V19H2A1,1 0 0,1 1,18V15A1,1 0 0,1 2,14H3A7,7 0 0,1 10,7H11V5.73C10.4,5.39 10,4.74 10,4A2,2 0 0,1 12,2M7.5,13A2.5,2.5 0 0,0 5,15.5A2.5,2.5 0 0,0 7.5,18A2.5,2.5 0 0,0 10,15.5A2.5,2.5 0 0,0 7.5,13M16.5,13A2.5,2.5 0 0,0 14,15.5A2.5,2.5 0 0,0 16.5,18A2.5,2.5 0 0,0 19,15.5A2.5,2.5 0 0,0 16.5,13Z";
  var mdiStar = "M12,17.27L18.18,21L16.54,13.97L22,9.24L14.81,8.62L12,2L9.19,8.62L2,9.24L7.45,13.97L5.82,21L12,17.27Z";

  const languages = {
    "da": {
      "common": {
        "about": "Om",
        "add": "tilføj",
        "appdaemon_apps": "AppDaemon-apps",
        "appdaemon_plural": "AppDaemon-apps",
        "background_task": "Baggrundsopgave kører. Denne side vil genindlæses automatisk.",
        "check_log_file": "Tjek din logfil for flere detaljer.",
        "continue": "Fortsæt",
        "disabled": "Deaktiveret",
        "documentation": "Dokumentation",
        "element": "element",
        "hacs_is_disabled": "HACS er deaktiveret",
        "install": "Installer",
        "installed": "installeret",
        "integration": "Integration",
        "integration_plural": "Integrationer",
        "integrations": "Integrationer",
        "lovelace": "Lovelace",
        "lovelace_element": "Lovelace-element",
        "lovelace_elements": "Lovelace-elementer",
        "manage": "administrer",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDaemon-apps",
        "netdaemon_plural": "NetDaemon-apps",
        "plugin": "Lovelace",
        "plugin_plural": "Lovelace-elementer",
        "plugins": "Lovelace-elementer",
        "python_script": "Python-script",
        "python_script_plural": "Python-scripts",
        "python_scripts": "Python-scripts",
        "repositories": "Repositories",
        "repository": "Repository",
        "settings": "indstillinger",
        "theme": "Tema",
        "theme_plural": "Temaer",
        "themes": "Temaer",
        "uninstall": "Afinstaller",
        "update": "Opdater",
        "version": "Version"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Kun en enkelt konfiguration af HACS er tilladt."
        },
        "error": {
          "auth": "Personlig adgangstoken er ikke korrekt."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Aktiver opdagelse & sporing af AppDaemon-apps",
              "netdaemon": "Aktiver opdagelse og sporing af NetDaemon-apps",
              "python_script": "Aktivér opdagelse og sporing af python_scripts",
              "sidepanel_icon": "Sidepanelikon",
              "sidepanel_title": "Sidepanelets titel",
              "theme": "Aktivér opdagelse og sporing af temaer",
              "token": "GitHub personlig adgangstoken"
            },
            "description": "Hvis du har brug for hjælp til konfigurationen, så kig her: https://hacs.xyz/docs/configuration/start"
          }
        }
      },
      "confirm": {
        "add_to_lovelace": "Er du sikker på, at du vil tilføje dette til dine Lovelace-ressourcer?",
        "bg_task": "Handlingen er deaktiveret, mens baggrundsopgaver kører.",
        "cancel": "Annuller",
        "continue": "Er du sikker på, at du vil fortsætte?",
        "delete": "Er du sikker på, at du vil slette '{Item}'?",
        "delete_installed": "'{item}' er installeret. Du skal afinstallere det, før du kan slette det.",
        "exist": "{item} findes allerede",
        "generic": "Er du sikker?",
        "home_assistant_is_restarting": "Vent venligst - Home Assistant genstarter nu.",
        "home_assistant_version_not_correct": "Du kører Home Assistant version '{haversion}', men dette repository kræver som minimum version '{minversion}'.",
        "no": "Nej",
        "no_upgrades": "Der er ingen opdateringer tilgængelig",
        "ok": "OK",
        "overwrite": "Dette vil overskrive den.",
        "reload_data": "Dette genindlæser data fra alle repositories, som HACS kender til. Dette vil tage nogen tid at fuldføre.",
        "restart_home_assistant": "Er du sikker på, at du vil genstarte Home Assistant?",
        "uninstall": "Er du sikker på, at du vil afinstallere '{Item}'?",
        "upgrade_all": "Dette vil opdatere alle repositories. Sørg for at du har læst udgivelsesnoterne for dem alle, inden du fortsætter.",
        "yes": "Ja"
      },
      "dialog_about": {
        "frontend_version": "Frontend-version",
        "installed_repositories": "Installerede repositories",
        "integration_version": "Integrationsversion",
        "useful_links": "Nyttige links"
      },
      "dialog_add_repo": {
        "limit": "Kun de første 100 repositories vises. Brug søgningen til at filtrere, hvad du har brug for",
        "no_match": "Der blev ikke fundet nogen repositories, der matcher dit filter",
        "sort_by": "Sorter efter",
        "title": "Tilføj repository"
      },
      "dialog_custom_repositories": {
        "category": "Kategori",
        "no_category": "Manglende kategori",
        "no_repository": "Manglende repository",
        "title": "Brugerdefinerede repositories",
        "url_placeholder": "Tilføj brugerdefineret repository-webadresse"
      },
      "dialog_info": {
        "author": "Udvikler",
        "downloads": "Downloads",
        "install": "Installer dette repository i HACS",
        "loading": "Indlæser oplysninger...",
        "no_info": "Udvikleren har ikke givet flere oplysninger om dette repository",
        "open_issues": "Åbn issues",
        "open_repo": "Åbn repository",
        "stars": "Stjerner",
        "version_installed": "Installeret version"
      },
      "dialog_install": {
        "restart": "Husk, at du skal genstarte Home Assistant, før ændringer af integrationer (custom_components) træder i kræft.",
        "select_version": "Vælg version",
        "show_beta": "Vis betaversioner",
        "type": "Type",
        "url": "Webadresse"
      },
      "dialog_update": {
        "available_version": "Tilgængelig version",
        "changelog": "Udgivelsesnoter",
        "installed_version": "Installeret version",
        "releasenotes": "Udgivelsesnoter for {release}",
        "title": "Ventende opdatering"
      },
      "entry": {
        "information": "Oplysninger",
        "intro": "Opdateringer og vigtige meddelelser vises her, hvis der er nogen",
        "messages": {
          "disabled": {
            "content": "Tjek din logfil for flere detaljer",
            "title": "HACS er deaktiveret"
          },
          "has_pending_tasks": {
            "content": "Nogle repositories vises muligvis ikke, før dette er fuldført",
            "title": "Baggrundsopgaver venter"
          },
          "resources": {
            "content": "Du har {number} Lovelace-elementer, der ikke er indlæst korrekt i Lovelace.",
            "title": "Ikke indlæst i Lovelace"
          },
          "restart": {
            "content": "Du har {number} integrationer, der kræver en genstart af Home Assistant. Du kan genstarte fra 'Serveradministration'-sektionen under Indstillinger i Home Assistant-brugerfladen.",
            "title": "Afventer genstart"
          },
          "startup": {
            "content": "HACS starter op. Der kan i dette tidsrum mangle nogle oplysninger, eller de kan være ukorekte.",
            "title": "HACS starter op"
          },
          "wrong_frontend_installed": {
            "content": "Du har version {running} af HACS-frontend installeret, men version {expected} var forventet, hvis dette ser du denne besked. Home Assistant kunne ikke installere den nye version. Prøv at genstarte Home Assistant.",
            "title": "Uventet frontend-version"
          },
          "wrong_frontend_loaded": {
            "content": "Du kører version {running} af HACS-frontend, men version {expected} var forventet. Du bør rydde din browser-cache.",
            "title": "Uventet frontend-version"
          }
        },
        "pending_updates": "Ventende opdateringer"
      },
      "menu": {
        "about": "Om HACS",
        "clear": "Ryd alle nye",
        "custom_repositories": "Brugerdefinerede repositories",
        "dismiss": "Afvis alle nye repositories",
        "documentation": "Dokumentation",
        "open_issue": "Opret issue",
        "reload": "Genindlæs vindue"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Aktiver opdagelse og sporing af AppDaemon-apps",
              "country": "Filtrer med landekode.",
              "debug": "Aktiver debug.",
              "experimental": "Aktivér eksperimentelle funktioner",
              "netdaemon": "Aktiver opdagelse og sporing af NetDaemon-apps",
              "not_in_use": "Ikke i brug med YAML",
              "release_limit": "Antal udgivelser, der skal vises.",
              "sidepanel_icon": "Sidepanelikon",
              "sidepanel_title": "Sidepanelets titel"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Denne integration understøtter config_flow. Det betyder, at du nu kan gå til integrationssektionen i din brugerflade for at konfigurere den.",
        "config_flow_title": "Brugerfladekonfiguration understøttet",
        "integration_not_loaded": "Denne integration er ikke indlæst i Home Assistant.",
        "no_restart_required": "Ingen genstart påkrævet",
        "not_loaded": "Ikke indlæst",
        "plugin_not_loaded": "Dette element er ikke føjet til dine Lovelace-ressourcer.",
        "restart": "Du skal genstarte Home Assistant.",
        "restart_pending": "Afventer genstart"
      },
      "repository_card": {
        "dismiss": "Afvis",
        "hide": "Skjul",
        "information": "Oplysninger",
        "new_repository": "Nyt repository",
        "not_loaded": "Ikke indlæst",
        "open_issue": "Opret issue",
        "open_source": "Åbn kilde",
        "pending_restart": "Afventer genstart",
        "pending_update": "Ventende opdatering",
        "reinstall": "Geninstaller",
        "report": "Rapporter til fjernelse",
        "update_information": "Opdater oplysninger"
      },
      "repository": {
        "add_to_lovelace": "Tilføj til Lovelace",
        "authors": "Forfattere",
        "available": "Tilgængelig",
        "back_to": "Tilbage til",
        "changelog": "Udgivelsesnoter",
        "downloads": "Downloads",
        "flag_this": "Marker denne",
        "frontend_version": "Frontend-version",
        "github_stars": "GitHub-stjerner",
        "goto_integrations": "Gå til integrationer",
        "hide": "Skjul",
        "hide_beta": "Skjul beta",
        "install": "Installer",
        "installed": "Installeret",
        "lovelace_copy_example": "Kopiér eksemplet til din Udklipsholder",
        "lovelace_instruction": "Tilføj dette til din lovelace-konfiguration",
        "lovelace_no_js_type": "Kunne ikke afgøre typen af dette element, tjek venligst repository'et.",
        "newest": "nyeste",
        "note_appdaemon": "Du skal stadig føje den til filen 'apps.yaml'",
        "note_installed": "Når det er installeret, vil dette være placeret i",
        "note_integration": "du skal stadig føje den til filen 'configuration.yaml'",
        "note_plugin": "du skal stadig tilføje det til din lovelace-konfiguration ('ui-lovelace.yaml' eller Tekstbaseret redigering)",
        "note_plugin_post_107": "du skal stadig tilføje det til din lovelace-konfiguration ('configuration.yaml' eller ressourceeditoren '/config/lovelace/resources')",
        "open_issue": "Opret issue",
        "open_plugin": "Åbn element",
        "reinstall": "Geninstaller",
        "repository": "Repository",
        "restart_home_assistant": "Genstart Home Assistant",
        "show_beta": "Vis beta",
        "uninstall": "Afinstaller",
        "update_information": "Opdater oplysninger",
        "upgrade": "Opdater"
      },
      "search": {
        "installed": "Søg efter installerede repositories",
        "installed_new": "Søg efter installerede eller nye repositories",
        "placeholder": "Søg efter repository"
      },
      "sections": {
        "about": {
          "description": "Vis information om HACS",
          "title": "Om"
        },
        "automation": {
          "description": "Det er her, du finder python_scripts, AppDaemon-apps og NetDaemon-apps",
          "title": "Automatisering"
        },
        "frontend": {
          "description": "Det er her, du finder temaer, brugerdefinerede kort og andre elementer til lovelace",
          "title": "Frontend"
        },
        "integrations": {
          "description": "Det er her, du finder brugerdefinerede integrationer (custom_components)",
          "title": "Integrationer"
        },
        "pending_repository_upgrade": "Du kører version {installed}, version {available} er tilgængelig"
      },
      "settings": {
        "add_custom_repository": "TILFØJ ET BRUGERDEFINERET REPOSITORY",
        "adding_new_repo": "Tilføjer nyt repository '{repo}'",
        "adding_new_repo_category": "Med kategorien '{category}'.",
        "bg_task_custom": "Brugerdefinerede repositories er skjult, mens opgaver i baggrunden kører.",
        "category": "Kategori",
        "compact_mode": "Kompakt tilstand",
        "custom_repositories": "BRUGERDEFINEREDE REPOSITORIES",
        "delete": "Slet",
        "display": "Visning",
        "grid": "Gitter",
        "hacs_repo": "HACS-repo",
        "hidden_repositories": "Skjulte repositories",
        "missing_category": "Du skal vælge en kategori",
        "open_repository": "Åbn repository",
        "reload_data": "Genindlæs data",
        "reload_window": "Genindlæs vindue",
        "repository_configuration": "Konfiguration af repository",
        "save": "Gem",
        "table": "Tabel",
        "table_view": "Tabelvisning",
        "unhide": "Vis",
        "upgrade_all": "Opdater alle"
      },
      "store": {
        "ascending": "stigende",
        "clear_new": "Marker alle som set",
        "descending": "faldende",
        "last_updated": "Sidst opdateret",
        "name": "Navn",
        "new_repositories": "Nye repositories",
        "new_repositories_note": "Du har over 10 nye repositories, der vises her. Hvis du vil rydde dem alle, skal du klikke på de 3 prikker i øverste højre hjørne og afvise dem alle.",
        "no_repositories": "Ingen repositories",
        "no_repositories_desc1": "Det ser ud til, at du ikke har nogen repositories installeret i denne sektion endnu.",
        "no_repositories_desc2": "Klik på + i nederste hjørne for at tilføje dit første!",
        "no_repositories_found_desc1": "Der blev ikke fundet installerede repositories, der matcher \"{searchInput}\" i denne sektion.",
        "no_repositories_found_desc2": "Prøv at søge efter noget andet!",
        "pending_upgrades": "Ventende opdateringer",
        "placeholder_search": "Indtast en søgeterm...",
        "sort": "sorter",
        "stars": "Stjerner",
        "status": "Status"
      },
      "time": {
        "ago": "siden",
        "day": "dag",
        "days": "dage",
        "hour": "time",
        "hours": "timer",
        "minute": "minut",
        "minutes": "minutter",
        "month": "måned",
        "months": "måneder",
        "one": "Et",
        "one_day_ago": "en dag siden",
        "one_hour_ago": "en time siden",
        "one_minute_ago": "et minut siden",
        "one_month_ago": "en måned siden",
        "one_second_ago": "et sekund siden",
        "one_year_ago": "et år siden",
        "second": "sekund",
        "seconds": "sekunder",
        "x_days_ago": "{x} dage siden",
        "x_hours_ago": "{x} timer siden",
        "x_minutes_ago": "{x} minutter siden",
        "x_months_ago": "{x} måneder siden",
        "x_seconds_ago": "{x} sekunder siden",
        "x_years_ago": "{x} år siden",
        "year": "år",
        "years": "år"
      }
    },
    "de": {
      "common": {
        "about": "Über",
        "add": "hinzufügen",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "AppDaemon Apps",
        "appdaemon_plural": "AppDaemon Apps",
        "background_task": "Hintergrundprozess läuft. Diese Seite lädt neu, sobald dieser fertig ist.",
        "check_log_file": "Überprüfe die Logdatei für weitere Informationen.",
        "continue": "Fortfahren",
        "disabled": "Deaktiviert",
        "documentation": "Dokumentation",
        "element": "Element",
        "hacs_is_disabled": "HACS ist deaktiviert",
        "install": "Installieren",
        "installed": "Installiert",
        "integration": "Integration",
        "integration_plural": "Integrationen",
        "integrations": "Integrationen",
        "lovelace": "Lovelace",
        "lovelace_element": "Lovelace-Element",
        "lovelace_elements": "Lovelace-Elemente",
        "manage": "verwalten",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDaemon Apps",
        "netdaemon_plural": "NetDaemon Apps",
        "plugin": "Lovelace",
        "plugin_plural": "Lovelace-Elemente",
        "plugins": "Lovelace-Elemente",
        "python_script": "Python Skript",
        "python_script_plural": "Python Skripte",
        "python_scripts": "Python Skripte",
        "repositories": "Repositories",
        "repository": "Repository",
        "settings": "Einstellungen",
        "theme": "Theme",
        "theme_plural": "Themes",
        "themes": "Themes",
        "uninstall": "Deinstallieren",
        "update": "Aktualisieren",
        "version": "Version"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Es ist nur eine einzelne HACS-Instanz erlaubt."
        },
        "error": {
          "auth": "Persönlicher Zugriffstoken ist falsch."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "AppDaemon App-Entdeckung & Nachverfolgung aktivieren",
              "netdaemon": "NetDaemon App-Entdeckung & Nachverfolgung aktivieren",
              "python_script": "Python Script-Entdeckung & Nachverfolgung aktivieren",
              "sidepanel_icon": "Sidepanel Symbol",
              "sidepanel_title": "Sidepanel Titel",
              "theme": "Theme-Entdeckung & Nachverfolgung aktivieren",
              "token": "Persönlicher GitHub Zugriffstoken"
            },
            "description": "Wenn du Hilfe mit den Einstellungen brauchst, kannst du hier nachsehen: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Möchtest du dies wirklich zu deinen Lovelace-Ressourcen hinzufügen?",
        "bg_task": "Die Aktion ist deaktiviert, während Hintergrundprozesse ausgeführt werden.",
        "cancel": "Abbrechen",
        "continue": "Bist du dir sicher, dass du fortfahren möchtest?",
        "delete": "Möchtest du '{item}' wirklich löschen?",
        "delete_installed": "'{item}' ist installiert. Du musst es deinstallieren, bevor du es löschen kannst.",
        "exist": "{item} existiert bereits",
        "generic": "Bist du dir sicher?",
        "home_assistant_is_restarting": "Bitte warte, Home Assistant wird jetzt neu gestartet.",
        "home_assistant_version_not_correct": "Du benutzt die Home Assistant-Version '{haversion}', für dieses Repository muss jedoch die Mindestversion '{minversion}' installiert sein.",
        "no": "Nein",
        "no_upgrades": "Keine Upgrades ausstehend",
        "ok": "OK",
        "overwrite": "Dadurch wird die Datei überschrieben.",
        "reload_data": "Hierdurch werden die Daten aller Repositories die HACS kennt neu geladen. Dies wird einige Zeit in Anspruch nehmen.",
        "restart_home_assistant": "Bist du dir sicher, dass du Home Assistant neu starten möchtest?",
        "uninstall": "Möchtest du '{item}' wirklich deinstallieren?",
        "upgrade_all": "Hierdurch werden all diese Repositories aktualisiert. Stelle sicher, dass du die Versionshinweise vorher gelesen hast.",
        "yes": "Ja"
      },
      "dialog_about": {
        "frontend_version": "Frontend Version",
        "installed_repositories": "Installierte Repositories",
        "integration_version": "Integrations Version",
        "useful_links": "Nützliche Links"
      },
      "dialog_add_repo": {
        "limit": "Es werden nur die ersten 100 Repositories angezeigt. Verwenden Sie die Suche, um zu filtern, was Sie benötigen",
        "no_match": "Es wurden keine Repositories gefunden, die Ihrem Filter entsprechen",
        "sort_by": "Sortiere nach",
        "title": "Repository hinzufügen"
      },
      "dialog_custom_repositories": {
        "category": "Kategorie",
        "no_category": "Fehlende Kategorie",
        "no_repository": "Fehlendes Repository",
        "title": "Benutzerdefinierte Repositories",
        "url_placeholder": "Fügen Sie eine benutzerdefinierte Repository-URL hinzu"
      },
      "dialog_info": {
        "author": "Autor",
        "downloads": "Downloads",
        "install": "Installieren Sie dieses Repository in HACS",
        "loading": "Informationen laden...",
        "no_info": "Der Entwickler hat keine weiteren Informationen für dieses Repository bereitgestellt",
        "open_issues": "Probleme melden",
        "open_repo": "Repository öffnen",
        "stars": "Sterne",
        "version_installed": "Version installiert"
      },
      "dialog_install": {
        "restart": "Denken Sie daran, dass Sie Home Assistant neu starten müssen, bevor Änderungen an Integrationen (custom_components) angewendet werden.",
        "select_version": "Version auswählen",
        "show_beta": "Beta-Versionen anzeigen",
        "type": "Typ",
        "url": "URL"
      },
      "dialog_update": {
        "available_version": "Verfügbare Version",
        "changelog": "Änderungsprotokoll",
        "installed_version": "Installierte Version",
        "releasenotes": "Releasenotes für {release}",
        "title": "Update ausstehend"
      },
      "entry": {
        "information": "Information",
        "intro": "Aktualisierungen und wichtige Meldungen werden hier angezeigt, falls vorhanden",
        "messages": {
          "disabled": {
            "content": "Überprüfe die Logdatei für weitere Informationen",
            "title": "HACS ist deaktiviert"
          },
          "has_pending_tasks": {
            "content": "Einige Repositorys werden möglicherweise erst angezeigt, wenn dies abgeschlossen ist",
            "title": "Hintergrundaufgaben stehen noch aus"
          },
          "resources": {
            "content": "Sie haben {number} Lovelace-Elemente, die in Lovelace nicht richtig geladen sind.",
            "title": "Nicht in Lovelace geladen"
          },
          "restart": {
            "content": "Sie haben {number} Integrationen, die einen Neustart von Home Assistant erfordern. Dies können Sie im Abschnitt 'Server Controls' im Konfigurationsteil der Home Assistant-Benutzeroberfläche tun.",
            "title": "Ausstehender Neustart"
          },
          "startup": {
            "content": "HACS wird gestartet, während dieser Zeit könnten einige Informationen fehlen oder falsch sein",
            "title": "HACS startet"
          },
          "wrong_frontend_installed": {
            "content": "Sie haben {running} des HACS-Frontends installiert, aber Version {expected} wurde erwartet. Wenn diese Meldung angezeigt wird, dass Home Assistant die neue Version nicht installieren konnte, starten Sie Home Assistant neu.",
            "title": "Unerwartete Frontend-Version"
          },
          "wrong_frontend_loaded": {
            "content": "Sie führen die Version {running} des HACS-Frontends aus, aber es wurde die Version {expected} erwartet. Sie sollten Ihren Browser-Cache leeren.",
            "title": "Unerwartete Frontend-Version"
          }
        },
        "pending_updates": "Ausstehende Updates"
      },
      "menu": {
        "about": "Über HACS",
        "clear": "Alles neue als gesehen markieren",
        "custom_repositories": "Benutzerdefinierte Repositories",
        "dismiss": "Alle neuen Repositories ausblenden",
        "documentation": "Dokumentation",
        "open_issue": "Problem melden",
        "reload": "Fenster neu laden"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "AppDaemon App-Entdeckung & Nachverfolgung aktivieren",
              "country": "Nach Ländercode filtern.",
              "debug": "Debug aktivieren.",
              "experimental": "Experimentelle Funktionen aktivieren",
              "netdaemon": "NetDaemon App-Entdeckung & Nachverfolgung aktivieren",
              "not_in_use": "Nicht in Verwendung mit YAML",
              "release_limit": "Anzahl anzuzeigender Releases.",
              "sidepanel_icon": "Sidepanel Symbol",
              "sidepanel_title": "Sidepanel Titel"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Diese Integration unterstützt config_flow. Das bedeutet, dass du jetzt in den Integrationsbereich deiner Benutzeroberfläche wechseln kannst, um es zu konfigurieren.",
        "config_flow_title": "UI-Konfiguration unterstützt",
        "integration_not_loaded": "Diese Integration ist in Home Assistant nicht geladen.",
        "no_restart_required": "Kein Neustart erforderlich",
        "not_loaded": "Nicht geladen",
        "plugin_not_loaded": "Dieses Element wird nicht zu Ihren Lovelace-Ressourcen hinzugefügt.",
        "restart": "Du musst Home Assistant neu starten.",
        "restart_pending": "Neustart ausstehend"
      },
      "repository_card": {
        "dismiss": "Ausblenden",
        "hide": "Verstecken",
        "information": "Information",
        "new_repository": "Neues Repository",
        "not_loaded": "Nicht geladen",
        "open_issue": "Problem melden",
        "open_source": "Quelldateien öffnen",
        "pending_restart": "Ausstehender Neustart",
        "pending_update": "Ausstehende Aktualisierung",
        "reinstall": "Neu installieren",
        "report": "Melden zur Entfernung des Repositorys",
        "update_information": "Aktualisierungsinformationen"
      },
      "repository": {
        "add_to_lovelace": "Zu Lovelace hinzufügen",
        "authors": "Autoren",
        "available": "Verfügbar",
        "back_to": "Zurück zu",
        "changelog": "Änderungsprotokoll",
        "downloads": "Downloads",
        "flag_this": "Melden",
        "frontend_version": "Frontend Version",
        "github_stars": "GitHub Sterne",
        "goto_integrations": "Gehe zu Integrationen",
        "hide": "Verstecken",
        "hide_beta": "Beta verstecken",
        "install": "Installieren",
        "installed": "Installiert",
        "lovelace_copy_example": "Beispiel in die Zwischenablage kopieren",
        "lovelace_instruction": "Zum Hinzufügen zu deinen Lovelace-Einstellungen, benutze Folgendes",
        "lovelace_no_js_type": "Der Typ dieses Elements konnte nicht ermittelt werden. Überprüfen Sie das Repository.",
        "newest": "neueste",
        "note_appdaemon": "du musst es dann noch in die Datei 'apps.yaml' hinzufügen",
        "note_installed": "Wird installiert nach",
        "note_integration": "du musst es dann noch in die Datei 'configuration.yaml' hinzufügen",
        "note_plugin": "du musst es dann noch in deine Lovelace-Einstellungen ('ui-lovelace.yaml' oder im Raw-Konfigurationseditor) hinzufügen",
        "note_plugin_post_107": "Du musst es noch zu deiner Lovelace-Konfiguration hinzufügen ('configuration.yaml' oder der Ressourceneditor '/config/lovelace/resources')",
        "open_issue": "Problem melden",
        "open_plugin": "Element öffnen",
        "reinstall": "Neu installieren",
        "repository": "Repository",
        "restart_home_assistant": "Home Assistant neu starten",
        "show_beta": "Beta anzeigen",
        "uninstall": "Deinstallieren",
        "update_information": "Aktualisierungsinformationen",
        "upgrade": "Aktualisieren"
      },
      "search": {
        "placeholder": "Suche nach Repository"
      },
      "sections": {
        "about": {
          "description": "Informationen zu HACS anzeigen",
          "title": "Über"
        },
        "automation": {
          "description": "Hier finden Sie python_scripts, AppDaemon-Apps und NetDaemon-Apps",
          "title": "Automatisierung"
        },
        "frontend": {
          "description": "Hier finden Sie Themen, individuelle Karten und andere Elemente für Lovelace",
          "title": "Frontend"
        },
        "integrations": {
          "description": "Hier finden Sie benutzerdefinierte Integrationen (custom_components)",
          "title": "Integrationen"
        },
        "pending_repository_upgrade": "Sie verwenden Version {installed}, Version {available} ist verfügbar"
      },
      "settings": {
        "add_custom_repository": "BENUTZERDEFINIERTES REPOSITORY HINZUFÜGEN",
        "adding_new_repo": "Hinzufügen eines neuen Repository '{repo}'",
        "adding_new_repo_category": "Mit der Kategorie '{category}'.",
        "bg_task_custom": "Custom Repositorys werden ausgeblendet, während Hintergrundaufgaben ausgeführt werden.",
        "category": "Kategorie",
        "compact_mode": "Kompakter Modus",
        "custom_repositories": "BENUTZERDEFINIERTE REPOSITORIES",
        "delete": "Löschen",
        "display": "Anzeige",
        "grid": "Gitter",
        "hacs_repo": "HACS repo",
        "hidden_repositories": "versteckte Repositories",
        "missing_category": "Du musst eine Kategorie auswählen.",
        "open_repository": "Repository öffnen",
        "reload_data": "Daten neu laden",
        "reload_window": "Fenster neu laden",
        "repository_configuration": "Repository Konfiguration",
        "save": "Speichern",
        "table": "Tabelle",
        "table_view": "Tabellenansicht",
        "unhide": "einblenden",
        "upgrade_all": "Alles aktualisieren"
      },
      "store": {
        "ascending": "Aufsteigend",
        "clear_new": "Alle neuen Repositories als gesehen markieren",
        "descending": "Absteigend",
        "last_updated": "Zuletzt aktualisiert",
        "name": "Name",
        "new_repositories": "Neue Repositories",
        "new_repositories_note": "Hier werden über 10 neue Repositorys angezeigt. Wenn Sie alle als gelesen markieren möchten, klicken Sie auf die 3 Punkte in der oberen rechten Ecke und blenden sie alle aus.",
        "no_repositories": "Keine Repositories",
        "no_repositories_desc1": "Anscheinend sind in diesem Abschnitt noch keine Repositories installiert.",
        "no_repositories_desc2": "Klicken Sie auf das + in der unteren Ecke, um Ihre ersten hinzuzufügen!",
        "no_repositories_found_desc1": "In diesem Abschnitt wurden keine installierten Repositorys gefunden, die mit \"{searchInput}\" übereinstimmen.",
        "no_repositories_found_desc2": "Versuchen Sie, nach etwas anderem zu suchen!",
        "pending_upgrades": "Ausstehende Upgrades",
        "placeholder_search": "Suchbegriff eingeben…",
        "sort": "Sortieren",
        "stars": "Sterne",
        "status": "Status"
      },
      "time": {
        "ago": "vor",
        "day": "Tag",
        "days": "Tage",
        "hour": "Stunde",
        "hours": "Stunden",
        "minute": "Minute",
        "minutes": "Minuten",
        "month": "Monat",
        "months": "Monate",
        "one": "Eins",
        "one_day_ago": "vor einem Tag",
        "one_hour_ago": "vor einer Stunde",
        "one_minute_ago": "vor einer Minute",
        "one_month_ago": "vor einem Monat",
        "one_second_ago": "vor einer Sekunde",
        "one_year_ago": "vor einem Jahr",
        "second": "Sekunde",
        "seconds": "Sekunden",
        "x_days_ago": "vor {x} Tagen",
        "x_hours_ago": "vor {x} Stunden",
        "x_minutes_ago": "vor {x} Minuten",
        "x_months_ago": "vor {x} Monaten",
        "x_seconds_ago": "vor {x} Sekunden",
        "x_years_ago": "vor {x} Jahren",
        "year": "Jahr",
        "years": "Jahre"
      }
    },
    "el": {
      "common": {
        "about": "Σχετικά με",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "AppDaemon Apps",
        "background_task": "Τρέχει μια διεργασία στο παρασκήνιο, η σελίδα θα ανανεωθεί μόλις αυτό ολοκληρωθεί.",
        "check_log_file": "Ελέγξτε το αρχείο καταγραφής για περισσότερες λεπτομέρειες.",
        "continue": "Να συνεχίσει",
        "disabled": "Απενεργοποιημένο",
        "documentation": "Τεκμηρίωση",
        "hacs_is_disabled": "Το HACS είναι απενεργοποιημένο",
        "installed": "εγκατεστημένο",
        "integration": "Ενσωμάτωση",
        "integrations": "Ενσωματωμένα",
        "manage": "διαχειρίζονται",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDaemon Apps",
        "plugin": "Lovelace",
        "plugins": "Πρόσθετα",
        "python_script": "Πρόγραμμα Python",
        "python_scripts": "Προγράμματα Python",
        "repositories": "Αποθετήρια",
        "settings": "ρυθμίσεις",
        "theme": "Θέμα",
        "themes": "Θέματα",
        "version": "Έκδοση"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Μονάχα μία ρύθμιση των παραμέτρων του HACS επιτρέπεται."
        },
        "error": {
          "auth": "Το διακριτικό πρόσβασης δεν είναι σωστό."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Ενεργοποίηση εύρεσης & παρακολούθησης για το AppDaemon",
              "netdaemon": "Ενεργοποίηση εύρεσης & παρακολούθησης για το NetDaemon",
              "python_script": "Ενεργοποίηση εύρεσης & παρακολούθησης για τα python_scripts",
              "sidepanel_icon": "Εικονίδιο πλαϊνού πάνελ",
              "sidepanel_title": "Τίτλος πλαϊνού πάνελ",
              "theme": "Ενεργοποίηση εύρεσης & παρακολούθησης για τα θεμάτων",
              "token": "Διακριτικό πρόσβασης του GitHub"
            },
            "description": "Εάν χρειαστείτε βοήθεια με τις ρυθμίσεις ανατρέξτε εδώ: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Είστε βέβαιοι ότι θέλετε να προσθέσετε αυτό στους πόρους του Lovelace;",
        "bg_task": "Η ενέργεια είναι απενεργοποιημένη όσο εκτελούνται εργασίες στο παρασκήνιο",
        "cancel": "Ακύρωση",
        "continue": "Είστε βέβαιοι ότι θέλετε να συνεχίσετε;",
        "delete": "Είστε σίγουροι ότι θέλετε να διαγράψετε το '{item}';",
        "delete_installed": "Το '{item}' είναι εγκατεστημένο, πρέπει να το απεγκαταστήσετε πριν να το διαγράψετε.",
        "exist": "{item} υπάρχει ήδη",
        "generic": "Είστε βέβαιοι;",
        "home_assistant_is_restarting": "Περιμένετε, το Home Assistant επανεκκινείται τώρα.",
        "no": "Οχι",
        "no_upgrades": "Δεν υπάρχουν αναβαθμίσεις σε εκκρεμότητα",
        "ok": "Εντάξει",
        "overwrite": "Αυτό θα το αντικαταστήσει.",
        "restart_home_assistant": "Είστε βέβαιοι ότι θέλετε να κάνετε επανεκκίνηση του Home Assistant;",
        "uninstall": "Είστε βέβαιοι ότι θέλετε να απεγκαταστήσετε το '{item}';",
        "upgrade_all": "Αυτό θα αναβαθμίσει όλα αυτά τα αποθετήρια, βεβαιωθείτε ότι έχετε διαβάσει τις σημειώσεις έκδοσης για όλα πριν προχωρήσετε.",
        "yes": "Ναι"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Ενεργοποίηση εύρεσης & παρακολούθησης για το AppDaemon",
              "country": "Κριτήριο με βάση τον κωδικό χώρας.",
              "debug": "Ενεργοποίηση εντοπισμού σφαλμάτων.",
              "experimental": "Ενεργοποίση πειραματικών λειτουργιών",
              "netdaemon": "Ενεργοποίηση εύρεσης & παρακολούθησης για το NetDaemon",
              "not_in_use": "Δεν χρησιμοποιείται με το YAML",
              "release_limit": "Αριθμός εκδόσεων που να παραθέτονται.",
              "sidepanel_icon": "Εικονίδιο πλαϊνού πάνελ",
              "sidepanel_title": "Τίτλος πλαϊνού πάνελ"
            }
          }
        }
      },
      "repository_banner": {
        "integration_not_loaded": "Αυτή η ενσωμάτωση δεν φορτώθηκε στο Home Assistant.",
        "no_restart_required": "Δεν απαιτείται επανεκκίνηση",
        "not_loaded": "Δεν έχει φορτωθεί",
        "plugin_not_loaded": "Αυτό το πρόσθετο δεν προστέθηκε στους πόρους του Lovelace.",
        "restart": "Πρέπει να κάνετε επανεκκίνηση του Home Assistant.",
        "restart_pending": "Επανεκκίνηση σε εκκρεμότητα"
      },
      "repository": {
        "add_to_lovelace": "Προσθήκη στο Lovelace",
        "authors": "Συγγραφείς",
        "available": "Διαθέσιμο",
        "back_to": "Πίσω στο",
        "changelog": "Σημειώσεις των αλλαγών",
        "downloads": "Λήψεις",
        "flag_this": "Σημείωσε αυτό",
        "frontend_version": "Έκδοση Frontend",
        "github_stars": "GitHub αστέρια",
        "goto_integrations": "Μετάβαση στις ενσωματώσεις",
        "hide": "Απόκρυψη",
        "hide_beta": "Απόκριση του beta",
        "install": "Εγκατάσταση",
        "installed": "Εγκατεστημένο",
        "lovelace_copy_example": "Αντίγραψε το παράδειγμα στο πρόχειρο",
        "lovelace_instruction": "Όταν το προσθέσετε στις ρυθμίσεις του lovelace χρησιμοποιήστε τούτο",
        "lovelace_no_js_type": "Δεν καταφέραμε να προσδιορίσουμε τον τύπο αυτού του προσθέτου, ελέξτε το αποθετήριο.",
        "newest": "νεότερο",
        "note_appdaemon": "εξακολουθεί να χρειάζεται να το προσθέσετε στο αρχείο 'apps.yaml'",
        "note_installed": "Όταν εγκατασταθεί, θα προστεθεί στο",
        "note_integration": "εξακολουθεί να χρειάζεται να το προσθέσετε στο αρχείο 'configuration.yaml'",
        "note_plugin": "εξακολουθεί να χρειάζετε να το προσθέσετε στις ρυθμίσεις του lovelace ('ui-lovelace.yaml' ή μέσω του γραφικού επεξεργαστή των ρυθμίσεων)",
        "open_issue": "Εκκρεμόν ζήτημα",
        "open_plugin": "Ανοιχτό πρόσθετο",
        "reinstall": "Επανεγκατάσταση",
        "repository": "Αποθετήριο",
        "restart_home_assistant": "Επανεκκίνηση του Home Assistant",
        "show_beta": "Εμφάνιση του beta",
        "uninstall": "Απεγκατάσταση",
        "update_information": "Ενημέρωση πληροφοριών",
        "upgrade": "Ενημέρωση"
      },
      "settings": {
        "add_custom_repository": "ΠΡΟΣΘΕΣΤΕ ΕΝΑ ΕΙΔΙΚΟ ΑΠΟΘΕΤΗΡΙΟ",
        "adding_new_repo": "Προσθήκη νέου αποθετηρίου '{repo}'",
        "adding_new_repo_category": "Με κατηγορία '{category}'.",
        "category": "Κατηγορία",
        "compact_mode": "Συμπαγής λειτουργία",
        "custom_repositories": "ΕΙΔΙΚΑ ΑΠΟΘΕΤΗΡΙΑ",
        "delete": "Διαγραφή",
        "display": "Εμφάνιση",
        "grid": "Πλέγμα",
        "hacs_repo": "Αποθετήριο του HACS",
        "hidden_repositories": "κρυφά αποθετήρια",
        "missing_category": "Πρέπει να επιλέξετε μια κατηγορία",
        "open_repository": "Ανοίξτε το αποθετήριο",
        "reload_data": "Επαναφόρτωση δεδομένων",
        "reload_window": "Επαναφόρτωση του παραθύρου",
        "repository_configuration": "Διαμόρφωση αποθετηρίου",
        "save": "Αποθήκευση",
        "table": "Πίνακας",
        "table_view": "Προβολή πίνακα",
        "unhide": "αποκρύψω",
        "upgrade_all": "Αναβάθμιση όλων"
      },
      "store": {
        "ascending": "αύξουσα",
        "clear_new": "Απαλοιφή όλων των νέων αποθετηρίων",
        "descending": "φθίνουσα",
        "last_updated": "Τελευταία ενημέρωση",
        "name": "Ονομα",
        "new_repositories": "Νέα αποθετήρια",
        "pending_upgrades": "Εκκρεμείς αναβαθμίσεις",
        "placeholder_search": "Παρακαλώ πληκτρολογήστε έναν όρο προς αναζήτηση...",
        "sort": "είδος",
        "stars": "Αστέρια",
        "status": "Κατάσταση"
      },
      "time": {
        "ago": "πριν",
        "day": "ημέρα",
        "days": "ημέρες",
        "hour": "ώρα",
        "hours": "ώρες",
        "minute": "λεπτό",
        "minutes": "λεπτά",
        "month": "μήνας",
        "months": "μήνες",
        "one": "Ένα",
        "one_day_ago": "πριν από μία ημέρα",
        "one_hour_ago": "πριν από μια ώρα",
        "one_minute_ago": "πριν από ένα λεπτό",
        "one_month_ago": "πριν από ένα μήνα",
        "one_second_ago": "πριν από ένα δευτερόλεπτο",
        "one_year_ago": "πριν από ένα χρόνο",
        "second": "δευτερόλεπτο",
        "seconds": "δευτερόλεπτα",
        "x_days_ago": "{x} ημέρες πριν",
        "x_hours_ago": "{x} ώρες πριν",
        "x_minutes_ago": "{x} λεπτά πριν",
        "x_months_ago": "{x} μήνες πριν",
        "x_seconds_ago": "{x} δευτερόλεπτα πριν",
        "x_years_ago": "{x} χρόνια πριν",
        "year": "έτος",
        "years": "χρόνια"
      }
    },
    "en": {
      "common": {
        "about": "About",
        "add": "add",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "AppDaemon Apps",
        "appdaemon_plural": "AppDaemon Apps",
        "background_task": "Background task running, this page will reload when it's done.",
        "check_log_file": "Check your log file for more details.",
        "continue": "Continue",
        "disabled": "Disabled",
        "documentation": "Documentation",
        "element": "element",
        "hacs_is_disabled": "HACS is disabled",
        "ignore": "Ignore",
        "install": "Install",
        "installed": "installed",
        "integration": "Integration",
        "integration_plural": "Integrations",
        "integrations": "Integrations",
        "lovelace": "Lovelace",
        "lovelace_element": "Lovelace element",
        "lovelace_elements": "Lovelace elements",
        "manage": "manage",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDaemon Apps",
        "netdaemon_plural": "NetDaemon Apps",
        "plugin": "Lovelace",
        "plugin_plural": "Lovelace elements",
        "plugins": "Lovelace elements",
        "python_script": "Python Script",
        "python_script_plural": "Python Scripts",
        "python_scripts": "Python Scripts",
        "repositories": "Repositories",
        "repository": "Repository",
        "settings": "settings",
        "theme": "Theme",
        "theme_plural": "Themes",
        "themes": "Themes",
        "uninstall": "Uninstall",
        "update": "Update",
        "version": "Version"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Only a single configuration of HACS is allowed."
        },
        "error": {
          "auth": "Personal Access Token is not correct."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Enable AppDaemon apps discovery & tracking",
              "netdaemon": "Enable NetDaemon apps discovery & tracking",
              "python_script": "Enable python_scripts discovery & tracking",
              "sidepanel_icon": "Side panel icon",
              "sidepanel_title": "Side panel title",
              "theme": "Enable Themes discovery & tracking",
              "token": "GitHub Personal Access Token"
            },
            "description": "If you need help with the configuration have a look here: https://hacs.xyz/docs/configuration/start/",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Are you sure you want to add this to your Lovelace resources?",
        "bg_task": "Action is disabled while background tasks is running.",
        "cancel": "Cancel",
        "continue": "Are you sure you want to continue?",
        "delete": "Are you sure you want to delete \"{item}\"?",
        "delete_installed": "'{item}' is installed, you need to uninstall it before you can delete it.",
        "exist": "{item} already exists",
        "generic": "Are you sure?",
        "home_assistant_is_restarting": "Hold on, Home Assistant is now restarting.",
        "home_assistant_version_not_correct": "You are running Home Assistant version '{haversion}', but this repository requires minimum version '{minversion}' to be installed.",
        "no": "No",
        "no_upgrades": "No upgrades pending",
        "ok": "OK",
        "overwrite": "Doing this will overwrite it.",
        "reload_data": "This reloads the data of all repositories HACS knows about, this will take some time to finish.",
        "restart_home_assistant": "Are you sure you want to restart Home Assistant?",
        "uninstall": "Are you sure you want to uninstall \"{item}\"?",
        "upgrade_all": "This will upgrade all of these repositories, make sure that you have read the release notes for all of them before proceeding.",
        "yes": "Yes"
      },
      "dialog_about": {
        "frontend_version": "Frontend version",
        "installed_repositories": "Installed repositories",
        "integration_version": "Integration version",
        "useful_links": "Useful links"
      },
      "dialog_add_repo": {
        "limit": "Only the first 100 repositories are shown, use the search to filter what you need",
        "no_match": "No repositories found matching your filter",
        "sort_by": "Sort by",
        "title": "Add repository"
      },
      "dialog_custom_repositories": {
        "category": "Category",
        "no_category": "Missing category",
        "no_repository": "Missing repository",
        "title": "Custom repositories",
        "url_placeholder": "Add custom repository URL"
      },
      "dialog_info": {
        "author": "Author",
        "downloads": "Downloads",
        "install": "Install this repository in HACS",
        "loading": "Loading information...",
        "no_info": "The developer has not provided any more information for this repository",
        "open_issues": "Open issues",
        "open_repo": "Open repository",
        "stars": "Stars",
        "version_installed": "Version installed"
      },
      "dialog_install": {
        "restart": "Remember that you need to restart Home Assistant before changes to integrations (custom_components) are applied.",
        "select_version": "Select version",
        "show_beta": "Show beta versions",
        "type": "Type",
        "url": "URL"
      },
      "dialog_removed": {
        "link": "External link to more information",
        "name": "Repository name",
        "reason": "Removal reason",
        "type": "Removal type"
      },
      "dialog_update": {
        "available_version": "Available version",
        "changelog": "Changelog",
        "installed_version": "Installed version",
        "releasenotes": "Releasenotes for {release}",
        "title": "Update pending"
      },
      "entry": {
        "information": "Information",
        "intro": "Updates and important messages will show here if there are any",
        "messages": {
          "disabled": {
            "content": "Check your log file for more details",
            "title": "HACS is disabled"
          },
          "has_pending_tasks": {
            "content": "Some repositories might not show untill this is completed",
            "title": "Background tasks pending"
          },
          "removed": "Removed repository '{repository}'",
          "resources": {
            "content": "You have {number} Lovelace elements that are not loaded properly in Lovelace.",
            "title": "Not loaded in Lovelace"
          },
          "restart": {
            "content": "You have {number} integrations that requires a restart of Home Assistant, you can do that from the 'Server Controls' section under the configuration part of Home Assistant UI.",
            "title": "Pending restart"
          },
          "startup": {
            "content": "HACS is starting up, during this time some information might be missing or incorrect",
            "title": "HACS is starting up"
          },
          "wrong_frontend_installed": {
            "content": "You have {running} of the HACS frontend installed, but version {expected} was expected, if this you see this message Home Assistant was not able to install the new version, try restarting Home Assistant.",
            "title": "Unexpected frontend version"
          },
          "wrong_frontend_loaded": {
            "content": "You are running version {running} of the HACS frontend, but version {expected} was expected, you should clear your browser cache.",
            "title": "Unexpected frontend version"
          }
        },
        "pending_updates": "Pending updates"
      },
      "menu": {
        "about": "About HACS",
        "clear": "Clear all new",
        "custom_repositories": "Custom repositories",
        "dismiss": "Dismiss all new repositories",
        "documentation": "Documentation",
        "open_issue": "Open issue",
        "reload": "Reload window"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Enable AppDaemon apps discovery & tracking",
              "country": "Filter with country code.",
              "debug": "Enable debug.",
              "experimental": "Enable experimental features",
              "netdaemon": "Enable NetDaemon apps discovery & tracking",
              "not_in_use": "Not in use with YAML",
              "release_limit": "Number of releases to show.",
              "sidepanel_icon": "Side panel icon",
              "sidepanel_title": "Side panel title"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "This integration supports config_flow, that means that you now can go to the integration section of your UI to configure it.",
        "config_flow_title": "UI Configuration supported",
        "integration_not_loaded": "This integration is not loaded in Home Assistant.",
        "no_restart_required": "No restart required",
        "not_loaded": "Not loaded",
        "plugin_not_loaded": "This plugin is not added to your Lovelace resources.",
        "restart": "You need to restart Home Assistant.",
        "restart_pending": "Restart pending"
      },
      "repository_card": {
        "dismiss": "dismiss",
        "hide": "Hide",
        "information": "Information",
        "new_repository": "New repository",
        "not_loaded": "Not loaded",
        "open_issue": "Open issue",
        "open_source": "Open source",
        "pending_restart": "Pending restart",
        "pending_update": "Pending update",
        "reinstall": "Reinstall",
        "report": "Report for removal",
        "update_information": "Update information"
      },
      "repository": {
        "add_to_lovelace": "Add to Lovelace",
        "authors": "Authors",
        "available": "Available",
        "back_to": "Back to",
        "changelog": "Change log",
        "downloads": "Downloads",
        "flag_this": "Flag this",
        "frontend_version": "Frontend version",
        "github_stars": "GitHub stars",
        "goto_integrations": "Go to integrations",
        "hide": "Hide",
        "hide_beta": "Hide beta",
        "install": "Install",
        "installed": "Installed",
        "lovelace_copy_example": "Copy the example to your clipboard",
        "lovelace_instruction": "When you add this to your lovelace configuration use this",
        "lovelace_no_js_type": "Could not determine the type of this plugin, check the repository.",
        "newest": "newest",
        "note_appdaemon": "you still need to add it to your 'apps.yaml' file",
        "note_installed": "When installed, this will be located in",
        "note_integration": "you still need to add it to your 'configuration.yaml' file",
        "note_plugin": "you still need to add it to your lovelace configuration ('ui-lovelace.yaml' or the raw UI config editor)",
        "note_plugin_post_107": "you still need to add it to your lovelace configuration ('configuration.yaml' or the resource editor '/config/lovelace/resources')",
        "open_issue": "Open issue",
        "open_plugin": "Open element",
        "reinstall": "Reinstall",
        "repository": "Repository",
        "restart_home_assistant": "Restart Home Assistant",
        "show_beta": "Show beta",
        "uninstall": "Uninstall",
        "update_information": "Update information",
        "upgrade": "Update"
      },
      "search": {
        "installed": "Search for installed repositories",
        "installed_new": "Search for installed or new repositories",
        "placeholder": "Search for repository"
      },
      "sections": {
        "about": {
          "description": "Show information about HACS",
          "title": "About"
        },
        "automation": {
          "description": "This is where you find python_scripts, AppDaemon apps and NetDaemon apps",
          "title": "Automation"
        },
        "frontend": {
          "description": "This is where you find themes, custom cards and other elements for lovelace",
          "title": "Frontend"
        },
        "integrations": {
          "description": "This is where you find custom integrations (custom_components)",
          "title": "Integrations"
        },
        "pending_repository_upgrade": "You are running version {installed}, version {available} is available"
      },
      "settings": {
        "add_custom_repository": "ADD CUSTOM REPOSITORY",
        "adding_new_repo": "Adding new repository '{repo}'",
        "adding_new_repo_category": "With category '{category}'.",
        "bg_task_custom": "Custom repositories are hidden while background tasks is running.",
        "category": "Category",
        "compact_mode": "Compact mode",
        "custom_repositories": "CUSTOM REPOSITORIES",
        "delete": "Delete",
        "display": "Display",
        "grid": "Grid",
        "hacs_repo": "HACS repo",
        "hidden_repositories": "hidden repositories",
        "missing_category": "You need to select a category",
        "open_repository": "Open repository",
        "reload_data": "Reload data",
        "reload_window": "Reload window",
        "repository_configuration": "Repository configuration",
        "save": "Save",
        "table": "Table",
        "table_view": "Table view",
        "unhide": "unhide",
        "upgrade_all": "Upgrade all"
      },
      "store": {
        "ascending": "ascending",
        "clear_new": "Clear all new repositories",
        "descending": "descending",
        "last_updated": "Last updated",
        "name": "Name",
        "new_repositories": "New Repositories",
        "new_repositories_note": "You have over 10 new repositories showing here, if you want to clear them all click the 3 dots in the top right corner and dismiss all of them.",
        "no_repositories": "No repositories",
        "no_repositories_desc1": "It seems like you don't have any repositories installed in this section yet.",
        "no_repositories_desc2": "Click on the + in the bottom corner to add your first!",
        "no_repositories_found_desc1": "No installed repositories matching \"{searchInput}\" found in this section.",
        "no_repositories_found_desc2": "Try searching for something else!",
        "pending_upgrades": "Pending upgrades",
        "placeholder_search": "Please enter a search term...",
        "sort": "sort",
        "stars": "Stars",
        "status": "Status"
      },
      "time": {
        "ago": "ago",
        "day": "day",
        "days": "days",
        "hour": "hour",
        "hours": "hours",
        "minute": "minute",
        "minutes": "minutes",
        "month": "month",
        "months": "months",
        "one": "One",
        "one_day_ago": "one day ago",
        "one_hour_ago": "one hour ago",
        "one_minute_ago": "one minute ago",
        "one_month_ago": "one month ago",
        "one_second_ago": "one second ago",
        "one_year_ago": "one year ago",
        "second": "second",
        "seconds": "seconds",
        "x_days_ago": "{x} days ago",
        "x_hours_ago": "{x} hours ago",
        "x_minutes_ago": "{x} minutes ago",
        "x_months_ago": "{x} months ago",
        "x_seconds_ago": "{x} seconds ago",
        "x_years_ago": "{x} years ago",
        "year": "year",
        "years": "years"
      }
    },
    "es": {
      "common": {
        "about": "Acerca de",
        "add": "añadir",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "AppDaemon Apps",
        "appdaemon_plural": "AppDaemon Apps",
        "background_task": "Ejecutando tareas en segundo plano. Se refrescará automaticamente esta página al finalizar.",
        "check_log_file": "Compruebe el archivo de registro para obtener más detalles.",
        "continue": "Continuar",
        "disabled": "Deshabilitado",
        "documentation": "Documentación",
        "element": "elemento",
        "hacs_is_disabled": "HACS está deshabilitado",
        "ignore": "Ignorar",
        "install": "Instalar",
        "installed": "instalado",
        "integration": "Integración",
        "integration_plural": "Integraciones",
        "integrations": "Integraciones",
        "lovelace": "Lovelace",
        "lovelace_element": "Elemento de Lovelace",
        "lovelace_elements": "Elementos de Lovelace",
        "manage": "Administrar",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDaemon Apps",
        "netdaemon_plural": "Aplicaciones NetDaemon",
        "plugin": "Lovelace",
        "plugin_plural": "Elementos de Lovelace",
        "plugins": "Elementos de Lovelace",
        "python_script": "Python Script",
        "python_script_plural": "Python Scripts",
        "python_scripts": "Python Scripts",
        "repositories": "Repositorios",
        "repository": "Repositorio",
        "settings": "configuraciones",
        "theme": "Tema",
        "theme_plural": "Temas",
        "themes": "Temas",
        "uninstall": "Desinstalar",
        "update": "Actualizar",
        "version": "Versión"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Sólo se permite una única configuración de HACS."
        },
        "error": {
          "auth": "El token de acceso personal no es correcto."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Habilitar el descubrimiento y seguimiento de las aplicaciones de AppDaemon",
              "netdaemon": "Habilitar el descubrimiento y seguimiento de las aplicaciones de NetDaemon",
              "python_script": "Habilitar el descubrimiento y seguimiento en python_scripts",
              "sidepanel_icon": "Ícono del panel lateral",
              "sidepanel_title": "Título del panel lateral",
              "theme": "Habilitar el descubrimiento y seguimiento de temas",
              "token": "Token de acceso personal de GitHub"
            },
            "description": "Si necesitas ayuda con la configuración, visita la siguiente pagina: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "¿Está seguro de que desea agregar esto a sus recursos de Lovelace?",
        "bg_task": "La acción está deshabilitada mientras se ejecutan tareas en segundo plano.",
        "cancel": "Cancelar",
        "continue": "Estás seguro de que quieres continuar?",
        "delete": "¿Seguro que quieres eliminar '{item}'?",
        "delete_installed": "'{item}' está instalado, debe desinstalarlo antes de poder eliminarlo.",
        "exist": "{item} ya existe",
        "generic": "¿Estás seguro?",
        "home_assistant_is_restarting": "Espera, Home Assistant se está reiniciando.",
        "home_assistant_version_not_correct": "Está ejecutando la versión '{haversion}' de Home Assistant, pero este repositorio requiere la instalación de la versión '{minversion}' mínima.",
        "no": "No",
        "no_upgrades": "No hay actualizaciones pendientes",
        "ok": "OK",
        "overwrite": "Si haces esto, se sobrescribirá.",
        "reload_data": "Esto recarga los datos de todos los repositorios que HACS conoce, esto tardará algún tiempo en finalizar.",
        "restart_home_assistant": "¿Está seguro de que desea reiniciar Home Assistant?",
        "uninstall": "¿Está seguro de que deseas desinstalar '{item}'?",
        "upgrade_all": "Esto actualizará todos estos repositorios, asegúrese de que ha leído las notas de la versión de todos ellos antes de continuar.",
        "yes": "Si"
      },
      "dialog_about": {
        "frontend_version": "Versión del front-end",
        "installed_repositories": "Repositorios instalados",
        "integration_version": "Versión de la integración",
        "useful_links": "Enlaces útiles"
      },
      "dialog_add_repo": {
        "limit": "Sólo se muestran los primeros 100 repositorios, utilice la búsqueda para filtrar lo que necesita",
        "no_match": "No se han encontrado repositorios que coincidan con el filtro",
        "sort_by": "Ordenar por",
        "title": "Añadir repositorio"
      },
      "dialog_custom_repositories": {
        "category": "Categoría",
        "no_category": "Categoría que falta",
        "no_repository": "Falta el repositorio",
        "title": "Repositorios personalizados",
        "url_placeholder": "Agrega la URL del repositorio personalizado que deseas añadir"
      },
      "dialog_info": {
        "author": "Autor",
        "downloads": "Descargas",
        "install": "Instalar este repositorio en HACS",
        "loading": "Cargando información ...",
        "no_info": "El desarrollador no ha proporcionado más información para este repositorio",
        "open_issues": "Abrir incidencias",
        "open_repo": "Abrir repositorio",
        "stars": "Estrellas",
        "version_installed": "Versión instalada"
      },
      "dialog_install": {
        "restart": "Recuerde que debe reiniciar Home Assistant para que se apliquen los cambios en las integraciones (custom_components).",
        "select_version": "Seleccione la versión",
        "show_beta": "Mostrar versiones beta",
        "type": "Tipo",
        "url": "URL"
      },
      "dialog_removed": {
        "link": "Enlace externo para más información",
        "name": "Nombre del repositorio",
        "reason": "Motivo de la eliminación",
        "type": "Tipo de eliminación"
      },
      "dialog_update": {
        "available_version": "Versión disponible",
        "changelog": "Registro de cambios",
        "installed_version": "Versión instalada",
        "releasenotes": "Notas de la versión para {release}",
        "title": "Actualización pendiente"
      },
      "entry": {
        "information": "Información",
        "intro": "Las actualizaciones y los mensajes importantes se mostrarán aquí si hay alguno que mostrar",
        "messages": {
          "disabled": {
            "content": "Compruebe el archivo de registro para obtener más detalles",
            "title": "HACS está deshabilitado"
          },
          "has_pending_tasks": {
            "content": "Es posible que algunos repositorios no se muestren hasta que esto se complete",
            "title": "Tareas en segundo plano pendientes"
          },
          "removed": "Repositorio '{repository}' eliminado",
          "resources": {
            "content": "Tienes {number} elementos de Lovelace que no están cargados correctamente en Lovelace.",
            "title": "No está cargado en Lovelace"
          },
          "restart": {
            "content": "Tienes {number} integraciones que requieren un reinicio de Home Assistant, puedes hacerlo desde la sección 'Controles del Servidor' en la parte de configuración de la UI de Home Assistant.",
            "title": "Reinicio pendiente"
          },
          "startup": {
            "content": "HACS se está iniciando, durante este tiempo alguna información podría faltar o ser incorrecta",
            "title": "HACS se está iniciando"
          },
          "wrong_frontend_installed": {
            "content": "Tienes instalada la versión {running} de la interfaz de HACS, pero se esperaba la versión {expected}, si ves este mensaje, Home Assistant no pudo instalar la nueva versión, intenta reiniciar Home Assistant.",
            "title": "Versión inesperada de la interfaz"
          },
          "wrong_frontend_loaded": {
            "content": "Estás ejecutando la versión {running} de la interfaz HACS, pero se esperaba la versión {expected} , deberías de limpiar la memoria caché del navegador.",
            "title": "Versión inesperada de la interfaz"
          }
        },
        "pending_updates": "Actualizaciones pendientes"
      },
      "menu": {
        "about": "Acerca de HACS",
        "clear": "Borrar todo lo nuevo",
        "custom_repositories": "Repositorios personalizados",
        "dismiss": "Descartar todos los repositorios nuevos",
        "documentation": "Documentación",
        "open_issue": "Abrir issue",
        "reload": "Recargar la ventana"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Habilitar el descubrimiento y seguimiento de las aplicaciones de AppDaemon",
              "country": "Filtrar por el código de país.",
              "debug": "Habilitar depuración.",
              "experimental": "Habilitar funciones experimentales",
              "netdaemon": "Habilitar el descubrimiento y seguimiento de las aplicaciones de NetDaemon",
              "not_in_use": "No usarse con YAML",
              "release_limit": "Número de versiones a mostrar.",
              "sidepanel_icon": "Icono del panel lateral",
              "sidepanel_title": "Título del panel lateral"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Esta integración soporta config_flow, lo que significa que ahora puede ir a la sección de integración de su UI para configurarlo.",
        "config_flow_title": "Configuración de UI soportada",
        "integration_not_loaded": "Esta integración no se carga en Home Assistant.",
        "no_restart_required": "No es necesario reiniciar",
        "not_loaded": "No está cargado",
        "plugin_not_loaded": "Este plugin aun no se ha añadido a sus recursos de Lovelace.",
        "restart": "Es necesario reiniciar Home Assistant.",
        "restart_pending": "Reinicio pendiente"
      },
      "repository_card": {
        "dismiss": "descartar",
        "hide": "Ocultar",
        "information": "Información",
        "new_repository": "Nuevo repositorio",
        "not_loaded": "Sin cargar",
        "open_issue": "Abrir issue",
        "open_source": "Código abierto",
        "pending_restart": "Pendiente de reinicio",
        "pending_update": "Actualización pendiente",
        "reinstall": "Reinstalar",
        "report": "Informe para la eliminación",
        "update_information": "Actualizar información"
      },
      "repository": {
        "add_to_lovelace": "Añadir a Lovelace",
        "authors": "Autores",
        "available": "Disponible",
        "back_to": "Volver a",
        "changelog": "Registro de cambios",
        "downloads": "Descargas",
        "flag_this": "Marcar esto",
        "frontend_version": "Versión del frontend",
        "github_stars": "Estrellas de GitHub",
        "goto_integrations": "Ir a integraciones",
        "hide": "Ocultar",
        "hide_beta": "Ocultar beta",
        "install": "Instalar",
        "installed": "Instalado",
        "lovelace_copy_example": "Copiar el ejemplo al clipboard",
        "lovelace_instruction": "Agregue lo siguiente en su configuración de lovelace",
        "lovelace_no_js_type": "No se pudo determinar el tipo de elemento, revise el repositorio.",
        "newest": "más nuevo",
        "note_appdaemon": "deberá agregar esto a su archivo 'apps.yaml'",
        "note_installed": "Cuando esté instalado, se ubicará en",
        "note_integration": "deberá agregar esto a su archivo 'configuration.yaml'",
        "note_plugin": "deberá agregar esto a su configuración de lovelace ('ui-lovelace.yaml' o en el editor UI de lovelace)",
        "note_plugin_post_107": "todavía necesita agregarlo a su configuración de lovelace ('configuration.yaml' o al editor de recursos '/config/lovelace/resources')",
        "open_issue": "Abrir issue",
        "open_plugin": "Abrir elemento",
        "reinstall": "Reinstalar",
        "repository": "Repositorio",
        "restart_home_assistant": "Reiniciar Home Assistant",
        "show_beta": "Mostrar beta",
        "uninstall": "Desinstalar",
        "update_information": "Actualizar información",
        "upgrade": "Actualizar"
      },
      "search": {
        "installed": "Buscar repositorios instalados",
        "installed_new": "Buscar repositorios instalados o nuevos",
        "placeholder": "Buscar repositorio"
      },
      "sections": {
        "about": {
          "description": "Mostrar información sobre HACS",
          "title": "Acerca de"
        },
        "automation": {
          "description": "Aquí es donde se encuentran python_scripts, aplicaciones AppDaemon y aplicaciones NetDaemon",
          "title": "Automatización"
        },
        "frontend": {
          "description": "Aquí es donde encontrarás temas, tarjetas personalizadas y otros elementos para lovelace",
          "title": "Interfaz"
        },
        "integrations": {
          "description": "Aquí es donde se encuentran las integraciones personalizadas (custom_components)",
          "title": "Integraciones"
        },
        "pending_repository_upgrade": "Está ejecutando la versión {installed}, la versión {available} está disponible"
      },
      "settings": {
        "add_custom_repository": "AGREGAR REPOSITORIO PERSONALIZADO",
        "adding_new_repo": "Añadiendo un nuevo repositorio '{repo}'.",
        "adding_new_repo_category": "Con la categoría '{category}'.",
        "bg_task_custom": "Los repositorios personalizados están ocultos mientras se ejecutan las tareas en segundo plano.",
        "category": "Categoría",
        "compact_mode": "Modo compacto",
        "custom_repositories": "REPOSITORIOS PERSONALIZADOS",
        "delete": "Eliminar",
        "display": "Mostrar",
        "grid": "Cuadrícula",
        "hacs_repo": "HACS repo",
        "hidden_repositories": "repositorios ocultos",
        "missing_category": "Es necesario seleccionar una categoría",
        "open_repository": "Abrir repositorio",
        "reload_data": "Recargar datos",
        "reload_window": "Recargar ventana",
        "repository_configuration": "Configuración del repositorio",
        "save": "Guardar",
        "table": "Tabla",
        "table_view": "Vista de la tabla",
        "unhide": "mostrar",
        "upgrade_all": "Actualizar todo"
      },
      "store": {
        "ascending": "ascendente",
        "clear_new": "Eliminar la lista los nuevos repositorios",
        "descending": "descendente",
        "last_updated": "Última actualización",
        "name": "Nombre",
        "new_repositories": "Nuevos Repositorios",
        "new_repositories_note": "Tienes más de 10 nuevos repositorios mostrados aquí, si quieres borrarlos todos haz clic en los 3 puntos de la esquina superior derecha y deséchalos todos.",
        "no_repositories": "Sin repositorios",
        "no_repositories_desc1": "Parece que todavía no tiene ningún repositorio instalado en esta sección.",
        "no_repositories_desc2": "Haga clic en el + de la esquina inferior derecha para agregar su primer repositorio!",
        "no_repositories_found_desc1": "No se ha encontrado ningún repositorio instalado que coincida con el valor de \"{searchInput}\" en esta sección.",
        "no_repositories_found_desc2": "¡Intenta buscar otra cosa!",
        "pending_upgrades": "Actualizaciones pendientes",
        "placeholder_search": "Por favor escriba una palabra clave de búsqueda...",
        "sort": "ordenar",
        "stars": "Estrellas",
        "status": "Estado"
      },
      "time": {
        "ago": "hace",
        "day": "dia",
        "days": "dias",
        "hour": "hora",
        "hours": "horas",
        "minute": "minuto",
        "minutes": "minutos",
        "month": "mes",
        "months": "meses",
        "one": "Uno",
        "one_day_ago": "hace un día",
        "one_hour_ago": "hace una hora",
        "one_minute_ago": "hace un minuto",
        "one_month_ago": "hace un mes",
        "one_second_ago": "hace un segundo",
        "one_year_ago": "hace un año",
        "second": "segundo",
        "seconds": "segundos",
        "x_days_ago": "hace {x} dias",
        "x_hours_ago": "hace {x} horas",
        "x_minutes_ago": "hace {x} minutos",
        "x_months_ago": "hace {x} meses",
        "x_seconds_ago": "hace {x} segundos",
        "x_years_ago": "hace {x} años",
        "year": "año",
        "years": "años"
      }
    },
    "fi": {
      "common": {
        "add": "Lisää",
        "appdaemon_plural": "AppDaemon-sovellukset",
        "element": "elementti",
        "hacs_is_disabled": "HACS on poistettu käytöstä",
        "install": "Asenna",
        "integration_plural": "Integraatiot",
        "lovelace": "Lovelace",
        "lovelace_element": "Lovelace-elementti",
        "lovelace_elements": "Lovelace-elementit",
        "manage": "hallinnoi",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDaemon-sovellukset",
        "netdaemon_plural": "NetDaemon-sovellukset",
        "plugin_plural": "Lovelace-elementit",
        "python_script_plural": "Python-skriptit",
        "theme_plural": "Teemat",
        "uninstall": "Poista",
        "update": "Päivitä"
      },
      "config": {
        "step": {
          "user": {
            "data": {
              "netdaemon": "Ota NetDaemon-sovellusten etsintä ja seuranta käyttöön"
            }
          }
        }
      },
      "dialog_about": {
        "useful_links": "Hyödyllisiä linkkejä"
      },
      "dialog_add_repo": {
        "sort_by": "Järjestä",
        "title": "Lisää repo"
      },
      "dialog_custom_repositories": {
        "category": "Kategoria"
      },
      "dialog_info": {
        "downloads": "Lataukset",
        "open_issues": "Avoimet ongelmat",
        "stars": "Tähdet",
        "version_installed": "Asennettu versio"
      },
      "dialog_install": {
        "select_version": "Valitse versio",
        "show_beta": "Näytä beetaversiot",
        "type": "Tyyppi",
        "url": "URL"
      },
      "dialog_update": {
        "available_version": "Saatavilla oleva versio",
        "changelog": "Muutosloki",
        "installed_version": "Asennettu versio"
      },
      "entry": {
        "messages": {
          "disabled": {
            "content": "Tarkista lokitiedostosi saadaksesi lisätietoja",
            "title": "HACS on poistettu käytöstä"
          },
          "startup": {
            "title": "HACS käynnistyy"
          }
        },
        "pending_updates": "Päivityksiä saatavilla"
      },
      "menu": {
        "about": "Tietoja HACS:stä",
        "clear": "Tyhjennä kaikki uudet",
        "custom_repositories": "Mukautetut repot",
        "dismiss": "Hylkää kaikki uudet repot",
        "documentation": "Dokumentointi",
        "open_issue": "Avoin ongelma",
        "reload": "Lataa ikkuna uudelleen"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "netdaemon": "Ota NetDaemon-sovellusten etsintä ja seuranta käyttöön",
              "not_in_use": "Ei käytössä YAML:n kanssa",
              "sidepanel_icon": "Sivupaneelin kuvake"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow_title": "Käyttöliittymän määrityksiä tuetaan"
      },
      "repository_card": {
        "dismiss": "Hylkää",
        "hide": "Piilota",
        "information": "Tiedot",
        "open_issue": "Avoin ongelma",
        "open_source": "Avoin lähdekoodi",
        "reinstall": "Asenna uudelleen",
        "update_information": "Päivitä tiedot"
      },
      "repository": {
        "github_stars": "GitHub-tähdet"
      },
      "search": {
        "placeholder": "Etsi repoa"
      },
      "sections": {
        "about": {
          "title": "Tietoja"
        },
        "automation": {
          "title": "Automaatio"
        },
        "frontend": {
          "title": "Frontend"
        },
        "integrations": {
          "description": "Täältä löydät mukautetut integraatiot (custom_components)",
          "title": "integraatiot"
        }
      },
      "time": {
        "one_day_ago": "yksi päivä sitten",
        "one_hour_ago": "tunti sitten",
        "one_minute_ago": "minuutti sitten",
        "one_month_ago": "kuukausi sitten",
        "one_second_ago": "sekunti sitten",
        "one_year_ago": "vuosi sitten",
        "x_days_ago": "{x} päivää sitten",
        "x_hours_ago": "{x} tuntia sitten",
        "x_minutes_ago": "{x} minuuttia sitten",
        "x_months_ago": "{x} kuukautta sitten",
        "x_seconds_ago": "{x} sekuntia sitten",
        "x_years_ago": "{x} vuotta sitten"
      }
    },
    "fr": {
      "common": {
        "about": "À propos de",
        "add": "ajouter",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "Applications AppDaemon",
        "appdaemon_plural": "AppDaemon Apps",
        "background_task": "Tache de fond en cours, cette page se rechargera une fois terminée",
        "check_log_file": "Consultez votre fichier journal pour plus de détails.",
        "continue": "Continuer",
        "disabled": "Désactivé",
        "documentation": "Documentation",
        "element": "élément",
        "hacs_is_disabled": "HACS est désactivé",
        "install": "Installer",
        "installed": "installés",
        "integration": "Intégration",
        "integration_plural": "Intégrations",
        "integrations": "Intégrations",
        "lovelace": "Lovelace",
        "lovelace_element": "Élément Lovelace",
        "lovelace_elements": "Éléments Lovelace",
        "manage": "gérer",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "Applications NetDaemon",
        "netdaemon_plural": "NetDaemon Apps",
        "plugin": "Lovelace",
        "plugin_plural": "Éléments Lovelace",
        "plugins": "Éléments Lovelace",
        "python_script": "Script Python",
        "python_script_plural": "Scripts Python",
        "python_scripts": "Scripts Python",
        "repositories": "Dépôts",
        "repository": "Dépôt",
        "settings": "paramètres",
        "theme": "Thème",
        "theme_plural": "Thèmes",
        "themes": "Thèmes",
        "uninstall": "Désinstaller",
        "update": "Mise à jour",
        "version": "Version"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Une seule configuration de HACS est autorisée."
        },
        "error": {
          "auth": "Le jeton personnel d'accès est invalide."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Activer la découverte et le suivi des applications AppDaemon",
              "netdaemon": "Activer la découverte et le suivi des applications NetDaemon",
              "python_script": "Activer la découverte et le suivi des scripts python",
              "sidepanel_icon": "Icône de la barre latérale",
              "sidepanel_title": "Titre de la barre latérale",
              "theme": "Activer la découverte et le suivi des thèmes",
              "token": "Jeton d'accès personnel GitHub"
            },
            "description": "Si vous avez besoin d'aide pour la configuration, jetez un œil ici: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Êtes-vous sûr de vouloir l'ajouter à vos ressources Lovelace ?",
        "bg_task": "L'action est désactivée pendant l'exécution de tâches en arrière-plan.",
        "cancel": "Annuler",
        "continue": "Es-tu sur de vouloir continuer?",
        "delete": "Êtes-vous sûr de vouloir supprimer '{item}'?",
        "delete_installed": "'{item}' est installé, vous devez le désinstaller avant de pouvoir le supprimer.",
        "exist": "{item} existe déjà",
        "generic": "Êtes-vous sûr?",
        "home_assistant_is_restarting": "Attendez, Home Assistant redémarre maintenant.",
        "home_assistant_version_not_correct": "Vous utilisez la version '{haversion}' de Home Assistant, mais ce référentiel nécessite l'installation de la version minimale '{minversion}'.",
        "no": "Non",
        "no_upgrades": "Aucune mise à niveau en attente",
        "ok": "OK",
        "overwrite": "En faisant cela, cela l'écrasera.",
        "reload_data": "Cela recharge les données de tous les dépôts dont HACS a connaissance, cela prendra un certain temps à terminer.",
        "restart_home_assistant": "Voulez-vous vraiment redémarrer Home Assistant ?",
        "uninstall": "Êtes-vous sûr de vouloir désinstaller '{item}'?",
        "upgrade_all": "Cela mettra à niveau tous ces dépôts, assurez-vous d'avoir lu les notes de publication pour chacun d'entre eux avant de continuer.",
        "yes": "Oui"
      },
      "dialog_about": {
        "frontend_version": "Version frontend",
        "installed_repositories": "Dépôts installés",
        "integration_version": "Version d'intégration",
        "useful_links": "Liens utiles"
      },
      "dialog_add_repo": {
        "limit": "Seuls les 100 premiers dépôts sont affichés, utilisez la recherche pour filtrer ce dont vous avez besoin",
        "no_match": "Aucun dépôt trouvé correspondant à votre filtre",
        "sort_by": "Trier par",
        "title": "Ajouter un dépôt"
      },
      "dialog_custom_repositories": {
        "category": "Catégorie",
        "no_category": "Catégorie manquante",
        "no_repository": "Dépôt manquant",
        "title": "Dépôts personnalisés",
        "url_placeholder": "Ajouter une URL de dépôt personnalisée"
      },
      "dialog_info": {
        "author": "Auteur",
        "downloads": "Téléchargements",
        "install": "Installer ce dépôt dans HACS",
        "loading": "Chargement des informations ...",
        "no_info": "Le développeur n'a pas fourni plus d'informations pour ce dépôt",
        "open_issues": "Open issues",
        "open_repo": "Dépôt ouvert",
        "stars": "Étoiles",
        "version_installed": "Version installée"
      },
      "dialog_install": {
        "restart": "N'oubliez pas que vous devez redémarrer Home Assistant avant que les modifications aux intégrations (custom_components) soient appliquées.",
        "select_version": "Sélectionnez une version",
        "show_beta": "Afficher les versions bêta",
        "type": "Type",
        "url": "URL"
      },
      "dialog_update": {
        "available_version": "Version disponible",
        "changelog": "Changelog",
        "installed_version": "Version installée",
        "releasenotes": "Notes de version pour {release}",
        "title": "Mise à jour en attente"
      },
      "entry": {
        "information": "Information",
        "intro": "Les mises à jour et les messages importants s'afficheront ici s'il y en a",
        "messages": {
          "disabled": {
            "content": "Vérifiez votre fichier journal pour plus de détails",
            "title": "HACS est désactivé"
          },
          "has_pending_tasks": {
            "content": "Certains dépôts peuvent ne pas apparaître tant que cette opération n'est pas terminée",
            "title": "Tâches d’arrière-plan en attente"
          },
          "resources": {
            "content": "Vous avez {number} éléments Lovelace qui ne sont pas chargés correctement dans Lovelace.",
            "title": "Non chargé dans Lovelace"
          },
          "restart": {
            "content": "Vous disposez de {number} intégrations qui nécessitent un redémarrage de Home Assistant, vous pouvez le faire à partir de la section \"Commandes du serveur\" sous la partie configuration de l'interface utilisateur de Home Assistant.",
            "title": "En attente de redémarrage"
          },
          "startup": {
            "content": "HACS démarre, pendant ce temps, certaines informations peuvent être manquantes ou incorrectes",
            "title": "HACS est en train de démarrer"
          },
          "wrong_frontend_installed": {
            "content": "Vous avez {running} du frontend HACS installé, mais la version {expected} était attendue. Si ce message s'affiche, Home Assistant n'a pas pu installer la nouvelle version, essayez de redémarrer Home Assistant.",
            "title": "Version frontend inattendue"
          },
          "wrong_frontend_loaded": {
            "content": "Vous exécutez la version {running} de l'interface HACS, mais la version {expected} était attendue, vous devez vider le cache de votre navigateur.",
            "title": "Version frontend inattendue"
          }
        },
        "pending_updates": "Mises à jour en attente"
      },
      "menu": {
        "about": "À propos de HACS",
        "clear": "Effacer tous les nouveaux",
        "custom_repositories": "Dépôts personnalisés",
        "dismiss": "Rejeter tous les nouveaux dépôts",
        "documentation": "Documentation",
        "open_issue": "Open issue",
        "reload": "Recharger la fenêtre"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Activer la découverte et le suivi des applications AppDaemon",
              "country": "Filtrer par code pays.",
              "debug": "Activez le débogage.",
              "experimental": "Activer les fonctionnalités expérimentales",
              "netdaemon": "Activer la découverte et le suivi des applications NetDaemon",
              "not_in_use": "Non utilisé avec YAML",
              "release_limit": "Nombre de recensés à afficher.",
              "sidepanel_icon": "Icône de la barre latérale",
              "sidepanel_title": "Titre de la barre latérale"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Cette intégration prend en charge config_flow, ce qui signifie que vous pouvez maintenant accéder à la section d'intégration de votre interface utilisateur pour le configurer.",
        "config_flow_title": "Configuration de l'interface utilisateur prise en charge",
        "integration_not_loaded": "Cette intégration n'est pas chargée dans Home Assistant.",
        "no_restart_required": "Aucun redémarrage requis",
        "not_loaded": "Non chargé",
        "plugin_not_loaded": "Ce plugin n'est pas ajouté à vos ressources Lovelace.",
        "restart": "Vous devez redémarrer Home Assistant.",
        "restart_pending": "Redémarrage en attente"
      },
      "repository_card": {
        "dismiss": "rejeter",
        "hide": "Cacher",
        "information": "Information",
        "new_repository": "Nouveau dépôt",
        "not_loaded": "Non chargé",
        "open_issue": "Ouvrir issue",
        "open_source": "Open source",
        "pending_restart": "Redémarrage en attente",
        "pending_update": "Mise à jour en attente",
        "reinstall": "Réinstaller",
        "report": "Rapport de suppression",
        "update_information": "Mettre à jour les informations"
      },
      "repository": {
        "add_to_lovelace": "Ajouter à Lovelace",
        "authors": "Auteurs",
        "available": "Disponible",
        "back_to": "Retour",
        "changelog": "Change log",
        "downloads": "Téléchargements",
        "flag_this": "Marquer",
        "frontend_version": "Version de l'interface",
        "github_stars": "Étoiles GitHub",
        "goto_integrations": "Aller aux intégrations",
        "hide": "Masquer",
        "hide_beta": "Masquer les bêta",
        "install": "Installer",
        "installed": "Installé",
        "lovelace_copy_example": "Copier cet exemple dans le presse-papier",
        "lovelace_instruction": "Quand vous l'ajoutez à votre configuration lovelace, utilisez",
        "lovelace_no_js_type": "Impossible de déterminer le type de plugin, veuillez vérifier le dépôt",
        "newest": "nouveau",
        "note_appdaemon": "vous devez toujours l'ajouter à votre fichier 'apps.yaml'",
        "note_installed": "Une fois installé, il se trouvera dans",
        "note_integration": "Vous devez toujours l'ajouter à votre fichier 'configuration.yaml'",
        "note_plugin": "Vous devez toujours l'ajouter à votre configuration lovelace ('ui-lovelace.yaml' ou l'éditeur de configuration de l'interface)",
        "note_plugin_post_107": "Vous devez toujours l'ajouter à votre configuration lovelace ('configuration.yaml' ou l'éditeur de configuration de l'interface '/config/lovelace/resources')",
        "open_issue": "Ouvrir un ticket",
        "open_plugin": "Ouvrir l'élément",
        "reinstall": "Réinstaller",
        "repository": "Dépôt",
        "restart_home_assistant": "Redémarrer Home Assistant",
        "show_beta": "Afficher les bêta",
        "uninstall": "Désinstaller",
        "update_information": "Mettre à jour les informations",
        "upgrade": "Mettre à jour"
      },
      "search": {
        "placeholder": "Rechercher un dépôt"
      },
      "sections": {
        "about": {
          "description": "Afficher des informations sur le système HACS",
          "title": "À propos de"
        },
        "automation": {
          "description": "C'est ici que vous trouverez les scripts python, les applications AppDaemon et NetDaemon",
          "title": "Automatisation"
        },
        "frontend": {
          "description": "C'est ici que vous trouverez des thèmes, des cartes personnalisées et d'autres éléments pour lovelace",
          "title": "Frontend"
        },
        "integrations": {
          "description": "C'est ici que vous trouverez les intégrations personnalisées (custom_components)",
          "title": "Intégrations"
        },
        "pending_repository_upgrade": "Vous utilisez la version {installed} , la version {available} est disponible"
      },
      "settings": {
        "add_custom_repository": "AJOUTER UN DÉPÔT PERSONNALISÉ",
        "adding_new_repo": "Ajout d'un nouveau dépôt '{repo}'",
        "adding_new_repo_category": "Avec la catégorie '{category}'.",
        "bg_task_custom": "Les dépôts personnalisés sont masqués pendant l'exécution de tâches en arrière-plan.",
        "category": "Catégorie",
        "compact_mode": "Mode compact",
        "custom_repositories": "DÉPÔTS PERSONNALISÉS",
        "delete": "Supprimer",
        "display": "Affichage",
        "grid": "Grille",
        "hacs_repo": "Dépôt HACS",
        "hidden_repositories": "dépôts cachés",
        "missing_category": "Vous devez sélectionner une catégorie",
        "open_repository": "Ouvrir dépôt",
        "reload_data": "Recharger les données",
        "reload_window": "Recharger la fenêtre",
        "repository_configuration": "Configuration de dépôt",
        "save": "Enregistrer",
        "table": "Tableau",
        "table_view": "Vue table",
        "unhide": "Afficher",
        "upgrade_all": "Tout mettre à jour"
      },
      "store": {
        "ascending": "ascendant",
        "clear_new": "Effacer tous les nouveaux dépôts",
        "descending": "descendant",
        "last_updated": "Dernière mise à jour",
        "name": "Nom",
        "new_repositories": "Nouveaux dépôts",
        "new_repositories_note": "Vous avez plus de 10 nouveaux dépôts qui apparaissent ici. Si vous voulez les effacer tous, cliquez sur les 3 points en haut à droite de l'écran et ignorez-les tous.",
        "no_repositories": "Aucun dépôt",
        "no_repositories_desc1": "Il semble que vous n’avez pas de dépôts installés dans cette section encore.",
        "no_repositories_desc2": "Cliquez sur le + dans le coin inférieur pour ajouter votre premier !",
        "no_repositories_found_desc1": "Aucun référentiel installé correspondant à \" {searchInput} \" n'a été trouvé dans cette section.",
        "no_repositories_found_desc2": "Essayez de chercher autre chose !",
        "pending_upgrades": "Mises à niveau en attente",
        "placeholder_search": "Veuillez entrer un terme de recherche...",
        "sort": "Trier",
        "stars": "Étoiles",
        "status": "Statut"
      },
      "time": {
        "ago": "il y a",
        "day": "jour",
        "days": "jours",
        "hour": "heure",
        "hours": "heures",
        "minute": "minute",
        "minutes": "minutes",
        "month": "mois",
        "months": "mois",
        "one": "Un",
        "one_day_ago": "il y a 1 jour",
        "one_hour_ago": "il y a 1 heure",
        "one_minute_ago": "il y a 1 minute",
        "one_month_ago": "il y a 1 mois",
        "one_second_ago": "il y a 1 seconde",
        "one_year_ago": "il y a 1 an",
        "second": "seconde",
        "seconds": "secondes",
        "x_days_ago": "il y a {x} jours",
        "x_hours_ago": "il y a {x} heures",
        "x_minutes_ago": "il y a {x} minutes",
        "x_months_ago": "il y a {x} mois",
        "x_seconds_ago": "il y a {x} secondes",
        "x_years_ago": "il y a {x} ans",
        "year": "an",
        "years": "ans"
      }
    },
    "hu": {
      "common": {
        "about": "Névjegy",
        "add": "hozzáadás",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "AppDaemon Appok",
        "appdaemon_plural": "AppDaemon appok",
        "background_task": "Éppen háttérfeladat fut, ez az oldal frissülni fog, ha kész.",
        "check_log_file": "További részletekért ellenőrizd a naplófájlt.",
        "continue": "Folytatás",
        "disabled": "Tiltva",
        "documentation": "Dokumentáció",
        "element": "bővítmény",
        "hacs_is_disabled": "A HACS le van tiltva",
        "install": "Telepítés",
        "installed": "Telepített",
        "integration": "Integráció",
        "integration_plural": "Integrációk",
        "integrations": "Integrációk",
        "lovelace": "Lovelace",
        "lovelace_element": "Lovelace bővítmény",
        "lovelace_elements": "Lovelace bővítmények",
        "manage": "kezelés",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDaemon Appok",
        "netdaemon_plural": "NetDaemon appok",
        "plugin": "Lovelace",
        "plugin_plural": "Lovelace bővítmények",
        "plugins": "Lovelace bővítmények",
        "python_script": "Python Szkript",
        "python_script_plural": "Python szkriptek",
        "python_scripts": "Python Szkriptek",
        "repositories": "Tárolók",
        "repository": "Tároló",
        "settings": "beállítások",
        "theme": "Téma",
        "theme_plural": "Témák",
        "themes": "Témák",
        "uninstall": "Eltávolítás",
        "update": "Frissítés",
        "version": "Verzió"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Csak egyetlen HACS-konfiguráció megengedett."
        },
        "error": {
          "auth": "A Személyes Hozzáférési Token nem megfelelő."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "AppDaemon appok felfedezésének és nyomon követésének engedélyezése",
              "netdaemon": "NetDaemon appok felfedezésének és nyomon követésének engedélyezése",
              "python_script": "Python szkriptek felfedezésének és nyomon követésének engedélyezése",
              "sidepanel_icon": "Oldalsó panel ikon",
              "sidepanel_title": "Oldalsó panel cím",
              "theme": "Témák felfedezésének és nyomon követésének engedélyezése",
              "token": "GitHub Személyes Hozzáférési Token"
            },
            "description": "Ha segítségre van szükséged a konfigurációval kapcsolatban, akkor tekintsd meg ezt az oldalt: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Biztosan hozzá szeretnéd ezt adni a Lovelace erőforrásokhoz?",
        "bg_task": "A művelet le van tiltva, amíg háttérfeladat fut.",
        "cancel": "Mégse",
        "continue": "Biztosan folytatni szeretnéd?",
        "delete": "Biztosan törölni szeretnéd a(z) '{item}'-t?",
        "delete_installed": "A(z) '{item}' telepítve van, törlés előtt el kell távolítanod.",
        "exist": "{item} már létezik",
        "generic": "Biztos vagy benne?",
        "home_assistant_is_restarting": "Várj, a Home Assistant éppen újraindul.",
        "home_assistant_version_not_correct": "A Home Assistant '{haversion}' verzióját használod, de ehhez a tárolóhoz legalább a(z) '{minversion}' verzióra van szükség.",
        "no": "Nem",
        "no_upgrades": "Nincsenek elérhető frissítések",
        "ok": "OK",
        "overwrite": "Ezzel felül fogod írni.",
        "reload_data": "Ez újratölti a HACS által ismert összes tároló adatát, ami némi időbe telhet.",
        "restart_home_assistant": "Biztosan újraindítod a Home Assistant programot?",
        "uninstall": "Biztosan el szeretnéd távolítani a(z) '{item}'-t?",
        "upgrade_all": "Ez frissíteni fogja az összes tárolót. Győzödj meg róla, hogy elolvastad az összes kiadási megjegyzést, mielőtt továbblépnél.",
        "yes": "Igen"
      },
      "dialog_about": {
        "frontend_version": "Frontend verzió",
        "installed_repositories": "Telepített tárolók",
        "integration_version": "Integráció verzió",
        "useful_links": "Hasznos linkek"
      },
      "dialog_add_repo": {
        "limit": "Csak az első 100 tároló jelenik meg, használd a keresőt a találatok szűkítéséhez",
        "no_match": "Nincs a szűrésnek megfelelő tároló",
        "sort_by": "Rendezés",
        "title": "Tároló hozzáadása"
      },
      "dialog_custom_repositories": {
        "category": "Kategória",
        "no_category": "Hiányzó kategória",
        "no_repository": "Hiányzó tároló",
        "title": "Egyéni tárolók",
        "url_placeholder": "Egyéni tároló URL címének hozzáadása"
      },
      "dialog_info": {
        "author": "Szerző",
        "downloads": "Letöltések",
        "install": "Tároló telepítése HACS-ben",
        "loading": "Információ betöltése...",
        "no_info": "A fejlesztő nem adott meg több információt ehhez a tárolóhoz",
        "open_issues": "Jelentett problémák",
        "open_repo": "Tároló megnyitása",
        "stars": "Csillagok",
        "version_installed": "Telepített verzió"
      },
      "dialog_install": {
        "restart": "Ne feledd, hogy az egyéni integrációk (custom_components) módosításainak alkalmazásához újra kell indítanod a Home Assistant alkalmazást.",
        "select_version": "Verzió kiválasztása",
        "show_beta": "Béta verziók megjelenítése",
        "type": "Típus",
        "url": "URL"
      },
      "dialog_update": {
        "available_version": "Elérhető verzió",
        "changelog": "Változási napló",
        "installed_version": "Telepített verzió",
        "title": "Frissítés érhető el"
      },
      "entry": {
        "information": "Információ",
        "intro": "A frissítések és a fontos üzenetek itt jelennek meg, ha vannak",
        "messages": {
          "disabled": {
            "content": "További részletek a naplófájlban",
            "title": "A HACS le van tiltva"
          },
          "has_pending_tasks": {
            "content": "Előfordulhat, hogy egyes tárolók nem jelennek meg, amíg ez be nem fejeződik",
            "title": "Függőben lévő háttérfeladatok"
          },
          "startup": {
            "content": "A HACS éppen indul, ezidő alatt egyes információk hiányozhatnak vagy helytelenek lehetnek",
            "title": "A HACS éppen indul"
          }
        },
        "pending_updates": "Frissítések érhetők el"
      },
      "menu": {
        "about": "HACS névjegye",
        "clear": "Új jelölések törlése",
        "custom_repositories": "Egyéni tárolók",
        "dismiss": "Minden új tároló elvetése",
        "documentation": "Dokumentáció",
        "open_issue": "Probléma jelentése",
        "reload": "Ablak újratöltése"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "AppDaemon appok felfedezésének és nyomon követésének engedélyezése",
              "country": "Szűrés országkóddal.",
              "debug": "Hibakeresés engedélyezése.",
              "experimental": "Kísérleti funkciók engedélyezése",
              "netdaemon": "NetDaemon appok felfedezésének és nyomon követésének engedélyezése",
              "not_in_use": "YAML-lel nem használható",
              "release_limit": "Megjelenítendő kiadások száma.",
              "sidepanel_icon": "Oldalsó panel ikon",
              "sidepanel_title": "Oldalsó panel cím"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Ez az integráció támogatja a config_flow-t, vagyis a felhasználói felületen az integrációk menüben lehet konfigurálni.",
        "config_flow_title": "A felhasználói felület konfigurációja támogatott",
        "integration_not_loaded": "Ez az integráció nincs betöltve a Home Assistantban.",
        "no_restart_required": "Nincs szükség újraindításra",
        "not_loaded": "Nincs betöltve",
        "plugin_not_loaded": "Ez a bővítmény nincs hozzáadva a Lovelace erőforrásaidhoz.",
        "restart": "Indítsd újra a Home Assistant programot.",
        "restart_pending": "Újraindítás függőben"
      },
      "repository_card": {
        "dismiss": "elvetés",
        "hide": "Elrejtés",
        "information": "Információ",
        "new_repository": "Új tároló",
        "open_issue": "Probléma jelentése",
        "open_source": "Forrás megnyitása",
        "pending_update": "Frissítés érhető el",
        "reinstall": "Újratelepítés",
        "report": "Jelentés eltávolításra",
        "update_information": "Frissítési információ"
      },
      "repository": {
        "add_to_lovelace": "Hozzáadás a Lovelace-hez",
        "authors": "Szerzők",
        "available": "Elérhető",
        "back_to": "Vissza -",
        "changelog": "Változási napló",
        "downloads": "Letöltések",
        "flag_this": "Megjelölés",
        "frontend_version": "Frontend verzió",
        "github_stars": "GitHub csillagok",
        "goto_integrations": "Ugrás az integrációkhoz",
        "hide": "Elrejtés",
        "hide_beta": "Béta elrejtése",
        "install": "Telepítés",
        "installed": "Telepített",
        "lovelace_copy_example": "Példa másolása a vágólapra",
        "lovelace_instruction": "Amikor hozzáadod ezt a lovelace konfigurációdhoz, használd ezt",
        "lovelace_no_js_type": "Nem sikerült meghatározni a bővítmény típusát, ellenőrizd a tárolót.",
        "newest": "legújabb",
        "note_appdaemon": "de még hozzá kell adnod az 'apps.yaml' fájlhoz",
        "note_installed": "Telepítéskor a következő helyre kerül:",
        "note_integration": "de még hozzá kell adnod a 'configuration.yaml' fájlhoz",
        "note_plugin": "de még hozzá kell adnod a lovelace konfigurációhoz (az 'ui-lovelace.yaml' fájlban vagy a Lovelace felületen a konfiguráció szerkesztőben)",
        "note_plugin_post_107": "de még hozzá kell adnod a lovelace konfigurációhoz ('configuration.yaml' vagy az erőforrás szerkesztőben '/config/lovelace/resources')",
        "open_issue": "Probléma jelentése",
        "open_plugin": "Bővítmény megnyitása",
        "reinstall": "Újratelepítés",
        "repository": "Tároló",
        "restart_home_assistant": "Home Assistant újraindítása",
        "show_beta": "Béta megjelenítése",
        "uninstall": "Eltávolítás",
        "update_information": "Frissítési információk",
        "upgrade": "Frissítés"
      },
      "search": {
        "placeholder": "Tároló keresése"
      },
      "sections": {
        "about": {
          "description": "Információk megjelenítése a HACS-ről",
          "title": "Névjegy"
        },
        "automation": {
          "description": "Itt Python szkripteket, AppDaemon és NetDaemon appokat találsz",
          "title": "Automatizálás"
        },
        "frontend": {
          "description": "Itt témákat, egyéni kártyákat és más bővítményeket találsz a Lovelace-hez",
          "title": "Frontend"
        },
        "integrations": {
          "description": "Itt találod az egyéni integrációkat (custom_components)",
          "title": "Integrációk"
        },
        "pending_repository_upgrade": "A(z) {installed} verziót futtatod, a(z) {available} verzió már elérhető"
      },
      "settings": {
        "add_custom_repository": "EGYÉNI TÁROLÓ HOZZÁADÁSA",
        "adding_new_repo": "Új tároló hozzáadása '{repo}'",
        "adding_new_repo_category": "A '{category}' kategóriával.",
        "bg_task_custom": "Az egyéni tárolók rejtve vannak, amíg háttérfeladat fut.",
        "category": "Kategória",
        "compact_mode": "Kompakt mód",
        "custom_repositories": "EGYÉNI TÁROLÓK",
        "delete": "Törlés",
        "display": "Megjelenítés",
        "grid": "Rács",
        "hacs_repo": "HACS tároló",
        "hidden_repositories": "rejtett tárolók",
        "missing_category": "Ki kell választanod egy kategóriát",
        "open_repository": "Tároló megnyitása",
        "reload_data": "Adatok újratöltése",
        "reload_window": "Ablak újratöltése",
        "repository_configuration": "Tároló konfiguráció",
        "save": "Mentés",
        "table": "Táblázat",
        "table_view": "Táblázat nézet",
        "unhide": "felfedés",
        "upgrade_all": "Minden frissítése"
      },
      "store": {
        "ascending": "növekvő",
        "clear_new": "Új tárolók megjelölése látottként",
        "descending": "csökkenő",
        "last_updated": "Utolsó frissítés",
        "name": "Név",
        "new_repositories": "Új tárolók",
        "new_repositories_note": "Több mint 10 új tároló látható. Ha törölni szeretnéd őket, akkor kattints a jobb felső sarokban lévő 3 pontra, és válaszd ki a 'Minden új tároló elvetése' menüpontot.",
        "no_repositories": "Nincsenek tárolók",
        "no_repositories_desc1": "Úgy tűnik, még nincsenek telepítve tárolók ebben a szekcióban.",
        "no_repositories_desc2": "Kattints az alsó sarokban található + jelre az első hozzáadásához!",
        "pending_upgrades": "Frissítések érhetők el",
        "placeholder_search": "Kérlek adj meg egy keresési kifejezést...",
        "sort": "rendezés",
        "stars": "Csillag",
        "status": "Állapot"
      },
      "time": {
        "ago": "ezelőtt",
        "day": "nap",
        "days": "nap",
        "hour": "óra",
        "hours": "óra",
        "minute": "perc",
        "minutes": "perc",
        "month": "hónap",
        "months": "hónap",
        "one": "Egy",
        "one_day_ago": "egy nappal ezelőtt",
        "one_hour_ago": "egy órával ezelőtt",
        "one_minute_ago": "egy perccel ezelőtt",
        "one_month_ago": "egy hónappal ezelőtt",
        "one_second_ago": "egy másodperccel ezelőtt",
        "one_year_ago": "egy évvel ezelőtt",
        "second": "másodperc",
        "seconds": "másodperc",
        "x_days_ago": "{x} nappal ezelőtt",
        "x_hours_ago": "{x} órával ezelőtt",
        "x_minutes_ago": "{x} perccel ezelőtt",
        "x_months_ago": "{x} hónappal ezelőtt",
        "x_seconds_ago": "{x} másodperccel ezelőtt",
        "x_years_ago": "{x} évvel ezelőtt",
        "year": "év",
        "years": "év"
      }
    },
    "it": {
      "common": {
        "about": "Informazioni su",
        "add": "aggiungi",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "Applicazioni AppDaemon",
        "appdaemon_plural": "Applicazioni AppDaemon",
        "background_task": "Attività in esecuzione, questa pagina sarà ricaricata al termine.",
        "check_log_file": "Controlla il tuo file di registro per maggiori dettagli.",
        "continue": "Continua",
        "disabled": "Disabilitato",
        "documentation": "Documentazione",
        "element": "elemento",
        "hacs_is_disabled": "HACS è disabilitato",
        "install": "Installa",
        "installed": "Installati",
        "integration": "Integrazione",
        "integration_plural": "Integrazioni",
        "integrations": "Integrazioni",
        "lovelace": "Lovelace",
        "lovelace_element": "Elemento Lovelace",
        "lovelace_elements": "Elementi di Lovelace",
        "manage": "gestione",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "Applicazioni NetDaemon",
        "netdaemon_plural": "Applicazioni NetDaemon",
        "plugin": "Lovelace",
        "plugin_plural": "Elementi di Lovelace",
        "plugins": "Elementi di Lovelace",
        "python_script": "Script python",
        "python_script_plural": "Script in Python",
        "python_scripts": "Script python",
        "repositories": "Repository",
        "repository": "Repository",
        "settings": "Impostazioni",
        "theme": "Tema",
        "theme_plural": "Temi",
        "themes": "Temi",
        "uninstall": "Disinstallare",
        "update": "Aggiorna",
        "version": "Versione"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "È consentita una sola configurazione di HACS."
        },
        "error": {
          "auth": "Il token di accesso personale non è corretto."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Abilita il rilevamento e il monitoraggio delle applicazioni AppDaemon",
              "netdaemon": "Abilita il rilevamento e il monitoraggio delle applicazioni NetDaemon",
              "python_script": "Abilita il rilevamento e il monitoraggio dei python_scripts",
              "sidepanel_icon": "Icona nel pannello laterale",
              "sidepanel_title": "Titolo nel pannello laterale",
              "theme": "Abilita individuazione e tracciamento dei temi",
              "token": "Token di accesso personale GitHub"
            },
            "description": "Se hai bisogno di aiuto con la configurazione dai un'occhiata qui: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Sei sicuro di voler aggiungerlo alle tue risorse Lovelace?",
        "bg_task": "L'azione è disabilitata mentre sono in esecuzione attività in background.",
        "cancel": "Annulla",
        "continue": "Sei sicuro di voler continuare?",
        "delete": "Sei sicuro di voler disinstallare '{item}'?",
        "delete_installed": "'{item}' è installato, è necessario disinstallarlo prima di poterlo eliminare.",
        "exist": "{item} esiste già",
        "generic": "Sei sicuro?",
        "home_assistant_is_restarting": "Aspetta, Home Assistant si sta riavviando.",
        "home_assistant_version_not_correct": "Stai eseguendo la versione Home Assistant '{haversion}', ma questo repository richiede l'installazione della versione minima '{minversion}'.",
        "no": "No",
        "no_upgrades": "Nessun aggiornamento in sospeso",
        "ok": "OK",
        "overwrite": "In questo modo lo sovrascriverà.",
        "reload_data": "Questo ricarica i dati di tutte le repository di cui HACS è a conoscenza, ci vorrà del tempo per finire.",
        "restart_home_assistant": "Sei sicuro di voler riavviare Home Assistant?",
        "uninstall": "Sei sicuro di voler disinstallare '{item}'?",
        "upgrade_all": "Questa azione aggiornerà tutti i repository, assicurati di aver letto le note di rilascio prima di procedere.",
        "yes": "Sì"
      },
      "dialog_about": {
        "frontend_version": "Versione frontend",
        "installed_repositories": "Repository installati",
        "integration_version": "Versione di integrazione",
        "useful_links": "Link utili"
      },
      "dialog_add_repo": {
        "limit": "Vengono visualizzati solo i primi 100 repository, utilizza la ricerca per filtrare ciò di cui hai bisogno",
        "no_match": "Nessun repository trovato corrispondente al filtro",
        "sort_by": "Ordina per",
        "title": "Aggiungi repository"
      },
      "dialog_custom_repositories": {
        "category": "Categoria",
        "no_category": "Categoria mancante",
        "no_repository": "Repository mancante",
        "title": "Repository personalizzati",
        "url_placeholder": "Aggiungi l'URL del repository personalizzato"
      },
      "dialog_info": {
        "author": "Autore",
        "downloads": "Download",
        "install": "Installa questo repository in HACS",
        "loading": "Caricamento informazioni in corso ...",
        "no_info": "Lo sviluppatore non ha fornito ulteriori informazioni per questo repository",
        "open_issues": "Problemi aperti",
        "open_repo": "Apri il repository",
        "stars": "Stelle",
        "version_installed": "Versione installata"
      },
      "dialog_install": {
        "restart": "Tenere presente che è necessario riavviare Home Assistant prima di applicare le modifiche alle integrazioni (custom_components).",
        "select_version": "Seleziona la versione",
        "show_beta": "Mostra le versioni beta",
        "type": "Tipo",
        "url": "URL"
      },
      "dialog_update": {
        "available_version": "Versione disponibile",
        "changelog": "Registro dei cambiamenti",
        "installed_version": "Versione installata",
        "releasenotes": "Note di rilascio per {release}",
        "title": "Aggiornamento in sospeso"
      },
      "entry": {
        "information": "Informazioni",
        "intro": "Gli aggiornamenti e i messaggi importanti verranno visualizzati qui se presenti",
        "messages": {
          "disabled": {
            "content": "Controlla il tuo file di registro per maggiori dettagli",
            "title": "HACS è disabilitato"
          },
          "has_pending_tasks": {
            "content": "Alcuni repository potrebbero non essere visualizzati fino al completamento",
            "title": "Attività in background in sospeso"
          },
          "resources": {
            "content": "Hai {number} elementi di Lovelace che non sono stati caricati correttamente in Lovelace.",
            "title": "Non caricato in Lovelace"
          },
          "restart": {
            "content": "Hai {number} integrazioni che richiedono il riavvio di Home Assistant, puoi farlo dalla sezione \"Controlli del server\" nella sezione Impostazioni dell'interfaccia utente di Home Assistant.",
            "title": "In attesa di riavvio"
          },
          "startup": {
            "content": "HACS si sta avviando, durante questo periodo alcune informazioni potrebbero essere mancanti o errate",
            "title": "HACS si sta avviando"
          },
          "wrong_frontend_installed": {
            "content": "Hai installato {running} del frontend HACS, ma era attesa la versione {expected}, se viene visualizzato questo messaggio Home Assistant non è stato in grado di installare la nuova versione, prova a riavviare Home Assistant.",
            "title": "Versione frontend inaspettata"
          },
          "wrong_frontend_loaded": {
            "content": "Stai eseguendo la versione {running} del frontend HACS, ma la versione {expected} era prevista, è necessario svuotare la cache del browser.",
            "title": "Versione frontend inaspettata"
          }
        },
        "pending_updates": "Aggiornamenti in sospeso"
      },
      "menu": {
        "about": "Informazioni su HACS",
        "clear": "Cancella tutte le novità",
        "custom_repositories": "Repository personalizzati",
        "dismiss": "Elimina tutti i nuovi repository",
        "documentation": "Documentazione",
        "open_issue": "Segnala anomalia",
        "reload": "Ricarica la finestra"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Abilita il rilevamento e il monitoraggio delle applicazioni AppDaemon",
              "country": "Filtra con prefisso internazionale.",
              "debug": "Abilita debug.",
              "experimental": "Abilita funzionalità sperimentali",
              "netdaemon": "Abilita il rilevamento e il monitoraggio delle applicazioni NetDaemon",
              "not_in_use": "Non in uso con YAML",
              "release_limit": "Numero di versioni da mostrare.",
              "sidepanel_icon": "Icona nel pannello laterale",
              "sidepanel_title": "Titolo nel pannello laterale"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Questa integrazione supporta config_flow, questo significa che è ora possibile passare alla sezione \"IntegrazionI\" dell'interfaccia utente per la configurazione.",
        "config_flow_title": "Configurazione dell'interfaccia utente supportata",
        "integration_not_loaded": "Questa integrazione non è caricata in Home Assistant.",
        "no_restart_required": "Non è necessario riavviare",
        "not_loaded": "Non caricato",
        "plugin_not_loaded": "Questo elemento non è aggiunto alle tue risorse Lovelace.",
        "restart": "È necessario riavviare Home Assistant.",
        "restart_pending": "Riavvio in attesa"
      },
      "repository_card": {
        "dismiss": "elimina",
        "hide": "Nascondi",
        "information": "Informazioni",
        "new_repository": "Nuovo repository",
        "not_loaded": "Non caricato",
        "open_issue": "Segnala anomalia",
        "open_source": "Open source",
        "pending_restart": "In attesa di riavvio",
        "pending_update": "Aggiornamento in sospeso",
        "reinstall": "Reinstallare",
        "report": "Segnala per la rimozione",
        "update_information": "Aggiorna informazioni"
      },
      "repository": {
        "add_to_lovelace": "Aggiungi a Lovelace",
        "authors": "Autori",
        "available": "Disponibile",
        "back_to": "Torna a",
        "changelog": "Change log",
        "downloads": "Downloads",
        "flag_this": "Spunta questo",
        "frontend_version": "Frontend versione",
        "github_stars": "GitHub stelle",
        "goto_integrations": "Vai alle Integrazioni",
        "hide": "Nascondi",
        "hide_beta": "Nascondi beta",
        "install": "Installa",
        "installed": "Installato",
        "lovelace_copy_example": "Copia l'esempio negli appunti",
        "lovelace_instruction": "Quando lo aggiungi nella configurazione di lovelace, usa questo",
        "lovelace_no_js_type": "Impossibile determinare il tipo di questo elemento, controllare il repository.",
        "newest": "Più recente",
        "note_appdaemon": "dovrai aggiungerlo nel file 'apps.yaml'",
        "note_installed": "Una volta installato, si troverà in",
        "note_integration": "dovrai aggiungerlo nel file 'configuration.yaml'",
        "note_plugin": "devi aggiungere la configurazione nel file 'ui-lovelace.yaml' oppure via Editor RAW della UI.",
        "note_plugin_post_107": "devi aggiungere la configurazione nel file 'ui-lovelace.yaml' oppure via Editor RAW della UI.",
        "open_issue": "Segnala anomalia",
        "open_plugin": "Apri elemento",
        "reinstall": "Reinstalla",
        "repository": "Archivio Software (Repository)",
        "restart_home_assistant": "Riavvia Home Assistant",
        "show_beta": "Visualizza beta",
        "uninstall": "Rimuovi",
        "update_information": "Aggiorna informazioni",
        "upgrade": "Aggiorna"
      },
      "search": {
        "installed": "Cerca i repository installati",
        "installed_new": "Cercare repository installati o nuovi",
        "placeholder": "Cerca repository"
      },
      "sections": {
        "about": {
          "description": "Mostra informazioni su HACS",
          "title": "Informazioni su"
        },
        "automation": {
          "description": "Qui trovi python_scripts, app AppDaemon e app NetDaemon",
          "title": "Automazione"
        },
        "frontend": {
          "description": "Qui troverai temi, schede personalizzate e altri elementi per Lovelace",
          "title": "Frontend"
        },
        "integrations": {
          "description": "Qui si trovano le integrazioni personalizzate (custom_components)",
          "title": "Integrazioni"
        },
        "pending_repository_upgrade": "Stai eseguendo la versione {installed}, la versione {available}è disponibile"
      },
      "settings": {
        "add_custom_repository": "AGGIUNGI REPOSITORY PERSONALIZZATA",
        "adding_new_repo": "Aggiunta di un nuovo repository '{repo}'",
        "adding_new_repo_category": "Con la categoria '{category}'.",
        "bg_task_custom": "I repository personalizzati sono nascosti mentre sono in esecuzione attività in background.",
        "category": "Categoria",
        "compact_mode": "Modalità compatta",
        "custom_repositories": "REPOSITORY PERSONALIZZATE",
        "delete": "Cancella",
        "display": "Visualizza",
        "grid": "Griglia",
        "hacs_repo": "HACS repo",
        "hidden_repositories": "repository nascosti",
        "missing_category": "Devi selezionare una categoria",
        "open_repository": "Apri il repository",
        "reload_data": "Ricarica i dati",
        "reload_window": "Ricarica la finestra",
        "repository_configuration": "Configurazione del repository",
        "save": "Salva",
        "table": "Tabella",
        "table_view": "Vista tabella",
        "unhide": "Mostra",
        "upgrade_all": "Aggiorna tutto"
      },
      "store": {
        "ascending": "ascendente",
        "clear_new": "Ripulisci i nuovi repository",
        "descending": "discendente",
        "last_updated": "Ultimo aggiornamento",
        "name": "Nome",
        "new_repositories": "Nuovi repository",
        "new_repositories_note": "Hai più di 10 nuovi repository visualizzati qui, se vuoi cancellarli tutti fai clic sui 3 punti nell'angolo in alto a destra e li eliminerai tutti.",
        "no_repositories": "Nessun repository",
        "no_repositories_desc1": "Sembra che non ci siano ancora repository installati in questa sezione.",
        "no_repositories_desc2": "Fai clic sul + nell'angolo in basso per aggiungere il tuo primo!",
        "no_repositories_found_desc1": "Nessun repository installato corrispondente a \"{searchInput}\" trovato in questa sezione.",
        "no_repositories_found_desc2": "Prova a cercare qualcos'altro!",
        "pending_upgrades": "Aggiornamenti in sospeso",
        "placeholder_search": "Inserire un termine di ricerca",
        "sort": "Ordinare",
        "stars": "Stelle",
        "status": "Stato"
      },
      "time": {
        "ago": "fa",
        "day": "giorno",
        "days": "giorni",
        "hour": "ora",
        "hours": "ore",
        "minute": "minuto",
        "minutes": "minuti",
        "month": "mese",
        "months": "mesi",
        "one": "Un",
        "one_day_ago": "un giorno fa",
        "one_hour_ago": "un'ora fa",
        "one_minute_ago": "un minuto fa",
        "one_month_ago": "un mese fa",
        "one_second_ago": "un secondo fa",
        "one_year_ago": "un anno fa",
        "second": "secondo",
        "seconds": "secondi",
        "x_days_ago": "{x} giorni fa",
        "x_hours_ago": "{x} ore fa",
        "x_minutes_ago": "{x} minuti fa",
        "x_months_ago": "{x} mesi fa",
        "x_seconds_ago": "{x} secondi fa",
        "x_years_ago": "{x} anni fa",
        "year": "anno",
        "years": "anni"
      }
    },
    "nb": {
      "common": {
        "about": "Om",
        "add": "legg til",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "AppDaemon Apper",
        "appdaemon_plural": "AppDaemon-apper",
        "background_task": "Bakgrunnsoppgaven kjører. Denne siden lastes inn på nytt når den er ferdig.",
        "check_log_file": "Sjekk loggfilen din for mer informasjon.",
        "continue": "Fortsett",
        "disabled": "Deaktivert",
        "documentation": "dokumentasjon",
        "element": "element",
        "hacs_is_disabled": "HACS er deaktivert",
        "install": "Installer",
        "installed": "Installert",
        "integration": "Integrasjon",
        "integration_plural": "Integrasjoner",
        "integrations": "Integrasjoner",
        "lovelace": "Lovelace",
        "lovelace_element": "Lovelace-element",
        "lovelace_elements": "Lovelace-elementer",
        "manage": "manage",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDaemon Apper",
        "netdaemon_plural": "NetDaemon-apper",
        "plugin": "Lovelace",
        "plugin_plural": "Lovelace-elementer",
        "plugins": "Lovelace-elementer",
        "python_script": "Python-skript",
        "python_script_plural": "Python-skript",
        "python_scripts": "Python-skript",
        "repositories": "Repositories",
        "repository": "Repository",
        "settings": "Innstillinger",
        "theme": "Tema",
        "theme_plural": "Temaer",
        "themes": "Temaer",
        "uninstall": "Avinstaller",
        "update": "Oppdater",
        "version": "Versjon"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Bare en konfigurasjon av HACS er tillatt."
        },
        "error": {
          "auth": "Personlig tilgangstoken er ikke korrekt."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Aktiver oppdagelse og sporing av AppDaemon-apper",
              "netdaemon": "Aktiver oppdagelse og sporing av NetDaemon-apper",
              "python_script": "Aktiver oppdagelse og sporing av python_scripts",
              "sidepanel_icon": "Sidepanel ikon",
              "sidepanel_title": "Sidepanel tittel",
              "theme": "Aktiver oppdagelse og sporing av temaer",
              "token": "GitHub Personal Access Token"
            },
            "description": "Hvis du trenger hjelp med konfigurasjonen, ta en titt her: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Er du sikker på at du vil legge dette til i dine Lovelace resources?",
        "bg_task": "Handlingen er deaktivert mens bakgrunnsoppgaver kjører.",
        "cancel": "Avbryt",
        "continue": "Er du sikker på at du vil fortsette?",
        "delete": "Er du sikker på at du vil fjerne '{item}'?",
        "delete_installed": "'{item}' er installert, du må avinstallere det før du kan slette det.",
        "exist": "{item} eksisterer allerede",
        "generic": "Er du sikker?",
        "home_assistant_is_restarting": "Vent, Home Assistant starter nå på nytt.",
        "home_assistant_version_not_correct": "Du kjører Home Assistant '{haversion}', men denne krever minimum versjon '{minversion}' for å bli installert.",
        "no": "Nei",
        "no_upgrades": "Ingen oppgraderinger tilgjengelig",
        "ok": "OK",
        "overwrite": "Å gjøre dette vil overskrive det.",
        "reload_data": "Dette laster inn dataene til alle repositories HACS vet om, dette vil ta litt tid å fullføre.",
        "restart_home_assistant": "Er du sikker på at du vil starte Home Assistant på nytt?",
        "uninstall": "Er du sikker på at du vil avinstallere '{item}'?",
        "upgrade_all": "Dette vil oppgradere alle disse repositorene, sørg for at du har lest utgivelses notatene for dem alle før du fortsetter.",
        "yes": "Ja"
      },
      "dialog_about": {
        "frontend_version": "Frontend versjon",
        "installed_repositories": "Installerte repositories",
        "integration_version": "Integrasjonsversjon",
        "useful_links": "Nyttige lenker"
      },
      "dialog_add_repo": {
        "limit": "Bare de første 100 elementene vises, bruk søket til å filtrere det du trenger",
        "no_match": "Ingen elementer funnet som samsvarer med filteret ditt",
        "title": "Legg til repository"
      },
      "dialog_custom_repositories": {
        "category": "Kategori",
        "no_category": "Mangler kategori",
        "no_repository": "Mangler repository",
        "title": "Custom repositories",
        "url_placeholder": "Legg til custom repository"
      },
      "dialog_info": {
        "author": "Utgiver",
        "downloads": "Nedlastinger",
        "install": "Installer dette elementet i HACS",
        "loading": "Laster inn informasjon ...",
        "no_info": "Utvikleren har ikke gitt mer informasjon for dette elementet",
        "open_issues": "Åpne problemer",
        "open_repo": "Åpne repository",
        "stars": "Stjerner",
        "version_installed": "Versjon installert"
      },
      "dialog_install": {
        "select_version": "Velg versjon",
        "show_beta": "Vis betaversjoner",
        "type": "Type",
        "url": "URL"
      },
      "dialog_update": {
        "available_version": "Tilgjengelig versjon",
        "changelog": "Endringslogg",
        "installed_version": "Installert versjon",
        "title": "Oppdatering venter"
      },
      "entry": {
        "information": "Informasjon",
        "intro": "Oppdateringer og viktige meldinger vises her hvis det er noen",
        "messages": {
          "disabled": {
            "content": "Sjekk loggfilen din for mer informasjon",
            "title": "HACS er deaktivert"
          },
          "has_pending_tasks": {
            "content": "Noen elementer vises kanskje ikke før dette er fullført",
            "title": "Venter på bakgrunnsoppgaver"
          },
          "startup": {
            "content": "HACS starter opp, i løpet av denne tiden kan det hende at noe informasjon mangler eller er feil",
            "title": "HACS starter opp"
          }
        },
        "pending_updates": "Oppdateringer er klare"
      },
      "menu": {
        "about": "Om HACS",
        "clear": "Fjern alt nytt",
        "custom_repositories": "Custom repositories",
        "documentation": "Dokumentasjon",
        "open_issue": "Meld et problem",
        "reload": "Last inn vinduet på nytt"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Aktiver oppdagelse og sporing av AppDaemon-apper",
              "country": "Filtrer med landskode.",
              "debug": "Aktiver debug",
              "experimental": "Aktiver eksperimentelle funksjoner",
              "netdaemon": "Aktiver oppdagelse og sporing av NetDaemon-apper",
              "not_in_use": "Ikke i bruk med YAML",
              "release_limit": "Antall utgivelser som skal vises.",
              "sidepanel_icon": "Sidepanel ikon",
              "sidepanel_title": "Sidepanel tittel"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Denne integrasjonen støtter config_flow, det betyr at du nå kan gå til integrasjoner i brukergrensesnittet for å konfigurere den.",
        "config_flow_title": "UI konfigurasjon støttet",
        "integration_not_loaded": "Integrasjonen er ikke lastet inn i Home Assistant.",
        "no_restart_required": "Ingen omstart kreves",
        "not_loaded": "Ikke lastet inn",
        "plugin_not_loaded": "Dette elementet er ikke lagt til i lovelace under \"resource\" delen av konfigurasjonen.",
        "restart": "Du må restart Home Assistant",
        "restart_pending": "Restart er nødvendig"
      },
      "repository_card": {
        "hide": "Skjul",
        "information": "Informasjon",
        "new_repository": "Ny",
        "open_issue": "Meld et problem",
        "open_source": "Åpne kilde",
        "pending_update": "Oppdatering venter",
        "reinstall": "Installer på nytt",
        "report": "Rapporter for fjerning",
        "update_information": "Oppdater informasjon"
      },
      "repository": {
        "add_to_lovelace": "Legg til i Lovelace",
        "authors": "Laget av",
        "available": "Tilgjengelig",
        "back_to": "Tilbake til",
        "changelog": "Endringslogg",
        "downloads": "Nedlastinger",
        "flag_this": "Flag dette",
        "frontend_version": "Frontend versjon",
        "github_stars": "GitHub-stjerner",
        "goto_integrations": "Gå til integrasjoner",
        "hide": "Skjul",
        "hide_beta": "Skjul beta",
        "installed": "Installert",
        "lovelace_copy_example": "Kopier eksemplet til utklippstavlen",
        "lovelace_instruction": "Når du legger til dette i lovelace-konfigurasjonen din, bruk dette",
        "lovelace_no_js_type": "Kunne ikke bestemme typen for dettte elementet, sjekk repository.",
        "newest": "Nyeste",
        "note_appdaemon": "du må fortsatt legge den til i 'apps.yaml' filen",
        "note_installed": "Når det er installert, vil dette ligge i",
        "note_integration": "du må fortsatt legge den til 'configuration.yaml' filen",
        "note_plugin": "du må fortsatt legge den til i lovelace-konfigurasjonen ('ui-lovelace.yaml' eller den rå UI-konfigurasjonsredigereren)",
        "note_plugin_post_107": "du må fortsatt legge den til i lovelace konfigurasjonen ('configuration.yaml' eller via resource behanleren i grensesnittet '/config/lovelace/resources')",
        "open_issue": "Meld et problem",
        "open_plugin": "Åpne kilde",
        "reinstall": "Installer på nytt",
        "repository": "Repository",
        "restart_home_assistant": "Start Home Assistant på nytt",
        "show_beta": "Vis beta",
        "uninstall": "Avinstaller",
        "update_information": "Oppdater informasjon",
        "upgrade": "Oppdater"
      },
      "search": {
        "placeholder": "Søk etter repository"
      },
      "sections": {
        "about": {
          "description": "Vis informasjon om HACS",
          "title": "Om"
        },
        "automation": {
          "description": "Det er her du finner python_scripts, AppDaemon-apper og NetDaemon-apper",
          "title": "Automasjon"
        },
        "frontend": {
          "description": "Det er her du finner temaer, tilpassede kort og andre elementer for lovelace",
          "title": "Frontend"
        },
        "integrations": {
          "description": "Det er her du finner tilpassede integrasjoner (custom_components)",
          "title": "Integrasjoner"
        },
        "pending_repository_upgrade": "Du kjører versjon {installed} , versjon {available} er tilgjengelig"
      },
      "settings": {
        "add_custom_repository": "LEGG TIL REPOSITORY",
        "adding_new_repo": "Legger til ny repository '{repo}'",
        "adding_new_repo_category": "Med kategori '{category}'.",
        "bg_task_custom": "Custom repositories er skjult mens bakgrunnsoppgaver kjører.",
        "category": "Kategori",
        "compact_mode": "Kompakt modus",
        "custom_repositories": "TILPASSEDE REPOSITORIER",
        "delete": "Slett",
        "display": "Vise",
        "grid": "Nett",
        "hacs_repo": "HACS repo",
        "hidden_repositories": "Gjemte repositories",
        "missing_category": "Du må velge en kategori",
        "open_repository": "Åpne repository",
        "reload_data": "Last inn data på nytt",
        "reload_window": "Last inn vinduet på nytt",
        "repository_configuration": "Repository konfigurasjon",
        "save": "Lagre",
        "table": "Tabell",
        "table_view": "Tabellvisning",
        "unhide": "Vis igjen",
        "upgrade_all": "Oppgradere alle"
      },
      "store": {
        "ascending": "stigende",
        "clear_new": "Tøm nye repositories",
        "descending": "synkende",
        "last_updated": "Sist oppdatert",
        "name": "Navn",
        "new_repositories": "Nye repositories",
        "no_repositories": "Ingen repositories",
        "no_repositories_desc1": "Det virker som om du ikke har noen elementer installert i denne delen ennå.",
        "no_repositories_desc2": "Klikk på + i nederste hjørne for å legge til din første!",
        "pending_upgrades": "Venter på oppgradering",
        "placeholder_search": "Skriv inn et søkeord ...",
        "sort": "sorter",
        "stars": "Stjerner",
        "status": "Status"
      },
      "time": {
        "ago": "siden",
        "day": "dag",
        "days": "dager",
        "hour": "time",
        "hours": "timer",
        "minute": "minutt",
        "minutes": "minutter",
        "month": "måned",
        "months": "måneder",
        "one": "En",
        "one_day_ago": "for en dag siden",
        "one_hour_ago": "en time siden",
        "one_minute_ago": "ett minutt siden",
        "one_month_ago": "en måned siden",
        "one_second_ago": "ett sekund siden",
        "one_year_ago": "ett år siden",
        "second": "sekund",
        "seconds": "sekunder",
        "x_days_ago": "{x} dager siden",
        "x_hours_ago": "{x} timer siden",
        "x_minutes_ago": "{x} minutter siden",
        "x_months_ago": "{x} måneder siden",
        "x_seconds_ago": "{x} sekunder siden",
        "x_years_ago": "{x} år siden",
        "year": "år",
        "years": "år"
      }
    },
    "nl": {
      "common": {
        "about": "Over",
        "add": "toevoegen",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "AppDaemon Apps",
        "appdaemon_plural": "AppDaemon Apps",
        "background_task": "Achtergrond taak is draaiende, de pagina herhaalt zichzelf wanneer dit klaar is.",
        "check_log_file": "Controleer het logbestand voor meer details.",
        "continue": "Doorgaan",
        "disabled": "Uitgeschakeld",
        "documentation": "Documentatie",
        "element": "element",
        "hacs_is_disabled": "HACS is uitgeschakeld",
        "install": "Installeer",
        "installed": "geinstalleerd",
        "integration": "Integratie",
        "integration_plural": "Integraties",
        "integrations": "Integraties",
        "lovelace": "Lovelace",
        "lovelace_element": "Lovelace-element",
        "lovelace_elements": "Lovelace-elementen",
        "manage": "beheer",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDaemon Apps",
        "netdaemon_plural": "NetDaemon Apps",
        "plugin": "Lovelace",
        "plugin_plural": "Lovelace-elementen",
        "plugins": "Plugins",
        "python_script": "Python Script",
        "python_script_plural": "Python Scripts",
        "python_scripts": "Python Scripts",
        "repositories": "Repositories",
        "repository": "Repository",
        "settings": "instellingen",
        "theme": "Thema",
        "theme_plural": "Themas",
        "themes": "Themas",
        "uninstall": "Verwijderen",
        "update": "Update",
        "version": "Versie"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Je kunt maar een enkele configuratie van HACS tegelijk hebben."
        },
        "error": {
          "auth": "Persoonlijke Toegang Token is niet correct."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Zet AppDaemon apps ontdekken & traceren aan",
              "netdaemon": "Zet NetDaemon apps ontdekken & traceren aan",
              "python_script": "Zet python_scripts ontdekken & traceren aan",
              "sidepanel_icon": "Zijpaneel icoon",
              "sidepanel_title": "Zijpaneel titel",
              "theme": "Zet Themes ontdekken & traceren aan",
              "token": "GitHub Persoonlijke Toegang Token"
            },
            "description": "Als je hulp nodig hebt met de configuratie, kun je hier verder kijken: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Weet u zeker dat u dit wilt toevoegen aan uw Lovelace bronnen?",
        "bg_task": "Actie is geblokkeerd terwijl achtergrondtaken actief zijn.",
        "cancel": "Annuleer",
        "continue": "Weet je zeker dat je wilt doorgaan?",
        "delete": "Weet u zeker dat u '{item}' wilt verwijderen?",
        "delete_installed": "'{item}' is geïnstalleerd, je dient het eerst te deïnstalleren voordat je het kan verwijderen.",
        "exist": "{item} bestaat al.",
        "generic": "Weet je het zeker?",
        "home_assistant_is_restarting": "Een moment alstublieft, Home Assistant is aan het herstarten.",
        "home_assistant_version_not_correct": "Je gebruikt Home Assistant versie '{haversion}', echter deze repository vereist dat minimaal versie '{minversion}' is geïnstalleerd.",
        "no": "Nee",
        "no_upgrades": "Geen upgrades in afwachting.",
        "ok": "Oké",
        "overwrite": "Door dit te doen, wordt het overschreven.",
        "reload_data": "Dit zal alle bekende data herladen van alle repositories van HACS. Dit kan even duren",
        "restart_home_assistant": "Weet u zeker dat u Home Assistant opnieuw wilt starten?",
        "uninstall": "Weet u zeker dat u '{item}' wilt verwijderen?",
        "upgrade_all": "Hiermee worden al deze repositories geüpgraded. Zorg ervoor dat u de release-opmerkingen van allen heeft gelezen voordat u doorgaat.",
        "yes": "Ja"
      },
      "dialog_about": {
        "frontend_version": "Frontend versie",
        "installed_repositories": "Geïnstalleerde repositories",
        "integration_version": "Integratieversie",
        "useful_links": "Nuttige links"
      },
      "dialog_add_repo": {
        "limit": "Alleen de eerste 100 repositories worden getoond, gebruik de zoekopdracht om te filteren wat je nodig hebt",
        "no_match": "Er zijn geen repositories gevonden die overeenkomen met uw filter",
        "sort_by": "Sorteren op",
        "title": "Repository toevoegen"
      },
      "dialog_custom_repositories": {
        "category": "Categorie",
        "no_category": "Ontbrekende categorie",
        "no_repository": "Ontbrekende repository",
        "title": "Aangepaste repositories",
        "url_placeholder": "Voeg een aangepaste repository-URL toevoegen"
      },
      "dialog_info": {
        "author": "Auteur",
        "downloads": "Downloads",
        "install": "Installeer deze repository in HACS",
        "loading": "Informatie laden ...",
        "no_info": "De ontwikkelaar heeft geen verdere informatie verstrekt voor deze repository",
        "open_issues": "Openstaande problemen",
        "open_repo": "Open repository",
        "stars": "Sterren",
        "version_installed": "Versie geïnstalleerd"
      },
      "dialog_install": {
        "restart": "Onthoud dat u Home Assistant opnieuw moet opstarten voordat wijzigingen aan integraties (custom_components) worden toegepast.",
        "select_version": "Selecteer versie",
        "show_beta": "Bètaversies weergeven",
        "type": "Type",
        "url": "URL"
      },
      "dialog_update": {
        "available_version": "Beschikbare versie",
        "changelog": "Changelog",
        "installed_version": "Geïnstalleerde versie",
        "releasenotes": "Releasenotes voor {release}",
        "title": "Update in behandeling"
      },
      "entry": {
        "information": "Informatie",
        "intro": "Updates en belangrijke berichten worden hier weergegeven als die er zijn",
        "messages": {
          "disabled": {
            "content": "Controleer uw logbestand voor meer details",
            "title": "HACS is uitgeschakeld"
          },
          "has_pending_tasks": {
            "content": "Sommige repositories worden mogelijk pas weergegeven als dit is voltooid",
            "title": "Achtergrondtaken in behandeling"
          },
          "resources": {
            "content": "Je hebt {number} Lovelace-elementen die niet correct zijn geladen in Lovelace.",
            "title": "Niet geladen in Lovelace"
          },
          "restart": {
            "content": "Je hebt {number} integraties waarvoor de Home Assistant opnieuw moet worden opgestart, je kunt dat doen via het gedeelte 'Serverbeheer' onder het configuratiegedeelte van de Home Assistant UI.",
            "title": "In afwachting van herstart"
          },
          "startup": {
            "content": "HACS is aan het opstarten, gedurende deze tijd kan er informatie ontbreken of onjuist zijn",
            "title": "HACS is aan het opstarten"
          },
          "wrong_frontend_installed": {
            "content": "Je hebt {running} van de HACS-frontend geïnstalleerd, maar versie {expected} werd verwacht. Als je dit bericht ziet, kon Home Assistant de nieuwe versie niet installeren, probeer dan Home Assistant opnieuw op te starten.",
            "title": "Onverwachte frontend-versie"
          },
          "wrong_frontend_loaded": {
            "content": "U gebruikt versie {running} van de HACS-frontend, maar versie {expected} werd verwacht, u moet uw browsercache wissen.",
            "title": "Onverwachte frontend-versie"
          }
        },
        "pending_updates": "In afwachting van updates"
      },
      "menu": {
        "about": "Over HACS",
        "clear": "Wis alle nieuwe",
        "custom_repositories": "Aangepaste repositories",
        "dismiss": "Sluit alle nieuwe repositories af",
        "documentation": "Documentatie",
        "open_issue": "Meld probleem",
        "reload": "Herlaad venster"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Zet AppDaemon apps ontdekken & traceren aan",
              "country": "Filter met land code.",
              "debug": "Schakel debug in.",
              "experimental": "Zet experimentele functies aan",
              "netdaemon": "Zet NetDaemon apps ontdekken & traceren aan",
              "not_in_use": "Niet in gebruik met YAML",
              "release_limit": "Aantal releases om te laten zien.",
              "sidepanel_icon": "Zijpaneel icoon",
              "sidepanel_title": "Zijpaneel titel"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Deze integratie ondersteunt config_flow, wat betekent dat u via uw \"Instellingen\" naar \"Integraties\" kunt gaan om het te configureren.",
        "config_flow_title": "UI-configuratie ondersteund",
        "integration_not_loaded": "Deze integratie wordt niet geladen in Home Assistant.",
        "no_restart_required": "Geen herstart vereist",
        "not_loaded": "Niet geladen",
        "plugin_not_loaded": "Deze plugin wordt niet toegevoegd aan je Lovelace resources.",
        "restart": "U moet Home Assistant opnieuw starten.",
        "restart_pending": "Wachten op herstart"
      },
      "repository_card": {
        "dismiss": "afwijzen",
        "hide": "Verbergen",
        "information": "Informatie",
        "new_repository": "Nieuwe repository",
        "not_loaded": "Niet geladen",
        "open_issue": "Meld probleem",
        "open_source": "Open source",
        "pending_restart": "In afwachting van herstart",
        "pending_update": "In afwachting van update",
        "reinstall": "Herinstalleer",
        "report": "Rapport voor verwijdering",
        "update_information": "Update informatie"
      },
      "repository": {
        "add_to_lovelace": "Toevoegen aan Lovelace",
        "authors": "Auteurs",
        "available": "Beschikbaar",
        "back_to": "Terug naar",
        "changelog": "Changelog",
        "downloads": "Downloads",
        "flag_this": "Vlag dit",
        "frontend_version": "Frontend versie",
        "github_stars": "GitHub-sterren",
        "goto_integrations": "Ga naar integraties",
        "hide": "Verberg",
        "hide_beta": "Verberg beta",
        "install": "Installeer",
        "installed": "Geinstalleerd",
        "lovelace_copy_example": "Kopier het voorbeeld naar je klembord",
        "lovelace_instruction": "Wanneer je dit gaat toevoegen aan je lovelace configuratie gebruik dit",
        "lovelace_no_js_type": "Kon niet achterhalen welk type plugin dit is, controleer de repository van de plugin.",
        "newest": "nieuwste",
        "note_appdaemon": "je moet het nog steeds toevoegen aan je 'apps.yaml' bestand",
        "note_installed": "Wanneer geïnstalleerd, staat het in",
        "note_integration": "je moet het nog steeds toevoegen aan je 'configuration.yaml' bestand",
        "note_plugin": "je moet het nog steeds toevoegen aan je lovelace configuratie ('ui-lovelace.yaml') of raw UI config editor.",
        "note_plugin_post_107": "je moet het nog steeds toevoegen aan je lovelace configuratie ('configuration.yaml' of de resource editor '/config/lovelace/resources')",
        "open_issue": "Meld probleem",
        "open_plugin": "Open plugin",
        "reinstall": "Herinstalleer",
        "repository": "Repository",
        "restart_home_assistant": "Start Home Assistant opnieuw",
        "show_beta": "Laat beta zien",
        "uninstall": "Verwijder",
        "update_information": "Update informatie",
        "upgrade": "Update"
      },
      "search": {
        "placeholder": "Zoek naar repository"
      },
      "sections": {
        "about": {
          "description": "Toon informatie over HACS",
          "title": "Over"
        },
        "automation": {
          "description": "Hier vind je python_scripts, AppDaemon-apps en NetDaemon-apps",
          "title": "Automatisering"
        },
        "frontend": {
          "description": "Dit is waar je thema's, aangepaste kaarten en andere elementen voor lovelace",
          "title": "Frontend"
        },
        "integrations": {
          "description": "Hier vindt u aangepaste integraties (custom_components)",
          "title": "Integraties"
        },
        "pending_repository_upgrade": "U gebruikt versie {installed} , versie {available} is beschikbaar"
      },
      "settings": {
        "add_custom_repository": "VOEG EIGEN REPOSITORY TOE",
        "adding_new_repo": "Nieuwe repository '{repo}' toevoegen",
        "adding_new_repo_category": "Met categorie '{category}'.",
        "bg_task_custom": "Aangepaste repositories zijn verborgen terwijl de achtergrondtaken actief zijn.",
        "category": "Categorie",
        "compact_mode": "Compacte modus",
        "custom_repositories": "EIGEN REPOSITORIES",
        "delete": "Verwijder",
        "display": "Weergave",
        "grid": "Rooster",
        "hacs_repo": "HACS repo",
        "hidden_repositories": "verborgen repositories",
        "missing_category": "Je moet een categorie selecteren.",
        "open_repository": "Open repository",
        "reload_data": "Herlaad data",
        "reload_window": "Herlaad venster",
        "repository_configuration": "Repository configuratie",
        "save": "Opslaan",
        "table": "Tabel",
        "table_view": "Tabelweergave",
        "unhide": "zichtbaar maken",
        "upgrade_all": "Upgrade alles"
      },
      "store": {
        "ascending": "oplopend",
        "clear_new": "Wissen van alle nieuwe repositories",
        "descending": "Aflopend",
        "last_updated": "Laatste update",
        "name": "Naam",
        "new_repositories": "Nieuwe Repositories",
        "new_repositories_note": "Je hebt meer dan 10 nieuwe repositories die hier worden weergegeven, als je ze allemaal wilt wissen, klik dan op de 3 puntjes in de rechterbovenhoek en wijs ze af.",
        "no_repositories": "Geen repositories",
        "no_repositories_desc1": "Het lijkt erop dat je nog geen repositories hebt geïnstalleerd in deze sectie.",
        "no_repositories_desc2": "Klik op de + in de benedenhoek om je eerste toe te voegen!",
        "no_repositories_found_desc1": "Er zijn geen geïnstalleerde repositories die overeenkomen met {searchInput}\" in deze sectie.",
        "no_repositories_found_desc2": "Probeer iets anders te zoeken!",
        "pending_upgrades": "Upgrades in afwachting",
        "placeholder_search": "Typ iets om te zoeken...",
        "sort": "sorteer",
        "stars": "Sterren",
        "status": "Status"
      },
      "time": {
        "ago": "geleden",
        "day": "dag",
        "days": "dagen",
        "hour": "uur",
        "hours": "uren",
        "minute": "minuut",
        "minutes": "minuten",
        "month": "maand",
        "months": "maanden",
        "one": "Eén",
        "one_day_ago": "een dag geleden",
        "one_hour_ago": "een uur geleden",
        "one_minute_ago": "een minuut geleden",
        "one_month_ago": "een maand geleden",
        "one_second_ago": "een seconde geleden",
        "one_year_ago": "een jaar geleden",
        "second": "seconde",
        "seconds": "seconden",
        "x_days_ago": "{x} dagen geleden",
        "x_hours_ago": "{x} uur geleden",
        "x_minutes_ago": "{x} minuten geleden",
        "x_months_ago": "{x} maanden geleden",
        "x_seconds_ago": "{x} seconden geleden",
        "x_years_ago": "{x} jaar geleden",
        "year": "jaar",
        "years": "jaren"
      }
    },
    "nn": {
      "common": {
        "about": "Om",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "AppDeamon-appar",
        "appdaemon_plural": "AppDaemon-appar",
        "background_task": "Bakgrunnsoppgåve køyrer. Denne sida kjem til å laste seg omatt når ho er ferdig.",
        "check_log_file": "Sjå i loggfila di for meir detaljar.",
        "continue": "Hald fram",
        "disabled": "Deaktivert",
        "documentation": "Dokumentasjon",
        "element": "element",
        "hacs_is_disabled": "HACS er deaktivert",
        "installed": "Installert",
        "integration": "Integrasjon",
        "integration_plural": "Integrasjonar",
        "integrations": "Integrasjonar",
        "lovelace": "Lovelace",
        "lovelace_element": "Lovelace-element",
        "lovelace_elements": "Lovelace-element",
        "manage": "Handtere",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDeamon-appar",
        "netdaemon_plural": "NetDaemon-appar",
        "plugin": "Lovelace",
        "plugin_plural": "Lovelace-element",
        "plugins": "Lovelace-element",
        "python_script": "Pythonskript",
        "python_script_plural": "Pythonskript",
        "python_scripts": "Pythonskript",
        "repositories": "Repositories",
        "settings": "innstillingar",
        "theme": "Tema",
        "theme_plural": "Tema",
        "themes": "Tema",
        "version": "Versjon"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Berre éin enkelt konfigurasjon av HACS er tillete."
        },
        "error": {
          "auth": "Personleg tilgangsnøkkel er ikkje korrekt."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Aktiver AppDeamon-appar-oppdaging og sporing",
              "netdaemon": "Aktiver NetDeamon-appar-oppdaging og sporing",
              "python_script": "Aktiver pythonscript-oppdaging og sporing",
              "sidepanel_icon": "Sidepanelikon",
              "sidepanel_title": "Sidepaneltittel",
              "theme": "Aktiver tema-oppdaging og sporing",
              "token": "Personleg GitHub tilgangsnøkkel"
            },
            "description": "Dersom du treng hjelp med konfigurasjonen, ta ein kik her: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Er du sikker på at du vil legge til dette i Lovelace-ressursane dine?",
        "bg_task": "Handlinga er deaktivert medan bakgrunnsoppgåveene køyrer.",
        "cancel": "Avbryt",
        "continue": "Er du sikker på at du vil halde fram?",
        "delete": "Er du sikker på at du vil slette '{item}'?",
        "delete_installed": "'{item}' er installert. Du må avinstallere det før du kan slette det.",
        "exist": "{item} eksisterer allereie",
        "generic": "Er du sikker?",
        "home_assistant_is_restarting": "Vent... Home Assistant starter på nytt no.",
        "home_assistant_version_not_correct": "Du køyrer Home Assistant-versjonen '{haversion}', men dette kodedepoet krev minst versjon '{minversion}' for å bli installert.",
        "no": "Nei",
        "no_upgrades": "Ingen ventande oppgradringer",
        "ok": "OK",
        "overwrite": "Ved å gjere dette kjem du til å overskrive.",
        "reload_data": "Dette laster inn dataa til depota HACS veit om, og dette vil ta litt tid å fullføre.",
        "restart_home_assistant": "Er du sikker på at du vil starte Home Assistant på nytt?",
        "uninstall": "Er du sikker på at du vil avinstallere '{item}'?",
        "upgrade_all": "Dette kjem til å oppgradere alle depota. Ver sikker på at du har lest alle versjonsmerknadene før du held fram.",
        "yes": "Ja"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Aktiver AppDeamon-appar-oppdaging og sporing",
              "country": "Filterer med landskode",
              "debug": "Aktiver debug.",
              "experimental": "Aktiver ekspreimentelle funksjonar",
              "netdaemon": "Aktiver NetDeamon-appar-oppdaging og sporing",
              "not_in_use": "Kan ikkje brukast saman med YAML",
              "release_limit": "Talet på utgivingar",
              "sidepanel_icon": "Sidepanelikon",
              "sidepanel_title": "Sidepaneltittel"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Denne integrasjonen støttar config_flow, som betyr at du no kan gå til integrasjonssida i brukargrensesnittet for å konfigurere den.",
        "config_flow_title": "UI-konfigurasjon støtta",
        "integration_not_loaded": "Integrasjonen er ikkje lasta inn i Home Assistant.",
        "no_restart_required": "Ingen omstart kravd",
        "not_loaded": "Ikkje lasta",
        "plugin_not_loaded": "Tillegget er ikkje lagt til i Lovelace-ressursane dine.",
        "restart": "Du må starte Home Assistant på nytt",
        "restart_pending": "Omstart venter"
      },
      "repository": {
        "add_to_lovelace": "Legg til i Lovelace",
        "authors": "Forfatter(e)",
        "available": "Tilgjengeleg",
        "back_to": "Tilbake til",
        "changelog": "Endre logg",
        "downloads": "Nedlastinger",
        "flag_this": "Marker dette",
        "frontend_version": "Frontend-versjon",
        "github_stars": "GitHub-stjerner",
        "goto_integrations": "Gå til integrasjonar",
        "hide": "Gøym",
        "hide_beta": "Gøym beta",
        "install": "Installer",
        "installed": "Installert",
        "lovelace_copy_example": "Kopier eksempelet til utklippsbreittet ditt",
        "lovelace_instruction": "Når du legg til dette i Lovelace-konfigurasjonen din, bruk dette",
        "lovelace_no_js_type": "Kunne ikkje slå fast typen til dette tilegget. Sjå i repositoryet.",
        "newest": "nyaste",
        "note_appdaemon": "du må framleis legge dette til i \"apps.yaml\"-fila di",
        "note_installed": "Når dette er installert, kjem den til å vere plassert i",
        "note_integration": "du må framleis legge dette til i \"configuration.yaml\"-fila di",
        "note_plugin": "du må framleis dette til i Lovelace-konfigurasjonen (\"ui-lovelace.yaml\" eller i rå-brukargrensesnittredigeraren",
        "note_plugin_post_107": "du må framleis legge dette til i lovelace-konfigurasjonen ('configuration.yaml' eller i kjelderedigeraren ''/config/lovelace/resources')",
        "open_issue": "Opne problem",
        "open_plugin": "Opne tillegg",
        "reinstall": "Installer på nytt",
        "repository": "Repository",
        "restart_home_assistant": "Start Home Assistant på nytt",
        "show_beta": "Vis beta",
        "uninstall": "Avinstaller",
        "update_information": "Oppdater informasjonen",
        "upgrade": "Oppdater"
      },
      "sections": {
        "about": {
          "description": "Vis informasjon om HACS",
          "title": "Om"
        },
        "automation": {
          "description": "Her finn du python_scripts, AppDaemon-appar og NetDaemon-appar",
          "title": "Automasjon"
        },
        "frontend": {
          "description": "Her finn du tema, eigendefinerte kort og andre element for lovelace",
          "title": "Frontend"
        },
        "integrations": {
          "description": "Her finn du eigendefinerte ingtegrasjonar (custom_components)",
          "title": "Integrasjonar"
        },
        "pending_repository_upgrade": "Du køyrer versjon {installed}, og versjon {available} er tilgjengeleg"
      },
      "settings": {
        "add_custom_repository": "LEGG TIL EIN ANNAN REPOSITORY",
        "adding_new_repo": "Legger til ny repository '{repo}'",
        "adding_new_repo_category": "Med kategori '{category}'.",
        "bg_task_custom": "Custom repositories er skjult medan bakgrunnsoppgaver køyrer.",
        "category": "Kategori",
        "compact_mode": "Kompaktmodus",
        "custom_repositories": "VANLEG REPOSITORY",
        "delete": "Slett",
        "display": "Vis",
        "grid": "rutenett",
        "hacs_repo": "HACS repo",
        "hidden_repositories": "gøymde repositories",
        "missing_category": "Du må velje éin kategori",
        "open_repository": "Opne repository",
        "reload_data": "Last om dataa",
        "reload_window": "Last inn vindauget på nytt",
        "repository_configuration": "Repository-konfigurasjon",
        "save": "Lagre",
        "table": "Tavle",
        "table_view": "Tabellvisning",
        "unhide": "vis",
        "upgrade_all": "Oppdater alle"
      },
      "store": {
        "ascending": "stigande",
        "clear_new": "Fjern alle nye repositories",
        "descending": "synkande",
        "last_updated": "Sist oppdatert",
        "name": "Namn",
        "new_repositories": "Ny repository",
        "pending_upgrades": "Ventande oppgraderinger",
        "placeholder_search": "Ver vennleg og skriv inn ei søkefrase",
        "sort": "Sorter",
        "stars": "Stjerner",
        "status": "Status"
      },
      "time": {
        "ago": "sidan",
        "day": "dag",
        "days": "dagar",
        "hour": "time",
        "hours": "timar",
        "minute": "minutt",
        "minutes": "minutt",
        "month": "månad",
        "months": "månadar",
        "one": "Éin",
        "one_day_ago": "for éin dag sidan",
        "one_hour_ago": "éin time sidan",
        "one_minute_ago": "eitt minutt sidan",
        "one_month_ago": "ein månad sidan",
        "one_second_ago": "eitt sekund sidan",
        "one_year_ago": "eitt år sidan",
        "second": "sekund",
        "seconds": "sekund",
        "x_days_ago": "{x} dagar siden",
        "x_hours_ago": "{x} timer sidan",
        "x_minutes_ago": "{x} minutt sidan",
        "x_months_ago": "{x} månadar sidan",
        "x_seconds_ago": "{x} sekund sidan",
        "x_years_ago": "{x} år sidan",
        "year": "år",
        "years": "år"
      }
    },
    "pl": {
      "common": {
        "about": "O",
        "add": "dodaj",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "Aplikacje AppDaemon",
        "appdaemon_plural": "Aplikacje AppDaemon",
        "background_task": "Wykonywanie zadania w tle, ta strona zostanie odświeżona, gdy zadanie zostanie ukończone.",
        "check_log_file": "Sprawdź plik dziennika, aby uzyskać więcej informacji.",
        "continue": "Kontynuuj",
        "disabled": "Wyłączony",
        "documentation": "Dokumentacja",
        "element": "element",
        "hacs_is_disabled": "HACS jest wyłączony",
        "ignore": "Ignoruj",
        "install": "Zainstaluj",
        "installed": "zainstalowane",
        "integration": "Integracja",
        "integration_plural": "Integracje",
        "integrations": "Integracje",
        "lovelace": "Lovelace",
        "lovelace_element": "Element Lovelace",
        "lovelace_elements": "Elementy Lovelace",
        "manage": "zarządzaj",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "Aplikacje NetDaemon",
        "netdaemon_plural": "Aplikacje NetDaemon",
        "plugin": "Lovelace",
        "plugin_plural": "Elementy Lovelace",
        "plugins": "Elementy Lovelace",
        "python_script": "Skrypt Python",
        "python_script_plural": "Skrypty języka Python",
        "python_scripts": "Skrypty Python",
        "repositories": "Repozytoria",
        "repository": "Repozytorium",
        "settings": "ustawienia",
        "theme": "Motyw",
        "theme_plural": "Motywy",
        "themes": "Motywy",
        "uninstall": "Odinstaluj",
        "update": "Uaktualnij",
        "version": "Wersja"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Dozwolona jest tylko jedna konfiguracja HACS."
        },
        "error": {
          "auth": "Osobisty token dostępu jest nieprawidłowy."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Włącz wykrywanie i śledzenie aplikacji AppDaemon",
              "netdaemon": "Włącz wykrywanie i śledzenie aplikacji NetDaemon",
              "python_script": "Włącz wykrywanie i śledzenie skryptów Python",
              "sidepanel_icon": "Ikona w panelu bocznym",
              "sidepanel_title": "Tytuł w panelu bocznym",
              "theme": "Włącz wykrywanie i śledzenie motywów",
              "token": "Osobisty token dostępu GitHub"
            },
            "description": "Jeśli potrzebujesz pomocy w konfiguracji, przejdź na stronę: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Na pewno chcesz dodać to do swoich zasobów Lovelace?",
        "bg_task": "Akcja jest wyłączona podczas wykonywania zadań w tle.",
        "cancel": "Anuluj",
        "continue": "Na pewno chcesz kontynuować?",
        "delete": "Na pewno chcesz usunąć '{item}'?",
        "delete_installed": "'{item}' jest zainstalowany, musisz go odinstalować zanim będziesz mógł go usunąć.",
        "exist": "{item} już istnieje",
        "generic": "Jesteś pewny?",
        "home_assistant_is_restarting": "Poczekaj, Home Assistant jest teraz ponownie uruchamiany.",
        "home_assistant_version_not_correct": "Używasz Home Assistant'a w wersji '{haversion}', a to repozytorium wymaga wersji minimum '{minversion}'.",
        "no": "Nie",
        "no_upgrades": "Brak oczekujących aktualizacji",
        "ok": "Ok",
        "overwrite": "Spowoduje to zastąpienie istniejącej kopii.",
        "reload_data": "To przeładowuje dane wszystkich repozytoriów, o których wie HACS, może to trochę potrwać.",
        "restart_home_assistant": "Na pewno chcesz ponownie uruchomić Home Assistant'a?",
        "uninstall": "Na pewno chcesz odinstalować '{item}'?",
        "upgrade_all": "To uaktualni wszystkie te repozytoria, upewnij się, że przeczytałeś uwagi do wydania dla wszystkich z nich przed kontynuacją.",
        "yes": "Tak"
      },
      "dialog_about": {
        "frontend_version": "Wersja interfejsu użytkownika",
        "installed_repositories": "Zainstalowane repozytoria",
        "integration_version": "Wersja integracji",
        "useful_links": "Przydatne linki"
      },
      "dialog_add_repo": {
        "limit": "Wyświetlanych jest tylko pierwszych 100 repozytoriów, użyj wyszukiwania, aby przefiltrować potrzebne informacje",
        "no_match": "Nie znaleziono repozytoriów pasujących do filtra",
        "sort_by": "Sortuj według",
        "title": "Dodawanie repozytorium"
      },
      "dialog_custom_repositories": {
        "category": "Kategoria",
        "no_category": "Brak kategorii",
        "no_repository": "Brak repozytorium",
        "title": "Niestandardowe repozytoria",
        "url_placeholder": "Adres URL niestandardowego repozytorium"
      },
      "dialog_info": {
        "author": "Autor",
        "downloads": "Ilość pobrań",
        "install": "Zainstaluj to repozytorium w HACS",
        "loading": "Pobieranie informacji...",
        "no_info": "Deweloper nie dostarczył więcej informacji na temat tego repozytorium",
        "open_issues": "Problemy",
        "open_repo": "Otwórz repozytorium",
        "stars": "Gwiazdki",
        "version_installed": "Wersja zainstalowana"
      },
      "dialog_install": {
        "restart": "Pamiętaj, że musisz ponownie uruchomić Home Assistanta by zastosować zmiany w integracjach (custom_components).",
        "select_version": "Wybierz wersję",
        "show_beta": "Wyświetl wydania beta",
        "type": "Typ",
        "url": "URL"
      },
      "dialog_removed": {
        "link": "Link zewnętrzny do dodatkowych informacji",
        "name": "Nazwa repozytorium",
        "reason": "Powód usunięcia",
        "type": "Rodzaj usunięcia"
      },
      "dialog_update": {
        "available_version": "Dostępna wersja",
        "changelog": "Lista zmian",
        "installed_version": "Zainstalowana wersja",
        "releasenotes": "Informacje o {release}",
        "title": "Dostępna aktualizacja"
      },
      "entry": {
        "information": "Informacje",
        "intro": "Aktualizacje i ważne komunikaty będą wyświetlane w tym miejscu",
        "messages": {
          "disabled": {
            "content": "Sprawdź log, aby uzyskać więcej informacji",
            "title": "HACS jest wyłączony"
          },
          "has_pending_tasks": {
            "content": "Dopóki nie zostaną zakończone, niektóre repozytoria mogą nie być wyświetlane",
            "title": "Wykonywane są zadania w tle"
          },
          "removed": "Usunięto repozytorium '{repository}'",
          "resources": {
            "content": "Elementy Lovelace, które nie zostały poprawnie załadowane: {number}",
            "title": "Nie załadowano w Lovelace"
          },
          "restart": {
            "content": "Integracje, które wymagają ponownego uruchomienia Home Assistanta: {number}\nMożesz to zrobić w sekcji 'Kontrola serwera' konfiguracji Home Assistanta.",
            "title": "Oczekiwanie na restart"
          },
          "startup": {
            "content": "HACS uruchamia się, w tym czasie może brakować pewnych informacji lub mogą one być nieprawidłowe.",
            "title": "HACS uruchamia się"
          },
          "wrong_frontend_installed": {
            "content": "Masz zainstalowany interfejs HACS w wersji {running}, a wersja {expected} była oczekiwana. Komunikat ten oznacza, że Home Assistant nie mógł zainstalować nowej wersji interfejsu HACS, spróbuj ponownie uruchomić Home Assistanta.",
            "title": "Nieoczekiwana wersja interfejsu"
          },
          "wrong_frontend_loaded": {
            "content": "Używasz wersji {running} interfejsu HACS, a wersja {expected} była oczekiwana, powinieneś wyczyścić pamięć podręczną przeglądarki.",
            "title": "Nieoczekiwana wersja interfejsu"
          }
        },
        "pending_updates": "Oczekujące aktualizacje"
      },
      "menu": {
        "about": "O HACS",
        "clear": "Wyczyść oznaczenia nowych",
        "custom_repositories": "Niestandardowe repozytoria",
        "dismiss": "Odrzuć wszystkie nowe repozytoria",
        "documentation": "Dokumentacja",
        "open_issue": "Powiadom o problemie",
        "reload": "Załaduj ponownie okno"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Włącz wykrywanie i śledzenie aplikacji AppDaemon",
              "country": "Filtruj według kodu kraju",
              "debug": "Włącz debugowanie.",
              "experimental": "Włącz funkcje eksperymentalne",
              "netdaemon": "Włącz wykrywanie i śledzenie aplikacji NetDaemon",
              "not_in_use": "Nieużywany z YAML",
              "release_limit": "Liczba wydań do wyświetlenia",
              "sidepanel_icon": "Ikona w panelu bocznym",
              "sidepanel_title": "Tytuł w panelu bocznym"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Ta integracja obsługuje config_flow, co oznacza, że możesz teraz przejść do sekcji integracji w interfejsie użytkownika, aby ją skonfigurować.",
        "config_flow_title": "Obsługiwana konfiguracja poprzez interfejs użytkownika",
        "integration_not_loaded": "Ta integracja nie jest załadowana do Home Assistant'a.",
        "no_restart_required": "Ponowne uruchomienie nie jest wymagane",
        "not_loaded": "Nie załadowano",
        "plugin_not_loaded": "Ta wtyczka nie jest dodana do zasobów Lovelace.",
        "restart": "Musisz ponownie uruchomić Home Assistant'a.",
        "restart_pending": "Oczekiwanie na ponowne uruchomienie"
      },
      "repository_card": {
        "dismiss": "odrzuć",
        "hide": "Ukryj",
        "information": "Informacje",
        "new_repository": "Nowe repozytorium",
        "not_loaded": "Nie załadowano",
        "open_issue": "Powiadom o problemie",
        "open_source": "Otwarte źródło",
        "pending_restart": "Oczekiwanie na restart",
        "pending_update": "Oczekująca aktualizacja",
        "reinstall": "Przeinstaluj",
        "report": "Zgłoś do usunięcia",
        "update_information": "Uaktualnij dane"
      },
      "repository": {
        "add_to_lovelace": "Dodaj do Lovelace",
        "authors": "Autorzy",
        "available": "Dostępna",
        "back_to": "Wróć do",
        "changelog": "Lista zmian",
        "downloads": "Ilość pobrań",
        "flag_this": "Oflaguj",
        "frontend_version": "Wersja frontendu",
        "github_stars": "Gwiazdki GitHub",
        "goto_integrations": "Przejdź do integracji",
        "hide": "Ukryj",
        "hide_beta": "Ukryj wydania beta",
        "install": "Zainstaluj",
        "installed": "Zainstalowano",
        "lovelace_copy_example": "Skopiuj przykład do schowka",
        "lovelace_instruction": "Interfejs użytkownika użyje tej wtyczki po dodaniu konfiguracji",
        "lovelace_no_js_type": "Nie można określić typu tej wtyczki, sprawdź repozytorium.",
        "newest": "najnowsza",
        "note_appdaemon": "musisz jeszcze dodać aplikację do pliku 'apps.yaml'",
        "note_installed": "Po zainstalowaniu dodatek będzie znajdować się w",
        "note_integration": "musisz jeszcze dodać integrację do pliku 'configuration.yaml'",
        "note_plugin": "musisz jeszcze dodać wtyczkę do konfiguracji interfejsu użytkownika (plik 'ui-lovelace.yaml' lub edytor interfejsu użytkownika)",
        "note_plugin_post_107": "nadal musisz dodać go do konfiguracji Lovelace ('configuration.yaml' lub edytora zasobów '/config/lovelace/resources')",
        "open_issue": "Powiadom o problemie",
        "open_plugin": "Otwórz element",
        "reinstall": "Przeinstaluj",
        "repository": "Repozytorium",
        "restart_home_assistant": "Uruchom ponownie Home Assistant'a",
        "show_beta": "Wyświetl wydania beta",
        "uninstall": "Odinstaluj",
        "update_information": "Uaktualnij dane",
        "upgrade": "Uaktualnij"
      },
      "search": {
        "installed": "Wyszukaj zainstalowane repozytoria",
        "installed_new": "Wyszukaj zainstalowane lub nowe repozytoria",
        "placeholder": "Wyszukaj repozytorium"
      },
      "sections": {
        "about": {
          "description": "Informacje o HACS",
          "title": "O HACS"
        },
        "automation": {
          "description": "Skrypty Pythona, aplikacje AppDaemon i NetDaemon",
          "title": "Automatyzacje"
        },
        "frontend": {
          "description": "Motywy, niestandardowe karty i inne elementy interfejsu użytkownika",
          "title": "Interfejs użytkownika"
        },
        "integrations": {
          "description": "Niestandardowe integracje (custom_components)",
          "title": "Integracje"
        },
        "pending_repository_upgrade": "Używasz wersji {installed}, wersja {available} jest dostępna"
      },
      "settings": {
        "add_custom_repository": "DODAJ REPOZYTORIUM NIESTANDARDOWE",
        "adding_new_repo": "Dodawanie nowego repozytorium '{repo}'",
        "adding_new_repo_category": "Z kategorią '{category}'.",
        "bg_task_custom": "Niestandardowe repozytoria są ukryte podczas wykonywania zadań w tle.",
        "category": "Kategoria",
        "compact_mode": "Tryb kompaktowy",
        "custom_repositories": "REPOZYTORIA NIESTANDARDOWE",
        "delete": "Usuń",
        "display": "Sposób wyświetlania",
        "grid": "Siatka",
        "hacs_repo": "Repozytorium HACS",
        "hidden_repositories": "ukryte repozytoria",
        "missing_category": "Musisz wybrać kategorię",
        "open_repository": "Otwórz repozytorium",
        "reload_data": "Wczytaj ponownie dane",
        "reload_window": "Załaduj ponownie okno",
        "repository_configuration": "Konfiguracja repozytorium",
        "save": "Zapisz",
        "table": "tabela",
        "table_view": "Widok tabeli",
        "unhide": "pokaż",
        "upgrade_all": "Uaktualnij wszystkie"
      },
      "store": {
        "ascending": "rosnąco",
        "clear_new": "Wyczyść wszystkie nowe repozytoria",
        "descending": "malejąco",
        "last_updated": "Ostatnia aktualizacja",
        "name": "Nazwa",
        "new_repositories": "Nowe repozytoria",
        "new_repositories_note": "Jest ponad 10 nowych repozytoriów, jeśli chcesz je wyczyścić, kliknij menu z trzema kropkami w prawym górnym rogu i odrzuć je wszystkie.",
        "no_repositories": "Brak repozytoriów",
        "no_repositories_desc1": "Wygląda na to, że nie masz jeszcze zainstalowanych repozytoriów w tej sekcji.",
        "no_repositories_desc2": "Kliknij + w dolnym rogu, aby dodać pierwsze!",
        "no_repositories_found_desc1": "W tej sekcji nie znaleziono zainstalowanych repozytoriów pasujących do \"{searchInput}\".",
        "no_repositories_found_desc2": "Spróbuj wyszukać czegoś innego!",
        "pending_upgrades": "Oczekujące aktualizacje",
        "placeholder_search": "Wprowadź wyszukiwane hasło...",
        "sort": "sortowanie",
        "stars": "Gwiazdki",
        "status": "Status"
      },
      "time": {
        "ago": "temu",
        "day": "dzień",
        "days": "dni",
        "hour": "godzina",
        "hours": "godziny",
        "minute": "minuta",
        "minutes": "minuty",
        "month": "miesiąc",
        "months": "miesięcy",
        "one": "Jeden",
        "one_day_ago": "jeden dzień temu",
        "one_hour_ago": "jedna godzina temu",
        "one_minute_ago": "jedna minuta temu",
        "one_month_ago": "jeden miesiąc temu",
        "one_second_ago": "jedna sekunda temu",
        "one_year_ago": "jeden rok temu",
        "second": "sekunda",
        "seconds": "sekundy",
        "x_days_ago": "{x} dni temu",
        "x_hours_ago": "{x} godzin(y) temu",
        "x_minutes_ago": "{x} minut(y) temu",
        "x_months_ago": "{x} miesi(ące/ęcy) temu",
        "x_seconds_ago": "{x} sekund(y) temu",
        "x_years_ago": "{x} lat(a) temu",
        "year": "rok",
        "years": "lata"
      }
    },
    "pt-BR": {
      "common": {
        "about": "Sobre",
        "add": "adicionar",
        "appdaemon": "AppDaemon",
        "appdaemon_apps": "Aplicativos AppDaemon",
        "appdaemon_plural": "Aplicativos AppDaemon",
        "background_task": "Tarefa em segundo plano em execução, esta página será recarregada quando terminar.",
        "check_log_file": "Verifique seu arquivo de log para obter mais detalhes.",
        "continue": "Continuar",
        "disabled": "Desativado",
        "documentation": "Documentação",
        "element": "elemento",
        "hacs_is_disabled": "HACS está desativado",
        "install": "Instalar",
        "installed": "instalado",
        "integration": "Integração",
        "integration_plural": "Integrações",
        "integrations": "Integrações",
        "lovelace": "Lovelace",
        "lovelace_element": "Elemento do Lovelace",
        "lovelace_elements": "Elementos do lovelace",
        "manage": "gerenciar",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "NetDaemon Apps",
        "netdaemon_plural": "Aplicativos NetDaemon",
        "plugin": "Lovelace",
        "plugin_plural": "Elementos do Lovelace",
        "plugins": "Elementos do Lovelace",
        "python_script": "Script Python",
        "python_script_plural": "Scripts python",
        "python_scripts": "Scripts python",
        "repositories": "Repositórios",
        "repository": "Repositório",
        "settings": "configurações",
        "theme": "Tema",
        "theme_plural": "Temas",
        "themes": "Temas",
        "uninstall": "Desinstalar",
        "update": "Atualizar",
        "version": "Versão"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Apenas uma configuração do HACS é permitida."
        },
        "error": {
          "auth": "Token de acesso pessoal incorreto."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Habilitar descoberta & rastreamento de apps AppDaemon",
              "netdaemon": "Habilitar NetDaemon apps descoberta & rastreamento",
              "python_script": "Habilitar descoberta & rastreamento de python_scripts",
              "sidepanel_icon": "Icone do painel lateral",
              "sidepanel_title": "Titulo do painel lateral",
              "theme": "Habilitar descoberta & rastreamento de temas",
              "token": "Token de acesso pessoal do GitHub"
            },
            "description": "Se você preciar de ajuda com a configuração olhe aqui: https://hacs.xyz/docs/configuration/start",
            "title": "HACS (Home Assistant Community Store)"
          }
        },
        "title": "HACS (Home Assistant Community Store)"
      },
      "confirm": {
        "add_to_lovelace": "Tem certeza de que deseja adicionar isso aos seus recursos do Lovelace?",
        "bg_task": "A ação é desativada enquanto as tarefas de fundo estão sendo executadas.",
        "cancel": "Cancelar",
        "continue": "Tem certeza que quer continuar?",
        "delete": "Tem certeza de que deseja excluir '{item}'?",
        "delete_installed": "'{item}' está instalado, é necessário desinstalá-lo para poder excluí-lo.",
        "exist": "{item} já existe",
        "generic": "Tem certeza?",
        "home_assistant_is_restarting": "Espere, o Home Assistant está agora a reiniciar.",
        "home_assistant_version_not_correct": "Você está executando a versão Home Assistant '{haversion}', mas este repositório requer que a versão mínima '{minversion}' esteja instalada.",
        "no": "Não",
        "no_upgrades": "Não há atualizações pendentes",
        "ok": "OK",
        "overwrite": "Fazer isso irá substituí-lo.",
        "reload_data": "Isso recarrega os dados de todos os repositórios que o HACS conhece e levará algum tempo para concluir.",
        "restart_home_assistant": "Tem certeza de que deseja reiniciar o Home Assistant?",
        "uninstall": "Tem certeza de que deseja desinstalar '{item}'?",
        "upgrade_all": "Isso atualizará todos esses repositórios, verifique se você leu as notas de versão de todos eles antes de continuar.",
        "yes": "Sim"
      },
      "dialog_about": {
        "frontend_version": "Versão do frontend",
        "installed_repositories": "Repositórios instalados",
        "integration_version": "Versão da integração",
        "useful_links": "Links úteis"
      },
      "dialog_add_repo": {
        "limit": "Apenas os 100 primeiros repositórios são mostrados, use a pesquisa para filtrar o que você precisa",
        "no_match": "Nenhum repositório encontrado correspondente ao seu filtro",
        "sort_by": "Ordenar por",
        "title": "Novo repositório"
      },
      "dialog_custom_repositories": {
        "category": "Categoria",
        "no_category": "Categoria ausente",
        "no_repository": "Repositório ausente",
        "title": "Repositórios personalizados",
        "url_placeholder": "Adicionar URL de repositório personalizado"
      },
      "dialog_info": {
        "author": "Autor",
        "downloads": "Downloads",
        "install": "Instalar esse repositório no HACS",
        "loading": "Carregando informações...",
        "no_info": "O desenvolvedor não forneceu mais informações para este repositório",
        "open_issues": "Problemas em aberto",
        "open_repo": "Abrir repositório",
        "stars": "Estrelas",
        "version_installed": "Versão instalada"
      },
      "dialog_install": {
        "restart": "Lembre-se de que você precisa reiniciar o Home Assistant para que as alterações nas integrações (custom_components) sejam aplicadas.",
        "select_version": "Selecionar versão",
        "show_beta": "Mostrar versões beta",
        "type": "Tipo",
        "url": "URL"
      },
      "dialog_update": {
        "available_version": "Versão disponível",
        "changelog": "Registro de mudanças",
        "installed_version": "Versão instalada",
        "releasenotes": "Notas de lançamento para {release}",
        "title": "Atualização pendente"
      },
      "entry": {
        "information": "Informações",
        "intro": "Atualizações e mensagens importantes serão mostradas aqui se houver",
        "messages": {
          "disabled": {
            "content": "Verifique seu arquivo de log para mais detalhes.",
            "title": "O HACS está desativado"
          },
          "has_pending_tasks": {
            "content": "Alguns repositórios podem não aparecer até que isso seja concluído",
            "title": "Tarefas em segundo plano pendentes"
          },
          "resources": {
            "content": "Tem {número} elementos do Lovelace que não são carregados corretamente no Lovelace.",
            "title": "Não carregado em Lovelace"
          },
          "restart": {
            "content": "Tem {número} integrações que requerem um reinício do Home Assistant. Você pode fazer isso na seção 'Controles do Servidor' na parte de configuração do Home Assistant UI.",
            "title": "Reinicialização pendente"
          },
          "startup": {
            "content": "O HACS está sendo iniciado, durante esse período algumas informações podem estar ausentes ou incorretas",
            "title": "O HACS está iniciando"
          },
          "wrong_frontend_installed": {
            "content": "Você instalou a versão {running} do frontend HACS, mas a versão {expected} era esperada. Se você vir esta mensagem, o Home Assistant não conseguiu instalar a nova versão. Por favor tente reiniciar o Home Assistant.",
            "title": "Versão frontend inesperada"
          },
          "wrong_frontend_loaded": {
            "content": "Você está executando a versão {running} do frontend HACS, mas a versão {expected} era esperada. Por favor limpe o cache do seu navegador.",
            "title": "Versão frontend inesperada"
          }
        },
        "pending_updates": "Atualizações pendentes"
      },
      "menu": {
        "about": "Sobre o HACS",
        "clear": "Limpar todos os novos",
        "custom_repositories": "Repositórios personalizados",
        "dismiss": "Limpar todos os novos repositórios",
        "documentation": "Documentação",
        "open_issue": "Relatar problema",
        "reload": "Recarregar janela"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Habilitar AppDaemon apps descoberta & rastreamento",
              "country": "Filtrar pelo código do país.",
              "debug": "Ative a depuração.",
              "experimental": "Ativar recursos experimentais",
              "netdaemon": "Habilitar NetDaemon apps descoberta & rastreamento",
              "not_in_use": "Não está em uso com o YAML",
              "release_limit": "Número de lançamentos a serem exibidos.",
              "sidepanel_icon": "Icone do painel lateral",
              "sidepanel_title": "Titulo do painel lateral"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Essa integração oferece suporte ao config_flow, o que significa que agora você pode acessar a seção de integração da sua interface do usuário para configurá-lo.",
        "config_flow_title": "Configuração de interface do usuário suportada",
        "integration_not_loaded": "Esta integração não está carregada no Home Assistant.",
        "no_restart_required": "Não é necessário reiniciar",
        "not_loaded": "Não carregado",
        "plugin_not_loaded": "Este elemento não é adicionado aos seus recursos do Lovelace.",
        "restart": "Você precisa reiniciar o Home Assistant.",
        "restart_pending": "Reinicialização pendente"
      },
      "repository_card": {
        "dismiss": "Dispensar",
        "hide": "Esconder",
        "information": "Informações",
        "new_repository": "Novo repositório",
        "not_loaded": "Não carregado",
        "open_issue": "Relatar problema",
        "open_source": "Código aberto",
        "pending_restart": "Reinicialização pendente",
        "pending_update": "Atualização pendente",
        "reinstall": "Reinstalar",
        "report": "Denunciar para remoção",
        "update_information": "Atualizar informações"
      },
      "repository": {
        "add_to_lovelace": "Adicionar a Lovelace",
        "authors": "Autores",
        "available": "Disponível",
        "back_to": "Voltar para",
        "changelog": "Changelog",
        "downloads": "Downloads",
        "flag_this": "Sinalizar isso",
        "frontend_version": "Versão Frontend",
        "github_stars": "Estrelas de GitHub",
        "goto_integrations": "Ir para integrações",
        "hide": "Esconder",
        "hide_beta": "Esconder beta",
        "install": "Instalar",
        "installed": "Instalado",
        "lovelace_copy_example": "Copie este exemplo para seu clipboard",
        "lovelace_instruction": "Quando você adicionar isso à sua configuração do lovelace, use este",
        "lovelace_no_js_type": "Não foi possível determinar o tipo desse elemento, verifique o repositório.",
        "newest": "O mais novo",
        "note_appdaemon": "Você ainda precisa adicioná-lo ao seu arquivo 'apps.yaml'",
        "note_installed": "Quando instalado, ele estará localizado em",
        "note_integration": "Você ainda precisa adicioná-lo ao seu arquivo 'configuration.yaml'",
        "note_plugin": "você ainda precisará adicioná-lo à sua configuração do lovelace ('ui-lovelace.yaml' ou o editor de configuração da interface do usuário)",
        "note_plugin_post_107": "você ainda precisará adicioná-lo à sua configuração do lovelace ('configuration.yaml' ou o editor de recursos '/config /lovelace/resources')",
        "open_issue": "Open issue",
        "open_plugin": "Elemento aberto",
        "reinstall": "Reinstalar",
        "repository": "Repositório",
        "restart_home_assistant": "Reiniciar Home Assistant",
        "show_beta": "Mostrar beta",
        "uninstall": "Desinstalar",
        "update_information": "Atualizar informação",
        "upgrade": "Melhorar"
      },
      "search": {
        "installed": "Procure repositórios instalados",
        "installed_new": "Procure repositórios instalados ou novos",
        "placeholder": "Procurar repositório"
      },
      "sections": {
        "about": {
          "description": "Exibir informações sobre o HACS",
          "title": "Sobre"
        },
        "automation": {
          "description": "É aqui que você encontra python_scripts, aplicativos AppDaemon e aplicativos NetDaemon",
          "title": "Automação"
        },
        "frontend": {
          "description": "É aqui que você encontra temas, cartões personalizados e outros elementos para o lovelace",
          "title": "Frontend"
        },
        "integrations": {
          "description": "É aqui que você encontra integrações personalizadas (custom_components)",
          "title": "Integrações"
        },
        "pending_repository_upgrade": "Você está executando a versão {installed}, a versão {available} está disponível"
      },
      "settings": {
        "add_custom_repository": "ADICIONAR REPOSITÓRIO PERSONALIZADO",
        "adding_new_repo": "Adicionando novo repositório '{repo}'",
        "adding_new_repo_category": "Com a categoria '{category}'.",
        "bg_task_custom": "Os repositórios personalizados ficam ocultos enquanto as tarefas de fundo estão em execução.",
        "category": "Categoria",
        "compact_mode": "Modo compacto",
        "custom_repositories": "REPOSITÓRIOS PERSONALIZADOS",
        "delete": "Deletar",
        "display": "Display",
        "grid": "Grade",
        "hacs_repo": "HACS repo",
        "hidden_repositories": "repositórios ocultos",
        "missing_category": "Você precisa selecionar uma categoria",
        "open_repository": "Repositório aberto",
        "reload_data": "Recarregar dados",
        "reload_window": "Recarregar janela",
        "repository_configuration": "Configuração do Repositório",
        "save": "Salvar",
        "table": "Tabela",
        "table_view": "Vista de mesa",
        "unhide": "reexibir",
        "upgrade_all": "Atualizar tudo"
      },
      "store": {
        "ascending": "ascendente",
        "clear_new": "Limpar todos os novos repositórios",
        "descending": "descendente",
        "last_updated": "Última atualização",
        "name": "Nome",
        "new_repositories": "Novos Repositórios",
        "new_repositories_note": "Você tem mais de 10 novos repositórios sendo mostrados aqui, se quiser limpar todos eles clique nos 3 pontos no canto superior direito e dispense-os.",
        "no_repositories": "Nenhum repositório",
        "no_repositories_desc1": "Parece que você ainda não tem nenhum repositório instalado nesta seção.",
        "no_repositories_desc2": "Clique no + no canto inferior para adicionar o seu primeiro repositório!",
        "no_repositories_found_desc1": "Nenhum repositório instalado foi encontrado que corresponda a \"{searchInput}\" nesta seção.",
        "no_repositories_found_desc2": "Tente procurar por outra coisa!",
        "pending_upgrades": "Atualizações pendentes",
        "placeholder_search": "Por favor insira um termo de pesquisa...",
        "sort": "ordenar",
        "stars": "Estrelas",
        "status": "Status"
      },
      "time": {
        "ago": "atrás",
        "day": "dia",
        "days": "dias",
        "hour": "hora",
        "hours": "horas",
        "minute": "minuto",
        "minutes": "minutos",
        "month": "mês",
        "months": "meses",
        "one": "Um",
        "one_day_ago": "um dia atrás",
        "one_hour_ago": "uma hora atrás",
        "one_minute_ago": "um minuto atrás",
        "one_month_ago": "um mês atrás",
        "one_second_ago": "um segundo atrás",
        "one_year_ago": "um ano atrás",
        "second": "segundo",
        "seconds": "segundos",
        "x_days_ago": "{x} dias atrás",
        "x_hours_ago": "{x} horas atrás",
        "x_minutes_ago": "{x} minutos atrás",
        "x_months_ago": "{x} meses atrás",
        "x_seconds_ago": "{x} segundos atrás",
        "x_years_ago": "{x} anos atrás",
        "year": "ano",
        "years": "anos"
      }
    },
    "pt": {
      "common": {
        "about": "Sobre",
        "add": "adicionar",
        "appdaemon_apps": "Aplicações AppDaemon",
        "appdaemon_plural": "Aplicações AppDaemon",
        "background_task": "Está a ser executada uma tarefa em segundo plano, esta página será recarregada quando terminar.",
        "check_log_file": "Verifique o seu ficheiro de log para obter mais detalhes.",
        "continue": "Continuar",
        "disabled": "Desativado",
        "documentation": "Documentação",
        "element": "elemento",
        "hacs_is_disabled": "HACS está desativado",
        "ignore": "Ignorar",
        "install": "Instalar",
        "installed": "instalado",
        "integration": "Integração",
        "integration_plural": "Integrações",
        "integrations": "Integrações",
        "lovelace": "Lovelace",
        "lovelace_element": "Elemento Lovelace",
        "lovelace_elements": "Elementos Lovelace",
        "manage": "gerir",
        "netdaemon": "NetDaemon",
        "netdaemon_apps": "Aplicações NetDaemon",
        "netdaemon_plural": "Aplicações NetDaemon",
        "plugin": "Lovelace",
        "plugin_plural": "Elementos Lovelace",
        "plugins": "Elementos Lovelace",
        "python_script": "Script Python",
        "python_script_plural": "Scripts Python",
        "python_scripts": "Scripts Python",
        "repositories": "Repositórios",
        "repository": "Repositório",
        "settings": "configurações",
        "theme": "Tema",
        "theme_plural": "Temas",
        "themes": "Temas",
        "uninstall": "Desinstalar",
        "update": "Atualizar",
        "version": "Versão"
      },
      "config": {
        "abort": {
          "single_instance_allowed": "Apenas é permitida uma única configuração do HACS."
        },
        "error": {
          "auth": "O token de acesso pessoal não está correto."
        },
        "step": {
          "user": {
            "data": {
              "appdaemon": "Ativar a localização e o seguimento de aplicações AppDaemon",
              "netdaemon": "Ativar a localização e o seguimento de aplicações NetDaemon",
              "python_script": "Ativar a localização e o seguimento de python_scripts",
              "sidepanel_icon": "Ícone no painel lateral",
              "sidepanel_title": "Título no painel lateral",
              "theme": "Ativar a localização e o seguimento de temas",
              "token": "Token de acesso pessoal do GitHub"
            },
            "description": "Se precisar de ajuda com a configuração, consulte aqui: https://hacs.xyz/docs/configuration/start"
          }
        }
      },
      "confirm": {
        "add_to_lovelace": "Tem certeza que deseja adicionar aos recursos do Lovelace?",
        "bg_task": "Esta ação é desativada enquanto as tarefas em segundo plano estão a ser executadas.",
        "cancel": "Cancelar",
        "continue": "Tem a certeza que deseja continuar?",
        "delete": "Tem a certeza que deseja apagar '{item}'?",
        "delete_installed": "'{item}' está instalado, é preciso desinstalá-lo antes de o poder apagar.",
        "exist": "{item} já existe",
        "generic": "Tem a certeza?",
        "home_assistant_is_restarting": "Aguarde, o Home Assistant está a reiniciar.",
        "home_assistant_version_not_correct": "Está a executar a versão '{haversion}' do Home Assistant, mas este repositório requer a versão mínima '{minversion}' para ser instalado.",
        "no": "Não",
        "no_upgrades": "Não há atualizações pendentes",
        "ok": "OK",
        "overwrite": "Ao fazer esta ação irá substituir o ficheiro atual.",
        "reload_data": "Isto irá recarregar os dados de todos os repositórios que a HACS conhece, irá demorar algum tempo até terminar.",
        "restart_home_assistant": "Tem a certeza que deseja reiniciar o Home Assistant?",
        "uninstall": "Tem a certeza que deseja desinstalar '{item}'?",
        "upgrade_all": "Isto irá actualizar todos estes repositórios, certifique-se de que leu as notas de lançamento de todos antes de continuar.",
        "yes": "Sim"
      },
      "dialog_about": {
        "frontend_version": "Versão Frontend",
        "installed_repositories": "Repositórios instalados",
        "integration_version": "Versão de integração",
        "useful_links": "Links úteis"
      },
      "dialog_add_repo": {
        "limit": "Apenas os 100 primeiros repositórios serão mostrados, use a pesquisa para filtrar o que precisa",
        "no_match": "Não foram encontrados repositórios que correspondam ao filtro",
        "sort_by": "Ordenar por",
        "title": "Adicionar repositório"
      },
      "dialog_custom_repositories": {
        "category": "Categoria",
        "no_category": "Categoria em falta",
        "no_repository": "Repositório em falta",
        "title": "Repositórios personalizados",
        "url_placeholder": "Adicionar URL do repositório personalizado"
      },
      "dialog_info": {
        "author": "Autor",
        "downloads": "Transferências",
        "install": "Instalar este repositório no HACS",
        "loading": "A carregar informações...",
        "no_info": "O developer não forneceu mais informações sobre este repositório",
        "open_issues": "Questões em aberto",
        "open_repo": "Abrir Repositório",
        "stars": "Estrelas",
        "version_installed": "Versão instalada"
      },
      "dialog_install": {
        "restart": "Lembre-se de que é preciso reiniciar o Home Assistant para que as alterações das integrações (custom_components) sejam aplicadas.",
        "select_version": "Selecionar versão",
        "show_beta": "Mostrar versões beta",
        "type": "Tipo",
        "url": "URL"
      },
      "dialog_removed": {
        "link": "Link externo para mais informações",
        "name": "Nome do repositório",
        "reason": "Motivo de remoção",
        "type": "Tipo de remoção"
      },
      "dialog_update": {
        "available_version": "Versão disponível",
        "changelog": "Changelog",
        "installed_version": "Versão instalada",
        "releasenotes": "Notas de lançamento para {release}",
        "title": "Atualização pendente"
      },
      "entry": {
        "information": "Informações",
        "intro": "Atualizações e mensagens importantes serão mostradas aqui",
        "messages": {
          "disabled": {
            "content": "Verifique o seu ficheiro de log para obter mais detalhes",
            "title": "HACS está desativado"
          },
          "has_pending_tasks": {
            "content": "Alguns repositórios podem não aparecer até que isso seja concluído",
            "title": "Tarefas em segundo plano pendentes"
          },
          "removed": "Repositório '{repository}' removido",
          "resources": {
            "content": "Tem {number} elementos que não são carregados corretamente em Lovelace.",
            "title": "Não carregado em Lovelace"
          },
          "restart": {
            "content": "Tem {number} integrações que exigem uma reinicialização do Home Assistant, pode fazer isso a partir da secção 'Controlo do Servidor' na parte de configuração do Home Assistant.",
            "title": "Reinicialização pendente"
          },
          "startup": {
            "content": "O HACS está a iniciar. Durante este tempo, algumas informações podem estar ausentes ou incorretas",
            "title": "O HACS está a iniciar"
          },
          "wrong_frontend_installed": {
            "content": "Tem a versão {running} do frontend HACS instalado, mas a versão {expected} é a mais atualizada, se está a ver esta mensagem e o Home Assistant não foi capaz de instalar a nova versão, tente reiniciar o Home Assistant.",
            "title": "Versão do frontend inesperada"
          },
          "wrong_frontend_loaded": {
            "content": "Está a executar a versão {running} do frontend HACS, mas a versão {expected} é a mais atualizada, deve limpar a cache do seu browser.",
            "title": "Versão do frontend inesperada"
          }
        },
        "pending_updates": "Atualizações pendentes"
      },
      "menu": {
        "about": "Sobre o HACS",
        "clear": "Limpar todos os recentes",
        "custom_repositories": "Repositórios personalizados",
        "dismiss": "Dispensar todos os novos repositórios",
        "documentation": "Documentação",
        "open_issue": "Questão em aberto",
        "reload": "Recarregar janela"
      },
      "options": {
        "step": {
          "user": {
            "data": {
              "appdaemon": "Ativar a localização e o seguimento de aplicações AppDaemon",
              "country": "Filtrar com o código do país.",
              "debug": "Ativar depuração.",
              "experimental": "Ativar recursos experimentais",
              "netdaemon": "Ativar a localização e o seguimento de aplicações NetDaemon",
              "not_in_use": "Não está a ser usado com YAML",
              "release_limit": "Número de lançamentos a mostrar.",
              "sidepanel_icon": "Ícone no painel lateral",
              "sidepanel_title": "Título no painel lateral"
            }
          }
        }
      },
      "repository_banner": {
        "config_flow": "Esta integração suporta o config_flow, o que significa que agora pode ir para a seção de integração do IU para a configurar.",
        "config_flow_title": "Configuração UI suportada",
        "integration_not_loaded": "Esta integração não foi carregada no Home Assistant.",
        "no_restart_required": "Não é necessário reiniciar",
        "not_loaded": "Não carregado",
        "plugin_not_loaded": "Este elemento não é adicionado aos recursos Lovelace.",
        "restart": "É necessário reiniciar o Home Assistant.",
        "restart_pending": "Reinício pendente"
      },
      "repository_card": {
        "dismiss": "dispensar",
        "hide": "Esconder",
        "information": "Informações",
        "new_repository": "Novo repositório",
        "not_loaded": "Não carregado",
        "open_issue": "Questão em aberto",
        "open_source": "Código aberto",
        "pending_restart": "Reinicialização pendente",
        "pending_update": 