# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.5.3
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class ContractHistoryItem(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'as_of': 'datetime',
        'revision_no': 'int',
        'delivery_area': 'str',
        'contract_id': 'str',
        'vwap': 'float',
        'best_bid_price': 'float',
        'best_bid_quantity': 'float',
        'best_ask_price': 'float',
        'best_ask_quantity': 'float',
        'last_price': 'float',
        'last_quantity': 'float',
        'total_quantity': 'float',
        'auction_price': 'float',
        'high': 'float',
        'low': 'float',
        'signals': 'list[Signal]',
        'trades': 'list[Trade]',
        'internal_trades': 'list[InternalTrade]',
        'orders': 'Orders'
    }

    attribute_map = {
        'as_of': 'as_of',
        'revision_no': 'revisionNo',
        'delivery_area': 'delivery_area',
        'contract_id': 'contract_id',
        'vwap': 'vwap',
        'best_bid_price': 'best_bid_price',
        'best_bid_quantity': 'best_bid_quantity',
        'best_ask_price': 'best_ask_price',
        'best_ask_quantity': 'best_ask_quantity',
        'last_price': 'last_price',
        'last_quantity': 'last_quantity',
        'total_quantity': 'total_quantity',
        'auction_price': 'auction_price',
        'high': 'high',
        'low': 'low',
        'signals': 'signals',
        'trades': 'trades',
        'internal_trades': 'internal_trades',
        'orders': 'orders'
    }

    def __init__(self, as_of=None, revision_no=None, delivery_area=None, contract_id=None, vwap=None, best_bid_price=None, best_bid_quantity=None, best_ask_price=None, best_ask_quantity=None, last_price=None, last_quantity=None, total_quantity=None, auction_price=None, high=None, low=None, signals=None, trades=None, internal_trades=None, orders=None, local_vars_configuration=None):  # noqa: E501
        """ContractHistoryItem - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._as_of = None
        self._revision_no = None
        self._delivery_area = None
        self._contract_id = None
        self._vwap = None
        self._best_bid_price = None
        self._best_bid_quantity = None
        self._best_ask_price = None
        self._best_ask_quantity = None
        self._last_price = None
        self._last_quantity = None
        self._total_quantity = None
        self._auction_price = None
        self._high = None
        self._low = None
        self._signals = None
        self._trades = None
        self._internal_trades = None
        self._orders = None
        self.discriminator = None

        if as_of is not None:
            self.as_of = as_of
        if revision_no is not None:
            self.revision_no = revision_no
        if delivery_area is not None:
            self.delivery_area = delivery_area
        if contract_id is not None:
            self.contract_id = contract_id
        if vwap is not None:
            self.vwap = vwap
        if best_bid_price is not None:
            self.best_bid_price = best_bid_price
        if best_bid_quantity is not None:
            self.best_bid_quantity = best_bid_quantity
        if best_ask_price is not None:
            self.best_ask_price = best_ask_price
        if best_ask_quantity is not None:
            self.best_ask_quantity = best_ask_quantity
        if last_price is not None:
            self.last_price = last_price
        if last_quantity is not None:
            self.last_quantity = last_quantity
        if total_quantity is not None:
            self.total_quantity = total_quantity
        if auction_price is not None:
            self.auction_price = auction_price
        if high is not None:
            self.high = high
        if low is not None:
            self.low = low
        if signals is not None:
            self.signals = signals
        if trades is not None:
            self.trades = trades
        if internal_trades is not None:
            self.internal_trades = internal_trades
        if orders is not None:
            self.orders = orders

    @property
    def as_of(self):
        """Gets the as_of of this ContractHistoryItem.  # noqa: E501

        The timestamp as of the entry is valid  # noqa: E501

        :return: The as_of of this ContractHistoryItem.  # noqa: E501
        :rtype: datetime
        """
        return self._as_of

    @as_of.setter
    def as_of(self, as_of):
        """Sets the as_of of this ContractHistoryItem.

        The timestamp as of the entry is valid  # noqa: E501

        :param as_of: The as_of of this ContractHistoryItem.  # noqa: E501
        :type as_of: datetime
        """

        self._as_of = as_of

    @property
    def revision_no(self):
        """Gets the revision_no of this ContractHistoryItem.  # noqa: E501

        The running revision number of the entry  # noqa: E501

        :return: The revision_no of this ContractHistoryItem.  # noqa: E501
        :rtype: int
        """
        return self._revision_no

    @revision_no.setter
    def revision_no(self, revision_no):
        """Sets the revision_no of this ContractHistoryItem.

        The running revision number of the entry  # noqa: E501

        :param revision_no: The revision_no of this ContractHistoryItem.  # noqa: E501
        :type revision_no: int
        """

        self._revision_no = revision_no

    @property
    def delivery_area(self):
        """Gets the delivery_area of this ContractHistoryItem.  # noqa: E501


        :return: The delivery_area of this ContractHistoryItem.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this ContractHistoryItem.


        :param delivery_area: The delivery_area of this ContractHistoryItem.  # noqa: E501
        :type delivery_area: str
        """

        self._delivery_area = delivery_area

    @property
    def contract_id(self):
        """Gets the contract_id of this ContractHistoryItem.  # noqa: E501


        :return: The contract_id of this ContractHistoryItem.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this ContractHistoryItem.


        :param contract_id: The contract_id of this ContractHistoryItem.  # noqa: E501
        :type contract_id: str
        """

        self._contract_id = contract_id

    @property
    def vwap(self):
        """Gets the vwap of this ContractHistoryItem.  # noqa: E501

        The volume weighted average price at that time  # noqa: E501

        :return: The vwap of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._vwap

    @vwap.setter
    def vwap(self, vwap):
        """Sets the vwap of this ContractHistoryItem.

        The volume weighted average price at that time  # noqa: E501

        :param vwap: The vwap of this ContractHistoryItem.  # noqa: E501
        :type vwap: float
        """

        self._vwap = vwap

    @property
    def best_bid_price(self):
        """Gets the best_bid_price of this ContractHistoryItem.  # noqa: E501

        The best bid's price at that time  # noqa: E501

        :return: The best_bid_price of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._best_bid_price

    @best_bid_price.setter
    def best_bid_price(self, best_bid_price):
        """Sets the best_bid_price of this ContractHistoryItem.

        The best bid's price at that time  # noqa: E501

        :param best_bid_price: The best_bid_price of this ContractHistoryItem.  # noqa: E501
        :type best_bid_price: float
        """

        self._best_bid_price = best_bid_price

    @property
    def best_bid_quantity(self):
        """Gets the best_bid_quantity of this ContractHistoryItem.  # noqa: E501

        The best bid's quantity at that time  # noqa: E501

        :return: The best_bid_quantity of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._best_bid_quantity

    @best_bid_quantity.setter
    def best_bid_quantity(self, best_bid_quantity):
        """Sets the best_bid_quantity of this ContractHistoryItem.

        The best bid's quantity at that time  # noqa: E501

        :param best_bid_quantity: The best_bid_quantity of this ContractHistoryItem.  # noqa: E501
        :type best_bid_quantity: float
        """

        self._best_bid_quantity = best_bid_quantity

    @property
    def best_ask_price(self):
        """Gets the best_ask_price of this ContractHistoryItem.  # noqa: E501

        The best ask's price at that time  # noqa: E501

        :return: The best_ask_price of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._best_ask_price

    @best_ask_price.setter
    def best_ask_price(self, best_ask_price):
        """Sets the best_ask_price of this ContractHistoryItem.

        The best ask's price at that time  # noqa: E501

        :param best_ask_price: The best_ask_price of this ContractHistoryItem.  # noqa: E501
        :type best_ask_price: float
        """

        self._best_ask_price = best_ask_price

    @property
    def best_ask_quantity(self):
        """Gets the best_ask_quantity of this ContractHistoryItem.  # noqa: E501

        The best asks's quantity at that time  # noqa: E501

        :return: The best_ask_quantity of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._best_ask_quantity

    @best_ask_quantity.setter
    def best_ask_quantity(self, best_ask_quantity):
        """Sets the best_ask_quantity of this ContractHistoryItem.

        The best asks's quantity at that time  # noqa: E501

        :param best_ask_quantity: The best_ask_quantity of this ContractHistoryItem.  # noqa: E501
        :type best_ask_quantity: float
        """

        self._best_ask_quantity = best_ask_quantity

    @property
    def last_price(self):
        """Gets the last_price of this ContractHistoryItem.  # noqa: E501

        The price of the last trade at that time  # noqa: E501

        :return: The last_price of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._last_price

    @last_price.setter
    def last_price(self, last_price):
        """Sets the last_price of this ContractHistoryItem.

        The price of the last trade at that time  # noqa: E501

        :param last_price: The last_price of this ContractHistoryItem.  # noqa: E501
        :type last_price: float
        """

        self._last_price = last_price

    @property
    def last_quantity(self):
        """Gets the last_quantity of this ContractHistoryItem.  # noqa: E501

        The quantity of the last trade at that time  # noqa: E501

        :return: The last_quantity of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._last_quantity

    @last_quantity.setter
    def last_quantity(self, last_quantity):
        """Sets the last_quantity of this ContractHistoryItem.

        The quantity of the last trade at that time  # noqa: E501

        :param last_quantity: The last_quantity of this ContractHistoryItem.  # noqa: E501
        :type last_quantity: float
        """

        self._last_quantity = last_quantity

    @property
    def total_quantity(self):
        """Gets the total_quantity of this ContractHistoryItem.  # noqa: E501

        The total volume of the contract at that time  # noqa: E501

        :return: The total_quantity of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._total_quantity

    @total_quantity.setter
    def total_quantity(self, total_quantity):
        """Sets the total_quantity of this ContractHistoryItem.

        The total volume of the contract at that time  # noqa: E501

        :param total_quantity: The total_quantity of this ContractHistoryItem.  # noqa: E501
        :type total_quantity: float
        """

        self._total_quantity = total_quantity

    @property
    def auction_price(self):
        """Gets the auction_price of this ContractHistoryItem.  # noqa: E501


        :return: The auction_price of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._auction_price

    @auction_price.setter
    def auction_price(self, auction_price):
        """Sets the auction_price of this ContractHistoryItem.


        :param auction_price: The auction_price of this ContractHistoryItem.  # noqa: E501
        :type auction_price: float
        """

        self._auction_price = auction_price

    @property
    def high(self):
        """Gets the high of this ContractHistoryItem.  # noqa: E501

        Highest traded price since the start of the trading period at the current point in time.  # noqa: E501

        :return: The high of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._high

    @high.setter
    def high(self, high):
        """Sets the high of this ContractHistoryItem.

        Highest traded price since the start of the trading period at the current point in time.  # noqa: E501

        :param high: The high of this ContractHistoryItem.  # noqa: E501
        :type high: float
        """

        self._high = high

    @property
    def low(self):
        """Gets the low of this ContractHistoryItem.  # noqa: E501

        Lowest traded price since the start of the trading period at the current point in time.  # noqa: E501

        :return: The low of this ContractHistoryItem.  # noqa: E501
        :rtype: float
        """
        return self._low

    @low.setter
    def low(self, low):
        """Sets the low of this ContractHistoryItem.

        Lowest traded price since the start of the trading period at the current point in time.  # noqa: E501

        :param low: The low of this ContractHistoryItem.  # noqa: E501
        :type low: float
        """

        self._low = low

    @property
    def signals(self):
        """Gets the signals of this ContractHistoryItem.  # noqa: E501

        Signals valid as of the current point in time.  # noqa: E501

        :return: The signals of this ContractHistoryItem.  # noqa: E501
        :rtype: list[Signal]
        """
        return self._signals

    @signals.setter
    def signals(self, signals):
        """Sets the signals of this ContractHistoryItem.

        Signals valid as of the current point in time.  # noqa: E501

        :param signals: The signals of this ContractHistoryItem.  # noqa: E501
        :type signals: list[Signal]
        """

        self._signals = signals

    @property
    def trades(self):
        """Gets the trades of this ContractHistoryItem.  # noqa: E501

        Lists the trades which occurred since the previous point in time.  # noqa: E501

        :return: The trades of this ContractHistoryItem.  # noqa: E501
        :rtype: list[Trade]
        """
        return self._trades

    @trades.setter
    def trades(self, trades):
        """Sets the trades of this ContractHistoryItem.

        Lists the trades which occurred since the previous point in time.  # noqa: E501

        :param trades: The trades of this ContractHistoryItem.  # noqa: E501
        :type trades: list[Trade]
        """

        self._trades = trades

    @property
    def internal_trades(self):
        """Gets the internal_trades of this ContractHistoryItem.  # noqa: E501

        Lists the internal trades which occurred since the previous point in time.  # noqa: E501

        :return: The internal_trades of this ContractHistoryItem.  # noqa: E501
        :rtype: list[InternalTrade]
        """
        return self._internal_trades

    @internal_trades.setter
    def internal_trades(self, internal_trades):
        """Sets the internal_trades of this ContractHistoryItem.

        Lists the internal trades which occurred since the previous point in time.  # noqa: E501

        :param internal_trades: The internal_trades of this ContractHistoryItem.  # noqa: E501
        :type internal_trades: list[InternalTrade]
        """

        self._internal_trades = internal_trades

    @property
    def orders(self):
        """Gets the orders of this ContractHistoryItem.  # noqa: E501


        :return: The orders of this ContractHistoryItem.  # noqa: E501
        :rtype: Orders
        """
        return self._orders

    @orders.setter
    def orders(self, orders):
        """Sets the orders of this ContractHistoryItem.


        :param orders: The orders of this ContractHistoryItem.  # noqa: E501
        :type orders: Orders
        """

        self._orders = orders

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContractHistoryItem):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContractHistoryItem):
            return True

        return self.to_dict() != other.to_dict()
