# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['censusviz']

package_data = \
{'': ['*']}

install_requires = \
['descartes', 'geopandas', 'lxml', 'matplotlib', 'pandas', 'requests']

setup_kwargs = {
    'name': 'censusviz',
    'version': '0.1.10',
    'description': 'A Python package to make it easier to visualize Census data.',
    'long_description': '# **censusviz -- map Census data**\n\nThis package helps users more easily visualize maps using Census Population Estimate API and the Census Cartographic GeoJSON boundary files. It transforms GeoJSON files into easy to work with GeoPandas.GeoDataFrame and plot choropleth maps.\n\n## **How To Install**\n\nPlease install and import the censusviz package using the following commands. \n```\npip install censusviz\n```\n\nAfter installing via pip, please import the package to use on your Python IDE.\n\n```\nfrom censusviz import censusviz\n```\n\n## **Usage**\n\n### Find Available Geo Parameters\nThe ```list_geoparams``` function returns a table from the Census\' Github telling users which GeoJSON files are available by Year and geography area type. \n\nParameters (optional):\n- year: A string value of the year you would like to recall. %Y. Optional and will return a subset of table if specified.\n\n\n```\ncensusviz.list_geoparams()\n\ncensusviz.list_geoparams(year = "2010")\n```\n### Return a Geopandas dataframe\nThe ```get_geocen_df``` function returns a geopandas.GeoDataFrame of Census cartographic files. \n\nParameters:\n - quality: a string value of the resolution of the GeoJSON file. The available resolutions are 20m, 5m, and 500k.\n- year:  a string value of the year you would like to recall. %Y. Year availables: 1990, 2000, 2010, 2012-2019.\n- area_type: a stringe value of the geography area value you would like to specify. \n\n```\ncensusviz.get_geocen_df(quality = "20m", year = "2010", area_type= "county")\n```\n### Return State Identifiers\nThe ```get_state_ids``` function returns a pandas.DataFrame of state-related federal codes such as FIPS and USPS codes.\n\nParameters:\n- state_initials: a string value of the officially recognized state abbreviation.\n\n```\ncensusviz.get_state_ids(state_initials = "OR")\n\ncensusviz.get_state_ids(state_initials = "NY")\n```\n### Plot Cartographic shapes\n\nThe ```get_geocen_plot``` function returns a matplotlib.pyplot.plot of a specified cartographic area by year, area type and resolution quality.\n\nParameters\n- quality: a string value of the resolution of the GeoJSON file. The available resolutions are 20m, 5m, and 500k.\n- year:  a string value of the year you would like to recall. %Y. Years available: 1990, 2000, 2010, 2012-2019.\n- area_type: a string value of the geography area value you would like to specify. \n- boundaries: a boolean value that if True returns only the outline/boundaries of the area specified and if false returns the whole area filled in.\n\n```\ncensusviz.get_geocen_plot(quality ="20m", year="2010", area_type="county", boundaries=False)\n```\n\n### Return Population Data with Map \nThe ```get_pop``` function  returns a choropleth map in matplotlib.pyplot.plot format or a geopandas.GeoDataFrame of the U.S. population by year and geometric boundaries. It utilizes the U.S. Census Bureau Population Estimate API and the Census GeoJSON database on GitHub.\n\nParameters\n- api_key: a private api key provided by the U.S. Census Bureau. https://www.census.gov/data/developers/data-sets/popest-popproj/popest.html \n- year:  a string value of the year you would like to recall. %Y. Year availables: 2015-2019.\n- map: a boolean value that if True returns matplotlib.pyplot.plot of the area specified and if false returns a geopandas.GeoDataFrame of the same values.\n\n```\ncensusviz.get_pop(api_key = my_api_key, year="2018", map = False)\n\ncensusviz.get_pop(api_key = my_api_key, year="2019", map = True)\n```\n\n### Return Population Data with Map (By Region)\nThe ```get_region_pop``` function function returns a choropleth map in matplotlib.pyplot.plot format or a geopandas.GeoDataFrame of the U.S. population by year and region. It utilizes the U.S. Census Bureau Population Estimate API and the Census GeoJSON database on GitHub.\n\nParameters\n- api_key: a private api key provided by the U.S. Census Bureau. https://www.census.gov/data/developers/data-sets/popest-popproj/popest.html \n- year:  a string value of the year you would like to recall. %Y. Year availables: 2018-2019.\n- map: a boolean value that if True returns matplotlib.pyplot.plot of the area specified and if false returns a geopandas.GeoDataFrame for the same values.\n\n```\ncensusviz.get_region_pop(api_key = my_api_key, year="2016", map = False)\n\ncensusviz.get_region_pop(api_key = my_api_key, year="2019", map = True)\n```\n\n### Return Population Data with Map (By State)\nThe ```get_state_pop``` function returns a choropleth map in matplotlib.pyplot.plot format or a geopandas.GeoDataFrame of the U.S. population by year and state. It utlizes the U.S. Census Bureau Population Estimate API and the Census GeoJSON database on GitHub.\n\n Parameters\n - api_key: a private api key provided by the U.S. Census Bureau. https://www.census.gov/data/developers/data-sets/popest-popproj/popest.html \n- year:  a string value of the year you would like to recall. %Y. Year availables: 2018-2019.\n- state_fip: a string value of the state Federal Information Processing Standard state code.\n- map: a boolean value that if True returns matplotlib.pyplot.plot of the area specified and if false returns a geopandas.GeoDataFrame for the same values.\n\n```\ncensusviz.get_state_pop(api_key = my_api_key, year="2016", state_fip = "15", map = False)\n\ncensusviz.get_state_pop(api_key = my_api_key, year="2019", state_fip = "29", map = True)\n```\n\n### Return Housing Unit Estimation Data with Map\n\nThe ```get_house_est``` returns a choropleth map in matplotlib.pyplot.plot format or a geopandas.GeoDataFrame of the U.S. housing estimates by year. It utlizes the U.S. Census Bureau Housing Unit Estimate API and the Census GeoJSON database on GitHub.\n\nParameters\n- api_key: a private api key provided by the U.S. Census Bureau. https://www.census.gov/data/developers/data-sets/popest-popproj/popest.html \n- year:  a string value of the year you would like to recall. %Y. Year availables: 2018-2019.\n- map: a boolean value that if True returns matplotlib.pyplot.plot of the area specified and if false returns a geopandas.GeoDataFrame for the same values.\n\n```\ncensusviz.get_house_est(api_key = my_api_key, year="2018", map = False)\n\ncensusviz.get_house_est(api_key = my_api_key, year="2019", map = True)\n```\n\n## **Dependencies**\n\n- python = "^3.6"\n- pandas \n- pyproj \n- requests \n- numpy \n- shapely \n- gdal = [Wheels for Windows User](https://www.lfd.uci.edu/~gohlke/pythonlibs/#gdal)\n- fiona = [Wheels for Windows User](https://www.lfd.uci.edu/~gohlke/pythonlibs/#fiona)\n- geopandas \n- matplotlib \n- descartes \n- lxml\n\n## **Documentation**\n\nThe official documentation is hosted on Read the Docs: https://censusviz.readthedocs.io/en/latest/\n\n## **Contributors**\n\nWe welcome and recognize all contributions. You can see a list of current contributors in the [contributors tab](https://github.com/elliotttrio/censusviz/graphs/contributors).\n\n### **Credits**\n\nThis package was created with Cookiecutter and the UBC-MDS/cookiecutter-ubc-mds project template, modified from the [pyOpenSci/cookiecutter-pyopensci](https://github.com/pyOpenSci/cookiecutter-pyopensci) project template and the [audreyr/cookiecutter-pypackage](https://github.com/audreyr/cookiecutter-pypackage).\n',
    'author': 'Elliott',
    'author_email': 'eat2153@columbia.edu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/elliotttrio/censusviz',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
