# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CredentialOfferParameters(Model):
    """Send offer.

    All required parameters must be populated in order to send to Azure.

    :param definition_id: Required. The credential definition identifier
    :type definition_id: str
    :param connection_id: Connection identifier to send this credential to.
     If omitted, the request will be treated as connectionless issuance and
     will generate a URL.
    :type connection_id: str
    :param automatic_issuance: If true, the credential will automatically be
     issued once the individual accepts the offer.
     If false, when an individual accepts the offer the credential will be in
     state 'Requested' and must be manually issued.
     Default value is 'false'.
    :type automatic_issuance: bool
    :param credential_values:
    :type credential_values: dict[str, str]
    """

    _validation = {
        'definition_id': {'required': True},
    }

    _attribute_map = {
        'definition_id': {'key': 'definitionId', 'type': 'str'},
        'connection_id': {'key': 'connectionId', 'type': 'str'},
        'automatic_issuance': {'key': 'automaticIssuance', 'type': 'bool'},
        'credential_values': {'key': 'credentialValues', 'type': '{str}'},
    }

    def __init__(self, *, definition_id: str, connection_id: str=None, automatic_issuance: bool=None, credential_values=None, **kwargs) -> None:
        super(CredentialOfferParameters, self).__init__(**kwargs)
        self.definition_id = definition_id
        self.connection_id = connection_id
        self.automatic_issuance = automatic_issuance
        self.credential_values = credential_values
