# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError
from . import models


class CredentialsClientConfiguration(Configuration):
    """Configuration for CredentialsClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Subscription credentials which uniquely
     identify client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if not base_url:
            base_url = 'https://api.trinsic.id/credentials/v1'

        super(CredentialsClientConfiguration, self).__init__(base_url)

        self.add_user_agent('trinsic.service_clients.credentials/{}'.format(VERSION))

        self.credentials = credentials


class CredentialsClient(SDKClient):
    """An API to issue, manage, and verify digital credentials

    :ivar config: Configuration for client.
    :vartype config: CredentialsClientConfiguration

    :param credentials: Subscription credentials which uniquely
     identify client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        self.config = CredentialsClientConfiguration(credentials, base_url)
        super(CredentialsClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = 'v1'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    def upload_image(
            self, uploaded_files, filename=None, content_type=None, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Upload image.

        Please use the Provider API instead.
        Upload an image and return a URL with the static remote location.

        :param uploaded_files:
        :type uploaded_files: Generator
        :param filename:
        :type filename: str
        :param content_type:
        :type content_type: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: str or ClientRawResponse if raw=true
        :rtype: str or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.upload_image.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'uploadedFiles': uploaded_files,
            'filename': filename,
            'contentType': content_type,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('str', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    upload_image.metadata = {'url': '/common/upload'}

    def list_networks(
            self, custom_headers=None, raw=False, **operation_config):
        """List all ledger networks.

        List all available ledger networks.
        Some networks are not available based on your subscription.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~credentials.models.NetworkContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_networks.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[NetworkContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_networks.metadata = {'url': '/common/networks'}

    def get_transaction_author_agreement(
            self, network_id, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Get network transaction author agreement.

        This endpoint is no longer needed.
        Get the latest transaction author agreement and acceptance methods if
        one is set on the specified network.

        :param network_id: The network identifier
        :type network_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: NetworkTxnAgreementContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.NetworkTxnAgreementContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_transaction_author_agreement.metadata['url']
        path_format_arguments = {
            'networkId': self._serialize.url("network_id", network_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('NetworkTxnAgreementContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_transaction_author_agreement.metadata = {'url': '/common/networks/{networkId}/txnAuthorAgreement'}

    def accept_transaction_author_agreement(
            self, tenant_id, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Accept network transaction author agreement.

        This endpoint is no longer needed.
        Accept the latest transaction author agreement on the specified
        network.

        :param tenant_id: The tenant identifier
        :type tenant_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.accept_transaction_author_agreement.metadata['url']
        path_format_arguments = {
            'tenantId': self._serialize.url("tenant_id", tenant_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    accept_transaction_author_agreement.metadata = {'url': '/common/networks/{tenantId}/txnAuthorAgreement'}

    def list_connections(
            self, state=None, custom_headers=None, raw=False, **operation_config):
        """List all connections.

        Retrieve a list of all connections.
        Optionally, list only connections in a specified state.

        :param state: The connection state. Possible values include:
         'Invited', 'Negotiating', 'Connected'
        :type state: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~credentials.models.ConnectionContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_connections.metadata['url']

        # Construct parameters
        query_parameters = {}
        if state is not None:
            query_parameters['state'] = self._serialize.query("state", state, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ConnectionContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_connections.metadata = {'url': '/connections'}

    def create_connection(
            self, body, custom_headers=None, raw=False, **operation_config):
        """Create connection.

        Initiate a new connection by creating an invitation.
        The newly created connection record will be in state 'Invited' until
        the other party has accepted the invitation.
        The response body includes details about the newly creation connection.

        :param body: Connection invitation parameters
        :type body: ~credentials.models.ConnectionInvitationParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ConnectionContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.ConnectionContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_connection.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'ConnectionInvitationParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ConnectionContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_connection.metadata = {'url': '/connections'}

    def get_connection(
            self, connection_id, custom_headers=None, raw=False, **operation_config):
        """Get connection.

        Get the specified connection.

        :param connection_id: The connection identifier
        :type connection_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ConnectionContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.ConnectionContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_connection.metadata['url']
        path_format_arguments = {
            'connectionId': self._serialize.url("connection_id", connection_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ConnectionContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_connection.metadata = {'url': '/connections/{connectionId}'}

    def delete_connection(
            self, connection_id, custom_headers=None, raw=False, **operation_config):
        """Delete connection.

        Delete the specified connection.

        :param connection_id: The connection identifier
        :type connection_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_connection.metadata['url']
        path_format_arguments = {
            'connectionId': self._serialize.url("connection_id", connection_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_connection.metadata = {'url': '/connections/{connectionId}'}

    def list_credentials(
            self, connection_id=None, state=None, definition_id=None, custom_headers=None, raw=False, **operation_config):
        """List all credentials.

        List all credentials that match any specified query parameters.
        No query parameters are required, but any provided will filter the
        results.

        :param connection_id: A connection identifier
        :type connection_id: str
        :param state: The state of credentials. Possible values include:
         'Offered', 'Requested', 'Issued', 'Rejected', 'Revoked'
        :type state: str
        :param definition_id: A credential definition identifier
        :type definition_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~credentials.models.CredentialContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_credentials.metadata['url']

        # Construct parameters
        query_parameters = {}
        if connection_id is not None:
            query_parameters['connectionId'] = self._serialize.query("connection_id", connection_id, 'str')
        if state is not None:
            query_parameters['state'] = self._serialize.query("state", state, 'str')
        if definition_id is not None:
            query_parameters['definitionId'] = self._serialize.query("definition_id", definition_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[CredentialContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_credentials.metadata = {'url': '/credentials'}

    def create_credential(
            self, body, custom_headers=None, raw=False, **operation_config):
        """Create and offer credential.

        Send a credential offer of the specified credential definition to the
        specified connection.

        :param body: The definition and connection to which this offer will be
         sent
        :type body: ~credentials.models.CredentialOfferParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CredentialContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.CredentialContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_credential.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'CredentialOfferParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CredentialContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_credential.metadata = {'url': '/credentials'}

    def get_credential(
            self, credential_id, custom_headers=None, raw=False, **operation_config):
        """Get credential.

        Get the specified credential.

        :param credential_id: The credential identifier
        :type credential_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CredentialContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.CredentialContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_credential.metadata['url']
        path_format_arguments = {
            'credentialId': self._serialize.url("credential_id", credential_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CredentialContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_credential.metadata = {'url': '/credentials/{credentialId}'}

    def issue_credential(
            self, credential_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Issue credential.

        Issue the specified credential.
        If the values offered were incorrect, changes to the values may be made
        here.
        You must update all of the values, and they must be follow the same
        structure of the schema.
        To keep the values the same as those included in the credential offer,
        leave the body blank.

        :param credential_id: The credential identifier
        :type credential_id: str
        :param body: Updated credential values
        :type body: dict[str, str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.issue_credential.metadata['url']
        path_format_arguments = {
            'credentialId': self._serialize.url("credential_id", credential_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, '{str}')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    issue_credential.metadata = {'url': '/credentials/{credentialId}'}

    def revoke_credential(
            self, credential_id, custom_headers=None, raw=False, **operation_config):
        """Revoke an issued credential.

        Revoke credential that was issued previously.
        Process of revocation will update the revocation registry locally and
        on the ledger.
        Issued credentials can still participate in proof workflows and be
        considered valid, but only if the verifying ignores the revocation
        trail.

        :param credential_id: The credential identifier
        :type credential_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.revoke_credential.metadata['url']
        path_format_arguments = {
            'credentialId': self._serialize.url("credential_id", credential_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    revoke_credential.metadata = {'url': '/credentials/{credentialId}'}

    def delete_credential(
            self, credential_id, custom_headers=None, raw=False, **operation_config):
        """Delete credential.

        Delete the specified credential.
        This endpoint does not revoke the credential.

        :param credential_id: The credential identifier
        :type credential_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_credential.metadata['url']
        path_format_arguments = {
            'credentialId': self._serialize.url("credential_id", credential_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_credential.metadata = {'url': '/credentials/delete/{credentialId}'}

    def list_verification_policies(
            self, custom_headers=None, raw=False, **operation_config):
        """List all verification policies.

        List all verification policies for the authenticated organization.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~credentials.models.VerificationPolicyContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_verification_policies.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[VerificationPolicyContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_verification_policies.metadata = {'url': '/verificationPolicies'}

    def create_verification_policy(
            self, body, custom_headers=None, raw=False, **operation_config):
        """Create verification policy.

        Create a verification policy from the specified parameters.

        :param body: The verification policy parameters
        :type body: ~credentials.models.VerificationPolicyParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationPolicyContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.VerificationPolicyContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_verification_policy.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'VerificationPolicyParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationPolicyContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_verification_policy.metadata = {'url': '/verificationPolicies'}

    def get_verification_policy(
            self, policy_id, custom_headers=None, raw=False, **operation_config):
        """Get verification policy.

        Get the specified verification policy.

        :param policy_id: The verification policy identifier
        :type policy_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationPolicyContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.VerificationPolicyContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_verification_policy.metadata['url']
        path_format_arguments = {
            'policyId': self._serialize.url("policy_id", policy_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationPolicyContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_verification_policy.metadata = {'url': '/verificationPolicies/{policyId}'}

    def delete_verification_policy(
            self, policy_id, custom_headers=None, raw=False, **operation_config):
        """Delete verification policy.

        Delete the specified verification policy.

        :param policy_id: The verification policy identifier
        :type policy_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_verification_policy.metadata['url']
        path_format_arguments = {
            'policyId': self._serialize.url("policy_id", policy_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_verification_policy.metadata = {'url': '/verificationPolicies/{policyId}'}

    def list_credential_definitions(
            self, custom_headers=None, raw=False, **operation_config):
        """List all credential definitions.

        List all credential definitions for the authorization context.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~credentials.models.CredentialDefinitionContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_credential_definitions.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[CredentialDefinitionContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_credential_definitions.metadata = {'url': '/definitions/credentials'}

    def create_credential_definition(
            self, body, custom_headers=None, raw=False, **operation_config):
        """Create credential definition and schema from parameters.

        A credential definition is created and saved on your cloud agent.

        :param body: Definition parameters
        :type body:
         ~credentials.models.CredentialDefinitionFromSchemaParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CredentialDefinitionContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.CredentialDefinitionContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_credential_definition.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'CredentialDefinitionFromSchemaParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CredentialDefinitionContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_credential_definition.metadata = {'url': '/definitions/credentials'}

    def get_credential_definition(
            self, definition_id, custom_headers=None, raw=False, **operation_config):
        """Get credential definition.

        Get the specified credential definition.

        :param definition_id: The credential definition identifier
        :type definition_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CredentialDefinitionContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.CredentialDefinitionContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_credential_definition.metadata['url']
        path_format_arguments = {
            'definitionId': self._serialize.url("definition_id", definition_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CredentialDefinitionContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_credential_definition.metadata = {'url': '/definitions/credentials/{definitionId}'}

    def create_credential_definition_for_schema_id(
            self, schema_id, body, custom_headers=None, raw=False, **operation_config):
        """Create credential definition from schema.

        Create a credential definition from the specified schema.

        :param schema_id: The schema identifier
        :type schema_id: str
        :param body: The definition parameters
        :type body: ~credentials.models.CredentialDefinitionParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CredentialDefinitionContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.CredentialDefinitionContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_credential_definition_for_schema_id.metadata['url']
        path_format_arguments = {
            'schemaId': self._serialize.url("schema_id", schema_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'CredentialDefinitionParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CredentialDefinitionContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_credential_definition_for_schema_id.metadata = {'url': '/definitions/credentials/{schemaId}'}

    def delete_credential_definition(
            self, credential_definition_id, custom_headers=None, raw=False, **operation_config):
        """Delete credential definition.

        Delete the specified credential definition.

        :param credential_definition_id: The credential definition identifier
        :type credential_definition_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_credential_definition.metadata['url']
        path_format_arguments = {
            'credentialDefinitionId': self._serialize.url("credential_definition_id", credential_definition_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_credential_definition.metadata = {'url': '/definitions/credentials/{credentialDefinitionId}'}

    def create_schema(
            self, body, custom_headers=None, raw=False, **operation_config):
        """Create schema.

        Register schema with the current agency tenant and write the schema to
        the ledger using the tenant as issuer.
        This does not create credential definition.

        :param body: Schema parameters
        :type body: ~credentials.models.SchemaParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: str or ClientRawResponse if raw=true
        :rtype: str or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_schema.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'SchemaParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('str', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_schema.metadata = {'url': '/definitions/schemas'}

    def list_schemas(
            self, custom_headers=None, raw=False, **operation_config):
        """List all schemas.

        List all schemas registered to or used by the authenticated
        organization.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~credentials.models.SchemaRecord] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_schemas.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[SchemaRecord]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_schemas.metadata = {'url': '/definitions/schemas'}

    def get_verification_definition(
            self, definition_id, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Get verification definition.

        Please use Verification Policies endpoints.
        Get the specified verification definition.

        :param definition_id: The verification definition identifier
        :type definition_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationDefinitionContract or ClientRawResponse if
         raw=true
        :rtype: ~credentials.models.VerificationDefinitionContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_verification_definition.metadata['url']
        path_format_arguments = {
            'definitionId': self._serialize.url("definition_id", definition_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationDefinitionContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_verification_definition.metadata = {'url': '/definitions/verifications/{definitionId}'}

    def list_verification_definitions(
            self, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] List all verification definitions.

        Please use Verification Policies endpoints.
        List all verification definitions for the authenticated organization.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~credentials.models.VerificationDefinitionContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_verification_definitions.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[VerificationDefinitionContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_verification_definitions.metadata = {'url': '/definitions/verifications'}

    def create_verification_definition(
            self, body, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Create verification definition.

        Please use Verification Policies endpoints.
        A verification definition is created and saved on your cloud agent.
        You can discover your definition based on the ID that is returned or
        the name.

        :param body: The proof request
        :type body: ~credentials.models.ProofRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationDefinitionContract or ClientRawResponse if
         raw=true
        :rtype: ~credentials.models.VerificationDefinitionContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_verification_definition.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'ProofRequest')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationDefinitionContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_verification_definition.metadata = {'url': '/definitions/verifications'}

    def delete_verification_definition(
            self, verification_definition_id, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Delete verification definition.

        Please use Verification Policies endpoints.
        Delete the specified verification definition.

        :param verification_definition_id: The verification definition
         identifier
        :type verification_definition_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_verification_definition.metadata['url']
        path_format_arguments = {
            'verificationDefinitionId': self._serialize.url("verification_definition_id", verification_definition_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_verification_definition.metadata = {'url': '/definitions/verifications/{verificationDefinitionId}'}

    def list_tenants(
            self, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] List all tenants.

        Please use the Provider API instead.
        List all tenants for the current authorization context.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~credentials.models.TenantContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_tenants.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[TenantContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_tenants.metadata = {'url': '/tenants'}

    def create_tenant(
            self, body, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Create tenant.

        Please use the Provider API instead.
        Create a new tenant and setup a unique agency endpoint.
        The agency will be set as an issuer.

        :param body: Configuration options for creating new tenant
        :type body: ~credentials.models.TenantParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: TenantContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.TenantContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_tenant.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'TenantParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TenantContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_tenant.metadata = {'url': '/tenants'}

    def get_tenant(
            self, tenant_id, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Get tenant.

        Please use the Provider API instead.
        Get the configuration for the specified tenant.

        :param tenant_id: The tenant identifier
        :type tenant_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: TenantContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.TenantContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tenant.metadata['url']
        path_format_arguments = {
            'tenantId': self._serialize.url("tenant_id", tenant_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TenantContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tenant.metadata = {'url': '/tenants/{tenantId}'}

    def delete_tenant(
            self, tenant_id, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Delete tenant.

        Please use the Provider API instead.
        Permanently remove the specified tenant, including their wallet,
        endpoint registrations and all data.
        All definitions, connections and credentials issued will be deleted.
        This action cannot be reverted.

        :param tenant_id: The tenant identifier
        :type tenant_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_tenant.metadata['url']
        path_format_arguments = {
            'tenantId': self._serialize.url("tenant_id", tenant_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_tenant.metadata = {'url': '/tenants/{tenantId}'}

    def get_issuer_status(
            self, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Get issuer status for current tenant.

        Please use the Provider API instead.
        If the tenant is configured with Dedicated endorsement, this action
        will check if the issuer DID has the required ENDORSER role on the
        configured ledger network.
        Additionally, check the acceptance of the transaction author agreement
        and return the text and version if acceptance is required.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: IssuerStatusContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.IssuerStatusContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_issuer_status.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IssuerStatusContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_issuer_status.metadata = {'url': '/tenants/issuerStatus'}

    def send_verification_from_policy(
            self, connection_id, policy_id, custom_headers=None, raw=False, **operation_config):
        """Send verification to connection from policy.

        Send a verification to the specified connection using an existing
        policy.

        :param connection_id: The connection identifier
        :type connection_id: str
        :param policy_id: The policy identifier
        :type policy_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.VerificationContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.send_verification_from_policy.metadata['url']
        path_format_arguments = {
            'connectionId': self._serialize.url("connection_id", connection_id, 'str'),
            'policyId': self._serialize.url("policy_id", policy_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    send_verification_from_policy.metadata = {'url': '/verifications/policy/{policyId}/connections/{connectionId}'}

    def send_verification_from_parameters(
            self, connection_id, body, custom_headers=None, raw=False, **operation_config):
        """Send verification to connection from parameters.

        Send a verification request to the specified connection from a set of
        parameters.

        :param connection_id: The connection identifier
        :type connection_id: str
        :param body: The policy parameters
        :type body: ~credentials.models.VerificationPolicyParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.VerificationContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.send_verification_from_parameters.metadata['url']
        path_format_arguments = {
            'connectionId': self._serialize.url("connection_id", connection_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'VerificationPolicyParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    send_verification_from_parameters.metadata = {'url': '/verifications/policy/connections/{connectionId}'}

    def send_verification_from_proposal(
            self, connection_id, policy_id, custom_headers=None, raw=False, **operation_config):
        """Send verification from policy.

        Create a verification from the specified policy and send it to the
        specified connection.

        :param connection_id: The connection identifier
        :type connection_id: str
        :param policy_id: The verification policy identifier
        :type policy_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.VerificationContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.send_verification_from_proposal.metadata['url']
        path_format_arguments = {
            'connectionId': self._serialize.url("connection_id", connection_id, 'str'),
            'policyId': self._serialize.url("policy_id", policy_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    send_verification_from_proposal.metadata = {'url': '/verifications/proposal/{policyId}/connections/{connectionId}'}

    def create_verification_from_policy(
            self, policy_id, custom_headers=None, raw=False, **operation_config):
        """Create connectionless verification from policy.

        Create a connectionless verification from the specified policy.
        Connectionless transport uses URLs that can be shared with the user
        over any existing transport (email, SMS, web).

        :param policy_id: The policy identifier
        :type policy_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.VerificationContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_verification_from_policy.metadata['url']
        path_format_arguments = {
            'policyId': self._serialize.url("policy_id", policy_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_verification_from_policy.metadata = {'url': '/verifications/policy/{policyId}'}

    def create_verification_from_parameters(
            self, body, custom_headers=None, raw=False, **operation_config):
        """Create connectionless verification from parameters.

        Create verification from parameters.
        Connectionless transport uses URLs that can be shared with the user
        over any existing transport (email, SMS, web).

        :param body: The policy parameters
        :type body: ~credentials.models.VerificationPolicyParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.VerificationContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_verification_from_parameters.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'VerificationPolicyParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_verification_from_parameters.metadata = {'url': '/verifications/policy'}

    def list_verifications(
            self, connection_id=None, definition_id=None, custom_headers=None, raw=False, **operation_config):
        """List all verifications.

        List all verifications.
        Optionally filter by connection and/or definition.

        :param connection_id: The connection identifier
        :type connection_id: str
        :param definition_id: The definition identifier
        :type definition_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~credentials.models.VerificationContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_verifications.metadata['url']

        # Construct parameters
        query_parameters = {}
        if connection_id is not None:
            query_parameters['connectionId'] = self._serialize.query("connection_id", connection_id, 'str')
        if definition_id is not None:
            query_parameters['definitionId'] = self._serialize.query("definition_id", definition_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[VerificationContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_verifications.metadata = {'url': '/verifications'}

    def create_verification(
            self, body, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Create/send verification.

        Please use SendVerification(policyId) or CreateVerification(policyId)
        instead.
        This endpoint can be used to send a verification definition to a
        connection, which will create a verification ID to track the response
        from the connection.
        If the parameter {connectionId} is not specified, this endpoint will
        create a connectionless verification. A URL will be generated that can
        be shared with anonymous user.

        :param body: The verification parameters
        :type body: ~credentials.models.VerificationParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.VerificationContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_verification.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'VerificationParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_verification.metadata = {'url': '/verifications'}

    def get_verification(
            self, verification_id, custom_headers=None, raw=False, **operation_config):
        """Get verification.

        Get the specified verification.

        :param verification_id: The verification identifier
        :type verification_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.VerificationContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_verification.metadata['url']
        path_format_arguments = {
            'verificationId': self._serialize.url("verification_id", verification_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_verification.metadata = {'url': '/verifications/{verificationId}'}

    def delete_verification(
            self, verification_id, custom_headers=None, raw=False, **operation_config):
        """Delete verification.

        Delete the specified verification.

        :param verification_id: The verification identifier
        :type verification_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_verification.metadata['url']
        path_format_arguments = {
            'verificationId': self._serialize.url("verification_id", verification_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_verification.metadata = {'url': '/verifications/{verificationId}'}

    def verify_verification(
            self, verification_id, custom_headers=None, raw=False, **operation_config):
        """[Deprecated] Verify verification.

        This action is now obsolete. Verifications are automatically verified
        when they are received.
        Execute verification on this record. This is an expensive action and is
        executed by verifying the proof against the ledger data.

        :param verification_id: The verification identifier
        :type verification_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationResult or ClientRawResponse if raw=true
        :rtype: ~credentials.models.VerificationResult or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.verify_verification.metadata['url']
        path_format_arguments = {
            'verificationId': self._serialize.url("verification_id", verification_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    verify_verification.metadata = {'url': '/verifications/{verificationId}/verify'}

    def list_webhooks(
            self, custom_headers=None, raw=False, **operation_config):
        """List all webhooks.

        List all webhooks registered with the authenticated organization.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~credentials.models.WebhookContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_webhooks.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[WebhookContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_webhooks.metadata = {'url': '/webhooks'}

    def create_webhook(
            self, body, custom_headers=None, raw=False, **operation_config):
        """Create webhook.

        Register a webhook with the authenticated organization.

        :param body: The webhook parameters
        :type body: ~credentials.models.WebhookParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: WebhookContract or ClientRawResponse if raw=true
        :rtype: ~credentials.models.WebhookContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_webhook.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'WebhookParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('WebhookContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_webhook.metadata = {'url': '/webhooks'}

    def remove_webhook(
            self, webhook_id, custom_headers=None, raw=False, **operation_config):
        """Remove webhook.

        Remove a registered webhook from the authenticated organization.

        :param webhook_id: The webhook identifier
        :type webhook_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.remove_webhook.metadata['url']
        path_format_arguments = {
            'webhookId': self._serialize.url("webhook_id", webhook_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    remove_webhook.metadata = {'url': '/webhooks/{webhookId}'}

    def enable_webhook(
            self, webhook_id, custom_headers=None, raw=False, **operation_config):
        """Enable webhook.

        Enable a registered webhook for the authenticated organization.

        :param webhook_id: The webhook identifier
        :type webhook_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.enable_webhook.metadata['url']
        path_format_arguments = {
            'webhookId': self._serialize.url("webhook_id", webhook_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    enable_webhook.metadata = {'url': '/webhooks/{webhookId}/enable'}

    def disable_webhook(
            self, webhook_id, custom_headers=None, raw=False, **operation_config):
        """Disable webhook.

        Enable a registered webhook for the authenticated organization.

        :param webhook_id: The webhook identifier
        :type webhook_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.disable_webhook.metadata['url']
        path_format_arguments = {
            'webhookId': self._serialize.url("webhook_id", webhook_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    disable_webhook.metadata = {'url': '/webhooks/{webhookId}/disable'}

    def health(
            self, custom_headers=None, raw=False, **operation_config):
        """Health check.

        Check the health of the API.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.health.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    health.metadata = {'url': '/health'}
