# Generated by Django 4.2.10 on 2024-08-02 11:48

# Django
import django.contrib.gis.db.models.fields
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Etablissement",
            fields=[
                (
                    "nic",
                    models.CharField(
                        blank=True, db_index=True, null=True, verbose_name="NIC"
                    ),
                ),
                (
                    "siret",
                    models.CharField(
                        primary_key=True, serialize=False, verbose_name="SIRET"
                    ),
                ),
                (
                    "statut_diffusion_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Statut diffusion etablissement",
                    ),
                ),
                (
                    "date_creation_etablissement",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Date creation etablissement",
                    ),
                ),
                (
                    "tranche_effectifs_etablissement",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("00", "0 salarié"),
                            ("01", "1 ou 2 salariés"),
                            ("02", "3 à 5 salariés"),
                            ("03", "6 à 9 salariés"),
                            ("11", "10 à 19 salariés"),
                            ("12", "20 à 49 salariés"),
                            ("21", "50 à 99 salariés"),
                            ("22", "100 à 199 salariés"),
                            ("31", "200 à 249 salariés"),
                            ("32", "250 à 499 salariés"),
                            ("41", "500 à 999 salariés"),
                            ("42", "1 000 à 1 999 salariés"),
                            ("51", "2 000 à 4 999 salariés"),
                            ("52", "5 000 à 9 999 salariés"),
                            ("53", "10 000 salariés et plus"),
                            ("NN", "Non employeuse"),
                        ],
                        null=True,
                        verbose_name="Tranche effectifs etablissement",
                    ),
                ),
                (
                    "annee_effectifs_etablissement",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Annee effectifs etablissement",
                    ),
                ),
                (
                    "activite_principale_registre_metiers_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Activite principale registre metiers etablissement",
                    ),
                ),
                (
                    "date_dernier_traitement_etablissement",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Date dernier traitement etablissement",
                    ),
                ),
                (
                    "etablissement_siege",
                    models.BooleanField(
                        blank=True, null=True, verbose_name="Etablissement siege"
                    ),
                ),
                (
                    "nombre_periodes_etablissement",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Nombre periodes etablissement",
                    ),
                ),
                (
                    "complement_adresse_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Complement adresse etablissement",
                    ),
                ),
                (
                    "numero_voie_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Numero voie etablissement"
                    ),
                ),
                (
                    "indice_repetition_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Indice repetition etablissement",
                    ),
                ),
                (
                    "dernier_numero_voie_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Dernier numero voie etablissement",
                    ),
                ),
                (
                    "indice_repetition_dernier_numero_voie_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Indice repetition dernier numero voie etablissement",
                    ),
                ),
                (
                    "type_voie_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Type voie etablissement"
                    ),
                ),
                (
                    "libelle_voie_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Libelle voie etablissement"
                    ),
                ),
                (
                    "code_postal_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Code postal etablissement"
                    ),
                ),
                (
                    "libelle_commune_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Libelle commune etablissement",
                    ),
                ),
                (
                    "libelle_commune_etranger_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Libelle commune etranger etablissement",
                    ),
                ),
                (
                    "distribution_speciale_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Distribution speciale etablissement",
                    ),
                ),
                (
                    "code_commune_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Code commune etablissement",
                    ),
                ),
                (
                    "code_cedex_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Code cedex etablissement"
                    ),
                ),
                (
                    "libelle_cedex_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Libelle cedex etablissement",
                    ),
                ),
                (
                    "code_pays_etranger_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Code pays etranger etablissement",
                    ),
                ),
                (
                    "libelle_pays_etranger_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Libelle pays etranger etablissement",
                    ),
                ),
                (
                    "identifiant_adresse_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Identifiant adresse etablissement",
                    ),
                ),
                (
                    "coordonnees_etablissement",
                    django.contrib.gis.db.models.fields.PointField(
                        blank=True,
                        null=True,
                        srid=4326,
                        verbose_name="Coordonnees etablissement",
                    ),
                ),
                (
                    "coordonnee_lambert_ordonnee_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Coordonnee lambert ordonnee etablissement",
                    ),
                ),
                (
                    "complement_adresse2_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Complement adresse2 etablissement",
                    ),
                ),
                (
                    "numero_voie2_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Numero voie2 etablissement"
                    ),
                ),
                (
                    "indice_repetition2_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Indice repetition2 etablissement",
                    ),
                ),
                (
                    "type_voie2_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Type voie2 etablissement"
                    ),
                ),
                (
                    "libelle_voie2_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Libelle voie2 etablissement",
                    ),
                ),
                (
                    "code_postal2_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Code postal2 etablissement"
                    ),
                ),
                (
                    "libelle_commune2_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Libelle commune2 etablissement",
                    ),
                ),
                (
                    "libelle_commune_etranger2_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Libelle commune etranger2 etablissement",
                    ),
                ),
                (
                    "distribution_speciale2_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Distribution speciale2 etablissement",
                    ),
                ),
                (
                    "code_commune2_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Code commune2 etablissement",
                    ),
                ),
                (
                    "code_cedex2_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Code cedex2 etablissement"
                    ),
                ),
                (
                    "libelle_cedex2_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Libelle cedex2 etablissement",
                    ),
                ),
                (
                    "code_pays_etranger2_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Code pays etranger2 etablissement",
                    ),
                ),
                (
                    "libelle_pays_etranger2_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Libelle pays etranger2 etablissement",
                    ),
                ),
                (
                    "date_debut",
                    models.DateField(blank=True, null=True, verbose_name="Date debut"),
                ),
                (
                    "etat_administratif_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Etat administratif etablissement",
                    ),
                ),
                (
                    "enseigne1_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Enseigne1 etablissement",
                    ),
                ),
                (
                    "enseigne2_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Enseigne2 etablissement",
                    ),
                ),
                (
                    "enseigne3_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Enseigne3 etablissement",
                    ),
                ),
                (
                    "denomination_usuelle_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Denomination usuelle etablissement",
                    ),
                ),
                (
                    "activite_principale_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Activite principale etablissement",
                    ),
                ),
                (
                    "nomenclature_activite_principale_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Nomenclature activite principale etablissement",
                    ),
                ),
                (
                    "caractere_employeur_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Caractere employeur etablissement",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="UniteLegale",
            fields=[
                (
                    "siren",
                    models.CharField(
                        primary_key=True, serialize=False, verbose_name="SIREN"
                    ),
                ),
                (
                    "statut_diffusion_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Statut diffusion unite legale",
                    ),
                ),
                (
                    "unite_purgee_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Unite purgee unite legale",
                    ),
                ),
                (
                    "date_creation_unite_legale",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Date creation unite legale",
                    ),
                ),
                (
                    "sigle_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Sigle unite legale"
                    ),
                ),
                (
                    "sexe_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Sexe unite legale"
                    ),
                ),
                (
                    "prenom1_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Prenom1 unite legale"
                    ),
                ),
                (
                    "prenom2_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Prenom2 unite legale"
                    ),
                ),
                (
                    "prenom3_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Prenom3 unite legale"
                    ),
                ),
                (
                    "prenom4_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Prenom4 unite legale"
                    ),
                ),
                (
                    "prenom_usuel_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Prenom usuel unite legale"
                    ),
                ),
                (
                    "pseudonyme_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Pseudonyme unite legale"
                    ),
                ),
                (
                    "identifiant_association_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Identifiant association unite legale",
                    ),
                ),
                (
                    "tranche_effectifs_unite_legale",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("00", "0 salarié"),
                            ("01", "1 ou 2 salariés"),
                            ("02", "3 à 5 salariés"),
                            ("03", "6 à 9 salariés"),
                            ("11", "10 à 19 salariés"),
                            ("12", "20 à 49 salariés"),
                            ("21", "50 à 99 salariés"),
                            ("22", "100 à 199 salariés"),
                            ("31", "200 à 249 salariés"),
                            ("32", "250 à 499 salariés"),
                            ("41", "500 à 999 salariés"),
                            ("42", "1 000 à 1 999 salariés"),
                            ("51", "2 000 à 4 999 salariés"),
                            ("52", "5 000 à 9 999 salariés"),
                            ("53", "10 000 salariés et plus"),
                            ("NN", "Non employeuse"),
                        ],
                        null=True,
                        verbose_name="Tranche effectifs unite legale",
                    ),
                ),
                (
                    "annee_effectifs_unite_legale",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Annee effectifs unite legale",
                    ),
                ),
                (
                    "date_dernier_traitement_unite_legale",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Date dernier traitement unite legale",
                    ),
                ),
                (
                    "nombre_periodes_unite_legale",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="Nombre periodes unite legale",
                    ),
                ),
                (
                    "categorie_entreprise",
                    models.CharField(
                        blank=True, null=True, verbose_name="Categorie entreprise"
                    ),
                ),
                (
                    "annee_categorie_entreprise",
                    models.IntegerField(
                        blank=True, null=True, verbose_name="Annee categorie entreprise"
                    ),
                ),
                (
                    "date_debut",
                    models.DateField(
                        blank=True, db_index=True, null=True, verbose_name="Date debut"
                    ),
                ),
                (
                    "etat_administratif_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Etat administratif unite legale",
                    ),
                ),
                (
                    "nom_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Nom unite legale"
                    ),
                ),
                (
                    "nom_usage_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Nom usage unite legale"
                    ),
                ),
                (
                    "denomination_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Denomination unite legale",
                    ),
                ),
                (
                    "denomination_usuelle1_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Denomination usuelle1 unite legale",
                    ),
                ),
                (
                    "denomination_usuelle2_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Denomination usuelle2 unite legale",
                    ),
                ),
                (
                    "denomination_usuelle3_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Denomination usuelle3 unite legale",
                    ),
                ),
                (
                    "categorie_juridique_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Categorie juridique unite legale",
                    ),
                ),
                (
                    "activite_principale_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Activite principale unite legale",
                    ),
                ),
                (
                    "nomenclature_activite_principale_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Nomenclature activite principale unite legale",
                    ),
                ),
                (
                    "nic_siege_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="NIC siege unite legale",
                    ),
                ),
                (
                    "economie_sociale_solidaire_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Economie sociale solidaire unite legale",
                    ),
                ),
                (
                    "societe_mission_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Societe mission unite legale",
                    ),
                ),
                (
                    "caractere_employeur_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Caractere employeur unite legale",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="UniteLegaleHistorique",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "date_fin",
                    models.DateField(
                        blank=True, db_index=True, null=True, verbose_name="Date fin"
                    ),
                ),
                (
                    "date_debut",
                    models.DateField(
                        blank=True, db_index=True, null=True, verbose_name="Date debut"
                    ),
                ),
                (
                    "etat_administratif_unite_legale",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Etat administratif unite legale",
                    ),
                ),
                (
                    "changement_etat_administratif_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement etat administratif unite legale",
                    ),
                ),
                (
                    "nom_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Nom unite legale"
                    ),
                ),
                (
                    "changement_nom_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement nom unite legale",
                    ),
                ),
                (
                    "nom_usage_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Nom usage unite legale"
                    ),
                ),
                (
                    "changement_nom_usage_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement nom usage unite legale",
                    ),
                ),
                (
                    "denomination_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="Denomination unite legale"
                    ),
                ),
                (
                    "changement_denomination_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement denomination unite legale",
                    ),
                ),
                (
                    "denomination_usuelle1_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Denomination usuelle1 unite legale",
                    ),
                ),
                (
                    "denomination_usuelle2_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Denomination usuelle2 unite legale",
                    ),
                ),
                (
                    "denomination_usuelle3_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Denomination usuelle3 unite legale",
                    ),
                ),
                (
                    "changement_denomination_usuelle_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement denomination usuelle unite legale",
                    ),
                ),
                (
                    "categorie_juridique_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Categorie juridique unite legale",
                    ),
                ),
                (
                    "changement_categorie_juridique_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement categorie juridique unite legale",
                    ),
                ),
                (
                    "activite_principale_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Activite principale unite legale",
                    ),
                ),
                (
                    "nomenclature_activite_principale_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Nomenclature activite principale unite legale",
                    ),
                ),
                (
                    "changement_activite_principale_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement activite principale unite legale",
                    ),
                ),
                (
                    "nic_siege_unite_legale",
                    models.CharField(
                        blank=True, null=True, verbose_name="NIC siege unite legale"
                    ),
                ),
                (
                    "changement_nic_siege_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement nic siege unite legale",
                    ),
                ),
                (
                    "economie_sociale_solidaire_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Economie sociale solidaire unite legale",
                    ),
                ),
                (
                    "changement_economie_sociale_solidaire_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement economie sociale solidaire unite legale",
                    ),
                ),
                (
                    "societe_mission_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Societe mission unite legale",
                    ),
                ),
                (
                    "changement_societe_mission_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement societe mission unite legale",
                    ),
                ),
                (
                    "caractere_employeur_unite_legale",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Caractere employeur unite legale",
                    ),
                ),
                (
                    "changement_caractere_employeur_unite_legale",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement caractere employeur unite legale",
                    ),
                ),
                (
                    "siren",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="unite_legale_historiques",
                        to="insee_sirene.unitelegale",
                        verbose_name="SIREN",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EtablissementLiensSuccession",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "date_lien_succession",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Date lien succession",
                    ),
                ),
                (
                    "transfert_siege",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Transfert siege",
                    ),
                ),
                (
                    "continuite_economique",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Continuite economique",
                    ),
                ),
                (
                    "date_dernier_traitement_lien_succession",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Date dernier traitement lien succession",
                    ),
                ),
                (
                    "siret_etablissement_predecesseur",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="etablissement_liens_succession_siret_etablissement_predecesseurs",
                        to="insee_sirene.etablissement",
                        verbose_name="SIRET etablissement predecesseur",
                    ),
                ),
                (
                    "siret_etablissement_successeur",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="etablissement_liens_succession_siret_etablissement_successeurs",
                        to="insee_sirene.etablissement",
                        verbose_name="SIRET etablissement successeur",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EtablissementHistorique",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nic",
                    models.CharField(
                        blank=True, db_index=True, null=True, verbose_name="NIC"
                    ),
                ),
                (
                    "date_fin",
                    models.DateField(
                        blank=True, db_index=True, null=True, verbose_name="Date fin"
                    ),
                ),
                (
                    "date_debut",
                    models.DateField(
                        blank=True, db_index=True, null=True, verbose_name="Date debut"
                    ),
                ),
                (
                    "etat_administratif_etablissement",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Etat administratif etablissement",
                    ),
                ),
                (
                    "changement_etat_administratif_etablissement",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement etat administratif etablissement",
                    ),
                ),
                (
                    "enseigne1_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Enseigne1 etablissement"
                    ),
                ),
                (
                    "enseigne2_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Enseigne2 etablissement"
                    ),
                ),
                (
                    "enseigne3_etablissement",
                    models.CharField(
                        blank=True, null=True, verbose_name="Enseigne3 etablissement"
                    ),
                ),
                (
                    "changement_enseigne_etablissement",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement enseigne etablissement",
                    ),
                ),
                (
                    "denomination_usuelle_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Denomination usuelle etablissement",
                    ),
                ),
                (
                    "changement_denomination_usuelle_etablissement",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement denomination usuelle etablissement",
                    ),
                ),
                (
                    "activite_principale_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Activite principale etablissement",
                    ),
                ),
                (
                    "nomenclature_activite_principale_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Nomenclature activite principale etablissement",
                    ),
                ),
                (
                    "changement_activite_principale_etablissement",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement activite principale etablissement",
                    ),
                ),
                (
                    "caractere_employeur_etablissement",
                    models.CharField(
                        blank=True,
                        null=True,
                        verbose_name="Caractere employeur etablissement",
                    ),
                ),
                (
                    "changement_caractere_employeur_etablissement",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Changement caractere employeur etablissement",
                    ),
                ),
                (
                    "siren",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="etablissement_historiques",
                        to="insee_sirene.unitelegale",
                        verbose_name="SIREN",
                    ),
                ),
                (
                    "siret",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="etablissement_historiques",
                        to="insee_sirene.etablissement",
                        verbose_name="SIRET",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="etablissement",
            name="siren",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="etablissements",
                to="insee_sirene.unitelegale",
                verbose_name="SIREN",
            ),
        ),
    ]
