# django-insee-sirene

Allow to download and import the [INSEE Sirène](https://www.data.gouv.fr/fr/datasets/base-sirene-des-entreprises-et-de-leurs-etablissements-siren-siret/) csv files in django models.

# Requirements

- Python 3.12+
- Django 4.2+

# Installation

- your `DB_ENGINE` setting must be `"django.contrib.gis.db.backends.postgis"`
- run `pip install django-insee-sirene`
- add `insee_sirene` to your `INSTALLED_APPS`
- run `python manage.py migrate insee_sirene`

# Download source files

You can use the download management command to download the csv source files :

```bash
python manage.py download_insee_sirene_csv_files
```

The files are downloaded and extracted in a `insee_sirene/management/commands/data` folder.
They can then be used by the `import_insee_sirene` and `generate_insee_sirene_models` commands.

**Caution:** Keep in mind that files are not removed after calling this command.

By default, the command doesn't re-download the files if they are already in the folder.

**Command options:**
 - *Force :* `-f` or `--force-download` : Force the download of the files
 - *Only :* `-o` or `--only` : Download only the given file (ex: -o StockEtablissement_utf8.zip)
 - *Keep archives :* `-k` or `--keep-archives` : Keep the .zip archives after extraction

# Import

Launch the import management command to download the source import files and download the data in the database :

```
python manage.py import_insee_sirene
```

**Command options:**
 - *Force :* `-f` or `--force-download` : Force the download of the files
 - *Keep sources folder :* `-k` or `--keep-sources-folder` : Keep downloaded sources folder after import
 - *Chunk size :*  `--chunk` : Amount of lines to read at once and objects bulk created (1000 by default)

# Update models

The models are generated by the `generate_insee_sirene_models` management command.
This command is used to easily generate the models from the csv import files and must be used only by the repository maintainer or if you wish to submit a merge request, following the [CONTRIBUTING.md](CONTRIBUTING.md) guide.






