# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rubberdoc', 'rubberdoc.examples']

package_data = \
{'': ['*']}

install_requires = \
['docstring-parser>=0.15,<0.16', 'typer[all]>=0.6.1,<0.7.0']

entry_points = \
{'console_scripts': ['rubberdoc = rubberdoc.main:app']}

setup_kwargs = {
    'name': 'rubberdoc',
    'version': '0.2.1',
    'description': '',
    'long_description': "![RubberDoc](https://live.staticflickr.com/65535/52459337826_244c259918_o.png)\n\n<div style='text-align:center'>The simple and extendable documentation generator</div>  \n\n---\n\n**Documentation** [https://rubberdoc.deta.dev](https://rubberdoc.deta.dev)  \n**Source Code** [https://github.com/pyn-sol/rubberdoc](https://github.com/pyn-sol/rubberdoc)\n\n---\n\n**RubberDoc** is a documentation generator that makes your docstrings come alive.  \nThe generator takes your python package as it is and translates it directly to a beautiful set of technical documentation.  \n\nCheck out the tutorials and documentation (generated by RubberDoc, of course!) at the link above.  \n\n`pip install rubberdoc` to get started!",
    'author': 'Mbeebe',
    'author_email': 'grow.food.everywhere@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
