/*
 * Decompiled with CFR 0.152.
 */
package engine.helper;

import engine.core.MarioSprite;
import engine.sprites.Enemy;
import engine.sprites.FlowerEnemy;

public enum SpriteType {
    NONE(0),
    UNDEF(-42),
    MARIO(-31),
    FIREBALL(16),
    GOOMBA(2, 16),
    GOOMBA_WINGED(3, 16),
    RED_KOOPA(4, 0),
    RED_KOOPA_WINGED(5, 0),
    GREEN_KOOPA(6, 8),
    GREEN_KOOPA_WINGED(7, 8),
    SPIKY(8, 24),
    SPIKY_WINGED(9, 24),
    BULLET_BILL(10, 40),
    ENEMY_FLOWER(11, 48),
    MUSHROOM(12),
    FIRE_FLOWER(13),
    SHELL(14),
    LIFE_MUSHROOM(15);

    private int value;
    private int startIndex;

    private SpriteType(int n2) {
        this.value = n2;
    }

    private SpriteType(int n2, int n3) {
        this.value = n2;
        this.startIndex = n3;
    }

    public int getValue() {
        return this.value;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public MarioSprite spawnSprite(boolean bl, int n, int n2, int n3) {
        if (this == ENEMY_FLOWER) {
            return new FlowerEnemy(bl, (float)(n * 16 + 17), n2 * 16 + 18);
        }
        return new Enemy(bl, n * 16 + 8, n2 * 16 + 15, n3, this);
    }
}

