/*
 * Decompiled with CFR 0.152.
 */
package engine.graphics;

import engine.graphics.MarioGraphics;
import engine.helper.TileFeature;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;

public class MarioTilemap
extends MarioGraphics {
    public Image[][] sheet;
    public int[][] currentIndeces;
    public int[][] indexShift;
    public float[][] moveShift;
    public int animationIndex;

    public MarioTilemap(Image[][] imageArray, int[][] nArray) {
        this.sheet = imageArray;
        this.currentIndeces = nArray;
        this.indexShift = new int[nArray.length][nArray[0].length];
        this.moveShift = new float[nArray.length][nArray[0].length];
        this.animationIndex = 0;
    }

    @Override
    public void render(Graphics graphics, int n, int n2) {
        this.animationIndex = (this.animationIndex + 1) % 5;
        int n3 = n / 16 - 1;
        int n4 = n2 / 16 - 1;
        int n5 = (n + 256) / 16 + 1;
        int n6 = (n2 + 256) / 16 + 1;
        for (int i = n3; i <= n5; ++i) {
            for (int j = n4; j <= n6; ++j) {
                ArrayList<TileFeature> arrayList;
                if (i < 0 || j < 0 || i >= this.currentIndeces.length || j >= this.currentIndeces[0].length) continue;
                if (this.moveShift[i][j] > 0.0f) {
                    float[] fArray = this.moveShift[i];
                    int n7 = j;
                    fArray[n7] = fArray[n7] - 1.0f;
                    if (this.moveShift[i][j] < 0.0f) {
                        this.moveShift[i][j] = 0.0f;
                    }
                }
                if ((arrayList = TileFeature.getTileType(this.currentIndeces[i][j])).contains((Object)TileFeature.ANIMATED)) {
                    if (this.animationIndex == 0) {
                        this.indexShift[i][j] = (this.indexShift[i][j] + 1) % 3;
                    }
                } else {
                    this.indexShift[i][j] = 0;
                }
                int n8 = this.currentIndeces[i][j] + this.indexShift[i][j];
                int n9 = (int)this.moveShift[i][j];
                Image image = this.sheet[n8 % 8][n8 / 8];
                graphics.drawImage(image, i * 16 - n, j * 16 - n2 - n9, null);
            }
        }
    }
}

