/*
 * Decompiled with CFR 0.152.
 */
package engine.graphics;

import engine.graphics.MarioGraphics;
import engine.helper.Assets;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;

public class MarioBackground
extends MarioGraphics {
    private Image image;
    private Graphics2D g;
    private int screenWidth;

    public MarioBackground(GraphicsConfiguration graphicsConfiguration, int n, int[][] nArray) {
        this.width = nArray[0].length * 16;
        this.height = nArray.length * 16;
        this.screenWidth = n;
        this.image = graphicsConfiguration.createCompatibleImage(this.width, this.height, 2);
        this.g = (Graphics2D)this.image.getGraphics();
        this.g.setComposite(AlphaComposite.Src);
        this.updateArea(nArray);
    }

    private void updateArea(int[][] nArray) {
        this.g.setBackground(new Color(0, 0, 0, 0));
        this.g.clearRect(0, 0, this.width, this.height);
        for (int i = 0; i < nArray[0].length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                int n = nArray[j][i] % 8;
                int n2 = nArray[j][i] / 8;
                this.g.drawImage(Assets.level[n][n2], i * 16, j * 16, 16, 16, null);
            }
        }
    }

    @Override
    public void render(Graphics graphics, int n, int n2) {
        int n3 = n % this.width;
        for (int i = -1; i < this.screenWidth / this.width + 1; ++i) {
            graphics.drawImage(this.image, -n3 + i * this.width, 0, null);
        }
    }
}

