/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioWorld;
import engine.helper.Assets;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.JComponent;

public class MarioRender
extends JComponent
implements FocusListener {
    private static final long serialVersionUID = 790878775993203817L;
    public static final int TICKS_PER_SECOND = 24;
    private float scale;
    private GraphicsConfiguration graphicsConfiguration;
    int frame;
    Thread animator;
    boolean focused;

    public MarioRender(float f) {
        this.setFocusable(true);
        this.setEnabled(true);
        this.scale = f;
        Dimension dimension = new Dimension((int)(256.0f * f), (int)(240.0f * f));
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setFocusable(true);
    }

    public void init() {
        this.graphicsConfiguration = this.getGraphicsConfiguration();
        Assets.init(this.graphicsConfiguration);
    }

    public void renderWorld(MarioWorld marioWorld, Image image, Graphics graphics, Graphics graphics2) {
        graphics2.fillRect(0, 0, 256, 240);
        marioWorld.render(graphics2);
        this.drawStringDropShadow(graphics2, "Lives: " + marioWorld.lives, 0, 0, 7);
        this.drawStringDropShadow(graphics2, "Coins: " + marioWorld.coins, 11, 0, 7);
        this.drawStringDropShadow(graphics2, "Time: " + (Serializable)(marioWorld.currentTimer == -1 ? "Inf" : Integer.valueOf((int)Math.ceil((float)marioWorld.currentTimer / 1000.0f))), 22, 0, 7);
        if (this.scale > 1.0f) {
            graphics.drawImage(image, 0, 0, (int)(256.0f * this.scale), (int)(240.0f * this.scale), null);
        } else {
            graphics.drawImage(image, 0, 0, null);
        }
    }

    public void drawStringDropShadow(Graphics graphics, String string, int n, int n2, int n3) {
        this.drawString(graphics, string, n * 8 + 5, n2 * 8 + 5, 0);
        this.drawString(graphics, string, n * 8 + 4, n2 * 8 + 4, n3);
    }

    private void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            graphics.drawImage(Assets.font[cArray[i] - 32][n3], n + i * 8, n2, null);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.focused = true;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.focused = false;
    }
}

