/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioAgent;
import engine.core.MarioAgentEvent;
import engine.core.MarioEvent;
import engine.core.MarioForwardModel;
import engine.core.MarioRender;
import engine.core.MarioTimer;
import engine.core.MarioWorld;
import engine.helper.MarioActions;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import javax.swing.JFrame;

public class MarioGame {
    public static final long maxTime = 40L;
    public static final long graceTime = 10L;
    public static final int width = 256;
    public static final int height = 256;
    public static final int tileWidth = 16;
    public static final int tileHeight = 16;
    public static final boolean verbose = false;
    public boolean pause = false;
    private MarioEvent[] killEvents;
    public JFrame window = null;
    private MarioRender render = null;
    private MarioAgent agent = null;
    public MarioWorld world = null;
    public ArrayList<MarioEvent> gameEvents = null;
    public ArrayList<MarioAgentEvent> agentEvents = null;
    public MarioTimer agentTimer = null;
    public VolatileImage renderTarget = null;
    public Graphics backBuffer = null;
    public Graphics currentBuffer = null;
    public long currentTime = 0L;
    public boolean visuals = true;

    public MarioGame() {
    }

    public MarioGame(MarioEvent[] marioEventArray) {
        this.killEvents = marioEventArray;
    }

    private void setAgent(MarioAgent marioAgent) {
        this.agent = marioAgent;
        if (marioAgent instanceof KeyAdapter) {
            this.render.addKeyListener((KeyAdapter)((Object)this.agent));
        }
    }

    public void runGameN(MarioAgent marioAgent, String string, int n, int n2, boolean bl) {
        float f = 2.0f;
        this.visuals = bl;
        if (this.window != null) {
            this.window.setVisible(false);
            this.window.dispose();
        }
        this.render = null;
        if (this.visuals) {
            this.window = new JFrame("Mario AI Framework");
            this.render = new MarioRender(f);
            this.window.setContentPane(this.render);
            this.window.pack();
            this.window.setResizable(false);
            this.window.setDefaultCloseOperation(3);
            this.render.init();
            this.window.setVisible(true);
        }
        this.setAgent(marioAgent);
        this.initial(string, n, n2);
    }

    public void initial(String string, int n, int n2) {
        this.world = new MarioWorld(this.killEvents);
        this.world.visuals = this.visuals;
        this.world.initializeLevel(string, 1000 * n);
        if (this.visuals) {
            this.world.initializeVisuals(this.render.getGraphicsConfiguration());
        }
        this.world.mario.isLarge = n2 > 0;
        this.world.mario.isFire = n2 > 1;
        this.world.update(new boolean[MarioActions.numberOfActions()]);
        this.currentTime = System.currentTimeMillis();
        if (this.visuals) {
            this.renderTarget = this.render.createVolatileImage(256, 256);
            this.backBuffer = this.render.getGraphics();
            this.currentBuffer = this.renderTarget.getGraphics();
            this.render.addFocusListener(this.render);
        }
        this.agent.initialize(new MarioForwardModel(this.world.clone()), this.agentTimer);
        this.gameEvents = new ArrayList();
        this.agentEvents = new ArrayList();
    }

    public void step() {
        if (!this.pause) {
            this.agentTimer = new MarioTimer(40L);
            boolean[] blArray = this.agent.getActions(new MarioForwardModel(this.world.clone()), this.agentTimer);
            this.world.update(blArray);
            this.gameEvents.addAll(this.world.lastFrameEvents);
            this.agentEvents.add(new MarioAgentEvent(blArray, this.world.mario.x, this.world.mario.y, (this.world.mario.isLarge ? 1 : 0) + (this.world.mario.isFire ? 1 : 0), this.world.mario.onGround, this.world.currentTick));
        }
        if (this.visuals) {
            this.render.renderWorld(this.world, this.renderTarget, this.backBuffer, this.currentBuffer);
        }
    }
}

