/*
 * Decompiled with CFR 0.152.
 */
import agents.bridge.Agent;
import engine.core.MarioAgent;
import engine.core.MarioGame;
import engine.core.MarioResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class PlayLevel {
    public static MarioAgent agent = new Agent();
    public static MarioGame game = new MarioGame();
    public static String level = "/home/micha/Source/smb-gym/original/lvl-1.txt";

    public static void printResults(MarioResult marioResult) {
        System.out.println("****************************************************************");
        System.out.println("Game Status: " + marioResult.getGameStatus().toString() + " Percentage Completion: " + marioResult.getCompletionPercentage() * 100.0f);
        System.out.println("Lives: " + marioResult.getCurrentLives() + " Coins: " + marioResult.getCurrentCoins() + " Remaining Time: " + (int)Math.ceil((float)marioResult.getRemainingTime() / 1000.0f));
        System.out.println("Mario State: " + marioResult.getMarioMode() + " (Mushrooms: " + marioResult.getNumCollectedMushrooms() + " Fire Flowers: " + marioResult.getNumCollectedFireflower() + ")");
        System.out.println("Total Kills: " + marioResult.getKillsTotal() + " (Stomps: " + marioResult.getKillsByStomp() + " Fireballs: " + marioResult.getKillsByFire() + " Shells: " + marioResult.getKillsByShell() + " Falls: " + marioResult.getKillsByFall() + ")");
        System.out.println("Bricks: " + marioResult.getNumDestroyedBricks() + " Jumps: " + marioResult.getNumJumps() + " Max X Jump: " + marioResult.getMaxXJump() + " Max Air Time: " + marioResult.getMaxJumpAirTime());
        System.out.println("****************************************************************");
    }

    public static String getLevel(String string) {
        String string2 = "";
        try {
            string2 = new String(Files.readAllBytes(Paths.get(string, new String[0])));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public void initializeWithGraphics() {
        game.runGameN(agent, PlayLevel.getLevel(level), 20, 0, true);
    }

    public void initializeHeadless() {
        game.runGameN(agent, PlayLevel.getLevel(level), 20, 0, false);
    }

    public void closeWindow() {
        PlayLevel.game.window.setVisible(false);
        PlayLevel.game.window.dispose();
    }
}

