function _aws_cdk_aws_stepfunctions_tasks_InvokeFunctionProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("payload" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.InvokeFunctionProps#payload", "use `LambdaInvoke`");
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_InvokeFunction(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_RunLambdaTaskProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("clientContext" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunLambdaTaskProps#clientContext", "Use `LambdaInvoke`");
        if ("integrationPattern" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunLambdaTaskProps#integrationPattern", "Use `LambdaInvoke`");
        if ("invocationType" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunLambdaTaskProps#invocationType", "Use `LambdaInvoke`");
        if (!visitedObjects.has(p.invocationType))
            _aws_cdk_aws_stepfunctions_tasks_InvocationType(p.invocationType);
        if ("payload" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunLambdaTaskProps#payload", "Use `LambdaInvoke`");
        if ("qualifier" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunLambdaTaskProps#qualifier", "pass a Version or Alias object as lambdaFunction instead");
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_RunLambdaTask(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_InvocationType(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        print("@aws-cdk/aws-stepfunctions-tasks.InvocationType", "use `LambdaInvocationType`");
        const ns = require("./lib/lambda/run-lambda-task.js");
        if (Object.values(ns.InvocationType).filter(x => x === p).length > 1)
            return;
        if (p === ns.InvocationType.REQUEST_RESPONSE)
            print("@aws-cdk/aws-stepfunctions-tasks.InvocationType#REQUEST_RESPONSE", "");
        if (p === ns.InvocationType.EVENT)
            print("@aws-cdk/aws-stepfunctions-tasks.InvocationType#EVENT", "");
        if (p === ns.InvocationType.DRY_RUN)
            print("@aws-cdk/aws-stepfunctions-tasks.InvocationType#DRY_RUN", "");
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_LambdaInvokeProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.invocationType))
            _aws_cdk_aws_stepfunctions_tasks_LambdaInvocationType(p.invocationType);
        if ("qualifier" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.LambdaInvokeProps#qualifier", "pass a Version or Alias object as lambdaFunction instead");
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_LambdaInvoke(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_LambdaInvocationType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_InvokeActivityProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("heartbeat" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.InvokeActivityProps#heartbeat", "use `StepFunctionsInvokeActivity` and `StepFunctionsInvokeActivityProps`.");
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_InvokeActivity(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_CommonEcsRunTaskProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.containerOverrides != null)
            for (const o of p.containerOverrides)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_ContainerOverride(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EcsRunTaskBaseProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("parameters" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.EcsRunTaskBaseProps#parameters", "No replacement");
        if (p.containerOverrides != null)
            for (const o of p.containerOverrides)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_ContainerOverride(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EcsRunTaskBase(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ContainerOverride(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.environment != null)
            for (const o of p.environment)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_TaskEnvironmentVariable(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_TaskEnvironmentVariable(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_PublishToTopicProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("message" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.PublishToTopicProps#message", "Use `SnsPublish`");
        if ("integrationPattern" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.PublishToTopicProps#integrationPattern", "Use `SnsPublish`");
        if ("messagePerSubscriptionType" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.PublishToTopicProps#messagePerSubscriptionType", "Use `SnsPublish`");
        if ("subject" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.PublishToTopicProps#subject", "Use `SnsPublish`");
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_PublishToTopic(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_MessageAttributeDataType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_MessageAttribute(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.dataType))
            _aws_cdk_aws_stepfunctions_tasks_MessageAttributeDataType(p.dataType);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_SnsPublishProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.messageAttributes != null)
            for (const o of Object.values(p.messageAttributes))
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_MessageAttribute(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_SnsPublish(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SendToQueueProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("messageBody" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.SendToQueueProps#messageBody", "Use `SqsSendMessage`");
        if ("delay" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.SendToQueueProps#delay", "Use `SqsSendMessage`");
        if ("integrationPattern" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.SendToQueueProps#integrationPattern", "Use `SqsSendMessage`");
        if ("messageDeduplicationId" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.SendToQueueProps#messageDeduplicationId", "Use `SqsSendMessage`");
        if ("messageGroupId" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.SendToQueueProps#messageGroupId", "Use `SqsSendMessage`");
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_SendToQueue(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SqsSendMessageProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SqsSendMessage(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_RunEcsEc2TaskProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("placementConstraints" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunEcsEc2TaskProps#placementConstraints", "use `EcsRunTask` and `EcsRunTaskProps`");
        if (p.placementConstraints != null)
            for (const o of p.placementConstraints)
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-ecs/.warnings.jsii.js")._aws_cdk_aws_ecs_PlacementConstraint(o);
        if ("placementStrategies" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunEcsEc2TaskProps#placementStrategies", "use `EcsRunTask` and `EcsRunTaskProps`");
        if (p.placementStrategies != null)
            for (const o of p.placementStrategies)
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-ecs/.warnings.jsii.js")._aws_cdk_aws_ecs_PlacementStrategy(o);
        if ("securityGroup" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunEcsEc2TaskProps#securityGroup", "use `EcsRunTask` and `EcsRunTaskProps`");
        if ("subnets" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunEcsEc2TaskProps#subnets", "use `EcsRunTask` and `EcsRunTaskProps`");
        if (p.containerOverrides != null)
            for (const o of p.containerOverrides)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_ContainerOverride(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_RunEcsEc2Task(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_RunEcsFargateTaskProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("assignPublicIp" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunEcsFargateTaskProps#assignPublicIp", "replaced by `EcsRunTask` and `EcsRunTaskProps`");
        if ("platformVersion" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunEcsFargateTaskProps#platformVersion", "replaced by `EcsRunTask` and `EcsRunTaskProps`");
        if ("securityGroup" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunEcsFargateTaskProps#securityGroup", "replaced by `EcsRunTask` and `EcsRunTaskProps`");
        if ("subnets" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunEcsFargateTaskProps#subnets", "replaced by `EcsRunTask` and `EcsRunTaskProps`");
        if (p.containerOverrides != null)
            for (const o of p.containerOverrides)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_ContainerOverride(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_RunEcsFargateTask(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EcsRunTaskProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.launchTarget))
            _aws_cdk_aws_stepfunctions_tasks_IEcsLaunchTarget(p.launchTarget);
        if (p.containerOverrides != null)
            for (const o of p.containerOverrides)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_ContainerOverride(o);
        if (p.securityGroups != null)
            for (const o of p.securityGroups)
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-ec2/.warnings.jsii.js")._aws_cdk_aws_ec2_ISecurityGroup(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_IEcsLaunchTarget(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_LaunchTargetBindOptions(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EcsLaunchTargetConfig(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EcsFargateLaunchTargetOptions(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EcsEc2LaunchTargetOptions(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.placementConstraints != null)
            for (const o of p.placementConstraints)
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-ecs/.warnings.jsii.js")._aws_cdk_aws_ecs_PlacementConstraint(o);
        if (p.placementStrategies != null)
            for (const o of p.placementStrategies)
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-ecs/.warnings.jsii.js")._aws_cdk_aws_ecs_PlacementStrategy(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EcsFargateLaunchTarget(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EcsEc2LaunchTarget(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EcsRunTask(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ISageMakerTask(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AlgorithmSpecification(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.metricDefinitions != null)
            for (const o of p.metricDefinitions)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_MetricDefinition(o);
        if (!visitedObjects.has(p.trainingImage))
            _aws_cdk_aws_stepfunctions_tasks_DockerImage(p.trainingImage);
        if (!visitedObjects.has(p.trainingInputMode))
            _aws_cdk_aws_stepfunctions_tasks_InputMode(p.trainingInputMode);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_Channel(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.dataSource))
            _aws_cdk_aws_stepfunctions_tasks_DataSource(p.dataSource);
        if (!visitedObjects.has(p.compressionType))
            _aws_cdk_aws_stepfunctions_tasks_CompressionType(p.compressionType);
        if (!visitedObjects.has(p.inputMode))
            _aws_cdk_aws_stepfunctions_tasks_InputMode(p.inputMode);
        if (!visitedObjects.has(p.recordWrapperType))
            _aws_cdk_aws_stepfunctions_tasks_RecordWrapperType(p.recordWrapperType);
        if (!visitedObjects.has(p.shuffleConfig))
            _aws_cdk_aws_stepfunctions_tasks_ShuffleConfig(p.shuffleConfig);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_ShuffleConfig(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DataSource(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.s3DataSource))
            _aws_cdk_aws_stepfunctions_tasks_S3DataSource(p.s3DataSource);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_S3DataSource(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.s3Location))
            _aws_cdk_aws_stepfunctions_tasks_S3Location(p.s3Location);
        if (!visitedObjects.has(p.s3DataDistributionType))
            _aws_cdk_aws_stepfunctions_tasks_S3DataDistributionType(p.s3DataDistributionType);
        if (!visitedObjects.has(p.s3DataType))
            _aws_cdk_aws_stepfunctions_tasks_S3DataType(p.s3DataType);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_OutputDataConfig(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.s3OutputLocation))
            _aws_cdk_aws_stepfunctions_tasks_S3Location(p.s3OutputLocation);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_StoppingCondition(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ResourceConfig(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_VpcConfig(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_MetricDefinition(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_S3LocationConfig(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_S3Location(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_S3LocationBindOptions(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DockerImageConfig(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DockerImage(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_S3DataType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_S3DataDistributionType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_RecordWrapperType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_InputMode(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_CompressionType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ModelClientOptions(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_TransformInput(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.transformDataSource))
            _aws_cdk_aws_stepfunctions_tasks_TransformDataSource(p.transformDataSource);
        if (!visitedObjects.has(p.compressionType))
            _aws_cdk_aws_stepfunctions_tasks_CompressionType(p.compressionType);
        if (!visitedObjects.has(p.splitType))
            _aws_cdk_aws_stepfunctions_tasks_SplitType(p.splitType);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_TransformDataSource(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.s3DataSource))
            _aws_cdk_aws_stepfunctions_tasks_TransformS3DataSource(p.s3DataSource);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_TransformS3DataSource(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.s3DataType))
            _aws_cdk_aws_stepfunctions_tasks_S3DataType(p.s3DataType);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_TransformOutput(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.assembleWith))
            _aws_cdk_aws_stepfunctions_tasks_AssembleWith(p.assembleWith);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_TransformResources(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ContainerDefinitionOptions(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.image))
            _aws_cdk_aws_stepfunctions_tasks_DockerImage(p.image);
        if (!visitedObjects.has(p.mode))
            _aws_cdk_aws_stepfunctions_tasks_Mode(p.mode);
        if (!visitedObjects.has(p.modelS3Location))
            _aws_cdk_aws_stepfunctions_tasks_S3Location(p.modelS3Location);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_ContainerDefinition(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_IContainerDefinition(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ContainerDefinitionConfig(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_Mode(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ProductionVariant(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.acceleratorType))
            _aws_cdk_aws_stepfunctions_tasks_AcceleratorType(p.acceleratorType);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_AcceleratorClass(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AcceleratorType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_BatchStrategy(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SplitType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AssembleWith(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateTrainingJobProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.algorithmSpecification))
            _aws_cdk_aws_stepfunctions_tasks_AlgorithmSpecification(p.algorithmSpecification);
        if (p.inputDataConfig != null)
            for (const o of p.inputDataConfig)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_Channel(o);
        if (!visitedObjects.has(p.outputDataConfig))
            _aws_cdk_aws_stepfunctions_tasks_OutputDataConfig(p.outputDataConfig);
        if (!visitedObjects.has(p.resourceConfig))
            _aws_cdk_aws_stepfunctions_tasks_ResourceConfig(p.resourceConfig);
        if (!visitedObjects.has(p.stoppingCondition))
            _aws_cdk_aws_stepfunctions_tasks_StoppingCondition(p.stoppingCondition);
        if (!visitedObjects.has(p.vpcConfig))
            _aws_cdk_aws_stepfunctions_tasks_VpcConfig(p.vpcConfig);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateTrainingJob(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateTransformJobProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.transformInput))
            _aws_cdk_aws_stepfunctions_tasks_TransformInput(p.transformInput);
        if (!visitedObjects.has(p.transformOutput))
            _aws_cdk_aws_stepfunctions_tasks_TransformOutput(p.transformOutput);
        if (!visitedObjects.has(p.batchStrategy))
            _aws_cdk_aws_stepfunctions_tasks_BatchStrategy(p.batchStrategy);
        if (!visitedObjects.has(p.modelClientOptions))
            _aws_cdk_aws_stepfunctions_tasks_ModelClientOptions(p.modelClientOptions);
        if (!visitedObjects.has(p.transformResources))
            _aws_cdk_aws_stepfunctions_tasks_TransformResources(p.transformResources);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateTransformJob(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateEndpointProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateEndpoint(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateEndpointConfigProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.productionVariants != null)
            for (const o of p.productionVariants)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_ProductionVariant(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateEndpointConfig(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateModelProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.primaryContainer))
            _aws_cdk_aws_stepfunctions_tasks_IContainerDefinition(p.primaryContainer);
        if (p.containers != null)
            for (const o of p.containers)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_IContainerDefinition(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateModel(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerUpdateEndpointProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SageMakerUpdateEndpoint(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_StartExecutionProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("input" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.StartExecutionProps#input", "- use 'StepFunctionsStartExecution'");
        if ("integrationPattern" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.StartExecutionProps#integrationPattern", "- use 'StepFunctionsStartExecution'");
        if ("name" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.StartExecutionProps#name", "- use 'StepFunctionsStartExecution'");
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_StartExecution(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_StepFunctionsStartExecutionProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_StepFunctionsStartExecution(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_StepFunctionsInvokeActivityProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_StepFunctionsInvokeActivity(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EvaluateExpressionProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EvaluateExpression(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateClusterProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.instances))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstancesConfigProperty(p.instances);
        if (p.applications != null)
            for (const o of p.applications)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ApplicationConfigProperty(o);
        if (p.bootstrapActions != null)
            for (const o of p.bootstrapActions)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_BootstrapActionConfigProperty(o);
        if (p.configurations != null)
            for (const o of p.configurations)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ConfigurationProperty(o);
        if (!visitedObjects.has(p.kerberosAttributes))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_KerberosAttributesProperty(p.kerberosAttributes);
        if (!visitedObjects.has(p.scaleDownBehavior))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EmrClusterScaleDownBehavior(p.scaleDownBehavior);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EmrClusterScaleDownBehavior(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceRoleType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EbsBlockDeviceVolumeType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_VolumeSpecificationProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.volumeType))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EbsBlockDeviceVolumeType(p.volumeType);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EbsBlockDeviceConfigProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.volumeSpecification))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_VolumeSpecificationProperty(p.volumeSpecification);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EbsConfigurationProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.ebsBlockDeviceConfigs != null)
            for (const o of p.ebsBlockDeviceConfigs)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EbsBlockDeviceConfigProperty(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceTypeConfigProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.configurations != null)
            for (const o of p.configurations)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ConfigurationProperty(o);
        if (!visitedObjects.has(p.ebsConfiguration))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EbsConfigurationProperty(p.ebsConfiguration);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SpotTimeoutAction(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SpotAllocationStrategy(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SpotProvisioningSpecificationProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.timeoutAction))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SpotTimeoutAction(p.timeoutAction);
        if (!visitedObjects.has(p.allocationStrategy))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SpotAllocationStrategy(p.allocationStrategy);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceFleetProvisioningSpecificationsProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.spotSpecification))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SpotProvisioningSpecificationProperty(p.spotSpecification);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceFleetConfigProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.instanceFleetType))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceRoleType(p.instanceFleetType);
        if (p.instanceTypeConfigs != null)
            for (const o of p.instanceTypeConfigs)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceTypeConfigProperty(o);
        if (!visitedObjects.has(p.launchSpecifications))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceFleetProvisioningSpecificationsProperty(p.launchSpecifications);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmComparisonOperator(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmStatistic(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmUnit(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_MetricDimensionProperty(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmDefinitionProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.comparisonOperator))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmComparisonOperator(p.comparisonOperator);
        if (p.dimensions != null)
            for (const o of p.dimensions)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_MetricDimensionProperty(o);
        if (!visitedObjects.has(p.statistic))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmStatistic(p.statistic);
        if (!visitedObjects.has(p.unit))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmUnit(p.unit);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingTriggerProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.cloudWatchAlarmDefinition))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmDefinitionProperty(p.cloudWatchAlarmDefinition);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceMarket(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingAdjustmentType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SimpleScalingPolicyConfigurationProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.adjustmentType))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingAdjustmentType(p.adjustmentType);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingActionProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.simpleScalingPolicyConfiguration))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SimpleScalingPolicyConfigurationProperty(p.simpleScalingPolicyConfiguration);
        if (!visitedObjects.has(p.market))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceMarket(p.market);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingRuleProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.action))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingActionProperty(p.action);
        if (!visitedObjects.has(p.trigger))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingTriggerProperty(p.trigger);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingConstraintsProperty(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_AutoScalingPolicyProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.constraints))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingConstraintsProperty(p.constraints);
        if (p.rules != null)
            for (const o of p.rules)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingRuleProperty(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceGroupConfigProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.instanceRole))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceRoleType(p.instanceRole);
        if (!visitedObjects.has(p.autoScalingPolicy))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_AutoScalingPolicyProperty(p.autoScalingPolicy);
        if (p.configurations != null)
            for (const o of p.configurations)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ConfigurationProperty(o);
        if (!visitedObjects.has(p.ebsConfiguration))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EbsConfigurationProperty(p.ebsConfiguration);
        if (!visitedObjects.has(p.market))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceMarket(p.market);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_PlacementTypeProperty(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstancesConfigProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.instanceFleets != null)
            for (const o of p.instanceFleets)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceFleetConfigProperty(o);
        if (p.instanceGroups != null)
            for (const o of p.instanceGroups)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceGroupConfigProperty(o);
        if (!visitedObjects.has(p.placement))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_PlacementTypeProperty(p.placement);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ApplicationConfigProperty(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScriptBootstrapActionConfigProperty(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_BootstrapActionConfigProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.scriptBootstrapAction))
            _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScriptBootstrapActionConfigProperty(p.scriptBootstrapAction);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ConfigurationProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.configurations != null)
            for (const o of p.configurations)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ConfigurationProperty(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_KerberosAttributesProperty(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrSetClusterTerminationProtectionProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrSetClusterTerminationProtection(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrTerminateClusterProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrTerminateCluster(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ActionOnFailure(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrAddStepProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.actionOnFailure))
            _aws_cdk_aws_stepfunctions_tasks_ActionOnFailure(p.actionOnFailure);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrAddStep(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCancelStepProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrCancelStep(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceFleetByNameProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceFleetByName(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByNameProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.instanceGroup))
            _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName_InstanceGroupModifyConfigProperty(p.instanceGroup);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName_InstanceResizePolicyProperty(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName_ShrinkPolicyProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.instanceResizePolicy))
            _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName_InstanceResizePolicyProperty(p.instanceResizePolicy);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName_InstanceGroupModifyConfigProperty(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.configurations != null)
            for (const o of p.configurations)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ConfigurationProperty(o);
        if (!visitedObjects.has(p.shrinkPolicy))
            _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName_ShrinkPolicyProperty(p.shrinkPolicy);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EksClusterInput(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrContainersCreateVirtualClusterProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.eksCluster))
            _aws_cdk_aws_stepfunctions_tasks_EksClusterInput(p.eksCluster);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrContainersCreateVirtualCluster(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrContainersDeleteVirtualClusterProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrContainersDeleteVirtualCluster(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EmrContainersStartJobRunProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.jobDriver))
            _aws_cdk_aws_stepfunctions_tasks_JobDriver(p.jobDriver);
        if (!visitedObjects.has(p.releaseLabel))
            _aws_cdk_aws_stepfunctions_tasks_ReleaseLabel(p.releaseLabel);
        if (!visitedObjects.has(p.virtualCluster))
            _aws_cdk_aws_stepfunctions_tasks_VirtualClusterInput(p.virtualCluster);
        if (p.applicationConfig != null)
            for (const o of p.applicationConfig)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_ApplicationConfiguration(o);
        if (!visitedObjects.has(p.monitoring))
            _aws_cdk_aws_stepfunctions_tasks_Monitoring(p.monitoring);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EmrContainersStartJobRun(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_SparkSubmitJobDriver(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_JobDriver(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.sparkSubmitJobDriver))
            _aws_cdk_aws_stepfunctions_tasks_SparkSubmitJobDriver(p.sparkSubmitJobDriver);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_Classification(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ApplicationConfiguration(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.classification))
            _aws_cdk_aws_stepfunctions_tasks_Classification(p.classification);
        if (p.nestedConfig != null)
            for (const o of p.nestedConfig)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_ApplicationConfiguration(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_Monitoring(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ReleaseLabel(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_VirtualClusterInput(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_RunGlueJobTaskProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("arguments" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunGlueJobTaskProps#arguments", "use `GlueStartJobRun`");
        if ("integrationPattern" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunGlueJobTaskProps#integrationPattern", "use `GlueStartJobRun`");
        if ("notifyDelayAfter" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunGlueJobTaskProps#notifyDelayAfter", "use `GlueStartJobRun`");
        if ("securityConfiguration" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunGlueJobTaskProps#securityConfiguration", "use `GlueStartJobRun`");
        if ("timeout" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunGlueJobTaskProps#timeout", "use `GlueStartJobRun`");
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_RunGlueJobTask(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_GlueStartJobRunProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_GlueStartJobRun(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ContainerOverrides(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_JobDependency(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_RunBatchJobProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if ("jobDefinitionArn" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunBatchJobProps#jobDefinitionArn", "use `BatchSubmitJob`");
        if ("jobName" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunBatchJobProps#jobName", "use `BatchSubmitJob`");
        if ("jobQueueArn" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunBatchJobProps#jobQueueArn", "use `BatchSubmitJob`");
        if ("arraySize" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunBatchJobProps#arraySize", "use `BatchSubmitJob`");
        if ("attempts" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunBatchJobProps#attempts", "use `BatchSubmitJob`");
        if ("containerOverrides" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunBatchJobProps#containerOverrides", "use `BatchSubmitJob`");
        if (!visitedObjects.has(p.containerOverrides))
            _aws_cdk_aws_stepfunctions_tasks_ContainerOverrides(p.containerOverrides);
        if ("dependsOn" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunBatchJobProps#dependsOn", "use `BatchSubmitJob`");
        if (p.dependsOn != null)
            for (const o of p.dependsOn)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_JobDependency(o);
        if ("integrationPattern" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunBatchJobProps#integrationPattern", "use `BatchSubmitJob`");
        if ("payload" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunBatchJobProps#payload", "use `BatchSubmitJob`");
        if ("timeout" in p)
            print("@aws-cdk/aws-stepfunctions-tasks.RunBatchJobProps#timeout", "use `BatchSubmitJob`");
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_RunBatchJob(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_BatchContainerOverrides(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_BatchJobDependency(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_BatchSubmitJobProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.containerOverrides))
            _aws_cdk_aws_stepfunctions_tasks_BatchContainerOverrides(p.containerOverrides);
        if (p.dependsOn != null)
            for (const o of p.dependsOn)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_BatchJobDependency(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_BatchSubmitJob(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoGetItemProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.key != null)
            for (const o of Object.values(p.key))
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_DynamoAttributeValue(o);
        if (p.projectionExpression != null)
            for (const o of p.projectionExpression)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_DynamoProjectionExpression(o);
        if (!visitedObjects.has(p.returnConsumedCapacity))
            _aws_cdk_aws_stepfunctions_tasks_DynamoConsumedCapacity(p.returnConsumedCapacity);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoGetItem(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoPutItemProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.item != null)
            for (const o of Object.values(p.item))
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_DynamoAttributeValue(o);
        if (p.expressionAttributeValues != null)
            for (const o of Object.values(p.expressionAttributeValues))
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_DynamoAttributeValue(o);
        if (!visitedObjects.has(p.returnConsumedCapacity))
            _aws_cdk_aws_stepfunctions_tasks_DynamoConsumedCapacity(p.returnConsumedCapacity);
        if (!visitedObjects.has(p.returnItemCollectionMetrics))
            _aws_cdk_aws_stepfunctions_tasks_DynamoItemCollectionMetrics(p.returnItemCollectionMetrics);
        if (!visitedObjects.has(p.returnValues))
            _aws_cdk_aws_stepfunctions_tasks_DynamoReturnValues(p.returnValues);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoPutItem(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoUpdateItemProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.key != null)
            for (const o of Object.values(p.key))
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_DynamoAttributeValue(o);
        if (p.expressionAttributeValues != null)
            for (const o of Object.values(p.expressionAttributeValues))
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_DynamoAttributeValue(o);
        if (!visitedObjects.has(p.returnConsumedCapacity))
            _aws_cdk_aws_stepfunctions_tasks_DynamoConsumedCapacity(p.returnConsumedCapacity);
        if (!visitedObjects.has(p.returnItemCollectionMetrics))
            _aws_cdk_aws_stepfunctions_tasks_DynamoItemCollectionMetrics(p.returnItemCollectionMetrics);
        if (!visitedObjects.has(p.returnValues))
            _aws_cdk_aws_stepfunctions_tasks_DynamoReturnValues(p.returnValues);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoUpdateItem(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoDeleteItemProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.key != null)
            for (const o of Object.values(p.key))
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_DynamoAttributeValue(o);
        if (p.expressionAttributeValues != null)
            for (const o of Object.values(p.expressionAttributeValues))
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_DynamoAttributeValue(o);
        if (!visitedObjects.has(p.returnConsumedCapacity))
            _aws_cdk_aws_stepfunctions_tasks_DynamoConsumedCapacity(p.returnConsumedCapacity);
        if (!visitedObjects.has(p.returnItemCollectionMetrics))
            _aws_cdk_aws_stepfunctions_tasks_DynamoItemCollectionMetrics(p.returnItemCollectionMetrics);
        if (!visitedObjects.has(p.returnValues))
            _aws_cdk_aws_stepfunctions_tasks_DynamoReturnValues(p.returnValues);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoDeleteItem(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoConsumedCapacity(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoItemCollectionMetrics(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoReturnValues(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoProjectionExpression(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_DynamoAttributeValue(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_CodeBuildStartBuildProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.environmentVariablesOverride != null)
            for (const o of Object.values(p.environmentVariablesOverride))
                if (!visitedObjects.has(o))
                    require("@aws-cdk/aws-codebuild/.warnings.jsii.js")._aws_cdk_aws_codebuild_BuildEnvironmentVariable(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_CodeBuildStartBuild(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AthenaStartQueryExecutionProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.queryExecutionContext))
            _aws_cdk_aws_stepfunctions_tasks_QueryExecutionContext(p.queryExecutionContext);
        if (!visitedObjects.has(p.resultConfiguration))
            _aws_cdk_aws_stepfunctions_tasks_ResultConfiguration(p.resultConfiguration);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_AthenaStartQueryExecution(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_ResultConfiguration(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.encryptionConfiguration))
            _aws_cdk_aws_stepfunctions_tasks_EncryptionConfiguration(p.encryptionConfiguration);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EncryptionConfiguration(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.encryptionOption))
            _aws_cdk_aws_stepfunctions_tasks_EncryptionOption(p.encryptionOption);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EncryptionOption(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_QueryExecutionContext(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AthenaStopQueryExecutionProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AthenaStopQueryExecution(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AthenaGetQueryExecutionProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AthenaGetQueryExecution(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AthenaGetQueryResultsProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AthenaGetQueryResults(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_GlueDataBrewStartJobRunProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_GlueDataBrewStartJobRun(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EksCallProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.httpMethod))
            _aws_cdk_aws_stepfunctions_tasks_HttpMethods(p.httpMethod);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EksCall(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_HttpMethods(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_HttpMethod(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_AuthType(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_CallApiGatewayEndpointBaseProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.method))
            _aws_cdk_aws_stepfunctions_tasks_HttpMethod(p.method);
        if (!visitedObjects.has(p.authType))
            _aws_cdk_aws_stepfunctions_tasks_AuthType(p.authType);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_CallApiGatewayRestApiEndpointProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.method))
            _aws_cdk_aws_stepfunctions_tasks_HttpMethod(p.method);
        if (!visitedObjects.has(p.authType))
            _aws_cdk_aws_stepfunctions_tasks_AuthType(p.authType);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_CallApiGatewayRestApiEndpoint(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_CallApiGatewayHttpApiEndpointProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (!visitedObjects.has(p.method))
            _aws_cdk_aws_stepfunctions_tasks_HttpMethod(p.method);
        if (!visitedObjects.has(p.authType))
            _aws_cdk_aws_stepfunctions_tasks_AuthType(p.authType);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_CallApiGatewayHttpApiEndpoint(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EventBridgePutEventsEntry(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_EventBridgePutEventsProps(p) {
    if (p == null)
        return;
    visitedObjects.add(p);
    try {
        if (p.entries != null)
            for (const o of p.entries)
                if (!visitedObjects.has(o))
                    _aws_cdk_aws_stepfunctions_tasks_EventBridgePutEventsEntry(o);
    }
    finally {
        visitedObjects.delete(p);
    }
}
function _aws_cdk_aws_stepfunctions_tasks_EventBridgePutEvents(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_CallAwsServiceProps(p) {
}
function _aws_cdk_aws_stepfunctions_tasks_CallAwsService(p) {
}
function print(name, deprecationMessage) {
    const deprecated = process.env.JSII_DEPRECATED;
    const deprecationMode = ["warn", "fail", "quiet"].includes(deprecated) ? deprecated : "warn";
    const message = `${name} is deprecated.\n  ${deprecationMessage.trim()}\n  This API will be removed in the next major release.`;
    switch (deprecationMode) {
        case "fail":
            throw new DeprecationError(message);
        case "warn":
            console.warn("[WARNING]", message);
            break;
    }
}
function getPropertyDescriptor(obj, prop) {
    const descriptor = Object.getOwnPropertyDescriptor(obj, prop);
    if (descriptor) {
        return descriptor;
    }
    const proto = Object.getPrototypeOf(obj);
    const prototypeDescriptor = proto && getPropertyDescriptor(proto, prop);
    if (prototypeDescriptor) {
        return prototypeDescriptor;
    }
    return {};
}
const visitedObjects = new Set();
class DeprecationError extends Error {
    constructor(...args) {
        super(...args);
        Object.defineProperty(this, "name", {
            configurable: false,
            enumerable: true,
            value: "DeprecationError",
            writable: false,
        });
    }
}
module.exports = { print, getPropertyDescriptor, DeprecationError, _aws_cdk_aws_stepfunctions_tasks_InvokeFunctionProps, _aws_cdk_aws_stepfunctions_tasks_InvokeFunction, _aws_cdk_aws_stepfunctions_tasks_RunLambdaTaskProps, _aws_cdk_aws_stepfunctions_tasks_RunLambdaTask, _aws_cdk_aws_stepfunctions_tasks_InvocationType, _aws_cdk_aws_stepfunctions_tasks_LambdaInvokeProps, _aws_cdk_aws_stepfunctions_tasks_LambdaInvoke, _aws_cdk_aws_stepfunctions_tasks_LambdaInvocationType, _aws_cdk_aws_stepfunctions_tasks_InvokeActivityProps, _aws_cdk_aws_stepfunctions_tasks_InvokeActivity, _aws_cdk_aws_stepfunctions_tasks_CommonEcsRunTaskProps, _aws_cdk_aws_stepfunctions_tasks_EcsRunTaskBaseProps, _aws_cdk_aws_stepfunctions_tasks_EcsRunTaskBase, _aws_cdk_aws_stepfunctions_tasks_ContainerOverride, _aws_cdk_aws_stepfunctions_tasks_TaskEnvironmentVariable, _aws_cdk_aws_stepfunctions_tasks_PublishToTopicProps, _aws_cdk_aws_stepfunctions_tasks_PublishToTopic, _aws_cdk_aws_stepfunctions_tasks_MessageAttributeDataType, _aws_cdk_aws_stepfunctions_tasks_MessageAttribute, _aws_cdk_aws_stepfunctions_tasks_SnsPublishProps, _aws_cdk_aws_stepfunctions_tasks_SnsPublish, _aws_cdk_aws_stepfunctions_tasks_SendToQueueProps, _aws_cdk_aws_stepfunctions_tasks_SendToQueue, _aws_cdk_aws_stepfunctions_tasks_SqsSendMessageProps, _aws_cdk_aws_stepfunctions_tasks_SqsSendMessage, _aws_cdk_aws_stepfunctions_tasks_RunEcsEc2TaskProps, _aws_cdk_aws_stepfunctions_tasks_RunEcsEc2Task, _aws_cdk_aws_stepfunctions_tasks_RunEcsFargateTaskProps, _aws_cdk_aws_stepfunctions_tasks_RunEcsFargateTask, _aws_cdk_aws_stepfunctions_tasks_EcsRunTaskProps, _aws_cdk_aws_stepfunctions_tasks_IEcsLaunchTarget, _aws_cdk_aws_stepfunctions_tasks_LaunchTargetBindOptions, _aws_cdk_aws_stepfunctions_tasks_EcsLaunchTargetConfig, _aws_cdk_aws_stepfunctions_tasks_EcsFargateLaunchTargetOptions, _aws_cdk_aws_stepfunctions_tasks_EcsEc2LaunchTargetOptions, _aws_cdk_aws_stepfunctions_tasks_EcsFargateLaunchTarget, _aws_cdk_aws_stepfunctions_tasks_EcsEc2LaunchTarget, _aws_cdk_aws_stepfunctions_tasks_EcsRunTask, _aws_cdk_aws_stepfunctions_tasks_ISageMakerTask, _aws_cdk_aws_stepfunctions_tasks_AlgorithmSpecification, _aws_cdk_aws_stepfunctions_tasks_Channel, _aws_cdk_aws_stepfunctions_tasks_ShuffleConfig, _aws_cdk_aws_stepfunctions_tasks_DataSource, _aws_cdk_aws_stepfunctions_tasks_S3DataSource, _aws_cdk_aws_stepfunctions_tasks_OutputDataConfig, _aws_cdk_aws_stepfunctions_tasks_StoppingCondition, _aws_cdk_aws_stepfunctions_tasks_ResourceConfig, _aws_cdk_aws_stepfunctions_tasks_VpcConfig, _aws_cdk_aws_stepfunctions_tasks_MetricDefinition, _aws_cdk_aws_stepfunctions_tasks_S3LocationConfig, _aws_cdk_aws_stepfunctions_tasks_S3Location, _aws_cdk_aws_stepfunctions_tasks_S3LocationBindOptions, _aws_cdk_aws_stepfunctions_tasks_DockerImageConfig, _aws_cdk_aws_stepfunctions_tasks_DockerImage, _aws_cdk_aws_stepfunctions_tasks_S3DataType, _aws_cdk_aws_stepfunctions_tasks_S3DataDistributionType, _aws_cdk_aws_stepfunctions_tasks_RecordWrapperType, _aws_cdk_aws_stepfunctions_tasks_InputMode, _aws_cdk_aws_stepfunctions_tasks_CompressionType, _aws_cdk_aws_stepfunctions_tasks_ModelClientOptions, _aws_cdk_aws_stepfunctions_tasks_TransformInput, _aws_cdk_aws_stepfunctions_tasks_TransformDataSource, _aws_cdk_aws_stepfunctions_tasks_TransformS3DataSource, _aws_cdk_aws_stepfunctions_tasks_TransformOutput, _aws_cdk_aws_stepfunctions_tasks_TransformResources, _aws_cdk_aws_stepfunctions_tasks_ContainerDefinitionOptions, _aws_cdk_aws_stepfunctions_tasks_ContainerDefinition, _aws_cdk_aws_stepfunctions_tasks_IContainerDefinition, _aws_cdk_aws_stepfunctions_tasks_ContainerDefinitionConfig, _aws_cdk_aws_stepfunctions_tasks_Mode, _aws_cdk_aws_stepfunctions_tasks_ProductionVariant, _aws_cdk_aws_stepfunctions_tasks_AcceleratorClass, _aws_cdk_aws_stepfunctions_tasks_AcceleratorType, _aws_cdk_aws_stepfunctions_tasks_BatchStrategy, _aws_cdk_aws_stepfunctions_tasks_SplitType, _aws_cdk_aws_stepfunctions_tasks_AssembleWith, _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateTrainingJobProps, _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateTrainingJob, _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateTransformJobProps, _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateTransformJob, _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateEndpointProps, _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateEndpoint, _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateEndpointConfigProps, _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateEndpointConfig, _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateModelProps, _aws_cdk_aws_stepfunctions_tasks_SageMakerCreateModel, _aws_cdk_aws_stepfunctions_tasks_SageMakerUpdateEndpointProps, _aws_cdk_aws_stepfunctions_tasks_SageMakerUpdateEndpoint, _aws_cdk_aws_stepfunctions_tasks_StartExecutionProps, _aws_cdk_aws_stepfunctions_tasks_StartExecution, _aws_cdk_aws_stepfunctions_tasks_StepFunctionsStartExecutionProps, _aws_cdk_aws_stepfunctions_tasks_StepFunctionsStartExecution, _aws_cdk_aws_stepfunctions_tasks_StepFunctionsInvokeActivityProps, _aws_cdk_aws_stepfunctions_tasks_StepFunctionsInvokeActivity, _aws_cdk_aws_stepfunctions_tasks_EvaluateExpressionProps, _aws_cdk_aws_stepfunctions_tasks_EvaluateExpression, _aws_cdk_aws_stepfunctions_tasks_EmrCreateClusterProps, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EmrClusterScaleDownBehavior, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceRoleType, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EbsBlockDeviceVolumeType, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_VolumeSpecificationProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EbsBlockDeviceConfigProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_EbsConfigurationProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceTypeConfigProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SpotTimeoutAction, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SpotAllocationStrategy, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SpotProvisioningSpecificationProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceFleetProvisioningSpecificationsProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceFleetConfigProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmComparisonOperator, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmStatistic, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmUnit, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_MetricDimensionProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_CloudWatchAlarmDefinitionProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingTriggerProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceMarket, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingAdjustmentType, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_SimpleScalingPolicyConfigurationProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingActionProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingRuleProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScalingConstraintsProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_AutoScalingPolicyProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstanceGroupConfigProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_PlacementTypeProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_InstancesConfigProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ApplicationConfigProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ScriptBootstrapActionConfigProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_BootstrapActionConfigProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_ConfigurationProperty, _aws_cdk_aws_stepfunctions_tasks_EmrCreateCluster_KerberosAttributesProperty, _aws_cdk_aws_stepfunctions_tasks_EmrSetClusterTerminationProtectionProps, _aws_cdk_aws_stepfunctions_tasks_EmrSetClusterTerminationProtection, _aws_cdk_aws_stepfunctions_tasks_EmrTerminateClusterProps, _aws_cdk_aws_stepfunctions_tasks_EmrTerminateCluster, _aws_cdk_aws_stepfunctions_tasks_ActionOnFailure, _aws_cdk_aws_stepfunctions_tasks_EmrAddStepProps, _aws_cdk_aws_stepfunctions_tasks_EmrAddStep, _aws_cdk_aws_stepfunctions_tasks_EmrCancelStepProps, _aws_cdk_aws_stepfunctions_tasks_EmrCancelStep, _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceFleetByNameProps, _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceFleetByName, _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByNameProps, _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName, _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName_InstanceResizePolicyProperty, _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName_ShrinkPolicyProperty, _aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByName_InstanceGroupModifyConfigProperty, _aws_cdk_aws_stepfunctions_tasks_EksClusterInput, _aws_cdk_aws_stepfunctions_tasks_EmrContainersCreateVirtualClusterProps, _aws_cdk_aws_stepfunctions_tasks_EmrContainersCreateVirtualCluster, _aws_cdk_aws_stepfunctions_tasks_EmrContainersDeleteVirtualClusterProps, _aws_cdk_aws_stepfunctions_tasks_EmrContainersDeleteVirtualCluster, _aws_cdk_aws_stepfunctions_tasks_EmrContainersStartJobRunProps, _aws_cdk_aws_stepfunctions_tasks_EmrContainersStartJobRun, _aws_cdk_aws_stepfunctions_tasks_SparkSubmitJobDriver, _aws_cdk_aws_stepfunctions_tasks_JobDriver, _aws_cdk_aws_stepfunctions_tasks_Classification, _aws_cdk_aws_stepfunctions_tasks_ApplicationConfiguration, _aws_cdk_aws_stepfunctions_tasks_Monitoring, _aws_cdk_aws_stepfunctions_tasks_ReleaseLabel, _aws_cdk_aws_stepfunctions_tasks_VirtualClusterInput, _aws_cdk_aws_stepfunctions_tasks_RunGlueJobTaskProps, _aws_cdk_aws_stepfunctions_tasks_RunGlueJobTask, _aws_cdk_aws_stepfunctions_tasks_GlueStartJobRunProps, _aws_cdk_aws_stepfunctions_tasks_GlueStartJobRun, _aws_cdk_aws_stepfunctions_tasks_ContainerOverrides, _aws_cdk_aws_stepfunctions_tasks_JobDependency, _aws_cdk_aws_stepfunctions_tasks_RunBatchJobProps, _aws_cdk_aws_stepfunctions_tasks_RunBatchJob, _aws_cdk_aws_stepfunctions_tasks_BatchContainerOverrides, _aws_cdk_aws_stepfunctions_tasks_BatchJobDependency, _aws_cdk_aws_stepfunctions_tasks_BatchSubmitJobProps, _aws_cdk_aws_stepfunctions_tasks_BatchSubmitJob, _aws_cdk_aws_stepfunctions_tasks_DynamoGetItemProps, _aws_cdk_aws_stepfunctions_tasks_DynamoGetItem, _aws_cdk_aws_stepfunctions_tasks_DynamoPutItemProps, _aws_cdk_aws_stepfunctions_tasks_DynamoPutItem, _aws_cdk_aws_stepfunctions_tasks_DynamoUpdateItemProps, _aws_cdk_aws_stepfunctions_tasks_DynamoUpdateItem, _aws_cdk_aws_stepfunctions_tasks_DynamoDeleteItemProps, _aws_cdk_aws_stepfunctions_tasks_DynamoDeleteItem, _aws_cdk_aws_stepfunctions_tasks_DynamoConsumedCapacity, _aws_cdk_aws_stepfunctions_tasks_DynamoItemCollectionMetrics, _aws_cdk_aws_stepfunctions_tasks_DynamoReturnValues, _aws_cdk_aws_stepfunctions_tasks_DynamoProjectionExpression, _aws_cdk_aws_stepfunctions_tasks_DynamoAttributeValue, _aws_cdk_aws_stepfunctions_tasks_CodeBuildStartBuildProps, _aws_cdk_aws_stepfunctions_tasks_CodeBuildStartBuild, _aws_cdk_aws_stepfunctions_tasks_AthenaStartQueryExecutionProps, _aws_cdk_aws_stepfunctions_tasks_AthenaStartQueryExecution, _aws_cdk_aws_stepfunctions_tasks_ResultConfiguration, _aws_cdk_aws_stepfunctions_tasks_EncryptionConfiguration, _aws_cdk_aws_stepfunctions_tasks_EncryptionOption, _aws_cdk_aws_stepfunctions_tasks_QueryExecutionContext, _aws_cdk_aws_stepfunctions_tasks_AthenaStopQueryExecutionProps, _aws_cdk_aws_stepfunctions_tasks_AthenaStopQueryExecution, _aws_cdk_aws_stepfunctions_tasks_AthenaGetQueryExecutionProps, _aws_cdk_aws_stepfunctions_tasks_AthenaGetQueryExecution, _aws_cdk_aws_stepfunctions_tasks_AthenaGetQueryResultsProps, _aws_cdk_aws_stepfunctions_tasks_AthenaGetQueryResults, _aws_cdk_aws_stepfunctions_tasks_GlueDataBrewStartJobRunProps, _aws_cdk_aws_stepfunctions_tasks_GlueDataBrewStartJobRun, _aws_cdk_aws_stepfunctions_tasks_EksCallProps, _aws_cdk_aws_stepfunctions_tasks_EksCall, _aws_cdk_aws_stepfunctions_tasks_HttpMethods, _aws_cdk_aws_stepfunctions_tasks_HttpMethod, _aws_cdk_aws_stepfunctions_tasks_AuthType, _aws_cdk_aws_stepfunctions_tasks_CallApiGatewayEndpointBaseProps, _aws_cdk_aws_stepfunctions_tasks_CallApiGatewayRestApiEndpointProps, _aws_cdk_aws_stepfunctions_tasks_CallApiGatewayRestApiEndpoint, _aws_cdk_aws_stepfunctions_tasks_CallApiGatewayHttpApiEndpointProps, _aws_cdk_aws_stepfunctions_tasks_CallApiGatewayHttpApiEndpoint, _aws_cdk_aws_stepfunctions_tasks_EventBridgePutEventsEntry, _aws_cdk_aws_stepfunctions_tasks_EventBridgePutEventsProps, _aws_cdk_aws_stepfunctions_tasks_EventBridgePutEvents, _aws_cdk_aws_stepfunctions_tasks_CallAwsServiceProps, _aws_cdk_aws_stepfunctions_tasks_CallAwsService };
