import NewLifeUtils.FileModule       as File
from NewLifeUtils import inspect

def select_rand_list( source, use_zero=False):
    try:
        source[0]
    except IndexError:
        Logger.err(f"{source} is empty", "RS ERROR")
    except TypeError:
        Logger.err(f"{source} object is not subscriptable", "RS ERROR")
    else:
        if use_zero:
            Logger.log("Can use zero", "RS LOG")
            selector = random.randrange(1, len(source))
        else:
            Logger.log("Cant use zero", "RS LOG")
            selector = random.randrange(0, len(source))
        Logger.log(
            f"Select item #{selector} from {type(source).__name__}; result {source[selector]}",
            "RS LOG",
        )
        return source[selector]
    return None

def getfromfname( a):
    res = ""
    i = 0
    for e in inspect.stack():
        try:
            res += e.code_context[0]
        except Exception as e:
            res += " <Unknown> "
    return res.rstrip("\n").rsplit("\n", 1)[-1]

def __partition( nums, low, high):
    # Выбираем средний элемент в качестве опорного
    # Также возможен выбор первого, последнего
    # или произвольного элементов в качестве опорного
    pivot = nums[(low + high) // 2]
    i = low - 1
    j = high + 1
    while True:
        i += 1
        while nums[i] < pivot:
            i += 1

        j -= 1
        while nums[j] > pivot:
            j -= 1

        if i >= j:
            return j

        # Если элемент с индексом i (слева от опорного) больше, чем
        # элемент с индексом j (справа от опорного), меняем их местами
        nums[i], nums[j] = nums[j], nums[i]

def quick_sort( nums):
    # Создадим вспомогательную функцию, которая вызывается рекурсивно
    def _quick_sort(items, low, high):
        if low < high:
            # This is the index after the pivot, where our lists are split
            split_index = __partition(items, low, high)
            _quick_sort(items, low, split_index)
            _quick_sort(items, split_index + 1, high)

    _quick_sort(nums, 0, len(nums) - 1)

def bprint( text, maxlinelength=9, font="default"):
    filenamess = File.get_directory_content("+fonts")
    files = []
    for filename in filenamess:
        files.append(File.get_path("+fonts") + filename)
    fonts = []
    for file in files:
        current = open(file, encoding="utf-8")
        fontsrc = json.loads(current.read())
        fonts.append(fontsrc["name"])
        if fontsrc["name"] == font:
            sym = fontsrc
            break
    else:
        print(f'font "{font}" cant found. Avaliable: {", ".join(fonts)}. Using default')
        sym = {"name":"default","letters":{"0":[" ██████╗   ","██╔═████╗  ","██║██╔██║  ","████╔╝██║  ","╚██████╔╝  "," ╚═════╝   ","           "],"1":[" ██╗       ","███║       ","╚██║       "," ██║       "," ██║       "," ╚═╝       ","           "],"2":["██████╗    ","╚════██╗   "," █████╔╝   ","██╔═══╝    ","███████╗   ","╚══════╝   ","           "],"3":["██████╗    ","╚════██╗   "," █████╔╝   "," ╚═══██╗   ","██████╔╝   ","╚═════╝    ","           "],"4":["██╗  ██╗   ","██║  ██║   ","███████║   ","╚════██║   ","     ██║   ","     ╚═╝   ","           "],"5":["███████╗   ","██╔════╝   ","███████╗   ","╚════██║   ","███████║   ","╚══════╝   ","           "],"6":[" ██████╗   ","██╔════╝   ","███████╗   ","██╔═══██╗  ","╚██████╔╝  "," ╚═════╝   ","           "],"7":["███████╗   ","╚════██║   ","    ██╔╝   ","   ██╔╝    ","   ██║     ","   ╚═╝     ","           "],"8":[" █████╗    ","██╔══██╗   ","╚█████╔╝   ","██╔══██╗   ","╚█████╔╝   "," ╚════╝    ","           "],"9":[" █████╗    ","██╔══██╗   ","╚██████║   "," ╚═══██║   "," █████╔╝   "," ╚════╝    ","           "],"!":["██╗        ","██║        ","██║        ","╚═╝        ","██╗        ","╚═╝        ","           "],"\"":["           ","           ","           ","           ","           ","           ","           "],"#":[" ██╗ ██╗   ","████████╗  ","╚██╔═██╔╝  ","████████╗  ","╚██╔═██╔╝  "," ╚═╝ ╚═╝   ","           "],"$":["▄▄███▄▄·   ","██╔════╝   ","███████╗   ","╚════██║   ","███████║   ","╚═▀▀▀══╝   ","           "],"%":["██╗ ██╗    ","╚═╝██╔╝    ","  ██╔╝     "," ██╔╝      ","██╔╝██╗    ","╚═╝ ╚═╝    ","           "],"&":["   ██╗     ","   ██║     ","████████╗  ","██╔═██╔═╝  ","██████║    ","╚═════╝    ","           "],"'":["           ","           ","           ","           ","           ","           ","           "],"(":[" ██╗       ","██╔╝       ","██║        ","██║        ","╚██╗       "," ╚═╝       ","           "],")":["██╗        ","╚██╗       "," ██║       "," ██║       ","██╔╝       ","╚═╝        ","           "],"*":["           ","▄ ██╗▄     "," ████╗     ","▀╚██╔▀     ","  ╚═╝      ","           ","           "],"+":["           ","           ","           ","           ","           ","           ","           "],",":["           ","           ","           ","           ","▄█╗        ","╚═╝        ","           "],"-":["           ","           ","█████╗     ","╚════╝     ","           ","           ","           "],".":["           ","           ","           ","           ","██╗        ","╚═╝        ","           "],"/":["    ██╗    ","   ██╔╝    ","  ██╔╝     "," ██╔╝      ","██╔╝       ","╚═╝        ","           "],":":["           ","██╗        ","╚═╝        ","██╗        ","╚═╝        ","           ","           "],";":["           ","██╗        ","╚═╝        ","▄█╗        ","▀═╝        ","           ","           "],"<":["  ██╗      "," ██╔╝      ","██╔╝       ","╚██╗       "," ╚██╗      ","  ╚═╝      ","           "],"=":["           ","           ","           ","           ","           ","           ","           "],">":["██╗        ","╚██╗       "," ╚██╗      "," ██╔╝      ","██╔╝       ","╚═╝        ","           "],"?":["██████╗    ","╚════██╗   ","  ▄███╔╝   ","  ▀▀══╝    ","  ██╗      ","  ╚═╝      ","           "],"@":[" ██████╗   ","██╔═══██╗  ","██║██╗██║  ","██║██║██║  ","╚█║████╔╝  "," ╚╝╚═══╝   ","           "],"A":[" █████╗    ","██╔══██╗   ","███████║   ","██╔══██║   ","██║  ██║   ","╚═╝  ╚═╝   ","           "],"B":["██████╗    ","██╔══██╗   ","██████╔╝   ","██╔══██╗   ","██████╔╝   ","╚═════╝    ","           "],"C":[" ██████╗   ","██╔════╝   ","██║        ","██║        ","╚██████╗   "," ╚═════╝   ","           "],"D":["██████╗    ","██╔══██╗   ","██║  ██║   ","██║  ██║   ","██████╔╝   ","╚═════╝    ","           "],"E":["███████╗   ","██╔════╝   ","█████╗     ","██╔══╝     ","███████╗   ","╚══════╝   ","           "],"F":["███████╗   ","██╔════╝   ","█████╗     ","██╔══╝     ","██║        ","╚═╝        ","           "],"G":[" ██████╗   ","██╔════╝   ","██║  ███╗  ","██║   ██║  ","╚██████╔╝  "," ╚═════╝   ","           "],"H":["██╗  ██╗   ","██║  ██║   ","███████║   ","██╔══██║   ","██║  ██║   ","╚═╝  ╚═╝   ","           "],"I":["██╗        ","██║        ","██║        ","██║        ","██║        ","╚═╝        ","           "],"J":["     ██╗   ","     ██║   ","     ██║   ","██   ██║   ","╚█████╔╝   "," ╚════╝    ","           "],"K":["██╗  ██╗   ","██║ ██╔╝   ","█████╔╝    ","██╔═██╗    ","██║  ██╗   ","╚═╝  ╚═╝   ","           "],"L":["██╗        ","██║        ","██║        ","██║        ","███████╗   ","╚══════╝   ","           "],"M":["███╗   ███╗","████╗ ████║","██╔████╔██║","██║╚██╔╝██║","██║ ╚═╝ ██║","╚═╝     ╚═╝","           "],"N":["███╗   ██╗ ","████╗  ██║ ","██╔██╗ ██║ ","██║╚██╗██║ ","██║ ╚████║ ","╚═╝  ╚═══╝ ","           "],"O":[" ██████╗   ","██╔═══██╗  ","██║   ██║  ","██║   ██║  ","╚██████╔╝  "," ╚═════╝   ","           "],"P":["██████╗    ","██╔══██╗   ","██████╔╝   ","██╔═══╝    ","██║        ","╚═╝        ","           "],"Q":[" ██████╗   ","██╔═══██╗  ","██║   ██║  ","██║▄▄ ██║  ","╚██████╔╝  "," ╚══▀▀═╝   ","           "],"R":["██████╗    ","██╔══██╗   ","██████╔╝   ","██╔══██╗   ","██║  ██║   ","╚═╝  ╚═╝   ","           "],"S":["███████╗   ","██╔════╝   ","███████╗   ","╚════██║   ","███████║   ","╚══════╝   ","           "],"T":["████████╗  ","╚══██╔══╝  ","   ██║     ","   ██║     ","   ██║     ","   ╚═╝     ","           "],"U":["██╗   ██╗  ","██║   ██║  ","██║   ██║  ","██║   ██║  ","╚██████╔╝  "," ╚═════╝   ","           "],"V":["██╗   ██╗  ","██║   ██║  ","██║   ██║  ","╚██╗ ██╔╝  "," ╚████╔╝   ","  ╚═══╝    ","           "],"W":["██╗    ██╗ ","██║    ██║ ","██║ █╗ ██║ ","██║███╗██║ ","╚███╔███╔╝ "," ╚══╝╚══╝  ","           "],"X":["██╗  ██╗   ","╚██╗██╔╝   "," ╚███╔╝    "," ██╔██╗    ","██╔╝ ██╗   ","╚═╝  ╚═╝   ","           "],"Y":["██╗   ██╗  ","╚██╗ ██╔╝  "," ╚████╔╝   ","  ╚██╔╝    ","   ██║     ","   ╚═╝     ","           "],"Z":["███████╗   ","╚══███╔╝   ","  ███╔╝    "," ███╔╝     ","███████╗   ","╚══════╝   ","           "],"[":["███╗       ","██╔╝       ","██║        ","██║        ","███╗       ","╚══╝       ","           "],"\\":["           ","           ","           ","           ","           ","           ","           "],"]":["███╗       ","╚██║       "," ██║       "," ██║       ","███║       ","╚══╝       ","           "],"^":[" ███╗      ","██╔██╗     ","╚═╝╚═╝     ","           ","           ","           ","           "],"_":["           ","           ","           ","           ","███████╗   ","╚══════╝   ","           "],"`":["           ","           ","           ","           ","           ","           ","           "],"a":[" █████╗    ","██╔══██╗   ","███████║   ","██╔══██║   ","██║  ██║   ","╚═╝  ╚═╝   ","           "],"b":["██████╗    ","██╔══██╗   ","██████╔╝   ","██╔══██╗   ","██████╔╝   ","╚═════╝    ","           "],"c":[" ██████╗   ","██╔════╝   ","██║        ","██║        ","╚██████╗   "," ╚═════╝   ","           "],"d":["██████╗    ","██╔══██╗   ","██║  ██║   ","██║  ██║   ","██████╔╝   ","╚═════╝    ","           "],"e":["███████╗   ","██╔════╝   ","█████╗     ","██╔══╝     ","███████╗   ","╚══════╝   ","           "],"f":["███████╗   ","██╔════╝   ","█████╗     ","██╔══╝     ","██║        ","╚═╝        ","           "],"g":[" ██████╗   ","██╔════╝   ","██║  ███╗  ","██║   ██║  ","╚██████╔╝  "," ╚═════╝   ","           "],"h":["██╗  ██╗   ","██║  ██║   ","███████║   ","██╔══██║   ","██║  ██║   ","╚═╝  ╚═╝   ","           "],"i":["██╗        ","██║        ","██║        ","██║        ","██║        ","╚═╝        ","           "],"j":["     ██╗   ","     ██║   ","     ██║   ","██   ██║   ","╚█████╔╝   "," ╚════╝    ","           "],"k":["██╗  ██╗   ","██║ ██╔╝   ","█████╔╝    ","██╔═██╗    ","██║  ██╗   ","╚═╝  ╚═╝   ","           "],"l":["██╗        ","██║        ","██║        ","██║        ","███████╗   ","╚══════╝   ","           "],"m":["███╗   ███╗","████╗ ████║","██╔████╔██║","██║╚██╔╝██║","██║ ╚═╝ ██║","╚═╝     ╚═╝","           "],"n":["███╗   ██╗ ","████╗  ██║ ","██╔██╗ ██║ ","██║╚██╗██║ ","██║ ╚████║ ","╚═╝  ╚═══╝ ","           "],"o":[" ██████╗   ","██╔═══██╗  ","██║   ██║  ","██║   ██║  ","╚██████╔╝  "," ╚═════╝   ","           "],"p":["██████╗    ","██╔══██╗   ","██████╔╝   ","██╔═══╝    ","██║        ","╚═╝        ","           "],"q":[" ██████╗   ","██╔═══██╗  ","██║   ██║  ","██║▄▄ ██║  ","╚██████╔╝  "," ╚══▀▀═╝   ","           "],"r":["██████╗    ","██╔══██╗   ","██████╔╝   ","██╔══██╗   ","██║  ██║   ","╚═╝  ╚═╝   ","           "],"s":["███████╗   ","██╔════╝   ","███████╗   ","╚════██║   ","███████║   ","╚══════╝   ","           "],"t":["████████╗  ","╚══██╔══╝  ","   ██║     ","   ██║     ","   ██║     ","   ╚═╝     ","           "],"u":["██╗   ██╗  ","██║   ██║  ","██║   ██║  ","██║   ██║  ","╚██████╔╝  "," ╚═════╝   ","           "],"v":["██╗   ██╗  ","██║   ██║  ","██║   ██║  ","╚██╗ ██╔╝  "," ╚████╔╝   ","  ╚═══╝    ","           "],"w":["██╗    ██╗ ","██║    ██║ ","██║ █╗ ██║ ","██║███╗██║ ","╚███╔███╔╝ "," ╚══╝╚══╝  ","           "],"x":["██╗  ██╗   ","╚██╗██╔╝   "," ╚███╔╝    "," ██╔██╗    ","██╔╝ ██╗   ","╚═╝  ╚═╝   ","           "],"y":["██╗   ██╗  ","╚██╗ ██╔╝  "," ╚████╔╝   ","  ╚██╔╝    ","   ██║     ","   ╚═╝     ","           "],"z":["███████╗   ","╚══███╔╝   ","  ███╔╝    "," ███╔╝     ","███████╗   ","╚══════╝   "]," ":["     ","     ","     ","     ","     ","     "]}}

    def bprintletter(text):
        try:
            printline = []
            for i in range(len(sym["letters"][list(sym["letters"].keys())[0]])):
                printline.append("")
            for letter in text:
                for line in range(len(sym["letters"][letter])):
                    printline[line] += sym["letters"][letter][line]
            print("\n".join(printline))
        except KeyError:
            bprintletter("ERROR")
            print("Unable to continue print text, unknown characters")
            avaliableKeys = []
            avaliableKeys = list(sym["letters"].keys())
            avaliableKeys = "".join(avaliableKeys)
            print(f"Avaliable: {avaliableKeys}")

    import re

    r = [text[i : i + maxlinelength] for i in range(0, len(text), maxlinelength)]
    for text in r:
        bprintletter(text)
