/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.RandUtils;
import org.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2Vector
extends Vector {
    private int[] v;

    public GF2Vector(int length) {
        if (length < 0) {
            throw new ArithmeticException("Negative length.");
        }
        this.length = length;
        this.v = new int[length + 31 >> 5];
    }

    public GF2Vector(int length, SecureRandom sr) {
        this.length = length;
        int size = length + 31 >> 5;
        this.v = new int[size];
        int i = size - 1;
        while (i >= 0) {
            this.v[i] = sr.nextInt();
            --i;
        }
        int r = length & 0x1F;
        if (r != 0) {
            int n = size - 1;
            this.v[n] = this.v[n] & (1 << r) - 1;
        }
    }

    public GF2Vector(int length, int t, SecureRandom sr) {
        if (t > length) {
            throw new ArithmeticException("The hamming weight is greater than the length of vector.");
        }
        this.length = length;
        int size = length + 31 >> 5;
        this.v = new int[size];
        int[] help = new int[length];
        int i = 0;
        while (i < length) {
            help[i] = i;
            ++i;
        }
        int m = length;
        int i2 = 0;
        while (i2 < t) {
            int j = RandUtils.nextInt(sr, m);
            this.setBit(help[j]);
            help[j] = help[--m];
            ++i2;
        }
    }

    public GF2Vector(int length, int[] v) {
        if (length < 0) {
            throw new ArithmeticException("negative length");
        }
        this.length = length;
        int size = length + 31 >> 5;
        if (v.length != size) {
            throw new ArithmeticException("length mismatch");
        }
        this.v = IntUtils.clone(v);
        int r = length & 0x1F;
        if (r != 0) {
            int n = size - 1;
            this.v[n] = this.v[n] & (1 << r) - 1;
        }
    }

    public GF2Vector(GF2Vector other) {
        this.length = other.length;
        this.v = IntUtils.clone(other.v);
    }

    protected GF2Vector(int[] v, int length) {
        this.v = v;
        this.length = length;
    }

    public static GF2Vector OS2VP(int length, byte[] encVec) {
        if (length < 0) {
            throw new ArithmeticException("negative length");
        }
        int byteLen = length + 7 >> 3;
        if (encVec.length > byteLen) {
            throw new ArithmeticException("length mismatch");
        }
        return new GF2Vector(length, LittleEndianConversions.toIntArray(encVec));
    }

    @Override
    public byte[] getEncoded() {
        int byteLen = this.length + 7 >> 3;
        return LittleEndianConversions.toByteArray(this.v, byteLen);
    }

    public int[] getVecArray() {
        return this.v;
    }

    public int getHammingWeight() {
        int weight = 0;
        int i = 0;
        while (i < this.v.length) {
            int e = this.v[i];
            int j = 0;
            while (j < 32) {
                int b = e & 1;
                if (b != 0) {
                    ++weight;
                }
                e >>>= 1;
                ++j;
            }
            ++i;
        }
        return weight;
    }

    @Override
    public boolean isZero() {
        int i = this.v.length - 1;
        while (i >= 0) {
            if (this.v[i] != 0) {
                return false;
            }
            --i;
        }
        return true;
    }

    public int getBit(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int q = index >> 5;
        int r = index & 0x1F;
        return (this.v[q] & 1 << r) >>> r;
    }

    public void setBit(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int n = index >> 5;
        this.v[n] = this.v[n] | 1 << (index & 0x1F);
    }

    @Override
    public Vector add(Vector other) {
        if (!(other instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        GF2Vector otherVec = (GF2Vector)other;
        if (this.length != otherVec.length) {
            throw new ArithmeticException("length mismatch");
        }
        int[] vec = IntUtils.clone(((GF2Vector)other).v);
        int i = vec.length - 1;
        while (i >= 0) {
            int n = i;
            vec[n] = vec[n] ^ this.v[i];
            --i;
        }
        return new GF2Vector(this.length, vec);
    }

    @Override
    public Vector multiply(Permutation p) {
        int[] pVec = p.getVector();
        if (this.length != pVec.length) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Vector result = new GF2Vector(this.length);
        int i = 0;
        while (i < pVec.length) {
            int e = this.v[pVec[i] >> 5] & 1 << (pVec[i] & 0x1F);
            if (e != 0) {
                int n = i >> 5;
                result.v[n] = result.v[n] | 1 << (i & 0x1F);
            }
            ++i;
        }
        return result;
    }

    public GF2Vector extractVector(int[] setJ) {
        int k = setJ.length;
        if (setJ[k - 1] > this.length) {
            throw new ArithmeticException("invalid index set");
        }
        GF2Vector result = new GF2Vector(k);
        int i = 0;
        while (i < k) {
            int e = this.v[setJ[i] >> 5] & 1 << (setJ[i] & 0x1F);
            if (e != 0) {
                int n = i >> 5;
                result.v[n] = result.v[n] | 1 << (i & 0x1F);
            }
            ++i;
        }
        return result;
    }

    public GF2Vector extractLeftVector(int k) {
        if (k > this.length) {
            throw new ArithmeticException("invalid length");
        }
        if (k == this.length) {
            return new GF2Vector(this);
        }
        GF2Vector result = new GF2Vector(k);
        int q = k >> 5;
        int r = k & 0x1F;
        System.arraycopy(this.v, 0, result.v, 0, q);
        if (r != 0) {
            result.v[q] = this.v[q] & (1 << r) - 1;
        }
        return result;
    }

    public GF2Vector extractRightVector(int k) {
        if (k > this.length) {
            throw new ArithmeticException("invalid length");
        }
        if (k == this.length) {
            return new GF2Vector(this);
        }
        GF2Vector result = new GF2Vector(k);
        int q = this.length - k >> 5;
        int r = this.length - k & 0x1F;
        int length = k + 31 >> 5;
        int ind = q;
        if (r != 0) {
            int i = 0;
            while (i < length - 1) {
                result.v[i] = this.v[ind++] >>> r | this.v[ind] << 32 - r;
                ++i;
            }
            result.v[length - 1] = this.v[ind++] >>> r;
            if (ind < this.v.length) {
                int n = length - 1;
                result.v[n] = result.v[n] | this.v[ind] << 32 - r;
            }
        } else {
            System.arraycopy(this.v, q, result.v, 0, length);
        }
        return result;
    }

    public GF2mVector toExtensionFieldVector(GF2mField field) {
        int m = field.getDegree();
        if (this.length % m != 0) {
            throw new ArithmeticException("conversion is impossible");
        }
        int t = this.length / m;
        int[] result = new int[t];
        int count = 0;
        int i = t - 1;
        while (i >= 0) {
            int j = field.getDegree() - 1;
            while (j >= 0) {
                int q = count >>> 5;
                int r = count & 0x1F;
                int e = this.v[q] >>> r & 1;
                if (e == 1) {
                    int n = i;
                    result[n] = result[n] ^ 1 << j;
                }
                ++count;
                --j;
            }
            --i;
        }
        return new GF2mVector(field, result);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GF2Vector)) {
            return false;
        }
        GF2Vector otherVec = (GF2Vector)other;
        return this.length == otherVec.length && IntUtils.equals(this.v, otherVec.v);
    }

    @Override
    public int hashCode() {
        int hash = this.length;
        hash = hash * 31 + this.v.hashCode();
        return hash;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.length) {
            int r;
            int q;
            int bit;
            if (i != 0 && (i & 0x1F) == 0) {
                buf.append(' ');
            }
            if ((bit = this.v[q = i >> 5] & 1 << (r = i & 0x1F)) == 0) {
                buf.append('0');
            } else {
                buf.append('1');
            }
            ++i;
        }
        return buf.toString();
    }
}

