/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.test;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.pqc.jcajce.interfaces.StateAwareSignature;
import org.bouncycastle.pqc.jcajce.interfaces.XMSSKey;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.spec.XMSSParameterSpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class XMSSTest
extends TestCase {
    byte[] msg = Strings.toByteArray("Cthulhu Fthagn --What a wonderful phrase!Cthulhu Fthagn --Say it and you're crazed!");

    public void setUp() {
        if (Security.getProvider(BouncyCastlePQCProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastlePQCProvider());
        }
    }

    public void testXMSSSha256Signature() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSS", "BCPQC");
        kpg.initialize(new XMSSParameterSpec(10, "SHA256"), new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        Signature sig = Signature.getInstance("SHA256withXMSS", "BCPQC");
        XMSSTest.assertTrue((boolean)(sig instanceof StateAwareSignature));
        StateAwareSignature xmssSig = (StateAwareSignature)((Object)sig);
        xmssSig.initSign(kp.getPrivate());
        xmssSig.update(this.msg, 0, this.msg.length);
        byte[] s = sig.sign();
        xmssSig.initVerify(kp.getPublic());
        xmssSig.update(this.msg, 0, this.msg.length);
        XMSSTest.assertTrue((boolean)xmssSig.verify(s));
    }

    public void testXMSSSha512Signature() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSS", "BCPQC");
        kpg.initialize(new XMSSParameterSpec(10, "SHA512"), new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        Signature sig = Signature.getInstance("SHA512withXMSS", "BCPQC");
        XMSSTest.assertTrue((boolean)(sig instanceof StateAwareSignature));
        StateAwareSignature xmssSig = (StateAwareSignature)((Object)sig);
        xmssSig.initSign(kp.getPrivate());
        xmssSig.update(this.msg, 0, this.msg.length);
        byte[] s = sig.sign();
        xmssSig.initVerify(kp.getPublic());
        xmssSig.update(this.msg, 0, this.msg.length);
        XMSSTest.assertTrue((boolean)xmssSig.verify(s));
    }

    public void testXMSSShake128Signature() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSS", "BCPQC");
        kpg.initialize(new XMSSParameterSpec(5, "SHAKE128"), new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        Signature sig = Signature.getInstance("SHAKE128withXMSS", "BCPQC");
        XMSSTest.assertTrue((boolean)(sig instanceof StateAwareSignature));
        StateAwareSignature xmssSig = (StateAwareSignature)((Object)sig);
        xmssSig.initSign(kp.getPrivate());
        xmssSig.update(this.msg, 0, this.msg.length);
        byte[] s = sig.sign();
        xmssSig.initVerify(kp.getPublic());
        xmssSig.update(this.msg, 0, this.msg.length);
        XMSSTest.assertTrue((boolean)xmssSig.verify(s));
    }

    public void testXMSSShake256Signature() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSS", "BCPQC");
        kpg.initialize(new XMSSParameterSpec(5, "SHAKE256"), new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        Signature sig = Signature.getInstance("SHAKE256withXMSS", "BCPQC");
        XMSSTest.assertTrue((boolean)(sig instanceof StateAwareSignature));
        StateAwareSignature xmssSig = (StateAwareSignature)((Object)sig);
        xmssSig.initSign(kp.getPrivate());
        xmssSig.update(this.msg, 0, this.msg.length);
        byte[] s = sig.sign();
        xmssSig.initVerify(kp.getPublic());
        xmssSig.update(this.msg, 0, this.msg.length);
        XMSSTest.assertTrue((boolean)xmssSig.verify(s));
    }

    public void testXMSSSha256SignatureMultiple() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSS", "BCPQC");
        kpg.initialize(new XMSSParameterSpec(10, "SHA256"), new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        StateAwareSignature sig1 = (StateAwareSignature)((Object)Signature.getInstance("SHA256withXMSS", "BCPQC"));
        StateAwareSignature sig2 = (StateAwareSignature)((Object)Signature.getInstance("SHA256withXMSS", "BCPQC"));
        StateAwareSignature sig3 = (StateAwareSignature)((Object)Signature.getInstance("SHA256withXMSS", "BCPQC"));
        sig1.initSign(kp.getPrivate());
        sig2.initSign(sig1.getUpdatedPrivateKey());
        sig3.initSign(sig2.getUpdatedPrivateKey());
        sig1.update(this.msg, 0, this.msg.length);
        byte[] s1 = sig1.sign();
        sig2.update(this.msg, 0, this.msg.length);
        byte[] s2 = sig2.sign();
        sig3.update(this.msg, 0, this.msg.length);
        byte[] s3 = sig3.sign();
        sig1.initVerify(kp.getPublic());
        sig1.update(this.msg, 0, this.msg.length);
        XMSSTest.assertTrue((boolean)sig1.verify(s1));
        sig1.update(this.msg, 0, this.msg.length);
        XMSSTest.assertTrue((boolean)sig1.verify(s2));
        sig1.update(this.msg, 0, this.msg.length);
        XMSSTest.assertTrue((boolean)sig1.verify(s3));
    }

    public void testXMSSSha256KeyFactory() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSS", "BCPQC");
        kpg.initialize(new XMSSParameterSpec(10, "SHA256"), new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        KeyFactory keyFactory = KeyFactory.getInstance("XMSS", "BCPQC");
        XMSSKey privKey = (XMSSKey)((Object)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(kp.getPrivate().getEncoded())));
        XMSSTest.assertEquals((Object)kp.getPrivate(), (Object)privKey);
        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(kp.getPublic().getEncoded()));
        XMSSTest.assertEquals((Object)kp.getPublic(), (Object)pubKey);
        XMSSTest.assertEquals((int)10, (int)privKey.getHeight());
        XMSSTest.assertEquals((String)"SHA256", (String)privKey.getTreeDigest());
    }

    public void testXMSSSha512KeyFactory() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSS", "BCPQC");
        kpg.initialize(new XMSSParameterSpec(10, "SHA512"), new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        KeyFactory keyFactory = KeyFactory.getInstance("XMSS", "BCPQC");
        XMSSKey privKey = (XMSSKey)((Object)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(kp.getPrivate().getEncoded())));
        XMSSTest.assertEquals((Object)kp.getPrivate(), (Object)privKey);
        XMSSKey pubKey = (XMSSKey)((Object)keyFactory.generatePublic(new X509EncodedKeySpec(kp.getPublic().getEncoded())));
        XMSSTest.assertEquals((Object)kp.getPublic(), (Object)pubKey);
        XMSSTest.assertEquals((int)10, (int)privKey.getHeight());
        XMSSTest.assertEquals((String)"SHA512", (String)privKey.getTreeDigest());
        XMSSTest.assertEquals((int)10, (int)pubKey.getHeight());
        XMSSTest.assertEquals((String)"SHA512", (String)pubKey.getTreeDigest());
    }

    public void testKeyExtraction() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSS", "BCPQC");
        kpg.initialize(new XMSSParameterSpec(10, "SHA256"), new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        Signature sig = Signature.getInstance("SHA256withXMSS", "BCPQC");
        XMSSTest.assertTrue((boolean)(sig instanceof StateAwareSignature));
        StateAwareSignature xmssSig = (StateAwareSignature)((Object)sig);
        xmssSig.initSign(kp.getPrivate());
        xmssSig.update(this.msg, 0, this.msg.length);
        byte[] s = xmssSig.sign();
        PrivateKey nKey = xmssSig.getUpdatedPrivateKey();
        XMSSTest.assertFalse((boolean)kp.getPrivate().equals(nKey));
        xmssSig.update(this.msg, 0, this.msg.length);
        try {
            xmssSig.sign();
            XMSSTest.fail((String)"no exception after key extraction");
        }
        catch (SignatureException e) {
            XMSSTest.assertEquals((String)"signing key no longer usable", (String)e.getMessage());
        }
        try {
            xmssSig.getUpdatedPrivateKey();
            XMSSTest.fail((String)"no exception after key extraction");
        }
        catch (IllegalStateException e) {
            XMSSTest.assertEquals((String)"signature object not in a signing state", (String)e.getMessage());
        }
        xmssSig.initSign(nKey);
        xmssSig.update(this.msg, 0, this.msg.length);
        s = sig.sign();
        xmssSig.initVerify(kp.getPublic());
        xmssSig.update(this.msg, 0, this.msg.length);
        XMSSTest.assertTrue((boolean)xmssSig.verify(s));
    }

    public void testKeyRebuild() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("XMSS", "BCPQC");
        kpg.initialize(new XMSSParameterSpec(10, "SHA256"), new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        Signature sig = Signature.getInstance("SHA256withXMSS", "BCPQC");
        XMSSTest.assertTrue((boolean)(sig instanceof StateAwareSignature));
        StateAwareSignature xmssSig = (StateAwareSignature)((Object)sig);
        xmssSig.initSign(kp.getPrivate());
        int i = 0;
        while (i != 5) {
            xmssSig.update(this.msg, 0, this.msg.length);
            xmssSig.sign();
            ++i;
        }
        PrivateKey pKey = xmssSig.getUpdatedPrivateKey();
        PrivateKeyInfo pKeyInfo = PrivateKeyInfo.getInstance(pKey.getEncoded());
        KeyFactory keyFactory = KeyFactory.getInstance("XMSS", "BCPQC");
        ASN1Sequence seq = ASN1Sequence.getInstance(pKeyInfo.parsePrivateKey());
        pKeyInfo = new PrivateKeyInfo(pKeyInfo.getPrivateKeyAlgorithm(), new DERSequence(new ASN1Encodable[]{seq.getObjectAt(0), seq.getObjectAt(1)}));
        XMSSKey privKey = (XMSSKey)((Object)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(pKeyInfo.getEncoded())));
        xmssSig.initSign(pKey);
        xmssSig.update(this.msg, 0, this.msg.length);
        byte[] sig1 = xmssSig.sign();
        xmssSig.initSign((PrivateKey)((Object)privKey));
        xmssSig.update(this.msg, 0, this.msg.length);
        byte[] sig2 = xmssSig.sign();
        XMSSTest.assertTrue((boolean)Arrays.areEqual(sig1, sig2));
    }
}

