/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.test;

import java.security.Security;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.provider.test.McElieceCCA2KeyPairGeneratorTest;
import org.bouncycastle.pqc.jcajce.provider.test.McElieceCipherTest;
import org.bouncycastle.pqc.jcajce.provider.test.McElieceFujisakiCipherTest;
import org.bouncycastle.pqc.jcajce.provider.test.McElieceKeyPairGeneratorTest;
import org.bouncycastle.pqc.jcajce.provider.test.McElieceKobaraImaiCipherTest;
import org.bouncycastle.pqc.jcajce.provider.test.McEliecePointchevalCipherTest;
import org.bouncycastle.pqc.jcajce.provider.test.NewHopeKeyPairGeneratorTest;
import org.bouncycastle.pqc.jcajce.provider.test.NewHopeTest;
import org.bouncycastle.pqc.jcajce.provider.test.RainbowSignatureTest;
import org.bouncycastle.pqc.jcajce.provider.test.Sphincs256KeyPairGeneratorTest;
import org.bouncycastle.pqc.jcajce.provider.test.Sphincs256Test;
import org.bouncycastle.pqc.jcajce.provider.test.XMSSMTTest;
import org.bouncycastle.pqc.jcajce.provider.test.XMSSTest;

public class AllTests
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)AllTests.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("PQC JCE Tests");
        if (Security.getProvider(BouncyCastlePQCProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastlePQCProvider());
        }
        suite.addTestSuite(Sphincs256Test.class);
        suite.addTestSuite(RainbowSignatureTest.class);
        suite.addTestSuite(McElieceFujisakiCipherTest.class);
        suite.addTestSuite(McElieceKobaraImaiCipherTest.class);
        suite.addTestSuite(McEliecePointchevalCipherTest.class);
        suite.addTestSuite(McElieceCipherTest.class);
        suite.addTestSuite(McElieceKeyPairGeneratorTest.class);
        suite.addTestSuite(McElieceCCA2KeyPairGeneratorTest.class);
        suite.addTestSuite(NewHopeTest.class);
        suite.addTestSuite(NewHopeKeyPairGeneratorTest.class);
        suite.addTestSuite(Sphincs256Test.class);
        suite.addTestSuite(Sphincs256KeyPairGeneratorTest.class);
        suite.addTestSuite(XMSSTest.class);
        suite.addTestSuite(XMSSMTTest.class);
        return new BCTestSetup((Test)suite);
    }

    static class BCTestSetup
    extends TestSetup {
        public BCTestSetup(Test test) {
            super(test);
        }

        protected void setUp() {
            Security.addProvider(new BouncyCastlePQCProvider());
        }

        protected void tearDown() {
            Security.removeProvider("BCPQC");
        }
    }
}

