/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.util.ArrayList;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.GOST3411_2012_512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.DigestTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class GOST3411_2012_512DigestTest
extends DigestTest {
    private static final String[] messages;
    private static char[] M1;
    private static char[] M2;
    private static final String[] digests;

    static {
        M1 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2'};
        M2 = new char[]{'\u00d1', '\u00e5', ' ', '\u00e2', '\u00e5', '\u00f2', '\u00f0', '\u00e8', ',', ' ', '\u00d1', '\u00f2', '\u00f0', '\u00e8', '\u00e1', '\u00ee', '\u00e6', '\u00e8', ' ', '\u00e2', '\u00ed', '\u00f3', '\u00f6', '\u00e8', ',', ' ', '\u00e2', '\u00e5', '\u00fe', '\u00f2', '\u00fa', ' ', '\u00f1', ' ', '\u00ec', '\u00ee', '\u00f0', '\u00ff', ' ', '\u00f1', '\u00f2', '\u00f0', '\u00e5', '\u00eb', '\u00e0', '\u00ec', '\u00e8', ' ', '\u00ed', '\u00e0', ' ', '\u00f5', '\u00f0', '\u00e0', '\u00e1', '\u00f0', '\u00fb', '\u00ff', ' ', '\u00ef', '\u00eb', '\u00fa', '\u00ea', '\u00fb', ' ', '\u00c8', '\u00e3', '\u00ee', '\u00f0', '\u00e5', '\u00e2', '\u00fb'};
        ArrayList<String> strList = new ArrayList<String>();
        strList.add(new String(M1));
        strList.add(new String(M2));
        messages = new String[strList.size()];
        int i = 0;
        while (i < strList.size()) {
            GOST3411_2012_512DigestTest.messages[i] = (String)strList.get(i);
            ++i;
        }
        digests = new String[]{"1b54d01a4af5b9d5cc3d86d68d285462b19abc2475222f35c085122be4ba1ffa00ad30f8767b3a82384c6574f024c311e2a481332b08ef7f41797891c1646f48", "1e88e62226bfca6f9994f1f2d51569e0daf8475a3b0fe61a5300eee46d961376035fe83549ada2b8620fcd7c496ce5b33f0cb9dddc2b6460143b03dabac9fb28"};
    }

    public GOST3411_2012_512DigestTest() {
        super(new GOST3411_2012_512Digest(), messages, digests);
    }

    @Override
    public void performTest() {
        super.performTest();
        HMac gMac = new HMac(new GOST3411_2012_512Digest());
        gMac.init(new KeyParameter(Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f")));
        byte[] data = Hex.decode("0126bdb87800af214341456563780100");
        gMac.update(data, 0, data.length);
        byte[] mac = new byte[gMac.getMacSize()];
        gMac.doFinal(mac, 0);
        if (!Arrays.areEqual(Hex.decode("a59bab22ecae19c65fbde6e5f4e9f5d8549d31f037f9df9b905500e171923a773d5f1530f2ed7e964cb2eedc29e9ad2f3afe93b2814f79f5000ffc0366c251e6"), mac)) {
            this.fail("mac calculation failed.");
        }
    }

    @Override
    protected Digest cloneDigest(Digest digest) {
        return new GOST3411_2012_512Digest((GOST3411_2012_512Digest)digest);
    }

    public static void main(String[] args) {
        GOST3411_2012_512DigestTest.runTest(new GOST3411_2012_512DigestTest());
    }
}

