# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class GatewayDomain(TeaModel):
    def __init__(
        self,
        cert_identifier: str = None,
        gateway_id: int = None,
        gateway_name: str = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        must_https: str = None,
        name: str = None,
        protocol: str = None,
    ):
        self.cert_identifier = cert_identifier
        self.gateway_id = gateway_id
        self.gateway_name = gateway_name
        self.gateway_unique_id = gateway_unique_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.must_https = must_https
        self.name = name
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_identifier is not None:
            result['CertIdentifier'] = self.cert_identifier
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_name is not None:
            result['GatewayName'] = self.gateway_name
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.must_https is not None:
            result['MustHttps'] = self.must_https
        if self.name is not None:
            result['Name'] = self.name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CertIdentifier') is not None:
            self.cert_identifier = m.get('CertIdentifier')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayName') is not None:
            self.gateway_name = m.get('GatewayName')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MustHttps') is not None:
            self.must_https = m.get('MustHttps')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class GatewayOptionLogConfigDetails(TeaModel):
    def __init__(
        self,
        log_enabled: bool = None,
        log_store_name: str = None,
        project_name: str = None,
    ):
        self.log_enabled = log_enabled
        self.log_store_name = log_store_name
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_enabled is not None:
            result['LogEnabled'] = self.log_enabled
        if self.log_store_name is not None:
            result['LogStoreName'] = self.log_store_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogEnabled') is not None:
            self.log_enabled = m.get('LogEnabled')
        if m.get('LogStoreName') is not None:
            self.log_store_name = m.get('LogStoreName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class GatewayOptionTraceDetails(TeaModel):
    def __init__(
        self,
        sample: int = None,
        trace_enabled: bool = None,
    ):
        self.sample = sample
        self.trace_enabled = trace_enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.trace_enabled is not None:
            result['TraceEnabled'] = self.trace_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('TraceEnabled') is not None:
            self.trace_enabled = m.get('TraceEnabled')
        return self


class GatewayOption(TeaModel):
    def __init__(
        self,
        disable_http_2alpn: bool = None,
        enable_hardware_acceleration: bool = None,
        enable_waf: bool = None,
        log_config_details: GatewayOptionLogConfigDetails = None,
        trace_details: GatewayOptionTraceDetails = None,
    ):
        self.disable_http_2alpn = disable_http_2alpn
        self.enable_hardware_acceleration = enable_hardware_acceleration
        self.enable_waf = enable_waf
        self.log_config_details = log_config_details
        self.trace_details = trace_details

    def validate(self):
        if self.log_config_details:
            self.log_config_details.validate()
        if self.trace_details:
            self.trace_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable_http_2alpn is not None:
            result['DisableHttp2Alpn'] = self.disable_http_2alpn
        if self.enable_hardware_acceleration is not None:
            result['EnableHardwareAcceleration'] = self.enable_hardware_acceleration
        if self.enable_waf is not None:
            result['EnableWaf'] = self.enable_waf
        if self.log_config_details is not None:
            result['LogConfigDetails'] = self.log_config_details.to_map()
        if self.trace_details is not None:
            result['TraceDetails'] = self.trace_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisableHttp2Alpn') is not None:
            self.disable_http_2alpn = m.get('DisableHttp2Alpn')
        if m.get('EnableHardwareAcceleration') is not None:
            self.enable_hardware_acceleration = m.get('EnableHardwareAcceleration')
        if m.get('EnableWaf') is not None:
            self.enable_waf = m.get('EnableWaf')
        if m.get('LogConfigDetails') is not None:
            temp_model = GatewayOptionLogConfigDetails()
            self.log_config_details = temp_model.from_map(m['LogConfigDetails'])
        if m.get('TraceDetails') is not None:
            temp_model = GatewayOptionTraceDetails()
            self.trace_details = temp_model.from_map(m['TraceDetails'])
        return self


class TrafficPolicyLoadBalancerSettingsConsistentHashLBConfigHttpCookie(TeaModel):
    def __init__(
        self,
        name: str = None,
        path: str = None,
        ttl: str = None,
    ):
        self.name = name
        self.path = path
        self.ttl = ttl

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.ttl is not None:
            result['TTL'] = self.ttl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('TTL') is not None:
            self.ttl = m.get('TTL')
        return self


class TrafficPolicyLoadBalancerSettingsConsistentHashLBConfig(TeaModel):
    def __init__(
        self,
        consistent_hash_lbtype: str = None,
        http_cookie: TrafficPolicyLoadBalancerSettingsConsistentHashLBConfigHttpCookie = None,
        parameter_name: str = None,
    ):
        self.consistent_hash_lbtype = consistent_hash_lbtype
        self.http_cookie = http_cookie
        self.parameter_name = parameter_name

    def validate(self):
        if self.http_cookie:
            self.http_cookie.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consistent_hash_lbtype is not None:
            result['ConsistentHashLBType'] = self.consistent_hash_lbtype
        if self.http_cookie is not None:
            result['HttpCookie'] = self.http_cookie.to_map()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsistentHashLBType') is not None:
            self.consistent_hash_lbtype = m.get('ConsistentHashLBType')
        if m.get('HttpCookie') is not None:
            temp_model = TrafficPolicyLoadBalancerSettingsConsistentHashLBConfigHttpCookie()
            self.http_cookie = temp_model.from_map(m['HttpCookie'])
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class TrafficPolicyLoadBalancerSettings(TeaModel):
    def __init__(
        self,
        consistent_hash_lbconfig: TrafficPolicyLoadBalancerSettingsConsistentHashLBConfig = None,
        loadbalancer_type: str = None,
        warmup_duration: int = None,
    ):
        self.consistent_hash_lbconfig = consistent_hash_lbconfig
        self.loadbalancer_type = loadbalancer_type
        self.warmup_duration = warmup_duration

    def validate(self):
        if self.consistent_hash_lbconfig:
            self.consistent_hash_lbconfig.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consistent_hash_lbconfig is not None:
            result['ConsistentHashLBConfig'] = self.consistent_hash_lbconfig.to_map()
        if self.loadbalancer_type is not None:
            result['LoadbalancerType'] = self.loadbalancer_type
        if self.warmup_duration is not None:
            result['WarmupDuration'] = self.warmup_duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsistentHashLBConfig') is not None:
            temp_model = TrafficPolicyLoadBalancerSettingsConsistentHashLBConfig()
            self.consistent_hash_lbconfig = temp_model.from_map(m['ConsistentHashLBConfig'])
        if m.get('LoadbalancerType') is not None:
            self.loadbalancer_type = m.get('LoadbalancerType')
        if m.get('WarmupDuration') is not None:
            self.warmup_duration = m.get('WarmupDuration')
        return self


class TrafficPolicyTlsSetting(TeaModel):
    def __init__(
        self,
        ca_cert_content: str = None,
        cert_id: str = None,
        sni: str = None,
        tls_mode: str = None,
    ):
        self.ca_cert_content = ca_cert_content
        self.cert_id = cert_id
        self.sni = sni
        self.tls_mode = tls_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ca_cert_content is not None:
            result['CaCertContent'] = self.ca_cert_content
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.sni is not None:
            result['Sni'] = self.sni
        if self.tls_mode is not None:
            result['TlsMode'] = self.tls_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CaCertContent') is not None:
            self.ca_cert_content = m.get('CaCertContent')
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('Sni') is not None:
            self.sni = m.get('Sni')
        if m.get('TlsMode') is not None:
            self.tls_mode = m.get('TlsMode')
        return self


class TrafficPolicy(TeaModel):
    def __init__(
        self,
        load_balancer_settings: TrafficPolicyLoadBalancerSettings = None,
        tls_setting: TrafficPolicyTlsSetting = None,
    ):
        self.load_balancer_settings = load_balancer_settings
        self.tls_setting = tls_setting

    def validate(self):
        if self.load_balancer_settings:
            self.load_balancer_settings.validate()
        if self.tls_setting:
            self.tls_setting.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.load_balancer_settings is not None:
            result['LoadBalancerSettings'] = self.load_balancer_settings.to_map()
        if self.tls_setting is not None:
            result['TlsSetting'] = self.tls_setting.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LoadBalancerSettings') is not None:
            temp_model = TrafficPolicyLoadBalancerSettings()
            self.load_balancer_settings = temp_model.from_map(m['LoadBalancerSettings'])
        if m.get('TlsSetting') is not None:
            temp_model = TrafficPolicyTlsSetting()
            self.tls_setting = temp_model.from_map(m['TlsSetting'])
        return self


class GatewayService(TeaModel):
    def __init__(
        self,
        gateway_traffic_policy: TrafficPolicy = None,
        gateway_unique_id: str = None,
        group_name: str = None,
        id: int = None,
        meta_info: str = None,
        name: str = None,
        namespace: str = None,
        source_type: str = None,
    ):
        self.gateway_traffic_policy = gateway_traffic_policy
        self.gateway_unique_id = gateway_unique_id
        self.group_name = group_name
        self.id = id
        self.meta_info = meta_info
        self.name = name
        self.namespace = namespace
        self.source_type = source_type

    def validate(self):
        if self.gateway_traffic_policy:
            self.gateway_traffic_policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_traffic_policy is not None:
            result['GatewayTrafficPolicy'] = self.gateway_traffic_policy.to_map()
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.meta_info is not None:
            result['MetaInfo'] = self.meta_info
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayTrafficPolicy') is not None:
            temp_model = TrafficPolicy()
            self.gateway_traffic_policy = temp_model.from_map(m['GatewayTrafficPolicy'])
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MetaInfo') is not None:
            self.meta_info = m.get('MetaInfo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class AddAuthResourceRequestAuthResourceHeaderList(TeaModel):
    def __init__(
        self,
        header_key: str = None,
        header_method: str = None,
        header_value: str = None,
    ):
        self.header_key = header_key
        self.header_method = header_method
        self.header_value = header_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header_key is not None:
            result['HeaderKey'] = self.header_key
        if self.header_method is not None:
            result['HeaderMethod'] = self.header_method
        if self.header_value is not None:
            result['HeaderValue'] = self.header_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HeaderKey') is not None:
            self.header_key = m.get('HeaderKey')
        if m.get('HeaderMethod') is not None:
            self.header_method = m.get('HeaderMethod')
        if m.get('HeaderValue') is not None:
            self.header_value = m.get('HeaderValue')
        return self


class AddAuthResourceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        auth_id: int = None,
        auth_resource_header_list: List[AddAuthResourceRequestAuthResourceHeaderList] = None,
        domain_id: int = None,
        gateway_unique_id: str = None,
        ignore_case: bool = None,
        match_type: str = None,
        path: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the authorization record.
        self.auth_id = auth_id
        self.auth_resource_header_list = auth_resource_header_list
        # The domain ID.
        self.domain_id = domain_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        self.ignore_case = ignore_case
        # The matching type.
        # 
        # *   exact: exact matching
        # *   prefix: prefix matching
        # *   regex: regular expression matching
        self.match_type = match_type
        # The path.
        self.path = path

    def validate(self):
        if self.auth_resource_header_list:
            for k in self.auth_resource_header_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.auth_id is not None:
            result['AuthId'] = self.auth_id
        result['AuthResourceHeaderList'] = []
        if self.auth_resource_header_list is not None:
            for k in self.auth_resource_header_list:
                result['AuthResourceHeaderList'].append(k.to_map() if k else None)
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.ignore_case is not None:
            result['IgnoreCase'] = self.ignore_case
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AuthId') is not None:
            self.auth_id = m.get('AuthId')
        self.auth_resource_header_list = []
        if m.get('AuthResourceHeaderList') is not None:
            for k in m.get('AuthResourceHeaderList'):
                temp_model = AddAuthResourceRequestAuthResourceHeaderList()
                self.auth_resource_header_list.append(temp_model.from_map(k))
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('IgnoreCase') is not None:
            self.ignore_case = m.get('IgnoreCase')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class AddAuthResourceShrinkRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        auth_id: int = None,
        auth_resource_header_list_shrink: str = None,
        domain_id: int = None,
        gateway_unique_id: str = None,
        ignore_case: bool = None,
        match_type: str = None,
        path: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the authorization record.
        self.auth_id = auth_id
        self.auth_resource_header_list_shrink = auth_resource_header_list_shrink
        # The domain ID.
        self.domain_id = domain_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        self.ignore_case = ignore_case
        # The matching type.
        # 
        # *   exact: exact matching
        # *   prefix: prefix matching
        # *   regex: regular expression matching
        self.match_type = match_type
        # The path.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.auth_id is not None:
            result['AuthId'] = self.auth_id
        if self.auth_resource_header_list_shrink is not None:
            result['AuthResourceHeaderList'] = self.auth_resource_header_list_shrink
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.ignore_case is not None:
            result['IgnoreCase'] = self.ignore_case
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AuthId') is not None:
            self.auth_id = m.get('AuthId')
        if m.get('AuthResourceHeaderList') is not None:
            self.auth_resource_header_list_shrink = m.get('AuthResourceHeaderList')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('IgnoreCase') is not None:
            self.ignore_case = m.get('IgnoreCase')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class AddAuthResourceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data structure.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddAuthResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddAuthResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAuthResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddBlackWhiteListRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        content: str = None,
        gateway_unique_id: str = None,
        is_white: bool = None,
        name: str = None,
        note: str = None,
        resource_id_json_list: str = None,
        resource_type: str = None,
        status: str = None,
        type: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The content of the blacklist.
        self.content = content
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # Specifies whether to create a whitelist.
        self.is_white = is_white
        # The name.
        self.name = name
        # The description.
        self.note = note
        # The resource IDs in the JSON format.
        self.resource_id_json_list = resource_id_json_list
        # The resource type to which the blacklist or whitelist applies.
        self.resource_type = resource_type
        # The status of the blacklist.
        # 
        # *   on: enabled
        # *   off: disabled
        self.status = status
        # The type of object in the blacklist or whitelist.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.content is not None:
            result['Content'] = self.content
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.is_white is not None:
            result['IsWhite'] = self.is_white
        if self.name is not None:
            result['Name'] = self.name
        if self.note is not None:
            result['Note'] = self.note
        if self.resource_id_json_list is not None:
            result['ResourceIdJsonList'] = self.resource_id_json_list
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('IsWhite') is not None:
            self.is_white = m.get('IsWhite')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('ResourceIdJsonList') is not None:
            self.resource_id_json_list = m.get('ResourceIdJsonList')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddBlackWhiteListResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The ID of the record.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddBlackWhiteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddBlackWhiteListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddBlackWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGatewayRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag.
        self.key = key
        # The value of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddGatewayRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        enable_hardware_acceleration: bool = None,
        enable_sls: bool = None,
        enable_xtrace: bool = None,
        enterprise_security_group: bool = None,
        internet_slb_spec: str = None,
        name: str = None,
        region: str = None,
        replica: int = None,
        resource_group_id: str = None,
        slb_spec: str = None,
        spec: str = None,
        tag: List[AddGatewayRequestTag] = None,
        v_switch_id: str = None,
        v_switch_id_2: str = None,
        vpc: str = None,
        xtrace_ratio: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # Specifies whether to enable hardware acceleration.
        self.enable_hardware_acceleration = enable_hardware_acceleration
        # Specifies whether to activate Log Service.
        self.enable_sls = enable_sls
        # Specifies whether to activate Tracing Analysis.
        self.enable_xtrace = enable_xtrace
        # Specifies whether to use an advanced security group.
        self.enterprise_security_group = enterprise_security_group
        # The specifications of the Internet-facing SLB instance. Valid values:
        # 
        # *   slb.s1.small
        # *   slb.s2.small
        # *   slb.s2.medium
        # *   slb.s3.small
        # *   slb.s3.medium
        # *   slb.s3.large
        self.internet_slb_spec = internet_slb_spec
        # The name of the gateway.
        self.name = name
        # The region ID.
        self.region = region
        # The number of nodes.
        self.replica = replica
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The specifications of the internal-facing Server Load Balancer (SLB) instance. Valid values:
        # 
        # *   slb.s1.small
        # *   slb.s2.small
        # *   slb.s2.medium
        # *   slb.s3.small
        # *   slb.s3.medium
        # *   slb.s3.large
        self.slb_spec = slb_spec
        # The node specifications. Valid values:
        # 
        # *   MSE_GTW\_16\_32\_200\_c(16C32G)
        # *   MSE_GTW\_2\_4\_200\_c(2C4G)
        # *   MSE_GTW\_4\_8\_200\_c(4C8G)
        # *   MSE_GTW\_8\_16\_200\_c(8C16G)
        self.spec = spec
        # The tag of the gateway.
        self.tag = tag
        # The ID of the primary vSwitch.
        self.v_switch_id = v_switch_id
        # The ID of the secondary vSwitch.
        self.v_switch_id_2 = v_switch_id_2
        # The ID of the virtual private cloud (VPC).
        self.vpc = vpc
        # The sample rate of Tracing Analysis. Valid values: \[1,100].
        self.xtrace_ratio = xtrace_ratio

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.enable_hardware_acceleration is not None:
            result['EnableHardwareAcceleration'] = self.enable_hardware_acceleration
        if self.enable_sls is not None:
            result['EnableSls'] = self.enable_sls
        if self.enable_xtrace is not None:
            result['EnableXtrace'] = self.enable_xtrace
        if self.enterprise_security_group is not None:
            result['EnterpriseSecurityGroup'] = self.enterprise_security_group
        if self.internet_slb_spec is not None:
            result['InternetSlbSpec'] = self.internet_slb_spec
        if self.name is not None:
            result['Name'] = self.name
        if self.region is not None:
            result['Region'] = self.region
        if self.replica is not None:
            result['Replica'] = self.replica
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.slb_spec is not None:
            result['SlbSpec'] = self.slb_spec
        if self.spec is not None:
            result['Spec'] = self.spec
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.v_switch_id_2 is not None:
            result['VSwitchId2'] = self.v_switch_id_2
        if self.vpc is not None:
            result['Vpc'] = self.vpc
        if self.xtrace_ratio is not None:
            result['XtraceRatio'] = self.xtrace_ratio
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('EnableHardwareAcceleration') is not None:
            self.enable_hardware_acceleration = m.get('EnableHardwareAcceleration')
        if m.get('EnableSls') is not None:
            self.enable_sls = m.get('EnableSls')
        if m.get('EnableXtrace') is not None:
            self.enable_xtrace = m.get('EnableXtrace')
        if m.get('EnterpriseSecurityGroup') is not None:
            self.enterprise_security_group = m.get('EnterpriseSecurityGroup')
        if m.get('InternetSlbSpec') is not None:
            self.internet_slb_spec = m.get('InternetSlbSpec')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Replica') is not None:
            self.replica = m.get('Replica')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SlbSpec') is not None:
            self.slb_spec = m.get('SlbSpec')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddGatewayRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VSwitchId2') is not None:
            self.v_switch_id_2 = m.get('VSwitchId2')
        if m.get('Vpc') is not None:
            self.vpc = m.get('Vpc')
        if m.get('XtraceRatio') is not None:
            self.xtrace_ratio = m.get('XtraceRatio')
        return self


class AddGatewayResponseBodyData(TeaModel):
    def __init__(
        self,
        gateway_unique_id: str = None,
    ):
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        return self


class AddGatewayResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: AddGatewayResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        # 
        # *   If the request is successful, a success message is returned.
        # *   If the request fails, an error message is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddGatewayResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddGatewayResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGatewayDomainRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cert_identifier: str = None,
        gateway_unique_id: str = None,
        http_2: str = None,
        must_https: bool = None,
        name: str = None,
        protocol: str = None,
        tls_max: str = None,
        tls_min: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the certificate.
        self.cert_identifier = cert_identifier
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # Specifies whether to enable `HTTP/2`.
        # 
        # *   `open`: enables `HTTP/2`
        # *   `close`: disables `HTTP/2`
        # *   `globalConfig`: uses global configurations
        self.http_2 = http_2
        # Specifies whether to enable HTTPS.
        self.must_https = must_https
        # The domain name.
        self.name = name
        # The type of the protocol. Valid values:
        # 
        # *   `HTTP`
        # *   `HTTPS`
        self.protocol = protocol
        # The maximum version of Transport Layer Security (TLS).
        self.tls_max = tls_max
        # The minimum version of TLS.
        self.tls_min = tls_min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cert_identifier is not None:
            result['CertIdentifier'] = self.cert_identifier
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.http_2 is not None:
            result['Http2'] = self.http_2
        if self.must_https is not None:
            result['MustHttps'] = self.must_https
        if self.name is not None:
            result['Name'] = self.name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.tls_max is not None:
            result['TlsMax'] = self.tls_max
        if self.tls_min is not None:
            result['TlsMin'] = self.tls_min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('CertIdentifier') is not None:
            self.cert_identifier = m.get('CertIdentifier')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Http2') is not None:
            self.http_2 = m.get('Http2')
        if m.get('MustHttps') is not None:
            self.must_https = m.get('MustHttps')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('TlsMax') is not None:
            self.tls_max = m.get('TlsMax')
        if m.get('TlsMin') is not None:
            self.tls_min = m.get('TlsMin')
        return self


class AddGatewayDomainResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddGatewayDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddGatewayDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGatewayDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGatewayRouteRequestDirectResponseJSON(TeaModel):
    def __init__(
        self,
        body: str = None,
        code: int = None,
    ):
        # The mock return value.
        self.body = body
        # The mock return code.
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['Body'] = self.body
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Body') is not None:
            self.body = m.get('Body')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class AddGatewayRouteRequestFallbackServices(TeaModel):
    def __init__(
        self,
        agreement_type: str = None,
        group_name: str = None,
        name: str = None,
        namespace: str = None,
        percent: int = None,
        service_id: int = None,
        service_port: int = None,
        source_type: str = None,
        version: str = None,
    ):
        # The type of the protocol.
        self.agreement_type = agreement_type
        # The name of the group to which the service belongs.
        self.group_name = group_name
        # The name of the application.
        self.name = name
        # The namespace in which the service resides.
        self.namespace = namespace
        # The weight in the form of a percentage value.
        self.percent = percent
        # The ID of the service.
        self.service_id = service_id
        # The service port number.
        self.service_port = service_port
        # The type of the service source.
        self.source_type = source_type
        # The version of the service.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agreement_type is not None:
            result['AgreementType'] = self.agreement_type
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgreementType') is not None:
            self.agreement_type = m.get('AgreementType')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class AddGatewayRouteRequestPredicatesHeaderPredicates(TeaModel):
    def __init__(
        self,
        key: str = None,
        type: str = None,
        value: str = None,
    ):
        # The key of the request header.
        self.key = key
        # The matching type.
        self.type = type
        # The value of the request header.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddGatewayRouteRequestPredicatesPathPredicates(TeaModel):
    def __init__(
        self,
        ignore_case: bool = None,
        path: str = None,
        type: str = None,
    ):
        # Specifies whether to perform case-insensitive matching.
        self.ignore_case = ignore_case
        # The path.
        self.path = path
        # The route matching type. Valid values:
        # 
        # *   PRE: prefix matching
        # *   EQUAL: exact matching
        # *   ERGULAR: regular expression matching
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignore_case is not None:
            result['IgnoreCase'] = self.ignore_case
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoreCase') is not None:
            self.ignore_case = m.get('IgnoreCase')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddGatewayRouteRequestPredicatesQueryPredicates(TeaModel):
    def __init__(
        self,
        key: str = None,
        type: str = None,
        value: str = None,
    ):
        # The name of the parameter.
        self.key = key
        # The matching type.
        self.type = type
        # The value of the parameter.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddGatewayRouteRequestPredicates(TeaModel):
    def __init__(
        self,
        header_predicates: List[AddGatewayRouteRequestPredicatesHeaderPredicates] = None,
        method_predicates: List[str] = None,
        path_predicates: AddGatewayRouteRequestPredicatesPathPredicates = None,
        query_predicates: List[AddGatewayRouteRequestPredicatesQueryPredicates] = None,
    ):
        # The information about header matching.
        self.header_predicates = header_predicates
        # The information about method matching.
        self.method_predicates = method_predicates
        # The information about route matching.
        self.path_predicates = path_predicates
        # The information about URL parameter matching.
        self.query_predicates = query_predicates

    def validate(self):
        if self.header_predicates:
            for k in self.header_predicates:
                if k:
                    k.validate()
        if self.path_predicates:
            self.path_predicates.validate()
        if self.query_predicates:
            for k in self.query_predicates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HeaderPredicates'] = []
        if self.header_predicates is not None:
            for k in self.header_predicates:
                result['HeaderPredicates'].append(k.to_map() if k else None)
        if self.method_predicates is not None:
            result['MethodPredicates'] = self.method_predicates
        if self.path_predicates is not None:
            result['PathPredicates'] = self.path_predicates.to_map()
        result['QueryPredicates'] = []
        if self.query_predicates is not None:
            for k in self.query_predicates:
                result['QueryPredicates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.header_predicates = []
        if m.get('HeaderPredicates') is not None:
            for k in m.get('HeaderPredicates'):
                temp_model = AddGatewayRouteRequestPredicatesHeaderPredicates()
                self.header_predicates.append(temp_model.from_map(k))
        if m.get('MethodPredicates') is not None:
            self.method_predicates = m.get('MethodPredicates')
        if m.get('PathPredicates') is not None:
            temp_model = AddGatewayRouteRequestPredicatesPathPredicates()
            self.path_predicates = temp_model.from_map(m['PathPredicates'])
        self.query_predicates = []
        if m.get('QueryPredicates') is not None:
            for k in m.get('QueryPredicates'):
                temp_model = AddGatewayRouteRequestPredicatesQueryPredicates()
                self.query_predicates.append(temp_model.from_map(k))
        return self


class AddGatewayRouteRequestRedirectJSON(TeaModel):
    def __init__(
        self,
        code: int = None,
        host: str = None,
        path: str = None,
    ):
        # The status code returned.
        self.code = code
        # The hostname to be redirected to.
        self.host = host
        # The path to be redirected to.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.host is not None:
            result['Host'] = self.host
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class AddGatewayRouteRequestServicesHttpDubboTranscoderMothedMapListParamMapsList(TeaModel):
    def __init__(
        self,
        extract_key: str = None,
        extract_key_spec: str = None,
        mapping_type: str = None,
    ):
        # The key extracted from the input parameter.
        self.extract_key = extract_key
        # The position of the input parameter.
        # 
        # > Valid values:
        # 
        # *   `ALL_QUERY_PARAMETER`: request parameter
        # 
        # *   `ALL_HEADER`: request header
        # *   `ALL_PATH`: request path
        # *   `ALL_BODY`: request body
        self.extract_key_spec = extract_key_spec
        # The type of the backend service parameter.
        self.mapping_type = mapping_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extract_key is not None:
            result['ExtractKey'] = self.extract_key
        if self.extract_key_spec is not None:
            result['ExtractKeySpec'] = self.extract_key_spec
        if self.mapping_type is not None:
            result['MappingType'] = self.mapping_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtractKey') is not None:
            self.extract_key = m.get('ExtractKey')
        if m.get('ExtractKeySpec') is not None:
            self.extract_key_spec = m.get('ExtractKeySpec')
        if m.get('MappingType') is not None:
            self.mapping_type = m.get('MappingType')
        return self


class AddGatewayRouteRequestServicesHttpDubboTranscoderMothedMapList(TeaModel):
    def __init__(
        self,
        dubbo_mothed_name: str = None,
        http_mothed: str = None,
        mothedpath: str = None,
        param_maps_list: List[AddGatewayRouteRequestServicesHttpDubboTranscoderMothedMapListParamMapsList] = None,
        pass_through_all_headers: str = None,
        pass_through_list: List[str] = None,
    ):
        # The method name of the Dubbo service.
        self.dubbo_mothed_name = dubbo_mothed_name
        # The HTTP method.
        # 
        # > Valid values:
        # 
        # *   ALL_GET
        # 
        # *   ALL_POST
        # 
        # *   ALL_PUT
        # 
        # *   ALL_DELETE
        # 
        # *   ALL_PATCH
        self.http_mothed = http_mothed
        # The path that is used to match a method.
        self.mothedpath = mothedpath
        # The information of parameter mappings.
        self.param_maps_list = param_maps_list
        # The pass-through type of the header.
        # 
        # > Valid values:
        # 
        # *   PASS_ALL: All headers are passed through.
        # 
        # *   PASS_NOT: All headers are not passed through.
        # 
        # *   PASS_ASSIGN: Specified headers are passed through.
        self.pass_through_all_headers = pass_through_all_headers
        # The list of headers to be passed through.
        self.pass_through_list = pass_through_list

    def validate(self):
        if self.param_maps_list:
            for k in self.param_maps_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dubbo_mothed_name is not None:
            result['DubboMothedName'] = self.dubbo_mothed_name
        if self.http_mothed is not None:
            result['HttpMothed'] = self.http_mothed
        if self.mothedpath is not None:
            result['Mothedpath'] = self.mothedpath
        result['ParamMapsList'] = []
        if self.param_maps_list is not None:
            for k in self.param_maps_list:
                result['ParamMapsList'].append(k.to_map() if k else None)
        if self.pass_through_all_headers is not None:
            result['PassThroughAllHeaders'] = self.pass_through_all_headers
        if self.pass_through_list is not None:
            result['PassThroughList'] = self.pass_through_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DubboMothedName') is not None:
            self.dubbo_mothed_name = m.get('DubboMothedName')
        if m.get('HttpMothed') is not None:
            self.http_mothed = m.get('HttpMothed')
        if m.get('Mothedpath') is not None:
            self.mothedpath = m.get('Mothedpath')
        self.param_maps_list = []
        if m.get('ParamMapsList') is not None:
            for k in m.get('ParamMapsList'):
                temp_model = AddGatewayRouteRequestServicesHttpDubboTranscoderMothedMapListParamMapsList()
                self.param_maps_list.append(temp_model.from_map(k))
        if m.get('PassThroughAllHeaders') is not None:
            self.pass_through_all_headers = m.get('PassThroughAllHeaders')
        if m.get('PassThroughList') is not None:
            self.pass_through_list = m.get('PassThroughList')
        return self


class AddGatewayRouteRequestServicesHttpDubboTranscoder(TeaModel):
    def __init__(
        self,
        dubbo_service_group: str = None,
        dubbo_service_name: str = None,
        dubbo_service_version: str = None,
        mothed_map_list: List[AddGatewayRouteRequestServicesHttpDubboTranscoderMothedMapList] = None,
    ):
        # The service group.
        self.dubbo_service_group = dubbo_service_group
        # The name of the Dubbo service.
        self.dubbo_service_name = dubbo_service_name
        # The version of the Dubbo service.
        self.dubbo_service_version = dubbo_service_version
        # The forwarding rules of the Dubbo service.
        self.mothed_map_list = mothed_map_list

    def validate(self):
        if self.mothed_map_list:
            for k in self.mothed_map_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dubbo_service_group is not None:
            result['DubboServiceGroup'] = self.dubbo_service_group
        if self.dubbo_service_name is not None:
            result['DubboServiceName'] = self.dubbo_service_name
        if self.dubbo_service_version is not None:
            result['DubboServiceVersion'] = self.dubbo_service_version
        result['MothedMapList'] = []
        if self.mothed_map_list is not None:
            for k in self.mothed_map_list:
                result['MothedMapList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DubboServiceGroup') is not None:
            self.dubbo_service_group = m.get('DubboServiceGroup')
        if m.get('DubboServiceName') is not None:
            self.dubbo_service_name = m.get('DubboServiceName')
        if m.get('DubboServiceVersion') is not None:
            self.dubbo_service_version = m.get('DubboServiceVersion')
        self.mothed_map_list = []
        if m.get('MothedMapList') is not None:
            for k in m.get('MothedMapList'):
                temp_model = AddGatewayRouteRequestServicesHttpDubboTranscoderMothedMapList()
                self.mothed_map_list.append(temp_model.from_map(k))
        return self


class AddGatewayRouteRequestServices(TeaModel):
    def __init__(
        self,
        agreement_type: str = None,
        group_name: str = None,
        http_dubbo_transcoder: AddGatewayRouteRequestServicesHttpDubboTranscoder = None,
        name: str = None,
        namespace: str = None,
        percent: int = None,
        service_id: int = None,
        service_port: int = None,
        source_type: str = None,
        version: str = None,
    ):
        # The type of the protocol.
        self.agreement_type = agreement_type
        # The name of the group to which the service belongs.
        self.group_name = group_name
        # The transcoder of the Dubbo protocol.
        self.http_dubbo_transcoder = http_dubbo_transcoder
        # The name.
        self.name = name
        # The namespace in which the service resides.
        self.namespace = namespace
        # The weight in the form of a percentage value.
        self.percent = percent
        # The ID of the service.
        self.service_id = service_id
        # The service port number.
        self.service_port = service_port
        # The type of the service source.
        self.source_type = source_type
        # The version of the service.
        self.version = version

    def validate(self):
        if self.http_dubbo_transcoder:
            self.http_dubbo_transcoder.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agreement_type is not None:
            result['AgreementType'] = self.agreement_type
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.http_dubbo_transcoder is not None:
            result['HttpDubboTranscoder'] = self.http_dubbo_transcoder.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgreementType') is not None:
            self.agreement_type = m.get('AgreementType')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HttpDubboTranscoder') is not None:
            temp_model = AddGatewayRouteRequestServicesHttpDubboTranscoder()
            self.http_dubbo_transcoder = temp_model.from_map(m['HttpDubboTranscoder'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class AddGatewayRouteRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        destination_type: str = None,
        direct_response_json: AddGatewayRouteRequestDirectResponseJSON = None,
        domain_id: int = None,
        domain_id_list_json: str = None,
        enable_waf: bool = None,
        fallback: bool = None,
        fallback_services: List[AddGatewayRouteRequestFallbackServices] = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        name: str = None,
        predicates: AddGatewayRouteRequestPredicates = None,
        redirect_json: AddGatewayRouteRequestRedirectJSON = None,
        route_order: int = None,
        services: List[AddGatewayRouteRequestServices] = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The destination service type.
        self.destination_type = destination_type
        # The mock response configuration.
        self.direct_response_json = direct_response_json
        # The domain ID.
        self.domain_id = domain_id
        # The list of domain names.
        self.domain_id_list_json = domain_id_list_json
        # Specifies whether to activate Web Application Firewall (WAF).
        self.enable_waf = enable_waf
        # Specifies whether to enable the Fallback service.
        self.fallback = fallback
        # The information about the Fallback service.
        self.fallback_services = fallback_services
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The name of the route.
        self.name = name
        # The matching rule.
        self.predicates = predicates
        # The configuration of the redirection.
        self.redirect_json = redirect_json
        # The sequence number of the route. (A small value indicates a high priority.)
        self.route_order = route_order
        # The information about services.
        self.services = services

    def validate(self):
        if self.direct_response_json:
            self.direct_response_json.validate()
        if self.fallback_services:
            for k in self.fallback_services:
                if k:
                    k.validate()
        if self.predicates:
            self.predicates.validate()
        if self.redirect_json:
            self.redirect_json.validate()
        if self.services:
            for k in self.services:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.direct_response_json is not None:
            result['DirectResponseJSON'] = self.direct_response_json.to_map()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_id_list_json is not None:
            result['DomainIdListJSON'] = self.domain_id_list_json
        if self.enable_waf is not None:
            result['EnableWaf'] = self.enable_waf
        if self.fallback is not None:
            result['Fallback'] = self.fallback
        result['FallbackServices'] = []
        if self.fallback_services is not None:
            for k in self.fallback_services:
                result['FallbackServices'].append(k.to_map() if k else None)
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.name is not None:
            result['Name'] = self.name
        if self.predicates is not None:
            result['Predicates'] = self.predicates.to_map()
        if self.redirect_json is not None:
            result['RedirectJSON'] = self.redirect_json.to_map()
        if self.route_order is not None:
            result['RouteOrder'] = self.route_order
        result['Services'] = []
        if self.services is not None:
            for k in self.services:
                result['Services'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('DirectResponseJSON') is not None:
            temp_model = AddGatewayRouteRequestDirectResponseJSON()
            self.direct_response_json = temp_model.from_map(m['DirectResponseJSON'])
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainIdListJSON') is not None:
            self.domain_id_list_json = m.get('DomainIdListJSON')
        if m.get('EnableWaf') is not None:
            self.enable_waf = m.get('EnableWaf')
        if m.get('Fallback') is not None:
            self.fallback = m.get('Fallback')
        self.fallback_services = []
        if m.get('FallbackServices') is not None:
            for k in m.get('FallbackServices'):
                temp_model = AddGatewayRouteRequestFallbackServices()
                self.fallback_services.append(temp_model.from_map(k))
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Predicates') is not None:
            temp_model = AddGatewayRouteRequestPredicates()
            self.predicates = temp_model.from_map(m['Predicates'])
        if m.get('RedirectJSON') is not None:
            temp_model = AddGatewayRouteRequestRedirectJSON()
            self.redirect_json = temp_model.from_map(m['RedirectJSON'])
        if m.get('RouteOrder') is not None:
            self.route_order = m.get('RouteOrder')
        self.services = []
        if m.get('Services') is not None:
            for k in m.get('Services'):
                temp_model = AddGatewayRouteRequestServices()
                self.services.append(temp_model.from_map(k))
        return self


class AddGatewayRouteShrinkRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        destination_type: str = None,
        direct_response_jsonshrink: str = None,
        domain_id: int = None,
        domain_id_list_json: str = None,
        enable_waf: bool = None,
        fallback: bool = None,
        fallback_services_shrink: str = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        name: str = None,
        predicates_shrink: str = None,
        redirect_jsonshrink: str = None,
        route_order: int = None,
        services_shrink: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The destination service type.
        self.destination_type = destination_type
        # The mock response configuration.
        self.direct_response_jsonshrink = direct_response_jsonshrink
        # The domain ID.
        self.domain_id = domain_id
        # The list of domain names.
        self.domain_id_list_json = domain_id_list_json
        # Specifies whether to activate Web Application Firewall (WAF).
        self.enable_waf = enable_waf
        # Specifies whether to enable the Fallback service.
        self.fallback = fallback
        # The information about the Fallback service.
        self.fallback_services_shrink = fallback_services_shrink
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The name of the route.
        self.name = name
        # The matching rule.
        self.predicates_shrink = predicates_shrink
        # The configuration of the redirection.
        self.redirect_jsonshrink = redirect_jsonshrink
        # The sequence number of the route. (A small value indicates a high priority.)
        self.route_order = route_order
        # The information about services.
        self.services_shrink = services_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.direct_response_jsonshrink is not None:
            result['DirectResponseJSON'] = self.direct_response_jsonshrink
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_id_list_json is not None:
            result['DomainIdListJSON'] = self.domain_id_list_json
        if self.enable_waf is not None:
            result['EnableWaf'] = self.enable_waf
        if self.fallback is not None:
            result['Fallback'] = self.fallback
        if self.fallback_services_shrink is not None:
            result['FallbackServices'] = self.fallback_services_shrink
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.name is not None:
            result['Name'] = self.name
        if self.predicates_shrink is not None:
            result['Predicates'] = self.predicates_shrink
        if self.redirect_jsonshrink is not None:
            result['RedirectJSON'] = self.redirect_jsonshrink
        if self.route_order is not None:
            result['RouteOrder'] = self.route_order
        if self.services_shrink is not None:
            result['Services'] = self.services_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('DirectResponseJSON') is not None:
            self.direct_response_jsonshrink = m.get('DirectResponseJSON')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainIdListJSON') is not None:
            self.domain_id_list_json = m.get('DomainIdListJSON')
        if m.get('EnableWaf') is not None:
            self.enable_waf = m.get('EnableWaf')
        if m.get('Fallback') is not None:
            self.fallback = m.get('Fallback')
        if m.get('FallbackServices') is not None:
            self.fallback_services_shrink = m.get('FallbackServices')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Predicates') is not None:
            self.predicates_shrink = m.get('Predicates')
        if m.get('RedirectJSON') is not None:
            self.redirect_jsonshrink = m.get('RedirectJSON')
        if m.get('RouteOrder') is not None:
            self.route_order = m.get('RouteOrder')
        if m.get('Services') is not None:
            self.services_shrink = m.get('Services')
        return self


class AddGatewayRouteResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddGatewayRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddGatewayRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGatewayRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGatewayServiceVersionRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        service_id: int = None,
        service_version: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the service.
        self.service_id = service_id
        # The version of the service.
        self.service_version = service_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        return self


class AddGatewayServiceVersionResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The value 200 indicates that the request is successfully processed.
        self.code = code
        # The ID of the created service version.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned if the request failed.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddGatewayServiceVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddGatewayServiceVersionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGatewayServiceVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGatewaySlbRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        http_port: int = None,
        https_port: int = None,
        https_vserver_group_id: str = None,
        service_weight: int = None,
        slb_id: str = None,
        type: str = None,
        vserver_group_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The HTTP port number (virtual service group).
        self.http_port = http_port
        # The HTTPS port number (virtual service group).
        self.https_port = https_port
        # The ID of the HTTPS virtual service group.
        self.https_vserver_group_id = https_vserver_group_id
        # The service weight.
        self.service_weight = service_weight
        # The ID of the SLB instance.
        self.slb_id = slb_id
        # The type.
        self.type = type
        # The ID of the HTTP virtual service group.
        self.vserver_group_id = vserver_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.http_port is not None:
            result['HttpPort'] = self.http_port
        if self.https_port is not None:
            result['HttpsPort'] = self.https_port
        if self.https_vserver_group_id is not None:
            result['HttpsVServerGroupId'] = self.https_vserver_group_id
        if self.service_weight is not None:
            result['ServiceWeight'] = self.service_weight
        if self.slb_id is not None:
            result['SlbId'] = self.slb_id
        if self.type is not None:
            result['Type'] = self.type
        if self.vserver_group_id is not None:
            result['VServerGroupId'] = self.vserver_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('HttpPort') is not None:
            self.http_port = m.get('HttpPort')
        if m.get('HttpsPort') is not None:
            self.https_port = m.get('HttpsPort')
        if m.get('HttpsVServerGroupId') is not None:
            self.https_vserver_group_id = m.get('HttpsVServerGroupId')
        if m.get('ServiceWeight') is not None:
            self.service_weight = m.get('ServiceWeight')
        if m.get('SlbId') is not None:
            self.slb_id = m.get('SlbId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VServerGroupId') is not None:
            self.vserver_group_id = m.get('VServerGroupId')
        return self


class AddGatewaySlbResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        # 
        # *   If the request is successful, a success message is returned.
        # *   If the request fails, an error message is returned.
        self.message = message
        # Id of the request
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddGatewaySlbResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddGatewaySlbResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGatewaySlbResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMigrationTaskRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_type: str = None,
        id: str = None,
        origin_instance_address: str = None,
        origin_instance_name: str = None,
        origin_instance_namespace: str = None,
        project_desc: str = None,
        request_pars: str = None,
        target_cluster_name: str = None,
        target_cluster_url: str = None,
        target_instance_id: str = None,
    ):
        self.accept_language = accept_language
        self.cluster_type = cluster_type
        self.id = id
        self.origin_instance_address = origin_instance_address
        self.origin_instance_name = origin_instance_name
        self.origin_instance_namespace = origin_instance_namespace
        self.project_desc = project_desc
        self.request_pars = request_pars
        self.target_cluster_name = target_cluster_name
        self.target_cluster_url = target_cluster_url
        self.target_instance_id = target_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.id is not None:
            result['Id'] = self.id
        if self.origin_instance_address is not None:
            result['OriginInstanceAddress'] = self.origin_instance_address
        if self.origin_instance_name is not None:
            result['OriginInstanceName'] = self.origin_instance_name
        if self.origin_instance_namespace is not None:
            result['OriginInstanceNamespace'] = self.origin_instance_namespace
        if self.project_desc is not None:
            result['ProjectDesc'] = self.project_desc
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        if self.target_cluster_name is not None:
            result['TargetClusterName'] = self.target_cluster_name
        if self.target_cluster_url is not None:
            result['TargetClusterUrl'] = self.target_cluster_url
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('OriginInstanceAddress') is not None:
            self.origin_instance_address = m.get('OriginInstanceAddress')
        if m.get('OriginInstanceName') is not None:
            self.origin_instance_name = m.get('OriginInstanceName')
        if m.get('OriginInstanceNamespace') is not None:
            self.origin_instance_namespace = m.get('OriginInstanceNamespace')
        if m.get('ProjectDesc') is not None:
            self.project_desc = m.get('ProjectDesc')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        if m.get('TargetClusterName') is not None:
            self.target_cluster_name = m.get('TargetClusterName')
        if m.get('TargetClusterUrl') is not None:
            self.target_cluster_url = m.get('TargetClusterUrl')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class AddMigrationTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_type: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: str = None,
        origin_instance_address: str = None,
        origin_instance_name: str = None,
        origin_instance_namespace: str = None,
        project_desc: str = None,
        target_cluster_name: str = None,
        target_cluster_url: str = None,
        target_instance_id: str = None,
        user_id: str = None,
    ):
        self.cluster_type = cluster_type
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.origin_instance_address = origin_instance_address
        self.origin_instance_name = origin_instance_name
        self.origin_instance_namespace = origin_instance_namespace
        self.project_desc = project_desc
        self.target_cluster_name = target_cluster_name
        self.target_cluster_url = target_cluster_url
        self.target_instance_id = target_instance_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.origin_instance_address is not None:
            result['OriginInstanceAddress'] = self.origin_instance_address
        if self.origin_instance_name is not None:
            result['OriginInstanceName'] = self.origin_instance_name
        if self.origin_instance_namespace is not None:
            result['OriginInstanceNamespace'] = self.origin_instance_namespace
        if self.project_desc is not None:
            result['ProjectDesc'] = self.project_desc
        if self.target_cluster_name is not None:
            result['TargetClusterName'] = self.target_cluster_name
        if self.target_cluster_url is not None:
            result['TargetClusterUrl'] = self.target_cluster_url
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('OriginInstanceAddress') is not None:
            self.origin_instance_address = m.get('OriginInstanceAddress')
        if m.get('OriginInstanceName') is not None:
            self.origin_instance_name = m.get('OriginInstanceName')
        if m.get('OriginInstanceNamespace') is not None:
            self.origin_instance_namespace = m.get('OriginInstanceNamespace')
        if m.get('ProjectDesc') is not None:
            self.project_desc = m.get('ProjectDesc')
        if m.get('TargetClusterName') is not None:
            self.target_cluster_name = m.get('TargetClusterName')
        if m.get('TargetClusterUrl') is not None:
            self.target_cluster_url = m.get('TargetClusterUrl')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AddMigrationTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: AddMigrationTaskResponseBodyData = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.http_code = http_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddMigrationTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddMigrationTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddMigrationTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMigrationTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMockRuleRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        consumer_app_ids: str = None,
        dubbo_mock_items: str = None,
        enable: bool = None,
        extra_json: str = None,
        mock_type: int = None,
        name: str = None,
        provider_app_id: str = None,
        provider_app_name: str = None,
        region: str = None,
        sc_mock_items: str = None,
        source: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the custom application.
        self.consumer_app_ids = consumer_app_ids
        # The items in the recycle bin.
        self.dubbo_mock_items = dubbo_mock_items
        # Specifies whether to enable the alert rule. Valid values:
        # 
        # *   `true`: enables the alert rule.
        # *   `false`: disables the alert rule.
        self.enable = enable
        # The description.
        self.extra_json = extra_json
        # The response time (RT) threshold of slow calls. Valid values:
        # 
        # *   \- 15: 15 ms
        # *   \- 30: 30 ms
        # *   \- 60: 60 ms
        # *   \- 120: 120 ms
        self.mock_type = mock_type
        # The name of the rule.
        self.name = name
        # The ID of the service provider application.
        self.provider_app_id = provider_app_id
        # The name of the service provider application.
        self.provider_app_name = provider_app_name
        # The ID of the region.
        self.region = region
        # The input parameters. The JSON format is supported.
        self.sc_mock_items = sc_mock_items
        # The rule source.
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.consumer_app_ids is not None:
            result['ConsumerAppIds'] = self.consumer_app_ids
        if self.dubbo_mock_items is not None:
            result['DubboMockItems'] = self.dubbo_mock_items
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.extra_json is not None:
            result['ExtraJson'] = self.extra_json
        if self.mock_type is not None:
            result['MockType'] = self.mock_type
        if self.name is not None:
            result['Name'] = self.name
        if self.provider_app_id is not None:
            result['ProviderAppId'] = self.provider_app_id
        if self.provider_app_name is not None:
            result['ProviderAppName'] = self.provider_app_name
        if self.region is not None:
            result['Region'] = self.region
        if self.sc_mock_items is not None:
            result['ScMockItems'] = self.sc_mock_items
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ConsumerAppIds') is not None:
            self.consumer_app_ids = m.get('ConsumerAppIds')
        if m.get('DubboMockItems') is not None:
            self.dubbo_mock_items = m.get('DubboMockItems')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('ExtraJson') is not None:
            self.extra_json = m.get('ExtraJson')
        if m.get('MockType') is not None:
            self.mock_type = m.get('MockType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProviderAppId') is not None:
            self.provider_app_id = m.get('ProviderAppId')
        if m.get('ProviderAppName') is not None:
            self.provider_app_name = m.get('ProviderAppName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ScMockItems') is not None:
            self.sc_mock_items = m.get('ScMockItems')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class AddMockRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        consumer_app_id: str = None,
        consumer_app_name: str = None,
        enable: bool = None,
        extra_json: str = None,
        id: int = None,
        mock_type: int = None,
        name: str = None,
        namespace_id: str = None,
        provider_app_id: str = None,
        provider_app_name: str = None,
        region: str = None,
        sc_mock_item_json: str = None,
        source: str = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.account_id = account_id
        # The ID of the consumer application.
        self.consumer_app_id = consumer_app_id
        # The name of the consumer application.
        self.consumer_app_name = consumer_app_name
        # Indicates whether the mock rule is enabled.
        # 
        # *   `true`: enabled
        # *   `false`: disabled
        self.enable = enable
        # The description.
        self.extra_json = extra_json
        # The ID of the rule.
        self.id = id
        # The mock type. Valid values:
        # 
        # *   \- `[unk]0[unk]`: desktop client
        # *   \- `[unk]1[unk]`: mobile client
        self.mock_type = mock_type
        # The name.
        self.name = name
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The ID of the service provider application.
        self.provider_app_id = provider_app_id
        # The name of the service provider application.
        self.provider_app_name = provider_app_name
        # The region ID.
        self.region = region
        # The HTTP mock rule.
        self.sc_mock_item_json = sc_mock_item_json
        # The service source.
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.consumer_app_id is not None:
            result['ConsumerAppId'] = self.consumer_app_id
        if self.consumer_app_name is not None:
            result['ConsumerAppName'] = self.consumer_app_name
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.extra_json is not None:
            result['ExtraJson'] = self.extra_json
        if self.id is not None:
            result['Id'] = self.id
        if self.mock_type is not None:
            result['MockType'] = self.mock_type
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.provider_app_id is not None:
            result['ProviderAppId'] = self.provider_app_id
        if self.provider_app_name is not None:
            result['ProviderAppName'] = self.provider_app_name
        if self.region is not None:
            result['Region'] = self.region
        if self.sc_mock_item_json is not None:
            result['ScMockItemJson'] = self.sc_mock_item_json
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('ConsumerAppId') is not None:
            self.consumer_app_id = m.get('ConsumerAppId')
        if m.get('ConsumerAppName') is not None:
            self.consumer_app_name = m.get('ConsumerAppName')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('ExtraJson') is not None:
            self.extra_json = m.get('ExtraJson')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MockType') is not None:
            self.mock_type = m.get('MockType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('ProviderAppId') is not None:
            self.provider_app_id = m.get('ProviderAppId')
        if m.get('ProviderAppName') is not None:
            self.provider_app_name = m.get('ProviderAppName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ScMockItemJson') is not None:
            self.sc_mock_item_json = m.get('ScMockItemJson')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class AddMockRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: AddMockRuleResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddMockRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddMockRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddMockRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMockRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSSLCertRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cert_identifier: str = None,
        domain_id: int = None,
        gateway_unique_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the certificate.
        self.cert_identifier = cert_identifier
        # The domain ID.
        self.domain_id = domain_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cert_identifier is not None:
            result['CertIdentifier'] = self.cert_identifier
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('CertIdentifier') is not None:
            self.cert_identifier = m.get('CertIdentifier')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        return self


class AddSSLCertResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # Indicates whether the association is successful.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddSSLCertResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddSSLCertResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSSLCertResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSecurityGroupRuleRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        description: str = None,
        gateway_unique_id: str = None,
        port_range: str = None,
        security_group_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The description.
        self.description = description
        # The ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The range of port numbers.
        self.port_range = port_range
        # The ID of the security group.
        self.security_group_id = security_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.description is not None:
            result['Description'] = self.description
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class AddSecurityGroupRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddSecurityGroupRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddSecurityGroupRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSecurityGroupRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddServiceSourceRequestIngressOptionsRequest(TeaModel):
    def __init__(
        self,
        enable_ingress: bool = None,
        enable_status: bool = None,
        ingress_class: str = None,
        watch_namespace: str = None,
    ):
        # Specifies whether to enable Ingress.
        self.enable_ingress = enable_ingress
        # Specifies whether to update the Ingress status.
        self.enable_status = enable_status
        # Specifies whether to monitor Ingress classes.
        self.ingress_class = ingress_class
        # The namespace whose resources you want to monitor.
        self.watch_namespace = watch_namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_ingress is not None:
            result['EnableIngress'] = self.enable_ingress
        if self.enable_status is not None:
            result['EnableStatus'] = self.enable_status
        if self.ingress_class is not None:
            result['IngressClass'] = self.ingress_class
        if self.watch_namespace is not None:
            result['WatchNamespace'] = self.watch_namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableIngress') is not None:
            self.enable_ingress = m.get('EnableIngress')
        if m.get('EnableStatus') is not None:
            self.enable_status = m.get('EnableStatus')
        if m.get('IngressClass') is not None:
            self.ingress_class = m.get('IngressClass')
        if m.get('WatchNamespace') is not None:
            self.watch_namespace = m.get('WatchNamespace')
        return self


class AddServiceSourceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        address: str = None,
        gateway_unique_id: str = None,
        group_list: List[str] = None,
        ingress_options_request: AddServiceSourceRequestIngressOptionsRequest = None,
        name: str = None,
        path_list: List[str] = None,
        source: str = None,
        type: str = None,
    ):
        # The language in which the returned information is displayed. Valid values:
        # 
        # *   zh-CN: Chinese. This is the default value.
        # *   en-US: English.
        # *   ja: Japanese.
        self.accept_language = accept_language
        # The endpoint.
        self.address = address
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The list of service groups.
        self.group_list = group_list
        # The Ingress configuration.
        self.ingress_options_request = ingress_options_request
        # The name.
        # 
        # > The parameter value varies based on the source type.
        # 
        # *   If Type is set to K8S, this parameter specifies the name of the ACK cluster.
        # *   If Type is set to NACOS, this parameter specifies the ID of the instance.
        self.name = name
        # An array of service root paths.
        self.path_list = path_list
        # The service source.
        # 
        # *   K8S: ACK cluster
        # *   MSE: Nacos instance
        self.source = source
        # The type of the service source. Valid values:
        # 
        # *   K8S: ACK cluster
        # *   NACOS: Nacos instance
        self.type = type

    def validate(self):
        if self.ingress_options_request:
            self.ingress_options_request.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.address is not None:
            result['Address'] = self.address
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.group_list is not None:
            result['GroupList'] = self.group_list
        if self.ingress_options_request is not None:
            result['IngressOptionsRequest'] = self.ingress_options_request.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.path_list is not None:
            result['PathList'] = self.path_list
        if self.source is not None:
            result['Source'] = self.source
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GroupList') is not None:
            self.group_list = m.get('GroupList')
        if m.get('IngressOptionsRequest') is not None:
            temp_model = AddServiceSourceRequestIngressOptionsRequest()
            self.ingress_options_request = temp_model.from_map(m['IngressOptionsRequest'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PathList') is not None:
            self.path_list = m.get('PathList')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddServiceSourceShrinkRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        address: str = None,
        gateway_unique_id: str = None,
        group_list_shrink: str = None,
        ingress_options_request_shrink: str = None,
        name: str = None,
        path_list_shrink: str = None,
        source: str = None,
        type: str = None,
    ):
        # The language in which the returned information is displayed. Valid values:
        # 
        # *   zh-CN: Chinese. This is the default value.
        # *   en-US: English.
        # *   ja: Japanese.
        self.accept_language = accept_language
        # The endpoint.
        self.address = address
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The list of service groups.
        self.group_list_shrink = group_list_shrink
        # The Ingress configuration.
        self.ingress_options_request_shrink = ingress_options_request_shrink
        # The name.
        # 
        # > The parameter value varies based on the source type.
        # 
        # *   If Type is set to K8S, this parameter specifies the name of the ACK cluster.
        # *   If Type is set to NACOS, this parameter specifies the ID of the instance.
        self.name = name
        # An array of service root paths.
        self.path_list_shrink = path_list_shrink
        # The service source.
        # 
        # *   K8S: ACK cluster
        # *   MSE: Nacos instance
        self.source = source
        # The type of the service source. Valid values:
        # 
        # *   K8S: ACK cluster
        # *   NACOS: Nacos instance
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.address is not None:
            result['Address'] = self.address
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.group_list_shrink is not None:
            result['GroupList'] = self.group_list_shrink
        if self.ingress_options_request_shrink is not None:
            result['IngressOptionsRequest'] = self.ingress_options_request_shrink
        if self.name is not None:
            result['Name'] = self.name
        if self.path_list_shrink is not None:
            result['PathList'] = self.path_list_shrink
        if self.source is not None:
            result['Source'] = self.source
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GroupList') is not None:
            self.group_list_shrink = m.get('GroupList')
        if m.get('IngressOptionsRequest') is not None:
            self.ingress_options_request_shrink = m.get('IngressOptionsRequest')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PathList') is not None:
            self.path_list_shrink = m.get('PathList')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddServiceSourceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddServiceSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddServiceSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddServiceSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyGatewayRouteRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        route_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the route.
        self.route_id = route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class ApplyGatewayRouteResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The data of the node.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ApplyGatewayRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyGatewayRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyGatewayRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyTagPoliciesRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_id: str = None,
        enable: bool = None,
        namespace_id: str = None,
        region: str = None,
        rules: str = None,
        source: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the application.
        self.app_id = app_id
        # Specifies whether to enable the routing rule.
        self.enable = enable
        # Optional. The ID of the namespace.
        self.namespace_id = namespace_id
        # The region ID.
        self.region = region
        # The details of the routing rule.
        self.rules = rules
        # The service source.
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.region is not None:
            result['Region'] = self.region
        if self.rules is not None:
            result['Rules'] = self.rules
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Rules') is not None:
            self.rules = m.get('Rules')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class ApplyTagPoliciesResponseBodyData(TeaModel):
    def __init__(
        self,
        carry_data: bool = None,
        enable: bool = None,
        id: int = None,
        instance_num: int = None,
        name: str = None,
        rate: int = None,
        remove: bool = None,
        rules: str = None,
        status: int = None,
        tag: str = None,
    ):
        # Indicates whether the field is the primary key.
        self.carry_data = carry_data
        # Indicates whether the routing rule is enabled.
        # 
        # *   `true`: enabled
        # *   `false`: disabled
        self.enable = enable
        # The ID of the primary key.
        self.id = id
        # The number of instances.
        self.instance_num = instance_num
        # The policy name.
        self.name = name
        # The rate.
        self.rate = rate
        # Indicates whether the routing rule is deleted.
        self.remove = remove
        # The details of the routing rule.
        self.rules = rules
        # The status.
        self.status = status
        # The tag.
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.carry_data is not None:
            result['CarryData'] = self.carry_data
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_num is not None:
            result['InstanceNum'] = self.instance_num
        if self.name is not None:
            result['Name'] = self.name
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.rules is not None:
            result['Rules'] = self.rules
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CarryData') is not None:
            self.carry_data = m.get('CarryData')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceNum') is not None:
            self.instance_num = m.get('InstanceNum')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Rules') is not None:
            self.rules = m.get('Rules')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class ApplyTagPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[ApplyTagPoliciesResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ApplyTagPoliciesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ApplyTagPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyTagPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyTagPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneNacosConfigRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        ids: str = None,
        instance_id: str = None,
        origin_namespace_id: str = None,
        policy: str = None,
        target_namespace_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The IDs of configurations.
        self.ids = ids
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the source namespace.
        self.origin_namespace_id = origin_namespace_id
        # The policy used when a write conflict occurs.
        # 
        # *   ABORT
        # *   SKIP
        # *   OVERWRITE
        self.policy = policy
        # The ID of the destination namespace.
        self.target_namespace_id = target_namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.origin_namespace_id is not None:
            result['OriginNamespaceId'] = self.origin_namespace_id
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.target_namespace_id is not None:
            result['TargetNamespaceId'] = self.target_namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OriginNamespaceId') is not None:
            self.origin_namespace_id = m.get('OriginNamespaceId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('TargetNamespaceId') is not None:
            self.target_namespace_id = m.get('TargetNamespaceId')
        return self


class CloneNacosConfigResponseBodyDataFailData(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        group: str = None,
    ):
        # The ID of the data.
        self.data_id = data_id
        # The ID of the group.
        self.group = group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.group is not None:
            result['Group'] = self.group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        return self


class CloneNacosConfigResponseBodyDataSkipData(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        group: str = None,
    ):
        # The ID of the data.
        self.data_id = data_id
        # The ID of the group.
        self.group = group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.group is not None:
            result['Group'] = self.group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        return self


class CloneNacosConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        fail_data: List[CloneNacosConfigResponseBodyDataFailData] = None,
        skip_count: int = None,
        skip_data: List[CloneNacosConfigResponseBodyDataSkipData] = None,
        succ_count: int = None,
    ):
        # The details of the failed configurations.
        self.fail_data = fail_data
        # The number of skipped operations.
        self.skip_count = skip_count
        # The details of the skipped configurations.
        self.skip_data = skip_data
        # The number of successful operations.
        self.succ_count = succ_count

    def validate(self):
        if self.fail_data:
            for k in self.fail_data:
                if k:
                    k.validate()
        if self.skip_data:
            for k in self.skip_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailData'] = []
        if self.fail_data is not None:
            for k in self.fail_data:
                result['FailData'].append(k.to_map() if k else None)
        if self.skip_count is not None:
            result['SkipCount'] = self.skip_count
        result['SkipData'] = []
        if self.skip_data is not None:
            for k in self.skip_data:
                result['SkipData'].append(k.to_map() if k else None)
        if self.succ_count is not None:
            result['SuccCount'] = self.succ_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fail_data = []
        if m.get('FailData') is not None:
            for k in m.get('FailData'):
                temp_model = CloneNacosConfigResponseBodyDataFailData()
                self.fail_data.append(temp_model.from_map(k))
        if m.get('SkipCount') is not None:
            self.skip_count = m.get('SkipCount')
        self.skip_data = []
        if m.get('SkipData') is not None:
            for k in m.get('SkipData'):
                temp_model = CloneNacosConfigResponseBodyDataSkipData()
                self.skip_data.append(temp_model.from_map(k))
        if m.get('SuccCount') is not None:
            self.succ_count = m.get('SuccCount')
        return self


class CloneNacosConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: CloneNacosConfigResponseBodyData = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message. This parameter is used to replace the \*\*%s\*\* variable in the **ErrMessage** parameter.
        # 
        # > If the return value of the **ErrMessage** parameter is **The Value of Input Parameter %s is not valid** and the return value of the **DynamicMessage** parameter is **DtsJobId**, the specified **DtsJobId** parameter is invalid.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CloneNacosConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CloneNacosConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CloneNacosConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CloneNacosConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateApplicationRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_name: str = None,
        language: str = None,
        namespace: str = None,
        region: str = None,
        sentinel_enable: str = None,
        source: str = None,
        switch_enable: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The name of the application.
        self.app_name = app_name
        # The programming language of the application.
        self.language = language
        self.namespace = namespace
        # The region to which the application belongs.
        self.region = region
        # Specifies whether to enable the Sentinel-compatible mode.
        self.sentinel_enable = sentinel_enable
        # The service where the application is deployed. A value of ACK indicates Container Service for Kubernetes.
        self.source = source
        # Specifies whether to enable switching.
        self.switch_enable = switch_enable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.language is not None:
            result['Language'] = self.language
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region is not None:
            result['Region'] = self.region
        if self.sentinel_enable is not None:
            result['SentinelEnable'] = self.sentinel_enable
        if self.source is not None:
            result['Source'] = self.source
        if self.switch_enable is not None:
            result['SwitchEnable'] = self.switch_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SentinelEnable') is not None:
            self.sentinel_enable = m.get('SentinelEnable')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SwitchEnable') is not None:
            self.switch_enable = m.get('SwitchEnable')
        return self


class CreateApplicationResponseBodyData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_name: str = None,
        create_time: int = None,
        extra_info: str = None,
        language: str = None,
        license_key: str = None,
        namespace: str = None,
        region_id: str = None,
        source: str = None,
        status: int = None,
        update_time: int = None,
        user_id: str = None,
        version: str = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # The name of the application.
        self.app_name = app_name
        # The creation time.
        self.create_time = create_time
        # The additional information.
        self.extra_info = extra_info
        # The programming language of the application.
        self.language = language
        # The license key in use.
        self.license_key = license_key
        self.namespace = namespace
        # The region ID.
        self.region_id = region_id
        # The service where the application is deployed. Valid values:
        # 
        # *   \- ACK: Container Service for Kubernetes
        # *   \- Normal: another service
        self.source = source
        # The status of the application. A value of 1 indicates that the application is in a normal state.
        self.status = status
        # The update time.
        self.update_time = update_time
        # The ID of the Alibaba Cloud account.
        self.user_id = user_id
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.language is not None:
            result['Language'] = self.language
        if self.license_key is not None:
            result['LicenseKey'] = self.license_key
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('LicenseKey') is not None:
            self.license_key = m.get('LicenseKey')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class CreateApplicationResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: CreateApplicationResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The response code returned.
        self.code = code
        # The data of the node.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateApplicationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of a tag.
        self.key = key
        # The value of a tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateClusterRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_specification: str = None,
        cluster_type: str = None,
        cluster_version: str = None,
        connection_type: str = None,
        disk_type: str = None,
        instance_count: int = None,
        instance_name: str = None,
        mse_version: str = None,
        net_type: str = None,
        private_slb_specification: str = None,
        pub_network_flow: str = None,
        pub_slb_specification: str = None,
        region: str = None,
        request_pars: str = None,
        resource_group_id: str = None,
        tag: List[CreateClusterRequestTag] = None,
        v_switch_id: str = None,
        vpc_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The engine specifications. Valid values:
        # 
        # \[Professional Edition]
        # 
        # *   `MSE_SC_2_4_60_c`: 2 CPU cores and 4 GB of memory
        # *   `MSE_SC_1_2_60_c`: 1 CPU core and 2 GB of memory
        # *   `MSE_SC_4_8_60_c`: 4 CPU cores and 8 GB of memory
        # *   `MSE_SC_8_16_60_c`: 8 CPU cores and 16 GB of memory
        # *   `MSE_SC_16_32_60_c`: 16 CPU cores and 32 GB of memory
        # 
        # \[Developer Edition]
        # 
        # *   `MSE_SC_1_2_60_c`: 1 CPU core and 2 GB of memory
        # *   `MSE_SC_2_4_60_c`: 2 CPU cores and 4 GB of memory
        self.cluster_specification = cluster_specification
        # The type of the instance. Valid values: ZooKeeper and Nacos-Ans.
        self.cluster_type = cluster_type
        # The engine version of the instance. Valid values:
        # 
        # \[Professional Edition]
        # 
        # *   `NACOS_2_0_0`: Nacos 2.0.0
        # *   `ZooKeeper_3_8_0`: ZooKeeper 3.8.0
        # 
        # \[Developer Edition]
        # 
        # *   `NACOS_2_0_0`: Nacos 2.0.0
        # *   `ZooKeeper_3_8_0`: ZooKeeper 3.8.0
        self.cluster_version = cluster_version
        # The network connection type. Valid values:
        # 
        # *   slb
        # *   eni
        self.connection_type = connection_type
        # The disk type. Valid values:
        # 
        # *   alicloud-disk-ssd
        # *   alicloud-disk-essd-pl1
        self.disk_type = disk_type
        # The number of nodes in the instance. Valid values: 1 to 9.
        # 
        # \[Professional Edition]
        # 
        # *   The number of nodes in an instance is greater than or equal to 3 and must be an odd number.
        # 
        # \[Developer Edition]
        # 
        # *   Only one node can be deployed for an instance.
        self.instance_count = instance_count
        # The name of the MSE instance.
        self.instance_name = instance_name
        # Set this parameter unless otherwise specified. Valid values:
        # 
        # *   `mse_pro`: Professional Edition
        # *   `mse_dev`: Developer Edition
        self.mse_version = mse_version
        # The network type of the instance. Valid values:
        # 
        # *   `privatenet`: VPC
        # *   `pubnet`: Internet
        self.net_type = net_type
        # The specifications of the internal-facing SLB instance. Valid values:
        # 
        # *   `slb.s1.small`
        # *   `slb.s3.medium`
        self.private_slb_specification = private_slb_specification
        # The public bandwidth. Unit: Mbit/s.\
        # Valid values: 0 to 5000. The value 0 indicates no access to the Internet.
        self.pub_network_flow = pub_network_flow
        # The specifications of the Internet-facing Server Load Balancer (SLB) instance. Valid values:
        # 
        # *   `slb.s1.small`
        # *   `slb.s3.medium`
        self.pub_slb_specification = pub_slb_specification
        # The region where the MSE instance resides. Examples:
        # 
        # *   `cn-hangzhou`: China (Hangzhou)
        # *   `cn-beijing`: China (Beijing)
        # *   `cn-shanghai`: China (Shanghai)
        # *   `cn-zhangjiakou`: China (Zhangjiakou)
        # *   `cn-shenzhen`: China (Shenzhen)
        self.region = region
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars
        # The ID of the resource group. For more information about resource groups, see the topic "View basic information of a resource group."
        self.resource_group_id = resource_group_id
        # The list of the tags that you want to add.
        self.tag = tag
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id
        # The ID of the virtual private cloud (VPC).
        self.vpc_id = vpc_id

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_specification is not None:
            result['ClusterSpecification'] = self.cluster_specification
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.cluster_version is not None:
            result['ClusterVersion'] = self.cluster_version
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.mse_version is not None:
            result['MseVersion'] = self.mse_version
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.private_slb_specification is not None:
            result['PrivateSlbSpecification'] = self.private_slb_specification
        if self.pub_network_flow is not None:
            result['PubNetworkFlow'] = self.pub_network_flow
        if self.pub_slb_specification is not None:
            result['PubSlbSpecification'] = self.pub_slb_specification
        if self.region is not None:
            result['Region'] = self.region
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterSpecification') is not None:
            self.cluster_specification = m.get('ClusterSpecification')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('ClusterVersion') is not None:
            self.cluster_version = m.get('ClusterVersion')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('MseVersion') is not None:
            self.mse_version = m.get('MseVersion')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('PrivateSlbSpecification') is not None:
            self.private_slb_specification = m.get('PrivateSlbSpecification')
        if m.get('PubNetworkFlow') is not None:
            self.pub_network_flow = m.get('PubNetworkFlow')
        if m.get('PubSlbSpecification') is not None:
            self.pub_slb_specification = m.get('PubSlbSpecification')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateClusterRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateClusterResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        instance_id: str = None,
        message: str = None,
        order_id: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code returned if the request failed.
        self.error_code = error_code
        # The ID of the instance.
        self.instance_id = instance_id
        # The message returned.
        self.message = message
        # The ID of the order.
        self.order_id = order_id
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.message is not None:
            result['Message'] = self.message
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateClusterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEngineNamespaceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        desc: str = None,
        id: str = None,
        instance_id: str = None,
        name: str = None,
        service_count: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the cluster.
        self.cluster_id = cluster_id
        # The description of the namespace.
        self.desc = desc
        # The custom ID of the namespace. If you do not specify this parameter, the automatically generated Universally Unique Identifier (UUID) is returned.
        self.id = id
        # The ID of the instance.
        self.instance_id = instance_id
        # The display name of the namespace.
        self.name = name
        # The maximum number of services that can run in the namespace.
        self.service_count = service_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.service_count is not None:
            result['ServiceCount'] = self.service_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ServiceCount') is not None:
            self.service_count = m.get('ServiceCount')
        return self


class CreateEngineNamespaceResponseBodyData(TeaModel):
    def __init__(
        self,
        config_count: int = None,
        namespace: str = None,
        namespace_desc: str = None,
        namespace_show_name: str = None,
        quota: int = None,
        service_count: int = None,
        type: int = None,
    ):
        # The number of configurations.
        self.config_count = config_count
        # The ID of the namespace.
        self.namespace = namespace
        # The description of the namespace.
        self.namespace_desc = namespace_desc
        # The display name of the namespace.
        self.namespace_show_name = namespace_show_name
        # The quota of configurations.
        self.quota = quota
        # The number of active services.
        self.service_count = service_count
        # The type of the namespace. Valid values:
        # 
        # *   `0`: global configuration
        # *   `1`: default namespace
        # *   `2`: custom namespace
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_count is not None:
            result['ConfigCount'] = self.config_count
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_desc is not None:
            result['NamespaceDesc'] = self.namespace_desc
        if self.namespace_show_name is not None:
            result['NamespaceShowName'] = self.namespace_show_name
        if self.quota is not None:
            result['Quota'] = self.quota
        if self.service_count is not None:
            result['ServiceCount'] = self.service_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigCount') is not None:
            self.config_count = m.get('ConfigCount')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespaceDesc') is not None:
            self.namespace_desc = m.get('NamespaceDesc')
        if m.get('NamespaceShowName') is not None:
            self.namespace_show_name = m.get('NamespaceShowName')
        if m.get('Quota') is not None:
            self.quota = m.get('Quota')
        if m.get('ServiceCount') is not None:
            self.service_count = m.get('ServiceCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEngineNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        data: CreateEngineNamespaceResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The ID of the instance.
        self.cluster_id = cluster_id
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Data') is not None:
            temp_model = CreateEngineNamespaceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEngineNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEngineNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEngineNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMseServiceApplicationRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_name: str = None,
        extra_info: str = None,
        language: str = None,
        mse_version: str = None,
        region: str = None,
        sentinel_enable: str = None,
        source: str = None,
        switch_enable: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The name of the application.
        self.app_name = app_name
        # The additional information.
        self.extra_info = extra_info
        # The programming language of the application.
        self.language = language
        # The edition of the MSE instance that you want to purchase.
        # 
        # *   mse_pro: Professional Edition
        # *   mse_dev: Developer Edition
        self.mse_version = mse_version
        # The ID of the region where the Microservices Engine (MSE) instance resides. Examples:
        # 
        # *   cn-hangzhou: China (Hangzhou)
        # *   cn-beijing: China (Beijing)
        # *   cn-shanghai: China (Shanghai)
        # *   cn-zhangjiakou: China (Zhangjiakou)
        # *   cn-shenzhen: China (Shenzhen)
        self.region = region
        # Specifies whether to enable the Sentinel-compatible mode.
        self.sentinel_enable = sentinel_enable
        # The service source.
        self.source = source
        # Specifies whether to enable switching.
        self.switch_enable = switch_enable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.language is not None:
            result['Language'] = self.language
        if self.mse_version is not None:
            result['MseVersion'] = self.mse_version
        if self.region is not None:
            result['Region'] = self.region
        if self.sentinel_enable is not None:
            result['SentinelEnable'] = self.sentinel_enable
        if self.source is not None:
            result['Source'] = self.source
        if self.switch_enable is not None:
            result['SwitchEnable'] = self.switch_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('MseVersion') is not None:
            self.mse_version = m.get('MseVersion')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SentinelEnable') is not None:
            self.sentinel_enable = m.get('SentinelEnable')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SwitchEnable') is not None:
            self.switch_enable = m.get('SwitchEnable')
        return self


class CreateMseServiceApplicationResponseBodyData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_name: str = None,
        create_time: int = None,
        extra_info: str = None,
        language: str = None,
        license_key: str = None,
        region_id: str = None,
        source: str = None,
        status: int = None,
        update_time: int = None,
        user_id: str = None,
        version: str = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # The name of the application.
        self.app_name = app_name
        # The creation time.
        self.create_time = create_time
        # The additional information.
        self.extra_info = extra_info
        # The programming language of the application.
        self.language = language
        # The license key in use.
        self.license_key = license_key
        # The region ID.
        self.region_id = region_id
        # The source type.
        self.source = source
        # The status.
        self.status = status
        # The last modification time.
        self.update_time = update_time
        # The ID of the user.
        self.user_id = user_id
        # The version information.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.language is not None:
            result['Language'] = self.language
        if self.license_key is not None:
            result['LicenseKey'] = self.license_key
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('LicenseKey') is not None:
            self.license_key = m.get('LicenseKey')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class CreateMseServiceApplicationResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: CreateMseServiceApplicationResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The status code returned.
        self.code = code
        # The data structure.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateMseServiceApplicationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMseServiceApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMseServiceApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMseServiceApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNacosConfigRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_name: str = None,
        beta_ips: str = None,
        content: str = None,
        data_id: str = None,
        desc: str = None,
        group: str = None,
        instance_id: str = None,
        namespace_id: str = None,
        tags: str = None,
        type: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The name of the application.
        self.app_name = app_name
        # The list of IP addresses where the beta release of the configuration is performed.
        self.beta_ips = beta_ips
        # The content of the configuration.
        self.content = content
        # The ID of the data.
        self.data_id = data_id
        # The description of the configuration.
        self.desc = desc
        # The ID of the group.
        self.group = group
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The tags of the configuration.
        self.tags = tags
        # The format of the configuration. Supported formats include TEXT, JSON, and XML.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.beta_ips is not None:
            result['BetaIps'] = self.beta_ips
        if self.content is not None:
            result['Content'] = self.content
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.group is not None:
            result['Group'] = self.group
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BetaIps') is not None:
            self.beta_ips = m.get('BetaIps')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateNacosConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The code returned.
        self.code = code
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateNacosConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNacosConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNacosConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNacosInstanceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_name: str = None,
        enabled: bool = None,
        ephemeral: bool = None,
        group_name: str = None,
        instance_id: str = None,
        ip: str = None,
        metadata: str = None,
        namespace_id: str = None,
        port: int = None,
        service_name: str = None,
        weight: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The name of the Nacos instance.
        self.cluster_name = cluster_name
        # Specifies whether to enable the service for the instance.
        self.enabled = enabled
        # Specifies whether to mark the instance as a temporary node.
        self.ephemeral = ephemeral
        # The name of the group.
        self.group_name = group_name
        # The ID of the instance.
        self.instance_id = instance_id
        # The IP address of the Nacos instance.
        self.ip = ip
        # The metadata of the instance.
        self.metadata = metadata
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The port of the Nacos instance.
        self.port = port
        # The name of the service.
        self.service_name = service_name
        # The weight. Valid values: 0 to 10000. The value must be an integer. A larger value indicates a higher frequency at which the instance is accessed.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.ephemeral is not None:
            result['Ephemeral'] = self.ephemeral
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.port is not None:
            result['Port'] = self.port
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('Ephemeral') is not None:
            self.ephemeral = m.get('Ephemeral')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class CreateNacosInstanceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The result returned.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateNacosInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNacosInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNacosInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNacosServiceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        ephemeral: bool = None,
        group_name: str = None,
        instance_id: str = None,
        namespace_id: str = None,
        protect_threshold: str = None,
        service_name: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the instance.
        # 
        # > This operation contains both the InstanceId and ClusterId parameters. You must specify one of them.
        self.cluster_id = cluster_id
        # Specifies whether the instance is marked as a temporary node. Valid values:
        # 
        # *   `true`: yes
        # *   `false`: no
        self.ephemeral = ephemeral
        # The name of the group.
        self.group_name = group_name
        # The ID of the instance.
        # 
        # > This operation contains both the InstanceId and ClusterId parameters. You must specify one of them.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The protection threshold.
        self.protect_threshold = protect_threshold
        # The name of the service.
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.ephemeral is not None:
            result['Ephemeral'] = self.ephemeral
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.protect_threshold is not None:
            result['ProtectThreshold'] = self.protect_threshold
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Ephemeral') is not None:
            self.ephemeral = m.get('Ephemeral')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('ProtectThreshold') is not None:
            self.protect_threshold = m.get('ProtectThreshold')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class CreateNacosServiceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The data of the node.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateNacosServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNacosServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNacosServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateSwimmingLaneRequestEntryRulesRestItems(TeaModel):
    def __init__(
        self,
        cond: str = None,
        datum: str = None,
        divisor: int = None,
        name: str = None,
        name_list: List[str] = None,
        operator: str = None,
        rate: int = None,
        remainder: int = None,
        type: str = None,
        value: str = None,
    ):
        # The expression. =, >, <, >=, <=\
        self.cond = cond
        # The base value used for the rawvalue operator.
        self.datum = datum
        # The divisor used for the mod operator.
        self.divisor = divisor
        # The name of the rule. This parameter corresponds to the key of the type parameter.
        self.name = name
        # The list of names.
        self.name_list = name_list
        # The operator type. Valid values: mod, list, rawvalue, and rate.
        self.operator = operator
        # The rate.
        self.rate = rate
        # The remainder used for the mod operator.
        self.remainder = remainder
        # The type of the rule. Valid values: cookie, param, and header.
        self.type = type
        # The content of the rule.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cond is not None:
            result['Cond'] = self.cond
        if self.datum is not None:
            result['Datum'] = self.datum
        if self.divisor is not None:
            result['Divisor'] = self.divisor
        if self.name is not None:
            result['Name'] = self.name
        if self.name_list is not None:
            result['NameList'] = self.name_list
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.remainder is not None:
            result['Remainder'] = self.remainder
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cond') is not None:
            self.cond = m.get('Cond')
        if m.get('Datum') is not None:
            self.datum = m.get('Datum')
        if m.get('Divisor') is not None:
            self.divisor = m.get('Divisor')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NameList') is not None:
            self.name_list = m.get('NameList')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Remainder') is not None:
            self.remainder = m.get('Remainder')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOrUpdateSwimmingLaneRequestEntryRules(TeaModel):
    def __init__(
        self,
        condition: str = None,
        enable: bool = None,
        path: str = None,
        paths: List[str] = None,
        priority: int = None,
        rest_items: List[CreateOrUpdateSwimmingLaneRequestEntryRulesRestItems] = None,
    ):
        # The common parameters in the JSON format.
        self.condition = condition
        # Specifies whether to enable the rule. Valid values:
        # 
        # *   `true`: enables the rule.
        # *   `false`: disables the rule.
        self.enable = enable
        # The path.
        self.path = path
        # The list of paths.
        self.paths = paths
        # The priority. A smaller value of this parameter indicates a higher priority.
        self.priority = priority
        # The information about the rule for the REST method.
        self.rest_items = rest_items

    def validate(self):
        if self.rest_items:
            for k in self.rest_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition is not None:
            result['Condition'] = self.condition
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.path is not None:
            result['Path'] = self.path
        if self.paths is not None:
            result['Paths'] = self.paths
        if self.priority is not None:
            result['Priority'] = self.priority
        result['RestItems'] = []
        if self.rest_items is not None:
            for k in self.rest_items:
                result['RestItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Condition') is not None:
            self.condition = m.get('Condition')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Paths') is not None:
            self.paths = m.get('Paths')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        self.rest_items = []
        if m.get('RestItems') is not None:
            for k in m.get('RestItems'):
                temp_model = CreateOrUpdateSwimmingLaneRequestEntryRulesRestItems()
                self.rest_items.append(temp_model.from_map(k))
        return self


class CreateOrUpdateSwimmingLaneRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        enable: bool = None,
        enable_rules: bool = None,
        entry_rule: str = None,
        entry_rules: List[CreateOrUpdateSwimmingLaneRequestEntryRules] = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        group_id: int = None,
        id: int = None,
        license_key: str = None,
        name: str = None,
        region_id: str = None,
        source: str = None,
        status: int = None,
        tag: str = None,
        user_id: str = None,
    ):
        # The language that the value of the **LocalName** response parameter uses. Valid values:
        # 
        # *   **zh-cn**: Chinese
        # *   **en-us**: English.
        # 
        # > Default value: **zh-CN**.
        self.accept_language = accept_language
        # Specifies whether to enable a lane.
        self.enable = enable
        # Specifies whether to set a routing rule for the lane. If an Ingress gateway is used, this parameter is not required.
        self.enable_rules = enable_rules
        # The JSON string.
        self.entry_rule = entry_rule
        # The lane.
        self.entry_rules = entry_rules
        # Optional. The time when the lane was created.
        self.gmt_create = gmt_create
        # Optional. The time when the lane was last modified.
        self.gmt_modified = gmt_modified
        # The group to which the lane belongs.
        self.group_id = group_id
        # The ID of the primary key. A value -1 specifies a request that is used to create a lane. A value greater than 0 specifies a request that is used to modify a lane.
        self.id = id
        # The license key in use.
        self.license_key = license_key
        # The name of the lane.
        self.name = name
        # The ID of the region.
        self.region_id = region_id
        # The service source. Valid value: edasmsc.
        self.source = source
        # The value 0 indicates that the lane is disabled.
        self.status = status
        # The tag.
        self.tag = tag
        # The Alibaba Cloud account. The format is a number, such as 136246975637\*\*\*\*. You can leave this parameter empty.
        self.user_id = user_id

    def validate(self):
        if self.entry_rules:
            for k in self.entry_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.enable_rules is not None:
            result['EnableRules'] = self.enable_rules
        if self.entry_rule is not None:
            result['EntryRule'] = self.entry_rule
        result['EntryRules'] = []
        if self.entry_rules is not None:
            for k in self.entry_rules:
                result['EntryRules'].append(k.to_map() if k else None)
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.license_key is not None:
            result['LicenseKey'] = self.license_key
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('EnableRules') is not None:
            self.enable_rules = m.get('EnableRules')
        if m.get('EntryRule') is not None:
            self.entry_rule = m.get('EntryRule')
        self.entry_rules = []
        if m.get('EntryRules') is not None:
            for k in m.get('EntryRules'):
                temp_model = CreateOrUpdateSwimmingLaneRequestEntryRules()
                self.entry_rules.append(temp_model.from_map(k))
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LicenseKey') is not None:
            self.license_key = m.get('LicenseKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CreateOrUpdateSwimmingLaneResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: Any = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code. The value 200 is returned if the request is successful.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOrUpdateSwimmingLaneResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrUpdateSwimmingLaneResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateSwimmingLaneResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateSwimmingLaneGroupRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_ids: str = None,
        db_gray_enable: bool = None,
        enable: bool = None,
        entry_app: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        license_key: str = None,
        message_queue_filter_side: str = None,
        message_queue_gray_enable: bool = None,
        name: str = None,
        namespace: str = None,
        region: str = None,
        source: str = None,
        status: int = None,
        user_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The IDs of applications. Separate application IDs with commas (,).
        self.app_ids = app_ids
        # Specifies whether to enable database canary release.
        self.db_gray_enable = db_gray_enable
        # Specifies whether to enable a lane group.
        self.enable = enable
        # The ingress application.
        self.entry_app = entry_app
        # The creation time.
        self.gmt_create = gmt_create
        # The update time.
        self.gmt_modified = gmt_modified
        # The ID of the primary key. The primary key is auto-increment.
        self.id = id
        # The license key in use.
        self.license_key = license_key
        # The side for message filtering when the canary release for messaging feature is enabled.
        self.message_queue_filter_side = message_queue_filter_side
        # Specifies whether to enable canary release for messaging.
        self.message_queue_gray_enable = message_queue_gray_enable
        # The name.
        self.name = name
        self.namespace = namespace
        # The region ID.
        self.region = region
        # The service source. Valid value: edasmsc.
        self.source = source
        # The status of the lane group. The value 0 specifies that the lane group is disabled. The value 1 specifies that the lane group is enabled.
        self.status = status
        # The Alibaba Cloud account. The value is a number, such as 136246\*\*\*\*\*\*809. You can leave this parameter empty.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_ids is not None:
            result['AppIds'] = self.app_ids
        if self.db_gray_enable is not None:
            result['DbGrayEnable'] = self.db_gray_enable
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.entry_app is not None:
            result['EntryApp'] = self.entry_app
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.license_key is not None:
            result['LicenseKey'] = self.license_key
        if self.message_queue_filter_side is not None:
            result['MessageQueueFilterSide'] = self.message_queue_filter_side
        if self.message_queue_gray_enable is not None:
            result['MessageQueueGrayEnable'] = self.message_queue_gray_enable
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region is not None:
            result['Region'] = self.region
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppIds') is not None:
            self.app_ids = m.get('AppIds')
        if m.get('DbGrayEnable') is not None:
            self.db_gray_enable = m.get('DbGrayEnable')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('EntryApp') is not None:
            self.entry_app = m.get('EntryApp')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LicenseKey') is not None:
            self.license_key = m.get('LicenseKey')
        if m.get('MessageQueueFilterSide') is not None:
            self.message_queue_filter_side = m.get('MessageQueueFilterSide')
        if m.get('MessageQueueGrayEnable') is not None:
            self.message_queue_gray_enable = m.get('MessageQueueGrayEnable')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CreateOrUpdateSwimmingLaneGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: Any = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code. The value 200 is returned if the request is successful.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # true: The request was successful. false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOrUpdateSwimmingLaneGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrUpdateSwimmingLaneGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateSwimmingLaneGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateZnodeRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        data: str = None,
        path: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the instance.
        self.cluster_id = cluster_id
        # The data of the node.
        self.data = data
        # The path of the node.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.data is not None:
            result['Data'] = self.data
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class CreateZnodeResponseBodyData(TeaModel):
    def __init__(
        self,
        data: str = None,
        dir: bool = None,
        name: str = None,
        path: str = None,
    ):
        # The data of the node.
        self.data = data
        # Indicates whether the node information was returned. Valid values:
        # 
        # *   `true`: The node information was returned.
        # *   `false`: The node information failed to be returned.
        self.dir = dir
        # The name of the node.
        self.name = name
        # The path of the node.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.dir is not None:
            result['Dir'] = self.dir
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Dir') is not None:
            self.dir = m.get('Dir')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class CreateZnodeResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateZnodeResponseBodyData = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateZnodeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateZnodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateZnodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateZnodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAuthResourceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        id: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The destination ID.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteAuthResourceResponseBodyData(TeaModel):
    def __init__(
        self,
        auth_id: int = None,
        domain_id: int = None,
        domain_name: str = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        is_white: bool = None,
        path: str = None,
    ):
        # The authentication ID.
        self.auth_id = auth_id
        # The ID of the domain name.
        self.domain_id = domain_id
        # The domain name.
        self.domain_name = domain_name
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The creation time.
        self.gmt_create = gmt_create
        # The modification time.
        self.gmt_modified = gmt_modified
        # The ID of the primary key.
        self.id = id
        # Indicates whether the whitelist mode is enabled.
        self.is_white = is_white
        # The path.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_id is not None:
            result['AuthId'] = self.auth_id
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.is_white is not None:
            result['IsWhite'] = self.is_white
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthId') is not None:
            self.auth_id = m.get('AuthId')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsWhite') is not None:
            self.is_white = m.get('IsWhite')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class DeleteAuthResourceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DeleteAuthResourceResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteAuthResourceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAuthResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAuthResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAuthResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClusterRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        instance_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the instance.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteClusterResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteClusterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEngineNamespaceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the cluster.
        self.cluster_id = cluster_id
        # The ID of the namespace.
        self.id = id
        # The ID of the instance.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteEngineNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEngineNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEngineNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEngineNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGatewayRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        delete_slb: bool = None,
        gateway_unique_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # - zh: Chinese
        # - en: English
        self.accept_language = accept_language
        # Specifies whether to delete the Server Load Balancer (SLB) instance purchased for the gateway.
        self.delete_slb = delete_slb
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.delete_slb is not None:
            result['DeleteSlb'] = self.delete_slb
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DeleteSlb') is not None:
            self.delete_slb = m.get('DeleteSlb')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        return self


class DeleteGatewayResponseBodyData(TeaModel):
    def __init__(
        self,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        name: str = None,
        primary_user: str = None,
        region: str = None,
        replica: int = None,
        security_group: str = None,
        spec: str = None,
        status: int = None,
        vpc: str = None,
        vswitch: str = None,
    ):
        # The unique ID of the gateway. It is an identifier automatically generated by the system.
        self.gateway_unique_id = gateway_unique_id
        # The time when the gateway was created.
        self.gmt_create = gmt_create
        # The time when the gateway was modified.
        self.gmt_modified = gmt_modified
        # The ID of the primary key.
        self.id = id
        # The name of the gateway.
        self.name = name
        # The information about the user.
        self.primary_user = primary_user
        # The ID of the region.
        self.region = region
        # The number of gateway replicas.
        self.replica = replica
        # The ID of the security group.
        self.security_group = security_group
        # The instance type of the gateway.
        self.spec = spec
        # The status of the gateway. Valid values:
        # 
        # - 0: The gateway is being created.
        # - 1: The gateway fails to be created.
        # - 2: The gateway is running.
        # - 3: The gateway is changing.
        # - 4: The gateway is scaling down.
        # - 6: The gateway is scaling up.
        # - 8: The gateway is being deleted.
        # - 10: The gateway is restarting.
        # - 11: The gateway is being recreated.
        # - 12: The gateway is updating.
        # - 13: The gateway fails to be updated.
        self.status = status
        # The ID of the virtual private cloud (VPC) where the gateway resides.
        self.vpc = vpc
        # The ID of the vSwitch.
        self.vswitch = vswitch

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.primary_user is not None:
            result['PrimaryUser'] = self.primary_user
        if self.region is not None:
            result['Region'] = self.region
        if self.replica is not None:
            result['Replica'] = self.replica
        if self.security_group is not None:
            result['SecurityGroup'] = self.security_group
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc is not None:
            result['Vpc'] = self.vpc
        if self.vswitch is not None:
            result['Vswitch'] = self.vswitch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PrimaryUser') is not None:
            self.primary_user = m.get('PrimaryUser')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Replica') is not None:
            self.replica = m.get('Replica')
        if m.get('SecurityGroup') is not None:
            self.security_group = m.get('SecurityGroup')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Vpc') is not None:
            self.vpc = m.get('Vpc')
        if m.get('Vswitch') is not None:
            self.vswitch = m.get('Vswitch')
        return self


class DeleteGatewayResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DeleteGatewayResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. A value of 200 indicates that the request is successful. Other values indicate that the request fails.
        self.code = code
        # The details of the data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The request is processed successfully.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # - `true`: The request is successful.
        # - `false`: The request fails.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteGatewayResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGatewayResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGatewayDomainRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The domain ID.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteGatewayDomainResponseBodyData(TeaModel):
    def __init__(
        self,
        cert_identifier: str = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        must_https: bool = None,
        name: str = None,
        protocol: str = None,
    ):
        # The ID of the certificate.
        self.cert_identifier = cert_identifier
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The time when the domain name was added.
        self.gmt_create = gmt_create
        # The last modification time.
        self.gmt_modified = gmt_modified
        # The domain ID.
        self.id = id
        # Indicates whether HTTP probing is allowed.
        self.must_https = must_https
        # The name.
        self.name = name
        # The protocol.
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_identifier is not None:
            result['CertIdentifier'] = self.cert_identifier
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.must_https is not None:
            result['MustHttps'] = self.must_https
        if self.name is not None:
            result['Name'] = self.name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CertIdentifier') is not None:
            self.cert_identifier = m.get('CertIdentifier')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MustHttps') is not None:
            self.must_https = m.get('MustHttps')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class DeleteGatewayDomainResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DeleteGatewayDomainResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteGatewayDomainResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteGatewayDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGatewayDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGatewayDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGatewayRouteRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        route_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the route.
        self.route_id = route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class DeleteGatewayRouteResponseBodyData(TeaModel):
    def __init__(
        self,
        default_service_id: int = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        name: str = None,
        predicates: str = None,
        route_order: int = None,
        status: int = None,
    ):
        # The default service ID.
        self.default_service_id = default_service_id
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The creation time.
        self.gmt_create = gmt_create
        # The modification time.
        self.gmt_modified = gmt_modified
        # The ID.
        self.id = id
        # The name.
        self.name = name
        # The matching rules.
        self.predicates = predicates
        # The sequence number of the route.
        self.route_order = route_order
        # The status.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_service_id is not None:
            result['DefaultServiceId'] = self.default_service_id
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.predicates is not None:
            result['Predicates'] = self.predicates
        if self.route_order is not None:
            result['RouteOrder'] = self.route_order
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultServiceId') is not None:
            self.default_service_id = m.get('DefaultServiceId')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Predicates') is not None:
            self.predicates = m.get('Predicates')
        if m.get('RouteOrder') is not None:
            self.route_order = m.get('RouteOrder')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteGatewayRouteResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DeleteGatewayRouteResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteGatewayRouteResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteGatewayRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGatewayRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGatewayRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGatewayServiceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        service_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the service.
        self.service_id = service_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        return self


class DeleteGatewayServiceResponseBodyData(TeaModel):
    def __init__(
        self,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        group_name: str = None,
        id: int = None,
        ips: List[str] = None,
        meta_info: str = None,
        name: str = None,
        namespace: str = None,
        service_name_in_registry: str = None,
        source_id: int = None,
        source_type: str = None,
    ):
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The time when the service was created.
        self.gmt_create = gmt_create
        # The last modification time.
        self.gmt_modified = gmt_modified
        # The name of the group.
        self.group_name = group_name
        # The ID of the service.
        self.id = id
        # IP
        self.ips = ips
        # The basic information about the service.
        self.meta_info = meta_info
        # The name of the service.
        self.name = name
        # The namespace.
        self.namespace = namespace
        # The name of the service registered with the service registry.
        self.service_name_in_registry = service_name_in_registry
        # The ID of the service source.
        self.source_id = source_id
        # The source type of the service.
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.ips is not None:
            result['Ips'] = self.ips
        if self.meta_info is not None:
            result['MetaInfo'] = self.meta_info
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.service_name_in_registry is not None:
            result['ServiceNameInRegistry'] = self.service_name_in_registry
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Ips') is not None:
            self.ips = m.get('Ips')
        if m.get('MetaInfo') is not None:
            self.meta_info = m.get('MetaInfo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('ServiceNameInRegistry') is not None:
            self.service_name_in_registry = m.get('ServiceNameInRegistry')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class DeleteGatewayServiceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DeleteGatewayServiceResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The unique ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteGatewayServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteGatewayServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGatewayServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGatewayServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGatewayServiceVersionRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        service_id: int = None,
        service_version: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the service.
        self.service_id = service_id
        # The version of the service.
        self.service_version = service_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        return self


class DeleteGatewayServiceVersionResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        # 
        # *   If the request is successful, a success message is returned.
        # *   If the request fails, an error message is returned, such as the "TaskId not found" message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteGatewayServiceVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGatewayServiceVersionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGatewayServiceVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGatewaySlbRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        delete_slb: bool = None,
        gateway_unique_id: str = None,
        id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # Specifies whether to delete the SLB instance purchased for the gateway when you delete the gateway.
        self.delete_slb = delete_slb
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the associated record.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.delete_slb is not None:
            result['DeleteSlb'] = self.delete_slb
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DeleteSlb') is not None:
            self.delete_slb = m.get('DeleteSlb')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteGatewaySlbResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The deletion result.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        # 
        # *   If the request is successful, a success message is returned.
        # *   If the request fails, an error message is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteGatewaySlbResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGatewaySlbResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGatewaySlbResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMigrationTaskRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        id: str = None,
        request_pars: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the task.
        self.id = id
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.id is not None:
            result['Id'] = self.id
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        return self


class DeleteMigrationTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The deletion result.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMigrationTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMigrationTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMigrationTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNacosConfigRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        beta: bool = None,
        data_id: str = None,
        group: str = None,
        instance_id: str = None,
        namespace_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # Specifies whether to perform a beta release. Valid values:
        # 
        # *   `true`: performs a beta release.
        # *   `false`: not performs a beta release.
        self.beta = beta
        # The ID of the configuration.
        self.data_id = data_id
        # The type of the group.
        self.group = group
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.beta is not None:
            result['Beta'] = self.beta
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.group is not None:
            result['Group'] = self.group
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Beta') is not None:
            self.beta = m.get('Beta')
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class DeleteNacosConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteNacosConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNacosConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNacosConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNacosConfigsRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        ids: str = None,
        instance_id: str = None,
        namespace_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The IDs of configurations.
        self.ids = ids
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class DeleteNacosConfigsResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteNacosConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNacosConfigsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNacosConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNacosInstanceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_name: str = None,
        ephemeral: bool = None,
        group_name: str = None,
        instance_id: str = None,
        ip: str = None,
        namespace_id: str = None,
        port: int = None,
        service_name: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The alias of the instance.
        self.cluster_name = cluster_name
        # Specifies whether the instance is marked as a temporary node. Valid values:
        # 
        # *   `true`: monitors the task status.
        # *   `false`: no
        self.ephemeral = ephemeral
        # The name of the group.
        self.group_name = group_name
        # The ID of the instance.
        self.instance_id = instance_id
        # The IP address of the Nacos instance.
        self.ip = ip
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The port of the Nacos instance.
        self.port = port
        # The name of the service.
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.ephemeral is not None:
            result['Ephemeral'] = self.ephemeral
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.port is not None:
            result['Port'] = self.port
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Ephemeral') is not None:
            self.ephemeral = m.get('Ephemeral')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DeleteNacosInstanceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: str = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code. The value 200 is returned if the request is successful.
        self.code = code
        # The data of the node.
        self.data = data
        # The dynamic part in the error message.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteNacosInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNacosInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNacosInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNacosServiceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        group_name: str = None,
        instance_id: str = None,
        namespace_id: str = None,
        service_name: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The name of the group.
        self.group_name = group_name
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The name of the service.
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DeleteNacosServiceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The deletion result.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteNacosServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNacosServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNacosServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityGroupRuleRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        id: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The destination ID.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteSecurityGroupRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        description: str = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        ip_protocol: str = None,
        port_range: str = None,
        security_group_id: str = None,
    ):
        # The description.
        self.description = description
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The creation time.
        self.gmt_create = gmt_create
        # The modification time.
        self.gmt_modified = gmt_modified
        # The ID.
        self.id = id
        # The transport layer protocol. The value of this parameter is case-insensitive. Valid values:
        # 
        # *   icmp
        # *   gre
        # *   tcp
        # *   udp
        # *   all: All protocols are supported.
        self.ip_protocol = ip_protocol
        # The range of ports for the transport layer protocol in the destination security group. Valid values:
        # 
        # *   When the IpProtocol parameter is set to tcp or udp, the port number range is 1 to 65535. The start port number and the end port number are separated by a forward slash (/). Example: 1/200.
        # *   If the IpProtocol parameter is set to icmp, the port number range is -1/-1, which indicates all ports.
        # *   If the IpProtocol parameter is set to gre, the port number range is -1/-1, which indicates all ports.
        # *   If the IpProtocol parameter is set to all, the port number range is -1/-1, which indicates all ports.
        self.port_range = port_range
        # The ID of the security group.
        self.security_group_id = security_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class DeleteSecurityGroupRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DeleteSecurityGroupRuleResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteSecurityGroupRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSecurityGroupRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSecurityGroupRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecurityGroupRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteServiceSourceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        source_id: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the data source.
        self.source_id = source_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        return self


class DeleteServiceSourceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteServiceSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteServiceSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteServiceSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSwimmingLaneRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        lane_id: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the lane.
        self.lane_id = lane_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.lane_id is not None:
            result['LaneId'] = self.lane_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('LaneId') is not None:
            self.lane_id = m.get('LaneId')
        return self


class DeleteSwimmingLaneResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: Any = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code. A value of 200 is returned if the request is successful.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSwimmingLaneResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSwimmingLaneResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSwimmingLaneResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSwimmingLaneGroupRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        group_id: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the lane group.
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteSwimmingLaneGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: Any = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code. A value of 200 is returned if the request is successful.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSwimmingLaneGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSwimmingLaneGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSwimmingLaneGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteZnodeRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        path: str = None,
        request_pars: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the instance.
        self.cluster_id = cluster_id
        # The path of the node.
        self.path = path
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.path is not None:
            result['Path'] = self.path
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        return self


class DeleteZnodeResponseBodyData(TeaModel):
    def __init__(
        self,
        data: str = None,
        dir: bool = None,
        name: str = None,
        path: str = None,
    ):
        # The data of the node.
        self.data = data
        # Indicates whether the node information was returned. Valid values:
        # 
        # *   `true`: The node information was returned.
        # *   `false`: The node information failed to be returned.
        self.dir = dir
        # The name of the node.
        self.name = name
        # The path of the node.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.dir is not None:
            result['Dir'] = self.dir
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Dir') is not None:
            self.dir = m.get('Dir')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class DeleteZnodeResponseBody(TeaModel):
    def __init__(
        self,
        data: DeleteZnodeResponseBodyData = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeleteZnodeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteZnodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteZnodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteZnodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportNacosConfigRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_name: str = None,
        data_id: str = None,
        group: str = None,
        ids: str = None,
        instance_id: str = None,
        namespace_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The tag of the application.
        self.app_name = app_name
        # The ID of the data that you want to export.
        # 
        # > :
        # 
        # *   Multiple export methods are supported.
        # *   If you want to export a single configuration, you must leave the Ids parameter empty and specify the DataID and Group parameters.
        self.data_id = data_id
        # The name of the configuration group.
        self.group = group
        # The ID of the primary key of a configuration item.
        # 
        # > : - Multiple export methods are supported. You must specify this parameter if you want to export multiple configurations. - You can obtain the value of this parameter by calling the ListNacosConfigs operation. - If you specify this parameter, multiple configurations are exported. The DataId and Group parameters are invalid.
        self.ids = ids
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.group is not None:
            result['Group'] = self.group
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class ExportNacosConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        url: str = None,
    ):
        # The URL used to download the exported configurations.
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ExportNacosConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ExportNacosConfigResponseBodyData = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message. This parameter is used to replace the \*\*%s\*\* variable in the **ErrMessage** parameter.
        # 
        # > If the return value of the **ErrMessage** parameter is **The Value of Input Parameter %s is not valid** and the return value of the **DynamicMessage** parameter is **DtsJobId**, the specified **DtsJobId** parameter is invalid.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ExportNacosConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ExportNacosConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportNacosConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportNacosConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAppMessageQueueRouteRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_id: str = None,
        region: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the application.
        self.app_id = app_id
        # The region where the instance resides. Examples:
        # 
        # *   `cn-hangzhou`: China (Hangzhou)
        # *   `cn-beijing`: China (Beijing)
        # *   `cn-shanghai`: China (Shanghai)
        # *   `cn-zhangjiakou`: China (Zhangjiakou)
        # *   `cn-shenzhen`: China (Shenzhen)
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class GetAppMessageQueueRouteResponseBodyData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        enable: bool = None,
        filter_side: str = None,
        region: str = None,
        tags: List[str] = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # Indicates whether the canary release for messaging feature is enabled.
        # 
        # *   `true`: enabled
        # *   `false`: disabled
        self.enable = enable
        # The side for message filtering when the canary release for messaging feature is enabled.
        self.filter_side = filter_side
        # The region ID.
        self.region = region
        # The tags used to ignore message consumption for nodes in untagged environments.
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.filter_side is not None:
            result['FilterSide'] = self.filter_side
        if self.region is not None:
            result['Region'] = self.region
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('FilterSide') is not None:
            self.filter_side = m.get('FilterSide')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class GetAppMessageQueueRouteResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetAppMessageQueueRouteResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        # 
        # *   If the request is successful, a success message is returned.
        # *   If the request fails, an error message is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values: true and false. The value true indicates that the request was successful. The value false indicates that the request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAppMessageQueueRouteResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAppMessageQueueRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAppMessageQueueRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAppMessageQueueRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApplicationListRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_id: str = None,
        app_name: str = None,
        language: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        region: str = None,
        sentinel_enable: bool = None,
        source: str = None,
        switch_enable: bool = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the application.
        self.app_id = app_id
        # The name of the application.
        self.app_name = app_name
        # The programming language of the application, such as Java and Go.
        self.language = language
        self.namespace = namespace
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The region ID.
        self.region = region
        # Specifies whether to enable the Sentinel-compatible mode.
        self.sentinel_enable = sentinel_enable
        # The source of the application. The value is fixed as edasmsc.
        self.source = source
        # Specifies whether to enable switching.
        self.switch_enable = switch_enable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.language is not None:
            result['Language'] = self.language
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region is not None:
            result['Region'] = self.region
        if self.sentinel_enable is not None:
            result['SentinelEnable'] = self.sentinel_enable
        if self.source is not None:
            result['Source'] = self.source
        if self.switch_enable is not None:
            result['SwitchEnable'] = self.switch_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SentinelEnable') is not None:
            self.sentinel_enable = m.get('SentinelEnable')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SwitchEnable') is not None:
            self.switch_enable = m.get('SwitchEnable')
        return self


class GetApplicationListResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_name: str = None,
        extra_info: str = None,
        instances_number: int = None,
        language: str = None,
        license_key: str = None,
        namespace: str = None,
        region_id: str = None,
        source: str = None,
        status: int = None,
        user_id: str = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # The name of the application.
        self.app_name = app_name
        # The additional information.
        self.extra_info = extra_info
        # The number of instances.
        self.instances_number = instances_number
        # The programming language of the application.
        self.language = language
        # The license key in use.
        self.license_key = license_key
        self.namespace = namespace
        # The ID of the region.
        self.region_id = region_id
        # The source of the application.
        self.source = source
        # The status.
        self.status = status
        # The ID of the user.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.instances_number is not None:
            result['InstancesNumber'] = self.instances_number
        if self.language is not None:
            result['Language'] = self.language
        if self.license_key is not None:
            result['LicenseKey'] = self.license_key
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('InstancesNumber') is not None:
            self.instances_number = m.get('InstancesNumber')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('LicenseKey') is not None:
            self.license_key = m.get('LicenseKey')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetApplicationListResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        result: List[GetApplicationListResponseBodyDataResult] = None,
        total_size: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The returned information.
        self.result = result
        # The total number of entries returned.
        self.total_size = total_size

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = GetApplicationListResponseBodyDataResult()
                self.result.append(temp_model.from_map(k))
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class GetApplicationListResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetApplicationListResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data structure.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetApplicationListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetApplicationListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetApplicationListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetApplicationListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApplicationListWithMetircsRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_id: str = None,
        app_name: str = None,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        region: str = None,
        source: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the application.
        self.app_id = app_id
        # The name of the application.
        self.app_name = app_name
        self.namespace = namespace
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page. Default value: 10.
        self.page_size = page_size
        # The ID of the region where the instance resides. Examples:
        # 
        # *   cn-hangzhou: China (Hangzhou)
        # *   cn-beijing: China (Beijing)
        # *   cn-shanghai: China (Shanghai)
        # *   cn-zhangjiakou: China (Zhangjiakou)
        # *   cn-shenzhen: China (Shenzhen)
        self.region = region
        # The service source. Valid values:
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region is not None:
            result['Region'] = self.region
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class GetApplicationListWithMetircsResponseBodyDataResultCurMetrics(TeaModel):
    def __init__(
        self,
        block_qps: float = None,
        exp_qps: float = None,
        pass_qps: float = None,
        qps: float = None,
        rt: float = None,
        thread: float = None,
        timestamp: int = None,
    ):
        # The number of blocked QPS.
        self.block_qps = block_qps
        # The number of abnormal QPS.
        self.exp_qps = exp_qps
        # The number of passed QPS.
        self.pass_qps = pass_qps
        # The number of queries per second (QPS).
        self.qps = qps
        # The response time (RT).
        self.rt = rt
        # The number of threads.
        self.thread = thread
        # The timestamp.
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_qps is not None:
            result['BlockQps'] = self.block_qps
        if self.exp_qps is not None:
            result['ExpQps'] = self.exp_qps
        if self.pass_qps is not None:
            result['PassQps'] = self.pass_qps
        if self.qps is not None:
            result['Qps'] = self.qps
        if self.rt is not None:
            result['Rt'] = self.rt
        if self.thread is not None:
            result['Thread'] = self.thread
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockQps') is not None:
            self.block_qps = m.get('BlockQps')
        if m.get('ExpQps') is not None:
            self.exp_qps = m.get('ExpQps')
        if m.get('PassQps') is not None:
            self.pass_qps = m.get('PassQps')
        if m.get('Qps') is not None:
            self.qps = m.get('Qps')
        if m.get('Rt') is not None:
            self.rt = m.get('Rt')
        if m.get('Thread') is not None:
            self.thread = m.get('Thread')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetApplicationListWithMetircsResponseBodyDataResultCurMetricsFm(TeaModel):
    def __init__(
        self,
        block_qps: float = None,
        exp_qps: float = None,
        pass_qps: float = None,
        qps: float = None,
        rt: float = None,
        thread: float = None,
        timestamp: int = None,
    ):
        # The number of blocked QPS.
        self.block_qps = block_qps
        # The number of abnormal QPS.
        self.exp_qps = exp_qps
        # The number of passed QPS.
        self.pass_qps = pass_qps
        # The QPS.
        self.qps = qps
        # The RT.
        self.rt = rt
        # The number of concurrent threads.
        self.thread = thread
        # The timestamp.
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_qps is not None:
            result['BlockQps'] = self.block_qps
        if self.exp_qps is not None:
            result['ExpQps'] = self.exp_qps
        if self.pass_qps is not None:
            result['PassQps'] = self.pass_qps
        if self.qps is not None:
            result['Qps'] = self.qps
        if self.rt is not None:
            result['Rt'] = self.rt
        if self.thread is not None:
            result['Thread'] = self.thread
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockQps') is not None:
            self.block_qps = m.get('BlockQps')
        if m.get('ExpQps') is not None:
            self.exp_qps = m.get('ExpQps')
        if m.get('PassQps') is not None:
            self.pass_qps = m.get('PassQps')
        if m.get('Qps') is not None:
            self.qps = m.get('Qps')
        if m.get('Rt') is not None:
            self.rt = m.get('Rt')
        if m.get('Thread') is not None:
            self.thread = m.get('Thread')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetApplicationListWithMetircsResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_name: str = None,
        cur_metrics: List[GetApplicationListWithMetircsResponseBodyDataResultCurMetrics] = None,
        cur_metrics_fm: GetApplicationListWithMetircsResponseBodyDataResultCurMetricsFm = None,
        extra_info: str = None,
        instances_number: int = None,
        language: str = None,
        license_key: str = None,
        namespace: str = None,
        region_id: str = None,
        source: str = None,
        status: int = None,
        tags: List[str] = None,
        user_id: str = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # The name of the application.
        self.app_name = app_name
        # The metric about the application.
        self.cur_metrics = cur_metrics
        # The sum of metrics about the application.
        self.cur_metrics_fm = cur_metrics_fm
        # The additional information.
        self.extra_info = extra_info
        # The number of instances.
        self.instances_number = instances_number
        # The programming language of the application.
        self.language = language
        # The license key in use.
        self.license_key = license_key
        self.namespace = namespace
        # The ID of the region where the instance resides.
        self.region_id = region_id
        # The service source.
        self.source = source
        # The status.
        self.status = status
        # The tags.
        self.tags = tags
        # The ID of the user.
        self.user_id = user_id

    def validate(self):
        if self.cur_metrics:
            for k in self.cur_metrics:
                if k:
                    k.validate()
        if self.cur_metrics_fm:
            self.cur_metrics_fm.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        result['CurMetrics'] = []
        if self.cur_metrics is not None:
            for k in self.cur_metrics:
                result['CurMetrics'].append(k.to_map() if k else None)
        if self.cur_metrics_fm is not None:
            result['CurMetricsFm'] = self.cur_metrics_fm.to_map()
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.instances_number is not None:
            result['InstancesNumber'] = self.instances_number
        if self.language is not None:
            result['Language'] = self.language
        if self.license_key is not None:
            result['LicenseKey'] = self.license_key
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        self.cur_metrics = []
        if m.get('CurMetrics') is not None:
            for k in m.get('CurMetrics'):
                temp_model = GetApplicationListWithMetircsResponseBodyDataResultCurMetrics()
                self.cur_metrics.append(temp_model.from_map(k))
        if m.get('CurMetricsFm') is not None:
            temp_model = GetApplicationListWithMetircsResponseBodyDataResultCurMetricsFm()
            self.cur_metrics_fm = temp_model.from_map(m['CurMetricsFm'])
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('InstancesNumber') is not None:
            self.instances_number = m.get('InstancesNumber')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('LicenseKey') is not None:
            self.license_key = m.get('LicenseKey')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetApplicationListWithMetircsResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        result: List[GetApplicationListWithMetircsResponseBodyDataResult] = None,
        total_size: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The returned information.
        self.result = result
        # The total number of entries returned.
        self.total_size = total_size

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = GetApplicationListWithMetircsResponseBodyDataResult()
                self.result.append(temp_model.from_map(k))
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class GetApplicationListWithMetircsResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetApplicationListWithMetircsResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetApplicationListWithMetircsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetApplicationListWithMetircsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetApplicationListWithMetircsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetApplicationListWithMetircsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBlackWhiteListRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        is_white: bool = None,
        resource_type: str = None,
        type: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # Specifies whether to enable the whitelist.
        self.is_white = is_white
        # The type of the resource.
        self.resource_type = resource_type
        # The type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.is_white is not None:
            result['IsWhite'] = self.is_white
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('IsWhite') is not None:
            self.is_white = m.get('IsWhite')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetBlackWhiteListResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        is_white: bool = None,
        resource_id: int = None,
        resource_type: str = None,
        status: str = None,
        type: str = None,
    ):
        # The content of the blacklist.
        self.content = content
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The creation time.
        self.gmt_create = gmt_create
        # The modification time.
        self.gmt_modified = gmt_modified
        # The ID.
        self.id = id
        # Indicates whether the whitelist is enabled.
        self.is_white = is_white
        # The ID of the resource.
        self.resource_id = resource_id
        # The type of a resource.
        self.resource_type = resource_type
        # The status of the blacklist or whitelist.
        self.status = status
        # The type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.is_white is not None:
            result['IsWhite'] = self.is_white
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsWhite') is not None:
            self.is_white = m.get('IsWhite')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetBlackWhiteListResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetBlackWhiteListResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. A value of 200 indicates that the request is successful.
        self.code = code
        # The data of the node.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetBlackWhiteListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBlackWhiteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBlackWhiteListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBlackWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEngineNamepaceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the cluster.
        self.cluster_id = cluster_id
        # The destination ID.
        self.id = id
        # The ID of the instance.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetEngineNamepaceResponseBody(TeaModel):
    def __init__(
        self,
        config_count: str = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        namespace: str = None,
        namespace_desc: str = None,
        namespace_show_name: str = None,
        quota: str = None,
        request_id: str = None,
        success: bool = None,
        type: str = None,
    ):
        # The number of configurations.
        self.config_count = config_count
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The ID of the namespace.
        self.namespace = namespace
        # The description of the namespace.
        self.namespace_desc = namespace_desc
        # The display name of the namespace.
        self.namespace_show_name = namespace_show_name
        # The quota of configurations.
        self.quota = quota
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success
        # The type of the namespace. Valid values:
        # 
        # *   0: global configuration
        # *   1: default namespace
        # *   2: custom namespace
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_count is not None:
            result['ConfigCount'] = self.config_count
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_desc is not None:
            result['NamespaceDesc'] = self.namespace_desc
        if self.namespace_show_name is not None:
            result['NamespaceShowName'] = self.namespace_show_name
        if self.quota is not None:
            result['Quota'] = self.quota
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigCount') is not None:
            self.config_count = m.get('ConfigCount')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespaceDesc') is not None:
            self.namespace_desc = m.get('NamespaceDesc')
        if m.get('NamespaceShowName') is not None:
            self.namespace_show_name = m.get('NamespaceShowName')
        if m.get('Quota') is not None:
            self.quota = m.get('Quota')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetEngineNamepaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEngineNamepaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEngineNamepaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGatewayRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        return self


class GetGatewayResponseBodyDataLogConfigDetails(TeaModel):
    def __init__(
        self,
        log_enabled: bool = None,
        log_store_name: str = None,
        project_name: str = None,
    ):
        # Indicates whether Log Service is activated.
        self.log_enabled = log_enabled
        # The name of the Logstore.
        self.log_store_name = log_store_name
        # The name of the project.
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_enabled is not None:
            result['LogEnabled'] = self.log_enabled
        if self.log_store_name is not None:
            result['LogStoreName'] = self.log_store_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogEnabled') is not None:
            self.log_enabled = m.get('LogEnabled')
        if m.get('LogStoreName') is not None:
            self.log_store_name = m.get('LogStoreName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class GetGatewayResponseBodyDataXtraceDetails(TeaModel):
    def __init__(
        self,
        sample: int = None,
        trace_on: bool = None,
    ):
        # The sampling rate of Tracing Analysis.
        self.sample = sample
        # Indicates whether sampling by using Tracing Analysis is enabled.
        self.trace_on = trace_on

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.trace_on is not None:
            result['TraceOn'] = self.trace_on
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('TraceOn') is not None:
            self.trace_on = m.get('TraceOn')
        return self


class GetGatewayResponseBodyData(TeaModel):
    def __init__(
        self,
        charge_type: str = None,
        end_date: str = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        log_config_details: GetGatewayResponseBodyDataLogConfigDetails = None,
        mse_tag: str = None,
        name: str = None,
        primary_user: str = None,
        region: str = None,
        replica: int = None,
        resource_group_id: str = None,
        security_group: str = None,
        spec: str = None,
        status: int = None,
        status_desc: str = None,
        vpc: str = None,
        vswitch: str = None,
        vswitch_2: str = None,
        xtrace_details: GetGatewayResponseBodyDataXtraceDetails = None,
    ):
        # The billing method, such as subscription or pay-as-you-go.
        self.charge_type = charge_type
        # The time when the gateway expires.
        self.end_date = end_date
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The time when the gateway was created. The time is displayed in GMT. The time is the local time of the region in which the gateway resides.
        self.gmt_create = gmt_create
        # The time when the gateway was last modified.
        self.gmt_modified = gmt_modified
        # The ID of the gateway.
        self.id = id
        # The ID of the instance.
        self.instance_id = instance_id
        # The log configuration.
        self.log_config_details = log_config_details
        # The tag of the resource.
        self.mse_tag = mse_tag
        # The name of the gateway.
        self.name = name
        # The Alibaba Cloud account ID of the user who created the gateway.
        self.primary_user = primary_user
        # The region ID.
        self.region = region
        # The number of gateway replicas.
        self.replica = replica
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The ID of the security group.
        self.security_group = security_group
        # The specifications of the gateway.
        self.spec = spec
        # The status of the gateway. Valid values: 0: The gateway is being created. 1: The gateway fails to be created. 2: The gateway is running. 3: The gateway is changing. 4: The gateway is scaling down. 6: The gateway is scaling up. 8: The gateway is being deleted. 10: The gateway is restarting. 11: The gateway is being rebuilt. 12: The gateway is updating. 13: The gateway fails to be updated.
        self.status = status
        # The description of the status.
        self.status_desc = status_desc
        # The ID of the VPC.
        self.vpc = vpc
        # The ID of the vSwitch.
        self.vswitch = vswitch
        # The ID of the secondary vSwitch.
        self.vswitch_2 = vswitch_2
        # The details of Tracing Analysis.
        self.xtrace_details = xtrace_details

    def validate(self):
        if self.log_config_details:
            self.log_config_details.validate()
        if self.xtrace_details:
            self.xtrace_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.log_config_details is not None:
            result['LogConfigDetails'] = self.log_config_details.to_map()
        if self.mse_tag is not None:
            result['MseTag'] = self.mse_tag
        if self.name is not None:
            result['Name'] = self.name
        if self.primary_user is not None:
            result['PrimaryUser'] = self.primary_user
        if self.region is not None:
            result['Region'] = self.region
        if self.replica is not None:
            result['Replica'] = self.replica
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_group is not None:
            result['SecurityGroup'] = self.security_group
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.status is not None:
            result['Status'] = self.status
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.vpc is not None:
            result['Vpc'] = self.vpc
        if self.vswitch is not None:
            result['Vswitch'] = self.vswitch
        if self.vswitch_2 is not None:
            result['Vswitch2'] = self.vswitch_2
        if self.xtrace_details is not None:
            result['XtraceDetails'] = self.xtrace_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LogConfigDetails') is not None:
            temp_model = GetGatewayResponseBodyDataLogConfigDetails()
            self.log_config_details = temp_model.from_map(m['LogConfigDetails'])
        if m.get('MseTag') is not None:
            self.mse_tag = m.get('MseTag')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PrimaryUser') is not None:
            self.primary_user = m.get('PrimaryUser')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Replica') is not None:
            self.replica = m.get('Replica')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityGroup') is not None:
            self.security_group = m.get('SecurityGroup')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('Vpc') is not None:
            self.vpc = m.get('Vpc')
        if m.get('Vswitch') is not None:
            self.vswitch = m.get('Vswitch')
        if m.get('Vswitch2') is not None:
            self.vswitch_2 = m.get('Vswitch2')
        if m.get('XtraceDetails') is not None:
            temp_model = GetGatewayResponseBodyDataXtraceDetails()
            self.xtrace_details = temp_model.from_map(m['XtraceDetails'])
        return self


class GetGatewayResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetGatewayResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. A value of 200 indicates that the request is successful.
        self.code = code
        # The information about the gateway.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetGatewayResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetGatewayResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGatewayDomainDetailRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The domain ID.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetGatewayDomainDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        after_date: int = None,
        algorithm: str = None,
        before_date: int = None,
        cert_identifier: str = None,
        cert_name: str = None,
        common_name: str = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        gmt_after: str = None,
        gmt_before: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        http_2: str = None,
        id: int = None,
        issuer: str = None,
        must_https: bool = None,
        name: str = None,
        protocol: str = None,
        sans: str = None,
        tls_max: str = None,
        tls_min: str = None,
    ):
        # The start time.
        self.after_date = after_date
        # The algorithm.
        self.algorithm = algorithm
        # The expiration time.
        self.before_date = before_date
        # The ID of the certificate.
        self.cert_identifier = cert_identifier
        # The name of the certificate.
        self.cert_name = cert_name
        # The public domain name.
        self.common_name = common_name
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The start time.
        self.gmt_after = gmt_after
        # The expiration time.
        self.gmt_before = gmt_before
        # The creation time.
        self.gmt_create = gmt_create
        # The update time.
        self.gmt_modified = gmt_modified
        # Indicates whether `HTTP/2` is enabled.
        # 
        # *   `open`: `HTTP/2` is enabled.
        # *   `close`: `HTTP/2` is disabled.
        # *   `globalConfig`: Global configurations are used.
        self.http_2 = http_2
        # The ID.
        self.id = id
        # The issuer.
        self.issuer = issuer
        # Indicates whether HTTPS is forcibly used.
        self.must_https = must_https
        # The domain name.
        self.name = name
        # The protocol of the gateway.
        self.protocol = protocol
        # The name of the extended field.
        self.sans = sans
        # The maximum version of Transport Layer Security (TLS).
        self.tls_max = tls_max
        # The minimum version of TLS.
        self.tls_min = tls_min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.after_date is not None:
            result['AfterDate'] = self.after_date
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.before_date is not None:
            result['BeforeDate'] = self.before_date
        if self.cert_identifier is not None:
            result['CertIdentifier'] = self.cert_identifier
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.common_name is not None:
            result['CommonName'] = self.common_name
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_after is not None:
            result['GmtAfter'] = self.gmt_after
        if self.gmt_before is not None:
            result['GmtBefore'] = self.gmt_before
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.http_2 is not None:
            result['Http2'] = self.http_2
        if self.id is not None:
            result['Id'] = self.id
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.must_https is not None:
            result['MustHttps'] = self.must_https
        if self.name is not None:
            result['Name'] = self.name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.sans is not None:
            result['Sans'] = self.sans
        if self.tls_max is not None:
            result['TlsMax'] = self.tls_max
        if self.tls_min is not None:
            result['TlsMin'] = self.tls_min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AfterDate') is not None:
            self.after_date = m.get('AfterDate')
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('BeforeDate') is not None:
            self.before_date = m.get('BeforeDate')
        if m.get('CertIdentifier') is not None:
            self.cert_identifier = m.get('CertIdentifier')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('CommonName') is not None:
            self.common_name = m.get('CommonName')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtAfter') is not None:
            self.gmt_after = m.get('GmtAfter')
        if m.get('GmtBefore') is not None:
            self.gmt_before = m.get('GmtBefore')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Http2') is not None:
            self.http_2 = m.get('Http2')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('MustHttps') is not None:
            self.must_https = m.get('MustHttps')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Sans') is not None:
            self.sans = m.get('Sans')
        if m.get('TlsMax') is not None:
            self.tls_max = m.get('TlsMax')
        if m.get('TlsMin') is not None:
            self.tls_min = m.get('TlsMin')
        return self


class GetGatewayDomainDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetGatewayDomainDetailResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetGatewayDomainDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetGatewayDomainDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetGatewayDomainDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGatewayDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGatewayOptionRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        return self


class GetGatewayOptionResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GatewayOption = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The value 200 indicates that the request is successfully processed.
        self.code = code
        # The detailed configurations of the gateway.
        # 
        # *   **TraceDetails**: the sampling description of Tracing Analysis. Content: TraceEnabled indicates whether Tracing Analysis is activated. Sample indicates the sampling rate of Tracing Analysis.
        # *   **LogConfigDetails**: the description of Log Service. Content: LogEnabled indicates whether Log Service is activated. ProjectName indicates the Log Service project to which logs are delivered. LogStoreName indicates the name of the Logstore.
        # *   **EnableHardwareAcceleration**: indicates whether hardware acceleration is enabled.
        # *   **DisableHttp2Alpn**: indicates whether the HTTP/2 protocol is disabled.
        # *   **EnableWaf**: indicates whether Web Application Firewall (WAF) is enabled.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        # 
        # *   If the request is successful, a success message is returned.
        # *   If the request fails, an error message is returned, such as the "TaskId not found" message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GatewayOption()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetGatewayOptionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetGatewayOptionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGatewayOptionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGatewayRouteDetailRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        route_id: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the route.
        self.route_id = route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class GetGatewayRouteDetailResponseBodyDataCors(TeaModel):
    def __init__(
        self,
        allow_credentials: bool = None,
        allow_headers: str = None,
        allow_methods: str = None,
        allow_origins: str = None,
        expose_headers: str = None,
        status: str = None,
        time_unit: str = None,
        unit_num: int = None,
    ):
        # The credentials allowed.
        self.allow_credentials = allow_credentials
        # The headers allowed.
        self.allow_headers = allow_headers
        # The methods allowed.
        self.allow_methods = allow_methods
        # The origins allowed.
        self.allow_origins = allow_origins
        # The response headers.
        self.expose_headers = expose_headers
        # The status.
        self.status = status
        # The time unit.
        self.time_unit = time_unit
        # The unit number.
        self.unit_num = unit_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_credentials is not None:
            result['AllowCredentials'] = self.allow_credentials
        if self.allow_headers is not None:
            result['AllowHeaders'] = self.allow_headers
        if self.allow_methods is not None:
            result['AllowMethods'] = self.allow_methods
        if self.allow_origins is not None:
            result['AllowOrigins'] = self.allow_origins
        if self.expose_headers is not None:
            result['ExposeHeaders'] = self.expose_headers
        if self.status is not None:
            result['Status'] = self.status
        if self.time_unit is not None:
            result['TimeUnit'] = self.time_unit
        if self.unit_num is not None:
            result['UnitNum'] = self.unit_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowCredentials') is not None:
            self.allow_credentials = m.get('AllowCredentials')
        if m.get('AllowHeaders') is not None:
            self.allow_headers = m.get('AllowHeaders')
        if m.get('AllowMethods') is not None:
            self.allow_methods = m.get('AllowMethods')
        if m.get('AllowOrigins') is not None:
            self.allow_origins = m.get('AllowOrigins')
        if m.get('ExposeHeaders') is not None:
            self.expose_headers = m.get('ExposeHeaders')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TimeUnit') is not None:
            self.time_unit = m.get('TimeUnit')
        if m.get('UnitNum') is not None:
            self.unit_num = m.get('UnitNum')
        return self


class GetGatewayRouteDetailResponseBodyDataDirectResponse(TeaModel):
    def __init__(
        self,
        body: str = None,
        code: int = None,
    ):
        # The mock return value.
        self.body = body
        # The response code returned.
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['Body'] = self.body
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Body') is not None:
            self.body = m.get('Body')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class GetGatewayRouteDetailResponseBodyDataFallbackServices(TeaModel):
    def __init__(
        self,
        agreement_type: str = None,
        group_name: str = None,
        name: str = None,
        namespace: str = None,
        percent: int = None,
        service_id: int = None,
        service_name: str = None,
        service_port: int = None,
        source_type: str = None,
        version: str = None,
    ):
        # The type of the protocol.
        self.agreement_type = agreement_type
        # The name of the group to which the service belongs.
        self.group_name = group_name
        # The name.
        self.name = name
        # The namespace to which the service belongs.
        self.namespace = namespace
        # The weight in the form of a percentage value.
        self.percent = percent
        # The ID of the service.
        self.service_id = service_id
        # The name of the service.
        self.service_name = service_name
        # The service port number.
        self.service_port = service_port
        # The source type.
        self.source_type = source_type
        # The version of the service.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agreement_type is not None:
            result['AgreementType'] = self.agreement_type
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgreementType') is not None:
            self.agreement_type = m.get('AgreementType')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetGatewayRouteDetailResponseBodyDataHTTPRewrite(TeaModel):
    def __init__(
        self,
        host: str = None,
        path: str = None,
        path_type: str = None,
        pattern: str = None,
        status: str = None,
        substitution: str = None,
    ):
        # The hostname of the gateway.
        self.host = host
        # The path of the node.
        self.path = path
        # The rewrite type.
        self.path_type = path_type
        # The matching pattern.
        self.pattern = pattern
        # The status.
        self.status = status
        # The replacement.
        self.substitution = substitution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        if self.path is not None:
            result['Path'] = self.path
        if self.path_type is not None:
            result['PathType'] = self.path_type
        if self.pattern is not None:
            result['Pattern'] = self.pattern
        if self.status is not None:
            result['Status'] = self.status
        if self.substitution is not None:
            result['Substitution'] = self.substitution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('PathType') is not None:
            self.path_type = m.get('PathType')
        if m.get('Pattern') is not None:
            self.pattern = m.get('Pattern')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Substitution') is not None:
            self.substitution = m.get('Substitution')
        return self


class GetGatewayRouteDetailResponseBodyDataHeaderOpHeaderOpItems(TeaModel):
    def __init__(
        self,
        direction_type: str = None,
        key: str = None,
        op_type: str = None,
        value: str = None,
    ):
        # The request or response.
        self.direction_type = direction_type
        # The header key.
        self.key = key
        # The operation type.
        self.op_type = op_type
        # The header value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction_type is not None:
            result['DirectionType'] = self.direction_type
        if self.key is not None:
            result['Key'] = self.key
        if self.op_type is not None:
            result['OpType'] = self.op_type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DirectionType') is not None:
            self.direction_type = m.get('DirectionType')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('OpType') is not None:
            self.op_type = m.get('OpType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetGatewayRouteDetailResponseBodyDataHeaderOp(TeaModel):
    def __init__(
        self,
        header_op_items: List[GetGatewayRouteDetailResponseBodyDataHeaderOpHeaderOpItems] = None,
        status: str = None,
    ):
        # The information about headers.
        self.header_op_items = header_op_items
        # The status.
        self.status = status

    def validate(self):
        if self.header_op_items:
            for k in self.header_op_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HeaderOpItems'] = []
        if self.header_op_items is not None:
            for k in self.header_op_items:
                result['HeaderOpItems'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.header_op_items = []
        if m.get('HeaderOpItems') is not None:
            for k in m.get('HeaderOpItems'):
                temp_model = GetGatewayRouteDetailResponseBodyDataHeaderOpHeaderOpItems()
                self.header_op_items.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetGatewayRouteDetailResponseBodyDataRedirect(TeaModel):
    def __init__(
        self,
        code: int = None,
        host: str = None,
        path: str = None,
    ):
        # The response code returned.
        self.code = code
        # The hostname.
        self.host = host
        # The path.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.host is not None:
            result['Host'] = self.host
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class GetGatewayRouteDetailResponseBodyDataRetry(TeaModel):
    def __init__(
        self,
        attempts: int = None,
        http_codes: List[str] = None,
        retry_on: List[str] = None,
        status: str = None,
    ):
        # The number of retries allowed.
        self.attempts = attempts
        # The HTTP status code returned.
        self.http_codes = http_codes
        # The retry condition.
        self.retry_on = retry_on
        # The retry status.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attempts is not None:
            result['Attempts'] = self.attempts
        if self.http_codes is not None:
            result['HttpCodes'] = self.http_codes
        if self.retry_on is not None:
            result['RetryOn'] = self.retry_on
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Attempts') is not None:
            self.attempts = m.get('Attempts')
        if m.get('HttpCodes') is not None:
            self.http_codes = m.get('HttpCodes')
        if m.get('RetryOn') is not None:
            self.retry_on = m.get('RetryOn')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetGatewayRouteDetailResponseBodyDataRoutePredicatesHeaderPredicates(TeaModel):
    def __init__(
        self,
        key: str = None,
        type: str = None,
        value: str = None,
    ):
        # The key of the request header.
        self.key = key
        # The type.
        self.type = type
        # The value of the request header.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetGatewayRouteDetailResponseBodyDataRoutePredicatesPathPredicates(TeaModel):
    def __init__(
        self,
        ignore_case: bool = None,
        path: str = None,
        type: str = None,
    ):
        # Indicates whether case sensitivity is ignored.
        self.ignore_case = ignore_case
        # The path.
        self.path = path
        # The matching type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignore_case is not None:
            result['IgnoreCase'] = self.ignore_case
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoreCase') is not None:
            self.ignore_case = m.get('IgnoreCase')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetGatewayRouteDetailResponseBodyDataRoutePredicatesQueryPredicates(TeaModel):
    def __init__(
        self,
        key: str = None,
        type: str = None,
        value: str = None,
    ):
        # The name of the parameter.
        self.key = key
        # The type.
        self.type = type
        # The value of the parameter.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetGatewayRouteDetailResponseBodyDataRoutePredicates(TeaModel):
    def __init__(
        self,
        header_predicates: List[GetGatewayRouteDetailResponseBodyDataRoutePredicatesHeaderPredicates] = None,
        method_predicates: List[str] = None,
        path_predicates: GetGatewayRouteDetailResponseBodyDataRoutePredicatesPathPredicates = None,
        query_predicates: List[GetGatewayRouteDetailResponseBodyDataRoutePredicatesQueryPredicates] = None,
    ):
        # The information about header matching.
        self.header_predicates = header_predicates
        # The information about method matching.
        self.method_predicates = method_predicates
        # The information about route matching.
        self.path_predicates = path_predicates
        # The information about parameter matching.
        self.query_predicates = query_predicates

    def validate(self):
        if self.header_predicates:
            for k in self.header_predicates:
                if k:
                    k.validate()
        if self.path_predicates:
            self.path_predicates.validate()
        if self.query_predicates:
            for k in self.query_predicates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HeaderPredicates'] = []
        if self.header_predicates is not None:
            for k in self.header_predicates:
                result['HeaderPredicates'].append(k.to_map() if k else None)
        if self.method_predicates is not None:
            result['MethodPredicates'] = self.method_predicates
        if self.path_predicates is not None:
            result['PathPredicates'] = self.path_predicates.to_map()
        result['QueryPredicates'] = []
        if self.query_predicates is not None:
            for k in self.query_predicates:
                result['QueryPredicates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.header_predicates = []
        if m.get('HeaderPredicates') is not None:
            for k in m.get('HeaderPredicates'):
                temp_model = GetGatewayRouteDetailResponseBodyDataRoutePredicatesHeaderPredicates()
                self.header_predicates.append(temp_model.from_map(k))
        if m.get('MethodPredicates') is not None:
            self.method_predicates = m.get('MethodPredicates')
        if m.get('PathPredicates') is not None:
            temp_model = GetGatewayRouteDetailResponseBodyDataRoutePredicatesPathPredicates()
            self.path_predicates = temp_model.from_map(m['PathPredicates'])
        self.query_predicates = []
        if m.get('QueryPredicates') is not None:
            for k in m.get('QueryPredicates'):
                temp_model = GetGatewayRouteDetailResponseBodyDataRoutePredicatesQueryPredicates()
                self.query_predicates.append(temp_model.from_map(k))
        return self


class GetGatewayRouteDetailResponseBodyDataRouteServices(TeaModel):
    def __init__(
        self,
        agreement_type: str = None,
        group_name: str = None,
        name: str = None,
        namespace: str = None,
        percent: int = None,
        service_id: int = None,
        service_name: str = None,
        service_port: int = None,
        source_type: str = None,
        version: str = None,
    ):
        # The type of the protocol.
        self.agreement_type = agreement_type
        # The name of the group to which the service belongs.
        self.group_name = group_name
        # The name of the service.
        self.name = name
        # The namespace.
        self.namespace = namespace
        # The weight.
        self.percent = percent
        # The ID of the service.
        self.service_id = service_id
        # The name of the service.
        self.service_name = service_name
        # The service port number.
        self.service_port = service_port
        # The source type of the service.
        self.source_type = source_type
        # The version of the service.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agreement_type is not None:
            result['AgreementType'] = self.agreement_type
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgreementType') is not None:
            self.agreement_type = m.get('AgreementType')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetGatewayRouteDetailResponseBodyDataTimeout(TeaModel):
    def __init__(
        self,
        status: str = None,
        time_unit: str = None,
        unit_num: int = None,
    ):
        # The status.
        self.status = status
        # The time unit.
        self.time_unit = time_unit
        # The unit number.
        self.unit_num = unit_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.time_unit is not None:
            result['TimeUnit'] = self.time_unit
        if self.unit_num is not None:
            result['UnitNum'] = self.unit_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TimeUnit') is not None:
            self.time_unit = m.get('TimeUnit')
        if m.get('UnitNum') is not None:
            self.unit_num = m.get('UnitNum')
        return self


class GetGatewayRouteDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        ahas_status: int = None,
        cors: GetGatewayRouteDetailResponseBodyDataCors = None,
        default_service_id: int = None,
        default_service_name: str = None,
        destination_type: str = None,
        direct_response: GetGatewayRouteDetailResponseBodyDataDirectResponse = None,
        domain_id: int = None,
        domain_id_list: List[int] = None,
        domain_name: str = None,
        domain_name_list: List[str] = None,
        enable_waf: bool = None,
        fallback: bool = None,
        fallback_services: List[GetGatewayRouteDetailResponseBodyDataFallbackServices] = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        httprewrite: GetGatewayRouteDetailResponseBodyDataHTTPRewrite = None,
        header_op: GetGatewayRouteDetailResponseBodyDataHeaderOp = None,
        id: int = None,
        name: str = None,
        predicates: str = None,
        redirect: GetGatewayRouteDetailResponseBodyDataRedirect = None,
        retry: GetGatewayRouteDetailResponseBodyDataRetry = None,
        route_order: int = None,
        route_predicates: GetGatewayRouteDetailResponseBodyDataRoutePredicates = None,
        route_services: List[GetGatewayRouteDetailResponseBodyDataRouteServices] = None,
        services: str = None,
        status: int = None,
        timeout: GetGatewayRouteDetailResponseBodyDataTimeout = None,
    ):
        # The status of Application High Availability Service (AHAS).
        self.ahas_status = ahas_status
        # The configuration for cross-origin resource sharing (CORS).
        self.cors = cors
        # The default service ID.
        self.default_service_id = default_service_id
        # The default service name.
        self.default_service_name = default_service_name
        # The destination service type.
        self.destination_type = destination_type
        # The information about service mocking.
        self.direct_response = direct_response
        # The domain ID.
        self.domain_id = domain_id
        # The IDs of domains.
        self.domain_id_list = domain_id_list
        # The domain name.
        self.domain_name = domain_name
        # The list of domain names.
        self.domain_name_list = domain_name_list
        # Indicates whether WAF is activated.
        self.enable_waf = enable_waf
        # Indicates whether the Fallback service is enabled.
        self.fallback = fallback
        # The information about the Fallback service.
        self.fallback_services = fallback_services
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The creation time.
        self.gmt_create = gmt_create
        # The last modification time.
        self.gmt_modified = gmt_modified
        # The information about the rewrite policy.
        self.httprewrite = httprewrite
        # The header settings.
        self.header_op = header_op
        # The ID.
        self.id = id
        # The name.
        self.name = name
        # The matching conditions.
        self.predicates = predicates
        # The configuration of the redirection.
        self.redirect = redirect
        # The retry configuration.
        self.retry = retry
        # The sequence number of the route.
        self.route_order = route_order
        # The information about route matching.
        self.route_predicates = route_predicates
        # The information about services.
        self.route_services = route_services
        # The configurations of services.
        self.services = services
        # The status of the route. Valid values:
        # 
        # *   0: unpublished
        # *   2: publishing
        # *   3: published
        # *   4: editing (updated but not published)
        # *   5: unpublishing
        # *   6: unavailable
        self.status = status
        # The timeout configuration.
        self.timeout = timeout

    def validate(self):
        if self.cors:
            self.cors.validate()
        if self.direct_response:
            self.direct_response.validate()
        if self.fallback_services:
            for k in self.fallback_services:
                if k:
                    k.validate()
        if self.httprewrite:
            self.httprewrite.validate()
        if self.header_op:
            self.header_op.validate()
        if self.redirect:
            self.redirect.validate()
        if self.retry:
            self.retry.validate()
        if self.route_predicates:
            self.route_predicates.validate()
        if self.route_services:
            for k in self.route_services:
                if k:
                    k.validate()
        if self.timeout:
            self.timeout.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ahas_status is not None:
            result['AhasStatus'] = self.ahas_status
        if self.cors is not None:
            result['Cors'] = self.cors.to_map()
        if self.default_service_id is not None:
            result['DefaultServiceId'] = self.default_service_id
        if self.default_service_name is not None:
            result['DefaultServiceName'] = self.default_service_name
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.direct_response is not None:
            result['DirectResponse'] = self.direct_response.to_map()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_id_list is not None:
            result['DomainIdList'] = self.domain_id_list
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_name_list is not None:
            result['DomainNameList'] = self.domain_name_list
        if self.enable_waf is not None:
            result['EnableWaf'] = self.enable_waf
        if self.fallback is not None:
            result['Fallback'] = self.fallback
        result['FallbackServices'] = []
        if self.fallback_services is not None:
            for k in self.fallback_services:
                result['FallbackServices'].append(k.to_map() if k else None)
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.httprewrite is not None:
            result['HTTPRewrite'] = self.httprewrite.to_map()
        if self.header_op is not None:
            result['HeaderOp'] = self.header_op.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.predicates is not None:
            result['Predicates'] = self.predicates
        if self.redirect is not None:
            result['Redirect'] = self.redirect.to_map()
        if self.retry is not None:
            result['Retry'] = self.retry.to_map()
        if self.route_order is not None:
            result['RouteOrder'] = self.route_order
        if self.route_predicates is not None:
            result['RoutePredicates'] = self.route_predicates.to_map()
        result['RouteServices'] = []
        if self.route_services is not None:
            for k in self.route_services:
                result['RouteServices'].append(k.to_map() if k else None)
        if self.services is not None:
            result['Services'] = self.services
        if self.status is not None:
            result['Status'] = self.status
        if self.timeout is not None:
            result['Timeout'] = self.timeout.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AhasStatus') is not None:
            self.ahas_status = m.get('AhasStatus')
        if m.get('Cors') is not None:
            temp_model = GetGatewayRouteDetailResponseBodyDataCors()
            self.cors = temp_model.from_map(m['Cors'])
        if m.get('DefaultServiceId') is not None:
            self.default_service_id = m.get('DefaultServiceId')
        if m.get('DefaultServiceName') is not None:
            self.default_service_name = m.get('DefaultServiceName')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('DirectResponse') is not None:
            temp_model = GetGatewayRouteDetailResponseBodyDataDirectResponse()
            self.direct_response = temp_model.from_map(m['DirectResponse'])
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainIdList') is not None:
            self.domain_id_list = m.get('DomainIdList')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainNameList') is not None:
            self.domain_name_list = m.get('DomainNameList')
        if m.get('EnableWaf') is not None:
            self.enable_waf = m.get('EnableWaf')
        if m.get('Fallback') is not None:
            self.fallback = m.get('Fallback')
        self.fallback_services = []
        if m.get('FallbackServices') is not None:
            for k in m.get('FallbackServices'):
                temp_model = GetGatewayRouteDetailResponseBodyDataFallbackServices()
                self.fallback_services.append(temp_model.from_map(k))
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HTTPRewrite') is not None:
            temp_model = GetGatewayRouteDetailResponseBodyDataHTTPRewrite()
            self.httprewrite = temp_model.from_map(m['HTTPRewrite'])
        if m.get('HeaderOp') is not None:
            temp_model = GetGatewayRouteDetailResponseBodyDataHeaderOp()
            self.header_op = temp_model.from_map(m['HeaderOp'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Predicates') is not None:
            self.predicates = m.get('Predicates')
        if m.get('Redirect') is not None:
            temp_model = GetGatewayRouteDetailResponseBodyDataRedirect()
            self.redirect = temp_model.from_map(m['Redirect'])
        if m.get('Retry') is not None:
            temp_model = GetGatewayRouteDetailResponseBodyDataRetry()
            self.retry = temp_model.from_map(m['Retry'])
        if m.get('RouteOrder') is not None:
            self.route_order = m.get('RouteOrder')
        if m.get('RoutePredicates') is not None:
            temp_model = GetGatewayRouteDetailResponseBodyDataRoutePredicates()
            self.route_predicates = temp_model.from_map(m['RoutePredicates'])
        self.route_services = []
        if m.get('RouteServices') is not None:
            for k in m.get('RouteServices'):
                temp_model = GetGatewayRouteDetailResponseBodyDataRouteServices()
                self.route_services.append(temp_model.from_map(k))
        if m.get('Services') is not None:
            self.services = m.get('Services')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Timeout') is not None:
            temp_model = GetGatewayRouteDetailResponseBodyDataTimeout()
            self.timeout = temp_model.from_map(m['Timeout'])
        return self


class GetGatewayRouteDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetGatewayRouteDetailResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. A value of 200 indicates that the request is successful.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetGatewayRouteDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetGatewayRouteDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetGatewayRouteDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGatewayRouteDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGatewayServiceDetailRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        service_id: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the service.
        self.service_id = service_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        return self


class GetGatewayServiceDetailResponseBodyDataLabelDetails(TeaModel):
    def __init__(
        self,
        key: str = None,
        values: List[str] = None,
    ):
        # The tag.
        self.key = key
        # The key of the tag.
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class GetGatewayServiceDetailResponseBodyDataPortTrafficPolicyList(TeaModel):
    def __init__(
        self,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        service_id: int = None,
        service_port: int = None,
        traffic_policy: TrafficPolicy = None,
    ):
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The creation time.
        self.gmt_create = gmt_create
        # The modification time.
        self.gmt_modified = gmt_modified
        # The ID of the port configuration.
        self.id = id
        # The ID of the service.
        self.service_id = service_id
        # The service port number.
        self.service_port = service_port
        # The traffic policy.
        self.traffic_policy = traffic_policy

    def validate(self):
        if self.traffic_policy:
            self.traffic_policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.traffic_policy is not None:
            result['TrafficPolicy'] = self.traffic_policy.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('TrafficPolicy') is not None:
            temp_model = TrafficPolicy()
            self.traffic_policy = temp_model.from_map(m['TrafficPolicy'])
        return self


class GetGatewayServiceDetailResponseBodyDataVersionDetailsServiceVersionLabels(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag.
        self.key = key
        # The key of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetGatewayServiceDetailResponseBodyDataVersionDetailsServiceVersion(TeaModel):
    def __init__(
        self,
        labels: List[GetGatewayServiceDetailResponseBodyDataVersionDetailsServiceVersionLabels] = None,
        name: str = None,
    ):
        # The tag.
        self.labels = labels
        # The version number.
        self.name = name

    def validate(self):
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = GetGatewayServiceDetailResponseBodyDataVersionDetailsServiceVersionLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetGatewayServiceDetailResponseBodyDataVersionDetails(TeaModel):
    def __init__(
        self,
        endpoint_num: int = None,
        endpoint_num_percent: str = None,
        service_version: GetGatewayServiceDetailResponseBodyDataVersionDetailsServiceVersion = None,
    ):
        # The number of instances.
        self.endpoint_num = endpoint_num
        # The percentage of instances.
        self.endpoint_num_percent = endpoint_num_percent
        # The version of the service.
        self.service_version = service_version

    def validate(self):
        if self.service_version:
            self.service_version.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.endpoint_num is not None:
            result['EndpointNum'] = self.endpoint_num
        if self.endpoint_num_percent is not None:
            result['EndpointNumPercent'] = self.endpoint_num_percent
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndpointNum') is not None:
            self.endpoint_num = m.get('EndpointNum')
        if m.get('EndpointNumPercent') is not None:
            self.endpoint_num_percent = m.get('EndpointNumPercent')
        if m.get('ServiceVersion') is not None:
            temp_model = GetGatewayServiceDetailResponseBodyDataVersionDetailsServiceVersion()
            self.service_version = temp_model.from_map(m['ServiceVersion'])
        return self


class GetGatewayServiceDetailResponseBodyDataVersions(TeaModel):
    def __init__(
        self,
        label: str = None,
        type: str = None,
        value: str = None,
    ):
        # The tag.
        self.label = label
        # The type.
        self.type = type
        # The key of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetGatewayServiceDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        gateway_id: int = None,
        gateway_traffic_policy: TrafficPolicy = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        group_name: str = None,
        health_check: str = None,
        health_status: str = None,
        id: int = None,
        ips: List[str] = None,
        label_details: List[GetGatewayServiceDetailResponseBodyDataLabelDetails] = None,
        meta_info: str = None,
        name: str = None,
        namespace: str = None,
        port_traffic_policy_list: List[GetGatewayServiceDetailResponseBodyDataPortTrafficPolicyList] = None,
        ports: List[int] = None,
        service_name_in_registry: str = None,
        service_protocol: str = None,
        source_id: int = None,
        source_type: str = None,
        version_details: List[GetGatewayServiceDetailResponseBodyDataVersionDetails] = None,
        versions: List[GetGatewayServiceDetailResponseBodyDataVersions] = None,
    ):
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The traffic policy of the service.
        self.gateway_traffic_policy = gateway_traffic_policy
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The creation time.
        self.gmt_create = gmt_create
        # The last modification time.
        self.gmt_modified = gmt_modified
        # The name of the group.
        self.group_name = group_name
        # Indicates whether the health check is enabled.
        self.health_check = health_check
        # The status of the health check. Valid values:
        self.health_status = health_status
        # The ID of the service.
        self.id = id
        # The IP address of the service.
        self.ips = ips
        # The details of the tag.
        self.label_details = label_details
        # The basic information about the service.
        self.meta_info = meta_info
        # The name of the service.
        self.name = name
        # The namespace.
        self.namespace = namespace
        # The traffic policy of service ports.
        self.port_traffic_policy_list = port_traffic_policy_list
        # The array of service ports.
        self.ports = ports
        # The name of the service registered with the service registry.
        self.service_name_in_registry = service_name_in_registry
        # The protocol of the service.
        self.service_protocol = service_protocol
        # The ID of the service source.
        self.source_id = source_id
        # The source type of the service.
        self.source_type = source_type
        # The details of versions.
        self.version_details = version_details
        # The version of the service.
        self.versions = versions

    def validate(self):
        if self.gateway_traffic_policy:
            self.gateway_traffic_policy.validate()
        if self.label_details:
            for k in self.label_details:
                if k:
                    k.validate()
        if self.port_traffic_policy_list:
            for k in self.port_traffic_policy_list:
                if k:
                    k.validate()
        if self.version_details:
            for k in self.version_details:
                if k:
                    k.validate()
        if self.versions:
            for k in self.versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_traffic_policy is not None:
            result['GatewayTrafficPolicy'] = self.gateway_traffic_policy.to_map()
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.health_check is not None:
            result['HealthCheck'] = self.health_check
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.id is not None:
            result['Id'] = self.id
        if self.ips is not None:
            result['Ips'] = self.ips
        result['LabelDetails'] = []
        if self.label_details is not None:
            for k in self.label_details:
                result['LabelDetails'].append(k.to_map() if k else None)
        if self.meta_info is not None:
            result['MetaInfo'] = self.meta_info
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        result['PortTrafficPolicyList'] = []
        if self.port_traffic_policy_list is not None:
            for k in self.port_traffic_policy_list:
                result['PortTrafficPolicyList'].append(k.to_map() if k else None)
        if self.ports is not None:
            result['Ports'] = self.ports
        if self.service_name_in_registry is not None:
            result['ServiceNameInRegistry'] = self.service_name_in_registry
        if self.service_protocol is not None:
            result['ServiceProtocol'] = self.service_protocol
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        result['VersionDetails'] = []
        if self.version_details is not None:
            for k in self.version_details:
                result['VersionDetails'].append(k.to_map() if k else None)
        result['Versions'] = []
        if self.versions is not None:
            for k in self.versions:
                result['Versions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayTrafficPolicy') is not None:
            temp_model = TrafficPolicy()
            self.gateway_traffic_policy = temp_model.from_map(m['GatewayTrafficPolicy'])
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HealthCheck') is not None:
            self.health_check = m.get('HealthCheck')
        if m.get('HealthStatus') is not None:
            self.health_status = m.get('HealthStatus')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Ips') is not None:
            self.ips = m.get('Ips')
        self.label_details = []
        if m.get('LabelDetails') is not None:
            for k in m.get('LabelDetails'):
                temp_model = GetGatewayServiceDetailResponseBodyDataLabelDetails()
                self.label_details.append(temp_model.from_map(k))
        if m.get('MetaInfo') is not None:
            self.meta_info = m.get('MetaInfo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        self.port_traffic_policy_list = []
        if m.get('PortTrafficPolicyList') is not None:
            for k in m.get('PortTrafficPolicyList'):
                temp_model = GetGatewayServiceDetailResponseBodyDataPortTrafficPolicyList()
                self.port_traffic_policy_list.append(temp_model.from_map(k))
        if m.get('Ports') is not None:
            self.ports = m.get('Ports')
        if m.get('ServiceNameInRegistry') is not None:
            self.service_name_in_registry = m.get('ServiceNameInRegistry')
        if m.get('ServiceProtocol') is not None:
            self.service_protocol = m.get('ServiceProtocol')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        self.version_details = []
        if m.get('VersionDetails') is not None:
            for k in m.get('VersionDetails'):
                temp_model = GetGatewayServiceDetailResponseBodyDataVersionDetails()
                self.version_details.append(temp_model.from_map(k))
        self.versions = []
        if m.get('Versions') is not None:
            for k in m.get('Versions'):
                temp_model = GetGatewayServiceDetailResponseBodyDataVersions()
                self.versions.append(temp_model.from_map(k))
        return self


class GetGatewayServiceDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetGatewayServiceDetailResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetGatewayServiceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetGatewayServiceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetGatewayServiceDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGatewayServiceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGovernanceKubernetesClusterRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        region_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the instance.
        self.cluster_id = cluster_id
        # The ID of the region in which the instance resides. The region is supported by MSE.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetGovernanceKubernetesClusterResponseBodyDataNamespaces(TeaModel):
    def __init__(
        self,
        name: str = None,
        tags: str = None,
    ):
        # The name.
        self.name = name
        # The tags.
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class GetGovernanceKubernetesClusterResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        k_8s_version: str = None,
        namespace_infos: str = None,
        namespaces: List[GetGovernanceKubernetesClusterResponseBodyDataNamespaces] = None,
        pilot_start_time: str = None,
        region: str = None,
        update_time: str = None,
    ):
        # The ID of the instance.
        self.cluster_id = cluster_id
        # The name of the instance.
        self.cluster_name = cluster_name
        # The version of Kubernetes.
        self.k_8s_version = k_8s_version
        # The information of the namespace.
        self.namespace_infos = namespace_infos
        # The list of namespaces.
        self.namespaces = namespaces
        # The time when the ack-onepilot component was started.
        self.pilot_start_time = pilot_start_time
        # The ID of the region in which the instance resides. The region is supported by MSE.
        self.region = region
        # The time of the last modification.
        self.update_time = update_time

    def validate(self):
        if self.namespaces:
            for k in self.namespaces:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.k_8s_version is not None:
            result['K8sVersion'] = self.k_8s_version
        if self.namespace_infos is not None:
            result['NamespaceInfos'] = self.namespace_infos
        result['Namespaces'] = []
        if self.namespaces is not None:
            for k in self.namespaces:
                result['Namespaces'].append(k.to_map() if k else None)
        if self.pilot_start_time is not None:
            result['PilotStartTime'] = self.pilot_start_time
        if self.region is not None:
            result['Region'] = self.region
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('K8sVersion') is not None:
            self.k_8s_version = m.get('K8sVersion')
        if m.get('NamespaceInfos') is not None:
            self.namespace_infos = m.get('NamespaceInfos')
        self.namespaces = []
        if m.get('Namespaces') is not None:
            for k in m.get('Namespaces'):
                temp_model = GetGovernanceKubernetesClusterResponseBodyDataNamespaces()
                self.namespaces.append(temp_model.from_map(k))
        if m.get('PilotStartTime') is not None:
            self.pilot_start_time = m.get('PilotStartTime')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetGovernanceKubernetesClusterResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetGovernanceKubernetesClusterResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetGovernanceKubernetesClusterResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetGovernanceKubernetesClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetGovernanceKubernetesClusterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGovernanceKubernetesClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetImageRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        version_code: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The version number of the current instance.
        self.version_code = version_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        return self


class GetImageResponseBodyData(TeaModel):
    def __init__(
        self,
        current_version_full_show_name: str = None,
        max_version_changelog_url: str = None,
        max_version_code: str = None,
        max_version_full_show_name: str = None,
    ):
        # The full version number of the current instance image. The parameter is in the X.X.X.X format.
        self.current_version_full_show_name = current_version_full_show_name
        # The URL of the changelog for the maximum version to which the current version can be upgraded.
        self.max_version_changelog_url = max_version_changelog_url
        # The code of the maximum version to which the current version can be upgraded.
        self.max_version_code = max_version_code
        # The full number of the maximum version to which the current version can be upgraded.
        self.max_version_full_show_name = max_version_full_show_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_version_full_show_name is not None:
            result['CurrentVersionFullShowName'] = self.current_version_full_show_name
        if self.max_version_changelog_url is not None:
            result['MaxVersionChangelogUrl'] = self.max_version_changelog_url
        if self.max_version_code is not None:
            result['MaxVersionCode'] = self.max_version_code
        if self.max_version_full_show_name is not None:
            result['MaxVersionFullShowName'] = self.max_version_full_show_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentVersionFullShowName') is not None:
            self.current_version_full_show_name = m.get('CurrentVersionFullShowName')
        if m.get('MaxVersionChangelogUrl') is not None:
            self.max_version_changelog_url = m.get('MaxVersionChangelogUrl')
        if m.get('MaxVersionCode') is not None:
            self.max_version_code = m.get('MaxVersionCode')
        if m.get('MaxVersionFullShowName') is not None:
            self.max_version_full_show_name = m.get('MaxVersionFullShowName')
        return self


class GetImageResponseBody(TeaModel):
    def __init__(
        self,
        data: GetImageResponseBodyData = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetImageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetImportFileUrlRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        content_type: str = None,
        instance_id: str = None,
        namespace_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The type of the file.
        self.content_type = content_type
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class GetImportFileUrlResponseBodyData(TeaModel):
    def __init__(
        self,
        url: str = None,
    ):
        # The URL that is used to upload the configuration file.
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetImportFileUrlResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetImportFileUrlResponseBodyData = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message. This parameter is used to replace the \*\*%s\*\* variable in the **ErrMessage** parameter.
        # 
        # > If the return value of the **ErrMessage** parameter is **The Value of Input Parameter %s is not valid** and the return value of the **DynamicMessage** parameter is **DtsJobId**, the specified **DtsJobId** parameter is invalid.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetImportFileUrlResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetImportFileUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetImportFileUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetImportFileUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetKubernetesSourceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        vpc_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the virtual private cloud (VPC).
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class GetKubernetesSourceResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster: str = None,
        name: str = None,
    ):
        # The ID of the ACK cluster.
        self.cluster = cluster
        # The name of the ACK cluster.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster is not None:
            result['Cluster'] = self.cluster
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cluster') is not None:
            self.cluster = m.get('Cluster')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetKubernetesSourceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[GetKubernetesSourceResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data structure.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetKubernetesSourceResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetKubernetesSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetKubernetesSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetKubernetesSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMseFeatureSwitchRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        return self


class GetMseFeatureSwitchResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        result: Dict[str, Any] = None,
        success: bool = None,
    ):
        # The error code returned if the request failed.
        self.error_code = error_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # The returned result.
        self.result = result
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMseFeatureSwitchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMseFeatureSwitchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMseFeatureSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMseSourceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        type: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The MSE engine type. Valid values:
        # 
        # *   NACOS
        # *   ZOOKEEPER
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetMseSourceResponseBodyData(TeaModel):
    def __init__(
        self,
        address: str = None,
        cluster_id: str = None,
        instance_id: str = None,
        name: str = None,
        type: str = None,
    ):
        # The endpoint of the instance.
        self.address = address
        # The ID of the instance.
        self.cluster_id = cluster_id
        # The ID of the instance.
        self.instance_id = instance_id
        # The name.
        self.name = name
        # The type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetMseSourceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[GetMseSourceResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The data structure.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        # 
        # *   If the request is successful, a success message is returned.
        # *   If the request fails, an error message is returned, such as the "TaskId not found" message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetMseSourceResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMseSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMseSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMseSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNacosConfigRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        beta: bool = None,
        data_id: str = None,
        group: str = None,
        instance_id: str = None,
        namespace_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # Specifies whether to perform a beta release. Valid values:
        # 
        # *   `true`: yes
        # *   `false`: no
        self.beta = beta
        # The ID of the data.
        self.data_id = data_id
        # The name of the configuration group.
        self.group = group
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.beta is not None:
            result['Beta'] = self.beta
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.group is not None:
            result['Group'] = self.group
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Beta') is not None:
            self.beta = m.get('Beta')
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class GetNacosConfigResponseBodyConfiguration(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        beta_ips: str = None,
        content: str = None,
        data_id: str = None,
        desc: str = None,
        encrypted_data_key: str = None,
        group: str = None,
        md_5: str = None,
        tags: str = None,
        type: str = None,
    ):
        # The name of the application.
        self.app_name = app_name
        # The list of IP addresses where the beta release of the configuration is performed.
        self.beta_ips = beta_ips
        # The content of the configuration.
        self.content = content
        # The ID of the configuration.
        self.data_id = data_id
        # The description of the configuration.
        self.desc = desc
        # The encryption key.
        self.encrypted_data_key = encrypted_data_key
        # The name of the configuration group.
        self.group = group
        # The MD5 value of the configuration.
        self.md_5 = md_5
        # The tags of the configuration.
        self.tags = tags
        # The format of the configuration.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.beta_ips is not None:
            result['BetaIps'] = self.beta_ips
        if self.content is not None:
            result['Content'] = self.content
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.encrypted_data_key is not None:
            result['EncryptedDataKey'] = self.encrypted_data_key
        if self.group is not None:
            result['Group'] = self.group
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BetaIps') is not None:
            self.beta_ips = m.get('BetaIps')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('EncryptedDataKey') is not None:
            self.encrypted_data_key = m.get('EncryptedDataKey')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetNacosConfigResponseBody(TeaModel):
    def __init__(
        self,
        configuration: GetNacosConfigResponseBodyConfiguration = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The configuration information.
        self.configuration = configuration
        # The error code returned if the request failed.
        self.error_code = error_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.configuration:
            self.configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Configuration') is not None:
            temp_model = GetNacosConfigResponseBodyConfiguration()
            self.configuration = temp_model.from_map(m['Configuration'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNacosConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetNacosConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetNacosConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNacosHistoryConfigRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        data_id: str = None,
        group: str = None,
        instance_id: str = None,
        namespace_id: str = None,
        nid: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the data.
        self.data_id = data_id
        # The group.
        self.group = group
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The version ID of the configuration.
        self.nid = nid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.group is not None:
            result['Group'] = self.group
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.nid is not None:
            result['Nid'] = self.nid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Nid') is not None:
            self.nid = m.get('Nid')
        return self


class GetNacosHistoryConfigResponseBodyConfiguration(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        content: str = None,
        data_id: str = None,
        encrypted_data_key: str = None,
        group: str = None,
        md_5: str = None,
        op_type: str = None,
    ):
        # The name of the application.
        self.app_name = app_name
        # The content of the configuration.
        self.content = content
        # The ID of the configuration.
        self.data_id = data_id
        # The encryption key.
        self.encrypted_data_key = encrypted_data_key
        # The name of the configuration group.
        self.group = group
        # The MD5 value of the configuration.
        self.md_5 = md_5
        # The configuration type.
        self.op_type = op_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.content is not None:
            result['Content'] = self.content
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.encrypted_data_key is not None:
            result['EncryptedDataKey'] = self.encrypted_data_key
        if self.group is not None:
            result['Group'] = self.group
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.op_type is not None:
            result['OpType'] = self.op_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('EncryptedDataKey') is not None:
            self.encrypted_data_key = m.get('EncryptedDataKey')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('OpType') is not None:
            self.op_type = m.get('OpType')
        return self


class GetNacosHistoryConfigResponseBody(TeaModel):
    def __init__(
        self,
        configuration: GetNacosHistoryConfigResponseBodyConfiguration = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The configuration information.
        self.configuration = configuration
        # The error code returned if the request failed.
        self.error_code = error_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.configuration:
            self.configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Configuration') is not None:
            temp_model = GetNacosHistoryConfigResponseBodyConfiguration()
            self.configuration = temp_model.from_map(m['Configuration'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNacosHistoryConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetNacosHistoryConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetNacosHistoryConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOverviewRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        period: int = None,
        region: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The subscription period of the instance. Unit: months. Valid values: 1, 2, 3, 6, and 12.
        self.period = period
        # The region ID.
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.period is not None:
            result['Period'] = self.period
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class GetOverviewResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The status code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetOverviewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOverviewResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOverviewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPluginConfigRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        plugin_id: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # zh: Chinese en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the gateway plug-in.
        self.plugin_id = plugin_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.plugin_id is not None:
            result['PluginId'] = self.plugin_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('PluginId') is not None:
            self.plugin_id = m.get('PluginId')
        return self


class GetPluginConfigResponseBodyDataGatewayConfigList(TeaModel):
    def __init__(
        self,
        config: str = None,
        config_level: int = None,
        enable: bool = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        plugin_id: int = None,
    ):
        # The plug-in configuration.
        self.config = config
        # The application scope of the plug-in.
        # 
        # 0: global
        # 
        # 1: domain names
        # 
        # 2: routes
        self.config_level = config_level
        # Indicates whether the plug-in is enabled.
        self.enable = enable
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The creation time.
        self.gmt_create = gmt_create
        # The update time.
        self.gmt_modified = gmt_modified
        # The ID of the plug-in configuration.
        self.id = id
        # The ID of the gateway plug-in.
        self.plugin_id = plugin_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.config_level is not None:
            result['ConfigLevel'] = self.config_level
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.plugin_id is not None:
            result['PluginId'] = self.plugin_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('ConfigLevel') is not None:
            self.config_level = m.get('ConfigLevel')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PluginId') is not None:
            self.plugin_id = m.get('PluginId')
        return self


class GetPluginConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        category: int = None,
        config_check: str = None,
        gateway_config_list: List[GetPluginConfigResponseBodyDataGatewayConfigList] = None,
        id: int = None,
        image_name: str = None,
        mode: int = None,
        name: str = None,
        phase: int = None,
        primary_user: str = None,
        priority: int = None,
        publish_state: int = None,
        readme: str = None,
        readme_en: str = None,
        status: str = None,
        summary: str = None,
        type: int = None,
        version: str = None,
        version_json: str = None,
        wasm_lang: int = None,
    ):
        # The category of the plug-in.
        # 
        # 0: custom
        # 
        # 1: permission authorization
        # 
        # 2: security protection
        # 
        # 3: transmission protocol
        # 
        # 4: traffic control
        # 
        # 5: traffic observation
        self.category = category
        # The information about the plug-in configuration used for checking.
        self.config_check = config_check
        # The list of gateway plug-in configurations.
        self.gateway_config_list = gateway_config_list
        # The ID of the plug-in.
        self.id = id
        # The name of the image.
        self.image_name = image_name
        # The mode.
        self.mode = mode
        # The name of the plug-in.
        self.name = name
        # The execution stage of the plug-in.
        # 
        # 0: default stage
        # 
        # 1: authorization stage
        # 
        # 2: authentication stage
        # 
        # 3: statistics stage
        self.phase = phase
        # The ID of the creator.
        self.primary_user = primary_user
        # The execution priority of the plug-in. A larger value indicates a higher priority.
        self.priority = priority
        # The publish status.
        self.publish_state = publish_state
        # The description of the README file.
        self.readme = readme
        # The description of the README file that is edited in English.
        self.readme_en = readme_en
        # Indicates whether the plug-in is enabled.
        # 
        # 0: disabled
        # 
        # 1: enabled
        self.status = status
        # The summary of the plug-in.
        self.summary = summary
        # The type.
        self.type = type
        # The version of the plug-in.
        self.version = version
        self.version_json = version_json
        # The WebAssembly language.
        # 
        # 0: C++\
        # 
        # 1: TinyGo
        # 
        # 2: Rust
        # 
        # 3: AssemblyScript
        # 
        # 4: Zig
        self.wasm_lang = wasm_lang

    def validate(self):
        if self.gateway_config_list:
            for k in self.gateway_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.config_check is not None:
            result['ConfigCheck'] = self.config_check
        result['GatewayConfigList'] = []
        if self.gateway_config_list is not None:
            for k in self.gateway_config_list:
                result['GatewayConfigList'].append(k.to_map() if k else None)
        if self.id is not None:
            result['Id'] = self.id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.name is not None:
            result['Name'] = self.name
        if self.phase is not None:
            result['Phase'] = self.phase
        if self.primary_user is not None:
            result['PrimaryUser'] = self.primary_user
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.publish_state is not None:
            result['PublishState'] = self.publish_state
        if self.readme is not None:
            result['Readme'] = self.readme
        if self.readme_en is not None:
            result['ReadmeEn'] = self.readme_en
        if self.status is not None:
            result['Status'] = self.status
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.type is not None:
            result['Type'] = self.type
        if self.version is not None:
            result['Version'] = self.version
        if self.version_json is not None:
            result['VersionJson'] = self.version_json
        if self.wasm_lang is not None:
            result['WasmLang'] = self.wasm_lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ConfigCheck') is not None:
            self.config_check = m.get('ConfigCheck')
        self.gateway_config_list = []
        if m.get('GatewayConfigList') is not None:
            for k in m.get('GatewayConfigList'):
                temp_model = GetPluginConfigResponseBodyDataGatewayConfigList()
                self.gateway_config_list.append(temp_model.from_map(k))
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Phase') is not None:
            self.phase = m.get('Phase')
        if m.get('PrimaryUser') is not None:
            self.primary_user = m.get('PrimaryUser')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('PublishState') is not None:
            self.publish_state = m.get('PublishState')
        if m.get('Readme') is not None:
            self.readme = m.get('Readme')
        if m.get('ReadmeEn') is not None:
            self.readme_en = m.get('ReadmeEn')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VersionJson') is not None:
            self.version_json = m.get('VersionJson')
        if m.get('WasmLang') is not None:
            self.wasm_lang = m.get('WasmLang')
        return self


class GetPluginConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetPluginConfigResponseBodyData = None,
        dynamic_code: str = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Code.
        self.code = code
        # The returned data.
        self.data = data
        # The dynamic error code.
        self.dynamic_code = dynamic_code
        # The dynamic error message.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.dynamic_code is not None:
            result['DynamicCode'] = self.dynamic_code
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetPluginConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('DynamicCode') is not None:
            self.dynamic_code = m.get('DynamicCode')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetPluginConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPluginConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPluginConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPluginsRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        category: int = None,
        enable_only: bool = None,
        gateway_unique_id: str = None,
        name: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # zh: Chinese en: English
        self.accept_language = accept_language
        # The type of the plug-in. Valid values:
        # 
        # *   0: custom
        # *   1: permission authorization
        # *   2: security protection
        # *   3: transmission protocol
        # *   4: traffic control
        # *   5: traffic observation
        self.category = category
        # Specifies whether to enable the plug-in.
        self.enable_only = enable_only
        # The ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The name of the plug-in.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.category is not None:
            result['Category'] = self.category
        if self.enable_only is not None:
            result['EnableOnly'] = self.enable_only
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('EnableOnly') is not None:
            self.enable_only = m.get('EnableOnly')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetPluginsResponseBodyData(TeaModel):
    def __init__(
        self,
        category: int = None,
        config_check: str = None,
        id: int = None,
        max_version: str = None,
        mode: int = None,
        name: str = None,
        new_version_publishing_flag: bool = None,
        phase: int = None,
        primary_user: str = None,
        priority: int = None,
        publish_state: int = None,
        status: str = None,
        summary: str = None,
        version: str = None,
        wasm_file: str = None,
        wasm_lang: int = None,
    ):
        # The type of the plug-in. Valid values:
        # 
        # 0: custom
        # 
        # 1: permission authorization
        # 
        # 2: security protection
        # 
        # 3: transmission protocol
        # 
        # 4: traffic control
        # 
        # 5: traffic observation
        self.category = category
        # The information about the plug-in configuration used for checking.
        self.config_check = config_check
        # The ID of the plug-in.
        self.id = id
        self.max_version = max_version
        self.mode = mode
        # The name of the plug-in.
        self.name = name
        self.new_version_publishing_flag = new_version_publishing_flag
        # The execution stage of the plug-in.
        # 
        # *   0: default stage
        # *   1: authorization stage
        # *   2: authentication stage
        # *   3: statistics stage
        self.phase = phase
        # The ID of the creator.
        self.primary_user = primary_user
        # The execution priority of the plug-in. A larger value indicates a higher priority.
        self.priority = priority
        # The publish status.
        self.publish_state = publish_state
        # Indicates whether the plug-in is enabled.
        # 
        # *   0: disabled
        # *   1: enabled
        self.status = status
        # The summary of the plug-in.
        self.summary = summary
        # The version of the plug-in.
        self.version = version
        # The URL of the Object Storage Service (OSS) bucket that stores the WebAssembly plug-in.
        self.wasm_file = wasm_file
        # The WebAssembly language. Valid values:
        # 
        # *   0: C++\
        # *   1: TinyGo
        # *   2: Rust
        # *   3: AssemblyScript
        # *   4: Zig
        self.wasm_lang = wasm_lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.config_check is not None:
            result['ConfigCheck'] = self.config_check
        if self.id is not None:
            result['Id'] = self.id
        if self.max_version is not None:
            result['MaxVersion'] = self.max_version
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.name is not None:
            result['Name'] = self.name
        if self.new_version_publishing_flag is not None:
            result['NewVersionPublishingFlag'] = self.new_version_publishing_flag
        if self.phase is not None:
            result['Phase'] = self.phase
        if self.primary_user is not None:
            result['PrimaryUser'] = self.primary_user
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.publish_state is not None:
            result['PublishState'] = self.publish_state
        if self.status is not None:
            result['Status'] = self.status
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.version is not None:
            result['Version'] = self.version
        if self.wasm_file is not None:
            result['WasmFile'] = self.wasm_file
        if self.wasm_lang is not None:
            result['WasmLang'] = self.wasm_lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ConfigCheck') is not None:
            self.config_check = m.get('ConfigCheck')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MaxVersion') is not None:
            self.max_version = m.get('MaxVersion')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NewVersionPublishingFlag') is not None:
            self.new_version_publishing_flag = m.get('NewVersionPublishingFlag')
        if m.get('Phase') is not None:
            self.phase = m.get('Phase')
        if m.get('PrimaryUser') is not None:
            self.primary_user = m.get('PrimaryUser')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('PublishState') is not None:
            self.publish_state = m.get('PublishState')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('WasmFile') is not None:
            self.wasm_file = m.get('WasmFile')
        if m.get('WasmLang') is not None:
            self.wasm_lang = m.get('WasmLang')
        return self


class GetPluginsResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[GetPluginsResponseBodyData] = None,
        dynamic_code: str = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # Code.
        self.code = code
        # The data entries returned.
        self.data = data
        # The dynamic part in the error message.
        self.dynamic_code = dynamic_code
        # The dynamic error message.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.dynamic_code is not None:
            result['DynamicCode'] = self.dynamic_code
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetPluginsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('DynamicCode') is not None:
            self.dynamic_code = m.get('DynamicCode')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetPluginsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPluginsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPluginsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetServiceListRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_id: str = None,
        ip: str = None,
        region: str = None,
        service_name: str = None,
        service_type: str = None,
    ):
        # The language of the response.
        self.accept_language = accept_language
        # The ID of the application.
        self.app_id = app_id
        # The IP address.
        self.ip = ip
        # The ID of the region.
        self.region = region
        # The name of the service.
        self.service_name = service_name
        # The type of the framework.
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.region is not None:
            result['Region'] = self.region
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        return self


class GetServiceListResponseBodyDataMethods(TeaModel):
    def __init__(
        self,
        method_controller: str = None,
        name: str = None,
        parameter_types: List[str] = None,
        paths: List[str] = None,
        request_methods: List[str] = None,
        return_type: str = None,
    ):
        # The controller of the method.
        self.method_controller = method_controller
        # The name of the method.
        self.name = name
        # The data types of the parameters.
        self.parameter_types = parameter_types
        # The paths.
        self.paths = paths
        # The methods.
        self.request_methods = request_methods
        # The type of the return value.
        self.return_type = return_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method_controller is not None:
            result['MethodController'] = self.method_controller
        if self.name is not None:
            result['Name'] = self.name
        if self.parameter_types is not None:
            result['ParameterTypes'] = self.parameter_types
        if self.paths is not None:
            result['Paths'] = self.paths
        if self.request_methods is not None:
            result['RequestMethods'] = self.request_methods
        if self.return_type is not None:
            result['ReturnType'] = self.return_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MethodController') is not None:
            self.method_controller = m.get('MethodController')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParameterTypes') is not None:
            self.parameter_types = m.get('ParameterTypes')
        if m.get('Paths') is not None:
            self.paths = m.get('Paths')
        if m.get('RequestMethods') is not None:
            self.request_methods = m.get('RequestMethods')
        if m.get('ReturnType') is not None:
            self.return_type = m.get('ReturnType')
        return self


class GetServiceListResponseBodyData(TeaModel):
    def __init__(
        self,
        dubbo_application_name: str = None,
        edas_app_name: str = None,
        group: str = None,
        metadata: Dict[str, Any] = None,
        methods: List[GetServiceListResponseBodyDataMethods] = None,
        registry_type: str = None,
        service_name: str = None,
        service_type: str = None,
        spring_application_name: str = None,
        version: str = None,
    ):
        # The name of the Dubbo application.
        self.dubbo_application_name = dubbo_application_name
        # The name of the application.
        self.edas_app_name = edas_app_name
        # The group.
        self.group = group
        # The metadata.
        self.metadata = metadata
        # The methods.
        self.methods = methods
        # The type of the service registry.
        self.registry_type = registry_type
        # The name of the service.
        self.service_name = service_name
        # The type of the service.
        self.service_type = service_type
        # The name of the Spring application.
        self.spring_application_name = spring_application_name
        # The version information.
        self.version = version

    def validate(self):
        if self.methods:
            for k in self.methods:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dubbo_application_name is not None:
            result['DubboApplicationName'] = self.dubbo_application_name
        if self.edas_app_name is not None:
            result['EdasAppName'] = self.edas_app_name
        if self.group is not None:
            result['Group'] = self.group
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        result['Methods'] = []
        if self.methods is not None:
            for k in self.methods:
                result['Methods'].append(k.to_map() if k else None)
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        if self.spring_application_name is not None:
            result['SpringApplicationName'] = self.spring_application_name
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DubboApplicationName') is not None:
            self.dubbo_application_name = m.get('DubboApplicationName')
        if m.get('EdasAppName') is not None:
            self.edas_app_name = m.get('EdasAppName')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        self.methods = []
        if m.get('Methods') is not None:
            for k in m.get('Methods'):
                temp_model = GetServiceListResponseBodyDataMethods()
                self.methods.append(temp_model.from_map(k))
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        if m.get('SpringApplicationName') is not None:
            self.spring_application_name = m.get('SpringApplicationName')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetServiceListResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[GetServiceListResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data entries returned.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetServiceListResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetServiceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetServiceListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetServiceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetServiceListenersRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        group_name: str = None,
        has_ip_count: str = None,
        instance_id: str = None,
        namespace_id: str = None,
        page_num: int = None,
        page_size: int = None,
        region_id: str = None,
        request_pars: str = None,
        service_name: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the MSE instance to which the service belongs.
        # 
        # > You must specify InstanceId or ClusterId.
        self.cluster_id = cluster_id
        # The name of the cluster to which the service belongs.
        # 
        # > The cluster is a concept for Nacos services and does not refer to a Microservices Engine (MSE) instance.
        self.cluster_name = cluster_name
        # The group to which the service belongs.
        self.group_name = group_name
        # A reserved parameter.
        self.has_ip_count = has_ip_count
        # The ID of the instance to which the service belongs.
        # 
        # > You must specify InstanceId or ClusterId.
        self.instance_id = instance_id
        # The namespace to which the service belongs.
        self.namespace_id = namespace_id
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The region ID.
        self.region_id = region_id
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars
        # The name of the service whose listeners you want to query.
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.has_ip_count is not None:
            result['HasIpCount'] = self.has_ip_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HasIpCount') is not None:
            self.has_ip_count = m.get('HasIpCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class GetServiceListenersResponseBodyData(TeaModel):
    def __init__(
        self,
        addr: str = None,
        agent: str = None,
        app: str = None,
        cluster: str = None,
        ip: str = None,
        namespace_id: str = None,
        port: str = None,
        service_name: str = None,
    ):
        # The address of the listener.
        self.addr = addr
        # The listener client version.
        self.agent = agent
        # The application name of the listener.
        self.app = app
        # The name of the cluster to which the monitored service belongs.
        self.cluster = cluster
        # The IP address of the monitored service.
        self.ip = ip
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The port number of the monitored service.
        self.port = port
        # The name of the monitored service.
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr is not None:
            result['Addr'] = self.addr
        if self.agent is not None:
            result['Agent'] = self.agent
        if self.app is not None:
            result['App'] = self.app
        if self.cluster is not None:
            result['Cluster'] = self.cluster
        if self.ip is not None:
            result['IP'] = self.ip
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.port is not None:
            result['Port'] = self.port
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addr') is not None:
            self.addr = m.get('Addr')
        if m.get('Agent') is not None:
            self.agent = m.get('Agent')
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Cluster') is not None:
            self.cluster = m.get('Cluster')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class GetServiceListenersResponseBody(TeaModel):
    def __init__(
        self,
        data: List[GetServiceListenersResponseBodyData] = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        # The returned data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        # 
        # *   If the request is successful, a success message is returned.
        # *   If the request fails, an error message is returned.
        self.message = message
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success
        # The number of listeners that are queried.
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetServiceListenersResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetServiceListenersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetServiceListenersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetServiceListenersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTagsBySwimmingLaneGroupIdRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        group_id: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the lane group.
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class GetTagsBySwimmingLaneGroupIdResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: Any = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code. A value of 200 is returned if the request is successful.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetTagsBySwimmingLaneGroupIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTagsBySwimmingLaneGroupIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTagsBySwimmingLaneGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetZookeeperDataImportUrlRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        content_type: str = None,
        instance_id: str = None,
    ):
        self.accept_language = accept_language
        self.content_type = content_type
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetZookeeperDataImportUrlResponseBodyData(TeaModel):
    def __init__(
        self,
        max_size: str = None,
        url: str = None,
    ):
        self.max_size = max_size
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_size is not None:
            result['MaxSize'] = self.max_size
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxSize') is not None:
            self.max_size = m.get('MaxSize')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetZookeeperDataImportUrlResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetZookeeperDataImportUrlResponseBodyData = None,
        dynamic_code: str = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.dynamic_code = dynamic_code
        self.dynamic_message = dynamic_message
        self.error_code = error_code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.dynamic_code is not None:
            result['DynamicCode'] = self.dynamic_code
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetZookeeperDataImportUrlResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('DynamicCode') is not None:
            self.dynamic_code = m.get('DynamicCode')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetZookeeperDataImportUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetZookeeperDataImportUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetZookeeperDataImportUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportNacosConfigRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        file_url: str = None,
        instance_id: str = None,
        namespace_id: str = None,
        policy: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The download URL of the configuration file.
        self.file_url = file_url
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The policy.
        self.policy = policy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.policy is not None:
            result['Policy'] = self.policy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        return self


class ImportNacosConfigResponseBodyDataFailData(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        group: str = None,
    ):
        # The ID of the data.
        self.data_id = data_id
        # The ID of the group.
        self.group = group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.group is not None:
            result['Group'] = self.group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        return self


class ImportNacosConfigResponseBodyDataSkipData(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        group: str = None,
    ):
        # The ID of the data.
        self.data_id = data_id
        # The ID of the group.
        self.group = group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.group is not None:
            result['Group'] = self.group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        return self


class ImportNacosConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        fail_data: List[ImportNacosConfigResponseBodyDataFailData] = None,
        skip_count: int = None,
        skip_data: List[ImportNacosConfigResponseBodyDataSkipData] = None,
        succ_count: int = None,
    ):
        # The information about configurations failed to be imported.
        self.fail_data = fail_data
        # The number of configurations that are skipped.
        self.skip_count = skip_count
        # The information about skipped configurations.
        self.skip_data = skip_data
        # The number of configurations that are imported.
        self.succ_count = succ_count

    def validate(self):
        if self.fail_data:
            for k in self.fail_data:
                if k:
                    k.validate()
        if self.skip_data:
            for k in self.skip_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailData'] = []
        if self.fail_data is not None:
            for k in self.fail_data:
                result['FailData'].append(k.to_map() if k else None)
        if self.skip_count is not None:
            result['SkipCount'] = self.skip_count
        result['SkipData'] = []
        if self.skip_data is not None:
            for k in self.skip_data:
                result['SkipData'].append(k.to_map() if k else None)
        if self.succ_count is not None:
            result['SuccCount'] = self.succ_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fail_data = []
        if m.get('FailData') is not None:
            for k in m.get('FailData'):
                temp_model = ImportNacosConfigResponseBodyDataFailData()
                self.fail_data.append(temp_model.from_map(k))
        if m.get('SkipCount') is not None:
            self.skip_count = m.get('SkipCount')
        self.skip_data = []
        if m.get('SkipData') is not None:
            for k in m.get('SkipData'):
                temp_model = ImportNacosConfigResponseBodyDataSkipData()
                self.skip_data.append(temp_model.from_map(k))
        if m.get('SuccCount') is not None:
            self.succ_count = m.get('SuccCount')
        return self


class ImportNacosConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ImportNacosConfigResponseBodyData = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message. This parameter is used to replace the \*\*%s\*\* variable in the **ErrMessage** parameter.
        # 
        # > If the return value of the **ErrMessage** parameter is **The Value of Input Parameter %s is not valid** and the return value of the **DynamicMessage** parameter is **DtsJobId**, the specified **DtsJobId** parameter is invalid.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ImportNacosConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ImportNacosConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ImportNacosConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportNacosConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportServicesRequestServiceList(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        ips: List[str] = None,
        name: str = None,
        namespace: str = None,
        service_port: int = None,
        service_protocol: str = None,
    ):
        # The group.
        self.group_name = group_name
        # The IP addresses of the service.
        self.ips = ips
        # The name of the service.
        self.name = name
        # The namespace.
        self.namespace = namespace
        # The port of the service.
        self.service_port = service_port
        # The protocol of the service.
        self.service_protocol = service_protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.ips is not None:
            result['Ips'] = self.ips
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.service_protocol is not None:
            result['ServiceProtocol'] = self.service_protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Ips') is not None:
            self.ips = m.get('Ips')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('ServiceProtocol') is not None:
            self.service_protocol = m.get('ServiceProtocol')
        return self


class ImportServicesRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        service_list: List[ImportServicesRequestServiceList] = None,
        source_type: str = None,
        tls_setting: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The information about services.
        self.service_list = service_list
        # The service source. Valid values:
        # 
        # *   MSE: MSE Nacos instance
        # *   K8s: ACK cluster
        # *   VIP: fixed address
        # *   DNS: DNS domain
        self.source_type = source_type
        # The Transport Layer Security (TLS) settings. Valid values:
        # 
        # *   mode: TLS mode
        # *   certId: certificate ID
        # *   caCertId: CA certificate ID
        # *   caCertContent: CA certificate public key
        # *   sni: service name identification
        self.tls_setting = tls_setting

    def validate(self):
        if self.service_list:
            for k in self.service_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        result['ServiceList'] = []
        if self.service_list is not None:
            for k in self.service_list:
                result['ServiceList'].append(k.to_map() if k else None)
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.tls_setting is not None:
            result['TlsSetting'] = self.tls_setting
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        self.service_list = []
        if m.get('ServiceList') is not None:
            for k in m.get('ServiceList'):
                temp_model = ImportServicesRequestServiceList()
                self.service_list.append(temp_model.from_map(k))
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('TlsSetting') is not None:
            self.tls_setting = m.get('TlsSetting')
        return self


class ImportServicesShrinkRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        service_list_shrink: str = None,
        source_type: str = None,
        tls_setting: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The information about services.
        self.service_list_shrink = service_list_shrink
        # The service source. Valid values:
        # 
        # *   MSE: MSE Nacos instance
        # *   K8s: ACK cluster
        # *   VIP: fixed address
        # *   DNS: DNS domain
        self.source_type = source_type
        # The Transport Layer Security (TLS) settings. Valid values:
        # 
        # *   mode: TLS mode
        # *   certId: certificate ID
        # *   caCertId: CA certificate ID
        # *   caCertContent: CA certificate public key
        # *   sni: service name identification
        self.tls_setting = tls_setting

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.service_list_shrink is not None:
            result['ServiceList'] = self.service_list_shrink
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.tls_setting is not None:
            result['TlsSetting'] = self.tls_setting
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('ServiceList') is not None:
            self.service_list_shrink = m.get('ServiceList')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('TlsSetting') is not None:
            self.tls_setting = m.get('TlsSetting')
        return self


class ImportServicesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The result returned.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ImportServicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ImportServicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportServicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportZookeeperDataRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        file_name: str = None,
        file_url: str = None,
        instance_id: str = None,
        region_id: str = None,
        request_pars: str = None,
    ):
        self.accept_language = accept_language
        self.file_name = file_name
        self.file_url = file_url
        self.instance_id = instance_id
        self.region_id = region_id
        self.request_pars = request_pars

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        return self


class ImportZookeeperDataResponseBody(TeaModel):
    def __init__(
        self,
        data: Any = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.error_code = error_code
        self.http_code = http_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ImportZookeeperDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ImportZookeeperDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ImportZookeeperDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAnsInstancesRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        group_name: str = None,
        instance_id: str = None,
        namespace_id: str = None,
        page_num: int = None,
        page_size: int = None,
        request_pars: str = None,
        service_name: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the cluster.
        # 
        # > This operation contains both the InstanceId and ClusterId parameters. You must specify one of them.
        self.cluster_id = cluster_id
        # The alias of the cluster.
        self.cluster_name = cluster_name
        # The name of the contact group.
        self.group_name = group_name
        # The ID of the instance.
        # 
        # >  This operation contains both the InstanceId and ClusterId parameters. You must specify one of them.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars
        # The name of the service.
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ListAnsInstancesResponseBodyData(TeaModel):
    def __init__(
        self,
        app: str = None,
        cluster_name: str = None,
        datum_key: str = None,
        default_key: str = None,
        enabled: bool = None,
        ephemeral: bool = None,
        fail_count: int = None,
        healthy: bool = None,
        instance_heart_beat_interval: int = None,
        instance_heart_beat_time_out: int = None,
        instance_id: str = None,
        ip: str = None,
        ip_delete_timeout: int = None,
        last_beat: int = None,
        marked: bool = None,
        metadata: Dict[str, Any] = None,
        ok_count: int = None,
        port: int = None,
        service_name: str = None,
        weight: int = None,
    ):
        # The name of the application.
        self.app = app
        # The name of the cluster.
        self.cluster_name = cluster_name
        # The reference key.
        self.datum_key = datum_key
        # The default key.
        self.default_key = default_key
        # The effective status of the instance. Valid values:
        # 
        # *   `true`: The instance takes effect.
        # *   `false`: The instance does not take effect.
        self.enabled = enabled
        # Indicates whether the information about the temporary node is obtained. Valid values:
        # 
        # *   `true`: yes
        # *   `false`: no
        self.ephemeral = ephemeral
        # The number of failed checks.
        self.fail_count = fail_count
        # The health status of the instance. Valid values:
        # 
        # *   `true`: The instance is healthy.
        # *   `false`: The instance is unhealthy.
        self.healthy = healthy
        # The heartbeat interval of the instance. Unit: seconds.
        self.instance_heart_beat_interval = instance_heart_beat_interval
        # The timeout period of the instance heartbeat.
        self.instance_heart_beat_time_out = instance_heart_beat_time_out
        # The ID of the instance.
        self.instance_id = instance_id
        # The public IP address.
        self.ip = ip
        # The timeout period for removing an IP address.
        self.ip_delete_timeout = ip_delete_timeout
        # The last heartbeat time.
        self.last_beat = last_beat
        # Indicates whether the instance was marked. Valid values:
        # 
        # *   `true`: The instance marking was successful.
        # *   `false`: The instance marking failed.
        self.marked = marked
        # The metadata.
        self.metadata = metadata
        # The number of successful checks.
        self.ok_count = ok_count
        # The port number.
        self.port = port
        # The name of the service.
        self.service_name = service_name
        # The weight.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.datum_key is not None:
            result['DatumKey'] = self.datum_key
        if self.default_key is not None:
            result['DefaultKey'] = self.default_key
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.ephemeral is not None:
            result['Ephemeral'] = self.ephemeral
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.healthy is not None:
            result['Healthy'] = self.healthy
        if self.instance_heart_beat_interval is not None:
            result['InstanceHeartBeatInterval'] = self.instance_heart_beat_interval
        if self.instance_heart_beat_time_out is not None:
            result['InstanceHeartBeatTimeOut'] = self.instance_heart_beat_time_out
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_delete_timeout is not None:
            result['IpDeleteTimeout'] = self.ip_delete_timeout
        if self.last_beat is not None:
            result['LastBeat'] = self.last_beat
        if self.marked is not None:
            result['Marked'] = self.marked
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        if self.ok_count is not None:
            result['OkCount'] = self.ok_count
        if self.port is not None:
            result['Port'] = self.port
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('DatumKey') is not None:
            self.datum_key = m.get('DatumKey')
        if m.get('DefaultKey') is not None:
            self.default_key = m.get('DefaultKey')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('Ephemeral') is not None:
            self.ephemeral = m.get('Ephemeral')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('Healthy') is not None:
            self.healthy = m.get('Healthy')
        if m.get('InstanceHeartBeatInterval') is not None:
            self.instance_heart_beat_interval = m.get('InstanceHeartBeatInterval')
        if m.get('InstanceHeartBeatTimeOut') is not None:
            self.instance_heart_beat_time_out = m.get('InstanceHeartBeatTimeOut')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpDeleteTimeout') is not None:
            self.ip_delete_timeout = m.get('IpDeleteTimeout')
        if m.get('LastBeat') is not None:
            self.last_beat = m.get('LastBeat')
        if m.get('Marked') is not None:
            self.marked = m.get('Marked')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        if m.get('OkCount') is not None:
            self.ok_count = m.get('OkCount')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class ListAnsInstancesResponseBody(TeaModel):
    def __init__(
        self,
        data: List[ListAnsInstancesResponseBodyData] = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success
        # The total number of returned instances.
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAnsInstancesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAnsInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAnsInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAnsInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAnsServiceClustersRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        group_name: str = None,
        instance_id: str = None,
        namespace_id: str = None,
        page_num: int = None,
        page_size: int = None,
        request_pars: str = None,
        service_name: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the MSE cluster.
        # 
        # > The MSE cluster is different from the cluster of the Nacos service.
        self.cluster_id = cluster_id
        # The alias of the cluster.
        self.cluster_name = cluster_name
        # The name of the group.
        self.group_name = group_name
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars
        # The name of the service.
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ListAnsServiceClustersResponseBodyDataClusters(TeaModel):
    def __init__(
        self,
        default_check_port: int = None,
        default_port: int = None,
        health_checker_type: str = None,
        metadata: Dict[str, Any] = None,
        name: str = None,
        service_name: str = None,
        use_ipport_4check: bool = None,
    ):
        # The default port used for a health check.
        self.default_check_port = default_check_port
        # The default port.
        self.default_port = default_port
        # The type of health checks.
        self.health_checker_type = health_checker_type
        # The metadata of the cluster.
        self.metadata = metadata
        # The name of the cluster.
        self.name = name
        # The complete name of the service.
        self.service_name = service_name
        # Indicates whether the health check is initiated by the server. This parameter is valid only when the service is a temporary service.
        self.use_ipport_4check = use_ipport_4check

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_check_port is not None:
            result['DefaultCheckPort'] = self.default_check_port
        if self.default_port is not None:
            result['DefaultPort'] = self.default_port
        if self.health_checker_type is not None:
            result['HealthCheckerType'] = self.health_checker_type
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        if self.name is not None:
            result['Name'] = self.name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.use_ipport_4check is not None:
            result['UseIPPort4Check'] = self.use_ipport_4check
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultCheckPort') is not None:
            self.default_check_port = m.get('DefaultCheckPort')
        if m.get('DefaultPort') is not None:
            self.default_port = m.get('DefaultPort')
        if m.get('HealthCheckerType') is not None:
            self.health_checker_type = m.get('HealthCheckerType')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('UseIPPort4Check') is not None:
            self.use_ipport_4check = m.get('UseIPPort4Check')
        return self


class ListAnsServiceClustersResponseBodyData(TeaModel):
    def __init__(
        self,
        clusters: List[ListAnsServiceClustersResponseBodyDataClusters] = None,
        ephemeral: bool = None,
        group_name: str = None,
        metadata: Dict[str, Any] = None,
        name: str = None,
        protect_threshold: float = None,
        selector_type: str = None,
    ):
        # The information about the clusters.
        self.clusters = clusters
        # Indicates whether the service is a temporary service. Valid values:
        # 
        # *   `true`: The service is a temporary service.
        # *   `false`: The service is not a temporary service.
        self.ephemeral = ephemeral
        # The name of the contact group.
        self.group_name = group_name
        # The metadata of the service.
        self.metadata = metadata
        # The name of the service.
        self.name = name
        # The protection threshold.
        self.protect_threshold = protect_threshold
        # The election mode.
        self.selector_type = selector_type

    def validate(self):
        if self.clusters:
            for k in self.clusters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clusters'] = []
        if self.clusters is not None:
            for k in self.clusters:
                result['Clusters'].append(k.to_map() if k else None)
        if self.ephemeral is not None:
            result['Ephemeral'] = self.ephemeral
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        if self.name is not None:
            result['Name'] = self.name
        if self.protect_threshold is not None:
            result['ProtectThreshold'] = self.protect_threshold
        if self.selector_type is not None:
            result['SelectorType'] = self.selector_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clusters = []
        if m.get('Clusters') is not None:
            for k in m.get('Clusters'):
                temp_model = ListAnsServiceClustersResponseBodyDataClusters()
                self.clusters.append(temp_model.from_map(k))
        if m.get('Ephemeral') is not None:
            self.ephemeral = m.get('Ephemeral')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProtectThreshold') is not None:
            self.protect_threshold = m.get('ProtectThreshold')
        if m.get('SelectorType') is not None:
            self.selector_type = m.get('SelectorType')
        return self


class ListAnsServiceClustersResponseBody(TeaModel):
    def __init__(
        self,
        data: ListAnsServiceClustersResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = ListAnsServiceClustersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAnsServiceClustersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAnsServiceClustersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAnsServiceClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAnsServicesRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        group_name: str = None,
        has_ip_count: str = None,
        instance_id: str = None,
        namespace_id: str = None,
        page_num: int = None,
        page_size: int = None,
        request_pars: str = None,
        service_name: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the instance.
        # 
        # > This operation contains both the InstanceId and ClusterId parameters. You must specify one of them.
        self.cluster_id = cluster_id
        # The name of the contact group.
        self.group_name = group_name
        # Specifies whether to query the number of instances that are used for the service.
        self.has_ip_count = has_ip_count
        # The ID of the instance.
        # 
        # > This operation contains both the InstanceId and ClusterId parameters. You must specify one of them.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars
        # The name of the service.
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.has_ip_count is not None:
            result['HasIpCount'] = self.has_ip_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HasIpCount') is not None:
            self.has_ip_count = m.get('HasIpCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ListAnsServicesResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_count: int = None,
        group_name: str = None,
        healthy_instance_count: int = None,
        ip_count: int = None,
        name: str = None,
    ):
        # The total number of clusters.
        self.cluster_count = cluster_count
        # The name of the contact group.
        self.group_name = group_name
        # The total number of instances with healthy heartbeats.
        self.healthy_instance_count = healthy_instance_count
        # The total number of instances that are used for the current service.
        self.ip_count = ip_count
        # The name of the service.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_count is not None:
            result['ClusterCount'] = self.cluster_count
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.healthy_instance_count is not None:
            result['HealthyInstanceCount'] = self.healthy_instance_count
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterCount') is not None:
            self.cluster_count = m.get('ClusterCount')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HealthyInstanceCount') is not None:
            self.healthy_instance_count = m.get('HealthyInstanceCount')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListAnsServicesResponseBody(TeaModel):
    def __init__(
        self,
        data: List[ListAnsServicesResponseBodyData] = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success
        # The total number of returned instances.
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAnsServicesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAnsServicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAnsServicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAnsServicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAppBySwimmingLaneGroupTagRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        group_id: int = None,
        tag: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the lane group.
        self.group_id = group_id
        # The tag.
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class ListAppBySwimmingLaneGroupTagResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: Any = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code. A value of 200 is returned if the request is successful.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAppBySwimmingLaneGroupTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAppBySwimmingLaneGroupTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAppBySwimmingLaneGroupTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApplicationsWithTagRulesRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        app_id: str = None,
        app_name: str = None,
        page_number: int = None,
        page_size: int = None,
        region: str = None,
        source: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the application.
        self.app_id = app_id
        # The names of the applications.
        self.app_name = app_name
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The region ID.
        self.region = region
        # The source of the routing rule. Default value: edasmsc.
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region is not None:
            result['Region'] = self.region
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class ListApplicationsWithTagRulesResponseBodyDataResultRouteRules(TeaModel):
    def __init__(
        self,
        carry_data: bool = None,
        enable: bool = None,
        gmt_modified: str = None,
        id: int = None,
        instance_num: int = None,
        name: str = None,
        rate: int = None,
        remove: bool = None,
        rules: str = None,
        status: int = None,
        tag: str = None,
    ):
        # Indicates whether the field is a primary key.
        self.carry_data = carry_data
        # Indicates whether the alert rule is enabled. Valid values:
        # 
        # *   `true`: enabled
        # *   `false`: disabled
        self.enable = enable
        # The modification time.
        self.gmt_modified = gmt_modified
        # The ID of the rule.
        self.id = id
        # The number of instances.
        self.instance_num = instance_num
        # The name of the rule.
        self.name = name
        # The rate.
        self.rate = rate
        # Indicates whether the routing rule is deleted.
        self.remove = remove
        # The details of the routing rule.
        self.rules = rules
        # The status.
        self.status = status
        # The tag.
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.carry_data is not None:
            result['CarryData'] = self.carry_data
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_num is not None:
            result['InstanceNum'] = self.instance_num
        if self.name is not None:
            result['Name'] = self.name
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.rules is not None:
            result['Rules'] = self.rules
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CarryData') is not None:
            self.carry_data = m.get('CarryData')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceNum') is not None:
            self.instance_num = m.get('InstanceNum')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Rules') is not None:
            self.rules = m.get('Rules')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class ListApplicationsWithTagRulesResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_name: str = None,
        route_rules: List[ListApplicationsWithTagRulesResponseBodyDataResultRouteRules] = None,
        route_status: int = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # The name of the application.
        self.app_name = app_name
        # An array that consists of the rules.
        self.route_rules = route_rules
        # The status of the route. Valid values: -0: disabled. -1: enabled.
        self.route_status = route_status

    def validate(self):
        if self.route_rules:
            for k in self.route_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        result['RouteRules'] = []
        if self.route_rules is not None:
            for k in self.route_rules:
                result['RouteRules'].append(k.to_map() if k else None)
        if self.route_status is not None:
            result['RouteStatus'] = self.route_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        self.route_rules = []
        if m.get('RouteRules') is not None:
            for k in m.get('RouteRules'):
                temp_model = ListApplicationsWithTagRulesResponseBodyDataResultRouteRules()
                self.route_rules.append(temp_model.from_map(k))
        if m.get('RouteStatus') is not None:
            self.route_status = m.get('RouteStatus')
        return self


class ListApplicationsWithTagRulesResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        result: List[ListApplicationsWithTagRulesResponseBodyDataResult] = None,
        total_size: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The data structure.
        self.result = result
        # The total number of entries returned.
        self.total_size = total_size

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = ListApplicationsWithTagRulesResponseBodyDataResult()
                self.result.append(temp_model.from_map(k))
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class ListApplicationsWithTagRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ListApplicationsWithTagRulesResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        # 
        # *   If the request is successful, a success message is returned.
        # *   If the request fails, an error message is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values: -\[unk]true\[unk]: The request is successful. -\[unk]false\[unk]: The request fails.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListApplicationsWithTagRulesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListApplicationsWithTagRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApplicationsWithTagRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApplicationsWithTagRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterConnectionTypesRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        return self


class ListClusterConnectionTypesResponseBodyData(TeaModel):
    def __init__(
        self,
        show_name: str = None,
    ):
        # The connection type.
        self.show_name = show_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        return self


class ListClusterConnectionTypesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[ListClusterConnectionTypesResponseBodyData] = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message. This parameter is used to replace the **%s** variable in the **ErrMessage** parameter.
        # 
        # >  If the return value of the **ErrMessage** parameter is **The Value of Input Parameter %s is not valid** and the return value of the **DynamicMessage** parameter is **DtsJobId**, the specified **DtsJobId** parameter is invalid.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListClusterConnectionTypesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListClusterConnectionTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListClusterConnectionTypesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListClusterConnectionTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterHealthCheckTaskRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        region_id: str = None,
        request_pars: str = None,
    ):
        self.accept_language = accept_language
        self.instance_id = instance_id
        self.page_num = page_num
        self.page_size = page_size
        self.region_id = region_id
        self.request_pars = request_pars

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        return self


class ListClusterHealthCheckTaskResponseBodyDataResultRiskList(TeaModel):
    def __init__(
        self,
        description: str = None,
        id: int = None,
        module: str = None,
        mute: bool = None,
        notice_feature: bool = None,
        primary_user: str = None,
        risk_code: str = None,
        risk_level: str = None,
        risk_name: str = None,
        risk_type: str = None,
        situation: str = None,
        suggestion: str = None,
        task_id: int = None,
        type: int = None,
        values: str = None,
    ):
        self.description = description
        # ID。
        self.id = id
        self.module = module
        self.mute = mute
        self.notice_feature = notice_feature
        self.primary_user = primary_user
        self.risk_code = risk_code
        self.risk_level = risk_level
        self.risk_name = risk_name
        self.risk_type = risk_type
        self.situation = situation
        self.suggestion = suggestion
        self.task_id = task_id
        self.type = type
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.module is not None:
            result['Module'] = self.module
        if self.mute is not None:
            result['Mute'] = self.mute
        if self.notice_feature is not None:
            result['NoticeFeature'] = self.notice_feature
        if self.primary_user is not None:
            result['PrimaryUser'] = self.primary_user
        if self.risk_code is not None:
            result['RiskCode'] = self.risk_code
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.risk_type is not None:
            result['RiskType'] = self.risk_type
        if self.situation is not None:
            result['Situation'] = self.situation
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Module') is not None:
            self.module = m.get('Module')
        if m.get('Mute') is not None:
            self.mute = m.get('Mute')
        if m.get('NoticeFeature') is not None:
            self.notice_feature = m.get('NoticeFeature')
        if m.get('PrimaryUser') is not None:
            self.primary_user = m.get('PrimaryUser')
        if m.get('RiskCode') is not None:
            self.risk_code = m.get('RiskCode')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('RiskType') is not None:
            self.risk_type = m.get('RiskType')
        if m.get('Situation') is not None:
            self.situation = m.get('Situation')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class ListClusterHealthCheckTaskResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        app_version: str = None,
        charge_type: str = None,
        cluster_type: str = None,
        create_time: str = None,
        id: int = None,
        image_version: str = None,
        instance_id: str = None,
        primary_user: str = None,
        replica: str = None,
        risk_list: List[ListClusterHealthCheckTaskResponseBodyDataResultRiskList] = None,
        score: int = None,
        spec: str = None,
        status: str = None,
        total_item: int = None,
        total_risk: int = None,
        type: str = None,
        update_time: str = None,
        version_code: str = None,
    ):
        self.app_version = app_version
        self.charge_type = charge_type
        self.cluster_type = cluster_type
        self.create_time = create_time
        # ID。
        self.id = id
        self.image_version = image_version
        self.instance_id = instance_id
        self.primary_user = primary_user
        self.replica = replica
        self.risk_list = risk_list
        self.score = score
        self.spec = spec
        self.status = status
        self.total_item = total_item
        self.total_risk = total_risk
        self.type = type
        self.update_time = update_time
        self.version_code = version_code

    def validate(self):
        if self.risk_list:
            for k in self.risk_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.id is not None:
            result['Id'] = self.id
        if self.image_version is not None:
            result['ImageVersion'] = self.image_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.primary_user is not None:
            result['PrimaryUser'] = self.primary_user
        if self.replica is not None:
            result['Replica'] = self.replica
        result['RiskList'] = []
        if self.risk_list is not None:
            for k in self.risk_list:
                result['RiskList'].append(k.to_map() if k else None)
        if self.score is not None:
            result['Score'] = self.score
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.status is not None:
            result['Status'] = self.status
        if self.total_item is not None:
            result['TotalItem'] = self.total_item
        if self.total_risk is not None:
            result['TotalRisk'] = self.total_risk
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ImageVersion') is not None:
            self.image_version = m.get('ImageVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PrimaryUser') is not None:
            self.primary_user = m.get('PrimaryUser')
        if m.get('Replica') is not None:
            self.replica = m.get('Replica')
        self.risk_list = []
        if m.get('RiskList') is not None:
            for k in m.get('RiskList'):
                temp_model = ListClusterHealthCheckTaskResponseBodyDataResultRiskList()
                self.risk_list.append(temp_model.from_map(k))
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalItem') is not None:
            self.total_item = m.get('TotalItem')
        if m.get('TotalRisk') is not None:
            self.total_risk = m.get('TotalRisk')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        return self


class ListClusterHealthCheckTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        result: List[ListClusterHealthCheckTaskResponseBodyDataResult] = None,
        total_size: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.result = result
        self.total_size = total_size

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = ListClusterHealthCheckTaskResponseBodyDataResult()
                self.result.append(temp_model.from_map(k))
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class ListClusterHealthCheckTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ListClusterHealthCheckTaskResponseBodyData = None,
        dynamic_code: str = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.dynamic_code = dynamic_code
        self.dynamic_message = dynamic_message
        self.error_code = error_code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.dynamic_code is not None:
            result['DynamicCode'] = self.dynamic_code
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListClusterHealthCheckTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('DynamicCode') is not None:
            self.dynamic_code = m.get('DynamicCode')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListClusterHealthCheckTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListClusterHealthCheckTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListClusterHealthCheckTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterTypesRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        connect_type: str = None,
        mse_version: str = None,
        region_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The network type. Valid values:
        # 
        # *   slb
        # *   eni
        self.connect_type = connect_type
        # The edition of the MSE instance that you want to purchase.
        # 
        # *   mse_pro: Professional Edition
        # *   mse_dev: Developer Edition
        self.mse_version = mse_version
        # The ID of the region in which the instance resides. The region is supported by MSE.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.connect_type is not None:
            result['ConnectType'] = self.connect_type
        if self.mse_version is not None:
            result['MseVersion'] = self.mse_version
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ConnectType') is not None:
            self.connect_type = m.get('ConnectType')
        if m.get('MseVersion') is not None:
            self.mse_version = m.get('MseVersion')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListClusterTypesResponseBodyData(TeaModel):
    def __init__(
        self,
        show_name: str = None,
    ):
        # The type of the MSE engine that can be activated.
        self.show_name = show_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        return self


class ListClusterTypesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[ListClusterTypesResponseBodyData] = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data entries returned.
        self.data = data
        # The dynamic part in the error message. This parameter is used to replace the \*\*%s\*\* variable in the **ErrMessage** parameter.
        # 
        # > If the return value of the **ErrMessage** parameter is **The Value of Input Parameter %s is not valid** and the return value of the **DynamicMessage** parameter is **DtsJobId**, the specified **DtsJobId** parameter is invalid.
        self.dynamic_message = dynamic_message
        # The error code.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListClusterTypesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListClusterTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListClusterTypesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListClusterTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterVersionsRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_type: str = None,
        mse_version: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The type of the instance. Valid values: ZooKeeper, Nacos-Ans, and Eureka.
        self.cluster_type = cluster_type
        # Valid values:
        # 
        # *   `mse_dev`: Developer Edition
        # *   `mse_pro`: Professional Edition. This is the default value.
        self.mse_version = mse_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.mse_version is not None:
            result['MseVersion'] = self.mse_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('MseVersion') is not None:
            self.mse_version = m.get('MseVersion')
        return self


class ListClusterVersionsResponseBodyData(TeaModel):
    def __init__(
        self,
        cluster_type: str = None,
        code: str = None,
        show_name: str = None,
    ):
        # The type of the instance.
        self.cluster_type = cluster_type
        # The code of the instance type.
        self.code = code
        # The type of the instance.
        self.show_name = show_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.code is not None:
            result['Code'] = self.code
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        return self


class ListClusterVersionsResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[ListClusterVersionsResponseBodyData] = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code returned.
        self.code = code
        # The details of the data.
        self.data = data
        # The dynamic part in the error message.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListClusterVersionsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListClusterVersionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListClusterVersionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListClusterVersionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClustersRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key.
        self.key = key
        # The tag value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListClustersRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_alias_name: str = None,
        page_num: int = None,
        page_size: int = None,
        region_id: str = None,
        request_pars: str = None,
        resource_group_id: str = None,
        tag: List[ListClustersRequestTag] = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The alias of the instance. Fuzzy match is supported.
        self.cluster_alias_name = cluster_alias_name
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The ID of the region in which the instance resides. The region is supported by MSE.
        self.region_id = region_id
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars
        # The ID of the resource group to which the instance belongs. For more information about resource groups, see the topic "View basic information of a resource group."
        self.resource_group_id = resource_group_id
        # The list of tags. A maximum number of 20 tags are supported.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_alias_name is not None:
            result['ClusterAliasName'] = self.cluster_alias_name
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterAliasName') is not None:
            self.cluster_alias_name = m.get('ClusterAliasName')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListClustersRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ListClustersResponseBodyData(TeaModel):
    def __init__(
        self,
        app_version: str = None,
        can_update: bool = None,
        charge_type: str = None,
        cluster_alias_name: str = None,
        cluster_name: str = None,
        cluster_type: str = None,
        create_time: str = None,
        end_date: str = None,
        init_status: str = None,
        instance_count: int = None,
        instance_id: str = None,
        internet_address: str = None,
        internet_domain: str = None,
        intranet_address: str = None,
        intranet_domain: str = None,
        mse_version: str = None,
        resource_group_id: str = None,
        tags: Dict[str, Any] = None,
        version_code: str = None,
    ):
        # The application version.
        self.app_version = app_version
        # Indicates whether the instance can be upgraded.
        self.can_update = can_update
        # The billing method, such as subscription or pay-as-you-go.
        self.charge_type = charge_type
        # The alias of the instance.
        self.cluster_alias_name = cluster_alias_name
        # The name of the instance.
        self.cluster_name = cluster_name
        # The type of the instance. Valid values: ZooKeeper, Nacos-Ans, and Eureka.
        self.cluster_type = cluster_type
        # The time when the instance was created.
        self.create_time = create_time
        # The time when the instance expires.
        self.end_date = end_date
        # The initial status of the instance.
        self.init_status = init_status
        # The number of instances.
        self.instance_count = instance_count
        # The ID of the instance.
        self.instance_id = instance_id
        # The public IP address of the instance.
        self.internet_address = internet_address
        # The public endpoint of the instance.
        self.internet_domain = internet_domain
        # The internal IP address of the instance.
        self.intranet_address = intranet_address
        # The internal endpoint of the instance.
        self.intranet_domain = intranet_domain
        # The edition of the instance.
        self.mse_version = mse_version
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id
        # The tags that are attached to the instance.
        self.tags = tags
        # The version information.
        self.version_code = version_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.can_update is not None:
            result['CanUpdate'] = self.can_update
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.cluster_alias_name is not None:
            result['ClusterAliasName'] = self.cluster_alias_name
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.init_status is not None:
            result['InitStatus'] = self.init_status
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.internet_address is not None:
            result['InternetAddress'] = self.internet_address
        if self.internet_domain is not None:
            result['InternetDomain'] = self.internet_domain
        if self.intranet_address is not None:
            result['IntranetAddress'] = self.intranet_address
        if self.intranet_domain is not None:
            result['IntranetDomain'] = self.intranet_domain
        if self.mse_version is not None:
            result['MseVersion'] = self.mse_version
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('CanUpdate') is not None:
            self.can_update = m.get('CanUpdate')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClusterAliasName') is not None:
            self.cluster_alias_name = m.get('ClusterAliasName')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InitStatus') is not None:
            self.init_status = m.get('InitStatus')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InternetAddress') is not None:
            self.internet_address = m.get('InternetAddress')
        if m.get('InternetDomain') is not None:
            self.internet_domain = m.get('InternetDomain')
        if m.get('IntranetAddress') is not None:
            self.intranet_address = m.get('IntranetAddress')
        if m.get('IntranetDomain') is not None:
            self.intranet_domain = m.get('IntranetDomain')
        if m.get('MseVersion') is not None:
            self.mse_version = m.get('MseVersion')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        return self


class ListClustersResponseBody(TeaModel):
    def __init__(
        self,
        data: List[ListClustersResponseBodyData] = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success
        # The total number of returned instances.
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListClustersResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListClustersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListClustersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigTrackRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        data_id: str = None,
        end_ts: int = None,
        group: str = None,
        instance_id: str = None,
        ip: str = None,
        namespace_id: str = None,
        page_num: int = None,
        page_size: int = None,
        request_pars: str = None,
        reverse: bool = None,
        start_ts: int = None,
    ):
        self.accept_language = accept_language
        self.data_id = data_id
        self.end_ts = end_ts
        self.group = group
        self.instance_id = instance_id
        self.ip = ip
        self.namespace_id = namespace_id
        self.page_num = page_num
        self.page_size = page_size
        self.request_pars = request_pars
        self.reverse = reverse
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.group is not None:
            result['Group'] = self.group
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        if self.reverse is not None:
            result['Reverse'] = self.reverse
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        if m.get('Reverse') is not None:
            self.reverse = m.get('Reverse')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class ListConfigTrackResponseBodyTraces(TeaModel):
    def __init__(
        self,
        client: bool = None,
        data_id: str = None,
        delay: str = None,
        event: str = None,
        group: str = None,
        log_date: str = None,
        md_5: str = None,
        push: bool = None,
        request_ip: str = None,
        response_ip: str = None,
        result: str = None,
        ts: str = None,
        type: str = None,
    ):
        self.client = client
        self.data_id = data_id
        self.delay = delay
        self.event = event
        self.group = group
        self.log_date = log_date
        self.md_5 = md_5
        self.push = push
        self.request_ip = request_ip
        self.response_ip = response_ip
        self.result = result
        self.ts = ts
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client is not None:
            result['Client'] = self.client
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.event is not None:
            result['Event'] = self.event
        if self.group is not None:
            result['Group'] = self.group
        if self.log_date is not None:
            result['LogDate'] = self.log_date
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.push is not None:
            result['Push'] = self.push
        if self.request_ip is not None:
            result['RequestIp'] = self.request_ip
        if self.response_ip is not None:
            result['ResponseIp'] = self.response_ip
        if self.result is not None:
            result['Result'] = self.result
        if self.ts is not None:
            result['Ts'] = self.ts
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Client') is not None:
            self.client = m.get('Client')
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('LogDate') is not None:
            self.log_date = m.get('LogDate')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('Push') is not None:
            self.push = m.get('Push')
        if m.get('RequestIp') is not None:
            self.request_ip = m.get('RequestIp')
        if m.get('ResponseIp') is not None:
            self.response_ip = m.get('ResponseIp')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Ts') is not None:
            self.ts = m.get('Ts')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListConfigTrackResponseBody(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
        traces: List[ListConfigTrackResponseBodyTraces] = None,
    ):
        self.error_code = error_code
        self.http_code = http_code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count
        self.traces = traces

    def validate(self):
        if self.traces:
            for k in self.traces:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Traces'] = []
        if self.traces is not None:
            for k in self.traces:
                result['Traces'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.traces = []
        if m.get('Traces') is not None:
            for k in m.get('Traces'):
                temp_model = ListConfigTrackResponseBodyTraces()
                self.traces.append(temp_model.from_map(k))
        return self


class ListConfigTrackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListConfigTrackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListConfigTrackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEngineNamespacesRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        instance_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the instance.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListEngineNamespacesResponseBodyData(TeaModel):
    def __init__(
        self,
        config_count: int = None,
        namespace: str = None,
        namespace_desc: str = None,
        namespace_show_name: str = None,
        quota: int = None,
        service_count: str = None,
        type: int = None,
    ):
        # The quota value.
        self.config_count = config_count
        # The namespace.
        self.namespace = namespace
        # The description of the namespace.
        self.namespace_desc = namespace_desc
        # The name of the namespace.
        self.namespace_show_name = namespace_show_name
        # The quota of configurations.
        self.quota = quota
        # The number of active services.
        self.service_count = service_count
        # The type of the namespace. Valid values:
        # 
        # *   `0`: global configuration
        # *   `1`: default namespace
        # *   `2`: custom namespace
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_count is not None:
            result['ConfigCount'] = self.config_count
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_desc is not None:
            result['NamespaceDesc'] = self.namespace_desc
        if self.namespace_show_name is not None:
            result['NamespaceShowName'] = self.namespace_show_name
        if self.quota is not None:
            result['Quota'] = self.quota
        if self.service_count is not None:
            result['ServiceCount'] = self.service_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigCount') is not None:
            self.config_count = m.get('ConfigCount')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespaceDesc') is not None:
            self.namespace_desc = m.get('NamespaceDesc')
        if m.get('NamespaceShowName') is not None:
            self.namespace_show_name = m.get('NamespaceShowName')
        if m.get('Quota') is not None:
            self.quota = m.get('Quota')
        if m.get('ServiceCount') is not None:
            self.service_count = m.get('ServiceCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListEngineNamespacesResponseBody(TeaModel):
    def __init__(
        self,
        data: List[ListEngineNamespacesResponseBodyData] = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success
        # The total number of instances.
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListEngineNamespacesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEngineNamespacesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEngineNamespacesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEngineNamespacesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEurekaInstancesRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        page_num: int = None,
        page_size: int = None,
        request_pars: str = None,
        service_name: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the instance.
        self.cluster_id = cluster_id
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars
        # The name of the service.
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ListEurekaInstancesResponseBodyData(TeaModel):
    def __init__(
        self,
        app: str = None,
        duration_in_secs: int = None,
        home_page_url: str = None,
        host_name: str = None,
        instance_id: str = None,
        ip_addr: str = None,
        last_dirty_timestamp: int = None,
        last_updated_timestamp: int = None,
        metadata: Dict[str, Any] = None,
        port: int = None,
        renewal_interval_in_secs: int = None,
        secure_port: int = None,
        status: str = None,
        vip_address: str = None,
    ):
        # The name of the application.
        self.app = app
        # The timeout period of the instance.\
        # After the specified timeout period expires, the service is unavailable by default and is deleted.
        self.duration_in_secs = duration_in_secs
        # The URL of the homepage.
        self.home_page_url = home_page_url
        # The hostname.
        self.host_name = host_name
        # The ID of the instance.
        self.instance_id = instance_id
        # The IP address.
        self.ip_addr = ip_addr
        # The time when the instance was last modified.
        self.last_dirty_timestamp = last_dirty_timestamp
        # The time when the instance heartbeat was last checked.
        self.last_updated_timestamp = last_updated_timestamp
        # The metadata.
        self.metadata = metadata
        # The service port number.
        self.port = port
        # The maximum interval between two heartbeat checks after a heartbeat check times out.\
        # Default value: 10.
        self.renewal_interval_in_secs = renewal_interval_in_secs
        # The security port.
        self.secure_port = secure_port
        # The number of service providers. The value is in the following format: Number of healthy instances/Total number of instances.
        self.status = status
        # The virtual IP address (VIP).
        self.vip_address = vip_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.duration_in_secs is not None:
            result['DurationInSecs'] = self.duration_in_secs
        if self.home_page_url is not None:
            result['HomePageUrl'] = self.home_page_url
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_addr is not None:
            result['IpAddr'] = self.ip_addr
        if self.last_dirty_timestamp is not None:
            result['LastDirtyTimestamp'] = self.last_dirty_timestamp
        if self.last_updated_timestamp is not None:
            result['LastUpdatedTimestamp'] = self.last_updated_timestamp
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        if self.port is not None:
            result['Port'] = self.port
        if self.renewal_interval_in_secs is not None:
            result['RenewalIntervalInSecs'] = self.renewal_interval_in_secs
        if self.secure_port is not None:
            result['SecurePort'] = self.secure_port
        if self.status is not None:
            result['Status'] = self.status
        if self.vip_address is not None:
            result['VipAddress'] = self.vip_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('DurationInSecs') is not None:
            self.duration_in_secs = m.get('DurationInSecs')
        if m.get('HomePageUrl') is not None:
            self.home_page_url = m.get('HomePageUrl')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpAddr') is not None:
            self.ip_addr = m.get('IpAddr')
        if m.get('LastDirtyTimestamp') is not None:
            self.last_dirty_timestamp = m.get('LastDirtyTimestamp')
        if m.get('LastUpdatedTimestamp') is not None:
            self.last_updated_timestamp = m.get('LastUpdatedTimestamp')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RenewalIntervalInSecs') is not None:
            self.renewal_interval_in_secs = m.get('RenewalIntervalInSecs')
        if m.get('SecurePort') is not None:
            self.secure_port = m.get('SecurePort')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VipAddress') is not None:
            self.vip_address = m.get('VipAddress')
        return self


class ListEurekaInstancesResponseBody(TeaModel):
    def __init__(
        self,
        data: List[ListEurekaInstancesResponseBodyData] = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success
        # The total number of returned instances.
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListEurekaInstancesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEurekaInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEurekaInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEurekaInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEurekaServicesRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_id: str = None,
        page_num: int = None,
        page_size: int = None,
        region_id: str = None,
        request_pars: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the instance.
        self.cluster_id = cluster_id
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The region ID.
        self.region_id = region_id
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        return self


class ListEurekaServicesResponseBodyData(TeaModel):
    def __init__(
        self,
        instances_id: List[str] = None,
        name: str = None,
        up_status: str = None,
    ):
        # The details of the instance.
        self.instances_id = instances_id
        # The name of the service.
        self.name = name
        # The number of service providers. The value is in the following format: Number of healthy instances/Total number of instances.
        self.up_status = up_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instances_id is not None:
            result['InstancesId'] = self.instances_id
        if self.name is not None:
            result['Name'] = self.name
        if self.up_status is not None:
            result['UpStatus'] = self.up_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstancesId') is not None:
            self.instances_id = m.get('InstancesId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpStatus') is not None:
            self.up_status = m.get('UpStatus')
        return self


class ListEurekaServicesResponseBody(TeaModel):
    def __init__(
        self,
        data: List[ListEurekaServicesResponseBodyData] = None,
        error_code: str = None,
        http_code: str = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        # The details of the data.
        self.data = data
        # The error code returned if the request failed.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_code = http_code
        # The message returned.
        self.message = message
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success
        # The total number of returned instances.
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListEurekaServicesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEurekaServicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEurekaServicesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEurekaServicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGatewayRequestFilterParams(TeaModel):
    def __init__(
        self,
        gateway_type: str = None,
        gateway_unique_id: str = None,
        instance_id: str = None,
        mse_tag: str = None,
        name: str = None,
        resource_group_id: str = None,
        vpc: str = None,
    ):
        # The type of the gateway.
        self.gateway_type = gateway_type
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The ID of the instance.
        self.instance_id = instance_id
        # The tag of the instance.
        self.mse_tag = mse_tag
        # The name of the gateway.
        self.name = name
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The ID of the virtual private cloud (VPC).
        self.vpc = vpc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_type is not None:
            result['GatewayType'] = self.gateway_type
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.mse_tag is not None:
            result['MseTag'] = self.mse_tag
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.vpc is not None:
            result['Vpc'] = self.vpc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayType') is not None:
            self.gateway_type = m.get('GatewayType')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MseTag') is not None:
            self.mse_tag = m.get('MseTag')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Vpc') is not None:
            self.vpc = m.get('Vpc')
        return self


class ListGatewayRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        desc_sort: bool = None,
        filter_params: ListGatewayRequestFilterParams = None,
        order_item: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # Specifies whether to enable the sorting feature. This feature is not available.
        self.desc_sort = desc_sort
        # The details of parameters.
        self.filter_params = filter_params
        # The order information.
        self.order_item = order_item
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        if self.filter_params:
            self.filter_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.desc_sort is not None:
            result['DescSort'] = self.desc_sort
        if self.filter_params is not None:
            result['FilterParams'] = self.filter_params.to_map()
        if self.order_item is not None:
            result['OrderItem'] = self.order_item
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DescSort') is not None:
            self.desc_sort = m.get('DescSort')
        if m.get('FilterParams') is not None:
            temp_model = ListGatewayRequestFilterParams()
            self.filter_params = temp_model.from_map(m['FilterParams'])
        if m.get('OrderItem') is not None:
            self.order_item = m.get('OrderItem')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListGatewayShrinkRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        desc_sort: bool = None,
        filter_params_shrink: str = None,
        order_item: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # Specifies whether to enable the sorting feature. This feature is not available.
        self.desc_sort = desc_sort
        # The details of parameters.
        self.filter_params_shrink = filter_params_shrink
        # The order information.
        self.order_item = order_item
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.desc_sort is not None:
            result['DescSort'] = self.desc_sort
        if self.filter_params_shrink is not None:
            result['FilterParams'] = self.filter_params_shrink
        if self.order_item is not None:
            result['OrderItem'] = self.order_item
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DescSort') is not None:
            self.desc_sort = m.get('DescSort')
        if m.get('FilterParams') is not None:
            self.filter_params_shrink = m.get('FilterParams')
        if m.get('OrderItem') is not None:
            self.order_item = m.get('OrderItem')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListGatewayResponseBodyDataResultInitConfig(TeaModel):
    def __init__(
        self,
        enable_waf: bool = None,
        support_waf: bool = None,
    ):
        # Indicates whether Web Application Firewall (WAF) is enabled.
        self.enable_waf = enable_waf
        # Indicates whether WAF is supported.
        self.support_waf = support_waf

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_waf is not None:
            result['EnableWaf'] = self.enable_waf
        if self.support_waf is not None:
            result['SupportWaf'] = self.support_waf
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableWaf') is not None:
            self.enable_waf = m.get('EnableWaf')
        if m.get('SupportWaf') is not None:
            self.support_waf = m.get('SupportWaf')
        return self


class ListGatewayResponseBodyDataResultInternetSlb(TeaModel):
    def __init__(
        self,
        gateway_slb_mode: str = None,
        gateway_slb_status: str = None,
        internet_network_flow: str = None,
        slb_id: str = None,
        slb_ip: str = None,
        slb_port: str = None,
        slb_spec: str = None,
        status_desc: str = None,
        type: str = None,
    ):
        # The mode of the SLB instance.
        self.gateway_slb_mode = gateway_slb_mode
        # The status of the SLB instance.
        self.gateway_slb_status = gateway_slb_status
        # The traffic of the gateway.
        self.internet_network_flow = internet_network_flow
        # The ID of the SLB instance.
        self.slb_id = slb_id
        # The IP address of the SLB instance.
        self.slb_ip = slb_ip
        # The port number of the SLB instance.
        self.slb_port = slb_port
        # The specifications of the SLB instance.
        self.slb_spec = slb_spec
        # The description of the status.
        self.status_desc = status_desc
        # The type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_slb_mode is not None:
            result['GatewaySlbMode'] = self.gateway_slb_mode
        if self.gateway_slb_status is not None:
            result['GatewaySlbStatus'] = self.gateway_slb_status
        if self.internet_network_flow is not None:
            result['InternetNetworkFlow'] = self.internet_network_flow
        if self.slb_id is not None:
            result['SlbId'] = self.slb_id
        if self.slb_ip is not None:
            result['SlbIp'] = self.slb_ip
        if self.slb_port is not None:
            result['SlbPort'] = self.slb_port
        if self.slb_spec is not None:
            result['SlbSpec'] = self.slb_spec
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewaySlbMode') is not None:
            self.gateway_slb_mode = m.get('GatewaySlbMode')
        if m.get('GatewaySlbStatus') is not None:
            self.gateway_slb_status = m.get('GatewaySlbStatus')
        if m.get('InternetNetworkFlow') is not None:
            self.internet_network_flow = m.get('InternetNetworkFlow')
        if m.get('SlbId') is not None:
            self.slb_id = m.get('SlbId')
        if m.get('SlbIp') is not None:
            self.slb_ip = m.get('SlbIp')
        if m.get('SlbPort') is not None:
            self.slb_port = m.get('SlbPort')
        if m.get('SlbSpec') is not None:
            self.slb_spec = m.get('SlbSpec')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListGatewayResponseBodyDataResultSlb(TeaModel):
    def __init__(
        self,
        gateway_slb_mode: str = None,
        gateway_slb_status: str = None,
        slb_id: str = None,
        slb_ip: str = None,
        slb_port: str = None,
        slb_spec: str = None,
        status_desc: str = None,
        type: str = None,
    ):
        # The mode of the SLB instance.
        self.gateway_slb_mode = gateway_slb_mode
        # The status of the SLB instance.
        self.gateway_slb_status = gateway_slb_status
        # The ID of the SLB instance.
        self.slb_id = slb_id
        # The IP address of the SLB instance.
        self.slb_ip = slb_ip
        # The port number of the SLB instance.
        self.slb_port = slb_port
        # The specifications of the SLB instance.
        self.slb_spec = slb_spec
        # The description of the status.
        self.status_desc = status_desc
        # The type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_slb_mode is not None:
            result['GatewaySlbMode'] = self.gateway_slb_mode
        if self.gateway_slb_status is not None:
            result['GatewaySlbStatus'] = self.gateway_slb_status
        if self.slb_id is not None:
            result['SlbId'] = self.slb_id
        if self.slb_ip is not None:
            result['SlbIp'] = self.slb_ip
        if self.slb_port is not None:
            result['SlbPort'] = self.slb_port
        if self.slb_spec is not None:
            result['SlbSpec'] = self.slb_spec
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewaySlbMode') is not None:
            self.gateway_slb_mode = m.get('GatewaySlbMode')
        if m.get('GatewaySlbStatus') is not None:
            self.gateway_slb_status = m.get('GatewaySlbStatus')
        if m.get('SlbId') is not None:
            self.slb_id = m.get('SlbId')
        if m.get('SlbIp') is not None:
            self.slb_ip = m.get('SlbIp')
        if m.get('SlbPort') is not None:
            self.slb_port = m.get('SlbPort')
        if m.get('SlbSpec') is not None:
            self.slb_spec = m.get('SlbSpec')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListGatewayResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        ahas_on: bool = None,
        app_version: str = None,
        arms_on: bool = None,
        charge_type: str = None,
        current_version: str = None,
        end_date: str = None,
        gateway_type: str = None,
        gateway_unique_id: str = None,
        gateway_version: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        init_config: ListGatewayResponseBodyDataResultInitConfig = None,
        instance_id: str = None,
        internet_slb: List[ListGatewayResponseBodyDataResultInternetSlb] = None,
        latest_version: str = None,
        mse_tag: str = None,
        must_upgrade: bool = None,
        name: str = None,
        primary_user: str = None,
        region: str = None,
        replica: int = None,
        resource_group_id: str = None,
        roll_back: bool = None,
        slb: List[ListGatewayResponseBodyDataResultSlb] = None,
        spec: str = None,
        status: int = None,
        status_desc: str = None,
        support_wasm: bool = None,
        tag: str = None,
        upgrade: bool = None,
        vswitch_2: str = None,
    ):
        # Indicates whether Application High Availability Service (AHAS) is activated.
        self.ahas_on = ahas_on
        # The version of the application.
        self.app_version = app_version
        # Indicates whether Application Real-Time Monitoring Service (ARMS) is activated.
        self.arms_on = arms_on
        # The billing method.
        self.charge_type = charge_type
        # The current version of the gateway.
        self.current_version = current_version
        # The time when the subscription gateway expires.
        self.end_date = end_date
        # The type of the gateway.
        self.gateway_type = gateway_type
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The version of the gateway.
        self.gateway_version = gateway_version
        # The creation time.
        self.gmt_create = gmt_create
        # The modification time.
        self.gmt_modified = gmt_modified
        # The ID of the gateway.
        self.id = id
        # The configurations.
        self.init_config = init_config
        # The ID of the instance.
        self.instance_id = instance_id
        # The details of the Internet-facing SLB instances.
        self.internet_slb = internet_slb
        # The latest version of the gateway.
        self.latest_version = latest_version
        # The tag of the instance.
        self.mse_tag = mse_tag
        # Indicates whether the gateway can be forcefully updated.
        self.must_upgrade = must_upgrade
        # The name of the gateway.
        self.name = name
        # The information about the user.
        self.primary_user = primary_user
        # The region ID.
        self.region = region
        # The number of replicas.
        self.replica = replica
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # Indicates whether rollbacks are allowed.
        self.roll_back = roll_back
        # The details of the Server Load Balancer (SLB) instances.
        self.slb = slb
        # The specifications of the gateway.
        self.spec = spec
        # The gateway status.
        # 
        # *   0: The gateway is being created.
        # *   1: The gateway fails to be created.
        # *   2: The gateway is running.
        # *   3: The gateway is changing.
        # *   4: The gateway is scaling down.
        # *   6: The gateway is scaling up.
        # *   8: The gateway is being deleted.
        # *   9: The gateway is suspended and to be released.
        # *   10: The gateway is restarting.
        # *   11: The gateway is being rebuilt.
        # *   12: The gateway is updating.
        # *   13: The gateway fails to be updated.
        self.status = status
        # The description of the status.
        self.status_desc = status_desc
        # Indicates whether WebAssembly (Wasm) is supported.
        self.support_wasm = support_wasm
        # The tag.
        self.tag = tag
        # Indicates whether the gateway can be updated.
        self.upgrade = upgrade
        # The ID of the secondary vSwitch.
        self.vswitch_2 = vswitch_2

    def validate(self):
        if self.init_config:
            self.init_config.validate()
        if self.internet_slb:
            for k in self.internet_slb:
                if k:
                    k.validate()
        if self.slb:
            for k in self.slb:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ahas_on is not None:
            result['AhasOn'] = self.ahas_on
        if self.app_version is not None:
            result['AppVersion'] = self.app_version
        if self.arms_on is not None:
            result['ArmsOn'] = self.arms_on
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.gateway_type is not None:
            result['GatewayType'] = self.gateway_type
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gateway_version is not None:
            result['GatewayVersion'] = self.gateway_version
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.init_config is not None:
            result['InitConfig'] = self.init_config.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['InternetSlb'] = []
        if self.internet_slb is not None:
            for k in self.internet_slb:
                result['InternetSlb'].append(k.to_map() if k else None)
        if self.latest_version is not None:
            result['LatestVersion'] = self.latest_version
        if self.mse_tag is not None:
            result['MseTag'] = self.mse_tag
        if self.must_upgrade is not None:
            result['MustUpgrade'] = self.must_upgrade
        if self.name is not None:
            result['Name'] = self.name
        if self.primary_user is not None:
            result['PrimaryUser'] = self.primary_user
        if self.region is not None:
            result['Region'] = self.region
        if self.replica is not None:
            result['Replica'] = self.replica
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.roll_back is not None:
            result['RollBack'] = self.roll_back
        result['Slb'] = []
        if self.slb is not None:
            for k in self.slb:
                result['Slb'].append(k.to_map() if k else None)
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.status is not None:
            result['Status'] = self.status
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.support_wasm is not None:
            result['SupportWasm'] = self.support_wasm
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.upgrade is not None:
            result['Upgrade'] = self.upgrade
        if self.vswitch_2 is not None:
            result['Vswitch2'] = self.vswitch_2
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AhasOn') is not None:
            self.ahas_on = m.get('AhasOn')
        if m.get('AppVersion') is not None:
            self.app_version = m.get('AppVersion')
        if m.get('ArmsOn') is not None:
            self.arms_on = m.get('ArmsOn')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('GatewayType') is not None:
            self.gateway_type = m.get('GatewayType')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GatewayVersion') is not None:
            self.gateway_version = m.get('GatewayVersion')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InitConfig') is not None:
            temp_model = ListGatewayResponseBodyDataResultInitConfig()
            self.init_config = temp_model.from_map(m['InitConfig'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.internet_slb = []
        if m.get('InternetSlb') is not None:
            for k in m.get('InternetSlb'):
                temp_model = ListGatewayResponseBodyDataResultInternetSlb()
                self.internet_slb.append(temp_model.from_map(k))
        if m.get('LatestVersion') is not None:
            self.latest_version = m.get('LatestVersion')
        if m.get('MseTag') is not None:
            self.mse_tag = m.get('MseTag')
        if m.get('MustUpgrade') is not None:
            self.must_upgrade = m.get('MustUpgrade')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PrimaryUser') is not None:
            self.primary_user = m.get('PrimaryUser')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Replica') is not None:
            self.replica = m.get('Replica')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RollBack') is not None:
            self.roll_back = m.get('RollBack')
        self.slb = []
        if m.get('Slb') is not None:
            for k in m.get('Slb'):
                temp_model = ListGatewayResponseBodyDataResultSlb()
                self.slb.append(temp_model.from_map(k))
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('SupportWasm') is not None:
            self.support_wasm = m.get('SupportWasm')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Upgrade') is not None:
            self.upgrade = m.get('Upgrade')
        if m.get('Vswitch2') is not None:
            self.vswitch_2 = m.get('Vswitch2')
        return self


class ListGatewayResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        result: List[ListGatewayResponseBodyDataResult] = None,
        total_size: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The data entries returned.
        self.result = result
        # The total number of entries returned.
        self.total_size = total_size

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = ListGatewayResponseBodyDataResult()
                self.result.append(temp_model.from_map(k))
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class ListGatewayResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ListGatewayResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The return value.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListGatewayResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGatewayResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGatewayDomainRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
        type: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The type of the domain name.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListGatewayDomainResponseBodyDataComment(TeaModel):
    def __init__(
        self,
        status: str = None,
    ):
        # The status.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListGatewayDomainResponseBodyData(TeaModel):
    def __init__(
        self,
        cert_before_date: str = None,
        cert_identifier: str = None,
        comment: ListGatewayDomainResponseBodyDataComment = None,
        gateway_id: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        http_2: str = None,
        id: int = None,
        must_https: bool = None,
        name: str = None,
        protocol: str = None,
        status: int = None,
        tls_max: str = None,
        tls_min: str = None,
        type: str = None,
    ):
        # The expiration time.
        self.cert_before_date = cert_before_date
        # The ID of the certificate.
        self.cert_identifier = cert_identifier
        # The route comment (ingress).
        self.comment = comment
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The creation time.
        self.gmt_create = gmt_create
        # The update time.
        self.gmt_modified = gmt_modified
        # Indicates whether `HTTP/2` is enabled.
        # 
        # *   `open`: `HTTP/2` is enabled.
        # *   `close`: `HTTP/2` is disabled.
        # *   `globalConfig`: Global configurations are used.
        self.http_2 = http_2
        # ID
        self.id = id
        # Indicates whether HTTPS is forcefully used.
        self.must_https = must_https
        # The domain name.
        self.name = name
        # The protocol.
        self.protocol = protocol
        # The status of the domain name. Valid values:
        # 
        # *   0: unpublish
        # *   2: publishing
        # *   3: published
        # *   4: editing
        # *   5: unpublishing
        # *   6: unavailable
        self.status = status
        # The maximum version of Transport Layer Security (TLS).
        self.tls_max = tls_max
        # The minimum version of TLS.
        self.tls_min = tls_min
        # The type.
        self.type = type

    def validate(self):
        if self.comment:
            self.comment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_before_date is not None:
            result['CertBeforeDate'] = self.cert_before_date
        if self.cert_identifier is not None:
            result['CertIdentifier'] = self.cert_identifier
        if self.comment is not None:
            result['Comment'] = self.comment.to_map()
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.http_2 is not None:
            result['Http2'] = self.http_2
        if self.id is not None:
            result['Id'] = self.id
        if self.must_https is not None:
            result['MustHttps'] = self.must_https
        if self.name is not None:
            result['Name'] = self.name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.status is not None:
            result['Status'] = self.status
        if self.tls_max is not None:
            result['TlsMax'] = self.tls_max
        if self.tls_min is not None:
            result['TlsMin'] = self.tls_min
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CertBeforeDate') is not None:
            self.cert_before_date = m.get('CertBeforeDate')
        if m.get('CertIdentifier') is not None:
            self.cert_identifier = m.get('CertIdentifier')
        if m.get('Comment') is not None:
            temp_model = ListGatewayDomainResponseBodyDataComment()
            self.comment = temp_model.from_map(m['Comment'])
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Http2') is not None:
            self.http_2 = m.get('Http2')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MustHttps') is not None:
            self.must_https = m.get('MustHttps')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TlsMax') is not None:
            self.tls_max = m.get('TlsMax')
        if m.get('TlsMin') is not None:
            self.tls_min = m.get('TlsMin')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListGatewayDomainResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[ListGatewayDomainResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data of the node.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListGatewayDomainResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListGatewayDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGatewayDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGatewayDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGatewayRouteRequestFilterParams(TeaModel):
    def __init__(
        self,
        default_service_id: int = None,
        domain_id: int = None,
        domain_name: str = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        name: str = None,
        route_order: int = None,
        status: int = None,
    ):
        # The default service ID.
        self.default_service_id = default_service_id
        # The domain ID.
        self.domain_id = domain_id
        # The associated domain name.
        self.domain_name = domain_name
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The name of the gateway.
        self.name = name
        # The order.
        self.route_order = route_order
        # The status.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_service_id is not None:
            result['DefaultServiceId'] = self.default_service_id
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.name is not None:
            result['Name'] = self.name
        if self.route_order is not None:
            result['RouteOrder'] = self.route_order
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultServiceId') is not None:
            self.default_service_id = m.get('DefaultServiceId')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RouteOrder') is not None:
            self.route_order = m.get('RouteOrder')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListGatewayRouteRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        desc_sort: bool = None,
        filter_params: ListGatewayRouteRequestFilterParams = None,
        order_item: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # Specifies whether to enable sorting.
        self.desc_sort = desc_sort
        # The parameters that specify filter conditions. The parameters are in the format of {"key1":"value1"}.
        self.filter_params = filter_params
        # The item based on which entries are sorted.
        self.order_item = order_item
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        if self.filter_params:
            self.filter_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.desc_sort is not None:
            result['DescSort'] = self.desc_sort
        if self.filter_params is not None:
            result['FilterParams'] = self.filter_params.to_map()
        if self.order_item is not None:
            result['OrderItem'] = self.order_item
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DescSort') is not None:
            self.desc_sort = m.get('DescSort')
        if m.get('FilterParams') is not None:
            temp_model = ListGatewayRouteRequestFilterParams()
            self.filter_params = temp_model.from_map(m['FilterParams'])
        if m.get('OrderItem') is not None:
            self.order_item = m.get('OrderItem')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListGatewayRouteShrinkRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        desc_sort: bool = None,
        filter_params_shrink: str = None,
        order_item: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # Specifies whether to enable sorting.
        self.desc_sort = desc_sort
        # The parameters that specify filter conditions. The parameters are in the format of {"key1":"value1"}.
        self.filter_params_shrink = filter_params_shrink
        # The item based on which entries are sorted.
        self.order_item = order_item
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.desc_sort is not None:
            result['DescSort'] = self.desc_sort
        if self.filter_params_shrink is not None:
            result['FilterParams'] = self.filter_params_shrink
        if self.order_item is not None:
            result['OrderItem'] = self.order_item
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DescSort') is not None:
            self.desc_sort = m.get('DescSort')
        if m.get('FilterParams') is not None:
            self.filter_params_shrink = m.get('FilterParams')
        if m.get('OrderItem') is not None:
            self.order_item = m.get('OrderItem')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListGatewayRouteResponseBodyDataResultComment(TeaModel):
    def __init__(
        self,
        status: str = None,
    ):
        # The status.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListGatewayRouteResponseBodyDataResultDirectResponse(TeaModel):
    def __init__(
        self,
        body: str = None,
        code: int = None,
    ):
        # The return value for service mocking.
        self.body = body
        # The response code returned.
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['Body'] = self.body
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Body') is not None:
            self.body = m.get('Body')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class ListGatewayRouteResponseBodyDataResultFallbackServices(TeaModel):
    def __init__(
        self,
        agreement_type: str = None,
        group_name: str = None,
        name: str = None,
        namespace: str = None,
        percent: int = None,
        service_id: int = None,
        service_name: str = None,
        service_port: int = None,
        source_type: str = None,
        version: str = None,
    ):
        # The type of the protocol.
        self.agreement_type = agreement_type
        # The name of the group to which the service belongs.
        self.group_name = group_name
        # The name.
        self.name = name
        # The namespace to which the service belongs.
        self.namespace = namespace
        # The weight in the form of a percentage value.
        self.percent = percent
        # The ID of the service.
        self.service_id = service_id
        # The name of the service.
        self.service_name = service_name
        # The service port number.
        self.service_port = service_port
        # The source type.
        self.source_type = source_type
        # The version of the service.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agreement_type is not None:
            result['AgreementType'] = self.agreement_type
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgreementType') is not None:
            self.agreement_type = m.get('AgreementType')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class ListGatewayRouteResponseBodyDataResultRedirect(TeaModel):
    def __init__(
        self,
        code: int = None,
        host: str = None,
        path: str = None,
    ):
        # The response code returned.
        self.code = code
        # The hostname to be redirected to.
        self.host = host
        # The path.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.host is not None:
            result['Host'] = self.host
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class ListGatewayRouteResponseBodyDataResultRoutePredicatesHeaderPredicates(TeaModel):
    def __init__(
        self,
        key: str = None,
        type: str = None,
        value: str = None,
    ):
        # Header KEY
        self.key = key
        # The matching type.
        self.type = type
        # The value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListGatewayRouteResponseBodyDataResultRoutePredicatesPathPredicates(TeaModel):
    def __init__(
        self,
        ignore_case: bool = None,
        path: str = None,
        type: str = None,
    ):
        # Indicates whether case sensitivity is ignored.
        self.ignore_case = ignore_case
        # The path of the node.
        self.path = path
        # The matching type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignore_case is not None:
            result['IgnoreCase'] = self.ignore_case
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoreCase') is not None:
            self.ignore_case = m.get('IgnoreCase')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListGatewayRouteResponseBodyDataResultRoutePredicatesQueryPredicates(TeaModel):
    def __init__(
        self,
        key: str = None,
        type: str = None,
        value: str = None,
    ):
        # The key.
        self.key = key
        # The matching type.
        self.type = type
        # The value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListGatewayRouteResponseBodyDataResultRoutePredicates(TeaModel):
    def __init__(
        self,
        header_predicates: List[ListGatewayRouteResponseBodyDataResultRoutePredicatesHeaderPredicates] = None,
        method_predicates: List[str] = None,
        path_predicates: ListGatewayRouteResponseBodyDataResultRoutePredicatesPathPredicates = None,
        query_predicates: List[ListGatewayRouteResponseBodyDataResultRoutePredicatesQueryPredicates] = None,
    ):
        # The headers used for route matching.
        self.header_predicates = header_predicates
        # The HTTP methods used for route matching.
        self.method_predicates = method_predicates
        # The path used for route matching.
        self.path_predicates = path_predicates
        # The parameters used for route matching.
        self.query_predicates = query_predicates

    def validate(self):
        if self.header_predicates:
            for k in self.header_predicates:
                if k:
                    k.validate()
        if self.path_predicates:
            self.path_predicates.validate()
        if self.query_predicates:
            for k in self.query_predicates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HeaderPredicates'] = []
        if self.header_predicates is not None:
            for k in self.header_predicates:
                result['HeaderPredicates'].append(k.to_map() if k else None)
        if self.method_predicates is not None:
            result['MethodPredicates'] = self.method_predicates
        if self.path_predicates is not None:
            result['PathPredicates'] = self.path_predicates.to_map()
        result['QueryPredicates'] = []
        if self.query_predicates is not None:
            for k in self.query_predicates:
                result['QueryPredicates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.header_predicates = []
        if m.get('HeaderPredicates') is not None:
            for k in m.get('HeaderPredicates'):
                temp_model = ListGatewayRouteResponseBodyDataResultRoutePredicatesHeaderPredicates()
                self.header_predicates.append(temp_model.from_map(k))
        if m.get('MethodPredicates') is not None:
            self.method_predicates = m.get('MethodPredicates')
        if m.get('PathPredicates') is not None:
            temp_model = ListGatewayRouteResponseBodyDataResultRoutePredicatesPathPredicates()
            self.path_predicates = temp_model.from_map(m['PathPredicates'])
        self.query_predicates = []
        if m.get('QueryPredicates') is not None:
            for k in m.get('QueryPredicates'):
                temp_model = ListGatewayRouteResponseBodyDataResultRoutePredicatesQueryPredicates()
                self.query_predicates.append(temp_model.from_map(k))
        return self


class ListGatewayRouteResponseBodyDataResultRouteServicesHttpDubboTranscoderMothedMapListParamMapsList(TeaModel):
    def __init__(
        self,
        extract_key: str = None,
        extract_key_spec: str = None,
        mapping_type: str = None,
    ):
        # The key extracted from the input parameter.
        self.extract_key = extract_key
        # The position of the input parameter.
        # 
        # > Valid values:
        # 
        # *   `ALL_QUERY_PARAMETER`: request parameter
        # 
        # *   `ALL_HEADER`: request header
        # 
        # *   `ALL_PATH`: request path
        # 
        # *   `ALL_BODY`: request body
        self.extract_key_spec = extract_key_spec
        # The type of the backend service parameter.
        self.mapping_type = mapping_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extract_key is not None:
            result['ExtractKey'] = self.extract_key
        if self.extract_key_spec is not None:
            result['ExtractKeySpec'] = self.extract_key_spec
        if self.mapping_type is not None:
            result['MappingType'] = self.mapping_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtractKey') is not None:
            self.extract_key = m.get('ExtractKey')
        if m.get('ExtractKeySpec') is not None:
            self.extract_key_spec = m.get('ExtractKeySpec')
        if m.get('MappingType') is not None:
            self.mapping_type = m.get('MappingType')
        return self


class ListGatewayRouteResponseBodyDataResultRouteServicesHttpDubboTranscoderMothedMapList(TeaModel):
    def __init__(
        self,
        dubbo_mothed_name: str = None,
        http_mothed: str = None,
        mothedpath: str = None,
        param_maps_list: List[ListGatewayRouteResponseBodyDataResultRouteServicesHttpDubboTranscoderMothedMapListParamMapsList] = None,
        pass_through_all_headers: str = None,
        pass_through_list: List[str] = None,
    ):
        # The method name of the Dubbo service.
        self.dubbo_mothed_name = dubbo_mothed_name
        # The HTTP method.
        # 
        # > Valid values:
        # 
        # *   ALL_GET
        # 
        # *   ALL_POST
        # 
        # *   ALL_PUT
        # 
        # *   ALL_DELETE
        # 
        # *   ALL_PATCH
        self.http_mothed = http_mothed
        # The path used for method matching.
        self.mothedpath = mothedpath
        # The information about parameter mappings.
        self.param_maps_list = param_maps_list
        # The pass-through type of the header.
        # 
        # > Valid values:
        # 
        # *   PASS_ALL: All headers are passed through.
        # 
        # *   PASS_NOT: All headers are not passed through.
        # 
        # *   PASS_ASSIGN: Specified headers are passed through.
        self.pass_through_all_headers = pass_through_all_headers
        # The list of headers to be passed through.
        self.pass_through_list = pass_through_list

    def validate(self):
        if self.param_maps_list:
            for k in self.param_maps_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dubbo_mothed_name is not None:
            result['DubboMothedName'] = self.dubbo_mothed_name
        if self.http_mothed is not None:
            result['HttpMothed'] = self.http_mothed
        if self.mothedpath is not None:
            result['Mothedpath'] = self.mothedpath
        result['ParamMapsList'] = []
        if self.param_maps_list is not None:
            for k in self.param_maps_list:
                result['ParamMapsList'].append(k.to_map() if k else None)
        if self.pass_through_all_headers is not None:
            result['PassThroughAllHeaders'] = self.pass_through_all_headers
        if self.pass_through_list is not None:
            result['PassThroughList'] = self.pass_through_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DubboMothedName') is not None:
            self.dubbo_mothed_name = m.get('DubboMothedName')
        if m.get('HttpMothed') is not None:
            self.http_mothed = m.get('HttpMothed')
        if m.get('Mothedpath') is not None:
            self.mothedpath = m.get('Mothedpath')
        self.param_maps_list = []
        if m.get('ParamMapsList') is not None:
            for k in m.get('ParamMapsList'):
                temp_model = ListGatewayRouteResponseBodyDataResultRouteServicesHttpDubboTranscoderMothedMapListParamMapsList()
                self.param_maps_list.append(temp_model.from_map(k))
        if m.get('PassThroughAllHeaders') is not None:
            self.pass_through_all_headers = m.get('PassThroughAllHeaders')
        if m.get('PassThroughList') is not None:
            self.pass_through_list = m.get('PassThroughList')
        return self


class ListGatewayRouteResponseBodyDataResultRouteServicesHttpDubboTranscoder(TeaModel):
    def __init__(
        self,
        dubbo_service_group: str = None,
        dubbo_service_name: str = None,
        dubbo_service_version: str = None,
        mothed_map_list: List[ListGatewayRouteResponseBodyDataResultRouteServicesHttpDubboTranscoderMothedMapList] = None,
    ):
        # The Dubbo service group.
        self.dubbo_service_group = dubbo_service_group
        # The name of the Dubbo service.
        self.dubbo_service_name = dubbo_service_name
        # The version of the Dubbo service.
        self.dubbo_service_version = dubbo_service_version
        # The forwarding rules of the Dubbo service.
        self.mothed_map_list = mothed_map_list

    def validate(self):
        if self.mothed_map_list:
            for k in self.mothed_map_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dubbo_service_group is not None:
            result['DubboServiceGroup'] = self.dubbo_service_group
        if self.dubbo_service_name is not None:
            result['DubboServiceName'] = self.dubbo_service_name
        if self.dubbo_service_version is not None:
            result['DubboServiceVersion'] = self.dubbo_service_version
        result['MothedMapList'] = []
        if self.mothed_map_list is not None:
            for k in self.mothed_map_list:
                result['MothedMapList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DubboServiceGroup') is not None:
            self.dubbo_service_group = m.get('DubboServiceGroup')
        if m.get('DubboServiceName') is not None:
            self.dubbo_service_name = m.get('DubboServiceName')
        if m.get('DubboServiceVersion') is not None:
            self.dubbo_service_version = m.get('DubboServiceVersion')
        self.mothed_map_list = []
        if m.get('MothedMapList') is not None:
            for k in m.get('MothedMapList'):
                temp_model = ListGatewayRouteResponseBodyDataResultRouteServicesHttpDubboTranscoderMothedMapList()
                self.mothed_map_list.append(temp_model.from_map(k))
        return self


class ListGatewayRouteResponseBodyDataResultRouteServices(TeaModel):
    def __init__(
        self,
        agreement_type: str = None,
        group_name: str = None,
        http_dubbo_transcoder: ListGatewayRouteResponseBodyDataResultRouteServicesHttpDubboTranscoder = None,
        name: str = None,
        namespace: str = None,
        percent: int = None,
        service_id: int = None,
        service_name: str = None,
        service_port: int = None,
        source_type: str = None,
        version: str = None,
    ):
        # The type of the protocol.
        self.agreement_type = agreement_type
        # The name of the group to which the service belongs.
        self.group_name = group_name
        # The transcoder of the Dubbo protocol.
        self.http_dubbo_transcoder = http_dubbo_transcoder
        # The name.
        self.name = name
        # The namespace.
        self.namespace = namespace
        # The weight in the form of a percentage value.
        self.percent = percent
        # The ID of the service.
        self.service_id = service_id
        # The name of the service.
        self.service_name = service_name
        # The Dubbo port number.
        self.service_port = service_port
        # The source type.
        self.source_type = source_type
        # The version of the service.
        self.version = version

    def validate(self):
        if self.http_dubbo_transcoder:
            self.http_dubbo_transcoder.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agreement_type is not None:
            result['AgreementType'] = self.agreement_type
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.http_dubbo_transcoder is not None:
            result['HttpDubboTranscoder'] = self.http_dubbo_transcoder.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgreementType') is not None:
            self.agreement_type = m.get('AgreementType')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HttpDubboTranscoder') is not None:
            temp_model = ListGatewayRouteResponseBodyDataResultRouteServicesHttpDubboTranscoder()
            self.http_dubbo_transcoder = temp_model.from_map(m['HttpDubboTranscoder'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class ListGatewayRouteResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        comment: ListGatewayRouteResponseBodyDataResultComment = None,
        default_service_id: int = None,
        default_service_name: str = None,
        destination_type: str = None,
        direct_response: ListGatewayRouteResponseBodyDataResultDirectResponse = None,
        domain_id: int = None,
        domain_id_list: List[int] = None,
        domain_name: str = None,
        domain_name_list: List[str] = None,
        enable_waf: str = None,
        fallback: bool = None,
        fallback_services: List[ListGatewayRouteResponseBodyDataResultFallbackServices] = None,
        gateway_id: int = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        name: str = None,
        predicates: str = None,
        redirect: ListGatewayRouteResponseBodyDataResultRedirect = None,
        route_order: int = None,
        route_predicates: ListGatewayRouteResponseBodyDataResultRoutePredicates = None,
        route_services: List[ListGatewayRouteResponseBodyDataResultRouteServices] = None,
        services: str = None,
        status: int = None,
        type: str = None,
    ):
        # The route comment (ingress).
        self.comment = comment
        # The default service ID.
        self.default_service_id = default_service_id
        # The default service name.
        self.default_service_name = default_service_name
        # The destination service type.
        self.destination_type = destination_type
        # The information about service mocking.
        self.direct_response = direct_response
        # The domain ID.
        self.domain_id = domain_id
        # The IDs of domains.
        self.domain_id_list = domain_id_list
        # The domain name.
        self.domain_name = domain_name
        # The list of domain names.
        self.domain_name_list = domain_name_list
        # Specifies whether to activate Web Application Firewall (WAF).
        self.enable_waf = enable_waf
        # Specifies whether to enable the Fallback service.
        self.fallback = fallback
        # The information about the Fallback service.
        self.fallback_services = fallback_services
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The creation time.
        self.gmt_create = gmt_create
        # The modification time.
        self.gmt_modified = gmt_modified
        # The ID.
        self.id = id
        # The name.
        self.name = name
        # The matching rules.
        self.predicates = predicates
        # The information about redirection.
        self.redirect = redirect
        # The order.
        self.route_order = route_order
        # The matching rules.
        self.route_predicates = route_predicates
        # The information about services.
        self.route_services = route_services
        # The information about services.
        self.services = services
        # The status.
        self.status = status
        # The route type.
        self.type = type

    def validate(self):
        if self.comment:
            self.comment.validate()
        if self.direct_response:
            self.direct_response.validate()
        if self.fallback_services:
            for k in self.fallback_services:
                if k:
                    k.validate()
        if self.redirect:
            self.redirect.validate()
        if self.route_predicates:
            self.route_predicates.validate()
        if self.route_services:
            for k in self.route_services:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment.to_map()
        if self.default_service_id is not None:
            result['DefaultServiceId'] = self.default_service_id
        if self.default_service_name is not None:
            result['DefaultServiceName'] = self.default_service_name
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.direct_response is not None:
            result['DirectResponse'] = self.direct_response.to_map()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_id_list is not None:
            result['DomainIdList'] = self.domain_id_list
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_name_list is not None:
            result['DomainNameList'] = self.domain_name_list
        if self.enable_waf is not None:
            result['EnableWaf'] = self.enable_waf
        if self.fallback is not None:
            result['Fallback'] = self.fallback
        result['FallbackServices'] = []
        if self.fallback_services is not None:
            for k in self.fallback_services:
                result['FallbackServices'].append(k.to_map() if k else None)
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.predicates is not None:
            result['Predicates'] = self.predicates
        if self.redirect is not None:
            result['Redirect'] = self.redirect.to_map()
        if self.route_order is not None:
            result['RouteOrder'] = self.route_order
        if self.route_predicates is not None:
            result['RoutePredicates'] = self.route_predicates.to_map()
        result['RouteServices'] = []
        if self.route_services is not None:
            for k in self.route_services:
                result['RouteServices'].append(k.to_map() if k else None)
        if self.services is not None:
            result['Services'] = self.services
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            temp_model = ListGatewayRouteResponseBodyDataResultComment()
            self.comment = temp_model.from_map(m['Comment'])
        if m.get('DefaultServiceId') is not None:
            self.default_service_id = m.get('DefaultServiceId')
        if m.get('DefaultServiceName') is not None:
            self.default_service_name = m.get('DefaultServiceName')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('DirectResponse') is not None:
            temp_model = ListGatewayRouteResponseBodyDataResultDirectResponse()
            self.direct_response = temp_model.from_map(m['DirectResponse'])
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainIdList') is not None:
            self.domain_id_list = m.get('DomainIdList')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainNameList') is not None:
            self.domain_name_list = m.get('DomainNameList')
        if m.get('EnableWaf') is not None:
            self.enable_waf = m.get('EnableWaf')
        if m.get('Fallback') is not None:
            self.fallback = m.get('Fallback')
        self.fallback_services = []
        if m.get('FallbackServices') is not None:
            for k in m.get('FallbackServices'):
                temp_model = ListGatewayRouteResponseBodyDataResultFallbackServices()
                self.fallback_services.append(temp_model.from_map(k))
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Predicates') is not None:
            self.predicates = m.get('Predicates')
        if m.get('Redirect') is not None:
            temp_model = ListGatewayRouteResponseBodyDataResultRedirect()
            self.redirect = temp_model.from_map(m['Redirect'])
        if m.get('RouteOrder') is not None:
            self.route_order = m.get('RouteOrder')
        if m.get('RoutePredicates') is not None:
            temp_model = ListGatewayRouteResponseBodyDataResultRoutePredicates()
            self.route_predicates = temp_model.from_map(m['RoutePredicates'])
        self.route_services = []
        if m.get('RouteServices') is not None:
            for k in m.get('RouteServices'):
                temp_model = ListGatewayRouteResponseBodyDataResultRouteServices()
                self.route_services.append(temp_model.from_map(k))
        if m.get('Services') is not None:
            self.services = m.get('Services')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListGatewayRouteResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        result: List[ListGatewayRouteResponseBodyDataResult] = None,
        total_size: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The data structure.
        self.result = result
        # The total number of entries returned.
        self.total_size = total_size

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = ListGatewayRouteResponseBodyDataResult()
                self.result.append(temp_model.from_map(k))
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class ListGatewayRouteResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ListGatewayRouteResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListGatewayRouteResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListGatewayRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGatewayRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGatewayRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGatewayServiceRequestFilterParams(TeaModel):
    def __init__(
        self,
        gateway_unique_id: str = None,
        group_name: str = None,
        name: str = None,
        namespace: str = None,
        service_protocol: str = None,
        source_type: str = None,
    ):
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The group.
        self.group_name = group_name
        # The name of the service.
        self.name = name
        # The namespace.
        self.namespace = namespace
        # The protocol of the service.
        # 
        # *   HTTP
        # *   HTTPS
        # *   HTTP2
        # *   GRPC
        # *   DUBBO
        self.service_protocol = service_protocol
        # The type of the service source.
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.service_protocol is not None:
            result['ServiceProtocol'] = self.service_protocol
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('ServiceProtocol') is not None:
            self.service_protocol = m.get('ServiceProtocol')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class ListGatewayServiceRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        desc_sort: bool = None,
        filter_params: ListGatewayServiceRequestFilterParams = None,
        order_item: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # Specifies whether to enable sorting.
        self.desc_sort = desc_sort
        # The parameters that specify filter conditions, which are in the format of {"key1":"value1"}.
        self.filter_params = filter_params
        # The item based on which entries are sorted.
        self.order_item = order_item
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        if self.filter_params:
            self.filter_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.desc_sort is not None:
            result['DescSort'] = self.desc_sort
        if self.filter_params is not None:
            result['FilterParams'] = self.filter_params.to_map()
        if self.order_item is not None:
            result['OrderItem'] = self.order_item
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DescSort') is not None:
            self.desc_sort = m.get('DescSort')
        if m.get('FilterParams') is not None:
            temp_model = ListGatewayServiceRequestFilterParams()
            self.filter_params = temp_model.from_map(m['FilterParams'])
        if m.get('OrderItem') is not None:
            self.order_item = m.get('OrderItem')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListGatewayServiceShrinkRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        desc_sort: bool = None,
        filter_params_shrink: str = None,
        order_item: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # Specifies whether to enable sorting.
        self.desc_sort = desc_sort
        # The parameters that specify filter conditions, which are in the format of {"key1":"value1"}.
        self.filter_params_shrink = filter_params_shrink
        # The item based on which entries are sorted.
        self.order_item = order_item
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.desc_sort is not None:
            result['DescSort'] = self.desc_sort
        if self.filter_params_shrink is not None:
            result['FilterParams'] = self.filter_params_shrink
        if self.order_item is not None:
            result['OrderItem'] = self.order_item
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DescSort') is not None:
            self.desc_sort = m.get('DescSort')
        if m.get('FilterParams') is not None:
            self.filter_params_shrink = m.get('FilterParams')
        if m.get('OrderItem') is not None:
            self.order_item = m.get('OrderItem')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyLoadBalancerSettingsConsistentHashLBConfigHttpCookie(TeaModel):
    def __init__(
        self,
        name: str = None,
        path: str = None,
        ttl: str = None,
    ):
        # The name of the cookie.
        self.name = name
        # The path of the cookie.
        self.path = path
        # The lifecycle of the cookie.
        self.ttl = ttl

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        return self


class ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyLoadBalancerSettingsConsistentHashLBConfig(TeaModel):
    def __init__(
        self,
        consistent_hash_lbtype: str = None,
        http_cookie: ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyLoadBalancerSettingsConsistentHashLBConfigHttpCookie = None,
        minimum_ring_size: int = None,
        parameter_name: str = None,
    ):
        # The type based on which consistent hashing load balancing is performed.
        # 
        # *   HEADER
        # *   COOKIE
        # *   SOURCE_IP
        # *   QUERY_PARAMETER
        self.consistent_hash_lbtype = consistent_hash_lbtype
        # The cookie-based load balancing parameters.
        self.http_cookie = http_cookie
        # The minimum value of the hash ring.
        self.minimum_ring_size = minimum_ring_size
        # The name of the parameter.
        self.parameter_name = parameter_name

    def validate(self):
        if self.http_cookie:
            self.http_cookie.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consistent_hash_lbtype is not None:
            result['ConsistentHashLBType'] = self.consistent_hash_lbtype
        if self.http_cookie is not None:
            result['HttpCookie'] = self.http_cookie.to_map()
        if self.minimum_ring_size is not None:
            result['MinimumRingSize'] = self.minimum_ring_size
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsistentHashLBType') is not None:
            self.consistent_hash_lbtype = m.get('ConsistentHashLBType')
        if m.get('HttpCookie') is not None:
            temp_model = ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyLoadBalancerSettingsConsistentHashLBConfigHttpCookie()
            self.http_cookie = temp_model.from_map(m['HttpCookie'])
        if m.get('MinimumRingSize') is not None:
            self.minimum_ring_size = m.get('MinimumRingSize')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyLoadBalancerSettings(TeaModel):
    def __init__(
        self,
        consistent_hash_lbconfig: ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyLoadBalancerSettingsConsistentHashLBConfig = None,
        loadbalancer_type: str = None,
        warmup_duration: int = None,
    ):
        # The consistent hashing settings.
        self.consistent_hash_lbconfig = consistent_hash_lbconfig
        # The load balancing type.
        # 
        # *   ROUND_ROBIN
        # *   LEAST_CONN
        # *   RANDOM
        # *   CONSISTENT_HASH
        self.loadbalancer_type = loadbalancer_type
        # The prefetch time of the least connection load balancing.
        self.warmup_duration = warmup_duration

    def validate(self):
        if self.consistent_hash_lbconfig:
            self.consistent_hash_lbconfig.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consistent_hash_lbconfig is not None:
            result['ConsistentHashLBConfig'] = self.consistent_hash_lbconfig.to_map()
        if self.loadbalancer_type is not None:
            result['LoadbalancerType'] = self.loadbalancer_type
        if self.warmup_duration is not None:
            result['WarmupDuration'] = self.warmup_duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsistentHashLBConfig') is not None:
            temp_model = ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyLoadBalancerSettingsConsistentHashLBConfig()
            self.consistent_hash_lbconfig = temp_model.from_map(m['ConsistentHashLBConfig'])
        if m.get('LoadbalancerType') is not None:
            self.loadbalancer_type = m.get('LoadbalancerType')
        if m.get('WarmupDuration') is not None:
            self.warmup_duration = m.get('WarmupDuration')
        return self


class ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyTls(TeaModel):
    def __init__(
        self,
        ca_cert_content: str = None,
        ca_cert_id: str = None,
        cert_id: str = None,
        mode: str = None,
        sni: str = None,
        subject_alt_names: List[str] = None,
    ):
        # The public key of the CA certificate .
        self.ca_cert_content = ca_cert_content
        # The ID of the certification authority (CA) certificate.
        self.ca_cert_id = ca_cert_id
        # The ID of the certificate.
        self.cert_id = cert_id
        # The TLS mode.
        # 
        # *   DISABLE
        # *   SIMPLE
        # *   MUTUAL
        # *   ISTIO_MUTUAL
        self.mode = mode
        # The Server Name Indication (SNI) value.
        self.sni = sni
        # The array of subject aliases.
        self.subject_alt_names = subject_alt_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ca_cert_content is not None:
            result['CaCertContent'] = self.ca_cert_content
        if self.ca_cert_id is not None:
            result['CaCertId'] = self.ca_cert_id
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.sni is not None:
            result['Sni'] = self.sni
        if self.subject_alt_names is not None:
            result['SubjectAltNames'] = self.subject_alt_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CaCertContent') is not None:
            self.ca_cert_content = m.get('CaCertContent')
        if m.get('CaCertId') is not None:
            self.ca_cert_id = m.get('CaCertId')
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Sni') is not None:
            self.sni = m.get('Sni')
        if m.get('SubjectAltNames') is not None:
            self.subject_alt_names = m.get('SubjectAltNames')
        return self


class ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicy(TeaModel):
    def __init__(
        self,
        load_balancer_settings: ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyLoadBalancerSettings = None,
        tls: ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyTls = None,
    ):
        # The load balancing settings.
        self.load_balancer_settings = load_balancer_settings
        # The Transport Layer Security (TLS).
        self.tls = tls

    def validate(self):
        if self.load_balancer_settings:
            self.load_balancer_settings.validate()
        if self.tls:
            self.tls.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.load_balancer_settings is not None:
            result['LoadBalancerSettings'] = self.load_balancer_settings.to_map()
        if self.tls is not None:
            result['Tls'] = self.tls.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LoadBalancerSettings') is not None:
            temp_model = ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyLoadBalancerSettings()
            self.load_balancer_settings = temp_model.from_map(m['LoadBalancerSettings'])
        if m.get('Tls') is not None:
            temp_model = ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicyTls()
            self.tls = temp_model.from_map(m['Tls'])
        return self


class ListGatewayServiceResponseBodyDataResultHealthCheckInfo(TeaModel):
    def __init__(
        self,
        check: bool = None,
        expected_statuses: List[int] = None,
        healthy_threshold: int = None,
        http_host: str = None,
        http_path: str = None,
        interval: int = None,
        protocol: str = None,
        timeout: int = None,
        unhealthy_threshold: int = None,
    ):
        # Indicates whether checks are performed.
        self.check = check
        # The expected status of the health check.
        self.expected_statuses = expected_statuses
        # The threshold for healthy instances.
        self.healthy_threshold = healthy_threshold
        # The URL of the HTTP request for the health check.
        self.http_host = http_host
        # The path to which the HTTP request for the health check is sent.
        self.http_path = http_path
        # The health check interval.
        self.interval = interval
        # The network protocol.
        self.protocol = protocol
        # The timeout period.
        self.timeout = timeout
        # The threshold for unhealthy instances.
        self.unhealthy_threshold = unhealthy_threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check is not None:
            result['Check'] = self.check
        if self.expected_statuses is not None:
            result['ExpectedStatuses'] = self.expected_statuses
        if self.healthy_threshold is not None:
            result['HealthyThreshold'] = self.healthy_threshold
        if self.http_host is not None:
            result['HttpHost'] = self.http_host
        if self.http_path is not None:
            result['HttpPath'] = self.http_path
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.unhealthy_threshold is not None:
            result['UnhealthyThreshold'] = self.unhealthy_threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Check') is not None:
            self.check = m.get('Check')
        if m.get('ExpectedStatuses') is not None:
            self.expected_statuses = m.get('ExpectedStatuses')
        if m.get('HealthyThreshold') is not None:
            self.healthy_threshold = m.get('HealthyThreshold')
        if m.get('HttpHost') is not None:
            self.http_host = m.get('HttpHost')
        if m.get('HttpPath') is not None:
            self.http_path = m.get('HttpPath')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('UnhealthyThreshold') is not None:
            self.unhealthy_threshold = m.get('UnhealthyThreshold')
        return self


class ListGatewayServiceResponseBodyDataResultVersions(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # The version number.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListGatewayServiceResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        gateway_id: int = None,
        gateway_traffic_policy: ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicy = None,
        gateway_unique_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        group_name: str = None,
        healeh_status: str = None,
        health_check: bool = None,
        health_check_info: ListGatewayServiceResponseBodyDataResultHealthCheckInfo = None,
        health_status: str = None,
        id: int = None,
        ips: List[str] = None,
        meta_info: str = None,
        name: str = None,
        namespace: str = None,
        ports: List[int] = None,
        service_name_in_registry: str = None,
        service_port: int = None,
        service_protocol: str = None,
        source_id: int = None,
        source_type: str = None,
        unhealthy_endpoints: List[str] = None,
        versions: List[ListGatewayServiceResponseBodyDataResultVersions] = None,
    ):
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The traffic management policy.
        self.gateway_traffic_policy = gateway_traffic_policy
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id
        # The time when the service was created.
        self.gmt_create = gmt_create
        # The time when the service was last modified.
        self.gmt_modified = gmt_modified
        # The group.
        self.group_name = group_name
        # The health status.
        # 
        # *   Health
        # *   Unhealthy
        # *   Unknown
        self.healeh_status = healeh_status
        # Indicates whether health checks are performed.
        self.health_check = health_check
        # The information about health checks.
        self.health_check_info = health_check_info
        # The health status.
        # 
        # *   Health
        # *   Unhealthy
        # *   Unknown
        self.health_status = health_status
        # The ID.
        self.id = id
        # The IP addresses of the service.
        self.ips = ips
        # The metadata or IP addresses of the service.
        self.meta_info = meta_info
        # The name of the service.
        self.name = name
        # The namespace.
        self.namespace = namespace
        # The port array.
        self.ports = ports
        # The name of the service registered with the service registry.
        self.service_name_in_registry = service_name_in_registry
        # The service port.
        self.service_port = service_port
        # The protocol of the service.
        self.service_protocol = service_protocol
        # The ID of the service source.
        self.source_id = source_id
        # The type of the service source.
        self.source_type = source_type
        # The array of unhealthy endpoints.
        self.unhealthy_endpoints = unhealthy_endpoints
        # The version of the service.
        self.versions = versions

    def validate(self):
        if self.gateway_traffic_policy:
            self.gateway_traffic_policy.validate()
        if self.health_check_info:
            self.health_check_info.validate()
        if self.versions:
            for k in self.versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_traffic_policy is not None:
            result['GatewayTrafficPolicy'] = self.gateway_traffic_policy.to_map()
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.healeh_status is not None:
            result['HealehStatus'] = self.healeh_status
        if self.health_check is not None:
            result['HealthCheck'] = self.health_check
        if self.health_check_info is not None:
            result['HealthCheckInfo'] = self.health_check_info.to_map()
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.id is not None:
            result['Id'] = self.id
        if self.ips is not None:
            result['Ips'] = self.ips
        if self.meta_info is not None:
            result['MetaInfo'] = self.meta_info
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.ports is not None:
            result['Ports'] = self.ports
        if self.service_name_in_registry is not None:
            result['ServiceNameInRegistry'] = self.service_name_in_registry
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.service_protocol is not None:
            result['ServiceProtocol'] = self.service_protocol
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.unhealthy_endpoints is not None:
            result['UnhealthyEndpoints'] = self.unhealthy_endpoints
        result['Versions'] = []
        if self.versions is not None:
            for k in self.versions:
                result['Versions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewayTrafficPolicy') is not None:
            temp_model = ListGatewayServiceResponseBodyDataResultGatewayTrafficPolicy()
            self.gateway_traffic_policy = temp_model.from_map(m['GatewayTrafficPolicy'])
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HealehStatus') is not None:
            self.healeh_status = m.get('HealehStatus')
        if m.get('HealthCheck') is not None:
            self.health_check = m.get('HealthCheck')
        if m.get('HealthCheckInfo') is not None:
            temp_model = ListGatewayServiceResponseBodyDataResultHealthCheckInfo()
            self.health_check_info = temp_model.from_map(m['HealthCheckInfo'])
        if m.get('HealthStatus') is not None:
            self.health_status = m.get('HealthStatus')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Ips') is not None:
            self.ips = m.get('Ips')
        if m.get('MetaInfo') is not None:
            self.meta_info = m.get('MetaInfo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Ports') is not None:
            self.ports = m.get('Ports')
        if m.get('ServiceNameInRegistry') is not None:
            self.service_name_in_registry = m.get('ServiceNameInRegistry')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('ServiceProtocol') is not None:
            self.service_protocol = m.get('ServiceProtocol')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('UnhealthyEndpoints') is not None:
            self.unhealthy_endpoints = m.get('UnhealthyEndpoints')
        self.versions = []
        if m.get('Versions') is not None:
            for k in m.get('Versions'):
                temp_model = ListGatewayServiceResponseBodyDataResultVersions()
                self.versions.append(temp_model.from_map(k))
        return self


class ListGatewayServiceResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        result: List[ListGatewayServiceResponseBodyDataResult] = None,
        total_size: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page. Default value: 10.
        self.page_size = page_size
        # The returned information.
        self.result = result
        # The total number of entries returned.
        self.total_size = total_size

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = ListGatewayServiceResponseBodyDataResult()
                self.result.append(temp_model.from_map(k))
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class ListGatewayServiceResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ListGatewayServiceResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The return value.
        self.code = code
        # The returned data.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListGatewayServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListGatewayServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGatewayServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGatewayServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGatewaySlbRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        gateway_unique_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The unique ID of the gateway.
        self.gateway_unique_id = gateway_unique_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.gateway_unique_id is not None:
            result['GatewayUniqueId'] = self.gateway_unique_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('GatewayUniqueId') is not None:
            self.gateway_unique_id = m.get('GatewayUniqueId')
        return self


class ListGatewaySlbResponseBodyData(TeaModel):
    def __init__(
        self,
        edit_enable: bool = None,
        gateway_id: str = None,
        gateway_slb_mode: str = None,
        gateway_slb_status: str = None,
        gmt_create: str = None,
        http_port: int = None,
        https_port: int = None,
        https_vserver_group_id: str = None,
        id: str = None,
        service_weight: int = None,
        slb_id: str = None,
        slb_ip: str = None,
        slb_port: str = None,
        status_desc: str = None,
        type: str = None,
        vserver_group_id: str = None,
    ):
        # Indicates whether the edit operation is supported.
        self.edit_enable = edit_enable
        # The ID of the gateway.
        self.gateway_id = gateway_id
        # The mode of the SLB instance.
        self.gateway_slb_mode = gateway_slb_mode
        # The association status.
        self.gateway_slb_status = gateway_slb_status
        # The creation time.
        self.gmt_create = gmt_create
        # The port number of the HTTP virtual service group.
        self.http_port = http_port
        # The port number of the HTTPS virtual service group.
        self.https_port = https_port
        # The ID of the HTTPS virtual service group.
        self.https_vserver_group_id = https_vserver_group_id
        # ID
        self.id = id
        # The service weight.
        self.service_weight = service_weight
        # SLB ID
        self.slb_id = slb_id
        # SLB IP
        self.slb_ip = slb_ip
        # The port number of the SLB instance.
        self.slb_port = slb_port
        # The description of the status.
        self.status_desc = status_desc
        # The type.
        self.type = type
        # The ID of the HTTP virtual service group.
        self.vserver_group_id = vserver_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.edit_enable is not None:
            result['EditEnable'] = self.edit_enable
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gateway_slb_mode is not None:
            result['GatewaySlbMode'] = self.gateway_slb_mode
        if self.gateway_slb_status is not None:
            result['GatewaySlbStatus'] = self.gateway_slb_status
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.http_port is not None:
            result['HttpPort'] = self.http_port
        if self.https_port is not None:
            result['HttpsPort'] = self.https_port
        if self.https_vserver_group_id is not None:
            result['HttpsVServerGroupId'] = self.https_vserver_group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.service_weight is not None:
            result['ServiceWeight'] = self.service_weight
        if self.slb_id is not None:
            result['SlbId'] = self.slb_id
        if self.slb_ip is not None:
            result['SlbIp'] = self.slb_ip
        if self.slb_port is not None:
            result['SlbPort'] = self.slb_port
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.type is not None:
            result['Type'] = self.type
        if self.vserver_group_id is not None:
            result['VServerGroupId'] = self.vserver_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EditEnable') is not None:
            self.edit_enable = m.get('EditEnable')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GatewaySlbMode') is not None:
            self.gateway_slb_mode = m.get('GatewaySlbMode')
        if m.get('GatewaySlbStatus') is not None:
            self.gateway_slb_status = m.get('GatewaySlbStatus')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('HttpPort') is not None:
            self.http_port = m.get('HttpPort')
        if m.get('HttpsPort') is not None:
            self.https_port = m.get('HttpsPort')
        if m.get('HttpsVServerGroupId') is not None:
            self.https_vserver_group_id = m.get('HttpsVServerGroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ServiceWeight') is not None:
            self.service_weight = m.get('ServiceWeight')
        if m.get('SlbId') is not None:
            self.slb_id = m.get('SlbId')
        if m.get('SlbIp') is not None:
            self.slb_ip = m.get('SlbIp')
        if m.get('SlbPort') is not None:
            self.slb_port = m.get('SlbPort')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VServerGroupId') is not None:
            self.vserver_group_id = m.get('VServerGroupId')
        return self


class ListGatewaySlbResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[ListGatewaySlbResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data entries returned.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListGatewaySlbResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListGatewaySlbResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGatewaySlbResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGatewaySlbResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstanceCountRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        cluster_type: str = None,
        mse_version: str = None,
        region_id: str = None,
        request_pars: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The type of the instance. Valid values: ZooKeeper and Nacos-Ans.
        self.cluster_type = cluster_type
        # The edition type of the instance. Valid values:
        # 
        # *   `mse_dev`: Developer Edition
        # *   `mse_pro`: Professional Edition
        self.mse_version = mse_version
        # The ID of the region where the instance resides. Examples:
        # 
        # *   cn-hangzhou: China (Hangzhou)
        # *   cn-beijing: China (Beijing)
        # *   cn-shanghai: China (Shanghai)
        # *   cn-zhangjiakou: China (Zhangjiakou)
        # *   cn-shenzhen: China (Shenzhen)
        self.region_id = region_id
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.mse_version is not None:
            result['MseVersion'] = self.mse_version
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('MseVersion') is not None:
            self.mse_version = m.get('MseVersion')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        return self


class ListInstanceCountResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[int] = None,
        dynamic_code: str = None,
        dynamic_message: str = None,
        error_code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code. A value of 200 is returned if the request is successful.
        self.code = code
        # The data entries returned.
        self.data = data
        # The dynamic part in the error message.
        self.dynamic_code = dynamic_code
        # The dynamic part in the error message. This parameter is used to replace the \*\*%s\*\* variable in the **ErrMessage** parameter.
        # 
        # > If the return value of the **ErrMessage** parameter is **The Value of Input Parameter %s is not valid** and the return value of the **DynamicMessage** parameter is **DtsJobId**, the specified **DtsJobId** parameter is invalid.
        self.dynamic_message = dynamic_message
        # The error code returned if the request failed. If the request failed, the ErrorCode parameter is returned. For more information, see the "Error codes" section of this topic.
        self.error_code = error_code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The message returned. If the request is successful, a success message is returned. If the request fails, an error message is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   `true`: The request was successful.
        # *   `false`: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.dynamic_code is not None:
            result['DynamicCode'] = self.dynamic_code
        if self.dynamic_message is not None:
            result['DynamicMessage'] = self.dynamic_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DynamicCode') is not None:
            self.dynamic_code = m.get('DynamicCode')
        if m.get('DynamicMessage') is not None:
            self.dynamic_message = m.get('DynamicMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListInstanceCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListInstanceCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInstanceCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListListenersByConfigRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        data_id: str = None,
        group: str = None,
        instance_id: str = None,
        namespace_id: str = None,
        request_pars: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # *   zh: Chinese
        # *   en: English
        self.accept_language = accept_language
        # The ID of the data.
        self.data_id = data_id
        # The group.
        self.group = group
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The extended request parameters in the JSON format.
        self.request_pars = request_pars

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.data_id is not None:
            result['DataId'] = self.data_id
        if self.group is not None:
            result['Group'] = self.group
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.request_pars is not None:
            result['RequestPars'] = self.request_pars
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DataId') is not None:
            self.data_id = m.get('DataId')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('RequestPars') is not None:
            self.request_pars = m.get('RequestPars')
        return self


class ListListenersByConfigResponseBodyListeners(TeaModel):
    def __init__(
        self,
        ip: str = None,
        md_5: str = None,
        status: str = None,
    ):
        # The IP address.
        self.ip = ip
    