(function () {

    "use strict";

    var dashboard_management_test = function dashboard_management_test() {
        // Error reporting
        try {
            MashupPlatform.operator.outputs.output.connect(null);
            throw Exception();
        } catch (e) {
            if (!(e instanceof TypeError)) {
                throw e;
            }
        }

        try {
            MashupPlatform.operator.outputs.output.connect(MashupPlatform.operator.inputs.input);
            throw Exception();
        } catch (e) {
            if (!(e instanceof TypeError)) {
                throw e;
            }
        }

        try {
            MashupPlatform.mashup.addWidget(null);
            throw Exception();
        } catch (e) {
            if (!(e instanceof TypeError)) {
                throw e;
            }
        }

        try {
            MashupPlatform.mashup.addOperator(null);
            throw Exception();
        } catch (e) {
            if (!(e instanceof TypeError)) {
                throw e;
            }
        }

        // Flow 1: new widget directly connected to this operator
        var widget1 = MashupPlatform.mashup.addWidget('Wirecloud/api-test/0.9');
        MashupPlatform.operator.outputs.output.connect(widget1.inputs.inputendpoint);

        // Flow 2: new widget connected through a new operator
        var widget2 = MashupPlatform.mashup.addWidget('Wirecloud/api-test/0.9', {top: "50%", left: "50%"});
        var operator = MashupPlatform.mashup.addOperator('Wirecloud/TestOperator/1.0');
        MashupPlatform.operator.outputs.output.connect(operator.inputs.input);
        operator.outputs.output.connect(widget2.inputs.inputendpoint);

        MashupPlatform.operator.outputs.output.pushEvent('Success!!');
    };

    MashupPlatform.wiring.registerCallback('input', function (data) {
        if (data === 'typeerror') {
            throw new MashupPlatform.wiring.EndpointTypeError('invalid data format');
        } else if (data === 'valueerror') {
            throw new MashupPlatform.wiring.EndpointValueError('invalid value');
        } else if (data === 'dashboard_management_test') {
            try {
                dashboard_management_test();
            } catch (e) {
                MashupPlatform.wiring.pushEvent('output', 'Failure!!');
            }
            return;
        } else if (MashupPlatform.prefs.get('exception_on_event')) {
            throw new Error();
        }
        MashupPlatform.wiring.pushEvent('output', MashupPlatform.prefs.get('prefix') + data);
    });

    MashupPlatform.prefs.registerCallback(function (new_values) {
        if (new_values.test_logging === true) {
            MashupPlatform.operator.log('error message');
            MashupPlatform.operator.log('error message2', MashupPlatform.log.ERROR);
            MashupPlatform.operator.log('warn message', MashupPlatform.log.WARN);
            MashupPlatform.operator.log('info message', MashupPlatform.log.INFO);
        }
        MashupPlatform.wiring.pushEvent('output', 'preferences changed: ' + Object.keys(new_values));
    });

    if (MashupPlatform.prefs.get('register_status_callback')) {
        MashupPlatform.wiring.registerStatusCallback(function () {
            MashupPlatform.wiring.pushEvent('output', 'wiring modified');
        });
    }

})();
