# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CachePolicyConfig',
    'CachePolicyCookiesConfig',
    'CachePolicyHeadersConfig',
    'CachePolicyParametersInCacheKeyAndForwardedToOrigin',
    'CachePolicyQueryStringsConfig',
    'CloudFrontOriginAccessIdentityConfig',
    'DistributionCacheBehavior',
    'DistributionConfig',
    'DistributionCookies',
    'DistributionCustomErrorResponse',
    'DistributionCustomOriginConfig',
    'DistributionDefaultCacheBehavior',
    'DistributionForwardedValues',
    'DistributionFunctionAssociation',
    'DistributionGeoRestriction',
    'DistributionLambdaFunctionAssociation',
    'DistributionLegacyCustomOrigin',
    'DistributionLegacyS3Origin',
    'DistributionLogging',
    'DistributionOrigin',
    'DistributionOriginCustomHeader',
    'DistributionOriginGroup',
    'DistributionOriginGroupFailoverCriteria',
    'DistributionOriginGroupMember',
    'DistributionOriginGroupMembers',
    'DistributionOriginGroups',
    'DistributionOriginShield',
    'DistributionRestrictions',
    'DistributionS3OriginConfig',
    'DistributionStatusCodes',
    'DistributionTag',
    'DistributionViewerCertificate',
    'FunctionConfig',
    'FunctionMetadata',
    'KeyGroupConfig',
    'OriginRequestPolicyConfig',
    'OriginRequestPolicyCookiesConfig',
    'OriginRequestPolicyHeadersConfig',
    'OriginRequestPolicyQueryStringsConfig',
    'PublicKeyConfig',
    'RealtimeLogConfigEndPoint',
    'RealtimeLogConfigKinesisStreamConfig',
    'ResponseHeadersPolicyAccessControlAllowHeaders',
    'ResponseHeadersPolicyAccessControlAllowMethods',
    'ResponseHeadersPolicyAccessControlAllowOrigins',
    'ResponseHeadersPolicyAccessControlExposeHeaders',
    'ResponseHeadersPolicyConfig',
    'ResponseHeadersPolicyContentSecurityPolicy',
    'ResponseHeadersPolicyContentTypeOptions',
    'ResponseHeadersPolicyCorsConfig',
    'ResponseHeadersPolicyCustomHeader',
    'ResponseHeadersPolicyCustomHeadersConfig',
    'ResponseHeadersPolicyFrameOptions',
    'ResponseHeadersPolicyReferrerPolicy',
    'ResponseHeadersPolicySecurityHeadersConfig',
    'ResponseHeadersPolicyStrictTransportSecurity',
    'ResponseHeadersPolicyXSSProtection',
    'StreamingDistributionConfig',
    'StreamingDistributionLogging',
    'StreamingDistributionS3Origin',
    'StreamingDistributionTag',
    'StreamingDistributionTrustedSigners',
]

@pulumi.output_type
class CachePolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultTTL":
            suggest = "default_ttl"
        elif key == "maxTTL":
            suggest = "max_ttl"
        elif key == "minTTL":
            suggest = "min_ttl"
        elif key == "parametersInCacheKeyAndForwardedToOrigin":
            suggest = "parameters_in_cache_key_and_forwarded_to_origin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_ttl: float,
                 max_ttl: float,
                 min_ttl: float,
                 name: str,
                 parameters_in_cache_key_and_forwarded_to_origin: 'outputs.CachePolicyParametersInCacheKeyAndForwardedToOrigin',
                 comment: Optional[str] = None):
        pulumi.set(__self__, "default_ttl", default_ttl)
        pulumi.set(__self__, "max_ttl", max_ttl)
        pulumi.set(__self__, "min_ttl", min_ttl)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters_in_cache_key_and_forwarded_to_origin", parameters_in_cache_key_and_forwarded_to_origin)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="defaultTTL")
    def default_ttl(self) -> float:
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="maxTTL")
    def max_ttl(self) -> float:
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="minTTL")
    def min_ttl(self) -> float:
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parametersInCacheKeyAndForwardedToOrigin")
    def parameters_in_cache_key_and_forwarded_to_origin(self) -> 'outputs.CachePolicyParametersInCacheKeyAndForwardedToOrigin':
        return pulumi.get(self, "parameters_in_cache_key_and_forwarded_to_origin")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")


@pulumi.output_type
class CachePolicyCookiesConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieBehavior":
            suggest = "cookie_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyCookiesConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyCookiesConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyCookiesConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_behavior: str,
                 cookies: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "cookie_behavior", cookie_behavior)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)

    @property
    @pulumi.getter(name="cookieBehavior")
    def cookie_behavior(self) -> str:
        return pulumi.get(self, "cookie_behavior")

    @property
    @pulumi.getter
    def cookies(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cookies")


@pulumi.output_type
class CachePolicyHeadersConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerBehavior":
            suggest = "header_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_behavior: str,
                 headers: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "header_behavior", header_behavior)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter(name="headerBehavior")
    def header_behavior(self) -> str:
        return pulumi.get(self, "header_behavior")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "headers")


@pulumi.output_type
class CachePolicyParametersInCacheKeyAndForwardedToOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookiesConfig":
            suggest = "cookies_config"
        elif key == "enableAcceptEncodingGzip":
            suggest = "enable_accept_encoding_gzip"
        elif key == "headersConfig":
            suggest = "headers_config"
        elif key == "queryStringsConfig":
            suggest = "query_strings_config"
        elif key == "enableAcceptEncodingBrotli":
            suggest = "enable_accept_encoding_brotli"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyParametersInCacheKeyAndForwardedToOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyParametersInCacheKeyAndForwardedToOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyParametersInCacheKeyAndForwardedToOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookies_config: 'outputs.CachePolicyCookiesConfig',
                 enable_accept_encoding_gzip: bool,
                 headers_config: 'outputs.CachePolicyHeadersConfig',
                 query_strings_config: 'outputs.CachePolicyQueryStringsConfig',
                 enable_accept_encoding_brotli: Optional[bool] = None):
        pulumi.set(__self__, "cookies_config", cookies_config)
        pulumi.set(__self__, "enable_accept_encoding_gzip", enable_accept_encoding_gzip)
        pulumi.set(__self__, "headers_config", headers_config)
        pulumi.set(__self__, "query_strings_config", query_strings_config)
        if enable_accept_encoding_brotli is not None:
            pulumi.set(__self__, "enable_accept_encoding_brotli", enable_accept_encoding_brotli)

    @property
    @pulumi.getter(name="cookiesConfig")
    def cookies_config(self) -> 'outputs.CachePolicyCookiesConfig':
        return pulumi.get(self, "cookies_config")

    @property
    @pulumi.getter(name="enableAcceptEncodingGzip")
    def enable_accept_encoding_gzip(self) -> bool:
        return pulumi.get(self, "enable_accept_encoding_gzip")

    @property
    @pulumi.getter(name="headersConfig")
    def headers_config(self) -> 'outputs.CachePolicyHeadersConfig':
        return pulumi.get(self, "headers_config")

    @property
    @pulumi.getter(name="queryStringsConfig")
    def query_strings_config(self) -> 'outputs.CachePolicyQueryStringsConfig':
        return pulumi.get(self, "query_strings_config")

    @property
    @pulumi.getter(name="enableAcceptEncodingBrotli")
    def enable_accept_encoding_brotli(self) -> Optional[bool]:
        return pulumi.get(self, "enable_accept_encoding_brotli")


@pulumi.output_type
class CachePolicyQueryStringsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStringBehavior":
            suggest = "query_string_behavior"
        elif key == "queryStrings":
            suggest = "query_strings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyQueryStringsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyQueryStringsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyQueryStringsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_string_behavior: str,
                 query_strings: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> str:
        return pulumi.get(self, "query_string_behavior")

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "query_strings")


@pulumi.output_type
class CloudFrontOriginAccessIdentityConfig(dict):
    def __init__(__self__, *,
                 comment: str):
        pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")


@pulumi.output_type
class DistributionCacheBehavior(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathPattern":
            suggest = "path_pattern"
        elif key == "targetOriginId":
            suggest = "target_origin_id"
        elif key == "viewerProtocolPolicy":
            suggest = "viewer_protocol_policy"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "cachePolicyId":
            suggest = "cache_policy_id"
        elif key == "cachedMethods":
            suggest = "cached_methods"
        elif key == "defaultTTL":
            suggest = "default_ttl"
        elif key == "fieldLevelEncryptionId":
            suggest = "field_level_encryption_id"
        elif key == "forwardedValues":
            suggest = "forwarded_values"
        elif key == "functionAssociations":
            suggest = "function_associations"
        elif key == "lambdaFunctionAssociations":
            suggest = "lambda_function_associations"
        elif key == "maxTTL":
            suggest = "max_ttl"
        elif key == "minTTL":
            suggest = "min_ttl"
        elif key == "originRequestPolicyId":
            suggest = "origin_request_policy_id"
        elif key == "realtimeLogConfigArn":
            suggest = "realtime_log_config_arn"
        elif key == "responseHeadersPolicyId":
            suggest = "response_headers_policy_id"
        elif key == "smoothStreaming":
            suggest = "smooth_streaming"
        elif key == "trustedKeyGroups":
            suggest = "trusted_key_groups"
        elif key == "trustedSigners":
            suggest = "trusted_signers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehavior. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehavior.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehavior.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path_pattern: str,
                 target_origin_id: str,
                 viewer_protocol_policy: str,
                 allowed_methods: Optional[Sequence[str]] = None,
                 cache_policy_id: Optional[str] = None,
                 cached_methods: Optional[Sequence[str]] = None,
                 compress: Optional[bool] = None,
                 default_ttl: Optional[float] = None,
                 field_level_encryption_id: Optional[str] = None,
                 forwarded_values: Optional['outputs.DistributionForwardedValues'] = None,
                 function_associations: Optional[Sequence['outputs.DistributionFunctionAssociation']] = None,
                 lambda_function_associations: Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']] = None,
                 max_ttl: Optional[float] = None,
                 min_ttl: Optional[float] = None,
                 origin_request_policy_id: Optional[str] = None,
                 realtime_log_config_arn: Optional[str] = None,
                 response_headers_policy_id: Optional[str] = None,
                 smooth_streaming: Optional[bool] = None,
                 trusted_key_groups: Optional[Sequence[str]] = None,
                 trusted_signers: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "path_pattern", path_pattern)
        pulumi.set(__self__, "target_origin_id", target_origin_id)
        pulumi.set(__self__, "viewer_protocol_policy", viewer_protocol_policy)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if cache_policy_id is not None:
            pulumi.set(__self__, "cache_policy_id", cache_policy_id)
        if cached_methods is not None:
            pulumi.set(__self__, "cached_methods", cached_methods)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if field_level_encryption_id is not None:
            pulumi.set(__self__, "field_level_encryption_id", field_level_encryption_id)
        if forwarded_values is not None:
            pulumi.set(__self__, "forwarded_values", forwarded_values)
        if function_associations is not None:
            pulumi.set(__self__, "function_associations", function_associations)
        if lambda_function_associations is not None:
            pulumi.set(__self__, "lambda_function_associations", lambda_function_associations)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl is not None:
            pulumi.set(__self__, "min_ttl", min_ttl)
        if origin_request_policy_id is not None:
            pulumi.set(__self__, "origin_request_policy_id", origin_request_policy_id)
        if realtime_log_config_arn is not None:
            pulumi.set(__self__, "realtime_log_config_arn", realtime_log_config_arn)
        if response_headers_policy_id is not None:
            pulumi.set(__self__, "response_headers_policy_id", response_headers_policy_id)
        if smooth_streaming is not None:
            pulumi.set(__self__, "smooth_streaming", smooth_streaming)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> str:
        return pulumi.get(self, "path_pattern")

    @property
    @pulumi.getter(name="targetOriginId")
    def target_origin_id(self) -> str:
        return pulumi.get(self, "target_origin_id")

    @property
    @pulumi.getter(name="viewerProtocolPolicy")
    def viewer_protocol_policy(self) -> str:
        return pulumi.get(self, "viewer_protocol_policy")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="cachePolicyId")
    def cache_policy_id(self) -> Optional[str]:
        return pulumi.get(self, "cache_policy_id")

    @property
    @pulumi.getter(name="cachedMethods")
    def cached_methods(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cached_methods")

    @property
    @pulumi.getter
    def compress(self) -> Optional[bool]:
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="defaultTTL")
    def default_ttl(self) -> Optional[float]:
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="fieldLevelEncryptionId")
    def field_level_encryption_id(self) -> Optional[str]:
        return pulumi.get(self, "field_level_encryption_id")

    @property
    @pulumi.getter(name="forwardedValues")
    def forwarded_values(self) -> Optional['outputs.DistributionForwardedValues']:
        return pulumi.get(self, "forwarded_values")

    @property
    @pulumi.getter(name="functionAssociations")
    def function_associations(self) -> Optional[Sequence['outputs.DistributionFunctionAssociation']]:
        return pulumi.get(self, "function_associations")

    @property
    @pulumi.getter(name="lambdaFunctionAssociations")
    def lambda_function_associations(self) -> Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']]:
        return pulumi.get(self, "lambda_function_associations")

    @property
    @pulumi.getter(name="maxTTL")
    def max_ttl(self) -> Optional[float]:
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="minTTL")
    def min_ttl(self) -> Optional[float]:
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter(name="originRequestPolicyId")
    def origin_request_policy_id(self) -> Optional[str]:
        return pulumi.get(self, "origin_request_policy_id")

    @property
    @pulumi.getter(name="realtimeLogConfigArn")
    def realtime_log_config_arn(self) -> Optional[str]:
        return pulumi.get(self, "realtime_log_config_arn")

    @property
    @pulumi.getter(name="responseHeadersPolicyId")
    def response_headers_policy_id(self) -> Optional[str]:
        return pulumi.get(self, "response_headers_policy_id")

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> Optional[bool]:
        return pulumi.get(self, "smooth_streaming")

    @property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "trusted_key_groups")

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "trusted_signers")


@pulumi.output_type
class DistributionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultCacheBehavior":
            suggest = "default_cache_behavior"
        elif key == "cNAMEs":
            suggest = "c_names"
        elif key == "cacheBehaviors":
            suggest = "cache_behaviors"
        elif key == "customErrorResponses":
            suggest = "custom_error_responses"
        elif key == "customOrigin":
            suggest = "custom_origin"
        elif key == "defaultRootObject":
            suggest = "default_root_object"
        elif key == "httpVersion":
            suggest = "http_version"
        elif key == "iPV6Enabled":
            suggest = "i_pv6_enabled"
        elif key == "originGroups":
            suggest = "origin_groups"
        elif key == "priceClass":
            suggest = "price_class"
        elif key == "s3Origin":
            suggest = "s3_origin"
        elif key == "viewerCertificate":
            suggest = "viewer_certificate"
        elif key == "webACLId":
            suggest = "web_acl_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_cache_behavior: 'outputs.DistributionDefaultCacheBehavior',
                 enabled: bool,
                 aliases: Optional[Sequence[str]] = None,
                 c_names: Optional[Sequence[str]] = None,
                 cache_behaviors: Optional[Sequence['outputs.DistributionCacheBehavior']] = None,
                 comment: Optional[str] = None,
                 custom_error_responses: Optional[Sequence['outputs.DistributionCustomErrorResponse']] = None,
                 custom_origin: Optional['outputs.DistributionLegacyCustomOrigin'] = None,
                 default_root_object: Optional[str] = None,
                 http_version: Optional[str] = None,
                 i_pv6_enabled: Optional[bool] = None,
                 logging: Optional['outputs.DistributionLogging'] = None,
                 origin_groups: Optional['outputs.DistributionOriginGroups'] = None,
                 origins: Optional[Sequence['outputs.DistributionOrigin']] = None,
                 price_class: Optional[str] = None,
                 restrictions: Optional['outputs.DistributionRestrictions'] = None,
                 s3_origin: Optional['outputs.DistributionLegacyS3Origin'] = None,
                 viewer_certificate: Optional['outputs.DistributionViewerCertificate'] = None,
                 web_acl_id: Optional[str] = None):
        pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        pulumi.set(__self__, "enabled", enabled)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if c_names is not None:
            pulumi.set(__self__, "c_names", c_names)
        if cache_behaviors is not None:
            pulumi.set(__self__, "cache_behaviors", cache_behaviors)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if custom_error_responses is not None:
            pulumi.set(__self__, "custom_error_responses", custom_error_responses)
        if custom_origin is not None:
            pulumi.set(__self__, "custom_origin", custom_origin)
        if default_root_object is not None:
            pulumi.set(__self__, "default_root_object", default_root_object)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if i_pv6_enabled is not None:
            pulumi.set(__self__, "i_pv6_enabled", i_pv6_enabled)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if origin_groups is not None:
            pulumi.set(__self__, "origin_groups", origin_groups)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if price_class is not None:
            pulumi.set(__self__, "price_class", price_class)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)
        if s3_origin is not None:
            pulumi.set(__self__, "s3_origin", s3_origin)
        if viewer_certificate is not None:
            pulumi.set(__self__, "viewer_certificate", viewer_certificate)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> 'outputs.DistributionDefaultCacheBehavior':
        return pulumi.get(self, "default_cache_behavior")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="cNAMEs")
    def c_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "c_names")

    @property
    @pulumi.getter(name="cacheBehaviors")
    def cache_behaviors(self) -> Optional[Sequence['outputs.DistributionCacheBehavior']]:
        return pulumi.get(self, "cache_behaviors")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="customErrorResponses")
    def custom_error_responses(self) -> Optional[Sequence['outputs.DistributionCustomErrorResponse']]:
        return pulumi.get(self, "custom_error_responses")

    @property
    @pulumi.getter(name="customOrigin")
    def custom_origin(self) -> Optional['outputs.DistributionLegacyCustomOrigin']:
        return pulumi.get(self, "custom_origin")

    @property
    @pulumi.getter(name="defaultRootObject")
    def default_root_object(self) -> Optional[str]:
        return pulumi.get(self, "default_root_object")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[str]:
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter(name="iPV6Enabled")
    def i_pv6_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "i_pv6_enabled")

    @property
    @pulumi.getter
    def logging(self) -> Optional['outputs.DistributionLogging']:
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="originGroups")
    def origin_groups(self) -> Optional['outputs.DistributionOriginGroups']:
        return pulumi.get(self, "origin_groups")

    @property
    @pulumi.getter
    def origins(self) -> Optional[Sequence['outputs.DistributionOrigin']]:
        return pulumi.get(self, "origins")

    @property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> Optional[str]:
        return pulumi.get(self, "price_class")

    @property
    @pulumi.getter
    def restrictions(self) -> Optional['outputs.DistributionRestrictions']:
        return pulumi.get(self, "restrictions")

    @property
    @pulumi.getter(name="s3Origin")
    def s3_origin(self) -> Optional['outputs.DistributionLegacyS3Origin']:
        return pulumi.get(self, "s3_origin")

    @property
    @pulumi.getter(name="viewerCertificate")
    def viewer_certificate(self) -> Optional['outputs.DistributionViewerCertificate']:
        return pulumi.get(self, "viewer_certificate")

    @property
    @pulumi.getter(name="webACLId")
    def web_acl_id(self) -> Optional[str]:
        return pulumi.get(self, "web_acl_id")


@pulumi.output_type
class DistributionCookies(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whitelistedNames":
            suggest = "whitelisted_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCookies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCookies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCookies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forward: str,
                 whitelisted_names: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "forward", forward)
        if whitelisted_names is not None:
            pulumi.set(__self__, "whitelisted_names", whitelisted_names)

    @property
    @pulumi.getter
    def forward(self) -> str:
        return pulumi.get(self, "forward")

    @property
    @pulumi.getter(name="whitelistedNames")
    def whitelisted_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "whitelisted_names")


@pulumi.output_type
class DistributionCustomErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorCachingMinTTL":
            suggest = "error_caching_min_ttl"
        elif key == "responseCode":
            suggest = "response_code"
        elif key == "responsePagePath":
            suggest = "response_page_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCustomErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCustomErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCustomErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: int,
                 error_caching_min_ttl: Optional[float] = None,
                 response_code: Optional[int] = None,
                 response_page_path: Optional[str] = None):
        pulumi.set(__self__, "error_code", error_code)
        if error_caching_min_ttl is not None:
            pulumi.set(__self__, "error_caching_min_ttl", error_caching_min_ttl)
        if response_code is not None:
            pulumi.set(__self__, "response_code", response_code)
        if response_page_path is not None:
            pulumi.set(__self__, "response_page_path", response_page_path)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> int:
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorCachingMinTTL")
    def error_caching_min_ttl(self) -> Optional[float]:
        return pulumi.get(self, "error_caching_min_ttl")

    @property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> Optional[int]:
        return pulumi.get(self, "response_code")

    @property
    @pulumi.getter(name="responsePagePath")
    def response_page_path(self) -> Optional[str]:
        return pulumi.get(self, "response_page_path")


@pulumi.output_type
class DistributionCustomOriginConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originProtocolPolicy":
            suggest = "origin_protocol_policy"
        elif key == "hTTPPort":
            suggest = "h_ttp_port"
        elif key == "hTTPSPort":
            suggest = "h_ttps_port"
        elif key == "originKeepaliveTimeout":
            suggest = "origin_keepalive_timeout"
        elif key == "originReadTimeout":
            suggest = "origin_read_timeout"
        elif key == "originSSLProtocols":
            suggest = "origin_ssl_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCustomOriginConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCustomOriginConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCustomOriginConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin_protocol_policy: str,
                 h_ttp_port: Optional[int] = None,
                 h_ttps_port: Optional[int] = None,
                 origin_keepalive_timeout: Optional[int] = None,
                 origin_read_timeout: Optional[int] = None,
                 origin_ssl_protocols: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        if h_ttp_port is not None:
            pulumi.set(__self__, "h_ttp_port", h_ttp_port)
        if h_ttps_port is not None:
            pulumi.set(__self__, "h_ttps_port", h_ttps_port)
        if origin_keepalive_timeout is not None:
            pulumi.set(__self__, "origin_keepalive_timeout", origin_keepalive_timeout)
        if origin_read_timeout is not None:
            pulumi.set(__self__, "origin_read_timeout", origin_read_timeout)
        if origin_ssl_protocols is not None:
            pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> str:
        return pulumi.get(self, "origin_protocol_policy")

    @property
    @pulumi.getter(name="hTTPPort")
    def h_ttp_port(self) -> Optional[int]:
        return pulumi.get(self, "h_ttp_port")

    @property
    @pulumi.getter(name="hTTPSPort")
    def h_ttps_port(self) -> Optional[int]:
        return pulumi.get(self, "h_ttps_port")

    @property
    @pulumi.getter(name="originKeepaliveTimeout")
    def origin_keepalive_timeout(self) -> Optional[int]:
        return pulumi.get(self, "origin_keepalive_timeout")

    @property
    @pulumi.getter(name="originReadTimeout")
    def origin_read_timeout(self) -> Optional[int]:
        return pulumi.get(self, "origin_read_timeout")

    @property
    @pulumi.getter(name="originSSLProtocols")
    def origin_ssl_protocols(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "origin_ssl_protocols")


@pulumi.output_type
class DistributionDefaultCacheBehavior(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetOriginId":
            suggest = "target_origin_id"
        elif key == "viewerProtocolPolicy":
            suggest = "viewer_protocol_policy"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "cachePolicyId":
            suggest = "cache_policy_id"
        elif key == "cachedMethods":
            suggest = "cached_methods"
        elif key == "defaultTTL":
            suggest = "default_ttl"
        elif key == "fieldLevelEncryptionId":
            suggest = "field_level_encryption_id"
        elif key == "forwardedValues":
            suggest = "forwarded_values"
        elif key == "functionAssociations":
            suggest = "function_associations"
        elif key == "lambdaFunctionAssociations":
            suggest = "lambda_function_associations"
        elif key == "maxTTL":
            suggest = "max_ttl"
        elif key == "minTTL":
            suggest = "min_ttl"
        elif key == "originRequestPolicyId":
            suggest = "origin_request_policy_id"
        elif key == "realtimeLogConfigArn":
            suggest = "realtime_log_config_arn"
        elif key == "responseHeadersPolicyId":
            suggest = "response_headers_policy_id"
        elif key == "smoothStreaming":
            suggest = "smooth_streaming"
        elif key == "trustedKeyGroups":
            suggest = "trusted_key_groups"
        elif key == "trustedSigners":
            suggest = "trusted_signers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionDefaultCacheBehavior. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionDefaultCacheBehavior.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionDefaultCacheBehavior.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_origin_id: str,
                 viewer_protocol_policy: str,
                 allowed_methods: Optional[Sequence[str]] = None,
                 cache_policy_id: Optional[str] = None,
                 cached_methods: Optional[Sequence[str]] = None,
                 compress: Optional[bool] = None,
                 default_ttl: Optional[float] = None,
                 field_level_encryption_id: Optional[str] = None,
                 forwarded_values: Optional['outputs.DistributionForwardedValues'] = None,
                 function_associations: Optional[Sequence['outputs.DistributionFunctionAssociation']] = None,
                 lambda_function_associations: Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']] = None,
                 max_ttl: Optional[float] = None,
                 min_ttl: Optional[float] = None,
                 origin_request_policy_id: Optional[str] = None,
                 realtime_log_config_arn: Optional[str] = None,
                 response_headers_policy_id: Optional[str] = None,
                 smooth_streaming: Optional[bool] = None,
                 trusted_key_groups: Optional[Sequence[str]] = None,
                 trusted_signers: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "target_origin_id", target_origin_id)
        pulumi.set(__self__, "viewer_protocol_policy", viewer_protocol_policy)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if cache_policy_id is not None:
            pulumi.set(__self__, "cache_policy_id", cache_policy_id)
        if cached_methods is not None:
            pulumi.set(__self__, "cached_methods", cached_methods)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if field_level_encryption_id is not None:
            pulumi.set(__self__, "field_level_encryption_id", field_level_encryption_id)
        if forwarded_values is not None:
            pulumi.set(__self__, "forwarded_values", forwarded_values)
        if function_associations is not None:
            pulumi.set(__self__, "function_associations", function_associations)
        if lambda_function_associations is not None:
            pulumi.set(__self__, "lambda_function_associations", lambda_function_associations)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl is not None:
            pulumi.set(__self__, "min_ttl", min_ttl)
        if origin_request_policy_id is not None:
            pulumi.set(__self__, "origin_request_policy_id", origin_request_policy_id)
        if realtime_log_config_arn is not None:
            pulumi.set(__self__, "realtime_log_config_arn", realtime_log_config_arn)
        if response_headers_policy_id is not None:
            pulumi.set(__self__, "response_headers_policy_id", response_headers_policy_id)
        if smooth_streaming is not None:
            pulumi.set(__self__, "smooth_streaming", smooth_streaming)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)

    @property
    @pulumi.getter(name="targetOriginId")
    def target_origin_id(self) -> str:
        return pulumi.get(self, "target_origin_id")

    @property
    @pulumi.getter(name="viewerProtocolPolicy")
    def viewer_protocol_policy(self) -> str:
        return pulumi.get(self, "viewer_protocol_policy")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="cachePolicyId")
    def cache_policy_id(self) -> Optional[str]:
        return pulumi.get(self, "cache_policy_id")

    @property
    @pulumi.getter(name="cachedMethods")
    def cached_methods(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cached_methods")

    @property
    @pulumi.getter
    def compress(self) -> Optional[bool]:
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="defaultTTL")
    def default_ttl(self) -> Optional[float]:
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="fieldLevelEncryptionId")
    def field_level_encryption_id(self) -> Optional[str]:
        return pulumi.get(self, "field_level_encryption_id")

    @property
    @pulumi.getter(name="forwardedValues")
    def forwarded_values(self) -> Optional['outputs.DistributionForwardedValues']:
        return pulumi.get(self, "forwarded_values")

    @property
    @pulumi.getter(name="functionAssociations")
    def function_associations(self) -> Optional[Sequence['outputs.DistributionFunctionAssociation']]:
        return pulumi.get(self, "function_associations")

    @property
    @pulumi.getter(name="lambdaFunctionAssociations")
    def lambda_function_associations(self) -> Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']]:
        return pulumi.get(self, "lambda_function_associations")

    @property
    @pulumi.getter(name="maxTTL")
    def max_ttl(self) -> Optional[float]:
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="minTTL")
    def min_ttl(self) -> Optional[float]:
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter(name="originRequestPolicyId")
    def origin_request_policy_id(self) -> Optional[str]:
        return pulumi.get(self, "origin_request_policy_id")

    @property
    @pulumi.getter(name="realtimeLogConfigArn")
    def realtime_log_config_arn(self) -> Optional[str]:
        return pulumi.get(self, "realtime_log_config_arn")

    @property
    @pulumi.getter(name="responseHeadersPolicyId")
    def response_headers_policy_id(self) -> Optional[str]:
        return pulumi.get(self, "response_headers_policy_id")

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> Optional[bool]:
        return pulumi.get(self, "smooth_streaming")

    @property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "trusted_key_groups")

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "trusted_signers")


@pulumi.output_type
class DistributionForwardedValues(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryString":
            suggest = "query_string"
        elif key == "queryStringCacheKeys":
            suggest = "query_string_cache_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionForwardedValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionForwardedValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionForwardedValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_string: bool,
                 cookies: Optional['outputs.DistributionCookies'] = None,
                 headers: Optional[Sequence[str]] = None,
                 query_string_cache_keys: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "query_string", query_string)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_string_cache_keys is not None:
            pulumi.set(__self__, "query_string_cache_keys", query_string_cache_keys)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> bool:
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter
    def cookies(self) -> Optional['outputs.DistributionCookies']:
        return pulumi.get(self, "cookies")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryStringCacheKeys")
    def query_string_cache_keys(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "query_string_cache_keys")


@pulumi.output_type
class DistributionFunctionAssociation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventType":
            suggest = "event_type"
        elif key == "functionARN":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionFunctionAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionFunctionAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionFunctionAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_type: Optional[str] = None,
                 function_arn: Optional[str] = None):
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[str]:
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="functionARN")
    def function_arn(self) -> Optional[str]:
        return pulumi.get(self, "function_arn")


@pulumi.output_type
class DistributionGeoRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restrictionType":
            suggest = "restriction_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionGeoRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionGeoRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionGeoRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restriction_type: str,
                 locations: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "restriction_type", restriction_type)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)

    @property
    @pulumi.getter(name="restrictionType")
    def restriction_type(self) -> str:
        return pulumi.get(self, "restriction_type")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "locations")


@pulumi.output_type
class DistributionLambdaFunctionAssociation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventType":
            suggest = "event_type"
        elif key == "includeBody":
            suggest = "include_body"
        elif key == "lambdaFunctionARN":
            suggest = "lambda_function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLambdaFunctionAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLambdaFunctionAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLambdaFunctionAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_type: Optional[str] = None,
                 include_body: Optional[bool] = None,
                 lambda_function_arn: Optional[str] = None):
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if include_body is not None:
            pulumi.set(__self__, "include_body", include_body)
        if lambda_function_arn is not None:
            pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[str]:
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="includeBody")
    def include_body(self) -> Optional[bool]:
        return pulumi.get(self, "include_body")

    @property
    @pulumi.getter(name="lambdaFunctionARN")
    def lambda_function_arn(self) -> Optional[str]:
        return pulumi.get(self, "lambda_function_arn")


@pulumi.output_type
class DistributionLegacyCustomOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dNSName":
            suggest = "d_ns_name"
        elif key == "originProtocolPolicy":
            suggest = "origin_protocol_policy"
        elif key == "originSSLProtocols":
            suggest = "origin_ssl_protocols"
        elif key == "hTTPPort":
            suggest = "h_ttp_port"
        elif key == "hTTPSPort":
            suggest = "h_ttps_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLegacyCustomOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLegacyCustomOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLegacyCustomOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 d_ns_name: str,
                 origin_protocol_policy: str,
                 origin_ssl_protocols: Sequence[str],
                 h_ttp_port: Optional[int] = None,
                 h_ttps_port: Optional[int] = None):
        pulumi.set(__self__, "d_ns_name", d_ns_name)
        pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)
        if h_ttp_port is not None:
            pulumi.set(__self__, "h_ttp_port", h_ttp_port)
        if h_ttps_port is not None:
            pulumi.set(__self__, "h_ttps_port", h_ttps_port)

    @property
    @pulumi.getter(name="dNSName")
    def d_ns_name(self) -> str:
        return pulumi.get(self, "d_ns_name")

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> str:
        return pulumi.get(self, "origin_protocol_policy")

    @property
    @pulumi.getter(name="originSSLProtocols")
    def origin_ssl_protocols(self) -> Sequence[str]:
        return pulumi.get(self, "origin_ssl_protocols")

    @property
    @pulumi.getter(name="hTTPPort")
    def h_ttp_port(self) -> Optional[int]:
        return pulumi.get(self, "h_ttp_port")

    @property
    @pulumi.getter(name="hTTPSPort")
    def h_ttps_port(self) -> Optional[int]:
        return pulumi.get(self, "h_ttps_port")


@pulumi.output_type
class DistributionLegacyS3Origin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dNSName":
            suggest = "d_ns_name"
        elif key == "originAccessIdentity":
            suggest = "origin_access_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLegacyS3Origin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLegacyS3Origin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLegacyS3Origin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 d_ns_name: str,
                 origin_access_identity: Optional[str] = None):
        pulumi.set(__self__, "d_ns_name", d_ns_name)
        if origin_access_identity is not None:
            pulumi.set(__self__, "origin_access_identity", origin_access_identity)

    @property
    @pulumi.getter(name="dNSName")
    def d_ns_name(self) -> str:
        return pulumi.get(self, "d_ns_name")

    @property
    @pulumi.getter(name="originAccessIdentity")
    def origin_access_identity(self) -> Optional[str]:
        return pulumi.get(self, "origin_access_identity")


@pulumi.output_type
class DistributionLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeCookies":
            suggest = "include_cookies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 include_cookies: Optional[bool] = None,
                 prefix: Optional[str] = None):
        pulumi.set(__self__, "bucket", bucket)
        if include_cookies is not None:
            pulumi.set(__self__, "include_cookies", include_cookies)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="includeCookies")
    def include_cookies(self) -> Optional[bool]:
        return pulumi.get(self, "include_cookies")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        return pulumi.get(self, "prefix")


@pulumi.output_type
class DistributionOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "connectionAttempts":
            suggest = "connection_attempts"
        elif key == "connectionTimeout":
            suggest = "connection_timeout"
        elif key == "customOriginConfig":
            suggest = "custom_origin_config"
        elif key == "originCustomHeaders":
            suggest = "origin_custom_headers"
        elif key == "originPath":
            suggest = "origin_path"
        elif key == "originShield":
            suggest = "origin_shield"
        elif key == "s3OriginConfig":
            suggest = "s3_origin_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: str,
                 id: str,
                 connection_attempts: Optional[int] = None,
                 connection_timeout: Optional[int] = None,
                 custom_origin_config: Optional['outputs.DistributionCustomOriginConfig'] = None,
                 origin_custom_headers: Optional[Sequence['outputs.DistributionOriginCustomHeader']] = None,
                 origin_path: Optional[str] = None,
                 origin_shield: Optional['outputs.DistributionOriginShield'] = None,
                 s3_origin_config: Optional['outputs.DistributionS3OriginConfig'] = None):
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "id", id)
        if connection_attempts is not None:
            pulumi.set(__self__, "connection_attempts", connection_attempts)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if custom_origin_config is not None:
            pulumi.set(__self__, "custom_origin_config", custom_origin_config)
        if origin_custom_headers is not None:
            pulumi.set(__self__, "origin_custom_headers", origin_custom_headers)
        if origin_path is not None:
            pulumi.set(__self__, "origin_path", origin_path)
        if origin_shield is not None:
            pulumi.set(__self__, "origin_shield", origin_shield)
        if s3_origin_config is not None:
            pulumi.set(__self__, "s3_origin_config", s3_origin_config)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="connectionAttempts")
    def connection_attempts(self) -> Optional[int]:
        return pulumi.get(self, "connection_attempts")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[int]:
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="customOriginConfig")
    def custom_origin_config(self) -> Optional['outputs.DistributionCustomOriginConfig']:
        return pulumi.get(self, "custom_origin_config")

    @property
    @pulumi.getter(name="originCustomHeaders")
    def origin_custom_headers(self) -> Optional[Sequence['outputs.DistributionOriginCustomHeader']]:
        return pulumi.get(self, "origin_custom_headers")

    @property
    @pulumi.getter(name="originPath")
    def origin_path(self) -> Optional[str]:
        return pulumi.get(self, "origin_path")

    @property
    @pulumi.getter(name="originShield")
    def origin_shield(self) -> Optional['outputs.DistributionOriginShield']:
        return pulumi.get(self, "origin_shield")

    @property
    @pulumi.getter(name="s3OriginConfig")
    def s3_origin_config(self) -> Optional['outputs.DistributionS3OriginConfig']:
        return pulumi.get(self, "s3_origin_config")


@pulumi.output_type
class DistributionOriginCustomHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginCustomHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginCustomHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginCustomHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str,
                 header_value: str):
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> str:
        return pulumi.get(self, "header_value")


@pulumi.output_type
class DistributionOriginGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverCriteria":
            suggest = "failover_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_criteria: 'outputs.DistributionOriginGroupFailoverCriteria',
                 id: str,
                 members: 'outputs.DistributionOriginGroupMembers'):
        pulumi.set(__self__, "failover_criteria", failover_criteria)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "members", members)

    @property
    @pulumi.getter(name="failoverCriteria")
    def failover_criteria(self) -> 'outputs.DistributionOriginGroupFailoverCriteria':
        return pulumi.get(self, "failover_criteria")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def members(self) -> 'outputs.DistributionOriginGroupMembers':
        return pulumi.get(self, "members")


@pulumi.output_type
class DistributionOriginGroupFailoverCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCodes":
            suggest = "status_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginGroupFailoverCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginGroupFailoverCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginGroupFailoverCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_codes: 'outputs.DistributionStatusCodes'):
        pulumi.set(__self__, "status_codes", status_codes)

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> 'outputs.DistributionStatusCodes':
        return pulumi.get(self, "status_codes")


@pulumi.output_type
class DistributionOriginGroupMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originId":
            suggest = "origin_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginGroupMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginGroupMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginGroupMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin_id: str):
        pulumi.set(__self__, "origin_id", origin_id)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> str:
        return pulumi.get(self, "origin_id")


@pulumi.output_type
class DistributionOriginGroupMembers(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.DistributionOriginGroupMember'],
                 quantity: int):
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.DistributionOriginGroupMember']:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def quantity(self) -> int:
        return pulumi.get(self, "quantity")


@pulumi.output_type
class DistributionOriginGroups(dict):
    def __init__(__self__, *,
                 quantity: int,
                 items: Optional[Sequence['outputs.DistributionOriginGroup']] = None):
        pulumi.set(__self__, "quantity", quantity)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def quantity(self) -> int:
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.DistributionOriginGroup']]:
        return pulumi.get(self, "items")


@pulumi.output_type
class DistributionOriginShield(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originShieldRegion":
            suggest = "origin_shield_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginShield. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginShield.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginShield.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 origin_shield_region: Optional[str] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if origin_shield_region is not None:
            pulumi.set(__self__, "origin_shield_region", origin_shield_region)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="originShieldRegion")
    def origin_shield_region(self) -> Optional[str]:
        return pulumi.get(self, "origin_shield_region")


@pulumi.output_type
class DistributionRestrictions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "geoRestriction":
            suggest = "geo_restriction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 geo_restriction: 'outputs.DistributionGeoRestriction'):
        pulumi.set(__self__, "geo_restriction", geo_restriction)

    @property
    @pulumi.getter(name="geoRestriction")
    def geo_restriction(self) -> 'outputs.DistributionGeoRestriction':
        return pulumi.get(self, "geo_restriction")


@pulumi.output_type
class DistributionS3OriginConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originAccessIdentity":
            suggest = "origin_access_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionS3OriginConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionS3OriginConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionS3OriginConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin_access_identity: Optional[str] = None):
        if origin_access_identity is not None:
            pulumi.set(__self__, "origin_access_identity", origin_access_identity)

    @property
    @pulumi.getter(name="originAccessIdentity")
    def origin_access_identity(self) -> Optional[str]:
        return pulumi.get(self, "origin_access_identity")


@pulumi.output_type
class DistributionStatusCodes(dict):
    def __init__(__self__, *,
                 items: Sequence[int],
                 quantity: int):
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def items(self) -> Sequence[int]:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def quantity(self) -> int:
        return pulumi.get(self, "quantity")


@pulumi.output_type
class DistributionTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class DistributionViewerCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acmCertificateArn":
            suggest = "acm_certificate_arn"
        elif key == "cloudFrontDefaultCertificate":
            suggest = "cloud_front_default_certificate"
        elif key == "iamCertificateId":
            suggest = "iam_certificate_id"
        elif key == "minimumProtocolVersion":
            suggest = "minimum_protocol_version"
        elif key == "sslSupportMethod":
            suggest = "ssl_support_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionViewerCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionViewerCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionViewerCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acm_certificate_arn: Optional[str] = None,
                 cloud_front_default_certificate: Optional[bool] = None,
                 iam_certificate_id: Optional[str] = None,
                 minimum_protocol_version: Optional[str] = None,
                 ssl_support_method: Optional[str] = None):
        if acm_certificate_arn is not None:
            pulumi.set(__self__, "acm_certificate_arn", acm_certificate_arn)
        if cloud_front_default_certificate is not None:
            pulumi.set(__self__, "cloud_front_default_certificate", cloud_front_default_certificate)
        if iam_certificate_id is not None:
            pulumi.set(__self__, "iam_certificate_id", iam_certificate_id)
        if minimum_protocol_version is not None:
            pulumi.set(__self__, "minimum_protocol_version", minimum_protocol_version)
        if ssl_support_method is not None:
            pulumi.set(__self__, "ssl_support_method", ssl_support_method)

    @property
    @pulumi.getter(name="acmCertificateArn")
    def acm_certificate_arn(self) -> Optional[str]:
        return pulumi.get(self, "acm_certificate_arn")

    @property
    @pulumi.getter(name="cloudFrontDefaultCertificate")
    def cloud_front_default_certificate(self) -> Optional[bool]:
        return pulumi.get(self, "cloud_front_default_certificate")

    @property
    @pulumi.getter(name="iamCertificateId")
    def iam_certificate_id(self) -> Optional[str]:
        return pulumi.get(self, "iam_certificate_id")

    @property
    @pulumi.getter(name="minimumProtocolVersion")
    def minimum_protocol_version(self) -> Optional[str]:
        return pulumi.get(self, "minimum_protocol_version")

    @property
    @pulumi.getter(name="sslSupportMethod")
    def ssl_support_method(self) -> Optional[str]:
        return pulumi.get(self, "ssl_support_method")


@pulumi.output_type
class FunctionConfig(dict):
    def __init__(__self__, *,
                 comment: str,
                 runtime: str):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "runtime", runtime)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def runtime(self) -> str:
        return pulumi.get(self, "runtime")


@pulumi.output_type
class FunctionMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionARN":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: Optional[str] = None):
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="functionARN")
    def function_arn(self) -> Optional[str]:
        return pulumi.get(self, "function_arn")


@pulumi.output_type
class KeyGroupConfig(dict):
    def __init__(__self__, *,
                 items: Sequence[str],
                 name: str,
                 comment: Optional[str] = None):
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")


@pulumi.output_type
class OriginRequestPolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookiesConfig":
            suggest = "cookies_config"
        elif key == "headersConfig":
            suggest = "headers_config"
        elif key == "queryStringsConfig":
            suggest = "query_strings_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookies_config: 'outputs.OriginRequestPolicyCookiesConfig',
                 headers_config: 'outputs.OriginRequestPolicyHeadersConfig',
                 name: str,
                 query_strings_config: 'outputs.OriginRequestPolicyQueryStringsConfig',
                 comment: Optional[str] = None):
        pulumi.set(__self__, "cookies_config", cookies_config)
        pulumi.set(__self__, "headers_config", headers_config)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query_strings_config", query_strings_config)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="cookiesConfig")
    def cookies_config(self) -> 'outputs.OriginRequestPolicyCookiesConfig':
        return pulumi.get(self, "cookies_config")

    @property
    @pulumi.getter(name="headersConfig")
    def headers_config(self) -> 'outputs.OriginRequestPolicyHeadersConfig':
        return pulumi.get(self, "headers_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryStringsConfig")
    def query_strings_config(self) -> 'outputs.OriginRequestPolicyQueryStringsConfig':
        return pulumi.get(self, "query_strings_config")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")


@pulumi.output_type
class OriginRequestPolicyCookiesConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieBehavior":
            suggest = "cookie_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyCookiesConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyCookiesConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyCookiesConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_behavior: str,
                 cookies: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "cookie_behavior", cookie_behavior)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)

    @property
    @pulumi.getter(name="cookieBehavior")
    def cookie_behavior(self) -> str:
        return pulumi.get(self, "cookie_behavior")

    @property
    @pulumi.getter
    def cookies(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cookies")


@pulumi.output_type
class OriginRequestPolicyHeadersConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerBehavior":
            suggest = "header_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_behavior: str,
                 headers: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "header_behavior", header_behavior)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter(name="headerBehavior")
    def header_behavior(self) -> str:
        return pulumi.get(self, "header_behavior")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "headers")


@pulumi.output_type
class OriginRequestPolicyQueryStringsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStringBehavior":
            suggest = "query_string_behavior"
        elif key == "queryStrings":
            suggest = "query_strings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyQueryStringsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyQueryStringsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyQueryStringsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_string_behavior: str,
                 query_strings: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> str:
        return pulumi.get(self, "query_string_behavior")

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "query_strings")


@pulumi.output_type
class PublicKeyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callerReference":
            suggest = "caller_reference"
        elif key == "encodedKey":
            suggest = "encoded_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicKeyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicKeyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicKeyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caller_reference: str,
                 encoded_key: str,
                 name: str,
                 comment: Optional[str] = None):
        pulumi.set(__self__, "caller_reference", caller_reference)
        pulumi.set(__self__, "encoded_key", encoded_key)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> str:
        return pulumi.get(self, "caller_reference")

    @property
    @pulumi.getter(name="encodedKey")
    def encoded_key(self) -> str:
        return pulumi.get(self, "encoded_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")


@pulumi.output_type
class RealtimeLogConfigEndPoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kinesisStreamConfig":
            suggest = "kinesis_stream_config"
        elif key == "streamType":
            suggest = "stream_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RealtimeLogConfigEndPoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RealtimeLogConfigEndPoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RealtimeLogConfigEndPoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kinesis_stream_config: 'outputs.RealtimeLogConfigKinesisStreamConfig',
                 stream_type: str):
        pulumi.set(__self__, "kinesis_stream_config", kinesis_stream_config)
        pulumi.set(__self__, "stream_type", stream_type)

    @property
    @pulumi.getter(name="kinesisStreamConfig")
    def kinesis_stream_config(self) -> 'outputs.RealtimeLogConfigKinesisStreamConfig':
        return pulumi.get(self, "kinesis_stream_config")

    @property
    @pulumi.getter(name="streamType")
    def stream_type(self) -> str:
        return pulumi.get(self, "stream_type")


@pulumi.output_type
class RealtimeLogConfigKinesisStreamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "streamArn":
            suggest = "stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RealtimeLogConfigKinesisStreamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RealtimeLogConfigKinesisStreamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RealtimeLogConfigKinesisStreamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 stream_arn: str):
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> str:
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlAllowHeaders(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlAllowMethods(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlAllowOrigins(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlExposeHeaders(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsConfig":
            suggest = "cors_config"
        elif key == "customHeadersConfig":
            suggest = "custom_headers_config"
        elif key == "securityHeadersConfig":
            suggest = "security_headers_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None,
                 cors_config: Optional['outputs.ResponseHeadersPolicyCorsConfig'] = None,
                 custom_headers_config: Optional['outputs.ResponseHeadersPolicyCustomHeadersConfig'] = None,
                 security_headers_config: Optional['outputs.ResponseHeadersPolicySecurityHeadersConfig'] = None):
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if cors_config is not None:
            pulumi.set(__self__, "cors_config", cors_config)
        if custom_headers_config is not None:
            pulumi.set(__self__, "custom_headers_config", custom_headers_config)
        if security_headers_config is not None:
            pulumi.set(__self__, "security_headers_config", security_headers_config)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="corsConfig")
    def cors_config(self) -> Optional['outputs.ResponseHeadersPolicyCorsConfig']:
        return pulumi.get(self, "cors_config")

    @property
    @pulumi.getter(name="customHeadersConfig")
    def custom_headers_config(self) -> Optional['outputs.ResponseHeadersPolicyCustomHeadersConfig']:
        return pulumi.get(self, "custom_headers_config")

    @property
    @pulumi.getter(name="securityHeadersConfig")
    def security_headers_config(self) -> Optional['outputs.ResponseHeadersPolicySecurityHeadersConfig']:
        return pulumi.get(self, "security_headers_config")


@pulumi.output_type
class ResponseHeadersPolicyContentSecurityPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentSecurityPolicy":
            suggest = "content_security_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyContentSecurityPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyContentSecurityPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyContentSecurityPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_security_policy: str,
                 override: bool):
        pulumi.set(__self__, "content_security_policy", content_security_policy)
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter(name="contentSecurityPolicy")
    def content_security_policy(self) -> str:
        return pulumi.get(self, "content_security_policy")

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")


@pulumi.output_type
class ResponseHeadersPolicyContentTypeOptions(dict):
    def __init__(__self__, *,
                 override: bool):
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")


@pulumi.output_type
class ResponseHeadersPolicyCorsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlAllowCredentials":
            suggest = "access_control_allow_credentials"
        elif key == "accessControlAllowHeaders":
            suggest = "access_control_allow_headers"
        elif key == "accessControlAllowMethods":
            suggest = "access_control_allow_methods"
        elif key == "accessControlAllowOrigins":
            suggest = "access_control_allow_origins"
        elif key == "originOverride":
            suggest = "origin_override"
        elif key == "accessControlExposeHeaders":
            suggest = "access_control_expose_headers"
        elif key == "accessControlMaxAgeSec":
            suggest = "access_control_max_age_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyCorsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyCorsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyCorsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control_allow_credentials: bool,
                 access_control_allow_headers: 'outputs.ResponseHeadersPolicyAccessControlAllowHeaders',
                 access_control_allow_methods: 'outputs.ResponseHeadersPolicyAccessControlAllowMethods',
                 access_control_allow_origins: 'outputs.ResponseHeadersPolicyAccessControlAllowOrigins',
                 origin_override: bool,
                 access_control_expose_headers: Optional['outputs.ResponseHeadersPolicyAccessControlExposeHeaders'] = None,
                 access_control_max_age_sec: Optional[int] = None):
        pulumi.set(__self__, "access_control_allow_credentials", access_control_allow_credentials)
        pulumi.set(__self__, "access_control_allow_headers", access_control_allow_headers)
        pulumi.set(__self__, "access_control_allow_methods", access_control_allow_methods)
        pulumi.set(__self__, "access_control_allow_origins", access_control_allow_origins)
        pulumi.set(__self__, "origin_override", origin_override)
        if access_control_expose_headers is not None:
            pulumi.set(__self__, "access_control_expose_headers", access_control_expose_headers)
        if access_control_max_age_sec is not None:
            pulumi.set(__self__, "access_control_max_age_sec", access_control_max_age_sec)

    @property
    @pulumi.getter(name="accessControlAllowCredentials")
    def access_control_allow_credentials(self) -> bool:
        return pulumi.get(self, "access_control_allow_credentials")

    @property
    @pulumi.getter(name="accessControlAllowHeaders")
    def access_control_allow_headers(self) -> 'outputs.ResponseHeadersPolicyAccessControlAllowHeaders':
        return pulumi.get(self, "access_control_allow_headers")

    @property
    @pulumi.getter(name="accessControlAllowMethods")
    def access_control_allow_methods(self) -> 'outputs.ResponseHeadersPolicyAccessControlAllowMethods':
        return pulumi.get(self, "access_control_allow_methods")

    @property
    @pulumi.getter(name="accessControlAllowOrigins")
    def access_control_allow_origins(self) -> 'outputs.ResponseHeadersPolicyAccessControlAllowOrigins':
        return pulumi.get(self, "access_control_allow_origins")

    @property
    @pulumi.getter(name="originOverride")
    def origin_override(self) -> bool:
        return pulumi.get(self, "origin_override")

    @property
    @pulumi.getter(name="accessControlExposeHeaders")
    def access_control_expose_headers(self) -> Optional['outputs.ResponseHeadersPolicyAccessControlExposeHeaders']:
        return pulumi.get(self, "access_control_expose_headers")

    @property
    @pulumi.getter(name="accessControlMaxAgeSec")
    def access_control_max_age_sec(self) -> Optional[int]:
        return pulumi.get(self, "access_control_max_age_sec")


@pulumi.output_type
class ResponseHeadersPolicyCustomHeader(dict):
    def __init__(__self__, *,
                 header: str,
                 override: bool,
                 value: str):
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> str:
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ResponseHeadersPolicyCustomHeadersConfig(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.ResponseHeadersPolicyCustomHeader']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ResponseHeadersPolicyCustomHeader']:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyFrameOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frameOption":
            suggest = "frame_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyFrameOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyFrameOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyFrameOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frame_option: str,
                 override: bool):
        pulumi.set(__self__, "frame_option", frame_option)
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter(name="frameOption")
    def frame_option(self) -> str:
        return pulumi.get(self, "frame_option")

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")


@pulumi.output_type
class ResponseHeadersPolicyReferrerPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referrerPolicy":
            suggest = "referrer_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyReferrerPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyReferrerPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyReferrerPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 override: bool,
                 referrer_policy: str):
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "referrer_policy", referrer_policy)

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")

    @property
    @pulumi.getter(name="referrerPolicy")
    def referrer_policy(self) -> str:
        return pulumi.get(self, "referrer_policy")


@pulumi.output_type
class ResponseHeadersPolicySecurityHeadersConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentSecurityPolicy":
            suggest = "content_security_policy"
        elif key == "contentTypeOptions":
            suggest = "content_type_options"
        elif key == "frameOptions":
            suggest = "frame_options"
        elif key == "referrerPolicy":
            suggest = "referrer_policy"
        elif key == "strictTransportSecurity":
            suggest = "strict_transport_security"
        elif key == "xSSProtection":
            suggest = "x_ss_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicySecurityHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicySecurityHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicySecurityHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_security_policy: Optional['outputs.ResponseHeadersPolicyContentSecurityPolicy'] = None,
                 content_type_options: Optional['outputs.ResponseHeadersPolicyContentTypeOptions'] = None,
                 frame_options: Optional['outputs.ResponseHeadersPolicyFrameOptions'] = None,
                 referrer_policy: Optional['outputs.ResponseHeadersPolicyReferrerPolicy'] = None,
                 strict_transport_security: Optional['outputs.ResponseHeadersPolicyStrictTransportSecurity'] = None,
                 x_ss_protection: Optional['outputs.ResponseHeadersPolicyXSSProtection'] = None):
        if content_security_policy is not None:
            pulumi.set(__self__, "content_security_policy", content_security_policy)
        if content_type_options is not None:
            pulumi.set(__self__, "content_type_options", content_type_options)
        if frame_options is not None:
            pulumi.set(__self__, "frame_options", frame_options)
        if referrer_policy is not None:
            pulumi.set(__self__, "referrer_policy", referrer_policy)
        if strict_transport_security is not None:
            pulumi.set(__self__, "strict_transport_security", strict_transport_security)
        if x_ss_protection is not None:
            pulumi.set(__self__, "x_ss_protection", x_ss_protection)

    @property
    @pulumi.getter(name="contentSecurityPolicy")
    def content_security_policy(self) -> Optional['outputs.ResponseHeadersPolicyContentSecurityPolicy']:
        return pulumi.get(self, "content_security_policy")

    @property
    @pulumi.getter(name="contentTypeOptions")
    def content_type_options(self) -> Optional['outputs.ResponseHeadersPolicyContentTypeOptions']:
        return pulumi.get(self, "content_type_options")

    @property
    @pulumi.getter(name="frameOptions")
    def frame_options(self) -> Optional['outputs.ResponseHeadersPolicyFrameOptions']:
        return pulumi.get(self, "frame_options")

    @property
    @pulumi.getter(name="referrerPolicy")
    def referrer_policy(self) -> Optional['outputs.ResponseHeadersPolicyReferrerPolicy']:
        return pulumi.get(self, "referrer_policy")

    @property
    @pulumi.getter(name="strictTransportSecurity")
    def strict_transport_security(self) -> Optional['outputs.ResponseHeadersPolicyStrictTransportSecurity']:
        return pulumi.get(self, "strict_transport_security")

    @property
    @pulumi.getter(name="xSSProtection")
    def x_ss_protection(self) -> Optional['outputs.ResponseHeadersPolicyXSSProtection']:
        return pulumi.get(self, "x_ss_protection")


@pulumi.output_type
class ResponseHeadersPolicyStrictTransportSecurity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlMaxAgeSec":
            suggest = "access_control_max_age_sec"
        elif key == "includeSubdomains":
            suggest = "include_subdomains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyStrictTransportSecurity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyStrictTransportSecurity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyStrictTransportSecurity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control_max_age_sec: int,
                 override: bool,
                 include_subdomains: Optional[bool] = None,
                 preload: Optional[bool] = None):
        pulumi.set(__self__, "access_control_max_age_sec", access_control_max_age_sec)
        pulumi.set(__self__, "override", override)
        if include_subdomains is not None:
            pulumi.set(__self__, "include_subdomains", include_subdomains)
        if preload is not None:
            pulumi.set(__self__, "preload", preload)

    @property
    @pulumi.getter(name="accessControlMaxAgeSec")
    def access_control_max_age_sec(self) -> int:
        return pulumi.get(self, "access_control_max_age_sec")

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> Optional[bool]:
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter
    def preload(self) -> Optional[bool]:
        return pulumi.get(self, "preload")


@pulumi.output_type
class ResponseHeadersPolicyXSSProtection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modeBlock":
            suggest = "mode_block"
        elif key == "reportUri":
            suggest = "report_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyXSSProtection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyXSSProtection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyXSSProtection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 override: bool,
                 protection: bool,
                 mode_block: Optional[bool] = None,
                 report_uri: Optional[str] = None):
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "protection", protection)
        if mode_block is not None:
            pulumi.set(__self__, "mode_block", mode_block)
        if report_uri is not None:
            pulumi.set(__self__, "report_uri", report_uri)

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")

    @property
    @pulumi.getter
    def protection(self) -> bool:
        return pulumi.get(self, "protection")

    @property
    @pulumi.getter(name="modeBlock")
    def mode_block(self) -> Optional[bool]:
        return pulumi.get(self, "mode_block")

    @property
    @pulumi.getter(name="reportUri")
    def report_uri(self) -> Optional[str]:
        return pulumi.get(self, "report_uri")


@pulumi.output_type
class StreamingDistributionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Origin":
            suggest = "s3_origin"
        elif key == "trustedSigners":
            suggest = "trusted_signers"
        elif key == "priceClass":
            suggest = "price_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingDistributionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingDistributionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingDistributionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comment: str,
                 enabled: bool,
                 s3_origin: 'outputs.StreamingDistributionS3Origin',
                 trusted_signers: 'outputs.StreamingDistributionTrustedSigners',
                 aliases: Optional[Sequence[str]] = None,
                 logging: Optional['outputs.StreamingDistributionLogging'] = None,
                 price_class: Optional[str] = None):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "s3_origin", s3_origin)
        pulumi.set(__self__, "trusted_signers", trusted_signers)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if price_class is not None:
            pulumi.set(__self__, "price_class", price_class)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="s3Origin")
    def s3_origin(self) -> 'outputs.StreamingDistributionS3Origin':
        return pulumi.get(self, "s3_origin")

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> 'outputs.StreamingDistributionTrustedSigners':
        return pulumi.get(self, "trusted_signers")

    @property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter
    def logging(self) -> Optional['outputs.StreamingDistributionLogging']:
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> Optional[str]:
        return pulumi.get(self, "price_class")


@pulumi.output_type
class StreamingDistributionLogging(dict):
    def __init__(__self__, *,
                 bucket: str,
                 enabled: bool,
                 prefix: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        return pulumi.get(self, "prefix")


@pulumi.output_type
class StreamingDistributionS3Origin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "originAccessIdentity":
            suggest = "origin_access_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingDistributionS3Origin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingDistributionS3Origin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingDistributionS3Origin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: str,
                 origin_access_identity: str):
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "origin_access_identity", origin_access_identity)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="originAccessIdentity")
    def origin_access_identity(self) -> str:
        return pulumi.get(self, "origin_access_identity")


@pulumi.output_type
class StreamingDistributionTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class StreamingDistributionTrustedSigners(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAccountNumbers":
            suggest = "aws_account_numbers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingDistributionTrustedSigners. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingDistributionTrustedSigners.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingDistributionTrustedSigners.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 aws_account_numbers: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "enabled", enabled)
        if aws_account_numbers is not None:
            pulumi.set(__self__, "aws_account_numbers", aws_account_numbers)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="awsAccountNumbers")
    def aws_account_numbers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "aws_account_numbers")


