# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['zotero2readwise']

package_data = \
{'': ['*']}

install_requires = \
['Pyzotero>=1.4.26,<2.0.0', 'requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'zotero2readwise',
    'version': '0.2.1',
    'description': 'Export your Zotero annotations and notes to Readwise',
    'long_description': '# Zotero ➡️ Readwise\n\n`zotero2readwise` is a Python library that retrieves all [Zotero](https://www.zotero.org/) annotations† and notes. \nThen, It automatically uploads them to your [Readwise](https://readwise.io/)§§. \n\nThis is particularly useful for the new [Zotero PDF Reader](https://www.zotero.org/support/pdf_reader_preview) \nthat stores all highlights in the Zotero database. \nThe new Zotero, also available for [iOS app](https://www.zotero.org/iosbeta) (currently in beta). \nIn the new Zotero, the annotations are NOT saved in the PDF file unless you export the highlights in order to save them.\n\nIf you annotate your files outside the new Zotero PDF reader, this library may not work with your PDF annotations as those are not retrievable from Zotero API.\n\n**_This library is for you if you annotate (highlight + note) using the Zotero\'s PDF reader (including the Zotero iOS)_**\n\n👉***Updating an existing Zotero annotation or note and re-running this library will update the corresponding Readwise highlight without creating a duplicate!***\n\n† Annotations made in the new Zotero PDF reader and note editor.\n\n§ Readwise is a _paid_ service/software that integrates your highlights from almost everywhere (Pocket, Instapaper, Twitter, Medium, Apple Books, and many more). \nIt even has an amazing OCR for directly importing your highlights on a physical book/article into Readwise and allowing \nyou to export all your highlights to Obsidian, Notion, Roam, Markdown, etc. \nMoreover, It has an automated [Spaced Repition](https://en.wikipedia.org/wiki/Spaced_repetition) and [Active Recall](https://en.wikipedia.org/wiki/Testing_effect). You can use the the link [here](https://readwise.io/i/essi) to get an extra free month (*Disclaimer: I will get a free month too!*)\n\n---\n\n\n# Installation \nYou can install the library by running \n```shell\npip install zotero2readwise\n```\n\nNote: If you do not have pip installed on your system, you can follow the instructions [here](https://pip.pypa.io/en/stable/installation/).\n\n\n# Usage\nSince we have to retrieve the notes from Zotero API and then upload them to the Readwise, the minimum requirements are:\n* **Readwise access token** [Required]: You can get your access token from https://readwise.io/access_token\n* **Zotero API key** [Required]: Create a new Zotero Key from [your Zotero settings](https://www.zotero.org/settings/key)\n* **Zotero personal or group ID** [Required]: \n    * Your **personal library ID** (aka **userID**) can be found [here](https://www.zotero.org/settings/key) next to `Your userID for use in API calls is XXXXXX`.\n    * If you\'re using a **group library**, you can find the library ID by \n        1. Go to `https://www.zotero.org/groups/`\n        2. Click on the interested group.\n        3. You can find the library ID from the URL link that has format like *https://www.zotero.org/groups/<group_id>/group_name*. The number between `/groups/` and `/group_name` is the libarry ID. \n* **Zotero library type** [Optional]: *"user"* (default) if using personal library and *"group"* if using group library.\n\nNote that if you want to retrieve annotations and notes from a group, you should provide the group ID (`zotero_library_id=<group_id>`) and set the library type to group (`zotero_library_type="group"`).\n\n## Approach 1 (Recommended)\n```python \nfrom zotero2readwise.zt2rw import Zotero2Readwise\n\nzt_rw = Zotero2Readwise(\n    readwise_token="your_readwise_access_token",  # Visit https://readwise.io/access_token)\n    zotero_key="your_zotero_key",  # Visit https://www.zotero.org/settings/keys\n    zotero_library_id="your_zotero_id", # Visit https://www.zotero.org/settings/keys\n    zotero_library_type="user", # "user" (default) or "group"\n    include_annotations=True, # Include Zotero annotations -> Default: True\n    include_notes=False, # Include Zotero notes -> Default: False\n)\nzt_rw.run()\n```\nJust to make sure that all files are created, you can run `save_failed_items_to_json()` from `readwise` attribute of \nthe class object to save any highlight that failed to upload to Readwise. \nIf a file or more failed to create, the filename (item title) and the corresponding Zotero \nitem key will be saved to a txt file. \n```python\nzt_rw.readwise.save_failed_items_to_json("failed_readwise_highlights.json")\n```\n\n## Approach 2\nYou can use the `run.py` script. Run `python run.py -h` to get more information about all options. \nYou can simply run the script as the following:\n```shell\npython run.py <readwise_token> <zotero_key> <zotero_id> \n```\n\n# Request a new feature or report a bug\nFeel free to request a new feature or report a bug in GitHub issue [here](https://github.com/e-alizadeh/Zotero2MD/issues).\n\n\n# 📫 How to reach me:\n<a href="https://ealizadeh.com" target="_blank"><img alt="Personal Website" src="https://img.shields.io/badge/Personal%20Website-%2312100E.svg?&style=for-the-badge&logoColor=white" /></a>\n<a href="https://www.linkedin.com/in/alizadehesmaeil/" target="_blank"><img alt="LinkedIn" src="https://img.shields.io/badge/linkedin-%230077B5.svg?&style=for-the-badge&logo=linkedin&logoColor=white" /></a>\n<a href="https://medium.ealizadeh.com/" target="_blank"><img alt="Medium" src="https://img.shields.io/badge/medium-%2312100E.svg?&style=for-the-badge&logo=medium&logoColor=white" /></a>\n<a href="https://twitter.com/intent/follow?screen_name=es_alizadeh&tw_p=followbutton" target="_blank"><img alt="Twitter" src="https://img.shields.io/badge/twitter-%231DA1F2.svg?&style=for-the-badge&logo=twitter&logoColor=white" /></a>\n\n<a href="https://www.buymeacoffee.com/ealizadeh" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/v2/default-blue.png" alt="Buy Me A Coffee" style="height: 60px !important;width: 217px !important;" ></a>\n',
    'author': 'ealizadeh',
    'author_email': 'hello@ealizadeh.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/e-alizadeh/Zotero2Readwise',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
