"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosStack = void 0;
const runtime_1 = require("./runtime");
const tag_manager_1 = require("./tag-manager");
const ros_resource_1 = require("./ros-resource");
const tag_manager_2 = require("./tag-manager");
function rosStackPropsToRosTemplate(properties) {
    if (!runtime_1.canInspect(properties)) {
        return properties;
    }
    return {
        TemplateBody: runtime_1.stringToRosTemplate(properties.templateBody),
        TemplateURL: runtime_1.stringToRosTemplate(properties.templateUrl),
        NotificationARNs: runtime_1.listMapper(runtime_1.stringToRosTemplate)(properties.notificationArns),
        Parameters: runtime_1.hashMapper(runtime_1.stringToRosTemplate)(properties.parameters),
        Tags: runtime_1.listMapper(runtime_1.rosTagToRosTemplate)(properties.tags),
        TimeoutMins: runtime_1.numberToRosTemplate(properties.timeoutMins),
    };
}
class RosStack extends ros_resource_1.RosResource {
    constructor(scope, id, props) {
        super(scope, id, {
            type: RosStack.ROS_RESOURCE_TYPE_NAME,
            properties: props,
        });
        this.templateBody = props.templateBody;
        this.templateUrl = props.templateUrl;
        this.parameters = props.parameters;
        this.tags = new tag_manager_1.TagManager(tag_manager_2.TagType.STANDARD, "ALIYUN::ROS::Stack", props.tags, { tagPropertyName: "tags" });
        this.timeoutMins = props.timeoutMins;
    }
    get rosProperties() {
        return {
            templateBody: this.templateBody,
            templateUrl: this.templateUrl,
            parameters: this.parameters,
            tags: this.tags.renderTags(),
            timeoutMins: this.timeoutMins,
        };
    }
    renderProperties(props) {
        return rosStackPropsToRosTemplate(props);
    }
}
exports.RosStack = RosStack;
RosStack.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::Stack";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm9zLXN0YWNrLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicm9zLXN0YWNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHVDQU9tQjtBQUVuQiwrQ0FBMkM7QUFFM0MsaURBQTZDO0FBRTdDLCtDQUF3QztBQVV4QyxTQUFTLDBCQUEwQixDQUFDLFVBQWU7SUFDakQsSUFBSSxDQUFDLG9CQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDM0IsT0FBTyxVQUFVLENBQUM7S0FDbkI7SUFDRCxPQUFPO1FBQ0wsWUFBWSxFQUFFLDZCQUFtQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDMUQsV0FBVyxFQUFFLDZCQUFtQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDeEQsZ0JBQWdCLEVBQUUsb0JBQVUsQ0FBQyw2QkFBbUIsQ0FBQyxDQUMvQyxVQUFVLENBQUMsZ0JBQWdCLENBQzVCO1FBQ0QsVUFBVSxFQUFFLG9CQUFVLENBQUMsNkJBQW1CLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQ2xFLElBQUksRUFBRSxvQkFBVSxDQUFDLDZCQUFtQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUN0RCxXQUFXLEVBQUUsNkJBQW1CLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztLQUN6RCxDQUFDO0FBQ0osQ0FBQztBQUVELE1BQWEsUUFBUyxTQUFRLDBCQUFXO0lBUXZDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBb0I7UUFDNUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixJQUFJLEVBQUUsUUFBUSxDQUFDLHNCQUFzQjtZQUNyQyxVQUFVLEVBQUUsS0FBSztTQUNsQixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksd0JBQVUsQ0FDeEIscUJBQU8sQ0FBQyxRQUFRLEVBQ2hCLG9CQUFvQixFQUNwQixLQUFLLENBQUMsSUFBSSxFQUNWLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUM1QixDQUFDO1FBQ0YsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO0lBQ3ZDLENBQUM7SUFFRCxJQUFjLGFBQWE7UUFDekIsT0FBTztZQUNMLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtZQUM1QixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7U0FDOUIsQ0FBQztJQUNKLENBQUM7SUFDUyxnQkFBZ0IsQ0FBQyxLQUUxQjtRQUNDLE9BQU8sMEJBQTBCLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDM0MsQ0FBQzs7QUF2Q0gsNEJBd0NDO0FBdkN3QiwrQkFBc0IsR0FBRyxvQkFBb0IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIHN0cmluZ1RvUm9zVGVtcGxhdGUsXG4gIGxpc3RNYXBwZXIsXG4gIGhhc2hNYXBwZXIsXG4gIG51bWJlclRvUm9zVGVtcGxhdGUsXG4gIHJvc1RhZ1RvUm9zVGVtcGxhdGUsXG4gIGNhbkluc3BlY3QsXG59IGZyb20gXCIuL3J1bnRpbWVcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCIuL2NvbnN0cnVjdC1jb21wYXRcIjtcbmltcG9ydCB7IFRhZ01hbmFnZXIgfSBmcm9tIFwiLi90YWctbWFuYWdlclwiO1xuaW1wb3J0IHsgUm9zVGFnIH0gZnJvbSBcIi4vcm9zLXRhZ1wiO1xuaW1wb3J0IHsgUm9zUmVzb3VyY2UgfSBmcm9tIFwiLi9yb3MtcmVzb3VyY2VcIjtcbmltcG9ydCB7IElSZXNvbHZhYmxlIH0gZnJvbSBcIi4vcmVzb2x2YWJsZVwiO1xuaW1wb3J0IHsgVGFnVHlwZSB9IGZyb20gXCIuL3RhZy1tYW5hZ2VyXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgUm9zU3RhY2tQcm9wcyB7XG4gIHJlYWRvbmx5IHRlbXBsYXRlQm9keT86IHN0cmluZztcbiAgcmVhZG9ubHkgdGVtcGxhdGVVcmw/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHBhcmFtZXRlcnM/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9IHwgSVJlc29sdmFibGU7XG4gIHJlYWRvbmx5IHRhZ3M/OiBSb3NUYWdbXTtcbiAgcmVhZG9ubHkgdGltZW91dE1pbnM/OiBudW1iZXI7XG59XG5cbmZ1bmN0aW9uIHJvc1N0YWNrUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gIGlmICghY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkge1xuICAgIHJldHVybiBwcm9wZXJ0aWVzO1xuICB9XG4gIHJldHVybiB7XG4gICAgVGVtcGxhdGVCb2R5OiBzdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudGVtcGxhdGVCb2R5KSxcbiAgICBUZW1wbGF0ZVVSTDogc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnRlbXBsYXRlVXJsKSxcbiAgICBOb3RpZmljYXRpb25BUk5zOiBsaXN0TWFwcGVyKHN0cmluZ1RvUm9zVGVtcGxhdGUpKFxuICAgICAgcHJvcGVydGllcy5ub3RpZmljYXRpb25Bcm5zXG4gICAgKSxcbiAgICBQYXJhbWV0ZXJzOiBoYXNoTWFwcGVyKHN0cmluZ1RvUm9zVGVtcGxhdGUpKHByb3BlcnRpZXMucGFyYW1ldGVycyksXG4gICAgVGFnczogbGlzdE1hcHBlcihyb3NUYWdUb1Jvc1RlbXBsYXRlKShwcm9wZXJ0aWVzLnRhZ3MpLFxuICAgIFRpbWVvdXRNaW5zOiBudW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudGltZW91dE1pbnMpLFxuICB9O1xufVxuXG5leHBvcnQgY2xhc3MgUm9zU3RhY2sgZXh0ZW5kcyBSb3NSZXNvdXJjZSB7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUk9TX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQUxJWVVOOjpST1M6OlN0YWNrXCI7XG4gIHB1YmxpYyB0ZW1wbGF0ZVVybD86IHN0cmluZztcbiAgcHVibGljIHBhcmFtZXRlcnM6IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH0gfCBJUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcbiAgcHVibGljIHJlYWRvbmx5IHRhZ3M6IFRhZ01hbmFnZXI7XG4gIHB1YmxpYyB0aW1lb3V0TWluczogbnVtYmVyIHwgdW5kZWZpbmVkO1xuICBwdWJsaWMgdGVtcGxhdGVCb2R5Pzogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSb3NTdGFja1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0eXBlOiBSb3NTdGFjay5ST1NfUkVTT1VSQ0VfVFlQRV9OQU1FLFxuICAgICAgcHJvcGVydGllczogcHJvcHMsXG4gICAgfSk7XG5cbiAgICB0aGlzLnRlbXBsYXRlQm9keSA9IHByb3BzLnRlbXBsYXRlQm9keTtcbiAgICB0aGlzLnRlbXBsYXRlVXJsID0gcHJvcHMudGVtcGxhdGVVcmw7XG4gICAgdGhpcy5wYXJhbWV0ZXJzID0gcHJvcHMucGFyYW1ldGVycztcbiAgICB0aGlzLnRhZ3MgPSBuZXcgVGFnTWFuYWdlcihcbiAgICAgIFRhZ1R5cGUuU1RBTkRBUkQsXG4gICAgICBcIkFMSVlVTjo6Uk9TOjpTdGFja1wiLFxuICAgICAgcHJvcHMudGFncyxcbiAgICAgIHsgdGFnUHJvcGVydHlOYW1lOiBcInRhZ3NcIiB9XG4gICAgKTtcbiAgICB0aGlzLnRpbWVvdXRNaW5zID0gcHJvcHMudGltZW91dE1pbnM7XG4gIH1cblxuICBwcm90ZWN0ZWQgZ2V0IHJvc1Byb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHRlbXBsYXRlQm9keTogdGhpcy50ZW1wbGF0ZUJvZHksXG4gICAgICB0ZW1wbGF0ZVVybDogdGhpcy50ZW1wbGF0ZVVybCxcbiAgICAgIHBhcmFtZXRlcnM6IHRoaXMucGFyYW1ldGVycyxcbiAgICAgIHRhZ3M6IHRoaXMudGFncy5yZW5kZXJUYWdzKCksXG4gICAgICB0aW1lb3V0TWluczogdGhpcy50aW1lb3V0TWlucyxcbiAgICB9O1xuICB9XG4gIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7XG4gICAgW2tleTogc3RyaW5nXTogYW55O1xuICB9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHJvc1N0YWNrUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BzKTtcbiAgfVxufVxuIl19