/*
This is a configuration for evaluting the quality of responses generated by an AI assistant.
Originally used to generate scores for MT-bench or Vicuna-bench.

Adapted from [lm-sys/FastChat](https://github.com/lm-sys/FastChat/blob/main/fastchat/llm_judge/data/judge_prompts.jsonl).
*/
{
  class_path: 'ChatLLMPairwiseJudge',
  init_args: {
    language_model: { class_path: 'OpenAIChatAPI', init_args: { model: 'gpt-4-turbo-2024-04-09' } },
    prompt_template: {
      class_path: 'Jinja2PromptTemplate',
      init_args: {
        template: std.stripChars(|||
          {% set question = model1_item["task_inputs"]["messages"][0]["content"] -%}
          {% set model1_messages = model1_item["task_inputs"]["messages"] -%}
          {% set model2_messages = model2_item["task_inputs"]["messages"] -%}
          [Instruction]
          {% if references|length > 0 -%}
          Please act as an impartial judge and evaluate the quality of the responses provided by two AI assistants to the user question displayed below. Your evaluation should consider correctness and helpfulness. You will be given a reference answer, assistant A's answer, and assistant B's answer. Your job is to evaluate which assistant's answer is better. Begin your evaluation by comparing both assistants' answers with the reference answer. Identify and correct any mistakes. Avoid any position biases and ensure that the order in which the responses were presented does not influence your decision. Do not allow the length of the responses to influence your evaluation. Do not favor certain names of the assistants. Be as objective as possible. After providing your explanation, output your final verdict by strictly following this format: "[[1]]" if assistant 1 is better, "[[2]]" if assistant 2 is better, and "[[3]]" for a tie.
          {%- else -%}
          Please act as an impartial judge and evaluate the quality of the responses provided by two AI assistants to the user question displayed below. You should choose the assistant that follows the user's instructions and answers the user's question better. Your evaluation should consider factors such as the helpfulness, relevance, accuracy, depth, creativity, and level of detail of their responses. Begin your evaluation by comparing the two responses and provide a short explanation. Avoid any position biases and ensure that the order in which the responses were presented does not influence your decision. Do not allow the length of the responses to influence your evaluation. Do not favor certain names of the assistants. Be as objective as possible. After providing your explanation, output your final verdict by strictly following this format: "[[1]]" if assistant 1 is better, "[[2]]" if assistant 2 is better, and "[[3]]" for a tie.
          {%- endif %}

          [Question]
          {{ question }}

          {% if references|length > 0 -%}
          [The Start of Reference Answer]
          {{ references[0] }}
          [The End of Reference Answer]
          {% endif -%}
          [The Start of Assistant 1's Answer]
          {% if model1_messages|length == 1 %}{{ model1_item["lm_output"] }}{% else %}{{ model1_messages[1]["content"] }}{% endif %}
          [The End of Assistant's Answer]
          [The Start of Assistant 2's Answer]
          {% if model2_messages|length == 1 %}{{ model2_item["lm_output"] }}{% else %}{{ model2_messages[1]["content"] }}{% endif %}
          [The End of Assistant's Answer]
        |||, '\n'),
      },
    },
  },
}
