# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KoyebSecretArgs', 'KoyebSecret']

@pulumi.input_type
class KoyebSecretArgs:
    def __init__(__self__, *,
                 azure_container_registry: Optional[pulumi.Input['KoyebSecretAzureContainerRegistryArgs']] = None,
                 digital_ocean_container_registry: Optional[pulumi.Input['KoyebSecretDigitalOceanContainerRegistryArgs']] = None,
                 docker_hub_registry: Optional[pulumi.Input['KoyebSecretDockerHubRegistryArgs']] = None,
                 github_registry: Optional[pulumi.Input['KoyebSecretGithubRegistryArgs']] = None,
                 gitlab_registry: Optional[pulumi.Input['KoyebSecretGitlabRegistryArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_registry: Optional[pulumi.Input['KoyebSecretPrivateRegistryArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a KoyebSecret resource.
        :param pulumi.Input['KoyebSecretAzureContainerRegistryArgs'] azure_container_registry: The Azure registry configuration to use
        :param pulumi.Input['KoyebSecretDigitalOceanContainerRegistryArgs'] digital_ocean_container_registry: The DigitalOcean registry configuration to use
        :param pulumi.Input['KoyebSecretDockerHubRegistryArgs'] docker_hub_registry: The DockerHub registry configuration to use
        :param pulumi.Input['KoyebSecretGithubRegistryArgs'] github_registry: The GitHub registry configuration to use
        :param pulumi.Input['KoyebSecretGitlabRegistryArgs'] gitlab_registry: The GitLab registry configuration to use
        :param pulumi.Input[str] name: The secret name
        :param pulumi.Input['KoyebSecretPrivateRegistryArgs'] private_registry: The DigitalOcean registry configuration to use
        :param pulumi.Input[str] type: The secret type
        :param pulumi.Input[str] value: The secret value
        """
        if azure_container_registry is not None:
            pulumi.set(__self__, "azure_container_registry", azure_container_registry)
        if digital_ocean_container_registry is not None:
            pulumi.set(__self__, "digital_ocean_container_registry", digital_ocean_container_registry)
        if docker_hub_registry is not None:
            pulumi.set(__self__, "docker_hub_registry", docker_hub_registry)
        if github_registry is not None:
            pulumi.set(__self__, "github_registry", github_registry)
        if gitlab_registry is not None:
            pulumi.set(__self__, "gitlab_registry", gitlab_registry)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_registry is not None:
            pulumi.set(__self__, "private_registry", private_registry)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="azureContainerRegistry")
    def azure_container_registry(self) -> Optional[pulumi.Input['KoyebSecretAzureContainerRegistryArgs']]:
        """
        The Azure registry configuration to use
        """
        return pulumi.get(self, "azure_container_registry")

    @azure_container_registry.setter
    def azure_container_registry(self, value: Optional[pulumi.Input['KoyebSecretAzureContainerRegistryArgs']]):
        pulumi.set(self, "azure_container_registry", value)

    @property
    @pulumi.getter(name="digitalOceanContainerRegistry")
    def digital_ocean_container_registry(self) -> Optional[pulumi.Input['KoyebSecretDigitalOceanContainerRegistryArgs']]:
        """
        The DigitalOcean registry configuration to use
        """
        return pulumi.get(self, "digital_ocean_container_registry")

    @digital_ocean_container_registry.setter
    def digital_ocean_container_registry(self, value: Optional[pulumi.Input['KoyebSecretDigitalOceanContainerRegistryArgs']]):
        pulumi.set(self, "digital_ocean_container_registry", value)

    @property
    @pulumi.getter(name="dockerHubRegistry")
    def docker_hub_registry(self) -> Optional[pulumi.Input['KoyebSecretDockerHubRegistryArgs']]:
        """
        The DockerHub registry configuration to use
        """
        return pulumi.get(self, "docker_hub_registry")

    @docker_hub_registry.setter
    def docker_hub_registry(self, value: Optional[pulumi.Input['KoyebSecretDockerHubRegistryArgs']]):
        pulumi.set(self, "docker_hub_registry", value)

    @property
    @pulumi.getter(name="githubRegistry")
    def github_registry(self) -> Optional[pulumi.Input['KoyebSecretGithubRegistryArgs']]:
        """
        The GitHub registry configuration to use
        """
        return pulumi.get(self, "github_registry")

    @github_registry.setter
    def github_registry(self, value: Optional[pulumi.Input['KoyebSecretGithubRegistryArgs']]):
        pulumi.set(self, "github_registry", value)

    @property
    @pulumi.getter(name="gitlabRegistry")
    def gitlab_registry(self) -> Optional[pulumi.Input['KoyebSecretGitlabRegistryArgs']]:
        """
        The GitLab registry configuration to use
        """
        return pulumi.get(self, "gitlab_registry")

    @gitlab_registry.setter
    def gitlab_registry(self, value: Optional[pulumi.Input['KoyebSecretGitlabRegistryArgs']]):
        pulumi.set(self, "gitlab_registry", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The secret name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateRegistry")
    def private_registry(self) -> Optional[pulumi.Input['KoyebSecretPrivateRegistryArgs']]:
        """
        The DigitalOcean registry configuration to use
        """
        return pulumi.get(self, "private_registry")

    @private_registry.setter
    def private_registry(self, value: Optional[pulumi.Input['KoyebSecretPrivateRegistryArgs']]):
        pulumi.set(self, "private_registry", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The secret type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The secret value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _KoyebSecretState:
    def __init__(__self__, *,
                 azure_container_registry: Optional[pulumi.Input['KoyebSecretAzureContainerRegistryArgs']] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 digital_ocean_container_registry: Optional[pulumi.Input['KoyebSecretDigitalOceanContainerRegistryArgs']] = None,
                 docker_hub_registry: Optional[pulumi.Input['KoyebSecretDockerHubRegistryArgs']] = None,
                 github_registry: Optional[pulumi.Input['KoyebSecretGithubRegistryArgs']] = None,
                 gitlab_registry: Optional[pulumi.Input['KoyebSecretGitlabRegistryArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 private_registry: Optional[pulumi.Input['KoyebSecretPrivateRegistryArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KoyebSecret resources.
        :param pulumi.Input['KoyebSecretAzureContainerRegistryArgs'] azure_container_registry: The Azure registry configuration to use
        :param pulumi.Input[str] created_at: The date and time of when the secret was created
        :param pulumi.Input['KoyebSecretDigitalOceanContainerRegistryArgs'] digital_ocean_container_registry: The DigitalOcean registry configuration to use
        :param pulumi.Input['KoyebSecretDockerHubRegistryArgs'] docker_hub_registry: The DockerHub registry configuration to use
        :param pulumi.Input['KoyebSecretGithubRegistryArgs'] github_registry: The GitHub registry configuration to use
        :param pulumi.Input['KoyebSecretGitlabRegistryArgs'] gitlab_registry: The GitLab registry configuration to use
        :param pulumi.Input[str] name: The secret name
        :param pulumi.Input[str] organization_id: The organization ID owning the secret
        :param pulumi.Input['KoyebSecretPrivateRegistryArgs'] private_registry: The DigitalOcean registry configuration to use
        :param pulumi.Input[str] type: The secret type
        :param pulumi.Input[str] updated_at: The date and time of when the secret was last updated
        :param pulumi.Input[str] value: The secret value
        """
        if azure_container_registry is not None:
            pulumi.set(__self__, "azure_container_registry", azure_container_registry)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if digital_ocean_container_registry is not None:
            pulumi.set(__self__, "digital_ocean_container_registry", digital_ocean_container_registry)
        if docker_hub_registry is not None:
            pulumi.set(__self__, "docker_hub_registry", docker_hub_registry)
        if github_registry is not None:
            pulumi.set(__self__, "github_registry", github_registry)
        if gitlab_registry is not None:
            pulumi.set(__self__, "gitlab_registry", gitlab_registry)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if private_registry is not None:
            pulumi.set(__self__, "private_registry", private_registry)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="azureContainerRegistry")
    def azure_container_registry(self) -> Optional[pulumi.Input['KoyebSecretAzureContainerRegistryArgs']]:
        """
        The Azure registry configuration to use
        """
        return pulumi.get(self, "azure_container_registry")

    @azure_container_registry.setter
    def azure_container_registry(self, value: Optional[pulumi.Input['KoyebSecretAzureContainerRegistryArgs']]):
        pulumi.set(self, "azure_container_registry", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of when the secret was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="digitalOceanContainerRegistry")
    def digital_ocean_container_registry(self) -> Optional[pulumi.Input['KoyebSecretDigitalOceanContainerRegistryArgs']]:
        """
        The DigitalOcean registry configuration to use
        """
        return pulumi.get(self, "digital_ocean_container_registry")

    @digital_ocean_container_registry.setter
    def digital_ocean_container_registry(self, value: Optional[pulumi.Input['KoyebSecretDigitalOceanContainerRegistryArgs']]):
        pulumi.set(self, "digital_ocean_container_registry", value)

    @property
    @pulumi.getter(name="dockerHubRegistry")
    def docker_hub_registry(self) -> Optional[pulumi.Input['KoyebSecretDockerHubRegistryArgs']]:
        """
        The DockerHub registry configuration to use
        """
        return pulumi.get(self, "docker_hub_registry")

    @docker_hub_registry.setter
    def docker_hub_registry(self, value: Optional[pulumi.Input['KoyebSecretDockerHubRegistryArgs']]):
        pulumi.set(self, "docker_hub_registry", value)

    @property
    @pulumi.getter(name="githubRegistry")
    def github_registry(self) -> Optional[pulumi.Input['KoyebSecretGithubRegistryArgs']]:
        """
        The GitHub registry configuration to use
        """
        return pulumi.get(self, "github_registry")

    @github_registry.setter
    def github_registry(self, value: Optional[pulumi.Input['KoyebSecretGithubRegistryArgs']]):
        pulumi.set(self, "github_registry", value)

    @property
    @pulumi.getter(name="gitlabRegistry")
    def gitlab_registry(self) -> Optional[pulumi.Input['KoyebSecretGitlabRegistryArgs']]:
        """
        The GitLab registry configuration to use
        """
        return pulumi.get(self, "gitlab_registry")

    @gitlab_registry.setter
    def gitlab_registry(self, value: Optional[pulumi.Input['KoyebSecretGitlabRegistryArgs']]):
        pulumi.set(self, "gitlab_registry", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The secret name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID owning the secret
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="privateRegistry")
    def private_registry(self) -> Optional[pulumi.Input['KoyebSecretPrivateRegistryArgs']]:
        """
        The DigitalOcean registry configuration to use
        """
        return pulumi.get(self, "private_registry")

    @private_registry.setter
    def private_registry(self, value: Optional[pulumi.Input['KoyebSecretPrivateRegistryArgs']]):
        pulumi.set(self, "private_registry", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The secret type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of when the secret was last updated
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The secret value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class KoyebSecret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_container_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretAzureContainerRegistryArgs']]] = None,
                 digital_ocean_container_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretDigitalOceanContainerRegistryArgs']]] = None,
                 docker_hub_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretDockerHubRegistryArgs']]] = None,
                 github_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretGithubRegistryArgs']]] = None,
                 gitlab_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretGitlabRegistryArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretPrivateRegistryArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_koyeb as koyeb

        simple_secret = koyeb.KoyebSecret("simple-secret", value="secret-value")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['KoyebSecretAzureContainerRegistryArgs']] azure_container_registry: The Azure registry configuration to use
        :param pulumi.Input[pulumi.InputType['KoyebSecretDigitalOceanContainerRegistryArgs']] digital_ocean_container_registry: The DigitalOcean registry configuration to use
        :param pulumi.Input[pulumi.InputType['KoyebSecretDockerHubRegistryArgs']] docker_hub_registry: The DockerHub registry configuration to use
        :param pulumi.Input[pulumi.InputType['KoyebSecretGithubRegistryArgs']] github_registry: The GitHub registry configuration to use
        :param pulumi.Input[pulumi.InputType['KoyebSecretGitlabRegistryArgs']] gitlab_registry: The GitLab registry configuration to use
        :param pulumi.Input[str] name: The secret name
        :param pulumi.Input[pulumi.InputType['KoyebSecretPrivateRegistryArgs']] private_registry: The DigitalOcean registry configuration to use
        :param pulumi.Input[str] type: The secret type
        :param pulumi.Input[str] value: The secret value
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[KoyebSecretArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_koyeb as koyeb

        simple_secret = koyeb.KoyebSecret("simple-secret", value="secret-value")
        ```

        :param str resource_name: The name of the resource.
        :param KoyebSecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KoyebSecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_container_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretAzureContainerRegistryArgs']]] = None,
                 digital_ocean_container_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretDigitalOceanContainerRegistryArgs']]] = None,
                 docker_hub_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretDockerHubRegistryArgs']]] = None,
                 github_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretGithubRegistryArgs']]] = None,
                 gitlab_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretGitlabRegistryArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretPrivateRegistryArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KoyebSecretArgs.__new__(KoyebSecretArgs)

            __props__.__dict__["azure_container_registry"] = azure_container_registry
            __props__.__dict__["digital_ocean_container_registry"] = digital_ocean_container_registry
            __props__.__dict__["docker_hub_registry"] = docker_hub_registry
            __props__.__dict__["github_registry"] = github_registry
            __props__.__dict__["gitlab_registry"] = gitlab_registry
            __props__.__dict__["name"] = name
            __props__.__dict__["private_registry"] = private_registry
            __props__.__dict__["type"] = type
            __props__.__dict__["value"] = value
            __props__.__dict__["created_at"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["updated_at"] = None
        super(KoyebSecret, __self__).__init__(
            'koyeb:index/koyebSecret:KoyebSecret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_container_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretAzureContainerRegistryArgs']]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            digital_ocean_container_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretDigitalOceanContainerRegistryArgs']]] = None,
            docker_hub_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretDockerHubRegistryArgs']]] = None,
            github_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretGithubRegistryArgs']]] = None,
            gitlab_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretGitlabRegistryArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            private_registry: Optional[pulumi.Input[pulumi.InputType['KoyebSecretPrivateRegistryArgs']]] = None,
            type: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'KoyebSecret':
        """
        Get an existing KoyebSecret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['KoyebSecretAzureContainerRegistryArgs']] azure_container_registry: The Azure registry configuration to use
        :param pulumi.Input[str] created_at: The date and time of when the secret was created
        :param pulumi.Input[pulumi.InputType['KoyebSecretDigitalOceanContainerRegistryArgs']] digital_ocean_container_registry: The DigitalOcean registry configuration to use
        :param pulumi.Input[pulumi.InputType['KoyebSecretDockerHubRegistryArgs']] docker_hub_registry: The DockerHub registry configuration to use
        :param pulumi.Input[pulumi.InputType['KoyebSecretGithubRegistryArgs']] github_registry: The GitHub registry configuration to use
        :param pulumi.Input[pulumi.InputType['KoyebSecretGitlabRegistryArgs']] gitlab_registry: The GitLab registry configuration to use
        :param pulumi.Input[str] name: The secret name
        :param pulumi.Input[str] organization_id: The organization ID owning the secret
        :param pulumi.Input[pulumi.InputType['KoyebSecretPrivateRegistryArgs']] private_registry: The DigitalOcean registry configuration to use
        :param pulumi.Input[str] type: The secret type
        :param pulumi.Input[str] updated_at: The date and time of when the secret was last updated
        :param pulumi.Input[str] value: The secret value
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KoyebSecretState.__new__(_KoyebSecretState)

        __props__.__dict__["azure_container_registry"] = azure_container_registry
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["digital_ocean_container_registry"] = digital_ocean_container_registry
        __props__.__dict__["docker_hub_registry"] = docker_hub_registry
        __props__.__dict__["github_registry"] = github_registry
        __props__.__dict__["gitlab_registry"] = gitlab_registry
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["private_registry"] = private_registry
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["value"] = value
        return KoyebSecret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureContainerRegistry")
    def azure_container_registry(self) -> pulumi.Output[Optional['outputs.KoyebSecretAzureContainerRegistry']]:
        """
        The Azure registry configuration to use
        """
        return pulumi.get(self, "azure_container_registry")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date and time of when the secret was created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="digitalOceanContainerRegistry")
    def digital_ocean_container_registry(self) -> pulumi.Output[Optional['outputs.KoyebSecretDigitalOceanContainerRegistry']]:
        """
        The DigitalOcean registry configuration to use
        """
        return pulumi.get(self, "digital_ocean_container_registry")

    @property
    @pulumi.getter(name="dockerHubRegistry")
    def docker_hub_registry(self) -> pulumi.Output[Optional['outputs.KoyebSecretDockerHubRegistry']]:
        """
        The DockerHub registry configuration to use
        """
        return pulumi.get(self, "docker_hub_registry")

    @property
    @pulumi.getter(name="githubRegistry")
    def github_registry(self) -> pulumi.Output[Optional['outputs.KoyebSecretGithubRegistry']]:
        """
        The GitHub registry configuration to use
        """
        return pulumi.get(self, "github_registry")

    @property
    @pulumi.getter(name="gitlabRegistry")
    def gitlab_registry(self) -> pulumi.Output[Optional['outputs.KoyebSecretGitlabRegistry']]:
        """
        The GitLab registry configuration to use
        """
        return pulumi.get(self, "gitlab_registry")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The secret name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The organization ID owning the secret
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="privateRegistry")
    def private_registry(self) -> pulumi.Output[Optional['outputs.KoyebSecretPrivateRegistry']]:
        """
        The DigitalOcean registry configuration to use
        """
        return pulumi.get(self, "private_registry")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The secret type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The date and time of when the secret was last updated
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[str]]:
        """
        The secret value
        """
        return pulumi.get(self, "value")

