# Generated by Django 2.1.2 on 2019-09-10 08:35

from django.db import migrations


def get_config(apps):
    # We can't import the Config model directly as it may be a newer
    # version than this migration expects. We use the historical version.
    return apps.get_model('kallisticore', 'Config')


def create_config(apps, schema_editor):
    get_config(apps).objects.create(publish_trial=True)


def remove_config(apps, schema_editor):
    get_config(apps).objects.delete()


class Migration(migrations.Migration):
    dependencies = [
        ('kallisticore', '0016_config'),
    ]

    operations = [
        migrations.RunPython(code=create_config, reverse_code=remove_config),
    ]
