# Generated by Django 3.1.4 on 2020-12-28 13:30

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

import aasrp.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveonline", "0012_index_additions"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="AaSrp",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "verbose_name": "AA-SRP",
                "permissions": (
                    ("basic_access", "Can access the AA-SRP module"),
                    ("create_srp", "Can create new SRP links"),
                    ("manage_srp", "Can manage SRP"),
                    ("manage_srp_requests", "Can manage SRP requests"),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="AaSrpLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("srp_name", models.CharField(default="", max_length=254)),
                (
                    "srp_status",
                    models.CharField(
                        choices=[
                            ("Active", "Active"),
                            ("Closed", "Closed"),
                            ("Completed", "Completed"),
                        ],
                        default="Active",
                        max_length=9,
                    ),
                ),
                ("srp_code", models.CharField(default="", max_length=16)),
                ("fleet_doctrine", models.CharField(default="", max_length=254)),
                ("fleet_time", models.DateTimeField()),
                ("aar_link", models.CharField(blank=True, default="", max_length=254)),
                (
                    "creator",
                    models.ForeignKey(
                        help_text="Who created the SRP link?",
                        null=True,
                        on_delete=models.SET(aasrp.models.get_sentinel_user),
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "fleet_commander",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="eveonline.evecharacter",
                    ),
                ),
            ],
            options={
                "verbose_name": "SRP Link",
                "verbose_name_plural": "SRP Links",
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="AaSrpRequest",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("request_code", models.CharField(default="", max_length=254)),
                ("ship_name", models.CharField(default="", max_length=254)),
                ("killboard_link", models.CharField(default="", max_length=254)),
                ("additional_info", models.TextField(blank=True, default="")),
                (
                    "request_status",
                    models.CharField(
                        choices=[
                            ("Pending", "Pending"),
                            ("Approved", "Approved"),
                            ("Rejected", "Rejected"),
                        ],
                        default="Pending",
                        max_length=8,
                    ),
                ),
                ("payout_amount", models.BigIntegerField(default=0)),
                ("loss_amount", models.BigIntegerField(default=0)),
                ("post_time", models.DateTimeField(default=django.utils.timezone.now)),
                (
                    "character",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="eveonline.evecharacter",
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        help_text="Who created the SRP link?",
                        null=True,
                        on_delete=models.SET(aasrp.models.get_sentinel_user),
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "srp_link",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="aasrp.aasrplink",
                    ),
                ),
            ],
            options={
                "verbose_name": "SRP Request",
                "verbose_name_plural": "SRP Requests",
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="AaSrpRequestComment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("comment", models.TextField(blank=True, null=True)),
                (
                    "comment_type",
                    models.CharField(
                        choices=[
                            ("Comment", "SRP Request Comment"),
                            (
                                "Request Information",
                                "SRP Request Additional Information",
                            ),
                            ("Reject Reason", "SRP Reject Reason"),
                        ],
                        default="Comment",
                        max_length=19,
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=models.SET(aasrp.models.get_sentinel_user),
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "srp_request",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="aasrp.aasrprequest",
                    ),
                ),
            ],
            options={
                "verbose_name": "SRP Request Comment",
                "verbose_name_plural": "SRP Request Comments",
                "default_permissions": (),
            },
        ),
    ]
