# Site Map

## 🏠 Main Pages

- [Home](/) - PCILeech Firmware Generator overview and quick start
- [Search](/search) - Search all documentation

## 🔧 Core Features & Architecture

- [Device Cloning Process](device-cloning) - Learn about the device cloning workflow
- [Configuration Space Shadow](config-space-shadow) - Understanding the configuration space shadow mechanism  
- [Template Architecture](template-architecture) - Explore the template-based design system
- [Firmware Authenticity & Stability](firmware-uniqueness) - Ensuring firmware integrity and reliability
- [Supported Devices](supported-devices) - View all compatible hardware devices

## 📚 Guides & Tutorials

- [Manual Donor Dump](manual-donor-dump) - How to manually create donor device dumps
- [TUI Interface Guide](tui-readme) - Using the Terminal User Interface
- [Development Guide](development) - Contributing to PCILeech Firmware Generator

## 📖 API Documentation

- [Python API Documentation](docs/) - Auto-generated Sphinx documentation

## 🔗 External Resources

- [PCILeech Main Project](https://github.com/ufrisk/pcileech) - Visit the main PCILeech project
- [PCILeech FPGA](https://github.com/ufrisk/pcileech-fpga) - PCILeech FPGA implementation
- [Issues Tracker](https://github.com/ramseymcgrath/PCILeechFWGenerator/issues) - Report bugs or request features
- [Community Forum](https://github.com/ramseymcgrath/PCILeechFWGenerator/discussions) - Join the community discussions

---

*Last updated: {{ site.time | date: "%Y-%m-%d" }}*
