# math_round_af

![GitHub repo size](https://img.shields.io/github/issues/AlbertFarkhutdinov/math_round_af)
![GitHub contributors](https://img.shields.io/github/contributors/AlbertFarkhutdinov/math_round_af)
![GitHub stars](https://img.shields.io/github/stars/AlbertFarkhutdinov/math_round_af)
![GitHub forks](https://img.shields.io/github/forks/AlbertFarkhutdinov/math_round_af)
![GitHub licence](https://img.shields.io/github/license/AlbertFarkhutdinov/math_round_af)

`math_round_af` is a Python package that allows to get mathematically rounded floating numbers.

## Prerequisites

Before you begin, ensure you have installed the latest version of Python.

## Installing `math_round_af`

To install `math_round_af`, follow these steps:

Linux and macOS:
```
pip3 install math-round-af
```

Windows:
```
pip install math-round-af
```
## Using `math_round_af`

There are examples of how to use `math_round_af`:

```
>>> from math_round_af import get_rounded_number
>>> get_rounded_number(0.4)
0.0
>>> get_rounded_number(0.5)
1.0
>>> get_rounded_number(-0.4)
0.0
>>> get_rounded_number(-0.5)
-1.0
>>> get_rounded_number(3.142, 0)
3.0
>>> get_rounded_number(3.142, 1)
3.1
>>> get_rounded_number(3.142, 2)
3.14

```

## Contributing to `math_round_af`
To contribute to `math_round_af`, follow these steps:

1. Fork this repository.
2. Create a branch: `git checkout -b <branch_name>`.
3. Make your changes and commit them: `git commit -m '<commit_message>'`
4. Push to the original branch: `git push origin <project_name>/<location>`
5. Create the pull request.

Alternatively see the GitHub documentation on [creating a pull request](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request).

## Contributors

* [@AlbertFarkhutdinov](https://github.com/AlbertFarkhutdinov) 

## Contact

If you want to contact me you can reach me at `albertfarhutdinov@gmail.com`.

## License
<!--- If you're not sure which open license to use see https://choosealicense.com/--->

This project uses the following license: [MIT License](https://github.com/AlbertFarkhutdinov/math_round_af/blob/main/LICENSE).