export declare type FeatureFlagsEntry = Record<string, Record<string, {}>>;
export declare type FeatureFlagConfiguration = {
    project: FeatureFlagsEntry;
    environments: Record<string, FeatureFlagsEntry>;
};
export declare type FeatureFlagType = 'number' | 'string' | 'boolean';
export declare type FeatureFlagRegistration = StringFeatureFlag | NumberFeatureFlag | BooleanFeatureFlag;
export declare type StringFeatureFlag = {
    type: 'string';
    name: string;
    defaultValueForExistingProjects: string;
    defaultValueForNewProjects: string;
};
export declare type NumberFeatureFlag = {
    type: 'number';
    name: string;
    defaultValueForExistingProjects: number;
    defaultValueForNewProjects: number;
};
export declare type BooleanFeatureFlag = {
    type: 'boolean';
    name: string;
    defaultValueForExistingProjects: boolean;
    defaultValueForNewProjects: boolean;
};
//# sourceMappingURL=featureFlagTypes.d.ts.map