# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01_pypi.ipynb (unless otherwise specified).

__all__ = ['clean_dist', 'build_pypi_package', 'publish_pypi_package', 'build_and_publish_pypi']

# Cell
import os
import shutil
import subprocess
from .utils import check_project_root, get_pypi_credentials, run_tests

# Cell
@check_project_root
def clean_dist():
    "Clean dist/ folder"
    shutil.rmtree("dist", ignore_errors=True)

# Cell
@check_project_root
def build_pypi_package():
    "Build pypi package"
    subprocess.run(["python", "setup.py", "sdist", "bdist_wheel"])

# Cell
@check_project_root
def publish_pypi_package():
    "Publish package to pypi via twine"
    username, password = get_pypi_credentials()
    subprocess.run(
        ["twine", "upload", "--repository", "pypi", "dist/*",
         "--username", username, "--password", password]
    )

# Cell
@run_tests
def build_and_publish_pypi():
    "Build and publish pypi package"
    clean_dist()
    build_pypi_package()
    publish_pypi_package()