# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_conda.ipynb (unless otherwise specified).

__all__ = ['read_meta_template', 'update_meta_yaml', 'build_conda_package', 'login_to_anaconda', 'upload_conda_package']

# Cell
import os
import yaml
import subprocess
from .utils import (
    check_project_root,
    get_template,
    get_config,
    get_conda_env_packages,
    get_anaconda_credentials,
    run_tests
)

# Cell
def read_meta_template():
    "Read meta.yaml template"
    template = get_template("meta_template.yaml")
    return yaml.safe_load(template)

# Cell
@check_project_root
def update_meta_yaml():
    "Write / update meta.yaml for conda package building"
    print("Updating conda-recipe/meta.yaml")
    cfg = get_config()
    meta_yaml = read_meta_template()
    build_reqs = get_conda_env_packages()
    meta_yaml["package"]["name"] = cfg["lib_name"]
    meta_yaml["package"]["version"] = cfg["version"]
    meta_yaml["requirements"]["build"] = build_reqs
    meta_yaml["requirements"]["run"] = [f"python>={cfg['min_python']}"] + cfg.get("requirements", "").split()
    meta_yaml["about"]["home"] = cfg["git_url"]
    meta_yaml["about"]["license"] = cfg["license"]
    meta_yaml["about"]["summary"] = cfg["description"]
    if not os.path.exists("conda-recipe"):
        os.mkdir("conda-recipe")
    with open(os.path.join("conda-recipe", "meta.yaml"), "w") as f:
        yaml.dump(meta_yaml, f, sort_keys=False)

# Cell
@run_tests
def build_conda_package():
    "Build conda package"
    exit_code = subprocess.run(
        ["conda-build", "conda-recipe", "--output-folder", "./conda-bld", "--no-anaconda-upload"]
    ).returncode
    return exit_code

# Cell
@check_project_root
def login_to_anaconda():
    """Login to anaconda with credentials

    They will be searched in the file .anaconda-credentials
    either under the project root or under the user home
    """
    username, password = get_anaconda_credentials()
    exit_code = subprocess.run(["anaconda", "login", "--username", username, "--password", password]).returncode
    return exit_code

# Cell
@check_project_root
def upload_conda_package():
    "Upload conda package to your anaconda user"
    cfg = get_config()
    package_name = cfg["lib_name"]
    version = cfg["version"]
    package_dir = f"./conda-bld/noarch/{package_name}-{version}-py_0.tar.bz2"
    exit_code = subprocess.run(["anaconda", "upload", package_dir]).returncode
    return exit_code