# -*- coding: utf-8 -*-
# pylint: skip-file
"""This module contains implemtation of F14 - F12.

When using it, please cite :cite:`Blumlein:2009ta`.
Mellin transform is defined with the convention x^(N).
"""
import numba as nb
import numpy as np


@nb.njit(cache=True)
def F14F12(n, S1, S21):
    """Linear combination of :math:`M[( 2 S_{2,2}(x)- Li_2(x)^2/2)/(1+x)](N)`"""
    return (
        -0.5626569734260486
        + 0.49999902059348167
        * (
            (-1.6449340668482262 * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)) / (2.0 + n)
            + (
                np.power(1.0 + n, -3)
                + np.power(2.0 + n, -3)
                + S1 / np.power(1.0 + n, 2)
                + (1 / (1.0 + n) + S1) / np.power(2.0 + n, 2)
                + S21
            )
            / (2.0 + n)
            + n
            * (
                -1.0 / np.power(2.0 + n, 5)
                + 1.6449340668482262 / np.power(2.0 + n, 3)
                - 0.8117424252833533 / (2.0 + n)
                - (1.0 * (1 / (1.0 + n) + S1)) / np.power(2.0 + n, 4)
                + (1.6449340668482262 * (1 / (1.0 + n) + S1)) / np.power(2.0 + n, 2)
                - (1.0 * (np.power(1.0 + n, -3) + S1 / np.power(1.0 + n, 2) + S21))
                / np.power(2.0 + n, 2)
            )
        )
        - 0.9999999952263307
        * (
            (-1.6449340668482262 * (1 / (1.0 + n) + S1)) / (1.0 + n)
            + (np.power(1.0 + n, -3) + S1 / np.power(1.0 + n, 2) + S21) / (1.0 + n)
            + n
            * (
                -1.0 / np.power(1.0 + n, 5)
                + 1.6449340668482262 / np.power(1.0 + n, 3)
                - 0.8117424252833533 / (1.0 + n)
                - (1.0 * S1) / np.power(1.0 + n, 4)
                + (1.6449340668482262 * S1) / np.power(1.0 + n, 2)
                - (
                    1.0
                    * (
                        np.power(1.0 + n, -3)
                        + S1 / np.power(1.0 + n, 2)
                        - (1.0 * (1 / (1.0 + n) + S1)) / np.power(1.0 + n, 2)
                        + S21
                    )
                )
                / np.power(1.0 + n, 2)
            )
        )
        - 0.3332995604546604
        * (
            (
                -1.6449340668482262
                * (
                    1 / (1.0 + n)
                    + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                    + S1
                )
            )
            / (3.0 + n)
            + (
                np.power(1.0 + n, -3)
                + (
                    11.0
                    + 20.0 * (1.0 + n)
                    + 13.0 * np.power(1.0 + n, 2)
                    + 3.0 * np.power(1.0 + n, 3)
                )
                / (np.power(2.0 + n, 3) * np.power(3.0 + n, 3))
                + S1 / np.power(1.0 + n, 2)
                + (
                    (5.0 + 6.0 * (1.0 + n) + 2.0 * np.power(1.0 + n, 2))
                    * (1 / (1.0 + n) + S1)
                )
                / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2))
                + S21
            )
            / (3.0 + n)
            + n
            * (
                -1.0 / np.power(3.0 + n, 5)
                + 1.6449340668482262 / np.power(3.0 + n, 3)
                - 0.8117424252833533 / (3.0 + n)
                - (1.0 * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)) / np.power(3.0 + n, 4)
                + (1.6449340668482262 * (1 / (1.0 + n) + 1 / (2.0 + n) + S1))
                / np.power(3.0 + n, 2)
                - (
                    1.0
                    * (
                        np.power(1.0 + n, -3)
                        + np.power(2.0 + n, -3)
                        + S1 / np.power(1.0 + n, 2)
                        + (1 / (1.0 + n) + S1) / np.power(2.0 + n, 2)
                        + S21
                    )
                )
                / np.power(3.0 + n, 2)
            )
        )
        + 0.24954082848379078
        * (
            (
                -1.6449340668482262
                * (
                    1 / (1.0 + n)
                    + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                    + S1
                )
            )
            / (4.0 + n)
            + (
                np.power(1.0 + n, -3)
                + (
                    341.0
                    + 1017.0 * (1.0 + n)
                    + 1289.0 * np.power(1.0 + n, 2)
                    + 881.0 * np.power(1.0 + n, 3)
                    + 340.0 * np.power(1.0 + n, 4)
                    + 70.0 * np.power(1.0 + n, 5)
                    + 6.0 * np.power(1.0 + n, 6)
                )
                / (np.power(2.0 + n, 3) * np.power(3.0 + n, 3) * np.power(4.0 + n, 3))
                + S1 / np.power(1.0 + n, 2)
                + (
                    (
                        49.0
                        + 96.0 * (1.0 + n)
                        + 72.0 * np.power(1.0 + n, 2)
                        + 24.0 * np.power(1.0 + n, 3)
                        + 3.0 * np.power(1.0 + n, 4)
                    )
                    * (1 / (1.0 + n) + S1)
                )
                / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2) * np.power(4.0 + n, 2))
                + S21
            )
            / (4.0 + n)
            + n
            * (
                -1.0 / np.power(4.0 + n, 5)
                + 1.6449340668482262 / np.power(4.0 + n, 3)
                - 0.8117424252833533 / (4.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                        + S1
                    )
                )
                / np.power(4.0 + n, 4)
                + (
                    1.6449340668482262
                    * (
                        1 / (1.0 + n)
                        + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                        + S1
                    )
                )
                / np.power(4.0 + n, 2)
                - (
                    1.0
                    * (
                        np.power(1.0 + n, -3)
                        + (
                            11.0
                            + 20.0 * (1.0 + n)
                            + 13.0 * np.power(1.0 + n, 2)
                            + 3.0 * np.power(1.0 + n, 3)
                        )
                        / (np.power(2.0 + n, 3) * np.power(3.0 + n, 3))
                        + S1 / np.power(1.0 + n, 2)
                        + (
                            (5.0 + 6.0 * (1.0 + n) + 2.0 * np.power(1.0 + n, 2))
                            * (1 / (1.0 + n) + S1)
                        )
                        / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2))
                        + S21
                    )
                )
                / np.power(4.0 + n, 2)
            )
        )
        - 0.1967571967137462
        * (
            (
                -1.6449340668482262
                * (
                    1 / (1.0 + n)
                    + (
                        2.0
                        * (5.0 + 2.0 * (1.0 + n))
                        * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                    + S1
                )
            )
            / (5.0 + n)
            + (
                np.power(1.0 + n, -3)
                + (
                    23624.0
                    + 90576.0 * (1.0 + n)
                    + 155374.0 * np.power(1.0 + n, 2)
                    + 155615.0 * np.power(1.0 + n, 3)
                    + 99831.0 * np.power(1.0 + n, 4)
                    + 42413.0 * np.power(1.0 + n, 5)
                    + 11911.0 * np.power(1.0 + n, 6)
                    + 2130.0 * np.power(1.0 + n, 7)
                    + 220.0 * np.power(1.0 + n, 8)
                    + 10.0 * np.power(1.0 + n, 9)
                )
                / (
                    np.power(2.0 + n, 3)
                    * np.power(3.0 + n, 3)
                    * np.power(4.0 + n, 3)
                    * np.power(5.0 + n, 3)
                )
                + S1 / np.power(1.0 + n, 2)
                + (
                    2.0
                    * (
                        410.0
                        + 1030.0 * (1.0 + n)
                        + 1081.0 * np.power(1.0 + n, 2)
                        + 600.0 * np.power(1.0 + n, 3)
                        + 185.0 * np.power(1.0 + n, 4)
                        + 30.0 * np.power(1.0 + n, 5)
                        + 2.0 * np.power(1.0 + n, 6)
                    )
                    * (1 / (1.0 + n) + S1)
                )
                / (
                    np.power(2.0 + n, 2)
                    * np.power(3.0 + n, 2)
                    * np.power(4.0 + n, 2)
                    * np.power(5.0 + n, 2)
                )
                + S21
            )
            / (5.0 + n)
            + n
            * (
                -1.0 / np.power(5.0 + n, 5)
                + 1.6449340668482262 / np.power(5.0 + n, 3)
                - 0.8117424252833533 / (5.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                        + S1
                    )
                )
                / np.power(5.0 + n, 4)
                + (
                    1.6449340668482262
                    * (
                        1 / (1.0 + n)
                        + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                        + S1
                    )
                )
                / np.power(5.0 + n, 2)
                - (
                    1.0
                    * (
                        np.power(1.0 + n, -3)
                        + (
                            341.0
                            + 1017.0 * (1.0 + n)
                            + 1289.0 * np.power(1.0 + n, 2)
                            + 881.0 * np.power(1.0 + n, 3)
                            + 340.0 * np.power(1.0 + n, 4)
                            + 70.0 * np.power(1.0 + n, 5)
                            + 6.0 * np.power(1.0 + n, 6)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                        )
                        + S1 / np.power(1.0 + n, 2)
                        + (
                            (
                                49.0
                                + 96.0 * (1.0 + n)
                                + 72.0 * np.power(1.0 + n, 2)
                                + 24.0 * np.power(1.0 + n, 3)
                                + 3.0 * np.power(1.0 + n, 4)
                            )
                            * (1 / (1.0 + n) + S1)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                        )
                        + S21
                    )
                )
                / np.power(5.0 + n, 2)
            )
        )
        + 0.1530503487172192
        * (
            (
                -1.6449340668482262
                * (
                    1 / (1.0 + n)
                    + (
                        274.0
                        + 450.0 * (1.0 + n)
                        + 255.0 * np.power(1.0 + n, 2)
                        + 60.0 * np.power(1.0 + n, 3)
                        + 5.0 * np.power(1.0 + n, 4)
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                    + S1
                )
            )
            / (6.0 + n)
            + (
                np.power(1.0 + n, -3)
                + (
                    3.110824e6
                    + 1.40106e7 * (1.0 + n)
                    + 2.894151e7 * np.power(1.0 + n, 2)
                    + 3.6105269e7 * np.power(1.0 + n, 3)
                    + 3.0197768e7 * np.power(1.0 + n, 4)
                    + 1.7798299e7 * np.power(1.0 + n, 5)
                    + 7.568825e6 * np.power(1.0 + n, 6)
                    + 2.337861e6 * np.power(1.0 + n, 7)
                    + 520317.0 * np.power(1.0 + n, 8)
                    + 81361.0 * np.power(1.0 + n, 9)
                    + 8485.0 * np.power(1.0 + n, 10)
                    + 530.0 * np.power(1.0 + n, 11)
                    + 15.0 * np.power(1.0 + n, 12)
                )
                / (
                    np.power(2.0 + n, 3)
                    * np.power(3.0 + n, 3)
                    * np.power(4.0 + n, 3)
                    * np.power(5.0 + n, 3)
                    * np.power(6.0 + n, 3)
                )
                + S1 / np.power(1.0 + n, 2)
                + (
                    (
                        21076.0
                        + 62100.0 * (1.0 + n)
                        + 79650.0 * np.power(1.0 + n, 2)
                        + 57660.0 * np.power(1.0 + n, 3)
                        + 25685.0 * np.power(1.0 + n, 4)
                        + 7200.0 * np.power(1.0 + n, 5)
                        + 1240.0 * np.power(1.0 + n, 6)
                        + 120.0 * np.power(1.0 + n, 7)
                        + 5.0 * np.power(1.0 + n, 8)
                    )
                    * (1 / (1.0 + n) + S1)
                )
                / (
                    np.power(2.0 + n, 2)
                    * np.power(3.0 + n, 2)
                    * np.power(4.0 + n, 2)
                    * np.power(5.0 + n, 2)
                    * np.power(6.0 + n, 2)
                )
                + S21
            )
            / (6.0 + n)
            + n
            * (
                -1.0 / np.power(6.0 + n, 5)
                + 1.6449340668482262 / np.power(6.0 + n, 3)
                - 0.8117424252833533 / (6.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (
                            2.0
                            * (5.0 + 2.0 * (1.0 + n))
                            * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                        + S1
                    )
                )
                / np.power(6.0 + n, 4)
                + (
                    1.6449340668482262
                    * (
                        1 / (1.0 + n)
                        + (
                            2.0
                            * (5.0 + 2.0 * (1.0 + n))
                            * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                        + S1
                    )
                )
                / np.power(6.0 + n, 2)
                - (
                    1.0
                    * (
                        np.power(1.0 + n, -3)
                        + (
                            23624.0
                            + 90576.0 * (1.0 + n)
                            + 155374.0 * np.power(1.0 + n, 2)
                            + 155615.0 * np.power(1.0 + n, 3)
                            + 99831.0 * np.power(1.0 + n, 4)
                            + 42413.0 * np.power(1.0 + n, 5)
                            + 11911.0 * np.power(1.0 + n, 6)
                            + 2130.0 * np.power(1.0 + n, 7)
                            + 220.0 * np.power(1.0 + n, 8)
                            + 10.0 * np.power(1.0 + n, 9)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                        )
                        + S1 / np.power(1.0 + n, 2)
                        + (
                            2.0
                            * (
                                410.0
                                + 1030.0 * (1.0 + n)
                                + 1081.0 * np.power(1.0 + n, 2)
                                + 600.0 * np.power(1.0 + n, 3)
                                + 185.0 * np.power(1.0 + n, 4)
                                + 30.0 * np.power(1.0 + n, 5)
                                + 2.0 * np.power(1.0 + n, 6)
                            )
                            * (1 / (1.0 + n) + S1)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                        )
                        + S21
                    )
                )
                / np.power(6.0 + n, 2)
            )
        )
        - 0.10602798528818422
        * (
            (
                -1.6449340668482262
                * (
                    1 / (1.0 + n)
                    + (
                        (7.0 + 2.0 * (1.0 + n))
                        * (
                            252.0
                            + 392.0 * (1.0 + n)
                            + 203.0 * np.power(1.0 + n, 2)
                            + 42.0 * np.power(1.0 + n, 3)
                            + 3.0 * np.power(1.0 + n, 4)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                    )
                    + S1
                )
            )
            / (7.0 + n)
            + (
                np.power(1.0 + n, -3)
                + (
                    6.97339584e8
                    + 3.525030432e9 * (1.0 + n)
                    + 8.293536336e9 * np.power(1.0 + n, 2)
                    + 1.2007529256e10 * np.power(1.0 + n, 3)
                    + 1.193375892e10 * np.power(1.0 + n, 4)
                    + 8.60864186e9 * np.power(1.0 + n, 5)
                    + 4.650892802e9 * np.power(1.0 + n, 6)
                    + 1.914862936e9 * np.power(1.0 + n, 7)
                    + 6.05522329e8 * np.power(1.0 + n, 8)
                    + 1.47044895e8 * np.power(1.0 + n, 9)
                    + 2.7198669e7 * np.power(1.0 + n, 10)
                    + 3.763711e6 * np.power(1.0 + n, 11)
                    + 377251.0 * np.power(1.0 + n, 12)
                    + 25865.0 * np.power(1.0 + n, 13)
                    + 1085.0 * np.power(1.0 + n, 14)
                    + 21.0 * np.power(1.0 + n, 15)
                )
                / (
                    np.power(2.0 + n, 3)
                    * np.power(3.0 + n, 3)
                    * np.power(4.0 + n, 3)
                    * np.power(5.0 + n, 3)
                    * np.power(6.0 + n, 3)
                    * np.power(7.0 + n, 3)
                )
                + S1 / np.power(1.0 + n, 2)
                + (
                    (
                        773136.0
                        + 2.554272e6 * (1.0 + n)
                        + 3.762752e6 * np.power(1.0 + n, 2)
                        + 3.23736e6 * np.power(1.0 + n, 3)
                        + 1.797035e6 * np.power(1.0 + n, 4)
                        + 671790.0 * np.power(1.0 + n, 5)
                        + 171248.0 * np.power(1.0 + n, 6)
                        + 29400.0 * np.power(1.0 + n, 7)
                        + 3255.0 * np.power(1.0 + n, 8)
                        + 210.0 * np.power(1.0 + n, 9)
                        + 6.0 * np.power(1.0 + n, 10)
                    )
                    * (1 / (1.0 + n) + S1)
                )
                / (
                    np.power(2.0 + n, 2)
                    * np.power(3.0 + n, 2)
                    * np.power(4.0 + n, 2)
                    * np.power(5.0 + n, 2)
                    * np.power(6.0 + n, 2)
                    * np.power(7.0 + n, 2)
                )
                + S21
            )
            / (7.0 + n)
            + n
            * (
                -1.0 / np.power(7.0 + n, 5)
                + 1.6449340668482262 / np.power(7.0 + n, 3)
                - 0.8117424252833533 / (7.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (
                            274.0
                            + 450.0 * (1.0 + n)
                            + 255.0 * np.power(1.0 + n, 2)
                            + 60.0 * np.power(1.0 + n, 3)
                            + 5.0 * np.power(1.0 + n, 4)
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                        + S1
                    )
                )
                / np.power(7.0 + n, 4)
                + (
                    1.6449340668482262
                    * (
                        1 / (1.0 + n)
                        + (
                            274.0
                            + 450.0 * (1.0 + n)
                            + 255.0 * np.power(1.0 + n, 2)
                            + 60.0 * np.power(1.0 + n, 3)
                            + 5.0 * np.power(1.0 + n, 4)
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                        + S1
                    )
                )
                / np.power(7.0 + n, 2)
                - (
                    1.0
                    * (
                        np.power(1.0 + n, -3)
                        + (
                            3.110824e6
                            + 1.40106e7 * (1.0 + n)
                            + 2.894151e7 * np.power(1.0 + n, 2)
                            + 3.6105269e7 * np.power(1.0 + n, 3)
                            + 3.0197768e7 * np.power(1.0 + n, 4)
                            + 1.7798299e7 * np.power(1.0 + n, 5)
                            + 7.568825e6 * np.power(1.0 + n, 6)
                            + 2.337861e6 * np.power(1.0 + n, 7)
                            + 520317.0 * np.power(1.0 + n, 8)
                            + 81361.0 * np.power(1.0 + n, 9)
                            + 8485.0 * np.power(1.0 + n, 10)
                            + 530.0 * np.power(1.0 + n, 11)
                            + 15.0 * np.power(1.0 + n, 12)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                        )
                        + S1 / np.power(1.0 + n, 2)
                        + (
                            (
                                21076.0
                                + 62100.0 * (1.0 + n)
                                + 79650.0 * np.power(1.0 + n, 2)
                                + 57660.0 * np.power(1.0 + n, 3)
                                + 25685.0 * np.power(1.0 + n, 4)
                                + 7200.0 * np.power(1.0 + n, 5)
                                + 1240.0 * np.power(1.0 + n, 6)
                                + 120.0 * np.power(1.0 + n, 7)
                                + 5.0 * np.power(1.0 + n, 8)
                            )
                            * (1 / (1.0 + n) + S1)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                        )
                        + S21
                    )
                )
                / np.power(7.0 + n, 2)
            )
        )
        + 0.056951717764149916
        * (
            (
                -1.6449340668482262
                * (
                    1 / (1.0 + n)
                    + (
                        13068.0
                        + 26264.0 * (1.0 + n)
                        + 20307.0 * np.power(1.0 + n, 2)
                        + 7840.0 * np.power(1.0 + n, 3)
                        + 1610.0 * np.power(1.0 + n, 4)
                        + 168.0 * np.power(1.0 + n, 5)
                        + 7.0 * np.power(1.0 + n, 6)
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                    )
                    + S1
                )
            )
            / (8.0 + n)
            + (
                np.power(1.0 + n, -3)
                + (
                    2.0
                    * (
                        1.22980964256e11
                        + 6.79202212752e11 * (1.0 + n)
                        + 1.762986212232e12 * np.power(1.0 + n, 2)
                        + 2.849976037428e12 * np.power(1.0 + n, 3)
                        + 3.208712317944e12 * np.power(1.0 + n, 4)
                        + 2.66793900071e12 * np.power(1.0 + n, 5)
                        + 1.696140569839e12 * np.power(1.0 + n, 6)
                        + 8.42534361945e11 * np.power(1.0 + n, 7)
                        + 3.31394293594e11 * np.power(1.0 + n, 8)
                        + 1.03973066426e11 * np.power(1.0 + n, 9)
                        + 2.6083138284e10 * np.power(1.0 + n, 10)
                        + 5.220244242e9 * np.power(1.0 + n, 11)
                        + 8.27501148e8 * np.power(1.0 + n, 12)
                        + 1.02512358e8 * np.power(1.0 + n, 13)
                        + 9.709175e6 * np.power(1.0 + n, 14)
                        + 678601.0 * np.power(1.0 + n, 15)
                        + 32970.0 * np.power(1.0 + n, 16)
                        + 994.0 * np.power(1.0 + n, 17)
                        + 14.0 * np.power(1.0 + n, 18)
                    )
                )
                / (
                    np.power(2.0 + n, 3)
                    * np.power(3.0 + n, 3)
                    * np.power(4.0 + n, 3)
                    * np.power(5.0 + n, 3)
                    * np.power(6.0 + n, 3)
                    * np.power(7.0 + n, 3)
                    * np.power(8.0 + n, 3)
                )
                + S1 / np.power(1.0 + n, 2)
                + (
                    (
                        3.8402064e7
                        + 1.38523392e8 * (1.0 + n)
                        + 2.26358048e8 * np.power(1.0 + n, 2)
                        + 2.20651312e8 * np.power(1.0 + n, 3)
                        + 1.42622963e8 * np.power(1.0 + n, 4)
                        + 6.434848e7 * np.power(1.0 + n, 5)
                        + 2.07774e7 * np.power(1.0 + n, 6)
                        + 4.838848e6 * np.power(1.0 + n, 7)
                        + 807086.0 * np.power(1.0 + n, 8)
                        + 94080.0 * np.power(1.0 + n, 9)
                        + 7280.0 * np.power(1.0 + n, 10)
                        + 336.0 * np.power(1.0 + n, 11)
                        + 7.0 * np.power(1.0 + n, 12)
                    )
                    * (1 / (1.0 + n) + S1)
                )
                / (
                    np.power(2.0 + n, 2)
                    * np.power(3.0 + n, 2)
                    * np.power(4.0 + n, 2)
                    * np.power(5.0 + n, 2)
                    * np.power(6.0 + n, 2)
                    * np.power(7.0 + n, 2)
                    * np.power(8.0 + n, 2)
                )
                + S21
            )
            / (8.0 + n)
            + n
            * (
                -1.0 / np.power(8.0 + n, 5)
                + 1.6449340668482262 / np.power(8.0 + n, 3)
                - 0.8117424252833533 / (8.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (
                            (7.0 + 2.0 * (1.0 + n))
                            * (
                                252.0
                                + 392.0 * (1.0 + n)
                                + 203.0 * np.power(1.0 + n, 2)
                                + 42.0 * np.power(1.0 + n, 3)
                                + 3.0 * np.power(1.0 + n, 4)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(8.0 + n, 4)
                + (
                    1.6449340668482262
                    * (
                        1 / (1.0 + n)
                        + (
                            (7.0 + 2.0 * (1.0 + n))
                            * (
                                252.0
                                + 392.0 * (1.0 + n)
                                + 203.0 * np.power(1.0 + n, 2)
                                + 42.0 * np.power(1.0 + n, 3)
                                + 3.0 * np.power(1.0 + n, 4)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(8.0 + n, 2)
                - (
                    1.0
                    * (
                        np.power(1.0 + n, -3)
                        + (
                            6.97339584e8
                            + 3.525030432e9 * (1.0 + n)
                            + 8.293536336e9 * np.power(1.0 + n, 2)
                            + 1.2007529256e10 * np.power(1.0 + n, 3)
                            + 1.193375892e10 * np.power(1.0 + n, 4)
                            + 8.60864186e9 * np.power(1.0 + n, 5)
                            + 4.650892802e9 * np.power(1.0 + n, 6)
                            + 1.914862936e9 * np.power(1.0 + n, 7)
                            + 6.05522329e8 * np.power(1.0 + n, 8)
                            + 1.47044895e8 * np.power(1.0 + n, 9)
                            + 2.7198669e7 * np.power(1.0 + n, 10)
                            + 3.763711e6 * np.power(1.0 + n, 11)
                            + 377251.0 * np.power(1.0 + n, 12)
                            + 25865.0 * np.power(1.0 + n, 13)
                            + 1085.0 * np.power(1.0 + n, 14)
                            + 21.0 * np.power(1.0 + n, 15)
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                            * np.power(7.0 + n, 3)
                        )
                        + S1 / np.power(1.0 + n, 2)
                        + (
                            (
                                773136.0
                                + 2.554272e6 * (1.0 + n)
                                + 3.762752e6 * np.power(1.0 + n, 2)
                                + 3.23736e6 * np.power(1.0 + n, 3)
                                + 1.797035e6 * np.power(1.0 + n, 4)
                                + 671790.0 * np.power(1.0 + n, 5)
                                + 171248.0 * np.power(1.0 + n, 6)
                                + 29400.0 * np.power(1.0 + n, 7)
                                + 3255.0 * np.power(1.0 + n, 8)
                                + 210.0 * np.power(1.0 + n, 9)
                                + 6.0 * np.power(1.0 + n, 10)
                            )
                            * (1 / (1.0 + n) + S1)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                        )
                        + S21
                    )
                )
                / np.power(8.0 + n, 2)
            )
        )
        - 0.019847559824380426
        * (
            (
                -1.6449340668482262
                * (
                    1 / (1.0 + n)
                    + (
                        4.0
                        * (9.0 + 2.0 * (1.0 + n))
                        * (
                            3044.0
                            + 5886.0 * (1.0 + n)
                            + 4299.0 * np.power(1.0 + n, 2)
                            + 1539.0 * np.power(1.0 + n, 3)
                            + 288.0 * np.power(1.0 + n, 4)
                            + 27.0 * np.power(1.0 + n, 5)
                            + np.power(1.0 + n, 6)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                        * (9.0 + n)
                    )
                    + S1
                )
            )
            / (9.0 + n)
            + (
                np.power(1.0 + n, -3)
                + (
                    6.0
                    * (
                        2.1452686055424e13
                        + 1.27193972324352e14 * (1.0 + n)
                        + 3.569135825824e14 * np.power(1.0 + n, 2)
                        + 6.28964181904288e14 * np.power(1.0 + n, 3)
                        + 7.79557064653264e14 * np.power(1.0 + n, 4)
                        + 7.2173981400876e14 * np.power(1.0 + n, 5)
                        + 5.17717816384772e14 * np.power(1.0 + n, 6)
                        + 2.94648846212476e14 * np.power(1.0 + n, 7)
                        + 1.35183891860404e14 * np.power(1.0 + n, 8)
                        + 5.0528576648611e13 * np.power(1.0 + n, 9)
                        + 1.5487423206191e13 * np.power(1.0 + n, 10)
                        + 3.905253305568e12 * np.power(1.0 + n, 11)
                        + 8.10278287284e11 * np.power(1.0 + n, 12)
                        + 1.37943606892e11 * np.power(1.0 + n, 13)
                        + 1.9149259574e10 * np.power(1.0 + n, 14)
                        + 2.145327532e9 * np.power(1.0 + n, 15)
                        + 1.90913568e8 * np.power(1.0 + n, 16)
                        + 1.3175883e7 * np.power(1.0 + n, 17)
                        + 679567.0 * np.power(1.0 + n, 18)
                        + 24640.0 * np.power(1.0 + n, 19)
                        + 560.0 * np.power(1.0 + n, 20)
                        + 6.0 * np.power(1.0 + n, 21)
                    )
                )
                / (
                    np.power(2.0 + n, 3)
                    * np.power(3.0 + n, 3)
                    * np.power(4.0 + n, 3)
                    * np.power(5.0 + n, 3)
                    * np.power(6.0 + n, 3)
                    * np.power(7.0 + n, 3)
                    * np.power(8.0 + n, 3)
                    * np.power(9.0 + n, 3)
                )
                + S1 / np.power(1.0 + n, 2)
                + (
                    4.0
                    * (
                        6.20783424e8
                        + 2.402913888e9 * (1.0 + n)
                        + 4.261208648e9 * np.power(1.0 + n, 2)
                        + 4.5733464e9 * np.power(1.0 + n, 3)
                        + 3.31344237e9 * np.power(1.0 + n, 4)
                        + 1.713293694e9 * np.power(1.0 + n, 5)
                        + 6.51986769e8 * np.power(1.0 + n, 6)
                        + 1.85551632e8 * np.power(1.0 + n, 7)
                        + 3.9703709e7 * np.power(1.0 + n, 8)
                        + 6.360228e6 * np.power(1.0 + n, 9)
                        + 751317.0 * np.power(1.0 + n, 10)
                        + 63504.0 * np.power(1.0 + n, 11)
                        + 3633.0 * np.power(1.0 + n, 12)
                        + 126.0 * np.power(1.0 + n, 13)
                        + 2.0 * np.power(1.0 + n, 14)
                    )
                    * (1 / (1.0 + n) + S1)
                )
                / (
                    np.power(2.0 + n, 2)
                    * np.power(3.0 + n, 2)
                    * np.power(4.0 + n, 2)
                    * np.power(5.0 + n, 2)
                    * np.power(6.0 + n, 2)
                    * np.power(7.0 + n, 2)
                    * np.power(8.0 + n, 2)
                    * np.power(9.0 + n, 2)
                )
                + S21
            )
            / (9.0 + n)
            + n
            * (
                -1.0 / np.power(9.0 + n, 5)
                + 1.6449340668482262 / np.power(9.0 + n, 3)
                - 0.8117424252833533 / (9.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (
                            13068.0
                            + 26264.0 * (1.0 + n)
                            + 20307.0 * np.power(1.0 + n, 2)
                            + 7840.0 * np.power(1.0 + n, 3)
                            + 1610.0 * np.power(1.0 + n, 4)
                            + 168.0 * np.power(1.0 + n, 5)
                            + 7.0 * np.power(1.0 + n, 6)
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(9.0 + n, 4)
                + (
                    1.6449340668482262
                    * (
                        1 / (1.0 + n)
                        + (
                            13068.0
                            + 26264.0 * (1.0 + n)
                            + 20307.0 * np.power(1.0 + n, 2)
                            + 7840.0 * np.power(1.0 + n, 3)
                            + 1610.0 * np.power(1.0 + n, 4)
                            + 168.0 * np.power(1.0 + n, 5)
                            + 7.0 * np.power(1.0 + n, 6)
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(9.0 + n, 2)
                - (
                    1.0
                    * (
                        np.power(1.0 + n, -3)
                        + (
                            2.0
                            * (
                                1.22980964256e11
                                + 6.79202212752e11 * (1.0 + n)
                                + 1.762986212232e12 * np.power(1.0 + n, 2)
                                + 2.849976037428e12 * np.power(1.0 + n, 3)
                                + 3.208712317944e12 * np.power(1.0 + n, 4)
                                + 2.66793900071e12 * np.power(1.0 + n, 5)
                                + 1.696140569839e12 * np.power(1.0 + n, 6)
                                + 8.42534361945e11 * np.power(1.0 + n, 7)
                                + 3.31394293594e11 * np.power(1.0 + n, 8)
                                + 1.03973066426e11 * np.power(1.0 + n, 9)
                                + 2.6083138284e10 * np.power(1.0 + n, 10)
                                + 5.220244242e9 * np.power(1.0 + n, 11)
                                + 8.27501148e8 * np.power(1.0 + n, 12)
                                + 1.02512358e8 * np.power(1.0 + n, 13)
                                + 9.709175e6 * np.power(1.0 + n, 14)
                                + 678601.0 * np.power(1.0 + n, 15)
                                + 32970.0 * np.power(1.0 + n, 16)
                                + 994.0 * np.power(1.0 + n, 17)
                                + 14.0 * np.power(1.0 + n, 18)
                            )
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                            * np.power(7.0 + n, 3)
                            * np.power(8.0 + n, 3)
                        )
                        + S1 / np.power(1.0 + n, 2)
                        + (
                            (
                                3.8402064e7
                                + 1.38523392e8 * (1.0 + n)
                                + 2.26358048e8 * np.power(1.0 + n, 2)
                                + 2.20651312e8 * np.power(1.0 + n, 3)
                                + 1.42622963e8 * np.power(1.0 + n, 4)
                                + 6.434848e7 * np.power(1.0 + n, 5)
                                + 2.07774e7 * np.power(1.0 + n, 6)
                                + 4.838848e6 * np.power(1.0 + n, 7)
                                + 807086.0 * np.power(1.0 + n, 8)
                                + 94080.0 * np.power(1.0 + n, 9)
                                + 7280.0 * np.power(1.0 + n, 10)
                                + 336.0 * np.power(1.0 + n, 11)
                                + 7.0 * np.power(1.0 + n, 12)
                            )
                            * (1 / (1.0 + n) + S1)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                            * np.power(8.0 + n, 2)
                        )
                        + S21
                    )
                )
                / np.power(9.0 + n, 2)
            )
        )
        + 0.003243204652309423
        * (
            (
                -1.6449340668482262
                * (
                    1 / (1.0 + n)
                    + (
                        3.0
                        * (
                            342192.0
                            + 781800.0 * (1.0 + n)
                            + 723680.0 * np.power(1.0 + n, 2)
                            + 359100.0 * np.power(1.0 + n, 3)
                            + 105455.0 * np.power(1.0 + n, 4)
                            + 18900.0 * np.power(1.0 + n, 5)
                            + 2030.0 * np.power(1.0 + n, 6)
                            + 120.0 * np.power(1.0 + n, 7)
                            + 3.0 * np.power(1.0 + n, 8)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                        * (9.0 + n)
                        * (10.0 + n)
                    )
                    + S1
                )
            )
            / (10.0 + n)
            + (
                np.power(1.0 + n, -3)
                + (
                    3.0
                    * (
                        3.183431862446899e16
                        + 2.001696918700032e17 * (1.0 + n)
                        + 5.98808681111543e17 * np.power(1.0 + n, 2)
                        + 1.1319310863695514e18 * np.power(1.0 + n, 3)
                        + 1.5156493142882596e18 * np.power(1.0 + n, 4)
                        + 1.5282976372182676e18 * np.power(1.0 + n, 5)
                        + 1.2049970049036114e18 * np.power(1.0 + n, 6)
                        + 7.616938706128154e17 * np.power(1.0 + n, 7)
                        + 3.92747201355673e17 * np.power(1.0 + n, 8)
                        + 1.6722252430665453e17 * np.power(1.0 + n, 9)
                        + 5.92988929379218e16 * np.power(1.0 + n, 10)
                        + 1.7614071211379864e16 * np.power(1.0 + n, 11)
                        + 4.397465867910487e15 * np.power(1.0 + n, 12)
                        + 9.23902782587314e14 * np.power(1.0 + n, 13)
                        + 1.6322843101295e14 * np.power(1.0 + n, 14)
                        + 2.4179602098084e13 * np.power(1.0 + n, 15)
                        + 2.987313035113e12 * np.power(1.0 + n, 16)
                        + 3.05296487914e11 * np.power(1.0 + n, 17)
                        + 2.550145462e10 * np.power(1.0 + n, 18)
                        + 1.711289424e9 * np.power(1.0 + n, 19)
                        + 8.9968697e7 * np.power(1.0 + n, 20)
                        + 3.567374e6 * np.power(1.0 + n, 21)
                        + 100270.0 * np.power(1.0 + n, 22)
                        + 1780.0 * np.power(1.0 + n, 23)
                        + 15.0 * np.power(1.0 + n, 24)
                    )
                )
                / (
                    np.power(2.0 + n, 3)
                    * np.power(3.0 + n, 3)
                    * np.power(4.0 + n, 3)
                    * np.power(5.0 + n, 3)
                    * np.power(6.0 + n, 3)
                    * np.power(7.0 + n, 3)
                    * np.power(8.0 + n, 3)
                    * np.power(9.0 + n, 3)
                    * np.power(10.0 + n, 3)
                )
                + S1 / np.power(1.0 + n, 2)
                + (
                    3.0
                    * (
                        6.7586510592e10
                        + 2.7735912e11 * (1.0 + n)
                        + 5.25886236e11 * np.power(1.0 + n, 2)
                        + 6.098325648e11 * np.power(1.0 + n, 3)
                        + 4.8346372324e11 * np.power(1.0 + n, 4)
                        + 2.77716663e11 * np.power(1.0 + n, 5)
                        + 1.195744907e11 * np.power(1.0 + n, 6)
                        + 3.937668588e10 * np.power(1.0 + n, 7)
                        + 1.0027662147e10 * np.power(1.0 + n, 8)
                        + 1.982481e9 * np.power(1.0 + n, 9)
                        + 3.0344942e8 * np.power(1.0 + n, 10)
                        + 3.560508e7 * np.power(1.0 + n, 11)
                        + 3.141418e6 * np.power(1.0 + n, 12)
                        + 201600.0 * np.power(1.0 + n, 13)
                        + 8880.0 * np.power(1.0 + n, 14)
                        + 240.0 * np.power(1.0 + n, 15)
                        + 3.0 * np.power(1.0 + n, 16)
                    )
                    * (1 / (1.0 + n) + S1)
                )
                / (
                    np.power(2.0 + n, 2)
                    * np.power(3.0 + n, 2)
                    * np.power(4.0 + n, 2)
                    * np.power(5.0 + n, 2)
                    * np.power(6.0 + n, 2)
                    * np.power(7.0 + n, 2)
                    * np.power(8.0 + n, 2)
                    * np.power(9.0 + n, 2)
                    * np.power(10.0 + n, 2)
                )
                + S21
            )
            / (10.0 + n)
            + n
            * (
                -1.0 / np.power(10.0 + n, 5)
                + 1.6449340668482262 / np.power(10.0 + n, 3)
                - 0.8117424252833533 / (10.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (
                            4.0
                            * (9.0 + 2.0 * (1.0 + n))
                            * (
                                3044.0
                                + 5886.0 * (1.0 + n)
                                + 4299.0 * np.power(1.0 + n, 2)
                                + 1539.0 * np.power(1.0 + n, 3)
                                + 288.0 * np.power(1.0 + n, 4)
                                + 27.0 * np.power(1.0 + n, 5)
                                + np.power(1.0 + n, 6)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                            * (9.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(10.0 + n, 4)
                + (
                    1.6449340668482262
                    * (
                        1 / (1.0 + n)
                        + (
                            4.0
                            * (9.0 + 2.0 * (1.0 + n))
                            * (
                                3044.0
                                + 5886.0 * (1.0 + n)
                                + 4299.0 * np.power(1.0 + n, 2)
                                + 1539.0 * np.power(1.0 + n, 3)
                                + 288.0 * np.power(1.0 + n, 4)
                                + 27.0 * np.power(1.0 + n, 5)
                                + np.power(1.0 + n, 6)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                            * (9.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(10.0 + n, 2)
                - (
                    1.0
                    * (
                        np.power(1.0 + n, -3)
                        + (
                            6.0
                            * (
                                2.1452686055424e13
                                + 1.27193972324352e14 * (1.0 + n)
                                + 3.569135825824e14 * np.power(1.0 + n, 2)
                                + 6.28964181904288e14 * np.power(1.0 + n, 3)
                                + 7.79557064653264e14 * np.power(1.0 + n, 4)
                                + 7.2173981400876e14 * np.power(1.0 + n, 5)
                                + 5.17717816384772e14 * np.power(1.0 + n, 6)
                                + 2.94648846212476e14 * np.power(1.0 + n, 7)
                                + 1.35183891860404e14 * np.power(1.0 + n, 8)
                                + 5.0528576648611e13 * np.power(1.0 + n, 9)
                                + 1.5487423206191e13 * np.power(1.0 + n, 10)
                                + 3.905253305568e12 * np.power(1.0 + n, 11)
                                + 8.10278287284e11 * np.power(1.0 + n, 12)
                                + 1.37943606892e11 * np.power(1.0 + n, 13)
                                + 1.9149259574e10 * np.power(1.0 + n, 14)
                                + 2.145327532e9 * np.power(1.0 + n, 15)
                                + 1.90913568e8 * np.power(1.0 + n, 16)
                                + 1.3175883e7 * np.power(1.0 + n, 17)
                                + 679567.0 * np.power(1.0 + n, 18)
                                + 24640.0 * np.power(1.0 + n, 19)
                                + 560.0 * np.power(1.0 + n, 20)
                                + 6.0 * np.power(1.0 + n, 21)
                            )
                        )
                        / (
                            np.power(2.0 + n, 3)
                            * np.power(3.0 + n, 3)
                            * np.power(4.0 + n, 3)
                            * np.power(5.0 + n, 3)
                            * np.power(6.0 + n, 3)
                            * np.power(7.0 + n, 3)
                            * np.power(8.0 + n, 3)
                            * np.power(9.0 + n, 3)
                        )
                        + S1 / np.power(1.0 + n, 2)
                        + (
                            4.0
                            * (
                                6.20783424e8
                                + 2.402913888e9 * (1.0 + n)
                                + 4.261208648e9 * np.power(1.0 + n, 2)
                                + 4.5733464e9 * np.power(1.0 + n, 3)
                                + 3.31344237e9 * np.power(1.0 + n, 4)
                                + 1.713293694e9 * np.power(1.0 + n, 5)
                                + 6.51986769e8 * np.power(1.0 + n, 6)
                                + 1.85551632e8 * np.power(1.0 + n, 7)
                                + 3.9703709e7 * np.power(1.0 + n, 8)
                                + 6.360228e6 * np.power(1.0 + n, 9)
                                + 751317.0 * np.power(1.0 + n, 10)
                                + 63504.0 * np.power(1.0 + n, 11)
                                + 3633.0 * np.power(1.0 + n, 12)
                                + 126.0 * np.power(1.0 + n, 13)
                                + 2.0 * np.power(1.0 + n, 14)
                            )
                            * (1 / (1.0 + n) + S1)
                        )
                        / (
                            np.power(2.0 + n, 2)
                            * np.power(3.0 + n, 2)
                            * np.power(4.0 + n, 2)
                            * np.power(5.0 + n, 2)
                            * np.power(6.0 + n, 2)
                            * np.power(7.0 + n, 2)
                            * np.power(8.0 + n, 2)
                            * np.power(9.0 + n, 2)
                        )
                        + S21
                    )
                )
                / np.power(10.0 + n, 2)
            )
        )
    )
