"""
This module is to contain helpers, which collect info about python code
execution
"""
import os
import sys
from collections import defaultdict
from time import sleep
from timeit import Timer


def print_new_weights(sleep_time=0.2):  # pragma: no cover

    config = {
        "LOGICAL": Timer("x or y", "x=0; y=1"),
        "DICT_LOOKUP": Timer("d['abc']", "d = {'abc': 1}"),
        "MATH_SIMPLE": Timer("x / y", "x=1;y=2"),
        "ATTR_LOOKUP": Timer("A.b", "class A: b = 1"),
        "TUPLE_INIT": Timer("(x,2,3,4,5)", "x=1"),
        "LIST_INIT": Timer("[1,2,3,4,5]"),
        "SET_INIT": Timer("{1,2,3,4,5}"),
        "DICT_INIT": Timer("{'a': 1, 'b': 2, 'c': 3, 'd': 4, 'e': 5}"),
        "FUNCTION_CALL": Timer("f(1,2,3)", "def f(x,y,z): return z"),
    }
    total_time = 0
    total_iterations = 0
    print("# CALCULATING BASE TIME")
    for _ in range(10):
        iterations, time_ = Timer("'abc'").autorange()
        total_time += time_
        total_iterations += iterations
        sleep(sleep_time)

    base_time = total_time / total_iterations / 100

    attempts = 10
    name_to_info = defaultdict(lambda: {"time": 0, "iterations": 0})

    for i in range(attempts):
        print(f"# MEASURING: attempt {i} out of {attempts}")
        for name, timer in config.items():
            iterations_, time_ = timer.autorange()
            name_to_info[name]["iterations"] += iterations_
            name_to_info[name]["time"] += time_

    print(f"#{'.'.join(sys.version_info[:3])}")
    print(
        "class Weights:  #type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811"
    )
    print(f"    # base_time: {base_time}")
    print("    STEP = 100")

    max_it = 1
    for name, info in name_to_info.items():
        it = int(info["time"] / info["iterations"] / base_time)
        print(f"    {name} = {it}")
        max_it = max(max_it, it)

    print(f"    UNPREDICTABLE = {max_it * 100}")


if os.environ.get("BUILD_HEURISTICS"):
    print_new_weights()  # pragma: no cover

# generated by print_new_weights function:
#   from convtools.heuristics import print_new_weights

PY_VERSION = sys.version_info[0:2]
if PY_VERSION <= (3, 6):

    # 3.6.15
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 7.700267359999997e-11
        STEP = 100
        LOGICAL = 254
        DICT_LOOKUP = 326
        MATH_SIMPLE = 408
        ATTR_LOOKUP = 369
        TUPLE_INIT = 583
        LIST_INIT = 880
        SET_INIT = 1767
        DICT_INIT = 1961
        FUNCTION_CALL = 1085
        UNPREDICTABLE = 196100

elif PY_VERSION <= (3, 7):  # pragma: no cover

    # 3.7.13
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 7.392884344000038e-11
        STEP = 100
        LOGICAL = 255
        DICT_LOOKUP = 381
        MATH_SIMPLE = 392
        ATTR_LOOKUP = 368
        TUPLE_INIT = 594
        LIST_INIT = 837
        SET_INIT = 1744
        DICT_INIT = 1850
        FUNCTION_CALL = 1016
        UNPREDICTABLE = 185000

elif PY_VERSION == (3, 8):  # pragma: no cover

    # 3.8.12
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 8.61443491599998e-11
        STEP = 100
        LOGICAL = 268
        DICT_LOOKUP = 373
        MATH_SIMPLE = 429
        ATTR_LOOKUP = 386
        TUPLE_INIT = 586
        LIST_INIT = 863
        SET_INIT = 2119
        DICT_INIT = 2030
        FUNCTION_CALL = 1142
        UNPREDICTABLE = 211900

elif PY_VERSION == (3, 9):  # pragma: no cover

    # 3.9.13
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 9.54243965400002e-11
        STEP = 100
        LOGICAL = 226
        DICT_LOOKUP = 355
        MATH_SIMPLE = 411
        ATTR_LOOKUP = 354
        TUPLE_INIT = 579
        LIST_INIT = 671
        SET_INIT = 1481
        DICT_INIT = 1914
        FUNCTION_CALL = 917
        UNPREDICTABLE = 191400

else:
    # 3.10.5
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 1.1034814140000008e-10
        STEP = 100
        LOGICAL = 230
        DICT_LOOKUP = 301
        MATH_SIMPLE = 343
        ATTR_LOOKUP = 273
        TUPLE_INIT = 680
        LIST_INIT = 675
        SET_INIT = 1377
        DICT_INIT = 1914
        FUNCTION_CALL = 832
        UNPREDICTABLE = 191400
