# ipymolstar

![image](https://github.com/Jhsmit/ipymolstar/assets/7881506/589a94d5-2647-4977-90aa-c886c10cacb9)


## Live Demos

Give `ipymolstar` a spin without even installing python!

 - Try it in jupyter lab via [JupyterLite](https://github.com/Jhsmit/ipymolstar-demo) 🌍🚀
 - Explore the solara ☀️ [demo application](https://github.com/Jhsmit/ploomber-solara-ipymolstar) on [Ploomber-cloud](https://hidden-resonance-5816.ploomberapp.io) ⛅
 - Grab a cup and play with the solara app demo code in [PyCafe](https://app.py.cafe/snippet/solara/v1?c=H4sIAN-cF2YAA8VZCW_bNhT-K5wKDErnOHGbLKsBYWuObgOWLluyAUMUGJRE20JkUqUoJ0aW_76PpCRT8tG0TTEasWTy8fHdB_PgxSJh3tBLZ7mQihQio5KGfCzFjKT5YiayQlFJquWL02N2bqd65OqXs_Ozywo2oYrGGS0KVtTAzVSP0CJJY1WB2jP6NEtpAyvvekTOQ94io5_RKOT681ODK-TmYSg5xeQw5AQDdLK4zNgoTYakUJIEJPQGHxY89CxAXBZKzEYaz5BoYsi_5L3gDID6YYGiySgWmZBLFC_eHelPjaXIUz4kkRAZVt_RrKg2TtOEjXKRLWYMmzes31G1ZXXKsCooiCw2wsRURptXueAjaIYnVEIIm1AIKgvWXdYfLRrMVKL_k9FYpXPm14L2d3ZCPk-LNEqzVC1GcVQA-jr0KrZDrwd5GR7tq8OQnTDU21eX1GrR0BV6N5qUXArFUg0ipNYQThn88c97C_nq4uzAwDU6r8EeLJ-h93NWxkJjs6r27bwepcwCkKZUXgz39vIyiqds1udxlPZ5hpd02p-I-Z5khcLqZC8WfCwk2Cv29jEG378d6Kd-3bs8ffcjAHPBCzZSi5wFBZ2zb5upiBaM0xkLTmokr09HJ7-fX_z-13u8_Ho6Ojx68xpMLcnTYFSBwiIZtxailFO5CIy6qumd6hl6b68unoVV-F7Jkz1Qtnf45vAIS7GQScWnfrVcvk6WPH4e20D-DGyf0PEYVvI8anZ4f3U4ePPVeNfIn4H3SyUX8ZRv4558JvsHB4P9o8FXE4BFDxa-QAaPVVaoYpUhnzOOBJOwMbmw0ePvlN35CDC3IwY7McHMhr2dKmfcpWpah7sTBCI_9KqtZI69oVcD6qEgQR1jQk-jhHTTMRKci5wwEIn1LJ1MVZ0w9HCSZp9lQMOV__KlTYkgUNH-nGYl2-nZQwLzjWC7jUU6YX5NXgzVIdT2SMEU4rv5sQzkJbSCoxXz94FTw3fIbiCRbQ10e91fu2uUSzZPRalzgHNQPduRu2HG5E8ly1iV0tpOe6-sM06jBmjAbqvzQZps2NJKGNf7N9W-JkPcssWGnZzdKz-FxPx2OuljS4Gcp7OeRbaq8G-CTVJxDGdlm7Nm5QoDKHM8mF_XH4EtrZD2rLHd4K1ew6-KOz20zX0Swso6VzFWWoZx2b2jRh4aoW9M1NRFPaId3Ly6DgI-9TwJtI8sFYbw1CZvudSHvVq8LYZaiFwNrqByF5-CrG19K-jayy2ELTY7cAbGHtDYbQfzC8KxMHSrVJIWBIaYECW032rXr0XT3VswNivg5XxcFimfkClDtROxmGI_uWMajVveGoxTcdechpp5k304BAWOYgxL_UzcwS0QlhzkgS6Wn25_Ln6ERNRvLq62x1231GlIWNqlG6vf5vkxBWHOuU4Eu9LR80pMJpkJXWtCvcjKGS_864Me-eHGxbImISCNKYnYbZNBh1H4CupYQ6l_b91C57COlbkn1GOti1UoWubWJcsydlwqhXR7CWsAl6voDUnBOjt1cms9ahaC-mUNTNXZBToi7Y4zdm9Lcf22KwVS5U1n0zqmKxYs8T50xXSZ0vgMbGN5isE8AerdQTvgbUeGNGsE-jFsHce3uE7TuV-oRaaVOGU6Tg7Jq_0cvK7seHIUWCV8g9W4EXOd8PT4JKtxGLtE1dEqEN3R6OH0mOjD12hfD2si3RixDbhooI17bwB9ivV11F_FnCeLtp1D_hfhOna5TbyrEXC7gLO0UBvqli8T91r_OJmy-DYS92t4rfnU9yNrebSHLovdvobcFowyOosSSu7R3Dj5RO8K7rvMrRCMfsL650jX28QU9O7FxRoToMrc-KD9MNckD8vtj7qW_7ixaQSB_tpkYC4fL18-aNAhuX_cZltbJL6UekUyaZO81c4mDA2Bkk7zYel_VquJFF_W3FWcRtFJ41tEYjSbqGhM8dkjUSbi2-BKtmo3PdzMp3P7OeOlbwp3XCvJACfoMI-bnhEIQ4Gk0CCN4iwFNtMyrlOFnOsKQMgLQKG82SAmxIEEsnUMtq6Wt4io2rTedJtSfMV8t_lcLbeVDaEnWSIpUm9Pn22ZtiejNF82gn7dEH5HBijllqLe4kIvPq01fmG-n9rl7ugI5cNoq6vl3YeKQhito37bsQGsWR49tPso45c1-Oae356Hvw6LdUGl-z94Ti2nHQhK_-wg2d6O_0YXolR-PE2zRDJeCwdmruBZ5tFplM3c-tb6qQ25ZKg-uFMUV1QsmazpCeoX3DDg_iOi0qCEdbt44UrGPpfX4TtaThvvOXKZznA5Y7Tm9WCOH8pUGr0X-v8Jzf8OsKYrJMxZUvGb5rnWlDccm4sdjyWpOuM0ygCFIMYe_wOmoGbMlxgAAA) ☕
 - Upload your Alphafold3 .zip result and view plddt or chain colors in the `solarafold` result viewer on [huggingface](https://huggingface.co/spaces/Jhsmit/solarafold) 🤗


## Installation

```sh
pip install ipymolstar
```


## Use

```python
from ipymolstar import PDBeMolstar
view = PDBeMolstar(molecule_id='1qyn', theme='light', hide_water=True)
view
```

Loading local data, hiding the buttons:

```python
from pathlib import Path 
fpth = Path().resolve() / 'assets' / '6vsb.bcif'
custom_data = {
    'data': fpth.read_bytes(),
    'format': 'cif',
    'binary': True,
    }
view = PDBeMolstar(
    custom_data=custom_data, 
    hide_controls_icon=True, 
    hide_expand_icon=True, 
    hide_settings_icon=True, 
    hide_selection_icon=True, 
    hide_animation_icon=True,
    hide_water=True,
    hide_carbs=True,
)
view
```

See the example notebook for more advanced usage. 
Solara example code can be found [here](https://github.com/Jhsmit/ploomber-solara-ipymolstar)

## Cite

`ipymolstar` uses [anywidget](https://github.com/manzt/anywidget) to create a widget based on the [PDBe integration](https://github.com/molstar/pdbe-molstar) of [Mol*](https://molstar.org/).

When using `ipymolstar`, please cite:

David Sehnal, Sebastian Bittrich, Mandar Deshpande, Radka Svobodová, Karel Berka, Václav Bazgier, Sameer Velankar, Stephen K Burley, Jaroslav Koča, Alexander S Rose: Mol* Viewer: modern web app for 3D visualization and analysis of large biomolecular structures, Nucleic Acids Research, 2021; [10.1093/nar/gkab31](https://doi.org/10.1093/nar/gkab314).

See also the [RCSB citation policies](https://www.rcsb.org/pages/policies) for additional citation information.

## Development

### Creating a new release

- update `__version__` in `__init__.py`
- create a new release on GitHub, choose as tag 'v' + `__version__`; ie 'v0.0.3'
- GitHub actions should automatically deploy to PyPi

### Hot reloading

To enable anywidget hot reloading, you need to set th env var `ANYWIDGET_HMR` to 1. 

Windows:
```bash
set ANYWIDGET_HMR=1
jupyter lab
```
