import sys
import pprint

sys.path.insert(0, "..")

from ttp_templates import get_template
from ttp import ttp


def test_N2G_ospf_lsdb_Cisco_IOSXR():
    with open("./mock_data/cisco_xr_show_ip_ospf_database_router_external_summary_router-1.txt", "r") as f:
        data1 = f.read()
    with open("./mock_data/cisco_xr_show_ip_ospf_database_router_external_summary_router-2.txt", "r") as f:
        data2 = f.read()
    template = get_template(path="misc/N2G/ospf_lsdb/Cisco_IOSXR.txt")
    # print(template)
    parser = ttp(template=template)
    parser.add_input(data1)
    parser.add_input(data2)
    parser.parse()
    res = parser.result()
    pprint.pprint(res)
    assert res == [[{'ospf_processes': {'1': {'external_lsa': [{'mask': '0',
                                              'metric': '1',
                                              'metric_type': '2',
                                              'originator_rid': '10.3.22.190',
                                              'subnet': '0.0.0.0',
                                              'tag': '10'},
                                             {'mask': '0',
                                              'metric': '1',
                                              'metric_type': '2',
                                              'originator_rid': '10.3.25.22',
                                              'subnet': '0.0.0.0',
                                              'tag': '10'},
                                             {'mask': '8',
                                              'metric': '20',
                                              'metric_type': '2',
                                              'originator_rid': '10.3.20.95',
                                              'subnet': '10.0.0.0',
                                              'tag': '0'},
                                             {'mask': '24',
                                              'metric': '20',
                                              'metric_type': '2',
                                              'originator_rid': '10.3.22.83',
                                              'subnet': '10.0.2.0',
                                              'tag': '0'}],
                            'local_rid': '10.1.2.2',
                            'router_lsa': [{'area': '0.0.0.0',
                                            'asbr': True,
                                            'bma_peers': [{'link_data': '10.3.162.14',
                                                           'link_id': '10.3.162.13',
                                                           'metric': '1'},
                                                          {'link_data': '10.3.162.10',
                                                           'link_id': '10.3.162.9',
                                                           'metric': '1'}],
                                            'connected_stub': [{'link_data': '255.255.255.252',
                                                                'link_id': '10.0.61.0',
                                                                'metric': '9100'}],
                                            'originator_rid': '10.1.0.91',
                                            'ptp_peers': [{'link_data': '10.0.61.1',
                                                           'link_id': '10.1.1.251',
                                                           'metric': '9100'},
                                                          {'link_data': '10.0.61.94',
                                                           'link_id': '10.1.2.6',
                                                           'metric': '65535'},
                                                          {'link_data': '0.0.1.220',
                                                           'link_id': '10.1.2.7',
                                                           'metric': '3000'}]},
                                           {'area': '0.0.0.0',
                                            'asbr': True,
                                            'connected_stub': [{'link_data': '255.255.255.252',
                                                                'link_id': '10.0.61.96',
                                                                'metric': '9000'}],
                                            'originator_rid': '10.1.0.92',
                                            'ptp_peers': [{'link_data': '0.0.2.5',
                                                           'link_id': '10.1.2.6',
                                                           'metric': '1100'},
                                                          {'link_data': '0.0.2.67',
                                                           'link_id': '10.1.2.8',
                                                           'metric': '3000'},
                                                          {'link_data': '0.0.2.69',
                                                           'link_id': '10.1.2.7',
                                                           'metric': '3000'}]}],
                            'summary_lsa': [{'area': '0.0.0.0',
                                             'mask': '32',
                                             'metric': '2312',
                                             'originator_rid': '10.0.24.1',
                                             'subnet': '10.1.0.1'},
                                            {'area': '0.0.0.0',
                                             'mask': '32',
                                             'metric': '1806',
                                             'originator_rid': '10.0.24.2',
                                             'subnet': '10.1.0.1'},
                                            {'area': '0.0.0.0',
                                             'mask': '32',
                                             'metric': '1312',
                                             'originator_rid': '10.0.25.192',
                                             'subnet': '10.1.0.1'},
                                            {'area': '0.0.0.0',
                                             'mask': '32',
                                             'metric': '806',
                                             'originator_rid': '10.0.25.193',
                                             'subnet': '10.1.0.1'},
                                            {'area': '0.0.0.32',
                                             'mask': '32',
                                             'metric': '2312',
                                             'originator_rid': '10.0.24.1',
                                             'subnet': '10.1.0.1'}]}}},
  {'ospf_processes': {'1': {'local_rid': '10.1.2.2',
                            'router_lsa': [{'area': '0.0.0.0',
                                            'asbr': True,
                                            'connected_stub': [{'link_data': '255.255.255.252',
                                                                'link_id': '10.0.60.204',
                                                                'metric': '9000'},
                                                               {'link_data': '255.255.255.252',
                                                                'link_id': '10.0.60.196',
                                                                'metric': '9000'}],
                                            'originator_rid': '10.1.0.91',
                                            'ptp_peers': [{'link_data': '10.0.60.206',
                                                           'link_id': '10.0.24.6',
                                                           'metric': '9000'},
                                                          {'link_data': '10.0.60.197',
                                                           'link_id': '10.1.0.92',
                                                           'metric': '9000'}]},
                                           {'area': '0.0.0.0',
                                            'asbr': True,
                                            'connected_stub': [{'link_data': '255.255.255.252',
                                                                'link_id': '10.0.60.108',
                                                                'metric': '1'},
                                                               {'link_data': '255.255.255.252',
                                                                'link_id': '10.0.60.200',
                                                                'metric': '9000'}],
                                            'originator_rid': '10.1.0.92',
                                            'ptp_peers': [{'link_data': '10.0.60.109',
                                                           'link_id': '10.0.24.31',
                                                           'metric': '1'},
                                                          {'link_data': '10.0.60.201',
                                                           'link_id': '10.0.24.5',
                                                           'metric': '9000'}]},
                                           {'area': '0.0.0.1',
                                            'asbr': True,
                                            'originator_rid': '10.1.0.91',
                                            'ptp_peers': [{'link_data': '10.0.60.206',
                                                           'link_id': '10.0.24.6',
                                                           'metric': '9000'}]}],
                            'summary_lsa': [{'area': '0.0.0.0',
                                             'mask': '32',
                                             'metric': '2312',
                                             'originator_rid': '10.0.24.1',
                                             'subnet': '10.1.0.1'},
                                            {'area': '0.0.0.0',
                                             'mask': '32',
                                             'metric': '1806',
                                             'originator_rid': '10.0.24.2',
                                             'subnet': '10.1.0.1'},
                                            {'area': '0.0.0.0',
                                             'mask': '32',
                                             'metric': '1312',
                                             'originator_rid': '10.0.25.192',
                                             'subnet': '10.1.0.1'},
                                            {'area': '0.0.0.0',
                                             'mask': '32',
                                             'metric': '806',
                                             'originator_rid': '10.0.25.193',
                                             'subnet': '10.1.0.1'}]},
                      '10': {'external_lsa': [{'mask': '0',
                                               'metric': '1',
                                               'metric_type': '2',
                                               'originator_rid': '10.3.22.190',
                                               'subnet': '0.0.0.0',
                                               'tag': '10'},
                                              {'mask': '0',
                                               'metric': '1',
                                               'metric_type': '2',
                                               'originator_rid': '10.3.25.22',
                                               'subnet': '0.0.0.0',
                                               'tag': '10'},
                                              {'mask': '8',
                                               'metric': '20',
                                               'metric_type': '2',
                                               'originator_rid': '10.3.20.95',
                                               'subnet': '10.0.0.0',
                                               'tag': '0'},
                                              {'mask': '24',
                                               'metric': '20',
                                               'metric_type': '2',
                                               'originator_rid': '10.3.22.83',
                                               'subnet': '10.0.2.0',
                                               'tag': '0'}],
                             'local_rid': '10.3.22.75'}}}]]

# test_N2G_ospf_lsdb_Cisco_IOSXR()

def test_N2G_ospf_lsdb_Cisco_IOS():
    with open("./mock_data/cisco_ios_show_ip_ospf_database_router_external_summary_IOL4_ABR.txt", "r") as f:
        data = f.read()
    template = get_template(path="misc/N2G/ospf_lsdb/Cisco_IOS.txt")
    # print(template)
    parser = ttp(data=data, template=template)
    parser.parse()
    res = parser.result()
    pprint.pprint(res)    
    assert res == [[{'ospf_processes': {'1': {'external_lsa': [{'mask': '32',
                                              'metric': '20',
                                              'metric_type': '2',
                                              'originator_rid': '10.0.0.10',
                                              'subnet': '10.0.0.100',
                                              'tag': '0'},
                                             {'mask': '32',
                                              'metric': '20',
                                              'metric_type': '2',
                                              'originator_rid': '10.0.0.10',
                                              'subnet': '10.0.0.101',
                                              'tag': '0'},
                                             {'mask': '32',
                                              'metric': '20',
                                              'metric_type': '2',
                                              'originator_rid': '10.0.0.10',
                                              'subnet': '10.0.0.102',
                                              'tag': '0'},
                                             {'mask': '32',
                                              'metric': '20',
                                              'metric_type': '2',
                                              'originator_rid': '10.0.0.10',
                                              'subnet': '10.0.0.103',
                                              'tag': '0'},
                                             {'mask': '32',
                                              'metric': '20',
                                              'metric_type': '2',
                                              'originator_rid': '10.0.5.101',
                                              'subnet': '10.0.5.100',
                                              'tag': '0'},
                                             {'mask': '32',
                                              'metric': '20',
                                              'metric_type': '2',
                                              'originator_rid': '10.0.5.101',
                                              'subnet': '10.0.5.101',
                                              'tag': '0'}],
                            'local_rid': '10.0.0.4',
                            'router_lsa': [{'area': '0',
                                            'asbr': False,
                                            'bma_peers': [{'link_data': '10.1.117.3',
                                                           'link_id': '10.1.117.7',
                                                           'metric': '10'}],
                                            'originator_rid': '10.0.0.3'},
                                           {'area': '0',
                                            'asbr': False,
                                            'bma_peers': [{'link_data': '10.1.117.4',
                                                           'link_id': '10.1.117.7',
                                                           'metric': '10'}],
                                            'connected_stub': [{'link_data': '255.255.255.128',
                                                                'link_id': '10.1.14.0',
                                                                'metric': '10'}],
                                            'originator_rid': '10.0.0.4',
                                            'ptp_peers': [{'link_data': '10.1.14.4',
                                                           'link_id': '10.0.0.10',
                                                           'metric': '10'}]},
                                           {'area': '0',
                                            'asbr': False,
                                            'bma_peers': [{'link_data': '10.1.117.7',
                                                           'link_id': '10.1.117.7',
                                                           'metric': '10'}],
                                            'connected_stub': [{'link_data': '255.255.255.255',
                                                                'link_id': '10.0.0.7',
                                                                'metric': '1'},
                                                               {'link_data': '255.255.255.252',
                                                                'link_id': '10.1.107.0',
                                                                'metric': '10'},
                                                               {'link_data': '255.255.255.0',
                                                                'link_id': '10.1.37.0',
                                                                'metric': '10'}],
                                            'originator_rid': '10.0.0.7',
                                            'ptp_peers': [{'link_data': '10.1.107.2',
                                                           'link_id': '10.0.0.10',
                                                           'metric': '10'}]},
                                           {'area': '0',
                                            'asbr': True,
                                            'connected_stub': [{'link_data': '255.255.255.255',
                                                                'link_id': '10.0.0.10',
                                                                'metric': '1'},
                                                               {'link_data': '255.255.255.252',
                                                                'link_id': '10.1.107.0',
                                                                'metric': '10'},
                                                               {'link_data': '255.255.255.128',
                                                                'link_id': '10.1.14.0',
                                                                'metric': '10'}],
                                            'originator_rid': '10.0.0.10',
                                            'ptp_peers': [{'link_data': '10.1.107.1',
                                                           'link_id': '10.0.0.7',
                                                           'metric': '10'},
                                                          {'link_data': '10.1.14.1',
                                                           'link_id': '10.0.0.4',
                                                           'metric': '10'}]},
                                           {'area': '100',
                                            'asbr': False,
                                            'connected_stub': [{'link_data': '255.255.255.254',
                                                                'link_id': '10.1.45.2',
                                                                'metric': '10'}],
                                            'originator_rid': '10.0.0.4',
                                            'ptp_peers': [{'link_data': '10.1.45.2',
                                                           'link_id': '10.0.5.101',
                                                           'metric': '10'}]},
                                           {'area': '100',
                                            'asbr': True,
                                            'connected_stub': [{'link_data': '255.255.255.254',
                                                                'link_id': '10.1.45.2',
                                                                'metric': '10'}],
                                            'originator_rid': '10.0.5.101',
                                            'ptp_peers': [{'link_data': '10.1.45.3',
                                                           'link_id': '10.0.0.4',
                                                           'metric': '10'}]}],
                            'summary_lsa': [{'area': '0',
                                             'mask': '31',
                                             'metric': '10',
                                             'originator_rid': '10.0.0.4',
                                             'subnet': '10.1.45.2'},
                                            {'area': '100',
                                             'mask': '32',
                                             'metric': '11',
                                             'originator_rid': '10.0.0.4',
                                             'subnet': '10.0.0.7'},
                                            {'area': '100',
                                             'mask': '32',
                                             'metric': '11',
                                             'originator_rid': '10.0.0.4',
                                             'subnet': '10.0.0.10'},
                                            {'area': '100',
                                             'mask': '25',
                                             'metric': '10',
                                             'originator_rid': '10.0.0.4',
                                             'subnet': '10.1.14.0'},
                                            {'area': '100',
                                             'mask': '24',
                                             'metric': '20',
                                             'originator_rid': '10.0.0.4',
                                             'subnet': '10.1.37.0'},
                                            {'area': '100',
                                             'mask': '30',
                                             'metric': '20',
                                             'originator_rid': '10.0.0.4',
                                             'subnet': '10.1.107.0'},
                                            {'area': '100',
                                             'mask': '24',
                                             'metric': '10',
                                             'originator_rid': '10.0.0.4',
                                             'subnet': '10.1.117.0'}]}}}]]
   
# test_N2G_ospf_lsdb_Cisco_IOS()


def test_N2G_ospf_lsdb_huawei():
    with open("./mock_data/huawei_display_ospf_lsdb_router.txt", "r") as f:
        data = f.read()
    template = get_template(path="misc/N2G/ospf_lsdb/Huawei.txt")
    # print(template)
    parser = ttp(data=data, template=template)
    parser.parse()
    res = parser.result()
    pprint.pprint(res)    
    assert res == [[{'ospf_processes': {'123': {'local_rid': '123.123.24.158',
                              'router_lsa': [{'area': '0.0.0.123',
                                              'originator_rid': '10.123.0.91',
                                              'ptp_peers': [{'link_data': '123.123.60.206',
                                                             'link_id': '123.123.24.6',
                                                             'metric': '9000'},
                                                            {'link_data': '123.123.1.220',
                                                             'link_id': '10.123.2.7',
                                                             'metric': '3000'}]},
                                             {'area': '0.0.0.123',
                                              'connected_stub': [{'link_data': '255.255.255.252',
                                                                  'link_id': '123.123.60.108',
                                                                  'metric': '1'}],
                                              'originator_rid': '10.123.0.92',
                                              'ptp_peers': [{'link_data': '123.123.60.109',
                                                             'link_id': '123.123.24.31',
                                                             'metric': '1'},
                                                            {'link_data': '123.123.60.201',
                                                             'link_id': '123.123.24.5',
                                                             'metric': '9000'}]}]}}}]]
                                                             
# test_N2G_ospf_lsdb_huawei()