# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aw_client']

package_data = \
{'': ['*']}

install_requires = \
['aw-core>=0.5.1,<0.6.0',
 'click>=7.1.1,<8.0.0',
 'persist-queue>=0.6.0,<0.7.0',
 'requests>=2.22.0,<3.0.0']

entry_points = \
{'console_scripts': ['aw-client = aw_client.cli:main']}

setup_kwargs = {
    'name': 'aw-client',
    'version': '0.5.4',
    'description': 'Client library for ActivityWatch',
    'long_description': 'aw-client\n=========\n\n[![GitHub Actions badge](https://github.com/ActivityWatch/aw-client/workflows/Build/badge.svg)](https://github.com/ActivityWatch/aw-client/actions)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Typechecking: Mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](http://mypy-lang.org/)\n\n\n[**Documentation**](https://activitywatch.readthedocs.io/en/latest/)\n\nClient library for ActivityWatch in Python.\n\nPlease see the documentation for usage and examples.\n\n\n## How to install\n\nTo install the latest git version directly from github without cloning, run\n`pip install git+https://github.com/ActivityWatch/aw-client.git`\n\nTo install from a cloned version, cd into the directory and run\n`poetry install` to install inside an virtualenv. If you want to install it\nsystem-wide it can be installed with `pip install .`, but that has the issue\nthat it might not get the exact version of the dependencies due to not reading\nthe poetry.lock file.\n\n\n## Examples\n\nThe `examples/` directory contains a couple of example scripts, including:\n\n - `time_spent_today.py` - fetches all non-afk events and sums their duration to get the total active time for the day.\n - `merge_buckets.py` - merges two buckets with non-intersecting events by moving all events from one into the other.\n - `redact_sensitive.py` - redact sensitive events.\n',
    'author': 'Erik Bjäreholt',
    'author_email': 'erik@bjareho.lt',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://activitywatch.net/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
