# Generated by Django 3.2.11 on 2022-01-27 00:32

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.expressions


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("api", "0031_auto_20220127_0032"),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.CreateModel(
                    name="Span",
                    fields=[
                        (
                            "id",
                            models.BigAutoField(
                                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                            ),
                        ),
                        ("prob", models.FloatField(default=0.0)),
                        ("manual", models.BooleanField(default=False)),
                        ("created_at", models.DateTimeField(auto_now_add=True)),
                        ("updated_at", models.DateTimeField(auto_now=True)),
                        ("start_offset", models.IntegerField()),
                        ("end_offset", models.IntegerField()),
                        (
                            "example",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.CASCADE, related_name="spans", to="api.example"
                            ),
                        ),
                        ("label", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="api.spantype")),
                        (
                            "user",
                            models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
                        ),
                    ],
                ),
                migrations.CreateModel(
                    name="Category",
                    fields=[
                        (
                            "id",
                            models.BigAutoField(
                                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                            ),
                        ),
                        ("prob", models.FloatField(default=0.0)),
                        ("manual", models.BooleanField(default=False)),
                        ("created_at", models.DateTimeField(auto_now_add=True)),
                        ("updated_at", models.DateTimeField(auto_now=True)),
                        (
                            "example",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.CASCADE, related_name="categories", to="api.example"
                            ),
                        ),
                        (
                            "label",
                            models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="api.categorytype"),
                        ),
                        (
                            "user",
                            models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
                        ),
                    ],
                ),
                migrations.CreateModel(
                    name="AnnotationRelations",
                    fields=[
                        (
                            "id",
                            models.BigAutoField(
                                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                            ),
                        ),
                        ("annotation_id_1", models.IntegerField()),
                        ("annotation_id_2", models.IntegerField()),
                        ("timestamp", models.DateTimeField()),
                        (
                            "project",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.CASCADE,
                                related_name="annotation_relations",
                                to="api.project",
                            ),
                        ),
                        (
                            "type",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.CASCADE,
                                related_name="annotation_relations",
                                to="api.relationtypes",
                            ),
                        ),
                        (
                            "user",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.CASCADE,
                                related_name="annotation_relations",
                                to=settings.AUTH_USER_MODEL,
                            ),
                        ),
                    ],
                ),
                migrations.CreateModel(
                    name="TextLabel",
                    fields=[
                        (
                            "id",
                            models.BigAutoField(
                                auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                            ),
                        ),
                        ("prob", models.FloatField(default=0.0)),
                        ("manual", models.BooleanField(default=False)),
                        ("created_at", models.DateTimeField(auto_now_add=True)),
                        ("updated_at", models.DateTimeField(auto_now=True)),
                        ("text", models.TextField()),
                        (
                            "example",
                            models.ForeignKey(
                                on_delete=django.db.models.deletion.CASCADE, related_name="texts", to="api.example"
                            ),
                        ),
                        (
                            "user",
                            models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
                        ),
                    ],
                    options={
                        "unique_together": {("example", "user", "text")},
                    },
                ),
                migrations.AddConstraint(
                    model_name="span",
                    constraint=models.CheckConstraint(
                        check=models.Q(("start_offset__gte", 0)), name="startOffset >= 0"
                    ),
                ),
                migrations.AddConstraint(
                    model_name="span",
                    constraint=models.CheckConstraint(check=models.Q(("end_offset__gte", 0)), name="endOffset >= 0"),
                ),
                migrations.AddConstraint(
                    model_name="span",
                    constraint=models.CheckConstraint(
                        check=models.Q(("start_offset__lt", django.db.models.expressions.F("end_offset"))),
                        name="start < end",
                    ),
                ),
                migrations.AlterUniqueTogether(
                    name="category",
                    unique_together={("example", "user", "label")},
                ),
                migrations.AlterUniqueTogether(
                    name="annotationrelations",
                    unique_together={("annotation_id_1", "annotation_id_2", "type", "project")},
                ),
            ],
            database_operations=[],
        )
    ]
