# Generated by Django 3.2.8 on 2021-12-21 14:15

import django.db.models.deletion
from django.db import migrations, models
from label_types.models import generate_random_hex_color


class Migration(migrations.Migration):

    dependencies = [
        ("api", "0019_auto_20211124_0506"),
    ]

    operations = [
        migrations.CreateModel(
            name="CategoryType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("text", models.CharField(db_index=True, max_length=100)),
                (
                    "prefix_key",
                    models.CharField(
                        blank=True,
                        choices=[("ctrl", "ctrl"), ("shift", "shift"), ("ctrl shift", "ctrl shift")],
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "suffix_key",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("0", "0"),
                            ("1", "1"),
                            ("2", "2"),
                            ("3", "3"),
                            ("4", "4"),
                            ("5", "5"),
                            ("6", "6"),
                            ("7", "7"),
                            ("8", "8"),
                            ("9", "9"),
                            ("a", "a"),
                            ("b", "b"),
                            ("c", "c"),
                            ("d", "d"),
                            ("e", "e"),
                            ("f", "f"),
                            ("g", "g"),
                            ("h", "h"),
                            ("i", "i"),
                            ("j", "j"),
                            ("k", "k"),
                            ("l", "l"),
                            ("m", "m"),
                            ("n", "n"),
                            ("o", "o"),
                            ("p", "p"),
                            ("q", "q"),
                            ("r", "r"),
                            ("s", "s"),
                            ("t", "t"),
                            ("u", "u"),
                            ("v", "v"),
                            ("w", "w"),
                            ("x", "x"),
                            ("y", "y"),
                            ("z", "z"),
                        ],
                        max_length=1,
                        null=True,
                    ),
                ),
                ("background_color", models.CharField(default=generate_random_hex_color, max_length=7)),
                ("text_color", models.CharField(default="#ffffff", max_length=7)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "ordering": ["created_at"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SpanType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("text", models.CharField(db_index=True, max_length=100)),
                (
                    "prefix_key",
                    models.CharField(
                        blank=True,
                        choices=[("ctrl", "ctrl"), ("shift", "shift"), ("ctrl shift", "ctrl shift")],
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "suffix_key",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("0", "0"),
                            ("1", "1"),
                            ("2", "2"),
                            ("3", "3"),
                            ("4", "4"),
                            ("5", "5"),
                            ("6", "6"),
                            ("7", "7"),
                            ("8", "8"),
                            ("9", "9"),
                            ("a", "a"),
                            ("b", "b"),
                            ("c", "c"),
                            ("d", "d"),
                            ("e", "e"),
                            ("f", "f"),
                            ("g", "g"),
                            ("h", "h"),
                            ("i", "i"),
                            ("j", "j"),
                            ("k", "k"),
                            ("l", "l"),
                            ("m", "m"),
                            ("n", "n"),
                            ("o", "o"),
                            ("p", "p"),
                            ("q", "q"),
                            ("r", "r"),
                            ("s", "s"),
                            ("t", "t"),
                            ("u", "u"),
                            ("v", "v"),
                            ("w", "w"),
                            ("x", "x"),
                            ("y", "y"),
                            ("z", "z"),
                        ],
                        max_length=1,
                        null=True,
                    ),
                ),
                ("background_color", models.CharField(default=generate_random_hex_color, max_length=7)),
                ("text_color", models.CharField(default="#ffffff", max_length=7)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "ordering": ["created_at"],
                "abstract": False,
            },
        ),
        migrations.AlterUniqueTogether(
            name="label",
            unique_together=set(),
        ),
        migrations.AddConstraint(
            model_name="label",
            constraint=models.UniqueConstraint(fields=("project", "text"), name="api_label_is_unique"),
        ),
        migrations.AddField(
            model_name="spantype",
            name="project",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="api.project"),
        ),
        migrations.AddField(
            model_name="categorytype",
            name="project",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="api.project"),
        ),
        migrations.AddConstraint(
            model_name="spantype",
            constraint=models.UniqueConstraint(fields=("project", "text"), name="api_spantype_is_unique"),
        ),
        migrations.AddConstraint(
            model_name="categorytype",
            constraint=models.UniqueConstraint(fields=("project", "text"), name="api_categorytype_is_unique"),
        ),
    ]
