corpus = [  # pragma: no cover
    [
        "Time[]{2018-01-04 X:X (X/X)}",
        "2017-12-20T20:34",
        [
            "THURSDAY 4th JANUARY 2018",
            "04. Januar 2018",
            "THURSDAY 4th JANUARY 2018",
            "THURSDAY 4th JANUARY 2018",
            "04. Januar 2018",
        ],
    ],
    [
        "Interval[]{2017-03-12 18:40 (X/X) - 2017-03-12 19:45 (X/X)}",
        "2017-02-10T10:59",
        ["Am 12.03.2017 18:40 - 19:45", "Am 12.03.2017 18:40 - 19:45"],
    ],
    [
        "Time[]{2017-05-11 X:X (X/X)}",
        "2017-05-09T06:47",
        ["Do, 11. Mai 2017", "am 11.", "Donnerstag, 11.05.17", "Do, 11. Mai 2017"],
    ],
    [
        "Interval[]{2016-05-04 08:00 (X/X) - 2016-05-04 09:00 (X/X)}",
        "2016-04-06T15:25",
        ["Mi., 04.05.2016 ca. 08:00 Uhr bis ca. 09:00 Uhr"],
    ],
    [
        "Interval[]{2018-02-05 X:X (X/X) - 2018-02-15 X:X (X/X)}",
        "2018-01-26T09:32",
        ["Feb 5-15"],
    ],
    [
        "Time[]{2016-05-27 14:00 (X/X)}",
        "2016-05-24T04:39",
        ["Fri 5/27 2:00pm", "Fri 5/27 2:00pm"],
    ],
    ["Time[]{2016-05-27 17:20 (X/X)}", "2016-05-24T04:39", ["Fri 5/27 5:20pm"]],
    [
        "Time[]{2016-06-24 12:40 (X/X)}",
        "2016-06-22T09:08",
        ["Fri 6/24 12:40pm", "Fri 6/24 12:40pm"],
    ],
    [
        "Time[]{2016-09-23 20:00 (X/X)}",
        "2016-09-06T05:05",
        ["Fri 9/23 8pm", "Fri 9/23 8pm"],
    ],
    [
        "Time[]{2016-10-26 06:30 (X/X)}",
        "2016-10-11T08:25",
        ["Oct 26 morning 6:30", "Oct 26 morning 6:30"],
    ],
    [
        "Time[]{2018-02-28 X:X (X/X)}",
        "2017-12-12T09:33",
        ["Feb 28, 2018", "Feb 28, 2018", "Feb 28, 2018"],
    ],
    [
        "Interval[]{2017-03-01 X:X (X/X) - 2017-03-03 X:X (X/X)}",
        "2017-02-24T12:30",
        ["Vom 01.03. bis 03.03"],
    ],
    [
        "Time[]{2017-10-20 X:X (X/X)}",
        "2017-09-19T09:42",
        ["Fri 20th Oct 2017", "Fri 20th Oct 2017", "Fri 20th Oct 2017"],
    ],
    [
        "Time[]{2017-02-03 X:X (X/X)}",
        "2017-02-01T11:43",
        [
            "Februar 3, 2017",
            "am 3. Februar 2017",
            "Februar 3, 2017",
            "Februar 3, 2017",
            "Freitag 03.02",
            "am 3. Februar 2017",
        ],
    ],
    [
        "Time[]{2017-11-02 X:X (X/X)}",
        "2017-09-03T11:45",
        [
            "November 2, 2017",
            "November 2, 2017",
            "November 2, 2017",
            "Donnerstag, 02.11.",
        ],
    ],
    [
        "Interval[]{2017-04-03 X:X (X/X) - 2017-04-04 X:X (X/X)}",
        "2017-03-14T08:31",
        ["April 3-4"],
    ],
    ["Time[]{2016-06-05 X:X (X/X)}", "2016-06-02T07:52", ["Sunday 6/5", "Sunday 6/5"]],
    ["Time[]{2018-04-27 X:X (X/X)}", "2017-12-14T23:57", ["Friday 27"]],
    [
        "Interval[]{2017-08-21 X:X (X/X) - 2017-08-25 X:X (X/X)}",
        "2017-08-08T09:40",
        ["August 21-25"],
    ],
    [
        "Time[]{2018-02-16 X:X (X/X)}",
        "2018-01-10T11:14",
        ["Freitag 16.", "Freitag 16."],
    ],
    [
        "Time[]{2017-07-13 X:X (X/X)}",
        "2017-07-06T08:05",
        ["Donnerstag 13. Juli 2017", "Donnerstag 13. Juli 2017"],
    ],
    [
        "Time[]{2017-11-10 X:X (X/X)}",
        "2017-08-02T06:57",
        ["Freitag 10.November 2017", "Freitag 10.November 2017"],
    ],
    [
        "Time[]{2016-01-26 X:X (X/morning)}",
        "2016-01-13T12:05",
        ["Dienstagmorgen 26.1."],
    ],
    [
        "Time[]{2017-08-17 13:55 (X/X)}",
        "2017-08-10T09:11",
        ["Donnerstag 17.8. 13:55", "Donnerstag 17.8. 13:55", "Donnerstag 17.8. 13:55"],
    ],
    [
        "Time[]{2017-12-01 X:X (X/afternoon)}",
        "2017-11-07T16:48",
        ["Freitagnachmittag 01.12."],
    ],
    [
        "Time[]{2016-03-08 X:X (X/evening)}",
        "2015-11-19T08:54",
        ["Dienstagabend 08.03.16"],
    ],
    [
        "Time[]{2017-02-07 X:X (X/morning)}",
        "2017-01-13T10:30",
        ["Dienstagmorgen 07.02.17"],
    ],
    ["Time[]{2016-04-17 X:X (X/X)}", "2016-04-08T11:42", ["Sunday 17th"]],
    [
        "Time[]{2018-03-24 X:X (X/X)}",
        "2018-03-09T15:21",
        [
            "Saturday 24th March 2018",
            "Saturday 24th March 2018",
            "Saturday 24th March 2018",
        ],
    ],
    [
        "Time[]{2016-05-26 X:X (X/evening)}",
        "2016-05-23T07:31",
        ["Thursday 26th in the evening"],
    ],
    [
        "Time[]{2016-10-19 X:X (X/evening)}",
        "2016-10-11T17:10",
        ["Wednesday 19th evening"],
    ],
    [
        "Time[]{2017-05-12 X:X (X/last)}",
        "2017-05-04T07:31",
        ["Friday 12th last flight"],
    ],
    ["Time[]{2017-05-08 X:X (X/X)}", "2017-04-27T14:52", ["Monday 8th"]],
    [
        "Time[]{2018-03-09 X:X (X/X)}",
        "2018-02-15T12:21",
        [
            "Friday 9th March 2018",
            "Friday 9th March 2018",
            "Friday 9th March 2018",
            "am Freitag 09.03",
        ],
    ],
    [
        "Time[]{2017-09-13 X:X (X/X)}",
        "2017-09-11T14:17",
        ["Mittwoch den 13.", "Mittwoch den 13."],
    ],
    [
        "Interval[]{2017-08-08 20:05 (X/X) - 2017-08-08 21:00 (X/X)}",
        "2017-08-03T11:10",
        [
            "Dienstag den 08.08.2017 20:05 - 21:00 Uhr",
            "Dienstag den 08.08.2017 20:05 - 21:00 Uhr",
            "Dienstag den 08.08.2017 20:05 - 21:00 Uhr",
        ],
    ],
    [
        "Time[]{2016-12-22 X:X (X/X)}",
        "2016-12-19T21:12",
        ["Donnerstag diese Woche", "Donnerstag diese Woche", "Donnerstag diese Woche"],
    ],
    [
        "Time[]{2018-03-26 X:X (X/evening)}",
        "2017-12-15T11:14",
        ["Monday evening 26th March"],
    ],
    [
        "Time[]{2017-06-19 X:X (X/morning)}",
        "2017-05-18T06:53",
        ["Monday morning, 19.6.17"],
    ],
    [
        "Time[]{2018-03-01 X:X (X/X)}",
        "2018-01-10T12:18",
        [
            "Donnerstag, 1. M\u00e4rz 2018",
            "Donnerstag, den 01. M\u00e4rz 2018",
            "1-3-2018",
            "Donnerstag 01.03.2018",
            "Donnerstag, 1. M\u00e4rz 2018",
            "Donnerstag, den 01. M\u00e4rz 2018",
        ],
    ],
    [
        "Time[]{2016-04-06 08:20 (X/X)}",
        "2016-03-11T11:04",
        ["Mittwoch, 6.4. 8:20", "Mittwoch, 6.4. 8:20", "Mittwoch, 6.4. 8:20"],
    ],
    [
        "Time[]{2016-04-07 15:35 (X/X)}",
        "2016-03-11T11:04",
        ["Donnerstag, 7.4. 15:35", "Donnerstag, 7.4. 15:35", "Donnerstag, 7.4. 15:35"],
    ],
    [
        "Time[]{2017-08-08 14:31 (X/X)}",
        "2017-08-08T08:28",
        ["Dienstag, 8.8. 14:31h", "Dienstag, 8.8. 14:31h", "Dienstag, 8.8. 14:31h"],
    ],
    [
        "Time[]{2017-06-30 X:X (X/X)}",
        "2017-06-23T09:53",
        ["Freitag, 30. Juni 2017", "Freitag, 30. Juni 2017"],
    ],
    [
        "Time[]{2016-11-17 X:X (X/X)}",
        "2016-10-20T14:34",
        ["Donnerstag, 17. November 2016", "Donnerstag, 17. November 2016"],
    ],
    [
        "Time[]{2017-11-13 X:X (X/X)}",
        "2017-10-24T13:35",
        ["Montag, 13.11. 2017", "Montag, 13.11. 2017", "Montag, 13.11. 2017"],
    ],
    [
        "Interval[]{2016-12-13 05:06 (X/X) - 2016-12-13 08:44 (X/X)}",
        "2016-12-08T15:30",
        [
            "Dienstag, 13.12.2016 um  05:06 - 08:44 Uhr",
            "Dienstag, 13.12.2016 um  05:06 - 08:44 Uhr",
            "Dienstag, 13.12.2016 um  05:06 - 08:44 Uhr",
        ],
    ],
    [
        "Time[]{2017-12-15 X:X (X/X)}",
        "2017-11-15T21:11",
        ["Friday, 15th", "am 15.12.2017 gegen 11.00 Uhr"],
    ],
    [
        "Time[]{2018-03-12 X:X (X/X)}",
        "2018-03-02T10:05",
        ["Monday, 12th of March 2018", "Monday, 12th of March 2018"],
    ],
    [
        "Time[]{2018-04-03 X:X (X/afternoon)}",
        "2018-03-22T11:25",
        ["Dienstag, den 3. April 2018 nachmittags"],
    ],
    [
        "Interval[]{2017-10-05 09:00 (X/X) - 2017-10-05 10:00 (X/X)}",
        "2017-09-28T07:55",
        [
            "Donnerstag, den 5.10.2017 09:00 - 10:00 Uhr",
            "Donnerstag, den 5.10.2017 09:00 - 10:00 Uhr",
            "Donnerstag, den 5.10.2017 09:00 - 10:00 Uhr",
        ],
    ],
    [
        "Time[]{2017-10-10 X:X (X/X)}",
        "2017-10-08T16:08",
        ["Dienstag, den 10.", "vom 10.", "Dienstag, den 10."],
    ],
    [
        "Time[]{2017-05-22 16:13 (X/X)}",
        "2017-05-22T12:32",
        ["Morgen, den 22. Mai 2017 16:13"],
    ],
    [
        "Time[]{2017-10-03 X:X (X/X)}",
        "2017-08-28T14:31",
        ["3 Oct 2017", "3. Oktober 2017", "3 Oct 2017", "3. Oktober 2017"],
    ],
    [
        "Time[]{2018-04-06 X:X (X/X)}",
        "2018-01-08T07:52",
        [
            "6 April 2018",
            "06.04.2018 17:40 Uhr",
            "6 April 2018",
            "06.04.2018 17:40 Uhr",
        ],
    ],
    [
        "Interval[]{2017-06-04 X:X (X/X) - 2017-06-06 X:X (X/X)}",
        "2017-05-25T18:08",
        ["4-6.6.", "4-6.6.", "4-6.6."],
    ],
    ["Time[]{2017-07-02 X:X (X/X)}", "2017-06-29T06:15", ["2."]],
    [
        "Time[]{2017-07-04 X:X (X/X)}",
        "2017-06-29T06:15",
        ["4. Juli 2017", "4. Juli 2017"],
    ],
    ["Time[]{2017-08-06 11:05 (X/X)}", "2017-07-26T09:21", ["6. August 11.05"]],
    [
        "Time[]{2016-11-02 X:X (X/X)}",
        "2016-10-04T11:39",
        ["2. November 2016", "2. November 2016"],
    ],
    [
        "Time[]{2016-04-03 X:X (X/X)}",
        "2015-11-02T11:37",
        ["3. April 2016", "3. April 2016"],
    ],
    [
        "Time[]{2016-11-04 X:X (X/X)}",
        "2016-10-04T11:39",
        ["4. November 2016", "4. November 2016"],
    ],
    [
        "Time[]{2017-10-05 X:X (X/X)}",
        "2017-07-17T07:46",
        ["5. Oktober 2017", "5. Oktober 2017"],
    ],
    [
        "Time[]{2018-01-06 X:X (X/X)}",
        "2017-12-19T09:24",
        ["6. Januar 2018", "6. Januar 2018"],
    ],
    [
        "Interval[]{2017-07-03 09:00 (X/X) - 2017-07-03 10:00 (X/X)}",
        "2017-06-26T13:05",
        [
            "3.7.2017 gegen 9-10 Uhr",
            "3.7.2017 gegen 9-10 Uhr",
            "3.7.2017 gegen 9-10 Uhr",
        ],
    ],
    [
        "Time[]{2018-10-07 18:10 (X/X)}",
        "2018-02-07T13:05",
        ["5.03. - 07.10. 18:10", "5.03. - 07.10. 18:10"],
    ],
    [
        "Time[]{2017-07-01 10:00 (X/X)}",
        "2017-06-02T09:41",
        ["1.07.2017 ca. 10Uhr morgens", "1.07.2017 ca. 10Uhr morgens"],
    ],
    ["Time[]{2017-03-17 X:X (X/X)}", "2017-03-03T13:30", ["3/17"]],
    ["Time[]{2017-02-11 X:X (X/X)}", "2017-01-31T10:12", ["11"]],
    ["Time[]{2017-01-14 X:X (X/X)}", "2017-01-05T08:07", ["14"]],
    ["Time[]{2017-11-15 X:X (X/X)}", "2017-11-08T16:14", ["15"]],
    ["Time[]{2016-09-19 X:X (X/X)}", "2016-08-19T11:23", ["19"]],
    ["Time[]{2017-04-20 X:X (X/X)}", "2017-04-18T11:04", ["20"]],
    [
        "Time[]{2017-09-25 X:X (X/X)}",
        "2017-09-10T15:46",
        ["25 SEP 2017,", "25 SEP 2017,"],
    ],
    [
        "Time[]{2016-05-17 X:X (X/X)}",
        "2016-05-10T10:31",
        ["17 May 2016", "17 May 2016"],
    ],
    [
        "Time[]{2018-02-21 X:X (X/X)}",
        "2018-01-17T14:12",
        ["21 Feb 2018", "21 Feb 2018"],
    ],
    [
        "Time[]{2017-10-24 X:X (X/X)}",
        "2017-10-17T18:14",
        ["24 Oct 2017", "24 Oct 2017"],
    ],
    [
        "Time[]{2017-04-24 X:X (X/X)}",
        "2017-03-09T09:35",
        ["24 April 17", "24 April 17"],
    ],
    [
        "Time[]{2018-01-10 X:X (X/X)}",
        "2017-10-03T03:36",
        ["10 January 2018", "10-01-2018", "10 January 2018", "10.01.2018 15:37"],
    ],
    [
        "Time[]{2017-09-10 X:X (X/X)}",
        "2017-07-31T07:05",
        ["10 September 2017", "10 September 2017"],
    ],
    [
        "Time[]{2018-04-11 X:X (X/X)}",
        "2018-01-08T07:52",
        ["11 April 2018", "11 April 2018"],
    ],
    [
        "Time[]{2017-08-14 X:X (X/X)}",
        "2017-07-31T07:05",
        ["14 August 2017", "14 August 2017"],
    ],
    [
        "Time[]{2018-02-15 X:X (X/X)}",
        "2018-01-15T08:26",
        [
            "15 February 2018",
            "am Donnerstag, 15.02.",
            "Do. 15.",
            "15 February 2018",
            "am Donnerstag, 15.02.",
        ],
    ],
    [
        "Time[]{2016-12-21 X:X (X/X)}",
        "2016-12-09T12:58",
        ["21 December 2016", "21 December 2016"],
    ],
    [
        "Time[]{2017-12-22 X:X (X/X)}",
        "2017-10-03T03:36",
        ["22 December 2017", "22 December 2017"],
    ],
    [
        "Time[]{2016-06-16 18:40 (X/X)}",
        "2016-06-16T13:14",
        ["16 june 6:40 pm", "16 june 6:40 pm", "16 june 6:40 pm"],
    ],
    [
        "Interval[]{2017-09-15 15:00 (X/X) - None}",
        "2017-09-07T13:55",
        ["15 after 15:00"],
    ],
    ["Time[]{2017-02-21 X:X (X/X)}", "2017-02-06T08:28", ["21-2-2017"]],
    ["Time[]{2017-02-22 X:X (X/X)}", "2017-02-06T08:28", ["22-2-2017"]],
    ["Time[]{2017-02-23 X:X (X/X)}", "2017-02-06T08:28", ["23-2-2017"]],
    [
        "Interval[]{2018-03-19 X:X (X/X) - 2018-03-20 X:X (X/X)}",
        "2018-03-06T09:46",
        ["19-20"],
    ],
    ["Time[]{2016-05-28 09:00 (X/X)}", "2016-05-26T06:48", ["28-05 09:00"]],
    [
        "Interval[]{2017-11-12 X:X (X/X) - 2017-11-13 X:X (X/X)}",
        "2017-10-03T08:32",
        ["12-13 november"],
    ],
    [
        "Time[]{2016-10-09 X:X (X/X)}",
        "2016-10-07T09:38",
        ["09-10-16", "09-10-16", "09-10-16"],
    ],
    [
        "Time[]{2015-10-25 X:X (X/X)}",
        "2015-10-13T12:11",
        ["15-10-25", "15-10-25", "15-10-25"],
    ],
    [
        "Time[]{2016-04-19 X:X (X/X)}",
        "2016-04-12T14:27",
        ["16-04-19", "16-04-19", "Dienstag 19.4.", "16-04-19"],
    ],
    ["Time[]{2016-05-31 X:X (X/X)}", "2016-05-26T14:38", ["16-05-31", "16-05-31"]],
    ["Time[]{2017-08-04 X:X (X/X)}", "2017-07-24T09:18", ["04-08-2017"]],
    ["Time[]{2016-10-04 X:X (X/X)}", "2016-09-26T13:20", ["04-10-2016"]],
    ["Time[]{2017-11-05 X:X (X/X)}", "2017-10-18T18:45", ["05-11-2017"]],
    [
        "Time[]{2018-05-07 X:X (X/X)}",
        "2018-03-21T13:20",
        ["07-05-2018", "on Monday 7th May", "on Monday 7th May"],
    ],
    ["Time[]{2016-10-07 X:X (X/X)}", "2016-09-26T13:20", ["07-10-2016"]],
    ["Time[]{2016-03-08 X:X (X/X)}", "2016-03-07T08:46", ["08-03-2016"]],
    ["Time[]{2018-05-09 X:X (X/X)}", "2018-03-21T13:20", ["09-05-2018"]],
    ["Time[]{2017-11-09 X:X (X/X)}", "2017-10-18T18:45", ["09-11-2017"]],
    ["Time[]{2016-03-10 X:X (X/X)}", "2016-03-07T08:46", ["10-03-2016"]],
    ["Time[]{2016-12-11 X:X (X/X)}", "2016-12-01T08:24", ["11-12-2016"]],
    [
        "Time[]{2017-12-11 X:X (X/X)}",
        "2017-11-22T13:00",
        ["11-12-2017", "Montag 11.12"],
    ],
    [
        "Time[]{2017-11-12 X:X (X/X)}",
        "2017-10-18T18:45",
        ["12-11-2017", "Sunday 12th November 2017"],
    ],
    ["Time[]{2017-01-13 X:X (X/X)}", "2017-11-30T13:54", ["13-01-2017"]],
    ["Time[]{2017-03-13 X:X (X/X)}", "2017-03-02T13:17", ["13-03-2017"]],
    ["Time[]{2016-06-01 10:16 (X/X)}", "2016-05-25T09:14", ["01-06-2016 10:16"]],
    ["Time[]{2016-06-01 16:00 (X/X)}", "2016-05-25T09:14", ["01-06-2016 16:00"]],
    ["Time[]{2017-11-06 17:00 (X/X)}", "2017-10-23T14:23", ["06-11-2017 17:00"]],
    ["Time[]{2017-11-08 17:55 (X/X)}", "2017-10-23T14:23", ["08-11-2017 17:55"]],
    ["Time[]{2018-03-10 19:30 (X/X)}", "2018-02-15T15:23", ["10-03-2018 19:30"]],
    ["Time[]{2018-03-14 14:35 (X/X)}", "2018-02-15T15:23", ["14-03-2018 14:35"]],
    [
        "Interval[]{2017-09-11 X:X (X/X) - 2017-09-13 X:X (X/X)}",
        "2017-08-21T15:07",
        ["11-13. September"],
    ],
    [
        "Interval[]{2018-04-02 X:X (X/X) - 2018-04-05 X:X (X/X)}",
        "2018-03-18T12:16",
        ["02-05.4", "02-05.4", "02-05.4"],
    ],
    [
        "Interval[]{2018-01-10 X:X (X/X) - 2018-01-11 X:X (X/X)}",
        "2017-12-30T15:14",
        ["10-11.1.", "10-11.1.", "10-11.1."],
    ],
    ["Time[]{2015-12-02 X:X (X/X)}", "2015-11-16T10:37", ["02."]],
    ["Time[]{2017-04-03 X:X (X/X)}", "2017-03-08T14:38", ["03.", "03.04. 2017"]],
    ["Time[]{2017-02-06 X:X (X/X)}", "2017-01-31T19:27", ["06."]],
    ["Time[]{2017-02-08 X:X (X/X)}", "2017-01-16T15:44", ["08."]],
    ["Time[]{2010-11-11 X:X (X/X)}", "2017-08-04T15:22", ["11. Nov 2010"]],
    [
        "Time[]{2017-05-12 X:X (X/X)}",
        "2017-05-03T13:19",
        ["12. Mai 2017", "12. Mai 2017"],
    ],
    ["Time[]{2008-02-15 X:X (X/X)}", "2017-08-04T15:22", ["15. Feb 2008"]],
    [
        "Time[]{2017-05-16 X:X (X/X)}",
        "2017-05-08T14:03",
        ["16. Mai 2017", "16. Mai 2017"],
    ],
    ["Time[]{2014-08-17 X:X (X/X)}", "2017-08-04T15:22", ["17. Aug 2014"]],
    [
        "Time[]{2018-02-26 X:X (X/X)}",
        "2018-01-10T12:02",
        ["26. Feb. 2018", "26. Feb. 2018"],
    ],
    [
        "Time[]{2016-07-13 X:X (X/X)}",
        "2016-06-20T10:03",
        ["13. Juli 16", "13. Juli 16"],
    ],
    [
        "Time[]{2016-07-18 X:X (X/X)}",
        "2016-06-28T09:21",
        ["18. Juli 18:25", "18. Juli 18:25"],
    ],
    [
        "Time[]{2017-06-09 X:X (X/X)}",
        "2017-05-23T05:56",
        ["09. Juni 2017", "09. Juni 2017"],
    ],
    [
        "Time[]{2017-03-10 X:X (X/X)}",
        "2017-01-30T12:26",
        ["10. M\u00e4rz 2017", "10. M\u00e4rz 2017"],
    ],
    [
        "Time[]{2018-03-10 X:X (X/X)}",
        "2017-12-18T07:30",
        ["10. M\u00e4rz 2018", "10. M\u00e4rz 2018"],
    ],
    [
        "Time[]{2017-03-11 X:X (X/X)}",
        "2017-01-30T12:26",
        ["11. M\u00e4rz 2017", "11. M\u00e4rz 2017"],
    ],
    [
        "Time[]{2018-06-12 X:X (X/X)}",
        "2018-03-22T10:04",
        ["12. Juni 2018", "12. Juni 2018"],
    ],
    [
        "Time[]{2017-06-14 X:X (X/X)}",
        "2017-06-02T07:23",
        ["14. Juni 2017", "14. Juni 2017"],
    ],
    [
        "Time[]{2018-03-10 14:30 (X/X)}",
        "2018-03-05T11:52",
        ["10. March Saturday 14:30"],
    ],
    [
        "Time[]{2018-04-09 X:X (X/X)}",
        "2018-03-13T11:59",
        ["09. April 2018", "09. April 2018"],
    ],
    [
        "Time[]{2016-12-09 X:X (X/X)}",
        "2016-11-14T12:23",
        ["09. Dezember 2016", "09. Dezember 2016"],
    ],
    [
        "Time[]{2016-11-12 X:X (X/X)}",
        "2016-04-07T07:45",
        ["12. November 2016", "12. November 2016"],
    ],
    [
        "Time[]{2017-10-12 X:X (X/X)}",
        "2017-10-05T16:59",
        [
            "12. Oktober 2017",
            "Donnerstag 12.10.2017",
            "Thursday (12.)",
            "12. Oktober 2017",
        ],
    ],
    [
        "Time[]{2017-09-12 X:X (X/X)}",
        "2017-08-11T07:25",
        [
            "12. September 2017",
            "am Dienstag, 12.9.",
            "12. September 2017",
            "am Dienstag, 12.9.",
        ],
    ],
    [
        "Time[]{2018-04-13 X:X (X/X)}",
        "2018-03-16T12:34",
        ["13. April 2018", "13. April 2018"],
    ],
    [
        "Time[]{2018-02-13 X:X (X/X)}",
        "2017-12-19T09:24",
        ["13. Februar 2018", "13. Februar 2018"],
    ],
    [
        "Time[]{2018-04-14 X:X (X/X)}",
        "2018-04-08T17:07",
        ["14. April 2018", "14. April 2018"],
    ],
    [
        "Time[]{2018-03-13 X:X (X/X)}",
        "2018-03-12T16:48",
        ["13. 03.", "13. 03.", "13. 03."],
    ],
    [
        "Interval[]{2017-07-11 X:X (X/X) - 2017-07-12 X:X (X/X)}",
        "2017-06-28T15:41",
        ["11. auf 12."],
    ],
    [
        "Time[]{2018-03-03 X:X (X/evening)}",
        "2018-02-02T15:44",
        ["23.-02.-03.03. abends"],
    ],
    [
        "Time[]{2017-01-16 X:X (X/X)}",
        "2017-01-13T07:58",
        ["16.Januar 2017", "am Montag 16.01.17", "16.Januar 2017"],
    ],
    [
        "Time[]{2016-05-19 X:X (X/X)}",
        "2016-04-12T12:42",
        ["19.5 08:05", "19.5 08:05", "19.5 08:05"],
    ],
    ["Time[]{2017-01-16 08:10 (X/X)}", "2016-11-18T06:43", ["16.1 um 8.10"]],
    [
        "Time[]{2018-03-15 16:01 (X/X)}",
        "2018-02-28T10:19",
        ["12.03 - 15.03. 16:01", "12.03 - 15.03. 16:01"],
    ],
    [
        "Time[]{2017-10-21 X:X (X/X)}",
        "2017-10-10T12:06",
        ["21.10 Samstag", "21.10 Samstag", "21.10 Samstag"],
    ],
    ["Time[]{2016-11-21 08:10 (X/X)}", "2016-09-19T08:44", ["21.11 8.10"]],
    ["Time[]{2016-11-14 08:10 (X/X)}", "2016-08-31T13:16", ["14.11 um 8.10"]],
    [
        "Interval[]{2017-11-24 11:00 (X/X) - 2017-11-24 13:00 (X/X)}",
        "2017-11-17T09:47",
        ["24.11 ca. 11-13 Uhr"],
    ],
    [
        "Interval[]{2017-05-04 X:X (X/X) - 2017-05-05 X:X (X/X)}",
        "2017-04-28T15:09",
        ["04.05 bis 05.05"],
    ],
    [
        "Interval[]{2017-10-04 X:X (X/X) - 2017-10-06 X:X (X/X)}",
        "2017-09-29T14:29",
        ["04.10 bis 06.10"],
    ],
    [
        "Interval[]{2016-11-09 X:X (X/X) - 2016-11-10 X:X (X/X)}",
        "2016-11-08T20:42",
        ["09.11 bis 10.11", "vom 09.11 bis 10.11"],
    ],
    [
        "Interval[]{2017-10-12 X:X (X/X) - 2017-10-13 X:X (X/X)}",
        "2017-08-18T06:05",
        ["12.10 bis 13.10"],
    ],
    [
        "Interval[]{2018-03-13 X:X (X/X) - 2018-03-16 X:X (X/X)}",
        "2018-03-05T12:12",
        ["13.03 bis 16.03"],
    ],
    [
        "Time[]{2017-06-13 X:X (X/X)}",
        "2017-05-19T13:40",
        ["13.06 morning", "the 13.", "13.06 morning", "13.06 morning"],
    ],
    [
        "Time[]{2016-03-03 17:00 (X/X)}",
        "2016-02-05T08:25",
        ["03.03 nachmittags ca. 5 Uhr"],
    ],
    [
        "Time[]{2017-01-31 X:X (X/X)}",
        "2017-01-23T18:56",
        ["31.01. Tuesday", "31.01. Tuesday", "31.01. Tuesday"],
    ],
    ["Time[]{2017-09-20 22:10 (X/X)}", "2017-09-13T08:14", ["20.09. 22.10"]],
    [
        "Time[]{2017-09-15 X:X (X/X)}",
        "2017-09-07T10:19",
        ["15.09. 14:21 Uhr", "15.09. 14:21 Uhr", "15.09. 14:21 Uhr"],
    ],
    [
        "Interval[]{2017-07-05 08:00 (X/X) - None}",
        "2017-06-13T12:03",
        ["05.07. 2017 ab 08:00 Uhr"],
    ],
    [
        "Interval[]{2018-01-20 07:38 (X/X) - 2018-01-20 10:52 (X/X)}",
        "2018-01-15T14:40",
        ["20.01. um 7:38 - 10:52"],
    ],
    [
        "Interval[]{2017-06-12 13:15 (X/X) - 2017-06-12 14:15 (X/X)}",
        "2017-06-08T08:12",
        ["12.06. um 13.15-14:15"],
    ],
    [
        "Time[]{2016-11-03 08:15 (X/X)}",
        "2016-11-02T09:46",
        ["03.11. ab 08:15 Uhr", "03.11. ab 08:15 Uhr"],
    ],
    [
        "Interval[]{2017-06-13 21:55 (X/X) - 2017-06-13 22:45 (X/X)}",
        "2017-06-08T08:12",
        ["13.06. um 21:55-22:45"],
    ],
    [
        "Interval[]{2018-01-02 X:X (X/X) - 2018-01-05 X:X (X/X)}",
        "2017-12-14T08:14",
        ["02.01.-05.01.2018 3 \u00dcN", "02.01.-05.01.2018 3 \u00dcN"],
    ],
    [
        "Interval[]{2017-09-14 18:00 (X/X) - 2017-09-14 20:00 (X/X)}",
        "2017-08-11T11:31",
        ["12.09.17 - 14.09.17 18:00 - 20:00"],
    ],
    [
        "Interval[]{2017-02-10 11:49 (X/X) - None}",
        "2017-02-09T16:00",
        ["10.02.17 ab 11:49", "10.02.17 ab 11:49"],
    ],
    [
        "Interval[]{2017-02-15 08:35 (X/X) - None}",
        "2017-02-14T13:20",
        ["15.02.17 ab 08:35"],
    ],
    [
        "Interval[]{2017-12-07 12:50 (X/X) - 2017-12-07 14:10 (X/X)}",
        "2017-11-20T13:30",
        [
            "07.12.17 um 12:50 - 14:10 Uhr",
            "07.12.17 um 12:50 - 14:10 Uhr",
            "07.12.17 um 12:50 - 14:10 Uhr",
        ],
    ],
    [
        "Time[]{2017-06-01 X:X (X/X)}",
        "2017-03-13T08:29",
        [
            "01.06.2017 19:35",
            "am 01. Juni 2017",
            "01.06.2017 19:35",
            "01.06.2017 19:35",
            "am 01. Juni 2017",
        ],
    ],
    [
        "Time[]{2017-10-02 X:X (X/X)}",
        "2017-08-25T05:49",
        ["02.10.2017 10:30", "02.10.2017 10:30", "02.10.2017 10:30"],
    ],
    [
        "Time[]{2018-03-06 X:X (X/X)}",
        "2018-02-26T13:53",
        [
            "06.03.2018 06:30 Uhr",
            "06.03.2018 18:55 Uhr",
            "6th March 2018",
            "06.03.2018 06:30 Uhr",
            "06.03.2018 18:55 Uhr",
            "6th March 2018",
            "06.03.2018 06:30 Uhr",
            "06.03.2018 18:55 Uhr",
            "6th March 2018",
        ],
    ],
    [
        "Interval[]{2017-03-13 16:48 (X/X) - 2017-03-13 20:08 (X/X)}",
        "2017-03-07T09:47",
        [
            "13.03.2017 um 16:48 - 20:08",
            "13.03.2017 um 16:48 - 20:08",
            "13.03.2017 um 16:48 - 20:08",
        ],
    ],
    [
        "Interval[]{2017-04-07 09:00 (X/X) - 2017-04-07 10:00 (X/X)}",
        "2017-03-20T18:46",
        [
            "07.04.2017 ca. 9-10 Uhr",
            "07.04.2017 ca. 9-10 Uhr",
            "07.04.2017 ca. 9-10 Uhr",
        ],
    ],
    [
        "Interval[]{2017-04-03 10:00 (X/X) - 2017-04-03 11:00 (X/X)}",
        "2017-03-20T18:46",
        [
            "03.04.2017 ca. 10 - 11 Uhr",
            "03.04.2017 ca. 10 - 11 Uhr",
            "03.04.2017 ca. 10 - 11 Uhr",
        ],
    ],
    [
        "Interval[]{2018-03-05 10:00 (X/X) - 2018-03-05 11:00 (X/X)}",
        "2018-02-20T09:37",
        [
            "05.03.2018 ca. 10-11 Uhr",
            "05.03.2018 ca. 10-11 Uhr",
            "05.03.2018 ca. 10-11 Uhr",
        ],
    ],
    [
        "Time[]{2017-06-23 10:00 (X/X)}",
        "2017-06-02T09:41",
        ["23.06.2017 ca. 10Uhr morgens", "23.06.2017 ca. 10Uhr morgens"],
    ],
    [
        "Interval[]{2018-02-20 X:X (X/X) - 2018-02-21 X:X (X/X)}",
        "2018-02-16T08:59",
        ["20.02.2018 bis 21.02.20178"],
    ],
    [
        "Interval[]{2017-05-10 18:00 (X/X) - 2017-05-10 20:00 (X/X)}",
        "2017-05-04T19:05",
        [
            "10.05.2017 gegen 18-20 Uhr",
            "10.05.2017 gegen 18-20 Uhr",
            "10.05.2017 gegen 18-20 Uhr",
        ],
    ],
    [
        "Interval[]{2017-11-13 10:00 (X/X) - 2017-11-13 11:00 (X/X)}",
        "2017-10-25T09:25",
        ["13.11.2017 gegen 10-11 Uhr", "13.11.2017 gegen 10-11 Uhr"],
    ],
    [
        "Interval[]{2017-04-24 09:30 (X/X) - 2017-04-24 10:00 (X/X)}",
        "2017-04-13T12:41",
        [
            "24.04.2017 gegen 09:30 - 10:00 Uhr",
            "24.04.2017 gegen 09:30 - 10:00 Uhr",
            "24.04.2017 gegen 09:30 - 10:00 Uhr",
        ],
    ],
    [
        "Time[]{2018-03-02 14:00 (X/X)}",
        "2018-02-23T15:38",
        [
            "02.03.2018 gegen 14:00 Uhr nachmittags",
            "02.03.2018 gegen 14:00 Uhr nachmittags",
        ],
    ],
    [
        "Time[]{2017-07-18 X:X (X/evening)}",
        "2017-07-11T09:03",
        ["18/07 sp\u00e4t abends", "18/07 sp\u00e4t abends", "18/07 sp\u00e4t abends"],
    ],
    [
        "Time[]{2016-12-12 01:40 (X/X)}",
        "2016-12-09T18:07",
        [
            "01:40 Mon, 12 Dec 2016Journey",
            "01:40 Mon, 12 Dec 2016Journey",
            "01:40 Mon, 12 Dec 2016Journey",
        ],
    ],
    [
        "Time[]{2017-11-20 08:25 (X/X)}",
        "2017-11-14T08:41",
        [
            "08:25 Monday, 20 November 2017",
            "08:25 Monday, 20 November 2017",
            "08:25 Monday, 20 November 2017",
        ],
    ],
    ["Time[]{2017-08-02 15:42 (X/X)}", "2017-07-31T09:05", ["15:42 diesen Mittwoch"]],
    [
        "Time[]{2017-03-15 19:20 (X/X)}",
        "2017-03-15T10:46",
        ["15Mar 19:20", "15Mar 19:20", "15Mar 19:20"],
    ],
    ["Time[]{2017-08-10 X:X (X/X)}", "2017-08-09T14:45", ["10Aug17", "10Aug17"]],
    ["Time[]{2016-11-28 X:X (X/X)}", "2016-11-18T12:56", ["28Nov2016", "28Nov2016"]],
    ["Time[]{2017-09-18 X:X (X/X)}", "2017-09-07T08:03", ["2017-09-18", "2017-09-18"]],
    ["Time[]{2017-09-20 X:X (X/X)}", "2017-09-07T08:03", ["2017-09-20", "2017-09-20"]],
    [
        "Time[]{2016-10-30 X:X (X/X)}",
        "2016-10-05T13:20",
        ["2016-10-30 12:05", "2016-10-30 12:05", "2016-10-30 12:05"],
    ],
    ["Time[]{2016-12-16 19:55 (X/X)}", "2016-11-23T16:05", ["2016-12-16 19:55"]],
    ["Time[]{2016-12-16 22:55 (X/X)}", "2016-11-23T16:05", ["2016-12-16 22:55"]],
    ["Time[]{2016-12-17 01:25 (X/X)}", "2016-11-23T18:55", ["2016-12-17 01:25"]],
    ["Time[]{2016-12-17 02:55 (X/X)}", "2016-11-23T16:05", ["2016-12-17 02:55"]],
    ["Time[]{2016-12-17 05:50 (X/X)}", "2016-11-23T18:55", ["2016-12-17 05:50"]],
    ["Time[]{2016-12-17 07:00 (X/X)}", "2016-11-23T18:55", ["2016-12-17 07:00"]],
    ["Time[]{2016-12-17 07:20 (X/X)}", "2016-11-23T16:05", ["2016-12-17 07:20"]],
    ["Time[]{2016-12-17 08:15 (X/X)}", "2016-11-23T18:55", ["2016-12-17 08:15"]],
    ["Time[]{2016-12-17 12:00 (X/X)}", "2016-11-23T16:05", ["2016-12-17 12:00"]],
    ["Time[]{2016-12-17 13:05 (X/X)}", "2016-11-23T16:05", ["2016-12-17 13:05"]],
    [
        "Time[]{2016-05-16 X:X (X/X)}",
        "2016-03-04T16:16",
        ["16th May 2016", "16th May 2016", "16th May 2016"],
    ],
    [
        "Time[]{2017-09-05 X:X (X/X)}",
        "2017-06-27T10:47",
        ["05th September 2017", "05th September 2017"],
    ],
    [
        "Time[]{2018-04-07 X:X (X/X)}",
        "2018-03-05T14:43",
        ["07th April 2018", "07th April 2018", "07th April 2018"],
    ],
    [
        "Time[]{2018-02-10 X:X (X/X)}",
        "2018-01-29T03:05",
        ["10th February 2018", "10th February 2018"],
    ],
    [
        "Time[]{2018-03-11 X:X (X/X)}",
        "2017-11-10T12:37",
        ["11th March 2018", "11th March 2018"],
    ],
    [
        "Time[]{2016-11-24 12:50 (X/X)}",
        "2016-11-16T16:38",
        ["24th 12:50", "24th 12:50"],
    ],
    [
        "Time[]{2016-12-24 X:X (X/X)}",
        "2016-12-11T21:39",
        ["24th 25th December", "24th 25th December", "24th 25th December"],
    ],
    [
        "Time[]{2017-05-10 X:X (X/X)}",
        "2017-05-08T15:39",
        ["10th of May 2017", "10th of May 2017", "10th of May 2017"],
    ],
    [
        "Time[]{2018-01-12 X:X (X/X)}",
        "2017-10-25T07:59",
        ["am Fr. 12. Januar 2018", "am Fr. 12. Januar 2018"],
    ],
    [
        "Time[]{2018-03-30 X:X (X/evening)}",
        "2018-03-11T21:48",
        ["am Donnerstag Abend 30.3"],
    ],
    [
        "Time[]{2018-05-25 18:45 (X/X)}",
        "2018-04-11T10:04",
        [
            "on Friday 25 may at 18:45 in the evening",
            "on Friday 25 may at 18:45 in the evening",
        ],
    ],
    [
        "Time[]{2018-02-23 X:X (X/X)}",
        "2018-01-05T16:44",
        ["on Friday 23rd", "ab Freitag 23.02.2018", "on Friday 23/2/2018"],
    ],
    ["Time[]{2018-01-18 X:X (X/X)}", "2018-01-16T15:09", ["am Donnerstag den 18."]],
    [
        "Time[]{2017-11-08 X:X (X/X)}",
        "2017-09-05T08:17",
        ["am Mittwoch, den 08. November 2017", "am Mittwoch, den 08. November 2017"],
    ],
    ["Time[]{2017-05-03 X:X (X/X)}", "2017-04-24T12:02", ["am 3."]],
    ["Time[]{2017-07-15 X:X (X/X)}", "2017-06-21T11:02", ["am 15"]],
    ["Time[]{2017-08-07 X:X (X/X)}", "2017-08-04T14:25", ["am 07."]],
    ["Time[]{2016-11-13 X:X (X/X)}", "2016-10-18T07:23", ["am 13."]],
    [
        "Time[]{2016-06-13 X:X (X/X)}",
        "2016-03-21T11:20",
        ["am 13. Juni 2016", "am 13. Juni 2016"],
    ],
    [
        "Time[]{2018-03-12 X:X (X/morning)}",
        "2018-03-02T11:56",
        ["am 12. M\u00e4rz 2018 morgens"],
    ],
    [
        "Time[]{2018-06-13 X:X (X/morning)}",
        "2018-03-26T10:02",
        ["am 13. Juni 2018 morgens"],
    ],
    [
        "Time[]{2016-11-16 09:50 (X/X)}",
        "2016-11-03T10:07",
        ["am 16. November 2016 09:50 Uhr"],
    ],
    [
        "Time[]{2017-10-04 X:X (X/evening)}",
        "2017-09-25T14:37",
        ["am 04. Oktober 2017 abends"],
    ],
    [
        "Interval[]{None - 2017-11-20 10:30 (X/X)}",
        "2017-11-07T14:16",
        ["am 20. November 2017 sp\u00e4testens 10:30 Uhr"],
    ],
    ["Time[]{2018-04-11 X:X (X/morning)}", "2018-03-27T12:23", ["am 11. morgens"]],
    ["Time[]{2018-02-14 X:X (X/morning)}", "2018-01-17T11:48", ["am 14. morgens"]],
    [
        "Time[]{2017-11-14 X:X (X/X)}",
        "2017-09-07T12:57",
        ["am 14.November 2017", "am 14.November 2017"],
    ],
    [
        "Time[]{2017-01-20 X:X (X/morning)}",
        "2016-11-15T10:25",
        ["am 20.Januar 2017 morgens"],
    ],
    [
        "Time[]{2016-08-15 X:X (X/afternoon)}",
        "2016-06-23T11:34",
        ["am 15.8. am Nachmittag"],
    ],
    ["Time[]{2018-04-15 X:X (X/evening)}", "2018-03-14T15:40", ["am 15.04 am Abend"]],
    [
        "Time[]{2018-04-11 X:X (X/lateafternoon)}",
        "2018-03-16T11:54",
        ["am 11.04 sp\u00e4tnachmittags"],
    ],
    [
        "Time[]{2017-12-15 X:X (X/lateevening)}",
        "2017-12-08T10:34",
        ["am 15.12 sp\u00e4t abends"],
    ],
    [
        "Time[]{2018-03-16 X:X (X/afternoon)}",
        "2018-03-08T04:32",
        ["am 16.03. am Nachmittag"],
    ],
    [
        "Time[]{2017-12-17 X:X (X/afternoon)}",
        "2017-12-12T06:45",
        ["am 17.12. am Nachmittag"],
    ],
    ["Time[]{2018-01-25 X:X (X/evening)}", "2018-01-16T17:07", ["am 25.01. am Abend"]],
    [
        "Time[]{2018-01-02 X:X (X/afternoon)}",
        "2017-12-18T08:47",
        ["am 02.01. am nachmittag"],
    ],
    [
        "Interval[]{2017-08-28 08:15 (X/X) - 2017-08-28 09:20 (X/X)}",
        "2017-08-22T12:26",
        ["am 28.08.17 08.15 - 09.20", "am 28.08.17 08.15 - 09.20"],
    ],
    [
        "Interval[]{2018-03-02 14:30 (X/X) - 2018-03-02 16:00 (X/X)}",
        "2018-02-16T17:50",
        ["am 02.03.18 14.30 - 16.00 Uhr", "am 02.03.18 14.30 - 16.00 Uhr"],
    ],
    [
        "Interval[]{2018-05-04 17:35 (X/X) - 2018-05-04 18:30 (X/X)}",
        "2018-03-26T08:13",
        ["am 04.05.18 17.35 - 18.30 Uhr", "am 04.05.18 17.35 - 18.30 Uhr"],
    ],
    [
        "Interval[]{2017-12-21 15:30 (X/X) - 2017-12-21 16:40 (X/X)}",
        "2017-11-22T12:23",
        ["am 21.12.17 15:30 - 16:40", "am 21.12.17 15:30 - 16:40"],
    ],
    [
        "Interval[]{2018-03-14 17:45 (X/X) - 2018-03-14 19:10 (X/X)}",
        "2018-03-01T12:42",
        ["am 14.03.18 17:45 -- 19:10 Uhr", "am 14.03.18 17:45 -- 19:10 Uhr"],
    ],
    [
        "Interval[]{2017-11-02 15:00 (X/X) - 2017-11-02 18:00 (X/X)}",
        "2017-10-17T08:57",
        ["am 02.11.2017 15-18 Uhr", "am 02.11.2017 15-18 Uhr"],
    ],
    [
        "Interval[]{2018-04-04 07:10 (X/X) - 2018-04-04 08:20 (X/X)}",
        "2018-03-29T11:39",
        ["am 04.04.2018 07:10 - 08:20", "am 04.04.2018 07:10 - 08:20"],
    ],
    [
        "Interval[]{2018-02-06 07:10 (X/X) - 2018-02-06 08:40 (X/X)}",
        "2017-12-22T09:56",
        ["am 06.02.2018 07:10 - 08:40", "am 06.02.2018 07:10 - 08:40"],
    ],
    [
        "Interval[]{2018-02-06 19:50 (X/X) - 2018-02-06 21:15 (X/X)}",
        "2017-12-22T09:56",
        ["am 06.02.2018 19:50 - 21:15", "am 06.02.2018 19:50 - 21:15"],
    ],
    [
        "Interval[]{2018-03-07 16:03 (X/X) - 2018-03-07 20:07 (X/X)}",
        "2018-02-19T09:03",
        ["am 07.03.2018 16:03 - 20:07", "am 07.03.2018 16:03 - 20:07"],
    ],
    [
        "Interval[]{2017-06-12 06:50 (X/X) - 2017-06-12 08:00 (X/X)}",
        "2017-06-08T11:07",
        ["am 12.06.2017 06:50 - 08:00", "am 12.06.2017 06:50 - 08:00"],
    ],
    [
        "Interval[]{2017-11-16 18:05 (X/X) - 2017-11-16 19:35 (X/X)}",
        "2017-11-09T11:59",
        ["am 16.11.2017 18:05 - 19:35 Uhr", "am 16.11.2017 18:05 - 19:35 Uhr"],
    ],
    [
        "Interval[]{2017-07-17 07:00 (X/X) - 2017-07-17 09:00 (X/X)}",
        "2017-07-11T11:53",
        ["am 17.07.2017 07:00-09:00 Uhr", "am 17.07.2017 07:00-09:00 Uhr"],
    ],
    [
        "Time[]{2018-06-07 07:00 (X/X)}",
        "2018-03-05T13:15",
        ["am 07.06.2018 um 07.00 Uhr morgens"],
    ],
    [
        "Interval[]{2017-06-15 08:00 (X/X) - None}",
        "2017-06-14T15:35",
        ["ab 08:00 Uhr", "ab 08:00 Uhr", "ab 08:00 Uhr"],
    ],
    [
        "Interval[]{2017-07-20 18:00 (X/X) - None}",
        "2017-06-23T08:54",
        ["ab 18:00 Uhr 20.07.2017"],
    ],
    [
        "Interval[]{2016-11-28 08:00 (X/X) - None}",
        "2016-11-14T13:36",
        ["ab 08:00 Uhr am 28.11.2016"],
    ],
    [
        "Interval[]{2016-12-16 16:00 (X/X) - None}",
        "2016-12-16T08:09",
        ["ab 16Uhr", "ab 16Uhr", "ab 16Uhr"],
    ],
    [
        "Interval[]{2017-02-10 14:00 (X/X) - None}",
        "2017-01-29T14:13",
        ["ab 14h am 10.02.2017"],
    ],
    [
        "Time[]{2018-03-22 X:X (X/X)}",
        "2018-03-15T11:38",
        ["on the 22.", "Donnerstag 22.3."],
    ],
    [
        "Time[]{2017-01-24 X:X (X/evening)}",
        "2017-01-24T13:24",
        ["ab heute Abend", "ab heute Abend", "ab heute Abend"],
    ],
    [
        "Interval[]{2018-01-15 X:X (X/X) - 2018-01-16 X:X (X/X)}",
        "2017-12-11T15:35",
        [
            "von Montag bis Dienstag (15.01.-16.01",
            "von Montag bis Dienstag (15.01.-16.01",
        ],
    ],
    [
        "Interval[]{2017-11-08 X:X (X/X) - 2017-11-10 X:X (X/X)}",
        "2017-10-12T07:20",
        ["vom 8.11 bis 10.11"],
    ],
    ["Time[]{2017-06-12 X:X (X/X)}", "2017-06-08T08:38", ["the 12."]],
    ["Time[]{2017-03-09 X:X (X/X)}", "2017-03-07T07:36", ["vom 09."]],
    [
        "Time[]{2018-04-20 X:X (X/noon)}",
        "2018-04-05T08:59",
        ["vom 16. - 20. April Mittags", "vom 16. - 20. April Mittags"],
    ],
    [
        "Interval[]{2017-09-04 X:X (X/X) - 2017-09-06 X:X (X/X)}",
        "2017-08-24T12:11",
        ["vom 04.09 bis 06.09"],
    ],
    [
        "Interval[]{2018-02-07 X:X (X/X) - 2018-02-08 X:X (X/X)}",
        "2018-01-11T16:34",
        ["vom 07.02 bis 08.02"],
    ],
    [
        "Interval[]{2017-05-12 X:X (X/X) - 2017-05-13 X:X (X/X)}",
        "2017-04-13T10:10",
        ["vom 12.05 bis 13.05"],
    ],
    [
        "Interval[]{2017-08-14 X:X (X/X) - 2017-08-16 X:X (X/X)}",
        "2017-07-21T08:09",
        ["vom 14.08 bis 16.08"],
    ],
    [
        "Interval[]{2017-03-15 X:X (X/X) - 2017-03-16 X:X (X/X)}",
        "2017-03-14T08:54",
        ["vom 15.03 bis 16.03"],
    ],
    [
        "Interval[]{2017-01-16 X:X (X/X) - 2017-01-19 X:X (X/X)}",
        "2017-01-10T08:23",
        ["vom 16.01 bis 19.01"],
    ],
    [
        "Interval[]{2018-02-18 X:X (X/X) - 2018-02-23 X:X (X/X)}",
        "2018-02-12T13:36",
        ["vom 18.02 bis 23.02"],
    ],
    [
        "Time[]{2018-01-04 21:00 (X/X)}",
        "2017-12-18T15:50",
        ["vom 02.01. - 04.01. um 21:00 Uhr", "vom 02.01. - 04.01. um 21:00 Uhr"],
    ],
    [
        "Interval[]{2017-06-07 X:X (X/X) - 2017-06-08 X:X (X/X)}",
        "2017-06-06T10:56",
        ["f\u00fcr 07.06. bis 08.06"],
    ],
    [
        "Interval[]{2017-11-02 X:X (X/X) - 2017-11-03 X:X (X/X)}",
        "2017-10-16T13:21",
        ["vom 02.11. bis 03.11"],
    ],
    [
        "Interval[]{2017-02-07 X:X (X/X) - 2017-02-10 X:X (X/X)}",
        "2017-02-03T09:16",
        ["vom 07.02. bis 10.02"],
    ],
    [
        "Interval[]{2017-01-09 X:X (X/X) - 2017-01-10 X:X (X/X)}",
        "2017-01-04T08:44",
        ["vom 09.01. bis 10.01"],
    ],
    [
        "Interval[]{2017-07-10 X:X (X/X) - 2017-07-12 X:X (X/X)}",
        "2017-06-20T11:06",
        ["vom 10.07. bis 12.07"],
    ],
    [
        "Time[]{2017-07-06 16:00 (X/X)}",
        "2017-07-06T06:10",
        ["bis 06.07., 16:00 Uhr", "bis 06.07., 16:00 Uhr", "bis 06.07., 16:00 Uhr"],
    ],
    [
        "Interval[]{None - 2016-10-04 08:30 (X/X)}",
        "2016-09-07T14:13",
        ["vor 08:30 Uhr am 04.10."],
    ],
    [
        "Time[]{2017-07-05 X:X (X/morning)}",
        "2017-07-04T15:51",
        ["morgen Mittwoch", "morgen Mittwoch"],
    ],
    [
        "Time[]{2017-08-02 06:30 (X/X)}",
        "2017-07-25T15:21",
        ["kommenden Mittwoch den 02.August 2017 06:30"],
    ],
    ["Time[]{2017-10-26 X:X (X/first)}", "2017-10-25T12:42", ["earliest 26.10"]],
    [
        "Interval[]{2017-02-06 X:X (X/X) - 2017-02-07 X:X (X/X)}",
        "2017-02-06T13:13",
        [
            "heute 06.02 bis morgen 7.02",
            "heute 06.02 bis morgen 7.02",
            "heute 06.02 bis morgen 7.02",
        ],
    ],
    [
        "Interval[]{None - 2017-12-15 X:X (X/afternoon)}",
        "2017-12-14T20:43",
        ["tomorrow 15.12 before afternoon"],
    ],
    [
        "Time[]{2016-11-21 X:X (X/X)}",
        "2016-11-21T16:18",
        ["heute 21.11.", "heute 21.11.", "heute 21.11."],
    ],
    [
        "Interval[]{2016-10-05 18:00 (X/X) - None}",
        "2016-09-07T14:13",
        [
            "nach 18:00 Uhr am 05.10.",
            "nach 18:00 Uhr am 05.10.",
            "nach 18:00 Uhr am 05.10.",
        ],
    ],
    [
        "Interval[]{2018-02-07 15:00 (X/X) - None}",
        "2018-01-30T12:32",
        ["nach 15:00 Uhr am 07.02.2018"],
    ],
    [
        "Interval[]{2016-09-17 16:00 (X/X) - None}",
        "2016-09-17T08:01",
        ["after 4pm", "after 4pm", "after 4pm"],
    ],
    [
        "Interval[]{2017-11-22 19:00 (X/X) - None}",
        "2017-11-22T07:12",
        ["abends ab 19:00", "abends ab 19:00", "abends ab 19:00"],
    ],
    ["Time[]{2016-09-09 X:X (X/morning)}", "2016-09-08T11:04", ["morgen frueh"]],
    [
        "Interval[]{2017-11-02 14:00 (X/X) - 2017-11-02 16:00 (X/X)}",
        "2017-11-02T07:03",
        [
            "heute zwischen 14 und 16 Uhr",
            "heute zwischen 14 und 16 Uhr",
            "heute zwischen 14 und 16 Uhr",
        ],
    ],
    [
        "Time[]{2018-03-06 X:X (X/morning)}",
        "2018-03-01T15:21",
        ["dienstag fr\u00fch morgens"],
    ],
    [
        "Interval[]{2017-11-14 07:30 (X/X) - 2017-11-14 12:52 (X/X)}",
        "2017-11-13T09:59",
        ["morgen, den 14.11.2017 07:30 - 12:52 Uhr"],
    ],
    [
        "Time[]{2017-11-06 X:X (X/X)}",
        "2017-11-03T07:20",
        [
            "KW 45 bis KW 51 von montags bis freitags 06.11.2017",
            "on Monday - 06.11.2017",
            "KW 45 bis KW 51 von montags bis freitags 06.11.2017",
            "November 6, 2017",
            "Montag 06.11",
            "on Monday - 06.11.2017",
        ],
    ],
    ["Time[]{2017-07-07 X:X (X/X)}", "2017-05-31T08:47", ["Am Freitag 07.07.2017"]],
    [
        "Time[]{2017-06-29 X:X (X/X)}",
        "2017-06-19T12:47",
        ["Am Donnerstag, den 29.06.", "Am Donnerstag, den 29.06."],
    ],
    [
        "Interval[]{2017-06-26 07:50 (X/X) - 2017-06-26 10:00 (X/X)}",
        "2017-06-20T11:10",
        ["Mon 26th June 07:50-10:00"],
    ],
    [
        "Time[]{2016-11-17 13:51 (X/X)}",
        "2016-11-14T08:48",
        ["Donnerstag Nachmittag 13:51"],
    ],
    [
        "Time[]{2017-12-21 07:00 (X/X)}",
        "2017-12-18T10:37",
        [
            "Diesen Donnerstag, 21.12. gegen 07:00",
            "Diesen Donnerstag, 21.12. gegen 07:00",
        ],
    ],
    ["Time[]{2017-11-02 17:50 (X/X)}", "2017-10-29T18:23", ["Thurs 2 Nov 1750"]],
    ["Time[]{2017-10-06 14:00 (X/X)}", "2017-09-29T13:47", ["Freitag 14 Uhr"]],
    ["Time[]{2017-10-12 10:45 (X/X)}", "2017-10-09T09:05", ["Donnerstag 10.45 Uhr"]],
    [
        "Time[]{2017-09-07 X:X (X/X)}",
        "2017-05-23T12:46",
        ["Donnerstag 07.09.17", "am Donnerstag, 7.9.2017", "am Donnerstag, 07.09.17"],
    ],
    ["Time[]{2016-12-15 X:X (X/X)}", "2016-11-29T08:43", ["Donnerstag 15.12.16"]],
    ["Time[]{2017-08-24 X:X (X/X)}", "2017-08-16T07:10", ["Donnerstag 24.08.17"]],
    ["Time[]{2017-04-07 X:X (X/X)}", "2017-03-06T13:32", ["Freitag 07.04.17"]],
    ["Time[]{2017-11-03 X:X (X/X)}", "2017-11-01T07:20", ["Donnerstag 03.11.2017"]],
    ["Time[]{2017-04-06 X:X (X/X)}", "2017-03-09T14:13", ["Donnerstag 06.04.2017"]],
    ["Time[]{2018-06-07 X:X (X/X)}", "2017-11-16T09:29", ["Donnerstag 07.06.2018"]],
    ["Time[]{2018-02-08 X:X (X/X)}", "2017-11-16T09:29", ["Donnerstag 08.02.2018"]],
    [
        "Time[]{2018-03-08 X:X (X/X)}",
        "2017-11-16T09:29",
        ["Donnerstag 08.03.2018", "am Donnerstag, 08.03.2018"],
    ],
    ["Time[]{2018-01-11 X:X (X/X)}", "2017-11-16T09:29", ["Donnerstag 11.01.2018"]],
    [
        "Time[]{2018-04-12 X:X (X/X)}",
        "2017-11-16T09:29",
        ["Donnerstag 12.04.2018", "Donnerstag 12.04."],
    ],
    ["Time[]{2017-07-03 06:48 (X/X)}", "2017-06-30T13:27", ["Montag 06.48h"]],
    ["Time[]{2016-04-14 14:50 (X/X)}", "2016-04-12T16:36", ["Donnerstag 14:50"]],
    ["Time[]{2017-05-12 11:30 (X/X)}", "2017-05-08T12:58", ["Freitag 11:30"]],
    ["Time[]{2016-04-20 16:30 (X/X)}", "2016-04-15T11:21", ["Mittwoch 16:30"]],
    ["Time[]{2018-01-31 17:00 (X/X)}", "2018-01-25T11:04", ["Mittwoch 17:00"]],
    ["Time[]{2018-02-06 05:00 (X/X)}", "2018-02-02T13:47", ["Dienstag 05:00 Uhr"]],
    ["Time[]{2017-05-30 06:24 (X/X)}", "2017-05-29T06:22", ["Dienstag 06:24 Uhr"]],
    ["Time[]{2018-02-20 16:00 (X/X)}", "2018-02-16T10:44", ["Dienstag 16:00 Uhr"]],
    ["Time[]{2017-05-30 16:25 (X/X)}", "2017-05-29T06:22", ["Dienstag 16:25 Uhr"]],
    [
        "Interval[]{2017-07-10 18:30 (X/X) - 2017-07-10 19:50 (X/X)}",
        "2017-05-31T07:58",
        ["Monday 10th of July 18:30 - 19:50"],
    ],
    [
        "Time[]{2017-06-28 10:10 (X/X)}",
        "2017-06-22T07:47",
        ["Wednesday 28th of June 10:10SXF"],
    ],
    ["Time[]{2016-04-07 17:00 (X/X)}", "2016-04-05T12:38", ["Donnerstag 5pm"]],
    [
        "Time[]{2017-03-09 20:35 (X/X)}",
        "2017-02-24T10:51",
        ["Sunday 9th of March 20:35CDG"],
    ],
    [
        "Interval[]{2017-06-12 18:00 (X/X) - None}",
        "2017-06-08T08:38",
        ["Monday evening 12.06.2017 after 18:00"],
    ],
    ["Time[]{2017-05-18 18:00 (X/X)}", "2017-05-15T11:59", ["Donnerstag abend 18:00"]],
    ["Time[]{2017-01-03 X:X (X/X)}", "2016-12-14T08:33", ["Dienstag, 3.1.2017"]],
    ["Time[]{2017-01-24 X:X (X/X)}", "2016-12-14T08:33", ["Dienstag, 24.1.2017"]],
    ["Time[]{2016-11-25 10:00 (X/X)}", "2016-11-22T15:30", ["Friday, 25.11. 10 am"]],
    [
        "Time[]{2017-09-14 X:X (X/X)}",
        "2017-09-01T10:01",
        ["Donnerstag, 14.09.17", "Donnerstag, 14.09"],
    ],
    ["Time[]{2016-06-16 X:X (X/X)}", "2016-06-03T09:37", ["Donnerstag, 16.06.16"]],
    ["Time[]{2018-02-01 X:X (X/X)}", "2018-01-19T15:29", ["Donnerstag, 01.02.2018"]],
    ["Time[]{2017-05-05 12:55 (X/X)}", "2017-05-03T18:24", ["Freitag, 12:55"]],
    [
        "Time[]{2017-11-17 16:10 (X/X)}",
        "2017-11-09T10:54",
        ["Friday, 17th of Nov, 4.10 pm"],
    ],
    ["Time[]{2018-02-02 00:45 (X/X)}", "2018-01-15T16:51", ["2 FEB 00.45"]],
    ["Time[]{2018-02-07 08:00 (X/X)}", "2018-01-08T21:10", ["7 FEB, 08:00"]],
    ["Time[]{2018-04-06 16:30 (X/X)}", "2018-03-29T09:26", ["6 APRIL, 16:30"]],
    ["Time[]{2017-12-01 07:10 (X/X)}", "2017-11-20T19:42", ["1 Dec 0710"]],
    ["Time[]{2017-12-01 08:15 (X/X)}", "2017-11-20T19:42", ["1 Dec 0815"]],
    ["Time[]{2018-02-02 05:25 (X/X)}", "2018-01-24T10:06", ["2 Feb 0525"]],
    ["Time[]{2018-01-02 14:30 (X/X)}", "2017-12-09T12:31", ["2 Jan 1430"]],
    ["Time[]{2018-01-02 23:25 (X/X)}", "2017-12-09T12:31", ["2 Jan 2325"]],
    ["Time[]{2017-11-02 12:35 (X/X)}", "2017-08-25T12:23", ["2 Nov 1235"]],
    ["Time[]{2017-11-02 18:15 (X/X)}", "2017-08-25T12:23", ["2 Nov 1815"]],
    ["Time[]{2017-11-02 19:40 (X/X)}", "2017-10-25T09:35", ["2 Nov 1940"]],
    ["Time[]{2017-12-03 20:25 (X/X)}", "2017-11-20T19:42", ["3 Dec 2025"]],
    ["Time[]{2017-12-03 21:25 (X/X)}", "2017-11-20T19:42", ["3 Dec 2125"]],
    ["Time[]{2018-03-09 07:55 (X/X)}", "2018-02-20T11:11", ["9 March 0755"]],
    ["Time[]{2016-10-04 22:35 (X/X)}", "2016-09-12T08:20", ["4. Okt 22:35"]],
    ["Time[]{2017-06-01 14:15 (X/X)}", "2017-05-12T15:32", ["1. Juni 14:15"]],
    ["Time[]{2017-07-05 09:34 (X/X)}", "2017-06-29T14:30", ["5. Juli 09:34"]],
    ["Time[]{2017-07-05 13:47 (X/X)}", "2017-06-29T14:30", ["5. Juli 13:47"]],
    ["Time[]{2017-06-02 10:20 (X/X)}", "2017-05-12T15:32", ["2. Juni 10:20 Uhr"]],
    ["Time[]{2017-09-06 10:30 (X/X)}", "2017-08-07T14:26", ["6. Sept. 10:30"]],
    ["Time[]{2018-02-08 06:35 (X/X)}", "2018-01-17T10:14", ["8. Februar 6:35"]],
    ["Time[]{2017-08-02 16:45 (X/X)}", "2017-07-10T10:57", ["2. August 16.45"]],
    ["Time[]{2016-04-07 12:30 (X/X)}", "2016-03-30T12:28", ["7. April 12.30h"]],
    ["Time[]{2017-12-04 21:30 (X/X)}", "2017-11-24T12:39", ["4. Dezember 21:30"]],
    ["Time[]{2017-08-01 14:08 (X/X)}", "2017-07-31T11:31", ["1. August 14:08 Uhr"]],
    ["Time[]{2017-10-06 X:X (X/X)}", "2017-09-28T10:01", ["6. 10."]],
    ["Time[]{2017-02-07 18:05 (X/X)}", "2016-12-16T09:02", ["7.2.2017 um 18.05"]],
    ["Time[]{2017-03-24 07:05 (X/X)}", "2017-03-13T15:25", ["7:05 Fr 24. M\u00e4r"]],
    ["Time[]{2017-07-02 15:10 (X/X)}", "2017-05-31T12:41", ["02 JUL 15:10"]],
    ["Time[]{2017-07-02 16:30 (X/X)}", "2017-05-31T12:41", ["02 JUL 16:30"]],
    ["Time[]{2018-01-04 12:20 (X/X)}", "2017-12-06T12:36", ["04 JAN 12:20"]],
    ["Time[]{2017-06-04 07:45 (X/X)}", "2017-05-17T09:16", ["04 JUN 07:45"]],
    ["Time[]{2017-06-04 09:35 (X/X)}", "2017-05-17T09:16", ["04 JUN 09:35"]],
    ["Time[]{2018-01-05 00:10 (X/X)}", "2017-12-06T12:36", ["05 JAN 00:10"]],
    ["Time[]{2017-07-06 20:00 (X/X)}", "2017-05-30T13:31", ["06 JUL 20:00"]],
    ["Time[]{2017-07-06 21:45 (X/X)}", "2017-05-30T13:31", ["06 JUL 21:45"]],
    ["Time[]{2017-06-06 20:45 (X/X)}", "2017-05-17T09:16", ["06 JUN 20:45"]],
    ["Time[]{2017-06-06 22:35 (X/X)}", "2017-05-17T09:16", ["06 JUN 22:35"]],
    ["Time[]{2017-07-07 07:05 (X/X)}", "2017-06-21T10:04", ["07 JUL 07:05"]],
    ["Time[]{2017-07-07 17:25 (X/X)}", "2017-06-21T10:04", ["07 JUL 17:25"]],
    ["Time[]{2017-07-07 19:10 (X/X)}", "2017-05-30T13:31", ["07 JUL 19:10"]],
    ["Time[]{2017-06-07 07:55 (X/X)}", "2017-05-17T09:16", ["07 JUN 07:55"]],
    ["Time[]{2017-06-07 08:50 (X/X)}", "2017-05-17T09:16", ["07 JUN 08:50"]],
    ["Time[]{2017-06-08 09:50 (X/X)}", "2017-05-17T09:16", ["08 JUN 09:50"]],
    ["Time[]{2018-01-10 19:10 (X/X)}", "2017-12-30T15:14", ["10 JAN, 19:10"]],
    ["Time[]{2018-01-10 22:05 (X/X)}", "2017-12-30T15:14", ["10 JAN, 22:05"]],
    ["Time[]{2017-10-10 08:40 (X/X)}", "2017-09-09T06:12", ["10 OCT, 08:40"]],
    ["Time[]{2017-10-10 09:15 (X/X)}", "2017-09-19T09:55", ["10 OCT, 09:15"]],
    ["Time[]{2017-10-10 10:30 (X/X)}", "2017-09-19T09:55", ["10 OCT, 10:30"]],
    ["Time[]{2017-10-10 11:35 (X/X)}", "2017-09-09T06:12", ["10 OCT, 11:35"]],
    ["Time[]{2018-01-11 17:35 (X/X)}", "2017-12-30T15:14", ["11 JAN, 17:35"]],
    ["Time[]{2018-01-11 18:10 (X/X)}", "2017-12-30T15:14", ["11 JAN, 18:10"]],
    ["Time[]{2018-01-11 19:55 (X/X)}", "2017-12-30T15:14", ["11 JAN, 19:55"]],
    ["Time[]{2018-01-11 21:50 (X/X)}", "2017-12-30T15:14", ["11 JAN, 21:50"]],
    ["Time[]{2017-10-11 17:00 (X/X)}", "2017-09-09T06:12", ["11 OCT, 17:00"]],
    ["Time[]{2017-09-11 13:15 (X/X)}", "2017-09-09T06:12", ["11 SEP, 13:15"]],
    ["Time[]{2017-09-11 16:05 (X/X)}", "2017-09-09T06:12", ["11 SEP, 16:05"]],
    ["Time[]{2018-01-12 15:15 (X/X)}", "2017-12-30T15:14", ["12 JAN, 15:15"]],
    ["Time[]{2018-01-12 17:05 (X/X)}", "2017-12-30T15:14", ["12 JAN, 17:05"]],
    ["Time[]{2018-01-12 19:45 (X/X)}", "2017-12-30T15:14", ["12 JAN, 19:45"]],
    ["Time[]{2017-09-12 17:00 (X/X)}", "2017-09-09T06:12", ["12 SEP, 17:00"]],
    ["Time[]{2017-09-12 17:55 (X/X)}", "2017-09-09T06:12", ["12 SEP, 17:55"]],
    ["Time[]{2018-02-13 07:45 (X/X)}", "2017-10-16T13:34", ["13 FEB, 07:45"]],
    ["Time[]{2018-02-13 08:35 (X/X)}", "2017-10-16T13:34", ["13 FEB, 08:35"]],
    ["Time[]{2018-02-13 18:05 (X/X)}", "2017-10-16T13:34", ["13 FEB, 18:05"]],
    ["Time[]{2018-02-13 18:50 (X/X)}", "2017-10-16T13:34", ["13 FEB, 18:50"]],
    ["Time[]{2017-11-15 16:30 (X/X)}", "2017-11-14T04:09", ["15 NOV, 16:30"]],
    ["Time[]{2017-11-15 17:35 (X/X)}", "2017-11-14T04:09", ["15 NOV, 17:35"]],
    ["Time[]{2017-11-15 18:15 (X/X)}", "2017-11-14T04:09", ["15 NOV, 18:15"]],
    ["Time[]{2018-04-15 19:10 (X/X)}", "2018-03-29T09:26", ["15 APRIL, 19:10"]],
    ["Time[]{2016-03-03 18:55 (X/X)}", "2016-02-17T10:04", ["03 Mar 18:55"]],
    ["Time[]{2016-03-03 22:55 (X/X)}", "2016-02-17T10:04", ["03 Mar 22:55"]],
    ["Time[]{2016-03-04 00:45 (X/X)}", "2016-02-17T10:04", ["04 Mar 00:45"]],
    ["Time[]{2016-03-04 16:55 (X/X)}", "2016-02-17T10:04", ["04 Mar 16:55"]],
    ["Time[]{2016-03-09 20:30 (X/X)}", "2016-03-01T23:13", ["09 Mar 20:30"]],
    ["Time[]{2016-03-10 21:15 (X/X)}", "2016-03-01T23:13", ["10 Mar 21:15"]],
    ["Time[]{2016-02-15 19:25 (X/X)}", "2016-02-10T16:38", ["15 Feb 19:25"]],
    ["Time[]{2016-02-16 08:15 (X/X)}", "2016-02-10T16:38", ["16 Feb 08:15"]],
    ["Time[]{2016-02-16 13:05 (X/X)}", "2016-02-10T16:38", ["16 Feb 13:05"]],
    ["Time[]{2016-02-18 20:55 (X/X)}", "2016-02-10T16:38", ["18 Feb 20:55"]],
    ["Time[]{2016-02-18 22:15 (X/X)}", "2016-02-10T16:38", ["18 Feb 22:15"]],
    ["Time[]{2016-03-18 20:45 (X/X)}", "2016-03-04T13:34", ["18 Mar 20:45"]],
    ["Time[]{2017-12-12 10:30 (X/X)}", "2017-11-29T15:28", ["12 Dec 1030"]],
    ["Time[]{2018-03-12 10:05 (X/X)}", "2018-02-28T11:22", ["12 Mar 1005"]],
    ["Time[]{2017-05-12 09:00 (X/X)}", "2017-05-09T18:51", ["12 May 0900"]],
    ["Time[]{2017-05-12 10:15 (X/X)}", "2017-05-09T18:51", ["12 May 1015"]],
    ["Time[]{2017-05-12 17:00 (X/X)}", "2017-05-09T18:51", ["12 May 1700"]],
    ["Time[]{2017-05-12 18:15 (X/X)}", "2017-05-09T18:51", ["12 May 1815"]],
    ["Time[]{2017-11-12 20:20 (X/X)}", "2017-08-25T12:23", ["12 Nov 2020"]],
    ["Time[]{2017-11-12 22:55 (X/X)}", "2017-08-25T12:23", ["12 Nov 2255"]],
    ["Time[]{2017-11-13 20:20 (X/X)}", "2017-08-25T12:23", ["13 Nov 2020"]],
    ["Time[]{2017-11-13 22:55 (X/X)}", "2017-08-25T12:23", ["13 Nov 2255"]],
    ["Time[]{2017-11-13 23:30 (X/X)}", "2017-08-25T12:23", ["13 Nov 2330"]],
    ["Time[]{2017-12-14 10:20 (X/X)}", "2017-11-29T15:28", ["14 Dec 1020"]],
    ["Time[]{2017-05-14 19:05 (X/X)}", "2017-05-03T12:01", ["14 May 0705pm"]],
    ["Time[]{2017-07-27 11:00 (X/X)}", "2017-07-20T15:50", ["27 July 1100"]],
    ["Time[]{2017-10-04 02:55 (X/X)}", "2017-08-04T07:06", ["04 October 02.55"]],
    ["Time[]{2017-10-04 12:00 (X/X)}", "2017-08-04T07:06", ["04 October 12.00"]],
    ["Time[]{2018-03-02 12:50 (X/X)}", "2018-02-05T13:59", ["02 March 12:50"]],
    ["Time[]{2017-08-10 17:00 (X/X)}", "2017-07-14T06:23", ["10 August 17:00"]],
    ["Time[]{2018-03-10 19:40 (X/X)}", "2018-02-23T09:15", ["10 March 1940"]],
    ["Time[]{2018-03-13 17:00 (X/X)}", "2018-02-23T09:15", ["13 March 1700"]],
    ["Time[]{2016-02-15 08:15 (X/X)}", "2016-02-13T08:17", ["15 feb 08:15"]],
    ["Time[]{2016-02-15 09:30 (X/X)}", "2016-02-13T08:17", ["15 feb 09:30"]],
    ["Time[]{2016-02-15 10:15 (X/X)}", "2016-02-13T08:17", ["15 feb 10:15"]],
    [
        "Interval[]{2017-12-12 X:X (X/X) - 2017-12-13 X:X (X/X)}",
        "2017-10-25T13:27",
        ["12- 13.12.17"],
    ],
    [
        "Interval[]{2018-01-15 X:X (X/X) - 2018-01-17 X:X (X/X)}",
        "2017-12-04T15:01",
        ["15-17.01.2018"],
    ],
    [
        "Interval[]{2017-05-02 X:X (X/X) - 2017-05-04 X:X (X/X)}",
        "2017-04-28T13:07",
        ["02. - 04.05. 2017", "02. - 04.05. 2017"],
    ],
    [
        "Interval[]{2017-11-16 X:X (X/X) - 2017-11-17 X:X (X/X)}",
        "2017-09-18T15:23",
        ["16. - 17.11.17"],
    ],
    [
        "Interval[]{2017-08-03 X:X (X/X) - 2017-08-04 X:X (X/X)}",
        "2017-06-29T12:25",
        ["03. - 04.08.2017"],
    ],
    [
        "Interval[]{2017-09-03 X:X (X/X) - 2017-09-05 X:X (X/X)}",
        "2017-04-03T14:57",
        ["03. - 05.09.2017"],
    ],
    [
        "Interval[]{2017-07-13 X:X (X/X) - 2017-07-14 X:X (X/X)}",
        "2017-05-31T09:03",
        ["13. - 14.07.2017"],
    ],
    ["Time[]{2016-05-20 18:55 (X/X)}", "2016-04-18T09:08", ["20. Mai 18.55 Uhr"]],
    ["Time[]{2017-05-16 19:30 (X/X)}", "2017-05-08T12:11", ["16. Mai 19:30"]],
    ["Time[]{2017-10-21 11:30 (X/X)}", "2017-07-07T08:26", ["21. Oct. 11:30"]],
    ["Time[]{2017-10-21 19:00 (X/X)}", "2017-07-07T08:26", ["21. Oct. 19:00"]],
    ["Time[]{2017-10-21 20:04 (X/X)}", "2017-07-07T08:26", ["21. Oct. 20:04"]],
    ["Time[]{2017-07-19 08:39 (X/X)}", "2017-07-03T16:28", ["19. Juli 8.39"]],
    ["Time[]{2017-03-07 17:20 (X/X)}", "2017-02-17T10:35", ["07. M\u00e4rz 17.20 Uhr"]],
    ["Time[]{2018-03-12 10:50 (X/X)}", "2018-03-09T13:29", ["12. M\u00e4rz 10:50"]],
    ["Time[]{2018-03-12 12:05 (X/X)}", "2018-03-09T13:29", ["12. M\u00e4rz 12:05"]],
    ["Time[]{2018-03-13 11:15 (X/X)}", "2018-03-08T15:14", ["13. M\u00e4rz 11:15"]],
    ["Time[]{2018-03-13 14:40 (X/X)}", "2018-03-08T15:14", ["13. M\u00e4rz 14:40"]],
    ["Time[]{2018-03-14 07:00 (X/X)}", "2018-03-09T13:29", ["14. M\u00e4rz 07:00"]],
    ["Time[]{2018-03-14 10:10 (X/X)}", "2018-03-09T13:29", ["14. M\u00e4rz 10:10"]],
    ["Time[]{2018-03-15 08:40 (X/X)}", "2018-03-08T15:14", ["15. M\u00e4rz 08:40"]],
    ["Time[]{2018-03-15 10:15 (X/X)}", "2018-03-08T15:14", ["15. M\u00e4rz 10:15"]],
    ["Time[]{2017-08-31 16:40 (X/X)}", "2017-07-20T10:17", ["31. August 4.40PM"]],
    ["Time[]{2018-01-10 07:00 (X/X)}", "2018-01-05T06:09", ["10. Januar 7:00"]],
    ["Time[]{2018-02-27 18:00 (X/X)}", "2018-02-12T10:09", ["27. Februar 18 Uhr"]],
    ["Time[]{2018-04-10 06:55 (X/X)}", "2018-03-29T14:48", ["10. April 06.55"]],
    ["Time[]{2018-01-11 20:20 (X/X)}", "2018-01-05T06:09", ["11. Januar 20:20"]],
    ["Time[]{2016-11-11 13:20 (X/X)}", "2016-10-11T07:13", ["11. November 13:20"]],
    ["Time[]{2016-11-11 14:50 (X/X)}", "2016-10-11T07:13", ["11. November 14:50"]],
    ["Time[]{2018-09-11 17:10 (X/X)}", "2018-03-20T12:49", ["11. September 17:10"]],
    ["Time[]{2018-04-16 11:25 (X/X)}", "2018-04-03T11:50", ["16. April 11:25"]],
    ["Time[]{2018-04-16 15:25 (X/X)}", "2018-04-03T11:50", ["16. April 15:25"]],
    ["Time[]{2015-12-16 05:10 (X/X)}", "2015-12-10T16:58", ["16. Dezember 05:10"]],
    ["Time[]{2015-12-16 06:20 (X/X)}", "2015-12-10T16:58", ["16. Dezember 06:20"]],
    ["Time[]{2018-02-19 07:45 (X/X)}", "2018-02-14T09:50", ["19. Februar 07:45"]],
    ["Time[]{2018-02-19 12:40 (X/X)}", "2018-02-14T09:50", ["19. Februar 12:40"]],
    ["Time[]{2017-01-19 10:35 (X/X)}", "2017-01-16T16:46", ["19. Januar 10:35"]],
    ["Time[]{2018-04-20 15:30 (X/X)}", "2018-04-03T11:50", ["20. April 15:30"]],
    ["Time[]{2018-04-20 17:50 (X/X)}", "2018-04-03T11:50", ["20. April 17:50"]],
    ["Time[]{2018-09-11 08:15 (X/X)}", "2018-03-20T12:49", ["11. September 08:15 Uhr"]],
    ["Time[]{2017-12-12 14:00 (X/X)}", "2017-12-07T09:10", ["12. Dezember 14:00 Uhr"]],
    ["Time[]{2017-12-12 20:50 (X/X)}", "2017-12-07T09:10", ["12. Dezember 20:50 Uhr"]],
    ["Time[]{2017-04-04 17:35 (X/X)}", "2017-03-25T14:11", ["04. April 17:35 h"]],
    ["Time[]{2018-04-25 10:15 (X/X)}", "2018-03-21T12:49", ["25. apr 10.15"]],
    [
        "Interval[]{2018-12-12 X:X (X/X) - 2018-12-14 X:X (X/X)}",
        "2018-03-22T15:20",
        ["12. bis 14.12.2018"],
    ],
    ["Time[]{2018-03-13 09:20 (X/X)}", "2018-03-06T11:02", ["13. mar 09:20"]],
    [
        "Interval[]{2018-01-24 X:X (X/X) - 2018-01-29 X:X (X/X)}",
        "2017-12-18T13:03",
        ["24.-29. Januar 2018"],
    ],
    [
        "Interval[]{2018-03-21 X:X (X/X) - 2018-03-23 X:X (X/X)}",
        "2018-01-09T09:14",
        ["21.-23.3.18"],
    ],
    [
        "Interval[]{2017-04-10 X:X (X/X) - 2017-04-11 X:X (X/X)}",
        "2017-04-04T08:53",
        ["10.-11.04. 2017", "10.-11.04.2017", "10.-11.04. 2017"],
    ],
    [
        "Interval[]{2017-11-05 X:X (X/X) - 2017-11-10 X:X (X/X)}",
        "2017-08-14T16:01",
        ["05.-10.11.17"],
    ],
    [
        "Interval[]{2018-05-07 X:X (X/X) - 2018-05-09 X:X (X/X)}",
        "2018-02-28T17:28",
        ["07.-09.05.18"],
    ],
    [
        "Interval[]{2017-10-07 X:X (X/X) - 2017-10-14 X:X (X/X)}",
        "2017-08-07T08:13",
        ["07.-14.10.17"],
    ],
    [
        "Interval[]{2018-05-04 X:X (X/X) - 2018-05-05 X:X (X/X)}",
        "2018-02-02T09:44",
        ["04.-05.05.2018"],
    ],
    [
        "Interval[]{2017-11-05 X:X (X/X) - 2017-11-07 X:X (X/X)}",
        "2017-09-19T12:19",
        ["05.-07.11.2017"],
    ],
    [
        "Interval[]{2018-02-05 X:X (X/X) - 2018-02-10 X:X (X/X)}",
        "2017-09-26T14:05",
        ["05.-10.02.2018"],
    ],
    [
        "Interval[]{2018-02-05 X:X (X/X) - 2018-02-11 X:X (X/X)}",
        "2017-09-26T14:05",
        ["05.-11.02.2018"],
    ],
    [
        "Interval[]{2017-03-06 X:X (X/X) - 2017-03-08 X:X (X/X)}",
        "2017-01-19T08:09",
        ["06.-08.03.2017"],
    ],
    [
        "Interval[]{2018-05-06 X:X (X/X) - 2018-05-09 X:X (X/X)}",
        "2018-02-07T12:30",
        ["06.-09.05.2018"],
    ],
    [
        "Interval[]{2018-06-08 X:X (X/X) - 2018-06-09 X:X (X/X)}",
        "2018-02-02T10:04",
        ["08.-09.06.2018"],
    ],
    [
        "Interval[]{2018-07-08 X:X (X/X) - 2018-07-10 X:X (X/X)}",
        "2018-02-07T12:30",
        ["08.-10.07.2018"],
    ],
    [
        "Interval[]{2018-01-08 X:X (X/X) - 2018-01-11 X:X (X/X)}",
        "2017-11-16T09:10",
        ["08.-11.01.2018"],
    ],
    [
        "Interval[]{2018-06-10 X:X (X/X) - 2018-06-12 X:X (X/X)}",
        "2018-02-07T12:30",
        ["10.-12.06.2018"],
    ],
    ["Time[]{2017-05-23 14:00 (X/X)}", "2017-04-25T15:59", ["23.Mai 14h"]],
    [
        "Interval[]{None - 2018-02-14 10:30 (X/X)}",
        "2018-02-02T18:56",
        ["14.2 sp\u00e4testens um 10:30"],
    ],
    [
        "Interval[]{2017-03-17 10:30 (X/X) - 2017-03-18 09:25 (X/X)}",
        "2017-03-09T10:17",
        ["17.03. 10:30 - 18.03. 09:25"],
    ],
    [
        "Interval[]{None - 2016-01-20 19:00 (X/X)}",
        "2016-01-13T12:05",
        ["20.01. sp\u00e4testens um 19 Uhr"],
    ],
    [
        "Interval[]{None - 2017-07-03 10:00 (X/X)}",
        "2017-06-21T13:36",
        ["03.07. sp\u00e4testens um 10:00 Uhr"],
    ],
    [
        "Interval[]{2017-08-15 13:00 (X/X) - 2017-08-15 16:30 (X/X)}",
        "2017-08-02T06:54",
        ["15.08.17 13 - 16:30"],
    ],
    [
        "Interval[]{2017-04-05 15:00 (X/X) - 2017-04-05 17:00 (X/X)}",
        "2017-04-03T11:09",
        ["05.04.17 15-17 Uhr"],
    ],
    [
        "Interval[]{2017-06-11 11:00 (X/X) - 2017-06-11 12:00 (X/X)}",
        "2017-04-18T10:38",
        ["11.06.17 11-12 Uhr"],
    ],
    [
        "Interval[]{2017-06-11 11:00 (X/X) - 2017-06-11 13:00 (X/X)}",
        "2017-04-04T09:18",
        ["11.06.17 11-13 Uhr"],
    ],
    [
        "Interval[]{2017-07-13 19:00 (X/X) - 2017-07-13 19:30 (X/X)}",
        "2017-07-07T14:52",
        ["13.07.17 19-19:30 Uhr"],
    ],
    [
        "Time[]{2017-06-02 X:X (X/X)}",
        "2017-01-23T17:51",
        ["02.06.17 19.30", "02.06.17 19.30"],
    ],
    [
        "Interval[]{2016-04-01 19:00 (X/X) - 2016-04-01 21:10 (X/X)}",
        "2016-03-23T09:11",
        ["01.04.16 1900-2110"],
    ],
    [
        "Interval[]{2016-07-01 19:25 (X/X) - 2016-07-01 22:50 (X/X)}",
        "2016-06-28T09:39",
        ["01.07.16 1925-2250"],
    ],
    [
        "Interval[]{2016-05-02 19:30 (X/X) - 2016-05-02 20:00 (X/X)}",
        "2016-04-27T09:14",
        ["02.05.16 1930-2000"],
    ],
    [
        "Interval[]{2016-06-03 19:05 (X/X) - 2016-06-03 21:00 (X/X)}",
        "2016-05-27T13:01",
        ["03.06.16 1905-2100"],
    ],
    [
        "Interval[]{2016-04-04 19:30 (X/X) - 2016-04-04 20:00 (X/X)}",
        "2016-03-30T12:57",
        ["04.04.16 1930-2000"],
    ],
    [
        "Interval[]{2016-04-04 22:40 (X/X) - 2016-04-05 03:30 (X/X)}",
        "2016-04-04T14:32",
        ["04.04.16 2240-0330"],
    ],
    [
        "Interval[]{2016-05-06 19:00 (X/X) - 2016-05-06 21:10 (X/X)}",
        "2016-04-29T12:27",
        ["06.05.16 1900-2110"],
    ],
    [
        "Interval[]{2016-04-07 19:00 (X/X) - 2016-04-07 21:10 (X/X)}",
        "2016-04-05T08:03",
        ["07.04.16 1900-2110"],
    ],
    [
        "Interval[]{2016-04-08 19:00 (X/X) - 2016-04-08 21:10 (X/X)}",
        "2016-04-01T13:47",
        ["08.04.16 1900-2110"],
    ],
    [
        "Interval[]{2016-07-08 19:05 (X/X) - 2016-07-08 21:00 (X/X)}",
        "2016-06-29T09:44",
        ["08.07.16 1905-2100"],
    ],
    [
        "Interval[]{2016-06-09 19:00 (X/X) - 2016-06-09 21:10 (X/X)}",
        "2016-06-06T09:52",
        ["09.06.16 1900-2110"],
    ],
    [
        "Interval[]{2016-06-10 19:25 (X/X) - 2016-06-10 22:50 (X/X)}",
        "2016-06-03T07:53",
        ["10.06.16 1925-2250"],
    ],
    [
        "Interval[]{2016-05-13 19:00 (X/X) - 2016-05-13 21:10 (X/X)}",
        "2016-05-06T10:44",
        ["13.05.16 1900-2110"],
    ],
    [
        "Interval[]{2016-05-13 19:30 (X/X) - 2016-05-13 20:40 (X/X)}",
        "2016-05-12T16:03",
        ["13.05.16 1930-2040"],
    ],
    [
        "Interval[]{2016-04-15 13:00 (X/X) - 2016-04-15 16:00 (X/X)}",
        "2016-04-11T13:39",
        ["15.04.16 von 13-16 Uhr", "15.04.16 von 13-16 Uhr"],
    ],
    [
        "Interval[]{2018-04-10 08:00 (X/X) - 2018-04-10 10:00 (X/X)}",
        "2018-03-26T15:54",
        ["10.04.2018 8-10AM", "10.04.2018 8-10AM"],
    ],
    [
        "Interval[]{2017-04-07 17:00 (X/X) - 2017-04-07 18:00 (X/X)}",
        "2017-04-03T11:09",
        ["07.04.2017 17-18 Uhr"],
    ],
    [
        "Time[]{2017-03-22 19:10 (X/X)}",
        "2017-03-07T14:54",
        ["22.03.2017 19.10", "22.03.2017 19.10"],
    ],
    [
        "Time[]{2018-02-14 12:00 (X/X)}",
        "2018-01-24T15:25",
        ["14.02.2018 morgens ca. 12.00 Uhr"],
    ],
    [
        "Time[]{2017-03-19 09:00 (X/X)}",
        "2017-03-03T08:57",
        ["19.03.2017 morgens gegen 09.00 h"],
    ],
    ["Time[]{2017-05-15 15:40 (X/X)}", "2017-04-06T09:01", ["15:40     Mon, 15 May"]],
    ["Time[]{2017-04-09 17:20 (X/X)}", "2017-03-30T13:07", ["17:20 So 9. Apr"]],
    ["Time[]{2017-07-13 10:25 (X/X)}", "2017-07-05T12:39", ["10:25 Do 13. Jul"]],
    ["Time[]{2017-03-22 10:35 (X/X)}", "2017-03-13T15:25", ["10:35 Mi 22. M\u00e4r"]],
    ["Time[]{2017-07-14 11:05 (X/X)}", "2017-07-05T12:39", ["11:05 Fr 14. Jul"]],
    [
        "Time[]{2017-01-11 19:05 (X/X)}",
        "2017-01-03T07:56",
        ["19:05 Mittwoch, 11 Januar"],
    ],
    ["Time[]{2016-12-02 18:50 (X/X)}", "2016-11-02T16:44", ["02DEC   18:50"]],
    ["Time[]{2016-11-14 09:30 (X/X)}", "2016-10-31T15:12", ["14NOV 9:30"]],
    ["Time[]{2016-12-01 10:00 (X/X)}", "2016-11-22T09:46", ["01DEZ 10:00"]],
    ["Time[]{2017-07-01 19:40 (X/X)}", "2017-05-19T08:51", ["01JUL 19:40"]],
    ["Time[]{2016-11-02 10:15 (X/X)}", "2016-10-28T10:19", ["02NOV 10:15"]],
    ["Time[]{2016-11-02 10:35 (X/X)}", "2016-10-28T08:42", ["02NOV 10:35"]],
    ["Time[]{2017-10-02 22:15 (X/X)}", "2017-08-30T10:39", ["02OCT 22:15"]],
    ["Time[]{2017-04-03 11:40 (X/X)}", "2017-03-15T10:47", ["03APR 11:40"]],
    ["Time[]{2017-04-03 12:30 (X/X)}", "2017-03-15T10:47", ["03APR 12:30"]],
    ["Time[]{2017-04-03 15:20 (X/X)}", "2017-03-15T10:47", ["03APR 15:20"]],
    ["Time[]{2017-04-03 16:30 (X/X)}", "2017-03-15T10:47", ["03APR 16:30"]],
    ["Time[]{2017-04-03 18:30 (X/X)}", "2017-03-06T10:53", ["03APR 18:30"]],
    ["Time[]{2017-04-03 19:55 (X/X)}", "2017-03-06T10:53", ["03APR 19:55"]],
    ["Time[]{2017-08-03 19:40 (X/X)}", "2017-05-19T08:51", ["03AUG 19:40"]],
    ["Time[]{2016-11-03 20:00 (X/X)}", "2016-10-28T08:42", ["03NOV 20:00"]],
    ["Time[]{2017-08-04 17:15 (X/X)}", "2017-05-19T08:51", ["04AUG 17:15"]],
    ["Time[]{2017-08-04 18:20 (X/X)}", "2017-05-19T08:51", ["04AUG 18:20"]],
    ["Time[]{2016-11-04 18:35 (X/X)}", "2016-11-02T08:55", ["04NOV 18:35"]],
    ["Time[]{2017-04-06 07:40 (X/X)}", "2017-03-06T10:53", ["06APR 07:40"]],
    ["Time[]{2017-04-06 09:00 (X/X)}", "2017-03-06T10:53", ["06APR 09:00"]],
    ["Time[]{2017-04-06 10:00 (X/X)}", "2017-03-06T10:53", ["06APR 10:00"]],
    ["Time[]{2017-04-06 13:10 (X/X)}", "2017-03-06T10:53", ["06APR 13:10"]],
    ["Time[]{2017-04-07 12:55 (X/X)}", "2017-03-15T10:47", ["07APR 12:55"]],
    ["Time[]{2017-04-07 14:15 (X/X)}", "2017-03-15T10:47", ["07APR 14:15"]],
    ["Time[]{2017-04-07 16:10 (X/X)}", "2017-03-15T10:47", ["07APR 16:10"]],
    ["Time[]{2017-04-07 17:00 (X/X)}", "2017-03-15T10:47", ["07APR 17:00"]],
    ["Time[]{2017-04-07 19:20 (X/X)}", "2017-03-06T10:53", ["07APR 19:20"]],
    ["Time[]{2017-04-07 20:20 (X/X)}", "2017-03-06T10:53", ["07APR 20:20"]],
    ["Time[]{2017-04-07 21:00 (X/X)}", "2017-03-06T10:53", ["07APR 21:00"]],
    ["Time[]{2017-04-07 22:10 (X/X)}", "2017-03-06T10:53", ["07APR 22:10"]],
    ["Time[]{2016-11-09 09:00 (X/X)}", "2016-11-02T08:51", ["09NOV 09:00"]],
    ["Time[]{2016-11-09 10:25 (X/X)}", "2016-11-02T08:55", ["09NOV 10:25"]],
    ["Time[]{2016-11-10 16:00 (X/X)}", "2016-11-02T09:52", ["10NOV 16:00"]],
    ["Time[]{2016-11-10 17:00 (X/X)}", "2016-11-08T09:06", ["10NOV 17:00"]],
    ["Time[]{2016-11-10 17:30 (X/X)}", "2016-11-09T09:19", ["10NOV 17:30"]],
    ["Time[]{2016-12-11 19:25 (X/X)}", "2016-11-21T10:41", ["11DEC 19:25"]],
    ["Time[]{2016-11-11 11:30 (X/X)}", "2016-11-08T11:44", ["11NOV 11:30"]],
    ["Time[]{2016-11-11 16:00 (X/X)}", "2016-11-08T11:44", ["11NOV 16:00"]],
    ["Time[]{2016-11-11 19:00 (X/X)}", "2016-11-08T09:06", ["11NOV 19:00"]],
    ["Time[]{2016-11-12 15:00 (X/X)}", "2016-11-09T15:42", ["12NOV 15:00"]],
    ["Time[]{2017-10-12 00:40 (X/X)}", "2017-08-30T10:39", ["12OCT 00:40"]],
    ["Time[]{2017-08-13 08:05 (X/X)}", "2017-05-19T08:51", ["13AUG 08:05"]],
    ["Time[]{2017-08-13 09:10 (X/X)}", "2017-05-19T08:51", ["13AUG 09:10"]],
    ["Time[]{2017-08-13 13:30 (X/X)}", "2017-05-19T08:51", ["13AUG 13:30"]],
    ["Time[]{2017-08-13 17:40 (X/X)}", "2017-05-19T08:51", ["13AUG 17:40"]],
    ["Time[]{2017-09-15 21:25 (X/X)}", "2017-08-18T14:19", ["15th September 21.25"]],
    ["Time[]{2018-03-22 07:50 (X/X)}", "2018-02-09T14:33", ["22mar 7:50"]],
    [
        "Time[]{2018-03-23 13:50 (X/X)}",
        "2018-02-09T14:33",
        ["23mar 13:50", "on Friday 23rd Mar 13.50"],
    ],
    ["Time[]{2018-03-02 07:10 (X/X)}", "2018-02-09T09:04", ["2mar 7:10"]],
    [
        "Time[]{2018-04-17 X:X (X/X)}",
        "2018-04-12T11:16",
        ["on Tue, 17-Apr", "on Tue, 17-Apr"],
    ],
    [
        "Time[]{2017-03-12 X:X (X/X)}",
        "2016-11-14T20:44",
        ["on Sunday March 12", "on Sunday March 12"],
    ],
    [
        "Time[]{2016-12-13 X:X (X/X)}",
        "2016-11-15T15:03",
        ["on Tuesday 13 December", "16-12-13", "on Tuesday 13 December"],
    ],
    [
        "Time[]{2017-08-25 X:X (X/X)}",
        "2017-08-02T08:35",
        ["am Freitag 25. August", "am Freitag 25. August"],
    ],
    [
        "Time[]{2017-04-14 X:X (X/X)}",
        "2017-04-06T15:11",
        ["am Freitag 14.4.", "am Freitag 14.4."],
    ],
    ["Time[]{2018-01-11 15:45 (X/X)}", "2018-01-08T17:30", ["am Donnerstag 15.45"]],
    [
        "Time[]{2017-11-21 X:X (X/X)}",
        "2017-11-05T14:30",
        ["am Dienstag 21.11.", "am Dienstag 21.11."],
    ],
    [
        "Time[]{2016-11-10 X:X (X/X)}",
        "2016-10-31T00:53",
        ["am Donnerstag 10.11.", "am Donnerstag 10.11."],
    ],
    [
        "Time[]{2017-11-23 X:X (X/X)}",
        "2017-11-05T14:30",
        ["am Donnerstag 23.11.", "am Donnerstag 23.11.", "am Donnerstag, 23. November"],
    ],
    [
        "Time[]{2016-11-24 X:X (X/X)}",
        "2016-10-19T16:28",
        ["am Donnerstag 24.11.", "am Donnerstag 24.11."],
    ],
    [
        "Time[]{2017-08-22 18:40 (X/X)}",
        "2017-08-10T09:17",
        ["am Dienstag 22.08. 18:40", "am Dienstag 22.08. 18:40"],
    ],
    ["Time[]{2016-01-17 X:X (X/X)}", "2016-12-16T08:38", ["am Dienstag 17.01.2016"]],
    ["Time[]{2018-06-28 X:X (X/X)}", "2018-03-23T09:58", ["am Donnerstag 28.06.2018"]],
    [
        "Time[]{2017-09-22 X:X (X/X)}",
        "2017-09-11T16:52",
        ["on Friday 22/9", "on Friday 22/9"],
    ],
    [
        "Time[]{2018-01-31 08:40 (X/X)}",
        "2018-01-25T13:54",
        ["on Wednesday 31/1 at 08.40", "on Wednesday 31/1 at 08.40"],
    ],
    [
        "Time[]{2017-08-27 X:X (X/X)}",
        "2017-08-17T10:25",
        ["am Sonntag 27/08", "am Sonntag 27/08"],
    ],
    ["Time[]{2016-05-11 14:30 (X/X)}", "2016-05-09T20:05", ["am Mittwoch 14:30"]],
    ["Time[]{2016-02-18 15:55 (X/X)}", "2016-02-16T10:31", ["am Donnerstag 15:55 Uhr"]],
    ["Time[]{2018-04-30 X:X (X/X)}", "2018-01-25T13:40", ["on Monday 30th April"]],
    [
        "Time[]{2017-07-09 X:X (X/X)}",
        "2017-06-28T08:23",
        ["on Sunday 9th July", "on Sunday 9th July"],
    ],
    [
        "Time[]{2017-03-08 X:X (X/X)}",
        "2017-02-28T16:22",
        ["am Mittwoch den 08.03.", "am Mittwoch den 08.03."],
    ],
    [
        "Time[]{2016-09-01 X:X (X/X)}",
        "2016-06-06T14:31",
        ["am Donnerstag, 01. September", "am Donnerstag, 01. September"],
    ],
    [
        "Time[]{2018-04-10 X:X (X/evening)}",
        "2018-03-20T08:03",
        ["am Dienstag, 10.4. abends", "am Dienstag, 10.4. abends"],
    ],
    [
        "Time[]{2017-08-18 X:X (X/X)}",
        "2017-08-09T06:58",
        ["am Freitag, 18.08", "am Freitag, 18.08"],
    ],
    [
        "Time[]{2017-09-27 06:30 (X/X)}",
        "2017-09-20T17:50",
        ["am Mittwoch, 27.09. 06:30", "am Mittwoch, 27.09. 06:30"],
    ],
    ["Time[]{2017-03-21 X:X (X/X)}", "2017-03-13T08:37", ["am Dienstag, 21.03.17"]],
    ["Time[]{2016-11-29 X:X (X/X)}", "2016-10-20T15:40", ["am Dienstag, 29.11.16"]],
    ["Time[]{2017-03-16 X:X (X/X)}", "2017-03-07T11:26", ["am Donnerstag, 16.03.17"]],
    ["Time[]{2017-06-22 X:X (X/X)}", "2017-05-05T10:43", ["am Donnerstag, 22.06.17"]],
    ["Time[]{2018-02-02 X:X (X/X)}", "2018-01-22T14:32", ["am Freitag, 02.02.2018"]],
    ["Time[]{2015-11-20 X:X (X/X)}", "2015-11-06T09:36", ["am Freitag, 20.11.2015"]],
    [
        "Time[]{2016-11-07 X:X (X/X)}",
        "2016-11-04T09:55",
        ["ab Montag, den 07.11", "ab Montag, den 07.11"],
    ],
    [
        "Time[]{2015-10-06 X:X (X/X)}",
        "2015-09-24T10:40",
        ["am Dienstag, den 06.10.", "am Dienstag, den 06.10."],
    ],
    [
        "Time[]{2017-08-15 X:X (X/X)}",
        "2017-08-03T12:00",
        ["am Dienstag, den 15.08.", "am Dienstag, den 15.08."],
    ],
    [
        "Time[]{2017-12-09 13:00 (X/X)}",
        "2017-11-27T14:14",
        ["um 13 Uhr Samstag 09.12.2017"],
    ],
    [
        "Interval[]{2017-12-13 16:00 (X/X) - None}",
        "2017-12-04T09:06",
        ["am 13.12. ab frühestens 16:00 h", "am 13.12. ab frühestens 16:00 h"],
    ],
    [
        "Interval[]{None - 2018-03-22 08:00 (X/X)}",
        "2018-03-09T12:27",
        ["am 22.03. sp\u00e4testens um 8.00 Uhr"],
    ],
    [
        "Interval[]{None - 2017-05-16 13:00 (X/X)}",
        "2017-05-05T08:14",
        ["am 16.05. sp\u00e4testens um 13 Uhr"],
    ],
    [
        "Interval[]{None - 2017-07-10 07:30 (X/X)}",
        "2017-05-30T12:02",
        ["am 10.07. sp\u00e4testens um 07:30"],
    ],
    [
        "Interval[]{2017-04-12 07:00 (X/X) - None}",
        "2017-04-05T12:42",
        ["am 12.04.2017 ab ca. 7.00 Uhr morgens"],
    ],
    [
        "Time[]{2016-10-12 16:00 (X/X)}",
        "2016-09-22T10:28",
        ["am 12.10.2016 nachmittags 16.00 Uhr", "am 12.10.2016 nachmittags 16.00 Uhr"],
    ],
    [
        "Time[]{2015-10-21 06:55 (X/X)}",
        "2015-10-14T14:32",
        ["am 21.10.2015 fr\u00fch 06:55", "am 21.10.2015 fr\u00fch 06:55"],
    ],
    [
        "Time[]{2016-11-10 17:20 (X/X)}",
        "2016-10-19T12:53",
        ["am 10.11.2016 abends 17:20 Uhr", "am 10.11.2016 abends 17:20 Uhr"],
    ],
    [
        "Time[]{2018-02-01 06:48 (X/X)}",
        "2018-01-22T07:58",
        ["am 01.02.2018 morgens um 06.48 Uhr"],
    ],
    [
        "Time[]{2017-02-09 11:00 (X/X)}",
        "2017-01-27T07:41",
        ["am 09.02.2017 vormittags um 11:00 Uhr"],
    ],
    [
        "Time[]{2017-06-01 19:00 (X/X)}",
        "2017-03-28T08:06",
        ["am 01.06.2017 abends ca. 19.00 Uhr"],
    ],
    [
        "Time[]{2017-04-12 18:00 (X/X)}",
        "2017-04-05T12:42",
        ["am 12.04.2017 abends ca. 18.00 Uhr"],
    ],
    [
        "Time[]{2016-11-08 20:00 (X/X)}",
        "2016-10-28T07:29",
        ["am 08.11.2016 abends gegen 20 Uhr"],
    ],
    [
        "Time[]{2017-05-30 08:20 (X/X)}",
        "2017-05-11T11:58",
        ["um 08:20 Uhr Dienstag, 30.05.2017"],
    ],
    [
        "Interval[]{2018-03-26 X:X (X/X) - 2018-03-29 X:X (X/X)}",
        "2018-03-14T14:42",
        ["ab den 26.03.2018-29.03.2018", "ab den 26.03.2018-29.03.2018"],
    ],
    [
        "Time[]{2015-10-22 X:X (X/evening)}",
        "2015-10-19T15:13",
        ["am kommenden Donnerstag abends", "am kommenden Donnerstag abends"],
    ],
    [
        "Time[]{2018-05-28 14:05 (X/X)}",
        "2018-04-10T20:29",
        ["onMonday, 28.05.2018 14.05"],
    ],
    [
        "Interval[]{2017-06-02 X:X (X/X) - 2017-06-03 X:X (X/X)}",
        "2017-04-28T10:53",
        ["vom 02. - 03.06.2017"],
    ],
    [
        "Interval[]{2017-05-08 X:X (X/X) - 2017-05-10 X:X (X/X)}",
        "2017-03-29T06:38",
        ["vom 08. - 10.05.2017"],
    ],
    [
        "Interval[]{2018-04-08 X:X (X/X) - 2018-04-14 X:X (X/X)}",
        "2018-01-12T10:02",
        ["vom 08. - 14.04.2018"],
    ],
    [
        "Interval[]{2017-09-15 X:X (X/X) - 2017-09-16 X:X (X/X)}",
        "2017-08-14T13:04",
        ["vom 15. auf den 16.09.2017"],
    ],
    [
        "Interval[]{2017-02-01 X:X (X/X) - 2017-02-03 X:X (X/X)}",
        "2016-11-30T20:38",
        ["vom 01.-03. Februar 2017"],
    ],
    [
        "Interval[]{2017-03-14 X:X (X/X) - 2017-03-16 X:X (X/X)}",
        "2016-01-18T07:24",
        ["vom 14.-16.3.2017"],
    ],
    [
        "Interval[]{2018-06-05 X:X (X/X) - 2018-06-06 X:X (X/X)}",
        "2018-02-28T10:20",
        ["vom 05.-06.06.18"],
    ],
    [
        "Interval[]{2017-11-08 X:X (X/X) - 2017-11-09 X:X (X/X)}",
        "2017-10-06T14:27",
        ["vom 08.-09.11.2017"],
    ],
    [
        "Interval[]{2017-05-08 X:X (X/X) - 2017-05-12 X:X (X/X)}",
        "2016-09-02T08:40",
        ["vom 08.-12.05.2017"],
    ],
    [
        "Interval[]{2018-03-09 X:X (X/X) - 2018-03-11 X:X (X/X)}",
        "2018-01-08T08:51",
        ["vom 09.-11.03.2018"],
    ],
    [
        "Interval[]{2018-01-09 X:X (X/X) - 2018-01-12 X:X (X/X)}",
        "2017-11-15T13:15",
        ["vom 09.-12.01.2018"],
    ],
    [
        "Interval[]{2018-03-09 X:X (X/X) - 2018-03-12 X:X (X/X)}",
        "2018-01-08T08:51",
        ["vom 09.-12.03.2018"],
    ],
    [
        "Time[]{2016-09-02 X:X (X/morning)}",
        "2016-09-01T07:53",
        ["morgen Freitagvormittag", "morgen Freitagvormittag"],
    ],
    [
        "Time[]{2017-12-21 07:03 (X/X)}",
        "2017-12-14T08:21",
        ["n\u00e4chste Woche Do 7:03"],
    ],
    [
        "Time[]{2017-12-21 15:25 (X/X)}",
        "2017-12-14T08:21",
        ["n\u00e4chste Woche Do 15:25"],
    ],
    [
        "Time[]{2017-09-12 17:44 (X/X)}",
        "2017-09-07T07:51",
        ["n\u00e4chste Woche Dienstag 17:44"],
    ],
    ["Time[]{2018-01-29 09:15 (X/X)}", "2018-01-22T12:56", ["next Monday 9.15"]],
    ["Time[]{2016-06-30 07:05 (X/X)}", "2016-06-28T11:00", ["diesen Donnerstag 7:05"]],
    [
        "Time[]{2017-06-19 09:30 (X/X)}",
        "2017-06-16T11:26",
        ["kommenden Montag 9:30 Uhr"],
    ],
    ["Time[]{2017-01-08 14:00 (X/X)}", "2017-01-04T16:49", ["diesen Sonntag 14 Uhr"]],
    ["Time[]{2017-09-28 10:00 (X/X)}", "2017-09-26T16:18", ["diesen Donnerstag 10:00"]],
    ["Time[]{2017-10-11 18:39 (X/X)}", "2017-10-11T07:28", ["heute Abend um 18:39"]],
    [
        "Time[]{2017-03-23 16:36 (X/X)}",
        "2017-03-22T09:18",
        ["morgen Nachmittag um 16:36 Uhr"],
    ],
    [
        "Time[]{2016-10-11 X:X (X/evening)}",
        "2016-10-06T09:06",
        ["kommenden Dienstag abends", "kommenden Dienstag abends"],
    ],
    [
        "Time[]{2016-10-11 X:X (X/morning)}",
        "2016-10-06T09:06",
        ["kommenden Dienstag morgens"],
    ],
    [
        "Time[]{2017-09-21 08:30 (X/X)}",
        "2017-09-18T13:35",
        ["diesen Donnerstag, 21.09. 08:30 Uhr", "diesen Donnerstag, 21.09. 08:30 Uhr"],
    ],
    [
        "Time[]{2018-01-23 X:X (X/X)}",
        "2018-01-22T13:41",
        ["morgen 23.01", "morgen 23.01"],
    ],
    [
        "Interval[]{2017-01-18 X:X (X/X) - 2017-01-20 X:X (X/X)}",
        "2017-01-18T12:52",
        ["heute bis Freitag"],
    ],
    ["Time[]{2016-12-09 09:45 (X/X)}", "2016-12-02T13:36", ["next week Fri 0945"]],
    [
        "Time[]{2016-10-19 09:20 (X/X)}",
        "2016-10-17T09:55",
        ["this wednesday the 19th 0920", "this wednesday the 19th 0920"],
    ],
    [
        "Interval[]{2017-06-14 18:00 (X/X) - None}",
        "2017-05-24T11:13",
        ["Am 14.06.2017 fr\u00fchestens 18:00 Uhr"],
    ],
    ["Time[]{2017-03-07 X:X (X/X)}", "2017-03-06T13:23", ["Di. 07."]],
    ["Time[]{2016-09-13 X:X (X/X)}", "2016-09-12T20:07", ["Di. 13.09"]],
    ["Time[]{2017-02-14 X:X (X/X)}", "2017-02-13T15:54", ["Di. 14.02"]],
    [
        "Interval[]{2017-09-26 X:X (X/X) - 2017-09-27 X:X (X/X)}",
        "2017-08-31T16:34",
        ["Di., 26.09.-27.09., 1 Nacht"],
    ],
    [
        "Interval[]{2018-02-23 X:X (X/X) - 2018-02-24 X:X (X/X)}",
        "2018-02-14T16:04",
        ["Fr.-Sa., 23.02.-24.02., 1 Nacht"],
    ],
    ["Time[]{2016-12-03 X:X (X/X)}", "2016-11-30T13:23", ["Samstag 3.12"]],
    ["Time[]{2016-10-14 X:X (X/X)}", "2016-10-09T08:56", ["Friday 14"]],
    ["Time[]{2016-10-11 X:X (X/X)}", "2016-10-04T10:52", ["Tuesday 11"]],
    ["Time[]{2017-07-18 X:X (X/X)}", "2017-07-06T12:42", ["Dienstag 18.7."]],
    ["Time[]{2016-06-28 X:X (X/X)}", "2016-06-13T08:26", ["Dienstag 28.6."]],
    ["Time[]{2017-06-15 X:X (X/X)}", "2017-06-07T11:25", ["Donnerstag 15.6."]],
    ["Time[]{2017-07-20 X:X (X/X)}", "2017-07-12T20:49", ["Donnerstag 20.7."]],
    ["Time[]{2017-08-17 16:15 (X/X)}", "2017-08-10T09:11", ["Donnerstag 17.8. 16:15"]],
    ["Time[]{2018-01-23 X:X (X/evening)}", "2018-01-23T10:48", ["Abends 23.01"]],
    [
        "Time[]{2018-04-03 X:X (X/X)}",
        "2018-03-29T10:31",
        ["Dienstag 03.04", "Dienstag, 03.04"],
    ],
    [
        "Time[]{2017-06-20 X:X (X/X)}",
        "2017-06-19T07:04",
        ["Dienstag 20.06", "Dienstag, 20.06", "am Dienstag 20.06"],
    ],
    ["Time[]{2017-03-02 X:X (X/X)}", "2017-02-13T11:00", ["Donnerstag 02.03"]],
    ["Time[]{2017-12-07 X:X (X/X)}", "2017-11-27T10:53", ["Donnerstag 07.12"]],
    ["Time[]{2017-08-02 X:X (X/X)}", "2017-07-10T07:29", ["Mittwoch 02.08"]],
    ["Time[]{2017-06-07 X:X (X/X)}", "2017-06-04T20:23", ["Mittwoch 07.06"]],
    ["Time[]{2017-12-13 X:X (X/X)}", "2017-12-07T13:33", ["Mittwoch 13.12"]],
    [
        "Time[]{2017-08-23 X:X (X/X)}",
        "2017-08-16T13:00",
        ["Mittwoch 23.08", "Dienstag, 23.08", "am Mittwoch, 23.08"],
    ],
    ["Time[]{2017-10-25 X:X (X/X)}", "2017-10-10T12:06", ["Mittwoch 25.10"]],
    ["Time[]{2017-09-11 X:X (X/X)}", "2017-09-08T20:54", ["Monday 11.09"]],
    ["Time[]{2017-06-19 X:X (X/X)}", "2017-05-24T08:15", ["Monday 19.06"]],
    ["Time[]{2018-03-15 X:X (X/X)}", "2018-01-23T11:31", ["Donnerstag 15.03."]],
    ["Time[]{2018-04-04 X:X (X/X)}", "2018-03-27T08:41", ["Mittwoch, 4.4."]],
    [
        "Time[]{2016-09-23 X:X (X/X)}",
        "2016-09-20T08:45",
        ["Freitag, 23. September 2016"],
    ],
    ["Time[]{2017-07-25 X:X (X/X)}", "2017-05-30T09:59", ["Dienstag, 25.07"]],
    ["Time[]{2017-08-17 X:X (X/X)}", "2017-08-09T08:02", ["Donnerstag, 17.08"]],
    [
        "Interval[]{2017-10-05 09:45 (X/X) - 2017-10-05 10:55 (X/X)}",
        "2017-09-28T07:55",
        ["Donnerstag, den 5.10.2017 09:45 - 10:55 Uhr"],
    ],
    ["Time[]{2018-01-07 X:X (X/X)}", "2017-12-19T09:24", ["7. Januar 2018"]],
    ["Time[]{2017-10-26 X:X (X/X)}", "2017-10-17T18:14", ["26 Oct 2017"]],
    ["Time[]{2018-05-24 14:55 (X/X)}", "2018-04-10T08:46", ["24 of May at 14.55"]],
    ["Time[]{2018-04-25 12:00 (X/X)}", "2018-04-05T09:18", ["25 of April at 12.00"]],
    ["Time[]{2017-05-22 X:X (X/X)}", "2017-05-04T16:28", ["22. Mai 2017"]],
    ["Time[]{2016-07-15 X:X (X/X)}", "2016-06-20T10:03", ["15. Juli 16"]],
    ["Time[]{2018-06-14 X:X (X/X)}", "2018-03-08T11:34", ["14. Juni 2018"]],
    ["Time[]{2018-02-14 X:X (X/X)}", "2017-12-19T09:24", ["14. Februar 2018"]],
    ["Time[]{2018-03-14 X:X (X/X)}", "2018-03-12T16:48", ["14. 03."]],
    [
        "Interval[]{2018-04-10 X:X (X/X) - 2018-04-11 X:X (X/X)}",
        "2018-04-05T10:08",
        ["10.04. - 11.04., 1 Nacht"],
    ],
    ["Time[]{2018-01-18 15:30 (X/X)}", "2018-01-18T13:11", ["18.01. 15:30 Uhr"]],
    [
        "Interval[]{2017-10-06 X:X (X/X) - 2017-10-07 X:X (X/X)}",
        "2017-09-22T12:53",
        ["06.10.-07.10., 1 Nacht"],
    ],
    [
        "Interval[]{2017-12-06 X:X (X/X) - 2017-12-07 X:X (X/X)}",
        "2017-11-24T14:27",
        ["06.12.2017 to 07.12.2017 (1 night"],
    ],
    [
        "Interval[]{2018-03-09 09:00 (X/X) - 2018-03-09 10:00 (X/X)}",
        "2018-02-20T09:37",
        ["09.03.2018 ca. 9-10 Uhr"],
    ],
    [
        "Interval[]{2017-07-06 14:00 (X/X) - 2017-07-06 15:00 (X/X)}",
        "2017-06-21T12:02",
        ["06.07.2017 ca. 14-15 Uhr"],
    ],
    ["Time[]{2017-09-15 02:35 (X/X)}", "2017-08-11T13:10", ["02:35 Fr. 15 Sep 2017"]],
    ["Time[]{2017-09-15 07:20 (X/X)}", "2017-08-11T13:10", ["07:20 Fr. 15 Sep 2017"]],
    [
        "Time[]{2016-11-11 10:00 (X/X)}",
        "2016-11-09T13:16",
        ["10:00 Fri, 11 Nov 2016Journey"],
    ],
    [
        "Time[]{2018-05-09 04:00 (X/X)}",
        "2018-03-26T11:11",
        ["04:00 Wednesday, 9 May 2018"],
    ],
    [
        "Time[]{2018-05-09 08:40 (X/X)}",
        "2018-03-26T11:11",
        ["08:40 Wednesday, 9 May 2018"],
    ],
    [
        "Time[]{2018-03-01 08:30 (X/X)}",
        "2018-02-19T15:04",
        ["08:30 Thursday, 1 March 2018"],
    ],
    [
        "Time[]{2018-05-12 05:00 (X/X)}",
        "2018-03-26T11:11",
        ["05:00 Saturday, 12 May 2018"],
    ],
    [
        "Time[]{2018-05-12 07:45 (X/X)}",
        "2018-03-26T11:11",
        ["07:45 Saturday, 12 May 2018"],
    ],
    [
        "Time[]{2018-05-12 10:25 (X/X)}",
        "2018-03-26T11:11",
        ["10:25 Saturday, 12 May 2018"],
    ],
    [
        "Time[]{2018-05-17 11:40 (X/X)}",
        "2018-03-26T11:11",
        ["11:40 Thursday, 17 May 2018"],
    ],
    [
        "Time[]{2017-01-12 20:45 (X/X)}",
        "2017-01-03T07:56",
        ["20:45 Donnerstag, 12 Januar"],
    ],
    [
        "Time[]{2018-02-27 00:15 (X/X)}",
        "2018-02-19T15:04",
        ["00:15 Tuesday, 27 February 2018"],
    ],
    [
        "Time[]{2017-11-24 11:05 (X/X)}",
        "2017-11-14T08:41",
        ["11:05 Friday, 24 November 2017"],
    ],
    ["Time[]{2017-11-07 X:X (X/X)}", "2017-11-06T08:59", ["7th November 2017"]],
    ["Time[]{2018-03-31 X:X (X/X)}", "2018-03-11T21:48", ["am Freitag 31.3."]],
    ["Time[]{2017-12-12 X:X (X/X)}", "2017-12-06T12:11", ["am Dienstag 12.12"]],
    ["Time[]{2018-03-16 X:X (X/X)}", "2018-02-19T08:56", ["am Freitag 16.03"]],
    ["Time[]{2017-05-17 X:X (X/X)}", "2017-05-12T11:37", ["am Mittwoch 17.05"]],
    ["Time[]{2016-09-14 X:X (X/X)}", "2016-09-02T05:48", ["am Mittwoch 14.09."]],
    ["Time[]{2017-06-05 X:X (X/X)}", "2017-05-27T08:01", ["am Montag 05.06."]],
    ["Time[]{2018-03-23 X:X (X/X)}", "2018-03-14T10:42", ["on Friday 23/03"]],
    ["Time[]{2018-01-22 X:X (X/X)}", "2018-01-15T13:05", ["on Monday 22nd January"]],
    ["Time[]{2016-03-31 X:X (X/X)}", "2016-03-09T15:20", ["am Donnerstag, 31.03."]],
    [
        "Time[]{2017-09-14 07:05 (X/X)}",
        "2017-09-11T05:57",
        ["am Donnerstag, 14.09.17 07:05"],
    ],
    ["Time[]{2017-05-18 X:X (X/X)}", "2017-04-22T19:02", ["am Donnerstag, den 18.05."]],
    ["Time[]{2016-03-17 X:X (X/X)}", "2016-03-11T09:15", ["am 17. M\u00e4rz 2016"]],
    [
        "Interval[]{2016-03-16 16:45 (X/X) - None}",
        "2016-02-25T12:48",
        ["am 16.3.16 fr\u00fchestens 16:45 Uhr"],
    ],
    ["Time[]{2017-09-21 X:X (X/X)}", "2017-09-12T10:23", ["am 21.09 (Donnerstag"]],
    [
        "Time[]{2017-03-07 12:00 (X/X)}",
        "2017-02-08T08:08",
        ["am 07.03.17 Mittag 12 Uhr"],
    ],
    [
        "Time[]{2017-12-06 X:X (X/lateafternoon)}",
        "2017-11-23T07:22",
        ["am 06.12.2017 Sp\u00e4tnachmittag"],
    ],
    [
        "Interval[]{2017-06-12 18:00 (X/X) - 2017-06-12 19:05 (X/X)}",
        "2017-06-08T11:07",
        ["am 12.06.2017 18:00 - 19:05"],
    ],
    [
        "Time[]{2016-11-09 X:X (X/lateevening)}",
        "2016-11-07T08:10",
        ["am 09.11.2016 sp\u00e4t Abends"],
    ],
    [
        "Interval[]{2018-03-09 17:00 (X/X) - None}",
        "2018-02-15T14:47",
        ["am 09.03.2018 fr\u00fchstens 17 Uhr"],
    ],
    [
        "Time[]{2017-09-14 X:X (X/earlymorning)}",
        "2017-09-05T10:10",
        ["am 14.09.2017 fr\u00fch morgens"],
    ],
    [
        "Interval[]{2017-05-16 X:X (X/X) - 2017-05-18 X:X (X/X)}",
        "2017-05-12T11:16",
        ["von Dienstag 16.05 bis Donnerstag 18.05"],
    ],
    [
        "Interval[]{2018-02-05 X:X (X/X) - 2018-02-08 X:X (X/X)}",
        "2018-02-03T09:20",
        ["von Montag 05.02 bis Donnerstag 08.02"],
    ],
    [
        "Interval[]{2018-02-24 X:X (X/X) - 2018-02-26 X:X (X/X)}",
        "2018-02-07T16:28",
        ["vom Samstag, den 24.02.2018 bis Montag, den 26.02.2018"],
    ],
    ["Time[]{2017-06-23 X:X (X/X)}", "2017-06-22T07:20", ["morgen 23.06"]],
    [
        "Interval[]{2018-03-15 X:X (X/X) - 2018-03-16 X:X (X/X)}",
        "2018-03-05T12:51",
        ["between the 15-16"],
    ],
    [
        "Interval[]{2017-11-28 13:13 (X/X) - 2017-11-28 13:44 (X/X)}",
        "2017-11-27T15:14",
        ["morgen, 28.11.2017 um 13:13 - 13:44 Uhr"],
    ],
    ["Time[]{1993-07-02 X:X (X/X)}", "2017-11-27T15:14", ["2 jul 93"]],
    ["Time[]{2022-07-02 X:X (X/X)}", "2017-11-27T15:14", ["2 jul 22"]],
    [
        "Interval[]{2018-06-07 X:X (X/evening) - 2018-06-07 X:X (X/night)}",
        "2018-05-08T16:32",
        ["at 7.6 evening/night"],
    ],
]
