# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataSourcePermissionArgs', 'DataSourcePermission']

@pulumi.input_type
class DataSourcePermissionArgs:
    def __init__(__self__, *,
                 datasource_id: pulumi.Input[int],
                 permissions: pulumi.Input[Sequence[pulumi.Input['DataSourcePermissionPermissionArgs']]]):
        """
        The set of arguments for constructing a DataSourcePermission resource.
        :param pulumi.Input[int] datasource_id: ID of the datasource to apply permissions to.
        :param pulumi.Input[Sequence[pulumi.Input['DataSourcePermissionPermissionArgs']]] permissions: The permission items to add/update. Items that are omitted from the list will be removed.
        """
        pulumi.set(__self__, "datasource_id", datasource_id)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="datasourceId")
    def datasource_id(self) -> pulumi.Input[int]:
        """
        ID of the datasource to apply permissions to.
        """
        return pulumi.get(self, "datasource_id")

    @datasource_id.setter
    def datasource_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "datasource_id", value)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Sequence[pulumi.Input['DataSourcePermissionPermissionArgs']]]:
        """
        The permission items to add/update. Items that are omitted from the list will be removed.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Sequence[pulumi.Input['DataSourcePermissionPermissionArgs']]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class _DataSourcePermissionState:
    def __init__(__self__, *,
                 datasource_id: Optional[pulumi.Input[int]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['DataSourcePermissionPermissionArgs']]]] = None):
        """
        Input properties used for looking up and filtering DataSourcePermission resources.
        :param pulumi.Input[int] datasource_id: ID of the datasource to apply permissions to.
        :param pulumi.Input[Sequence[pulumi.Input['DataSourcePermissionPermissionArgs']]] permissions: The permission items to add/update. Items that are omitted from the list will be removed.
        """
        if datasource_id is not None:
            pulumi.set(__self__, "datasource_id", datasource_id)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="datasourceId")
    def datasource_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the datasource to apply permissions to.
        """
        return pulumi.get(self, "datasource_id")

    @datasource_id.setter
    def datasource_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "datasource_id", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSourcePermissionPermissionArgs']]]]:
        """
        The permission items to add/update. Items that are omitted from the list will be removed.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSourcePermissionPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)


class DataSourcePermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datasource_id: Optional[pulumi.Input[int]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSourcePermissionPermissionArgs']]]]] = None,
                 __props__=None):
        """
        * [HTTP API](https://grafana.com/docs/grafana/latest/http_api/datasource_permissions/)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        team = grafana.Team("team")
        foo = grafana.DataSource("foo",
            type="cloudwatch",
            json_datas=[grafana.DataSourceJsonDataArgs(
                default_region="us-east-1",
                auth_type="keys",
            )],
            secure_json_datas=[grafana.DataSourceSecureJsonDataArgs(
                access_key="123",
                secret_key="456",
            )])
        foo_permissions = grafana.DataSourcePermission("fooPermissions",
            datasource_id=foo.id,
            permissions=[
                grafana.DataSourcePermissionPermissionArgs(
                    team_id=team.id,
                    permission="Query",
                ),
                grafana.DataSourcePermissionPermissionArgs(
                    user_id=3,
                    permission="Query",
                ),
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] datasource_id: ID of the datasource to apply permissions to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSourcePermissionPermissionArgs']]]] permissions: The permission items to add/update. Items that are omitted from the list will be removed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSourcePermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [HTTP API](https://grafana.com/docs/grafana/latest/http_api/datasource_permissions/)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        team = grafana.Team("team")
        foo = grafana.DataSource("foo",
            type="cloudwatch",
            json_datas=[grafana.DataSourceJsonDataArgs(
                default_region="us-east-1",
                auth_type="keys",
            )],
            secure_json_datas=[grafana.DataSourceSecureJsonDataArgs(
                access_key="123",
                secret_key="456",
            )])
        foo_permissions = grafana.DataSourcePermission("fooPermissions",
            datasource_id=foo.id,
            permissions=[
                grafana.DataSourcePermissionPermissionArgs(
                    team_id=team.id,
                    permission="Query",
                ),
                grafana.DataSourcePermissionPermissionArgs(
                    user_id=3,
                    permission="Query",
                ),
            ])
        ```

        :param str resource_name: The name of the resource.
        :param DataSourcePermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSourcePermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datasource_id: Optional[pulumi.Input[int]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSourcePermissionPermissionArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSourcePermissionArgs.__new__(DataSourcePermissionArgs)

            if datasource_id is None and not opts.urn:
                raise TypeError("Missing required property 'datasource_id'")
            __props__.__dict__["datasource_id"] = datasource_id
            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
        super(DataSourcePermission, __self__).__init__(
            'grafana:index/dataSourcePermission:DataSourcePermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            datasource_id: Optional[pulumi.Input[int]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSourcePermissionPermissionArgs']]]]] = None) -> 'DataSourcePermission':
        """
        Get an existing DataSourcePermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] datasource_id: ID of the datasource to apply permissions to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSourcePermissionPermissionArgs']]]] permissions: The permission items to add/update. Items that are omitted from the list will be removed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataSourcePermissionState.__new__(_DataSourcePermissionState)

        __props__.__dict__["datasource_id"] = datasource_id
        __props__.__dict__["permissions"] = permissions
        return DataSourcePermission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="datasourceId")
    def datasource_id(self) -> pulumi.Output[int]:
        """
        ID of the datasource to apply permissions to.
        """
        return pulumi.get(self, "datasource_id")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence['outputs.DataSourcePermissionPermission']]:
        """
        The permission items to add/update. Items that are omitted from the list will be removed.
        """
        return pulumi.get(self, "permissions")

