# constant.py
# 存放全局变量以及检查文件

import os

DATA_PATH = "data/nodice"


def load_const() -> None:
    if not os.path.exists("data"):
        os.mkdir("data")
    if not os.path.exists("data/nodice"):
        os.mkdir("data/nodice")

    if not os.path.exists("data/nodice/deck"):
        os.mkdir("data/nodice/deck")
    if not os.path.exists("data/nodice/CustomMsg.hjson"):
        with open("data/nodice/CustomMsg.hjson", "w", encoding="utf-8") as f:
            f.write(CustomMsg)
    if not os.path.exists("data/nodice/HelpDoc.hjson"):
        with open("data/nodice/HelpDoc.hjson", "w", encoding="utf-8") as f:
            f.write(HelpDoc)
    if not os.path.exists("data/nodice/deck/insane.json"):
        with open("data/nodice/deck/insane.json", "w", encoding="utf-8") as f:
            f.write(insane)
    if not os.path.exists("data/nodice/deck/name.json"):
        with open("data/nodice/deck/name.json", "w", encoding="utf-8") as f:
            f.write(name)
    if not os.path.exists("data/nodice/deck/tarot.json"):
        with open("data/nodice/deck/tarot.json", "w", encoding="utf-8") as f:
            f.write(tarot)


CustomMsg = r"""{
	"strParaEmpty":"参数不能为空×", //偷懒用万能回复
	"strParaIllegal":"参数非法×", //偷懒用万能回复
	"stranger":"用户", //{nick}无法获取非空昵称时的称呼
	"strAdminOptionEmpty":"找{self}有什么事么？{nick}",
	"strLogNew":"{self}开始新日志记录√\n请适时用.log off暂停或.log end完成记录",
	"strLogOn":"{self}开始日志记录√\n可使用.log off暂停记录",
	"strLogOnAlready":"{self}正在记录中！",
	"strLogOff":"{self}已暂停日志记录√\n可使用.log on恢复记录",
	"strLogOffAlready":"{self}已经暂停记录！",
	"strLogEnd":"{self}已完成日志记录√\n正在上传日志文件{log_file}",
	"strLogEndEmpty":"{self}已结束记录√\n本次无日志产生",
	"strLogNullErr":"{self}无日志记录或已结束！",
	"strLogUpSuccess":"{self}已完成日志上传√\n请访问 https://logpainter.kokona.tech/?s3={log_file} 以查看记录",
	"strLogUpFailure":"{self}上传日志文件失败，正在第{retry}次重试…{ret}",
	"strLogUpFailureEnd":"很遗憾，{self}无法成功上传日志文件×\n{ret}\n如需获取可联系Master:{master_QQ}\n文件名:{log_file}",
	"strGMTableShow":"{self}记录的{table_name}列表: {res}",
	"strGMTableClr":"{self}已清除{table_name}表√",
	"strGMTableItemDel":"{self}已移除{table_name}表的项目{table_item}√",
	"strGMTableNotExist":"{self}没有保存{table_name}表×",
	"strGMTableItemNotFound":"{self}没有找到{table_name}表的项目{table_item}×",
	"strGMTableItemEmpty":"请告知{self}待移除的{table_name}列表项目×",
	"strUserTrustShow":"{user}在{self}处的信任级别为{trust}",
	"strUserTrusted":"已将{self}对{user}的信任级别调整为{trust}",
	"strUserTrustDenied":"{nick}在{self}处无权访问对方的权限×",
	"strUserTrustIllegal":"将目标权限修改为{trust}是非法的×",
	"strUserNotFound":"{self}无{user}的用户记录",
	"strGroupAuthorized":"A roll to the table turns to a dice fumble!\nDice Roller {strSelfName}√\n本群已授权许可，请尽情使用本骰娘√\n请遵守协议使用，服务结束后使用.dismiss送出!",
	"strGroupLicenseDeny":"本群未获{self}许可使用，自动在群内静默。\n请先.help协议 阅读并同意协议后向运营方申请许可使用，\n否则请管理员使用!dismiss送出{self}\n可按以下格式填写并发送申请:\n!authorize 申请用途:[ **请写入理由** ] 我已了解Dice!基本用法，仔细阅读并保证遵守{strSelfName}的用户协议，如需停用指令使用[ **请写入指令** ]，用后使用[ **请写入指令** ]送出群",
	"strGroupLicenseApply":"此群未通过自助授权×\n许可申请已发送√",
	"strGroupSetOn":"现已开启{self}在此群的“{option}”选项√", //群内开关和遥控开关通用此文本
	"strGroupSetOnAlready":"{self}已在此群设置了{option}！",			
	"strGroupSetOff":"现已关闭{self}在此群的“{option}”选项√",			
	"strGroupSetOffAlready":"{self}未在此群设置{option}！",
	"strGroupSetAll":"{self}已修改记录中{cnt}个群的“{option}”选项√",
	"strGroupDenied":"{nick}在{self}处无权访问此群的设置×",
	"strGroupSetDenied":"{nick}在{self}处设置{option}的权限不足×",
	"strGroupSetNotExist":"{self}无{option}此选项×",
	"strGroupWholeUnban":"{self}已关闭全局禁言√",
	"strGroupWholeBan":"{self}已开启全局禁言√",
	"strGroupWholeBanErr":"{self}开启全局禁言失败×",
	"strGroupUnban":"{self}裁定:{member}解除禁言√",
	"strGroupBan":"{self}裁定:{member}禁言{res}分钟√",
	"strGroupNotFound":"{self}无该群记录×",
	"strGroupNot":"{group}不是群！",
	"strGroupNotIn":"{self}当前不在{group}内×",
	"strGroupExit":"{self}已退出该群√",
	"strGroupCardSet":"{self}已将{target}的群名片修改为{card}√",
	"strGroupTitleSet":"{self}已将{target}的头衔修改为{title}√",
	"strPcNewEmptyCard":"已为{nick}新建{type}空白卡{char}√",
	"strPcNewCardShow":"已为{nick}新建{type}卡{char}：{show}", //由于预生成选项而存在属性
	"strPcCardSet":"已将{nick}当前角色卡绑定为{char}√", //{nick}-用户昵称 {pc}-原角色卡名 {char}-新角色卡名
	"strPcCardReset":"已解绑{nick}当前的默认卡√", //{nick}-用户昵称 {pc}-原角色卡名
	"strPcCardRename":"已将{old_name}重命名为{new_name}√",
	"strPcCardDel":"已将角色卡{char}删除√",
	"strPcCardCpy":"已将{char2}的属性复制到{char1}√",
	"strPcClr":"已清空{nick}的角色卡记录√",
	"strPcCardList":"{nick}的角色列表：{show}",
	"strPcCardBuild":"{nick}的{char}生成：{show}",
	"strPcCardShow":"{nick}的<{type}>{char}：{show}", //{nick}-用户昵称 {type}-角色卡类型 {char}-角色卡名
	"strPcCardRedo":"{nick}的{char}重新生成：{show}",
	"strPcGroupList":"{nick}的各群角色列表：{show}",
	"strPcNotExistErr":"{self}无{nick}的角色卡记录，无法删除×",
	"strPcCardFull":"{nick}在{self}处的角色卡已达上限，请先清理多余角色卡×",
	"strPcTempInvalid":"{self}无法识别的角色卡模板×",
	"strPcNameEmpty":"名称不能为空×",
	"strPcNameExist":"{nick}已存在同名卡×",
	"strPcNameNotExist":"{nick}无该名称角色卡×",
	"strPcNameInvalid":"非法的角色卡名（存在冒号）×",
	"strPcInitDelErr":"{nick}的初始卡不可删除×",
	"strPcNoteTooLong":"备注长度不能超过255×",
	"strPcTextTooLong":"文本长度不能超过48×",
	"strCOCBuild":"{pc}的调查员作成:{res}",
	"strDNDBuild":"{pc}的英雄作成:{res}",
	"strCensorCaution":"提醒：{nick}的指令包含敏感词，{self}已上报",
	"strCensorWarning":"警告：{nick}的指令包含敏感词，{self}已记录并上报！",
	"strCensorDanger":"警告：{nick}的指令包含敏感词，{self}拒绝指令并已上报！",
	//"strCensorCritical":"警告：{nick}的指令包含敏感词，{self}已记录并上报！",
	"strSpamFirstWarning":"你短时间内对{self}指令次数过多！请善用多轮掷骰和复数生成指令（刷屏初次警告）",
	"strSpamFinalWarning":"请暂停你的一切指令，避免因高频指令被{self}拉黑！（刷屏最终警告）",
	"strReplySet":"{self}对关键词{key}的回复已设置√",
	"strReplyDel":"{self}对关键词{key}的回复已清除√",
	"strStModify":"{self}对已记录{pc}的属性变化:", //存在技能值变化情况时，优先使用此文本
	"strStDetail":"{self}对已设置{pc}的属性：", //存在掷骰时，使用此文本(暂时无用)
	"strStValEmpty":"{self}未记录{attr}原值×",		
	"strBlackQQAddNotice":"{user_nick}，你已被{self}加入黑名单，详情请联系Master:{master_QQ}",				
	"strBlackQQAddNoticeReason":"{user_nick}，由于{reason}，你已被{self}加入黑名单，申诉解封请联系管理员。Master:{master_QQ}",
	"strBlackQQDelNotice":"{user_nick}，你已被{self}移出黑名单，现在可以继续使用了",
	"strWhiteQQAddNotice":"{user_nick}，您已获得{self}的信任，请尽情使用{self}√",
	"strWhiteQQDenied":"你不是{self}信任的用户×",
	"strWhiteGroupDenied":"本群聊不在白名单中×",
	"strDeckNew":"{self}已为{nick}自定义新牌堆<{deck_name}>√",
	"strDeckSet":"{nick}已用<{deck_name}>创建{self}的牌堆实例√",
	"strDeckSetRename":"{nick}已用<{deck_cited}>创建{self}的牌堆实例{deck_name}√",
	"strDeckRestEmpty":"牌堆<{deck_name}>已抽空，请使用.deck reset {deck_name}手动重置牌堆",		
	"strDeckOversize":"{nick}定义的牌太多，{self}装不下啦×",
	"strDeckRestShow":"当前牌堆<{deck_name}>剩余卡牌:{deck_rest}",
	"strDeckRestReset":"{self}已重置牌堆实例<{deck_name}>√",
	"strDeckDelete":"{self}已移除牌堆实例<{deck_name}>√",
	"strDeckListShow":"在{self}处创建的牌堆实例有:{res}",
	"strDeckListClr":"{nick}已清空{self}处牌堆实例√",
	"strDeckListEmpty":"{self}处牌堆实例列表为空！",
	"strDeckNewEmpty":"{self}无法为{nick}新建虚空牌堆×",
	"strDeckListFull":"{self}处牌堆实例已达上限，请先清理无用实例×",
	"strDeckNotFound":"{self}找不到牌堆{deck_name}×",
	"strDeckCiteNotFound":"{self}找不到公共牌堆{deck_cited}×",
	"strDeckNameEmpty":"未指定牌堆名×",
	"strRangeEmpty":"{self}没法对着空气数数×",
	"strOutRange":"{nick}定义的数列超出{self}允许范围×",
	"strRollDice":"{pc}掷骰: {res}",
	"strRollDiceReason":"{pc}掷骰 {reason}: {res}",
	"strRollHidden":"{pc}进行了一次暗骰",
	"strRollTurn":"{pc}的掷骰轮数: {turn}轮",
	"strRollMultiDice":"{pc}掷骰{turn}次: {dice_exp}={res}",
	"strRollMultiDiceReason":"{pc}掷骰{turn}次{reason}: {dice_exp}={res}",
	"strRollSkill":"{pc}进行{attr}检定：",
	"strRollSkillReason":"由于{reason} {pc}进行{attr}检定：",
	"strRollSkillHidden":"{pc}进行了一次暗中{attr}检定√",
	"strEnRoll":"{pc}的{attr}增强或成长检定：\n{res}", //{attr}在用户省略技能名后替换为{strEnDefaultName}
	"strEnRollNotChange":"{strEnRoll}\n{pc}的{attr}值没有变化",
	"strEnRollFailure":"{strEnRoll}\n{pc}的{attr}变化{change}点，当前为{final}点",
	"strEnRollSuccess":"{strEnRoll}\n{pc}的{attr}增加{change}点，当前为{final}点",
	"strEnDefaultName":"属性或技能", //默认文本
	"strEnValEmpty":"未对{self}设定待成长属性值，请先.st {attr} 属性值 或查看.help en×",
	"strEnValInvalid":"{attr}值输入不正确,请输入1-99范围内的整数!",
	"strSendMsg":"{self}已将消息送出√", //Master定向发送的回执
	"strSendMasterMsg":"消息{self}已发送给Master√", //向Master发送的回执
	"strSendMsgEmpty":"发送消息内容为空×",
	"strSendMsgInvalid":"{self}没有可以发送的对象×", //没有Master
	"strDefaultCOCClr":"默认检定房规已清除√",
	"strDefaultCOCNotFound":"默认检定房规不存在×",
	"strDefaultCOCSet":"默认检定房规已设置:",
	"strLinked":"{self}已为对象建立链接√",
	"strLinkClose":"{self}已断开与对象的链接√" ,
	"strLinkBusy":"{nick}的目标已经有对象啦×\n{self}不支持多边关系" ,
	"strLinkedAlready":"{self}正在被其他对象链接×\n请{nick}先断绝当前关系",
	"strLinkingAlready":"{self}已经开启链接啦!",
	"strLinkCloseAlready":"{self}断开链接失败：{nick}当前本就没有对象",
	"strLinkNotFound":"{self}找不到{nick}的对象×",
	"strNotMaster":"你不是{self}的master！你想做什么？",
	"strNotAdmin":"你不是{self}的管理员×",
	"strAdminDismiss":"{strDismiss}", //管理员指令退群的回执
	"strDismiss":"", //.dismiss退群前的回执
	"strHlpSet":"已为{key}设置词条√",
	"strHlpReset":"已清除{key}的词条√",
	"strHlpNameEmpty":"Master想要自定义什么词条呀？",
	"strHelpNotFound":"{self}未找到【{help_word}】相关的词条×",
	"strHelpSuggestion":"{self}猜{nick}想要查找的是:{res}",
	"strHelpRedirect":"{self}仅找到相近词条【{redirect_key}】:\n{redirect_res}",
	"strClockToWork":"{self}已按时启用√",
	"strClockOffWork":"{self}已按时关闭√",
	"strNameGenerator":"{pc}的随机名称：{res}",
	"strDrawCard":"来看看{pc}抽到了什么：{res}",
	"strDrawHidden":"{pc}抽了{cnt}张手牌√",
	"strMeOn":"成功在这里启用{self}的.me命令√",
	"strMeOff":"成功在这里禁用{self}的.me命令√",
	"strMeOnAlready":"在这里{self}的.me命令没有被禁用!",
	"strMeOffAlready":"在这里{self}的.me命令已经被禁用!",
	"strObOn":"成功在这里启用{self}的旁观模式√",
	"strObOff":"成功在这里禁用{self}的旁观模式√",
	"strObOnAlready":"在这里{self}的旁观模式没有被禁用!",
	"strObOffAlready":"在这里{self}的旁观模式已经被禁用!",
	"strObList":"当前{self}的旁观者有:",
	"strObListEmpty":"当前{self}暂无旁观者",
	"strObListClr":"{self}成功删除所有旁观者√",
	"strObEnter":"{nick}成功加入{self}的旁观√",
	"strObExit":"{nick}成功退出{self}的旁观√",
	"strObEnterAlready":"{nick}已经处于{self}的旁观模式!",
	"strObExitAlready":"{nick}没有加入{self}的旁观模式!",
	"strQQIDEmpty":"QQ号不能为空×",
	"strGroupIDEmpty":"群号不能为空×",
	"strBlackGroup":"该群在黑名单中，如有疑问请联系master",
	"strBotOn":"成功开启{self}√",
	"strBotOff":"成功关闭{self}√",
	"strBotOnAlready":"{self}已经处于开启状态!",
	"strBotOffAlready":"{self}已经处于关闭状态!",
	"strRollCriticalSuccess":"大成功！", //一般检定用
	"strRollExtremeSuccess":"极难成功",
	"strRollHardSuccess":"困难成功",
	"strRollRegularSuccess":"成功",
	"strRollFailure":"失败",
	"strRollFumble":"大失败！",
	"strFumble":"大失败!", //多轮检定用，请控制长度
	"strFailure":"失败",
	"strSuccess":"成功",
	"strHardSuccess":"困难成功",
	"strExtremeSuccess":"极难成功",
	"strCriticalSuccess":"大成功!",
	"strNumCannotBeZero":"无意义的数目！莫要消遣于我!",
	"strDeckNotFound":"是说{deck_name}？{self}没听说过的牌堆名呢……",
	"strDeckEmpty":"{self}已经一张也不剩了！",
	"strNameNumTooBig":"生成数量过多!请输入1-10之间的数字!",
	"strNameNumCannotBeZero":"生成数量不能为零!请输入1-10之间的数字!",
	"strSetInvalid":"无效的默认骰!请输入1-9999之间的数字!",
	"strSetTooBig":"这面数……让我丢个球啊!请输入1-9999之间的数字!",
	"strSetCannotBeZero":"默认骰不能为零!请输入1-9999之间的数字!",
	"strCharacterCannotBeZero":"人物作成次数不能为零!请输入1-10之间的数字!",
	"strCharacterTooBig":"人物作成次数过多!请输入1-10之间的数字!",
	"strCharacterInvalid":"人物作成次数无效!请输入1-10之间的数字!",
	"strSanRoll":"{pc}的San Check：\n{res}",
	"strSanRollRes":"{strSanRoll}\n{pc}的San值减少{change}点,当前剩余{final}点",
	"strSanCostInvalid":"SC表达式输入不正确,格式为成功扣San/失败扣San,如1/1d6!",
	"strSanInvalid":"San值输入不正确,请输入1-99范围内的整数!",
	"strSanEmpty":"未设定San值，请先.st san 或查看.help sc×",
	"strSuccessRateErr":"这成功率还需要检定吗？",
	"strGroupIDInvalid":"无效的群号!",
	"strSendErr":"消息发送失败!",
	"strSendSuccess":"命令执行成功√",
	"strDisabledErr":"命令无法执行:机器人已在此群中被关闭!",
	"strActionEmpty":"动作不能为空×",
	"strMEDisabledErr":"管理员已在此群中禁用.me命令!",
	"strDisabledMeGlobal":"恕不提供.me服务×",
	"strDisabledJrrpGlobal":"恕不提供.jrrp服务×",
	"strDisabledDeckGlobal":"恕不提供.deck服务×",
	"strDisabledDrawGlobal":"恕不提供.draw服务×",
	"strDisabledSendGlobal":"恕不提供.send服务×",
	"strHELPDisabledErr":"管理员已在此群中禁用.help命令!",
	"strNameDelEmpty":"{nick}没有设置名称,无法删除!",
	"strValueErr":"掷骰表达式输入错误!",
	"strInputErr":"命令或掷骰表达式输入错误!",
	"strUnknownErr":"发生了未知错误!",
	"strUnableToGetErrorMsg":"无法获取错误信息!",
	"strDiceTooBigErr":"{self}被你扔出的骰子淹没了×",
	"strRequestRetCodeErr":"访问服务器时出现错误! HTTP状态码: {error}",
	"strRequestNoResponse":"服务器未返回任何信息×",
	"strTypeTooBigErr":"哇!让我数数骰子有多少面先~1...2...",
	"strZeroTypeErr":"这是...!!时空裂({self}被骰子产生的时空裂缝卷走了)",
	"strAddDiceValErr":"你这样要让{self}扔骰子扔到什么时候嘛~(请输入正确的加骰参数:5-10之内的整数)",
	"strZeroDiceErr":"咦?我的骰子呢?",
	"strRollTimeExceeded":"掷骰轮数超过了最大轮数限制!",
	"strRollTimeErr":"异常的掷骰轮数",
	"strDismissPrivate":"滚！",
	"strWelcomePrivate":"你在这欢迎谁呢？",
	"strWelcomeMsgClearNotice":"已清除本群的入群欢迎词√",
	"strWelcomeMsgClearErr":"没有设置入群欢迎词，清除失败×",
	"strWelcomeMsgUpdateNotice":"{self}已更新本群的入群欢迎词√",
	"strPermissionDeniedErr":"请让群内管理对{self}发送该指令×",
	"strSelfPermissionErr":"{self}权限不够无能为力呢×",
	"strNameTooLongErr":"名称过长×(最多为50英文字符)",
	"strNameClr":"已将{nick}的名称删除√",
	"strNameSet":"已将{nick}的名称更改为{new_nick}√",
	"strUnknownPropErr":"未设定{attr}成功率，请先.st {attr} 技能值 或查看.help rc×",
	"strEmptyWWDiceErr":"格式错误:正确格式为.w(w)XaY!其中X≥1, 5≤Y≤10",
	"strPropErr":"请认真的输入你的属性哦~",
	"strSetPropSuccess":"属性设置成功√",
	"strPropCleared":"已清空{char}的所有属性√",
	"strRuleReset":"已重置默认规则√",
	"strRuleSet":"已设置默认规则√",
	"strRuleErr":"规则数据获取失败,具体信息:\n",
	"strRulesFailedErr":"请求失败,{self}无法连接数据库×",
	"strPropDeleted":"已删除{pc}的{attr}√",
	"strPropNotFound":"属性{attr}不存在×",
	"strRuleNotFound":"{self}未找到对应的规则信息×",
	"strProp":"{pc}的{attr}为{val}",
	"strPropList":"{nick}的{char}属性列表为：{show}",
	"strStErr":"格式错误:请参考.help st获取.st命令的使用方法",
	"strRulesFormatErr":"格式错误:正确格式为.rules[规则名称:]规则条目 如.rules COC7:力量",
	"strLeaveDiscuss":"{self}现不支持讨论组服务，即将退出",
	"strLeaveNoPower":"{self}未获得群管理，即将退群",
	"strLeaveUnused":"{self}已经在这里被放置{day}天啦，马上就会离开这里了",
	"strGlobalOff":"{self}休假中，暂停服务×",
	"strPreserve":"{self}私有私用，勿扰勿怪\n如需申请许可请发送!authorize +[群号] 申请用途:[ **请写入理由** ] 我已了解Dice!基本用法，仔细阅读并保证遵守{strSelfName}的用户协议，如需停用指令使用[ **请写入指令** ]，用后使用[ **请写入指令** ]送出群",
	"strJrrp":"{nick}今天的人品值是: {res}",
	"strJrrpErr":"JRRP获取失败! 错误信息: \n{res}",
	"strFriendDenyNotUser":"很遗憾，你没有对{self}使用指令的记录",
	"strFriendDenyNoTrust":"很遗憾，你不是{self}信任的用户，如需使用可联系{master_QQ}",
	"strAddFriendWhiteQQ":"{strAddFriend}", //白名单用户添加好友时回复此句
  "strAddFriend":"欢迎选择{strSelfName}的免费掷骰服务！\n.help协议 确认服务协议\n.help指令 查看指令列表\n.help设定 确认骰娘设定\n.help链接 查看源码文档\n使用服务默认已经同意服务协议", //同意添加好友时额外发送的语句
	"strAddGroup":"欢迎选择{strSelfName}的免费掷骰服务！\n请使用.dismiss QQ号（或后四位） 使{self}退群退讨论组\n.bot on/off QQ号（或后四位） //开启或关闭指令\n.group +/-禁用回复 //禁用或启用回复\n.help协议 确认服务协议\n.help指令 查看指令列表\n.help设定 确认骰娘设定\n.help链接 查看源码文档\n邀请入群默认视为同意服务协议，知晓禁言或移出的后果", 
	"strNewMaster":"试问，你就是{strSelfName}的Master√\n请认真阅读当前版本Master手册以及用户手册。请注意版本号对应: https://v2docs.kokona.tech\f{strSelfName}默认开启对群移出、禁言、刷屏事件的监听，如要关闭请手动调整；\n请注意云黑系统默认开启，如无需此功能请关闭CloudBlackShare；",
	"strNewMasterPublic":"{strSelfName}初始化开启公骰模式：\n自动开启BelieveDiceList响应来自骰娘列表的warning；\n公骰模式默认同意有掷骰记录用户的好友邀请，如要改为同意任何人请使用.admin AllowStranger=2；\n已开启黑名单自动清理，拉黑时及每日定时会自动清理与黑名单用户的共同群聊，黑名单用户群权限不低于自己时自动退群；\n已开启拉黑群时连带邀请人；\n已启用send功能接收用户发送的消息；",
	"strNewMasterPrivate":"({strSelfName}默认开启私骰模式：\n默认拒绝陌生人的群邀请，只同意来自管理员、受信任用户的邀请；\n默认拒绝陌生人的好友邀请，如要同意请开启AllowStranger；\n已开启黑名单自动清理，拉黑时及每日定时会自动清理与黑名单用户的共同群聊，黑名单用户群权限高于自己时自动退群；\n.me功能默认不可用，需要手动开启；\n切换公用请使用.admin public，但不会初始化相应设置；\n可在.master delete后使用.master public来重新初始化；",
	"strSelfName":"",
	"strSelfCall":"&strSelfName",
	"self":"&strSelfCall",
	"strBotMsg":"\n使用.help更新 查看{self}更新内容",
	"strHlpMsg":"请使用.dismiss QQ号（或后四位） 使{self}退群退讨论组\n.bot on/off QQ号（或后四位） //开启或关闭指令\n.help协议 确认服务协议\n.help指令 查看指令列表\n.help群管 查看群管指令\n.help设定 确认骰娘设定\n.help链接 查看源码文档\n官方论坛: https://forum.kokona.tech/\n论坛导航贴: https://kokona.tech"
}"""

HelpDoc = r"""{
	"更新":"\n575:设置自我响应\n574:默认骰机制优化\n573:角色卡机制优化\n572:允许脚本读写角色卡\n571:更新框架，允许多开\n570:允许.lua脚本自定义指令\n569:.rc/.draw暗骰暗抽\n568:.deck自定义牌堆重做\n567:敏感词检测\n566:.help查询建议\n565:.log日志记录\n564:多功能优化，牌数牌堆等\n563:优化指令帮助\n562:新增GUI\n559:远程更新插件/不良记录\n557:定时作业系统\n554:新增多角色卡功能\n551:文件夹批量读取牌堆\n550:允许多轮检定\n549:新增刷屏监测",
	"协议":"0.本协议是Dice!默认服务协议。如果你看到了这句话，意味着Master应用默认协议，请注意。\n1.邀请骰娘、使用掷骰服务和在群内阅读此协议视为同意并承诺遵守此协议，否则请使用.dismiss移出骰娘。\n2.不允许禁言、移出骰娘或刷屏掷骰等对骰娘的不友善行为，这些行为将会提高骰娘被制裁的风险。开关骰娘响应请使用.bot on/off。\n3.骰娘默认邀请行为已事先得到群内同意，因而会自动同意群邀请。因擅自邀请而使骰娘遭遇不友善行为时，邀请者因未履行预见义务而将承担连带责任。\n4.禁止将骰娘用于赌博及其他违法犯罪行为。\n5.对于设置敏感昵称等无法预见但有可能招致言论审查的行为，骰娘可能会出于自我保护而拒绝提供服务\n6.由于技术以及资金原因，我们无法保证机器人100%的时间稳定运行，可能不定时停机维护或遭遇冻结，但是相应情况会及时通过各种渠道进行通知，敬请谅解。临时停机的骰娘不会有任何响应，故而不会影响群内活动，此状态下仍然禁止不友善行为。\n7.对于违反协议的行为，骰娘将视情况终止对用户和所在群提供服务，并将不良记录共享给其他服务提供方。黑名单相关事宜可以与服务提供方协商，但最终裁定权在服务提供方。\n8.本协议内容随时有可能改动。请注意帮助信息、签名、空间、官方群等处的骰娘动态。\n9.骰娘提供掷骰服务是完全免费的，欢迎投食。\n10.本服务最终解释权归服务提供方所有。",
	"链接":"Dice!论坛导航贴: https://kokona.tech \n Dice!论坛: https://forum.kokona.tech",
	"设定":"Master：{master_QQ}\n好友申请：需要使用记录\n入群邀请：黑名单制，非黑即入\n讨论组使用：允许\n移出反制：拉黑群和操作者\n禁言反制：默认拉黑群和群主\n刷屏反制：警告\n邀请人责任：有限连带\n窥屏可能：{窥屏可能}\n其他插件：{其他插件}{姐妹骰}\n骰娘用户群:{骰娘用户群}\n官方(水)群: 882747577\n私骰分享群：863062599 192499947\n开发交流群：1029435374",
	"骰娘用户群":"【未设置】",
	"窥屏可能":"无",
	"其他插件":"【未设置】",
	"姐妹骰":"{list_dice_sister}",
	"作者":"Copyright (C) 2018-2020 w4123溯洄\nCopyright (C) 2019-2020 String.Empty",
	"指令第一页":"at骰娘后接指令可以指定骰娘单独响应，如at骰娘.bot off\n多数指令需要后接参数，请.help对应指令 获取详细信息，如.help jrrp\n控制指令:\n.dismiss 退群\n.bot 版本信息\n.bot on 启用指令\n.bot off 停用指令\n.group 群管\n.authorize 授权许可\n.send 向后台发送消息",
	"指令第二页":".rules 规则速查\n.r 掷骰\n.log 日志记录\n.ob 旁观模式\n.set 设置默认骰\n.coc COC人物作成\n.dnd DND人物作成\n.st 属性记录\n.pc 角色卡记录\n.rc 检定\n.setcoc 设置检定房规\n.sc 理智检定\n.en 成长检定\n.ri 先攻\n.init 先攻列表\n.ww 骰池",
	"指令第三页":".nn 设置昵称\n.draw 抽牌\n.deck 牌堆实例\n.name 随机姓名\n.jrrp 今日人品\n.welcome 入群欢迎\n.me 第三人称动作\n为了避免未预料到的指令误判，请尽可能在参数之间使用空格)",
	"master":"当前Master:{master_QQ}\nMaster拥有最高权限，且可以调整任意信任)",
	"log":"跑团日志记录\n.log new 新建日志并开始记录\n.log on 开始记录\n.log off 暂停记录\n.log end 完成记录并发送日志文件\n日志上传存在失败可能，届时请联系后台管理索取",
	"deck":"牌堆实例.deck\n该指令可以在群内自设牌堆，使用.draw时，牌堆实例优先级高于同名公共对象\n抽牌不会放回直到抽空\n每个群的牌堆列表至多保存10个牌堆\n.deck set ([牌堆实例名]=)[公共牌堆名] //从公共牌堆创建实例\n.deck set ([牌堆实例名]=)member //从群成员列表创建实例\n.deck set ([牌堆实例名]=)range [下限] [上限] //创建等差数列作为实例\n.deck show //查看牌堆实例列表\n.deck show [牌堆名] //查看剩余卡牌\n.deck reset [牌堆名] //重置剩余卡牌\n.deck clr //清空所有实例\n.deck new [牌堆名]=[卡面1](...|[卡面n])	//自定义牌堆\n例:\n.deck new 俄罗斯轮盘=有弹|无弹|无弹|无弹|无弹|无弹\n除show外其他群内操作需要用户信任或管理权限",
	"退群":"&dismiss",
	"退群指令":"&dismiss",
	"dismiss":"该指令需要群管理员权限，使用后即退出群聊\n!dismiss [目标QQ(完整或末四位)]指名退群\n!dismiss无视内置黑名单和静默状态，只要插件开启总是有效",
	"授权许可":"&authoize",
	"authorize":"授权许可(非信任用户使用时转为向管理申请许可)\n!authorize (+[群号]) ([申请理由])\n群内原地发送可省略群号，无法自动授权时会连同理由发给管理\n默认格式为:!authorize 申请用途:[ **请写入理由** ] 我已了解Dice!基本用法，仔细阅读并保证遵守{strSelfName}的用户协议，如需停用指令使用[ **请写入指令** ]，用后使用[ **请写入指令** ]送出群",
	"开关":"&bot",
	"bot":".bot on/off开启/静默骰子（限群管理）\n.bot无视静默状态，只要插件开启且不在黑名单总是有效",
	"规则速查":"&rules",
	"规则":"&rules",
	"rules":"规则速查：.rules ([规则]):[待查词条] 或.rules set [规则]\n.rules 跳跃 //复数规则有相同词条时，择一返回\n.rules COC：大失败 //coc默认搜寻coc7的词条,dnd默认搜寻3r\n.rules dnd：语言\n.rules set dnd //设置后优先查询dnd同名词条，无参数则清除设置",
	"掷骰":"&r",
	"rd":"&r",
	"r":"掷骰：.r [掷骰表达式] ([掷骰原因]) [掷骰表达式]：([掷骰轮数]#)[骰子个数]d骰子面数(p[惩罚骰个数])(k[取点数最大的骰子数])不带参数时视为掷一个默认骰\n合法参数要求掷骰轮数1-10，奖惩骰个数1-9，个数范围1-100，面数范围1-1000\n.r3#d\t//3轮掷骰\n.rh心理学 暗骰\n.rs1D10+1D6+3 沙鹰伤害\t//省略单个骰子的点数，直接给结果\n现版本开头的r均可用o或d代替，但群聊中.ob会被识别为旁观指令",
	"暗骰":"群聊限定，掷骰指令后接h视为暗骰，结果将私发本人和群内ob的用户\n为了保证发送成功，请加骰娘好友",
	"旁观":"&ob",
	"旁观模式":"&ob",
	"ob":"旁观模式：.ob (exit/list/clr/on/off)\n.ob\t//加入旁观可以看到他人暗骰结果\n.ob exit\t//退出旁观模式\n.ob list\t//查看群内旁观者\n.ob clr\t//清除所有旁观者\n.ob on\t//全群允许旁观模式\n.ob off\t//禁用旁观模式\n暗骰与旁观仅在群聊中有效",
	"默认骰":"&set",
	"set":"当表达式中‘D’之后没有接面数时，视为投掷默认骰\n.set20 将默认骰设置为20\n.set 不带参数视为将默认骰重置为默认的100\n若所用规则判定掷骰形如2D6，推荐使用.st &=2D6",
	"个位骰":"个位骰有十面，为0~9十个数字，百面骰的结果为十位骰与个位骰之和（但00+0时视为100）",
	"十位骰":"十位骰有十面，为00~90十个数字，百面骰的结果为十位骰与个位骰之和（但00+0时视为100）",
	"奖励骰":"&奖励/惩罚骰",
	"惩罚骰":"&奖励/惩罚骰",
	"奖惩骰":"&奖励/惩罚骰",
	"奖励/惩罚骰":"COC中奖励/惩罚骰是额外投掷的十位骰，最终结果选用点数更低/更高的结果（不出现大失败的情况下等价于更小/更大的十位骰）\n.rb2 2个奖励骰\nrcp 射击 1个惩罚骰",
	"随机姓名":"&name",
	"name":"随机姓名：.name (cn/jp/en)([生成数量])\n.name 10\t//默认4类名称随机生成\n.name en\t//后接cn/jp/en/enzh则限定生成中文/日文/英文/英文中译名\n名称生成个数范围1-10，太多容易发现姓名库的寒酸",
	"设置昵称":"&nn",
	"昵称":"&nn",
	"nn":"设置昵称：.nn [昵称] / .nn / .nnn(cn/jp/en) \n.nn kp\t//昵称前的./！等符号会被自动忽略\n.nn\t//视为删除昵称\n.nnn\t//设置为随机昵称\n.nnn jp\t/设置限定随机昵称\n私聊.nn视为操作全局昵称\n优先级：群昵称>全局昵称>群名片>QQ昵称",
	"人物作成":"该版本人物作成支持COC7(.coc、.draw调查员背景/英雄天赋)、COC6(.coc6、.draw煤气灯)、DND(.dnd)、AMGC(.draw AMGC)",
	"coc":"克苏鲁的呼唤(COC)人物作成：.coc([7/6])(d)([生成数量])\n.coc 10\t//默认生成7版人物\n.coc6d\t//接d为详细作成，一次只能作成一个\n仅用作骰点法人物作成，可应用变体规则，参考.rules创建调查员的其他选项",
	"dnd":"龙与地下城(DND)人物作成：.dnd([生成数量])\n.dnd 5\t//仅作参考，可自行应用变体规则",
	"属性记录":"&st",
	"st":"属性记录：.st (del/clr/show) ([属性名]:[属性值])\n用户默认所有群使用同一张卡，pl如需多开请使用.pc指令切卡\n.st力量:50 体质:55 体型:65 敏捷:45 外貌:70 智力:75 意志:35 教育:65 幸运:75\n.st hp-1 后接+/-时视为从原值上变化\n.st san+1d6 修改属性时可使用掷骰表达式\n.st del kp裁决\t//删除已保存的属性\n.st clr\t//清空当前卡\n.st show 灵感\t//查看指定属性\n.st show\t//无参数时查看所有属性，请使用只st加点过技能的半自动人物卡！\n部分COC属性会被视为同义词，如智力/灵感、理智/san、侦查/侦察",
	"角色卡":"&pc",
	"pc":"角色卡：.pc \n每名用户最多可同时保存16张角色卡\n.pc new ([模板]:([生成参数]:))([卡名]) \n完全省略参数将生成一张COC7模板的随机姓名卡\n.pc tag ([卡名]) //为当前群绑定指定卡，为空则解绑使用默认卡\n所有群默认使用私聊绑定卡，未绑定则使用0号卡\n.pc show ([卡名]) //展示指定卡所有记录的属性，为空则展示当前卡\n.pc nn [新卡名] //重命名当前卡，不允许重名\n.pc type [模板] //将切换当前卡模板\n.pc cpy [卡名1]=[卡名2] //将后者属性复制给前者\n.pc del [卡名] //删除指定卡\n.pc list //列出全部角色卡\n.pc grp //列出各群绑定卡\n.pc build ([生成参数]:)(卡名) //根据模板填充生成属性（COC7为9项主属性）\n.pc redo ([生成参数]:)(卡名) //清空原有属性后重新生成\n.pc clr //销毁全部角色卡记录",
	"rc":"&rc/ra",
	"ra":"&rc/ra",
	"检定":"&rc/ra",
	"rc/ra":"检定指令：.rc/ra (_)([检定次数]#)([难度])[属性名]( [成功率])\n角色卡设置了属性时，可省略成功率\n.rc体质*5\t//允许使用+-*/，但顺序要求为乘法>加减>除法\n.rc 困难幸运\t//技能名开头的困难和极难会被视为关键词\n.rc _心理学50\t//暗骰结果仅本人及旁观者可见\n.rc 敏捷-10\t//修正后成功率必须在1-1000内\n.rcp 手枪\t//奖惩骰至多9个\n默认以规则书判定，大成功大失败的房规由.setcoc设置",
	"房规":"Dice!目前只为COC7检定提供房规，指令为.setcoc:{setcoc}",
	"setcoc":"为当前群或讨论组设置COC房规，如.setcoc 1,当前参数0-5\n0 规则书\n出1大成功\n不满50出96 - 100大失败，满50出100大失败\n1\n不满50出1大成功，满50出1 - 5大成功\n不满50出96 - 100大失败，满50出100大失败\n2\n出1 - 5且 <= 成功率大成功\n出100或出96 - 99且 > 成功率大失败\n3\n出1 - 5大成功\n出96 - 100大失败\n4\n出1 - 5且 <= 十分之一大成功\n不满50出 >= 96 + 十分之一大失败，满50出100大失败\n5\n出1 - 2且 < 五分之一大成功\n不满50出96 - 100大失败，满50出99 - 100大失败\n6 绿色三角洲\n出1或两骰相同<=成功率大成功\n出100或两骰相同>成功率大失败\n如果其他房规可向开发者反馈\n无论如何，群内检定只会调用群内设置，否则后果将是团内成员不对等",
	"san check":"&sc",
	"理智检定":"&sc",
	"sc":"San Check指令：.sc[成功损失]/[失败损失] ([当前san值])\n已经.st了理智/san时，可省略最后的参数\n.sc0/1 70\n.sc1d10/1d100 直面外神\n大失败自动失去最大值\n当调用角色卡san时，san会自动更新为sc后的剩余值\n程序上可以损失负数的san，也就是可以用.sc-1d6/-1d6来回复san，但请避免这种奇怪操作",
	"ti":"&ti/li",
	"li":"&ti/li",
	"疯狂症状":"&ti/li",
	"ti/li":"疯狂症状：\n.ti 临时疯狂症状\n.li 总结疯狂症状\n适用coc7版规则，6版请自行用百面骰配合查表\n具体适用哪项参见.rules 疯狂发作",
	"成长检定":"&en",
	"增强检定":"&en",
	"en":"成长检定：.en [技能名称]([技能值])(([失败成长值]/)[成功成长值])\n已经.st时，可省略最后的参数\n.en 教育 60 +1D10 教育增强\t//后接成功时成长值\n.en 幸运 +1D3/1D10幸运成长\t//调用人物卡属性时，成长后的值会自动更新\n可变成长值必须以加减号开头，不限制加减",
	"抽牌":"&draw",
	"draw":"抽牌：.draw [牌堆名称] ([抽牌数量])	\n.draw _[牌堆名称] ([抽牌数量])	//暗抽，结果私聊发送\n.drawh [牌堆名称] ([抽牌数量])	//暗抽，参数h后必须留空格\n.draw _狼人杀	//抽牌结果通过私聊获取，可ob\n*牌堆名称优先调用牌堆实例，如未设置则从同名公共牌堆生成临时实例\n*抽到的牌不放回，牌堆抽空后无法继续\n*查看{self}已安装牌堆，可.help 全牌堆列表或.help 扩展牌堆",
	"扩展牌堆":"{list_extern_deck}",
	"全牌堆列表":"{list_all_deck}",
	"扩展指令":"{list_extern_order}",
	"先攻":"&ri",
	"ri":"先攻（群聊限定）：.ri([加值])([昵称])\n.ri -1 某pc\t//自动记入先攻列表\n.ri +5 boss",
	"先攻列表":"&init",
	"init":"先攻列表：\n.init list\t//查看先攻列表\n.init clr\t//清除先攻列表\n.init del [项目名]\t//从先攻列表移除项目",
	"骰池":"&ww",
	"ww":"骰池：.w(w) [骰子个数]a[加骰参数]\n.w会直接给出结果而.ww会给出每个骰子的点数\n固定10面骰，每有一个骰子点数达到加骰参数，则加骰一次，最后计算点数达到8的骰子数\n具体用法请参考相关游戏规则",
	"第三人称":"&me",
	"第三人称动作":"&me",
	"me":"第三人称动作：.me([群号])[动作].me 笑出了声\t//仅限群聊使用\n.me 941980833 抱群主\t//仅限私聊使用，此命令可伪装成骰子在群里说话\n.me off\t//群内禁用.me\n.me on\t//群内启用.me",
	"今日人品":"&jrrp",
	"jrrp":"今日人品：.jrrp\n.jrrp off\t//群内禁用jrrp\n.jrrp on\t//群内启用jrrp\n一天一个人品值\n2.3.5版本后随机值为均匀分布\n骰娘只负责从溯洄的服务器搬运结果，请勿无能狂怒\n如何发配所有人的命运，只有孕育万千骰娘生机之母，萌妹吃鱼之神，正五棱双角锥体对的监护人，一切诡秘的窥见者，时空舞台外的逆流者，永转的命运之轮——溯洄本体掌握",
	"send":"发送消息：.send 想对Master说的话\n如果用来调戏Master请做好心理准备",
	"入群欢迎":"&welcome",
	"入群欢迎词":"&welcome",
	"welcome":"入群欢迎词：.welcome\n.welcome \\\\{at}欢迎\\\\{nick}入群！\t//\\\\{at}视为at入群者，\\\\{nick}会替换为新人的昵称\n.welcome\t//不带参数时清除欢迎词\n无论开关状态，只要有欢迎词时有人入群，都会响应",
	"group":"&群管",
	"群管":"群管指令.group(群管理员限定)\n.group state //查看在群内对骰娘的设置\n.group pause/restart //群全体禁言/全体解除禁言\n.group card [at/用户QQ] [名片] //设置群员名片\n.group title [at/用户QQ] [头衔] //设置群员头衔\n.group diver //查看潜水成员\n.group +/-[群管词条] //为群加减设置，需要对应权限\n例:.group +禁用回复 //关闭本群自定义回复\n群管词条:停用指令/禁用回复/禁用jrrp/禁用draw/禁用me/禁用help/禁用ob/拦截消息/许可使用/免清/免黑",
	"groups_list":"&取群列表",
	"取群列表":"取群列表.groups list(管理限定)\n.groups list idle //按闲置天数降序列出群\n.groups list size //按群规模降序列出群\n.groups list [群管词条] //列出带有词条的群\n群管词条:停用指令/禁用回复/禁用jrrp/禁用draw/禁用me/禁用help/禁用ob/拦截消息/许可使用/免清/免黑",
	"消息链接":"&link",
	"link":"消息链接.link\n.link [转发方向] [对象窗口] 建立本窗口与对象窗口的转发\n.link close 关闭链接\n.link start 开启上次关闭的链接\n[转发方向]:to=转发本窗口消息到对象窗口;from=转发对象窗口消息到本窗口;with=双向转发\n[对象窗口]:群/讨论组=[群号];私聊窗口=q[QQ号]\n例:.link with q1605271653 //建立双向私聊链接\n.link from 754494359 //接收目标群的消息转发",
	"敏感词检测":"&censor",
	"censor":"敏感词检测.admin censor\n.admin censor +([触发等级])=[敏感词0](|[敏感词1]...) //添加敏感词\n.admin censor -[敏感词0](|[敏感词1]...) //移除敏感词\n例:.admin censor +=nmsl //将“nmsl”设置为Warning级\n.admin censor +Danger=nn老公|nn主人 //将“nn老公”、“nn主人”设置为Danger级\n.admin censor -手枪 //移除敏感词“手枪”\n# 匹配机制\n骰娘会模糊匹配指令标识符(.)开头的消息，并返回所含敏感词的最高触发等级\n匹配过程自动跳过文本中的特殊符号和空格，且大小写不敏感\n受信任用户会相应降低触发等级，信任4以上用户将不触发检测\n# 触发等级\nIgnore //无视\nNotice //仅在0级窗口通知\nCaution //提醒用户，并在1级窗口提醒\nWarning //【默认等级】警告用户，并在1级窗口提醒\nDanger //警告用户且拒绝指令，并在3级窗口警告\n*请避免为纯字母/数字的敏感词设置较高触发等级，这些字符存在误匹配图片码的可能性\n# 词库批量加载方式见手册",
	"溯洄":"孕育万千骰娘生机之母，萌妹吃鱼之神，正五棱双角锥体对的监护人，一切诡秘的窥见者，拟人者主宰，时空舞台外的逆流者，永转的命运之轮",
	"投喂":"&投食",
	"投食": "投食Shiki，请选择https://afdian.net/@dice_shiki\n投食溯洄，可选择https://afdian.net/@suhuiw4123\n投食{self}，可选择……充超会？"
}"""

insane = r"""{
    "_即时症状":
     ["1) 失忆 : 调查员会发现自己只记得最后身处的安全地点，却没有任何来到这里的记忆。例如，调查员前一刻还在家中吃着早饭，下一刻就已经直面着不知名的怪物。这将会持续[1d10]轮。",
      "2) 假性残疾 : 调查员陷入了心理性的失明，失聪以及躯体缺失感中，持续[1d10]轮。",
      "3) 暴力倾向 : 调查员陷入了六亲不认的暴力行为中，对周围的敌人与友方进行着无差别的攻击，持续[1d10]轮。",
      "4) 偏执: 调查员陷入了严重的偏执妄想之中，持续[1d10]轮。有人在暗中窥视着他们，同伴中有人背叛了他们，没有人可以信任，万事皆虚。",
      "5) 人际依赖: 守秘人适当参考调查员的背景中重要之人的条目，调查员因为一些原因而将他人误认为了他重要的人并且努力的会与那个人保持那种关系，持续[1d10]轮",
      "6) 昏厥: 调查员当场昏倒，并需要[1d10]轮才能苏醒。.",
      "7) 逃避行为: 调查员会用任何的手段试图逃离现在所处的位置，即使这意味着开走唯一一辆交通工具并将其它人抛诸脑后，调查员会试图逃离[1d10]轮。",
      "8) 竭嘶底里: 调查员表现出大笑，哭泣，嘶吼，害怕等的极端情绪表现，持续{1d10}轮。",
      "9) 恐惧: 由守秘人选择一个或:\n{_恐惧症状}\n就算这一恐惧的事物是并不存在的，调查员的症状会持续[1d10]轮。",
      "10) 狂躁 : 由守秘人选择一个或:\n{_狂躁症状}\n这个症状将会持续[1d10]轮。"],
    "_总结症状":
     ["1) 失忆（Amnesia）: 回过神来，调查员们发现自己身处一个陌生的地方，并忘记了自己是谁。记忆会随时间恢复。",
      "2) 被窃（Robbed）: 调查员在[1d10]小时后恢复清醒，发觉自己被盗，身体毫发无损。如果调查员携带着宝贵之物（见调查员背景），做幸运检定来决定其是否被盗。所有有价值的东西无需检定自动消失。",
      "3) 遍体鳞伤（Battered）: 调查员在[1d10]小时后恢复清醒，发现自己身上满是拳痕和瘀伤。生命值减少到疯狂前的一半，但这不会造成重伤。调查员没有被窃。这种伤害如何持续到现在由守秘人决定。",
      "4) 暴力倾向（Violence）: 调查员陷入强烈的暴力与破坏欲之中。调查员回过神来可能会理解自己做了什么也可能毫无印象。调查员对谁或何物施以暴力，他们是杀人还是仅仅造成了伤害，由守秘人决定。",
      "5) 极端信念（Ideology/Beliefs）: 查看调查员背景中的思想信念，调查员会采取极端和疯狂的表现手段展示他们的思想信念之一。比如一个信教者会在地铁上高声布道。",
      "6) 重要之人（Significant People）: 考虑调查员背景中的重要之人，及其重要的原因。在[1d10]小时或更久的时间中，调查员将不顾一切地接近那个人，并为他们之间的关系做出行动。",
      "7) 被收容（Institutionalized）: 调查员在精神病院病房或警察局牢房中回过神来，他们可能会慢慢回想起导致自己被关在这里的事情。",
      "8) 逃避行为（Flee in panic）: 调查员恢复清醒时发现自己在很远的地方，也许迷失在荒郊野岭，或是在驶向远方的列车或长途汽车上。",
      "9) 恐惧（Phobia）: 调查员患上一个新的恐惧症。由守秘人选择一个或:\n{_恐惧症状}\n调查员在[1d10]小时后回过神来，并开始为避开恐惧源而采取任何措施。",
      "10) 狂躁（Mania）: 调查员患上一个新的狂躁症。由守秘人选择一个或:\n{_狂躁症状}\n调查员会在[1d10]小时后恢复理智。在这次疯狂发作中，调查员将完全沉浸于其新的狂躁症状。这症状是否会表现给旁人则取决于守秘人和此调查员。"],
    "_恐惧症状":
     ["1) 洗澡恐惧症（Ablutophobia）: 对于洗涤或洗澡的恐惧。",
      "2) 恐高症（Acrophobia）: 对于身处高处的恐惧。",
      "3) 飞行恐惧症（Aerophobia）: 对飞行的恐惧。",
      "4) 广场恐惧症（Agoraphobia）: 对于开放的（拥挤）公共场所的恐惧。",
      "5) 恐鸡症（Alektorophobia）: 对鸡的恐惧。",
      "6) 大蒜恐惧症（Alliumphobia）: 对大蒜的恐惧。",
      "7) 乘车恐惧症（Amaxophobia）: 对于乘坐地面载具的恐惧。",
      "8) 恐风症（Ancraophobia）: 对风的恐惧。",
      "9) 男性恐惧症（Androphobia）: 对于成年男性的恐惧。",
      "10) 恐英症（Anglophobia）: 对英格兰或英格兰文化的恐惧。",
      "11) 恐花症（Anthophobia）: 对花的恐惧。",
      "12) 截肢者恐惧症（Apotemnophobia）: 对截肢者的恐惧。",
      "13) 蜘蛛恐惧症（Arachnophobia）: 对蜘蛛的恐惧。",
      "14) 闪电恐惧症（Astraphobia）: 对闪电的恐惧。",
      "15) 废墟恐惧症（Atephobia）: 对遗迹或残址的恐惧。",
      "16) 长笛恐惧症（Aulophobia）: 对长笛的恐惧。",
      "17) 细菌恐惧症（Bacteriophobia）: 对细菌的恐惧。",
      "18) 导弹/子弹恐惧症（Ballistophobia）: 对导弹或子弹的恐惧。",
      "19) 跌落恐惧症（Basophobia）: 对于跌倒或摔落的恐惧。",
      "20) 书籍恐惧症（Bibliophobia）: 对书籍的恐惧。",
      "21) 植物恐惧症（Botanophobia）: 对植物的恐惧。",
      "22) 美女恐惧症（Caligynephobia）: 对美貌女性的恐惧。",
      "23) 寒冷恐惧症（Cheimaphobia）: 对寒冷的恐惧。",
      "24) 恐钟表症（Chronomentrophobia）: 对于钟表的恐惧。",
      "25) 幽闭恐惧症（Claustrophobia）: 对于处在封闭的空间中的恐惧。",
      "26) 小丑恐惧症（Coulrophobia）: 对小丑的恐惧。",
      "27) 恐犬症（Cynophobia）: 对狗的恐惧。",
      "28) 恶魔恐惧症（Demonophobia）: 对邪灵或恶魔的恐惧。",
      "29) 人群恐惧症（Demophobia）: 对人群的恐惧。",
      "30) 牙科恐惧症①（Dentophobia）: 对牙医的恐惧。",
      "31) 丢弃恐惧症（Disposophobia）: 对于丢弃物件的恐惧（贮藏癖）。",
      "32) 皮毛恐惧症（Doraphobia）: 对动物皮毛的恐惧。",
      "33) 过马路恐惧症（Dromophobia）: 对于过马路的恐惧。",
      "34) 教堂恐惧症（Ecclesiophobia）: 对教堂的恐惧。",
      "35) 镜子恐惧症（Eisoptrophobia）: 对镜子的恐惧。",
      "36) 针尖恐惧症（Enetophobia）: 对针或大头针的恐惧。",
      "37) 昆虫恐惧症（Entomophobia）: 对昆虫的恐惧。",
      "38) 恐猫症（Felinophobia）: 对猫的恐惧。",
      "39) 过桥恐惧症（Gephyrophobia）: 对于过桥的恐惧。",
      "40) 恐老症（Gerontophobia）: 对于老年人或变老的恐惧。",
      "41) 恐女症（Gynophobia）: 对女性的恐惧。",
      "42) 恐血症（Haemaphobia）: 对血的恐惧。",
      "43) 宗教罪行恐惧症（Hamartophobia）: 对宗教罪行的恐惧。",
      "44) 触摸恐惧症（Haphophobia）: 对于被触摸的恐惧。",
      "45) 爬虫恐惧症（Herpetophobia）: 对爬行动物的恐惧。",
      "46) 迷雾恐惧症（Homichlophobia）: 对雾的恐惧。",
      "47) 火器恐惧症（Hoplophobia）: 对火器的恐惧。",
      "48) 恐水症（Hydrophobia）: 对水的恐惧。",
      "49) 催眠恐惧症①（Hypnophobia）: 对于睡眠或被催眠的恐惧。",
      "50) 白袍恐惧症（Iatrophobia）: 对医生的恐惧。",
      "51) 鱼类恐惧症（Ichthyophobia）: 对鱼的恐惧。",
      "52) 蟑螂恐惧症（Katsaridaphobia）: 对蟑螂的恐惧。",
      "53) 雷鸣恐惧症（Keraunophobia）: 对雷声的恐惧。",
      "54) 蔬菜恐惧症（Lachanophobia）: 对蔬菜的恐惧。",
      "55) 噪音恐惧症（Ligyrophobia）: 对刺耳噪音的恐惧。",
      "56) 恐湖症（Limnophobia）: 对湖泊的恐惧。",
      "57) 机械恐惧症（Mechanophobia）: 对机器或机械的恐惧。",
      "58) 巨物恐惧症（Megalophobia）: 对于庞大物件的恐惧。",
      "59) 捆绑恐惧症（Merinthophobia）: 对于被捆绑或紧缚的恐惧。",
      "60) 流星恐惧症（Meteorophobia）: 对流星或陨石的恐惧。",
      "61) 孤独恐惧症（Monophobia）: 对于一人独处的恐惧。",
      "62) 不洁恐惧症（Mysophobia）: 对污垢或污染的恐惧。",
      "63) 黏液恐惧症（Myxophobia）: 对黏液（史莱姆）的恐惧。",
      "64) 尸体恐惧症（Necrophobia）: 对尸体的恐惧。",
      "65) 数字 8 恐惧症（Octophobia）: 对数字 8 的恐惧。",
      "66) 恐牙症（Odontophobia）: 对牙齿的恐惧。",
      "67) 恐梦症（Oneirophobia）: 对梦境的恐惧。",
      "68) 称呼恐惧症（Onomatophobia）: 对于特定词语的恐惧。",
      "69) 恐蛇症（Ophidiophobia）: 对蛇的恐惧。",
      "70) 恐鸟症（Ornithophobia）: 对鸟的恐惧。",
      "71) 寄生虫恐惧症（Parasitophobia）: 对寄生虫的恐惧。",
      "72) 人偶恐惧症（Pediophobia）: 对人偶的恐惧。",
      "73) 吞咽恐惧症（Phagophobia）: 对于吞咽或被吞咽的恐惧。",
      "74) 药物恐惧症（Pharmacophobia）: 对药物的恐惧。",
      "75) 幽灵恐惧症（Phasmophobia）: 对鬼魂的恐惧。",
      "76) 日光恐惧症（Phenogophobia）: 对日光的恐惧。",
      "77) 胡须恐惧症（Pogonophobia）: 对胡须的恐惧。",
      "78) 河流恐惧症（Potamophobia）: 对河流的恐惧。",
      "79) 酒精恐惧症（Potophobia）: 对酒或酒精的恐惧。",
      "80) 恐火症（Pyrophobia）: 对火的恐惧。",
      "81) 魔法恐惧症（Rhabdophobia）: 对魔法的恐惧。",
      "82) 黑暗恐惧症（Scotophobia）: 对黑暗或夜晚的恐惧。",
      "83) 恐月症（Selenophobia）: 对月亮的恐惧。",
      "84) 火车恐惧症（Siderodromophobia）: 对于乘坐火车出行的恐惧。",
      "85) 恐星症（Siderophobia）: 对星星的恐惧。",
      "86) 狭室恐惧症（Stenophobia）: 对狭小物件或地点的恐惧。",
      "87) 对称恐惧症（Symmetrophobia）: 对对称的恐惧。",
      "88) 活埋恐惧症（Taphephobia）: 对于被活埋或墓地的恐惧。",
      "89) 公牛恐惧症（Taurophobia）: 对公牛的恐惧。",
      "90) 电话恐惧症（Telephonophobia）: 对电话的恐惧。",
      "91) 怪物恐惧症①（Teratophobia）: 对怪物的恐惧。",
      "92) 深海恐惧症（Thalassophobia）: 对海洋的恐惧。",
      "93) 手术恐惧症（Tomophobia）: 对外科手术的恐惧。",
      "94) 十三恐惧症（Triskadekaphobia）: 对数字 13 的恐惧症。",
      "95) 衣物恐惧症（Vestiphobia）: 对衣物的恐惧。",
      "96) 女巫恐惧症（Wiccaphobia）: 对女巫与巫术的恐惧。",
      "97) 黄色恐惧症（Xanthophobia）: 对黄色或“黄”字的恐惧。",
      "98) 外语恐惧症（Xenoglossophobia）: 对外语的恐惧。",
      "99) 异域恐惧症（Xenophobia）: 对陌生人或外国人的恐惧。",
      "100) 动物恐惧症（Zoophobia）: 对动物的恐惧。"],
    "_狂躁症状":
     ["1) 沐浴癖（Ablutomania）: 执着于清洗自己。",
      "2) 犹豫癖（Aboulomania）: 病态地犹豫不定。",
      "3) 喜暗狂（Achluomania）: 对黑暗的过度热爱。",
      "4) 喜高狂（Acromaniaheights）: 狂热迷恋高处。",
      "5) 亲切癖（Agathomania）: 病态地对他人友好。",
      "6) 喜旷症（Agromania）: 强烈地倾向于待在开阔空间中。",
      "7) 喜尖狂（Aichmomania）: 痴迷于尖锐或锋利的物体。",
      "8) 恋猫狂（Ailuromania）: 近乎病态地对猫友善。",
      "9) 疼痛癖（Algomania）: 痴迷于疼痛。",
      "10) 喜蒜狂（Alliomania）: 痴迷于大蒜。",
      "11) 乘车癖（Amaxomania）: 痴迷于乘坐车辆。",
      "12) 欣快癖（Amenomania）: 不正常地感到喜悦。",
      "13) 喜花狂（Anthomania）: 痴迷于花朵。",
      "14) 计算癖（Arithmomania）: 狂热地痴迷于数字。",
      "15) 消费癖（Asoticamania）: 鲁莽冲动地消费。",
      "16) 隐居癖*（Automania）: 过度地热爱独自隐居。【英文原文是恋车癖】",
      "17) 芭蕾癖（Balletmania）: 痴迷于芭蕾舞。",
      "18) 窃书癖（Biliokleptomania）: 无法克制偷窃书籍的冲动。",
      "19) 恋书狂（Bibliomania）: 痴迷于书籍和/或阅读",
      "20) 磨牙癖（Bruxomania）: 无法克制磨牙的冲动。",
      "21) 灵臆症（Cacodemomania）: 病态地坚信自己已被一个邪恶的灵体占据。",
      "22) 美貌狂（Callomania）: 痴迷于自身的美貌。",
      "23) 地图狂（Cartacoethes）: 在何时何处都无法控制查阅地图的冲动。",
      "24) 跳跃狂（Catapedamania）: 痴迷于从高处跳下。",
      "25) 喜冷症（Cheimatomania）: 对寒冷或寒冷的物体的反常喜爱。",
      "26) 舞蹈狂（Choreomania）: 无法控制地起舞或发颤。",
      "27) 恋床癖（Clinomania）: 过度地热爱待在床上。",
      "28) 恋墓狂（Coimetormania）: 痴迷于墓地。",
      "29) 色彩狂（Coloromania）: 痴迷于某种颜色。",
      "30) 小丑狂（Coulromania）: 痴迷于小丑。",
      "31) 恐惧狂（Countermania）: 执着于经历恐怖的场面。",
      "32) 杀戮癖（Dacnomania）: 痴迷于杀戮。",
      "33) 魔臆症（Demonomania）: 病态地坚信自己已被恶魔附身。",
      "34) 抓挠癖（Dermatillomania）: 执着于抓挠自己的皮肤。",
      "35) 正义狂（Dikemania）: 痴迷于目睹正义被伸张。",
      "36) 嗜酒狂（Dipsomania）: 反常地渴求酒精。",
      "37) 毛皮狂（Doramania）: 痴迷于拥有毛皮。（存疑）",
      "38) 赠物癖（Doromania）: 痴迷于赠送礼物。",
      "39) 漂泊症（Drapetomania）: 执着于逃离。",
      "40) 漫游癖（Ecdemiomania）: 执着于四处漫游。",
      "41) 自恋狂（Egomania）: 近乎病态地以自我为中心或自我崇拜。",
      "42) 职业狂（Empleomania）: 对于工作的无尽病态渴求。",
      "43) 臆罪症（Enosimania）: 病态地坚信自己带有罪孽。",
      "44) 学识狂（Epistemomania）: 痴迷于获取学识。",
      "45) 静止癖（Eremiomania）: 执着于保持安静。",
      "46) 乙醚上瘾（Etheromania）: 渴求乙醚。",
      "47) 求婚狂（Gamomania）: 痴迷于进行奇特的求婚。",
      "48) 狂笑癖（Geliomania）: 无法自制地，强迫性的大笑。",
      "49) 巫术狂（Goetomania）: 痴迷于女巫与巫术。",
      "50) 写作癖（Graphomania）: 痴迷于将每一件事写下来。",
      "51) 裸体狂（Gymnomania）: 执着于裸露身体。",
      "52) 妄想狂（Habromania）: 近乎病态地充满愉快的妄想（而不顾现实状况如何）。",
      "53) 蠕虫狂（Helminthomania）: 过度地喜爱蠕虫。",
      "54) 枪械狂（Hoplomania）: 痴迷于火器。",
      "55) 饮水狂（Hydromania）: 反常地渴求水分。",
      "56) 喜鱼癖（Ichthyomania）: 痴迷于鱼类。",
      "57) 图标狂（Iconomania）: 痴迷于图标与肖像",
      "58) 偶像狂（Idolomania）: 痴迷于甚至愿献身于某个偶像。",
      "59) 信息狂（Infomania）: 痴迷于积累各种信息与资讯。",
      "60) 射击狂（Klazomania）: 反常地执着于射击。",
      "61) 偷窃癖（Kleptomania）: 反常地执着于偷窃。",
      "62) 噪音癖（Ligyromania）: 无法自制地执着于制造响亮或刺耳的噪音。",
      "63) 喜线癖（Linonomania）: 痴迷于线绳。",
      "64) 彩票狂（Lotterymania）: 极端地执着于购买彩票。",
      "65) 抑郁症（Lypemania）: 近乎病态的重度抑郁倾向。",
      "66) 巨石狂（Megalithomania）: 当站在石环中或立起的巨石旁时，就会近乎病态地写出各种奇怪的创意。",
      "67) 旋律狂（Melomania）: 痴迷于音乐或一段特定的旋律。",
      "68) 作诗癖（Metromania）: 无法抑制地想要不停作诗。",
      "69) 憎恨癖（Misomania）: 憎恨一切事物，痴迷于憎恨某个事物或团体。",
      "70) 偏执狂（Monomania）: 近乎病态地痴迷与专注某个特定的想法或创意。",
      "71) 夸大癖（Mythomania）: 以一种近乎病态的程度说谎或夸大事物。",
      "72) 臆想症（Nosomania）: 妄想自己正在被某种臆想出的疾病折磨。",
      "73) 记录癖（Notomania）: 执着于记录一切事物（例如摄影）",
      "74) 恋名狂（Onomamania）: 痴迷于名字（人物的、地点的、事物的）",
      "75) 称名癖（Onomatomania）: 无法抑制地不断重复某个词语的冲动。",
      "76) 剔指癖（Onychotillomania）: 执着于剔指甲。",
      "77) 恋食癖（Opsomania）: 对某种食物的病态热爱。",
      "78) 抱怨癖（Paramania）: 一种在抱怨时产生的近乎病态的愉悦感。",
      "79) 面具狂（Personamania）: 执着于佩戴面具。",
      "80) 幽灵狂（Phasmomania）: 痴迷于幽灵。",
      "81) 谋杀癖（Phonomania）: 病态的谋杀倾向。",
      "82) 渴光癖（Photomania）: 对光的病态渴求。",
      "83) 背德癖（Planomania）: 病态地渴求违背社会道德【原文是漂泊症】",
      "84) 求财癖（Plutomania）: 对财富的强迫性的渴望。",
      "85) 欺骗狂（Pseudomania）: 无法抑制的执着于撒谎。",
      "86) 纵火狂（Pyromania）: 执着于纵火。",
      "87) 提问狂（Questiong-Asking Mania）: 执着于提问。",
      "88) 挖鼻癖（Rhinotillexomania）: 执着于挖鼻子。",
      "89) 涂鸦癖（Scribbleomania）: 沉迷于涂鸦。",
      "90) 列车狂（Siderodromomania）: 认为火车或类似的依靠轨道交通的旅行方式充满魅力。",
      "91) 臆智症（Sophomania）: 臆想自己拥有难以置信的智慧。",
      "92) 科技狂（Technomania）: 痴迷于新的科技。",
      "93) 臆咒狂（Thanatomania）: 坚信自己已被某种死亡魔法所诅咒。",
      "94) 臆神狂（Theomania）: 坚信自己是一位神灵。",
      "95) 抓挠癖（Titillomaniac）: 抓挠自己的强迫倾向。",
      "96) 手术狂（Tomomania）: 对进行手术的不正常爱好。",
      "97) 拔毛癖（Trichotillomania）: 执着于拔下自己的头发。",
      "98) 臆盲症（Typhlomania）: 病理性的失明。",
      "99) 嗜外狂（Xenomania）: 痴迷于异国的事物。",
      "100) 喜兽癖（Zoomania）: 对待动物的态度近乎疯狂地友好。"]
}"""

name = r"""{
    "_name":["{%_name_cn}","{%_name_en}","{%_name_jp}"],
    "_name cn": ["{%_中文姓}{%_中文名}"],
    "_name en": ["{%_英语名}·{%_英语姓}"],
    "_name jp": ["{%_日语姓}{%_日语名}"],
    "_中文姓":
     ["赵",   "钱",   "孙",   "李",   "周",   "吴",   "郑",   "王",   "冯",   "陈",   "褚",   "卫",   "蒋",   "沈",
      "韩",   "杨",   "朱",   "秦",   "尤",   "许",   "何",   "吕",   "施",   "张",   "孔",   "曹",   "严",   "华",
      "金",   "魏",   "陶",   "姜",   "戚",   "谢",   "邹",   "喻",   "柏",   "水",   "窦",   "章",   "云",   "苏",
      "潘",   "葛",   "奚",   "范",   "彭",   "郎",   "鲁",   "韦",   "昌",   "马",   "苗",   "凤",   "花",   "方",
      "俞",   "任",   "袁",   "柳",   "酆",   "鲍",   "史",   "唐",   "费",   "廉",   "岑",   "薛",   "雷",   "贺",
      "倪",   "汤",   "滕",   "殷",   "罗",   "毕",   "郝",   "邬",   "安",   "常",   "乐",   "于",   "时",   "傅",
      "皮",   "卞",   "齐",   "康",   "伍",   "余",   "元",   "卜",   "顾",   "孟",   "平",   "黄",   "和",   "穆",
      "萧",   "尹",   "姚",   "邵",   "舒",   "汪",   "祁",   "毛",   "禹",   "狄",   "米",   "贝",   "明",   "臧",
      "计",   "伏",   "成",   "戴",   "谈",   "宋",   "茅",   "庞",   "熊",   "纪",   "屈",   "项",   "祝",   "董",
      "杜",   "阮",   "蓝",   "闵",   "席",   "季",   "麻",   "强",   "贾",   "路",   "娄",   "危",   "江",   "童",
      "颜",   "郭",   "梅",   "盛",   "林",   "刁",   "钟",   "徐",   "邱",   "骆",   "高",   "夏",   "蔡",   "田",
      "樊",   "胡",   "凌",   "霍",   "虞",   "万",   "支",   "柯",   "咎",   "管",   "卢",   "莫",   "经",   "房",
      "裘",   "缪",   "干",   "解",   "应",   "宗",   "宣",   "丁",   "贲",   "邓",   "郁",   "单",   "杭",   "洪",
      "包",   "诸",   "左",   "石",   "崔",   "吉",   "钮",   "龚",   "程",   "嵇",   "邢",   "滑",   "裴",   "陆",
      "荣",   "翁",   "荀",   "羊",   "於",   "惠",   "甄",   "加",   "封",   "芮",   "羿",   "储",   "靳",   "汲",
      "邴",   "糜",   "松",   "井",   "段",   "富",   "巫",   "乌",   "焦",   "巴",   "弓",   "牧",   "隗",   "山",
      "谷",   "车",   "侯",   "宓",   "蓬",   "全",   "郗",   "班",   "仰",   "秋",   "仲",   "伊",   "宫",   "宁",
      "仇",   "栾",   "暴",   "甘",   "钭",   "厉",   "戎",   "祖",   "武",   "符",   "刘",   "詹",   "束",   "龙",
      "叶",   "幸",   "司",   "韶",   "郜",   "黎",   "蓟",   "薄",   "印",   "宿",   "白",   "怀",   "蒲",   "台",
      "从",   "鄂",   "索",   "咸",   "籍",   "赖",   "卓",   "蔺",   "屠",   "蒙",   "池",   "乔",   "阴",   "胥",
      "能",   "苍",   "双",   "闻",   "莘",   "党",   "翟",   "谭",   "贡",   "劳",   "逄",   "姬",   "申",   "扶",
      "堵",   "冉",   "宰",   "郦",   "雍",   "璩",   "桑",   "桂",   "濮",   "牛",   "寿",   "通",   "边",   "扈",
      "燕",   "冀",   "郏",   "浦",   "尚",   "农",   "温",   "别",   "庄",   "晏",   "柴",   "瞿",   "阎",   "充",
      "慕",   "连",   "茹",   "习",   "宦",   "艾",   "鱼",   "容",   "向",   "古",   "易",   "慎",   "戈",   "廖",
      "庚",   "终",   "暨",   "居",   "衡",   "步",   "都",   "耿",   "满",   "弘",   "匡",   "国",   "文",   "寇",
      "广",   "禄",   "阙",   "东",   "殳",   "沃",   "利",   "蔚",   "越",   "夔",   "隆",   "师",   "巩",   "厍",
      "聂",   "晁",   "勾",   "敖",   "融",   "冷",   "訾",   "辛",   "阚",   "那",   "简",   "饶",   "空",   "曾",
      "毋",   "沙",   "乜",   "养",   "鞠",   "须",   "丰",   "巢",   "关",   "蒯",   "相",   "查",   "后",   "红",
      "游",   "竺",   "权",   "逯",   "盖",   "益",   "桓",   "公",   "晋",   "楚",   "法",   "汝",   "鄢",   "涂",
      "钦",   "缑",   "亢",   "况",   "有",   "商",   "牟",   "佘",   "佴",   "伯",   "赏",   "墨",   "哈",   "谯",
      "笪",   "年",   "爱",   "阳",   "佟",   "琴",   "言",   "福",   "百",   "家",   "姓",   "续",   "岳",   "帅",
      "第五", "梁丘", "左丘", "东门", "百里", "东郭", "南门", "呼延", "万俟", "南宫", "段干", "西门", "司马", "上官",
      "欧阳", "夏侯", "诸葛", "闻人", "东方", "赫连", "皇甫", "尉迟", "公羊", "澹台", "公冶", "宗政", "濮阳", "淳于",
      "仲孙", "太叔", "申屠", "公孙", "乐正", "轩辕", "令狐", "钟离", "闾丘", "长孙", "慕容", "鲜于", "宇文", "司徒",
      "司空", "亓官", "司寇", "子车", "颛孙", "端木", "巫马", "公西", "漆雕", "壤驷", "公良", "夹谷", "宰父", "微生",
      "羊舌"],
    "_中文名":
     ["夫秀", "夫琴",  "夫艳", "夫霞", "夫文", "夫娜", "夫艳", "夫瑶", "夫红", "夫美", "夫萍", "夫娥", "夫玲", "夫琳",
      "夫颖", "夫娜",  "夫蓉", "夫莉", "夫萍", "夫文", "夫英", "夫丽", "夫丽", "夫英", "夫丽", "夫蓉", "池悦", "池婷",
      "池秀", "池萍",  "池文", "池莹", "池萍", "池文", "池娜", "池怡", "池丽", "池骅", "池冉", "池冉", "池婷", "池玉",
      "池娜", "池妍",  "池颖", "池萍", "池琼", "池芳", "池瑶", "池悦", "池秀", "池颖", "池悦", "池芳", "池莹", "普娟",
      "普琳", "普文",  "普艳", "普文", "普霞", "普娟", "普媛", "普玉", "普媛", "普娜", "普怡", "普芳", "普悦", "普英",
      "普丽", "普颖",  "普莉", "普妍", "普英", "普文", "普英", "普英", "普萍", "普媛", "普文", "普芳", "普萍", "普瑛",
      "普文", "普文",  "普悦", "普娟", "沙丽", "沙燕", "沙玲", "沙琴", "沙妍", "沙玉", "沙玉", "沙艳", "沙燕", "沙蓉",
      "沙丽", "沙丽",  "沙芬", "沙玉", "沙妍", "沙娜", "沙娜", "沙莉", "沙娜", "沙莉", "沙妍", "沙倩", "沙丽", "沙琳",
      "沙妍", "沙丽",  "沙丽", "沙娜", "沙莉", "沙蓉", "沙英", "沙娜", "沙莉", "沙娜", "沙艳", "沙丽", "沙婧", "滨秀",
      "滨娜", "滨霞",  "滨茹", "滨玲", "滨花", "滨艳", "滨嫣", "滨莉", "滨玉", "滨倩", "滨媛", "滨倩", "滨霞", "滨倩",
      "滨婧", "滨瑛",  "滨蓉", "滨妍", "滨琳", "滨悦", "滨怡", "滨媛", "滨莹", "滨媛", "滨英", "滨婷", "滨妍", "滨莹",
      "滨英", "滨霞",  "滨芬", "滨莉", "滨莹", "滨悦", "滨玲", "滨红", "滨悦", "滨花", "滨萍", "滨玲", "滨燕", "滨茹",
      "滨雪", "滨瑛",  "滨霞", "滨娟", "滨茹", "滨秀", "滨婷", "滨洁", "滨倩", "滨梅", "滨文", "滨倩", "滨妍", "滨霞",
      "滨莹", "滨婧",  "滨文", "毓如", "丞熙", "胤霄", "丞祥", "禺琛", "毓立", "毓函", "毓轩", "剜庭", "毓华", "毓宏",
      "丞颢", "毓同",  "毓宁", "丕兰", "卦岸", "毓欣", "胤旋", "禺昊", "丞献", "胤淇", "毓恬", "胤其", "攸越", "剞钧",
      "毓瀚", "毓铭",  "卅卜", "毓健", "丌骊", "胤吕", "丞铭", "胤臻", "丞爨", "仄晟", "馗夕", "佚萌", "胤华", "赜琛",
      "毓涵", "毓宣",  "胤杰", "仞烊", "乜瞑", "丕秀", "丕宏", "丕森", "丞熙", "毓雅", "胤谛", "攸月", "毓斐", "胤豪",
      "丕程", "佚桀",  "丞叶", "卅戎", "禺笑", "丞贤", "剞海", "伉形", "胤椿", "匕海", "仃宇", "攸骊", "丕彬", "丞晟",
      "丞明", "毓曦",  "兀韪", "禺辰", "丞睿", "攸书", "丕馨", "毓均", "丕云", "匕海", "丕裕", "仞冲", "丕昌", "丕络",
      "毓纯", "毓康",  "毓真", "毓萱", "伛平", "剡立", "胤熹", "佚宏", "胤鑫", "仡葱", "佚轩", "亓亓", "毓晗", "毓馨",
      "毓宾", "丞晨",  "馗三", "丞昊", "攸翔", "丞标", "胤睿", "佚伶", "胤臻", "毓淇", "佚炜", "佚然", "毓萱", "胤雯",
      "佚名", "丞宇",  "乜罡", "亓鹂", "亘祺", "佚帅", "毓康", "毓华", "胤汀", "丞华", "毓萱", "毓璋", "毓辰", "丕凯",
      "胤江", "仡匆",  "丕福", "仵臻", "毓蔓", "丞宽", "毓鑫", "胤栋", "丞秋", "仃囡", "毓含", "毓僮", "禺景", "剞作",
      "丞工", "丞锂",  "胤辉", "丞彦", "毓聪", "毓清", "丞弘", "仉骅", "禺日", "佚海", "丞民", "乜栩", "毓才", "丞栊",
      "毓珈", "丌涵",  "毓鸿", "佚菱", "毓辰", "丞杰", "乇旦", "丕力", "毓怀", "兀伊", "毓宁", "胤昊", "毓荭", "胤兆",
      "毓麟", "毓璐",  "丞海", "馗圣", "毓辰", "丞第", "禺森", "冰怡", "冰婷", "冰悦", "冰燕", "冰颖", "冰雪", "冰洁",
      "冰倩", "冰瑶",  "冰玉", "冰怡", "冰秀", "冰艳", "冰梅", "冰莹", "冰倩", "冰莉", "冰瑛", "冰文", "冰倩", "冰秀",
      "冰雪", "冰琼",  "冰梅", "冰倩", "冰妍", "冰娟", "冰雪", "冰莹", "冰娜", "冰洁", "冰妍", "冰婷", "冰芬", "冰莹",
      "冰芳", "冰芬",  "冰颖", "冰怡", "冰霞", "冰洁", "冰玉", "冰英", "冰琼", "冰冰", "冰娜", "冰洁", "冰茹", "冰怡",
      "冰莹", "冰梅",  "冰妍", "冰洁", "冰玲", "冰玲", "冰洁", "冰倩", "冰玉", "冰倩", "冰颖", "冰芳", "冰秀", "冰雪",
      "冰颖", "冰艳",  "冰妍", "冰玉", "冰琳", "冰洁", "冰芳", "冰梅", "冰妍", "冰艳", "冰妍", "冰洁", "冰洁", "冰茹",
      "冰莹", "冰妍",  "冰颖", "冰艳", "冰怡", "冰雪", "冰玲", "冰花", "冰倩", "冰玲", "冰花", "冰倩", "冰茹", "冰洁",
      "冰芳", "冰洁",  "冰莹", "冰颖", "冰悦", "冰玉", "冰倩", "冰玉", "冰燕", "冰艳", "冰洁", "冰婵", "冰丽", "冰琼",
      "冰芬", "冰怡",  "冰倩", "冰琴", "冰洁", "冰婧", "冰瑶", "冰莹", "冰玲", "冰倩", "冰艳", "冰媛", "冰洁", "冰花",
      "冰倩", "冰洁",  "冰倩", "冰婷", "冰妍", "冰倩", "冰洁", "冰冉", "冰文", "冰雪", "冰瑶", "冰妍", "冰莹", "冰芳",
      "冰芬", "冰裴",  "冰艳", "冰倩", "冰艳", "冰洁", "冰芳", "冰莹", "冰霞", "冰倩", "冰雪", "冰文", "冰玉", "冰雪",
      "冰妍", "冰婵",  "冰莉", "冰洁", "冰琳", "冰颖", "冰嫣", "冰洁", "冰妍", "冰嫣", "冰倩", "冰洁", "冰媛", "冰玉",
      "冰莹", "冰妍",  "冰玉", "冰倩", "冰洁", "冰文", "冰雪", "冰怡", "冰玉", "冰雪", "冰洁", "冰秀", "冰琳", "冰倩",
      "冰莹", "冰颖",  "冰雪", "冰玉", "冰芬", "冰倩", "冰茹", "冰娜", "冰艳", "冰艳", "冰梅", "冰莹", "冰洁", "冰倩",
      "冰洁", "冰雪",  "冰雪", "冰怡", "冰瑶", "冰倩", "冰雪", "冰莹", "冰倩", "冰悦", "冰芳", "湘洁", "湘茹", "湘琴",
      "湘悦", "湘颖",  "湘丽", "湘霞", "湘琳", "湘玉", "湘艳", "湘艳", "湘怡", "湘悦", "湘媛", "湘媛", "湘媛", "湘文",
      "湘媛", "湘悦",  "湘丽", "湘燕", "湘琴", "湘莹", "湘婷", "湘婷", "湘婷", "湘秀", "湘婷", "湘玲", "湘怡", "湘文",
      "湘洁", "湘婷",  "湘颖", "湘婷", "湘倩", "湘燕", "湘婷", "湘婷", "湘婷", "湘婧", "湘琼", "湘梅", "湘怡", "湘艳",
      "湘琼", "湘婷",  "湘文", "湘茹", "湘梅", "湘雪", "湘雪", "湘琳", "湘琼", "湘茹", "湘梅", "湘婷", "湘婷", "湘雪",
      "湘莹", "湘艳",  "湘琴", "湘玉", "湘婷", "湘玉", "湘悦", "湘悦", "湘婷", "湘丽", "湘文", "湘媛", "湘婷", "湘媛",
      "湘玉", "湘婷",  "湘娜", "湘怡", "湘玉", "湘茹", "湘琼", "湘怡", "湘琴", "湘莹", "湘萍", "湘茹", "湘莹", "湘莹",
      "湘婷", "湘玉",  "湘蓉", "湘芬", "湘英", "湘玉", "湘怡", "湘婷", "湘雪", "湘梅", "湘怡", "湘琼", "湘怡", "湘颖",
      "湘玲", "湘红",  "湘红", "湘颖", "湘雪", "湘瑛", "湘悦", "湘媛", "湘英", "湘娟", "湘萍", "湘婷", "湘瑶", "湘婷",
      "湘琴", "湘颖",  "湘丽", "湘媛", "湘婷", "湘颖", "湘红", "湘琳", "湘蓉", "湘琳", "湘茹", "湘婷", "湘洁", "湘婷",
      "湘艳", "湘颖",  "湘萍", "湘玲", "湘茹", "湘娥", "湘玲", "湘悦", "湘萍", "湘莹", "湘媛", "湘婷", "湘燕", "湘琳",
      "湘玲", "湘茹",  "湘蓉", "湘瑛", "湘婷", "湘娅", "湘霞", "湘瑶", "湘颖", "湘婷", "湘艳", "湘婷", "湘玉", "湘婧",
      "湘媛", "湘娟",  "湘芳", "湘娜", "湘洁", "湘倩", "湘琳", "湘婷", "湘怡", "湘蓉", "湘颖", "湘梅", "湘琳", "湘婷",
      "湘蓉", "湘萍",  "湘婷", "湘萍", "湘萍", "湘怡", "湘茹", "湘花", "湘妍", "湘玉", "湘婷", "湘玉", "湘蓉", "湘悦",
      "湘萍", "湘蓉",  "湘嫣", "湘婷", "湘玲", "湘波", "湘怡", "湘倩", "湘梅", "湘美", "湘玉", "湘雪", "湘茹", "湘媛",
      "湘玉", "洋梅",  "洋昊", "洋琴", "洋秀", "洋雪", "洋萍", "洋洁", "洋芳", "洋文", "洋红", "洋洁", "洋萍", "洋萍",
      "洋梅", "洋悦",  "洋洁", "洋婵", "洋红", "洋玉", "洋美", "洋颖", "洋妍", "洋雪", "洋琴", "洋婧", "洋萍", "洋玉",
      "洋春", "洋洁",  "洋婧", "洋倩", "洋文", "洋怡", "洋娜", "洋萍", "洋文", "洋洁", "洋燕", "洋芳", "洋洋", "洋瑞",
      "洋琳", "洋琳",  "洋婷", "洋芮", "洋倩", "洋琳", "洋玉", "洋悦", "洋梅", "洋萍", "洋娜", "洋玉", "洋婷", "洋艳",
      "洋灏", "洋天",  "洋茹", "洋琳", "洋婷", "洋怡", "洋瑛", "洋萍", "洋梓", "洋文", "洋霞", "洋萍", "洋蕊", "洋悦",
      "洋妞", "洋花",  "洋洁", "洋锐", "洋琴", "洋茹", "洋琴", "洋丽", "洋婧", "洋婷", "洋文", "洋莹", "洋悦", "洋玉",
      "洋浩", "洋悦",  "洋倩", "洋怡", "洋莹", "洋婷", "洋媛", "洋婷", "洋萍", "洋艳", "洋花", "洋娅", "洋瑶", "洋玉",
      "洋婧", "洋悦",  "洋梅", "洋娟", "洋芬", "洋玲", "洋琳", "洋睿", "洋文", "洋嫣", "洋芳", "洋蓉", "洋丽", "洋娜",
      "洋豪", "洋梅",  "洋倩", "洋悦", "洋莉", "洋冉", "洋婧", "洋怡", "洋燕", "洋文", "洋婷", "洋妍", "洋郝", "洋洁",
      "洋莹", "洋琳",  "洋颖", "洋瑶", "洋霞", "洋妹", "洋玲", "洋美", "洋莉", "洋花", "洋萍", "洋丽", "洋悦", "洋漾",
      "洋颖", "洋婷",  "洋玉", "洋梅", "洋琳", "洋玲", "妹员", "妹妤", "妹秀", "妹郡", "妹琪", "妹芳", "妹鸾", "妹兰",
      "妹仔", "妹霖",  "妹仔", "妹洁", "妹孙", "妹馨", "妹娥", "妹子", "妹兰", "妹仔", "妹静", "妹娜", "妹文", "妹涵",
      "妹凝", "妹甬",  "妹子", "妹妮", "妹利", "妹君", "妹燕", "妹雨", "妹芬", "妹那", "妹娜", "妹平", "妹如", "妹骄",
      "妹荣", "妹飞",  "妹冰", "妹纯", "妹姨", "妹儿", "妹仪", "妹琴", "妹婷", "妹砷", "妹妍", "妹儿", "妹连", "妹俭",
      "妹加", "妹红",  "妹黔", "妹卿", "妹璎", "妹聪", "妹衲", "妹华", "妹娴", "妹儿", "妹燕", "妹珠", "妹凤", "妹娥",
      "妹鹂", "妹兰",  "妹蓉", "妹华", "妹淇", "妹仪", "妹乐", "妹英", "妹玫", "妹菊", "妹贤", "妹英", "妹好", "妹娘",
      "妹梅", "妹竹",  "妹玲", "妹霞", "妹玲", "妹华", "妹萍", "妹眉", "妹英", "妹雨", "妹莲", "妹芝", "妹尔", "妹娇",
      "妹鹆", "妹凤",  "妹娥", "妹狡", "妹伦", "妹君", "妹余", "妹兰", "妹秀", "妹好", "妹炎", "妹辉", "妹楣", "妹狗",
      "妹嫒", "妹沿",  "妹暖", "妹老", "妹娥", "妹蓓", "毕雪", "毕琴", "毕红", "毕勇", "毕琴", "毕悦", "毕美", "毕冉",
      "毕莉", "毕霞",  "毕芬", "毕霞", "毕丽", "毕颖", "毕红", "毕媛", "毕文", "毕文", "毕莉", "毕丽", "毕英", "毕红",
      "毕霞", "毕永",  "毕婵", "毕泳", "毕咏", "毕婵", "毕怡", "雨琼", "雨莹", "雨颖", "雨琳", "雨娜", "雨燕", "雨妞",
      "雨桐", "雨婷",  "雨霞", "雨婷", "雨洁", "雨媛", "雨娟", "雨娟", "雨莹", "雨婧", "雨婷", "雨嫣", "雨洁", "雨洁",
      "雨颖", "雨婷",  "雨怡", "雨婷", "雨婷", "雨洁", "雨琳", "雨梅", "雨瑶", "雨琳", "雨妍", "雨霞", "雨娟", "雨倩",
      "雨婷", "雨妍",  "雨洁", "雨玲", "雨燕", "雨冉", "雨悦", "雨琳", "雨艳", "雨洁", "雨洁", "雨婷", "雨妍", "雨洁",
      "雨倩", "雨琴",  "雨妍", "雨蓉", "雨霞", "雨嫣", "雨婷", "雨琳", "雨莹", "雨英", "雨琳", "雨妍", "雨洁", "雨颖",
      "雨娥", "雨萍",  "雨嫣", "雨婵", "雨妍", "雨莹", "雨茹", "雨燕", "雨嫣", "雨文", "雨琴", "雨婧", "雨婷", "雨婧",
      "雨婧", "雨文",  "雨嫣", "雨雪", "雨婷", "雨瑶", "雨玲", "雨倩", "雨嫣", "雨妍", "雨琼", "雨嫣", "雨婷", "雨洁",
      "雨萍", "雨莉",  "雨婵", "雨梅", "雨娟", "雨英", "雨莹", "雨婷", "雨英", "雨花", "雨秀", "雨琳", "雨燕", "雨嫣",
      "雨婷", "雨秀",  "雨婷", "雨娟", "雨悦", "雨妍", "雨艳", "雨嫣", "雨英", "雨梅", "雨倩", "雨娟", "雨嫣", "雨芳",
      "雨洁", "雨妍",  "雨婷", "雨霞", "雨媛", "雨萍", "雨婷", "雨洁", "雨嫣", "雨瑛", "雨悦", "雨琴", "雨雪", "雨滩",
      "雨英", "雨倩",  "雨玲", "雨秀", "雨芬", "雨嫣", "雨洁", "雨婵", "雨悦", "雨霞", "雨嫣", "雨琳", "雨文", "雨萍",
      "雨芳", "雨燕",  "雨洁", "雨文", "雨玲", "雨芬", "雨霞", "雨瑶", "雨琳", "雨燕", "雨颖", "雨婷", "雨菁", "雨涵",
      "雨倩", "雨蓉",  "雨琼", "雨婷", "雨娟", "雨萍", "雨瑶", "雨霞", "雨艳", "雨婷", "雨怡", "雨倩", "雨嫣", "雨嫣",
      "雨怡", "雨梅",  "雨玲", "雨娟", "雨妍", "雨莹", "雨婷", "雨芬", "雨嫣", "雨燕", "雨婷", "雨婷", "雨倩", "雨娟",
      "雨瑶", "雨嫣",  "雨媛", "雨倩", "雨莹", "雨玲", "雨玲", "雨婷", "雨琴", "雨嫣", "佩悦", "佩婷", "佩梅", "佩玉",
      "佩燕", "佩怡",  "佩芳", "佩英", "佩蓉", "佩英", "佩瑶", "佩琳", "佩莉", "佩琳", "佩玉", "佩琳", "佩琴", "佩莉",
      "佩娅", "佩娟",  "佩丽", "佩文", "佩莹", "佩玉", "佩琳", "佩婷", "佩玲", "佩琳", "佩琼", "佩怡", "佩芳", "佩茹",
      "佩瑶", "佩玲",  "佩霞", "佩文", "佩英", "佩婷", "佩英", "佩茹", "佩莉", "佩英", "佩媛", "佩芳", "佩丽", "佩琼",
      "佩芬", "佩娥",  "佩琳", "佩芳", "佩芳", "佩莉", "佩红", "佩红", "佩瑶", "佩琳", "佩文", "佩文", "佩洁", "佩琳",
      "佩霞", "佩颖",  "佩红", "佩玉", "佩媛", "佩瑶", "佩英", "佩燕", "佩玲", "佩瑶", "佩莉", "佩瑶", "佩妍", "佩文",
      "佩雪", "佩玲",  "佩莹", "佩玉", "佩霞", "佩洁", "佩媛", "佩娟", "佩娟", "佩瑶", "佩颖", "佩芬", "佩玲", "佩妍",
      "佩莹", "佩瑶",  "佩琳", "佩娜", "佩莉", "佩红", "佩婷", "佩琳", "佩玉", "佩婵", "佩琳", "佩颖", "佩娥", "佩玉",
      "佩芳", "佩茹",  "佩娟", "佩怡", "佩茹", "佩倩", "佩琴", "佩芳", "佩琳", "佩芬", "佩怡", "佩妍", "佩玲", "佩燕",
      "佩茹", "佩芬",  "佩英", "佩艳", "佩颖", "佩瑶", "佩怡", "佩玉", "佩莹", "佩蓉", "佩玲", "佩婷", "佩婷", "佩洁",
      "佩婵", "佩芬",  "佩英", "佩丽", "佩文", "佩娟", "佩玲", "佩嫣", "佩雪", "佩婷", "佩琳", "佩艳", "佩玲", "佩玲",
      "佩蓉", "佩婷",  "佩芬", "佩玉", "佩文", "佩瑶", "佩琳", "佩琴", "佩瑶", "佩妍", "佩怡", "佩瑶", "佩丽", "佩怡",
      "佩红", "佩玲",  "佩颖", "佩莉", "佩芬", "佩婷", "佩怡", "佩洁", "佩茹", "佩文", "佩莉", "佩文", "佩玲", "佩蓉",
      "佩玲", "佩洁",  "佩瑶", "佩琳", "佩红", "佩瑶", "佩婷", "佩颖", "佩颖", "佩瑶", "佩文", "佩琳", "佩瑶", "佩文",
      "佩琳", "佩娜",  "佩洁", "佩玉", "佩琪", "佩丽", "佩洁", "佩颖", "佩霞", "佩瑶", "佩玲", "佩红", "佩文", "佩裴",
      "娥妹", "娥仙",  "娥世", "娥福", "娥芳", "娥眉", "娥英", "娥佳", "娥秀", "娥如", "娥斯", "娥妹", "娥翔", "娥玉",
      "娥英", "娥洁",  "娥娉", "娥嘉", "娥兰", "娥巧", "娥连", "娥娇", "娥辉", "娥英", "娥华", "娥蕴", "娥静", "娥妹",
      "娥怡", "娥媛",  "娥娱", "娥娥", "娥仙", "娥冰", "娥英", "娥福", "娥晗", "娥如", "娥英", "娥娥", "娥子", "娥凤",
      "娥滢", "娥酏",  "娥娇", "娥玉", "娥玫", "娥英", "娥娣", "娥力", "娥平", "娥茹", "娥媚", "娥婷", "娥颜", "娥小",
      "娥霖", "娥华",  "娥凤", "娥英", "娥荣", "娥芬", "娥窕", "娥月", "娥先", "娥枝", "娥珍", "娥瑞", "娥妤", "娥芬",
      "娥元", "娥慧",  "娥菁", "娥棋", "娥欢", "娥飞", "娥瑰", "娥骝", "娥梅", "娥娥", "娥聪", "娥强", "娥英", "娥平",
      "娥娈", "娥水",  "娥翠", "娥芳", "娥福", "娥银", "娥湖", "娥仟", "娥瑗", "娥滇", "娥嘉", "娥秀", "娥仙", "娥露",
      "娥梅", "娥惠",  "娥菲", "娥香", "娥淬", "娥翔", "娥资", "甫文", "甫文", "甫妍", "甫文", "甫玲", "甫英", "甫雪",
      "甫文", "甫斌",  "甫文", "甫文", "甫娟", "甫红", "甫彬", "甫文", "甫琼", "甫玉", "甫芳", "甫文", "甫文", "甫秀",
      "汝琳", "汝芬",  "汝颖", "汝芳", "汝雪", "汝玲", "汝秀", "汝秀", "汝剀", "汝洁", "汝瑶", "汝梅", "汝玉", "汝玉",
      "汝怡", "汝玉",  "汝琳", "汝萍", "汝茹", "汝琴", "汝洁", "汝玉", "汝婷", "汝美", "汝茹", "汝琳", "汝琳", "汝英",
      "汝芳", "汝艳",  "汝丽", "汝霞", "汝洁", "汝文", "汝玉", "汝婷", "汝洁", "汝雪", "汝琳", "汝芬", "汝洁", "汝莉",
      "汝玉", "汝玉",  "汝蓉", "汝霞", "汝洁", "汝萍", "汝婷", "汝媛", "汝琼", "汝婷", "汝洁", "汝文", "汝英", "汝怡",
      "汝文", "汝萍",  "汝玉", "汝婷", "汝瑶", "汝琴", "汝颖", "汝婵", "汝妍", "汝娟", "汝瑶", "汝萍", "汝芬", "汝婷",
      "汝悦", "汝琳",  "汝英", "汝艳", "汝红", "汝燕", "汝红", "汝花", "汝秀", "汝瑶", "汝婷", "汝文", "汝琼", "汝玉",
      "汝垲", "汝蓉",  "汝婷", "汝恺", "汝芬", "汝芳", "汝洁", "汝玉", "汝雪", "汝妍", "汝玉", "汝瑛", "汝萍", "汝莹",
      "汝梅", "汝萍",  "汝瑶", "汝瑛", "汝文", "汝秀", "汝琳", "汝琳", "汝玉", "汝红", "汝洁", "汝玲", "汝英", "汝娜",
      "汝婷", "汝霞",  "汝萍", "汝妍", "汝婷", "汝雪", "汝倩", "汝玲", "汝玉", "汝燕", "汝洁", "汝芳", "汝妍", "汝倩",
      "汝萍", "汝怡",  "汝文", "汝芬", "汝英", "汝英", "汝文", "汝悦", "汝婷", "汝悦", "汝玉", "汝英", "汝雪", "汝英",
      "汝琳", "汝瑛",  "汝莹", "汝红", "汝洁", "汝婧", "汝霞", "汝艳", "汝芬", "汝玉", "汝红", "汝芳", "汝婷", "汝艳",
      "汝秀", "汝裴",  "汝艳", "汝萍", "汝雪", "汝瑛", "汝娜", "汝燕", "汝婷", "汝悦", "汝颖", "汝雪", "汝楷", "汝琳",
      "汝萍", "汝芳",  "汝英", "汝颖", "汝婷", "汝梅", "汝嫣", "汝霞", "汝琼", "汝芳", "汝琼", "汝红", "汝洁", "汝怡",
      "汝花", "汝瑶",  "汝婷", "汝娟", "汝琳", "汝洁", "汝琴", "汝妹", "汝燕", "汝洁", "汝红", "汝雪", "汝英", "汝丽",
      "汝燕", "汝婧",  "汝萍", "汝洁", "饫平", "恺琪", "怿东", "怛瀚", "饴海", "怿慎", "恺琦", "庥隆", "忪韬", "怿琨",
      "猗轩", "恺槊",  "怿峰", "恺潞", "饴逸", "膺正", "恺凝", "恺韵", "恺扬", "恺宜", "怿航", "恺芸", "怅兰", "忡希",
      "怿浩", "忤盈",  "庾锐", "怿哲", "怿江", "恺洌", "恺天", "怿浦", "怩欣", "恺佳", "恺青", "忏灵", "恺颢", "忪铃",
      "恺晟", "恺翎",  "忏忏", "赓炀", "怿锐", "恺泽", "恺豪", "恺闻", "怿铭", "恺明", "怿盛", "庾诚", "恺箫", "恺煜",
      "恺微", "恺叶",  "膺任", "恺支", "恺谛", "忏倪", "馑菘", "恺涵", "恺诺", "庠菊", "怿琪", "恺圣", "忾铭", "怿鑫",
      "夤瀑", "恺行",  "恺海", "恺航", "怿伟", "恺海", "恺漾", "怿彬", "怅次", "恺诚", "恺熙", "恺雯", "恺栎", "忾岩",
      "怿辰", "恺儒",  "恺芮", "饪萌", "恂津", "恺洋", "膺洙", "恺悌", "恺仪", "怆爨", "怿含", "怿颢", "馑厦", "恺丞",
      "忸鸿", "恺廷",  "怿飞", "恺轩", "恺彤", "恺沁", "恺雯", "怿芸", "恺丰", "忮垲", "怿非", "忪俞", "忪棂", "猥亿",
      "怿唐", "怿漩",  "怿昀", "恺悌", "恺信", "恺瑜", "忉鸾", "怿清", "馍自", "恺擎", "赓泽", "怿亮", "忏恩", "恺乐",
      "恺成", "恺茵",  "怿海", "庾轹", "饴润", "恺疑", "恺晟", "庾成", "忏艺", "恺晨", "忤爽", "恺的", "怿铎", "恺薇",
      "怿泽", "恺稷",  "恺盈", "恺宇", "恺茵", "恺汶", "怿华", "恺海", "恺勤", "恺锐", "忾浩", "恺源", "恺汶", "忡衍",
      "恺恩", "怿羚",  "庾轩", "恺心", "恺闻", "怿旗", "廪俊", "恺苒", "馀鲽", "霆玉", "霆婷", "霆英", "霆英", "霆悦",
      "霆悦", "霆玉",  "霆倩", "霆燕", "霆芳", "霆颖", "霆婷", "霆玉", "霆玉", "霆婷", "霆玉", "霆婷", "霆玉", "霆文",
      "盼怡", "盼怡",  "盼婷", "盼红", "盼颖", "盼红", "盼玲", "盼倩", "盼瑶", "盼莹", "盼瑶", "盼怡", "盼娜", "盼娜",
      "盼倩", "盼雪",  "盼妍", "盼霞", "盼莹", "盼悦", "盼琳", "盼红", "盼悦", "盼玉", "盼琳", "盼琳", "盼丽", "盼悦",
      "盼悦", "盼雪",  "盼霞", "盼冉", "盼莹", "盼玉", "盼媛", "盼红", "盼文", "盼文", "盼颖", "盼琳", "瀛婷", "瀛文",
      "瀛霞", "瀛秀",  "瀛莹", "瀛萍", "瀛文", "瀛茹", "瀛莹", "瀛文", "瀛芳", "瀛霞", "瀛婷", "瀛文", "瀛莹", "瀛莹",
      "瀛文", "瀛悦",  "瀛莹", "瀛琳", "瀛芳", "瀛雪", "默妍", "默丽", "默冉", "默婷", "默娜", "默妍", "默玉", "默文",
      "默冉", "默蓉",  "默文", "默冉", "默文", "默茹", "默妍", "默萍", "默冉", "默茹", "默琳", "默丽", "默冉", "默瑶",
      "默文", "默文",  "默颖", "默琳", "默妍", "默怡", "默茹", "默文", "默文", "默瑶", "默悦", "默冉", "默琼", "默妍",
      "默琳", "默瑶",  "默婷", "默燕", "默颖", "默怡", "默妍", "默妍", "默妍", "默颖", "默嫣", "默霞", "沅媛", "沅婷",
      "沅媛", "沅丽",  "沅丽", "沅莉", "沅洁", "沅霞", "沅媛", "沅媛", "沅洁", "沅婷", "沅莹", "沅婧", "沅雪", "沅婷",
      "沅茹", "沅媛",  "沅媛", "沅洁", "沅英", "沅琼", "沅洁", "沅瑶", "沅媛", "沅莹", "沅洁", "沅媛", "沅婷", "沅媛",
      "沅怡", "沅燕",  "沅丽", "沅文", "沅琳", "沅妍", "沅婧", "沅婷", "沅琳", "沅蓉", "沅洁", "沅媛", "沅萍", "沅倩",
      "沅怡", "沅文",  "沅蓉", "沅萍", "沅艳", "沅玲", "沅婷", "沅娜", "沅芳", "沅娜", "沅萍", "沅芳", "沅萍", "沅莉",
      "沅婷", "沅秀",  "沅莹", "沅芳", "沅芳", "沅倩", "沅茹", "沅莹", "沅颖", "沅怡", "沅玲", "沅颖", "沅洁", "沅悦",
      "沅淇", "沅洁",  "沅颖", "沅文", "沅玲", "沅怡", "沅艳", "沅妍", "沅悦", "沅玉", "沅琳", "沅琳", "沅蓉", "沅芳",
      "沅蓉", "沅婷",  "沅倩", "沅芳", "沅芳", "沅玲", "沅媛", "沅娟", "沅萍", "沅红", "沅玉", "沅媛", "沅莉", "沅娅",
      "赋文", "赋媛",  "赋文", "赋文", "赋瑶", "赋文", "赋琼", "赋颖", "赋婷", "赋燕", "赋怡", "赋蓉", "赋洁", "赋文",
      "赋蓉", "赋文",  "赋艳", "赋莹", "赋妍", "赋茹", "赋玉", "赋梅", "珩瑛", "珩洁", "珩婷", "珩冉", "珩文", "珩婧",
      "珩玉", "珩玉",  "珩艳", "珩嫣", "珩涛", "珩颖", "珩秀", "珩嫣", "珩婧", "珩雪", "珩颖", "珩艳", "珩芳", "珩文",
      "珩媛", "珩珩",  "珩婷", "珩艳", "珩嫣", "珩玉", "珩文", "珩艳", "珩文", "珩婷", "珩玉", "珩玉", "珩婉", "珩倩",
      "潇瑶", "潇冉",  "潇颖", "潇冉", "潇茹", "潇洁", "潇艳", "潇玲", "潇莉", "潇文", "潇雪", "潇怡", "潇文", "潇玲",
      "潇颖", "潇雪",  "潇婧", "潇倩", "潇琳", "潇雪", "潇茹", "潇雪", "潇怡", "潇莹", "潇琳", "潇文", "潇婷", "潇琴",
      "潇芳", "潇瑛",  "潇倩", "潇艳", "潇玉", "潇芳", "潇茹", "潇婷", "潇莹", "潇冉", "潇婷", "潇燕", "潇冉", "潇颖",
      "潇颖", "潇文",  "潇芬", "潇莹", "潇霞", "潇莉", "潇文", "潇秀", "潇茹", "潇颖", "潇雪", "潇燕", "潇燕", "潇妹",
      "潇文", "潇文",  "潇琳", "潇婷", "潇冉", "潇妞", "潇娜", "潇玉", "潇芬", "潇悦", "潇萍", "潇莉", "潇莹", "潇丽",
      "潇颖", "潇莉",  "潇琳", "潇颖", "潇洁", "潇颖", "潇瑶", "潇婷", "潇洁", "潇雪", "潇婧", "潇冉", "潇悦", "潇瑶",
      "潇婷", "潇文",  "潇悦", "潇怡", "潇文", "潇怡", "潇娜", "潇玉", "潇颖", "潇洁", "潇洁", "潇莹", "潇文", "潇悦",
      "潇媛", "潇艳",  "潇茹", "潇玲", "潇颖", "潇文", "潇雪", "潇文", "潇丽", "潇艳", "潇媛", "潇冉", "潇娜", "潇悦",
      "潇萍", "潇芬",  "潇媛", "潇怡", "潇冉", "潇文", "潇颖", "潇雪", "潇洁", "潇艳", "潇茹", "潇萍", "潇丽", "潇莹",
      "潇英", "潇媛",  "潇洁", "潇瑶", "潇洁", "潇怡", "潇怡", "潇琼", "潇颖", "潇怡", "潇婷", "潇梅", "潇莉", "潇艳",
      "潇妍", "潇怡",  "潇瑶", "潇芳", "潇秀", "潇娜", "潇芳", "潇文", "潇婷", "潇婧", "潇倩", "潇玉", "潇琼", "潇洁",
      "潇文", "潇芳",  "潇文", "潇怡", "潇娜", "潇萍", "潇莹", "潇颖", "潇娅", "潇琳", "潇妍", "潇冉", "潇雪", "潇萍",
      "潇文", "潇婷",  "潇雪", "潇洁", "潇媛", "潇莹", "潇文", "潇琳", "潇婷", "潇文", "潇洁", "潇霞", "潇婷", "潇娜",
      "潇洁", "潇燕",  "潇颖", "潇莹", "潇婷", "潇怡", "潇艳", "潇瑶", "潇霞", "潇玲", "潇怡", "潇颖", "潇雪", "潇琴",
      "潇洁", "潇涵",  "潇雪", "纬军", "嘻熙", "维福", "文涵", "文轩", "熙然", "文霆", "唯辰", "西宙", "文娴", "文璨",
      "文沛", "闻哲",  "卫军", "文君", "维山", "文旭", "文清", "伟祥", "文雄", "文海", "伟甫", "唯译", "熙儒", "卫华",
      "伟禺", "文君",  "闻陶", "伟龙", "文海", "伟伟", "伟联", "文金", "舞眩", "文海", "文浩", "伟雄", "闻涛", "文力",
      "文君", "文傲",  "文琦", "文亮", "维梁", "文宏", "文嘉", "魏禹", "文铖", "为清", "伟杰", "伟侨", "文皆", "熙城",
      "伟辰", "熙焕",  "文锦", "伟伟", "析曦", "文婕", "熙施", "未轩", "西纯", "无咎", "伟添", "武漱", "文超", "文睿",
      "卫林", "武军",  "文标", "熙溪", "熙炅", "文东", "文昌", "维宝", "西睿", "文皓", "文杰", "文茜", "熙璇", "文兵",
      "文明", "委刚",  "卫理", "文刚", "文贵", "熙鬓", "闻生", "文睿", "文俊", "伟东", "文敏", "伟欢", "伟华", "伟鸿",
      "文彤", "文锋",  "伟元", "维拓", "昔函", "锡杉", "文斐", "文举", "胃康", "文哲", "文妲", "文兵", "文芸", "闻亚",
      "稳程", "文琦",  "伟根", "为仙", "文萧", "熙迩", "卫权", "锡波", "文浩", "未央", "闻楠", "蔚岚", "文铭", "熙轩",
      "文祥", "卫宏",  "文舟", "伟鹏", "伟明", "伟伟", "务平", "伟烨", "文明", "卫华", "魏朋", "未昀", "卫达", "维楷",
      "卫军", "务业",  "文枢", "位峰", "文田", "文生", "维秋", "文越", "武河", "熙淳", "韦弘", "维乐", "文龙", "熙瑷",
      "武隆", "文泰",  "伟苹", "文康", "蔚博", "文平", "卫明", "文礼", "文勇", "紊军", "熙睿", "文跞", "文利", "魏瓶",
      "戊娣", "文清",  "维淇", "闻熹", "武裕", "韦鹏", "熙杰", "卫星", "郗怡", "郗颖", "郗茹", "郗瑶", "郗怡", "郗娜",
      "郗文", "郗文",  "郗倩", "郗嫣", "郗媛", "郗莹", "郗娅", "郗瑶", "郗媛", "郗娅", "郗莹", "盟洁", "盟洁", "盟怡",
      "盟美", "盟玉",  "盟媛", "盟文", "盟杨", "盟娟", "盟婷", "盟英", "盟瑶", "盟茹", "盟琳", "盟婷", "盟洁", "盟娜",
      "盟美", "盟怡",  "盟琳", "盟娜", "盟梅", "盟冉", "盟文", "妃嫣", "妃玉", "妃娜", "妃婷", "妃莹", "妃艳", "妃娜",
      "妃妍", "妃燕",  "妃婵", "妃萍", "妃悦", "妃花", "妃琴", "妃媛", "妃玉", "妃冉", "妃嫣", "妃茹", "妃娜", "妃琳",
      "妃悦", "妃悦",  "妃倩", "妃玲", "妃丽", "妃丽", "妃娟", "妃悦", "妃妍", "妃雪", "妃颖", "妃颖", "妃雪", "妃婷",
      "妃娥", "妃瑶",  "妃倩", "妃娜", "妃英", "妃艳", "妃娟", "妃怡", "妃茹", "妃莹", "妃玉", "妃悦", "妃燕", "妃妍",
      "妃萍", "妃媛",  "妃婷", "妃婷", "妃怡", "妃婷", "妃娜", "妃茹", "妃艳", "妃雪", "妃妍", "妃红", "妃雪", "妃琳",
      "妃嫣", "妃玉",  "妃娜", "妃娜", "妃娅", "妃蓉", "妃萍", "妃悦", "妃英", "妃雪", "妃瑶", "妃雪", "妃婷", "妃婷",
      "妃妍", "妃怡",  "妃莉", "妃琼", "妃雪", "妃艳", "妃洁", "妃悦", "妃雪", "妃梅", "妃丽", "妃艳", "妃妍", "妃花",
      "妃茹", "妃燕",  "妃婷", "妃娅", "妃艳", "妃妍", "妃琳", "妃妍", "妃嫣", "妃雪", "妃燕", "妃倩", "妃萍", "妃妍",
      "妃秀", "妃婵",  "妃雪", "妃倩", "妃红", "妃芳", "妃婷", "妃怡", "妃倩", "妃雪", "妃娟", "妃冉", "漫妍", "漫雪",
      "漫怡", "漫燕",  "漫莉", "漫琳", "漫莉", "漫婷", "漫茹", "漫秀", "漫丽", "漫琳", "漫红", "漫丽", "漫怡", "漫琳",
      "漫婷", "漫蓉",  "漫洁", "漫婷", "漫婷", "漫怡", "漫莉", "漫怡", "漫婧", "漫琳", "漫莉", "漫瑛", "漫雪", "漫花",
      "漫莉", "漫洁",  "漫茹", "漫蓉", "漫婷", "漫霞", "漫莉", "漫丽", "漫怡", "漫秀", "漫婷", "漫玉", "漫婧", "漫莉",
      "漫玲", "漫红",  "漫婷", "漫婷", "漫颖", "漫雪", "漫丽", "漫雪", "漫霞", "漫倩", "漫玉", "漫英", "漫怡", "漫颖",
      "漫玲", "漫华",  "漫丽", "漫雪", "漫婷", "漫茹", "漫琳", "漫玉", "漫琳", "漫丽", "漫莹", "漫娜", "漫婷", "漫瑶",
      "漫洁", "漫婷",  "漫红", "漫洁", "漫琴", "漫婷", "漫琳", "漫玉", "漫芳", "漫琳", "漫莉", "漫琳", "漫婷", "漫婷",
      "漫婷", "漫莉",  "漫蓉", "漫琳", "漫琳", "漫莉", "漫丽", "漫丽", "漫琳", "漫玲", "漫琳", "漫丽", "漫莉", "漫婷",
      "漫琳", "漫洁",  "漫玉", "漫霞", "漫颖", "漫霞", "漫莹", "漫莉", "漫琳", "漫婷", "漫琳", "漫雪", "漫琳", "漫莉",
      "漫文", "漫琳",  "漫婷", "漫婷", "漫媛", "漫英", "漫茹", "漫琳", "漫娜", "漫雪", "漫玲", "漫婷", "漫颖", "漫霞",
      "漫琳", "漫洁",  "漫婷", "漫玉", "漫嫣", "漫颖", "漫琳", "漫莹", "漫莹", "漫丽", "漫玲", "漫娟", "漫婷", "漫洁",
      "漫玲", "漫娜",  "漫蓉", "漫婷", "漫妍", "漫玉", "漫雪", "漫丽", "漫玉", "漫娜", "漫莉", "漫红", "漫萍", "漫瑶",
      "漫丽", "漫芳",  "漫琳", "漫颖", "漫萍", "漫丽", "漫娜", "漫艳", "漫莉", "漫婷", "漫雪", "漫玉", "漫莉", "漫婷",
      "漫萍", "漫婷",  "公冶", "伯赏", "轩辕", "长孙", "司马", "鲜于", "欧阳", "司空", "单于", "夏侯", "上官", "皇甫",
      "南宫", "诸葛",  "巫马", "阳佟", "太叔", "东方", "尉迟", "呼延", "慕容", "宇文", "淳于", "子车", "闾丘", "东郭",
      "归海", "赫连",  "司空", "乐正", "濮阳", "西门", "百里", "司徒", "令狐", "左丘", "公西", "谷粱", "拓跋", "名字男",
      "之玉", "越泽",  "锦程", "修杰", "烨伟", "尔曼", "立辉", "致远", "天思", "友绿", "聪健", "修洁", "访琴", "初彤",
      "谷雪", "平灵",  "源智", "烨华", "振家", "越彬", "乞",   "子轩", "伟宸", "晋鹏", "觅松", "海亦", "戾",   "嵩",
      "邑",   "瑛",    "鸿",   "卿",   "裘",   "契",   "涛",   "疾",   "驳",   "凛",   "逊",   "鹰",   "威",   "紊",
      "阁",   "康",    "焱",   "城",   "誉",   "祥",   "虔",   "胜",   "穆",   "豁",   "匪",   "霆",   "凡",   "枫",
      "豪",   "铭",    "罡",   "扬",   "垣",   "师",   "翼",   "秋",   "傥",   "雨珍", "浩宇", "嘉熙", "志泽", "苑博",
      "念波", "峻熙",  "俊驰", "聪展", "南松", "问旋", "黎昕", "谷波", "凝海", "靖易", "芷烟", "渊思", "煜祺", "乐驹",
      "风华", "箴",    "睿渊", "博超", "天磊", "夜白", "初晴", "雍",   "达",   "乾",   "鑫",   "萧",   "鲂",   "冥",
      "翰",   "丑",    "隶",   "钧",   "坤",   "荆",   "蹇",   "骁",   "沅",   "剑",   "勒",   "筮",   "磬",   "戎",
      "翎",   "函",    "嚣",   "炳",   "耷",   "惮",   "鞯",   "擎",   "烙",   "靖",   "遥",   "斩",   "颤",   "孱",
      "续",   "岩",    "奄",   "秋白", "瑾瑜", "鹏飞", "弘文", "伟泽", "迎松", "雨泽", "鹏笑", "诗云", "白易", "远航",
      "笑白", "映 波", "代桃", "晓啸", "智宸", "晓博", "靖琪", "十八", "君浩", "绍辉", "冷安", "盼旋", "博",   "鹤",
      "绯",   "匕",    "奎",   "仰",   "霸",   "乌",   "邴",   "败",   "捕",   "糜",   "汲",   "涔",   "班",   "悲",
      "臻",   "厉",    "栾",   "井",   "伊",   "储",   "羿",   "富",   "稀",   "松",   "寇",   "碧",   "珩",   "靳",
      "鞅",   "弼",    "焦",   "天德", "铁身", "老黑", "半邪", "半山", "一江", "冰安", "皓轩", "子默", "熠彤", "青寒",
      "烨磊", "愚志",  "飞风", "问筠", "旭尧", "妙海", "平文", "冷之", "尔阳", "天宇", "正豪", "文博", "明辉", "行恶",
      "哲瀚", "子骞",  "泽洋", "灵竹", "幼旋", "百招", "不斜", "擎汉", "千万", "高烽", "大开", "不正", "伟帮", "如豹",
      "三德", "三毒",  "连虎", "十三", "酬海", "天川", "一德", "复天", "牛青", "羊青", "大楚", "傀斗", "老五", "老九",
      "定帮", "自中",  "开山", "似狮", "无声", "一手", "严青", "老四", "不可", "随阴", "大有", "中恶", "延恶", "百川",
      "世倌", "连碧",  "岱周", "擎苍", "思远", "嘉懿", "鸿煊", "笑天", "晟睿", "强炫", "寄灵", "听白", "鸿涛", "孤风",
      "青文", "盼秋",  "怜烟", "浩然", "明杰", "昊焱", "伟诚", "剑通", "鹏涛", "鑫磊", "醉薇", "尔蓝", "靖仇", "成风",
      "豪英", "若风",  "难破", "德地", "无施", "追命", "成协", "人达", "亿先", "不评", "成威", "成败", "难胜", "人英",
      "忘幽", "世德",  "世平", "广山", "德天", "人雄", "人杰", "不言", "难摧", "世立", "老三", "若之", "成危", "元龙",
      "成仁", "若剑",  "难敌", "浩阑", "士晋", "铸海", "人龙", "伯云", "老头", "南风", "擎宇", "浩轩", "煜城", "博涛",
      "问安", "烨霖",  "天佑", "明雪", "书芹", "半雪", "伟祺", "从安", "寻菡", "秋寒", "谷槐", "文轩", "立诚", "立果",
      "明轩", "楷瑞",  "炎彬", "鹏煊", "幼南", "沛山", "不尤", "道天", "剑愁", "千筹", "广缘", "天奇", "道罡", "远望",
      "乘风", "剑心",  "道之", "乘云", "绝施", "冥幽", "天抒", "剑成", "士萧", "文龙", "一鸣", "剑鬼", "半仙", "万言",
      "剑封", "远锋",  "天与", "元正", "世开", "不凡", "断缘", "中道", "绝悟", "道消", "断秋", "远山", "无招", "无极",
      "鬼神", "满天",  "飞扬", "醉山", "语堂", "懿轩", "雅阳", "鑫鹏", "文昊", "松思", "水云", "山柳", "荣轩", "绮彤",
      "沛白", "慕蕊",  "觅云", "鹭洋", "立轩", "金鑫", "健柏", "建辉", "鹤轩", "昊强", "凡梦", "代丝", "远侵", "一斩",
      "一笑", "一刀",  "行天", "无血", "无剑", "无敌", "万怨", "万天", "万声", "万恶", "万仇", "天问", "天寿", "送终",
      "山河", "三问",  "如花", "灭龙", "聋五", "绝义", "绝山", "剑身", "浩天", "非笑", "恶天", "断天", "仇血", "仇天",
      "沧海", "不二",  "碧空", "半鬼", "海",   "文涛", "刚",   "纲",   "晓刚", "洪纲", "砖家", "叫兽", "囧",   "名字女",
      "醉易", "紫萱",  "紫霜", "紫南", "紫菱", "紫蓝", "紫翠", "紫安", "姿",   "芷天", "芷容", "芷巧", "芷卉", "芷荷",
      "芷",   "芝",    "之桃", "筝",   "真",   "珍",   "贞",   "元霜", "元绿", "元槐", "元枫", "语雪", "语山", "语蓉",
      "语琴", "语海",  "语芙", "语儿", "语蝶", "雨雪", "雨文", "雨梅", "雨莲", "雨兰", "幼丝", "幼枫", "又菡", "友梅",
      "友儿", "映萱",  "映安", "迎梦", "迎波", "婴",   "易巧", "亦丝", "亦巧", "忆雪", "忆文", "忆梅", "忆枫", "以丹",
      "依丝", "夜玉",  "夜梦", "夜春", "雁荷", "雁风", "雅彤", "雅琴", "寻梅", "寻冬", "雪珍", "雪瑶", "雪旋", "雪卉",
      "秀",   "笑旋",  "笑蓝", "笑翠", "晓亦", "晓夏", "向梦", "香萱", "香岚", "夏真", "夏山", "夏兰", "惜雪", "惜蕊",
      "惜灵", "问夏",  "问蕊", "问梅", "雯",   "纹",   "菀",   "莞",   "宛",   "桐",   "彤",   "听筠", "听枫", "天曼",
      "愫",   "素",    "涑",   "思松", "思菱", "水瑶", "水彤", "姝",   "书竹", "书易", "诗桃", "诗双", "诗珊", "诗蕊",
      "山菡", "山蝶",  "弱",   "若雁", "若菱", "若",   "如风", "如冬", "如波", "蓉",   "秋柔", "清",   "青雪", "青曼",
      "青",   "巧蕊",  "千亦", "千柔", "千柳", "绮琴", "绮梅", "莆",   "萍",   "平萱", "平露", "颦",   "沛儿", "盼烟",
      "凝雁", "凝安",  "念之", "念柏", "茗",   "敏",   "妙之", "妙梦", "妙柏", "娩",   "梦之", "梦桃", "梦琪", "梦露",
      "梦凡", "曼容",  "曼荷", "曼寒", "曼安", "绿真", "凌文", "凌青", "凌波", "怜阳", "怜珊", "冷雪", "冷荷", "乐萱",
      "乐天", "乐松",  "乐枫", "斓",   "澜",   "蓝",   "兰",   "静芙", "靖柏", "寄真", "寄文", "寄琴", "惠",   "荟",
      "幻天", "幻珊",  "寒天", "寒凝", "寒梦", "寒荷", "涵易", "涵菱", "含玉", "含烟", "含灵", "含蕾", "海云", "海冬",
      "涫",   "谷蕊",  "谷兰", "飞珍", "飞槐", "访云", "访烟", "访天", "访风", "凡阳", "凡旋", "凡梅", "凡灵", "凡蕾",
      "尔丝", "尔柳",  "尔芙", "尔白", "孤菱", "沛萍", "梦柏", "从阳", "绿海", "白梅", "秋烟", "访旋", "元珊", "凌旋",
      "依珊", "寻凝",  "幻柏", "雨寒", "寒安", "芙",   "怀绿", "书琴", "水香", "向彤", "曼冬", "璎",   "姒",   "苠",
      "淇",   "绮",    "怜梦", "安珊", "映阳", "思天", "初珍", "冷珍", "海安", "从彤", "灵珊", "夏彤", "映菡", "青筠",
      "易真", "幼荷",  "冷霜", "凝旋", "夜柳", "紫文", "凡桃", "醉蝶", "从云", "冰萍", "小萱", "白筠", "依云", "元柏",
      "丹烟", "雁",    "念云", "易蓉", "青易", "友卉", "若山", "涵柳", "映菱", "依凝", "怜南", "水儿", "从筠", "千秋",
      "代芙", "之卉",  "幻丝", "书瑶", "含之", "雪珊", "海之", "寄云", "盼海", "谷梦", "襄",   "雁兰", "晓灵", "向珊",
      "宛筠", "笑南",  "梦容", "寄柔", "静枫", "尔容", "沛蓝", "宛海", "迎彤", "梦易", "惜海", "灵阳", "念寒", "紫",
      "芯",   "沂",    "衣",   "荠",   "莺",   "萤",   "采梦", "夜绿", "又亦", "怡",   "苡",   "悒",   "梦山", "醉波",
      "慕晴", "安彤",  "荧",   "半烟", "翠桃", "书蝶", "寻云", "冰绿", "山雁", "南莲", "夜梅", "翠阳", "芷文", "茈",
      "南露", "向真",  "又晴", "香",   "又蓝", "绫",   "灵",   "雅旋", "千儿", "玲",   "听安", "凌蝶", "向露", "从凝",
      "雨双", "依白",  "樱",   "颜",   "以筠", "含巧", "艳",   "晓瑶", "忆山", "以莲", "冰海", "盼芙", "冰珍", "颖",
      "盈",   "半双",  "以冬", "千凝", "琦",   "笑阳", "香菱", "友蕊", "若云", "天晴", "笑珊", "凡霜", "南珍", "晓霜",
      "芷云", "谷芹",  "芷蝶", "雨柏", "之云", "靖巧", "寄翠", "涵菡", "雁卉", "涵山", "念薇", "忻",   "芸",   "笙",
      "芳",   "绮兰",  "迎蕾", "秋荷", "代天", "采波", "丝",   "诗兰", "谷丝", "凝琴", "凝芙", "尔风", "觅双", "忆灵",
      "水蓝", "书蕾",  "访枫", "涵双", "初阳", "从梦", "凝天", "秋灵", "湘",   "笑槐", "灵凡", "冰夏", "听露", "翠容",
      "绮晴", "静柏",  "天亦", "冷玉", "以亦", "盼曼", "乐蕊", "凡柔", "曼凝", "沛柔", "迎蓉", "映真", "采文", "曼文",
      "新筠", "碧玉",  "秋柳", "白莲", "亦玉", "幻波", "忆之", "孤丝", "妙竹", "傲柏", "元风", "易烟", "怀蕊", "萃",
      "寻桃", "映之",  "小玉", "尔槐", "翠",   "萝",   "听荷", "赛君", "闭月", "不愁", "羞花", "紫寒", "夏之", "飞薇",
      "如松", "白安",  "秋翠", "夜蓉", "傲晴", "凝丹", "凌瑶", "初曼", "夜安", "安荷", "青柏", "向松", "绿旋", "芷珍",
      "凌晴", "新儿",  "亦绿", "雁丝", "惜霜", "紫青", "冰双", "映冬", "代萱", "梦旋", "毒娘", "紫萍", "冰真", "幻翠",
      "向秋", "海蓝",  "凌兰", "如柏", "千山", "半凡", "雁芙", "白秋", "平松", "代梅", "香之", "梦寒", "小蕊", "慕卉",
      "映梦", "绿蝶",  "芹",   "凌翠", "夜蕾", "含双", "慕灵", "碧琴", "夏旋", "冷雁", "乐双", "念梦", "静丹", "之柔",
      "新瑶", "亦旋",  "雪巧", "中蓝", "莹芝", "一兰", "清涟", "盛男", "竺",   "洙",   "凝莲", "雪莲", "依琴", "绣连",
      "友灵", "醉柳",  "秋双", "珠",   "绮波", "寄瑶", "冰蝶", "孤丹", "半梅", "友菱", "飞双", "醉冬", "寡妇", "沛容",
      "南晴", "太兰",  "紫易", "从蓉", "友易", "衫",   "尔竹", "莛",   "琳",   "巧荷", "寻双", "珊",   "芷雪", "又夏",
      "梦玉", "安梦",  "凝荷", "凤",   "外绣", "忆曼", "不平", "凝蝶", "以寒", "安南", "思山", "嫣",   "芫",   "若翠",
      "曼青", "小珍",  "青荷", "代容", "孤云", "慕青", "寄凡", "元容", "丹琴", "寒珊", "飞雪", "妙芙", "碧凡", "思柔",
      "雁桃", "丹南",  "雁菡", "翠丝", "幻梅", "海莲", "宛秋", "问枫", "靖雁", "蛟凤", "大凄", "金连", "梦安", "碧曼",
      "代珊", "惜珊",  "元冬", "葶",   "芮",   "青梦", "书南", "绮山", "白桃", "从波", "访冬", "含卉", "平蝶", "海秋",
      "沛珊", "沁",    "飞兰", "凝云", "亦竹", "梦岚", "寒凡", "傲柔", "凌丝", "觅风", "平彤", "念露", "翠彤", "秋玲",
      "安蕾", "若蕊",  "灵萱", "含雁", "思真", "盼山", "香薇", "碧萱", "夏柳", "白风", "安双", "凌萱", "盼夏", "幻巧",
      "怜寒", "傲儿",  "冰枫", "如萱", "妖丽", "元芹", "涵阳", "涵蕾", "以旋", "高丽", "灭男", "代玉", "可仁", "可兰",
      "可愁", "可燕",  "妙彤", "易槐", "小凝", "妙晴", "冰薇", "涵柏", "语兰", "小蕾", "忆翠", "听云", "觅海", "静竹",
      "初蓝", "迎丝",  "幻香", "含芙", "夏波", "冰香", "凌香", "妙菱", "访彤", "凡雁", "紫真", "书双", "问晴", "惜萱",
      "白萱", "靖柔",  "凡白", "晓曼", "曼岚", "雁菱", "雨安", "谷菱", "夏烟", "问儿", "青亦", "夏槐", "含蕊", "迎南",
      "又琴", "冷松",  "安雁", "飞荷", "踏歌", "秋莲", "盼波", "以蕊", "盼兰", "之槐", "飞柏", "孤容", "白玉", "傲南",
      "山芙", "夏青",  "雁山", "曼梅", "如霜", "沛芹", "丹萱", "翠霜", "玉兰", "汝燕", "不乐", "不悔", "可冥", "若男",
      "素阴", "元彤",  "从丹", "曼彤", "惋庭", "起眸", "香芦", "绿竹", "雨真", "乐巧", "亚男", "小之", "如曼", "山槐",
      "谷蓝", "笑容",  "香露", "白薇", "凝丝", "雨筠", "秋尽", "婷冉", "冰凡", "亦云", "芙蓉", "天蓝", "沉鱼", "东蒽",
      "飞丹", "涵瑶",  "雁开", "以松", "南烟", "傲霜", "香旋", "觅荷", "幼珊", "无色", "凤灵", "新竹", "半莲", "媚颜",
      "紫雪", "寒香",  "幼晴", "宛菡", "采珊", "凝蕊", "无颜", "莫言", "初兰", "冷菱", "妙旋", "梨愁", "友琴", "水蓉",
      "尔岚", "怜蕾",  "怀蕾", "惜天", "谷南", "雪兰", "语柳", "夏菡", "巧凡", "映雁", "之双", "梦芝", "傲白", "觅翠",
      "如凡", "傲蕾",  "傲旋", "以柳", "从寒", "双双", "无春", "紫烟", "飞凤", "紫丝", "思卉", "初雪", "向薇", "落雁",
      "凡英", "海菡",  "白晴", "映天", "静白", "雨旋", "安卉", "依柔", "半兰", "灵雁", "雅蕊", "初丹", "寒云", "念烟",
      "代男", "笑卉",  "曼云", "飞莲", "幻竹", "晓绿", "寄容", "小翠", "小霜", "语薇", "芷蕾", "谷冬", "血茗", "天荷",
      "问丝", "沛凝",  "翠绿", "寒松", "思烟", "雅寒", "以南", "碧蓉", "绮南", "白凡", "安莲", "访卉", "元瑶", "水风",
      "凡松", "友容",  "访蕊", "若南", "涵雁", "雪一", "怀寒", "幻莲", "碧菡", "绿蕊", "如雪", "珊珊", "念珍", "莫英",
      "朝雪", "茹嫣",  "老太", "曼易", "宛亦", "映寒", "谷秋", "诗槐", "如之", "水桃", "又菱", "迎夏", "幻灵", "初夏",
      "晓槐", "代柔",  "忆安", "迎梅", "夜云", "傲安", "雨琴", "听芹", "依玉", "冬寒", "绿柏", "梦秋", "千青", "念桃",
      "苑睐", "夏蓉",  "诗蕾", "友安", "寻菱", "绮烟", "若枫", "凝竹", "听莲", "依波", "飞松", "依秋", "绿柳", "元菱",
      "念芹", "如彤",  "香彤", "涵梅", "映容", "平安", "赛凤", "书桃", "梦松", "以云", "映易", "小夏", "元灵", "天真",
      "晓蕾", "问玉",  "问薇", "笑晴", "亦瑶", "半芹", "幼萱", "凡双", "夜香", "阑香", "阑悦", "溪灵", "冥茗", "丹妗",
      "妙芹", "飞飞",  "觅山", "沛槐", "太英", "惋清", "太清", "灵安", "觅珍", "依风", "若颜", "觅露", "问柳", "以晴",
      "山灵", "晓兰",  "梦菡", "思萱", "半蕾", "紫伊", "山兰", "初翠", "岂愈", "海雪", "向雁", "冬亦", "柏柳", "青枫",
      "宝莹", "宝川",  "若灵", "冷梅", "艳一", "梦槐", "依霜", "凡之", "忆彤", "英姑", "清炎", "绮露", "醉卉", "念双",
      "小凡", "尔琴",  "冬卉", "初柳", "天玉", "千愁", "稚晴", "怀曼", "雪曼", "雪枫", "缘郡", "雁梅", "雅容", "雁枫",
      "灵寒", "寻琴",  "慕儿", "雅霜", "含莲", "曼香", "慕山", "书兰", "凡波", "又莲", "沛春", "语梦", "青槐", "新之",
      "含海", "觅波",  "嫣然", "善愁", "善若", "善斓", "千雁", "白柏", "雅柏", "冬灵", "平卉", "不弱", "不惜", "灵槐",
      "海露", "白梦",  "尔蓉", "芷珊", "迎曼", "问兰", "又柔", "雪青", "傲之", "绿兰", "听兰", "冰旋", "白山", "荧荧",
      "迎荷", "丹彤",  "海白", "谷云", "以菱", "以珊", "雪萍", "千兰", "大娘", "思枫", "白容", "翠芙", "寻雪", "冰岚",
      "新晴", "绿蓉",  "傲珊", "安筠", "怀亦", "安寒", "青丝", "灵枫", "芷蕊", "寻真", "以山", "菲音", "寒烟", "易云",
      "夜山", "映秋",  "唯雪", "嫣娆", "梦菲", "凤凰", "一寡", "幻然", "颜演", "白翠", "傲菡", "妙松", "忆南", "醉蓝",
      "碧彤", "水之",  "怜菡", "雅香", "雅山", "丹秋", "盼晴", "听双", "冷亦", "依萱", "静槐", "冰之", "曼柔", "夏云",
      "凌寒", "夜天",  "小小", "如南", "寻绿", "诗翠", "丹翠", "从蕾", "忆丹", "傲薇", "宛白", "幻枫", "晓旋", "初瑶",
      "如蓉", "海瑶",  "代曼", "靖荷", "采枫", "书白", "凝阳", "孤晴", "如音", "傲松", "书雪", "怜翠", "雪柳", "安容",
      "以彤", "翠琴",  "安萱", "寄松", "雨灵", "新烟", "妙菡", "雪晴", "友瑶", "丹珍", "白凝", "孤萍", "寒蕾", "妖妖",
      "藏花", "葵阴",  "幻嫣", "幻悲", "若冰", "藏鸟", "又槐", "夜阑", "灭绝", "藏今", "凌柏", "向雪", "丹雪", "无心",
      "夜雪", "幻桃",  "念瑶", "白卉", "飞绿", "怀梦", "幼菱", "芸遥", "芷波", "灵波", "一凤", "尔蝶", "问雁", "一曲",
      "问芙", "涔雨",  "宫苴", "尔云", "秋凌", "灵煌", "寒梅", "灵松", "安柏", "晓凡", "冰颜", "行云", "觅儿", "天菱",
      "舞仙", "念真",  "代亦", "飞阳", "迎天", "摇伽", "菲鹰", "惜萍", "安白", "幻雪", "友桃", "飞烟", "沛菡", "水绿",
      "天薇", "依瑶",  "夏岚", "晓筠", "若烟", "寄风", "思雁", "乐荷", "雨南", "乐蓉", "易梦", "凡儿", "翠曼", "静曼",
      "魂幽", "茹妖",  "香魔", "幻姬", "凝珍", "怜容", "惜芹", "笑柳", "太君", "莫茗", "忆秋", "代荷", "尔冬", "山彤",
      "盼雁", "山晴",  "乐瑶", "灵薇", "盼易", "听蓉", "宛儿", "从灵", "如娆", "南霜", "元蝶", "忆霜", "冬云", "访文",
      "紫夏", "新波",  "千萍", "凤妖", "水卉", "靖儿", "青烟", "千琴", "问凝", "如冰", "半梦", "怀莲", "傲芙", "静蕾",
      "艳血", "绾绾",  "绝音", "若血", "若魔", "虔纹", "涟妖", "雪冥", "邪欢", "冰姬", "四娘", "二娘", "三娘", "老姆",
      "黎云", "青旋",  "语蕊", "代灵", "紫山", "傲丝", "听寒", "秋珊", "代云", "代双", "晓蓝", "茗茗", "天蓉", "南琴",
      "寻芹", "诗柳",  "冬莲", "问萍", "忆寒", "尔珍", "新梅", "白曼", "一一", "安波", "醉香", "紫槐", "傲易", "冰菱",
      "访曼", "冷卉",  "乐儿", "幼翠", "孤兰", "绮菱", "觅夏", "三颜", "千风", "碧灵", "雨竹", "平蓝", "尔烟", "冬菱",
      "笑寒", "冰露",  "诗筠", "鸣凤", "沛文", "易文", "绿凝", "雁玉", "梦曼", "凌雪", "怜晴", "傲玉", "柔",   "幻儿",
      "书萱", "绮玉",  "诗霜", "惜寒", "惜梦", "乐安", "以蓝", "之瑶", "夏寒", "妍",   "丹亦", "凌珍", "问寒", "访梦",
      "新蕾", "书文",  "平凡", "如天", "怀柔", "语柔", "芾",   "宛丝", "南蕾", "迎海", "代芹", "巧曼", "代秋", "慕梅",
      "幼蓉", "亦寒",  "莹",   "冬易", "丹云", "丹寒", "丹蝶", "代真", "翠梅", "翠风", "翠柏", "翠安", "从霜", "从露",
      "初之", "初柔",  "初露", "初蝶", "采萱", "采蓝", "采白", "冰烟", "冰彤", "冰巧", "斌",   "傲云", "凝冬", "雁凡",
      "书翠", "千凡",  "半青", "惜儿", "曼凡", "乐珍", "新柔", "翠萱", "飞瑶", "幻露", "梦蕊", "安露", "晓露", "白枫",
      "怀薇", "雁露",  "梦竹", "盼柳", "沛岚", "夜南", "香寒", "山柏", "雁易", "静珊", "雁蓉", "千易", "笑萍", "从雪",
      "书雁", "曼雁",  "晓丝", "念蕾", "雅柔", "采柳", "易绿", "向卉", "惜文", "冰兰", "尔安", "语芹", "晓山", "秋蝶",
      "曼卉", "凝梦",  "向南", "念文", "冰蓝", "听南", "慕凝", "如容", "亦凝", "乐菱", "怀蝶", "惜筠", "冬萱", "初南",
      "含桃", "语风",  "白竹", "夏瑶", "雅绿", "怜雪", "从菡", "访波", "安青", "觅柔", "雅青", "白亦", "宛凝", "安阳",
      "苞络", "安邦",  "安福", "安歌", "安国", "安和", "安康", "安澜", "安民", "安宁", "安平", "安然", "安顺", "安翔",
      "安宜", "安易",  "安志", "安怡", "安晏", "昂杰", "昂然", "昂熙", "昂雄", "彬彬", "彬炳", "彬郁", "斌斌", "斌蔚",
      "滨海", "宾白",  "宾鸿", "宾实", "炳君", "波光", "波鸿", "波峻", "波涛", "博超", "博达", "博厚", "博简", "博明",
      "博容", "博赡",  "博涉", "博实", "博涛", "博文", "博学", "博雅", "博延", "博艺", "博易", "博裕", "博远", "博耘",
      "博瀚", "才捷",  "才俊", "才良", "才艺", "才英", "才哲", "昌翰", "昌黎", "昌燎", "昌茂", "昌盛", "昌勋", "昌淼",
      "长平", "长卿",  "长星", "长兴", "长旭", "长逸", "长岳", "长运", "辰骏", "辰良", "辰龙", "辰铭", "辰沛", "辰韦",
      "辰阳", "辰宇",  "辰钊", "辰锟", "辰皓", "晨朗", "晨涛", "晨潍", "晨轩", "晨濡", "成和", "成弘", "成化", "成济",
      "成礼", "成龙",  "成仁", "成双", "成天", "成文", "成业", "成益", "成荫", "成周", "澄邈", "承安", "承德", "承恩",
      "承福", "承基",  "承教", "承平", "承嗣", "承天", "承望", "承宣", "承颜", "承业", "承悦", "承允", "承运", "承载",
      "承泽", "承志",  "承弼", "驰海", "驰翰", "驰鸿", "驰轩", "驰逸", "驰皓", "德本", "德昌", "德海", "德厚", "德华",
      "德辉", "德惠",  "德明", "德容", "德润", "德寿", "德水", "德业", "德义", "德庸", "德佑", "德宇", "德元", "德运",
      "德泽", "德馨",  "德曜", "范明", "飞昂", "飞白", "飞掣", "飞尘", "飞沉", "飞驰", "飞光", "飞翰", "飞航", "飞鸿",
      "飞虎", "飞捷",  "飞龙", "飞鸣", "飞鹏", "飞文", "飞翔", "飞星", "飞扬", "飞翼", "飞英", "飞雨", "飞宇", "飞语",
      "飞羽", "飞跃",  "飞章", "飞舟", "飞飙", "飞鸾", "飞翮", "丰茂", "丰羽", "风华", "刚豪", "刚捷", "刚洁", "刚毅",
      "高峯", "高旻",  "高昂", "高畅", "高超", "高驰", "高达", "高飞", "高芬", "高峰", "高歌", "高格", "高寒", "高翰",
      "高杰", "高洁",  "高峻", "高朗", "高丽", "高明", "高爽", "高兴", "高轩", "高雅", "高扬", "高阳", "高逸", "高义",
      "高谊", "高原",  "高远", "高韵", "高卓", "高懿", "高岑", "高澹", "高邈", "冠宇", "冠玉", "光赫", "光华", "光辉",
      "光济", "光亮",  "光临", "光明", "光启", "光熙", "光耀", "光誉", "光远", "光霁", "广君", "国安", "国兴", "国源",
      "海昌", "海超",  "海荣", "海阳", "海逸", "涵畅", "涵涤", "涵涵", "涵亮", "涵忍", "涵容", "涵润", "涵蓄", "涵衍",
      "涵意", "涵映",  "涵育", "涵煦", "翰采", "翰池", "翰飞", "翰海", "翰林", "翰墨", "翰学", "翰音", "翰藻", "翰翮",
      "浩涆", "浩皛",  "浩波", "浩博", "浩初", "浩大", "浩荡", "浩歌", "浩广", "浩浩", "浩慨", "浩旷", "浩阔", "浩漫",
      "浩渺", "浩气",  "浩然", "浩壤", "浩思", "浩言", "浩瀚", "浩宕", "浩邈", "浩淼", "浩穰", "和蔼", "和安", "和畅",
      "和风", "和歌",  "和光", "和平", "和洽", "和顺", "和硕", "和颂", "和泰", "和通", "和同", "和雅", "和宜", "和玉",
      "和裕", "和豫",  "和悦", "和韵", "和泽", "和正", "和志", "和怡", "和悌", "和惬", "和璧", "和昶", "和煦", "鹤轩",
      "鹤骞", "鸿宝",  "鸿波", "鸿博", "鸿才", "鸿彩", "鸿畅", "鸿畴", "鸿达", "鸿德", "鸿飞", "鸿风", "鸿福", "鸿光",
      "鸿朗", "鸿文",  "鸿熙", "鸿信", "鸿轩", "鸿雪", "鸿羽", "鸿远", "鸿云", "鸿运", "鸿哲", "鸿振", "鸿志", "鸿卓",
      "鸿骞", "鸿晖",  "鸿煊", "鸿祯", "鸿禧", "鸿羲", "宏博", "宏伯", "宏才", "宏畅", "宏达", "宏大", "宏放", "宏富",
      "宏峻", "宏浚",  "宏旷", "宏阔", "宏朗", "宏茂", "宏儒", "宏深", "宏盛", "宏胜", "宏爽", "宏硕", "宏伟", "宏扬",
      "宏逸", "宏毅",  "宏义", "宏远", "宏壮", "宏恺", "宏邈", "弘博", "弘大", "弘方", "弘光", "弘和", "弘厚", "弘化",
      "弘济", "弘阔",  "弘量", "弘亮", "弘深", "弘盛", "弘图", "弘伟", "弘文", "弘新", "弘雅", "弘扬", "弘业", "弘毅",
      "弘义", "弘益",  "弘致", "弘壮", "弘懿", "华奥", "华采", "华彩", "华灿", "华藏", "华池", "华翰", "华辉", "华茂",
      "华美", "华清",  "华荣", "华容", "华晖", "华皓", "吉星", "季萌", "季同", "嘉赐", "嘉德", "嘉福", "嘉良", "嘉茂",
      "嘉慕", "嘉木",  "嘉纳", "嘉年", "嘉平", "嘉庆", "嘉荣", "嘉容", "嘉瑞", "嘉胜", "嘉石", "嘉实", "嘉树", "嘉熙",
      "嘉祥", "嘉许",  "嘉勋", "嘉言", "嘉谊", "嘉颖", "嘉佑", "嘉玉", "嘉誉", "嘉悦", "嘉运", "嘉泽", "嘉珍", "嘉志",
      "嘉致", "嘉懿",  "嘉澍", "嘉歆", "嘉祯", "嘉禧", "家骏", "坚白", "坚壁", "坚秉", "坚成", "坚诚", "健柏", "建安",
      "建白", "建柏",  "建本", "建德", "建华", "建明", "建木", "建树", "建同", "建修", "建业", "建义", "建元", "建章",
      "建中", "建茗",  "建弼", "金鹏", "金鑫", "锦程", "晋鹏", "经赋", "经国", "经略", "经纶", "经纬", "经武", "经业",
      "经艺", "经义",  "经亘", "景澄", "景福", "景浩", "景焕", "景辉", "景龙", "景明", "景平", "景山", "景胜", "景天",
      "景同", "景行",  "景逸", "景彰", "景中", "景曜", "景铄", "敬曦", "靖琪", "君博", "君豪", "君浩", "君之", "君昊",
      "峻熙", "俊喆",  "俊艾", "俊拔", "俊材", "俊才", "俊驰", "俊楚", "俊达", "俊德", "俊发", "俊风", "俊豪", "俊健",
      "俊杰", "俊捷",  "俊郎", "俊力", "俊良", "俊迈", "俊茂", "俊美", "俊民", "俊明", "俊名", "俊能", "俊人", "俊爽",
      "俊晤", "俊悟",  "俊侠", "俊贤", "俊雄", "俊雅", "俊彦", "俊逸", "俊英", "俊友", "俊语", "俊誉", "俊远", "俊哲",
      "俊智", "俊弼",  "俊楠", "俊晖", "骏喆", "骏俊", "骏年", "骏奇", "骏伟", "骏祥", "骏逸", "骏哲", "骏琛", "骏桀",
      "开畅", "开诚",  "开济", "开朗", "开宇", "开霁", "凯安", "凯唱", "凯定", "凯风", "凯复", "凯歌", "凯捷", "凯凯",
      "凯康", "凯乐",  "凯旋", "凯泽", "康安", "康伯", "康成", "康德", "康复", "康健", "康乐", "康宁", "康平", "康盛",
      "康胜", "康时",  "康适", "康顺", "康泰", "康裕", "康震", "昆峰", "昆卉", "昆杰", "昆纶", "昆明", "昆鹏", "昆锐",
      "昆纬", "昆雄",  "昆谊", "昆宇", "昆琦", "昆皓", "昆颉", "乐安", "乐邦", "乐成", "乐池", "乐和", "乐家", "乐康",
      "乐人", "乐容",  "乐山", "乐生", "乐圣", "乐水", "乐天", "乐童", "乐贤", "乐欣", "乐心", "乐逸", "乐意", "乐音",
      "乐咏", "乐游",  "乐语", "乐悦", "乐湛", "乐章", "乐正", "乐志", "黎明", "黎昕", "理全", "理群", "礼骞", "立诚",
      "立果", "立辉",  "立群", "立人", "立轩", "力夫", "力强", "力勤", "力行", "力学", "力言", "良奥", "良材", "良才",
      "良策", "良畴",  "良工", "良翰", "良吉", "良俊", "良骏", "良朋", "良平", "良哲", "良弼", "良骥", "令璟", "令枫",
      "令锋", "令秋",  "令雪", "令羽", "令梓", "令飒", "茂材", "茂才", "茂德", "茂典", "茂实", "茂学", "茂勋", "茂彦",
      "孟君", "敏叡",  "敏博", "敏才", "敏达", "敏学", "敏智", "明喆", "明诚", "明达", "明德", "明辉", "明杰", "明俊",
      "明朗", "明亮",  "明旭", "明轩", "明远", "明哲", "明知", "明志", "明智", "明珠", "明煦", "铭晨", "澎湃", "彭薄",
      "彭勃", "彭湃",  "彭彭", "彭魄", "彭越", "彭泽", "彭祖", "朋兴", "朋义", "鹏程", "鹏池", "鹏飞", "鹏赋", "鹏海",
      "鹏鲸", "鹏举",  "鹏涛", "鹏天", "鹏翼", "鹏云", "鹏运", "鹏煊", "鹏鲲", "鹏鹍", "浦和", "浦泽", "奇略", "奇迈",
      "奇胜", "奇水",  "奇思", "奇伟", "奇文", "奇希", "奇逸", "奇正", "奇志", "奇致", "奇邃", "奇玮", "起运", "庆生",
      "荣轩", "瑞渊",  "锐达", "锐锋", "锐翰", "锐进", "锐精", "锐利", "锐立", "锐思", "锐逸", "锐意", "锐藻", "锐泽",
      "锐阵", "锐志",  "锐智", "绍辉", "绍钧", "绍元", "绍晖", "绍祺", "升荣", "圣杰", "书君", "斯伯", "斯年", "思博",
      "思聪", "思源",  "思远", "思淼", "泰初", "泰和", "泰河", "泰鸿", "泰华", "泰宁", "泰平", "泰清", "泰然", "腾骏",
      "腾逸", "腾骞",  "天材", "天成", "天赋", "天干", "天工", "天翰", "天和", "天华", "天骄", "天空", "天路", "天禄",
      "天瑞", "天逸",  "天佑", "天宇", "天元", "天韵", "天泽", "天纵", "天睿", "天罡", "同方", "同甫", "同光", "同和",
      "同化", "同济",  "巍昂", "巍然", "巍奕", "维运", "伟博", "伟才", "伟诚", "伟茂", "伟彦", "伟毅", "伟泽", "伟兆",
      "伟志", "伟晔",  "伟祺", "伟懋", "温纶", "温茂", "温书", "温韦", "温文", "温瑜", "文昂", "文柏", "文彬", "文斌",
      "文滨", "文昌",  "文成", "文德", "文栋", "文赋", "文光", "文翰", "文虹", "文华", "文景", "文康", "文乐", "文林",
      "文敏", "文瑞",  "文山", "文石", "文星", "文轩", "文宣", "文彦", "文耀", "文曜", "侠骞", "翔飞", "翔宇", "项明",
      "项禹", "向晨",  "向笛", "向明", "向荣", "向文", "向阳", "晓博", "欣德", "欣嘉", "欣可", "欣然", "欣荣", "欣悦",
      "欣怿", "欣怡",  "新翰", "新觉", "新立", "新荣", "新知", "新曦", "新霁", "心水", "心思", "心远", "信鸿", "信厚",
      "信鸥", "信然",  "信瑞", "星波", "星辰", "星驰", "星光", "星海", "星汉", "星河", "星华", "星火", "星剑", "星津",
      "星爵", "星阑",  "星鹏", "星然", "星腾", "星纬", "星文", "星雨", "星宇", "星渊", "星泽", "星洲", "星晖", "星睿",
      "兴安", "兴邦",  "兴昌", "兴朝", "兴德", "兴发", "兴国", "兴怀", "兴平", "兴庆", "兴生", "兴思", "兴腾", "兴旺",
      "兴为", "兴文",  "兴贤", "兴修", "兴学", "兴言", "兴业", "兴运", "修诚", "修德", "修杰", "修洁", "修谨", "修明",
      "修能", "修平",  "修齐", "修然", "修为", "修伟", "修文", "修贤", "修雅", "修永", "修远", "修真", "修竹", "修筠",
      "旭彬", "旭东",  "旭鹏", "旭炎", "旭尧", "轩昂", "宣朗", "学博", "学海", "学林", "学民", "学名", "学文", "学义",
      "学真", "学智",  "雪峰", "雪风", "雪松", "雅珺", "雅畅", "雅达", "雅惠", "雅健", "雅逸", "雅志", "雅懿", "雅昶",
      "颜骏", "炎彬",  "彦昌", "彦君", "阳冰", "阳波", "阳伯", "阳成", "阳德", "阳华", "阳辉", "阳嘉", "阳平", "阳秋",
      "阳荣", "阳舒",  "阳朔", "阳文", "阳夏", "阳旭", "阳炎", "阳羽", "阳云", "阳泽", "阳州", "阳晖", "阳曜", "阳曦",
      "阳飙", "阳焱",  "阳煦", "阳飇", "宜春", "宜民", "宜年", "宜然", "宜人", "宜修", "逸春", "逸明", "逸仙", "意远",
      "意蕴", "意致",  "意智", "毅君", "毅然", "寅骏", "英叡", "英喆", "英博", "英才", "英达", "英发", "英范", "英光",
      "英豪", "英华",  "英杰", "英朗", "英锐", "英韶", "英卫", "英武", "英悟", "英勋", "英彦", "英耀", "英逸", "英毅",
      "英哲", "英卓",  "英资", "英纵", "英奕", "英飙", "英睿", "咏德", "咏歌", "咏思", "咏志", "永安", "永昌", "永长",
      "永春", "永丰",  "永福", "永嘉", "永康", "永年", "永宁", "永寿", "永思", "永望", "永新", "永言", "永逸", "永元",
      "永贞", "永怡",  "勇捷", "勇军", "勇男", "勇锐", "勇毅", "佑运", "雨伯", "雨华", "雨石", "雨信", "雨星", "雨泽",
      "宇达", "宇航",  "宇文", "宇荫", "宇寰", "玉成", "玉龙", "玉泉", "玉山", "玉石", "玉书", "玉树", "玉堂", "玉轩",
      "玉宇", "玉韵",  "玉泽", "玉宸", "元白", "元德", "元化", "元基", "元嘉", "元甲", "元驹", "元凯", "元魁", "元良",
      "元亮", "元龙",  "元明", "元青", "元思", "元纬", "元武", "元勋", "元正", "元忠", "元洲", "元恺", "远航", "远骞",
      "苑博", "苑杰",  "越彬", "越泽", "耘豪", "耘涛", "耘志", "云天", "允晨", "运珹", "运诚", "运发", "运凡", "运锋",
      "运浩", "运恒",  "运鸿", "运华", "运杰", "运骏", "运凯", "运莱", "运良", "运鹏", "运乾", "运升", "运盛", "运珧",
      "运晟", "蕴涵",  "蕴和", "蕴藉", "泽民", "泽洋", "泽雨", "泽宇", "泽语", "曾琪", "展鹏", "哲茂", "哲圣", "哲彦",
      "哲瀚", "震博",  "震轩", "振翱", "振博", "振国", "振海", "振华", "振凯", "振平", "振强", "振荣", "振锐", "振宇",
      "正诚", "正初",  "正德", "正豪", "正浩", "正平", "正奇", "正青", "正卿", "正文", "正祥", "正信", "正雅", "正阳",
      "正业", "正谊",  "正真", "正志", "职君", "志诚", "志国", "志明", "志强", "志尚", "志文", "志新", "志行", "志学",
      "志业", "志义",  "志勇", "志用", "志泽", "志专", "致远", "智刚", "智杰", "智敏", "智明", "智伟", "智阳", "智勇",
      "智宇", "智渊",  "智志", "智晖", "智鑫", "中震", "卓君", "子安", "子昂", "子辰", "子晋", "子民", "子明", "子墨",
      "子默", "子平",  "子石", "子实", "子轩", "子真", "子濯", "子琪", "子瑜", "自明", "自强", "自珍", "自怡", "作人",
      "胤运", "胤骞",  "懿轩", "恺歌", "恺乐", "溥心", "濮存", "瀚玥", "瀚昂", "瀚海", "瀚漠", "瀚彭", "瀚文", "瀚钰",
      "骞北", "骞魁",  "骞仕", "骞信", "骞尧", "骞泽", "琪睿", "瑾瑜", "璞玉", "璞瑜", "昊苍", "昊东", "昊嘉", "昊空",
      "昊磊", "昊明",  "昊乾", "昊然", "昊硕", "昊天", "昊伟", "昊英", "昊宇", "昊昊", "昊焱", "昊穹", "晟睿", "晗日",
      "晗昱", "曜灿",  "曜栋", "曜坤", "曜瑞", "曜文", "曜曦", "曦晨", "曦哲", "曦之", "炫明", "烨赫", "烨华", "烨磊",
      "烨霖", "烨然",  "烨烁", "烨伟", "烨烨", "烨煜", "烨熠", "煜祺", "熠彤", "祺福", "祺然", "祺瑞", "祺祥", "睿博",
      "睿才", "睿诚",  "睿慈", "睿聪", "睿达", "睿德", "睿范", "睿广", "睿好", "睿明", "睿识", "睿思", "稷骞", "皓君",
      "皓轩", "鑫鹏"],
    "_英语名":
     ["亚伦",
      "亚伯",
      "亚伯拉罕",
      "亚当",
      "艾德里安",
      "艾登/艾丹",
      "阿尔瓦",
      "亚历克斯",
      "亚历山大",
      "艾伦",
      "艾伯特",
      "阿尔弗雷德",
      "安德鲁",
      "安迪",
      "安格斯",
      "安东尼",
      "阿波罗",
      "阿诺德",
      "亚瑟",
      "奥古斯特",
      "奥斯汀",
      "本",
      "本杰明",
      "伯特",
      "本森",
      "比尔",
      "比利",
      "布莱克",
      "鲍伯",
      "鲍比",
      "布拉德",
      "布兰登",
      "布兰特",
      "布伦特",
      "布赖恩",
      "布朗",
      "布鲁斯",
      "迦勒",
      "卡梅伦",
      "卡尔",
      "卡洛斯",
      "凯里",
      "卡斯帕",
      "塞西",
      "查尔斯",
      "采尼",
      "克里斯",
      "克里斯蒂安",
      "克里斯多夫",
      "克拉克",
      "柯利弗",
      "科迪",
      "科尔",
      "科林",
      "科兹莫",
      "丹尼尔",
      "丹尼",
      "达尔文",
      "大卫",
      "丹尼斯",
      "德里克",
      "狄克",
      "唐纳德",
      "道格拉斯",
      "杜克",
      "迪伦",
      "埃迪",
      "埃德加",
      "爱迪生",
      "艾德蒙",
      "爱德华",
      "艾德文",
      "以利亚",
      "艾略特",
      "埃尔维斯",
      "埃里克",
      "伊桑",
      "柳真",
      "埃文",
      "福特",
      "弗兰克思",
      "弗兰克",
      "富兰克林",
      "弗瑞德",
      "加百利",
      "加比",
      "加菲尔德",
      "加里",
      "加文",
      "杰弗里",
      "乔治",
      "基诺",
      "格林",
      "格林顿",
      "汉克",
      "哈帝",
      "哈里森",
      "哈利",
      "海顿",
      "亨利",
      "希尔顿",
      "雨果",
      "汉克",
      "霍华德",
      "亨利",
      "伊恩",
      "伊格纳缇伍兹",
      "伊凡",
      "艾萨克",
      "以赛亚/艾塞亚",
      "杰克",
      "杰克逊",
      "雅各布",
      "詹姆士",
      "詹森",
      "杰伊",
      "杰弗瑞",
      "杰罗姆",
      "杰瑞",
      "杰西",
      "吉姆",
      "吉米",
      "乔",
      "约翰",
      "约翰尼",
      "乔纳森",
      "乔丹",
      "约瑟夫",
      "约书亚",
      "贾斯汀",
      "凯斯",
      "肯",
      "肯尼迪",
      "肯尼斯",
      "肯尼",
      "凯文",
      "凯尔",
      "兰斯",
      "拉里",
      "劳伦特",
      "劳伦斯",
      "利安德尔",
      "李",
      "雷欧",
      "雷纳德",
      "利奥波特",
      "莱斯利",
      "劳伦",
      "劳瑞",
      "劳瑞恩",
      "路易斯",
      "卢克/路加",
      "马库斯",
      "马西",
      "马克",
      "马科斯",
      "马尔斯",
      "马歇尔",
      "马丁",
      "马文",
      "梅森",
      "马修",
      "马克斯",
      "迈克尔",
      "米奇",
      "麦克",
      "纳撒尼尔",
      "尼尔",
      "尼尔森",
      "尼古拉斯",
      "尼克",
      "诺亚",
      "诺曼",
      "奥利弗",
      "奥斯卡",
      "欧文",
      "帕特里克/派翠克",
      "保罗",
      "彼得",
      "菲利普",
      "菲比",
      "昆廷",
      "兰德尔",
      "伦道夫",
      "兰迪",
      "雷",
      "列得",
      "雷克斯",
      "理查德",
      "里奇",
      "赖利/瑞利",
      "罗伯特",
      "罗宾",
      "罗宾逊/鲁宾逊",
      "洛克",
      "罗杰",
      "罗纳德",
      "罗文",
      "罗伊",
      "赖安",
      "萨姆/山姆",
      "萨米",
      "塞缪尔",
      "斯考特",
      "肖恩",
      "肖恩",
      "西德尼",
      "西蒙",
      "所罗门",
      "斯帕克",
      "斯宾塞",
      "斯派克",
      "斯坦利",
      "史蒂夫",
      "史蒂文",
      "斯图尔特",
      "斯图亚特",
      "特伦斯",
      "特里",
      "泰德",
      "托马斯",
      "提姆",
      "蒂莫西",
      "托德",
      "汤米",
      "汤姆",
      "托马斯",
      "托尼",
      "泰勒",
      "奥特曼",
      "尤利塞斯",
      "范",
      "弗恩",
      "弗农",
      "维克多",
      "文森特",
      "华纳",
      "沃伦",
      "韦恩",
      "卫斯理",
      "威廉",
      "威利/维利",
      "扎克",
      "圣扎迦利",
      "阿比盖尔",
      "艾比",
      "艾达",
      "阿德莱德",
      "艾德琳",
      "亚历桑德拉",
      "艾丽莎",
      "艾米",
      "亚历克西斯",
      "爱丽丝",
      "艾丽西娅",
      "艾琳娜",
      "艾莉森",
      "艾莉莎/爱丽丝娅",
      "阿曼达",
      "艾美",
      "安伯",
      "阿纳斯塔西娅",
      "安德莉亚",
      "安琪",
      "安吉拉",
      "安吉莉亚",
      "安吉莉娜",
      "安",
      "安娜",
      "安妮",
      "安妮",
      "安尼塔",
      "艾莉尔",
      "阿普里尔",
      "艾许莉/阿什利/艾希礼",
      "欧蕊",
      "阿维娃",
      "笆笆拉",
      "芭比",
      "贝亚特",
      "比阿特丽斯",
      "贝基",
      "贝拉",
      "贝斯",
      "贝蒂",
      "贝蒂",
      "布兰奇",
      "邦妮",
      "布伦达",
      "布莱安娜",
      "布兰妮",
      "布列塔尼",
      "卡米尔",
      "莰蒂丝",
      "坎蒂",
      "卡瑞娜",
      "卡门",
      "凯罗尔",
      "卡罗琳",
      "凯丽",
      "凯莉",
      "卡桑德拉",
      "凯西",
      "凯瑟琳",
      "凯茜",
      "切尔西",
      "沙琳",
      "夏洛特",
      "切莉",
      "雪莉尔",
      "克洛伊",
      "克莉丝",
      "克里斯蒂娜",
      "克里斯汀",
      "克里斯蒂",
      "辛迪",
      "克莱尔",
      "克劳迪娅",
      "克莱门特",
      "克劳瑞丝",
      "康妮",
      "康斯坦斯",
      "科拉",
      "科瑞恩",
      "科瑞斯特尔",
      "戴茜",
      "达芙妮",
      "达茜",
      "戴夫",
      "黛比",
      "黛博拉",
      "黛布拉",
      "黛米",
      "黛安娜",
      "德洛丽丝",
      "堂娜",
      "多拉",
      "桃瑞丝",
      "伊迪丝",
      "伊迪萨",
      "伊莱恩",
      "埃莉诺",
      "伊丽莎白",
      "埃拉",
      "爱伦",
      "艾莉",
      "艾米瑞达",
      "艾米丽",
      "艾玛",
      "伊妮德",
      "埃尔莎",
      "埃莉卡",
      "爱斯特尔",
      "爱丝特",
      "尤杜拉",
      "伊娃",
      "伊芙",
      "伊夫林",
      "芬妮",
      "费怡",
      "菲奥纳",
      "福罗拉",
      "弗罗伦丝",
      "弗郎西丝",
      "弗雷德里卡",
      "弗里达",
      "吉娜",
      "吉莉安",
      "格拉蒂丝",
      "格罗瑞娅",
      "格瑞丝",
      "格瑞丝",
      "格瑞塔",
      "格温多琳",
      "汉娜",
      "海莉",
      "赫柏",
      "海伦娜",
      "海伦",
      "汉纳",
      "海蒂",
      "希拉里/希拉蕊/希拉莉",
      "英格丽德",
      "伊莎贝拉",
      "爱沙拉",
      "艾琳",
      "艾丽丝",
      "艾维",
      "杰奎琳",
      "小玉",
      "詹米",
      "简",
      "珍妮特",
      "贾斯敏",
      "姬恩",
      "珍娜",
      "詹妮弗",
      "詹妮",
      "杰西卡",
      "杰西",
      "姬尔",
      "琼",
      "乔安娜",
      "乔斯林",
      "乔莉埃特",
      "约瑟芬",
      "乔茜",
      "乔伊",
      "乔伊斯",
      "朱迪丝",
      "朱蒂",
      "朱莉娅",
      "朱莉安娜",
      "朱莉",
      "朱恩",
      "凯琳",
      "卡瑞达",
      "凯瑟琳",
      "凯特",
      "凯西",
      "卡蒂",
      "卡特里娜",
      "凯",
      "凯拉",
      "凯莉",
      "凯尔西",
      "特里娜",
      "基蒂",
      "莱瑞拉",
      "蕾西",
      "劳拉",
      "罗兰/劳伦",
      "莉娜",
      "莉迪娅",
      "莉莲",
      "莉莉",
      "琳达",
      "琳赛",
      "丽莎",
      "莉兹",
      "洛拉",
      "罗琳",
      "路易莎",
      "路易丝",
      "露西娅",
      "露茜",
      "露西妮",
      "露露",
      "莉迪娅/莉蒂亚",
      "林恩",
      "梅布尔/玛佩尔",
      "马德琳",
      "玛姬",
      "玛米",
      "曼达",
      "曼迪",
      "玛格丽特",
      "玛丽亚",
      "玛里琳/玛丽莲/玛丽琳",
      "玛莎",
      "梅维丝",
      "玛丽",
      "玛蒂尔达",
      "莫琳",
      "梅维丝",
      "玛克辛",
      "梅",
      "梅米",
      "梅甘",
      "梅琳达",
      "梅利莎",
      "美洛蒂",
      "默西迪丝",
      "梅瑞狄斯",
      "米娅",
      "米歇尔",
      "米莉",
      "米兰达",
      "米里亚姆",
      "米娅",
      "茉莉",
      "莫尼卡",
      "摩尔根/摩根",
      "南茜",
      "娜塔莉",
      "娜塔莎",
      "妮可",
      "尼基塔",
      "尼娜",
      "娜拉/诺拉",
      "诺玛",
      "尼迪亚",
      "奥克塔维亚",
      "奥琳娜",
      "奥利维亚",
      "奥菲莉娅",
      "奥帕",
      "帕梅拉",
      "帕特丽夏",
      "芭迪",
      "保拉",
      "波琳",
      "珀尔",
      "帕姬",
      "菲洛米娜",
      "菲比",
      "菲丽丝",
      "波莉",
      "普里西拉",
      "昆蒂娜",
      "雷切尔",
      "丽贝卡",
      "瑞加娜",
      "丽塔",
      "罗丝",
      "洛克萨妮",
      "露丝",
      "萨布丽娜",
      "萨莉",
      "桑德拉",
      "萨曼莎",
      "萨米",
      "桑德拉",
      "桑迪",
      "莎拉",
      "萨瓦纳/萨瓦娜",
      "斯佳丽/斯嘉丽",
      "塞尔玛",
      "塞琳娜",
      "塞丽娜",
      "莎伦",
      "希拉",
      "雪莉",
      "雪丽",
      "雪莉",
      "斯莱瑞",
      "西尔维亚",
      "索尼亚",
      "索菲娅",
      "丝塔茜",
      "丝特拉",
      "斯蒂芬妮",
      "苏",
      "萨妮",
      "苏珊",
      "塔玛拉",
      "苔米",
      "谭雅坦尼娅",
      "塔莎",
      "特莉萨",
      "苔丝",
      "蒂凡妮",
      "蒂娜",
      "棠雅/东妮亚",
      "特蕾西",
      "厄休拉",
      "温妮莎",
      "维纳斯",
      "维拉",
      "维姬",
      "维多利亚",
      "维尔莉特",
      "维吉妮亚",
      "维达",
      "薇薇安",
      "旺达",
      "温蒂",
      "惠特尼",
      "韦恩",
      "温妮",
      "尤兰达",
      "伊薇特",
      "伊温妮",
      "莎拉",
      "塞尔达",
      "佐伊",
      "卓拉"],
    "_英语姓": ["阿德米林德",   "阿埃鲁姆",     "阿克乌姆",       "安布罗法尔特克豪森",
                "阿梅布洛",     "阿米克",       "阿莫米安",       "阿尔巴尔",
                "巴尔巴尔科尔", "比埃尔",       "比尔德",         "比特尔利夫",
                "邦德诺",       "布拉乌尔",     "布尔卢",         "布蒂克",
                "蔡卢姆",       "切内尔",       "奇彭",           "德洛尔莫",
                "德乌姆",       "多梅特",       "埃胡姆",         "埃米兰",
                "恩霍兰",       "埃斯佩尔",     "埃斯特鲁姆",     "法伊雷尔",
                "法米利",       "费萨南",       "菲洛帕托尔",     "菲斯坎",
                "弗卢吉尔",     "加兰",         "格拉兰",         "吉米克",
                "格拉温格",     "格林希尔特",   "古斯特",         "扎尔登",
                "哈基尔",       "哈尔克",       "哈斯卡",         "海尔丹",
                "赫尔布",       "霍马尔",       "霍尔贝克",       "霍鲁姆",
                "因奎",         "因特雷斯",     "伊尔兰",         "伊文斯",
                "亚布利奇",     "亚古",         "亚鲁姆",         "尤努尔",
                "茹尔纳尔",     "卡米诺",       "坎德林格",       "卡尼亚斯",
                "卡尔兰",       "克卢布",       "科德拉尔",       "科里亚斯",
                "科维尔特",     "克拉丹",       "克雷德布洛",     "克鲁夫",
                "库德里尔",     "库伊雷",       "库努尔",         "库万",
                "克瓦罗普",     "拉格特",       "拉姆里斯",       "兰德",
                "利布雷特",     "洛哲伊",       "卢姆斯特尔",     "马卡维尔",
                "马克西佩斯",   "马尔班",       "马里斯特",       "马尔萨乌斯",
                "马鲁姆",       "梅赫卡普拉德", "梅莫林德",       "蒙图姆",
                "蒙特里尔",     "纳坎",         "诺穆姆",         "奥克托佩德",
                "奥斯图姆",     "帕内尔",       "帕努姆",         "彭蒂乌姆",
                "彭特里斯特",   "佩皮安",       "皮尔克",         "皮鲁伊",
                "普卢明格",     "普卢穆伊",     "普卢维尔",       "波穆伊",
                "普雷哲伊",     "普尔维尔",     "拉夫尼尔",       "拉尔凡",
                "拉斯塔甘",     "拉齐尔",       "雷格内斯特鲁姆", "雷古姆",
                "里楚尔",       "鲁克斯平",     "萨布雷尔",       "萨朱尔",
                "萨古姆",       "萨伊斯特",     "斯卡托尔",       "斯特卢姆",
                "苏克尔",       "施洛西尔",     "舒伊斯特",       "坦德尔",
                "特里坎",       "蒂普姆",       "特拉曼",         "特兰奇尔",
                "特拉维斯",     "乌尔布姆",     "温德伊",         "维尔达日",
                "维鲁姆",       "维拉南",       "温贝鲁伊",       "碧声",
                "沃尔特",       "泽尔科斯",     "齐亚特",         "佐拉扬",
                "史密斯",       "约翰逊",       "威廉姆斯",       "约翰",
                "布朗",         "戴维斯",       "米勒",           "威尔逊",
                "摩尔",         "泰勒",         "安德森",         "托马斯",
                "杰克逊",       "怀特",         "哈里斯",         "马丁",
                "汤姆逊",       "加西亚",       "马丁内斯",       "罗宾森",
                "克拉克",       "罗德里格斯",   "路易斯",         "李",
                "沃克",         "霍尔",         "艾伦",           "杨",
                "埃尔南德斯",   "金",           "赖特",           "洛佩兹",
                "伊尔",         "斯科特",       "格林",           "亚当",
                "贝克",         "冈萨雷斯",     "纳尔逊",         "卡特",
                "米切尔",       "佩雷斯",       "罗伯特",         "特纳",
                "菲利普",       "坎贝尔",       "帕克",           "埃文斯",
                "爱德华",       "柯林斯",       "斯图尔特",       "桑切斯",
                "莫里斯",       "罗杰斯",       "里德",           "库克",
                "摩根",         "贝尔",         "墨菲",           "贝利",
                "里韦拉",       "库珀",         "理查德森",       "考克斯",
                "霍华德",       "沃德",         "托里斯",         "彼得森",
                "格瑞",         "拉米雷斯",     "詹姆斯",         "沃森",
                "布鲁克斯",     "凯莉",         "桑德斯",         "普里斯",
                "班尼特",       "伍德",         "巴恩斯",         "罗斯",
                "亨德森",       "科尔曼",       "詹金斯",         "佩里",
                "鲍威尔",       "隆",           "帕特森",         "休斯",
                "弗洛雷斯",     "华盛顿",       "巴特勒",         "西蒙",
                "福斯特",       "冈萨雷斯",     "布赖恩特",       "亚历克斯",
                "拉塞尔",       "格里芬",       "亚兹",           "海斯"],
    "_日语姓":
     ["鹤田",   "香取",   "野泽",   "麻生",   "小田切", "草翦",   "稻垣",   "木村",   "中居",   "濑户",   "山下",
      "酒井",   "松本",   "石田",   "柴崎",   "藤原",   "福山",   "江口",   "唐泽",   "长泽",   "椎名",   "松岛",
      "白石",   "铃木",   "堂本",   "仲间",   "织田",   "泷泽",   "妻夫木", "药师丸", "余贵",   "石黑",   "丰川",
      "平宫",   "工藤",   "赤西",   "生田",   "高岛",   "松山",   "井之原", "锦户",   "城田",   "竹野内", "广末",
      "二宫",   "石垣",   "小松",   "小栗",   "田中",   "滨崎",   "滨田",   "幸田",   "志田",   "香椎",   "山本",
      "原田",   "永山",   "栗山",   "前田",   "冈部",   "忍成",   "寺岛",   "黑木",   "水野",   "伊势谷", "野口",
      "土屋",   "北乃",   "绫濑",   "泽尻",   "荣仓",   "加藤",   "宫崎",   "风间",   "户田",   "山口",   "井川",
      "深田",   "米仓",   "佐藤",   "小池",   "上野",   "伊东",   "须藤",   "长濑",   "倍赏",   "岸谷",   "赤坂",
      "中村",   "相叶",   "今井",   "黑川",   "伊藤",   "五十岚", "冈田",   "野际",   "岛谷",   "堤",     "加濑",
      "吉田",   "观月",   "深津",   "洼冢",   "役所",   "山田",   "吹石",   "吉冈",   "内田",   "阿部",   "吉泽",
      "松田",   "长谷川", "国仲",   "上川",   "北村",   "宝生",   "京野",   "天海",   "中山",   "中谷",   "香川",
      "吉永",   "冈本",   "相武",   "向井",   "稻森",   "成海",   "市川",   "玉山",   "龟梨",   "松下",   "高桥",
      "仲代",   "井上",   "吉川",   "手冢",   "友坂",   "宫泽",   "樱井",   "大野",   "多部未", "上户",   "平冈",
      "能濑",   "手越",   "宇多田", "仓木",   "安室奈", "美木",   "小野",   "中岛",   "竹中",   "中井",   "吉高",
      "安藤",   "川岛",   "菊川",   "管野",   "安倍",   "市原",   "小泉",   "苍井",   "加藤",   "浅野",   "冢本",
      "筱原",   "白川",   "村川",   "矢田",   "三浦",   "入江",   "管谷",   "小仓",   "水岛",   "大政",   "上原",
      "蛯原",   "津川",   "阵内",   "内山",   "江角",   "柳叶",   "西田",   "常盘",   "树木",   "高冈",   "泽口",
      "南野",   "田口",   "相田",   "相马",   "押尾",   "佐佐木", "秋山",   "北川",   "松坂",   "高仓",   "三船",
      "栗原",   "松雪",   "横山",   "武田",   "岩佐",   "丹波",   "行定",   "渡部",   "本木",   "桃井",   "储形",
      "乙羽",   "大冢",   "泽村",   "中越",   "夏川",   "森田",   "三宅",   "坂本",   "华原",   "细川",   "小林",
      "渥美",   "泽田",   "北野",   "黑川",   "小室",   "寺尾",   "今村",   "小津",   "深作",   "大岛",   "玉置",
      "田所",   "野兽",   "筱田",   "寺山",   "若松",   "黑泽",   "沟口",   "押井",   "岩井",   "谷村",   "宇津",
      "西村",   "矢泽",   "稻山",   "吉武",   "八尾",   "古尾谷", "贯地谷", "不破",   "若月",   "高村",   "伊佐",
      "牛岛",   "杉山",   "神木",   "松川",   "要",     "堺",     "本乡",   "水川",   "释由",   "石原",   "藤木",
      "平山",   "笕利",   "饭田",   "饭岛",   "堀北",   "广濑",   "藤井",   "片濑",   "谷原",   "金子",   "江户川",
      "福田",   "津岛",   "横沟",   "佐野",   "丸山",   "平井",   "柳井",   "有坂",   "水桥",   "铜谷",   "草野",
      "内博",   "南泽",   "樱庭",   "新垣",   "末永",   "伊崎",   "森村",   "高木",   "川端",   "沟端",   "横光",
      "芥川",   "矢井田", "藤田",   "森山",   "持田",   "一青",   "松尾",   "尾崎",   "小川",   "大江",   "三岛",
      "清少",   "夏目",   "清水",   "爱内",   "伴都",   "黑石",   "古谷",   "松浦",   "清浦",   "后藤",   "远藤",
      "增田",   "小山",   "满",     "野间",   "村上",   "森",     "三枝",   "竹井",   "坂井",   "新居",   "石川",
      "藤本",   "大仓",   "安部",   "池田",   "岸本",   "岩田",   "北原",   "宇德",   "上木",   "近江",   "水树",
      "小出",   "冈崎",   "加护",   "玉木",   "奥井",   "中原",   "植田",   "植草",   "东山",   "梶浦",   "绀野",
      "原田",   "原纱",   "金田",   "锦织",   "能登",   "牧野",   "堀江",   "石松",   "堀内",   "广桥",   "池泽",
      "南里",   "千叶",   "小西",   "近藤",   "三木",   "折笠",   "河原木", "神田",   "野中",   "野岛",   "川澄",
      "种村",   "桑岛",   "宫小路", "福井",   "丰崎",   "藤堂",   "西门",   "花泽",   "桧山",   "新谷",   "高泽见",
      "大谷",   "久川",   "早见",   "纪野",   "茅原",   "中森",   "大原",   "神谷",   "藤村",   "户松",   "阪口",
      "桑谷",   "小林",   "小野",   "上杉",   "源",     "饭冢",   "菊地",   "生天目", "名冢",   "武内",   "新井",
      "横手",   "越智",   "松谷",   "岭",     "樱内",   "齐藤",   "斋藤",   "太田",   "木下",   "福永",   "千野",
      "鸠山",   "渡边",   "菊池",   "美部浓", "末弘",   "平山",   "石桥",   "大久保", "秋月",   "竹内",   "武见",
      "松冈",   "岸",     "犬神",   "金田一", "竹下",   "内藤",   "柏原",   "泉谷",   "大泉",   "森高",   "森下",
      "牛尾",   "安西",   "正田",   "小和田", "黑田",   "森嘉",   "松崎",   "森永",   "加纳",   "野田",   "荒船",
      "近卫",   "细川护", "千",     "江崎",   "叶山",   "濑名",   "龟山",   "杉尾",   "臼井",   "久保田", "奥泽",
      "小石川", "冰室",   "朝仓",   "杉崎",   "星野",   "矢吹",   "真壁",   "生野",   "沟口",   "冲岛",   "町田",
      "田村",   "西川",   "小泽",   "池内",   "大淹",   "梅田",   "山崎",   "北田",   "小岩井", "片桐",   "内野",
      "水原",   "纯名",   "黑崎",   "森口",   "吉本",   "井筒",   "筒井",   "井之上", "长岭",   "浅见",   "野村",
      "品川",   "生濑",   "黑谷",   "游川",   "八木",   "土井",   "难波",   "片山",   "北井",   "别所",   "五代",
      "田渊",   "小椋",   "高丸",   "市村",   "长冢",   "秋吉",   "吹越",   "日向志", "藏原",   "长井",   "杉村",
      "奥贯",   "望月",   "井田",   "桥爪",   "神尾",   "道明寺", "美作",   "三条",   "大河原", "青池",   "日向",
      "中岛",   "重村",   "堀口",   "楠田",   "周防",   "宅间",   "小牧",   "重冈",   "星谷",   "佐伯",   "江黑",
      "坂上",   "笹峰",   "浅井",   "利根川", "山野",   "宫下",   "赤井",   "家富",   "飞松",   "樱田",   "山室",
      "水黑",   "彩田",   "大卫",   "栗卷",   "佐田",   "石野",   "富浦",   "加贺",   "坪井",   "三城",   "武藤",
      "佐竹",   "织部",   "鹤见",   "水月",   "桥田",   "田岛",   "岩本",   "西浦",   "叶野",   "泷村",   "日比",
      "野弥",   "小柳",   "北岛",   "宫林",   "胜亦",   "大森",   "美山",   "大杉",   "中江",   "平野",   "堂岛",
      "大泽",   "田山"],
    "_日语名":
     ["鮎美",   "真纪",   "美沙",   "翔子",   "里奈",   "凉",     "里代",   "千春",   "智沙",   "直子",   "友美",
      "七恵",   "丽",     "里奈",   "真白",   "美砂",   "直子",   "纪子",   "希",     "梨香",   "工美",   "琴美",
      "未央",   "佐和子", "贵子",   "裕子",   "夏実",   "美恵子", "峰子",   "真子",   "奈绪美", "顺子",   "里奈",
      "千裕",   "香织",   "加穂里", "淳子",   "瞳",     "実岭",   "芽衣",   "奈未",   "沙树",   "裕子",   "丽子",
      "里奈",   "有未",   "由贵",   "久美子", "明美",   "恵利香", "加奈子", "留美",   "优子",   "典予",   "夏実",
      "恵津子", "一子",   "加奈子", "弥代",   "奈々子", "亜美",   "奈美",   "麻里",   "芳子",   "纪香",   "恭子",
      "晴美",   "絵里",   "一恵",   "有美子", "晶",     "美穂",   "芳香",   "纱菜",   "理沙",   "理恵子", "美智子",
      "恵",     "舞",     "美奈子", "朱里",   "麻矢",   "美帆子", "未来",   "千晶",   "史奈",   "久美子", "志乃",
      "香子",   "映莉子", "奈美",   "茜",     "桃子",   "直美",   "美纪",   "美贵",   "芳美",   "未来",   "絵美",
      "玲亜",   "朋美",   "菜穂子", "加奈子", "茧子",   "由香",   "真梨",   "绫",     "美保",   "美纪",   "凉子",
      "树里",   "理沙",   "美佳",   "真由美", "揺",     "香织",   "庆",     "真里",   "直美",   "未奈",   "华英",
      "茜",     "薫",     "结花",   "夕纪",   "直子",   "五月",   "五月",   "真弓",   "清夏",   "花衣",   "恵理子",
      "晶子",   "美沙",   "瞳",     "千鹤",   "絵里子", "友香",   "朱美",   "理恵",   "奈绪",   "律子",   "雅美",
      "翠",     "晴美",   "麻美",   "恵",     "直美",   "理絵",   "梨花",   "贵子",   "阳子",   "都记子", "智子",
      "里穂",   "丽矢",   "絵理香", "美纪",   "亮子",   "由贵子", "裕子",   "由美",   "麻衣",   "尚子",   "美和",
      "毬絵",   "里沙",   "朋美",   "幸子",   "洋子",   "文子",   "志乃",   "美穂",   "瑞穂",   "贵子",   "美奈子",
      "贵子",   "纪子",   "仁美",   "萌",     "理沙",   "真由美", "奈保子", "麻衣子", "千里",   "理沙",   "恵美",
      "佳子",   "亜希子", "爱",     "范子",   "和津美", "雏妃",   "花衣",   "典子",   "彩水",   "爱美",   "万理江",
      "沙也果", "佳乃",   "优",     "晶子",   "香",     "まゆ",   "由香利", "恵理",   "美幸",   "里穂",   "晶",
      "唯",     "绫乃",   "绢香",   "令子",   "有子",   "雪乃",   "仁见",   "亜弥",   "香织",   "飞香",   "智子",
      "可奈子", "玲子",   "里美",   "恭香",   "絵美",   "佐智子", "千春",   "春奈",   "丽奈",   "比吕",   "絵真",
      "先辈",   "浩二",   "莲",     "飒太",   "大翔",   "大和",   "翔太",   "凑",     "悠人",   "大辉",   "苍空",
      "龙生",   "阳",     "阳斗",   "陆",     "陆斗",   "飒真",   "瑛太",   "悠真",   "飒汰",   "树",     "苍大",
      "悠斗",   "阳太",   "一飒",   "结人",   "虎太郎", "太阳",   "隼人",   "遥斗",   "阳向",   "飒",     "海翔",
      "优心",   "阳翔",   "龙之介", "翔",     "辉",     "结斗",   "春辉",   "晴",     "苍",     "苍介",   "智也",
      "直辉",   "优希",   "悠翔",   "阳大",   "翼",     "琉生",   "飒介",   "绚斗",   "瑛斗",   "干太",   "空",
      "春翔",   "晴琉",   "圣",     "奏太",   "苍真",   "苍天",   "大智",   "斗真",   "枫",     "佑真",   "优",
      "勇斗",   "悠",     "雄大",   "凉太",   "煌",     "煌大",   "飒斗",   "葵",     "一辉",   "一真",   "瑛大",
      "咏太",   "海音",   "岳",     "庆太",   "结翔",   "健",     "光希",   "航平",   "朔也",   "春斗",   "瞬",
      "匠",     "渉",     "丈",     "奏音",   "苍汰",   "太一",   "泰生",   "大空",   "大悟",   "大晟",   "拓海",
      "拓実",   "暖",     "直树",   "哲平",   "碧人",   "优斗",   "勇翔",   "悠雅",   "悠介",   "悠希",   "悠月",
      "悠马",   "阳人",   "璃空",   "琉雅",   "琉斗",   "龙希",   "龙成",   "龙星",   "亮太",   "莲斗",   "和真",
      "翔大",   "飒一",   "飒人"]
}"""

tarot = r"""{
  "_塔罗牌":["【0】愚者",    "【1】魔术师", "【2】女祭司", "【3】女皇",  "【4】皇帝",      "【5】教皇",
            "【6】恋人",    "【7】战车",   "【8】力量",   "【9】隐者",  "【10】命运之轮", "【11】正义",
            "【12】倒吊人", "【13】死神",  "【14】节制",  "【15】恶魔", "【16】塔",       "【17】星星",
            "【18】月亮",   "【19】太阳",  "【20】审判",  "【21】世界"],
  "_正逆":["正位", "逆位"],
  "塔罗牌占卜":["随机牌阵: {_塔罗牌阵}"],
  "_塔罗牌阵":
     ["单张塔罗牌\n{单张塔罗牌}",
      "圣三角牌阵{圣三角牌阵}",
      "四要素牌阵{四要素牌阵}",
      "小十字牌阵{小十字牌阵}",
      "六芒星牌阵{六芒星牌阵}",
      "凯尔特十字牌阵{凯尔特十字牌阵}"],
  "单张塔罗牌":
    ["【0】愚者（The Fool，0)正位:\n憧憬自然的地方、毫无目的地前行、喜欢尝试挑战新鲜事物、四处流浪。美好的梦想。",
    "【0】愚者（The Fool，0)逆位:\n冒险的行动，追求可能性，重视梦想，无视物质的损失，离开家园，过于信赖别人，为出外旅行而烦恼。心情空虚、轻率的恋情、无法长久持续的融洽感、不安的爱情的旅程、对婚姻感到束缚、彼此忽冷忽热、不顾众人反对坠入爱河、为恋人的负心所伤、感情不专一。",
    "【1】魔术师（The Magician，I)正位:\n事情的开始，行动的改变，熟练的技术及技巧，贯彻我的意志，运用自然的力量来达到野心。",
    "【1】魔术师（The Magician，I)逆位:\n意志力薄弱，起头难，走入错误的方向，知识不足，被骗和失败。",
    "【2】女祭司（The High Priestess，II)正位:\n开发出内在的神秘潜力，前途将有所变化的预言，深刻地思考，敏锐的洞察力，准确的直觉。",
    "【2】女祭司（The High Priestess，II)逆位:\n过于洁癖，无知，贪心，目光短浅，自尊心过高，偏差的判断，有勇无谋，自命不凡。",
    "【3】女皇（The Empress，III)正位:\n幸福，成功，收获，无忧无虑，圆满的家庭生活，良好的环境，美貌，艺术，与大自然接触，愉快的旅行，休闲。",
    "【3】女皇（The Empress，III)逆位:\n不活泼，缺乏上进心，散漫的生活习惯，无法解决的事情，不能看到成果，担于享乐，环境险恶，与家人发生纠纷。",
    "【4】皇帝（The Emperor，IV)正位:\n光荣，权力，胜利，握有领导权，坚强的意志，达成目标，父亲的责任，精神上的孤单。",
    "【4】皇帝（The Emperor，IV)逆位:\n幼稚，无力，独裁，撒娇任性，平凡，没有自信，行动力不足，意志薄弱，被支配。",
    "【5】教皇（The Hierophant，or the Pope，V)正位:\n援助，同情，宽宏大量，可信任的人给予的劝告，良好的商量对象，得到精神上的满足，遵守规则，志愿者。",
    "【5】教皇（The Hierophant，or the Pope，V)逆位:\n错误的讯息，恶意的规劝，上当，援助被中断，愿望无法达成，被人利用，被放弃。",
    "【6】恋人（The Lovers，VI)正位:\n撮合，爱情，流行，兴趣，充满希望的未来，魅力，增加朋友。",
    "【6】恋人（The Lovers，VI)逆位:\n禁不起诱惑，纵欲过度，反覆无常，友情变淡，厌倦，争吵，华丽的打扮，优柔寡断。",
    "【7】战车（The Chariot，VII)正位:\n努力而获得成功，胜利，克服障碍，行动力，自立，尝试，自我主张，年轻男子，交通工具，旅行运大吉。",
    "【7】战车（The Chariot，VII)逆位:\n争论失败，发生纠纷，阻滞，违返规则，诉诸暴力，顽固的男子，突然的失败，不良少年，挫折和自私自利。",
    "【8】力量（Strength，VIII）正位:\n大胆的行动，有勇气的决断，新发展，大转机，异动，以意志力战胜困难，健壮的女人。",
    "【8】力量（Strength，VIII）逆位:\n胆小，输给强者，经不起诱惑，屈服在权威与常识之下，没有实践便告放弃，虚荣，懦弱，没有耐性。",
    "【9】隐者（The Hermit，IX)正位:\n隐藏的事实，个别的行动，倾听他人的意见，享受孤独，有益的警戒，年长者，避开危险，祖父，乡间生活。",
    "【9】隐者（The Hermit，IX)逆位:\n憎恨孤独，自卑，担心，幼稚思想，过于慎重导致失败，偏差，不宜旅行。",
    "【10】命运之轮（The Wheel of Fortune，X)正位:\n关键性的事件，有新的机会，因的潮流，环境的变化，幸运的开端，状况好转，问题解决，幸运之神降临。",
    "【10】命运之轮（The Wheel of Fortune，X)逆位:\n连续的不幸，挫折，计划泡汤，障碍，无法修正方向，往坏处发展，恶性循环，中断。",
    "【11】正义（Justice，XI）正位:\n公正、中立、诚实、心胸坦荡、表里如一、身兼二职、追求合理化、协调者、与法律有关、光明正大的交往、感情和睦。",
    "【11】正义（Justice，XI）逆位:\n失衡、偏见、纷扰、诉讼、独断专行、问心有愧、无法两全、表里不一、男女性格不合、情感波折、无视社会道德的恋情。",
    "【12】倒吊人（The Hanged Man，XII)正位:\n接受考验、行动受限、牺牲、不畏艰辛、不受利诱、有失必有得、吸取经验教训、浴火重生、广泛学习、奉献的爱。",
    "【12】倒吊人（The Hanged Man，XII)逆位:\n无谓的牺牲、骨折、厄运、不够努力、处于劣势、任性、利己主义者、缺乏耐心、受惩罚、逃避爱情、没有结果的恋情。",
    "【13】死神（Death，XIII)正位:\n失败、接近毁灭、生病、失业、维持停滞状态、持续的损害、交易停止、枯燥的生活、别离、重新开始、双方有很深的鸿沟、恋情终止。",
    "【13】死神（Death，XIII)逆位:\n抱有一线希望、起死回生、回心转意、摆脱低迷状态、挽回名誉、身体康复、突然改变计划、逃避现实、斩断情丝、与旧情人相逢。",
    "【14】节制（Temperance，XIV)正位:\n单纯、调整、平顺、互惠互利、好感转为爱意、纯爱、深爱。",
    "【14】节制（Temperance，XIV)逆位:\n消耗、下降、疲劳、损失、不安、不融洽、爱情的配合度不佳。",
    "【15】恶魔（The Devil ，XV)正位:\n被束缚、堕落、生病、恶意、屈服、欲望的俘虏、不可抗拒的诱惑、颓废的生活、举债度日、不可告人的秘密、私密恋情。",
    "【15】恶魔（The Devil ，XV)逆位:\n逃离拘束、解除困扰、治愈病痛、告别过去、暂停、别离、拒绝诱惑、舍弃私欲、别离时刻、爱恨交加的恋情。",
    "【16】塔（The Tower，XVI)正位:\n破产、逆境、被开除、急病、致命的打击、巨大的变动、受牵连、信念崩溃、玩火自焚、纷扰不断、突然分离，破灭的爱。",
    "【16】塔（The Tower，XVI)逆位:\n困境、内讧、紧迫的状态、状况不佳、趋于稳定、骄傲自大将付出代价、背水一战、分离的预感、爱情危机。",
    "【17】星星（The Star，XVII)正位:\n前途光明、充满希望、想象力、创造力、幻想、满足愿望、水准提高、理想的对象、美好的恋情。",
    "【17】星星（The Star，XVII)逆位:\n挫折、失望、好高骛远、异想天开、仓皇失措、事与愿违、工作不顺心、情况悲观、秘密恋情、缺少爱的生活。",
    "【18】月亮（The Moon，XVIII)正位:\n不安、迷惑、动摇、谎言、欺骗、鬼迷心窍、动荡的爱、三角关系。",
    "【18】月亮（The Moon，XVIII)逆位:\n逃脱骗局、解除误会、状况好转、预知危险、等待、正视爱情的裂缝。",
    "【19】太阳（The Sun，XIX)正位:\n活跃、丰富的生命力、充满生机、精力充沛、工作顺利、贵人相助、幸福的婚姻、健康的交际。",
    "【19】太阳（The Sun，XIX)逆位:\n消沉、体力不佳、缺乏连续性、意气消沉、生活不安、人际关系不好、感情波动、离婚。",
    "【20】审判（Judgement，XX)正位:\n复活的喜悦、康复、坦白、好消息、好运气、初露锋芒、复苏的爱、重逢、爱的奇迹。",
    "【20】审判（Judgement，XX)逆位:\n一蹶不振、幻灭、隐瞒、坏消息、无法决定、缺少目标、没有进展、消除、恋恋不舍。",
    "【21】世界（The World，XXI)正位:\n完成、成功、完美无缺、连续不断、精神亢奋、拥有毕生奋斗的目标、完成使命、幸运降临、快乐的结束、模范情侣。",
    "【21】世界（The World，XXI)逆位:\n未完成、失败、准备不足、盲目接受、一时不顺利、半途而废、精神颓废、饱和状态、合谋、态度不够融洽、感情受挫。"],
  "圣三角牌阵": ["\n过去的经验: {_塔罗牌} {%_正逆}\n问题的现状: {_塔罗牌} {%_正逆}\n将来的预测: {_塔罗牌} {%_正逆}"],
  "四要素牌阵":
    ["\n火（行动力）: {_塔罗牌} {%_正逆}\n水（情感）: {_塔罗牌} {%_正逆}\n土（现实）: {_塔罗牌} {%_正逆}\n风（思想）: {_塔罗牌} {%_正逆}"],
  "小十字牌阵":
    ["\n过去: {_塔罗牌} {%_正逆}\n现在(左): {_塔罗牌} {%_正逆}\n现在(右): {_塔罗牌} {%_正逆}\n未来: {_塔罗牌} {%_正逆}"],
  "六芒星牌阵":
    ["\n起因: {_塔罗牌} {%_正逆}\n现状: {_塔罗牌} {%_正逆}\n未来: {_塔罗牌} {%_正逆}\n对策: {_塔罗牌} {%_正逆}\n周遭: {_塔罗牌} {%_正逆}\n态度: {_塔罗牌} {%_正逆}\n结果: {_塔罗牌} {%_正逆}"],
  "凯尔特十字牌阵":
    ["\n问题现状: {_塔罗牌} {%_正逆}\n障碍助力: {_塔罗牌} {%_正逆}\n理想状况: {_塔罗牌} {%_正逆}\n基础条件: {_塔罗牌} {%_正逆}\n过去状况: {_塔罗牌} {%_正逆}\n未来发展: {_塔罗牌} {%_正逆}\n自身现状: {_塔罗牌} {%_正逆}\n周围环境: {_塔罗牌} {%_正逆}\n希望恐惧: {_塔罗牌} {%_正逆}\n最终结果: {_塔罗牌} {%_正逆}"]
}"""
