# Generated by Django 2.2.8 on 2019-12-10 04:21

from django.conf import settings
import django.contrib.postgres.fields.jsonb
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import pylabber.utils
import research.models.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Subject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id_number', pylabber.utils.CharNullField(blank=True, max_length=64, null=True, unique=True, validators=[django.core.validators.RegexValidator('^\\d+$', code='invalid_number', message='Digits only!')])),
                ('first_name', models.CharField(blank=True, max_length=64, null=True)),
                ('last_name', models.CharField(blank=True, max_length=64, null=True)),
                ('date_of_birth', models.DateField(blank=True, null=True, validators=[research.models.validators.not_future], verbose_name='Date of Birth')),
                ('dominant_hand', models.CharField(blank=True, choices=[('R', 'Right'), ('L', 'Left'), ('A', 'Ambidextrous')], max_length=5, null=True)),
                ('sex', models.CharField(blank=True, choices=[('M', 'Male'), ('F', 'Female'), ('U', 'Other')], max_length=6, null=True)),
                ('gender', models.CharField(blank=True, choices=[('CIS', 'Cisgender'), ('TRANS', 'Transgender'), ('OTHER', 'Other')], max_length=5, null=True)),
                ('custom_attributes', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict)),
            ],
            options={
                'ordering': ('-modified', '-created'),
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Study',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('image', models.ImageField(blank=True, null=True, upload_to='images/studies')),
                ('collaborators', models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL)),
                ('subjects', models.ManyToManyField(blank=True, to='research.Subject')),
            ],
            options={
                'verbose_name_plural': 'Studies',
            },
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='description')),
                ('study', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='research.Study')),
            ],
            options={
                'unique_together': {('study', 'title')},
            },
        ),
    ]
