import { Construct } from 'constructs';
export * from './policy';
/**
 * @experimental
 */
export interface AwsExternalDnsOptions {
    /**
     * (experimental) Service Account Name for external-dns.
     *
     * @default - external-dns
     * @experimental
     */
    readonly serviceAccountName?: string;
    /**
     * (experimental) Args for controller.
     *
     * @default - None
     * @experimental
     */
    readonly args?: string[];
    /**
     * (experimental) Namespace for external-dns.
     *
     * @default - default
     * @experimental
     */
    readonly namespace?: string;
    /**
     * (experimental) image for external-dns.
     *
     * @default - k8s.gcr.io/external-dns/external-dns:v0.7.6
     * @experimental
     */
    readonly image?: string;
}
/**
 * (experimental) Generate external-dns config yaml.
 *
 * see https://github.com/kubernetes-sigs/external-dns/blob/master/docs/tutorials/aws.md
 *
 * @experimental
 */
export declare class AwsExternalDns extends Construct {
    /**
     * (experimental) Service Account Name for external-dns.
     *
     * @experimental
     */
    readonly serviceAccountName: string;
    /**
     * (experimental) Kubernetes Deployment Name for external-dns.
     *
     * @experimental
     */
    readonly deploymentName: string;
    /**
     * (experimental) Namespace for external-dns.
     *
     * @default - default
     * @experimental
     */
    readonly namespace: string;
    /**
     * (experimental) image for external-dns.
     *
     * @default - k8s.gcr.io/external-dns/external-dns:v0.7.6
     * @experimental
     */
    readonly image: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, options: AwsExternalDnsOptions);
    private argsFunc;
}
